require("tests/testsuite")

local document = Cmd.ImportODTFile("testdocs/testdoc.odt")

local expected = [[
%% This document automatically generated by WordGrinder 0.8.
\documentclass{article}
\usepackage{xunicode, setspace, xltxtra}
\sloppy
\onehalfspacing
\begin{document}
\title{testdoc.odt}
\author{(no author)}
\maketitle
\section{Heading 1}
This is \textbf{bold }\textit{\textbf{bolditalic }}\textit{\textbf{\underline{bolditalicunderline }}}\textit{\underline{italicunderline }}\underline{underline} }plain

normal text

\begin{enumerate}
\item[\textbullet]{bullet}
\item[\textbullet]{bullet}
\item[\textbullet]{no bullet}
\item[\textbullet]{no bullet}
\item{number}
\item{number}
\item[\textbullet]{nothing}
\item{number}
\item[\textbullet]{bullet}
\end{enumerate}
normal text

\end{document}
]]

DocumentSet:setCurrent("testdoc.odt")
local output = Cmd.ExportToLatexString()
AssertEquals(expected, output)


