% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinical.R
\name{TCGAtumor_purity}
\alias{TCGAtumor_purity}
\title{Filters TCGA barcodes according to purity parameters}
\usage{
TCGAtumor_purity(barcodes, estimate, absolute, lump, ihc, cpe)
}
\arguments{
\item{barcodes}{is a vector of TCGA barcodes}

\item{estimate}{uses gene expression profiles of 141 immune genes and 141 stromal genes}

\item{absolute}{which uses somatic copy-number data (estimations were available for only 11 cancer types)}

\item{lump}{(leukocytes unmethylation for purity), which averages 44 non-methylated immune-specific CpG sites}

\item{ihc}{as estimated by image analysis of haematoxylin and eosin stain slides produced by the Nationwide Childrens Hospital Biospecimen Core Resource}

\item{cpe}{CPE is a derived consensus measurement as the median purity level after normalizing levels from all methods to give them equal means and s.ds}
}
\value{
List with $pure_barcodes attribute as a vector of pure samples and $filtered attribute as filtered samples with no purity info
}
\description{
TCGAtumor_purity Filters TCGA samples using 5 estimates from 5 methods as thresholds.
}
\examples{
dataTableSubt <- TCGAtumor_purity("TCGA-60-2721-01A-01R-0851-07",
                          estimate = 0.6,
                          absolute = 0.6,
                          ihc = 0.8,
                          lump = 0.8,
                          cpe = 0.7)
}
