#
# @BEGIN LICENSE
#
# Psi4: an open-source quantum chemistry software package
#
# Copyright (c) 2007-2019 The Psi4 Developers.
#
# The copyrights for code used from other parties are included in
# the corresponding files.
#
# This file is part of Psi4.
#
# Psi4 is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, version 3.
#
# Psi4 is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License along
# with Psi4; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# @END LICENSE
#

"""
| Database of Ed and Rob's favorite linear acene dimers.
| Geometries from nowhere special, and reference energies undefined.

- **cp**  ``'off'`` || ``'on'``

- **rlxd** ``'off'``

- **subset**

  - ``'small'``
  - ``'large'``
  - ``'FIRST3'`` benzene, napthalene, and anthracene dimers
  - ``'FIRST5'`` benzene - pentacene dimers
  - ``'FIRST10'`` benzene - decacene dimers

"""
import re
import qcdb

# <<< ACENES Database Module >>>
dbse = 'ACENES'

# <<< Database Members >>>
HRXN = ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20']
HRXN_SM = ['1', '2', '3', '4', '5']
HRXN_LG = ['11', '12', '13', '14', '15', '16', '17', '18', '19', '20']
FIRST3  = ['1', '2', '3']
FIRST5  = ['1', '2', '3', '4', '5']
FIRST10 = ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10']

# <<< Chemical Systems Involved >>>
RXNM = {}     # reaction matrix of reagent contributions per reaction
ACTV = {}     # order of active reagents per reaction
ACTV_CP = {}  # order of active reagents per counterpoise-corrected reaction
ACTV_SA = {}  # order of active reagents for non-supramolecular calculations
for rxn in HRXN:

    RXNM[   '%s-%s' % (dbse, rxn)] = {'%s-%s-dimer'      % (dbse, rxn) : +1,
                                      '%s-%s-monoA-CP'   % (dbse, rxn) : -1,
                                      '%s-%s-monoB-CP'   % (dbse, rxn) : -1,
                                      '%s-%s-monoA-unCP' % (dbse, rxn) : -1,
                                      '%s-%s-monoB-unCP' % (dbse, rxn) : -1 }

    ACTV_SA['%s-%s' % (dbse, rxn)] = ['%s-%s-dimer'      % (dbse, rxn) ]

    ACTV_CP['%s-%s' % (dbse, rxn)] = ['%s-%s-dimer'      % (dbse, rxn),
                                      '%s-%s-monoA-CP'   % (dbse, rxn),
                                      '%s-%s-monoB-CP'   % (dbse, rxn) ]

    ACTV[   '%s-%s' % (dbse, rxn)] = ['%s-%s-dimer'      % (dbse, rxn),
                                      '%s-%s-monoA-unCP' % (dbse, rxn),
                                      '%s-%s-monoB-unCP' % (dbse, rxn) ]

# <<< Reference Values [kcal/mol] >>>
BIND = {}
BIND['%s-%s'            % (dbse, '1'                     )] =    0.000
BIND['%s-%s'            % (dbse, '10'                    )] =    0.000
BIND['%s-%s'            % (dbse, '11'                    )] =    0.000
BIND['%s-%s'            % (dbse, '12'                    )] =    0.000
BIND['%s-%s'            % (dbse, '13'                    )] =    0.000
BIND['%s-%s'            % (dbse, '14'                    )] =    0.000
BIND['%s-%s'            % (dbse, '15'                    )] =    0.000
BIND['%s-%s'            % (dbse, '16'                    )] =    0.000
BIND['%s-%s'            % (dbse, '17'                    )] =    0.000
BIND['%s-%s'            % (dbse, '18'                    )] =    0.000
BIND['%s-%s'            % (dbse, '19'                    )] =    0.000
BIND['%s-%s'            % (dbse, '2'                     )] =    0.000
BIND['%s-%s'            % (dbse, '20'                    )] =    0.000
BIND['%s-%s'            % (dbse, '3'                     )] =    0.000
BIND['%s-%s'            % (dbse, '4'                     )] =    0.000
BIND['%s-%s'            % (dbse, '5'                     )] =    0.000
BIND['%s-%s'            % (dbse, '6'                     )] =    0.000
BIND['%s-%s'            % (dbse, '7'                     )] =    0.000
BIND['%s-%s'            % (dbse, '8'                     )] =    0.000
BIND['%s-%s'            % (dbse, '9'                     )] =    0.000

# <<< Comment Lines >>>
TAGL = {}
TAGL['%s-%s'            % (dbse, '1'                     )] = ''
TAGL['%s-%s-dimer'      % (dbse, '1'                     )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '1'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '1'                     )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '1'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '1'                     )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '10'                    )] = ''
TAGL['%s-%s-dimer'      % (dbse, '10'                    )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '10'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '10'                    )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '10'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '10'                    )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '11'                    )] = ''
TAGL['%s-%s-dimer'      % (dbse, '11'                    )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '11'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '11'                    )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '11'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '11'                    )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '12'                    )] = ''
TAGL['%s-%s-dimer'      % (dbse, '12'                    )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '12'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '12'                    )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '12'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '12'                    )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '13'                    )] = ''
TAGL['%s-%s-dimer'      % (dbse, '13'                    )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '13'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '13'                    )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '13'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '13'                    )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '14'                    )] = ''
TAGL['%s-%s-dimer'      % (dbse, '14'                    )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '14'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '14'                    )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '14'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '14'                    )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '15'                    )] = ''
TAGL['%s-%s-dimer'      % (dbse, '15'                    )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '15'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '15'                    )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '15'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '15'                    )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '16'                    )] = ''
TAGL['%s-%s-dimer'      % (dbse, '16'                    )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '16'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '16'                    )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '16'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '16'                    )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '17'                    )] = ''
TAGL['%s-%s-dimer'      % (dbse, '17'                    )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '17'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '17'                    )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '17'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '17'                    )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '18'                    )] = ''
TAGL['%s-%s-dimer'      % (dbse, '18'                    )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '18'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '18'                    )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '18'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '18'                    )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '19'                    )] = ''
TAGL['%s-%s-dimer'      % (dbse, '19'                    )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '19'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '19'                    )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '19'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '19'                    )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '2'                     )] = ''
TAGL['%s-%s-dimer'      % (dbse, '2'                     )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '2'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '2'                     )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '2'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '2'                     )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '20'                    )] = ''
TAGL['%s-%s-dimer'      % (dbse, '20'                    )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '20'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '20'                    )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '20'                    )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '20'                    )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '3'                     )] = ''
TAGL['%s-%s-dimer'      % (dbse, '3'                     )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '3'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '3'                     )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '3'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '3'                     )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '4'                     )] = ''
TAGL['%s-%s-dimer'      % (dbse, '4'                     )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '4'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '4'                     )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '4'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '4'                     )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '5'                     )] = ''
TAGL['%s-%s-dimer'      % (dbse, '5'                     )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '5'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '5'                     )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '5'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '5'                     )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '6'                     )] = ''
TAGL['%s-%s-dimer'      % (dbse, '6'                     )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '6'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '6'                     )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '6'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '6'                     )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '7'                     )] = ''
TAGL['%s-%s-dimer'      % (dbse, '7'                     )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '7'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '7'                     )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '7'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '7'                     )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '8'                     )] = ''
TAGL['%s-%s-dimer'      % (dbse, '8'                     )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '8'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '8'                     )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '8'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '8'                     )] = 'Monomer B from '
TAGL['%s-%s'            % (dbse, '9'                     )] = ''
TAGL['%s-%s-dimer'      % (dbse, '9'                     )] = 'Dimer from '
TAGL['%s-%s-monoA-CP'   % (dbse, '9'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-CP'   % (dbse, '9'                     )] = 'Monomer B from '
TAGL['%s-%s-monoA-unCP' % (dbse, '9'                     )] = 'Monomer A from '
TAGL['%s-%s-monoB-unCP' % (dbse, '9'                     )] = 'Monomer B from '

# <<< Geometry Specification Strings >>>
GEOS = {}

GEOS['%s-%s-dimer' % (dbse, '1')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H       -1.23575000     2.14038200     0.00000000
H        1.23575000     2.14038200     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        0.46425000     2.14038200     3.50000000
H        2.93575000     2.14038200     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '10')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
C        1.39150000    12.05074000     0.00000000
C       -1.39150000    12.05074000     0.00000000
C       -0.69575000    13.25581400     0.00000000
C        0.69575000    13.25581400     0.00000000
C        1.39150000    14.46088800     0.00000000
C       -1.39150000    14.46088800     0.00000000
C       -0.69575000    15.66596200     0.00000000
C        0.69575000    15.66596200     0.00000000
C        1.39150000    16.87103600     0.00000000
C       -1.39150000    16.87103600     0.00000000
C       -0.69575000    18.07611000     0.00000000
C        0.69575000    18.07611000     0.00000000
C        1.39150000    19.28118400     0.00000000
C       -1.39150000    19.28118400     0.00000000
C       -0.69575000    20.48625800     0.00000000
C        0.69575000    20.48625800     0.00000000
C        1.39150000    21.69133200     0.00000000
C       -1.39150000    21.69133200     0.00000000
C       -0.69575000    22.89640600     0.00000000
C        0.69575000    22.89640600     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H        2.47150000    12.05074000     0.00000000
H       -2.47150000    12.05074000     0.00000000
H        2.47150000    14.46088800     0.00000000
H       -2.47150000    14.46088800     0.00000000
H        2.47150000    16.87103600     0.00000000
H       -2.47150000    16.87103600     0.00000000
H        2.47150000    19.28118400     0.00000000
H       -2.47150000    19.28118400     0.00000000
H        2.47150000    21.69133200     0.00000000
H       -2.47150000    21.69133200     0.00000000
H       -1.23575000    23.83171400     0.00000000
H        1.23575000    23.83171400     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
C        3.09150000    12.05074000     3.50000000
C        0.30850000    12.05074000     3.50000000
C        1.00425000    13.25581400     3.50000000
C        2.39575000    13.25581400     3.50000000
C        3.09150000    14.46088800     3.50000000
C        0.30850000    14.46088800     3.50000000
C        1.00425000    15.66596200     3.50000000
C        2.39575000    15.66596200     3.50000000
C        3.09150000    16.87103600     3.50000000
C        0.30850000    16.87103600     3.50000000
C        1.00425000    18.07611000     3.50000000
C        2.39575000    18.07611000     3.50000000
C        3.09150000    19.28118400     3.50000000
C        0.30850000    19.28118400     3.50000000
C        1.00425000    20.48625800     3.50000000
C        2.39575000    20.48625800     3.50000000
C        3.09150000    21.69133200     3.50000000
C        0.30850000    21.69133200     3.50000000
C        1.00425000    22.89640600     3.50000000
C        2.39575000    22.89640600     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        4.17150000    12.05074000     3.50000000
H       -0.77150000    12.05074000     3.50000000
H        4.17150000    14.46088800     3.50000000
H       -0.77150000    14.46088800     3.50000000
H        4.17150000    16.87103600     3.50000000
H       -0.77150000    16.87103600     3.50000000
H        4.17150000    19.28118400     3.50000000
H       -0.77150000    19.28118400     3.50000000
H        4.17150000    21.69133200     3.50000000
H       -0.77150000    21.69133200     3.50000000
H        0.46425000    23.83171400     3.50000000
H        2.93575000    23.83171400     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '11')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
C        1.39150000    12.05074000     0.00000000
C       -1.39150000    12.05074000     0.00000000
C       -0.69575000    13.25581400     0.00000000
C        0.69575000    13.25581400     0.00000000
C        1.39150000    14.46088800     0.00000000
C       -1.39150000    14.46088800     0.00000000
C       -0.69575000    15.66596200     0.00000000
C        0.69575000    15.66596200     0.00000000
C        1.39150000    16.87103600     0.00000000
C       -1.39150000    16.87103600     0.00000000
C       -0.69575000    18.07611000     0.00000000
C        0.69575000    18.07611000     0.00000000
C        1.39150000    19.28118400     0.00000000
C       -1.39150000    19.28118400     0.00000000
C       -0.69575000    20.48625800     0.00000000
C        0.69575000    20.48625800     0.00000000
C        1.39150000    21.69133200     0.00000000
C       -1.39150000    21.69133200     0.00000000
C       -0.69575000    22.89640600     0.00000000
C        0.69575000    22.89640600     0.00000000
C        1.39150000    24.10148000     0.00000000
C       -1.39150000    24.10148000     0.00000000
C       -0.69575000    25.30655400     0.00000000
C        0.69575000    25.30655400     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H        2.47150000    12.05074000     0.00000000
H       -2.47150000    12.05074000     0.00000000
H        2.47150000    14.46088800     0.00000000
H       -2.47150000    14.46088800     0.00000000
H        2.47150000    16.87103600     0.00000000
H       -2.47150000    16.87103600     0.00000000
H        2.47150000    19.28118400     0.00000000
H       -2.47150000    19.28118400     0.00000000
H        2.47150000    21.69133200     0.00000000
H       -2.47150000    21.69133200     0.00000000
H        2.47150000    24.10148000     0.00000000
H       -2.47150000    24.10148000     0.00000000
H       -1.23575000    26.24186200     0.00000000
H        1.23575000    26.24186200     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
C        3.09150000    12.05074000     3.50000000
C        0.30850000    12.05074000     3.50000000
C        1.00425000    13.25581400     3.50000000
C        2.39575000    13.25581400     3.50000000
C        3.09150000    14.46088800     3.50000000
C        0.30850000    14.46088800     3.50000000
C        1.00425000    15.66596200     3.50000000
C        2.39575000    15.66596200     3.50000000
C        3.09150000    16.87103600     3.50000000
C        0.30850000    16.87103600     3.50000000
C        1.00425000    18.07611000     3.50000000
C        2.39575000    18.07611000     3.50000000
C        3.09150000    19.28118400     3.50000000
C        0.30850000    19.28118400     3.50000000
C        1.00425000    20.48625800     3.50000000
C        2.39575000    20.48625800     3.50000000
C        3.09150000    21.69133200     3.50000000
C        0.30850000    21.69133200     3.50000000
C        1.00425000    22.89640600     3.50000000
C        2.39575000    22.89640600     3.50000000
C        3.09150000    24.10148000     3.50000000
C        0.30850000    24.10148000     3.50000000
C        1.00425000    25.30655400     3.50000000
C        2.39575000    25.30655400     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        4.17150000    12.05074000     3.50000000
H       -0.77150000    12.05074000     3.50000000
H        4.17150000    14.46088800     3.50000000
H       -0.77150000    14.46088800     3.50000000
H        4.17150000    16.87103600     3.50000000
H       -0.77150000    16.87103600     3.50000000
H        4.17150000    19.28118400     3.50000000
H       -0.77150000    19.28118400     3.50000000
H        4.17150000    21.69133200     3.50000000
H       -0.77150000    21.69133200     3.50000000
H        4.17150000    24.10148000     3.50000000
H       -0.77150000    24.10148000     3.50000000
H        0.46425000    26.24186200     3.50000000
H        2.93575000    26.24186200     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '12')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
C        1.39150000    12.05074000     0.00000000
C       -1.39150000    12.05074000     0.00000000
C       -0.69575000    13.25581400     0.00000000
C        0.69575000    13.25581400     0.00000000
C        1.39150000    14.46088800     0.00000000
C       -1.39150000    14.46088800     0.00000000
C       -0.69575000    15.66596200     0.00000000
C        0.69575000    15.66596200     0.00000000
C        1.39150000    16.87103600     0.00000000
C       -1.39150000    16.87103600     0.00000000
C       -0.69575000    18.07611000     0.00000000
C        0.69575000    18.07611000     0.00000000
C        1.39150000    19.28118400     0.00000000
C       -1.39150000    19.28118400     0.00000000
C       -0.69575000    20.48625800     0.00000000
C        0.69575000    20.48625800     0.00000000
C        1.39150000    21.69133200     0.00000000
C       -1.39150000    21.69133200     0.00000000
C       -0.69575000    22.89640600     0.00000000
C        0.69575000    22.89640600     0.00000000
C        1.39150000    24.10148000     0.00000000
C       -1.39150000    24.10148000     0.00000000
C       -0.69575000    25.30655400     0.00000000
C        0.69575000    25.30655400     0.00000000
C        1.39150000    26.51162800     0.00000000
C       -1.39150000    26.51162800     0.00000000
C       -0.69575000    27.71670200     0.00000000
C        0.69575000    27.71670200     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H        2.47150000    12.05074000     0.00000000
H       -2.47150000    12.05074000     0.00000000
H        2.47150000    14.46088800     0.00000000
H       -2.47150000    14.46088800     0.00000000
H        2.47150000    16.87103600     0.00000000
H       -2.47150000    16.87103600     0.00000000
H        2.47150000    19.28118400     0.00000000
H       -2.47150000    19.28118400     0.00000000
H        2.47150000    21.69133200     0.00000000
H       -2.47150000    21.69133200     0.00000000
H        2.47150000    24.10148000     0.00000000
H       -2.47150000    24.10148000     0.00000000
H        2.47150000    26.51162800     0.00000000
H       -2.47150000    26.51162800     0.00000000
H       -1.23575000    28.65201000     0.00000000
H        1.23575000    28.65201000     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
C        3.09150000    12.05074000     3.50000000
C        0.30850000    12.05074000     3.50000000
C        1.00425000    13.25581400     3.50000000
C        2.39575000    13.25581400     3.50000000
C        3.09150000    14.46088800     3.50000000
C        0.30850000    14.46088800     3.50000000
C        1.00425000    15.66596200     3.50000000
C        2.39575000    15.66596200     3.50000000
C        3.09150000    16.87103600     3.50000000
C        0.30850000    16.87103600     3.50000000
C        1.00425000    18.07611000     3.50000000
C        2.39575000    18.07611000     3.50000000
C        3.09150000    19.28118400     3.50000000
C        0.30850000    19.28118400     3.50000000
C        1.00425000    20.48625800     3.50000000
C        2.39575000    20.48625800     3.50000000
C        3.09150000    21.69133200     3.50000000
C        0.30850000    21.69133200     3.50000000
C        1.00425000    22.89640600     3.50000000
C        2.39575000    22.89640600     3.50000000
C        3.09150000    24.10148000     3.50000000
C        0.30850000    24.10148000     3.50000000
C        1.00425000    25.30655400     3.50000000
C        2.39575000    25.30655400     3.50000000
C        3.09150000    26.51162800     3.50000000
C        0.30850000    26.51162800     3.50000000
C        1.00425000    27.71670200     3.50000000
C        2.39575000    27.71670200     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        4.17150000    12.05074000     3.50000000
H       -0.77150000    12.05074000     3.50000000
H        4.17150000    14.46088800     3.50000000
H       -0.77150000    14.46088800     3.50000000
H        4.17150000    16.87103600     3.50000000
H       -0.77150000    16.87103600     3.50000000
H        4.17150000    19.28118400     3.50000000
H       -0.77150000    19.28118400     3.50000000
H        4.17150000    21.69133200     3.50000000
H       -0.77150000    21.69133200     3.50000000
H        4.17150000    24.10148000     3.50000000
H       -0.77150000    24.10148000     3.50000000
H        4.17150000    26.51162800     3.50000000
H       -0.77150000    26.51162800     3.50000000
H        0.46425000    28.65201000     3.50000000
H        2.93575000    28.65201000     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '13')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
C        1.39150000    12.05074000     0.00000000
C       -1.39150000    12.05074000     0.00000000
C       -0.69575000    13.25581400     0.00000000
C        0.69575000    13.25581400     0.00000000
C        1.39150000    14.46088800     0.00000000
C       -1.39150000    14.46088800     0.00000000
C       -0.69575000    15.66596200     0.00000000
C        0.69575000    15.66596200     0.00000000
C        1.39150000    16.87103600     0.00000000
C       -1.39150000    16.87103600     0.00000000
C       -0.69575000    18.07611000     0.00000000
C        0.69575000    18.07611000     0.00000000
C        1.39150000    19.28118400     0.00000000
C       -1.39150000    19.28118400     0.00000000
C       -0.69575000    20.48625800     0.00000000
C        0.69575000    20.48625800     0.00000000
C        1.39150000    21.69133200     0.00000000
C       -1.39150000    21.69133200     0.00000000
C       -0.69575000    22.89640600     0.00000000
C        0.69575000    22.89640600     0.00000000
C        1.39150000    24.10148000     0.00000000
C       -1.39150000    24.10148000     0.00000000
C       -0.69575000    25.30655400     0.00000000
C        0.69575000    25.30655400     0.00000000
C        1.39150000    26.51162800     0.00000000
C       -1.39150000    26.51162800     0.00000000
C       -0.69575000    27.71670200     0.00000000
C        0.69575000    27.71670200     0.00000000
C        1.39150000    28.92177600     0.00000000
C       -1.39150000    28.92177600     0.00000000
C       -0.69575000    30.12685000     0.00000000
C        0.69575000    30.12685000     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H        2.47150000    12.05074000     0.00000000
H       -2.47150000    12.05074000     0.00000000
H        2.47150000    14.46088800     0.00000000
H       -2.47150000    14.46088800     0.00000000
H        2.47150000    16.87103600     0.00000000
H       -2.47150000    16.87103600     0.00000000
H        2.47150000    19.28118400     0.00000000
H       -2.47150000    19.28118400     0.00000000
H        2.47150000    21.69133200     0.00000000
H       -2.47150000    21.69133200     0.00000000
H        2.47150000    24.10148000     0.00000000
H       -2.47150000    24.10148000     0.00000000
H        2.47150000    26.51162800     0.00000000
H       -2.47150000    26.51162800     0.00000000
H        2.47150000    28.92177600     0.00000000
H       -2.47150000    28.92177600     0.00000000
H       -1.23575000    31.06215800     0.00000000
H        1.23575000    31.06215800     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
C        3.09150000    12.05074000     3.50000000
C        0.30850000    12.05074000     3.50000000
C        1.00425000    13.25581400     3.50000000
C        2.39575000    13.25581400     3.50000000
C        3.09150000    14.46088800     3.50000000
C        0.30850000    14.46088800     3.50000000
C        1.00425000    15.66596200     3.50000000
C        2.39575000    15.66596200     3.50000000
C        3.09150000    16.87103600     3.50000000
C        0.30850000    16.87103600     3.50000000
C        1.00425000    18.07611000     3.50000000
C        2.39575000    18.07611000     3.50000000
C        3.09150000    19.28118400     3.50000000
C        0.30850000    19.28118400     3.50000000
C        1.00425000    20.48625800     3.50000000
C        2.39575000    20.48625800     3.50000000
C        3.09150000    21.69133200     3.50000000
C        0.30850000    21.69133200     3.50000000
C        1.00425000    22.89640600     3.50000000
C        2.39575000    22.89640600     3.50000000
C        3.09150000    24.10148000     3.50000000
C        0.30850000    24.10148000     3.50000000
C        1.00425000    25.30655400     3.50000000
C        2.39575000    25.30655400     3.50000000
C        3.09150000    26.51162800     3.50000000
C        0.30850000    26.51162800     3.50000000
C        1.00425000    27.71670200     3.50000000
C        2.39575000    27.71670200     3.50000000
C        3.09150000    28.92177600     3.50000000
C        0.30850000    28.92177600     3.50000000
C        1.00425000    30.12685000     3.50000000
C        2.39575000    30.12685000     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        4.17150000    12.05074000     3.50000000
H       -0.77150000    12.05074000     3.50000000
H        4.17150000    14.46088800     3.50000000
H       -0.77150000    14.46088800     3.50000000
H        4.17150000    16.87103600     3.50000000
H       -0.77150000    16.87103600     3.50000000
H        4.17150000    19.28118400     3.50000000
H       -0.77150000    19.28118400     3.50000000
H        4.17150000    21.69133200     3.50000000
H       -0.77150000    21.69133200     3.50000000
H        4.17150000    24.10148000     3.50000000
H       -0.77150000    24.10148000     3.50000000
H        4.17150000    26.51162800     3.50000000
H       -0.77150000    26.51162800     3.50000000
H        4.17150000    28.92177600     3.50000000
H       -0.77150000    28.92177600     3.50000000
H        0.46425000    31.06215800     3.50000000
H        2.93575000    31.06215800     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '14')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
C        1.39150000    12.05074000     0.00000000
C       -1.39150000    12.05074000     0.00000000
C       -0.69575000    13.25581400     0.00000000
C        0.69575000    13.25581400     0.00000000
C        1.39150000    14.46088800     0.00000000
C       -1.39150000    14.46088800     0.00000000
C       -0.69575000    15.66596200     0.00000000
C        0.69575000    15.66596200     0.00000000
C        1.39150000    16.87103600     0.00000000
C       -1.39150000    16.87103600     0.00000000
C       -0.69575000    18.07611000     0.00000000
C        0.69575000    18.07611000     0.00000000
C        1.39150000    19.28118400     0.00000000
C       -1.39150000    19.28118400     0.00000000
C       -0.69575000    20.48625800     0.00000000
C        0.69575000    20.48625800     0.00000000
C        1.39150000    21.69133200     0.00000000
C       -1.39150000    21.69133200     0.00000000
C       -0.69575000    22.89640600     0.00000000
C        0.69575000    22.89640600     0.00000000
C        1.39150000    24.10148000     0.00000000
C       -1.39150000    24.10148000     0.00000000
C       -0.69575000    25.30655400     0.00000000
C        0.69575000    25.30655400     0.00000000
C        1.39150000    26.51162800     0.00000000
C       -1.39150000    26.51162800     0.00000000
C       -0.69575000    27.71670200     0.00000000
C        0.69575000    27.71670200     0.00000000
C        1.39150000    28.92177600     0.00000000
C       -1.39150000    28.92177600     0.00000000
C       -0.69575000    30.12685000     0.00000000
C        0.69575000    30.12685000     0.00000000
C        1.39150000    31.33192400     0.00000000
C       -1.39150000    31.33192400     0.00000000
C       -0.69575000    32.53699800     0.00000000
C        0.69575000    32.53699800     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H        2.47150000    12.05074000     0.00000000
H       -2.47150000    12.05074000     0.00000000
H        2.47150000    14.46088800     0.00000000
H       -2.47150000    14.46088800     0.00000000
H        2.47150000    16.87103600     0.00000000
H       -2.47150000    16.87103600     0.00000000
H        2.47150000    19.28118400     0.00000000
H       -2.47150000    19.28118400     0.00000000
H        2.47150000    21.69133200     0.00000000
H       -2.47150000    21.69133200     0.00000000
H        2.47150000    24.10148000     0.00000000
H       -2.47150000    24.10148000     0.00000000
H        2.47150000    26.51162800     0.00000000
H       -2.47150000    26.51162800     0.00000000
H        2.47150000    28.92177600     0.00000000
H       -2.47150000    28.92177600     0.00000000
H        2.47150000    31.33192400     0.00000000
H       -2.47150000    31.33192400     0.00000000
H       -1.23575000    33.47230600     0.00000000
H        1.23575000    33.47230600     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
C        3.09150000    12.05074000     3.50000000
C        0.30850000    12.05074000     3.50000000
C        1.00425000    13.25581400     3.50000000
C        2.39575000    13.25581400     3.50000000
C        3.09150000    14.46088800     3.50000000
C        0.30850000    14.46088800     3.50000000
C        1.00425000    15.66596200     3.50000000
C        2.39575000    15.66596200     3.50000000
C        3.09150000    16.87103600     3.50000000
C        0.30850000    16.87103600     3.50000000
C        1.00425000    18.07611000     3.50000000
C        2.39575000    18.07611000     3.50000000
C        3.09150000    19.28118400     3.50000000
C        0.30850000    19.28118400     3.50000000
C        1.00425000    20.48625800     3.50000000
C        2.39575000    20.48625800     3.50000000
C        3.09150000    21.69133200     3.50000000
C        0.30850000    21.69133200     3.50000000
C        1.00425000    22.89640600     3.50000000
C        2.39575000    22.89640600     3.50000000
C        3.09150000    24.10148000     3.50000000
C        0.30850000    24.10148000     3.50000000
C        1.00425000    25.30655400     3.50000000
C        2.39575000    25.30655400     3.50000000
C        3.09150000    26.51162800     3.50000000
C        0.30850000    26.51162800     3.50000000
C        1.00425000    27.71670200     3.50000000
C        2.39575000    27.71670200     3.50000000
C        3.09150000    28.92177600     3.50000000
C        0.30850000    28.92177600     3.50000000
C        1.00425000    30.12685000     3.50000000
C        2.39575000    30.12685000     3.50000000
C        3.09150000    31.33192400     3.50000000
C        0.30850000    31.33192400     3.50000000
C        1.00425000    32.53699800     3.50000000
C        2.39575000    32.53699800     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        4.17150000    12.05074000     3.50000000
H       -0.77150000    12.05074000     3.50000000
H        4.17150000    14.46088800     3.50000000
H       -0.77150000    14.46088800     3.50000000
H        4.17150000    16.87103600     3.50000000
H       -0.77150000    16.87103600     3.50000000
H        4.17150000    19.28118400     3.50000000
H       -0.77150000    19.28118400     3.50000000
H        4.17150000    21.69133200     3.50000000
H       -0.77150000    21.69133200     3.50000000
H        4.17150000    24.10148000     3.50000000
H       -0.77150000    24.10148000     3.50000000
H        4.17150000    26.51162800     3.50000000
H       -0.77150000    26.51162800     3.50000000
H        4.17150000    28.92177600     3.50000000
H       -0.77150000    28.92177600     3.50000000
H        4.17150000    31.33192400     3.50000000
H       -0.77150000    31.33192400     3.50000000
H        0.46425000    33.47230600     3.50000000
H        2.93575000    33.47230600     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '15')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
C        1.39150000    12.05074000     0.00000000
C       -1.39150000    12.05074000     0.00000000
C       -0.69575000    13.25581400     0.00000000
C        0.69575000    13.25581400     0.00000000
C        1.39150000    14.46088800     0.00000000
C       -1.39150000    14.46088800     0.00000000
C       -0.69575000    15.66596200     0.00000000
C        0.69575000    15.66596200     0.00000000
C        1.39150000    16.87103600     0.00000000
C       -1.39150000    16.87103600     0.00000000
C       -0.69575000    18.07611000     0.00000000
C        0.69575000    18.07611000     0.00000000
C        1.39150000    19.28118400     0.00000000
C       -1.39150000    19.28118400     0.00000000
C       -0.69575000    20.48625800     0.00000000
C        0.69575000    20.48625800     0.00000000
C        1.39150000    21.69133200     0.00000000
C       -1.39150000    21.69133200     0.00000000
C       -0.69575000    22.89640600     0.00000000
C        0.69575000    22.89640600     0.00000000
C        1.39150000    24.10148000     0.00000000
C       -1.39150000    24.10148000     0.00000000
C       -0.69575000    25.30655400     0.00000000
C        0.69575000    25.30655400     0.00000000
C        1.39150000    26.51162800     0.00000000
C       -1.39150000    26.51162800     0.00000000
C       -0.69575000    27.71670200     0.00000000
C        0.69575000    27.71670200     0.00000000
C        1.39150000    28.92177600     0.00000000
C       -1.39150000    28.92177600     0.00000000
C       -0.69575000    30.12685000     0.00000000
C        0.69575000    30.12685000     0.00000000
C        1.39150000    31.33192400     0.00000000
C       -1.39150000    31.33192400     0.00000000
C       -0.69575000    32.53699800     0.00000000
C        0.69575000    32.53699800     0.00000000
C        1.39150000    33.74207200     0.00000000
C       -1.39150000    33.74207200     0.00000000
C       -0.69575000    34.94714600     0.00000000
C        0.69575000    34.94714600     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H        2.47150000    12.05074000     0.00000000
H       -2.47150000    12.05074000     0.00000000
H        2.47150000    14.46088800     0.00000000
H       -2.47150000    14.46088800     0.00000000
H        2.47150000    16.87103600     0.00000000
H       -2.47150000    16.87103600     0.00000000
H        2.47150000    19.28118400     0.00000000
H       -2.47150000    19.28118400     0.00000000
H        2.47150000    21.69133200     0.00000000
H       -2.47150000    21.69133200     0.00000000
H        2.47150000    24.10148000     0.00000000
H       -2.47150000    24.10148000     0.00000000
H        2.47150000    26.51162800     0.00000000
H       -2.47150000    26.51162800     0.00000000
H        2.47150000    28.92177600     0.00000000
H       -2.47150000    28.92177600     0.00000000
H        2.47150000    31.33192400     0.00000000
H       -2.47150000    31.33192400     0.00000000
H        2.47150000    33.74207200     0.00000000
H       -2.47150000    33.74207200     0.00000000
H       -1.23575000    35.88245400     0.00000000
H        1.23575000    35.88245400     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
C        3.09150000    12.05074000     3.50000000
C        0.30850000    12.05074000     3.50000000
C        1.00425000    13.25581400     3.50000000
C        2.39575000    13.25581400     3.50000000
C        3.09150000    14.46088800     3.50000000
C        0.30850000    14.46088800     3.50000000
C        1.00425000    15.66596200     3.50000000
C        2.39575000    15.66596200     3.50000000
C        3.09150000    16.87103600     3.50000000
C        0.30850000    16.87103600     3.50000000
C        1.00425000    18.07611000     3.50000000
C        2.39575000    18.07611000     3.50000000
C        3.09150000    19.28118400     3.50000000
C        0.30850000    19.28118400     3.50000000
C        1.00425000    20.48625800     3.50000000
C        2.39575000    20.48625800     3.50000000
C        3.09150000    21.69133200     3.50000000
C        0.30850000    21.69133200     3.50000000
C        1.00425000    22.89640600     3.50000000
C        2.39575000    22.89640600     3.50000000
C        3.09150000    24.10148000     3.50000000
C        0.30850000    24.10148000     3.50000000
C        1.00425000    25.30655400     3.50000000
C        2.39575000    25.30655400     3.50000000
C        3.09150000    26.51162800     3.50000000
C        0.30850000    26.51162800     3.50000000
C        1.00425000    27.71670200     3.50000000
C        2.39575000    27.71670200     3.50000000
C        3.09150000    28.92177600     3.50000000
C        0.30850000    28.92177600     3.50000000
C        1.00425000    30.12685000     3.50000000
C        2.39575000    30.12685000     3.50000000
C        3.09150000    31.33192400     3.50000000
C        0.30850000    31.33192400     3.50000000
C        1.00425000    32.53699800     3.50000000
C        2.39575000    32.53699800     3.50000000
C        3.09150000    33.74207200     3.50000000
C        0.30850000    33.74207200     3.50000000
C        1.00425000    34.94714600     3.50000000
C        2.39575000    34.94714600     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        4.17150000    12.05074000     3.50000000
H       -0.77150000    12.05074000     3.50000000
H        4.17150000    14.46088800     3.50000000
H       -0.77150000    14.46088800     3.50000000
H        4.17150000    16.87103600     3.50000000
H       -0.77150000    16.87103600     3.50000000
H        4.17150000    19.28118400     3.50000000
H       -0.77150000    19.28118400     3.50000000
H        4.17150000    21.69133200     3.50000000
H       -0.77150000    21.69133200     3.50000000
H        4.17150000    24.10148000     3.50000000
H       -0.77150000    24.10148000     3.50000000
H        4.17150000    26.51162800     3.50000000
H       -0.77150000    26.51162800     3.50000000
H        4.17150000    28.92177600     3.50000000
H       -0.77150000    28.92177600     3.50000000
H        4.17150000    31.33192400     3.50000000
H       -0.77150000    31.33192400     3.50000000
H        4.17150000    33.74207200     3.50000000
H       -0.77150000    33.74207200     3.50000000
H        0.46425000    35.88245400     3.50000000
H        2.93575000    35.88245400     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '16')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
C        1.39150000    12.05074000     0.00000000
C       -1.39150000    12.05074000     0.00000000
C       -0.69575000    13.25581400     0.00000000
C        0.69575000    13.25581400     0.00000000
C        1.39150000    14.46088800     0.00000000
C       -1.39150000    14.46088800     0.00000000
C       -0.69575000    15.66596200     0.00000000
C        0.69575000    15.66596200     0.00000000
C        1.39150000    16.87103600     0.00000000
C       -1.39150000    16.87103600     0.00000000
C       -0.69575000    18.07611000     0.00000000
C        0.69575000    18.07611000     0.00000000
C        1.39150000    19.28118400     0.00000000
C       -1.39150000    19.28118400     0.00000000
C       -0.69575000    20.48625800     0.00000000
C        0.69575000    20.48625800     0.00000000
C        1.39150000    21.69133200     0.00000000
C       -1.39150000    21.69133200     0.00000000
C       -0.69575000    22.89640600     0.00000000
C        0.69575000    22.89640600     0.00000000
C        1.39150000    24.10148000     0.00000000
C       -1.39150000    24.10148000     0.00000000
C       -0.69575000    25.30655400     0.00000000
C        0.69575000    25.30655400     0.00000000
C        1.39150000    26.51162800     0.00000000
C       -1.39150000    26.51162800     0.00000000
C       -0.69575000    27.71670200     0.00000000
C        0.69575000    27.71670200     0.00000000
C        1.39150000    28.92177600     0.00000000
C       -1.39150000    28.92177600     0.00000000
C       -0.69575000    30.12685000     0.00000000
C        0.69575000    30.12685000     0.00000000
C        1.39150000    31.33192400     0.00000000
C       -1.39150000    31.33192400     0.00000000
C       -0.69575000    32.53699800     0.00000000
C        0.69575000    32.53699800     0.00000000
C        1.39150000    33.74207200     0.00000000
C       -1.39150000    33.74207200     0.00000000
C       -0.69575000    34.94714600     0.00000000
C        0.69575000    34.94714600     0.00000000
C        1.39150000    36.15222000     0.00000000
C       -1.39150000    36.15222000     0.00000000
C       -0.69575000    37.35729400     0.00000000
C        0.69575000    37.35729400     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H        2.47150000    12.05074000     0.00000000
H       -2.47150000    12.05074000     0.00000000
H        2.47150000    14.46088800     0.00000000
H       -2.47150000    14.46088800     0.00000000
H        2.47150000    16.87103600     0.00000000
H       -2.47150000    16.87103600     0.00000000
H        2.47150000    19.28118400     0.00000000
H       -2.47150000    19.28118400     0.00000000
H        2.47150000    21.69133200     0.00000000
H       -2.47150000    21.69133200     0.00000000
H        2.47150000    24.10148000     0.00000000
H       -2.47150000    24.10148000     0.00000000
H        2.47150000    26.51162800     0.00000000
H       -2.47150000    26.51162800     0.00000000
H        2.47150000    28.92177600     0.00000000
H       -2.47150000    28.92177600     0.00000000
H        2.47150000    31.33192400     0.00000000
H       -2.47150000    31.33192400     0.00000000
H        2.47150000    33.74207200     0.00000000
H       -2.47150000    33.74207200     0.00000000
H        2.47150000    36.15222000     0.00000000
H       -2.47150000    36.15222000     0.00000000
H       -1.23575000    38.29260200     0.00000000
H        1.23575000    38.29260200     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
C        3.09150000    12.05074000     3.50000000
C        0.30850000    12.05074000     3.50000000
C        1.00425000    13.25581400     3.50000000
C        2.39575000    13.25581400     3.50000000
C        3.09150000    14.46088800     3.50000000
C        0.30850000    14.46088800     3.50000000
C        1.00425000    15.66596200     3.50000000
C        2.39575000    15.66596200     3.50000000
C        3.09150000    16.87103600     3.50000000
C        0.30850000    16.87103600     3.50000000
C        1.00425000    18.07611000     3.50000000
C        2.39575000    18.07611000     3.50000000
C        3.09150000    19.28118400     3.50000000
C        0.30850000    19.28118400     3.50000000
C        1.00425000    20.48625800     3.50000000
C        2.39575000    20.48625800     3.50000000
C        3.09150000    21.69133200     3.50000000
C        0.30850000    21.69133200     3.50000000
C        1.00425000    22.89640600     3.50000000
C        2.39575000    22.89640600     3.50000000
C        3.09150000    24.10148000     3.50000000
C        0.30850000    24.10148000     3.50000000
C        1.00425000    25.30655400     3.50000000
C        2.39575000    25.30655400     3.50000000
C        3.09150000    26.51162800     3.50000000
C        0.30850000    26.51162800     3.50000000
C        1.00425000    27.71670200     3.50000000
C        2.39575000    27.71670200     3.50000000
C        3.09150000    28.92177600     3.50000000
C        0.30850000    28.92177600     3.50000000
C        1.00425000    30.12685000     3.50000000
C        2.39575000    30.12685000     3.50000000
C        3.09150000    31.33192400     3.50000000
C        0.30850000    31.33192400     3.50000000
C        1.00425000    32.53699800     3.50000000
C        2.39575000    32.53699800     3.50000000
C        3.09150000    33.74207200     3.50000000
C        0.30850000    33.74207200     3.50000000
C        1.00425000    34.94714600     3.50000000
C        2.39575000    34.94714600     3.50000000
C        3.09150000    36.15222000     3.50000000
C        0.30850000    36.15222000     3.50000000
C        1.00425000    37.35729400     3.50000000
C        2.39575000    37.35729400     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        4.17150000    12.05074000     3.50000000
H       -0.77150000    12.05074000     3.50000000
H        4.17150000    14.46088800     3.50000000
H       -0.77150000    14.46088800     3.50000000
H        4.17150000    16.87103600     3.50000000
H       -0.77150000    16.87103600     3.50000000
H        4.17150000    19.28118400     3.50000000
H       -0.77150000    19.28118400     3.50000000
H        4.17150000    21.69133200     3.50000000
H       -0.77150000    21.69133200     3.50000000
H        4.17150000    24.10148000     3.50000000
H       -0.77150000    24.10148000     3.50000000
H        4.17150000    26.51162800     3.50000000
H       -0.77150000    26.51162800     3.50000000
H        4.17150000    28.92177600     3.50000000
H       -0.77150000    28.92177600     3.50000000
H        4.17150000    31.33192400     3.50000000
H       -0.77150000    31.33192400     3.50000000
H        4.17150000    33.74207200     3.50000000
H       -0.77150000    33.74207200     3.50000000
H        4.17150000    36.15222000     3.50000000
H       -0.77150000    36.15222000     3.50000000
H        0.46425000    38.29260200     3.50000000
H        2.93575000    38.29260200     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '17')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
C        1.39150000    12.05074000     0.00000000
C       -1.39150000    12.05074000     0.00000000
C       -0.69575000    13.25581400     0.00000000
C        0.69575000    13.25581400     0.00000000
C        1.39150000    14.46088800     0.00000000
C       -1.39150000    14.46088800     0.00000000
C       -0.69575000    15.66596200     0.00000000
C        0.69575000    15.66596200     0.00000000
C        1.39150000    16.87103600     0.00000000
C       -1.39150000    16.87103600     0.00000000
C       -0.69575000    18.07611000     0.00000000
C        0.69575000    18.07611000     0.00000000
C        1.39150000    19.28118400     0.00000000
C       -1.39150000    19.28118400     0.00000000
C       -0.69575000    20.48625800     0.00000000
C        0.69575000    20.48625800     0.00000000
C        1.39150000    21.69133200     0.00000000
C       -1.39150000    21.69133200     0.00000000
C       -0.69575000    22.89640600     0.00000000
C        0.69575000    22.89640600     0.00000000
C        1.39150000    24.10148000     0.00000000
C       -1.39150000    24.10148000     0.00000000
C       -0.69575000    25.30655400     0.00000000
C        0.69575000    25.30655400     0.00000000
C        1.39150000    26.51162800     0.00000000
C       -1.39150000    26.51162800     0.00000000
C       -0.69575000    27.71670200     0.00000000
C        0.69575000    27.71670200     0.00000000
C        1.39150000    28.92177600     0.00000000
C       -1.39150000    28.92177600     0.00000000
C       -0.69575000    30.12685000     0.00000000
C        0.69575000    30.12685000     0.00000000
C        1.39150000    31.33192400     0.00000000
C       -1.39150000    31.33192400     0.00000000
C       -0.69575000    32.53699800     0.00000000
C        0.69575000    32.53699800     0.00000000
C        1.39150000    33.74207200     0.00000000
C       -1.39150000    33.74207200     0.00000000
C       -0.69575000    34.94714600     0.00000000
C        0.69575000    34.94714600     0.00000000
C        1.39150000    36.15222000     0.00000000
C       -1.39150000    36.15222000     0.00000000
C       -0.69575000    37.35729400     0.00000000
C        0.69575000    37.35729400     0.00000000
C        1.39150000    38.56236800     0.00000000
C       -1.39150000    38.56236800     0.00000000
C       -0.69575000    39.76744200     0.00000000
C        0.69575000    39.76744200     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H        2.47150000    12.05074000     0.00000000
H       -2.47150000    12.05074000     0.00000000
H        2.47150000    14.46088800     0.00000000
H       -2.47150000    14.46088800     0.00000000
H        2.47150000    16.87103600     0.00000000
H       -2.47150000    16.87103600     0.00000000
H        2.47150000    19.28118400     0.00000000
H       -2.47150000    19.28118400     0.00000000
H        2.47150000    21.69133200     0.00000000
H       -2.47150000    21.69133200     0.00000000
H        2.47150000    24.10148000     0.00000000
H       -2.47150000    24.10148000     0.00000000
H        2.47150000    26.51162800     0.00000000
H       -2.47150000    26.51162800     0.00000000
H        2.47150000    28.92177600     0.00000000
H       -2.47150000    28.92177600     0.00000000
H        2.47150000    31.33192400     0.00000000
H       -2.47150000    31.33192400     0.00000000
H        2.47150000    33.74207200     0.00000000
H       -2.47150000    33.74207200     0.00000000
H        2.47150000    36.15222000     0.00000000
H       -2.47150000    36.15222000     0.00000000
H        2.47150000    38.56236800     0.00000000
H       -2.47150000    38.56236800     0.00000000
H       -1.23575000    40.70275000     0.00000000
H        1.23575000    40.70275000     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
C        3.09150000    12.05074000     3.50000000
C        0.30850000    12.05074000     3.50000000
C        1.00425000    13.25581400     3.50000000
C        2.39575000    13.25581400     3.50000000
C        3.09150000    14.46088800     3.50000000
C        0.30850000    14.46088800     3.50000000
C        1.00425000    15.66596200     3.50000000
C        2.39575000    15.66596200     3.50000000
C        3.09150000    16.87103600     3.50000000
C        0.30850000    16.87103600     3.50000000
C        1.00425000    18.07611000     3.50000000
C        2.39575000    18.07611000     3.50000000
C        3.09150000    19.28118400     3.50000000
C        0.30850000    19.28118400     3.50000000
C        1.00425000    20.48625800     3.50000000
C        2.39575000    20.48625800     3.50000000
C        3.09150000    21.69133200     3.50000000
C        0.30850000    21.69133200     3.50000000
C        1.00425000    22.89640600     3.50000000
C        2.39575000    22.89640600     3.50000000
C        3.09150000    24.10148000     3.50000000
C        0.30850000    24.10148000     3.50000000
C        1.00425000    25.30655400     3.50000000
C        2.39575000    25.30655400     3.50000000
C        3.09150000    26.51162800     3.50000000
C        0.30850000    26.51162800     3.50000000
C        1.00425000    27.71670200     3.50000000
C        2.39575000    27.71670200     3.50000000
C        3.09150000    28.92177600     3.50000000
C        0.30850000    28.92177600     3.50000000
C        1.00425000    30.12685000     3.50000000
C        2.39575000    30.12685000     3.50000000
C        3.09150000    31.33192400     3.50000000
C        0.30850000    31.33192400     3.50000000
C        1.00425000    32.53699800     3.50000000
C        2.39575000    32.53699800     3.50000000
C        3.09150000    33.74207200     3.50000000
C        0.30850000    33.74207200     3.50000000
C        1.00425000    34.94714600     3.50000000
C        2.39575000    34.94714600     3.50000000
C        3.09150000    36.15222000     3.50000000
C        0.30850000    36.15222000     3.50000000
C        1.00425000    37.35729400     3.50000000
C        2.39575000    37.35729400     3.50000000
C        3.09150000    38.56236800     3.50000000
C        0.30850000    38.56236800     3.50000000
C        1.00425000    39.76744200     3.50000000
C        2.39575000    39.76744200     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        4.17150000    12.05074000     3.50000000
H       -0.77150000    12.05074000     3.50000000
H        4.17150000    14.46088800     3.50000000
H       -0.77150000    14.46088800     3.50000000
H        4.17150000    16.87103600     3.50000000
H       -0.77150000    16.87103600     3.50000000
H        4.17150000    19.28118400     3.50000000
H       -0.77150000    19.28118400     3.50000000
H        4.17150000    21.69133200     3.50000000
H       -0.77150000    21.69133200     3.50000000
H        4.17150000    24.10148000     3.50000000
H       -0.77150000    24.10148000     3.50000000
H        4.17150000    26.51162800     3.50000000
H       -0.77150000    26.51162800     3.50000000
H        4.17150000    28.92177600     3.50000000
H       -0.77150000    28.92177600     3.50000000
H        4.17150000    31.33192400     3.50000000
H       -0.77150000    31.33192400     3.50000000
H        4.17150000    33.74207200     3.50000000
H       -0.77150000    33.74207200     3.50000000
H        4.17150000    36.15222000     3.50000000
H       -0.77150000    36.15222000     3.50000000
H        4.17150000    38.56236800     3.50000000
H       -0.77150000    38.56236800     3.50000000
H        0.46425000    40.70275000     3.50000000
H        2.93575000    40.70275000     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '18')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
C        1.39150000    12.05074000     0.00000000
C       -1.39150000    12.05074000     0.00000000
C       -0.69575000    13.25581400     0.00000000
C        0.69575000    13.25581400     0.00000000
C        1.39150000    14.46088800     0.00000000
C       -1.39150000    14.46088800     0.00000000
C       -0.69575000    15.66596200     0.00000000
C        0.69575000    15.66596200     0.00000000
C        1.39150000    16.87103600     0.00000000
C       -1.39150000    16.87103600     0.00000000
C       -0.69575000    18.07611000     0.00000000
C        0.69575000    18.07611000     0.00000000
C        1.39150000    19.28118400     0.00000000
C       -1.39150000    19.28118400     0.00000000
C       -0.69575000    20.48625800     0.00000000
C        0.69575000    20.48625800     0.00000000
C        1.39150000    21.69133200     0.00000000
C       -1.39150000    21.69133200     0.00000000
C       -0.69575000    22.89640600     0.00000000
C        0.69575000    22.89640600     0.00000000
C        1.39150000    24.10148000     0.00000000
C       -1.39150000    24.10148000     0.00000000
C       -0.69575000    25.30655400     0.00000000
C        0.69575000    25.30655400     0.00000000
C        1.39150000    26.51162800     0.00000000
C       -1.39150000    26.51162800     0.00000000
C       -0.69575000    27.71670200     0.00000000
C        0.69575000    27.71670200     0.00000000
C        1.39150000    28.92177600     0.00000000
C       -1.39150000    28.92177600     0.00000000
C       -0.69575000    30.12685000     0.00000000
C        0.69575000    30.12685000     0.00000000
C        1.39150000    31.33192400     0.00000000
C       -1.39150000    31.33192400     0.00000000
C       -0.69575000    32.53699800     0.00000000
C        0.69575000    32.53699800     0.00000000
C        1.39150000    33.74207200     0.00000000
C       -1.39150000    33.74207200     0.00000000
C       -0.69575000    34.94714600     0.00000000
C        0.69575000    34.94714600     0.00000000
C        1.39150000    36.15222000     0.00000000
C       -1.39150000    36.15222000     0.00000000
C       -0.69575000    37.35729400     0.00000000
C        0.69575000    37.35729400     0.00000000
C        1.39150000    38.56236800     0.00000000
C       -1.39150000    38.56236800     0.00000000
C       -0.69575000    39.76744200     0.00000000
C        0.69575000    39.76744200     0.00000000
C        1.39150000    40.97251600     0.00000000
C       -1.39150000    40.97251600     0.00000000
C       -0.69575000    42.17759000     0.00000000
C        0.69575000    42.17759000     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H        2.47150000    12.05074000     0.00000000
H       -2.47150000    12.05074000     0.00000000
H        2.47150000    14.46088800     0.00000000
H       -2.47150000    14.46088800     0.00000000
H        2.47150000    16.87103600     0.00000000
H       -2.47150000    16.87103600     0.00000000
H        2.47150000    19.28118400     0.00000000
H       -2.47150000    19.28118400     0.00000000
H        2.47150000    21.69133200     0.00000000
H       -2.47150000    21.69133200     0.00000000
H        2.47150000    24.10148000     0.00000000
H       -2.47150000    24.10148000     0.00000000
H        2.47150000    26.51162800     0.00000000
H       -2.47150000    26.51162800     0.00000000
H        2.47150000    28.92177600     0.00000000
H       -2.47150000    28.92177600     0.00000000
H        2.47150000    31.33192400     0.00000000
H       -2.47150000    31.33192400     0.00000000
H        2.47150000    33.74207200     0.00000000
H       -2.47150000    33.74207200     0.00000000
H        2.47150000    36.15222000     0.00000000
H       -2.47150000    36.15222000     0.00000000
H        2.47150000    38.56236800     0.00000000
H       -2.47150000    38.56236800     0.00000000
H        2.47150000    40.97251600     0.00000000
H       -2.47150000    40.97251600     0.00000000
H       -1.23575000    43.11289800     0.00000000
H        1.23575000    43.11289800     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
C        3.09150000    12.05074000     3.50000000
C        0.30850000    12.05074000     3.50000000
C        1.00425000    13.25581400     3.50000000
C        2.39575000    13.25581400     3.50000000
C        3.09150000    14.46088800     3.50000000
C        0.30850000    14.46088800     3.50000000
C        1.00425000    15.66596200     3.50000000
C        2.39575000    15.66596200     3.50000000
C        3.09150000    16.87103600     3.50000000
C        0.30850000    16.87103600     3.50000000
C        1.00425000    18.07611000     3.50000000
C        2.39575000    18.07611000     3.50000000
C        3.09150000    19.28118400     3.50000000
C        0.30850000    19.28118400     3.50000000
C        1.00425000    20.48625800     3.50000000
C        2.39575000    20.48625800     3.50000000
C        3.09150000    21.69133200     3.50000000
C        0.30850000    21.69133200     3.50000000
C        1.00425000    22.89640600     3.50000000
C        2.39575000    22.89640600     3.50000000
C        3.09150000    24.10148000     3.50000000
C        0.30850000    24.10148000     3.50000000
C        1.00425000    25.30655400     3.50000000
C        2.39575000    25.30655400     3.50000000
C        3.09150000    26.51162800     3.50000000
C        0.30850000    26.51162800     3.50000000
C        1.00425000    27.71670200     3.50000000
C        2.39575000    27.71670200     3.50000000
C        3.09150000    28.92177600     3.50000000
C        0.30850000    28.92177600     3.50000000
C        1.00425000    30.12685000     3.50000000
C        2.39575000    30.12685000     3.50000000
C        3.09150000    31.33192400     3.50000000
C        0.30850000    31.33192400     3.50000000
C        1.00425000    32.53699800     3.50000000
C        2.39575000    32.53699800     3.50000000
C        3.09150000    33.74207200     3.50000000
C        0.30850000    33.74207200     3.50000000
C        1.00425000    34.94714600     3.50000000
C        2.39575000    34.94714600     3.50000000
C        3.09150000    36.15222000     3.50000000
C        0.30850000    36.15222000     3.50000000
C        1.00425000    37.35729400     3.50000000
C        2.39575000    37.35729400     3.50000000
C        3.09150000    38.56236800     3.50000000
C        0.30850000    38.56236800     3.50000000
C        1.00425000    39.76744200     3.50000000
C        2.39575000    39.76744200     3.50000000
C        3.09150000    40.97251600     3.50000000
C        0.30850000    40.97251600     3.50000000
C        1.00425000    42.17759000     3.50000000
C        2.39575000    42.17759000     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        4.17150000    12.05074000     3.50000000
H       -0.77150000    12.05074000     3.50000000
H        4.17150000    14.46088800     3.50000000
H       -0.77150000    14.46088800     3.50000000
H        4.17150000    16.87103600     3.50000000
H       -0.77150000    16.87103600     3.50000000
H        4.17150000    19.28118400     3.50000000
H       -0.77150000    19.28118400     3.50000000
H        4.17150000    21.69133200     3.50000000
H       -0.77150000    21.69133200     3.50000000
H        4.17150000    24.10148000     3.50000000
H       -0.77150000    24.10148000     3.50000000
H        4.17150000    26.51162800     3.50000000
H       -0.77150000    26.51162800     3.50000000
H        4.17150000    28.92177600     3.50000000
H       -0.77150000    28.92177600     3.50000000
H        4.17150000    31.33192400     3.50000000
H       -0.77150000    31.33192400     3.50000000
H        4.17150000    33.74207200     3.50000000
H       -0.77150000    33.74207200     3.50000000
H        4.17150000    36.15222000     3.50000000
H       -0.77150000    36.15222000     3.50000000
H        4.17150000    38.56236800     3.50000000
H       -0.77150000    38.56236800     3.50000000
H        4.17150000    40.97251600     3.50000000
H       -0.77150000    40.97251600     3.50000000
H        0.46425000    43.11289800     3.50000000
H        2.93575000    43.11289800     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '19')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
C        1.39150000    12.05074000     0.00000000
C       -1.39150000    12.05074000     0.00000000
C       -0.69575000    13.25581400     0.00000000
C        0.69575000    13.25581400     0.00000000
C        1.39150000    14.46088800     0.00000000
C       -1.39150000    14.46088800     0.00000000
C       -0.69575000    15.66596200     0.00000000
C        0.69575000    15.66596200     0.00000000
C        1.39150000    16.87103600     0.00000000
C       -1.39150000    16.87103600     0.00000000
C       -0.69575000    18.07611000     0.00000000
C        0.69575000    18.07611000     0.00000000
C        1.39150000    19.28118400     0.00000000
C       -1.39150000    19.28118400     0.00000000
C       -0.69575000    20.48625800     0.00000000
C        0.69575000    20.48625800     0.00000000
C        1.39150000    21.69133200     0.00000000
C       -1.39150000    21.69133200     0.00000000
C       -0.69575000    22.89640600     0.00000000
C        0.69575000    22.89640600     0.00000000
C        1.39150000    24.10148000     0.00000000
C       -1.39150000    24.10148000     0.00000000
C       -0.69575000    25.30655400     0.00000000
C        0.69575000    25.30655400     0.00000000
C        1.39150000    26.51162800     0.00000000
C       -1.39150000    26.51162800     0.00000000
C       -0.69575000    27.71670200     0.00000000
C        0.69575000    27.71670200     0.00000000
C        1.39150000    28.92177600     0.00000000
C       -1.39150000    28.92177600     0.00000000
C       -0.69575000    30.12685000     0.00000000
C        0.69575000    30.12685000     0.00000000
C        1.39150000    31.33192400     0.00000000
C       -1.39150000    31.33192400     0.00000000
C       -0.69575000    32.53699800     0.00000000
C        0.69575000    32.53699800     0.00000000
C        1.39150000    33.74207200     0.00000000
C       -1.39150000    33.74207200     0.00000000
C       -0.69575000    34.94714600     0.00000000
C        0.69575000    34.94714600     0.00000000
C        1.39150000    36.15222000     0.00000000
C       -1.39150000    36.15222000     0.00000000
C       -0.69575000    37.35729400     0.00000000
C        0.69575000    37.35729400     0.00000000
C        1.39150000    38.56236800     0.00000000
C       -1.39150000    38.56236800     0.00000000
C       -0.69575000    39.76744200     0.00000000
C        0.69575000    39.76744200     0.00000000
C        1.39150000    40.97251600     0.00000000
C       -1.39150000    40.97251600     0.00000000
C       -0.69575000    42.17759000     0.00000000
C        0.69575000    42.17759000     0.00000000
C        1.39150000    43.38266400     0.00000000
C       -1.39150000    43.38266400     0.00000000
C       -0.69575000    44.58773800     0.00000000
C        0.69575000    44.58773800     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H        2.47150000    12.05074000     0.00000000
H       -2.47150000    12.05074000     0.00000000
H        2.47150000    14.46088800     0.00000000
H       -2.47150000    14.46088800     0.00000000
H        2.47150000    16.87103600     0.00000000
H       -2.47150000    16.87103600     0.00000000
H        2.47150000    19.28118400     0.00000000
H       -2.47150000    19.28118400     0.00000000
H        2.47150000    21.69133200     0.00000000
H       -2.47150000    21.69133200     0.00000000
H        2.47150000    24.10148000     0.00000000
H       -2.47150000    24.10148000     0.00000000
H        2.47150000    26.51162800     0.00000000
H       -2.47150000    26.51162800     0.00000000
H        2.47150000    28.92177600     0.00000000
H       -2.47150000    28.92177600     0.00000000
H        2.47150000    31.33192400     0.00000000
H       -2.47150000    31.33192400     0.00000000
H        2.47150000    33.74207200     0.00000000
H       -2.47150000    33.74207200     0.00000000
H        2.47150000    36.15222000     0.00000000
H       -2.47150000    36.15222000     0.00000000
H        2.47150000    38.56236800     0.00000000
H       -2.47150000    38.56236800     0.00000000
H        2.47150000    40.97251600     0.00000000
H       -2.47150000    40.97251600     0.00000000
H        2.47150000    43.38266400     0.00000000
H       -2.47150000    43.38266400     0.00000000
H       -1.23575000    45.52304600     0.00000000
H        1.23575000    45.52304600     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
C        3.09150000    12.05074000     3.50000000
C        0.30850000    12.05074000     3.50000000
C        1.00425000    13.25581400     3.50000000
C        2.39575000    13.25581400     3.50000000
C        3.09150000    14.46088800     3.50000000
C        0.30850000    14.46088800     3.50000000
C        1.00425000    15.66596200     3.50000000
C        2.39575000    15.66596200     3.50000000
C        3.09150000    16.87103600     3.50000000
C        0.30850000    16.87103600     3.50000000
C        1.00425000    18.07611000     3.50000000
C        2.39575000    18.07611000     3.50000000
C        3.09150000    19.28118400     3.50000000
C        0.30850000    19.28118400     3.50000000
C        1.00425000    20.48625800     3.50000000
C        2.39575000    20.48625800     3.50000000
C        3.09150000    21.69133200     3.50000000
C        0.30850000    21.69133200     3.50000000
C        1.00425000    22.89640600     3.50000000
C        2.39575000    22.89640600     3.50000000
C        3.09150000    24.10148000     3.50000000
C        0.30850000    24.10148000     3.50000000
C        1.00425000    25.30655400     3.50000000
C        2.39575000    25.30655400     3.50000000
C        3.09150000    26.51162800     3.50000000
C        0.30850000    26.51162800     3.50000000
C        1.00425000    27.71670200     3.50000000
C        2.39575000    27.71670200     3.50000000
C        3.09150000    28.92177600     3.50000000
C        0.30850000    28.92177600     3.50000000
C        1.00425000    30.12685000     3.50000000
C        2.39575000    30.12685000     3.50000000
C        3.09150000    31.33192400     3.50000000
C        0.30850000    31.33192400     3.50000000
C        1.00425000    32.53699800     3.50000000
C        2.39575000    32.53699800     3.50000000
C        3.09150000    33.74207200     3.50000000
C        0.30850000    33.74207200     3.50000000
C        1.00425000    34.94714600     3.50000000
C        2.39575000    34.94714600     3.50000000
C        3.09150000    36.15222000     3.50000000
C        0.30850000    36.15222000     3.50000000
C        1.00425000    37.35729400     3.50000000
C        2.39575000    37.35729400     3.50000000
C        3.09150000    38.56236800     3.50000000
C        0.30850000    38.56236800     3.50000000
C        1.00425000    39.76744200     3.50000000
C        2.39575000    39.76744200     3.50000000
C        3.09150000    40.97251600     3.50000000
C        0.30850000    40.97251600     3.50000000
C        1.00425000    42.17759000     3.50000000
C        2.39575000    42.17759000     3.50000000
C        3.09150000    43.38266400     3.50000000
C        0.30850000    43.38266400     3.50000000
C        1.00425000    44.58773800     3.50000000
C        2.39575000    44.58773800     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        4.17150000    12.05074000     3.50000000
H       -0.77150000    12.05074000     3.50000000
H        4.17150000    14.46088800     3.50000000
H       -0.77150000    14.46088800     3.50000000
H        4.17150000    16.87103600     3.50000000
H       -0.77150000    16.87103600     3.50000000
H        4.17150000    19.28118400     3.50000000
H       -0.77150000    19.28118400     3.50000000
H        4.17150000    21.69133200     3.50000000
H       -0.77150000    21.69133200     3.50000000
H        4.17150000    24.10148000     3.50000000
H       -0.77150000    24.10148000     3.50000000
H        4.17150000    26.51162800     3.50000000
H       -0.77150000    26.51162800     3.50000000
H        4.17150000    28.92177600     3.50000000
H       -0.77150000    28.92177600     3.50000000
H        4.17150000    31.33192400     3.50000000
H       -0.77150000    31.33192400     3.50000000
H        4.17150000    33.74207200     3.50000000
H       -0.77150000    33.74207200     3.50000000
H        4.17150000    36.15222000     3.50000000
H       -0.77150000    36.15222000     3.50000000
H        4.17150000    38.56236800     3.50000000
H       -0.77150000    38.56236800     3.50000000
H        4.17150000    40.97251600     3.50000000
H       -0.77150000    40.97251600     3.50000000
H        4.17150000    43.38266400     3.50000000
H       -0.77150000    43.38266400     3.50000000
H        0.46425000    45.52304600     3.50000000
H        2.93575000    45.52304600     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '2')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H       -1.23575000     4.55053000     0.00000000
H        1.23575000     4.55053000     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        0.46425000     4.55053000     3.50000000
H        2.93575000     4.55053000     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '20')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
C        1.39150000    12.05074000     0.00000000
C       -1.39150000    12.05074000     0.00000000
C       -0.69575000    13.25581400     0.00000000
C        0.69575000    13.25581400     0.00000000
C        1.39150000    14.46088800     0.00000000
C       -1.39150000    14.46088800     0.00000000
C       -0.69575000    15.66596200     0.00000000
C        0.69575000    15.66596200     0.00000000
C        1.39150000    16.87103600     0.00000000
C       -1.39150000    16.87103600     0.00000000
C       -0.69575000    18.07611000     0.00000000
C        0.69575000    18.07611000     0.00000000
C        1.39150000    19.28118400     0.00000000
C       -1.39150000    19.28118400     0.00000000
C       -0.69575000    20.48625800     0.00000000
C        0.69575000    20.48625800     0.00000000
C        1.39150000    21.69133200     0.00000000
C       -1.39150000    21.69133200     0.00000000
C       -0.69575000    22.89640600     0.00000000
C        0.69575000    22.89640600     0.00000000
C        1.39150000    24.10148000     0.00000000
C       -1.39150000    24.10148000     0.00000000
C       -0.69575000    25.30655400     0.00000000
C        0.69575000    25.30655400     0.00000000
C        1.39150000    26.51162800     0.00000000
C       -1.39150000    26.51162800     0.00000000
C       -0.69575000    27.71670200     0.00000000
C        0.69575000    27.71670200     0.00000000
C        1.39150000    28.92177600     0.00000000
C       -1.39150000    28.92177600     0.00000000
C       -0.69575000    30.12685000     0.00000000
C        0.69575000    30.12685000     0.00000000
C        1.39150000    31.33192400     0.00000000
C       -1.39150000    31.33192400     0.00000000
C       -0.69575000    32.53699800     0.00000000
C        0.69575000    32.53699800     0.00000000
C        1.39150000    33.74207200     0.00000000
C       -1.39150000    33.74207200     0.00000000
C       -0.69575000    34.94714600     0.00000000
C        0.69575000    34.94714600     0.00000000
C        1.39150000    36.15222000     0.00000000
C       -1.39150000    36.15222000     0.00000000
C       -0.69575000    37.35729400     0.00000000
C        0.69575000    37.35729400     0.00000000
C        1.39150000    38.56236800     0.00000000
C       -1.39150000    38.56236800     0.00000000
C       -0.69575000    39.76744200     0.00000000
C        0.69575000    39.76744200     0.00000000
C        1.39150000    40.97251600     0.00000000
C       -1.39150000    40.97251600     0.00000000
C       -0.69575000    42.17759000     0.00000000
C        0.69575000    42.17759000     0.00000000
C        1.39150000    43.38266400     0.00000000
C       -1.39150000    43.38266400     0.00000000
C       -0.69575000    44.58773800     0.00000000
C        0.69575000    44.58773800     0.00000000
C        1.39150000    45.79281200     0.00000000
C       -1.39150000    45.79281200     0.00000000
C       -0.69575000    46.99788600     0.00000000
C        0.69575000    46.99788600     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H        2.47150000    12.05074000     0.00000000
H       -2.47150000    12.05074000     0.00000000
H        2.47150000    14.46088800     0.00000000
H       -2.47150000    14.46088800     0.00000000
H        2.47150000    16.87103600     0.00000000
H       -2.47150000    16.87103600     0.00000000
H        2.47150000    19.28118400     0.00000000
H       -2.47150000    19.28118400     0.00000000
H        2.47150000    21.69133200     0.00000000
H       -2.47150000    21.69133200     0.00000000
H        2.47150000    24.10148000     0.00000000
H       -2.47150000    24.10148000     0.00000000
H        2.47150000    26.51162800     0.00000000
H       -2.47150000    26.51162800     0.00000000
H        2.47150000    28.92177600     0.00000000
H       -2.47150000    28.92177600     0.00000000
H        2.47150000    31.33192400     0.00000000
H       -2.47150000    31.33192400     0.00000000
H        2.47150000    33.74207200     0.00000000
H       -2.47150000    33.74207200     0.00000000
H        2.47150000    36.15222000     0.00000000
H       -2.47150000    36.15222000     0.00000000
H        2.47150000    38.56236800     0.00000000
H       -2.47150000    38.56236800     0.00000000
H        2.47150000    40.97251600     0.00000000
H       -2.47150000    40.97251600     0.00000000
H        2.47150000    43.38266400     0.00000000
H       -2.47150000    43.38266400     0.00000000
H        2.47150000    45.79281200     0.00000000
H       -2.47150000    45.79281200     0.00000000
H       -1.23575000    47.93319400     0.00000000
H        1.23575000    47.93319400     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
C        3.09150000    12.05074000     3.50000000
C        0.30850000    12.05074000     3.50000000
C        1.00425000    13.25581400     3.50000000
C        2.39575000    13.25581400     3.50000000
C        3.09150000    14.46088800     3.50000000
C        0.30850000    14.46088800     3.50000000
C        1.00425000    15.66596200     3.50000000
C        2.39575000    15.66596200     3.50000000
C        3.09150000    16.87103600     3.50000000
C        0.30850000    16.87103600     3.50000000
C        1.00425000    18.07611000     3.50000000
C        2.39575000    18.07611000     3.50000000
C        3.09150000    19.28118400     3.50000000
C        0.30850000    19.28118400     3.50000000
C        1.00425000    20.48625800     3.50000000
C        2.39575000    20.48625800     3.50000000
C        3.09150000    21.69133200     3.50000000
C        0.30850000    21.69133200     3.50000000
C        1.00425000    22.89640600     3.50000000
C        2.39575000    22.89640600     3.50000000
C        3.09150000    24.10148000     3.50000000
C        0.30850000    24.10148000     3.50000000
C        1.00425000    25.30655400     3.50000000
C        2.39575000    25.30655400     3.50000000
C        3.09150000    26.51162800     3.50000000
C        0.30850000    26.51162800     3.50000000
C        1.00425000    27.71670200     3.50000000
C        2.39575000    27.71670200     3.50000000
C        3.09150000    28.92177600     3.50000000
C        0.30850000    28.92177600     3.50000000
C        1.00425000    30.12685000     3.50000000
C        2.39575000    30.12685000     3.50000000
C        3.09150000    31.33192400     3.50000000
C        0.30850000    31.33192400     3.50000000
C        1.00425000    32.53699800     3.50000000
C        2.39575000    32.53699800     3.50000000
C        3.09150000    33.74207200     3.50000000
C        0.30850000    33.74207200     3.50000000
C        1.00425000    34.94714600     3.50000000
C        2.39575000    34.94714600     3.50000000
C        3.09150000    36.15222000     3.50000000
C        0.30850000    36.15222000     3.50000000
C        1.00425000    37.35729400     3.50000000
C        2.39575000    37.35729400     3.50000000
C        3.09150000    38.56236800     3.50000000
C        0.30850000    38.56236800     3.50000000
C        1.00425000    39.76744200     3.50000000
C        2.39575000    39.76744200     3.50000000
C        3.09150000    40.97251600     3.50000000
C        0.30850000    40.97251600     3.50000000
C        1.00425000    42.17759000     3.50000000
C        2.39575000    42.17759000     3.50000000
C        3.09150000    43.38266400     3.50000000
C        0.30850000    43.38266400     3.50000000
C        1.00425000    44.58773800     3.50000000
C        2.39575000    44.58773800     3.50000000
C        3.09150000    45.79281200     3.50000000
C        0.30850000    45.79281200     3.50000000
C        1.00425000    46.99788600     3.50000000
C        2.39575000    46.99788600     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        4.17150000    12.05074000     3.50000000
H       -0.77150000    12.05074000     3.50000000
H        4.17150000    14.46088800     3.50000000
H       -0.77150000    14.46088800     3.50000000
H        4.17150000    16.87103600     3.50000000
H       -0.77150000    16.87103600     3.50000000
H        4.17150000    19.28118400     3.50000000
H       -0.77150000    19.28118400     3.50000000
H        4.17150000    21.69133200     3.50000000
H       -0.77150000    21.69133200     3.50000000
H        4.17150000    24.10148000     3.50000000
H       -0.77150000    24.10148000     3.50000000
H        4.17150000    26.51162800     3.50000000
H       -0.77150000    26.51162800     3.50000000
H        4.17150000    28.92177600     3.50000000
H       -0.77150000    28.92177600     3.50000000
H        4.17150000    31.33192400     3.50000000
H       -0.77150000    31.33192400     3.50000000
H        4.17150000    33.74207200     3.50000000
H       -0.77150000    33.74207200     3.50000000
H        4.17150000    36.15222000     3.50000000
H       -0.77150000    36.15222000     3.50000000
H        4.17150000    38.56236800     3.50000000
H       -0.77150000    38.56236800     3.50000000
H        4.17150000    40.97251600     3.50000000
H       -0.77150000    40.97251600     3.50000000
H        4.17150000    43.38266400     3.50000000
H       -0.77150000    43.38266400     3.50000000
H        4.17150000    45.79281200     3.50000000
H       -0.77150000    45.79281200     3.50000000
H        0.46425000    47.93319400     3.50000000
H        2.93575000    47.93319400     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '3')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H       -1.23575000     6.96067800     0.00000000
H        1.23575000     6.96067800     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        0.46425000     6.96067800     3.50000000
H        2.93575000     6.96067800     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '4')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H       -1.23575000     9.37082600     0.00000000
H        1.23575000     9.37082600     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        0.46425000     9.37082600     3.50000000
H        2.93575000     9.37082600     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '5')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H       -1.23575000    11.78097400     0.00000000
H        1.23575000    11.78097400     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        0.46425000    11.78097400     3.50000000
H        2.93575000    11.78097400     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '6')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
C        1.39150000    12.05074000     0.00000000
C       -1.39150000    12.05074000     0.00000000
C       -0.69575000    13.25581400     0.00000000
C        0.69575000    13.25581400     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H        2.47150000    12.05074000     0.00000000
H       -2.47150000    12.05074000     0.00000000
H       -1.23575000    14.19112200     0.00000000
H        1.23575000    14.19112200     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
C        3.09150000    12.05074000     3.50000000
C        0.30850000    12.05074000     3.50000000
C        1.00425000    13.25581400     3.50000000
C        2.39575000    13.25581400     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        4.17150000    12.05074000     3.50000000
H       -0.77150000    12.05074000     3.50000000
H        0.46425000    14.19112200     3.50000000
H        2.93575000    14.19112200     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '7')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
C        1.39150000    12.05074000     0.00000000
C       -1.39150000    12.05074000     0.00000000
C       -0.69575000    13.25581400     0.00000000
C        0.69575000    13.25581400     0.00000000
C        1.39150000    14.46088800     0.00000000
C       -1.39150000    14.46088800     0.00000000
C       -0.69575000    15.66596200     0.00000000
C        0.69575000    15.66596200     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H        2.47150000    12.05074000     0.00000000
H       -2.47150000    12.05074000     0.00000000
H        2.47150000    14.46088800     0.00000000
H       -2.47150000    14.46088800     0.00000000
H       -1.23575000    16.60127000     0.00000000
H        1.23575000    16.60127000     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
C        3.09150000    12.05074000     3.50000000
C        0.30850000    12.05074000     3.50000000
C        1.00425000    13.25581400     3.50000000
C        2.39575000    13.25581400     3.50000000
C        3.09150000    14.46088800     3.50000000
C        0.30850000    14.46088800     3.50000000
C        1.00425000    15.66596200     3.50000000
C        2.39575000    15.66596200     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        4.17150000    12.05074000     3.50000000
H       -0.77150000    12.05074000     3.50000000
H        4.17150000    14.46088800     3.50000000
H       -0.77150000    14.46088800     3.50000000
H        0.46425000    16.60127000     3.50000000
H        2.93575000    16.60127000     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '8')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
C        1.39150000    12.05074000     0.00000000
C       -1.39150000    12.05074000     0.00000000
C       -0.69575000    13.25581400     0.00000000
C        0.69575000    13.25581400     0.00000000
C        1.39150000    14.46088800     0.00000000
C       -1.39150000    14.46088800     0.00000000
C       -0.69575000    15.66596200     0.00000000
C        0.69575000    15.66596200     0.00000000
C        1.39150000    16.87103600     0.00000000
C       -1.39150000    16.87103600     0.00000000
C       -0.69575000    18.07611000     0.00000000
C        0.69575000    18.07611000     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H        2.47150000    12.05074000     0.00000000
H       -2.47150000    12.05074000     0.00000000
H        2.47150000    14.46088800     0.00000000
H       -2.47150000    14.46088800     0.00000000
H        2.47150000    16.87103600     0.00000000
H       -2.47150000    16.87103600     0.00000000
H       -1.23575000    19.01141800     0.00000000
H        1.23575000    19.01141800     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
C        3.09150000    12.05074000     3.50000000
C        0.30850000    12.05074000     3.50000000
C        1.00425000    13.25581400     3.50000000
C        2.39575000    13.25581400     3.50000000
C        3.09150000    14.46088800     3.50000000
C        0.30850000    14.46088800     3.50000000
C        1.00425000    15.66596200     3.50000000
C        2.39575000    15.66596200     3.50000000
C        3.09150000    16.87103600     3.50000000
C        0.30850000    16.87103600     3.50000000
C        1.00425000    18.07611000     3.50000000
C        2.39575000    18.07611000     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        4.17150000    12.05074000     3.50000000
H       -0.77150000    12.05074000     3.50000000
H        4.17150000    14.46088800     3.50000000
H       -0.77150000    14.46088800     3.50000000
H        4.17150000    16.87103600     3.50000000
H       -0.77150000    16.87103600     3.50000000
H        0.46425000    19.01141800     3.50000000
H        2.93575000    19.01141800     3.50000000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '9')] = qcdb.Molecule("""
0 1
C        0.69575000    -1.20507400     0.00000000
C       -0.69575000    -1.20507400     0.00000000
C        1.39150000     0.00000000     0.00000000
C       -1.39150000     0.00000000     0.00000000
C       -0.69575000     1.20507400     0.00000000
C        0.69575000     1.20507400     0.00000000
C        1.39150000     2.41014800     0.00000000
C       -1.39150000     2.41014800     0.00000000
C       -0.69575000     3.61522200     0.00000000
C        0.69575000     3.61522200     0.00000000
C        1.39150000     4.82029600     0.00000000
C       -1.39150000     4.82029600     0.00000000
C       -0.69575000     6.02537000     0.00000000
C        0.69575000     6.02537000     0.00000000
C        1.39150000     7.23044400     0.00000000
C       -1.39150000     7.23044400     0.00000000
C       -0.69575000     8.43551800     0.00000000
C        0.69575000     8.43551800     0.00000000
C        1.39150000     9.64059200     0.00000000
C       -1.39150000     9.64059200     0.00000000
C       -0.69575000    10.84566600     0.00000000
C        0.69575000    10.84566600     0.00000000
C        1.39150000    12.05074000     0.00000000
C       -1.39150000    12.05074000     0.00000000
C       -0.69575000    13.25581400     0.00000000
C        0.69575000    13.25581400     0.00000000
C        1.39150000    14.46088800     0.00000000
C       -1.39150000    14.46088800     0.00000000
C       -0.69575000    15.66596200     0.00000000
C        0.69575000    15.66596200     0.00000000
C        1.39150000    16.87103600     0.00000000
C       -1.39150000    16.87103600     0.00000000
C       -0.69575000    18.07611000     0.00000000
C        0.69575000    18.07611000     0.00000000
C        1.39150000    19.28118400     0.00000000
C       -1.39150000    19.28118400     0.00000000
C       -0.69575000    20.48625800     0.00000000
C        0.69575000    20.48625800     0.00000000
H        1.23575000    -2.14038200     0.00000000
H       -1.23575000    -2.14038200     0.00000000
H        2.47150000     0.00000000     0.00000000
H       -2.47150000     0.00000000     0.00000000
H        2.47150000     2.41014800     0.00000000
H       -2.47150000     2.41014800     0.00000000
H        2.47150000     4.82029600     0.00000000
H       -2.47150000     4.82029600     0.00000000
H        2.47150000     7.23044400     0.00000000
H       -2.47150000     7.23044400     0.00000000
H        2.47150000     9.64059200     0.00000000
H       -2.47150000     9.64059200     0.00000000
H        2.47150000    12.05074000     0.00000000
H       -2.47150000    12.05074000     0.00000000
H        2.47150000    14.46088800     0.00000000
H       -2.47150000    14.46088800     0.00000000
H        2.47150000    16.87103600     0.00000000
H       -2.47150000    16.87103600     0.00000000
H        2.47150000    19.28118400     0.00000000
H       -2.47150000    19.28118400     0.00000000
H       -1.23575000    21.42156600     0.00000000
H        1.23575000    21.42156600     0.00000000
--
0 1
C        2.39575000    -1.20507400     3.50000000
C        1.00425000    -1.20507400     3.50000000
C        3.09150000     0.00000000     3.50000000
C        0.30850000     0.00000000     3.50000000
C        1.00425000     1.20507400     3.50000000
C        2.39575000     1.20507400     3.50000000
C        3.09150000     2.41014800     3.50000000
C        0.30850000     2.41014800     3.50000000
C        1.00425000     3.61522200     3.50000000
C        2.39575000     3.61522200     3.50000000
C        3.09150000     4.82029600     3.50000000
C        0.30850000     4.82029600     3.50000000
C        1.00425000     6.02537000     3.50000000
C        2.39575000     6.02537000     3.50000000
C        3.09150000     7.23044400     3.50000000
C        0.30850000     7.23044400     3.50000000
C        1.00425000     8.43551800     3.50000000
C        2.39575000     8.43551800     3.50000000
C        3.09150000     9.64059200     3.50000000
C        0.30850000     9.64059200     3.50000000
C        1.00425000    10.84566600     3.50000000
C        2.39575000    10.84566600     3.50000000
C        3.09150000    12.05074000     3.50000000
C        0.30850000    12.05074000     3.50000000
C        1.00425000    13.25581400     3.50000000
C        2.39575000    13.25581400     3.50000000
C        3.09150000    14.46088800     3.50000000
C        0.30850000    14.46088800     3.50000000
C        1.00425000    15.66596200     3.50000000
C        2.39575000    15.66596200     3.50000000
C        3.09150000    16.87103600     3.50000000
C        0.30850000    16.87103600     3.50000000
C        1.00425000    18.07611000     3.50000000
C        2.39575000    18.07611000     3.50000000
C        3.09150000    19.28118400     3.50000000
C        0.30850000    19.28118400     3.50000000
C        1.00425000    20.48625800     3.50000000
C        2.39575000    20.48625800     3.50000000
H        2.93575000    -2.14038200     3.50000000
H        0.46425000    -2.14038200     3.50000000
H        4.17150000     0.00000000     3.50000000
H       -0.77150000     0.00000000     3.50000000
H        4.17150000     2.41014800     3.50000000
H       -0.77150000     2.41014800     3.50000000
H        4.17150000     4.82029600     3.50000000
H       -0.77150000     4.82029600     3.50000000
H        4.17150000     7.23044400     3.50000000
H       -0.77150000     7.23044400     3.50000000
H        4.17150000     9.64059200     3.50000000
H       -0.77150000     9.64059200     3.50000000
H        4.17150000    12.05074000     3.50000000
H       -0.77150000    12.05074000     3.50000000
H        4.17150000    14.46088800     3.50000000
H       -0.77150000    14.46088800     3.50000000
H        4.17150000    16.87103600     3.50000000
H       -0.77150000    16.87103600     3.50000000
H        4.17150000    19.28118400     3.50000000
H       -0.77150000    19.28118400     3.50000000
H        0.46425000    21.42156600     3.50000000
H        2.93575000    21.42156600     3.50000000
units angstrom
""")

# <<< Derived Geometry Strings >>>
for rxn in HRXN:
    GEOS['%s-%s-monoA-unCP' % (dbse, rxn)] = GEOS['%s-%s-dimer' % (dbse, rxn)].extract_fragments(1)
    GEOS['%s-%s-monoB-unCP' % (dbse, rxn)] = GEOS['%s-%s-dimer' % (dbse, rxn)].extract_fragments(2)
    GEOS['%s-%s-monoA-CP'   % (dbse, rxn)] = GEOS['%s-%s-dimer' % (dbse, rxn)].extract_fragments(1, 2)
    GEOS['%s-%s-monoB-CP'   % (dbse, rxn)] = GEOS['%s-%s-dimer' % (dbse, rxn)].extract_fragments(2, 1)

#########################################################################

# <<< Supplementary Quantum Chemical Results >>>
DATA = {}

DATA['NUCLEAR REPULSION ENERGY'] = {}
DATA['NUCLEAR REPULSION ENERGY']['ACENES-1-dimer'                 ] =     623.45166278
DATA['NUCLEAR REPULSION ENERGY']['ACENES-1-monoA-unCP'            ] =     204.01997321
DATA['NUCLEAR REPULSION ENERGY']['ACENES-1-monoB-unCP'            ] =     204.01997321
DATA['NUCLEAR REPULSION ENERGY']['ACENES-2-dimer'                 ] =    1447.97918063
DATA['NUCLEAR REPULSION ENERGY']['ACENES-2-monoA-unCP'            ] =     462.51351405
DATA['NUCLEAR REPULSION ENERGY']['ACENES-2-monoB-unCP'            ] =     462.51351405
DATA['NUCLEAR REPULSION ENERGY']['ACENES-3-dimer'                 ] =    2478.53381614
DATA['NUCLEAR REPULSION ENERGY']['ACENES-3-monoA-unCP'            ] =     776.53779489
DATA['NUCLEAR REPULSION ENERGY']['ACENES-3-monoB-unCP'            ] =     776.53779489
DATA['NUCLEAR REPULSION ENERGY']['ACENES-4-dimer'                 ] =    3664.54622337
DATA['NUCLEAR REPULSION ENERGY']['ACENES-4-monoA-unCP'            ] =    1131.16297168
DATA['NUCLEAR REPULSION ENERGY']['ACENES-4-monoB-unCP'            ] =    1131.16297168
DATA['NUCLEAR REPULSION ENERGY']['ACENES-5-dimer'                 ] =    4974.79907551
DATA['NUCLEAR REPULSION ENERGY']['ACENES-5-monoA-unCP'            ] =    1517.73569587
DATA['NUCLEAR REPULSION ENERGY']['ACENES-5-monoB-unCP'            ] =    1517.73569587
DATA['NUCLEAR REPULSION ENERGY']['ACENES-6-dimer'                 ] =    6388.28553373
DATA['NUCLEAR REPULSION ENERGY']['ACENES-6-monoA-unCP'            ] =    1930.62605849
DATA['NUCLEAR REPULSION ENERGY']['ACENES-6-monoB-unCP'            ] =    1930.62605849
DATA['NUCLEAR REPULSION ENERGY']['ACENES-7-dimer'                 ] =    7889.97351320
DATA['NUCLEAR REPULSION ENERGY']['ACENES-7-monoA-unCP'            ] =    2365.88438821
DATA['NUCLEAR REPULSION ENERGY']['ACENES-7-monoB-unCP'            ] =    2365.88438821
DATA['NUCLEAR REPULSION ENERGY']['ACENES-8-dimer'                 ] =    9468.60272003
DATA['NUCLEAR REPULSION ENERGY']['ACENES-8-monoA-unCP'            ] =    2820.58881529
DATA['NUCLEAR REPULSION ENERGY']['ACENES-8-monoB-unCP'            ] =    2820.58881529
DATA['NUCLEAR REPULSION ENERGY']['ACENES-9-dimer'                 ] =   11115.43628142
DATA['NUCLEAR REPULSION ENERGY']['ACENES-9-monoA-unCP'            ] =    3292.49113688
DATA['NUCLEAR REPULSION ENERGY']['ACENES-9-monoB-unCP'            ] =    3292.49113688
DATA['NUCLEAR REPULSION ENERGY']['ACENES-10-dimer'                ] =   12823.50435945
DATA['NUCLEAR REPULSION ENERGY']['ACENES-10-monoA-unCP'           ] =    3779.80831432
DATA['NUCLEAR REPULSION ENERGY']['ACENES-10-monoB-unCP'           ] =    3779.80831432
DATA['NUCLEAR REPULSION ENERGY']['ACENES-11-dimer'                ] =   14587.12067915
DATA['NUCLEAR REPULSION ENERGY']['ACENES-11-monoA-unCP'           ] =    4281.09183900
DATA['NUCLEAR REPULSION ENERGY']['ACENES-11-monoB-unCP'           ] =    4281.09183900
DATA['NUCLEAR REPULSION ENERGY']['ACENES-12-dimer'                ] =   16401.55973922
DATA['NUCLEAR REPULSION ENERGY']['ACENES-12-monoA-unCP'           ] =    4795.14176671
DATA['NUCLEAR REPULSION ENERGY']['ACENES-12-monoB-unCP'           ] =    4795.14176671
DATA['NUCLEAR REPULSION ENERGY']['ACENES-13-dimer'                ] =   18262.83338543
DATA['NUCLEAR REPULSION ENERGY']['ACENES-13-monoA-unCP'           ] =    5320.94785288
DATA['NUCLEAR REPULSION ENERGY']['ACENES-13-monoB-unCP'           ] =    5320.94785288
DATA['NUCLEAR REPULSION ENERGY']['ACENES-14-dimer'                ] =   20167.53140066
DATA['NUCLEAR REPULSION ENERGY']['ACENES-14-monoA-unCP'           ] =    5857.64789898
DATA['NUCLEAR REPULSION ENERGY']['ACENES-14-monoB-unCP'           ] =    5857.64789898
DATA['NUCLEAR REPULSION ENERGY']['ACENES-15-dimer'                ] =   22112.70479751
DATA['NUCLEAR REPULSION ENERGY']['ACENES-15-monoA-unCP'           ] =    6404.49745327
DATA['NUCLEAR REPULSION ENERGY']['ACENES-15-monoB-unCP'           ] =    6404.49745327
DATA['NUCLEAR REPULSION ENERGY']['ACENES-16-dimer'                ] =   24095.77845643
DATA['NUCLEAR REPULSION ENERGY']['ACENES-16-monoA-unCP'           ] =    6960.84724639
DATA['NUCLEAR REPULSION ENERGY']['ACENES-16-monoB-unCP'           ] =    6960.84724639
DATA['NUCLEAR REPULSION ENERGY']['ACENES-17-dimer'                ] =   26114.48445685
DATA['NUCLEAR REPULSION ENERGY']['ACENES-17-monoA-unCP'           ] =    7526.12604311
DATA['NUCLEAR REPULSION ENERGY']['ACENES-17-monoB-unCP'           ] =    7526.12604311
DATA['NUCLEAR REPULSION ENERGY']['ACENES-18-dimer'                ] =   28166.81033192
DATA['NUCLEAR REPULSION ENERGY']['ACENES-18-monoA-unCP'           ] =    8099.82737807
DATA['NUCLEAR REPULSION ENERGY']['ACENES-18-monoB-unCP'           ] =    8099.82737807
DATA['NUCLEAR REPULSION ENERGY']['ACENES-19-dimer'                ] =   30250.95830169
DATA['NUCLEAR REPULSION ENERGY']['ACENES-19-monoA-unCP'           ] =    8681.49913522
DATA['NUCLEAR REPULSION ENERGY']['ACENES-19-monoB-unCP'           ] =    8681.49913522
DATA['NUCLEAR REPULSION ENERGY']['ACENES-20-dimer'                ] =   32365.31272557
DATA['NUCLEAR REPULSION ENERGY']['ACENES-20-monoA-unCP'           ] =    9270.73524802
DATA['NUCLEAR REPULSION ENERGY']['ACENES-20-monoB-unCP'           ] =    9270.73524802
DATA['NUCLEAR REPULSION ENERGY']['ACENES-1-monoA-CP'              ] =     204.01997321
DATA['NUCLEAR REPULSION ENERGY']['ACENES-1-monoB-CP'              ] =     204.01997321
DATA['NUCLEAR REPULSION ENERGY']['ACENES-2-monoA-CP'              ] =     462.51351405
DATA['NUCLEAR REPULSION ENERGY']['ACENES-2-monoB-CP'              ] =     462.51351405
DATA['NUCLEAR REPULSION ENERGY']['ACENES-3-monoA-CP'              ] =     776.53779489
DATA['NUCLEAR REPULSION ENERGY']['ACENES-3-monoB-CP'              ] =     776.53779489
DATA['NUCLEAR REPULSION ENERGY']['ACENES-4-monoA-CP'              ] =    1131.16297168
DATA['NUCLEAR REPULSION ENERGY']['ACENES-4-monoB-CP'              ] =    1131.16297168
DATA['NUCLEAR REPULSION ENERGY']['ACENES-5-monoA-CP'              ] =    1517.73569587
DATA['NUCLEAR REPULSION ENERGY']['ACENES-5-monoB-CP'              ] =    1517.73569587
DATA['NUCLEAR REPULSION ENERGY']['ACENES-6-monoA-CP'              ] =    1930.62605849
DATA['NUCLEAR REPULSION ENERGY']['ACENES-6-monoB-CP'              ] =    1930.62605849
DATA['NUCLEAR REPULSION ENERGY']['ACENES-7-monoA-CP'              ] =    2365.88438821
DATA['NUCLEAR REPULSION ENERGY']['ACENES-7-monoB-CP'              ] =    2365.88438821
DATA['NUCLEAR REPULSION ENERGY']['ACENES-8-monoA-CP'              ] =    2820.58881529
DATA['NUCLEAR REPULSION ENERGY']['ACENES-8-monoB-CP'              ] =    2820.58881529
DATA['NUCLEAR REPULSION ENERGY']['ACENES-9-monoA-CP'              ] =    3292.49113688
DATA['NUCLEAR REPULSION ENERGY']['ACENES-9-monoB-CP'              ] =    3292.49113688
DATA['NUCLEAR REPULSION ENERGY']['ACENES-10-monoA-CP'             ] =    3779.80831432
DATA['NUCLEAR REPULSION ENERGY']['ACENES-10-monoB-CP'             ] =    3779.80831432
DATA['NUCLEAR REPULSION ENERGY']['ACENES-11-monoA-CP'             ] =    4281.09183900
DATA['NUCLEAR REPULSION ENERGY']['ACENES-11-monoB-CP'             ] =    4281.09183900
DATA['NUCLEAR REPULSION ENERGY']['ACENES-12-monoA-CP'             ] =    4795.14176671
DATA['NUCLEAR REPULSION ENERGY']['ACENES-12-monoB-CP'             ] =    4795.14176671
DATA['NUCLEAR REPULSION ENERGY']['ACENES-13-monoA-CP'             ] =    5320.94785288
DATA['NUCLEAR REPULSION ENERGY']['ACENES-13-monoB-CP'             ] =    5320.94785288
DATA['NUCLEAR REPULSION ENERGY']['ACENES-14-monoA-CP'             ] =    5857.64789898
DATA['NUCLEAR REPULSION ENERGY']['ACENES-14-monoB-CP'             ] =    5857.64789898
DATA['NUCLEAR REPULSION ENERGY']['ACENES-15-monoA-CP'             ] =    6404.49745327
DATA['NUCLEAR REPULSION ENERGY']['ACENES-15-monoB-CP'             ] =    6404.49745327
DATA['NUCLEAR REPULSION ENERGY']['ACENES-16-monoA-CP'             ] =    6960.84724639
DATA['NUCLEAR REPULSION ENERGY']['ACENES-16-monoB-CP'             ] =    6960.84724639
DATA['NUCLEAR REPULSION ENERGY']['ACENES-17-monoA-CP'             ] =    7526.12604311
DATA['NUCLEAR REPULSION ENERGY']['ACENES-17-monoB-CP'             ] =    7526.12604311
DATA['NUCLEAR REPULSION ENERGY']['ACENES-18-monoA-CP'             ] =    8099.82737807
DATA['NUCLEAR REPULSION ENERGY']['ACENES-18-monoB-CP'             ] =    8099.82737807
DATA['NUCLEAR REPULSION ENERGY']['ACENES-19-monoA-CP'             ] =    8681.49913522
DATA['NUCLEAR REPULSION ENERGY']['ACENES-19-monoB-CP'             ] =    8681.49913522
DATA['NUCLEAR REPULSION ENERGY']['ACENES-20-monoA-CP'             ] =    9270.73524802
DATA['NUCLEAR REPULSION ENERGY']['ACENES-20-monoB-CP'             ] =    9270.73524802
