#!/bin/sh

ZEXY_C=z_zexy.c

#################################
## functions

mycolumn() {
  cat
}
COLUMN=$(which column 2>/dev/null || echo mycolumn)

head_c() {
  cat <<EOL
/* zexy-setup autogenerated setup-file
 * generated by "$0"
 * !! DO NOT MANUALLY EDIT  !!
 */

/* forward declarations */
EOL
}

middle_c() {
  cat <<EOL

void z_zexy_setup(void)
{
EOL
}

tail_c() {
  cat <<EOL
}
EOL
}

get_setup_functions() {
  find * -name "*.c" -not -name "* *" -exec grep ZEXY_SETUP {} + \
  | sed -e 's|(.*||' -e 's|:.* | |' \
  | LANG=C sort -u
}

forward_declarations() {
  get_setup_functions | while read file setup; do
    echo "void ${setup}(void); /* ${file} */"
  done
}

call_setup() {
  get_setup_functions | while read file setup; do
    echo "  ${setup}();"
  done
}


##################################
## body
zexy_c() {
  head_c
  forward_declarations | "${COLUMN}" -t -c 76
  middle_c
  call_setup
  tail_c
}

zexy_c | tee "${ZEXY_C}"
