#include "Platform.h"
#include <string.h>
#include <stdio.h>
#include "ONEReader.h"
#include "BaseCommunication.h"

#define base CCGOReader

CONEReader::CONEReader(CReader *Owner, CBaseCommunication *Communicator)
	:base(Owner, Communicator)
{
}

CONEReader::~CONEReader(void)
{
}




void CONEReader::SetHWString(char *String)
{
	strcpy(String, "ONE_");
}

void CONEReader::GetProductString(uint8_t *Product)
{
	memcpy(Product, "CJONE", 5);
}

void CONEReader::CompressModifyStructure(CCID_Message& Message)
{
	if (Message.Data.Secure.Data.Modify.bNumberMessage == 0)
	{
		memmove(&(Message.Data.Secure.Data.Modify.bMsgIndex2), Message.Data.Secure.Data.Modify.bTeoPrologue, Message.dwLength - 17);
		Message.dwLength -= 2;
	}
	else if (Message.Data.Secure.Data.Modify.bNumberMessage != 3)
	{
		memmove(&(Message.Data.Secure.Data.Modify.bMsgIndex3), Message.Data.Secure.Data.Modify.bTeoPrologue, Message.dwLength - 17);
		Message.dwLength -= 1;
	}
}

uint32_t CONEReader::GetReadersInputBufferSize()
{
	return 2048;
}

#ifdef WITH_SECODER_INFO_OVERRIDE
CJ_RESULT CONEReader::KTLightCall(uint8_t *sad, uint8_t *dad, uint8_t *cmd, uint16_t lenc, int32_t Lc, uint8_t *data_ptr, int32_t Le, uint8_t *response, uint16_t *lenr)
{
	static const uint8_t SECODER3_INFO_0[] = {
		"\x40\x07""Secoder"
		"\x80\x05""1.2.0"
		"\x80\x05""1.1.2"
		"\x81\x21""Reiner Kartenger\x7b""te GmbH & Co.KG."
	};
	static const uint8_t SECODER3_INFO_1[] = {
		"\x84\x02""de"
		"\x90\x01\x01"
		"\xa0\x13\x40\x03""tan\x80\x05""1.1.2\x83\x05""1.0.0"
		"\xa0\x13\x40\x03""aut\x80\x05""1.1.2\x83\x05""1.0.0"
		"\xa0\x13\x40\x03""sig\x80\x05""1.1.2\x83\x05""1.0.0"
		"\xa0\x13\x40\x03""gkp\x80\x05""1.1.2\x83\x05""1.0.0"
		"\xa0\x16\x40\x03""ctn\x80\x05""1.2.1\x83\x05""1.0.0\x84\x01\x33"
		"\x90\x00"
	};

	CJ_RESULT res;
	uint16_t InLenr = *lenr;
	uint8_t ReaderId[20 + 2];
	uint8_t SWImpVers[10 + 2];
	uint8_t ReaderPorp[9 + 2];
	int lenReaderId = 0;
	int lenSWImpVers = 0;
	int lenReaderProp = 0;
	uint8_t *Tag92 = NULL;
	uint8_t *Tag83 = NULL;
	uint8_t *Tag91 = NULL;
	uint8_t inCmd1 = *(cmd + 1);

	memset(ReaderId, 0, sizeof(ReaderId));
	memset(SWImpVers, 0, sizeof(SWImpVers));

	if ((res = base::KTLightCall(sad, dad, cmd, lenc, Lc, data_ptr, Le, response, lenr)) == CJ_SUCCESS)
	{
		if (inCmd1 == 0x70 && m_ReaderInfo.Version >= 0x11)
		{
			if (GetEnviroment("SecoderInfoOverride", 0x00000001) > 0)
			{
				if (GetEnviroment("SecoderInfoOverride_ONE", 0x00000001) > 0)
				{
					if (((Tag91 = GetTag(response, *lenr - 2, 0x91, &lenReaderProp)) != NULL) &&
						((Tag92 = GetTag(response, *lenr - 2, 0x92, &lenReaderId)) != NULL) &&
						((Tag83 = GetTag(response, *lenr - 2, 0x83, &lenSWImpVers)) != NULL) &&
						(lenReaderId <= 20) && (lenSWImpVers <= 10) && (lenReaderProp == 9))
					{
						lenReaderProp += 2;
						memcpy(ReaderPorp, Tag91 - 2, lenReaderProp);

						lenReaderId += 2;
						memcpy(ReaderId, Tag92 - 2, lenReaderId);

						lenSWImpVers += 2;
						memcpy(SWImpVers, Tag83 - 2, lenSWImpVers);

						if (InLenr >= (sizeof(SECODER3_INFO_0) + lenReaderProp + lenReaderId + lenSWImpVers + sizeof(SECODER3_INFO_1)))
						{
							memcpy(response, SECODER3_INFO_0, sizeof(SECODER3_INFO_0) - 1);
							memcpy(response + sizeof(SECODER3_INFO_0) - 1, ReaderPorp, lenReaderProp);
							memcpy(response + sizeof(SECODER3_INFO_0) - 1 + lenReaderProp, ReaderId, lenReaderId);
							memcpy(response + sizeof(SECODER3_INFO_0) - 1 + lenReaderProp + lenReaderId, SWImpVers, lenSWImpVers);
							memcpy(response + sizeof(SECODER3_INFO_0) - 1 + lenReaderProp + lenReaderId + lenSWImpVers, SECODER3_INFO_1, sizeof(SECODER3_INFO_1) - 1);
							*lenr = sizeof(SECODER3_INFO_0) - 1 + (USHORT)lenReaderProp + (USHORT)lenReaderId + (USHORT)lenSWImpVers + sizeof(SECODER3_INFO_1) - 1;
						}
						else
						{
							return CJ_ERR_RBUFFER_TO_SMALL;
						}
					}
				}
			}
		}
	}
	return res;
}
#endif

#if 0

#include "eca_defines.h"

CJ_RESULT CONEReader::CtSetMFT(const uint8_t *const pData, uint32_t DataLen, uint32_t *Result)
{
	CJ_RESULT Res;
	if ((Res = Escape(MODULE_ID_KERNEL, CCID_ESCAPE_SET_MFT, const_cast<uint8_t*>(pData), DataLen, Result, 0, 0)) != CJ_SUCCESS)
	{
		m_Owner->DebugLeveled(DEBUG_MASK_COMMUNICATION_ERROR, "Can't set MFT status!");
	}
	return Res;
}

CJ_RESULT CONEReader::CtGetMFT(cj_MFT_Info *const pData, uint32_t *const pNumElemnts)
{
	uint32_t Result;
	uint32_t FeatureMap = 0xFFFFFFFF;
	uint32_t Mask = 1;
	uint32_t Count = 0;
	uint32_t RetLen = sizeof(FeatureMap);
	CJ_RESULT Res;

	if (*pNumElemnts < 1)
	{
		*pNumElemnts = 0;
		return CJ_ERR_RBUFFER_TO_SMALL;
	}

	if ((Res = Escape(MODULE_ID_KERNEL, CCID_ESCAPE_GET_MFT, NULL, 0, &Result, (BYTE*)&FeatureMap, &RetLen)) != CJ_SUCCESS)
	{
		m_Owner->DebugLeveled(DEBUG_MASK_COMMUNICATION_ERROR, "Can't get MFT status!");
		return Res;
	}
	FeatureMap = ReaderToHostLong(FeatureMap);
	FeatureMap = ~FeatureMap;
	for (uint32_t idx = 0; idx < 32; idx++, Mask <<= 1)
	{
		if ((FeatureMap & Mask))
		{
			if (Count < *pNumElemnts)
			{
				switch (idx)
				{
				case 0:
					pData[Count].FID = 0x00000001;
					pData[Count].Status = 1;
					strcpy(pData[Count].Name, "chipTAN 1.1");
					break;

				default:
					pData[Count].FID = 0xF0000000 | idx;
					pData[Count].Status = 1;
					strcpy(pData[Count].Name, "UNKONW FEATURE");
					break;
				}
				++Count;
			}
			else
			{
				*pNumElemnts = 0;
				return CJ_ERR_RBUFFER_TO_SMALL;
			}
		}
		else
		{
			switch (idx)
			{
			case 0:
				pData[Count].FID = 0x00000001;
				pData[Count].Status = 0;
				strcpy(pData[Count].Name, "chipTAN 1.1");
				++Count;
				break;
			
			default:
				break;
			}
		}
	}
	*pNumElemnts = Count;
	return CJ_SUCCESS;
}

#endif
