# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# DO NOT ADD THINGS OTHER THAN ERROR MESSAGES HERE.
# This file gets parsed into a JS dictionary of all known error message ids in
# gen_aboutneterror_codes.py . If we end up needing fluent attributes or
# refactoring them in some way, the script will need updating.

# Variables:
# $hostname (String) - Hostname of the website with SSL error.
# $errorMessage (String) - Error message corresponding to the type of error we are experiencing.
ssl-connection-error = { $hostname } адресіне байланысты орнату кезінде қате кетті. { $errorMessage }

# Variables:
# $error (string) - NSS error code string that specifies type of cert error. e.g. unknown issuer, invalid cert, etc.
cert-error-code-prefix = Қате коды: { $error }

psmerr-ssl-disabled = Қауіпсіз байланысты орнату мүмкін емес, SSL хаттамасы сөндірулі тұр.
psmerr-ssl2-disabled = Сервермен байланыс орнату мүмкін емес, өйткені ол ескі, қауіпсіз емес SSL хаттамасын қолдануда.

# This is a multi-line message.
psmerr-hostreusedissuerandserial =
    Сіз алған сертификат қате.  Сервер администраторымен не электронды пошта алушысымен хабарласып, келесі ақпаратты беріңіз:
    
    Сертификат нөмірі осы сертификат шығару орталығы шығарған басқа бір сертификаттың нөмірімен сәйкес болып тұр. Нөмірі ерекше жаңа сертификат алыңыз.

ssl-error-export-only-server = Қорғалған байланысты орнату сәтсіз аяқталды. Торап жоғары дәрежелі шифрлеуді қолдамайды.
ssl-error-us-only-server = Қорғалған байланысты орнату сәтсіз аяқталды. Торап сұраған жоғары дәрежелі шифрлеуге қолдау жоқ.
ssl-error-no-cypher-overlap = Қорғалған байланысты орнату сәтсіз аяқталды: шифрлеудің жалпы алгоритмдері жоқ.
ssl-error-no-certificate = Аутентификация үшін керек сертификат немесе кілт табылмады.
ssl-error-bad-certificate = Қорғалған байланысты орнату сәтсіз аяқталды: тораптың сертификаты қабылданбады.
ssl-error-bad-client = Серверге клиент жағынан қате мәліметтер түсті.
ssl-error-bad-server = Клиентке сервер жағынан қате мәліметтер түсті.
ssl-error-unsupported-certificate-type = Сертификаттың осы түріне қолдау жоқ.
ssl-error-unsupported-version = Торап сұраған қауіпсіздік хаттамасына қолдау жоқ.
ssl-error-wrong-certificate = Клиент аутентификациясы сәтсіз аяқталды: кілт дерекқорындағы жабық кілт сертификаттар дерекқорындағы ашык кілтке сәйкес келмейді.
ssl-error-bad-cert-domain = Қорғалған байланысты орнату сәтсіз аяқталды: сұраған домен аты сервер сертификатындағы көрсетілгенге сәйкес келмейді.
ssl-error-post-warning = Танылмаған SSL қате коды.
ssl-error-ssl2-disabled = Торап тек SSL хаттамасының 2 нұсқасын қолдайды, ал сізде ол өшірулі тұр.
ssl-error-bad-mac-read = SSL хабарламаны аутентификациялау коды қате жазбаны алды.
ssl-error-bad-mac-alert = SSL торабы хабарламаны аутентификациялау коды қате екенін хабарлады.
ssl-error-bad-cert-alert = SSL торабы сертификатыңызды растай алмайды (верификация).
ssl-error-revoked-cert-alert = SSL торабы сертификатыңызды кері шақырылған деп қабылдамады.
ssl-error-expired-cert-alert = SSL торабы сертификатыңызды мерзімі аяқталған деп қабылдамады.
ssl-error-ssl-disabled = Байланысү мүмкін емес: SSL сөндірулі тұр.
ssl-error-fortezza-pqg = Байланысты орнату мүмкін емес: SSL торабы басқа FORTEZZA доменде орналасқан.
ssl-error-unknown-cipher-suite = Белгісіз SSL шифрлер жинағы сұранған.
ssl-error-no-ciphers-supported = Бағдарламада бірде-бір шифрлер жинағы жоқ және қосылмаған.
ssl-error-bad-block-padding = SSL түзетілуі қате жазбасын алды.
ssl-error-rx-record-too-long = SSL ұзындығы максимал мүмкін шамадан үлкен жазбаны алды.
ssl-error-tx-record-too-long = SSL ұзындығы максимал мүмкін шамадан үлкен жазбаны жіберіп көрді.
ssl-error-rx-malformed-hello-request = SSL Hello Request байланысын орнату зақымдалған сұранымын алды.
ssl-error-rx-malformed-client-hello = SSL Client Hello байланысын орнату зақымдалған сұранымын алды.
ssl-error-rx-malformed-server-hello = SSL Server Hello байланысын орнату зақымдалған сұранымын алды.
ssl-error-rx-malformed-certificate = SSL Certificate байланысын орнату зақымдалған сұранымын алды.
ssl-error-rx-malformed-server-key-exch = SSL Server Key Exchange байланысын орнату зақымдалған сұранымын алды.
ssl-error-rx-malformed-cert-request = SSL Certificate Request байланысын орнату зақымдалған сұранымын алды.
ssl-error-rx-malformed-hello-done = SSL Server Hello Done байланысын орнату зақымдалған сұранымын алды.
ssl-error-rx-malformed-cert-verify = SSL Certificate Verify байланысын орнату зақымдалған сұранымын алды.
ssl-error-rx-malformed-client-key-exch = SSL Client Key Exchange байланысын орнату зақымдалған сұранымын алды.
ssl-error-rx-malformed-finished = SSL Finished байланысын орнату зақымдалған сұранымын алды.
ssl-error-rx-malformed-change-cipher = SSL Change Cipher Spec зақымдалған жазбасын алды.
ssl-error-rx-malformed-alert = SSL Alert  зақымдалған жазбасын алды.
ssl-error-rx-malformed-handshake = SSL зақымдалған Handshake жазбасын алды.
ssl-error-rx-malformed-application-data = SSL зақымдалған Application Data жазбасын алды.
ssl-error-rx-unexpected-hello-request = SSL күтпеген Hello Request байланысын орнату сұранымын алды.
ssl-error-rx-unexpected-client-hello = SSL күтпеген Client Hello байланысын орнату сұранымын алды.
ssl-error-rx-unexpected-server-hello = SSL күтпеген Server Hello байланысын орнату сұранымын алды.
ssl-error-rx-unexpected-certificate = SSL күтпеген Certificate байланысын орнату сұранымын алды.
ssl-error-rx-unexpected-server-key-exch = SSL күтпеген Server Key Exchange байланысын орнату сұранымын алды.
ssl-error-rx-unexpected-cert-request = SSL күтпеген Certificate Request байланысын орнату сұранымын алды.
ssl-error-rx-unexpected-hello-done = SSL күтпеген Server Hello Done байланысын орнату сұранымын алды.
ssl-error-rx-unexpected-cert-verify = SSL күтпеген Certificate Verify байланысын орнату сұранымын алды.
ssl-error-rx-unexpected-client-key-exch = SSL күтпеген Client Key Exchange байланысын орнату сұранымын алды.
ssl-error-rx-unexpected-finished = SSL күтпеген Finished байланысын орнату сұранымын алды.
ssl-error-rx-unexpected-change-cipher = SSL күтпеген Change Cipher Spec жазбасын алды.
ssl-error-rx-unexpected-alert = SSL күтпеген Alert жазбасын алды.
ssl-error-rx-unexpected-handshake = SSL күтпеген Handshake жазбасын алды.
ssl-error-rx-unexpected-application-data = SSL күтпеген Application Data жазбасын алды.
ssl-error-rx-unknown-record-type = SSL құрамасы белгісіз жазбаны алды.
ssl-error-rx-unknown-handshake = SSL сәлем хабарламасына қоса белгісіз түрде хабарламаны алды.
ssl-error-rx-unknown-alert = SSL ескертудің белгісіз түрімен ескерту жазбасын алды.
ssl-error-close-notify-alert = SSL торабы бұл байланысты жапты.
ssl-error-handshake-unexpected-alert = SSL торабы байланысты орнатуға алынған сұранымды күтпеді.
ssl-error-decompression-failure-alert = SSL торабы өзі алған SSL жазбасын сәтті дешифрлей алмады.
ssl-error-handshake-failure-alert = SSL торабы алынған қауіпсіздік ақпаратты терістей не растай алмады.
ssl-error-illegal-parameter-alert = SSL торабы құрамасы қате болған соң байланыс орнату хабарламасын үзді.
ssl-error-unsupported-cert-alert = SSL торабы алынған сертификат түрін қолдамайды.
ssl-error-certificate-unknown-alert = SSL торабында алынған сертификатпен біраз мәселелер пайда болды.
ssl-error-generate-random-failure = SSL кездейсоқ сандарды генерациялауда қате кетті.
ssl-error-sign-hashes-failure = Сіздің сертификатыңызды растау үшін керек мәліметтерге сандық қолтаңба қою мүмкін емес.
ssl-error-extract-public-key-failure = SSL тораптың сертификатынан ашық кілтті тарқата алмады.
ssl-error-server-key-exchange-failure = SSL Server Key Exchange handshake өңдеу кезінде белгісіз қате кетті.
ssl-error-client-key-exchange-failure = SSL Client Key Exchange handshake  өңдеу кезінде белгісіз қате кетті.
ssl-error-encryption-failure = Таңдалған шифрлер жинағы үшін көптік ақпаратты шифрлеу алгоритмі сәтсіз.
ssl-error-decryption-failure = Таңдалған шифрлер жинағы үшін көптік ақпаратты шифрлеу алгоритмі сәтсіз.
ssl-error-socket-write-failure = Төменгі жатқан сокетке шифрленген ақпаратты жазу талабы сәтсіз аяқталды.
ssl-error-md5-digest-failure = MD5 digest функция қатесі.
ssl-error-sha-digest-failure = SHA-1 digest функция қатесі.
ssl-error-mac-computation-failure = MAC есептеу қатесі.
ssl-error-sym-key-context-failure = Симметриялы кілт контекстін жасау қатесі.
ssl-error-sym-key-unwrap-failure = Client Key Exchange хабарламасынан симметриялы кіллті тарқату қатесі.
ssl-error-pub-key-size-limit-exceeded = SSL сервері таңдалған шифрлер жинағымен ішкі қолдануға арналған ашық кіллті қолданып көрді.
ssl-error-iv-param-failure = PKCS11 кодын IV param-ға айналдыру қатесі.
ssl-error-init-cipher-suite-failure = Шифрлердің таңдалған жинағын іске қосу қатесі
ssl-error-session-key-gen-failure = Клиент SSL сессиясы үшін кілттерді генерациялай алмады.
ssl-error-no-server-key-for-alg = Серверде сұранған кілт алмасу алгоритмі үшін кілт жоқ.
ssl-error-token-insertion-removal = PKCS#11 токені операция жүріп жатқан кезде қосылды не сөндірілді.
ssl-error-token-slot-not-found = Сұранған операцияны жасау үшін бірде-бір PKCS#11 токені табылмады.
ssl-error-no-compression-overlap = Тораппен қауіпсіз байланысу мүмкін емес: жалпы сығу алгоритмдері табылмады.
ssl-error-handshake-not-completed = Жаңа SSL handshake жасау мүмкін емес, өйткені ағымдағы handshake әлі бітпеген.
ssl-error-bad-handshake-hash-value = Тораптан алынған handshakes hash мәндері қате.
ssl-error-cert-kea-mismatch = Ұсынылған сертификат таңдалған кілт алмасу алгоритмімен қолданыла алмайды.
ssl-error-no-trusted-ssl-client-ca = SSL клиентін анықтау үшін бірде-бір сертификаттау орталығы жоқ.
ssl-error-session-not-found = Клиенттің SSL сессиясының нөмірі (ID) сервердің сессия кэшінен табылмады.
ssl-error-decryption-failed-alert = Торап алынған SSL жазбасын дешифрлей алмайтынын хабарлады.
ssl-error-record-overflow-alert = Торап алынған SSL жазбасының ұзындығы рұқсат етілгеннен ұзын екенін хабарлады.
ssl-error-unknown-ca-alert = Торап сіздің сертификатыңызды шығарған CA білмейді және оларға сенбейді.
ssl-error-access-denied-alert = Торап дұрыс сертификатты алды, бірақ рұқсат жоқ.
ssl-error-decode-error-alert = Торап SSL байланыс орнату хабарламасын декодалай алмайды.
ssl-error-decrypt-error-alert = Торап қолтаңбаны тексеру кезінде немесе кілттермен алмасу кезінде қате кеткені туралы хабарлады.
ssl-error-export-restriction-alert = Торап жауаптары хабар алмасу ережелеріне сай емес.
ssl-error-protocol-version-alert = Торап жауаптарына немесе оның хаттамасына қолдау жоқ.
ssl-error-insufficient-security-alert = Сервер клиентте қолданылатын шифрден дәрежесі үлкен шифрлеуді сұрап тұр.
ssl-error-internal-error-alert = Торап жауаптары ішкі қате туралы хабарлайды.
ssl-error-user-canceled-alert = Торап пайдаланушысы байланыс орнату хабарын тоқтатқан.
ssl-error-no-renegotiation-alert = Торап SSL қауіпсіздік параметрлерін қайта қарауға рұқсат етпейді.
ssl-error-server-cache-not-configured = SSL серверінің кэші бапталмаған немесе бұл сокет үшін өшірілген.
ssl-error-unsupported-extension-alert = SSL торабы сұранған TLS hello кеңейтуін қолдамайды.
ssl-error-certificate-unobtainable-alert = SSL торабы сіздің сертификатыңызды көрсетілген URL адресінен жүктей алмады.
ssl-error-unrecognized-name-alert = SSL торабында көрсетілген DNS nаты үшін сертификат жоқ.
ssl-error-bad-cert-status-response-alert = SSL торабы оның сертификаты үшін OCSP жауабын ала алмады.
ssl-error-bad-cert-hash-value-alert = SSL торабы сертификаттың хеш сомасы қате екенін хабарлады.
ssl-error-rx-unexpected-new-session-ticket = SSL күтілмеген New Session Ticket handshake хабарламасын алды.
ssl-error-rx-malformed-new-session-ticket = SSL қате New Session Ticket handshake хабарламасын алды.
ssl-error-decompression-failure = SSL тарқатуға келмейтін сығылған жазбаны алды.
ssl-error-renegotiation-not-allowed = Бұл SSL сокетінде сөйлесуді қайта бастауға рұқсат жоқ.
ssl-error-unsafe-negotiation = Торап ескіше түрдегі (сындыруға келетін) handshake хабарламасын жіберген.
ssl-error-rx-unexpected-uncompressed-record = SSL күтілмеген сығылмаған жазбаны алды.
ssl-error-weak-server-ephemeral-dh-key = SSL әлсіз эфемерді Diffie-Hellman кіштін Server Key Exchange қол алысу хабарламасы кезінде алды.
ssl-error-next-protocol-data-invalid = SSL NPN кеңейтуінің қате мәліметін алды.
ssl-error-feature-not-supported-for-ssl2 = SSL мүмкіндігіне SSL 2.0 байланыстары үшін қолдау жоқ.
ssl-error-feature-not-supported-for-servers = SSL мүмкіндігі серверлер үшін қолдау жоқ.
ssl-error-feature-not-supported-for-clients = SSL мүмкіндігі клиенттер үшін қолдау жоқ.
ssl-error-invalid-version-range = SSL нұсқалар ауқымы қате.
ssl-error-cipher-disallowed-for-version = SSL торабы таңдалған хаттама нұсқасы үшін рұқсат етілмеген шифрларды таңдады.
ssl-error-rx-malformed-hello-verify-request = SSL жарамсыз Hello Verify Request handshake сұранымын алды.
ssl-error-rx-unexpected-hello-verify-request = SSL күтпеген Hello Verify Request handshake сұранымын алды.
ssl-error-feature-not-supported-for-version = SSL мүмкіндігіне хаттама нұсқасында қолдау жоқ.
ssl-error-rx-unexpected-cert-status = SSL күтпеген Certificate Request байланысын орнату сұранымын алды.
ssl-error-unsupported-hash-algorithm = TLS торабы қолданатын хэш алгоритміне қолдау жоқ.
ssl-error-digest-failure = Дайджест функциясы сәтсіз аяқталды.
ssl-error-incorrect-signature-algorithm = Цифрлы қолтаңбасы бар элементінің қолтаңба алгоритмі дұрыс емес.
ssl-error-next-protocol-no-callback = Келесі хаттаманы орнату кеңейтуі іске қосылған, бірақ, кері шақыру қолданғанға дейін өшірілді.
ssl-error-next-protocol-no-protocol = Клиент ALPN кеңейтуінде жазылған хаттамалардың ешбіреуін сервер қолдамайды.
ssl-error-inappropriate-fallback-alert = Сервер байланысты орнату сұранымын тайдырды, өйткені клиенттің сұраған TLS нұсқасы сервер қолдайтын нұсқасынан кіші болып тұр.
ssl-error-weak-server-cert-key = Сервер сертификаты публикалық кілті тым әлсіз болып тұрған сертификатты ұсынған.
ssl-error-rx-short-dtls-read = DTLS жазбасы үшін буферде орын жеткіліксіз.
ssl-error-no-supported-signature-algorithm = Бірде-бір қолдауы бар TLS қолтаңба алгоритмі бапталмаған.
ssl-error-unsupported-signature-algorithm = Торап қолдауы жоқ қолтаңба және хэш алгоритмдер жұбын қолданған.
ssl-error-missing-extended-master-secret = Торап жарамды extended_master_secret кеңейтусіз жалғастыру талабын жасаған.
ssl-error-unexpected-extended-master-secret = Торап күтілмеген extended_master_secret кеңейтуімен жалғастыру талабын жасаған.
sec-error-io = Қауіпсіз авторизация кезінде Е/Ш қатесі кеткен.
sec-error-library-failure = қауіпсіздік жинақ қатесі.
sec-error-bad-data = қауіпсіздік жинақ қатесі: қате мәліметтер алынды.
sec-error-output-len = қауіпсіздік жинақ қатесі: нәтиженің ұзындығы қате.
sec-error-input-len = қауіпсіздік жинағының енгізілген мәліметтер ұзындығы қате.
sec-error-invalid-args = қауіпсіздік жинақ қатесі: аргументтер қате.
sec-error-invalid-algorithm = қауіпсіздік жинақ қатесі: алгоритм қате.
sec-error-invalid-ava = қауіпсіздік жинақ қатесі: AVA қате.
sec-error-invalid-time = Уақыт мәні пішімі қате.
sec-error-bad-der = қауіпсіздік жинақ қатесі: қате пішімделген DER-кодталудағы хабарлама.
sec-error-bad-signature = Торап сертификатының қолтаңбасы қате.
sec-error-expired-certificate = Торап сертификатының мерзімі біткен.
sec-error-revoked-certificate = Торап сертификаты қайта шақырылды.
sec-error-unknown-issuer = Торап сертификатының шығарушысы анықталмады.
sec-error-bad-key = Тораптың ашық кілті қате.
sec-error-bad-password = Енгізілген пароль қате.
sec-error-retry-password = Жаңа пароль қате енгізілді. Қайталап көріңіз.
sec-error-no-nodelock = қауіпсіздік жинақ қатесі: nodelock жоқ.
sec-error-bad-database = қауіпсіздік жинақ қатесі: дерекқор қате.
sec-error-no-memory = қауіпсіздік жинақ қатесі: жады бөлу қатесі.
sec-error-untrusted-issuer = Пайдаланушы торап сертификатын шағарушысына сенбейді.
sec-error-untrusted-cert = Пайдаланушы торап сертификатына сенбейді.
sec-error-duplicate-cert = Бұл сертификат сіздің мәліметтер қорыңызда бар болып тұр.
sec-error-duplicate-cert-name = Жүктеліп алынған сертификат аты бар болып тұрған біреуіне сәйкес.
sec-error-adding-cert = Серификатты қорыңызға қосу қатемен аяқталды.
sec-error-filing-key = Осы сертификат үшін кілтті қайта толтырғанда қате кетті.
sec-error-no-key = Осы сертификат үшін жеке кілт кілт дерекқорынан табылмады.
sec-error-cert-valid = Бұл сертификат дұрыс.
sec-error-cert-not-valid = Бұл сертификат дұрыс емес.
sec-error-cert-no-response = Сертификаттар жинағы: Жауап жоқ.
sec-error-expired-issuer-certificate = Сертификатты шығарушының сертификат мерзімі біткен. Өзіңіздің жүйе уақытын тексеріңіз.
sec-error-crl-expired = Осы сертификат үшін CRL мерзімі біткен. Оны жаңартыңыз, немесе жүйеңіздің уақытын тексеріңіз.
sec-error-crl-bad-signature = Осы сертификат үшін CRL қолтаңбасы қате.
sec-error-crl-invalid = Жаңа CRL пішімі қате.
sec-error-extension-value-invalid = Сертификат кеңейтілуі қате.
sec-error-extension-not-found = Сертификат кеңейтілуі табылмады.
sec-error-ca-cert-invalid = Шығарушы сертификаты қате.
sec-error-path-len-constraint-invalid = Сертификат жолының бөгеті қате.
sec-error-cert-usages-invalid = Сертификатты қолдану жолдары қате.
sec-internal-only = **ТЕК ішкі модуль**
sec-error-invalid-key = Кілт сұранған операцияны қолдамайды.
sec-error-unknown-critical-extension = Сертификат ішінде белгісіз маңызды кеңейту бар.
sec-error-old-crl = Жаңа CRL ағымдағы нұсқажан кейін шыққан емес.
sec-error-no-email-cert = Шифрленбеген немесе қолтаңба қойылмаған: сізде әлі электронды пошта сертификаты жоқ.
sec-error-no-recipient-certs-query = Шифрленбеген: сізде алушылардың әрқайсысы үшін сертификат жоқ.
sec-error-not-a-recipient = Декодалау мүмкін емес: сіз алушы емессіз, немесе сәйкес келетін сертификат не кілт табылмады.
sec-error-pkcs7-keyalg-mismatch = Декодалау мүмкін емес: кілт шіфрлеу алгоритмі сіздің сертификатыңызға сәйкес келмейді.
sec-error-pkcs7-bad-signature = Қолтаңба верификация қатесі: қолтаңба қоюшы табылмады, немесе олар өте көп, немесе алынған мәлімет дұрыс емес не зақымдалған.
sec-error-unsupported-keyalg = Кілт алгоритмі белгісіз, немесе оған қолдау жоқ.
sec-error-decryption-disallowed = Декодалау мүмкін емес: шифрлеу қолданып тұрған алгоритміне не кілт ұзындығына рұқсат жоқ.
xp-sec-fortezza-bad-card = Fortezza card дұрыс жасалмады. Оны алып тастап, шығарушысына қайтарыңыз.
xp-sec-fortezza-no-card = Бірде-бір Fortezza картасы табылмады
xp-sec-fortezza-none-selected = Бірде-бір Fortezza картасы ерекшеленбеді
xp-sec-fortezza-more-info = Көбірек білу үшін personality таңдаңыз
xp-sec-fortezza-person-not-found = Personality табылмады
xp-sec-fortezza-no-more-info = Осы Personality туралы ақпарат жоқ
xp-sec-fortezza-bad-pin = Pin қате
xp-sec-fortezza-person-error = Fortezza personalities іске қосу мүмкін емес.
sec-error-no-krl = Осы сайт сертификаты үшін бірде-бір KRL табылмады.
sec-error-krl-expired = Осы сайт сертификатының KRL мерзімі өткен.
sec-error-krl-bad-signature = Осы сайт сертификатының KRL қолтаңбасы қате.
sec-error-revoked-key = Осы сайт сертификатының кілті қайта шақырылған.
sec-error-krl-invalid = Жаңа KRL пішімі қате.
sec-error-need-random = қауіпсіздік жинағы: кездейсоқ мәліметтер керек.
sec-error-no-module = қауіпсіздік жинағы: сұраған операцияны орындайтын модуль жоқ.
sec-error-no-token = Қауіпсіздік картасы немесе токен жоқ, іске қосылмаған немесе өшірілген.
sec-error-read-only = қауіпсіздік жинағы: деррекқор тек оқу үшін қалпында.
sec-error-no-slot-selected = Бірде-бір слот не токен таңдалмаған.
sec-error-cert-nickname-collision = Қысқаша аты сәйкес келетін сертификат бар болып тұр.
sec-error-key-nickname-collision = Қысқаша аты сәйкес келетін кілтр болып тұр.
sec-error-safe-not-created = қауіпсіз объектті жасау қатесі
sec-error-baggage-not-created = багаж объектін жасау қатесі
xp-java-remove-principal-error = Principal өшіру мүмкін емес
xp-java-delete-privilege-error = Privilege өшіру мүмкін емес
xp-java-cert-not-exists-error = Осы principal сертификаты жоқ
sec-error-bad-export-algorithm = Керек алгоритмге рұқсат жоқ.
sec-error-exporting-certificates = Сертфикаттарды экспорттау сәтсіз аяқталды.
sec-error-importing-certificates = Сертфикаттарды импорттау сәтсіз аяқталды.
sec-error-pkcs12-decoding-pfx = Импорттау мүмкін емес. Декодтау қатесі. Файл дұрыс емес.
sec-error-pkcs12-invalid-mac = Импорттау мүмкін емес. MAC қате. Пароль қате не файл зақымданған.
sec-error-pkcs12-unsupported-mac-algorithm = Импорттау мүмкін емес. MAC алгоритміне қолдау жоқ.
sec-error-pkcs12-unsupported-transport-mode = Импорттау мүмкін емес. Тек паролдің бүтіндігін тексеру мен жекелік режимдеріне қолдау бар.
sec-error-pkcs12-corrupt-pfx-structure = Импорттау мүмкін емес. Файл құрамасы зақымдалған.
sec-error-pkcs12-unsupported-pbe-algorithm = Импорттау мүмкін емес. Шифрлеу алгоритміне қолдау жоқ.
sec-error-pkcs12-unsupported-version = Импорттау мүмкін емес. Файл нұсқасына қолдау жоқ.
sec-error-pkcs12-privacy-password-incorrect = Импорттау мүмкін емес. Жекелік паролі қате.
sec-error-pkcs12-cert-collision = Импорттау мүмкін емес. Ондай никнейм дерекқорда бар болып тұр.
sec-error-user-cancelled = Пайдаланушы Бас тарту тандаған.
sec-error-pkcs12-duplicate-data = Импортталмады, дерекқорда бар болып тұр.
sec-error-message-send-aborted = Хабарлама жіберілмеді.
sec-error-inadequate-key-usage = Сұранған операция үшін сертификат кілтін қолдану сәйкес келмейді.
sec-error-inadequate-cert-type = Сертификат түрі қолдануға бекітілмеген.
sec-error-cert-addr-mismatch = Қолтаңба қойылатын сертификаттың адрес мәні хабарламадағы адресіне сәйкес келмейді.
sec-error-pkcs12-unable-to-import-key = Импорттау мүмкін емес. Жеке кілтті импорттау қатемен аяқталды.
sec-error-pkcs12-importing-cert-chain = Импорттау мүмкін емес. Сертификаттар тобын импортау кезінде қате кетті.
sec-error-pkcs12-unable-to-locate-object-by-name = Импорттау мүмкін емес. Никнейм арқылы сертификатты не кілтті табу мүмкін емес.
sec-error-pkcs12-unable-to-export-key = Экспорттау мүмкін емес. Жеке кілтті табу және экспорттау мүмкін емес.
sec-error-pkcs12-unable-to-write = Экспорттау мүмкін емес. Экспортталатын файлға жазу мүмкін емес.
sec-error-pkcs12-unable-to-read = Импорттау мүмкін емес. Импортталатын файлды оқу мүмкін емес.
sec-error-pkcs12-key-database-not-initialized = Экспорт мүмкін емес. Кілттер дерекқоры зақымдалған немесе өшірілген.
sec-error-keygen-fail = Ашық/жеке кілттер жұбын жасау мүмкін емес.
sec-error-invalid-password = Енгізілген пароль қате. Басқасын енгізіңіз.
sec-error-retry-old-password = Ескі пароль қате енгізілді. Қайталап көріңіз.
sec-error-bad-nickname = Сертификаттың қысқаша аты қолданылуда.
sec-error-not-fortezza-issuer = FORTEZZA тбының торабы FORTEZZA-емес сертификатқа ие.
sec-error-cannot-move-sensitive-key = Сезгіш кілт керек болған кезде слот ішіне ауыстырылмайды.
sec-error-js-invalid-module-name = Модульдің аты қате.
sec-error-js-invalid-dll = Модульдің аты/орналасқан жері қате көрсетілген.
sec-error-js-add-mod-failure = Модульді қосу мүмкін емес
sec-error-js-del-mod-failure = Модульді өшіру мүмкін емес
sec-error-old-krl = Жаңа KRL ағымдағы нұсқадан кеш емес.
sec-error-ckl-conflict = Жаңа CKL шығарушысы ағымдағы CKL шығарушысынан басқа. Ағымдағы CKL өшіріңіз.
sec-error-cert-not-in-name-space = Осы сертификат үшін CA өз атымен сертификаттарды растауға құқығы жоқ.
sec-error-krl-not-yet-valid = Осы сертификат үшін кілтерді қайта шақыру тізімінің мерзімі әлі басталмады.
sec-error-crl-not-yet-valid = Осы сертификат үшін сертификаттарда қайта шақыру тізімінің мерзімі әлі басталмады.
sec-error-unknown-cert = Сұралған сертификат табылмады.
sec-error-unknown-signer = Қолтаңба қоюшысының сертификатын табу мүмкін емес.
sec-error-cert-bad-access-location = Осы сертификаттар күйі серверінің мекен-жай пішімі қате.
sec-error-ocsp-unknown-response-type = OCSP жауабы толығымен декодаланбайды; оның түрі белгісіз.
sec-error-ocsp-bad-http-response = OCSP-сервері  күтпеген/қате HTTP мәліметтерін қайтарды.
sec-error-ocsp-malformed-request = OCSP-сервері сұранымды зақымдалған не дұрыс пішімделмеген деп санады.
sec-error-ocsp-server-error = OCSP-сервері өзінің ішкі қатесі туралы хабарлайды.
sec-error-ocsp-try-server-later = OCSP-сервері кейінірек қайталап көруді ұсынады.
sec-error-ocsp-request-needs-sig = OCSP сервері бұл сұраным үшін қолтаңба сұрайды.
sec-error-ocsp-unauthorized-request = OCSP сервері бұл сұранымды авторизацияланбаған деп үзді.
sec-error-ocsp-unknown-response-status = OCSP сервері түсініксіз күйді қайтарды.
sec-error-ocsp-unknown-cert = OCSP серверінің бұл сертификат үшін ақпарат жоқ.
sec-error-ocsp-not-enabled = Осы операцияны жалғастыру алдында OCSP қосуыңыз керек.
sec-error-ocsp-no-default-responder = Осы операцияны жалғастырар алдында негізгі OCSP серверді таңдауыңыз керек.
sec-error-ocsp-malformed-response = OCSP сервері қайтарған жауап зақымдалған, немесе дұрыс құрылмаған.
sec-error-ocsp-unauthorized-response = OCSP жауабын қайтарған осы сертификатты растауға құқығы жоқ.
sec-error-ocsp-future-response = OCSP жауабы қазір істемейді (оның уақыты әлі келмеді).
sec-error-ocsp-old-response = OCSP жауабы ішнде мерзімі аяқталған ақпараты бар.
sec-error-digest-not-found = Қолтаңаба қойылған хабарламада CMS немесе PKCS #7 Digest табылмады.
sec-error-unsupported-message-type = CMS немесе PKCS #7 хабарлама түріне қолдау жоқ.
sec-error-module-stuck = PKCS #11 модулін өшіру мүмкін емес, өйткені ол әлі қолдануда.
sec-error-bad-template = ASN.1 мәліметтерін декодалау қатесі. Көрсетілген шаблон табылмады.
sec-error-crl-not-found = Сәйкес CRL табылмады.
sec-error-reused-issuer-and-serial = Сіз қазір бар болып тұрған сертификаттың сериялық нөмірі мен шығарушысы сәйкес келетін бір сертификатты импорттауды таңдадыңыз, бірақ ол сол сертификат емес.
sec-error-busy = NSS өшіру мүмкін емес. Кейбір объектілер әлі қолданылуда.
sec-error-extra-input = DER-кодаланған хабарламада қолданылмайтын қосымша ақпарат бар.
sec-error-unsupported-elliptic-curve = Эллиптикалық қисыққа қолдау жоқ.
sec-error-unsupported-ec-point-form = Эллиптикалық қисық нүктесінің пішіміне қолдау жоқ.
sec-error-unrecognized-oid = Анықталмаған Object Identifier.
sec-error-ocsp-invalid-signing-cert = OCSP жауабындағы OCSP қолтаңба сертификаты қате.
sec-error-revoked-certificate-crl = Осы сертификат шығарушысының сертификаттарды қайта шақыру тізімінде қайта шақырылған.
sec-error-revoked-certificate-ocsp = Шығарушының OCSP сервері сертификат қайта шақырылған деп хабарлады.
sec-error-crl-invalid-version = Шығарушының сертификаттарды қайта шақыру тізімінің сериялық нөмірі белгісіз.
sec-error-crl-v1-critical-extension = Шығарушының сертификаттарды V1 қайта шақыру тізімінің ішінде маңызды кеңейту бар.
sec-error-crl-unknown-critical-extension = Шығарушының сертификаттарды V2 қайта шақыру тізімінің ішінде белгісіз маңызды кеңейту бар.
sec-error-unknown-object-type = Ұсынылған объект түрі белгісіз.
sec-error-incompatible-pkcs11 = PKCS #11 драйвері спецификацияны бұзып тұр.
sec-error-no-event = Қазір жаңа слот оқиғалары жоқ.
sec-error-crl-already-exists = CRL бар болып тұр.
sec-error-not-initialized = NSS инициализацияланбаған.
sec-error-token-not-logged-in = PKCS#11 токені қосылмаған себебінен операция қатемен аяқталды.
sec-error-ocsp-responder-cert-invalid = OCSP серверінің бапталған сертификаты қате.
sec-error-ocsp-bad-signature = OCSP жауабының қолтаңбасы қате.
sec-error-out-of-search-limits = Сертификатты растау іздеулер саны шектен асты
sec-error-invalid-policy-mapping = Policy mapping ішінде anypolicy тұр
sec-error-policy-validation-failed = Сертификаттар тізбергі policy validation өтпеді
sec-error-unknown-aia-location-type = Сертификаттың AIA кеңейтуінде белісіз орналасу түрі
sec-error-bad-http-response = Сервер қате HTTP жауабын қайтарған
sec-error-bad-ldap-response = Сервер қате LDAP жауабын қайтарған
sec-error-failed-to-encode-data = Мәліметті ASN1 декодерімен декодалау сәтсіз
sec-error-bad-info-access-location = Сертификат кеңейтуінде ақпарат рұқсаты орналасуы қате
sec-error-libpkix-internal = Libpkix сертификатты растау кезінде ішкі қатеге жолыққан.
sec-error-pkcs11-general-error = PKCS #11 модулі CKR_GENERAL_ERROR қайтарған, яғни, жөнделмейтін қате орын алды.
sec-error-pkcs11-function-failed = PKCS #11 модулі CKR_FUNCTION_FAILED қайтарған, яғни, сұранған функцияны орындау мүмкін емес. Бұны қайталау сәтті нәтижеге әкелуі мүмкін.
sec-error-pkcs11-device-error = PKCS #11 модулі CKR_DEVICE_ERROR қайтарған, яғни, мәселе токен не слотпен орын алған.
sec-error-bad-info-access-method = Сертификат кеңейтуінде ақпаратқа қатынау тәсілі белгісіз.
sec-error-crl-import-failed = CRL импорттау талабы кезінде қате кетті.
sec-error-expired-password = Парольдің мерзімі аяқталды.
sec-error-locked-password = Пароль блокталған.
sec-error-unknown-pkcs11-error = Белгісіз PKCS #11 қатесі.
sec-error-bad-crl-dp-url = CRL тарату нүктесінің атындағы белгісіз не қолдауы жоқ URL.
sec-error-cert-signature-algorithm-disabled = Сертификатқа қауіпсіз емес болғаны салдарынан сөндірілген алгоритмі көмегімен қолтаңба қойылған.
mozilla-pkix-error-key-pinning-failure = Бұл сервер кілттерді бекітуді (HPKP) қолданады, бірақ, бекітуге сай келетін сенімді сертификатты жасау мүмкін емес. Кілттерді бекітуді бұзуын ережеден тыс қабылдауға болмайды.
mozilla-pkix-error-ca-cert-used-as-end-entity = Бұл сервер негізгі шектеулерді кеңейтетін, сол себептен оны сертификаттау орталығы ретінде анықтайтын сертификатты қолданады. Жарамды сертификаттар үшін осылай болмау тиіс.
mozilla-pkix-error-inadequate-key-size = Бұл сервер қауіпсіз байланысты орнату үшін өлшемі тым аз болып тұрған кілті бар сертификатты қолданады.
mozilla-pkix-error-v1-cert-used-as-ca = Сервер сертификатын шығару үшін сенімді емес X.509 1-нұсқа сертификаты қолданылған. X.509 1-нұсқа сертификаттары ескірген және басқа сертификаттарға қолтаңба қою үшін қолданылмауы тиіс.
mozilla-pkix-error-not-yet-valid-certificate = Сервер әлі жарамсыз болып тұрған сертификатты ұсынған.
mozilla-pkix-error-not-yet-valid-issuer-certificate = Бұл сервердің сертификатын шығару үшін әлі жарамсыз болып тұрған сертификат қолданылған.
mozilla-pkix-error-signature-algorithm-mismatch = Сертификаттың қолтаңба өрісіндегі қолтаңба алгоритмі оның signatureAlgorithm өрісіндегі алгоритмге сәйкес келмейді.
mozilla-pkix-error-ocsp-response-for-cert-missing = OCSP жауабында расталып тұрған сертификаттың қалып-күйі жоқ.
mozilla-pkix-error-validity-too-long = Сервер жарамдылық уақыты тым ұзақ болып тұрған сертификатты ұсынған.
mozilla-pkix-error-required-tls-feature-missing = Міндетті TLS мүмкіндігі жоқ болып тұр.
mozilla-pkix-error-invalid-integer-encoding = Сервер ұсынған сертификатта бүтін санның қате кодталуы кездесті. Жиі себептер: теріс сериялық сандар, теріс RSA модулі, және ұзындығы керек шамадан артатын кодтаулар.
mozilla-pkix-error-empty-issuer-name = Сервер сертификаттау орталығының ажыратылымды аты бос болып келген сертификатпен жауап берген.
mozilla-pkix-error-additional-policy-constraint-failed = Бұл сертификатты растау кезінде қосымша саясат шарты сәтсіз аяқталды.
mozilla-pkix-error-self-signed-cert = Сертификатқа сенім жоқ, өйткені оның қолтаңбасы өздігінен қойылған.
