# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.notify.v1.service.binding import BindingList
from twilio.rest.notify.v1.service.notification import NotificationList


class ServiceList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the ServiceList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.notify.v1.service.ServiceList
        :rtype: twilio.rest.notify.v1.service.ServiceList
        """
        super(ServiceList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Services'.format(**self._solution)

    def create(self, friendly_name=values.unset, apn_credential_sid=values.unset,
               gcm_credential_sid=values.unset, messaging_service_sid=values.unset,
               facebook_messenger_page_id=values.unset,
               default_apn_notification_protocol_version=values.unset,
               default_gcm_notification_protocol_version=values.unset,
               fcm_credential_sid=values.unset,
               default_fcm_notification_protocol_version=values.unset,
               log_enabled=values.unset, alexa_skill_id=values.unset,
               default_alexa_notification_protocol_version=values.unset,
               delivery_callback_url=values.unset,
               delivery_callback_enabled=values.unset):
        """
        Create the ServiceInstance

        :param unicode friendly_name: A string to describe the resource
        :param unicode apn_credential_sid: The SID of the Credential to use for APN Bindings
        :param unicode gcm_credential_sid: The SID of the Credential to use for GCM Bindings
        :param unicode messaging_service_sid: The SID of the Messaging Service to use for SMS Bindings
        :param unicode facebook_messenger_page_id: Deprecated
        :param unicode default_apn_notification_protocol_version: The protocol version to use for sending APNS notifications
        :param unicode default_gcm_notification_protocol_version: The protocol version to use for sending GCM notifications
        :param unicode fcm_credential_sid: The SID of the Credential to use for FCM Bindings
        :param unicode default_fcm_notification_protocol_version: The protocol version to use for sending FCM notifications
        :param bool log_enabled: Whether to log notifications
        :param unicode alexa_skill_id: Deprecated
        :param unicode default_alexa_notification_protocol_version: Deprecated
        :param unicode delivery_callback_url: Webhook URL
        :param bool delivery_callback_enabled: Enable delivery callbacks

        :returns: The created ServiceInstance
        :rtype: twilio.rest.notify.v1.service.ServiceInstance
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'ApnCredentialSid': apn_credential_sid,
            'GcmCredentialSid': gcm_credential_sid,
            'MessagingServiceSid': messaging_service_sid,
            'FacebookMessengerPageId': facebook_messenger_page_id,
            'DefaultApnNotificationProtocolVersion': default_apn_notification_protocol_version,
            'DefaultGcmNotificationProtocolVersion': default_gcm_notification_protocol_version,
            'FcmCredentialSid': fcm_credential_sid,
            'DefaultFcmNotificationProtocolVersion': default_fcm_notification_protocol_version,
            'LogEnabled': log_enabled,
            'AlexaSkillId': alexa_skill_id,
            'DefaultAlexaNotificationProtocolVersion': default_alexa_notification_protocol_version,
            'DeliveryCallbackUrl': delivery_callback_url,
            'DeliveryCallbackEnabled': delivery_callback_enabled,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return ServiceInstance(self._version, payload, )

    def stream(self, friendly_name=values.unset, limit=None, page_size=None):
        """
        Streams ServiceInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param unicode friendly_name: The string that identifies the Service resources to read
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.notify.v1.service.ServiceInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(friendly_name=friendly_name, page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, friendly_name=values.unset, limit=None, page_size=None):
        """
        Lists ServiceInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param unicode friendly_name: The string that identifies the Service resources to read
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.notify.v1.service.ServiceInstance]
        """
        return list(self.stream(friendly_name=friendly_name, limit=limit, page_size=page_size, ))

    def page(self, friendly_name=values.unset, page_token=values.unset,
             page_number=values.unset, page_size=values.unset):
        """
        Retrieve a single page of ServiceInstance records from the API.
        Request is executed immediately

        :param unicode friendly_name: The string that identifies the Service resources to read
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of ServiceInstance
        :rtype: twilio.rest.notify.v1.service.ServicePage
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return ServicePage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of ServiceInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of ServiceInstance
        :rtype: twilio.rest.notify.v1.service.ServicePage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return ServicePage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a ServiceContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.notify.v1.service.ServiceContext
        :rtype: twilio.rest.notify.v1.service.ServiceContext
        """
        return ServiceContext(self._version, sid=sid, )

    def __call__(self, sid):
        """
        Constructs a ServiceContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.notify.v1.service.ServiceContext
        :rtype: twilio.rest.notify.v1.service.ServiceContext
        """
        return ServiceContext(self._version, sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Notify.V1.ServiceList>'


class ServicePage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the ServicePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.notify.v1.service.ServicePage
        :rtype: twilio.rest.notify.v1.service.ServicePage
        """
        super(ServicePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ServiceInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.notify.v1.service.ServiceInstance
        :rtype: twilio.rest.notify.v1.service.ServiceInstance
        """
        return ServiceInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Notify.V1.ServicePage>'


class ServiceContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, sid):
        """
        Initialize the ServiceContext

        :param Version version: Version that contains the resource
        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.notify.v1.service.ServiceContext
        :rtype: twilio.rest.notify.v1.service.ServiceContext
        """
        super(ServiceContext, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/Services/{sid}'.format(**self._solution)

        # Dependents
        self._bindings = None
        self._notifications = None

    def delete(self):
        """
        Deletes the ServiceInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def fetch(self):
        """
        Fetch the ServiceInstance

        :returns: The fetched ServiceInstance
        :rtype: twilio.rest.notify.v1.service.ServiceInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return ServiceInstance(self._version, payload, sid=self._solution['sid'], )

    def update(self, friendly_name=values.unset, apn_credential_sid=values.unset,
               gcm_credential_sid=values.unset, messaging_service_sid=values.unset,
               facebook_messenger_page_id=values.unset,
               default_apn_notification_protocol_version=values.unset,
               default_gcm_notification_protocol_version=values.unset,
               fcm_credential_sid=values.unset,
               default_fcm_notification_protocol_version=values.unset,
               log_enabled=values.unset, alexa_skill_id=values.unset,
               default_alexa_notification_protocol_version=values.unset,
               delivery_callback_url=values.unset,
               delivery_callback_enabled=values.unset):
        """
        Update the ServiceInstance

        :param unicode friendly_name: A string to describe the resource
        :param unicode apn_credential_sid: The SID of the Credential to use for APN Bindings
        :param unicode gcm_credential_sid: The SID of the Credential to use for GCM Bindings
        :param unicode messaging_service_sid: The SID of the Messaging Service to use for SMS Bindings
        :param unicode facebook_messenger_page_id: Deprecated
        :param unicode default_apn_notification_protocol_version: The protocol version to use for sending APNS notifications
        :param unicode default_gcm_notification_protocol_version: The protocol version to use for sending GCM notifications
        :param unicode fcm_credential_sid: The SID of the Credential to use for FCM Bindings
        :param unicode default_fcm_notification_protocol_version: The protocol version to use for sending FCM notifications
        :param bool log_enabled: Whether to log notifications
        :param unicode alexa_skill_id: Deprecated
        :param unicode default_alexa_notification_protocol_version: Deprecated
        :param unicode delivery_callback_url: Webhook URL
        :param bool delivery_callback_enabled: Enable delivery callbacks

        :returns: The updated ServiceInstance
        :rtype: twilio.rest.notify.v1.service.ServiceInstance
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'ApnCredentialSid': apn_credential_sid,
            'GcmCredentialSid': gcm_credential_sid,
            'MessagingServiceSid': messaging_service_sid,
            'FacebookMessengerPageId': facebook_messenger_page_id,
            'DefaultApnNotificationProtocolVersion': default_apn_notification_protocol_version,
            'DefaultGcmNotificationProtocolVersion': default_gcm_notification_protocol_version,
            'FcmCredentialSid': fcm_credential_sid,
            'DefaultFcmNotificationProtocolVersion': default_fcm_notification_protocol_version,
            'LogEnabled': log_enabled,
            'AlexaSkillId': alexa_skill_id,
            'DefaultAlexaNotificationProtocolVersion': default_alexa_notification_protocol_version,
            'DeliveryCallbackUrl': delivery_callback_url,
            'DeliveryCallbackEnabled': delivery_callback_enabled,
        })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return ServiceInstance(self._version, payload, sid=self._solution['sid'], )

    @property
    def bindings(self):
        """
        Access the bindings

        :returns: twilio.rest.notify.v1.service.binding.BindingList
        :rtype: twilio.rest.notify.v1.service.binding.BindingList
        """
        if self._bindings is None:
            self._bindings = BindingList(self._version, service_sid=self._solution['sid'], )
        return self._bindings

    @property
    def notifications(self):
        """
        Access the notifications

        :returns: twilio.rest.notify.v1.service.notification.NotificationList
        :rtype: twilio.rest.notify.v1.service.notification.NotificationList
        """
        if self._notifications is None:
            self._notifications = NotificationList(self._version, service_sid=self._solution['sid'], )
        return self._notifications

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Notify.V1.ServiceContext {}>'.format(context)


class ServiceInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, payload, sid=None):
        """
        Initialize the ServiceInstance

        :returns: twilio.rest.notify.v1.service.ServiceInstance
        :rtype: twilio.rest.notify.v1.service.ServiceInstance
        """
        super(ServiceInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'account_sid': payload.get('account_sid'),
            'friendly_name': payload.get('friendly_name'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'apn_credential_sid': payload.get('apn_credential_sid'),
            'gcm_credential_sid': payload.get('gcm_credential_sid'),
            'fcm_credential_sid': payload.get('fcm_credential_sid'),
            'messaging_service_sid': payload.get('messaging_service_sid'),
            'facebook_messenger_page_id': payload.get('facebook_messenger_page_id'),
            'default_apn_notification_protocol_version': payload.get('default_apn_notification_protocol_version'),
            'default_gcm_notification_protocol_version': payload.get('default_gcm_notification_protocol_version'),
            'default_fcm_notification_protocol_version': payload.get('default_fcm_notification_protocol_version'),
            'log_enabled': payload.get('log_enabled'),
            'url': payload.get('url'),
            'links': payload.get('links'),
            'alexa_skill_id': payload.get('alexa_skill_id'),
            'default_alexa_notification_protocol_version': payload.get('default_alexa_notification_protocol_version'),
            'delivery_callback_url': payload.get('delivery_callback_url'),
            'delivery_callback_enabled': payload.get('delivery_callback_enabled'),
        }

        # Context
        self._context = None
        self._solution = {'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: ServiceContext for this ServiceInstance
        :rtype: twilio.rest.notify.v1.service.ServiceContext
        """
        if self._context is None:
            self._context = ServiceContext(self._version, sid=self._solution['sid'], )
        return self._context

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def friendly_name(self):
        """
        :returns: The string that you assigned to describe the resource
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def apn_credential_sid(self):
        """
        :returns: The SID of the Credential to use for APN Bindings
        :rtype: unicode
        """
        return self._properties['apn_credential_sid']

    @property
    def gcm_credential_sid(self):
        """
        :returns: The SID of the Credential to use for GCM Bindings
        :rtype: unicode
        """
        return self._properties['gcm_credential_sid']

    @property
    def fcm_credential_sid(self):
        """
        :returns: The SID of the Credential to use for FCM Bindings
        :rtype: unicode
        """
        return self._properties['fcm_credential_sid']

    @property
    def messaging_service_sid(self):
        """
        :returns: The SID of the Messaging Service to use for SMS Bindings
        :rtype: unicode
        """
        return self._properties['messaging_service_sid']

    @property
    def facebook_messenger_page_id(self):
        """
        :returns: Deprecated
        :rtype: unicode
        """
        return self._properties['facebook_messenger_page_id']

    @property
    def default_apn_notification_protocol_version(self):
        """
        :returns: The protocol version to use for sending APNS notifications
        :rtype: unicode
        """
        return self._properties['default_apn_notification_protocol_version']

    @property
    def default_gcm_notification_protocol_version(self):
        """
        :returns: The protocol version to use for sending GCM notifications
        :rtype: unicode
        """
        return self._properties['default_gcm_notification_protocol_version']

    @property
    def default_fcm_notification_protocol_version(self):
        """
        :returns: The protocol version to use for sending FCM notifications
        :rtype: unicode
        """
        return self._properties['default_fcm_notification_protocol_version']

    @property
    def log_enabled(self):
        """
        :returns: Whether to log notifications
        :rtype: bool
        """
        return self._properties['log_enabled']

    @property
    def url(self):
        """
        :returns: The absolute URL of the Service resource
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def links(self):
        """
        :returns: The URLs of the resources related to the service
        :rtype: unicode
        """
        return self._properties['links']

    @property
    def alexa_skill_id(self):
        """
        :returns: Deprecated
        :rtype: unicode
        """
        return self._properties['alexa_skill_id']

    @property
    def default_alexa_notification_protocol_version(self):
        """
        :returns: Deprecated
        :rtype: unicode
        """
        return self._properties['default_alexa_notification_protocol_version']

    @property
    def delivery_callback_url(self):
        """
        :returns: Webhook URL
        :rtype: unicode
        """
        return self._properties['delivery_callback_url']

    @property
    def delivery_callback_enabled(self):
        """
        :returns: Enable delivery callbacks
        :rtype: bool
        """
        return self._properties['delivery_callback_enabled']

    def delete(self):
        """
        Deletes the ServiceInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def fetch(self):
        """
        Fetch the ServiceInstance

        :returns: The fetched ServiceInstance
        :rtype: twilio.rest.notify.v1.service.ServiceInstance
        """
        return self._proxy.fetch()

    def update(self, friendly_name=values.unset, apn_credential_sid=values.unset,
               gcm_credential_sid=values.unset, messaging_service_sid=values.unset,
               facebook_messenger_page_id=values.unset,
               default_apn_notification_protocol_version=values.unset,
               default_gcm_notification_protocol_version=values.unset,
               fcm_credential_sid=values.unset,
               default_fcm_notification_protocol_version=values.unset,
               log_enabled=values.unset, alexa_skill_id=values.unset,
               default_alexa_notification_protocol_version=values.unset,
               delivery_callback_url=values.unset,
               delivery_callback_enabled=values.unset):
        """
        Update the ServiceInstance

        :param unicode friendly_name: A string to describe the resource
        :param unicode apn_credential_sid: The SID of the Credential to use for APN Bindings
        :param unicode gcm_credential_sid: The SID of the Credential to use for GCM Bindings
        :param unicode messaging_service_sid: The SID of the Messaging Service to use for SMS Bindings
        :param unicode facebook_messenger_page_id: Deprecated
        :param unicode default_apn_notification_protocol_version: The protocol version to use for sending APNS notifications
        :param unicode default_gcm_notification_protocol_version: The protocol version to use for sending GCM notifications
        :param unicode fcm_credential_sid: The SID of the Credential to use for FCM Bindings
        :param unicode default_fcm_notification_protocol_version: The protocol version to use for sending FCM notifications
        :param bool log_enabled: Whether to log notifications
        :param unicode alexa_skill_id: Deprecated
        :param unicode default_alexa_notification_protocol_version: Deprecated
        :param unicode delivery_callback_url: Webhook URL
        :param bool delivery_callback_enabled: Enable delivery callbacks

        :returns: The updated ServiceInstance
        :rtype: twilio.rest.notify.v1.service.ServiceInstance
        """
        return self._proxy.update(
            friendly_name=friendly_name,
            apn_credential_sid=apn_credential_sid,
            gcm_credential_sid=gcm_credential_sid,
            messaging_service_sid=messaging_service_sid,
            facebook_messenger_page_id=facebook_messenger_page_id,
            default_apn_notification_protocol_version=default_apn_notification_protocol_version,
            default_gcm_notification_protocol_version=default_gcm_notification_protocol_version,
            fcm_credential_sid=fcm_credential_sid,
            default_fcm_notification_protocol_version=default_fcm_notification_protocol_version,
            log_enabled=log_enabled,
            alexa_skill_id=alexa_skill_id,
            default_alexa_notification_protocol_version=default_alexa_notification_protocol_version,
            delivery_callback_url=delivery_callback_url,
            delivery_callback_enabled=delivery_callback_enabled,
        )

    @property
    def bindings(self):
        """
        Access the bindings

        :returns: twilio.rest.notify.v1.service.binding.BindingList
        :rtype: twilio.rest.notify.v1.service.binding.BindingList
        """
        return self._proxy.bindings

    @property
    def notifications(self):
        """
        Access the notifications

        :returns: twilio.rest.notify.v1.service.notification.NotificationList
        :rtype: twilio.rest.notify.v1.service.notification.NotificationList
        """
        return self._proxy.notifications

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Notify.V1.ServiceInstance {}>'.format(context)
