[comment {-*- text -*- doctools manpage}]
[vset VERSION 1]
[manpage_begin fileutil::paths n [vset VERSION]]
[titledesc {Manage search path pools}]
[require Tcl 8.4]
[require fileutil::paths [opt [vset VERSION]]]
[description]

Provides a snit class whose instances manage a pool of (search) paths.

[section API]

The main command provides construction of search path pools:

[list_begin definitions]

[call [cmd ::fileutil::paths] [arg poolName]]

Creates a new, empty pool of search paths with an associated global
Tcl command whose name is [arg poolName].

It may be used to invoke various operations on the pool.

It has the following general form:

[list_begin definitions]
[call [cmd poolName] [method method] [opt [arg "arg arg ..."]]]
[method method] and [arg arg]uments determine the exact behavior of
the command.
[list_end][comment --instance-command--]

If [arg poolName] is specified as [const %AUTO%] a unique name will be
generated by the package itself.

The result of the command is the fully-qualified name of the instance
command. 

[list_end][comment --class-command--]

[para]

The following commands are possible for pool objects:

[list_begin definitions]

[call [arg poolName] [method add] [arg path]]

Adds the [arg path] to the pool.

Nothing is done if the [arg path] is already known to the pool.

The result of the command is the empty string.

[call [arg poolName] [method clear]]

Clears the entire pool. In other words, removes all paths from it.

The result of the command is the empty string.

[call [arg poolName] [method paths]]

Returns the list of all paths known to the pool, in the order they
were added.

[call [arg poolName] [method remove] [arg path]]

Removes the [arg path] from the pool, if it is known to the pool.

Unknown paths are ignored without error.

The result of the command is the empty string.

[list_end]

[include ../common-text/feedback.inc]
[manpage_end]
