% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timespans.r, R/intervals.r
\name{time_length}
\alias{time_length}
\alias{time_length,Interval-method}
\title{Compute the exact length of a time span}
\usage{
time_length(x, unit = "second")

\S4method{time_length}{Interval}(x, unit = "second")
}
\arguments{
\item{x}{a duration, period, difftime or interval}

\item{unit}{a character string that specifies with time units to use}
}
\value{
the length of the interval in the specified unit. A negative number
connotes a negative interval or duration
}
\description{
Compute the exact length of a time span
}
\details{
When \code{x} is an \linkS4class{Interval} object and
\code{unit} are years or months, \code{time_length()} takes into account
the fact that all months and years don't have the same number of days.

When \code{x} is a \linkS4class{Duration}, \linkS4class{Period}
or \code{\link[=difftime]{difftime()}} object, length in months or years is based on their
most common lengths in seconds (see \code{\link[=timespan]{timespan()}}).
}
\examples{
int <- interval(ymd("1980-01-01"), ymd("2014-09-18"))
time_length(int, "week")

# Exact age
time_length(int, "year")

# Age at last anniversary
trunc(time_length(int, "year"))

# Example of difference between intervals and durations
int <- interval(ymd("1900-01-01"), ymd("1999-12-31"))
time_length(int, "year")
time_length(as.duration(int), "year")
}
\seealso{
\code{\link[=timespan]{timespan()}}
}
\keyword{chron}
\keyword{math}
\keyword{methods}
\keyword{period}
