# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.domain import Domain
from twilio.rest.autopilot.v1 import V1


class Autopilot(Domain):

    def __init__(self, twilio):
        """
        Initialize the Autopilot Domain

        :returns: Domain for Autopilot
        :rtype: twilio.rest.autopilot.Autopilot
        """
        super(Autopilot, self).__init__(twilio)

        self.base_url = 'https://autopilot.twilio.com'

        # Versions
        self._v1 = None

    @property
    def v1(self):
        """
        :returns: Version v1 of autopilot
        :rtype: twilio.rest.autopilot.v1.V1
        """
        if self._v1 is None:
            self._v1 = V1(self)
        return self._v1

    @property
    def assistants(self):
        """
        :rtype: twilio.rest.autopilot.v1.assistant.AssistantList
        """
        return self.v1.assistants

    @property
    def restore_assistant(self):
        """
        :rtype: twilio.rest.autopilot.v1.restore_assistant.RestoreAssistantList
        """
        return self.v1.restore_assistant

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Autopilot>'
