/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class MapsTransformValuesUnmodifiableIteratorTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testClear() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testClear();
}

public void testContainsKey() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testContainsKey();
}

public void testContainsValue() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testContainsValue();
}

public void testEntrySet() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testEqualsForSmallerMap();
}

public void testGet() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testGet();
}

public void testGetForEmptyMap() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testGetForEmptyMap();
}

public void testGetNull() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testGetNull();
}

public void testHashCode() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testKeySetClear();
}

public void testKeySetRemove() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testPutExistingKey();
}

public void testPutNewKey() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testPutNewKey();
}

public void testPutNullKey() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testPutNullKey();
}

public void testPutNullValue() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testRemove();
}

public void testRemoveMissingKey() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testRemoveMissingKey();
}

public void testSize() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testSize();
}

public void testTransformChangesAreReflectedInUnderlyingMap() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testTransformChangesAreReflectedInUnderlyingMap();
}

public void testTransformEmptyMapEquality() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testTransformEmptyMapEquality();
}

public void testTransformEntrySetContains() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testTransformEntrySetContains();
}

public void testTransformEqualityOfMapsWithNullValues() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testTransformEqualityOfMapsWithNullValues();
}

public void testTransformEquals() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testTransformEquals();
}

public void testTransformIdentityFunctionEquality() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testTransformIdentityFunctionEquality();
}

public void testTransformPutEntryIsUnsupported() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testTransformPutEntryIsUnsupported();
}

public void testTransformReflectsUnderlyingMap() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testTransformReflectsUnderlyingMap();
}

public void testTransformRemoveEntry() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testTransformRemoveEntry();
}

public void testTransformSingletonMapEquality() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testTransformSingletonMapEquality();
}

public void testValues() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testValues();
}

public void testValuesClear() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty() throws Exception {
  com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest testCase = new com.google.common.collect.MapsTransformValuesUnmodifiableIteratorTest();
  testCase.testValuesRetainAllNullFromEmpty();
}
}
