/*
 * MD5 Message Digest Algorithm (RFC1321).
 *
 * Derived from cryptoapi implementation, originally based on the
 * public domain implementation written by Colin Plumb in 1993.
 *
 * Copyright (c) Cryptoapi developers.
 * Copyright (c) 2002 James Morris <jmorris@intercode.com.au>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 */

#include "md5.h"

#define MD5_F1(x, y, z)     (z ^ (x & (y ^ z)))
#define MD5_F2(x, y, z)     MD5_F1(z, x, y)
#define MD5_F3(x, y, z)     (x ^ y ^ z)
#define MD5_F4(x, y, z)     (y ^ (x | ~z))
#define MD5_STEP(f, w, x, y, z, in, s) \
    (w += f(x, y, z) + in, w = (w<<s | w>>(32-s)) + x)

void md5_transform_CPUbyteorder(u_int32_t *hash, u_int32_t const *in)
{
    u_int32_t a, b, c, d;

    a = hash[0];
    b = hash[1];
    c = hash[2];
    d = hash[3];

    MD5_STEP(MD5_F1, a, b, c, d, in[0] + 0xd76aa478, 7);
    MD5_STEP(MD5_F1, d, a, b, c, in[1] + 0xe8c7b756, 12);
    MD5_STEP(MD5_F1, c, d, a, b, in[2] + 0x242070db, 17);
    MD5_STEP(MD5_F1, b, c, d, a, in[3] + 0xc1bdceee, 22);
    MD5_STEP(MD5_F1, a, b, c, d, in[4] + 0xf57c0faf, 7);
    MD5_STEP(MD5_F1, d, a, b, c, in[5] + 0x4787c62a, 12);
    MD5_STEP(MD5_F1, c, d, a, b, in[6] + 0xa8304613, 17);
    MD5_STEP(MD5_F1, b, c, d, a, in[7] + 0xfd469501, 22);
    MD5_STEP(MD5_F1, a, b, c, d, in[8] + 0x698098d8, 7);
    MD5_STEP(MD5_F1, d, a, b, c, in[9] + 0x8b44f7af, 12);
    MD5_STEP(MD5_F1, c, d, a, b, in[10] + 0xffff5bb1, 17);
    MD5_STEP(MD5_F1, b, c, d, a, in[11] + 0x895cd7be, 22);
    MD5_STEP(MD5_F1, a, b, c, d, in[12] + 0x6b901122, 7);
    MD5_STEP(MD5_F1, d, a, b, c, in[13] + 0xfd987193, 12);
    MD5_STEP(MD5_F1, c, d, a, b, in[14] + 0xa679438e, 17);
    MD5_STEP(MD5_F1, b, c, d, a, in[15] + 0x49b40821, 22);

    MD5_STEP(MD5_F2, a, b, c, d, in[1] + 0xf61e2562, 5);
    MD5_STEP(MD5_F2, d, a, b, c, in[6] + 0xc040b340, 9);
    MD5_STEP(MD5_F2, c, d, a, b, in[11] + 0x265e5a51, 14);
    MD5_STEP(MD5_F2, b, c, d, a, in[0] + 0xe9b6c7aa, 20);
    MD5_STEP(MD5_F2, a, b, c, d, in[5] + 0xd62f105d, 5);
    MD5_STEP(MD5_F2, d, a, b, c, in[10] + 0x02441453, 9);
    MD5_STEP(MD5_F2, c, d, a, b, in[15] + 0xd8a1e681, 14);
    MD5_STEP(MD5_F2, b, c, d, a, in[4] + 0xe7d3fbc8, 20);
    MD5_STEP(MD5_F2, a, b, c, d, in[9] + 0x21e1cde6, 5);
    MD5_STEP(MD5_F2, d, a, b, c, in[14] + 0xc33707d6, 9);
    MD5_STEP(MD5_F2, c, d, a, b, in[3] + 0xf4d50d87, 14);
    MD5_STEP(MD5_F2, b, c, d, a, in[8] + 0x455a14ed, 20);
    MD5_STEP(MD5_F2, a, b, c, d, in[13] + 0xa9e3e905, 5);
    MD5_STEP(MD5_F2, d, a, b, c, in[2] + 0xfcefa3f8, 9);
    MD5_STEP(MD5_F2, c, d, a, b, in[7] + 0x676f02d9, 14);
    MD5_STEP(MD5_F2, b, c, d, a, in[12] + 0x8d2a4c8a, 20);

    MD5_STEP(MD5_F3, a, b, c, d, in[5] + 0xfffa3942, 4);
    MD5_STEP(MD5_F3, d, a, b, c, in[8] + 0x8771f681, 11);
    MD5_STEP(MD5_F3, c, d, a, b, in[11] + 0x6d9d6122, 16);
    MD5_STEP(MD5_F3, b, c, d, a, in[14] + 0xfde5380c, 23);
    MD5_STEP(MD5_F3, a, b, c, d, in[1] + 0xa4beea44, 4);
    MD5_STEP(MD5_F3, d, a, b, c, in[4] + 0x4bdecfa9, 11);
    MD5_STEP(MD5_F3, c, d, a, b, in[7] + 0xf6bb4b60, 16);
    MD5_STEP(MD5_F3, b, c, d, a, in[10] + 0xbebfbc70, 23);
    MD5_STEP(MD5_F3, a, b, c, d, in[13] + 0x289b7ec6, 4);
    MD5_STEP(MD5_F3, d, a, b, c, in[0] + 0xeaa127fa, 11);
    MD5_STEP(MD5_F3, c, d, a, b, in[3] + 0xd4ef3085, 16);
    MD5_STEP(MD5_F3, b, c, d, a, in[6] + 0x04881d05, 23);
    MD5_STEP(MD5_F3, a, b, c, d, in[9] + 0xd9d4d039, 4);
    MD5_STEP(MD5_F3, d, a, b, c, in[12] + 0xe6db99e5, 11);
    MD5_STEP(MD5_F3, c, d, a, b, in[15] + 0x1fa27cf8, 16);
    MD5_STEP(MD5_F3, b, c, d, a, in[2] + 0xc4ac5665, 23);

    MD5_STEP(MD5_F4, a, b, c, d, in[0] + 0xf4292244, 6);
    MD5_STEP(MD5_F4, d, a, b, c, in[7] + 0x432aff97, 10);
    MD5_STEP(MD5_F4, c, d, a, b, in[14] + 0xab9423a7, 15);
    MD5_STEP(MD5_F4, b, c, d, a, in[5] + 0xfc93a039, 21);
    MD5_STEP(MD5_F4, a, b, c, d, in[12] + 0x655b59c3, 6);
    MD5_STEP(MD5_F4, d, a, b, c, in[3] + 0x8f0ccc92, 10);
    MD5_STEP(MD5_F4, c, d, a, b, in[10] + 0xffeff47d, 15);
    MD5_STEP(MD5_F4, b, c, d, a, in[1] + 0x85845dd1, 21);
    MD5_STEP(MD5_F4, a, b, c, d, in[8] + 0x6fa87e4f, 6);
    MD5_STEP(MD5_F4, d, a, b, c, in[15] + 0xfe2ce6e0, 10);
    MD5_STEP(MD5_F4, c, d, a, b, in[6] + 0xa3014314, 15);
    MD5_STEP(MD5_F4, b, c, d, a, in[13] + 0x4e0811a1, 21);
    MD5_STEP(MD5_F4, a, b, c, d, in[4] + 0xf7537e82, 6);
    MD5_STEP(MD5_F4, d, a, b, c, in[11] + 0xbd3af235, 10);
    MD5_STEP(MD5_F4, c, d, a, b, in[2] + 0x2ad7d2bb, 15);
    MD5_STEP(MD5_F4, b, c, d, a, in[9] + 0xeb86d391, 21);

    hash[0] += a;
    hash[1] += b;
    hash[2] += c;
    hash[3] += d;
}
