# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UpdateStorageAccountWithAccountParameters(Model):
    """The parameters used to update an Azure Storage account while updating a
    Data Lake Analytics account.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The unique name of the Azure Storage account to
     update.
    :type name: str
    :param access_key: The updated access key associated with this Azure
     Storage account that will be used to connect to it.
    :type access_key: str
    :param suffix: The optional suffix for the storage account.
    :type suffix: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'access_key': {'key': 'properties.accessKey', 'type': 'str'},
        'suffix': {'key': 'properties.suffix', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UpdateStorageAccountWithAccountParameters, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.access_key = kwargs.get('access_key', None)
        self.suffix = kwargs.get('suffix', None)
