# psmisc

A package of small utilities that use the proc file-system.

* *fuser* - Identifies processes using files or sockets
* *killall* - kills processes by name, e.g. killall -HUP named
* *prtstat* - prints statistics of a process
* *pslog* - prints log path(s) of a process
* *pstree* - shows the currently running processes as a tree
* *peekfd* - shows the data travelling over a file descriptor

## Getting latest source
There are two ways of getting the latest source.

### GitLab
For the latest **psmisc** source, visit the
[GitLab psmisc page](https://gitlab.com/psmisc/psmisc)

### SourceForge
There are also tarballs found on
[SourceForge](https://sourceforge.net/projects/psmisc/files/psmisc/). The
reason these exist is the tarballs contain extra generated files. It's
reasonably easy to generate those files anyhow.

## Getting Help
There is no email list, but there is both an
[Issue Tracker](https://gitlab.com/psmisc/psmisc/-/issues) and
[Merge Request Tracker](https://gitlab.com/psmisc/psmisc/-/merge_requests).

I'm also trying out a Matrix room [#psmisc](https://matrix.to/#/#psmisc:dropbear.xyz)
so we will see how it goes.

## Credits

### Translations
My thanks for the various translators who have cheerfully given me the po
files to make psmisc speak different languages.  If your language is not
supported then let me know, all it takes is translating one file in
a certain manner. The current status of the translations can be found on
the [Translation Project](https://translationproject.org/domain/psmisc.html)
website.

### Icons
The pstree icons were drawn by Tatlin at Coresis who has given permission
for them to be used for psmisc.

## Copyright Change
The license has changed to GPL for version 20 onwards with permission
of the original authors.  People who want to use these programs under
the previous license will have to look at psmisc 19 or below.

## fuser on network fs
On network file-systems, fuser can hang because its trying to stat files
that may go away.  If you use the --with-timeout-stat option during
the configure step then fuser will fork a process to run stat. This means
fuser doesn't hang, but it is much slower.

