
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file GradientsColourTechniqueAttributes.h
    \\brief Definition of GradientsColourTechnique Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "GradientsColourTechniqueAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

GradientsColourTechniqueAttributes::GradientsColourTechniqueAttributes():
	colours_(ParameterManager::getStringArray("contour_gradients_colour_list")),
	stop_method_(ParameterManager::getString("contour_gradients_waypoint_method")),
	technique_(ParameterManager::getString("contour_gradients_technique")),
	technique_direction_(ParameterManager::getString("contour_gradients_technique_direction")),
	steps_(ParameterManager::getIntArray("contour_gradients_step_list"))
	
	 
{
} 


GradientsColourTechniqueAttributes::~GradientsColourTechniqueAttributes()
{
	
}

    
void GradientsColourTechniqueAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "contour_gradients_colour_list", colours_, params);
	setAttribute(prefix, "contour_gradients_waypoint_method", stop_method_, params);
	setAttribute(prefix, "contour_gradients_technique", technique_, params);
	setAttribute(prefix, "contour_gradients_technique_direction", technique_direction_, params);
	setAttribute(prefix, "contour_gradients_step_list", steps_, params);
	
	
}

void GradientsColourTechniqueAttributes::copy(const GradientsColourTechniqueAttributes& other)
{
	colours_ = other.colours_;
	stop_method_ = other.stop_method_;
	technique_ = other.technique_;
	technique_direction_ = other.technique_direction_;
	steps_ = other.steps_;
	
} 


bool GradientsColourTechniqueAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "")  )
		return true;
	
	return false;
}

void GradientsColourTechniqueAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void GradientsColourTechniqueAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " colours = " <<  colours_;
	out << " stop_method = " <<  stop_method_;
	out << " technique = " <<  technique_;
	out << " technique_direction = " <<  technique_direction_;
	out << " steps = " <<  steps_;
	
	out << "]" << "\n";
}

void GradientsColourTechniqueAttributes::toxml(ostream& out)  const
{
	out <<  "\"\""; 
	out << ", \"contour_gradients_colour_list\":";
	niceprint(out,colours_);
	out << ", \"contour_gradients_waypoint_method\":";
	niceprint(out,stop_method_);
	out << ", \"contour_gradients_technique\":";
	niceprint(out,technique_);
	out << ", \"contour_gradients_technique_direction\":";
	niceprint(out,technique_direction_);
	out << ", \"contour_gradients_step_list\":";
	niceprint(out,steps_);
	
}

static MagicsParameter<stringarray> contour_gradients_colour_list("contour_gradients_colour_list", stringarray(), "");
static MagicsParameter<string> contour_gradients_waypoint_method("contour_gradients_waypoint_method", "both", "");
static MagicsParameter<string> contour_gradients_technique("contour_gradients_technique", "rgb", "");
static MagicsParameter<string> contour_gradients_technique_direction("contour_gradients_technique_direction", "clockwise", "");
static MagicsParameter<intarray> contour_gradients_step_list("contour_gradients_step_list", intarray(), "");
