if(DEFINED ENV{HOMEBREW})
    set(HOMEBREW "$ENV{HOMEBREW}")
else()
    set(HOMEBREW "/usr/local")
endif()

if(DEFINED ENV{OSX_DEPLOYMENT_TARGET})
    set(OSX_DEPLOYMENT_TARGET "$ENV{OSX_DEPLOYMENT_TARGET}")
else()
    set(OSX_DEPLOYMENT_TARGET "10.13")
endif()

if(DEFINED ENV{OSX_ARCHITECTURES})
    set(OSX_ARCHITECTURES "$ENV{OSX_ARCHITECTURES}")
else()
    set(OSX_ARCHITECTURES "x86_64")
endif()

set(CMAKE_PREFIX_PATH "${CMAKE_PREFIX_PATH};${HOMEBREW}")
set(CMAKE_PREFIX_PATH "${CMAKE_PREFIX_PATH};${HOMEBREW}/opt/qt")
set(CMAKE_PREFIX_PATH "${CMAKE_PREFIX_PATH};${HOMEBREW}/opt/openssl@1.1")
set(CMAKE_PREFIX_PATH "${CMAKE_PREFIX_PATH};${HOMEBREW}/opt/gettext")

set(CMAKE_C_COMPILER   "clang")
set(CMAKE_CXX_COMPILER "clang++")

set(CMAKE_OSX_ARCHITECTURES "${OSX_ARCHITECTURES}"
    CACHE STRING "CMAKE_OSX_ARCHITECTURES")
set(CMAKE_OSX_DEPLOYMENT_TARGET "${OSX_DEPLOYMENT_TARGET}"
    CACHE STRING "CMAKE_OSX_DEPLOYMENT_TARGET")

set(CMAKE_INSTALL_PREFIX "${HOMEBREW}" CACHE PATH "Installation Prefix")
#set(CMAKE_BUILD_TYPE Release CACHE STRING "Debug|Release|RelWithDebInfo|MinSizeRel")
