#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Friday 31 July 2009 12:34:52 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/runningsurface/runningsurface_pmvnet.py,v 1.14 2009/07/31 19:49:28 vareille Exp $
#
# $Id: runningsurface_pmvnet.py,v 1.14 2009/07/31 19:49:28 vareille Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from Pmv.VisionInterface.PmvNodes import pmvlib
from MolKit.VisionInterface.MolKitNodes import molkitlib
from DejaVu.VisionInterface.DejaVuNodes import vizlib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(pmvlib,"Pmv.VisionInterface.PmvNodes", "pmvlib")

masterNet.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Select Nodes ##
    from MolKit.VisionInterface.MolKitNodes import NodeSelector
    Select_Nodes_0 = NodeSelector(constrkw={}, name='Select Nodes', library=molkitlib)
    masterNet.addNode(Select_Nodes_0,32,146)
    apply(Select_Nodes_0.outputPortByName['nodes'].configure, (), {'datatype': 'ResidueSet'})
    Select_Nodes_0.inputPortByName['nodeType'].widget.set(r"Residue", run=False)
    Select_Nodes_0.inputPortByName['selectionString'].widget.set(r"", run=False)
    apply(Select_Nodes_0.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore NodeSelector named Select Nodes in network masterNet"
    print_exc()
    Select_Nodes_0=None

try:
    ## saving node sub ##
    from Vision.StandardNodes import Operator2
    sub_1 = Operator2(constrkw={}, name='sub', library=stdlib)
    masterNet.addNode(sub_1,319,133)
    sub_1.inputPortByName['operation'].widget.set(r"sub", run=False)
    sub_1.inputPortByName['applyToElements'].widget.set(0, run=False)
    apply(sub_1.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Operator2 named sub in network masterNet"
    print_exc()
    sub_1=None

try:
    ## saving node Pmv ##
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_2 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    masterNet.addNode(Pmv_2,14,383)
    Pmv_2.inputPortByName['cmdName'].widget.set(r"", run=False)
    Pmv_2.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_2.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore PmvNode named Pmv in network masterNet"
    print_exc()
    Pmv_2=None

try:
    ## saving node Choose Cmd ##
    from Pmv.VisionInterface.PmvNodes import PmvChooseCommand
    Choose_Cmd_3 = PmvChooseCommand(constrkw={}, name='Choose Cmd', library=pmvlib)
    masterNet.addNode(Choose_Cmd_3,16,442)
    Choose_Cmd_3.inputPortByName['cmdName'].widget.set(r"computeMSMS", run=False)
except:
    print "WARNING: failed to restore PmvChooseCommand named Choose Cmd in network masterNet"
    print_exc()
    Choose_Cmd_3=None

try:
    ## saving node len ##
    from Vision.StandardNodes import Len
    len_5 = Len(constrkw={}, name='len', library=stdlib)
    masterNet.addNode(len_5,143,76)
    apply(len_5.inputPortByName['in1'].configure, (), {'datatype': 'ResidueSet', 'originalDatatype': 'None'})
except:
    print "WARNING: failed to restore Len named len in network masterNet"
    print_exc()
    len_5=None

try:
    ## saving node range ##
    from Vision.StandardNodes import Range
    range_6 = Range(constrkw={}, name='range', library=stdlib)
    masterNet.addNode(range_6,156,164)
    range_6.inputPortByName['fromInd'].widget.set(0, run=False)
    range_6.inputPortByName['toInd'].rebindWidget()
    range_6.inputPortByName['toInd'].widget.set(0, run=False)
    range_6.inputPortByName['toInd'].unbindWidget()
    range_6.inputPortByName['step'].rebindWidget()
    range_6.inputPortByName['step'].widget.set(3, run=False)
    range_6.inputPortByName['step'].unbindWidget()
    apply(range_6.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Range named range in network masterNet"
    print_exc()
    range_6=None

try:
    ## saving node add ##
    from Vision.StandardNodes import Operator2
    add_7 = Operator2(constrkw={}, name='add', library=stdlib)
    masterNet.addNode(add_7,259,315)
    apply(add_7.inputPortByName['data1'].configure, (), {'datatype': 'int', 'originalDatatype': 'None'})
    apply(add_7.inputPortByName['data2'].configure, (), {'datatype': 'int', 'originalDatatype': 'None'})
    add_7.inputPortByName['operation'].widget.set(r"add", run=False)
    add_7.inputPortByName['applyToElements'].widget.set(0, run=False)
    apply(add_7.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Operator2 named add in network masterNet"
    print_exc()
    add_7=None

try:
    ## saving node Stepsize ##
    from Vision.StandardNodes import DialIntNE
    Stepsize_8 = DialIntNE(constrkw={}, name='Stepsize', library=stdlib)
    masterNet.addNode(Stepsize_8,227,12)
    Stepsize_8.inputPortByName['dial'].widget.set(5, run=False)
except:
    print "WARNING: failed to restore DialIntNE named Stepsize in network masterNet"
    print_exc()
    Stepsize_8=None

try:
    ## saving node Slice ##
    from Vision.StandardNodes import Slice
    Slice_9 = Slice(constrkw={}, name='Slice', library=stdlib)
    masterNet.addNode(Slice_9,89,324)
    apply(Slice_9.inputPortByName['data'].configure, (), {'datatype': 'ResidueSet', 'originalDatatype': 'None'})
    apply(Slice_9.outputPortByName['data'].configure, (), {'datatype': 'ResidueSet'})
    Slice_9.inputPortByName['fromInd'].rebindWidget()
    Slice_9.inputPortByName['fromInd'].widget.set(0, run=False)
    Slice_9.inputPortByName['fromInd'].unbindWidget()
    Slice_9.inputPortByName['toInd'].rebindWidget()
    Slice_9.inputPortByName['toInd'].widget.set(0, run=False)
    Slice_9.inputPortByName['toInd'].unbindWidget()
    Slice_9.inputPortByName['step'].widget.set(1, run=False)
    apply(Slice_9.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Slice named Slice in network masterNet"
    print_exc()
    Slice_9=None

try:
    ## saving node iterate ##
    from Vision.StandardNodes import Iterate
    iterate_10 = Iterate(constrkw={}, name='iterate', library=stdlib)
    masterNet.addNode(iterate_10,170,235)
    apply(iterate_10.configure, (), {'specialPortsVisible': True})
    apply(iterate_10.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Iterate named iterate in network masterNet"
    print_exc()
    iterate_10=None

try:
    ## saving node overlap ##
    from Vision.StandardNodes import DialIntNE
    overlap_11 = DialIntNE(constrkw={}, name='overlap', library=stdlib)
    masterNet.addNode(overlap_11,348,9)
    overlap_11.inputPortByName['dial'].widget.set(1, run=False)
except:
    print "WARNING: failed to restore DialIntNE named overlap in network masterNet"
    print_exc()
    overlap_11=None

try:
    ## saving node Pmv Viewer ##
    from Pmv.VisionInterface.PmvNodes import PmvViewer
    Pmv_Viewer_12 = PmvViewer(viewer=masterNet.editor.vf.GUI.VIEWER, constrkw={'viewer': 'masterNet.editor.vf.GUI.VIEWER'}, name='Pmv Viewer', library=pmvlib)
    masterNet.addNode(Pmv_Viewer_12,462,40)
    apply(Pmv_Viewer_12.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    ##
        ## Saving State for Viewer
    Pmv_Viewer_12.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 453, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 89, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 32.399999999999999, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 688, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -162.25584], 'd2cutH': 255, 'far': 411.05302559328948, 'd1off': 4, 'lookFrom': [0.0, 0.0, 162.25584], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 233, 'd1scale': 0.012999999999999999}
    apply(Pmv_Viewer_12.vi.cameras[0].Set, (), state)

    state = {'end': 205.52651279664474, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 118.98517977706905, 'mode': 'GL_LINEAR'}
    apply(Pmv_Viewer_12.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [29.905378341674805, 16.498878479003906, 56.405982971191406], 'rotation': [0.38596192, -0.83629799, 0.3894085, 0.0, 0.35673466, 0.52458042, 0.77301735, 0.0, -0.85074896, -0.15943977, 0.50080454, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-29.905382, -16.498877, -56.405983], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(Pmv_Viewer_12.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Pmv_Viewer_12.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Pmv_Viewer_12.vi.rootObject:
        Pmv_Viewer_12.vi.rootObject.clipP = []
        Pmv_Viewer_12.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore PmvViewer named Pmv Viewer in network masterNet"
    print_exc()
    Pmv_Viewer_12=None

try:
    ## saving node file00000054.png ##
    from DejaVu.VisionInterface.DejaVuNodes import SelectMultipleGeometry
    file00000054_png_13 = SelectMultipleGeometry(constrkw={}, name='file00000054.png', library=vizlib)
    masterNet.addNode(file00000054_png_13,422,316)
    apply(file00000054_png_13.configure, (), {'specialPortsVisible': True})
    file00000054_png_13.inputPortByName['name'].widget.set(r"msms0", run=False)
    apply(file00000054_png_13.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore SelectMultipleGeometry named file00000054.png in network masterNet"
    print_exc()
    file00000054_png_13=None

try:
    ## saving node TF_1 ##
    from DejaVu.VisionInterface.DejaVuNodes import SelectGeometry
    TF_1_14 = SelectGeometry(constrkw={}, name='TF_1', library=vizlib)
    masterNet.addNode(TF_1_14,607,89)
    TF_1_14.inputPortByName['geomName'].widget.set(r"root|tf_1", run=False)
    apply(TF_1_14.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore SelectGeometry named TF_1 in network masterNet"
    print_exc()
    TF_1_14=None

try:
    ## saving node Reparent Geom ##
    from DejaVu.VisionInterface.DejaVuNodes import ReparentGeom
    Reparent_Geom_15 = ReparentGeom(constrkw={}, name='Reparent Geom', library=vizlib)
    masterNet.addNode(Reparent_Geom_15,596,474)
    Reparent_Geom_15.inputPortByName['retainPosition'].widget.set(0, run=False)
except:
    print "WARNING: failed to restore ReparentGeom named Reparent Geom in network masterNet"
    print_exc()
    Reparent_Geom_15=None

try:
    ## saving node Pmv Viewer ##
    from Pmv.VisionInterface.PmvNodes import PmvViewer
    Pmv_Viewer_16 = PmvViewer(viewer=masterNet.editor.vf.GUI.VIEWER, constrkw={'viewer': 'masterNet.editor.vf.GUI.VIEWER'}, name='Pmv Viewer', library=pmvlib)
    masterNet.addNode(Pmv_Viewer_16,871,461)
    apply(Pmv_Viewer_16.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    ##
        ## Saving State for Viewer
    Pmv_Viewer_16.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 453, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 89, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 32.399999999999999, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 688, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -162.25584], 'd2cutH': 255, 'far': 411.05302559328948, 'd1off': 4, 'lookFrom': [0.0, 0.0, 162.25584], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 233, 'd1scale': 0.012999999999999999}
    apply(Pmv_Viewer_16.vi.cameras[0].Set, (), state)

    state = {'end': 205.52651279664474, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 118.98517977706905, 'mode': 'GL_LINEAR'}
    apply(Pmv_Viewer_16.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [29.905378341674805, 16.498878479003906, 56.405982971191406], 'rotation': [0.38596192, -0.83629799, 0.3894085, 0.0, 0.35673466, 0.52458042, 0.77301735, 0.0, -0.85074896, -0.15943977, 0.50080454, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-29.905382, -16.498877, -56.405983], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(Pmv_Viewer_16.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Pmv_Viewer_16.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Pmv_Viewer_16.vi.rootObject:
        Pmv_Viewer_16.vi.rootObject.clipP = []
        Pmv_Viewer_16.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore PmvViewer named Pmv Viewer in network masterNet"
    print_exc()
    Pmv_Viewer_16=None

try:
    ## saving node geomContainer ##
    from DejaVu.VisionInterface.GeometryNodes import GeomContainer
    geomContainer_17 = GeomContainer(constrkw={}, name='geomContainer', library=vizlib)
    masterNet.addNode(geomContainer_17,748,323)
    geomContainer_17.inputPortByName['name'].widget.set(r"", run=False)
    geomContainer_17.inputPortByName['geoms'].widget.set(r"geomContainer", run=False)
except:
    print "WARNING: failed to restore GeomContainer named geomContainer in network masterNet"
    print_exc()
    geomContainer_17=None

try:
    ## saving node tf_1 ##
    import os
    from mglutil.util.relpath import rel2abs
    lRelFileName = 'tf_1.pdb'
    lNetworkDir = os.path.dirname(os.path.abspath(masterNet.filename))
    lAbsFileName = rel2abs(lRelFileName, lNetworkDir)
    mol = masterNet.editor.vf.loadMoleculeIfNeeded(lAbsFileName)
    assert mol
    from Pmv.VisionInterface.PmvNodes import PmvMolecule
    tf_1_18 = PmvMolecule(molecule=masterNet.editor.vf.expandNodes("tf_1")[0], constrkw={'molecule': 'masterNet.editor.vf.expandNodes("tf_1")[0]'}, name='tf_1', library=pmvlib)
    masterNet.addNode(tf_1_18,24,74)
except:
    print "WARNING: failed to restore PmvMolecule named tf_1 in network masterNet"
    print_exc()
    tf_1_18=None

try:
    ## saving node computeMSMS ##
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    computeMSMS_19 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.computeMSMS, namedArgs={'hdensity': 6.0, 'hdset': 'None', 'surfName': 'MSMS-MOL', 'density': 3.0, 'perMol': True, 'display': True, 'pRadius': 1.5}, posArgsNames=['nodes'], constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.computeMSMS', 'namedArgs': {'hdensity': 6.0, 'hdset': 'None', 'surfName': 'MSMS-MOL', 'density': 3.0, 'perMol': True, 'display': True, 'pRadius': 1.5}, 'posArgsNames': ['nodes']}, name='computeMSMS', library=pmvlib)
    masterNet.addNode(computeMSMS_19,79,561)
    apply(computeMSMS_19.inputPortByName['nodes'].configure, (), {'datatype': 'ResidueSet', 'originalDatatype': 'None'})
    computeMSMS_19.inputPortByName['importString'].widget.set(r"", run=False)
    computeMSMS_19.inputPortByName['hdensity'].widget.set(6.0, run=False)
    computeMSMS_19.inputPortByName['hdset'].widget.set(r"None", run=False)
    computeMSMS_19.inputPortByName['surfName'].rebindWidget()
    computeMSMS_19.inputPortByName['surfName'].widget.set(r"MSMS-MOL", run=False)
    computeMSMS_19.inputPortByName['surfName'].unbindWidget()
    computeMSMS_19.inputPortByName['density'].widget.set(3.0, run=False)
    computeMSMS_19.inputPortByName['perMol'].widget.set(0, run=False)
    computeMSMS_19.inputPortByName['display'].widget.set(1, run=False)
    computeMSMS_19.inputPortByName['pRadius'].widget.set(1.5, run=False)
    apply(computeMSMS_19.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore PmvRunCommand named computeMSMS in network masterNet"
    print_exc()
    computeMSMS_19=None

try:
    ## saving node NumberedName ##
    from Vision.StandardNodes import NumberedFilename
    NumberedName_20 = NumberedFilename(constrkw={}, name='NumberedName', library=stdlib)
    masterNet.addNode(NumberedName_20,216,415)
    NumberedName_20.inputPortByName['directory'].widget.set(r"", run=False)
    NumberedName_20.inputPortByName['baseName'].widget.set(r"msms", run=False)
    NumberedName_20.inputPortByName['padding'].widget.set(4, run=False)
    NumberedName_20.inputPortByName['suffix'].widget.set(r"", run=False)
    apply(NumberedName_20.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore NumberedFilename named NumberedName in network masterNet"
    print_exc()
    NumberedName_20=None

#masterNet.run()
masterNet.freeze()

## saving connections for network runningsurface ##
if Select_Nodes_0 is not None and len_5 is not None:
    try:
        masterNet.connectNodes(
            Select_Nodes_0, len_5, "nodes", "in1", blocking=True
            , splitratio=[0.46958365761738202, 0.73762045359729433])
    except:
        print "WARNING: failed to restore connection between Select_Nodes_0 and len_5 in network masterNet"
if len_5 is not None and range_6 is not None:
    try:
        masterNet.connectNodes(
            len_5, range_6, "length", "toInd", blocking=True
            , splitratio=[0.36680813240675941, 0.42459766398129162])
    except:
        print "WARNING: failed to restore connection between len_5 and range_6 in network masterNet"
if add_7 is not None and Slice_9 is not None:
    try:
        masterNet.connectNodes(
            add_7, Slice_9, "result", "toInd", blocking=True
            , splitratio=[0.53321674887800574, 0.34651469714925731])
    except:
        print "WARNING: failed to restore connection between add_7 and Slice_9 in network masterNet"
if iterate_10 is not None and Slice_9 is not None:
    try:
        masterNet.connectNodes(
            iterate_10, Slice_9, "oneItem", "fromInd", blocking=True
            , splitratio=[0.23311205198863463, 0.73911368943039712])
    except:
        print "WARNING: failed to restore connection between iterate_10 and Slice_9 in network masterNet"
if Select_Nodes_0 is not None and Slice_9 is not None:
    try:
        masterNet.connectNodes(
            Select_Nodes_0, Slice_9, "nodes", "data", blocking=True
            , splitratio=[0.38410437439672929, 0.53631748477963326])
    except:
        print "WARNING: failed to restore connection between Select_Nodes_0 and Slice_9 in network masterNet"
if Stepsize_8 is not None and sub_1 is not None:
    try:
        masterNet.connectNodes(
            Stepsize_8, sub_1, "value", "data1", blocking=True
            , splitratio=[0.54502183185871078, 0.44702733267454475])
    except:
        print "WARNING: failed to restore connection between Stepsize_8 and sub_1 in network masterNet"
if overlap_11 is not None and sub_1 is not None:
    try:
        masterNet.connectNodes(
            overlap_11, sub_1, "value", "data2", blocking=True
            , splitratio=[0.25015232195289133, 0.34982082784592816])
    except:
        print "WARNING: failed to restore connection between overlap_11 and sub_1 in network masterNet"
if sub_1 is not None and range_6 is not None:
    try:
        masterNet.connectNodes(
            sub_1, range_6, "result", "step", blocking=True
            , splitratio=[0.42018260273209984, 0.60999180431796507])
    except:
        print "WARNING: failed to restore connection between sub_1 and range_6 in network masterNet"
if range_6 is not None and iterate_10 is not None:
    try:
        masterNet.connectNodes(
            range_6, iterate_10, "data", "listToLoopOver", blocking=True
            , splitratio=[0.30682178029674567, 0.41391212237032388])
    except:
        print "WARNING: failed to restore connection between range_6 and iterate_10 in network masterNet"
if iterate_10 is not None and add_7 is not None:
    try:
        masterNet.connectNodes(
            iterate_10, add_7, "oneItem", "data1", blocking=True
            , splitratio=[0.5793131008402872, 0.72816067460853851])
    except:
        print "WARNING: failed to restore connection between iterate_10 and add_7 in network masterNet"
if Stepsize_8 is not None and add_7 is not None:
    try:
        masterNet.connectNodes(
            Stepsize_8, add_7, "value", "data2", blocking=True
            , splitratio=[0.56040802107472465, 0.21348130016868319])
    except:
        print "WARNING: failed to restore connection between Stepsize_8 and add_7 in network masterNet"
if Pmv_Viewer_12 is not None and file00000054_png_13 is not None:
    try:
        masterNet.connectNodes(
            Pmv_Viewer_12, file00000054_png_13, "dejaVuViewer", "viewer", blocking=True
            , splitratio=[0.71906579275877269, 0.22768571961760453])
    except:
        print "WARNING: failed to restore connection between Pmv_Viewer_12 and file00000054_png_13 in network masterNet"
if iterate_10 is not None and file00000054_png_13 is not None:
    try:
        masterNet.specialConnectNodes(
            iterate_10, file00000054_png_13, "trigger", "runNode", blocking=True
            , splitratio=[0.64488624130543182, 0.6465787150148018])
    except:
        print "WARNING: failed to restore connection between iterate_10 and file00000054_png_13 in network masterNet"
if Pmv_Viewer_12 is not None and TF_1_14 is not None:
    try:
        masterNet.connectNodes(
            Pmv_Viewer_12, TF_1_14, "dejaVuViewer", "viewer", blocking=True
            , splitratio=[0.3629600957268832, 0.38141339878194774])
    except:
        print "WARNING: failed to restore connection between Pmv_Viewer_12 and TF_1_14 in network masterNet"
if file00000054_png_13 is not None and Reparent_Geom_15 is not None:
    try:
        masterNet.connectNodes(
            file00000054_png_13, Reparent_Geom_15, "geomList", "geoms", blocking=True
            , splitratio=[0.66801266846665297, 0.59468816818499337])
    except:
        print "WARNING: failed to restore connection between file00000054_png_13 and Reparent_Geom_15 in network masterNet"
if TF_1_14 is not None and file00000054_png_13 is not None:
    try:
        masterNet.connectNodes(
            TF_1_14, file00000054_png_13, "geometry", "searchedParent", blocking=True
            , splitratio=[0.38811766295634548, 0.60017591461588937])
    except:
        print "WARNING: failed to restore connection between TF_1_14 and file00000054_png_13 in network masterNet"
if geomContainer_17 is not None and Pmv_Viewer_16 is not None:
    try:
        masterNet.connectNodes(
            geomContainer_17, Pmv_Viewer_16, "geomContainer", "geometries", blocking=True
            , splitratio=[0.50052106697689647, 0.43809324652227877])
    except:
        print "WARNING: failed to restore connection between geomContainer_17 and Pmv_Viewer_16 in network masterNet"
if geomContainer_17 is not None and Reparent_Geom_15 is not None:
    try:
        masterNet.connectNodes(
            geomContainer_17, Reparent_Geom_15, "geomContainer", "parent", blocking=True
            , splitratio=[0.46510952304707942, 0.3563691602396335])
    except:
        print "WARNING: failed to restore connection between geomContainer_17 and Reparent_Geom_15 in network masterNet"
if tf_1_18 is not None and Select_Nodes_0 is not None:
    try:
        masterNet.connectNodes(
            tf_1_18, Select_Nodes_0, "Molecule", "nodes", blocking=True
            , splitratio=[0.23580382753341017, 0.54858387978861023])
    except:
        print "WARNING: failed to restore connection between tf_1_18 and Select_Nodes_0 in network masterNet"
if Pmv_2 is not None and Choose_Cmd_3 is not None:
    try:
        masterNet.connectNodes(
            Pmv_2, Choose_Cmd_3, "PMV", "viewer", blocking=True
            , splitratio=[0.48004658573174486, 0.66226426394081606])
    except:
        print "WARNING: failed to restore connection between Pmv_2 and Choose_Cmd_3 in network masterNet"
if Choose_Cmd_3 is not None and computeMSMS_19 is not None:
    try:
        masterNet.connectNodes(
            Choose_Cmd_3, computeMSMS_19, "cmd", "command", blocking=True
            , splitratio=[0.46301978496163593, 0.67048708320247807])
    except:
        print "WARNING: failed to restore connection between Choose_Cmd_3 and computeMSMS_19 in network masterNet"
if Slice_9 is not None and computeMSMS_19 is not None:
    try:
        masterNet.connectNodes(
            Slice_9, computeMSMS_19, "data", "nodes", blocking=True
            , splitratio=[0.3370739970697697, 0.69363156322261521])
    except:
        print "WARNING: failed to restore connection between Slice_9 and computeMSMS_19 in network masterNet"
if TF_1_14 is not None and geomContainer_17 is not None:
    try:
        masterNet.connectNodes(
            TF_1_14, geomContainer_17, "geometry", "parent", blocking=True
            , splitratio=[0.23463438456180044, 0.35310861793813952])
    except:
        print "WARNING: failed to restore connection between TF_1_14 and geomContainer_17 in network masterNet"
if iterate_10 is not None and NumberedName_20 is not None:
    try:
        masterNet.connectNodes(
            iterate_10, NumberedName_20, "iter", "number", blocking=True
            , splitratio=[0.47829004048159163, 0.29574808951247228])
    except:
        print "WARNING: failed to restore connection between iterate_10 and NumberedName_20 in network masterNet"
if NumberedName_20 is not None and computeMSMS_19 is not None:
    try:
        masterNet.connectNodes(
            NumberedName_20, computeMSMS_19, "filename", "surfName", blocking=True
            , splitratio=[0.48784414670797005, 0.49511892694704474])
    except:
        print "WARNING: failed to restore connection between NumberedName_20 and computeMSMS_19 in network masterNet"
masterNet.runOnNewData.value = False


def loadSavedStates_Pmv_Viewer_12(self=Pmv_Viewer_12, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|misc
    ## Object root|AutoLigand_geoms
    ## Object root|CoarseAPBSbox
    ## Object root|FineAPBSbox
    ## Object root|tf_1
    ## Object root|misc|addBondsGeom
    ## Object root|misc|edit_geoms
    ## Object root|misc|repair_geoms
    ## Object root|misc|measure_geoms
    ## Object root|misc|setTorsionGeom
    ## Object root|misc|selectInSphereGeoms
    ## Object root|AutoLigand_geoms|Cross
    ## Object root|AutoLigand_geoms|Box
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': 0, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'line', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': 0, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 1, 'pickableVertices': True, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': 0, 'shading': 'flat', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'Box', 'backPolyMode': 'line', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': True, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|AutoLigand_geoms|Box')
    if obj:
        apply(obj.Set, (), state)

    ## Material for Box
    if obj:
        from opengltk.OpenGL import GL
        state = {'shininess': [13.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'binding': [10.0, 12.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for Box

    ## Clipping Planes for Box
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for Box

    ## Object root|AutoLigand_geoms|Spheres
    ## Object root|AutoLigand_geoms|Halo
    ## Object root|tf_1|selection
    ## Object root|tf_1|lines
    ## Object root|tf_1|AtomLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'AtomLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (0.29999999999999999, 0.29999999999999999, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|tf_1|AtomLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for AtomLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for AtomLabels

    ## Clipping Planes for AtomLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for AtomLabels

    ## Object root|tf_1|ResidueLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'ResidueLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (0.59999999999999998, 0.59999999999999998, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|tf_1|ResidueLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for ResidueLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for ResidueLabels

    ## Clipping Planes for ResidueLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for ResidueLabels

    ## Object root|tf_1|ChainLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'ChainLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (0.89999999999999991, 0.89999999999999991, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|tf_1|ChainLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for ChainLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for ChainLabels

    ## Clipping Planes for ChainLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for ChainLabels

    ## Object root|tf_1|ProteinLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'ProteinLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (1.2, 1.2, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|tf_1|ProteinLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for ProteinLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for ProteinLabels

    ## Clipping Planes for ProteinLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for ProteinLabels

    ## Object root|tf_1|sticks
    ## Object root|tf_1|balls
    ## Object root|tf_1|cpk
    ## Object root|tf_1|CAsticks
    ## Object root|tf_1|CAballs
    ## Object root|tf_1|geomContainer
    ## Object root|misc|addBondsGeom|addBondsSpheres
    ## Object root|misc|edit_geoms|editAtomTypeSphere
    ## Object root|misc|edit_geoms|editAtomChargeSphere
    ## Object root|misc|repair_geoms|closeContactGeoms
    ## Object root|misc|measure_geoms|measureDistGeomCtrl
    ## Object root|misc|measure_geoms|measureDistGeom
    ## Object root|misc|measure_geoms|measureAngleGeom
    ## Object root|misc|measure_geoms|measureTorsionGeom
    ## Object root|misc|setTorsionGeom|settorsionLine
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 1, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'settorsionLine', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': True, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|misc|setTorsionGeom|settorsionLine')
    if obj:
        apply(obj.Set, (), state)

    ## Material for settorsionLine
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [13.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[0.0, 1.0, 1.0, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for settorsionLine

    ## Clipping Planes for settorsionLine
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for settorsionLine

    ## Object root|misc|setTorsionGeom|settorsionLabel
    ## Object root|misc|setTorsionGeom|settorsionSpheres
    ## Object root|misc|selectInSphereGeoms|SelSphReg_selSph
    ## Object root|misc|selectInSphereGeoms|SelSphReg_cenCross
    ## Object root|tf_1|lines|bonded
    ## Object root|tf_1|lines|nobnds
    ## Object root|tf_1|lines|bondorder
    ## Object root|tf_1|geomContainer|msms0005
    ## Object root|tf_1|geomContainer|msms0021
    ## Object root|tf_1|geomContainer|msms0028
    ## Object root|tf_1|geomContainer|msms0007
    ## Object root|tf_1|geomContainer|msms0027
    ## Object root|tf_1|geomContainer|msms0044
    ## Object root|tf_1|geomContainer|msms0016
    ## Object root|tf_1|geomContainer|msms0004
    ## Object root|tf_1|geomContainer|msms0017
    ## Object root|tf_1|geomContainer|msms0037
    ## Object root|tf_1|geomContainer|msms0014
    ## Object root|tf_1|geomContainer|msms0013
    ## Object root|tf_1|geomContainer|msms0018
    ## Object root|tf_1|geomContainer|msms0000
    ## Object root|tf_1|geomContainer|msms0024
    ## Object root|tf_1|geomContainer|msms0019
    ## Object root|tf_1|geomContainer|msms0038
    ## Object root|tf_1|geomContainer|msms0043
    ## Object root|tf_1|geomContainer|msms0002
    ## Object root|tf_1|geomContainer|msms0034
    ## Object root|tf_1|geomContainer|msms0030
    ## Object root|tf_1|geomContainer|msms0035
    ## Object root|tf_1|geomContainer|msms0006
    ## Object root|tf_1|geomContainer|msms0025
    ## Object root|tf_1|geomContainer|msms0012
    ## Object root|tf_1|geomContainer|msms0042
    ## Object root|tf_1|geomContainer|msms0032
    ## Object root|tf_1|geomContainer|msms0011
    ## Object root|tf_1|geomContainer|msms0036
    ## Object root|tf_1|geomContainer|msms0040
    ## Object root|tf_1|geomContainer|msms0009
    ## Object root|tf_1|geomContainer|msms0048
    ## Object root|tf_1|geomContainer|msms0033
    ## Object root|tf_1|geomContainer|msms0041
    ## Object root|tf_1|geomContainer|msms0003
    ## Object root|tf_1|geomContainer|msms0010
    ## Object root|tf_1|geomContainer|msms0008
    ## Object root|tf_1|geomContainer|msms0023
    ## Object root|tf_1|geomContainer|msms0045
    ## Object root|tf_1|geomContainer|msms0031
    ## Object root|tf_1|geomContainer|msms0020
    ## Object root|tf_1|geomContainer|msms0001
    ## Object root|tf_1|geomContainer|msms0022
    ## Object root|tf_1|geomContainer|msms0039
    ## Object root|tf_1|geomContainer|msms0029
    ## Object root|tf_1|geomContainer|msms0047
    ## Object root|tf_1|geomContainer|msms0015
    ## Object root|tf_1|geomContainer|msms0026
    ## Object root|tf_1|geomContainer|msms0046
    ## Object root|misc|repair_geoms|closeContactGeoms|closeContLines
    ## Object root|misc|repair_geoms|closeContactGeoms|closeContLabels
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLine
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLabel
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distSpheres
    ## Object root|misc|measure_geoms|measureDistGeom|distLine
    ## Object root|misc|measure_geoms|measureDistGeom|distLabel
    ## Object root|misc|measure_geoms|measureDistGeom|distSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLine
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLabel
    ## Object root|misc|measure_geoms|measureAngleGeom|angleSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angles
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLine
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLabel
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres
    ## End Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres

    ##
        ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 453, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 32.399999999999999, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 688, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -162.25584], 'd2cutH': 255, 'far': 411.05302559328948, 'd1off': 4, 'lookFrom': [0.0, 0.0, 162.25584], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 205.52651279664474, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 118.98517977706905, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [29.905378341674805, 16.498878479003906, 56.405982971191406], 'rotation': [0.38596192, -0.83629799, 0.3894085, 0.0, 0.35673466, 0.52458042, 0.77301735, 0.0, -0.85074896, -0.15943977, 0.50080454, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-29.905382, -16.498877, -56.405983], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Pmv_Viewer_12.restoreStates_cb = Pmv_Viewer_12.restoreStatesFirstRun = loadSavedStates_Pmv_Viewer_12
Pmv_Viewer_12.menu.add_separator()
Pmv_Viewer_12.menu.add_command(label='Restore states', command=Pmv_Viewer_12.restoreStates_cb)


def loadSavedStates_Pmv_Viewer_16(self=Pmv_Viewer_16, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|misc
    ## Object root|AutoLigand_geoms
    ## Object root|CoarseAPBSbox
    ## Object root|FineAPBSbox
    ## Object root|tf_1
    ## Object root|misc|addBondsGeom
    ## Object root|misc|edit_geoms
    ## Object root|misc|repair_geoms
    ## Object root|misc|measure_geoms
    ## Object root|misc|setTorsionGeom
    ## Object root|misc|selectInSphereGeoms
    ## Object root|AutoLigand_geoms|Cross
    ## Object root|AutoLigand_geoms|Box
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': 0, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'line', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': 0, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 1, 'pickableVertices': True, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': 0, 'shading': 'flat', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'Box', 'backPolyMode': 'line', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': True, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|AutoLigand_geoms|Box')
    if obj:
        apply(obj.Set, (), state)

    ## Material for Box
    if obj:
        from opengltk.OpenGL import GL
        state = {'shininess': [13.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'binding': [10.0, 12.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for Box

    ## Clipping Planes for Box
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for Box

    ## Object root|AutoLigand_geoms|Spheres
    ## Object root|AutoLigand_geoms|Halo
    ## Object root|tf_1|selection
    ## Object root|tf_1|lines
    ## Object root|tf_1|AtomLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'AtomLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (0.29999999999999999, 0.29999999999999999, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|tf_1|AtomLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for AtomLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for AtomLabels

    ## Clipping Planes for AtomLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for AtomLabels

    ## Object root|tf_1|ResidueLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'ResidueLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (0.59999999999999998, 0.59999999999999998, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|tf_1|ResidueLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for ResidueLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for ResidueLabels

    ## Clipping Planes for ResidueLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for ResidueLabels

    ## Object root|tf_1|ChainLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'ChainLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (0.89999999999999991, 0.89999999999999991, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|tf_1|ChainLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for ChainLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for ChainLabels

    ## Clipping Planes for ChainLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for ChainLabels

    ## Object root|tf_1|ProteinLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'ProteinLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (1.2, 1.2, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|tf_1|ProteinLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for ProteinLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for ProteinLabels

    ## Clipping Planes for ProteinLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for ProteinLabels

    ## Object root|tf_1|sticks
    ## Object root|tf_1|balls
    ## Object root|tf_1|cpk
    ## Object root|tf_1|CAsticks
    ## Object root|tf_1|CAballs
    ## Object root|tf_1|geomContainer
    ## Object root|misc|addBondsGeom|addBondsSpheres
    ## Object root|misc|edit_geoms|editAtomTypeSphere
    ## Object root|misc|edit_geoms|editAtomChargeSphere
    ## Object root|misc|repair_geoms|closeContactGeoms
    ## Object root|misc|measure_geoms|measureDistGeomCtrl
    ## Object root|misc|measure_geoms|measureDistGeom
    ## Object root|misc|measure_geoms|measureAngleGeom
    ## Object root|misc|measure_geoms|measureTorsionGeom
    ## Object root|misc|setTorsionGeom|settorsionLine
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 1, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'settorsionLine', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': True, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|misc|setTorsionGeom|settorsionLine')
    if obj:
        apply(obj.Set, (), state)

    ## Material for settorsionLine
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [13.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[0.0, 1.0, 1.0, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for settorsionLine

    ## Clipping Planes for settorsionLine
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for settorsionLine

    ## Object root|misc|setTorsionGeom|settorsionLabel
    ## Object root|misc|setTorsionGeom|settorsionSpheres
    ## Object root|misc|selectInSphereGeoms|SelSphReg_selSph
    ## Object root|misc|selectInSphereGeoms|SelSphReg_cenCross
    ## Object root|tf_1|lines|bonded
    ## Object root|tf_1|lines|nobnds
    ## Object root|tf_1|lines|bondorder
    ## Object root|tf_1|geomContainer|msms0005
    ## Object root|tf_1|geomContainer|msms0021
    ## Object root|tf_1|geomContainer|msms0028
    ## Object root|tf_1|geomContainer|msms0007
    ## Object root|tf_1|geomContainer|msms0027
    ## Object root|tf_1|geomContainer|msms0044
    ## Object root|tf_1|geomContainer|msms0016
    ## Object root|tf_1|geomContainer|msms0004
    ## Object root|tf_1|geomContainer|msms0017
    ## Object root|tf_1|geomContainer|msms0037
    ## Object root|tf_1|geomContainer|msms0014
    ## Object root|tf_1|geomContainer|msms0013
    ## Object root|tf_1|geomContainer|msms0018
    ## Object root|tf_1|geomContainer|msms0000
    ## Object root|tf_1|geomContainer|msms0024
    ## Object root|tf_1|geomContainer|msms0019
    ## Object root|tf_1|geomContainer|msms0038
    ## Object root|tf_1|geomContainer|msms0043
    ## Object root|tf_1|geomContainer|msms0002
    ## Object root|tf_1|geomContainer|msms0034
    ## Object root|tf_1|geomContainer|msms0030
    ## Object root|tf_1|geomContainer|msms0035
    ## Object root|tf_1|geomContainer|msms0006
    ## Object root|tf_1|geomContainer|msms0025
    ## Object root|tf_1|geomContainer|msms0012
    ## Object root|tf_1|geomContainer|msms0042
    ## Object root|tf_1|geomContainer|msms0032
    ## Object root|tf_1|geomContainer|msms0011
    ## Object root|tf_1|geomContainer|msms0036
    ## Object root|tf_1|geomContainer|msms0040
    ## Object root|tf_1|geomContainer|msms0009
    ## Object root|tf_1|geomContainer|msms0048
    ## Object root|tf_1|geomContainer|msms0033
    ## Object root|tf_1|geomContainer|msms0041
    ## Object root|tf_1|geomContainer|msms0003
    ## Object root|tf_1|geomContainer|msms0010
    ## Object root|tf_1|geomContainer|msms0008
    ## Object root|tf_1|geomContainer|msms0023
    ## Object root|tf_1|geomContainer|msms0045
    ## Object root|tf_1|geomContainer|msms0031
    ## Object root|tf_1|geomContainer|msms0020
    ## Object root|tf_1|geomContainer|msms0001
    ## Object root|tf_1|geomContainer|msms0022
    ## Object root|tf_1|geomContainer|msms0039
    ## Object root|tf_1|geomContainer|msms0029
    ## Object root|tf_1|geomContainer|msms0047
    ## Object root|tf_1|geomContainer|msms0015
    ## Object root|tf_1|geomContainer|msms0026
    ## Object root|tf_1|geomContainer|msms0046
    ## Object root|misc|repair_geoms|closeContactGeoms|closeContLines
    ## Object root|misc|repair_geoms|closeContactGeoms|closeContLabels
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLine
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLabel
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distSpheres
    ## Object root|misc|measure_geoms|measureDistGeom|distLine
    ## Object root|misc|measure_geoms|measureDistGeom|distLabel
    ## Object root|misc|measure_geoms|measureDistGeom|distSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLine
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLabel
    ## Object root|misc|measure_geoms|measureAngleGeom|angleSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angles
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLine
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLabel
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres
    ## End Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres

    ##
        ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 453, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 32.399999999999999, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 688, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -162.25584], 'd2cutH': 255, 'far': 411.05302559328948, 'd1off': 4, 'lookFrom': [0.0, 0.0, 162.25584], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 205.52651279664474, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 118.98517977706905, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [29.905378341674805, 16.498878479003906, 56.405982971191406], 'rotation': [0.38596192, -0.83629799, 0.3894085, 0.0, 0.35673466, 0.52458042, 0.77301735, 0.0, -0.85074896, -0.15943977, 0.50080454, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-29.905382, -16.498877, -56.405983], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Pmv_Viewer_16.restoreStates_cb = Pmv_Viewer_16.restoreStatesFirstRun = loadSavedStates_Pmv_Viewer_16
Pmv_Viewer_16.menu.add_separator()
Pmv_Viewer_16.menu.add_command(label='Restore states', command=Pmv_Viewer_16.restoreStates_cb)

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 0) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        # create communication socket
        import socket
        HOST = ''                 # Symbolic name meaning the local host
        PORT = 50010              # Arbitrary non-privileged port
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.bind((HOST, PORT))
        s.listen(5)
        s.setblocking(0)
        masterNet.socket = s
        masterNet.socketConnections = []
        masterNet.HOST = HOST
        masterNet.PORT = PORT

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

