#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 30 July 2009 16:41:11 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header$
#
# $Id$
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from Pmv.VisionInterface.PmvNodes import pmvlib
from Volume.VisionInterface.VolumeNodes import vollib
from Vision.StandardNodes import stdlib
from MolKit.VisionInterface.MolKitNodes import molkitlib
from DejaVu.VisionInterface.DejaVuNodes import vizlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(pmvlib,"Pmv.VisionInterface.PmvNodes", "pmvlib")

masterNet.getEditor().addLibraryInstance(vollib,"Volume.VisionInterface.VolumeNodes", "vollib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

masterNet.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

try:
    ## saving node Select MolFrag ##
    from MolKit.VisionInterface.MolKitNodes import NodeSelector
    Select_MolFrag_0 = NodeSelector(constrkw={}, name='Select MolFrag', library=molkitlib)
    masterNet.addNode(Select_MolFrag_0,208,117)
    Select_MolFrag_0.inputPortByName['nodeType'].widget.set(r"Atom", run=False)
    Select_MolFrag_0.inputPortByName['selectionString'].widget.set(r"CA", run=False)
    apply(Select_MolFrag_0.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore NodeSelector named Select MolFrag in network masterNet"
    print_exc()
    Select_MolFrag_0=None

try:
    ## saving node Extract Atom Property ##
    from MolKit.VisionInterface.MolKitNodes import AtomsProperty
    Extract_Atom_Property_1 = AtomsProperty(constrkw={}, name='Extract Atom Property', library=molkitlib)
    masterNet.addNode(Extract_Atom_Property_1,110,170)
    Extract_Atom_Property_1.inputPortByName['propertyName'].widget.set(r"coords", run=False)
    apply(Extract_Atom_Property_1.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore AtomsProperty named Extract Atom Property in network masterNet"
    print_exc()
    Extract_Atom_Property_1=None

try:
    ## saving node UT-BlurSpheres(1) ##
    from Volume.VisionInterface.VolumeNodes import UTblurSpheres
    UT_BlurSpheres_1__2 = UTblurSpheres(constrkw={}, name='UT-BlurSpheres(1)', library=vollib)
    masterNet.addNode(UT_BlurSpheres_1__2,221,288)
    UT_BlurSpheres_1__2.inputPortByName['blobbyness'].widget.set(-0.7, run=False)
    UT_BlurSpheres_1__2.inputPortByName['oneRes'].widget.set(1, run=False)
    apply(UT_BlurSpheres_1__2.inputPortByName['resX'].widget.configure, (), {'labelCfg': {'text': 'X res  (Xdim=31)       '}})
    UT_BlurSpheres_1__2.inputPortByName['resX'].widget.set(1.5, run=False)
    apply(UT_BlurSpheres_1__2.inputPortByName['resY'].widget.configure, (), {'labelCfg': {'text': 'Y res  (Ydim=32)       '}})
    UT_BlurSpheres_1__2.inputPortByName['resY'].widget.set(1.5, run=False)
    apply(UT_BlurSpheres_1__2.inputPortByName['resZ'].widget.configure, (), {'labelCfg': {'text': 'Z res  (Zdim=31)       '}})
    UT_BlurSpheres_1__2.inputPortByName['resZ'].widget.set(1.5, run=False)
    apply(UT_BlurSpheres_1__2.inputPortByName['switch'].widget.configure, (), {'command': UT_BlurSpheres_1__2.usedims_cb})
    UT_BlurSpheres_1__2.inputPortByName['switch'].widget.set(0, run=False)
    UT_BlurSpheres_1__2.inputPortByName['dims'].widget.set(r"", run=False)
except:
    print "WARNING: failed to restore UTblurSpheres named UT-BlurSpheres(1) in network masterNet"
    print_exc()
    UT_BlurSpheres_1__2=None

try:
    ## saving node Dial ##
    from Vision.StandardNodes import DialNE
    Dial_3 = DialNE(constrkw={}, name='Dial', library=stdlib)
    masterNet.addNode(Dial_3,340,232)
    Dial_3.inputPortByName['dial'].widget.set(3.0, run=False)
    apply(Dial_3.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore DialNE named Dial in network masterNet"
    print_exc()
    Dial_3=None

try:
    ## saving node UT-Isocontour ##
    from Volume.VisionInterface.VolumeNodes import Isocontour
    UT_Isocontour_4 = Isocontour(constrkw={}, name='UT-Isocontour', library=vollib)
    masterNet.addNode(UT_Isocontour_4,143,341)
    apply(UT_Isocontour_4.inputPortByName['isovalue'].widget.configure, (), {'max': 5.8188228607177734, 'min': 0.0})
    UT_Isocontour_4.inputPortByName['isovalue'].widget.set(1.25504032771, run=False)
    UT_Isocontour_4.inputPortByName['calculatesignatures'].widget.set(0, run=False)
    UT_Isocontour_4.inputPortByName['verbosity'].widget.set(0, run=False)
except:
    print "WARNING: failed to restore Isocontour named UT-Isocontour in network masterNet"
    print_exc()
    UT_Isocontour_4=None

try:
    ## saving node heme2DChain ##
    from DejaVu.VisionInterface.GeometryNodes import IndexedPolygonsNE
    heme2DChain_5 = IndexedPolygonsNE(constrkw={}, name='heme2DChain', library=vizlib)
    masterNet.addNode(heme2DChain_5,143,413)
    heme2DChain_5.inputPortByName['name'].rebindWidget()
    heme2DChain_5.inputPortByName['name'].widget.set(r"", run=False)
    heme2DChain_5.inputPortByName['name'].unbindWidget()
    heme2DChain_5.inputPortByName['geoms'].widget.set(r"heme2DChain", run=False)
    apply(heme2DChain_5.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore IndexedPolygonsNE named heme2DChain in network masterNet"
    print_exc()
    heme2DChain_5=None

try:
    ## saving node Pmv Viewer ##
    from Pmv.VisionInterface.PmvNodes import PmvViewer
    Pmv_Viewer_6 = PmvViewer(viewer=masterNet.editor.vf.GUI.VIEWER, constrkw={'viewer': 'masterNet.editor.vf.GUI.VIEWER'}, name='Pmv Viewer', library=pmvlib)
    masterNet.addNode(Pmv_Viewer_6,258,591)
    ##
        ## Saving State for Viewer
    Pmv_Viewer_6.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0, 0, 0, 1), 'd2off': 1, 'height': 453, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 466, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 688, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -128.91843], 'd2cutH': 255, 'far': 326.58625031702718, 'd1off': 4, 'lookFrom': [0.0, 0.0, 128.91843], 'd1cutH': 60, 'antialiased': False, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 120.0, 121.0, 122.0, 123.0, 124.0, 125.0, 126.0, 127.0, 128.0, 129.0, 130.0, 131.0, 132.0, 133.0, 134.0, 135.0, 136.0, 137.0, 138.0, 139.0, 140.0, 141.0, 142.0, 143.0, 144.0, 145.0, 146.0, 147.0, 148.0, 149.0, 150.0, 151.0, 152.0, 153.0, 154.0, 155.0, 156.0, 157.0, 158.0, 159.0, 160.0, 161.0, 162.0, 163.0, 164.0, 165.0, 166.0, 167.0, 168.0, 169.0, 170.0, 171.0, 172.0, 173.0, 174.0, 175.0, 176.0, 177.0, 178.0, 179.0, 180.0, 181.0, 182.0, 183.0, 184.0, 185.0, 186.0, 187.0, 188.0, 189.0, 190.0, 191.0, 192.0, 193.0, 194.0, 195.0, 196.0, 197.0, 198.0, 199.0, 200.0, 201.0, 202.0, 203.0, 204.0, 205.0, 206.0, 207.0, 208.0, 209.0, 210.0, 211.0, 212.0, 213.0, 214.0, 215.0, 216.0, 217.0, 218.0, 219.0, 220.0, 221.0, 222.0, 223.0, 224.0, 225.0, 226.0, 227.0, 228.0, 229.0, 230.0, 231.0, 232.0, 233.0, 234.0, 235.0, 236.0, 237.0, 238.0, 239.0, 240.0, 241.0, 242.0, 243.0, 244.0, 245.0, 246.0, 247.0, 248.0, 249.0, 250.0, 251.0, 252.0, 253.0, 254.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 161, 'd1scale': 0.080000000000000002}
    apply(Pmv_Viewer_6.vi.cameras[0].Set, (), state)

    state = {'end': 163.29312515851359, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 94.54371980487025, 'mode': 'GL_LINEAR'}
    apply(Pmv_Viewer_6.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [84.629219055175781, 43.604473114013672, 2.0353817939758301], 'rotation': [0.27641186, -0.090043552, -0.95681173, 0.0, -0.95166111, -0.16439335, -0.25945318, 0.0, -0.1339314, 0.98227644, -0.13113122, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-84.629219, -43.604473, -2.0353856], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(Pmv_Viewer_6.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Pmv_Viewer_6.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Pmv_Viewer_6.vi.rootObject:
        Pmv_Viewer_6.vi.rootObject.clipP = []
        Pmv_Viewer_6.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore PmvViewer named Pmv Viewer in network masterNet"
    print_exc()
    Pmv_Viewer_6=None

try:
    ## saving node Select MolFrag ##
    from MolKit.VisionInterface.MolKitNodes import NodeSelector
    Select_MolFrag_7 = NodeSelector(constrkw={}, name='Select MolFrag', library=molkitlib)
    masterNet.addNode(Select_MolFrag_7,168,14)
    Select_MolFrag_7.inputPortByName['nodeType'].widget.set(r"Chain", run=False)
    Select_MolFrag_7.inputPortByName['selectionString'].widget.set(r"A,B,C,D", run=False)
    apply(Select_MolFrag_7.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore NodeSelector named Select MolFrag in network masterNet"
    print_exc()
    Select_MolFrag_7=None

try:
    ## saving node iterate ##
    from Vision.StandardNodes import Iterate
    iterate_8 = Iterate(constrkw={}, name='iterate', library=stdlib)
    masterNet.addNode(iterate_8,13,69)
    apply(iterate_8.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Iterate named iterate in network masterNet"
    print_exc()
    iterate_8=None

try:
    ## saving node Get id ##
    from Vision.StandardNodes import GetAttr
    Get_id_9 = GetAttr(constrkw={}, name='Get id', library=stdlib)
    masterNet.addNode(Get_id_9,43,236)
    apply(Get_id_9.inputPortByName['attr'].widget.configure, (), {'choices': ['AAradii', 'AtomRadiiPatterns', 'NodesFromName', '_MarkTree', '__cmp__', '__doc__', '__eq__', '__hash__', '__init__', '__module__', '__ne__', '__repr__', '__str__', '_atomRadius', '_copyNode', '_numberOfDeletedNodes', '_uniqIndex', 'addBond', 'adopt', 'assignUniqIndex', 'attach_nonbonded_fragments', 'bonds', 'buildBondsBhtree', 'buildBondsByDistance', 'buildBondsByDistanceOnAtoms', 'buildBrokenBonds', 'childByName', 'children', 'childrenName', 'childrenSetClass', 'closerThan', 'compare', 'compiled_patterns', 'configureProgressBar', 'connectResidues', 'defaultRadii', 'deleteSubTree', 'dump', 'elementType', 'findLevels', 'findType', 'full_name', 'gaps', 'get', 'getAtoms', 'getCenter', 'getNbrAtoms', 'getNext', 'getParentOfType', 'getPrevious', 'getRoot', 'getTypeList', 'hasBonds', 'id', 'isAbove', 'isBelow', 'isDna', 'isHetatmChain', 'isProteic', 'makeNameUniq', 'merge', 'mergeNPH', 'name', 'number', 'p', 'parent', 'parser', 'read', 'remove', 'removeAllHydrogens', 'removeBond', 'residues', 'secondaryStructure', 'setClass', 'shortestDist', 'split', 'subTree', 'top', 'updateProgressBar', 'write']})
    Get_id_9.inputPortByName['attr'].widget.set(r"id", run=False)
    apply(Get_id_9.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore GetAttr named Get id in network masterNet"
    print_exc()
    Get_id_9=None

try:
    ## saving node Filename ##
    from Vision.StandardNodes import Filename
    Filename_10 = Filename(constrkw={}, name='Filename', library=stdlib)
    masterNet.addNode(Filename_10,36,368)
    apply(Filename_10.inputPortByName['number'].configure, (), {'datatype': 'string', 'originalDatatype': 'int'})
    Filename_10.inputPortByName['format'].widget.set(r"heme2%sChain", run=False)
    apply(Filename_10.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Filename named Filename in network masterNet"
    print_exc()
    Filename_10=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_11 = Index(constrkw={}, name='Index', library=stdlib)
    masterNet.addNode(Index_11,35,305)
    apply(Index_11.inputPortByName['index'].widget.configure, (), {'max': 0, 'min': -1})
    Index_11.inputPortByName['index'].widget.set(0, run=False)
    apply(Index_11.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_11=None

try:
    ## saving node RemoveDupVert ##
    from DejaVu.VisionInterface.DejaVuNodes import RemoveDuplicatedVerticesNE
    RemoveDupVert_12 = RemoveDuplicatedVerticesNE(constrkw={}, name='RemoveDupVert', library=vizlib)
    masterNet.addNode(RemoveDupVert_12,7,451)
    RemoveDupVert_12.inputPortByName['newGeom'].widget.set(0, run=False)
    apply(RemoveDupVert_12.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore RemoveDuplicatedVerticesNE named RemoveDupVert in network masterNet"
    print_exc()
    RemoveDupVert_12=None

try:
    ## saving node QSlim ##
    from DejaVu.VisionInterface.DejaVuNodes import QSlim
    QSlim_13 = QSlim(constrkw={}, name='QSlim', library=vizlib)
    masterNet.addNode(QSlim_13,40,503)
    apply(QSlim_13.inputPortByName['percent'].widget.configure, (), {'continuous': None})
    QSlim_13.inputPortByName['percent'].widget.set(50.0, run=False)
    QSlim_13.inputPortByName['targetfaces'].widget.set(r"4074", run=False)
    QSlim_13.inputPortByName['rebuild'].widget.set(0, run=False)
except:
    print "WARNING: failed to restore QSlim named QSlim in network masterNet"
    print_exc()
    QSlim_13=None

try:
    ## saving node hemoglobin_deoxy ##
    import os
    from mglutil.util.relpath import rel2abs
    lRelFileName = 'hemoglobin-deoxy.pdb'
    lNetworkDir = os.path.dirname(os.path.abspath(masterNet.filename))
    lAbsFileName = rel2abs(lRelFileName, lNetworkDir)
    mol = masterNet.editor.vf.loadMoleculeIfNeeded(lAbsFileName)
    assert mol
    from Pmv.VisionInterface.PmvNodes import PmvMolecule
    hemoglobin_deoxy_14 = PmvMolecule(molecule=masterNet.editor.vf.expandNodes("hemoglobin_deoxy")[0], constrkw={'molecule': 'masterNet.editor.vf.expandNodes("hemoglobin_deoxy")[0]'}, name='hemoglobin_deoxy', library=pmvlib)
    masterNet.addNode(hemoglobin_deoxy_14,21,5)
except:
    print "WARNING: failed to restore PmvMolecule named hemoglobin_deoxy in network masterNet"
    print_exc()
    hemoglobin_deoxy_14=None

try:
    ## saving node Pmv ##
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_15 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    masterNet.addNode(Pmv_15,405,31)
    Pmv_15.inputPortByName['cmdName'].widget.set(r"bindGeomToMolecularFragment", run=False)
    Pmv_15.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_15.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore PmvNode named Pmv in network masterNet"
    print_exc()
    Pmv_15=None

try:
    ## saving node bindGeomToMolecularFragment ##
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    bindGeomToMolecularFragment_16 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.bindGeomToMolecularFragment, namedArgs={'cutoff_to': 40.0, 'instanceMatrices': None, 'cutoff_from': 3.5}, posArgsNames=['geom', 'nodes'], constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.bindGeomToMolecularFragment', 'namedArgs': {'cutoff_to': 40.0, 'instanceMatrices': None, 'cutoff_from': 3.5}, 'posArgsNames': ['geom', 'nodes']}, name='bindGeomToMolecularFragment', library=pmvlib)
    masterNet.addNode(bindGeomToMolecularFragment_16,448,503)
    apply(bindGeomToMolecularFragment_16.inputPortByName['geom'].configure, (), {'datatype': 'geomOrInsert2d', 'originalDatatype': 'None'})
    bindGeomToMolecularFragment_16.inputPortByName['importString'].widget.set(r"", run=False)
    bindGeomToMolecularFragment_16.inputPortByName['cutoff_to'].widget.set(40.0, run=False)
    bindGeomToMolecularFragment_16.inputPortByName['cutoff_from'].widget.set(3.5, run=False)
    apply(bindGeomToMolecularFragment_16.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore PmvRunCommand named bindGeomToMolecularFragment in network masterNet"
    print_exc()
    bindGeomToMolecularFragment_16=None

#masterNet.run()
masterNet.freeze()

## saving connections for network hemoglobin2 ##
if Select_MolFrag_0 is not None and Extract_Atom_Property_1 is not None:
    try:
        masterNet.connectNodes(
            Select_MolFrag_0, Extract_Atom_Property_1, "nodes", "atoms", blocking=True
            , splitratio=[0.54743802682586962, 0.60548420021485194])
    except:
        print "WARNING: failed to restore connection between Select_MolFrag_0 and Extract_Atom_Property_1 in network masterNet"
if Dial_3 is not None and UT_BlurSpheres_1__2 is not None:
    try:
        masterNet.connectNodes(
            Dial_3, UT_BlurSpheres_1__2, "value", "radius", blocking=True
            , splitratio=[0.30596955786735602, 0.242680836631611])
    except:
        print "WARNING: failed to restore connection between Dial_3 and UT_BlurSpheres_1__2 in network masterNet"
if Extract_Atom_Property_1 is not None and UT_BlurSpheres_1__2 is not None:
    try:
        masterNet.connectNodes(
            Extract_Atom_Property_1, UT_BlurSpheres_1__2, "propertyValues", "coords", blocking=True
            , splitratio=[0.36201915670025014, 0.74316543765008558])
    except:
        print "WARNING: failed to restore connection between Extract_Atom_Property_1 and UT_BlurSpheres_1__2 in network masterNet"
if UT_BlurSpheres_1__2 is not None and UT_Isocontour_4 is not None:
    try:
        masterNet.connectNodes(
            UT_BlurSpheres_1__2, UT_Isocontour_4, "maskGrid", "grid3D", blocking=True
            , splitratio=[0.36899409462726218, 0.27826873261633189])
    except:
        print "WARNING: failed to restore connection between UT_BlurSpheres_1__2 and UT_Isocontour_4 in network masterNet"
if UT_Isocontour_4 is not None and heme2DChain_5 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_4, heme2DChain_5, "normals", "vnormals", blocking=True
            , splitratio=[0.47276029831024907, 0.39580156298380109])
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_4 and heme2DChain_5 in network masterNet"
if UT_Isocontour_4 is not None and heme2DChain_5 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_4, heme2DChain_5, "indices", "indices", blocking=True
            , splitratio=[0.45044662270362512, 0.37909754714710076])
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_4 and heme2DChain_5 in network masterNet"
if UT_Isocontour_4 is not None and heme2DChain_5 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_4, heme2DChain_5, "coords", "coords", blocking=True
            , splitratio=[0.70634122836070246, 0.52319341869422753])
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_4 and heme2DChain_5 in network masterNet"
if Select_MolFrag_7 is not None and iterate_8 is not None:
    try:
        masterNet.connectNodes(
            Select_MolFrag_7, iterate_8, "nodes", "listToLoopOver", blocking=True
            , splitratio=[0.60284244141570065, 0.38284199026338339])
    except:
        print "WARNING: failed to restore connection between Select_MolFrag_7 and iterate_8 in network masterNet"
if iterate_8 is not None and Get_id_9 is not None:
    try:
        masterNet.connectNodes(
            iterate_8, Get_id_9, "oneItem", "objects", blocking=True
            , splitratio=[0.69489913123297287, 0.73133498144410702])
    except:
        print "WARNING: failed to restore connection between iterate_8 and Get_id_9 in network masterNet"
if Get_id_9 is not None and Index_11 is not None:
    try:
        masterNet.connectNodes(
            Get_id_9, Index_11, "attrs", "data", blocking=True
            , splitratio=[0.28513263548728507, 0.74383160859326547])
    except:
        print "WARNING: failed to restore connection between Get_id_9 and Index_11 in network masterNet"
if Index_11 is not None and Filename_10 is not None:
    try:
        masterNet.connectNodes(
            Index_11, Filename_10, "data", "number", blocking=True
            , splitratio=[0.687852935022367, 0.69678311194587716])
    except:
        print "WARNING: failed to restore connection between Index_11 and Filename_10 in network masterNet"
if Filename_10 is not None and heme2DChain_5 is not None:
    try:
        masterNet.connectNodes(
            Filename_10, heme2DChain_5, "filename", "name", blocking=True
            , splitratio=[0.33603491818072662, 0.34671197074364069])
    except:
        print "WARNING: failed to restore connection between Filename_10 and heme2DChain_5 in network masterNet"
if heme2DChain_5 is not None and RemoveDupVert_12 is not None:
    try:
        masterNet.connectNodes(
            heme2DChain_5, RemoveDupVert_12, "indexedPolygons", "geom", blocking=True
            , splitratio=[0.29060965822243479, 0.59942464655985217])
    except:
        print "WARNING: failed to restore connection between heme2DChain_5 and RemoveDupVert_12 in network masterNet"
if RemoveDupVert_12 is not None and QSlim_13 is not None:
    try:
        masterNet.connectNodes(
            RemoveDupVert_12, QSlim_13, "geom", "geometry", blocking=True
            , splitratio=[0.63487449261102302, 0.43201336097138571])
    except:
        print "WARNING: failed to restore connection between RemoveDupVert_12 and QSlim_13 in network masterNet"
if QSlim_13 is not None and Pmv_Viewer_6 is not None:
    try:
        masterNet.connectNodes(
            QSlim_13, Pmv_Viewer_6, "geometry", "geometries", blocking=True
            , splitratio=[0.58983359839815297, 0.7366399741264873])
    except:
        print "WARNING: failed to restore connection between QSlim_13 and Pmv_Viewer_6 in network masterNet"
if iterate_8 is not None and Select_MolFrag_0 is not None:
    try:
        masterNet.connectNodes(
            iterate_8, Select_MolFrag_0, "oneItem", "nodes", blocking=True
            , splitratio=[0.87131469163096131, 1.6071428571428572])
    except:
        print "WARNING: failed to restore connection between iterate_8 and Select_MolFrag_0 in network masterNet"
if hemoglobin_deoxy_14 is not None and Select_MolFrag_7 is not None:
    try:
        masterNet.connectNodes(
            hemoglobin_deoxy_14, Select_MolFrag_7, "Molecule", "nodes", blocking=True
            , splitratio=[0.72667431545495198, 0.43211535257000172])
    except:
        print "WARNING: failed to restore connection between hemoglobin_deoxy_14 and Select_MolFrag_7 in network masterNet"
if Pmv_15 is not None and bindGeomToMolecularFragment_16 is not None:
    try:
        masterNet.connectNodes(
            Pmv_15, bindGeomToMolecularFragment_16, "cmd", "command", blocking=True
            , splitratio=[0.59370979045120176, 0.57119065103355116])
    except:
        print "WARNING: failed to restore connection between Pmv_15 and bindGeomToMolecularFragment_16 in network masterNet"
if heme2DChain_5 is not None and bindGeomToMolecularFragment_16 is not None:
    try:
        masterNet.connectNodes(
            heme2DChain_5, bindGeomToMolecularFragment_16, "indexedPolygons", "geom", blocking=True
            , splitratio=[0.67028904599737338, 0.62254683861646554])
    except:
        print "WARNING: failed to restore connection between heme2DChain_5 and bindGeomToMolecularFragment_16 in network masterNet"
if Select_MolFrag_0 is not None and bindGeomToMolecularFragment_16 is not None:
    try:
        masterNet.connectNodes(
            Select_MolFrag_0, bindGeomToMolecularFragment_16, "nodes", "nodes", blocking=True
            , splitratio=[0.55437913059526833, 0.43626361937322911])
    except:
        print "WARNING: failed to restore connection between Select_MolFrag_0 and bindGeomToMolecularFragment_16 in network masterNet"
masterNet.runOnNewData.value = False


def loadSavedStates_Pmv_Viewer_6(self=Pmv_Viewer_6, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|misc
    ## Object root|AutoLigand_geoms
    ## Object root|CoarseAPBSbox
    ## Object root|FineAPBSbox
    ## Object root|hemoglobin_deoxy
    ## Object root|misc|addBondsGeom
    ## Object root|misc|edit_geoms
    ## Object root|misc|repair_geoms
    ## Object root|misc|measure_geoms
    ## Object root|misc|setTorsionGeom
    ## Object root|misc|selectInSphereGeoms
    ## Object root|AutoLigand_geoms|Cross
    ## Object root|AutoLigand_geoms|Box
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': 0, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'line', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': 0, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 1, 'pickableVertices': True, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': 0, 'shading': 'flat', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'Box', 'backPolyMode': 'line', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': True, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|AutoLigand_geoms|Box')
    if obj:
        apply(obj.Set, (), state)

    ## Material for Box
    if obj:
        from opengltk.OpenGL import GL
        state = {'shininess': [13.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'binding': [10.0, 12.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for Box

    ## Clipping Planes for Box
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for Box

    ## Object root|AutoLigand_geoms|Spheres
    ## Object root|AutoLigand_geoms|Halo
    ## Object root|hemoglobin_deoxy|selection
    ## Object root|hemoglobin_deoxy|lines
    ## Object root|hemoglobin_deoxy|AtomLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'AtomLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (0.29999999999999999, 0.29999999999999999, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|hemoglobin_deoxy|AtomLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for AtomLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for AtomLabels

    ## Clipping Planes for AtomLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for AtomLabels

    ## Object root|hemoglobin_deoxy|ResidueLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'ResidueLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (0.59999999999999998, 0.59999999999999998, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|hemoglobin_deoxy|ResidueLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for ResidueLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for ResidueLabels

    ## Clipping Planes for ResidueLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for ResidueLabels

    ## Object root|hemoglobin_deoxy|ChainLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'ChainLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (0.89999999999999991, 0.89999999999999991, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|hemoglobin_deoxy|ChainLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for ChainLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for ChainLabels

    ## Clipping Planes for ChainLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for ChainLabels

    ## Object root|hemoglobin_deoxy|ProteinLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'ProteinLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (1.2, 1.2, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|hemoglobin_deoxy|ProteinLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for ProteinLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for ProteinLabels

    ## Clipping Planes for ProteinLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for ProteinLabels

    ## Object root|hemoglobin_deoxy|sticks
    ## Object root|hemoglobin_deoxy|balls
    ## Object root|hemoglobin_deoxy|cpk
    ## Object root|hemoglobin_deoxy|CAsticks
    ## Object root|hemoglobin_deoxy|CAballs
    ## Object root|hemoglobin_deoxy|heme2AChain
    ## Object root|hemoglobin_deoxy|heme2BChain
    ## Object root|hemoglobin_deoxy|heme2CChain
    ## Object root|hemoglobin_deoxy|heme2DChain
    ## Object root|misc|addBondsGeom|addBondsSpheres
    ## Object root|misc|edit_geoms|editAtomTypeSphere
    ## Object root|misc|edit_geoms|editAtomChargeSphere
    ## Object root|misc|repair_geoms|closeContactGeoms
    ## Object root|misc|measure_geoms|measureDistGeomCtrl
    ## Object root|misc|measure_geoms|measureDistGeom
    ## Object root|misc|measure_geoms|measureAngleGeom
    ## Object root|misc|measure_geoms|measureTorsionGeom
    ## Object root|misc|setTorsionGeom|settorsionLine
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 1, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'settorsionLine', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': True, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|misc|setTorsionGeom|settorsionLine')
    if obj:
        apply(obj.Set, (), state)

    ## Material for settorsionLine
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [13.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[0.0, 1.0, 1.0, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for settorsionLine

    ## Clipping Planes for settorsionLine
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for settorsionLine

    ## Object root|misc|setTorsionGeom|settorsionLabel
    ## Object root|misc|setTorsionGeom|settorsionSpheres
    ## Object root|misc|selectInSphereGeoms|SelSphReg_selSph
    ## Object root|misc|selectInSphereGeoms|SelSphReg_cenCross
    ## Object root|hemoglobin_deoxy|lines|bonded
    ## Object root|hemoglobin_deoxy|lines|nobnds
    ## Object root|hemoglobin_deoxy|lines|bondorder
    ## Object root|misc|repair_geoms|closeContactGeoms|closeContLines
    ## Object root|misc|repair_geoms|closeContactGeoms|closeContLabels
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLine
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLabel
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distSpheres
    ## Object root|misc|measure_geoms|measureDistGeom|distLine
    ## Object root|misc|measure_geoms|measureDistGeom|distLabel
    ## Object root|misc|measure_geoms|measureDistGeom|distSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLine
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLabel
    ## Object root|misc|measure_geoms|measureAngleGeom|angleSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angles
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 1, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': False, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'angles', 'backPolyMode': 'fill', 'inheritFrontPolyMode': 0, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'inheritLineWidth': True, 'lineWidth': 1, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|misc|measure_geoms|measureAngleGeom|angles')
    if obj:
        apply(obj.Set, (), state)

    ## Material for angles
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[1.0, 0.5, 0.0, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for angles

    ## Clipping Planes for angles
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for angles

    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLine
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLabel
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres
    ## End Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres

    ##
        ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0, 0, 0, 1), 'd2off': 1, 'height': 453, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 688, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -128.91843], 'd2cutH': 255, 'far': 326.58625031702718, 'd1off': 4, 'lookFrom': [0.0, 0.0, 128.91843], 'd1cutH': 60, 'antialiased': False, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 120.0, 121.0, 122.0, 123.0, 124.0, 125.0, 126.0, 127.0, 128.0, 129.0, 130.0, 131.0, 132.0, 133.0, 134.0, 135.0, 136.0, 137.0, 138.0, 139.0, 140.0, 141.0, 142.0, 143.0, 144.0, 145.0, 146.0, 147.0, 148.0, 149.0, 150.0, 151.0, 152.0, 153.0, 154.0, 155.0, 156.0, 157.0, 158.0, 159.0, 160.0, 161.0, 162.0, 163.0, 164.0, 165.0, 166.0, 167.0, 168.0, 169.0, 170.0, 171.0, 172.0, 173.0, 174.0, 175.0, 176.0, 177.0, 178.0, 179.0, 180.0, 181.0, 182.0, 183.0, 184.0, 185.0, 186.0, 187.0, 188.0, 189.0, 190.0, 191.0, 192.0, 193.0, 194.0, 195.0, 196.0, 197.0, 198.0, 199.0, 200.0, 201.0, 202.0, 203.0, 204.0, 205.0, 206.0, 207.0, 208.0, 209.0, 210.0, 211.0, 212.0, 213.0, 214.0, 215.0, 216.0, 217.0, 218.0, 219.0, 220.0, 221.0, 222.0, 223.0, 224.0, 225.0, 226.0, 227.0, 228.0, 229.0, 230.0, 231.0, 232.0, 233.0, 234.0, 235.0, 236.0, 237.0, 238.0, 239.0, 240.0, 241.0, 242.0, 243.0, 244.0, 245.0, 246.0, 247.0, 248.0, 249.0, 250.0, 251.0, 252.0, 253.0, 254.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.080000000000000002}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 163.29312515851359, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 94.54371980487025, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [84.629219055175781, 43.604473114013672, 2.0353817939758301], 'rotation': [0.27641186, -0.090043552, -0.95681173, 0.0, -0.95166111, -0.16439335, -0.25945318, 0.0, -0.1339314, 0.98227644, -0.13113122, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-84.629219, -43.604473, -2.0353856], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Pmv_Viewer_6.restoreStates_cb = Pmv_Viewer_6.restoreStatesFirstRun = loadSavedStates_Pmv_Viewer_6
Pmv_Viewer_6.menu.add_separator()
Pmv_Viewer_6.menu.add_command(label='Restore states', command=Pmv_Viewer_6.restoreStates_cb)

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 0) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        # create communication socket
        import socket
        HOST = ''                 # Symbolic name meaning the local host
        PORT = 50010              # Arbitrary non-privileged port
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.bind((HOST, PORT))
        s.listen(5)
        s.setblocking(0)
        masterNet.socket = s
        masterNet.socketConnections = []
        masterNet.HOST = HOST
        masterNet.PORT = PORT

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

