/* valagdbusmodule.c generated by valac, the Vala compiler
 * generated from valagdbusmodule.vala, do not modify */

/* valagdbusmodule.vala
 *
 * Copyright (C) 2010-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <valagee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))


static gpointer vala_gd_bus_module_parent_class = NULL;

static void vala_gd_bus_module_real_visit_error_domain (ValaCodeVisitor* base,
                                                 ValaErrorDomain* edomain);
static gboolean vala_gd_bus_module_is_file_descriptor (ValaGDBusModule* self,
                                                ValaDataType* type);
static ValaCCodeExpression* vala_gd_bus_module_get_file_descriptor (ValaGDBusModule* self,
                                                             ValaDataType* type,
                                                             ValaCCodeExpression* expr);
static ValaCCodeExpression* vala_gd_bus_module_create_from_file_descriptor (ValaGDBusModule* self,
                                                                     ValaDataType* type,
                                                                     ValaCCodeExpression* expr);
static ValaCCodeExpression* vala_gd_bus_module_get_method_info (ValaGDBusModule* self,
                                                         ValaObjectTypeSymbol* sym);
static ValaCCodeExpression* vala_gd_bus_module_get_signal_info (ValaGDBusModule* self,
                                                         ValaObjectTypeSymbol* sym);
static ValaCCodeExpression* vala_gd_bus_module_get_property_info (ValaGDBusModule* self,
                                                           ValaObjectTypeSymbol* sym);
static void vala_gd_bus_module_declare_interface_info (ValaGDBusModule* self,
                                                ValaObjectTypeSymbol* sym);
static void vala_gd_bus_module_real_visit_class (ValaCodeVisitor* base,
                                          ValaClass* cl);
static void vala_gd_bus_module_visit_object_type_symbol (ValaGDBusModule* self,
                                                  ValaObjectTypeSymbol* sym);
static void vala_gd_bus_module_real_visit_interface (ValaCodeVisitor* base,
                                              ValaInterface* iface);


gchar*
vala_gd_bus_module_get_dbus_name (ValaTypeSymbol* symbol)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) symbol, "DBus", "name", NULL);
	result = _tmp0_;
	return result;
}


gchar*
vala_gd_bus_module_get_dbus_name_for_member (ValaSymbol* symbol)
{
	gchar* result = NULL;
	gchar* dbus_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) symbol, "DBus", "name", NULL);
	dbus_name = _tmp0_;
	_tmp1_ = dbus_name;
	if (_tmp1_ != NULL) {
		result = dbus_name;
		return result;
	}
	_tmp2_ = vala_symbol_get_name (symbol);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_symbol_lower_case_to_camel_case (_tmp3_);
	result = _tmp4_;
	_g_free0 (dbus_name);
	return result;
}


gint
vala_gd_bus_module_get_dbus_timeout_for_member (ValaSymbol* symbol)
{
	gint result = 0;
	g_return_val_if_fail (symbol != NULL, 0);
	result = vala_code_node_get_attribute_integer ((ValaCodeNode*) symbol, "DBus", "timeout", -1);
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


gboolean
vala_gd_bus_module_is_dbus_visible (ValaCodeNode* node)
{
	gboolean result = FALSE;
	ValaAttribute* dbus_attribute = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaAttribute* _tmp4_;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute (node, "DBus");
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	dbus_attribute = _tmp1_;
	_tmp4_ = dbus_attribute;
	if (_tmp4_ != NULL) {
		ValaAttribute* _tmp5_;
		_tmp5_ = dbus_attribute;
		_tmp3_ = vala_attribute_has_argument (_tmp5_, "visible");
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaAttribute* _tmp6_;
		_tmp6_ = dbus_attribute;
		_tmp2_ = !vala_attribute_get_bool (_tmp6_, "visible", FALSE);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = FALSE;
		_vala_code_node_unref0 (dbus_attribute);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (dbus_attribute);
	return result;
}


gboolean
vala_gd_bus_module_is_dbus_no_reply (ValaMethod* m)
{
	gboolean result = FALSE;
	g_return_val_if_fail (m != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) m, "DBus", "no_reply", FALSE);
	return result;
}


gchar*
vala_gd_bus_module_dbus_result_name (ValaMethod* m)
{
	gchar* result = NULL;
	gchar* dbus_name = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp4_;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) m, "DBus", "result", NULL);
	dbus_name = _tmp0_;
	_tmp2_ = dbus_name;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = dbus_name;
		_tmp1_ = g_strcmp0 (_tmp3_, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = dbus_name;
		return result;
	}
	_tmp4_ = g_strdup ("result");
	result = _tmp4_;
	_g_free0 (dbus_name);
	return result;
}


static void
vala_gd_bus_module_real_visit_error_domain (ValaCodeVisitor* base,
                                            ValaErrorDomain* edomain)
{
	ValaGDBusModule * self;
	gchar* edomain_dbus_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	ValaCCodeFile* _tmp2_;
	ValaCCodeFile* _tmp3_;
	ValaCCodeInitializerList* error_entries = NULL;
	ValaCCodeInitializerList* _tmp6_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp42_;
	ValaCCodeDeclaration* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	ValaCCodeInitializerList* _tmp48_;
	ValaCCodeVariableDeclarator* _tmp49_;
	ValaCCodeVariableDeclarator* _tmp50_;
	ValaCCodeDeclaration* _tmp51_;
	ValaCCodeFile* _tmp52_;
	ValaCCodeDeclaration* _tmp53_;
	gchar* quark_fun_name = NULL;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	ValaCCodeFunction* cquark_fun = NULL;
	const gchar* _tmp58_;
	ValaDataType* _tmp59_;
	ValaTypeSymbol* _tmp60_;
	ValaTypeSymbol* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	ValaCCodeFunction* _tmp64_;
	ValaCCodeFunction* _tmp65_;
	ValaCCodeFunction* _tmp66_;
	gchar* quark_name = NULL;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	ValaCCodeFunction* _tmp71_;
	ValaCCodeFunction* _tmp72_;
	const gchar* _tmp73_;
	ValaCCodeConstant* _tmp74_;
	ValaCCodeConstant* _tmp75_;
	ValaCCodeVariableDeclarator* _tmp76_;
	ValaCCodeVariableDeclarator* _tmp77_;
	ValaCCodeFunctionCall* register_call = NULL;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeIdentifier* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeFunctionCall* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	ValaCCodeConstant* _tmp89_;
	ValaCCodeConstant* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	const gchar* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeUnaryExpression* _tmp95_;
	ValaCCodeUnaryExpression* _tmp96_;
	ValaCCodeFunctionCall* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeIdentifier* _tmp103_;
	ValaCCodeFunctionCall* nentries = NULL;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeFunctionCall* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeFunctionCall* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	ValaCCodeIdentifier* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeFunctionCall* _tmp115_;
	ValaCCodeFunctionCall* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunction* _tmp118_;
	ValaCCodeFunctionCall* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	ValaCCodeFunction* _tmp121_;
	const gchar* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeCastExpression* _tmp125_;
	ValaCCodeCastExpression* _tmp126_;
	ValaCCodeFile* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	self = (ValaGDBusModule*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) edomain);
	edomain_dbus_name = _tmp0_;
	_tmp1_ = edomain_dbus_name;
	if (_tmp1_ == NULL) {
		VALA_CODE_VISITOR_CLASS (vala_gd_bus_module_parent_class)->visit_error_domain ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GVARIANT_MODULE, ValaGVariantModule), edomain);
		_g_free0 (edomain_dbus_name);
		return;
	}
	_tmp2_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp2_, "gio/gio.h", FALSE);
	_tmp3_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp3_);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp4_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp4_);
	}
	if (!vala_symbol_is_private_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp5_;
		_tmp5_ = ((ValaCCodeBaseModule*) self)->internal_header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp5_);
	}
	_tmp6_ = vala_ccode_initializer_list_new ();
	error_entries = _tmp6_;
	{
		ValaList* _ecode_list = NULL;
		ValaList* _tmp7_;
		gint _ecode_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _ecode_index = 0;
		_tmp7_ = vala_error_domain_get_codes (edomain);
		_ecode_list = _tmp7_;
		_tmp8_ = _ecode_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_ecode_size = _tmp10_;
		_ecode_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			ValaErrorCode* ecode = NULL;
			ValaList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			gchar* ecode_dbus_name = NULL;
			ValaErrorCode* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			ValaCCodeInitializerList* error_entry = NULL;
			ValaCCodeInitializerList* _tmp26_;
			ValaCCodeInitializerList* _tmp27_;
			ValaErrorCode* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaCCodeIdentifier* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeInitializerList* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			ValaCCodeConstant* _tmp38_;
			ValaCCodeConstant* _tmp39_;
			ValaCCodeInitializerList* _tmp40_;
			ValaCCodeInitializerList* _tmp41_;
			_tmp11_ = _ecode_index;
			_ecode_index = _tmp11_ + 1;
			_tmp12_ = _ecode_index;
			_tmp13_ = _ecode_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _ecode_list;
			_tmp15_ = _ecode_index;
			_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
			ecode = (ValaErrorCode*) _tmp16_;
			_tmp17_ = ecode;
			_tmp18_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) _tmp17_);
			ecode_dbus_name = _tmp18_;
			_tmp19_ = ecode_dbus_name;
			if (_tmp19_ == NULL) {
				ValaErrorCode* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp20_ = ecode;
				_tmp21_ = vala_symbol_get_name ((ValaSymbol*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_utf8_strdown (_tmp22_, (gssize) -1);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_lower_case_to_camel_case (_tmp24_);
				_g_free0 (ecode_dbus_name);
				ecode_dbus_name = _tmp25_;
				_g_free0 (_tmp24_);
			}
			_tmp26_ = vala_ccode_initializer_list_new ();
			error_entry = _tmp26_;
			_tmp27_ = error_entry;
			_tmp28_ = ecode;
			_tmp29_ = vala_get_ccode_name ((ValaCodeNode*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_ccode_identifier_new (_tmp30_);
			_tmp32_ = _tmp31_;
			vala_ccode_initializer_list_append (_tmp27_, (ValaCCodeExpression*) _tmp32_);
			_vala_ccode_node_unref0 (_tmp32_);
			_g_free0 (_tmp30_);
			_tmp33_ = error_entry;
			_tmp34_ = edomain_dbus_name;
			_tmp35_ = ecode_dbus_name;
			_tmp36_ = g_strdup_printf ("\"%s.%s\"", _tmp34_, _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_ccode_constant_new (_tmp37_);
			_tmp39_ = _tmp38_;
			vala_ccode_initializer_list_append (_tmp33_, (ValaCCodeExpression*) _tmp39_);
			_vala_ccode_node_unref0 (_tmp39_);
			_g_free0 (_tmp37_);
			_tmp40_ = error_entries;
			_tmp41_ = error_entry;
			vala_ccode_initializer_list_append (_tmp40_, (ValaCCodeExpression*) _tmp41_);
			_vala_ccode_node_unref0 (error_entry);
			_g_free0 (ecode_dbus_name);
			_vala_code_node_unref0 (ecode);
		}
		_vala_iterable_unref0 (_ecode_list);
	}
	_tmp42_ = vala_ccode_declaration_new ("const GDBusErrorEntry");
	_cdecl_ = _tmp42_;
	_tmp43_ = _cdecl_;
	_tmp44_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) edomain, NULL);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strconcat (_tmp45_, "_entries[]", NULL);
	_tmp47_ = _tmp46_;
	_tmp48_ = error_entries;
	_tmp49_ = vala_ccode_variable_declarator_new (_tmp47_, (ValaCCodeExpression*) _tmp48_, NULL);
	_tmp50_ = _tmp49_;
	vala_ccode_declaration_add_declarator (_tmp43_, (ValaCCodeDeclarator*) _tmp50_);
	_vala_ccode_node_unref0 (_tmp50_);
	_g_free0 (_tmp47_);
	_g_free0 (_tmp45_);
	_tmp51_ = _cdecl_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp51_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp52_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp53_ = _cdecl_;
	vala_ccode_file_add_constant_declaration (_tmp52_, (ValaCCodeNode*) _tmp53_);
	_tmp54_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp55_ = _tmp54_;
	_tmp56_ = g_strconcat (_tmp55_, "quark", NULL);
	_tmp57_ = _tmp56_;
	_g_free0 (_tmp55_);
	quark_fun_name = _tmp57_;
	_tmp58_ = quark_fun_name;
	_tmp59_ = ((ValaCCodeBaseModule*) self)->gquark_type;
	_tmp60_ = vala_data_type_get_data_type (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = vala_get_ccode_name ((ValaCodeNode*) _tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_ccode_function_new (_tmp58_, _tmp63_);
	_tmp65_ = _tmp64_;
	_g_free0 (_tmp63_);
	cquark_fun = _tmp65_;
	_tmp66_ = cquark_fun;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp66_);
	_tmp67_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp68_ = _tmp67_;
	_tmp69_ = g_strdup_printf ("%squark_volatile", _tmp68_);
	_tmp70_ = _tmp69_;
	_g_free0 (_tmp68_);
	quark_name = _tmp70_;
	_tmp71_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp72_ = _tmp71_;
	_tmp73_ = quark_name;
	_tmp74_ = vala_ccode_constant_new ("0");
	_tmp75_ = _tmp74_;
	_tmp76_ = vala_ccode_variable_declarator_new (_tmp73_, (ValaCCodeExpression*) _tmp75_, NULL);
	_tmp77_ = _tmp76_;
	vala_ccode_function_add_declaration (_tmp72_, "gsize", (ValaCCodeDeclarator*) _tmp77_, VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_VOLATILE);
	_vala_ccode_node_unref0 (_tmp77_);
	_vala_ccode_node_unref0 (_tmp75_);
	_tmp78_ = vala_ccode_identifier_new ("g_dbus_error_register_error_domain");
	_tmp79_ = _tmp78_;
	_tmp80_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp79_);
	_tmp81_ = _tmp80_;
	_vala_ccode_node_unref0 (_tmp79_);
	register_call = _tmp81_;
	_tmp82_ = register_call;
	_tmp83_ = vala_get_ccode_quark_name (edomain);
	_tmp84_ = _tmp83_;
	_tmp85_ = g_strconcat ("\"", _tmp84_, NULL);
	_tmp86_ = _tmp85_;
	_tmp87_ = g_strconcat (_tmp86_, "\"", NULL);
	_tmp88_ = _tmp87_;
	_tmp89_ = vala_ccode_constant_new (_tmp88_);
	_tmp90_ = _tmp89_;
	vala_ccode_function_call_add_argument (_tmp82_, (ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (_tmp90_);
	_g_free0 (_tmp88_);
	_g_free0 (_tmp86_);
	_g_free0 (_tmp84_);
	_tmp91_ = register_call;
	_tmp92_ = quark_name;
	_tmp93_ = vala_ccode_identifier_new (_tmp92_);
	_tmp94_ = _tmp93_;
	_tmp95_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp94_);
	_tmp96_ = _tmp95_;
	vala_ccode_function_call_add_argument (_tmp91_, (ValaCCodeExpression*) _tmp96_);
	_vala_ccode_node_unref0 (_tmp96_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp97_ = register_call;
	_tmp98_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) edomain, NULL);
	_tmp99_ = _tmp98_;
	_tmp100_ = g_strconcat (_tmp99_, "_entries", NULL);
	_tmp101_ = _tmp100_;
	_tmp102_ = vala_ccode_identifier_new (_tmp101_);
	_tmp103_ = _tmp102_;
	vala_ccode_function_call_add_argument (_tmp97_, (ValaCCodeExpression*) _tmp103_);
	_vala_ccode_node_unref0 (_tmp103_);
	_g_free0 (_tmp101_);
	_g_free0 (_tmp99_);
	_tmp104_ = vala_ccode_identifier_new ("G_N_ELEMENTS");
	_tmp105_ = _tmp104_;
	_tmp106_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp105_);
	_tmp107_ = _tmp106_;
	_vala_ccode_node_unref0 (_tmp105_);
	nentries = _tmp107_;
	_tmp108_ = nentries;
	_tmp109_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) edomain, NULL);
	_tmp110_ = _tmp109_;
	_tmp111_ = g_strconcat (_tmp110_, "_entries", NULL);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_ccode_identifier_new (_tmp112_);
	_tmp114_ = _tmp113_;
	vala_ccode_function_call_add_argument (_tmp108_, (ValaCCodeExpression*) _tmp114_);
	_vala_ccode_node_unref0 (_tmp114_);
	_g_free0 (_tmp112_);
	_g_free0 (_tmp110_);
	_tmp115_ = register_call;
	_tmp116_ = nentries;
	vala_ccode_function_call_add_argument (_tmp115_, (ValaCCodeExpression*) _tmp116_);
	_tmp117_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp118_ = _tmp117_;
	_tmp119_ = register_call;
	vala_ccode_function_add_expression (_tmp118_, (ValaCCodeExpression*) _tmp119_);
	_tmp120_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp121_ = _tmp120_;
	_tmp122_ = quark_name;
	_tmp123_ = vala_ccode_identifier_new (_tmp122_);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp124_, "GQuark");
	_tmp126_ = _tmp125_;
	vala_ccode_function_add_return (_tmp121_, (ValaCCodeExpression*) _tmp126_);
	_vala_ccode_node_unref0 (_tmp126_);
	_vala_ccode_node_unref0 (_tmp124_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp127_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp128_ = cquark_fun;
	vala_ccode_file_add_function (_tmp127_, _tmp128_);
	_vala_ccode_node_unref0 (nentries);
	_vala_ccode_node_unref0 (register_call);
	_g_free0 (quark_name);
	_vala_ccode_node_unref0 (cquark_fun);
	_g_free0 (quark_fun_name);
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (error_entries);
	_g_free0 (edomain_dbus_name);
}


static gboolean
vala_gd_bus_module_is_file_descriptor (ValaGDBusModule* self,
                                       ValaDataType* type)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_OBJECT_TYPE)) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		ValaTypeSymbol* _tmp3_;
		ValaTypeSymbol* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp3_ = vala_data_type_get_data_type (type);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, "GLib.UnixInputStream") == 0;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			_tmp2_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp8_ = vala_data_type_get_data_type (type);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp2_ = g_strcmp0 (_tmp11_, "GLib.UnixOutputStream") == 0;
			_g_free0 (_tmp11_);
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp12_ = vala_data_type_get_data_type (type);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp1_ = g_strcmp0 (_tmp15_, "GLib.Socket") == 0;
			_g_free0 (_tmp15_);
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp16_;
			ValaTypeSymbol* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp16_ = vala_data_type_get_data_type (type);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp0_ = g_strcmp0 (_tmp19_, "GLib.FileDescriptorBased") == 0;
			_g_free0 (_tmp19_);
		}
		if (_tmp0_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


gboolean
vala_gd_bus_module_dbus_method_uses_file_descriptor (ValaGDBusModule* self,
                                                     ValaMethod* method)
{
	gboolean result = FALSE;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (method != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) method);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			ValaDataType* _tmp11_;
			ValaDataType* _tmp12_;
			_tmp4_ = _param_index;
			_param_index = _tmp4_ + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = _param_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			_tmp11_ = vala_variable_get_variable_type ((ValaVariable*) _tmp10_);
			_tmp12_ = _tmp11_;
			if (vala_gd_bus_module_is_file_descriptor (self, _tmp12_)) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp13_ = vala_callable_get_return_type ((ValaCallable*) method);
	_tmp14_ = _tmp13_;
	if (vala_gd_bus_module_is_file_descriptor (self, _tmp14_)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static ValaCCodeExpression*
vala_gd_bus_module_get_file_descriptor (ValaGDBusModule* self,
                                        ValaDataType* type,
                                        ValaCCodeExpression* expr)
{
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_OBJECT_TYPE)) {
		ValaTypeSymbol* _tmp0_;
		ValaTypeSymbol* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp0_ = vala_data_type_get_data_type (type);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strcmp0 (_tmp3_, "GLib.UnixInputStream") == 0;
		_g_free0 (_tmp3_);
		if (_tmp4_) {
			ValaCCodeFunctionCall* _result_ = NULL;
			ValaCCodeIdentifier* _tmp5_;
			ValaCCodeIdentifier* _tmp6_;
			ValaCCodeFunctionCall* _tmp7_;
			ValaCCodeFunctionCall* _tmp8_;
			ValaCCodeFunctionCall* _tmp9_;
			_tmp5_ = vala_ccode_identifier_new ("g_unix_input_stream_get_fd");
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp6_);
			_tmp8_ = _tmp7_;
			_vala_ccode_node_unref0 (_tmp6_);
			_result_ = _tmp8_;
			_tmp9_ = _result_;
			vala_ccode_function_call_add_argument (_tmp9_, expr);
			result = (ValaCCodeExpression*) _result_;
			return result;
		} else {
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gboolean _tmp14_;
			_tmp10_ = vala_data_type_get_data_type (type);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strcmp0 (_tmp13_, "GLib.UnixOutputStream") == 0;
			_g_free0 (_tmp13_);
			if (_tmp14_) {
				ValaCCodeFunctionCall* _result_ = NULL;
				ValaCCodeIdentifier* _tmp15_;
				ValaCCodeIdentifier* _tmp16_;
				ValaCCodeFunctionCall* _tmp17_;
				ValaCCodeFunctionCall* _tmp18_;
				ValaCCodeFunctionCall* _tmp19_;
				_tmp15_ = vala_ccode_identifier_new ("g_unix_output_stream_get_fd");
				_tmp16_ = _tmp15_;
				_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp16_);
				_tmp18_ = _tmp17_;
				_vala_ccode_node_unref0 (_tmp16_);
				_result_ = _tmp18_;
				_tmp19_ = _result_;
				vala_ccode_function_call_add_argument (_tmp19_, expr);
				result = (ValaCCodeExpression*) _result_;
				return result;
			} else {
				ValaTypeSymbol* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gboolean _tmp24_;
				_tmp20_ = vala_data_type_get_data_type (type);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strcmp0 (_tmp23_, "GLib.Socket") == 0;
				_g_free0 (_tmp23_);
				if (_tmp24_) {
					ValaCCodeFunctionCall* _result_ = NULL;
					ValaCCodeIdentifier* _tmp25_;
					ValaCCodeIdentifier* _tmp26_;
					ValaCCodeFunctionCall* _tmp27_;
					ValaCCodeFunctionCall* _tmp28_;
					ValaCCodeFunctionCall* _tmp29_;
					_tmp25_ = vala_ccode_identifier_new ("g_socket_get_fd");
					_tmp26_ = _tmp25_;
					_tmp27_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp26_);
					_tmp28_ = _tmp27_;
					_vala_ccode_node_unref0 (_tmp26_);
					_result_ = _tmp28_;
					_tmp29_ = _result_;
					vala_ccode_function_call_add_argument (_tmp29_, expr);
					result = (ValaCCodeExpression*) _result_;
					return result;
				} else {
					ValaTypeSymbol* _tmp30_;
					ValaTypeSymbol* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gboolean _tmp34_;
					_tmp30_ = vala_data_type_get_data_type (type);
					_tmp31_ = _tmp30_;
					_tmp32_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = g_strcmp0 (_tmp33_, "GLib.FileDescriptorBased") == 0;
					_g_free0 (_tmp33_);
					if (_tmp34_) {
						ValaCCodeFunctionCall* _result_ = NULL;
						ValaCCodeIdentifier* _tmp35_;
						ValaCCodeIdentifier* _tmp36_;
						ValaCCodeFunctionCall* _tmp37_;
						ValaCCodeFunctionCall* _tmp38_;
						ValaCCodeFunctionCall* _tmp39_;
						_tmp35_ = vala_ccode_identifier_new ("g_file_descriptor_based_get_fd");
						_tmp36_ = _tmp35_;
						_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp36_);
						_tmp38_ = _tmp37_;
						_vala_ccode_node_unref0 (_tmp36_);
						_result_ = _tmp38_;
						_tmp39_ = _result_;
						vala_ccode_function_call_add_argument (_tmp39_, expr);
						result = (ValaCCodeExpression*) _result_;
						return result;
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


void
vala_gd_bus_module_send_dbus_value (ValaGDBusModule* self,
                                    ValaDataType* type,
                                    ValaCCodeExpression* builder_expr,
                                    ValaCCodeExpression* expr,
                                    ValaSymbol* sym)
{
	ValaCCodeExpression* fd = NULL;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (builder_expr != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_gd_bus_module_get_file_descriptor (self, type, expr);
	fd = _tmp0_;
	_tmp1_ = fd;
	if (_tmp1_ != NULL) {
		ValaCCodeFunctionCall* fd_append = NULL;
		ValaCCodeIdentifier* _tmp2_;
		ValaCCodeIdentifier* _tmp3_;
		ValaCCodeFunctionCall* _tmp4_;
		ValaCCodeFunctionCall* _tmp5_;
		ValaCCodeFunctionCall* _tmp6_;
		ValaCCodeIdentifier* _tmp7_;
		ValaCCodeIdentifier* _tmp8_;
		ValaCCodeFunctionCall* _tmp9_;
		ValaCCodeExpression* _tmp10_;
		ValaCCodeFunctionCall* _tmp11_;
		ValaCCodeConstant* _tmp12_;
		ValaCCodeConstant* _tmp13_;
		ValaCCodeFunctionCall* builder_add = NULL;
		ValaCCodeIdentifier* _tmp14_;
		ValaCCodeIdentifier* _tmp15_;
		ValaCCodeFunctionCall* _tmp16_;
		ValaCCodeFunctionCall* _tmp17_;
		ValaCCodeFunctionCall* _tmp18_;
		ValaCCodeUnaryExpression* _tmp19_;
		ValaCCodeUnaryExpression* _tmp20_;
		ValaCCodeFunctionCall* _tmp21_;
		ValaCCodeConstant* _tmp22_;
		ValaCCodeConstant* _tmp23_;
		ValaCCodeFunctionCall* _tmp24_;
		ValaCCodeFunctionCall* _tmp25_;
		ValaCCodeFunction* _tmp26_;
		ValaCCodeFunction* _tmp27_;
		ValaCCodeFunctionCall* _tmp28_;
		_tmp2_ = vala_ccode_identifier_new ("g_unix_fd_list_append");
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp3_);
		_tmp5_ = _tmp4_;
		_vala_ccode_node_unref0 (_tmp3_);
		fd_append = _tmp5_;
		_tmp6_ = fd_append;
		_tmp7_ = vala_ccode_identifier_new ("_fd_list");
		_tmp8_ = _tmp7_;
		vala_ccode_function_call_add_argument (_tmp6_, (ValaCCodeExpression*) _tmp8_);
		_vala_ccode_node_unref0 (_tmp8_);
		_tmp9_ = fd_append;
		_tmp10_ = fd;
		vala_ccode_function_call_add_argument (_tmp9_, _tmp10_);
		_tmp11_ = fd_append;
		_tmp12_ = vala_ccode_constant_new ("NULL");
		_tmp13_ = _tmp12_;
		vala_ccode_function_call_add_argument (_tmp11_, (ValaCCodeExpression*) _tmp13_);
		_vala_ccode_node_unref0 (_tmp13_);
		_tmp14_ = vala_ccode_identifier_new ("g_variant_builder_add");
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		_vala_ccode_node_unref0 (_tmp15_);
		builder_add = _tmp17_;
		_tmp18_ = builder_add;
		_tmp19_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, builder_expr);
		_tmp20_ = _tmp19_;
		vala_ccode_function_call_add_argument (_tmp18_, (ValaCCodeExpression*) _tmp20_);
		_vala_ccode_node_unref0 (_tmp20_);
		_tmp21_ = builder_add;
		_tmp22_ = vala_ccode_constant_new ("\"h\"");
		_tmp23_ = _tmp22_;
		vala_ccode_function_call_add_argument (_tmp21_, (ValaCCodeExpression*) _tmp23_);
		_vala_ccode_node_unref0 (_tmp23_);
		_tmp24_ = builder_add;
		_tmp25_ = fd_append;
		vala_ccode_function_call_add_argument (_tmp24_, (ValaCCodeExpression*) _tmp25_);
		_tmp26_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = builder_add;
		vala_ccode_function_add_expression (_tmp27_, (ValaCCodeExpression*) _tmp28_);
		_vala_ccode_node_unref0 (builder_add);
		_vala_ccode_node_unref0 (fd_append);
	} else {
		vala_gvariant_module_write_expression ((ValaGVariantModule*) self, type, builder_expr, expr, sym);
	}
	_vala_ccode_node_unref0 (fd);
}


static ValaCCodeExpression*
vala_gd_bus_module_create_from_file_descriptor (ValaGDBusModule* self,
                                                ValaDataType* type,
                                                ValaCCodeExpression* expr)
{
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_OBJECT_TYPE)) {
		ValaTypeSymbol* _tmp0_;
		ValaTypeSymbol* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp0_ = vala_data_type_get_data_type (type);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strcmp0 (_tmp3_, "GLib.UnixInputStream") == 0;
		_g_free0 (_tmp3_);
		if (_tmp4_) {
			ValaCCodeFunctionCall* _result_ = NULL;
			ValaCCodeIdentifier* _tmp5_;
			ValaCCodeIdentifier* _tmp6_;
			ValaCCodeFunctionCall* _tmp7_;
			ValaCCodeFunctionCall* _tmp8_;
			ValaCCodeFunctionCall* _tmp9_;
			ValaCCodeFunctionCall* _tmp10_;
			ValaCCodeConstant* _tmp11_;
			ValaCCodeConstant* _tmp12_;
			ValaCCodeFunctionCall* _tmp13_;
			ValaCCodeCastExpression* _tmp14_;
			_tmp5_ = vala_ccode_identifier_new ("g_unix_input_stream_new");
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp6_);
			_tmp8_ = _tmp7_;
			_vala_ccode_node_unref0 (_tmp6_);
			_result_ = _tmp8_;
			_tmp9_ = _result_;
			vala_ccode_function_call_add_argument (_tmp9_, expr);
			_tmp10_ = _result_;
			_tmp11_ = vala_ccode_constant_new ("TRUE");
			_tmp12_ = _tmp11_;
			vala_ccode_function_call_add_argument (_tmp10_, (ValaCCodeExpression*) _tmp12_);
			_vala_ccode_node_unref0 (_tmp12_);
			_tmp13_ = _result_;
			_tmp14_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp13_, "GUnixInputStream *");
			result = (ValaCCodeExpression*) _tmp14_;
			_vala_ccode_node_unref0 (_result_);
			return result;
		} else {
			ValaTypeSymbol* _tmp15_;
			ValaTypeSymbol* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp19_;
			_tmp15_ = vala_data_type_get_data_type (type);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strcmp0 (_tmp18_, "GLib.UnixOutputStream") == 0;
			_g_free0 (_tmp18_);
			if (_tmp19_) {
				ValaCCodeFunctionCall* _result_ = NULL;
				ValaCCodeIdentifier* _tmp20_;
				ValaCCodeIdentifier* _tmp21_;
				ValaCCodeFunctionCall* _tmp22_;
				ValaCCodeFunctionCall* _tmp23_;
				ValaCCodeFunctionCall* _tmp24_;
				ValaCCodeFunctionCall* _tmp25_;
				ValaCCodeConstant* _tmp26_;
				ValaCCodeConstant* _tmp27_;
				ValaCCodeFunctionCall* _tmp28_;
				ValaCCodeCastExpression* _tmp29_;
				_tmp20_ = vala_ccode_identifier_new ("g_unix_output_stream_new");
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp21_);
				_tmp23_ = _tmp22_;
				_vala_ccode_node_unref0 (_tmp21_);
				_result_ = _tmp23_;
				_tmp24_ = _result_;
				vala_ccode_function_call_add_argument (_tmp24_, expr);
				_tmp25_ = _result_;
				_tmp26_ = vala_ccode_constant_new ("TRUE");
				_tmp27_ = _tmp26_;
				vala_ccode_function_call_add_argument (_tmp25_, (ValaCCodeExpression*) _tmp27_);
				_vala_ccode_node_unref0 (_tmp27_);
				_tmp28_ = _result_;
				_tmp29_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp28_, "GUnixOutputStream *");
				result = (ValaCCodeExpression*) _tmp29_;
				_vala_ccode_node_unref0 (_result_);
				return result;
			} else {
				ValaTypeSymbol* _tmp30_;
				ValaTypeSymbol* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gboolean _tmp34_;
				_tmp30_ = vala_data_type_get_data_type (type);
				_tmp31_ = _tmp30_;
				_tmp32_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = g_strcmp0 (_tmp33_, "GLib.Socket") == 0;
				_g_free0 (_tmp33_);
				if (_tmp34_) {
					ValaCCodeFunctionCall* _result_ = NULL;
					ValaCCodeIdentifier* _tmp35_;
					ValaCCodeIdentifier* _tmp36_;
					ValaCCodeFunctionCall* _tmp37_;
					ValaCCodeFunctionCall* _tmp38_;
					ValaCCodeFunctionCall* _tmp39_;
					ValaCCodeFunctionCall* _tmp40_;
					ValaCCodeConstant* _tmp41_;
					ValaCCodeConstant* _tmp42_;
					_tmp35_ = vala_ccode_identifier_new ("g_socket_new_from_fd");
					_tmp36_ = _tmp35_;
					_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp36_);
					_tmp38_ = _tmp37_;
					_vala_ccode_node_unref0 (_tmp36_);
					_result_ = _tmp38_;
					_tmp39_ = _result_;
					vala_ccode_function_call_add_argument (_tmp39_, expr);
					_tmp40_ = _result_;
					_tmp41_ = vala_ccode_constant_new ("NULL");
					_tmp42_ = _tmp41_;
					vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp42_);
					_vala_ccode_node_unref0 (_tmp42_);
					result = (ValaCCodeExpression*) _result_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


void
vala_gd_bus_module_receive_dbus_value (ValaGDBusModule* self,
                                       ValaDataType* type,
                                       ValaCCodeExpression* message_expr,
                                       ValaCCodeExpression* iter_expr,
                                       ValaCCodeExpression* target_expr,
                                       ValaSymbol* sym,
                                       ValaCCodeExpression* error_expr,
                                       gboolean* may_fail)
{
	gboolean _vala_may_fail = FALSE;
	ValaCCodeFunctionCall* fd_list = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeIdentifier* fd_var = NULL;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeExpression* stream = NULL;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeExpression* _tmp7_;
	ValaCCodeExpression* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (message_expr != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (target_expr != NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_dbus_message_get_unix_fd_list");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	fd_list = _tmp3_;
	_tmp4_ = fd_list;
	vala_ccode_function_call_add_argument (_tmp4_, message_expr);
	_tmp5_ = vala_ccode_identifier_new ("_fd");
	fd_var = _tmp5_;
	_tmp6_ = fd_var;
	_tmp7_ = vala_gd_bus_module_create_from_file_descriptor (self, type, (ValaCCodeExpression*) _tmp6_);
	stream = _tmp7_;
	_tmp8_ = stream;
	if (_tmp8_ != NULL) {
		ValaCCodeIdentifier* fd_list_var = NULL;
		ValaCCodeIdentifier* _tmp9_;
		ValaCCodeFunctionCall* fd = NULL;
		ValaCCodeIdentifier* _tmp10_;
		ValaCCodeIdentifier* _tmp11_;
		ValaCCodeFunctionCall* _tmp12_;
		ValaCCodeFunctionCall* _tmp13_;
		ValaCCodeFunctionCall* _tmp14_;
		ValaCCodeIdentifier* _tmp15_;
		ValaCCodeFunctionCall* _tmp16_;
		ValaCCodeIdentifier* _tmp17_;
		ValaCCodeIdentifier* _tmp18_;
		ValaCCodeFunctionCall* _tmp19_;
		ValaCCodeFunction* _tmp20_;
		ValaCCodeFunction* _tmp21_;
		ValaCCodeIdentifier* _tmp22_;
		ValaCCodeFunctionCall* _tmp23_;
		ValaCCodeFunction* _tmp24_;
		ValaCCodeFunction* _tmp25_;
		ValaCCodeIdentifier* _tmp26_;
		ValaCCodeFunctionCall* get_fd = NULL;
		ValaCCodeIdentifier* _tmp27_;
		ValaCCodeIdentifier* _tmp28_;
		ValaCCodeFunctionCall* _tmp29_;
		ValaCCodeFunctionCall* _tmp30_;
		ValaCCodeFunctionCall* _tmp31_;
		ValaCCodeUnaryExpression* _tmp32_;
		ValaCCodeUnaryExpression* _tmp33_;
		ValaCCodeFunctionCall* _tmp34_;
		ValaCCodeConstant* _tmp35_;
		ValaCCodeConstant* _tmp36_;
		ValaCCodeFunctionCall* _tmp37_;
		ValaCCodeIdentifier* _tmp38_;
		ValaCCodeIdentifier* _tmp39_;
		ValaCCodeUnaryExpression* _tmp40_;
		ValaCCodeUnaryExpression* _tmp41_;
		ValaCCodeFunction* _tmp42_;
		ValaCCodeFunction* _tmp43_;
		ValaCCodeFunctionCall* _tmp44_;
		ValaCCodeFunction* _tmp45_;
		ValaCCodeFunction* _tmp46_;
		ValaCCodeIdentifier* _tmp47_;
		ValaCCodeFunctionCall* _tmp48_;
		ValaCCodeFunction* _tmp49_;
		ValaCCodeFunction* _tmp50_;
		ValaCCodeIdentifier* _tmp51_;
		ValaCCodeConstant* _tmp52_;
		ValaCCodeConstant* _tmp53_;
		ValaCCodeBinaryExpression* _tmp54_;
		ValaCCodeBinaryExpression* _tmp55_;
		ValaCCodeFunction* _tmp56_;
		ValaCCodeFunction* _tmp57_;
		ValaCCodeExpression* _tmp58_;
		ValaCCodeFunction* _tmp59_;
		ValaCCodeFunction* _tmp60_;
		ValaCCodeFunction* _tmp61_;
		ValaCCodeFunction* _tmp62_;
		ValaCCodeFunctionCall* set_error = NULL;
		ValaCCodeIdentifier* _tmp63_;
		ValaCCodeIdentifier* _tmp64_;
		ValaCCodeFunctionCall* _tmp65_;
		ValaCCodeFunctionCall* _tmp66_;
		ValaCCodeFunctionCall* _tmp67_;
		ValaCCodeFunctionCall* _tmp68_;
		ValaCCodeIdentifier* _tmp69_;
		ValaCCodeIdentifier* _tmp70_;
		ValaCCodeFunctionCall* _tmp71_;
		ValaCCodeIdentifier* _tmp72_;
		ValaCCodeIdentifier* _tmp73_;
		ValaCCodeFunctionCall* _tmp74_;
		ValaCCodeConstant* _tmp75_;
		ValaCCodeConstant* _tmp76_;
		ValaCCodeFunction* _tmp77_;
		ValaCCodeFunction* _tmp78_;
		ValaCCodeFunctionCall* _tmp79_;
		ValaCCodeFunction* _tmp80_;
		ValaCCodeFunction* _tmp81_;
		_tmp9_ = vala_ccode_identifier_new ("_fd_list");
		fd_list_var = _tmp9_;
		_tmp10_ = vala_ccode_identifier_new ("g_unix_fd_list_get");
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp11_);
		_tmp13_ = _tmp12_;
		_vala_ccode_node_unref0 (_tmp11_);
		fd = _tmp13_;
		_tmp14_ = fd;
		_tmp15_ = fd_list_var;
		vala_ccode_function_call_add_argument (_tmp14_, (ValaCCodeExpression*) _tmp15_);
		_tmp16_ = fd;
		_tmp17_ = vala_ccode_identifier_new ("_fd_index");
		_tmp18_ = _tmp17_;
		vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
		_vala_ccode_node_unref0 (_tmp18_);
		_tmp19_ = fd;
		vala_ccode_function_call_add_argument (_tmp19_, error_expr);
		_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp21_ = _tmp20_;
		_tmp22_ = fd_list_var;
		_tmp23_ = fd_list;
		vala_ccode_function_add_assignment (_tmp21_, (ValaCCodeExpression*) _tmp22_, (ValaCCodeExpression*) _tmp23_);
		_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = fd_list_var;
		vala_ccode_function_open_if (_tmp25_, (ValaCCodeExpression*) _tmp26_);
		_tmp27_ = vala_ccode_identifier_new ("g_variant_iter_next");
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp28_);
		_tmp30_ = _tmp29_;
		_vala_ccode_node_unref0 (_tmp28_);
		get_fd = _tmp30_;
		_tmp31_ = get_fd;
		_tmp32_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr);
		_tmp33_ = _tmp32_;
		vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
		_vala_ccode_node_unref0 (_tmp33_);
		_tmp34_ = get_fd;
		_tmp35_ = vala_ccode_constant_new ("\"h\"");
		_tmp36_ = _tmp35_;
		vala_ccode_function_call_add_argument (_tmp34_, (ValaCCodeExpression*) _tmp36_);
		_vala_ccode_node_unref0 (_tmp36_);
		_tmp37_ = get_fd;
		_tmp38_ = vala_ccode_identifier_new ("_fd_index");
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp39_);
		_tmp41_ = _tmp40_;
		vala_ccode_function_call_add_argument (_tmp37_, (ValaCCodeExpression*) _tmp41_);
		_vala_ccode_node_unref0 (_tmp41_);
		_vala_ccode_node_unref0 (_tmp39_);
		_tmp42_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp43_ = _tmp42_;
		_tmp44_ = get_fd;
		vala_ccode_function_add_expression (_tmp43_, (ValaCCodeExpression*) _tmp44_);
		_tmp45_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp46_ = _tmp45_;
		_tmp47_ = fd_var;
		_tmp48_ = fd;
		vala_ccode_function_add_assignment (_tmp46_, (ValaCCodeExpression*) _tmp47_, (ValaCCodeExpression*) _tmp48_);
		_tmp49_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp50_ = _tmp49_;
		_tmp51_ = fd_var;
		_tmp52_ = vala_ccode_constant_new ("0");
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, (ValaCCodeExpression*) _tmp51_, (ValaCCodeExpression*) _tmp53_);
		_tmp55_ = _tmp54_;
		vala_ccode_function_open_if (_tmp50_, (ValaCCodeExpression*) _tmp55_);
		_vala_ccode_node_unref0 (_tmp55_);
		_vala_ccode_node_unref0 (_tmp53_);
		_tmp56_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp57_ = _tmp56_;
		_tmp58_ = stream;
		vala_ccode_function_add_assignment (_tmp57_, target_expr, _tmp58_);
		_vala_may_fail = TRUE;
		_tmp59_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp60_ = _tmp59_;
		vala_ccode_function_close (_tmp60_);
		_tmp61_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp62_ = _tmp61_;
		vala_ccode_function_add_else (_tmp62_);
		_tmp63_ = vala_ccode_identifier_new ("g_set_error_literal");
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp64_);
		_tmp66_ = _tmp65_;
		_vala_ccode_node_unref0 (_tmp64_);
		set_error = _tmp66_;
		_tmp67_ = set_error;
		vala_ccode_function_call_add_argument (_tmp67_, error_expr);
		_tmp68_ = set_error;
		_tmp69_ = vala_ccode_identifier_new ("G_IO_ERROR");
		_tmp70_ = _tmp69_;
		vala_ccode_function_call_add_argument (_tmp68_, (ValaCCodeExpression*) _tmp70_);
		_vala_ccode_node_unref0 (_tmp70_);
		_tmp71_ = set_error;
		_tmp72_ = vala_ccode_identifier_new ("G_IO_ERROR_FAILED");
		_tmp73_ = _tmp72_;
		vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
		_vala_ccode_node_unref0 (_tmp73_);
		_tmp74_ = set_error;
		_tmp75_ = vala_ccode_constant_new ("\"FD List is NULL\"");
		_tmp76_ = _tmp75_;
		vala_ccode_function_call_add_argument (_tmp74_, (ValaCCodeExpression*) _tmp76_);
		_vala_ccode_node_unref0 (_tmp76_);
		_tmp77_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp78_ = _tmp77_;
		_tmp79_ = set_error;
		vala_ccode_function_add_expression (_tmp78_, (ValaCCodeExpression*) _tmp79_);
		_tmp80_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp81_ = _tmp80_;
		vala_ccode_function_close (_tmp81_);
		_vala_ccode_node_unref0 (set_error);
		_vala_ccode_node_unref0 (get_fd);
		_vala_ccode_node_unref0 (fd);
		_vala_ccode_node_unref0 (fd_list_var);
	} else {
		gboolean _tmp82_ = FALSE;
		vala_gvariant_module_read_expression ((ValaGVariantModule*) self, type, iter_expr, target_expr, sym, error_expr, &_tmp82_);
		_vala_may_fail = _tmp82_;
	}
	_vala_ccode_node_unref0 (stream);
	_vala_ccode_node_unref0 (fd_var);
	_vala_ccode_node_unref0 (fd_list);
	if (may_fail) {
		*may_fail = _vala_may_fail;
	}
}


static ValaCCodeExpression*
vala_gd_bus_module_get_method_info (ValaGDBusModule* self,
                                    ValaObjectTypeSymbol* sym)
{
	ValaCCodeExpression* result = NULL;
	ValaCCodeInitializerList* infos = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeInitializerList* _tmp367_;
	ValaCCodeConstant* _tmp368_;
	ValaCCodeConstant* _tmp369_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp370_;
	gchar* _tmp371_;
	gchar* _tmp372_;
	gchar* _tmp373_;
	gchar* _tmp374_;
	gchar* _tmp375_;
	gchar* _tmp376_;
	ValaCCodeInitializerList* _tmp377_;
	ValaCCodeVariableDeclarator* _tmp378_;
	ValaCCodeVariableDeclarator* _tmp379_;
	ValaCCodeFile* _tmp380_;
	gchar* _tmp381_;
	gchar* _tmp382_;
	gchar* _tmp383_;
	gchar* _tmp384_;
	gchar* _tmp385_;
	gchar* _tmp386_;
	ValaCCodeIdentifier* _tmp387_;
	ValaCCodeExpression* _tmp388_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	infos = _tmp0_;
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp1_;
		gint _m_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _m_index = 0;
		_tmp1_ = vala_object_type_symbol_get_methods (sym);
		_m_list = _tmp1_;
		_tmp2_ = _m_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_m_size = _tmp4_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaMethod* m = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			ValaMethod* _tmp14_;
			ValaMethod* _tmp24_;
			ValaCCodeInitializerList* in_args_info = NULL;
			ValaCCodeInitializerList* _tmp25_;
			ValaCCodeInitializerList* out_args_info = NULL;
			ValaCCodeInitializerList* _tmp26_;
			ValaMethod* _tmp161_;
			ValaDataType* _tmp162_;
			ValaDataType* _tmp163_;
			ValaCCodeInitializerList* _tmp229_;
			ValaCCodeConstant* _tmp230_;
			ValaCCodeConstant* _tmp231_;
			ValaCCodeInitializerList* _tmp232_;
			ValaCCodeConstant* _tmp233_;
			ValaCCodeConstant* _tmp234_;
			ValaCCodeDeclaration* _cdecl_ = NULL;
			ValaCCodeDeclaration* _tmp235_;
			ValaCCodeDeclaration* _tmp236_;
			gchar* _tmp237_;
			gchar* _tmp238_;
			gchar* _tmp239_;
			gchar* _tmp240_;
			gchar* _tmp241_;
			gchar* _tmp242_;
			ValaMethod* _tmp243_;
			const gchar* _tmp244_;
			const gchar* _tmp245_;
			gchar* _tmp246_;
			gchar* _tmp247_;
			gchar* _tmp248_;
			gchar* _tmp249_;
			ValaCCodeInitializerList* _tmp250_;
			ValaCCodeVariableDeclarator* _tmp251_;
			ValaCCodeVariableDeclarator* _tmp252_;
			ValaCCodeDeclaration* _tmp253_;
			ValaCCodeFile* _tmp254_;
			ValaCCodeDeclaration* _tmp255_;
			ValaCCodeDeclaration* _tmp256_;
			ValaCCodeDeclaration* _tmp257_;
			gchar* _tmp258_;
			gchar* _tmp259_;
			gchar* _tmp260_;
			gchar* _tmp261_;
			gchar* _tmp262_;
			gchar* _tmp263_;
			ValaMethod* _tmp264_;
			const gchar* _tmp265_;
			const gchar* _tmp266_;
			gchar* _tmp267_;
			gchar* _tmp268_;
			gchar* _tmp269_;
			gchar* _tmp270_;
			ValaCCodeInitializerList* _tmp271_;
			ValaCCodeVariableDeclarator* _tmp272_;
			ValaCCodeVariableDeclarator* _tmp273_;
			ValaCCodeDeclaration* _tmp274_;
			ValaCCodeFile* _tmp275_;
			ValaCCodeDeclaration* _tmp276_;
			ValaCCodeInitializerList* info = NULL;
			ValaCCodeInitializerList* _tmp277_;
			ValaCCodeInitializerList* _tmp278_;
			ValaCCodeConstant* _tmp279_;
			ValaCCodeConstant* _tmp280_;
			ValaCCodeInitializerList* _tmp281_;
			ValaMethod* _tmp282_;
			gchar* _tmp283_;
			gchar* _tmp284_;
			gchar* _tmp285_;
			gchar* _tmp286_;
			ValaCCodeConstant* _tmp287_;
			ValaCCodeConstant* _tmp288_;
			ValaCCodeInitializerList* _tmp289_;
			gchar* _tmp290_;
			gchar* _tmp291_;
			gchar* _tmp292_;
			gchar* _tmp293_;
			gchar* _tmp294_;
			gchar* _tmp295_;
			ValaMethod* _tmp296_;
			const gchar* _tmp297_;
			const gchar* _tmp298_;
			gchar* _tmp299_;
			gchar* _tmp300_;
			gchar* _tmp301_;
			gchar* _tmp302_;
			ValaCCodeIdentifier* _tmp303_;
			ValaCCodeIdentifier* _tmp304_;
			ValaCCodeUnaryExpression* _tmp305_;
			ValaCCodeUnaryExpression* _tmp306_;
			ValaCCodeCastExpression* _tmp307_;
			ValaCCodeCastExpression* _tmp308_;
			ValaCCodeInitializerList* _tmp309_;
			gchar* _tmp310_;
			gchar* _tmp311_;
			gchar* _tmp312_;
			gchar* _tmp313_;
			gchar* _tmp314_;
			gchar* _tmp315_;
			ValaMethod* _tmp316_;
			const gchar* _tmp317_;
			const gchar* _tmp318_;
			gchar* _tmp319_;
			gchar* _tmp320_;
			gchar* _tmp321_;
			gchar* _tmp322_;
			ValaCCodeIdentifier* _tmp323_;
			ValaCCodeIdentifier* _tmp324_;
			ValaCCodeUnaryExpression* _tmp325_;
			ValaCCodeUnaryExpression* _tmp326_;
			ValaCCodeCastExpression* _tmp327_;
			ValaCCodeCastExpression* _tmp328_;
			ValaCCodeInitializerList* _tmp329_;
			ValaCCodeConstant* _tmp330_;
			ValaCCodeConstant* _tmp331_;
			ValaCCodeDeclaration* _tmp332_;
			ValaCCodeDeclaration* _tmp333_;
			gchar* _tmp334_;
			gchar* _tmp335_;
			gchar* _tmp336_;
			gchar* _tmp337_;
			gchar* _tmp338_;
			gchar* _tmp339_;
			ValaMethod* _tmp340_;
			const gchar* _tmp341_;
			const gchar* _tmp342_;
			gchar* _tmp343_;
			gchar* _tmp344_;
			ValaCCodeInitializerList* _tmp345_;
			ValaCCodeVariableDeclarator* _tmp346_;
			ValaCCodeVariableDeclarator* _tmp347_;
			ValaCCodeDeclaration* _tmp348_;
			ValaCCodeFile* _tmp349_;
			ValaCCodeDeclaration* _tmp350_;
			ValaCCodeInitializerList* _tmp351_;
			gchar* _tmp352_;
			gchar* _tmp353_;
			gchar* _tmp354_;
			gchar* _tmp355_;
			gchar* _tmp356_;
			gchar* _tmp357_;
			ValaMethod* _tmp358_;
			const gchar* _tmp359_;
			const gchar* _tmp360_;
			gchar* _tmp361_;
			gchar* _tmp362_;
			ValaCCodeIdentifier* _tmp363_;
			ValaCCodeIdentifier* _tmp364_;
			ValaCCodeUnaryExpression* _tmp365_;
			ValaCCodeUnaryExpression* _tmp366_;
			_tmp5_ = _m_index;
			_m_index = _tmp5_ + 1;
			_tmp6_ = _m_index;
			_tmp7_ = _m_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _m_list;
			_tmp9_ = _m_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			m = (ValaMethod*) _tmp10_;
			_tmp14_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_CREATION_METHOD)) {
				_tmp13_ = TRUE;
			} else {
				ValaMethod* _tmp15_;
				ValaMemberBinding _tmp16_;
				ValaMemberBinding _tmp17_;
				_tmp15_ = m;
				_tmp16_ = vala_method_get_binding (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp13_ = _tmp17_ != VALA_MEMBER_BINDING_INSTANCE;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				ValaMethod* _tmp18_;
				gboolean _tmp19_;
				gboolean _tmp20_;
				_tmp18_ = m;
				_tmp19_ = vala_method_get_overrides (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp12_ = _tmp20_;
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				ValaMethod* _tmp21_;
				ValaSymbolAccessibility _tmp22_;
				ValaSymbolAccessibility _tmp23_;
				_tmp21_ = m;
				_tmp22_ = vala_symbol_get_access ((ValaSymbol*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp11_ = _tmp23_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp11_) {
				_vala_code_node_unref0 (m);
				continue;
			}
			_tmp24_ = m;
			if (!vala_gd_bus_module_is_dbus_visible ((ValaCodeNode*) _tmp24_)) {
				_vala_code_node_unref0 (m);
				continue;
			}
			_tmp25_ = vala_ccode_initializer_list_new ();
			in_args_info = _tmp25_;
			_tmp26_ = vala_ccode_initializer_list_new ();
			out_args_info = _tmp26_;
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp27_;
				ValaList* _tmp28_;
				gint _param_size = 0;
				ValaList* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _param_index = 0;
				_tmp27_ = m;
				_tmp28_ = vala_callable_get_parameters ((ValaCallable*) _tmp27_);
				_param_list = _tmp28_;
				_tmp29_ = _param_list;
				_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
				_tmp31_ = _tmp30_;
				_param_size = _tmp31_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					ValaParameter* param = NULL;
					ValaList* _tmp35_;
					gint _tmp36_;
					gpointer _tmp37_;
					gboolean _tmp38_ = FALSE;
					ValaParameter* _tmp39_;
					ValaDataType* _tmp40_;
					ValaDataType* _tmp41_;
					gboolean _tmp49_ = FALSE;
					ValaParameter* _tmp50_;
					ValaDataType* _tmp51_;
					ValaDataType* _tmp52_;
					ValaCCodeInitializerList* info = NULL;
					ValaCCodeInitializerList* _tmp60_;
					ValaCCodeInitializerList* _tmp61_;
					ValaCCodeConstant* _tmp62_;
					ValaCCodeConstant* _tmp63_;
					ValaCCodeInitializerList* _tmp64_;
					ValaParameter* _tmp65_;
					const gchar* _tmp66_;
					const gchar* _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
					ValaCCodeConstant* _tmp70_;
					ValaCCodeConstant* _tmp71_;
					ValaCCodeInitializerList* _tmp72_;
					ValaParameter* _tmp73_;
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					ValaParameter* _tmp76_;
					gchar* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					ValaCCodeConstant* _tmp81_;
					ValaCCodeConstant* _tmp82_;
					ValaCCodeInitializerList* _tmp83_;
					ValaCCodeConstant* _tmp84_;
					ValaCCodeConstant* _tmp85_;
					ValaCCodeDeclaration* _cdecl_ = NULL;
					ValaCCodeDeclaration* _tmp86_;
					ValaCCodeDeclaration* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					gchar* _tmp91_;
					gchar* _tmp92_;
					gchar* _tmp93_;
					ValaMethod* _tmp94_;
					const gchar* _tmp95_;
					const gchar* _tmp96_;
					gchar* _tmp97_;
					gchar* _tmp98_;
					gchar* _tmp99_;
					gchar* _tmp100_;
					ValaParameter* _tmp101_;
					const gchar* _tmp102_;
					const gchar* _tmp103_;
					gchar* _tmp104_;
					gchar* _tmp105_;
					ValaCCodeInitializerList* _tmp106_;
					ValaCCodeVariableDeclarator* _tmp107_;
					ValaCCodeVariableDeclarator* _tmp108_;
					ValaCCodeDeclaration* _tmp109_;
					ValaCCodeFile* _tmp110_;
					ValaCCodeDeclaration* _tmp111_;
					ValaParameter* _tmp112_;
					ValaParameterDirection _tmp113_;
					ValaParameterDirection _tmp114_;
					_tmp32_ = _param_index;
					_param_index = _tmp32_ + 1;
					_tmp33_ = _param_index;
					_tmp34_ = _param_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _param_list;
					_tmp36_ = _param_index;
					_tmp37_ = vala_list_get (_tmp35_, _tmp36_);
					param = (ValaParameter*) _tmp37_;
					_tmp39_ = param;
					_tmp40_ = vala_variable_get_variable_type ((ValaVariable*) _tmp39_);
					_tmp41_ = _tmp40_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, VALA_TYPE_OBJECT_TYPE)) {
						ValaParameter* _tmp42_;
						ValaDataType* _tmp43_;
						ValaDataType* _tmp44_;
						ValaTypeSymbol* _tmp45_;
						ValaTypeSymbol* _tmp46_;
						gchar* _tmp47_;
						gchar* _tmp48_;
						_tmp42_ = param;
						_tmp43_ = vala_variable_get_variable_type ((ValaVariable*) _tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = vala_data_type_get_data_type (_tmp44_);
						_tmp46_ = _tmp45_;
						_tmp47_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp46_);
						_tmp48_ = _tmp47_;
						_tmp38_ = g_strcmp0 (_tmp48_, "GLib.Cancellable") == 0;
						_g_free0 (_tmp48_);
					} else {
						_tmp38_ = FALSE;
					}
					if (_tmp38_) {
						_vala_code_node_unref0 (param);
						continue;
					}
					_tmp50_ = param;
					_tmp51_ = vala_variable_get_variable_type ((ValaVariable*) _tmp50_);
					_tmp52_ = _tmp51_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, VALA_TYPE_OBJECT_TYPE)) {
						ValaParameter* _tmp53_;
						ValaDataType* _tmp54_;
						ValaDataType* _tmp55_;
						ValaTypeSymbol* _tmp56_;
						ValaTypeSymbol* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
						_tmp53_ = param;
						_tmp54_ = vala_variable_get_variable_type ((ValaVariable*) _tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = vala_data_type_get_data_type (_tmp55_);
						_tmp57_ = _tmp56_;
						_tmp58_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp57_);
						_tmp59_ = _tmp58_;
						_tmp49_ = g_strcmp0 (_tmp59_, "GLib.BusName") == 0;
						_g_free0 (_tmp59_);
					} else {
						_tmp49_ = FALSE;
					}
					if (_tmp49_) {
						_vala_code_node_unref0 (param);
						continue;
					}
					_tmp60_ = vala_ccode_initializer_list_new ();
					info = _tmp60_;
					_tmp61_ = info;
					_tmp62_ = vala_ccode_constant_new ("-1");
					_tmp63_ = _tmp62_;
					vala_ccode_initializer_list_append (_tmp61_, (ValaCCodeExpression*) _tmp63_);
					_vala_ccode_node_unref0 (_tmp63_);
					_tmp64_ = info;
					_tmp65_ = param;
					_tmp66_ = vala_symbol_get_name ((ValaSymbol*) _tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = g_strdup_printf ("\"%s\"", _tmp67_);
					_tmp69_ = _tmp68_;
					_tmp70_ = vala_ccode_constant_new (_tmp69_);
					_tmp71_ = _tmp70_;
					vala_ccode_initializer_list_append (_tmp64_, (ValaCCodeExpression*) _tmp71_);
					_vala_ccode_node_unref0 (_tmp71_);
					_g_free0 (_tmp69_);
					_tmp72_ = info;
					_tmp73_ = param;
					_tmp74_ = vala_variable_get_variable_type ((ValaVariable*) _tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = param;
					_tmp77_ = vala_gvariant_module_get_type_signature (_tmp75_, (ValaSymbol*) _tmp76_);
					_tmp78_ = _tmp77_;
					_tmp79_ = g_strdup_printf ("\"%s\"", _tmp78_);
					_tmp80_ = _tmp79_;
					_tmp81_ = vala_ccode_constant_new (_tmp80_);
					_tmp82_ = _tmp81_;
					vala_ccode_initializer_list_append (_tmp72_, (ValaCCodeExpression*) _tmp82_);
					_vala_ccode_node_unref0 (_tmp82_);
					_g_free0 (_tmp80_);
					_g_free0 (_tmp78_);
					_tmp83_ = info;
					_tmp84_ = vala_ccode_constant_new ("NULL");
					_tmp85_ = _tmp84_;
					vala_ccode_initializer_list_append (_tmp83_, (ValaCCodeExpression*) _tmp85_);
					_vala_ccode_node_unref0 (_tmp85_);
					_tmp86_ = vala_ccode_declaration_new ("const GDBusArgInfo");
					_cdecl_ = _tmp86_;
					_tmp87_ = _cdecl_;
					_tmp88_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
					_tmp89_ = _tmp88_;
					_tmp90_ = g_strconcat ("_", _tmp89_, NULL);
					_tmp91_ = _tmp90_;
					_tmp92_ = g_strconcat (_tmp91_, "dbus_arg_info_", NULL);
					_tmp93_ = _tmp92_;
					_tmp94_ = m;
					_tmp95_ = vala_symbol_get_name ((ValaSymbol*) _tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = g_strconcat (_tmp93_, _tmp96_, NULL);
					_tmp98_ = _tmp97_;
					_tmp99_ = g_strconcat (_tmp98_, "_", NULL);
					_tmp100_ = _tmp99_;
					_tmp101_ = param;
					_tmp102_ = vala_symbol_get_name ((ValaSymbol*) _tmp101_);
					_tmp103_ = _tmp102_;
					_tmp104_ = g_strconcat (_tmp100_, _tmp103_, NULL);
					_tmp105_ = _tmp104_;
					_tmp106_ = info;
					_tmp107_ = vala_ccode_variable_declarator_new (_tmp105_, (ValaCCodeExpression*) _tmp106_, NULL);
					_tmp108_ = _tmp107_;
					vala_ccode_declaration_add_declarator (_tmp87_, (ValaCCodeDeclarator*) _tmp108_);
					_vala_ccode_node_unref0 (_tmp108_);
					_g_free0 (_tmp105_);
					_g_free0 (_tmp100_);
					_g_free0 (_tmp98_);
					_g_free0 (_tmp93_);
					_g_free0 (_tmp91_);
					_g_free0 (_tmp89_);
					_tmp109_ = _cdecl_;
					vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp109_, VALA_CCODE_MODIFIERS_STATIC);
					_tmp110_ = ((ValaCCodeBaseModule*) self)->cfile;
					_tmp111_ = _cdecl_;
					vala_ccode_file_add_constant_declaration (_tmp110_, (ValaCCodeNode*) _tmp111_);
					_tmp112_ = param;
					_tmp113_ = vala_parameter_get_direction (_tmp112_);
					_tmp114_ = _tmp113_;
					if (_tmp114_ == VALA_PARAMETER_DIRECTION_IN) {
						ValaCCodeInitializerList* _tmp115_;
						gchar* _tmp116_;
						gchar* _tmp117_;
						gchar* _tmp118_;
						gchar* _tmp119_;
						gchar* _tmp120_;
						gchar* _tmp121_;
						ValaMethod* _tmp122_;
						const gchar* _tmp123_;
						const gchar* _tmp124_;
						gchar* _tmp125_;
						gchar* _tmp126_;
						gchar* _tmp127_;
						gchar* _tmp128_;
						ValaParameter* _tmp129_;
						const gchar* _tmp130_;
						const gchar* _tmp131_;
						gchar* _tmp132_;
						gchar* _tmp133_;
						ValaCCodeIdentifier* _tmp134_;
						ValaCCodeIdentifier* _tmp135_;
						ValaCCodeUnaryExpression* _tmp136_;
						ValaCCodeUnaryExpression* _tmp137_;
						_tmp115_ = in_args_info;
						_tmp116_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
						_tmp117_ = _tmp116_;
						_tmp118_ = g_strconcat ("_", _tmp117_, NULL);
						_tmp119_ = _tmp118_;
						_tmp120_ = g_strconcat (_tmp119_, "dbus_arg_info_", NULL);
						_tmp121_ = _tmp120_;
						_tmp122_ = m;
						_tmp123_ = vala_symbol_get_name ((ValaSymbol*) _tmp122_);
						_tmp124_ = _tmp123_;
						_tmp125_ = g_strconcat (_tmp121_, _tmp124_, NULL);
						_tmp126_ = _tmp125_;
						_tmp127_ = g_strconcat (_tmp126_, "_", NULL);
						_tmp128_ = _tmp127_;
						_tmp129_ = param;
						_tmp130_ = vala_symbol_get_name ((ValaSymbol*) _tmp129_);
						_tmp131_ = _tmp130_;
						_tmp132_ = g_strconcat (_tmp128_, _tmp131_, NULL);
						_tmp133_ = _tmp132_;
						_tmp134_ = vala_ccode_identifier_new (_tmp133_);
						_tmp135_ = _tmp134_;
						_tmp136_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp135_);
						_tmp137_ = _tmp136_;
						vala_ccode_initializer_list_append (_tmp115_, (ValaCCodeExpression*) _tmp137_);
						_vala_ccode_node_unref0 (_tmp137_);
						_vala_ccode_node_unref0 (_tmp135_);
						_g_free0 (_tmp133_);
						_g_free0 (_tmp128_);
						_g_free0 (_tmp126_);
						_g_free0 (_tmp121_);
						_g_free0 (_tmp119_);
						_g_free0 (_tmp117_);
					} else {
						ValaCCodeInitializerList* _tmp138_;
						gchar* _tmp139_;
						gchar* _tmp140_;
						gchar* _tmp141_;
						gchar* _tmp142_;
						gchar* _tmp143_;
						gchar* _tmp144_;
						ValaMethod* _tmp145_;
						const gchar* _tmp146_;
						const gchar* _tmp147_;
						gchar* _tmp148_;
						gchar* _tmp149_;
						gchar* _tmp150_;
						gchar* _tmp151_;
						ValaParameter* _tmp152_;
						const gchar* _tmp153_;
						const gchar* _tmp154_;
						gchar* _tmp155_;
						gchar* _tmp156_;
						ValaCCodeIdentifier* _tmp157_;
						ValaCCodeIdentifier* _tmp158_;
						ValaCCodeUnaryExpression* _tmp159_;
						ValaCCodeUnaryExpression* _tmp160_;
						_tmp138_ = out_args_info;
						_tmp139_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
						_tmp140_ = _tmp139_;
						_tmp141_ = g_strconcat ("_", _tmp140_, NULL);
						_tmp142_ = _tmp141_;
						_tmp143_ = g_strconcat (_tmp142_, "dbus_arg_info_", NULL);
						_tmp144_ = _tmp143_;
						_tmp145_ = m;
						_tmp146_ = vala_symbol_get_name ((ValaSymbol*) _tmp145_);
						_tmp147_ = _tmp146_;
						_tmp148_ = g_strconcat (_tmp144_, _tmp147_, NULL);
						_tmp149_ = _tmp148_;
						_tmp150_ = g_strconcat (_tmp149_, "_", NULL);
						_tmp151_ = _tmp150_;
						_tmp152_ = param;
						_tmp153_ = vala_symbol_get_name ((ValaSymbol*) _tmp152_);
						_tmp154_ = _tmp153_;
						_tmp155_ = g_strconcat (_tmp151_, _tmp154_, NULL);
						_tmp156_ = _tmp155_;
						_tmp157_ = vala_ccode_identifier_new (_tmp156_);
						_tmp158_ = _tmp157_;
						_tmp159_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp158_);
						_tmp160_ = _tmp159_;
						vala_ccode_initializer_list_append (_tmp138_, (ValaCCodeExpression*) _tmp160_);
						_vala_ccode_node_unref0 (_tmp160_);
						_vala_ccode_node_unref0 (_tmp158_);
						_g_free0 (_tmp156_);
						_g_free0 (_tmp151_);
						_g_free0 (_tmp149_);
						_g_free0 (_tmp144_);
						_g_free0 (_tmp142_);
						_g_free0 (_tmp140_);
					}
					_vala_ccode_node_unref0 (_cdecl_);
					_vala_ccode_node_unref0 (info);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp161_ = m;
			_tmp162_ = vala_callable_get_return_type ((ValaCallable*) _tmp161_);
			_tmp163_ = _tmp162_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp163_, VALA_TYPE_VOID_TYPE)) {
				ValaCCodeInitializerList* info = NULL;
				ValaCCodeInitializerList* _tmp164_;
				ValaCCodeInitializerList* _tmp165_;
				ValaCCodeConstant* _tmp166_;
				ValaCCodeConstant* _tmp167_;
				ValaCCodeInitializerList* _tmp168_;
				ValaMethod* _tmp169_;
				gchar* _tmp170_;
				gchar* _tmp171_;
				gchar* _tmp172_;
				gchar* _tmp173_;
				ValaCCodeConstant* _tmp174_;
				ValaCCodeConstant* _tmp175_;
				ValaCCodeInitializerList* _tmp176_;
				ValaMethod* _tmp177_;
				ValaDataType* _tmp178_;
				ValaDataType* _tmp179_;
				ValaMethod* _tmp180_;
				gchar* _tmp181_;
				gchar* _tmp182_;
				gchar* _tmp183_;
				gchar* _tmp184_;
				ValaCCodeConstant* _tmp185_;
				ValaCCodeConstant* _tmp186_;
				ValaCCodeInitializerList* _tmp187_;
				ValaCCodeConstant* _tmp188_;
				ValaCCodeConstant* _tmp189_;
				ValaCCodeDeclaration* _cdecl_ = NULL;
				ValaCCodeDeclaration* _tmp190_;
				ValaCCodeDeclaration* _tmp191_;
				gchar* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				gchar* _tmp195_;
				gchar* _tmp196_;
				gchar* _tmp197_;
				ValaMethod* _tmp198_;
				const gchar* _tmp199_;
				const gchar* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				gchar* _tmp203_;
				gchar* _tmp204_;
				ValaCCodeInitializerList* _tmp205_;
				ValaCCodeVariableDeclarator* _tmp206_;
				ValaCCodeVariableDeclarator* _tmp207_;
				ValaCCodeDeclaration* _tmp208_;
				ValaCCodeFile* _tmp209_;
				ValaCCodeDeclaration* _tmp210_;
				ValaCCodeInitializerList* _tmp211_;
				gchar* _tmp212_;
				gchar* _tmp213_;
				gchar* _tmp214_;
				gchar* _tmp215_;
				gchar* _tmp216_;
				gchar* _tmp217_;
				ValaMethod* _tmp218_;
				const gchar* _tmp219_;
				const gchar* _tmp220_;
				gchar* _tmp221_;
				gchar* _tmp222_;
				gchar* _tmp223_;
				gchar* _tmp224_;
				ValaCCodeIdentifier* _tmp225_;
				ValaCCodeIdentifier* _tmp226_;
				ValaCCodeUnaryExpression* _tmp227_;
				ValaCCodeUnaryExpression* _tmp228_;
				_tmp164_ = vala_ccode_initializer_list_new ();
				info = _tmp164_;
				_tmp165_ = info;
				_tmp166_ = vala_ccode_constant_new ("-1");
				_tmp167_ = _tmp166_;
				vala_ccode_initializer_list_append (_tmp165_, (ValaCCodeExpression*) _tmp167_);
				_vala_ccode_node_unref0 (_tmp167_);
				_tmp168_ = info;
				_tmp169_ = m;
				_tmp170_ = vala_gd_bus_module_dbus_result_name (_tmp169_);
				_tmp171_ = _tmp170_;
				_tmp172_ = g_strdup_printf ("\"%s\"", _tmp171_);
				_tmp173_ = _tmp172_;
				_tmp174_ = vala_ccode_constant_new (_tmp173_);
				_tmp175_ = _tmp174_;
				vala_ccode_initializer_list_append (_tmp168_, (ValaCCodeExpression*) _tmp175_);
				_vala_ccode_node_unref0 (_tmp175_);
				_g_free0 (_tmp173_);
				_g_free0 (_tmp171_);
				_tmp176_ = info;
				_tmp177_ = m;
				_tmp178_ = vala_callable_get_return_type ((ValaCallable*) _tmp177_);
				_tmp179_ = _tmp178_;
				_tmp180_ = m;
				_tmp181_ = vala_gvariant_module_get_type_signature (_tmp179_, (ValaSymbol*) _tmp180_);
				_tmp182_ = _tmp181_;
				_tmp183_ = g_strdup_printf ("\"%s\"", _tmp182_);
				_tmp184_ = _tmp183_;
				_tmp185_ = vala_ccode_constant_new (_tmp184_);
				_tmp186_ = _tmp185_;
				vala_ccode_initializer_list_append (_tmp176_, (ValaCCodeExpression*) _tmp186_);
				_vala_ccode_node_unref0 (_tmp186_);
				_g_free0 (_tmp184_);
				_g_free0 (_tmp182_);
				_tmp187_ = info;
				_tmp188_ = vala_ccode_constant_new ("NULL");
				_tmp189_ = _tmp188_;
				vala_ccode_initializer_list_append (_tmp187_, (ValaCCodeExpression*) _tmp189_);
				_vala_ccode_node_unref0 (_tmp189_);
				_tmp190_ = vala_ccode_declaration_new ("const GDBusArgInfo");
				_cdecl_ = _tmp190_;
				_tmp191_ = _cdecl_;
				_tmp192_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
				_tmp193_ = _tmp192_;
				_tmp194_ = g_strconcat ("_", _tmp193_, NULL);
				_tmp195_ = _tmp194_;
				_tmp196_ = g_strconcat (_tmp195_, "dbus_arg_info_", NULL);
				_tmp197_ = _tmp196_;
				_tmp198_ = m;
				_tmp199_ = vala_symbol_get_name ((ValaSymbol*) _tmp198_);
				_tmp200_ = _tmp199_;
				_tmp201_ = g_strconcat (_tmp197_, _tmp200_, NULL);
				_tmp202_ = _tmp201_;
				_tmp203_ = g_strconcat (_tmp202_, "_result", NULL);
				_tmp204_ = _tmp203_;
				_tmp205_ = info;
				_tmp206_ = vala_ccode_variable_declarator_new (_tmp204_, (ValaCCodeExpression*) _tmp205_, NULL);
				_tmp207_ = _tmp206_;
				vala_ccode_declaration_add_declarator (_tmp191_, (ValaCCodeDeclarator*) _tmp207_);
				_vala_ccode_node_unref0 (_tmp207_);
				_g_free0 (_tmp204_);
				_g_free0 (_tmp202_);
				_g_free0 (_tmp197_);
				_g_free0 (_tmp195_);
				_g_free0 (_tmp193_);
				_tmp208_ = _cdecl_;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp208_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp209_ = ((ValaCCodeBaseModule*) self)->cfile;
				_tmp210_ = _cdecl_;
				vala_ccode_file_add_constant_declaration (_tmp209_, (ValaCCodeNode*) _tmp210_);
				_tmp211_ = out_args_info;
				_tmp212_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
				_tmp213_ = _tmp212_;
				_tmp214_ = g_strconcat ("_", _tmp213_, NULL);
				_tmp215_ = _tmp214_;
				_tmp216_ = g_strconcat (_tmp215_, "dbus_arg_info_", NULL);
				_tmp217_ = _tmp216_;
				_tmp218_ = m;
				_tmp219_ = vala_symbol_get_name ((ValaSymbol*) _tmp218_);
				_tmp220_ = _tmp219_;
				_tmp221_ = g_strconcat (_tmp217_, _tmp220_, NULL);
				_tmp222_ = _tmp221_;
				_tmp223_ = g_strconcat (_tmp222_, "_result", NULL);
				_tmp224_ = _tmp223_;
				_tmp225_ = vala_ccode_identifier_new (_tmp224_);
				_tmp226_ = _tmp225_;
				_tmp227_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp226_);
				_tmp228_ = _tmp227_;
				vala_ccode_initializer_list_append (_tmp211_, (ValaCCodeExpression*) _tmp228_);
				_vala_ccode_node_unref0 (_tmp228_);
				_vala_ccode_node_unref0 (_tmp226_);
				_g_free0 (_tmp224_);
				_g_free0 (_tmp222_);
				_g_free0 (_tmp217_);
				_g_free0 (_tmp215_);
				_g_free0 (_tmp213_);
				_vala_ccode_node_unref0 (_cdecl_);
				_vala_ccode_node_unref0 (info);
			}
			_tmp229_ = in_args_info;
			_tmp230_ = vala_ccode_constant_new ("NULL");
			_tmp231_ = _tmp230_;
			vala_ccode_initializer_list_append (_tmp229_, (ValaCCodeExpression*) _tmp231_);
			_vala_ccode_node_unref0 (_tmp231_);
			_tmp232_ = out_args_info;
			_tmp233_ = vala_ccode_constant_new ("NULL");
			_tmp234_ = _tmp233_;
			vala_ccode_initializer_list_append (_tmp232_, (ValaCCodeExpression*) _tmp234_);
			_vala_ccode_node_unref0 (_tmp234_);
			_tmp235_ = vala_ccode_declaration_new ("const GDBusArgInfo * const");
			_cdecl_ = _tmp235_;
			_tmp236_ = _cdecl_;
			_tmp237_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp238_ = _tmp237_;
			_tmp239_ = g_strconcat ("_", _tmp238_, NULL);
			_tmp240_ = _tmp239_;
			_tmp241_ = g_strconcat (_tmp240_, "dbus_arg_info_", NULL);
			_tmp242_ = _tmp241_;
			_tmp243_ = m;
			_tmp244_ = vala_symbol_get_name ((ValaSymbol*) _tmp243_);
			_tmp245_ = _tmp244_;
			_tmp246_ = g_strconcat (_tmp242_, _tmp245_, NULL);
			_tmp247_ = _tmp246_;
			_tmp248_ = g_strconcat (_tmp247_, "_in[]", NULL);
			_tmp249_ = _tmp248_;
			_tmp250_ = in_args_info;
			_tmp251_ = vala_ccode_variable_declarator_new (_tmp249_, (ValaCCodeExpression*) _tmp250_, NULL);
			_tmp252_ = _tmp251_;
			vala_ccode_declaration_add_declarator (_tmp236_, (ValaCCodeDeclarator*) _tmp252_);
			_vala_ccode_node_unref0 (_tmp252_);
			_g_free0 (_tmp249_);
			_g_free0 (_tmp247_);
			_g_free0 (_tmp242_);
			_g_free0 (_tmp240_);
			_g_free0 (_tmp238_);
			_tmp253_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp253_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp254_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp255_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp254_, (ValaCCodeNode*) _tmp255_);
			_tmp256_ = vala_ccode_declaration_new ("const GDBusArgInfo * const");
			_vala_ccode_node_unref0 (_cdecl_);
			_cdecl_ = _tmp256_;
			_tmp257_ = _cdecl_;
			_tmp258_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp259_ = _tmp258_;
			_tmp260_ = g_strconcat ("_", _tmp259_, NULL);
			_tmp261_ = _tmp260_;
			_tmp262_ = g_strconcat (_tmp261_, "dbus_arg_info_", NULL);
			_tmp263_ = _tmp262_;
			_tmp264_ = m;
			_tmp265_ = vala_symbol_get_name ((ValaSymbol*) _tmp264_);
			_tmp266_ = _tmp265_;
			_tmp267_ = g_strconcat (_tmp263_, _tmp266_, NULL);
			_tmp268_ = _tmp267_;
			_tmp269_ = g_strconcat (_tmp268_, "_out[]", NULL);
			_tmp270_ = _tmp269_;
			_tmp271_ = out_args_info;
			_tmp272_ = vala_ccode_variable_declarator_new (_tmp270_, (ValaCCodeExpression*) _tmp271_, NULL);
			_tmp273_ = _tmp272_;
			vala_ccode_declaration_add_declarator (_tmp257_, (ValaCCodeDeclarator*) _tmp273_);
			_vala_ccode_node_unref0 (_tmp273_);
			_g_free0 (_tmp270_);
			_g_free0 (_tmp268_);
			_g_free0 (_tmp263_);
			_g_free0 (_tmp261_);
			_g_free0 (_tmp259_);
			_tmp274_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp274_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp275_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp276_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp275_, (ValaCCodeNode*) _tmp276_);
			_tmp277_ = vala_ccode_initializer_list_new ();
			info = _tmp277_;
			_tmp278_ = info;
			_tmp279_ = vala_ccode_constant_new ("-1");
			_tmp280_ = _tmp279_;
			vala_ccode_initializer_list_append (_tmp278_, (ValaCCodeExpression*) _tmp280_);
			_vala_ccode_node_unref0 (_tmp280_);
			_tmp281_ = info;
			_tmp282_ = m;
			_tmp283_ = vala_gd_bus_module_get_dbus_name_for_member ((ValaSymbol*) _tmp282_);
			_tmp284_ = _tmp283_;
			_tmp285_ = g_strdup_printf ("\"%s\"", _tmp284_);
			_tmp286_ = _tmp285_;
			_tmp287_ = vala_ccode_constant_new (_tmp286_);
			_tmp288_ = _tmp287_;
			vala_ccode_initializer_list_append (_tmp281_, (ValaCCodeExpression*) _tmp288_);
			_vala_ccode_node_unref0 (_tmp288_);
			_g_free0 (_tmp286_);
			_g_free0 (_tmp284_);
			_tmp289_ = info;
			_tmp290_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp291_ = _tmp290_;
			_tmp292_ = g_strconcat ("_", _tmp291_, NULL);
			_tmp293_ = _tmp292_;
			_tmp294_ = g_strconcat (_tmp293_, "dbus_arg_info_", NULL);
			_tmp295_ = _tmp294_;
			_tmp296_ = m;
			_tmp297_ = vala_symbol_get_name ((ValaSymbol*) _tmp296_);
			_tmp298_ = _tmp297_;
			_tmp299_ = g_strconcat (_tmp295_, _tmp298_, NULL);
			_tmp300_ = _tmp299_;
			_tmp301_ = g_strconcat (_tmp300_, "_in", NULL);
			_tmp302_ = _tmp301_;
			_tmp303_ = vala_ccode_identifier_new (_tmp302_);
			_tmp304_ = _tmp303_;
			_tmp305_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp304_);
			_tmp306_ = _tmp305_;
			_tmp307_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp306_, "GDBusArgInfo **");
			_tmp308_ = _tmp307_;
			vala_ccode_initializer_list_append (_tmp289_, (ValaCCodeExpression*) _tmp308_);
			_vala_ccode_node_unref0 (_tmp308_);
			_vala_ccode_node_unref0 (_tmp306_);
			_vala_ccode_node_unref0 (_tmp304_);
			_g_free0 (_tmp302_);
			_g_free0 (_tmp300_);
			_g_free0 (_tmp295_);
			_g_free0 (_tmp293_);
			_g_free0 (_tmp291_);
			_tmp309_ = info;
			_tmp310_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp311_ = _tmp310_;
			_tmp312_ = g_strconcat ("_", _tmp311_, NULL);
			_tmp313_ = _tmp312_;
			_tmp314_ = g_strconcat (_tmp313_, "dbus_arg_info_", NULL);
			_tmp315_ = _tmp314_;
			_tmp316_ = m;
			_tmp317_ = vala_symbol_get_name ((ValaSymbol*) _tmp316_);
			_tmp318_ = _tmp317_;
			_tmp319_ = g_strconcat (_tmp315_, _tmp318_, NULL);
			_tmp320_ = _tmp319_;
			_tmp321_ = g_strconcat (_tmp320_, "_out", NULL);
			_tmp322_ = _tmp321_;
			_tmp323_ = vala_ccode_identifier_new (_tmp322_);
			_tmp324_ = _tmp323_;
			_tmp325_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp324_);
			_tmp326_ = _tmp325_;
			_tmp327_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp326_, "GDBusArgInfo **");
			_tmp328_ = _tmp327_;
			vala_ccode_initializer_list_append (_tmp309_, (ValaCCodeExpression*) _tmp328_);
			_vala_ccode_node_unref0 (_tmp328_);
			_vala_ccode_node_unref0 (_tmp326_);
			_vala_ccode_node_unref0 (_tmp324_);
			_g_free0 (_tmp322_);
			_g_free0 (_tmp320_);
			_g_free0 (_tmp315_);
			_g_free0 (_tmp313_);
			_g_free0 (_tmp311_);
			_tmp329_ = info;
			_tmp330_ = vala_ccode_constant_new ("NULL");
			_tmp331_ = _tmp330_;
			vala_ccode_initializer_list_append (_tmp329_, (ValaCCodeExpression*) _tmp331_);
			_vala_ccode_node_unref0 (_tmp331_);
			_tmp332_ = vala_ccode_declaration_new ("const GDBusMethodInfo");
			_vala_ccode_node_unref0 (_cdecl_);
			_cdecl_ = _tmp332_;
			_tmp333_ = _cdecl_;
			_tmp334_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp335_ = _tmp334_;
			_tmp336_ = g_strconcat ("_", _tmp335_, NULL);
			_tmp337_ = _tmp336_;
			_tmp338_ = g_strconcat (_tmp337_, "dbus_method_info_", NULL);
			_tmp339_ = _tmp338_;
			_tmp340_ = m;
			_tmp341_ = vala_symbol_get_name ((ValaSymbol*) _tmp340_);
			_tmp342_ = _tmp341_;
			_tmp343_ = g_strconcat (_tmp339_, _tmp342_, NULL);
			_tmp344_ = _tmp343_;
			_tmp345_ = info;
			_tmp346_ = vala_ccode_variable_declarator_new (_tmp344_, (ValaCCodeExpression*) _tmp345_, NULL);
			_tmp347_ = _tmp346_;
			vala_ccode_declaration_add_declarator (_tmp333_, (ValaCCodeDeclarator*) _tmp347_);
			_vala_ccode_node_unref0 (_tmp347_);
			_g_free0 (_tmp344_);
			_g_free0 (_tmp339_);
			_g_free0 (_tmp337_);
			_g_free0 (_tmp335_);
			_tmp348_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp348_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp349_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp350_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp349_, (ValaCCodeNode*) _tmp350_);
			_tmp351_ = infos;
			_tmp352_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp353_ = _tmp352_;
			_tmp354_ = g_strconcat ("_", _tmp353_, NULL);
			_tmp355_ = _tmp354_;
			_tmp356_ = g_strconcat (_tmp355_, "dbus_method_info_", NULL);
			_tmp357_ = _tmp356_;
			_tmp358_ = m;
			_tmp359_ = vala_symbol_get_name ((ValaSymbol*) _tmp358_);
			_tmp360_ = _tmp359_;
			_tmp361_ = g_strconcat (_tmp357_, _tmp360_, NULL);
			_tmp362_ = _tmp361_;
			_tmp363_ = vala_ccode_identifier_new (_tmp362_);
			_tmp364_ = _tmp363_;
			_tmp365_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp364_);
			_tmp366_ = _tmp365_;
			vala_ccode_initializer_list_append (_tmp351_, (ValaCCodeExpression*) _tmp366_);
			_vala_ccode_node_unref0 (_tmp366_);
			_vala_ccode_node_unref0 (_tmp364_);
			_g_free0 (_tmp362_);
			_g_free0 (_tmp357_);
			_g_free0 (_tmp355_);
			_g_free0 (_tmp353_);
			_vala_ccode_node_unref0 (info);
			_vala_ccode_node_unref0 (_cdecl_);
			_vala_ccode_node_unref0 (out_args_info);
			_vala_ccode_node_unref0 (in_args_info);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	_tmp367_ = infos;
	_tmp368_ = vala_ccode_constant_new ("NULL");
	_tmp369_ = _tmp368_;
	vala_ccode_initializer_list_append (_tmp367_, (ValaCCodeExpression*) _tmp369_);
	_vala_ccode_node_unref0 (_tmp369_);
	_tmp370_ = vala_ccode_declaration_new ("const GDBusMethodInfo * const");
	_cdecl_ = _tmp370_;
	_tmp371_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp372_ = _tmp371_;
	_tmp373_ = g_strconcat ("_", _tmp372_, NULL);
	_tmp374_ = _tmp373_;
	_tmp375_ = g_strconcat (_tmp374_, "dbus_method_info[]", NULL);
	_tmp376_ = _tmp375_;
	_tmp377_ = infos;
	_tmp378_ = vala_ccode_variable_declarator_new (_tmp376_, (ValaCCodeExpression*) _tmp377_, NULL);
	_tmp379_ = _tmp378_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp379_);
	_vala_ccode_node_unref0 (_tmp379_);
	_g_free0 (_tmp376_);
	_g_free0 (_tmp374_);
	_g_free0 (_tmp372_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp380_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp380_, (ValaCCodeNode*) _cdecl_);
	_tmp381_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp382_ = _tmp381_;
	_tmp383_ = g_strconcat ("_", _tmp382_, NULL);
	_tmp384_ = _tmp383_;
	_tmp385_ = g_strconcat (_tmp384_, "dbus_method_info", NULL);
	_tmp386_ = _tmp385_;
	_tmp387_ = vala_ccode_identifier_new (_tmp386_);
	_tmp388_ = (ValaCCodeExpression*) _tmp387_;
	_g_free0 (_tmp386_);
	_g_free0 (_tmp384_);
	_g_free0 (_tmp382_);
	result = _tmp388_;
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (infos);
	return result;
}


static ValaCCodeExpression*
vala_gd_bus_module_get_signal_info (ValaGDBusModule* self,
                                    ValaObjectTypeSymbol* sym)
{
	ValaCCodeExpression* result = NULL;
	ValaCCodeInitializerList* infos = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeInitializerList* _tmp194_;
	ValaCCodeConstant* _tmp195_;
	ValaCCodeConstant* _tmp196_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp197_;
	gchar* _tmp198_;
	gchar* _tmp199_;
	gchar* _tmp200_;
	gchar* _tmp201_;
	gchar* _tmp202_;
	gchar* _tmp203_;
	ValaCCodeInitializerList* _tmp204_;
	ValaCCodeVariableDeclarator* _tmp205_;
	ValaCCodeVariableDeclarator* _tmp206_;
	ValaCCodeFile* _tmp207_;
	gchar* _tmp208_;
	gchar* _tmp209_;
	gchar* _tmp210_;
	gchar* _tmp211_;
	gchar* _tmp212_;
	gchar* _tmp213_;
	ValaCCodeIdentifier* _tmp214_;
	ValaCCodeExpression* _tmp215_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	infos = _tmp0_;
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp1_;
		gint _sig_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _sig_index = 0;
		_tmp1_ = vala_object_type_symbol_get_signals (sym);
		_sig_list = _tmp1_;
		_tmp2_ = _sig_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_sig_size = _tmp4_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaSignal* sig = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaSignal* _tmp11_;
			ValaSymbolAccessibility _tmp12_;
			ValaSymbolAccessibility _tmp13_;
			ValaSignal* _tmp14_;
			ValaCCodeInitializerList* args_info = NULL;
			ValaCCodeInitializerList* _tmp15_;
			ValaCCodeInitializerList* _tmp102_;
			ValaCCodeConstant* _tmp103_;
			ValaCCodeConstant* _tmp104_;
			ValaCCodeDeclaration* _cdecl_ = NULL;
			ValaCCodeDeclaration* _tmp105_;
			ValaCCodeDeclaration* _tmp106_;
			gchar* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			gchar* _tmp110_;
			gchar* _tmp111_;
			gchar* _tmp112_;
			ValaSignal* _tmp113_;
			gchar* _tmp114_;
			gchar* _tmp115_;
			gchar* _tmp116_;
			gchar* _tmp117_;
			gchar* _tmp118_;
			gchar* _tmp119_;
			ValaCCodeInitializerList* _tmp120_;
			ValaCCodeVariableDeclarator* _tmp121_;
			ValaCCodeVariableDeclarator* _tmp122_;
			ValaCCodeDeclaration* _tmp123_;
			ValaCCodeFile* _tmp124_;
			ValaCCodeDeclaration* _tmp125_;
			ValaCCodeInitializerList* info = NULL;
			ValaCCodeInitializerList* _tmp126_;
			ValaCCodeInitializerList* _tmp127_;
			ValaCCodeConstant* _tmp128_;
			ValaCCodeConstant* _tmp129_;
			ValaCCodeInitializerList* _tmp130_;
			ValaSignal* _tmp131_;
			gchar* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			ValaCCodeConstant* _tmp136_;
			ValaCCodeConstant* _tmp137_;
			ValaCCodeInitializerList* _tmp138_;
			gchar* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			ValaSignal* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			gchar* _tmp149_;
			ValaCCodeIdentifier* _tmp150_;
			ValaCCodeIdentifier* _tmp151_;
			ValaCCodeUnaryExpression* _tmp152_;
			ValaCCodeUnaryExpression* _tmp153_;
			ValaCCodeCastExpression* _tmp154_;
			ValaCCodeCastExpression* _tmp155_;
			ValaCCodeInitializerList* _tmp156_;
			ValaCCodeConstant* _tmp157_;
			ValaCCodeConstant* _tmp158_;
			ValaCCodeDeclaration* _tmp159_;
			ValaCCodeDeclaration* _tmp160_;
			gchar* _tmp161_;
			gchar* _tmp162_;
			gchar* _tmp163_;
			gchar* _tmp164_;
			gchar* _tmp165_;
			gchar* _tmp166_;
			ValaSignal* _tmp167_;
			gchar* _tmp168_;
			gchar* _tmp169_;
			gchar* _tmp170_;
			gchar* _tmp171_;
			ValaCCodeInitializerList* _tmp172_;
			ValaCCodeVariableDeclarator* _tmp173_;
			ValaCCodeVariableDeclarator* _tmp174_;
			ValaCCodeDeclaration* _tmp175_;
			ValaCCodeFile* _tmp176_;
			ValaCCodeDeclaration* _tmp177_;
			ValaCCodeInitializerList* _tmp178_;
			gchar* _tmp179_;
			gchar* _tmp180_;
			gchar* _tmp181_;
			gchar* _tmp182_;
			gchar* _tmp183_;
			gchar* _tmp184_;
			ValaSignal* _tmp185_;
			gchar* _tmp186_;
			gchar* _tmp187_;
			gchar* _tmp188_;
			gchar* _tmp189_;
			ValaCCodeIdentifier* _tmp190_;
			ValaCCodeIdentifier* _tmp191_;
			ValaCCodeUnaryExpression* _tmp192_;
			ValaCCodeUnaryExpression* _tmp193_;
			_tmp5_ = _sig_index;
			_sig_index = _tmp5_ + 1;
			_tmp6_ = _sig_index;
			_tmp7_ = _sig_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _sig_list;
			_tmp9_ = _sig_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			sig = (ValaSignal*) _tmp10_;
			_tmp11_ = sig;
			_tmp12_ = vala_symbol_get_access ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
				_vala_code_node_unref0 (sig);
				continue;
			}
			_tmp14_ = sig;
			if (!vala_gd_bus_module_is_dbus_visible ((ValaCodeNode*) _tmp14_)) {
				_vala_code_node_unref0 (sig);
				continue;
			}
			_tmp15_ = vala_ccode_initializer_list_new ();
			args_info = _tmp15_;
			{
				ValaList* _param_list = NULL;
				ValaSignal* _tmp16_;
				ValaList* _tmp17_;
				gint _param_size = 0;
				ValaList* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _param_index = 0;
				_tmp16_ = sig;
				_tmp17_ = vala_callable_get_parameters ((ValaCallable*) _tmp16_);
				_param_list = _tmp17_;
				_tmp18_ = _param_list;
				_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
				_tmp20_ = _tmp19_;
				_param_size = _tmp20_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					ValaParameter* param = NULL;
					ValaList* _tmp24_;
					gint _tmp25_;
					gpointer _tmp26_;
					ValaCCodeInitializerList* info = NULL;
					ValaCCodeInitializerList* _tmp27_;
					ValaCCodeInitializerList* _tmp28_;
					ValaCCodeConstant* _tmp29_;
					ValaCCodeConstant* _tmp30_;
					ValaCCodeInitializerList* _tmp31_;
					ValaParameter* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					ValaCCodeConstant* _tmp37_;
					ValaCCodeConstant* _tmp38_;
					ValaCCodeInitializerList* _tmp39_;
					ValaParameter* _tmp40_;
					ValaDataType* _tmp41_;
					ValaDataType* _tmp42_;
					ValaParameter* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					ValaCCodeConstant* _tmp48_;
					ValaCCodeConstant* _tmp49_;
					ValaCCodeInitializerList* _tmp50_;
					ValaCCodeConstant* _tmp51_;
					ValaCCodeConstant* _tmp52_;
					ValaCCodeDeclaration* _cdecl_ = NULL;
					ValaCCodeDeclaration* _tmp53_;
					ValaCCodeDeclaration* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					gchar* _tmp59_;
					gchar* _tmp60_;
					ValaSignal* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					gchar* _tmp64_;
					gchar* _tmp65_;
					gchar* _tmp66_;
					gchar* _tmp67_;
					ValaParameter* _tmp68_;
					const gchar* _tmp69_;
					const gchar* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					ValaCCodeInitializerList* _tmp73_;
					ValaCCodeVariableDeclarator* _tmp74_;
					ValaCCodeVariableDeclarator* _tmp75_;
					ValaCCodeDeclaration* _tmp76_;
					ValaCCodeFile* _tmp77_;
					ValaCCodeDeclaration* _tmp78_;
					ValaCCodeInitializerList* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					gchar* _tmp85_;
					ValaSignal* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					gchar* _tmp91_;
					gchar* _tmp92_;
					ValaParameter* _tmp93_;
					const gchar* _tmp94_;
					const gchar* _tmp95_;
					gchar* _tmp96_;
					gchar* _tmp97_;
					ValaCCodeIdentifier* _tmp98_;
					ValaCCodeIdentifier* _tmp99_;
					ValaCCodeUnaryExpression* _tmp100_;
					ValaCCodeUnaryExpression* _tmp101_;
					_tmp21_ = _param_index;
					_param_index = _tmp21_ + 1;
					_tmp22_ = _param_index;
					_tmp23_ = _param_size;
					if (!(_tmp22_ < _tmp23_)) {
						break;
					}
					_tmp24_ = _param_list;
					_tmp25_ = _param_index;
					_tmp26_ = vala_list_get (_tmp24_, _tmp25_);
					param = (ValaParameter*) _tmp26_;
					_tmp27_ = vala_ccode_initializer_list_new ();
					info = _tmp27_;
					_tmp28_ = info;
					_tmp29_ = vala_ccode_constant_new ("-1");
					_tmp30_ = _tmp29_;
					vala_ccode_initializer_list_append (_tmp28_, (ValaCCodeExpression*) _tmp30_);
					_vala_ccode_node_unref0 (_tmp30_);
					_tmp31_ = info;
					_tmp32_ = param;
					_tmp33_ = vala_symbol_get_name ((ValaSymbol*) _tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = g_strdup_printf ("\"%s\"", _tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = vala_ccode_constant_new (_tmp36_);
					_tmp38_ = _tmp37_;
					vala_ccode_initializer_list_append (_tmp31_, (ValaCCodeExpression*) _tmp38_);
					_vala_ccode_node_unref0 (_tmp38_);
					_g_free0 (_tmp36_);
					_tmp39_ = info;
					_tmp40_ = param;
					_tmp41_ = vala_variable_get_variable_type ((ValaVariable*) _tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = param;
					_tmp44_ = vala_gvariant_module_get_type_signature (_tmp42_, (ValaSymbol*) _tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = g_strdup_printf ("\"%s\"", _tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = vala_ccode_constant_new (_tmp47_);
					_tmp49_ = _tmp48_;
					vala_ccode_initializer_list_append (_tmp39_, (ValaCCodeExpression*) _tmp49_);
					_vala_ccode_node_unref0 (_tmp49_);
					_g_free0 (_tmp47_);
					_g_free0 (_tmp45_);
					_tmp50_ = info;
					_tmp51_ = vala_ccode_constant_new ("NULL");
					_tmp52_ = _tmp51_;
					vala_ccode_initializer_list_append (_tmp50_, (ValaCCodeExpression*) _tmp52_);
					_vala_ccode_node_unref0 (_tmp52_);
					_tmp53_ = vala_ccode_declaration_new ("const GDBusArgInfo");
					_cdecl_ = _tmp53_;
					_tmp54_ = _cdecl_;
					_tmp55_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
					_tmp56_ = _tmp55_;
					_tmp57_ = g_strconcat ("_", _tmp56_, NULL);
					_tmp58_ = _tmp57_;
					_tmp59_ = g_strconcat (_tmp58_, "dbus_arg_info_", NULL);
					_tmp60_ = _tmp59_;
					_tmp61_ = sig;
					_tmp62_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp61_, NULL);
					_tmp63_ = _tmp62_;
					_tmp64_ = g_strconcat (_tmp60_, _tmp63_, NULL);
					_tmp65_ = _tmp64_;
					_tmp66_ = g_strconcat (_tmp65_, "_", NULL);
					_tmp67_ = _tmp66_;
					_tmp68_ = param;
					_tmp69_ = vala_symbol_get_name ((ValaSymbol*) _tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = g_strconcat (_tmp67_, _tmp70_, NULL);
					_tmp72_ = _tmp71_;
					_tmp73_ = info;
					_tmp74_ = vala_ccode_variable_declarator_new (_tmp72_, (ValaCCodeExpression*) _tmp73_, NULL);
					_tmp75_ = _tmp74_;
					vala_ccode_declaration_add_declarator (_tmp54_, (ValaCCodeDeclarator*) _tmp75_);
					_vala_ccode_node_unref0 (_tmp75_);
					_g_free0 (_tmp72_);
					_g_free0 (_tmp67_);
					_g_free0 (_tmp65_);
					_g_free0 (_tmp63_);
					_g_free0 (_tmp60_);
					_g_free0 (_tmp58_);
					_g_free0 (_tmp56_);
					_tmp76_ = _cdecl_;
					vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp76_, VALA_CCODE_MODIFIERS_STATIC);
					_tmp77_ = ((ValaCCodeBaseModule*) self)->cfile;
					_tmp78_ = _cdecl_;
					vala_ccode_file_add_constant_declaration (_tmp77_, (ValaCCodeNode*) _tmp78_);
					_tmp79_ = args_info;
					_tmp80_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
					_tmp81_ = _tmp80_;
					_tmp82_ = g_strconcat ("_", _tmp81_, NULL);
					_tmp83_ = _tmp82_;
					_tmp84_ = g_strconcat (_tmp83_, "dbus_arg_info_", NULL);
					_tmp85_ = _tmp84_;
					_tmp86_ = sig;
					_tmp87_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp86_, NULL);
					_tmp88_ = _tmp87_;
					_tmp89_ = g_strconcat (_tmp85_, _tmp88_, NULL);
					_tmp90_ = _tmp89_;
					_tmp91_ = g_strconcat (_tmp90_, "_", NULL);
					_tmp92_ = _tmp91_;
					_tmp93_ = param;
					_tmp94_ = vala_symbol_get_name ((ValaSymbol*) _tmp93_);
					_tmp95_ = _tmp94_;
					_tmp96_ = g_strconcat (_tmp92_, _tmp95_, NULL);
					_tmp97_ = _tmp96_;
					_tmp98_ = vala_ccode_identifier_new (_tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp99_);
					_tmp101_ = _tmp100_;
					vala_ccode_initializer_list_append (_tmp79_, (ValaCCodeExpression*) _tmp101_);
					_vala_ccode_node_unref0 (_tmp101_);
					_vala_ccode_node_unref0 (_tmp99_);
					_g_free0 (_tmp97_);
					_g_free0 (_tmp92_);
					_g_free0 (_tmp90_);
					_g_free0 (_tmp88_);
					_g_free0 (_tmp85_);
					_g_free0 (_tmp83_);
					_g_free0 (_tmp81_);
					_vala_ccode_node_unref0 (_cdecl_);
					_vala_ccode_node_unref0 (info);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp102_ = args_info;
			_tmp103_ = vala_ccode_constant_new ("NULL");
			_tmp104_ = _tmp103_;
			vala_ccode_initializer_list_append (_tmp102_, (ValaCCodeExpression*) _tmp104_);
			_vala_ccode_node_unref0 (_tmp104_);
			_tmp105_ = vala_ccode_declaration_new ("const GDBusArgInfo * const");
			_cdecl_ = _tmp105_;
			_tmp106_ = _cdecl_;
			_tmp107_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp108_ = _tmp107_;
			_tmp109_ = g_strconcat ("_", _tmp108_, NULL);
			_tmp110_ = _tmp109_;
			_tmp111_ = g_strconcat (_tmp110_, "dbus_arg_info_", NULL);
			_tmp112_ = _tmp111_;
			_tmp113_ = sig;
			_tmp114_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp113_, NULL);
			_tmp115_ = _tmp114_;
			_tmp116_ = g_strconcat (_tmp112_, _tmp115_, NULL);
			_tmp117_ = _tmp116_;
			_tmp118_ = g_strconcat (_tmp117_, "[]", NULL);
			_tmp119_ = _tmp118_;
			_tmp120_ = args_info;
			_tmp121_ = vala_ccode_variable_declarator_new (_tmp119_, (ValaCCodeExpression*) _tmp120_, NULL);
			_tmp122_ = _tmp121_;
			vala_ccode_declaration_add_declarator (_tmp106_, (ValaCCodeDeclarator*) _tmp122_);
			_vala_ccode_node_unref0 (_tmp122_);
			_g_free0 (_tmp119_);
			_g_free0 (_tmp117_);
			_g_free0 (_tmp115_);
			_g_free0 (_tmp112_);
			_g_free0 (_tmp110_);
			_g_free0 (_tmp108_);
			_tmp123_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp123_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp124_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp125_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp124_, (ValaCCodeNode*) _tmp125_);
			_tmp126_ = vala_ccode_initializer_list_new ();
			info = _tmp126_;
			_tmp127_ = info;
			_tmp128_ = vala_ccode_constant_new ("-1");
			_tmp129_ = _tmp128_;
			vala_ccode_initializer_list_append (_tmp127_, (ValaCCodeExpression*) _tmp129_);
			_vala_ccode_node_unref0 (_tmp129_);
			_tmp130_ = info;
			_tmp131_ = sig;
			_tmp132_ = vala_gd_bus_module_get_dbus_name_for_member ((ValaSymbol*) _tmp131_);
			_tmp133_ = _tmp132_;
			_tmp134_ = g_strdup_printf ("\"%s\"", _tmp133_);
			_tmp135_ = _tmp134_;
			_tmp136_ = vala_ccode_constant_new (_tmp135_);
			_tmp137_ = _tmp136_;
			vala_ccode_initializer_list_append (_tmp130_, (ValaCCodeExpression*) _tmp137_);
			_vala_ccode_node_unref0 (_tmp137_);
			_g_free0 (_tmp135_);
			_g_free0 (_tmp133_);
			_tmp138_ = info;
			_tmp139_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp140_ = _tmp139_;
			_tmp141_ = g_strconcat ("_", _tmp140_, NULL);
			_tmp142_ = _tmp141_;
			_tmp143_ = g_strconcat (_tmp142_, "dbus_arg_info_", NULL);
			_tmp144_ = _tmp143_;
			_tmp145_ = sig;
			_tmp146_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp145_, NULL);
			_tmp147_ = _tmp146_;
			_tmp148_ = g_strconcat (_tmp144_, _tmp147_, NULL);
			_tmp149_ = _tmp148_;
			_tmp150_ = vala_ccode_identifier_new (_tmp149_);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp151_);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp153_, "GDBusArgInfo **");
			_tmp155_ = _tmp154_;
			vala_ccode_initializer_list_append (_tmp138_, (ValaCCodeExpression*) _tmp155_);
			_vala_ccode_node_unref0 (_tmp155_);
			_vala_ccode_node_unref0 (_tmp153_);
			_vala_ccode_node_unref0 (_tmp151_);
			_g_free0 (_tmp149_);
			_g_free0 (_tmp147_);
			_g_free0 (_tmp144_);
			_g_free0 (_tmp142_);
			_g_free0 (_tmp140_);
			_tmp156_ = info;
			_tmp157_ = vala_ccode_constant_new ("NULL");
			_tmp158_ = _tmp157_;
			vala_ccode_initializer_list_append (_tmp156_, (ValaCCodeExpression*) _tmp158_);
			_vala_ccode_node_unref0 (_tmp158_);
			_tmp159_ = vala_ccode_declaration_new ("const GDBusSignalInfo");
			_vala_ccode_node_unref0 (_cdecl_);
			_cdecl_ = _tmp159_;
			_tmp160_ = _cdecl_;
			_tmp161_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp162_ = _tmp161_;
			_tmp163_ = g_strconcat ("_", _tmp162_, NULL);
			_tmp164_ = _tmp163_;
			_tmp165_ = g_strconcat (_tmp164_, "dbus_signal_info_", NULL);
			_tmp166_ = _tmp165_;
			_tmp167_ = sig;
			_tmp168_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp167_, NULL);
			_tmp169_ = _tmp168_;
			_tmp170_ = g_strconcat (_tmp166_, _tmp169_, NULL);
			_tmp171_ = _tmp170_;
			_tmp172_ = info;
			_tmp173_ = vala_ccode_variable_declarator_new (_tmp171_, (ValaCCodeExpression*) _tmp172_, NULL);
			_tmp174_ = _tmp173_;
			vala_ccode_declaration_add_declarator (_tmp160_, (ValaCCodeDeclarator*) _tmp174_);
			_vala_ccode_node_unref0 (_tmp174_);
			_g_free0 (_tmp171_);
			_g_free0 (_tmp169_);
			_g_free0 (_tmp166_);
			_g_free0 (_tmp164_);
			_g_free0 (_tmp162_);
			_tmp175_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp175_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp176_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp177_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp176_, (ValaCCodeNode*) _tmp177_);
			_tmp178_ = infos;
			_tmp179_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp180_ = _tmp179_;
			_tmp181_ = g_strconcat ("_", _tmp180_, NULL);
			_tmp182_ = _tmp181_;
			_tmp183_ = g_strconcat (_tmp182_, "dbus_signal_info_", NULL);
			_tmp184_ = _tmp183_;
			_tmp185_ = sig;
			_tmp186_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp185_, NULL);
			_tmp187_ = _tmp186_;
			_tmp188_ = g_strconcat (_tmp184_, _tmp187_, NULL);
			_tmp189_ = _tmp188_;
			_tmp190_ = vala_ccode_identifier_new (_tmp189_);
			_tmp191_ = _tmp190_;
			_tmp192_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp191_);
			_tmp193_ = _tmp192_;
			vala_ccode_initializer_list_append (_tmp178_, (ValaCCodeExpression*) _tmp193_);
			_vala_ccode_node_unref0 (_tmp193_);
			_vala_ccode_node_unref0 (_tmp191_);
			_g_free0 (_tmp189_);
			_g_free0 (_tmp187_);
			_g_free0 (_tmp184_);
			_g_free0 (_tmp182_);
			_g_free0 (_tmp180_);
			_vala_ccode_node_unref0 (info);
			_vala_ccode_node_unref0 (_cdecl_);
			_vala_ccode_node_unref0 (args_info);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp194_ = infos;
	_tmp195_ = vala_ccode_constant_new ("NULL");
	_tmp196_ = _tmp195_;
	vala_ccode_initializer_list_append (_tmp194_, (ValaCCodeExpression*) _tmp196_);
	_vala_ccode_node_unref0 (_tmp196_);
	_tmp197_ = vala_ccode_declaration_new ("const GDBusSignalInfo * const");
	_cdecl_ = _tmp197_;
	_tmp198_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp199_ = _tmp198_;
	_tmp200_ = g_strconcat ("_", _tmp199_, NULL);
	_tmp201_ = _tmp200_;
	_tmp202_ = g_strconcat (_tmp201_, "dbus_signal_info[]", NULL);
	_tmp203_ = _tmp202_;
	_tmp204_ = infos;
	_tmp205_ = vala_ccode_variable_declarator_new (_tmp203_, (ValaCCodeExpression*) _tmp204_, NULL);
	_tmp206_ = _tmp205_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp206_);
	_vala_ccode_node_unref0 (_tmp206_);
	_g_free0 (_tmp203_);
	_g_free0 (_tmp201_);
	_g_free0 (_tmp199_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp207_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp207_, (ValaCCodeNode*) _cdecl_);
	_tmp208_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp209_ = _tmp208_;
	_tmp210_ = g_strconcat ("_", _tmp209_, NULL);
	_tmp211_ = _tmp210_;
	_tmp212_ = g_strconcat (_tmp211_, "dbus_signal_info", NULL);
	_tmp213_ = _tmp212_;
	_tmp214_ = vala_ccode_identifier_new (_tmp213_);
	_tmp215_ = (ValaCCodeExpression*) _tmp214_;
	_g_free0 (_tmp213_);
	_g_free0 (_tmp211_);
	_g_free0 (_tmp209_);
	result = _tmp215_;
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (infos);
	return result;
}


static ValaCCodeExpression*
vala_gd_bus_module_get_property_info (ValaGDBusModule* self,
                                      ValaObjectTypeSymbol* sym)
{
	ValaCCodeExpression* result = NULL;
	ValaCCodeInitializerList* infos = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeInitializerList* _tmp109_;
	ValaCCodeConstant* _tmp110_;
	ValaCCodeConstant* _tmp111_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp112_;
	gchar* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	gchar* _tmp117_;
	gchar* _tmp118_;
	ValaCCodeInitializerList* _tmp119_;
	ValaCCodeVariableDeclarator* _tmp120_;
	ValaCCodeVariableDeclarator* _tmp121_;
	ValaCCodeFile* _tmp122_;
	gchar* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	gchar* _tmp128_;
	ValaCCodeIdentifier* _tmp129_;
	ValaCCodeExpression* _tmp130_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	infos = _tmp0_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp1_;
		gint _prop_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prop_index = 0;
		_tmp1_ = vala_object_type_symbol_get_properties (sym);
		_prop_list = _tmp1_;
		_tmp2_ = _prop_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prop_size = _tmp4_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaProperty* prop = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			ValaProperty* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			ValaProperty* _tmp22_;
			ValaCCodeInitializerList* info = NULL;
			ValaCCodeInitializerList* _tmp23_;
			ValaCCodeInitializerList* _tmp24_;
			ValaCCodeConstant* _tmp25_;
			ValaCCodeConstant* _tmp26_;
			ValaCCodeInitializerList* _tmp27_;
			ValaProperty* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			ValaCCodeConstant* _tmp33_;
			ValaCCodeConstant* _tmp34_;
			ValaCCodeInitializerList* _tmp35_;
			ValaProperty* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaProperty* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			ValaCCodeConstant* _tmp44_;
			ValaCCodeConstant* _tmp45_;
			gboolean _tmp46_ = FALSE;
			ValaProperty* _tmp47_;
			ValaPropertyAccessor* _tmp48_;
			ValaPropertyAccessor* _tmp49_;
			ValaCCodeInitializerList* _tmp71_;
			ValaCCodeConstant* _tmp72_;
			ValaCCodeConstant* _tmp73_;
			ValaCCodeDeclaration* _cdecl_ = NULL;
			ValaCCodeDeclaration* _tmp74_;
			ValaCCodeDeclaration* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			ValaProperty* _tmp82_;
			const gchar* _tmp83_;
			const gchar* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			ValaCCodeInitializerList* _tmp87_;
			ValaCCodeVariableDeclarator* _tmp88_;
			ValaCCodeVariableDeclarator* _tmp89_;
			ValaCCodeDeclaration* _tmp90_;
			ValaCCodeFile* _tmp91_;
			ValaCCodeDeclaration* _tmp92_;
			ValaCCodeInitializerList* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			gchar* _tmp99_;
			ValaProperty* _tmp100_;
			const gchar* _tmp101_;
			const gchar* _tmp102_;
			gchar* _tmp103_;
			gchar* _tmp104_;
			ValaCCodeIdentifier* _tmp105_;
			ValaCCodeIdentifier* _tmp106_;
			ValaCCodeUnaryExpression* _tmp107_;
			ValaCCodeUnaryExpression* _tmp108_;
			_tmp5_ = _prop_index;
			_prop_index = _tmp5_ + 1;
			_tmp6_ = _prop_index;
			_tmp7_ = _prop_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _prop_list;
			_tmp9_ = _prop_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			prop = (ValaProperty*) _tmp10_;
			_tmp13_ = prop;
			_tmp14_ = vala_property_get_binding (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ != VALA_MEMBER_BINDING_INSTANCE) {
				_tmp12_ = TRUE;
			} else {
				ValaProperty* _tmp16_;
				gboolean _tmp17_;
				gboolean _tmp18_;
				_tmp16_ = prop;
				_tmp17_ = vala_property_get_overrides (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp12_ = _tmp18_;
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				ValaProperty* _tmp19_;
				ValaSymbolAccessibility _tmp20_;
				ValaSymbolAccessibility _tmp21_;
				_tmp19_ = prop;
				_tmp20_ = vala_symbol_get_access ((ValaSymbol*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp11_ = _tmp21_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp11_) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp22_ = prop;
			if (!vala_gd_bus_module_is_dbus_visible ((ValaCodeNode*) _tmp22_)) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp23_ = vala_ccode_initializer_list_new ();
			info = _tmp23_;
			_tmp24_ = info;
			_tmp25_ = vala_ccode_constant_new ("-1");
			_tmp26_ = _tmp25_;
			vala_ccode_initializer_list_append (_tmp24_, (ValaCCodeExpression*) _tmp26_);
			_vala_ccode_node_unref0 (_tmp26_);
			_tmp27_ = info;
			_tmp28_ = prop;
			_tmp29_ = vala_gd_bus_module_get_dbus_name_for_member ((ValaSymbol*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strdup_printf ("\"%s\"", _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_ccode_constant_new (_tmp32_);
			_tmp34_ = _tmp33_;
			vala_ccode_initializer_list_append (_tmp27_, (ValaCCodeExpression*) _tmp34_);
			_vala_ccode_node_unref0 (_tmp34_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp30_);
			_tmp35_ = info;
			_tmp36_ = prop;
			_tmp37_ = vala_property_get_property_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = prop;
			_tmp40_ = vala_gvariant_module_get_type_signature (_tmp38_, (ValaSymbol*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strdup_printf ("\"%s\"", _tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_ccode_constant_new (_tmp43_);
			_tmp45_ = _tmp44_;
			vala_ccode_initializer_list_append (_tmp35_, (ValaCCodeExpression*) _tmp45_);
			_vala_ccode_node_unref0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_tmp47_ = prop;
			_tmp48_ = vala_property_get_get_accessor (_tmp47_);
			_tmp49_ = _tmp48_;
			if (_tmp49_ != NULL) {
				ValaProperty* _tmp50_;
				ValaPropertyAccessor* _tmp51_;
				ValaPropertyAccessor* _tmp52_;
				_tmp50_ = prop;
				_tmp51_ = vala_property_get_set_accessor (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp46_ = _tmp52_ != NULL;
			} else {
				_tmp46_ = FALSE;
			}
			if (_tmp46_) {
				ValaCCodeInitializerList* _tmp53_;
				ValaCCodeConstant* _tmp54_;
				ValaCCodeConstant* _tmp55_;
				_tmp53_ = info;
				_tmp54_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITA" \
"BLE");
				_tmp55_ = _tmp54_;
				vala_ccode_initializer_list_append (_tmp53_, (ValaCCodeExpression*) _tmp55_);
				_vala_ccode_node_unref0 (_tmp55_);
			} else {
				ValaProperty* _tmp56_;
				ValaPropertyAccessor* _tmp57_;
				ValaPropertyAccessor* _tmp58_;
				_tmp56_ = prop;
				_tmp57_ = vala_property_get_get_accessor (_tmp56_);
				_tmp58_ = _tmp57_;
				if (_tmp58_ != NULL) {
					ValaCCodeInitializerList* _tmp59_;
					ValaCCodeConstant* _tmp60_;
					ValaCCodeConstant* _tmp61_;
					_tmp59_ = info;
					_tmp60_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_READABLE");
					_tmp61_ = _tmp60_;
					vala_ccode_initializer_list_append (_tmp59_, (ValaCCodeExpression*) _tmp61_);
					_vala_ccode_node_unref0 (_tmp61_);
				} else {
					ValaProperty* _tmp62_;
					ValaPropertyAccessor* _tmp63_;
					ValaPropertyAccessor* _tmp64_;
					_tmp62_ = prop;
					_tmp63_ = vala_property_get_set_accessor (_tmp62_);
					_tmp64_ = _tmp63_;
					if (_tmp64_ != NULL) {
						ValaCCodeInitializerList* _tmp65_;
						ValaCCodeConstant* _tmp66_;
						ValaCCodeConstant* _tmp67_;
						_tmp65_ = info;
						_tmp66_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE");
						_tmp67_ = _tmp66_;
						vala_ccode_initializer_list_append (_tmp65_, (ValaCCodeExpression*) _tmp67_);
						_vala_ccode_node_unref0 (_tmp67_);
					} else {
						ValaCCodeInitializerList* _tmp68_;
						ValaCCodeConstant* _tmp69_;
						ValaCCodeConstant* _tmp70_;
						_tmp68_ = info;
						_tmp69_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_NONE");
						_tmp70_ = _tmp69_;
						vala_ccode_initializer_list_append (_tmp68_, (ValaCCodeExpression*) _tmp70_);
						_vala_ccode_node_unref0 (_tmp70_);
					}
				}
			}
			_tmp71_ = info;
			_tmp72_ = vala_ccode_constant_new ("NULL");
			_tmp73_ = _tmp72_;
			vala_ccode_initializer_list_append (_tmp71_, (ValaCCodeExpression*) _tmp73_);
			_vala_ccode_node_unref0 (_tmp73_);
			_tmp74_ = vala_ccode_declaration_new ("const GDBusPropertyInfo");
			_cdecl_ = _tmp74_;
			_tmp75_ = _cdecl_;
			_tmp76_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp77_ = _tmp76_;
			_tmp78_ = g_strconcat ("_", _tmp77_, NULL);
			_tmp79_ = _tmp78_;
			_tmp80_ = g_strconcat (_tmp79_, "dbus_property_info_", NULL);
			_tmp81_ = _tmp80_;
			_tmp82_ = prop;
			_tmp83_ = vala_symbol_get_name ((ValaSymbol*) _tmp82_);
			_tmp84_ = _tmp83_;
			_tmp85_ = g_strconcat (_tmp81_, _tmp84_, NULL);
			_tmp86_ = _tmp85_;
			_tmp87_ = info;
			_tmp88_ = vala_ccode_variable_declarator_new (_tmp86_, (ValaCCodeExpression*) _tmp87_, NULL);
			_tmp89_ = _tmp88_;
			vala_ccode_declaration_add_declarator (_tmp75_, (ValaCCodeDeclarator*) _tmp89_);
			_vala_ccode_node_unref0 (_tmp89_);
			_g_free0 (_tmp86_);
			_g_free0 (_tmp81_);
			_g_free0 (_tmp79_);
			_g_free0 (_tmp77_);
			_tmp90_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp90_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp91_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp92_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp91_, (ValaCCodeNode*) _tmp92_);
			_tmp93_ = infos;
			_tmp94_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp95_ = _tmp94_;
			_tmp96_ = g_strconcat ("_", _tmp95_, NULL);
			_tmp97_ = _tmp96_;
			_tmp98_ = g_strconcat (_tmp97_, "dbus_property_info_", NULL);
			_tmp99_ = _tmp98_;
			_tmp100_ = prop;
			_tmp101_ = vala_symbol_get_name ((ValaSymbol*) _tmp100_);
			_tmp102_ = _tmp101_;
			_tmp103_ = g_strconcat (_tmp99_, _tmp102_, NULL);
			_tmp104_ = _tmp103_;
			_tmp105_ = vala_ccode_identifier_new (_tmp104_);
			_tmp106_ = _tmp105_;
			_tmp107_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp106_);
			_tmp108_ = _tmp107_;
			vala_ccode_initializer_list_append (_tmp93_, (ValaCCodeExpression*) _tmp108_);
			_vala_ccode_node_unref0 (_tmp108_);
			_vala_ccode_node_unref0 (_tmp106_);
			_g_free0 (_tmp104_);
			_g_free0 (_tmp99_);
			_g_free0 (_tmp97_);
			_g_free0 (_tmp95_);
			_vala_ccode_node_unref0 (_cdecl_);
			_vala_ccode_node_unref0 (info);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp109_ = infos;
	_tmp110_ = vala_ccode_constant_new ("NULL");
	_tmp111_ = _tmp110_;
	vala_ccode_initializer_list_append (_tmp109_, (ValaCCodeExpression*) _tmp111_);
	_vala_ccode_node_unref0 (_tmp111_);
	_tmp112_ = vala_ccode_declaration_new ("const GDBusPropertyInfo * const");
	_cdecl_ = _tmp112_;
	_tmp113_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp114_ = _tmp113_;
	_tmp115_ = g_strconcat ("_", _tmp114_, NULL);
	_tmp116_ = _tmp115_;
	_tmp117_ = g_strconcat (_tmp116_, "dbus_property_info[]", NULL);
	_tmp118_ = _tmp117_;
	_tmp119_ = infos;
	_tmp120_ = vala_ccode_variable_declarator_new (_tmp118_, (ValaCCodeExpression*) _tmp119_, NULL);
	_tmp121_ = _tmp120_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp121_);
	_vala_ccode_node_unref0 (_tmp121_);
	_g_free0 (_tmp118_);
	_g_free0 (_tmp116_);
	_g_free0 (_tmp114_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp122_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp122_, (ValaCCodeNode*) _cdecl_);
	_tmp123_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp124_ = _tmp123_;
	_tmp125_ = g_strconcat ("_", _tmp124_, NULL);
	_tmp126_ = _tmp125_;
	_tmp127_ = g_strconcat (_tmp126_, "dbus_property_info", NULL);
	_tmp128_ = _tmp127_;
	_tmp129_ = vala_ccode_identifier_new (_tmp128_);
	_tmp130_ = (ValaCCodeExpression*) _tmp129_;
	_g_free0 (_tmp128_);
	_g_free0 (_tmp126_);
	_g_free0 (_tmp124_);
	result = _tmp130_;
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (infos);
	return result;
}


static void
vala_gd_bus_module_declare_interface_info (ValaGDBusModule* self,
                                           ValaObjectTypeSymbol* sym)
{
	ValaCCodeInitializerList* info = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeConstant* _tmp1_;
	ValaCCodeConstant* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaCCodeConstant* _tmp7_;
	ValaCCodeConstant* _tmp8_;
	ValaCCodeExpression* _tmp9_;
	ValaCCodeExpression* _tmp10_;
	ValaCCodeUnaryExpression* _tmp11_;
	ValaCCodeUnaryExpression* _tmp12_;
	ValaCCodeCastExpression* _tmp13_;
	ValaCCodeCastExpression* _tmp14_;
	ValaCCodeExpression* _tmp15_;
	ValaCCodeExpression* _tmp16_;
	ValaCCodeUnaryExpression* _tmp17_;
	ValaCCodeUnaryExpression* _tmp18_;
	ValaCCodeCastExpression* _tmp19_;
	ValaCCodeCastExpression* _tmp20_;
	ValaCCodeExpression* _tmp21_;
	ValaCCodeExpression* _tmp22_;
	ValaCCodeUnaryExpression* _tmp23_;
	ValaCCodeUnaryExpression* _tmp24_;
	ValaCCodeCastExpression* _tmp25_;
	ValaCCodeCastExpression* _tmp26_;
	ValaCCodeConstant* _tmp27_;
	ValaCCodeConstant* _tmp28_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	ValaCCodeVariableDeclarator* _tmp36_;
	ValaCCodeVariableDeclarator* _tmp37_;
	ValaCCodeFile* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	info = _tmp0_;
	_tmp1_ = vala_ccode_constant_new ("-1");
	_tmp2_ = _tmp1_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp2_);
	_vala_ccode_node_unref0 (_tmp2_);
	_tmp3_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) sym);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("\"%s\"", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_ccode_constant_new (_tmp6_);
	_tmp8_ = _tmp7_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp8_);
	_vala_ccode_node_unref0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp9_ = vala_gd_bus_module_get_method_info (self, sym);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp12_, "GDBusMethodInfo **");
	_tmp14_ = _tmp13_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp14_);
	_vala_ccode_node_unref0 (_tmp14_);
	_vala_ccode_node_unref0 (_tmp12_);
	_vala_ccode_node_unref0 (_tmp10_);
	_tmp15_ = vala_gd_bus_module_get_signal_info (self, sym);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp18_, "GDBusSignalInfo **");
	_tmp20_ = _tmp19_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp20_);
	_vala_ccode_node_unref0 (_tmp20_);
	_vala_ccode_node_unref0 (_tmp18_);
	_vala_ccode_node_unref0 (_tmp16_);
	_tmp21_ = vala_gd_bus_module_get_property_info (self, sym);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp24_, "GDBusPropertyInfo **");
	_tmp26_ = _tmp25_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp26_);
	_vala_ccode_node_unref0 (_tmp26_);
	_vala_ccode_node_unref0 (_tmp24_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp27_ = vala_ccode_constant_new ("NULL");
	_tmp28_ = _tmp27_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = vala_ccode_declaration_new ("const GDBusInterfaceInfo");
	_cdecl_ = _tmp29_;
	_tmp30_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat ("_", _tmp31_, NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat (_tmp33_, "dbus_interface_info", NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_ccode_variable_declarator_new (_tmp35_, (ValaCCodeExpression*) info, NULL);
	_tmp37_ = _tmp36_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp37_);
	_vala_ccode_node_unref0 (_tmp37_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp38_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp38_, (ValaCCodeNode*) _cdecl_);
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (info);
}


ValaCCodeExpression*
vala_gd_bus_module_get_interface_info (ValaGDBusModule* self,
                                       ValaObjectTypeSymbol* sym)
{
	ValaCCodeExpression* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeExpression* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("_", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "dbus_interface_info", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_identifier_new (_tmp5_);
	_tmp7_ = (ValaCCodeExpression*) _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp7_;
	return result;
}


static void
vala_gd_bus_module_real_visit_class (ValaCodeVisitor* base,
                                     ValaClass* cl)
{
	ValaGDBusModule * self;
	self = (ValaGDBusModule*) base;
	g_return_if_fail (cl != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gd_bus_module_parent_class)->visit_class ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GVARIANT_MODULE, ValaGVariantModule), cl);
	vala_gd_bus_module_visit_object_type_symbol (self, (ValaObjectTypeSymbol*) cl);
}


static void
vala_gd_bus_module_real_visit_interface (ValaCodeVisitor* base,
                                         ValaInterface* iface)
{
	ValaGDBusModule * self;
	self = (ValaGDBusModule*) base;
	g_return_if_fail (iface != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gd_bus_module_parent_class)->visit_interface ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GVARIANT_MODULE, ValaGVariantModule), iface);
	vala_gd_bus_module_visit_object_type_symbol (self, (ValaObjectTypeSymbol*) iface);
}


static void
vala_gd_bus_module_visit_object_type_symbol (ValaGDBusModule* self,
                                             ValaObjectTypeSymbol* sym)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	vala_gd_bus_module_declare_interface_info (self, sym);
}


ValaGDBusModule*
vala_gd_bus_module_construct (GType object_type)
{
	ValaGDBusModule* self = NULL;
	self = (ValaGDBusModule*) vala_gvariant_module_construct (object_type);
	return self;
}


ValaGDBusModule*
vala_gd_bus_module_new (void)
{
	return vala_gd_bus_module_construct (VALA_TYPE_GD_BUS_MODULE);
}


static void
vala_gd_bus_module_class_init (ValaGDBusModuleClass * klass)
{
	vala_gd_bus_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_gd_bus_module_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_gd_bus_module_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor*, ValaInterface*)) vala_gd_bus_module_real_visit_interface;
}


static void
vala_gd_bus_module_instance_init (ValaGDBusModule * self)
{
}


GType
vala_gd_bus_module_get_type (void)
{
	static volatile gsize vala_gd_bus_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gd_bus_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGDBusModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gd_bus_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGDBusModule), 0, (GInstanceInitFunc) vala_gd_bus_module_instance_init, NULL };
		GType vala_gd_bus_module_type_id;
		vala_gd_bus_module_type_id = g_type_register_static (VALA_TYPE_GVARIANT_MODULE, "ValaGDBusModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gd_bus_module_type_id__volatile, vala_gd_bus_module_type_id);
	}
	return vala_gd_bus_module_type_id__volatile;
}



