// SPDX-License-Identifier: GPL-2.0+
/*
 * (C) Copyright 2014 - 2018 Xilinx, Inc.
 * Michal Simek <michal.simek@xilinx.com>
 */

#include <common.h>
#include <fdtdec.h>
#include <malloc.h>
#include <asm/io.h>
#include <asm/arch/hardware.h>

DECLARE_GLOBAL_DATA_PTR;

int board_init(void)
{
	printf("EL Level:\tEL%d\n", current_el());

	return 0;
}

int board_early_init_r(void)
{
	if (current_el() == 3) {
		u32 val;

		writel(IOU_SWITCH_CTRL_CLKACT_BIT |
		       (0x20 << IOU_SWITCH_CTRL_DIVISOR0_SHIFT),
		       &crlapb_base->iou_switch_ctrl);

		/* Global timer init - Program time stamp reference clk */
		val = readl(&crlapb_base->timestamp_ref_ctrl);
		val |= CRL_APB_TIMESTAMP_REF_CTRL_CLKACT_BIT;
		writel(val, &crlapb_base->timestamp_ref_ctrl);

		debug("ref ctrl 0x%x\n",
		      readl(&crlapb_base->timestamp_ref_ctrl));

		/* Clear reset of timestamp reg */
		writel(0, &crlapb_base->rst_timestamp);

		/*
		 * Program freq register in System counter and
		 * enable system counter.
		 */
		writel(COUNTER_FREQUENCY,
		       &iou_scntr_secure->base_frequency_id_register);

		debug("counter val 0x%x\n",
		      readl(&iou_scntr_secure->base_frequency_id_register));

		writel(IOU_SCNTRS_CONTROL_EN,
		       &iou_scntr_secure->counter_control_register);

		debug("scntrs control 0x%x\n",
		      readl(&iou_scntr_secure->counter_control_register));
		debug("timer 0x%llx\n", get_ticks());
		debug("timer 0x%llx\n", get_ticks());
	}

	return 0;
}

int dram_init_banksize(void)
{
	fdtdec_setup_memory_banksize();

	return 0;
}

int dram_init(void)
{
	if (fdtdec_setup_mem_size_base() != 0)
		return -EINVAL;

	return 0;
}

void reset_cpu(ulong addr)
{
}
