% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{treeVec}
\alias{treeVec}
\title{Tree vector function}
\usage{
treeVec(tree, lambda = 0, return.lambda.function = FALSE,
  emphasise.tips = NULL, emphasise.weight = 2)
}
\arguments{
\item{tree}{an object of the class \code{phylo}}

\item{lambda}{a number in [0,1] which specifies the extent to which topology (default, with lambda=0)  or branch lengths (lambda=1) are emphasised. This argument is ignored if \code{return.lambda.function=TRUE}.}

\item{return.lambda.function}{If true, a function that can be invoked with different lambda values is returned. This function returns the vector of metric values for the given lambda.}

\item{emphasise.tips}{an optional list of tips whose entries in the tree vector should be emphasised. Defaults to \code{NULL}.}

\item{emphasise.weight}{applicable only if a list is supplied to \code{emphasise.tips}, this value (default 2) is the number by which vector entries corresponding to those tips are emphasised.}
}
\value{
The vector of values according to the metric, or a function that produces the vector given a value of lambda.
}
\description{
Function which takes an object of class phylo and outputs the vector for the Kendall Colijn metric.
The elements of the vector are numeric if \code{return.lambda.function=FALSE} (default),
and otherwise they are functions of lambda.
}
\examples{

## generate a random tree
tree <- rtree(6)
## topological vector of mrca distances from root:
treeVec(tree)
## vector of mrca distances from root when lambda=0.5:
treeVec(tree,0.5)
## vector of mrca distances as a function of lambda:
vecAsFunction <- treeVec(tree,return.lambda.function=TRUE)
## evaluate the vector at lambda=0.5:
vecAsFunction(0.5)


}
\author{
Jacob Almagro-Garcia \email{nativecoder@gmail.com}

Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}

