# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MongoDbShardKeyField(Model):
    """Describes a field reference within a MongoDB shard key.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the field
    :type name: str
    :param order: Required. The field ordering. Possible values include:
     'Forward', 'Reverse', 'Hashed'
    :type order: str or ~azure.mgmt.datamigration.models.MongoDbShardKeyOrder
    """

    _validation = {
        'name': {'required': True},
        'order': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'order': {'key': 'order', 'type': 'str'},
    }

    def __init__(self, *, name: str, order, **kwargs) -> None:
        super(MongoDbShardKeyField, self).__init__(**kwargs)
        self.name = name
        self.order = order
