# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DatabaseBackupInfo(Model):
    """Information about backup files when existing backup mode is used.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar database_name: Database name.
    :vartype database_name: str
    :ivar backup_type: Backup Type. Possible values include: 'Database',
     'TransactionLog', 'File', 'DifferentialDatabase', 'DifferentialFile',
     'Partial', 'DifferentialPartial'
    :vartype backup_type: str or ~azure.mgmt.datamigration.models.BackupType
    :ivar backup_files: The list of backup files for the current database.
    :vartype backup_files: list[str]
    :ivar position: Position of current database backup in the file.
    :vartype position: int
    :ivar is_damaged: Database was damaged when backed up, but the backup
     operation was requested to continue despite errors.
    :vartype is_damaged: bool
    :ivar is_compressed: Whether the backup set is compressed
    :vartype is_compressed: bool
    :ivar family_count: Number of files in the backup set.
    :vartype family_count: int
    :ivar backup_finish_date: Date and time when the backup operation
     finished.
    :vartype backup_finish_date: datetime
    """

    _validation = {
        'database_name': {'readonly': True},
        'backup_type': {'readonly': True},
        'backup_files': {'readonly': True},
        'position': {'readonly': True},
        'is_damaged': {'readonly': True},
        'is_compressed': {'readonly': True},
        'family_count': {'readonly': True},
        'backup_finish_date': {'readonly': True},
    }

    _attribute_map = {
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'backup_type': {'key': 'backupType', 'type': 'str'},
        'backup_files': {'key': 'backupFiles', 'type': '[str]'},
        'position': {'key': 'position', 'type': 'int'},
        'is_damaged': {'key': 'isDamaged', 'type': 'bool'},
        'is_compressed': {'key': 'isCompressed', 'type': 'bool'},
        'family_count': {'key': 'familyCount', 'type': 'int'},
        'backup_finish_date': {'key': 'backupFinishDate', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs) -> None:
        super(DatabaseBackupInfo, self).__init__(**kwargs)
        self.database_name = None
        self.backup_type = None
        self.backup_files = None
        self.position = None
        self.is_damaged = None
        self.is_compressed = None
        self.family_count = None
        self.backup_finish_date = None
