# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobsListOutputFilesOptions(Model):
    """Additional parameters for list_output_files operation.

    All required parameters must be populated in order to send to Azure.

    :param outputdirectoryid: Required. Id of the job output directory. This
     is the OutputDirectory-->id parameter that is given by the user during
     Create Job.
    :type outputdirectoryid: str
    :param directory: The path to the directory. Default value: "." .
    :type directory: str
    :param linkexpiryinminutes: The number of minutes after which the download
     link will expire. Default value: 60 .
    :type linkexpiryinminutes: int
    :param max_results: The maximum number of items to return in the response.
     A maximum of 1000 files can be returned. Default value: 1000 .
    :type max_results: int
    """

    _validation = {
        'outputdirectoryid': {'required': True},
    }

    _attribute_map = {
        'outputdirectoryid': {'key': '', 'type': 'str'},
        'directory': {'key': '', 'type': 'str'},
        'linkexpiryinminutes': {'key': '', 'type': 'int'},
        'max_results': {'key': '', 'type': 'int'},
    }

    def __init__(self, *, outputdirectoryid: str, directory: str=".", linkexpiryinminutes: int=60, max_results: int=1000, **kwargs) -> None:
        super(JobsListOutputFilesOptions, self).__init__(**kwargs)
        self.outputdirectoryid = outputdirectoryid
        self.directory = directory
        self.linkexpiryinminutes = linkexpiryinminutes
        self.max_results = max_results
