/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;

class FileManagerUtils {
    private FileManagerUtils() {
    }

    static Iterable<Path> asPaths(Iterable<? extends File> files) {
        return () -> new Iterator<Path>(files){
            Iterator<? extends File> iter;
            {
                this.iter = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Path next() {
                return this.iter.next().toPath();
            }
        };
    }

    static Iterable<File> asFiles(Iterable<? extends Path> paths) {
        return () -> new Iterator<File>(paths){
            Iterator<? extends Path> iter;
            {
                this.iter = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public File next() {
                Path p = this.iter.next();
                try {
                    return p.toFile();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException(p.toString(), e);
                }
            }
        };
    }
}

