/* gui.c generated by valac 0.42.2, the Vala compiler
 * generated from gui.vala, do not modify */

/*
 *    Copyright (C) 1999, 2000,
 *    Dirk-Jan C. Binnema <djcb@dds.nl>,
 *    Arjan Scherpenisse <acscherp@wins.uva.nl>
 *    Copyright (C) 2016 Colin Watson <cjwatson@debian.org>
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */
/* The main user interface. */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TG_TYPE_INPUT_STATUS (tg_input_status_get_type ())

#define TG_TYPE_GUI (tg_gui_get_type ())
#define TG_GUI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_GUI, TgGui))
#define TG_GUI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_GUI, TgGuiClass))
#define TG_IS_GUI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_GUI))
#define TG_IS_GUI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_GUI))
#define TG_GUI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_GUI, TgGuiClass))

typedef struct _TgGui TgGui;
typedef struct _TgGuiClass TgGuiClass;
typedef struct _TgGuiPrivate TgGuiPrivate;

#define TG_TYPE_CHANNEL (tg_channel_get_type ())
#define TG_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_CHANNEL, TgChannel))
#define TG_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_CHANNEL, TgChannelClass))
#define TG_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_CHANNEL))
#define TG_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_CHANNEL))
#define TG_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_CHANNEL, TgChannelClass))

typedef struct _TgChannel TgChannel;
typedef struct _TgChannelClass TgChannelClass;

#define TG_TYPE_PIXPACK (tg_pixpack_get_type ())
#define TG_PIXPACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_PIXPACK, TgPixpack))
#define TG_PIXPACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_PIXPACK, TgPixpackClass))
#define TG_IS_PIXPACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_PIXPACK))
#define TG_IS_PIXPACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_PIXPACK))
#define TG_PIXPACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_PIXPACK, TgPixpackClass))

typedef struct _TgPixpack TgPixpack;
typedef struct _TgPixpackClass TgPixpackClass;
enum  {
	TG_GUI_0_PROPERTY,
	TG_GUI_CHANNEL_CHILDREN_PROPERTY,
	TG_GUI_CURRENT_CHANNEL_UUID_PROPERTY,
	TG_GUI_ZOOM_FACTOR_PROPERTY,
	TG_GUI_PAGING_ENABLED_PROPERTY,
	TG_GUI_PAGING_INTERVAL_PROPERTY,
	TG_GUI_PAGE_NUMBER_PROPERTY,
	TG_GUI_SUBPAGE_NUMBER_PROPERTY,
	TG_GUI_CURRENT_CHANNEL_PROPERTY,
	TG_GUI_WINDOW_PROPERTY,
	TG_GUI_NUM_PROPERTIES
};
static GParamSpec* tg_gui_properties[TG_GUI_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

#define TG_TYPE_PREFS (tg_prefs_get_type ())
#define TG_PREFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_PREFS, TgPrefs))
#define TG_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_PREFS, TgPrefsClass))
#define TG_IS_PREFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_PREFS))
#define TG_IS_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_PREFS))
#define TG_PREFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_PREFS, TgPrefsClass))

typedef struct _TgPrefs TgPrefs;
typedef struct _TgPrefsClass TgPrefsClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	TG_INPUT_STATUS_NEW,
	TG_INPUT_STATUS_CONTINUED
} TgInputStatus;

struct _TgGui {
	GObject parent_instance;
	TgGuiPrivate * priv;
};

struct _TgGuiClass {
	GObjectClass parent_class;
};

struct _TgGuiPrivate {
	gchar** _channel_children;
	gint _channel_children_length1;
	gint __channel_children_size_;
	gchar* _current_channel_uuid;
	gint _zoom_factor;
	gboolean _paging_enabled;
	gint _paging_interval;
	gint _page_number;
	gint _subpage_number;
	TgChannel* _current_channel;
	GtkBuilder* builder;
	GtkWindow* _window;
	GtkEntry* entry;
	TgPixpack* pixpack;
	GtkProgressBar* progress_bar;
	GtkStatusbar* status_bar;
	GMenu* channel_menu;
	GSettings* settings;
	guint* logo_timer_id;
	guint* kb_timer_id;
	TgInputStatus kb_status;
	guint* page_timer_id;
	gint page_progress;
	GSList* channels;
};

typedef enum  {
	TG_HTTP_ERROR_PIXBUF,
	TG_HTTP_ERROR_VFS,
	TG_HTTP_ERROR_HTTPQUERY
} TgHttpError;
#define TG_HTTP_ERROR tg_http_error_quark ()

static gint TgGui_private_offset;
static gpointer tg_gui_parent_class = NULL;

#define TG_notfound_pixmap "/org/gnome/telegnome/pixmaps/testbeeld.png"
#define TG_logo_pixmap "/org/gnome/telegnome/pixmaps/telegnome-logo.png"
#define TG_main_ui "/org/gnome/telegnome/telegnome.ui"
#define TG_kb_timeout 2500
#define TG_logo_timeout 7500
GType tg_input_status_get_type (void) G_GNUC_CONST;
GType tg_gui_get_type (void) G_GNUC_CONST;
GType tg_channel_get_type (void) G_GNUC_CONST;
GType tg_pixpack_get_type (void) G_GNUC_CONST;
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
TgGui* tg_gui_new (GtkApplication* app,
                   GSettings* settings);
TgGui* tg_gui_construct (GType object_type,
                         GtkApplication* app,
                         GSettings* settings);
static void tg_gui_set_window (TgGui* self,
                        GtkWindow* value);
GtkWindow* tg_gui_get_window (TgGui* self);
static gboolean __lambda4_ (TgGui* self,
                     GdkEventKey* event);
static gboolean tg_gui_on_keypress (TgGui* self,
                             GdkEventKey* event);
static gboolean ___lambda4__gtk_widget_key_press_event (GtkWidget* _sender,
                                                 GdkEventKey* event,
                                                 gpointer self);
static void __lambda5_ (TgGui* self);
static void tg_gui_on_goto_page (TgGui* self);
static void ___lambda5__gtk_entry_activate (GtkEntry* _sender,
                                     gpointer self);
static void __lambda6_ (TgGui* self);
static void ___lambda6__gtk_tool_button_clicked (GtkToolButton* _sender,
                                          gpointer self);
static void __lambda7_ (TgGui* self);
static void tg_gui_on_prev_page (TgGui* self);
static void ___lambda7__gtk_tool_button_clicked (GtkToolButton* _sender,
                                          gpointer self);
static void __lambda8_ (TgGui* self);
static void tg_gui_on_next_page (TgGui* self);
static void ___lambda8__gtk_tool_button_clicked (GtkToolButton* _sender,
                                          gpointer self);
static void __lambda9_ (TgGui* self);
static void tg_gui_on_home (TgGui* self);
static void ___lambda9__gtk_tool_button_clicked (GtkToolButton* _sender,
                                          gpointer self);
static void __lambda10_ (TgGui* self);
static void tg_gui_on_toggle_paging (TgGui* self);
static void ___lambda10__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static void tg_gui_refresh_channel_menu (TgGui* self);
static TgChannel* tg_gui_channel_find_by_uuid (TgGui* self,
                                        const gchar* uuid);
const gchar* tg_gui_get_current_channel_uuid (TgGui* self);
static void tg_gui_update_title_bar (TgGui* self);
static void tg_gui_update_entry (TgGui* self,
                          gint page_nr,
                          gint subpage_nr);
void tg_pixpack_load_image_from_resource (TgPixpack* self,
                                          const gchar* resource_path);
gint tg_gui_get_page_number (TgGui* self);
static gboolean tg_gui_logo_timer (TgGui* self);
static gboolean _tg_gui_logo_timer_gsource_func (gpointer self);
static guint* _uint_dup (guint* self);
TgChannel* tg_gui_get_current_channel (TgGui* self);
const gchar* tg_channel_get_name (TgChannel* self);
const gchar* tg_channel_get_description (TgChannel* self);
static void tg_gui_get_the_page (TgGui* self);
const gchar* tg_channel_get_uuid (TgChannel* self);
static void tg_gui_channel_select (TgGui* self,
                            TgChannel* channel);
void tg_gui_change_state_set_channel (TgGui* self,
                                      GSimpleAction* action,
                                      GVariant* value);
void tg_gui_set_current_channel_uuid (TgGui* self,
                                      const gchar* value);
void tg_gui_set_page_number (TgGui* self,
                             gint value);
void tg_gui_set_subpage_number (TgGui* self,
                                gint value);
static void tg_gui_populate_channel_menu (TgGui* self);
static gchar* tg_gui_get_default_channel_value (TgGui* self,
                                         GKeyFile* file,
                                         const gchar* group,
                                         const gchar* key,
                                         gboolean missing_ok);
static void tg_gui_reload_channels (TgGui* self);
gchar** tg_gui_get_channel_children (TgGui* self,
                                     int* result_length1);
TgChannel* tg_channel_new (const gchar* uuid);
TgChannel* tg_channel_construct (GType object_type,
                                 const gchar* uuid);
TgChannel* tg_channel_new_with_parameters (const gchar* name,
                                           const gchar* description,
                                           const gchar* page_url,
                                           const gchar* subpage_url,
                                           const gchar* country);
TgChannel* tg_channel_construct_with_parameters (GType object_type,
                                                 const gchar* name,
                                                 const gchar* description,
                                                 const gchar* page_url,
                                                 const gchar* subpage_url,
                                                 const gchar* country);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void tg_gui_print_in_statusbar (TgGui* self,
                                const gchar* status);
static gboolean tg_gui_pager_timer (TgGui* self);
gint tg_gui_get_paging_interval (TgGui* self);
gboolean tg_gui_get_paging_enabled (TgGui* self);
void tg_gui_set_paging_enabled (TgGui* self,
                                gboolean value);
static gboolean _tg_gui_pager_timer_gsource_func (gpointer self);
static void tg_gui_update_page (TgGui* self);
gint tg_gui_get_subpage_number (TgGui* self);
GQuark tg_http_error_quark (void);
GdkPixbuf* tg_http_get_image (TgGui* gui,
                              GError** error);
void tg_pixpack_load_image (TgPixpack* self,
                            GdkPixbuf* pixbuf);
void tg_gui_activate_quit (TgGui* self,
                           GSimpleAction* action,
                           GVariant* parameter);
void tg_gui_activate_help_contents (TgGui* self,
                                    GSimpleAction* action,
                                    GVariant* parameter);
void tg_gui_activate_about (TgGui* self,
                            GSimpleAction* action,
                            GVariant* parameter);
static void tg_gui_refresh_timer (TgGui* self);
void tg_gui_activate_preferences (TgGui* self,
                                  GSimpleAction* action,
                                  GVariant* parameter);
TgPrefs* tg_prefs_new (TgGui* gui);
TgPrefs* tg_prefs_construct (GType object_type,
                             TgGui* gui);
GType tg_prefs_get_type (void) G_GNUC_CONST;
void tg_prefs_show (TgPrefs* self);
static gint64* _int64_dup (gint64* self);
static gboolean tg_gui_keyboard_timer (TgGui* self);
static gboolean _tg_gui_keyboard_timer_gsource_func (gpointer self);
void tg_gui_set_channel_children (TgGui* self,
                                  gchar** value,
                                  int value_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          int length);
gint tg_gui_get_zoom_factor (TgGui* self);
void tg_gui_set_zoom_factor (TgGui* self,
                             gint value);
void tg_gui_set_paging_interval (TgGui* self,
                                 gint value);
static void tg_gui_finalize (GObject * obj);
static void _vala_tg_gui_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec);
static void _vala_tg_gui_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType
tg_input_status_get_type (void)
{
	static volatile gsize tg_input_status_type_id__volatile = 0;
	if (g_once_init_enter (&tg_input_status_type_id__volatile)) {
		static const GEnumValue values[] = {{TG_INPUT_STATUS_NEW, "TG_INPUT_STATUS_NEW", "new"}, {TG_INPUT_STATUS_CONTINUED, "TG_INPUT_STATUS_CONTINUED", "continued"}, {0, NULL, NULL}};
		GType tg_input_status_type_id;
		tg_input_status_type_id = g_enum_register_static ("TgInputStatus", values);
		g_once_init_leave (&tg_input_status_type_id__volatile, tg_input_status_type_id);
	}
	return tg_input_status_type_id__volatile;
}


static inline gpointer
tg_gui_get_instance_private (TgGui* self)
{
	return G_STRUCT_MEMBER_P (self, TgGui_private_offset);
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static gboolean
__lambda4_ (TgGui* self,
            GdkEventKey* event)
{
	gboolean result = FALSE;
	g_return_val_if_fail (event != NULL, FALSE);
	result = tg_gui_on_keypress (self, event);
	return result;
}


static gboolean
___lambda4__gtk_widget_key_press_event (GtkWidget* _sender,
                                        GdkEventKey* event,
                                        gpointer self)
{
	gboolean result;
	result = __lambda4_ ((TgGui*) self, event);
	return result;
}


static void
__lambda5_ (TgGui* self)
{
	tg_gui_on_goto_page (self);
}


static void
___lambda5__gtk_entry_activate (GtkEntry* _sender,
                                gpointer self)
{
	__lambda5_ ((TgGui*) self);
}


static void
__lambda6_ (TgGui* self)
{
	tg_gui_on_goto_page (self);
}


static void
___lambda6__gtk_tool_button_clicked (GtkToolButton* _sender,
                                     gpointer self)
{
	__lambda6_ ((TgGui*) self);
}


static void
__lambda7_ (TgGui* self)
{
	tg_gui_on_prev_page (self);
}


static void
___lambda7__gtk_tool_button_clicked (GtkToolButton* _sender,
                                     gpointer self)
{
	__lambda7_ ((TgGui*) self);
}


static void
__lambda8_ (TgGui* self)
{
	tg_gui_on_next_page (self);
}


static void
___lambda8__gtk_tool_button_clicked (GtkToolButton* _sender,
                                     gpointer self)
{
	__lambda8_ ((TgGui*) self);
}


static void
__lambda9_ (TgGui* self)
{
	tg_gui_on_home (self);
}


static void
___lambda9__gtk_tool_button_clicked (GtkToolButton* _sender,
                                     gpointer self)
{
	__lambda9_ ((TgGui*) self);
}


static void
__lambda10_ (TgGui* self)
{
	tg_gui_on_toggle_paging (self);
}


static void
___lambda10__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
	__lambda10_ ((TgGui*) self);
}


static gboolean
_tg_gui_logo_timer_gsource_func (gpointer self)
{
	gboolean result;
	result = tg_gui_logo_timer ((TgGui*) self);
	return result;
}


static guint*
_uint_dup (guint* self)
{
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}


static gpointer
__uint_dup0 (gpointer self)
{
	return self ? _uint_dup (self) : NULL;
}


TgGui*
tg_gui_construct (GType object_type,
                  GtkApplication* app,
                  GSettings* settings)
{
	TgGui * self = NULL;
	const gchar* _tmp0_;
	GtkBuilder* _tmp1_;
	GtkBuilder* _tmp2_;
	GObject* _tmp3_;
	GtkWindow* _tmp4_;
	GtkBuilder* _tmp5_;
	GObject* _tmp6_;
	GtkEntry* _tmp7_;
	GtkBuilder* _tmp8_;
	GObject* _tmp9_;
	TgPixpack* _tmp10_;
	GtkBuilder* _tmp11_;
	GObject* _tmp12_;
	GtkProgressBar* _tmp13_;
	GtkBuilder* _tmp14_;
	GObject* _tmp15_;
	GtkStatusbar* _tmp16_;
	GtkWindow* _tmp17_;
	GtkEntry* _tmp18_;
	GtkToolButton* goto_button = NULL;
	GtkBuilder* _tmp19_;
	GObject* _tmp20_;
	GtkToolButton* _tmp21_;
	GtkToolButton* _tmp22_;
	GtkToolButton* prev_button = NULL;
	GtkBuilder* _tmp23_;
	GObject* _tmp24_;
	GtkToolButton* _tmp25_;
	GtkToolButton* _tmp26_;
	GtkToolButton* next_button = NULL;
	GtkBuilder* _tmp27_;
	GObject* _tmp28_;
	GtkToolButton* _tmp29_;
	GtkToolButton* _tmp30_;
	GtkToolButton* home_button = NULL;
	GtkBuilder* _tmp31_;
	GObject* _tmp32_;
	GtkToolButton* _tmp33_;
	GtkToolButton* _tmp34_;
	GtkToggleToolButton* paging_button = NULL;
	GtkBuilder* _tmp35_;
	GObject* _tmp36_;
	GtkToggleToolButton* _tmp37_;
	GtkToggleToolButton* _tmp38_;
	GMenu* _tmp39_;
	GMenu* _tmp40_;
	GSettings* _tmp41_;
	GtkWindow* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	TgChannel* _tmp45_;
	TgPixpack* _tmp46_;
	gint _tmp47_;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	self = (TgGui*) g_object_new (object_type, NULL);
	_tmp0_ = g_type_name (TG_TYPE_PIXPACK);
	_vala_assert (g_strcmp0 (_tmp0_, "") != 0, "typeof (Pixpack).name() != \"\"");
	_tmp1_ = gtk_builder_new_from_resource (TG_main_ui);
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp1_;
	_tmp2_ = self->priv->builder;
	_tmp3_ = gtk_builder_get_object (_tmp2_, "main_window");
	tg_gui_set_window (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp3_) : NULL);
	_tmp4_ = self->priv->_window;
	gtk_application_add_window (app, _tmp4_);
	_tmp5_ = self->priv->builder;
	_tmp6_ = gtk_builder_get_object (_tmp5_, "page_entry");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp6_) : NULL);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp7_;
	_tmp8_ = self->priv->builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "pixpack");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TG_TYPE_PIXPACK) ? ((TgPixpack*) _tmp9_) : NULL);
	_g_object_unref0 (self->priv->pixpack);
	self->priv->pixpack = _tmp10_;
	_tmp11_ = self->priv->builder;
	_tmp12_ = gtk_builder_get_object (_tmp11_, "progress_bar");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_progress_bar_get_type ()) ? ((GtkProgressBar*) _tmp12_) : NULL);
	_g_object_unref0 (self->priv->progress_bar);
	self->priv->progress_bar = _tmp13_;
	_tmp14_ = self->priv->builder;
	_tmp15_ = gtk_builder_get_object (_tmp14_, "status_bar");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, gtk_statusbar_get_type ()) ? ((GtkStatusbar*) _tmp15_) : NULL);
	_g_object_unref0 (self->priv->status_bar);
	self->priv->status_bar = _tmp16_;
	_tmp17_ = self->priv->_window;
	g_signal_connect_object ((GtkWidget*) _tmp17_, "key-press-event", (GCallback) ___lambda4__gtk_widget_key_press_event, self, 0);
	_tmp18_ = self->priv->entry;
	g_signal_connect_object (_tmp18_, "activate", (GCallback) ___lambda5__gtk_entry_activate, self, 0);
	_tmp19_ = self->priv->builder;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "goto_button");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, gtk_tool_button_get_type ()) ? ((GtkToolButton*) _tmp20_) : NULL);
	goto_button = _tmp21_;
	_tmp22_ = goto_button;
	g_signal_connect_object (_tmp22_, "clicked", (GCallback) ___lambda6__gtk_tool_button_clicked, self, 0);
	_tmp23_ = self->priv->builder;
	_tmp24_ = gtk_builder_get_object (_tmp23_, "prev_button");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, gtk_tool_button_get_type ()) ? ((GtkToolButton*) _tmp24_) : NULL);
	prev_button = _tmp25_;
	_tmp26_ = prev_button;
	g_signal_connect_object (_tmp26_, "clicked", (GCallback) ___lambda7__gtk_tool_button_clicked, self, 0);
	_tmp27_ = self->priv->builder;
	_tmp28_ = gtk_builder_get_object (_tmp27_, "next_button");
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, gtk_tool_button_get_type ()) ? ((GtkToolButton*) _tmp28_) : NULL);
	next_button = _tmp29_;
	_tmp30_ = next_button;
	g_signal_connect_object (_tmp30_, "clicked", (GCallback) ___lambda8__gtk_tool_button_clicked, self, 0);
	_tmp31_ = self->priv->builder;
	_tmp32_ = gtk_builder_get_object (_tmp31_, "home_button");
	_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, gtk_tool_button_get_type ()) ? ((GtkToolButton*) _tmp32_) : NULL);
	home_button = _tmp33_;
	_tmp34_ = home_button;
	g_signal_connect_object (_tmp34_, "clicked", (GCallback) ___lambda9__gtk_tool_button_clicked, self, 0);
	_tmp35_ = self->priv->builder;
	_tmp36_ = gtk_builder_get_object (_tmp35_, "paging_button");
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp36_) : NULL);
	paging_button = _tmp37_;
	_tmp38_ = paging_button;
	g_signal_connect_object ((GtkToolButton*) _tmp38_, "clicked", (GCallback) ___lambda10__gtk_tool_button_clicked, self, 0);
	_tmp39_ = gtk_application_get_menu_by_id (app, "channels");
	_tmp40_ = _g_object_ref0 (_tmp39_);
	_g_object_unref0 (self->priv->channel_menu);
	self->priv->channel_menu = _tmp40_;
	_tmp41_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp41_;
	g_settings_bind (settings, "channel-children", (GObject*) self, "channel_children", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (settings, "current-channel", (GObject*) self, "current_channel_uuid", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (settings, "zoom-factor", (GObject*) self, "zoom_factor", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (settings, "paging-enabled", (GObject*) self, "paging_enabled", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (settings, "paging-interval", (GObject*) self, "paging_interval", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (settings, "current-page-number", (GObject*) self, "page_number", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (settings, "current-subpage-number", (GObject*) self, "subpage_number", G_SETTINGS_BIND_DEFAULT);
	_tmp42_ = self->priv->_window;
	gtk_widget_show_all ((GtkWidget*) _tmp42_);
	_g_free0 (self->priv->kb_timer_id);
	self->priv->kb_timer_id = NULL;
	self->priv->kb_status = TG_INPUT_STATUS_NEW;
	(self->priv->channels == NULL) ? NULL : (self->priv->channels = (_g_slist_free__g_object_unref0_ (self->priv->channels), NULL));
	self->priv->channels = NULL;
	tg_gui_refresh_channel_menu (self);
	_tmp43_ = tg_gui_get_current_channel_uuid (self);
	_tmp44_ = _tmp43_;
	_tmp45_ = tg_gui_channel_find_by_uuid (self, _tmp44_);
	_g_object_unref0 (self->priv->_current_channel);
	self->priv->_current_channel = _tmp45_;
	tg_gui_update_title_bar (self);
	tg_gui_update_entry (self, 0, 0);
	_tmp46_ = self->priv->pixpack;
	tg_pixpack_load_image_from_resource (_tmp46_, TG_logo_pixmap);
	_tmp47_ = self->priv->_page_number;
	if (_tmp47_ > 0) {
		guint _tmp48_;
		guint* _tmp49_;
		_tmp48_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) TG_logo_timeout, _tg_gui_logo_timer_gsource_func, g_object_ref (self), g_object_unref);
		_tmp49_ = __uint_dup0 (&_tmp48_);
		_g_free0 (self->priv->logo_timer_id);
		self->priv->logo_timer_id = _tmp49_;
	} else {
		_g_free0 (self->priv->logo_timer_id);
		self->priv->logo_timer_id = NULL;
	}
	_g_object_unref0 (paging_button);
	_g_object_unref0 (home_button);
	_g_object_unref0 (next_button);
	_g_object_unref0 (prev_button);
	_g_object_unref0 (goto_button);
	return self;
}


TgGui*
tg_gui_new (GtkApplication* app,
            GSettings* settings)
{
	return tg_gui_construct (TG_TYPE_GUI, app, settings);
}


static void
tg_gui_update_title_bar (TgGui* self)
{
	TgChannel* _tmp0_;
	TgChannel* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tg_gui_get_current_channel (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gchar* name = NULL;
		TgChannel* _tmp2_;
		TgChannel* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* desc = NULL;
		TgChannel* _tmp7_;
		TgChannel* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_;
		_tmp2_ = tg_gui_get_current_channel (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = tg_channel_get_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		name = _tmp6_;
		_tmp7_ = tg_gui_get_current_channel (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = tg_channel_get_description (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		desc = _tmp11_;
		_tmp13_ = name;
		if (_tmp13_ != NULL) {
			const gchar* _tmp14_;
			_tmp14_ = desc;
			_tmp12_ = _tmp14_ != NULL;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			gchar* title = NULL;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			GtkWindow* _tmp18_;
			const gchar* _tmp19_;
			_tmp15_ = name;
			_tmp16_ = desc;
			_tmp17_ = g_strdup_printf (_ ("TeleGNOME: %s (%s)"), _tmp15_, _tmp16_);
			title = _tmp17_;
			_tmp18_ = self->priv->_window;
			_tmp19_ = title;
			gtk_window_set_title (_tmp18_, _tmp19_);
			_g_free0 (title);
		}
		_g_free0 (desc);
		_g_free0 (name);
	}
}


/**
 * logo_timer:
 *
 * Remove the logo from the screen and go to a page.
 */
static gboolean
tg_gui_logo_timer (TgGui* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	tg_gui_get_the_page (self);
	_g_free0 (self->priv->logo_timer_id);
	self->priv->logo_timer_id = NULL;
	result = FALSE;
	return result;
}


static TgChannel*
tg_gui_channel_find_by_uuid (TgGui* self,
                             const gchar* uuid)
{
	TgChannel* result = NULL;
	GSList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = self->priv->channels;
	{
		GSList* channel_collection = NULL;
		GSList* channel_it = NULL;
		channel_collection = _tmp0_;
		for (channel_it = channel_collection; channel_it != NULL; channel_it = channel_it->next) {
			TgChannel* _tmp1_;
			TgChannel* channel = NULL;
			_tmp1_ = _g_object_ref0 ((TgChannel*) channel_it->data);
			channel = _tmp1_;
			{
				TgChannel* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = channel;
				_tmp3_ = tg_channel_get_uuid (_tmp2_);
				_tmp4_ = _tmp3_;
				if (g_strcmp0 (uuid, _tmp4_) == 0) {
					result = channel;
					return result;
				}
				_g_object_unref0 (channel);
			}
		}
	}
	result = NULL;
	return result;
}


static void
tg_gui_channel_select (TgGui* self,
                       TgChannel* channel)
{
	TgChannel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = _g_object_ref0 (channel);
	_g_object_unref0 (self->priv->_current_channel);
	self->priv->_current_channel = _tmp0_;
	tg_gui_update_title_bar (self);
}


void
tg_gui_change_state_set_channel (TgGui* self,
                                 GSimpleAction* action,
                                 GVariant* value)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (value, NULL);
	tg_gui_set_current_channel_uuid (self, _tmp0_);
	tg_gui_set_page_number (self, 100);
	tg_gui_set_subpage_number (self, 0);
	tg_gui_get_the_page (self);
}


static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void
tg_gui_populate_channel_menu (TgGui* self)
{
	GMenu* _tmp0_;
	GSList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->channel_menu;
	g_menu_remove_all (_tmp0_);
	_tmp1_ = self->priv->channels;
	{
		GSList* channel_collection = NULL;
		GSList* channel_it = NULL;
		channel_collection = _tmp1_;
		for (channel_it = channel_collection; channel_it != NULL; channel_it = channel_it->next) {
			TgChannel* _tmp2_;
			TgChannel* channel = NULL;
			_tmp2_ = _g_object_ref0 ((TgChannel*) channel_it->data);
			channel = _tmp2_;
			{
				gchar* action = NULL;
				TgChannel* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				GMenu* _tmp8_;
				TgChannel* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				_tmp3_ = channel;
				_tmp4_ = tg_channel_get_uuid (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = string_to_string (_tmp5_);
				_tmp7_ = g_strconcat ("app.set-channel::", _tmp6_, NULL);
				action = _tmp7_;
				_tmp8_ = self->priv->channel_menu;
				_tmp9_ = channel;
				_tmp10_ = tg_channel_get_name (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = action;
				g_menu_append (_tmp8_, _tmp11_, _tmp12_);
				_g_free0 (action);
				_g_object_unref0 (channel);
			}
		}
	}
}


static gchar*
tg_gui_get_default_channel_value (TgGui* self,
                                  GKeyFile* file,
                                  const gchar* group,
                                  const gchar* key,
                                  gboolean missing_ok)
{
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_key_file_get_string (file, group, key, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp2_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		if (missing_ok) {
			result = NULL;
			_g_error_free0 (e);
			return result;
		} else {
			g_assert_not_reached ();
		}
		_g_error_free0 (e);
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


/**
 * reload_channels:
 *
 * Load all the channels from settings and store them in the
 * "channels" property.
 */
static gint
_vala_g_bytes_get_length (GBytes* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) g_bytes_get_size (self);
	return result;
}


static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
tg_gui_reload_channels (TgGui* self)
{
	gchar* current_uuid = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GSList* _tmp8_;
	const gchar* _tmp54_;
	TgChannel* _tmp56_;
	TgChannel* _tmp57_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tg_gui_get_current_channel_uuid (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	current_uuid = _tmp2_;
	(self->priv->channels == NULL) ? NULL : (self->priv->channels = (_g_slist_free__g_object_unref0_ (self->priv->channels), NULL));
	self->priv->channels = NULL;
	_tmp3_ = tg_gui_get_channel_children (self, &_tmp3__length1);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	{
		gchar** uuid_collection = NULL;
		gint uuid_collection_length1 = 0;
		gint _uuid_collection_size_ = 0;
		gint uuid_it = 0;
		uuid_collection = _tmp4_;
		uuid_collection_length1 = _tmp4__length1;
		for (uuid_it = 0; uuid_it < _tmp4__length1; uuid_it = uuid_it + 1) {
			gchar* _tmp5_;
			gchar* uuid = NULL;
			_tmp5_ = g_strdup (uuid_collection[uuid_it]);
			uuid = _tmp5_;
			{
				const gchar* _tmp6_;
				TgChannel* _tmp7_;
				_tmp6_ = uuid;
				_tmp7_ = tg_channel_new (_tmp6_);
				self->priv->channels = g_slist_append (self->priv->channels, _tmp7_);
				_g_free0 (uuid);
			}
		}
	}
	_tmp8_ = self->priv->channels;
	if (_tmp8_ == NULL) {
		gchar** children = NULL;
		gchar** _tmp9_;
		gint children_length1;
		gint _children_size_;
		GBytes* bytes = NULL;
		GKeyFile* file = NULL;
		GKeyFile* _tmp13_;
		GKeyFile* _tmp21_;
		gsize _tmp22_;
		gchar** _tmp23_;
		GSettings* _tmp52_;
		gchar** _tmp53_;
		gint _tmp53__length1;
		_tmp9_ = g_new0 (gchar*, 0 + 1);
		children = _tmp9_;
		children_length1 = 0;
		_children_size_ = children_length1;
		{
			GBytes* _tmp10_ = NULL;
			GBytes* _tmp11_;
			GBytes* _tmp12_;
			_tmp11_ = g_resources_lookup_data ("/org/gnome/telegnome/default-channels.cfg", G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error_);
			_tmp10_ = _tmp11_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp12_ = _tmp10_;
			_tmp10_ = NULL;
			_g_bytes_unref0 (bytes);
			bytes = _tmp12_;
			_g_bytes_unref0 (_tmp10_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_bytes_unref0 (bytes);
			children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (current_uuid);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp13_ = g_key_file_new ();
		file = _tmp13_;
		{
			GKeyFile* _tmp14_;
			GBytes* _tmp15_;
			gsize _tmp16_;
			guint8* _tmp17_;
			GBytes* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			_tmp14_ = file;
			_tmp15_ = bytes;
			_tmp17_ = g_bytes_get_data (_tmp15_, &_tmp16_);
			_tmp18_ = bytes;
			_tmp19_ = _vala_g_bytes_get_length (_tmp18_);
			_tmp20_ = _tmp19_;
			g_key_file_load_from_data (_tmp14_, (const gchar*) _tmp17_, (gsize) _tmp20_, G_KEY_FILE_NONE, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_key_file_unref0 (file);
			_g_bytes_unref0 (bytes);
			children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (current_uuid);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp21_ = file;
		_tmp23_ = g_key_file_get_groups (_tmp21_, &_tmp22_);
		{
			gchar** group_collection = NULL;
			gint group_collection_length1 = 0;
			gint _group_collection_size_ = 0;
			gint group_it = 0;
			group_collection = _tmp23_;
			group_collection_length1 = _tmp22_;
			for (group_it = 0; group_it < _tmp22_; group_it = group_it + 1) {
				const gchar* group = NULL;
				group = group_collection[group_it];
				{
					gchar* name = NULL;
					GKeyFile* _tmp24_;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* description = NULL;
					GKeyFile* _tmp27_;
					const gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* page_url = NULL;
					GKeyFile* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* subpage_url = NULL;
					GKeyFile* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* country = NULL;
					GKeyFile* _tmp36_;
					const gchar* _tmp37_;
					gchar* _tmp38_;
					TgChannel* channel = NULL;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					TgChannel* _tmp44_;
					TgChannel* _tmp45_;
					TgChannel* _tmp46_;
					gchar** _tmp47_;
					gint _tmp47__length1;
					TgChannel* _tmp48_;
					const gchar* _tmp49_;
					const gchar* _tmp50_;
					gchar* _tmp51_;
					_tmp24_ = file;
					_tmp25_ = group;
					_tmp26_ = tg_gui_get_default_channel_value (self, _tmp24_, _tmp25_, "Name", FALSE);
					name = _tmp26_;
					_tmp27_ = file;
					_tmp28_ = group;
					_tmp29_ = tg_gui_get_default_channel_value (self, _tmp27_, _tmp28_, "Description", FALSE);
					description = _tmp29_;
					_tmp30_ = file;
					_tmp31_ = group;
					_tmp32_ = tg_gui_get_default_channel_value (self, _tmp30_, _tmp31_, "PageURL", FALSE);
					page_url = _tmp32_;
					_tmp33_ = file;
					_tmp34_ = group;
					_tmp35_ = tg_gui_get_default_channel_value (self, _tmp33_, _tmp34_, "SubpageURL", TRUE);
					subpage_url = _tmp35_;
					_tmp36_ = file;
					_tmp37_ = group;
					_tmp38_ = tg_gui_get_default_channel_value (self, _tmp36_, _tmp37_, "Country", FALSE);
					country = _tmp38_;
					_tmp39_ = name;
					_tmp40_ = description;
					_tmp41_ = page_url;
					_tmp42_ = subpage_url;
					_tmp43_ = country;
					_tmp44_ = tg_channel_new_with_parameters (_tmp39_, _tmp40_, _tmp41_, _tmp42_, _tmp43_);
					channel = _tmp44_;
					_tmp45_ = channel;
					_tmp46_ = _g_object_ref0 (_tmp45_);
					self->priv->channels = g_slist_append (self->priv->channels, _tmp46_);
					_tmp47_ = children;
					_tmp47__length1 = children_length1;
					_tmp48_ = channel;
					_tmp49_ = tg_channel_get_uuid (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_strdup (_tmp50_);
					_vala_array_add1 (&children, &children_length1, &_children_size_, _tmp51_);
					_g_object_unref0 (channel);
					_g_free0 (country);
					_g_free0 (subpage_url);
					_g_free0 (page_url);
					_g_free0 (description);
					_g_free0 (name);
				}
			}
			group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp52_ = self->priv->settings;
		_tmp53_ = children;
		_tmp53__length1 = children_length1;
		g_settings_set_strv (_tmp52_, "channel-children", _tmp53_);
		_g_key_file_unref0 (file);
		_g_bytes_unref0 (bytes);
		children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp54_ = current_uuid;
	if (_tmp54_ != NULL) {
		const gchar* _tmp55_;
		_tmp55_ = current_uuid;
		tg_gui_set_current_channel_uuid (self, _tmp55_);
	}
	_tmp56_ = tg_gui_get_current_channel (self);
	_tmp57_ = _tmp56_;
	if (_tmp57_ == NULL) {
		GSList* _tmp58_;
		gconstpointer _tmp59_;
		const gchar* _tmp60_;
		const gchar* _tmp61_;
		const gchar* _tmp62_;
		_tmp58_ = self->priv->channels;
		_tmp59_ = _tmp58_->data;
		_tmp60_ = tg_channel_get_uuid ((TgChannel*) _tmp59_);
		_tmp61_ = _tmp60_;
		tg_gui_set_current_channel_uuid (self, _tmp61_);
		tg_gui_set_page_number (self, 100);
		tg_gui_set_subpage_number (self, 0);
		_tmp62_ = current_uuid;
		if (_tmp62_ != NULL) {
			tg_gui_get_the_page (self);
		}
	}
	_g_free0 (current_uuid);
}


static void
tg_gui_refresh_channel_menu (TgGui* self)
{
	g_return_if_fail (self != NULL);
	tg_gui_reload_channels (self);
	tg_gui_populate_channel_menu (self);
}


/**
 * print_in_statusbar:
 * @status: A status string.
 *
 * Print a string in the status bar.
 */
static void
tg_gui_print_in_statusbar (TgGui* self,
                           const gchar* status)
{
	guint context_id = 0U;
	GtkStatusbar* _tmp0_;
	GtkStatusbar* _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->status_bar;
	context_id = gtk_statusbar_get_context_id (_tmp0_, "errors");
	_tmp1_ = self->priv->status_bar;
	_tmp2_ = context_id;
	gtk_statusbar_remove_all (_tmp1_, _tmp2_);
	if (status != NULL) {
		GtkStatusbar* _tmp3_;
		guint _tmp4_;
		_tmp3_ = self->priv->status_bar;
		_tmp4_ = context_id;
		gtk_statusbar_push (_tmp3_, _tmp4_, status);
	}
}


static gboolean
tg_gui_pager_timer (TgGui* self)
{
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	GtkProgressBar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->page_progress;
	_tmp1_ = self->priv->_paging_interval;
	self->priv->page_progress = _tmp0_ + (_tmp1_ / 100);
	_tmp2_ = self->priv->progress_bar;
	_tmp3_ = self->priv->page_progress;
	_tmp4_ = self->priv->_paging_interval;
	gtk_progress_bar_set_fraction (_tmp2_, _tmp3_ / ((gdouble) _tmp4_));
	_tmp5_ = self->priv->page_progress;
	_tmp6_ = self->priv->_paging_interval;
	if (_tmp5_ >= _tmp6_) {
		GtkProgressBar* _tmp7_;
		self->priv->page_progress = 0;
		_tmp7_ = self->priv->progress_bar;
		gtk_progress_bar_set_fraction (_tmp7_, 0.0);
		tg_gui_on_next_page (self);
	}
	result = TRUE;
	return result;
}


static gboolean
_tg_gui_pager_timer_gsource_func (gpointer self)
{
	gboolean result;
	result = tg_gui_pager_timer ((TgGui*) self);
	return result;
}


static void
tg_gui_on_toggle_paging (TgGui* self)
{
	GtkProgressBar* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_bar;
	gtk_progress_bar_set_fraction (_tmp0_, 0.0);
	_tmp1_ = self->priv->_paging_enabled;
	if (_tmp1_) {
		guint* _tmp2_;
		_tmp2_ = self->priv->page_timer_id;
		if (_tmp2_ != NULL) {
			guint* _tmp3_;
			_tmp3_ = self->priv->page_timer_id;
			g_source_remove (*_tmp3_);
		}
		_g_free0 (self->priv->page_timer_id);
		self->priv->page_timer_id = NULL;
		tg_gui_set_paging_enabled (self, FALSE);
	} else {
		gint _tmp4_;
		guint _tmp5_;
		guint* _tmp6_;
		_tmp4_ = self->priv->_paging_interval;
		_tmp5_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (_tmp4_ / 100), _tg_gui_pager_timer_gsource_func, g_object_ref (self), g_object_unref);
		_tmp6_ = __uint_dup0 (&_tmp5_);
		_g_free0 (self->priv->page_timer_id);
		self->priv->page_timer_id = _tmp6_;
		tg_gui_set_paging_enabled (self, TRUE);
	}
	self->priv->page_progress = 0;
}


static void
tg_gui_update_page (TgGui* self)
{
	gint old_page = 0;
	gint _tmp0_;
	gint old_subpage = 0;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_page_number;
	old_page = _tmp0_;
	_tmp1_ = self->priv->_subpage_number;
	old_subpage = _tmp1_;
	{
		GdkPixbuf* pixbuf = NULL;
		GdkPixbuf* _tmp2_;
		TgPixpack* _tmp3_;
		_tmp2_ = tg_http_get_image (self, &_inner_error_);
		pixbuf = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == TG_HTTP_ERROR) {
				goto __catch3_tg_http_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->pixpack;
		tg_pixpack_load_image (_tmp3_, pixbuf);
		_g_object_unref0 (pixbuf);
	}
	goto __finally3;
	__catch3_tg_http_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		if (g_error_matches (_tmp4_, TG_HTTP_ERROR, TG_HTTP_ERROR_PIXBUF)) {
			gint _tmp5_;
			_tmp5_ = self->priv->_subpage_number;
			if (_tmp5_ == 0) {
				tg_gui_set_subpage_number (self, 1);
			} else {
				tg_gui_set_subpage_number (self, 0);
			}
			{
				GdkPixbuf* pixbuf = NULL;
				GdkPixbuf* _tmp6_;
				TgPixpack* _tmp7_;
				GdkPixbuf* _tmp8_;
				_tmp6_ = tg_http_get_image (self, &_inner_error_);
				pixbuf = _tmp6_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == TG_HTTP_ERROR) {
						goto __catch4_tg_http_error;
					}
					_g_error_free0 (e);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp7_ = self->priv->pixpack;
				_tmp8_ = pixbuf;
				tg_pixpack_load_image (_tmp7_, _tmp8_);
				_g_object_unref0 (pixbuf);
			}
			goto __finally4;
			__catch4_tg_http_error:
			{
				GError* e2 = NULL;
				gint _tmp9_;
				e2 = _inner_error_;
				_inner_error_ = NULL;
				_tmp9_ = self->priv->_subpage_number;
				if (_tmp9_ != 1) {
					gint _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp10_ = self->priv->_page_number;
					tg_gui_set_page_number (self, _tmp10_ + 1);
					tg_gui_set_subpage_number (self, 1);
					_tmp11_ = self->priv->_page_number;
					_tmp12_ = self->priv->_subpage_number;
					tg_gui_update_entry (self, _tmp11_, _tmp12_);
					tg_gui_get_the_page (self);
				} else {
					gint _tmp13_;
					gint _tmp14_;
					TgPixpack* _tmp15_;
					tg_gui_print_in_statusbar (self, _ ("Web server error: Wrong page number?"));
					tg_gui_set_page_number (self, old_page);
					tg_gui_set_subpage_number (self, old_subpage);
					_tmp13_ = self->priv->_page_number;
					_tmp14_ = self->priv->_subpage_number;
					tg_gui_update_entry (self, _tmp13_, _tmp14_);
					_tmp15_ = self->priv->pixpack;
					tg_pixpack_load_image_from_resource (_tmp15_, TG_notfound_pixmap);
				}
				_g_error_free0 (e2);
			}
			__finally4:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_error_free0 (e);
				_g_error_free0 (e);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		} else {
			GError* _tmp16_;
			_tmp16_ = e;
			if (g_error_matches (_tmp16_, TG_HTTP_ERROR, TG_HTTP_ERROR_VFS)) {
				tg_gui_print_in_statusbar (self, _ ("Error making HTTP connection"));
			} else {
				GError* _tmp17_;
				_tmp17_ = e;
				if (g_error_matches (_tmp17_, TG_HTTP_ERROR, TG_HTTP_ERROR_HTTPQUERY)) {
					tg_gui_print_in_statusbar (self, _ ("Internal error in HTTP query code"));
				} else {
					g_assert_not_reached ();
				}
			}
		}
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
 * update_entry:
 *
 * Update the entry box with the current values of page and subpage.
 */
static void
tg_gui_update_entry (TgGui* self,
                     gint page_nr,
                     gint subpage_nr)
{
	gchar* full_num = NULL;
	GtkEntry* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	if (subpage_nr > 0) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = g_strdup_printf ("%i", page_nr);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strdup_printf ("%i", subpage_nr);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp1_, "/", _tmp3_, NULL);
		_g_free0 (full_num);
		full_num = _tmp4_;
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup_printf ("%i", page_nr);
		_g_free0 (full_num);
		full_num = _tmp5_;
	}
	_tmp6_ = self->priv->entry;
	_tmp7_ = full_num;
	gtk_entry_set_text (_tmp6_, _tmp7_);
	_g_free0 (full_num);
}


/**
 * get_the_page:
 *
 * Try to get the page, and do something smart if it fails.
 */
static void
tg_gui_get_the_page (TgGui* self)
{
	guint* _tmp0_;
	TgChannel* _tmp2_;
	TgChannel* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->logo_timer_id;
	if (_tmp0_ != NULL) {
		guint* _tmp1_;
		_tmp1_ = self->priv->logo_timer_id;
		g_source_remove (*_tmp1_);
	}
	_g_free0 (self->priv->logo_timer_id);
	self->priv->logo_timer_id = NULL;
	_tmp2_ = tg_gui_get_current_channel (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		tg_gui_update_page (self);
	}
	_tmp4_ = self->priv->_page_number;
	_tmp5_ = self->priv->_subpage_number;
	tg_gui_update_entry (self, _tmp4_, _tmp5_);
	tg_gui_print_in_statusbar (self, NULL);
}


void
tg_gui_activate_quit (TgGui* self,
                      GSimpleAction* action,
                      GVariant* parameter)
{
	GApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_application_get_default ();
	g_application_quit (_tmp0_);
}


void
tg_gui_activate_help_contents (TgGui* self,
                               GSimpleAction* action,
                               GVariant* parameter)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		GtkWindow* _tmp0_;
		_tmp0_ = self->priv->_window;
		gtk_show_uri_on_window (_tmp0_, "help:telegnome", (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("gui.vala:440: Error displaying help: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void
tg_gui_activate_about (TgGui* self,
                       GSimpleAction* action,
                       GVariant* parameter)
{
	GtkDialog* about = NULL;
	GtkBuilder* _tmp0_;
	GObject* _tmp1_;
	GtkDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "about_dialog");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp1_) : NULL);
	about = _tmp2_;
	gtk_dialog_run (about);
	gtk_widget_hide ((GtkWidget*) about);
	_g_object_unref0 (about);
}


static void
tg_gui_refresh_timer (TgGui* self)
{
	gdouble perc = 0.0;
	GtkProgressBar* _tmp0_;
	GtkProgressBar* _tmp1_;
	gdouble _tmp2_;
	gboolean _tmp3_;
	gint _tmp8_;
	gdouble _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_bar;
	perc = gtk_progress_bar_get_fraction (_tmp0_);
	_tmp1_ = self->priv->progress_bar;
	_tmp2_ = perc;
	gtk_progress_bar_set_fraction (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->_paging_enabled;
	if (_tmp3_) {
		guint* _tmp4_;
		gint _tmp5_;
		guint _tmp6_;
		guint* _tmp7_;
		_tmp4_ = self->priv->page_timer_id;
		g_source_remove (*_tmp4_);
		_tmp5_ = self->priv->_paging_interval;
		_tmp6_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (_tmp5_ / 100), _tg_gui_pager_timer_gsource_func, g_object_ref (self), g_object_unref);
		_tmp7_ = __uint_dup0 (&_tmp6_);
		_g_free0 (self->priv->page_timer_id);
		self->priv->page_timer_id = _tmp7_;
	}
	_tmp8_ = self->priv->_paging_interval;
	_tmp9_ = perc;
	self->priv->page_progress = (gint) ((_tmp8_ / 100) * _tmp9_);
}


void
tg_gui_activate_preferences (TgGui* self,
                             GSimpleAction* action,
                             GVariant* parameter)
{
	TgPrefs* _tmp0_;
	TgPrefs* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = tg_prefs_new (self);
	_tmp1_ = _tmp0_;
	tg_prefs_show (_tmp1_);
	_g_object_unref0 (_tmp1_);
	tg_gui_refresh_channel_menu (self);
	tg_gui_refresh_timer (self);
}


static void
tg_gui_on_next_page (TgGui* self)
{
	gint _tmp0_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_subpage_number;
	if (_tmp0_ == 0) {
		gint _tmp1_;
		_tmp1_ = self->priv->_page_number;
		tg_gui_set_page_number (self, _tmp1_ + 1);
	} else {
		gint _tmp2_;
		_tmp2_ = self->priv->_subpage_number;
		tg_gui_set_subpage_number (self, _tmp2_ + 1);
	}
	_tmp3_ = self->priv->_page_number;
	_tmp4_ = self->priv->_subpage_number;
	tg_gui_update_entry (self, _tmp3_, _tmp4_);
	tg_gui_get_the_page (self);
}


static void
tg_gui_on_prev_page (TgGui* self)
{
	gint _tmp0_;
	gint _tmp2_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_subpage_number;
	if (_tmp0_ > 0) {
		gint _tmp1_;
		_tmp1_ = self->priv->_subpage_number;
		tg_gui_set_subpage_number (self, _tmp1_ - 1);
	}
	_tmp2_ = self->priv->_subpage_number;
	if (_tmp2_ == 0) {
		gint _tmp3_;
		_tmp3_ = self->priv->_page_number;
		tg_gui_set_page_number (self, _tmp3_ - 1);
	}
	_tmp4_ = self->priv->_page_number;
	_tmp5_ = self->priv->_subpage_number;
	tg_gui_update_entry (self, _tmp4_, _tmp5_);
	tg_gui_get_the_page (self);
}


static void
tg_gui_on_home (TgGui* self)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	tg_gui_set_page_number (self, 100);
	tg_gui_set_subpage_number (self, 0);
	_tmp0_ = self->priv->_page_number;
	_tmp1_ = self->priv->_subpage_number;
	tg_gui_update_entry (self, _tmp0_, _tmp1_);
	tg_gui_get_the_page (self);
}


static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar* * unparsed)
{
	gint64 _vala_result = 0LL;
	const gchar* _vala_unparsed = NULL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, (guint) 0);
	endptr = _tmp0_;
	_vala_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
	if (unparsed) {
		*unparsed = _vala_unparsed;
	}
}


static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}


static gpointer
__int64_dup0 (gpointer self)
{
	return self ? _int64_dup (self) : NULL;
}


static void
tg_gui_on_goto_page (TgGui* self)
{
	gchar* entry_text = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** tokens = NULL;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint tokens_length1;
	gint _tokens_size_;
	gint64* new_page = NULL;
	gint64 new_subpage = 0LL;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gint64* _tmp18_;
	g_return_if_fail (self != NULL);
	self->priv->kb_status = TG_INPUT_STATUS_NEW;
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	entry_text = _tmp2_;
	_tmp3_ = entry_text;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "/", 2);
	tokens = _tmp5_;
	tokens_length1 = _vala_array_length (_tmp4_);
	_tokens_size_ = tokens_length1;
	new_page = NULL;
	new_subpage = (gint64) 0;
	_tmp6_ = tokens;
	_tmp6__length1 = tokens_length1;
	if (_tmp6__length1 >= 1) {
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gint64 _tmp9_ = 0LL;
		gboolean _tmp10_;
		gint64 _tmp11_;
		gint64* _tmp12_;
		_tmp7_ = tokens;
		_tmp7__length1 = tokens_length1;
		_tmp8_ = _tmp7_[0];
		_tmp10_ = int64_try_parse (_tmp8_, &_tmp9_, NULL);
		_g_free0 (new_page);
		_tmp11_ = _tmp9_;
		_tmp12_ = __int64_dup0 (&_tmp11_);
		new_page = _tmp12_;
		if (!_tmp10_) {
			_g_free0 (new_page);
			new_page = NULL;
		}
	}
	_tmp13_ = tokens;
	_tmp13__length1 = tokens_length1;
	if (_tmp13__length1 >= 2) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		const gchar* _tmp15_;
		gint64 _tmp16_ = 0LL;
		gboolean _tmp17_;
		_tmp14_ = tokens;
		_tmp14__length1 = tokens_length1;
		_tmp15_ = _tmp14_[1];
		_tmp17_ = int64_try_parse (_tmp15_, &_tmp16_, NULL);
		new_subpage = _tmp16_;
		if (!_tmp17_) {
			_g_free0 (new_page);
			new_page = NULL;
		}
	}
	_tmp18_ = new_page;
	if (_tmp18_ == NULL) {
		tg_gui_print_in_statusbar (self, _ ("Error in page entry"));
	} else {
		gint64* _tmp19_;
		gint64 _tmp20_;
		_tmp19_ = new_page;
		tg_gui_set_page_number (self, (gint) (*_tmp19_));
		_tmp20_ = new_subpage;
		tg_gui_set_subpage_number (self, (gint) _tmp20_);
		tg_gui_get_the_page (self);
	}
	_g_free0 (new_page);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (entry_text);
}


static gboolean
tg_gui_keyboard_timer (TgGui* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->kb_status = TG_INPUT_STATUS_NEW;
	_g_free0 (self->priv->kb_timer_id);
	self->priv->kb_timer_id = NULL;
	result = FALSE;
	return result;
}


static gboolean
_tg_gui_keyboard_timer_gsource_func (gpointer self)
{
	gboolean result;
	result = tg_gui_keyboard_timer ((TgGui*) self);
	return result;
}


static gboolean
tg_gui_on_keypress (TgGui* self,
                    GdkEventKey* event)
{
	gboolean result = FALSE;
	guint _tmp0_;
	GtkEntry* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	TgInputStatus _tmp7_;
	guint* _tmp9_;
	guint _tmp11_;
	guint* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->keyval;
	if (_tmp0_ == GDK_KEY_KP_Enter) {
		gint _tmp1_;
		gint _tmp2_;
		tg_gui_on_goto_page (self);
		_tmp1_ = self->priv->_page_number;
		_tmp2_ = self->priv->_subpage_number;
		tg_gui_update_entry (self, _tmp1_, _tmp2_);
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->entry;
	g_object_get ((GtkWidget*) _tmp3_, "is-focus", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		GtkEntry* _tmp6_;
		_tmp6_ = self->priv->entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
	}
	_tmp7_ = self->priv->kb_status;
	if (_tmp7_ == TG_INPUT_STATUS_NEW) {
		GtkEntry* _tmp8_;
		_tmp8_ = self->priv->entry;
		gtk_entry_set_text (_tmp8_, "");
	}
	_tmp9_ = self->priv->kb_timer_id;
	if (_tmp9_ != NULL) {
		guint* _tmp10_;
		_tmp10_ = self->priv->kb_timer_id;
		g_source_remove (*_tmp10_);
	}
	_tmp11_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) TG_kb_timeout, _tg_gui_keyboard_timer_gsource_func, g_object_ref (self), g_object_unref);
	_tmp12_ = __uint_dup0 (&_tmp11_);
	_g_free0 (self->priv->kb_timer_id);
	self->priv->kb_timer_id = _tmp12_;
	self->priv->kb_status = TG_INPUT_STATUS_CONTINUED;
	result = FALSE;
	return result;
}


gchar**
tg_gui_get_channel_children (TgGui* self,
                             int* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_channel_children;
	_tmp0__length1 = self->priv->_channel_children_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar**
_vala_array_dup1 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void
tg_gui_set_channel_children (TgGui* self,
                             gchar** value,
                             int value_length1)
{
	int old_value_length;
	g_return_if_fail (self != NULL);
	if (tg_gui_get_channel_children (self, &old_value_length) != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : ((gpointer) value);
		_tmp0__length1 = value_length1;
		self->priv->_channel_children = (_vala_array_free (self->priv->_channel_children, self->priv->_channel_children_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_channel_children = _tmp0_;
		self->priv->_channel_children_length1 = _tmp0__length1;
		self->priv->__channel_children_size_ = self->priv->_channel_children_length1;
		g_object_notify_by_pspec ((GObject *) self, tg_gui_properties[TG_GUI_CHANNEL_CHILDREN_PROPERTY]);
	}
}


const gchar*
tg_gui_get_current_channel_uuid (TgGui* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_channel_uuid;
	result = _tmp0_;
	return result;
}


void
tg_gui_set_current_channel_uuid (TgGui* self,
                                 const gchar* value)
{
	gchar* _tmp0_;
	TgChannel* channel = NULL;
	TgChannel* _tmp1_;
	TgChannel* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_current_channel_uuid);
	self->priv->_current_channel_uuid = _tmp0_;
	_tmp1_ = tg_gui_channel_find_by_uuid (self, value);
	channel = _tmp1_;
	_tmp2_ = channel;
	if (_tmp2_ != NULL) {
		TgChannel* _tmp3_;
		_tmp3_ = channel;
		tg_gui_channel_select (self, _tmp3_);
	}
	_g_object_unref0 (channel);
	g_object_notify_by_pspec ((GObject *) self, tg_gui_properties[TG_GUI_CURRENT_CHANNEL_UUID_PROPERTY]);
}


gint
tg_gui_get_zoom_factor (TgGui* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_zoom_factor;
	result = _tmp0_;
	return result;
}


void
tg_gui_set_zoom_factor (TgGui* self,
                        gint value)
{
	g_return_if_fail (self != NULL);
	if (tg_gui_get_zoom_factor (self) != value) {
		self->priv->_zoom_factor = value;
		g_object_notify_by_pspec ((GObject *) self, tg_gui_properties[TG_GUI_ZOOM_FACTOR_PROPERTY]);
	}
}


gboolean
tg_gui_get_paging_enabled (TgGui* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_paging_enabled;
	result = _tmp0_;
	return result;
}


void
tg_gui_set_paging_enabled (TgGui* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	if (tg_gui_get_paging_enabled (self) != value) {
		self->priv->_paging_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, tg_gui_properties[TG_GUI_PAGING_ENABLED_PROPERTY]);
	}
}


gint
tg_gui_get_paging_interval (TgGui* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_paging_interval;
	result = _tmp0_;
	return result;
}


void
tg_gui_set_paging_interval (TgGui* self,
                            gint value)
{
	g_return_if_fail (self != NULL);
	if (tg_gui_get_paging_interval (self) != value) {
		self->priv->_paging_interval = value;
		g_object_notify_by_pspec ((GObject *) self, tg_gui_properties[TG_GUI_PAGING_INTERVAL_PROPERTY]);
	}
}


gint
tg_gui_get_page_number (TgGui* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_page_number;
	result = _tmp0_;
	return result;
}


void
tg_gui_set_page_number (TgGui* self,
                        gint value)
{
	g_return_if_fail (self != NULL);
	if (tg_gui_get_page_number (self) != value) {
		self->priv->_page_number = value;
		g_object_notify_by_pspec ((GObject *) self, tg_gui_properties[TG_GUI_PAGE_NUMBER_PROPERTY]);
	}
}


gint
tg_gui_get_subpage_number (TgGui* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_subpage_number;
	result = _tmp0_;
	return result;
}


void
tg_gui_set_subpage_number (TgGui* self,
                           gint value)
{
	g_return_if_fail (self != NULL);
	if (tg_gui_get_subpage_number (self) != value) {
		self->priv->_subpage_number = value;
		g_object_notify_by_pspec ((GObject *) self, tg_gui_properties[TG_GUI_SUBPAGE_NUMBER_PROPERTY]);
	}
}


TgChannel*
tg_gui_get_current_channel (TgGui* self)
{
	TgChannel* result;
	TgChannel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_channel;
	result = _tmp0_;
	return result;
}


GtkWindow*
tg_gui_get_window (TgGui* self)
{
	GtkWindow* result;
	GtkWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}


static void
tg_gui_set_window (TgGui* self,
                   GtkWindow* value)
{
	g_return_if_fail (self != NULL);
	if (tg_gui_get_window (self) != value) {
		GtkWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tg_gui_properties[TG_GUI_WINDOW_PROPERTY]);
	}
}


static void
tg_gui_class_init (TgGuiClass * klass)
{
	tg_gui_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TgGui_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_tg_gui_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tg_gui_set_property;
	G_OBJECT_CLASS (klass)->finalize = tg_gui_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_CHANNEL_CHILDREN_PROPERTY, tg_gui_properties[TG_GUI_CHANNEL_CHILDREN_PROPERTY] = g_param_spec_boxed ("channel-children", "Channel children", "List of relative settings paths at which channels are stored", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_CURRENT_CHANNEL_UUID_PROPERTY, tg_gui_properties[TG_GUI_CURRENT_CHANNEL_UUID_PROPERTY] = g_param_spec_string ("current-channel-uuid", "Current channel", "Current channel", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_ZOOM_FACTOR_PROPERTY, tg_gui_properties[TG_GUI_ZOOM_FACTOR_PROPERTY] = g_param_spec_int ("zoom-factor", "Zoom factor", "Page zoom factor.  Larger numbers produce larger text.", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_PAGING_ENABLED_PROPERTY, tg_gui_properties[TG_GUI_PAGING_ENABLED_PROPERTY] = g_param_spec_boolean ("paging-enabled", "Paging enabled", "Automatically switch page at periodic intervals", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_PAGING_INTERVAL_PROPERTY, tg_gui_properties[TG_GUI_PAGING_INTERVAL_PROPERTY] = g_param_spec_int ("paging-interval", "Paging interval", "Specifies the interval for the auto-pager, in milliseconds.", G_MININT, G_MAXINT, 12000, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_PAGE_NUMBER_PROPERTY, tg_gui_properties[TG_GUI_PAGE_NUMBER_PROPERTY] = g_param_spec_int ("page-number", "Current page number", "Current page number", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_SUBPAGE_NUMBER_PROPERTY, tg_gui_properties[TG_GUI_SUBPAGE_NUMBER_PROPERTY] = g_param_spec_int ("subpage-number", "Current subpage number", "Current subpage number", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_CURRENT_CHANNEL_PROPERTY, tg_gui_properties[TG_GUI_CURRENT_CHANNEL_PROPERTY] = g_param_spec_object ("current-channel", "current-channel", "current-channel", TG_TYPE_CHANNEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_WINDOW_PROPERTY, tg_gui_properties[TG_GUI_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", gtk_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
tg_gui_instance_init (TgGui * self)
{
	self->priv = tg_gui_get_instance_private (self);
	self->priv->_zoom_factor = 1;
	self->priv->_paging_enabled = FALSE;
	self->priv->_paging_interval = 12000;
	self->priv->_page_number = -1;
	self->priv->_subpage_number = -1;
}


static void
tg_gui_finalize (GObject * obj)
{
	TgGui * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TG_TYPE_GUI, TgGui);
	self->priv->_channel_children = (_vala_array_free (self->priv->_channel_children, self->priv->_channel_children_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_current_channel_uuid);
	_g_object_unref0 (self->priv->_current_channel);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->_window);
	_g_object_unref0 (self->priv->entry);
	_g_object_unref0 (self->priv->pixpack);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->status_bar);
	_g_object_unref0 (self->priv->channel_menu);
	_g_object_unref0 (self->priv->settings);
	_g_free0 (self->priv->logo_timer_id);
	_g_free0 (self->priv->kb_timer_id);
	_g_free0 (self->priv->page_timer_id);
	(self->priv->channels == NULL) ? NULL : (self->priv->channels = (_g_slist_free__g_object_unref0_ (self->priv->channels), NULL));
	G_OBJECT_CLASS (tg_gui_parent_class)->finalize (obj);
}


GType
tg_gui_get_type (void)
{
	static volatile gsize tg_gui_type_id__volatile = 0;
	if (g_once_init_enter (&tg_gui_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TgGuiClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tg_gui_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TgGui), 0, (GInstanceInitFunc) tg_gui_instance_init, NULL };
		GType tg_gui_type_id;
		tg_gui_type_id = g_type_register_static (G_TYPE_OBJECT, "TgGui", &g_define_type_info, 0);
		TgGui_private_offset = g_type_add_instance_private (tg_gui_type_id, sizeof (TgGuiPrivate));
		g_once_init_leave (&tg_gui_type_id__volatile, tg_gui_type_id);
	}
	return tg_gui_type_id__volatile;
}


static void
_vala_tg_gui_get_property (GObject * object,
                           guint property_id,
                           GValue * value,
                           GParamSpec * pspec)
{
	TgGui * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TG_TYPE_GUI, TgGui);
	switch (property_id) {
		case TG_GUI_CHANNEL_CHILDREN_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, tg_gui_get_channel_children (self, &length));
		}
		break;
		case TG_GUI_CURRENT_CHANNEL_UUID_PROPERTY:
		g_value_set_string (value, tg_gui_get_current_channel_uuid (self));
		break;
		case TG_GUI_ZOOM_FACTOR_PROPERTY:
		g_value_set_int (value, tg_gui_get_zoom_factor (self));
		break;
		case TG_GUI_PAGING_ENABLED_PROPERTY:
		g_value_set_boolean (value, tg_gui_get_paging_enabled (self));
		break;
		case TG_GUI_PAGING_INTERVAL_PROPERTY:
		g_value_set_int (value, tg_gui_get_paging_interval (self));
		break;
		case TG_GUI_PAGE_NUMBER_PROPERTY:
		g_value_set_int (value, tg_gui_get_page_number (self));
		break;
		case TG_GUI_SUBPAGE_NUMBER_PROPERTY:
		g_value_set_int (value, tg_gui_get_subpage_number (self));
		break;
		case TG_GUI_CURRENT_CHANNEL_PROPERTY:
		g_value_set_object (value, tg_gui_get_current_channel (self));
		break;
		case TG_GUI_WINDOW_PROPERTY:
		g_value_set_object (value, tg_gui_get_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_tg_gui_set_property (GObject * object,
                           guint property_id,
                           const GValue * value,
                           GParamSpec * pspec)
{
	TgGui * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TG_TYPE_GUI, TgGui);
	switch (property_id) {
		case TG_GUI_CHANNEL_CHILDREN_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			tg_gui_set_channel_children (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case TG_GUI_CURRENT_CHANNEL_UUID_PROPERTY:
		tg_gui_set_current_channel_uuid (self, g_value_get_string (value));
		break;
		case TG_GUI_ZOOM_FACTOR_PROPERTY:
		tg_gui_set_zoom_factor (self, g_value_get_int (value));
		break;
		case TG_GUI_PAGING_ENABLED_PROPERTY:
		tg_gui_set_paging_enabled (self, g_value_get_boolean (value));
		break;
		case TG_GUI_PAGING_INTERVAL_PROPERTY:
		tg_gui_set_paging_interval (self, g_value_get_int (value));
		break;
		case TG_GUI_PAGE_NUMBER_PROPERTY:
		tg_gui_set_page_number (self, g_value_get_int (value));
		break;
		case TG_GUI_SUBPAGE_NUMBER_PROPERTY:
		tg_gui_set_subpage_number (self, g_value_get_int (value));
		break;
		case TG_GUI_WINDOW_PROPERTY:
		tg_gui_set_window (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



