/******************************************************************************
 * The MIT License (MIT)
 *
 * Copyright (c) 2018 Baldur Karlsson
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

#pragma once

// for GL on mac we need to define the functions we want to hook at compile time for dyld hooking to
// work, but this also means we can only hook functions that actually exist. Fortunately GL on mac
// is not a moving target, so we can define the list of functions in the latest version of macOS and
// as long as someone doesn't compile on an older version (old enough that some of these functions
// are missing) it will work.
//
// TL;DR: this is a *manually curated* list and must not be modified without understanding.

DECL_GL_HOOK_EXPORT(glAccum);
DECL_GL_HOOK_EXPORT(glActiveShaderProgram);
DECL_GL_HOOK_EXPORT(glActiveStencilFaceEXT);
DECL_GL_HOOK_EXPORT(glActiveTexture);
DECL_GL_HOOK_EXPORT(glActiveTextureARB);
DECL_GL_HOOK_EXPORT(glAlphaFunc);
DECL_GL_HOOK_EXPORT(glAreTexturesResident);
DECL_GL_HOOK_EXPORT(glArrayElement);
DECL_GL_HOOK_EXPORT(glAttachObjectARB);
DECL_GL_HOOK_EXPORT(glAttachShader);
DECL_GL_HOOK_EXPORT(glBegin);
DECL_GL_HOOK_EXPORT(glBeginConditionalRender);
DECL_GL_HOOK_EXPORT(glBeginConditionalRenderNV);
DECL_GL_HOOK_EXPORT(glBeginQuery);
DECL_GL_HOOK_EXPORT(glBeginQueryARB);
DECL_GL_HOOK_EXPORT(glBeginQueryIndexed);
DECL_GL_HOOK_EXPORT(glBeginTransformFeedback);
DECL_GL_HOOK_EXPORT(glBeginTransformFeedbackEXT);
DECL_GL_HOOK_EXPORT(glBindAttribLocation);
DECL_GL_HOOK_EXPORT(glBindAttribLocationARB);
DECL_GL_HOOK_EXPORT(glBindBuffer);
DECL_GL_HOOK_EXPORT(glBindBufferARB);
DECL_GL_HOOK_EXPORT(glBindBufferBase);
DECL_GL_HOOK_EXPORT(glBindBufferBaseEXT);
DECL_GL_HOOK_EXPORT(glBindBufferOffsetEXT);
DECL_GL_HOOK_EXPORT(glBindBufferRange);
DECL_GL_HOOK_EXPORT(glBindBufferRangeEXT);
DECL_GL_HOOK_EXPORT(glBindFragDataLocation);
DECL_GL_HOOK_EXPORT(glBindFragDataLocationEXT);
DECL_GL_HOOK_EXPORT(glBindFragDataLocationIndexed);
DECL_GL_HOOK_EXPORT(glBindFramebuffer);
DECL_GL_HOOK_EXPORT(glBindFramebufferEXT);
DECL_GL_HOOK_EXPORT(glBindProgramARB);
DECL_GL_HOOK_EXPORT(glBindProgramPipeline);
DECL_GL_HOOK_EXPORT(glBindRenderbuffer);
DECL_GL_HOOK_EXPORT(glBindRenderbufferEXT);
DECL_GL_HOOK_EXPORT(glBindSampler);
DECL_GL_HOOK_EXPORT(glBindTexture);
DECL_GL_HOOK_EXPORT(glBindTransformFeedback);
DECL_GL_HOOK_EXPORT(glBindVertexArray);
DECL_GL_HOOK_EXPORT(glBindVertexArrayAPPLE);
DECL_GL_HOOK_EXPORT(glBitmap);
DECL_GL_HOOK_EXPORT(glBlendColor);
DECL_GL_HOOK_EXPORT(glBlendColorEXT);
DECL_GL_HOOK_EXPORT(glBlendEquation);
DECL_GL_HOOK_EXPORT(glBlendEquationEXT);
DECL_GL_HOOK_EXPORT(glBlendEquationi);
DECL_GL_HOOK_EXPORT(glBlendEquationiARB);
DECL_GL_HOOK_EXPORT(glBlendEquationSeparate);
DECL_GL_HOOK_EXPORT(glBlendEquationSeparateEXT);
DECL_GL_HOOK_EXPORT(glBlendEquationSeparatei);
DECL_GL_HOOK_EXPORT(glBlendEquationSeparateiARB);
DECL_GL_HOOK_EXPORT(glBlendFunc);
DECL_GL_HOOK_EXPORT(glBlendFunci);
DECL_GL_HOOK_EXPORT(glBlendFunciARB);
DECL_GL_HOOK_EXPORT(glBlendFuncSeparate);
DECL_GL_HOOK_EXPORT(glBlendFuncSeparateEXT);
DECL_GL_HOOK_EXPORT(glBlendFuncSeparatei);
DECL_GL_HOOK_EXPORT(glBlendFuncSeparateiARB);
DECL_GL_HOOK_EXPORT(glBlitFramebuffer);
DECL_GL_HOOK_EXPORT(glBlitFramebufferEXT);
DECL_GL_HOOK_EXPORT(glBufferData);
DECL_GL_HOOK_EXPORT(glBufferDataARB);
DECL_GL_HOOK_EXPORT(glBufferParameteriAPPLE);
DECL_GL_HOOK_EXPORT(glBufferSubData);
DECL_GL_HOOK_EXPORT(glBufferSubDataARB);
DECL_GL_HOOK_EXPORT(glCallList);
DECL_GL_HOOK_EXPORT(glCallLists);
DECL_GL_HOOK_EXPORT(glCheckFramebufferStatus);
DECL_GL_HOOK_EXPORT(glCheckFramebufferStatusEXT);
DECL_GL_HOOK_EXPORT(glClampColor);
DECL_GL_HOOK_EXPORT(glClampColorARB);
DECL_GL_HOOK_EXPORT(glClear);
DECL_GL_HOOK_EXPORT(glClearAccum);
DECL_GL_HOOK_EXPORT(glClearBufferfi);
DECL_GL_HOOK_EXPORT(glClearBufferfv);
DECL_GL_HOOK_EXPORT(glClearBufferiv);
DECL_GL_HOOK_EXPORT(glClearBufferuiv);
DECL_GL_HOOK_EXPORT(glClearColor);
DECL_GL_HOOK_EXPORT(glClearColorIiEXT);
DECL_GL_HOOK_EXPORT(glClearColorIuiEXT);
DECL_GL_HOOK_EXPORT(glClearDepth);
DECL_GL_HOOK_EXPORT(glClearDepthf);
DECL_GL_HOOK_EXPORT(glClearIndex);
DECL_GL_HOOK_EXPORT(glClearStencil);
DECL_GL_HOOK_EXPORT(glClientActiveTexture);
DECL_GL_HOOK_EXPORT(glClientActiveTextureARB);
DECL_GL_HOOK_EXPORT(glClientWaitSync);
DECL_GL_HOOK_EXPORT(glClipPlane);
DECL_GL_HOOK_EXPORT(glColor3b);
DECL_GL_HOOK_EXPORT(glColor3bv);
DECL_GL_HOOK_EXPORT(glColor3d);
DECL_GL_HOOK_EXPORT(glColor3dv);
DECL_GL_HOOK_EXPORT(glColor3f);
DECL_GL_HOOK_EXPORT(glColor3fv);
DECL_GL_HOOK_EXPORT(glColor3i);
DECL_GL_HOOK_EXPORT(glColor3iv);
DECL_GL_HOOK_EXPORT(glColor3s);
DECL_GL_HOOK_EXPORT(glColor3sv);
DECL_GL_HOOK_EXPORT(glColor3ub);
DECL_GL_HOOK_EXPORT(glColor3ubv);
DECL_GL_HOOK_EXPORT(glColor3ui);
DECL_GL_HOOK_EXPORT(glColor3uiv);
DECL_GL_HOOK_EXPORT(glColor3us);
DECL_GL_HOOK_EXPORT(glColor3usv);
DECL_GL_HOOK_EXPORT(glColor4b);
DECL_GL_HOOK_EXPORT(glColor4bv);
DECL_GL_HOOK_EXPORT(glColor4d);
DECL_GL_HOOK_EXPORT(glColor4dv);
DECL_GL_HOOK_EXPORT(glColor4f);
DECL_GL_HOOK_EXPORT(glColor4fv);
DECL_GL_HOOK_EXPORT(glColor4i);
DECL_GL_HOOK_EXPORT(glColor4iv);
DECL_GL_HOOK_EXPORT(glColor4s);
DECL_GL_HOOK_EXPORT(glColor4sv);
DECL_GL_HOOK_EXPORT(glColor4ub);
DECL_GL_HOOK_EXPORT(glColor4ubv);
DECL_GL_HOOK_EXPORT(glColor4ui);
DECL_GL_HOOK_EXPORT(glColor4uiv);
DECL_GL_HOOK_EXPORT(glColor4us);
DECL_GL_HOOK_EXPORT(glColor4usv);
DECL_GL_HOOK_EXPORT(glColorMask);
DECL_GL_HOOK_EXPORT(glColorMaski);
DECL_GL_HOOK_EXPORT(glColorMaskIndexedEXT);
DECL_GL_HOOK_EXPORT(glColorMaterial);
DECL_GL_HOOK_EXPORT(glColorPointer);
DECL_GL_HOOK_EXPORT(glColorSubTable);
DECL_GL_HOOK_EXPORT(glColorSubTableEXT);
DECL_GL_HOOK_EXPORT(glColorTable);
DECL_GL_HOOK_EXPORT(glColorTableEXT);
DECL_GL_HOOK_EXPORT(glColorTableParameterfv);
DECL_GL_HOOK_EXPORT(glColorTableParameteriv);
DECL_GL_HOOK_EXPORT(glCombinerInputNV);
DECL_GL_HOOK_EXPORT(glCombinerOutputNV);
DECL_GL_HOOK_EXPORT(glCombinerParameterfNV);
DECL_GL_HOOK_EXPORT(glCombinerParameterfvNV);
DECL_GL_HOOK_EXPORT(glCombinerParameteriNV);
DECL_GL_HOOK_EXPORT(glCombinerParameterivNV);
DECL_GL_HOOK_EXPORT(glCombinerStageParameterfvNV);
DECL_GL_HOOK_EXPORT(glCompileShader);
DECL_GL_HOOK_EXPORT(glCompileShaderARB);
DECL_GL_HOOK_EXPORT(glCompileShaderIncludeARB);
DECL_GL_HOOK_EXPORT(glCompressedTexImage1D);
DECL_GL_HOOK_EXPORT(glCompressedTexImage1DARB);
DECL_GL_HOOK_EXPORT(glCompressedTexImage2D);
DECL_GL_HOOK_EXPORT(glCompressedTexImage2DARB);
DECL_GL_HOOK_EXPORT(glCompressedTexImage3D);
DECL_GL_HOOK_EXPORT(glCompressedTexImage3DARB);
DECL_GL_HOOK_EXPORT(glCompressedTexSubImage1D);
DECL_GL_HOOK_EXPORT(glCompressedTexSubImage1DARB);
DECL_GL_HOOK_EXPORT(glCompressedTexSubImage2D);
DECL_GL_HOOK_EXPORT(glCompressedTexSubImage2DARB);
DECL_GL_HOOK_EXPORT(glCompressedTexSubImage3D);
DECL_GL_HOOK_EXPORT(glCompressedTexSubImage3DARB);
DECL_GL_HOOK_EXPORT(glConvolutionFilter1D);
DECL_GL_HOOK_EXPORT(glConvolutionFilter2D);
DECL_GL_HOOK_EXPORT(glConvolutionParameterf);
DECL_GL_HOOK_EXPORT(glConvolutionParameterfv);
DECL_GL_HOOK_EXPORT(glConvolutionParameteri);
DECL_GL_HOOK_EXPORT(glConvolutionParameteriv);
DECL_GL_HOOK_EXPORT(glCopyBufferSubData);
DECL_GL_HOOK_EXPORT(glCopyColorSubTable);
DECL_GL_HOOK_EXPORT(glCopyColorTable);
DECL_GL_HOOK_EXPORT(glCopyConvolutionFilter1D);
DECL_GL_HOOK_EXPORT(glCopyConvolutionFilter2D);
DECL_GL_HOOK_EXPORT(glCopyPixels);
DECL_GL_HOOK_EXPORT(glCopyTexImage1D);
DECL_GL_HOOK_EXPORT(glCopyTexImage2D);
DECL_GL_HOOK_EXPORT(glCopyTexSubImage1D);
DECL_GL_HOOK_EXPORT(glCopyTexSubImage2D);
DECL_GL_HOOK_EXPORT(glCopyTexSubImage3D);
DECL_GL_HOOK_EXPORT(glCreateProgram);
DECL_GL_HOOK_EXPORT(glCreateProgramObjectARB);
DECL_GL_HOOK_EXPORT(glCreateShader);
DECL_GL_HOOK_EXPORT(glCreateShaderObjectARB);
DECL_GL_HOOK_EXPORT(glCreateShaderProgramv);
DECL_GL_HOOK_EXPORT(glCullFace);
DECL_GL_HOOK_EXPORT(glDeleteBuffers);
DECL_GL_HOOK_EXPORT(glDeleteBuffersARB);
DECL_GL_HOOK_EXPORT(glDeleteFencesAPPLE);
DECL_GL_HOOK_EXPORT(glDeleteFramebuffers);
DECL_GL_HOOK_EXPORT(glDeleteFramebuffersEXT);
DECL_GL_HOOK_EXPORT(glDeleteLists);
DECL_GL_HOOK_EXPORT(glDeleteNamedStringARB);
DECL_GL_HOOK_EXPORT(glDeleteObjectARB);
DECL_GL_HOOK_EXPORT(glDeleteProgram);
DECL_GL_HOOK_EXPORT(glDeleteProgramPipelines);
DECL_GL_HOOK_EXPORT(glDeleteProgramsARB);
DECL_GL_HOOK_EXPORT(glDeleteQueries);
DECL_GL_HOOK_EXPORT(glDeleteQueriesARB);
DECL_GL_HOOK_EXPORT(glDeleteRenderbuffers);
DECL_GL_HOOK_EXPORT(glDeleteRenderbuffersEXT);
DECL_GL_HOOK_EXPORT(glDeleteSamplers);
DECL_GL_HOOK_EXPORT(glDeleteShader);
DECL_GL_HOOK_EXPORT(glDeleteSync);
DECL_GL_HOOK_EXPORT(glDeleteTextures);
DECL_GL_HOOK_EXPORT(glDeleteTransformFeedbacks);
DECL_GL_HOOK_EXPORT(glDeleteVertexArrays);
DECL_GL_HOOK_EXPORT(glDeleteVertexArraysAPPLE);
DECL_GL_HOOK_EXPORT(glDepthBoundsEXT);
DECL_GL_HOOK_EXPORT(glDepthFunc);
DECL_GL_HOOK_EXPORT(glDepthMask);
DECL_GL_HOOK_EXPORT(glDepthRange);
DECL_GL_HOOK_EXPORT(glDepthRangeArrayv);
DECL_GL_HOOK_EXPORT(glDepthRangef);
DECL_GL_HOOK_EXPORT(glDepthRangeIndexed);
DECL_GL_HOOK_EXPORT(glDetachObjectARB);
DECL_GL_HOOK_EXPORT(glDetachShader);
DECL_GL_HOOK_EXPORT(glDisable);
DECL_GL_HOOK_EXPORT(glDisableClientState);
DECL_GL_HOOK_EXPORT(glDisablei);
DECL_GL_HOOK_EXPORT(glDisableIndexedEXT);
DECL_GL_HOOK_EXPORT(glDisableVertexAttribAPPLE);
DECL_GL_HOOK_EXPORT(glDisableVertexAttribArray);
DECL_GL_HOOK_EXPORT(glDisableVertexAttribArrayARB);
DECL_GL_HOOK_EXPORT(glDrawArrays);
DECL_GL_HOOK_EXPORT(glDrawArraysIndirect);
DECL_GL_HOOK_EXPORT(glDrawArraysInstanced);
DECL_GL_HOOK_EXPORT(glDrawArraysInstancedARB);
DECL_GL_HOOK_EXPORT(glDrawBuffer);
DECL_GL_HOOK_EXPORT(glDrawBuffers);
DECL_GL_HOOK_EXPORT(glDrawBuffersARB);
DECL_GL_HOOK_EXPORT(glDrawElementArrayAPPLE);
DECL_GL_HOOK_EXPORT(glDrawElements);
DECL_GL_HOOK_EXPORT(glDrawElementsBaseVertex);
DECL_GL_HOOK_EXPORT(glDrawElementsIndirect);
DECL_GL_HOOK_EXPORT(glDrawElementsInstanced);
DECL_GL_HOOK_EXPORT(glDrawElementsInstancedARB);
DECL_GL_HOOK_EXPORT(glDrawElementsInstancedBaseVertex);
DECL_GL_HOOK_EXPORT(glDrawPixels);
DECL_GL_HOOK_EXPORT(glDrawRangeElementArrayAPPLE);
DECL_GL_HOOK_EXPORT(glDrawRangeElements);
DECL_GL_HOOK_EXPORT(glDrawRangeElementsBaseVertex);
DECL_GL_HOOK_EXPORT(glDrawRangeElementsEXT);
DECL_GL_HOOK_EXPORT(glDrawTransformFeedback);
DECL_GL_HOOK_EXPORT(glDrawTransformFeedbackStream);
DECL_GL_HOOK_EXPORT(glEdgeFlag);
DECL_GL_HOOK_EXPORT(glEdgeFlagPointer);
DECL_GL_HOOK_EXPORT(glEdgeFlagv);
DECL_GL_HOOK_EXPORT(glElementPointerAPPLE);
DECL_GL_HOOK_EXPORT(glEnable);
DECL_GL_HOOK_EXPORT(glEnableClientState);
DECL_GL_HOOK_EXPORT(glEnablei);
DECL_GL_HOOK_EXPORT(glEnableIndexedEXT);
DECL_GL_HOOK_EXPORT(glEnableVertexAttribAPPLE);
DECL_GL_HOOK_EXPORT(glEnableVertexAttribArray);
DECL_GL_HOOK_EXPORT(glEnableVertexAttribArrayARB);
DECL_GL_HOOK_EXPORT(glEnd);
DECL_GL_HOOK_EXPORT(glEndConditionalRender);
DECL_GL_HOOK_EXPORT(glEndConditionalRenderNV);
DECL_GL_HOOK_EXPORT(glEndList);
DECL_GL_HOOK_EXPORT(glEndQuery);
DECL_GL_HOOK_EXPORT(glEndQueryARB);
DECL_GL_HOOK_EXPORT(glEndQueryIndexed);
DECL_GL_HOOK_EXPORT(glEndTransformFeedback);
DECL_GL_HOOK_EXPORT(glEndTransformFeedbackEXT);
DECL_GL_HOOK_EXPORT(glEvalCoord1d);
DECL_GL_HOOK_EXPORT(glEvalCoord1dv);
DECL_GL_HOOK_EXPORT(glEvalCoord1f);
DECL_GL_HOOK_EXPORT(glEvalCoord1fv);
DECL_GL_HOOK_EXPORT(glEvalCoord2d);
DECL_GL_HOOK_EXPORT(glEvalCoord2dv);
DECL_GL_HOOK_EXPORT(glEvalCoord2f);
DECL_GL_HOOK_EXPORT(glEvalCoord2fv);
DECL_GL_HOOK_EXPORT(glEvalMesh1);
DECL_GL_HOOK_EXPORT(glEvalMesh2);
DECL_GL_HOOK_EXPORT(glEvalPoint1);
DECL_GL_HOOK_EXPORT(glEvalPoint2);
DECL_GL_HOOK_EXPORT(glFeedbackBuffer);
DECL_GL_HOOK_EXPORT(glFenceSync);
DECL_GL_HOOK_EXPORT(glFinalCombinerInputNV);
DECL_GL_HOOK_EXPORT(glFinish);
DECL_GL_HOOK_EXPORT(glFinishFenceAPPLE);
DECL_GL_HOOK_EXPORT(glFinishObjectAPPLE);
DECL_GL_HOOK_EXPORT(glFlush);
DECL_GL_HOOK_EXPORT(glFlushMappedBufferRange);
DECL_GL_HOOK_EXPORT(glFlushMappedBufferRangeAPPLE);
DECL_GL_HOOK_EXPORT(glFlushVertexArrayRangeAPPLE);
DECL_GL_HOOK_EXPORT(glFogCoordd);
DECL_GL_HOOK_EXPORT(glFogCoorddEXT);
DECL_GL_HOOK_EXPORT(glFogCoorddv);
DECL_GL_HOOK_EXPORT(glFogCoorddvEXT);
DECL_GL_HOOK_EXPORT(glFogCoordf);
DECL_GL_HOOK_EXPORT(glFogCoordfEXT);
DECL_GL_HOOK_EXPORT(glFogCoordfv);
DECL_GL_HOOK_EXPORT(glFogCoordfvEXT);
DECL_GL_HOOK_EXPORT(glFogCoordPointer);
DECL_GL_HOOK_EXPORT(glFogCoordPointerEXT);
DECL_GL_HOOK_EXPORT(glFogf);
DECL_GL_HOOK_EXPORT(glFogfv);
DECL_GL_HOOK_EXPORT(glFogi);
DECL_GL_HOOK_EXPORT(glFogiv);
DECL_GL_HOOK_EXPORT(glFramebufferRenderbuffer);
DECL_GL_HOOK_EXPORT(glFramebufferRenderbufferEXT);
DECL_GL_HOOK_EXPORT(glFramebufferTexture);
DECL_GL_HOOK_EXPORT(glFramebufferTexture1D);
DECL_GL_HOOK_EXPORT(glFramebufferTexture1DEXT);
DECL_GL_HOOK_EXPORT(glFramebufferTexture2D);
DECL_GL_HOOK_EXPORT(glFramebufferTexture2DEXT);
DECL_GL_HOOK_EXPORT(glFramebufferTexture3D);
DECL_GL_HOOK_EXPORT(glFramebufferTexture3DEXT);
DECL_GL_HOOK_EXPORT(glFramebufferTextureEXT);
DECL_GL_HOOK_EXPORT(glFramebufferTextureFaceEXT);
DECL_GL_HOOK_EXPORT(glFramebufferTextureLayer);
DECL_GL_HOOK_EXPORT(glFramebufferTextureLayerEXT);
DECL_GL_HOOK_EXPORT(glFrontFace);
DECL_GL_HOOK_EXPORT(glFrustum);
DECL_GL_HOOK_EXPORT(glGenBuffers);
DECL_GL_HOOK_EXPORT(glGenBuffersARB);
DECL_GL_HOOK_EXPORT(glGenerateMipmap);
DECL_GL_HOOK_EXPORT(glGenerateMipmapEXT);
DECL_GL_HOOK_EXPORT(glGenFencesAPPLE);
DECL_GL_HOOK_EXPORT(glGenFramebuffers);
DECL_GL_HOOK_EXPORT(glGenFramebuffersEXT);
DECL_GL_HOOK_EXPORT(glGenLists);
DECL_GL_HOOK_EXPORT(glGenProgramPipelines);
DECL_GL_HOOK_EXPORT(glGenProgramsARB);
DECL_GL_HOOK_EXPORT(glGenQueries);
DECL_GL_HOOK_EXPORT(glGenQueriesARB);
DECL_GL_HOOK_EXPORT(glGenRenderbuffers);
DECL_GL_HOOK_EXPORT(glGenRenderbuffersEXT);
DECL_GL_HOOK_EXPORT(glGenSamplers);
DECL_GL_HOOK_EXPORT(glGenTextures);
DECL_GL_HOOK_EXPORT(glGenTransformFeedbacks);
DECL_GL_HOOK_EXPORT(glGenVertexArrays);
DECL_GL_HOOK_EXPORT(glGenVertexArraysAPPLE);
DECL_GL_HOOK_EXPORT(glGetActiveAttrib);
DECL_GL_HOOK_EXPORT(glGetActiveAttribARB);
DECL_GL_HOOK_EXPORT(glGetActiveSubroutineName);
DECL_GL_HOOK_EXPORT(glGetActiveSubroutineUniformiv);
DECL_GL_HOOK_EXPORT(glGetActiveSubroutineUniformName);
DECL_GL_HOOK_EXPORT(glGetActiveUniform);
DECL_GL_HOOK_EXPORT(glGetActiveUniformARB);
DECL_GL_HOOK_EXPORT(glGetActiveUniformBlockiv);
DECL_GL_HOOK_EXPORT(glGetActiveUniformBlockName);
DECL_GL_HOOK_EXPORT(glGetActiveUniformName);
DECL_GL_HOOK_EXPORT(glGetActiveUniformsiv);
DECL_GL_HOOK_EXPORT(glGetAttachedObjectsARB);
DECL_GL_HOOK_EXPORT(glGetAttachedShaders);
DECL_GL_HOOK_EXPORT(glGetAttribLocation);
DECL_GL_HOOK_EXPORT(glGetAttribLocationARB);
DECL_GL_HOOK_EXPORT(glGetBooleani_v);
DECL_GL_HOOK_EXPORT(glGetBooleanIndexedvEXT);
DECL_GL_HOOK_EXPORT(glGetBooleanv);
DECL_GL_HOOK_EXPORT(glGetBufferParameteri64v);
DECL_GL_HOOK_EXPORT(glGetBufferParameteriv);
DECL_GL_HOOK_EXPORT(glGetBufferParameterivARB);
DECL_GL_HOOK_EXPORT(glGetBufferPointerv);
DECL_GL_HOOK_EXPORT(glGetBufferPointervARB);
DECL_GL_HOOK_EXPORT(glGetBufferSubData);
DECL_GL_HOOK_EXPORT(glGetBufferSubDataARB);
DECL_GL_HOOK_EXPORT(glGetClipPlane);
DECL_GL_HOOK_EXPORT(glGetColorTable);
DECL_GL_HOOK_EXPORT(glGetColorTableEXT);
DECL_GL_HOOK_EXPORT(glGetColorTableParameterfv);
DECL_GL_HOOK_EXPORT(glGetColorTableParameterfvEXT);
DECL_GL_HOOK_EXPORT(glGetColorTableParameteriv);
DECL_GL_HOOK_EXPORT(glGetColorTableParameterivEXT);
DECL_GL_HOOK_EXPORT(glGetCombinerInputParameterfvNV);
DECL_GL_HOOK_EXPORT(glGetCombinerInputParameterivNV);
DECL_GL_HOOK_EXPORT(glGetCombinerOutputParameterfvNV);
DECL_GL_HOOK_EXPORT(glGetCombinerOutputParameterivNV);
DECL_GL_HOOK_EXPORT(glGetCombinerStageParameterfvNV);
DECL_GL_HOOK_EXPORT(glGetCompressedTexImage);
DECL_GL_HOOK_EXPORT(glGetCompressedTexImageARB);
DECL_GL_HOOK_EXPORT(glGetConvolutionFilter);
DECL_GL_HOOK_EXPORT(glGetConvolutionParameterfv);
DECL_GL_HOOK_EXPORT(glGetConvolutionParameteriv);
DECL_GL_HOOK_EXPORT(glGetDoublei_v);
DECL_GL_HOOK_EXPORT(glGetDoublev);
DECL_GL_HOOK_EXPORT(glGetError);
DECL_GL_HOOK_EXPORT(glGetFinalCombinerInputParameterfvNV);
DECL_GL_HOOK_EXPORT(glGetFinalCombinerInputParameterivNV);
DECL_GL_HOOK_EXPORT(glGetFloati_v);
DECL_GL_HOOK_EXPORT(glGetFloatv);
DECL_GL_HOOK_EXPORT(glGetFragDataIndex);
DECL_GL_HOOK_EXPORT(glGetFragDataLocation);
DECL_GL_HOOK_EXPORT(glGetFragDataLocationEXT);
DECL_GL_HOOK_EXPORT(glGetFramebufferAttachmentParameteriv);
DECL_GL_HOOK_EXPORT(glGetFramebufferAttachmentParameterivEXT);
DECL_GL_HOOK_EXPORT(glGetHandleARB);
DECL_GL_HOOK_EXPORT(glGetHistogram);
DECL_GL_HOOK_EXPORT(glGetHistogramParameterfv);
DECL_GL_HOOK_EXPORT(glGetHistogramParameteriv);
DECL_GL_HOOK_EXPORT(glGetInfoLogARB);
DECL_GL_HOOK_EXPORT(glGetInteger64i_v);
DECL_GL_HOOK_EXPORT(glGetInteger64v);
DECL_GL_HOOK_EXPORT(glGetIntegeri_v);
DECL_GL_HOOK_EXPORT(glGetIntegerIndexedvEXT);
DECL_GL_HOOK_EXPORT(glGetIntegerv);
DECL_GL_HOOK_EXPORT(glGetInternalformativ);
DECL_GL_HOOK_EXPORT(glGetLightfv);
DECL_GL_HOOK_EXPORT(glGetLightiv);
DECL_GL_HOOK_EXPORT(glGetMapdv);
DECL_GL_HOOK_EXPORT(glGetMapfv);
DECL_GL_HOOK_EXPORT(glGetMapiv);
DECL_GL_HOOK_EXPORT(glGetMaterialfv);
DECL_GL_HOOK_EXPORT(glGetMaterialiv);
DECL_GL_HOOK_EXPORT(glGetMinmax);
DECL_GL_HOOK_EXPORT(glGetMinmaxParameterfv);
DECL_GL_HOOK_EXPORT(glGetMinmaxParameteriv);
DECL_GL_HOOK_EXPORT(glGetMultisamplefv);
DECL_GL_HOOK_EXPORT(glGetNamedStringARB);
DECL_GL_HOOK_EXPORT(glGetNamedStringivARB);
DECL_GL_HOOK_EXPORT(glGetObjectLabelEXT);
DECL_GL_HOOK_EXPORT(glGetObjectParameterfvARB);
DECL_GL_HOOK_EXPORT(glGetObjectParameterivAPPLE);
DECL_GL_HOOK_EXPORT(glGetObjectParameterivARB);
DECL_GL_HOOK_EXPORT(glGetPixelMapfv);
DECL_GL_HOOK_EXPORT(glGetPixelMapuiv);
DECL_GL_HOOK_EXPORT(glGetPixelMapusv);
DECL_GL_HOOK_EXPORT(glGetPointerv);
DECL_GL_HOOK_EXPORT(glGetPolygonStipple);
DECL_GL_HOOK_EXPORT(glGetProgramBinary);
DECL_GL_HOOK_EXPORT(glGetProgramEnvParameterdvARB);
DECL_GL_HOOK_EXPORT(glGetProgramEnvParameterfvARB);
DECL_GL_HOOK_EXPORT(glGetProgramInfoLog);
DECL_GL_HOOK_EXPORT(glGetProgramiv);
DECL_GL_HOOK_EXPORT(glGetProgramivARB);
DECL_GL_HOOK_EXPORT(glGetProgramLocalParameterdvARB);
DECL_GL_HOOK_EXPORT(glGetProgramLocalParameterfvARB);
DECL_GL_HOOK_EXPORT(glGetProgramPipelineInfoLog);
DECL_GL_HOOK_EXPORT(glGetProgramPipelineiv);
DECL_GL_HOOK_EXPORT(glGetProgramStageiv);
DECL_GL_HOOK_EXPORT(glGetProgramStringARB);
DECL_GL_HOOK_EXPORT(glGetQueryIndexediv);
DECL_GL_HOOK_EXPORT(glGetQueryiv);
DECL_GL_HOOK_EXPORT(glGetQueryivARB);
DECL_GL_HOOK_EXPORT(glGetQueryObjecti64v);
DECL_GL_HOOK_EXPORT(glGetQueryObjecti64vEXT);
DECL_GL_HOOK_EXPORT(glGetQueryObjectiv);
DECL_GL_HOOK_EXPORT(glGetQueryObjectivARB);
DECL_GL_HOOK_EXPORT(glGetQueryObjectui64v);
DECL_GL_HOOK_EXPORT(glGetQueryObjectui64vEXT);
DECL_GL_HOOK_EXPORT(glGetQueryObjectuiv);
DECL_GL_HOOK_EXPORT(glGetQueryObjectuivARB);
DECL_GL_HOOK_EXPORT(glGetRenderbufferParameteriv);
DECL_GL_HOOK_EXPORT(glGetRenderbufferParameterivEXT);
DECL_GL_HOOK_EXPORT(glGetSamplerParameterfv);
DECL_GL_HOOK_EXPORT(glGetSamplerParameterIiv);
DECL_GL_HOOK_EXPORT(glGetSamplerParameterIuiv);
DECL_GL_HOOK_EXPORT(glGetSamplerParameteriv);
DECL_GL_HOOK_EXPORT(glGetSeparableFilter);
DECL_GL_HOOK_EXPORT(glGetShaderInfoLog);
DECL_GL_HOOK_EXPORT(glGetShaderiv);
DECL_GL_HOOK_EXPORT(glGetShaderPrecisionFormat);
DECL_GL_HOOK_EXPORT(glGetShaderSource);
DECL_GL_HOOK_EXPORT(glGetShaderSourceARB);
DECL_GL_HOOK_EXPORT(glGetString);
DECL_GL_HOOK_EXPORT(glGetStringi);
DECL_GL_HOOK_EXPORT(glGetSubroutineIndex);
DECL_GL_HOOK_EXPORT(glGetSubroutineUniformLocation);
DECL_GL_HOOK_EXPORT(glGetSynciv);
DECL_GL_HOOK_EXPORT(glGetTexEnvfv);
DECL_GL_HOOK_EXPORT(glGetTexEnviv);
DECL_GL_HOOK_EXPORT(glGetTexGendv);
DECL_GL_HOOK_EXPORT(glGetTexGenfv);
DECL_GL_HOOK_EXPORT(glGetTexGeniv);
DECL_GL_HOOK_EXPORT(glGetTexImage);
DECL_GL_HOOK_EXPORT(glGetTexLevelParameterfv);
DECL_GL_HOOK_EXPORT(glGetTexLevelParameteriv);
DECL_GL_HOOK_EXPORT(glGetTexParameterfv);
DECL_GL_HOOK_EXPORT(glGetTexParameterIiv);
DECL_GL_HOOK_EXPORT(glGetTexParameterIivEXT);
DECL_GL_HOOK_EXPORT(glGetTexParameterIuiv);
DECL_GL_HOOK_EXPORT(glGetTexParameterIuivEXT);
DECL_GL_HOOK_EXPORT(glGetTexParameteriv);
DECL_GL_HOOK_EXPORT(glGetTexParameterPointervAPPLE);
DECL_GL_HOOK_EXPORT(glGetTransformFeedbackVarying);
DECL_GL_HOOK_EXPORT(glGetTransformFeedbackVaryingEXT);
DECL_GL_HOOK_EXPORT(glGetUniformBlockIndex);
DECL_GL_HOOK_EXPORT(glGetUniformBufferSizeEXT);
DECL_GL_HOOK_EXPORT(glGetUniformdv);
DECL_GL_HOOK_EXPORT(glGetUniformfv);
DECL_GL_HOOK_EXPORT(glGetUniformfvARB);
DECL_GL_HOOK_EXPORT(glGetUniformIndices);
DECL_GL_HOOK_EXPORT(glGetUniformiv);
DECL_GL_HOOK_EXPORT(glGetUniformivARB);
DECL_GL_HOOK_EXPORT(glGetUniformLocation);
DECL_GL_HOOK_EXPORT(glGetUniformLocationARB);
DECL_GL_HOOK_EXPORT(glGetUniformOffsetEXT);
DECL_GL_HOOK_EXPORT(glGetUniformSubroutineuiv);
DECL_GL_HOOK_EXPORT(glGetUniformuiv);
DECL_GL_HOOK_EXPORT(glGetUniformuivEXT);
DECL_GL_HOOK_EXPORT(glGetVertexAttribdv);
DECL_GL_HOOK_EXPORT(glGetVertexAttribdvARB);
DECL_GL_HOOK_EXPORT(glGetVertexAttribfv);
DECL_GL_HOOK_EXPORT(glGetVertexAttribfvARB);
DECL_GL_HOOK_EXPORT(glGetVertexAttribIiv);
DECL_GL_HOOK_EXPORT(glGetVertexAttribIivEXT);
DECL_GL_HOOK_EXPORT(glGetVertexAttribIuiv);
DECL_GL_HOOK_EXPORT(glGetVertexAttribIuivEXT);
DECL_GL_HOOK_EXPORT(glGetVertexAttribiv);
DECL_GL_HOOK_EXPORT(glGetVertexAttribivARB);
DECL_GL_HOOK_EXPORT(glGetVertexAttribLdv);
DECL_GL_HOOK_EXPORT(glGetVertexAttribPointerv);
DECL_GL_HOOK_EXPORT(glGetVertexAttribPointervARB);
DECL_GL_HOOK_EXPORT(glHint);
DECL_GL_HOOK_EXPORT(glHistogram);
DECL_GL_HOOK_EXPORT(glIndexd);
DECL_GL_HOOK_EXPORT(glIndexdv);
DECL_GL_HOOK_EXPORT(glIndexf);
DECL_GL_HOOK_EXPORT(glIndexfv);
DECL_GL_HOOK_EXPORT(glIndexi);
DECL_GL_HOOK_EXPORT(glIndexiv);
DECL_GL_HOOK_EXPORT(glIndexMask);
DECL_GL_HOOK_EXPORT(glIndexPointer);
DECL_GL_HOOK_EXPORT(glIndexs);
DECL_GL_HOOK_EXPORT(glIndexsv);
DECL_GL_HOOK_EXPORT(glIndexub);
DECL_GL_HOOK_EXPORT(glIndexubv);
DECL_GL_HOOK_EXPORT(glInitNames);
DECL_GL_HOOK_EXPORT(glInsertEventMarkerEXT);
DECL_GL_HOOK_EXPORT(glInterleavedArrays);
DECL_GL_HOOK_EXPORT(glIsBuffer);
DECL_GL_HOOK_EXPORT(glIsBufferARB);
DECL_GL_HOOK_EXPORT(glIsEnabled);
DECL_GL_HOOK_EXPORT(glIsEnabledi);
DECL_GL_HOOK_EXPORT(glIsEnabledIndexedEXT);
DECL_GL_HOOK_EXPORT(glIsFenceAPPLE);
DECL_GL_HOOK_EXPORT(glIsFramebuffer);
DECL_GL_HOOK_EXPORT(glIsFramebufferEXT);
DECL_GL_HOOK_EXPORT(glIsList);
DECL_GL_HOOK_EXPORT(glIsNamedStringARB);
DECL_GL_HOOK_EXPORT(glIsProgram);
DECL_GL_HOOK_EXPORT(glIsProgramARB);
DECL_GL_HOOK_EXPORT(glIsProgramPipeline);
DECL_GL_HOOK_EXPORT(glIsQuery);
DECL_GL_HOOK_EXPORT(glIsQueryARB);
DECL_GL_HOOK_EXPORT(glIsRenderbuffer);
DECL_GL_HOOK_EXPORT(glIsRenderbufferEXT);
DECL_GL_HOOK_EXPORT(glIsSampler);
DECL_GL_HOOK_EXPORT(glIsShader);
DECL_GL_HOOK_EXPORT(glIsSync);
DECL_GL_HOOK_EXPORT(glIsTexture);
DECL_GL_HOOK_EXPORT(glIsTransformFeedback);
DECL_GL_HOOK_EXPORT(glIsVertexArray);
DECL_GL_HOOK_EXPORT(glIsVertexArrayAPPLE);
DECL_GL_HOOK_EXPORT(glIsVertexAttribEnabledAPPLE);
DECL_GL_HOOK_EXPORT(glLabelObjectEXT);
DECL_GL_HOOK_EXPORT(glLightf);
DECL_GL_HOOK_EXPORT(glLightfv);
DECL_GL_HOOK_EXPORT(glLighti);
DECL_GL_HOOK_EXPORT(glLightiv);
DECL_GL_HOOK_EXPORT(glLightModelf);
DECL_GL_HOOK_EXPORT(glLightModelfv);
DECL_GL_HOOK_EXPORT(glLightModeli);
DECL_GL_HOOK_EXPORT(glLightModeliv);
DECL_GL_HOOK_EXPORT(glLineStipple);
DECL_GL_HOOK_EXPORT(glLineWidth);
DECL_GL_HOOK_EXPORT(glLinkProgram);
DECL_GL_HOOK_EXPORT(glLinkProgramARB);
DECL_GL_HOOK_EXPORT(glListBase);
DECL_GL_HOOK_EXPORT(glLoadIdentity);
DECL_GL_HOOK_EXPORT(glLoadMatrixd);
DECL_GL_HOOK_EXPORT(glLoadMatrixf);
DECL_GL_HOOK_EXPORT(glLoadName);
DECL_GL_HOOK_EXPORT(glLoadTransposeMatrixd);
DECL_GL_HOOK_EXPORT(glLoadTransposeMatrixdARB);
DECL_GL_HOOK_EXPORT(glLoadTransposeMatrixf);
DECL_GL_HOOK_EXPORT(glLoadTransposeMatrixfARB);
DECL_GL_HOOK_EXPORT(glLockArraysEXT);
DECL_GL_HOOK_EXPORT(glLogicOp);
DECL_GL_HOOK_EXPORT(glMap1d);
DECL_GL_HOOK_EXPORT(glMap1f);
DECL_GL_HOOK_EXPORT(glMap2d);
DECL_GL_HOOK_EXPORT(glMap2f);
DECL_GL_HOOK_EXPORT(glMapBuffer);
DECL_GL_HOOK_EXPORT(glMapBufferARB);
DECL_GL_HOOK_EXPORT(glMapBufferRange);
DECL_GL_HOOK_EXPORT(glMapGrid1d);
DECL_GL_HOOK_EXPORT(glMapGrid1f);
DECL_GL_HOOK_EXPORT(glMapGrid2d);
DECL_GL_HOOK_EXPORT(glMapGrid2f);
DECL_GL_HOOK_EXPORT(glMapVertexAttrib1dAPPLE);
DECL_GL_HOOK_EXPORT(glMapVertexAttrib1fAPPLE);
DECL_GL_HOOK_EXPORT(glMapVertexAttrib2dAPPLE);
DECL_GL_HOOK_EXPORT(glMapVertexAttrib2fAPPLE);
DECL_GL_HOOK_EXPORT(glMaterialf);
DECL_GL_HOOK_EXPORT(glMaterialfv);
DECL_GL_HOOK_EXPORT(glMateriali);
DECL_GL_HOOK_EXPORT(glMaterialiv);
DECL_GL_HOOK_EXPORT(glMatrixMode);
DECL_GL_HOOK_EXPORT(glMinmax);
DECL_GL_HOOK_EXPORT(glMinSampleShading);
DECL_GL_HOOK_EXPORT(glMinSampleShadingARB);
DECL_GL_HOOK_EXPORT(glMultiDrawArrays);
DECL_GL_HOOK_EXPORT(glMultiDrawArraysEXT);
DECL_GL_HOOK_EXPORT(glMultiDrawElementArrayAPPLE);
DECL_GL_HOOK_EXPORT(glMultiDrawElements);
DECL_GL_HOOK_EXPORT(glMultiDrawElementsBaseVertex);
DECL_GL_HOOK_EXPORT(glMultiDrawElementsEXT);
DECL_GL_HOOK_EXPORT(glMultiDrawRangeElementArrayAPPLE);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1d);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1dARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1dv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1dvARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1f);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1fARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1fv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1fvARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1i);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1iARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1iv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1ivARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1s);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1sARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1sv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord1svARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2d);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2dARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2dv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2dvARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2f);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2fARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2fv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2fvARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2i);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2iARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2iv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2ivARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2s);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2sARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2sv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord2svARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3d);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3dARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3dv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3dvARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3f);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3fARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3fv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3fvARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3i);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3iARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3iv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3ivARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3s);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3sARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3sv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord3svARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4d);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4dARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4dv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4dvARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4f);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4fARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4fv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4fvARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4i);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4iARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4iv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4ivARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4s);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4sARB);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4sv);
DECL_GL_HOOK_EXPORT(glMultiTexCoord4svARB);
DECL_GL_HOOK_EXPORT(glMultMatrixd);
DECL_GL_HOOK_EXPORT(glMultMatrixf);
DECL_GL_HOOK_EXPORT(glMultTransposeMatrixd);
DECL_GL_HOOK_EXPORT(glMultTransposeMatrixdARB);
DECL_GL_HOOK_EXPORT(glMultTransposeMatrixf);
DECL_GL_HOOK_EXPORT(glMultTransposeMatrixfARB);
DECL_GL_HOOK_EXPORT(glNamedStringARB);
DECL_GL_HOOK_EXPORT(glNewList);
DECL_GL_HOOK_EXPORT(glNormal3b);
DECL_GL_HOOK_EXPORT(glNormal3bv);
DECL_GL_HOOK_EXPORT(glNormal3d);
DECL_GL_HOOK_EXPORT(glNormal3dv);
DECL_GL_HOOK_EXPORT(glNormal3f);
DECL_GL_HOOK_EXPORT(glNormal3fv);
DECL_GL_HOOK_EXPORT(glNormal3i);
DECL_GL_HOOK_EXPORT(glNormal3iv);
DECL_GL_HOOK_EXPORT(glNormal3s);
DECL_GL_HOOK_EXPORT(glNormal3sv);
DECL_GL_HOOK_EXPORT(glNormalPointer);
DECL_GL_HOOK_EXPORT(glObjectPurgeableAPPLE);
DECL_GL_HOOK_EXPORT(glObjectUnpurgeableAPPLE);
DECL_GL_HOOK_EXPORT(glOrtho);
DECL_GL_HOOK_EXPORT(glPassThrough);
DECL_GL_HOOK_EXPORT(glPatchParameterfv);
DECL_GL_HOOK_EXPORT(glPatchParameteri);
DECL_GL_HOOK_EXPORT(glPauseTransformFeedback);
DECL_GL_HOOK_EXPORT(glPixelMapfv);
DECL_GL_HOOK_EXPORT(glPixelMapuiv);
DECL_GL_HOOK_EXPORT(glPixelMapusv);
DECL_GL_HOOK_EXPORT(glPixelStoref);
DECL_GL_HOOK_EXPORT(glPixelStorei);
DECL_GL_HOOK_EXPORT(glPixelTransferf);
DECL_GL_HOOK_EXPORT(glPixelTransferi);
DECL_GL_HOOK_EXPORT(glPixelZoom);
DECL_GL_HOOK_EXPORT(glPNTrianglesfATI);
DECL_GL_HOOK_EXPORT(glPNTrianglesiATI);
DECL_GL_HOOK_EXPORT(glPointParameterf);
DECL_GL_HOOK_EXPORT(glPointParameterfARB);
DECL_GL_HOOK_EXPORT(glPointParameterfv);
DECL_GL_HOOK_EXPORT(glPointParameterfvARB);
DECL_GL_HOOK_EXPORT(glPointParameteri);
DECL_GL_HOOK_EXPORT(glPointParameteriNV);
DECL_GL_HOOK_EXPORT(glPointParameteriv);
DECL_GL_HOOK_EXPORT(glPointParameterivNV);
DECL_GL_HOOK_EXPORT(glPointSize);
DECL_GL_HOOK_EXPORT(glPolygonMode);
DECL_GL_HOOK_EXPORT(glPolygonOffset);
DECL_GL_HOOK_EXPORT(glPolygonStipple);
DECL_GL_HOOK_EXPORT(glPopAttrib);
DECL_GL_HOOK_EXPORT(glPopClientAttrib);
DECL_GL_HOOK_EXPORT(glPopGroupMarkerEXT);
DECL_GL_HOOK_EXPORT(glPopMatrix);
DECL_GL_HOOK_EXPORT(glPopName);
DECL_GL_HOOK_EXPORT(glPrimitiveRestartIndex);
DECL_GL_HOOK_EXPORT(glPrioritizeTextures);
DECL_GL_HOOK_EXPORT(glProgramBinary);
DECL_GL_HOOK_EXPORT(glProgramEnvParameter4dARB);
DECL_GL_HOOK_EXPORT(glProgramEnvParameter4dvARB);
DECL_GL_HOOK_EXPORT(glProgramEnvParameter4fARB);
DECL_GL_HOOK_EXPORT(glProgramEnvParameter4fvARB);
DECL_GL_HOOK_EXPORT(glProgramEnvParameters4fvEXT);
DECL_GL_HOOK_EXPORT(glProgramLocalParameter4dARB);
DECL_GL_HOOK_EXPORT(glProgramLocalParameter4dvARB);
DECL_GL_HOOK_EXPORT(glProgramLocalParameter4fARB);
DECL_GL_HOOK_EXPORT(glProgramLocalParameter4fvARB);
DECL_GL_HOOK_EXPORT(glProgramLocalParameters4fvEXT);
DECL_GL_HOOK_EXPORT(glProgramParameteri);
DECL_GL_HOOK_EXPORT(glProgramParameteriEXT);
DECL_GL_HOOK_EXPORT(glProgramStringARB);
DECL_GL_HOOK_EXPORT(glProgramUniform1d);
DECL_GL_HOOK_EXPORT(glProgramUniform1dv);
DECL_GL_HOOK_EXPORT(glProgramUniform1f);
DECL_GL_HOOK_EXPORT(glProgramUniform1fv);
DECL_GL_HOOK_EXPORT(glProgramUniform1i);
DECL_GL_HOOK_EXPORT(glProgramUniform1iv);
DECL_GL_HOOK_EXPORT(glProgramUniform1ui);
DECL_GL_HOOK_EXPORT(glProgramUniform1uiv);
DECL_GL_HOOK_EXPORT(glProgramUniform2d);
DECL_GL_HOOK_EXPORT(glProgramUniform2dv);
DECL_GL_HOOK_EXPORT(glProgramUniform2f);
DECL_GL_HOOK_EXPORT(glProgramUniform2fv);
DECL_GL_HOOK_EXPORT(glProgramUniform2i);
DECL_GL_HOOK_EXPORT(glProgramUniform2iv);
DECL_GL_HOOK_EXPORT(glProgramUniform2ui);
DECL_GL_HOOK_EXPORT(glProgramUniform2uiv);
DECL_GL_HOOK_EXPORT(glProgramUniform3d);
DECL_GL_HOOK_EXPORT(glProgramUniform3dv);
DECL_GL_HOOK_EXPORT(glProgramUniform3f);
DECL_GL_HOOK_EXPORT(glProgramUniform3fv);
DECL_GL_HOOK_EXPORT(glProgramUniform3i);
DECL_GL_HOOK_EXPORT(glProgramUniform3iv);
DECL_GL_HOOK_EXPORT(glProgramUniform3ui);
DECL_GL_HOOK_EXPORT(glProgramUniform3uiv);
DECL_GL_HOOK_EXPORT(glProgramUniform4d);
DECL_GL_HOOK_EXPORT(glProgramUniform4dv);
DECL_GL_HOOK_EXPORT(glProgramUniform4f);
DECL_GL_HOOK_EXPORT(glProgramUniform4fv);
DECL_GL_HOOK_EXPORT(glProgramUniform4i);
DECL_GL_HOOK_EXPORT(glProgramUniform4iv);
DECL_GL_HOOK_EXPORT(glProgramUniform4ui);
DECL_GL_HOOK_EXPORT(glProgramUniform4uiv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix2dv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix2fv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix2x3dv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix2x3fv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix2x4dv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix2x4fv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix3dv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix3fv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix3x2dv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix3x2fv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix3x4dv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix3x4fv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix4dv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix4fv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix4x2dv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix4x2fv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix4x3dv);
DECL_GL_HOOK_EXPORT(glProgramUniformMatrix4x3fv);
DECL_GL_HOOK_EXPORT(glProvokingVertex);
DECL_GL_HOOK_EXPORT(glProvokingVertexEXT);
DECL_GL_HOOK_EXPORT(glPushAttrib);
DECL_GL_HOOK_EXPORT(glPushClientAttrib);
DECL_GL_HOOK_EXPORT(glPushGroupMarkerEXT);
DECL_GL_HOOK_EXPORT(glPushMatrix);
DECL_GL_HOOK_EXPORT(glPushName);
DECL_GL_HOOK_EXPORT(glQueryCounter);
DECL_GL_HOOK_EXPORT(glRasterPos2d);
DECL_GL_HOOK_EXPORT(glRasterPos2dv);
DECL_GL_HOOK_EXPORT(glRasterPos2f);
DECL_GL_HOOK_EXPORT(glRasterPos2fv);
DECL_GL_HOOK_EXPORT(glRasterPos2i);
DECL_GL_HOOK_EXPORT(glRasterPos2iv);
DECL_GL_HOOK_EXPORT(glRasterPos2s);
DECL_GL_HOOK_EXPORT(glRasterPos2sv);
DECL_GL_HOOK_EXPORT(glRasterPos3d);
DECL_GL_HOOK_EXPORT(glRasterPos3dv);
DECL_GL_HOOK_EXPORT(glRasterPos3f);
DECL_GL_HOOK_EXPORT(glRasterPos3fv);
DECL_GL_HOOK_EXPORT(glRasterPos3i);
DECL_GL_HOOK_EXPORT(glRasterPos3iv);
DECL_GL_HOOK_EXPORT(glRasterPos3s);
DECL_GL_HOOK_EXPORT(glRasterPos3sv);
DECL_GL_HOOK_EXPORT(glRasterPos4d);
DECL_GL_HOOK_EXPORT(glRasterPos4dv);
DECL_GL_HOOK_EXPORT(glRasterPos4f);
DECL_GL_HOOK_EXPORT(glRasterPos4fv);
DECL_GL_HOOK_EXPORT(glRasterPos4i);
DECL_GL_HOOK_EXPORT(glRasterPos4iv);
DECL_GL_HOOK_EXPORT(glRasterPos4s);
DECL_GL_HOOK_EXPORT(glRasterPos4sv);
DECL_GL_HOOK_EXPORT(glReadBuffer);
DECL_GL_HOOK_EXPORT(glReadPixels);
DECL_GL_HOOK_EXPORT(glRectd);
DECL_GL_HOOK_EXPORT(glRectdv);
DECL_GL_HOOK_EXPORT(glRectf);
DECL_GL_HOOK_EXPORT(glRectfv);
DECL_GL_HOOK_EXPORT(glRecti);
DECL_GL_HOOK_EXPORT(glRectiv);
DECL_GL_HOOK_EXPORT(glRects);
DECL_GL_HOOK_EXPORT(glRectsv);
DECL_GL_HOOK_EXPORT(glReleaseShaderCompiler);
DECL_GL_HOOK_EXPORT(glRenderbufferStorage);
DECL_GL_HOOK_EXPORT(glRenderbufferStorageEXT);
DECL_GL_HOOK_EXPORT(glRenderbufferStorageMultisample);
DECL_GL_HOOK_EXPORT(glRenderbufferStorageMultisampleEXT);
DECL_GL_HOOK_EXPORT(glRenderMode);
DECL_GL_HOOK_EXPORT(glResetHistogram);
DECL_GL_HOOK_EXPORT(glResetMinmax);
DECL_GL_HOOK_EXPORT(glResumeTransformFeedback);
DECL_GL_HOOK_EXPORT(glRotated);
DECL_GL_HOOK_EXPORT(glRotatef);
DECL_GL_HOOK_EXPORT(glSampleCoverage);
DECL_GL_HOOK_EXPORT(glSampleCoverageARB);
DECL_GL_HOOK_EXPORT(glSampleMaski);
DECL_GL_HOOK_EXPORT(glSamplerParameterf);
DECL_GL_HOOK_EXPORT(glSamplerParameterfv);
DECL_GL_HOOK_EXPORT(glSamplerParameteri);
DECL_GL_HOOK_EXPORT(glSamplerParameterIiv);
DECL_GL_HOOK_EXPORT(glSamplerParameterIuiv);
DECL_GL_HOOK_EXPORT(glSamplerParameteriv);
DECL_GL_HOOK_EXPORT(glScaled);
DECL_GL_HOOK_EXPORT(glScalef);
DECL_GL_HOOK_EXPORT(glScissor);
DECL_GL_HOOK_EXPORT(glScissorArrayv);
DECL_GL_HOOK_EXPORT(glScissorIndexed);
DECL_GL_HOOK_EXPORT(glScissorIndexedv);
DECL_GL_HOOK_EXPORT(glSecondaryColor3b);
DECL_GL_HOOK_EXPORT(glSecondaryColor3bEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColor3bv);
DECL_GL_HOOK_EXPORT(glSecondaryColor3bvEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColor3d);
DECL_GL_HOOK_EXPORT(glSecondaryColor3dEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColor3dv);
DECL_GL_HOOK_EXPORT(glSecondaryColor3dvEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColor3f);
DECL_GL_HOOK_EXPORT(glSecondaryColor3fEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColor3fv);
DECL_GL_HOOK_EXPORT(glSecondaryColor3fvEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColor3i);
DECL_GL_HOOK_EXPORT(glSecondaryColor3iEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColor3iv);
DECL_GL_HOOK_EXPORT(glSecondaryColor3ivEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColor3s);
DECL_GL_HOOK_EXPORT(glSecondaryColor3sEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColor3sv);
DECL_GL_HOOK_EXPORT(glSecondaryColor3svEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColor3ub);
DECL_GL_HOOK_EXPORT(glSecondaryColor3ubEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColor3ubv);
DECL_GL_HOOK_EXPORT(glSecondaryColor3ubvEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColor3ui);
DECL_GL_HOOK_EXPORT(glSecondaryColor3uiEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColor3uiv);
DECL_GL_HOOK_EXPORT(glSecondaryColor3uivEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColor3us);
DECL_GL_HOOK_EXPORT(glSecondaryColor3usEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColor3usv);
DECL_GL_HOOK_EXPORT(glSecondaryColor3usvEXT);
DECL_GL_HOOK_EXPORT(glSecondaryColorPointer);
DECL_GL_HOOK_EXPORT(glSecondaryColorPointerEXT);
DECL_GL_HOOK_EXPORT(glSelectBuffer);
DECL_GL_HOOK_EXPORT(glSeparableFilter2D);
DECL_GL_HOOK_EXPORT(glSetFenceAPPLE);
DECL_GL_HOOK_EXPORT(glShadeModel);
DECL_GL_HOOK_EXPORT(glShaderBinary);
DECL_GL_HOOK_EXPORT(glShaderSource);
DECL_GL_HOOK_EXPORT(glShaderSourceARB);
DECL_GL_HOOK_EXPORT(glStencilFunc);
DECL_GL_HOOK_EXPORT(glStencilFuncSeparate);
DECL_GL_HOOK_EXPORT(glStencilFuncSeparateATI);
DECL_GL_HOOK_EXPORT(glStencilMask);
DECL_GL_HOOK_EXPORT(glStencilMaskSeparate);
DECL_GL_HOOK_EXPORT(glStencilOp);
DECL_GL_HOOK_EXPORT(glStencilOpSeparate);
DECL_GL_HOOK_EXPORT(glStencilOpSeparateATI);
DECL_GL_HOOK_EXPORT(glTestFenceAPPLE);
DECL_GL_HOOK_EXPORT(glTestObjectAPPLE);
DECL_GL_HOOK_EXPORT(glTexBuffer);
DECL_GL_HOOK_EXPORT(glTexCoord1d);
DECL_GL_HOOK_EXPORT(glTexCoord1dv);
DECL_GL_HOOK_EXPORT(glTexCoord1f);
DECL_GL_HOOK_EXPORT(glTexCoord1fv);
DECL_GL_HOOK_EXPORT(glTexCoord1i);
DECL_GL_HOOK_EXPORT(glTexCoord1iv);
DECL_GL_HOOK_EXPORT(glTexCoord1s);
DECL_GL_HOOK_EXPORT(glTexCoord1sv);
DECL_GL_HOOK_EXPORT(glTexCoord2d);
DECL_GL_HOOK_EXPORT(glTexCoord2dv);
DECL_GL_HOOK_EXPORT(glTexCoord2f);
DECL_GL_HOOK_EXPORT(glTexCoord2fv);
DECL_GL_HOOK_EXPORT(glTexCoord2i);
DECL_GL_HOOK_EXPORT(glTexCoord2iv);
DECL_GL_HOOK_EXPORT(glTexCoord2s);
DECL_GL_HOOK_EXPORT(glTexCoord2sv);
DECL_GL_HOOK_EXPORT(glTexCoord3d);
DECL_GL_HOOK_EXPORT(glTexCoord3dv);
DECL_GL_HOOK_EXPORT(glTexCoord3f);
DECL_GL_HOOK_EXPORT(glTexCoord3fv);
DECL_GL_HOOK_EXPORT(glTexCoord3i);
DECL_GL_HOOK_EXPORT(glTexCoord3iv);
DECL_GL_HOOK_EXPORT(glTexCoord3s);
DECL_GL_HOOK_EXPORT(glTexCoord3sv);
DECL_GL_HOOK_EXPORT(glTexCoord4d);
DECL_GL_HOOK_EXPORT(glTexCoord4dv);
DECL_GL_HOOK_EXPORT(glTexCoord4f);
DECL_GL_HOOK_EXPORT(glTexCoord4fv);
DECL_GL_HOOK_EXPORT(glTexCoord4i);
DECL_GL_HOOK_EXPORT(glTexCoord4iv);
DECL_GL_HOOK_EXPORT(glTexCoord4s);
DECL_GL_HOOK_EXPORT(glTexCoord4sv);
DECL_GL_HOOK_EXPORT(glTexCoordPointer);
DECL_GL_HOOK_EXPORT(glTexEnvf);
DECL_GL_HOOK_EXPORT(glTexEnvfv);
DECL_GL_HOOK_EXPORT(glTexEnvi);
DECL_GL_HOOK_EXPORT(glTexEnviv);
DECL_GL_HOOK_EXPORT(glTexGend);
DECL_GL_HOOK_EXPORT(glTexGendv);
DECL_GL_HOOK_EXPORT(glTexGenf);
DECL_GL_HOOK_EXPORT(glTexGenfv);
DECL_GL_HOOK_EXPORT(glTexGeni);
DECL_GL_HOOK_EXPORT(glTexGeniv);
DECL_GL_HOOK_EXPORT(glTexImage1D);
DECL_GL_HOOK_EXPORT(glTexImage2D);
DECL_GL_HOOK_EXPORT(glTexImage2DMultisample);
DECL_GL_HOOK_EXPORT(glTexImage3D);
DECL_GL_HOOK_EXPORT(glTexImage3DMultisample);
DECL_GL_HOOK_EXPORT(glTexParameterf);
DECL_GL_HOOK_EXPORT(glTexParameterfv);
DECL_GL_HOOK_EXPORT(glTexParameteri);
DECL_GL_HOOK_EXPORT(glTexParameterIiv);
DECL_GL_HOOK_EXPORT(glTexParameterIivEXT);
DECL_GL_HOOK_EXPORT(glTexParameterIuiv);
DECL_GL_HOOK_EXPORT(glTexParameterIuivEXT);
DECL_GL_HOOK_EXPORT(glTexParameteriv);
DECL_GL_HOOK_EXPORT(glTexStorage1D);
DECL_GL_HOOK_EXPORT(glTexStorage2D);
DECL_GL_HOOK_EXPORT(glTexStorage3D);
DECL_GL_HOOK_EXPORT(glTexSubImage1D);
DECL_GL_HOOK_EXPORT(glTexSubImage2D);
DECL_GL_HOOK_EXPORT(glTexSubImage3D);
DECL_GL_HOOK_EXPORT(glTextureBarrierNV);
DECL_GL_HOOK_EXPORT(glTextureRangeAPPLE);
DECL_GL_HOOK_EXPORT(glTransformFeedbackVaryings);
DECL_GL_HOOK_EXPORT(glTransformFeedbackVaryingsEXT);
DECL_GL_HOOK_EXPORT(glTranslated);
DECL_GL_HOOK_EXPORT(glTranslatef);
DECL_GL_HOOK_EXPORT(glUniform1d);
DECL_GL_HOOK_EXPORT(glUniform1dv);
DECL_GL_HOOK_EXPORT(glUniform1f);
DECL_GL_HOOK_EXPORT(glUniform1fARB);
DECL_GL_HOOK_EXPORT(glUniform1fv);
DECL_GL_HOOK_EXPORT(glUniform1fvARB);
DECL_GL_HOOK_EXPORT(glUniform1i);
DECL_GL_HOOK_EXPORT(glUniform1iARB);
DECL_GL_HOOK_EXPORT(glUniform1iv);
DECL_GL_HOOK_EXPORT(glUniform1ivARB);
DECL_GL_HOOK_EXPORT(glUniform1ui);
DECL_GL_HOOK_EXPORT(glUniform1uiEXT);
DECL_GL_HOOK_EXPORT(glUniform1uiv);
DECL_GL_HOOK_EXPORT(glUniform1uivEXT);
DECL_GL_HOOK_EXPORT(glUniform2d);
DECL_GL_HOOK_EXPORT(glUniform2dv);
DECL_GL_HOOK_EXPORT(glUniform2f);
DECL_GL_HOOK_EXPORT(glUniform2fARB);
DECL_GL_HOOK_EXPORT(glUniform2fv);
DECL_GL_HOOK_EXPORT(glUniform2fvARB);
DECL_GL_HOOK_EXPORT(glUniform2i);
DECL_GL_HOOK_EXPORT(glUniform2iARB);
DECL_GL_HOOK_EXPORT(glUniform2iv);
DECL_GL_HOOK_EXPORT(glUniform2ivARB);
DECL_GL_HOOK_EXPORT(glUniform2ui);
DECL_GL_HOOK_EXPORT(glUniform2uiEXT);
DECL_GL_HOOK_EXPORT(glUniform2uiv);
DECL_GL_HOOK_EXPORT(glUniform2uivEXT);
DECL_GL_HOOK_EXPORT(glUniform3d);
DECL_GL_HOOK_EXPORT(glUniform3dv);
DECL_GL_HOOK_EXPORT(glUniform3f);
DECL_GL_HOOK_EXPORT(glUniform3fARB);
DECL_GL_HOOK_EXPORT(glUniform3fv);
DECL_GL_HOOK_EXPORT(glUniform3fvARB);
DECL_GL_HOOK_EXPORT(glUniform3i);
DECL_GL_HOOK_EXPORT(glUniform3iARB);
DECL_GL_HOOK_EXPORT(glUniform3iv);
DECL_GL_HOOK_EXPORT(glUniform3ivARB);
DECL_GL_HOOK_EXPORT(glUniform3ui);
DECL_GL_HOOK_EXPORT(glUniform3uiEXT);
DECL_GL_HOOK_EXPORT(glUniform3uiv);
DECL_GL_HOOK_EXPORT(glUniform3uivEXT);
DECL_GL_HOOK_EXPORT(glUniform4d);
DECL_GL_HOOK_EXPORT(glUniform4dv);
DECL_GL_HOOK_EXPORT(glUniform4f);
DECL_GL_HOOK_EXPORT(glUniform4fARB);
DECL_GL_HOOK_EXPORT(glUniform4fv);
DECL_GL_HOOK_EXPORT(glUniform4fvARB);
DECL_GL_HOOK_EXPORT(glUniform4i);
DECL_GL_HOOK_EXPORT(glUniform4iARB);
DECL_GL_HOOK_EXPORT(glUniform4iv);
DECL_GL_HOOK_EXPORT(glUniform4ivARB);
DECL_GL_HOOK_EXPORT(glUniform4ui);
DECL_GL_HOOK_EXPORT(glUniform4uiEXT);
DECL_GL_HOOK_EXPORT(glUniform4uiv);
DECL_GL_HOOK_EXPORT(glUniform4uivEXT);
DECL_GL_HOOK_EXPORT(glUniformBlockBinding);
DECL_GL_HOOK_EXPORT(glUniformBufferEXT);
DECL_GL_HOOK_EXPORT(glUniformMatrix2dv);
DECL_GL_HOOK_EXPORT(glUniformMatrix2fv);
DECL_GL_HOOK_EXPORT(glUniformMatrix2fvARB);
DECL_GL_HOOK_EXPORT(glUniformMatrix2x3dv);
DECL_GL_HOOK_EXPORT(glUniformMatrix2x3fv);
DECL_GL_HOOK_EXPORT(glUniformMatrix2x4dv);
DECL_GL_HOOK_EXPORT(glUniformMatrix2x4fv);
DECL_GL_HOOK_EXPORT(glUniformMatrix3dv);
DECL_GL_HOOK_EXPORT(glUniformMatrix3fv);
DECL_GL_HOOK_EXPORT(glUniformMatrix3fvARB);
DECL_GL_HOOK_EXPORT(glUniformMatrix3x2dv);
DECL_GL_HOOK_EXPORT(glUniformMatrix3x2fv);
DECL_GL_HOOK_EXPORT(glUniformMatrix3x4dv);
DECL_GL_HOOK_EXPORT(glUniformMatrix3x4fv);
DECL_GL_HOOK_EXPORT(glUniformMatrix4dv);
DECL_GL_HOOK_EXPORT(glUniformMatrix4fv);
DECL_GL_HOOK_EXPORT(glUniformMatrix4fvARB);
DECL_GL_HOOK_EXPORT(glUniformMatrix4x2dv);
DECL_GL_HOOK_EXPORT(glUniformMatrix4x2fv);
DECL_GL_HOOK_EXPORT(glUniformMatrix4x3dv);
DECL_GL_HOOK_EXPORT(glUniformMatrix4x3fv);
DECL_GL_HOOK_EXPORT(glUniformSubroutinesuiv);
DECL_GL_HOOK_EXPORT(glUnlockArraysEXT);
DECL_GL_HOOK_EXPORT(glUnmapBuffer);
DECL_GL_HOOK_EXPORT(glUnmapBufferARB);
DECL_GL_HOOK_EXPORT(glUseProgram);
DECL_GL_HOOK_EXPORT(glUseProgramObjectARB);
DECL_GL_HOOK_EXPORT(glUseProgramStages);
DECL_GL_HOOK_EXPORT(glValidateProgram);
DECL_GL_HOOK_EXPORT(glValidateProgramARB);
DECL_GL_HOOK_EXPORT(glValidateProgramPipeline);
DECL_GL_HOOK_EXPORT(glVertex2d);
DECL_GL_HOOK_EXPORT(glVertex2dv);
DECL_GL_HOOK_EXPORT(glVertex2f);
DECL_GL_HOOK_EXPORT(glVertex2fv);
DECL_GL_HOOK_EXPORT(glVertex2i);
DECL_GL_HOOK_EXPORT(glVertex2iv);
DECL_GL_HOOK_EXPORT(glVertex2s);
DECL_GL_HOOK_EXPORT(glVertex2sv);
DECL_GL_HOOK_EXPORT(glVertex3d);
DECL_GL_HOOK_EXPORT(glVertex3dv);
DECL_GL_HOOK_EXPORT(glVertex3f);
DECL_GL_HOOK_EXPORT(glVertex3fv);
DECL_GL_HOOK_EXPORT(glVertex3i);
DECL_GL_HOOK_EXPORT(glVertex3iv);
DECL_GL_HOOK_EXPORT(glVertex3s);
DECL_GL_HOOK_EXPORT(glVertex3sv);
DECL_GL_HOOK_EXPORT(glVertex4d);
DECL_GL_HOOK_EXPORT(glVertex4dv);
DECL_GL_HOOK_EXPORT(glVertex4f);
DECL_GL_HOOK_EXPORT(glVertex4fv);
DECL_GL_HOOK_EXPORT(glVertex4i);
DECL_GL_HOOK_EXPORT(glVertex4iv);
DECL_GL_HOOK_EXPORT(glVertex4s);
DECL_GL_HOOK_EXPORT(glVertex4sv);
DECL_GL_HOOK_EXPORT(glVertexArrayParameteriAPPLE);
DECL_GL_HOOK_EXPORT(glVertexArrayRangeAPPLE);
DECL_GL_HOOK_EXPORT(glVertexAttrib1d);
DECL_GL_HOOK_EXPORT(glVertexAttrib1dARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib1dv);
DECL_GL_HOOK_EXPORT(glVertexAttrib1dvARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib1f);
DECL_GL_HOOK_EXPORT(glVertexAttrib1fARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib1fv);
DECL_GL_HOOK_EXPORT(glVertexAttrib1fvARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib1s);
DECL_GL_HOOK_EXPORT(glVertexAttrib1sARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib1sv);
DECL_GL_HOOK_EXPORT(glVertexAttrib1svARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib2d);
DECL_GL_HOOK_EXPORT(glVertexAttrib2dARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib2dv);
DECL_GL_HOOK_EXPORT(glVertexAttrib2dvARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib2f);
DECL_GL_HOOK_EXPORT(glVertexAttrib2fARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib2fv);
DECL_GL_HOOK_EXPORT(glVertexAttrib2fvARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib2s);
DECL_GL_HOOK_EXPORT(glVertexAttrib2sARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib2sv);
DECL_GL_HOOK_EXPORT(glVertexAttrib2svARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib3d);
DECL_GL_HOOK_EXPORT(glVertexAttrib3dARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib3dv);
DECL_GL_HOOK_EXPORT(glVertexAttrib3dvARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib3f);
DECL_GL_HOOK_EXPORT(glVertexAttrib3fARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib3fv);
DECL_GL_HOOK_EXPORT(glVertexAttrib3fvARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib3s);
DECL_GL_HOOK_EXPORT(glVertexAttrib3sARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib3sv);
DECL_GL_HOOK_EXPORT(glVertexAttrib3svARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4bv);
DECL_GL_HOOK_EXPORT(glVertexAttrib4bvARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4d);
DECL_GL_HOOK_EXPORT(glVertexAttrib4dARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4dv);
DECL_GL_HOOK_EXPORT(glVertexAttrib4dvARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4f);
DECL_GL_HOOK_EXPORT(glVertexAttrib4fARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4fv);
DECL_GL_HOOK_EXPORT(glVertexAttrib4fvARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4iv);
DECL_GL_HOOK_EXPORT(glVertexAttrib4ivARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4Nbv);
DECL_GL_HOOK_EXPORT(glVertexAttrib4NbvARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4Niv);
DECL_GL_HOOK_EXPORT(glVertexAttrib4NivARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4Nsv);
DECL_GL_HOOK_EXPORT(glVertexAttrib4NsvARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4Nub);
DECL_GL_HOOK_EXPORT(glVertexAttrib4NubARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4Nubv);
DECL_GL_HOOK_EXPORT(glVertexAttrib4NubvARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4Nuiv);
DECL_GL_HOOK_EXPORT(glVertexAttrib4NuivARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4Nusv);
DECL_GL_HOOK_EXPORT(glVertexAttrib4NusvARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4s);
DECL_GL_HOOK_EXPORT(glVertexAttrib4sARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4sv);
DECL_GL_HOOK_EXPORT(glVertexAttrib4svARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4ubv);
DECL_GL_HOOK_EXPORT(glVertexAttrib4ubvARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4uiv);
DECL_GL_HOOK_EXPORT(glVertexAttrib4uivARB);
DECL_GL_HOOK_EXPORT(glVertexAttrib4usv);
DECL_GL_HOOK_EXPORT(glVertexAttrib4usvARB);
DECL_GL_HOOK_EXPORT(glVertexAttribDivisor);
DECL_GL_HOOK_EXPORT(glVertexAttribDivisorARB);
DECL_GL_HOOK_EXPORT(glVertexAttribI1i);
DECL_GL_HOOK_EXPORT(glVertexAttribI1iEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI1iv);
DECL_GL_HOOK_EXPORT(glVertexAttribI1ivEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI1ui);
DECL_GL_HOOK_EXPORT(glVertexAttribI1uiEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI1uiv);
DECL_GL_HOOK_EXPORT(glVertexAttribI1uivEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI2i);
DECL_GL_HOOK_EXPORT(glVertexAttribI2iEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI2iv);
DECL_GL_HOOK_EXPORT(glVertexAttribI2ivEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI2ui);
DECL_GL_HOOK_EXPORT(glVertexAttribI2uiEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI2uiv);
DECL_GL_HOOK_EXPORT(glVertexAttribI2uivEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI3i);
DECL_GL_HOOK_EXPORT(glVertexAttribI3iEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI3iv);
DECL_GL_HOOK_EXPORT(glVertexAttribI3ivEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI3ui);
DECL_GL_HOOK_EXPORT(glVertexAttribI3uiEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI3uiv);
DECL_GL_HOOK_EXPORT(glVertexAttribI3uivEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI4bv);
DECL_GL_HOOK_EXPORT(glVertexAttribI4bvEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI4i);
DECL_GL_HOOK_EXPORT(glVertexAttribI4iEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI4iv);
DECL_GL_HOOK_EXPORT(glVertexAttribI4ivEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI4sv);
DECL_GL_HOOK_EXPORT(glVertexAttribI4svEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI4ubv);
DECL_GL_HOOK_EXPORT(glVertexAttribI4ubvEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI4ui);
DECL_GL_HOOK_EXPORT(glVertexAttribI4uiEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI4uiv);
DECL_GL_HOOK_EXPORT(glVertexAttribI4uivEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribI4usv);
DECL_GL_HOOK_EXPORT(glVertexAttribI4usvEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribIPointer);
DECL_GL_HOOK_EXPORT(glVertexAttribIPointerEXT);
DECL_GL_HOOK_EXPORT(glVertexAttribL1d);
DECL_GL_HOOK_EXPORT(glVertexAttribL1dv);
DECL_GL_HOOK_EXPORT(glVertexAttribL2d);
DECL_GL_HOOK_EXPORT(glVertexAttribL2dv);
DECL_GL_HOOK_EXPORT(glVertexAttribL3d);
DECL_GL_HOOK_EXPORT(glVertexAttribL3dv);
DECL_GL_HOOK_EXPORT(glVertexAttribL4d);
DECL_GL_HOOK_EXPORT(glVertexAttribL4dv);
DECL_GL_HOOK_EXPORT(glVertexAttribLPointer);
DECL_GL_HOOK_EXPORT(glVertexAttribP1ui);
DECL_GL_HOOK_EXPORT(glVertexAttribP1uiv);
DECL_GL_HOOK_EXPORT(glVertexAttribP2ui);
DECL_GL_HOOK_EXPORT(glVertexAttribP2uiv);
DECL_GL_HOOK_EXPORT(glVertexAttribP3ui);
DECL_GL_HOOK_EXPORT(glVertexAttribP3uiv);
DECL_GL_HOOK_EXPORT(glVertexAttribP4ui);
DECL_GL_HOOK_EXPORT(glVertexAttribP4uiv);
DECL_GL_HOOK_EXPORT(glVertexAttribPointer);
DECL_GL_HOOK_EXPORT(glVertexAttribPointerARB);
DECL_GL_HOOK_EXPORT(glVertexBlendARB);
DECL_GL_HOOK_EXPORT(glVertexPointer);
DECL_GL_HOOK_EXPORT(glViewport);
DECL_GL_HOOK_EXPORT(glViewportArrayv);
DECL_GL_HOOK_EXPORT(glViewportIndexedf);
DECL_GL_HOOK_EXPORT(glViewportIndexedfv);
DECL_GL_HOOK_EXPORT(glWaitSync);
DECL_GL_HOOK_EXPORT(glWeightbvARB);
DECL_GL_HOOK_EXPORT(glWeightdvARB);
DECL_GL_HOOK_EXPORT(glWeightfvARB);
DECL_GL_HOOK_EXPORT(glWeightivARB);
DECL_GL_HOOK_EXPORT(glWeightPointerARB);
DECL_GL_HOOK_EXPORT(glWeightsvARB);
DECL_GL_HOOK_EXPORT(glWeightubvARB);
DECL_GL_HOOK_EXPORT(glWeightuivARB);
DECL_GL_HOOK_EXPORT(glWeightusvARB);
DECL_GL_HOOK_EXPORT(glWindowPos2d);
DECL_GL_HOOK_EXPORT(glWindowPos2dARB);
DECL_GL_HOOK_EXPORT(glWindowPos2dv);
DECL_GL_HOOK_EXPORT(glWindowPos2dvARB);
DECL_GL_HOOK_EXPORT(glWindowPos2f);
DECL_GL_HOOK_EXPORT(glWindowPos2fARB);
DECL_GL_HOOK_EXPORT(glWindowPos2fv);
DECL_GL_HOOK_EXPORT(glWindowPos2fvARB);
DECL_GL_HOOK_EXPORT(glWindowPos2i);
DECL_GL_HOOK_EXPORT(glWindowPos2iARB);
DECL_GL_HOOK_EXPORT(glWindowPos2iv);
DECL_GL_HOOK_EXPORT(glWindowPos2ivARB);
DECL_GL_HOOK_EXPORT(glWindowPos2s);
DECL_GL_HOOK_EXPORT(glWindowPos2sARB);
DECL_GL_HOOK_EXPORT(glWindowPos2sv);
DECL_GL_HOOK_EXPORT(glWindowPos2svARB);
DECL_GL_HOOK_EXPORT(glWindowPos3d);
DECL_GL_HOOK_EXPORT(glWindowPos3dARB);
DECL_GL_HOOK_EXPORT(glWindowPos3dv);
DECL_GL_HOOK_EXPORT(glWindowPos3dvARB);
DECL_GL_HOOK_EXPORT(glWindowPos3f);
DECL_GL_HOOK_EXPORT(glWindowPos3fARB);
DECL_GL_HOOK_EXPORT(glWindowPos3fv);
DECL_GL_HOOK_EXPORT(glWindowPos3fvARB);
DECL_GL_HOOK_EXPORT(glWindowPos3i);
DECL_GL_HOOK_EXPORT(glWindowPos3iARB);
DECL_GL_HOOK_EXPORT(glWindowPos3iv);
DECL_GL_HOOK_EXPORT(glWindowPos3ivARB);
DECL_GL_HOOK_EXPORT(glWindowPos3s);
DECL_GL_HOOK_EXPORT(glWindowPos3sARB);
DECL_GL_HOOK_EXPORT(glWindowPos3sv);
DECL_GL_HOOK_EXPORT(glWindowPos3svARB);
