% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virtualenv.R
\name{virtualenv-tools}
\alias{virtualenv-tools}
\alias{virtualenv_list}
\alias{virtualenv_root}
\alias{virtualenv_create}
\alias{virtualenv_install}
\alias{virtualenv_remove}
\alias{virtualenv_python}
\title{Interface to virtualenv}
\usage{
virtualenv_list()

virtualenv_root()

virtualenv_create(envname)

virtualenv_install(envname, packages, ignore_installed = FALSE)

virtualenv_remove(envname, packages = NULL, confirm = interactive())

virtualenv_python(envname)
}
\arguments{
\item{envname}{Name of virtual environment}

\item{packages}{Character vector with package names to install or remove.}

\item{ignore_installed}{Ignore any previously installed versions of packages}

\item{confirm}{Confirm before removing packages or virtual environments}
}
\value{
\code{virtualenv_list()} returns a chracter vector with the names
of available virtual environments. \code{virtualenv_root()} returns the
root directory for virtual environments.
}
\description{
R functions for managing Python \href{https://virtualenv.pypa.io/en/stable/}{virtual environments}
}
\details{
Virtual environments are by default located at \code{~/.virtualenvs}. You can change this
behavior by defining the \code{WORKON_HOME} environment variable.

Virtual environment functions are not supported on Windows (the use of
\link[=conda-tools]{conda environments} is recommended on Windows).
}
