DACSVFS(1)                   DACS Commands Manual                   DACSVFS(1)



[1mNAME[0m
       dacsvfs - access objects through the [1mDACS [22mvirtual filestore

[1mSYNOPSIS[0m
       [1mdacsvfs [22m[[34m[1mdacsoptions[0m[1m[22m[1]] [[4mitem_type[24m | [4mvfs_uri[24m | enabled] [[1m-F [4m[22msep[24m]
               [[4mop[24m [[4marg[24m...]]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacsvfs [22mutility is an interface to the [1mDACS [22mvirtual filestore. It
       provides a way to examine, change, and delete items independently of
       how and where they are stored. See [34m[1mdacs.vfs(5)[0m[1m[22m[2] and the [34m[1mVFS[0m[1m[22m[3]
       directive for additional information.

       To perform a virtual filestore operation, either an [4mitem_type[24m or a URI
       argument must be provided to identify the filestore. The former is used
       to find the applicable [34m[1mVFS[0m[1m[22m[3] directive that has been configured for
       the specified jurisdiction (see [34m[1mdacs.conf(5)[0m[1m[22m[4]).

       As a special case, the word [1menabled [22mcan be specified; a list of enabled
       store names is printed to stdout and the program terminates:

           % dacsvfs -q -uj SomeJurisdiction enabled

       This program is also available as a [1mDACS [22mweb service, [34m[1mdacs_vfs(8)[0m[1m[22m[5].

           [1mSecurity[0m
           Only the [1mDACS [22madministrator should be able to successfully run this
           program. Because [1mDACS [22mkeys and configuration files must be limited
           to the administrator, this will normally be the case, but a careful
           administrator will deny access to all other users.

[1mOPTIONS[0m
       [1m-F [4m[22msep[0m
           Sets the field separator character to [4msep[24m. The default is a colon.
           This is used by the load and dump operations.

       If present, the [4mop[24m argument specifies the operation to be performed on
       the filestore. If it is omitted, the program enters interactive mode
       where most of the same operations are available (type "[1mhelp[22m" for
       assistance). The following operations are available:

       delete [[4mkey[24m]
           Delete the item, or the item identified by [4mkey[24m.

       dump
           Write to stdout the contents of the filestore as [4mkey[24m, followed by
           the field separator character, followed by [4mvalue[24m, one pair per
           line.

       edit [[4mkey[24m]
           Interactively edit the item, or the value of the item identified by
           [4mkey[24m. When available, the environment variable [1mEDITOR [22mis used to
           determine which editor to use, otherwise a default editor specified
           at compile time is used. After editing, the user is asked for
           confirmation. If the operation is not aborted, the item or its
           value will be updated.

       exists [[4mkey[24m]
           Test if the item, or the item identified by [4mkey[24m, exists. The
           outcome is reported to stdout.

       get [[4mkey[24m]
           Retrieve the item, or the value of the item identified by [4mkey[24m. If
           successful, the result is printed to stdout.

       getsize [[4mkey[24m]
           Determine the size of the item, or the size of the value of the
           item identified by [4mkey[24m. If successful, the result is printed to
           stdout.

       help
           Prints a usage summary to stderr.

       list
           Lists the names of all items (or keys) associated with the
           [4mitem_type[24m.

       load
           Read key/value pairs from stdin, one pair per line. The end of the
           key is denoted by the field separator character, which may be
           repeated. Whitespace may appear on either side of the field
           separator character (unless the field separator is a whitespace
           character). For each [4mkey[24m do a put operation with the specified
           [4mvalue[24m. This is intended to be a quick way to initialize a filestore
           or make many changes.

       put [[4mkey[24m]
           Replace the item, or the value of the item identified by [4mkey[24m. The
           value is read from the standard input.

       putval [4mkey[24m [4mvalue[0m
           Replace the item, or the value of the item identified by [4mkey[24m, and
           set it to [4mvalue[24m.

       rename [[4moldkey[24m] [4mnewkey[0m
           Rename the item, or the value of the item identified by [4moldkey[24m to
           [4mnewkey[24m.

       update [[4mkey[24m]
           This is a synonym for the edit operation.

[1mEXAMPLES[0m
       To store the DTDs used by [1mDACS [22min a database rather than in a
       collection of files, you must configure an appropriate VFS directive
       and copy the files from the [1mDACS [22mdistribution into the database.
       Because it is read-only, this database can be shared by all federations
       and jurisdictions on the host.

       The first step is to select the type of database to use and decide
       where to put it. This example will use a Berkeley DB database ([1mDACS[0m
       must have been built with support for whichever database is used) and
       put it in /usr/local/dacs/federations/dtds.db. The URI to express this
       in the VFS syntax looks like this:

           [dtds]dacs-db:/usr/local/dacs/federations/dtds.db

       The next step is to create the database and load it with the DTDs. A
       simple shell script makes this easy to do. From the dtd-xsd directory
       of the [1mDACS [22mdistribution, and replacing example.com with the URI of a
       [1mDACS [22mjurisdiction on your host, execute:

           #! /bin/sh

           for i in *.dtd
           do
             dacsvfs -u example.com -q \
                 '[dtds]dacs-db:/usr/local/dacs/federations/dtds.db' put $i < $i
           done

       To configure [1mDACS [22mto use the database, a VFS directive must be put in
       an appropriate place in dacs.conf so that it overrides the current
       configuration:

           VFS "[dtds]dacs-db:/usr/local/dacs/federations/dtds.db"

       To list the contents of the database you can do:

           % dacsvfs -u example.com -q \
               '[dtds]dacs-db:/usr/local/dacs/federations/dtds.db' list

       or since the VFS directive has been configured, simply:

           % dacsvfs -u example.com -q dtds list

       If you omit the [1m-q [22mflag, various debugging output will appear,
       including some feedback that your new database is actually being used
       by [1mDACS[22m.

           [1mNote[0m
           If you copy any [1mDACS [22mresources, such as its DTDs, remember that
           when you upgrade your [1mDACS [22msoftware you'll need to make new copies
           because these resources may have changed.

       Other resources used by [1mDACS [22mwould be configured similarly. The load
       and dump operations can be particularly useful for this. If the file
       /tmp/roles associates roles with identities (e.g., as used by
       [34m[1mdacscheck(1)[0m[1m[22m[6]) as follows:

           bobo:users
           auggie:admin,users
           harley:guest

       then the following command initializes or updates a database from that
       file:

           % dacsvfs -u example.com -q -F ":" \
               '[myroles]dacs-db:/usr/local/myapp/roles.db' < /tmp/roles

       The URI [myroles]dacs-db:/usr/local/myapp/roles.db can then be used
       with [1mdacscheck[22m.

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mBUGS[0m
       There should be a caching mechanism that could be used with expensive
       storage types (i.e., those that are relatively slow to access, such as
       the http scheme).

[1mSEE ALSO[0m
       [34m[1mdacs_vfs(8)[0m[1m[22m[5], [34m[1mdacs.conf(5)[0m[1m[22m[4]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[7])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[8] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs.vfs(5)
           http://dacs.dss.ca/man/dacs.vfs.5.html

        3. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        4. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        5. dacs_vfs(8)
           http://dacs.dss.ca/man/dacs_vfs.8.html

        6. dacscheck(1)
           http://dacs.dss.ca/man/dacscheck.1.html

        7. www.dss.ca
           http://www.dss.ca

        8. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.40                       02/01/2018                        DACSVFS(1)
