arch_get_kernel_flavour () {
	case "$SUBARCH" in
	    loongarch64|generic)
		subarch=`uname -r`
		echo "$subarch"
		return 0 ;;
	    *)
		warning "Unknown $ARCH subarchitecture '$SUBARCH'."
		return 1 ;;
	esac
}

arch_check_usable_kernel () {
        case "$1" in
            *-dbg)
                return 1
                ;;
            *-loongson-3 | *-loongson-3-*)
                # Allow any other hyphenated suffix
                return 0
                ;;
            *)
                return 1
                ;;
        esac
}


arch_get_kernel () {
	echo "linux-image-$1"
}
