.TH XScreenSaver 6 "20-May-2003" "X Version 11"
.SH NAME
cloudlife \- a cellular automaton based on Conway's Life
.SH SYNOPSIS
.B cloudlife
[\-display \fIhost:display.screen\fP] [\-foreground \fIcolor\fP] [\-background \fIcolor\fP] [\-window] [\-root] [\-mono] [\-install] [\-visual \fIvisual\fP] [\-ncolors \fIinteger\fP] [\-cycle-delay \fImicroseconds\fP] [\-cycle-colors \fIinteger\fP][\-cell-size \fIinteger\fP] [\-initial-density \fIinteger\fP] [\-max-age \fIinteger\fP]

[\-fps]
.SH DESCRIPTION
The \fIcloudlife\fP program draws a cellular
automaton based on Conway's Life, except that
cells have a maximum age, and only one pixel per
cell is drawn every tick.
.SH OPTIONS
.I cloudlife
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-mono 
If on a color display, pretend we're on a monochrome display.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-cycle-delay \fIinteger\fP
Time in microseconds to sleep between ticks.  Default 25000.
.TP 8
.B \-cycle-colors \fIinteger\fP
How many ticks should elapse between cycling colors.  0 to disable
color cycling.  Default 2.
.TP 8
.B \-ncolors \fIinteger\fP
How many colors should be used (if possible).  Default 64.
The colors are chosen randomly.
.TP 8
.B \-cell-size \fIinteger\fP
Size of each cell, in powers of 2.  Default 3 (8-pixel cells).
.TP 8
.B \-initial-density \fIinteger\fP
Percentage of cells that are alive at start and when the
field is repopulated.  Default 30.  
.TP 8
.B \-max-age \fIinteger\fP
Maximum age for a cell.  Default 64.
.TP 8
.B \-fps
Display the current frame rate and CPU load.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1),
.BR xlock (1)
.SH COPYRIGHT

Copyright \(co 2003 by Don Marti.  Based on
examples from the hacks directory of xscreensaver,
Copyright (c) 1997, 1998, 2002 Jamie Zawinski
<jwz@jwz.org>

This man page based on the man page of sierpinski,
Copyright \(co 1996 by Desmond Daignault.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation. 
.SH AUTHOR
Don Marti <dmarti@zgp.org> 20 May 2003.  

