# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class TaskActionsList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid, task_sid):
        """
        Initialize the TaskActionsList

        :param Version version: Version that contains the resource
        :param assistant_sid: The unique ID of the parent Assistant.
        :param task_sid: The unique ID of the Task.

        :returns: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsList
        :rtype: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsList
        """
        super(TaskActionsList, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, 'task_sid': task_sid, }

    def get(self):
        """
        Constructs a TaskActionsContext

        :returns: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsContext
        :rtype: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsContext
        """
        return TaskActionsContext(
            self._version,
            assistant_sid=self._solution['assistant_sid'],
            task_sid=self._solution['task_sid'],
        )

    def __call__(self):
        """
        Constructs a TaskActionsContext

        :returns: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsContext
        :rtype: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsContext
        """
        return TaskActionsContext(
            self._version,
            assistant_sid=self._solution['assistant_sid'],
            task_sid=self._solution['task_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.Understand.TaskActionsList>'


class TaskActionsPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the TaskActionsPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param assistant_sid: The unique ID of the parent Assistant.
        :param task_sid: The unique ID of the Task.

        :returns: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsPage
        :rtype: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsPage
        """
        super(TaskActionsPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of TaskActionsInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsInstance
        """
        return TaskActionsInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
            task_sid=self._solution['task_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.Understand.TaskActionsPage>'


class TaskActionsContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid, task_sid):
        """
        Initialize the TaskActionsContext

        :param Version version: Version that contains the resource
        :param assistant_sid: The unique ID of the parent Assistant.
        :param task_sid: The unique ID of the Task.

        :returns: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsContext
        :rtype: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsContext
        """
        super(TaskActionsContext, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, 'task_sid': task_sid, }
        self._uri = '/Assistants/{assistant_sid}/Tasks/{task_sid}/Actions'.format(**self._solution)

    def fetch(self):
        """
        Fetch the TaskActionsInstance

        :returns: The fetched TaskActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return TaskActionsInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
            task_sid=self._solution['task_sid'],
        )

    def update(self, actions=values.unset):
        """
        Update the TaskActionsInstance

        :param dict actions: The JSON actions that instruct the Assistant how to perform this task.

        :returns: The updated TaskActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsInstance
        """
        data = values.of({'Actions': serialize.object(actions), })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return TaskActionsInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
            task_sid=self._solution['task_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.Understand.TaskActionsContext {}>'.format(context)


class TaskActionsInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, assistant_sid, task_sid):
        """
        Initialize the TaskActionsInstance

        :returns: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsInstance
        """
        super(TaskActionsInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'assistant_sid': payload.get('assistant_sid'),
            'task_sid': payload.get('task_sid'),
            'url': payload.get('url'),
            'data': payload.get('data'),
        }

        # Context
        self._context = None
        self._solution = {'assistant_sid': assistant_sid, 'task_sid': task_sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: TaskActionsContext for this TaskActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsContext
        """
        if self._context is None:
            self._context = TaskActionsContext(
                self._version,
                assistant_sid=self._solution['assistant_sid'],
                task_sid=self._solution['task_sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The unique ID of the Account that created this Field.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def assistant_sid(self):
        """
        :returns: The unique ID of the parent Assistant.
        :rtype: unicode
        """
        return self._properties['assistant_sid']

    @property
    def task_sid(self):
        """
        :returns: The unique ID of the Task.
        :rtype: unicode
        """
        return self._properties['task_sid']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def data(self):
        """
        :returns: The data
        :rtype: dict
        """
        return self._properties['data']

    def fetch(self):
        """
        Fetch the TaskActionsInstance

        :returns: The fetched TaskActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsInstance
        """
        return self._proxy.fetch()

    def update(self, actions=values.unset):
        """
        Update the TaskActionsInstance

        :param dict actions: The JSON actions that instruct the Assistant how to perform this task.

        :returns: The updated TaskActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.task.task_actions.TaskActionsInstance
        """
        return self._proxy.update(actions=actions, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.Understand.TaskActionsInstance {}>'.format(context)
