#! /bin/sh

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

BASENAME=$(basename $0 .pl)
TMP_TEST_DB=$(echo tmp${BASENAME}$$ | sed 's/[^-0-9a-zA-Z]//g').db

DB_DIR=db
DB_FILE=${DB_DIR}/test1.db
TMP_DB_FILE=${DB_DIR}/${TMP_TEST_DB}

cp ${DB_FILE} ${TMP_DB_FILE}

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}/bibliography"
export HTTP_HOST=restful.domain.net
export REQUEST_METHOD=POST
export QUERY_STRING=""
export REMOTE_USER=writer

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';
echo "==="

${INPUT_SCRIPT} \
    column%3Aauthors=S.%20Gra%C5%BEulis \
    column%3Aauthors=Andrius%20Merkys \
    column%3Atitle=CGI%20applications \
    column%3Atitle=CGI%20and%20DBI:confluence%20of%20powerful%20interfaces \
    column%3Ayear=2017 \
    column%3Ayear=2018 \
    Save=Save \
| sed "s/${TMP_TEST_DB}/tmp${BASENAME}pid/"

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';

rm -f ${TMP_DB_FILE}
