% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomart.R
\name{getTSS}
\alias{getTSS}
\title{getTSS to fetch GENCODE gene annotation (transcripts level) from Bioconductor package biomaRt
If upstream and downstream are specified in TSS list, promoter regions of GENCODE gene will be generated.}
\usage{
getTSS(genome = "hg38", TSS = list(upstream = NULL, downstream = NULL))
}
\arguments{
\item{genome}{Which genome build will be used: hg38 (default) or hg19.}

\item{TSS}{A list. Contains upstream and downstream like TSS=list(upstream, downstream).
When upstream and downstream is specified, coordinates of promoter regions with gene annotation will be generated.}
}
\value{
GENCODE gene annotation if TSS is not specified. Coordinates of GENCODE gene promoter regions if TSS is specified.
}
\description{
getTSS to fetch GENCODE gene annotation (transcripts level) from Bioconductor package biomaRt
If upstream and downstream are specified in TSS list, promoter regions of GENCODE gene will be generated.
}
\examples{
# get GENCODE gene annotation (transcripts level)
\dontrun{
    getTSS <- getTSS()
    getTSS <- getTSS(genome.build = "hg38", TSS=list(upstream=1000, downstream=1000))
}
}
