// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from LuaService.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.luaservice {
  public class Manager_2_0_0 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("luaservice.Manager:2.0.0", null);

    public Manager_2_0_0(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Manager_2_0_0(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Manager_2_0_0 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Manager_2_0_0(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int NO_ERROR = 0;

    public const int ERR_INVALID_NAME = 1;

    public const int ERR_NO_SUCH_SCRIPT = 2;

    public const int ERR_MAX_SCRIPT_NUMBERS_EXCEEDED = 3;

    public const int ERR_MAX_SCRIPT_SIZE_EXCEEDED = 4;

    public const int ERR_MAX_ALL_SCRIPT_SIZE_EXCEEDED = 5;

    public const int ERR_NOT_TERMINATED = 6;

    public const int ERR_NOT_RUNNING = 7;

    public const int ERR_INVALID_ADDR = 8;

    public const int ERR_TOO_MANY_ARGUMENTS = 10;

    public const int ERR_ARGUMENT_NOT_VALID = 11;

    public class SetScriptResult {
      public int _ret_;
    }

    public SetScriptResult setScript(string name, string script, Com.Raritan.Idl.luaservice.ScriptOptions_2_0_0 options) {
      var _parameters = new LightJson.JsonObject();
      _parameters["name"] = name;
      _parameters["script"] = script;
      _parameters["options"] = options.Encode();

      var _result = RpcCall("setScript", _parameters);
      var _ret = new SetScriptResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setScript(string name, string script, Com.Raritan.Idl.luaservice.ScriptOptions_2_0_0 options, AsyncRpcResponse<SetScriptResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setScript(name, script, options, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setScript(string name, string script, Com.Raritan.Idl.luaservice.ScriptOptions_2_0_0 options, AsyncRpcResponse<SetScriptResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["name"] = name;
        _parameters["script"] = script;
        _parameters["options"] = options.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setScript", _parameters,
        _result => {
          try {
            var _ret = new SetScriptResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetScriptResult {
      public int _ret_;
      public string script;
    }

    public GetScriptResult getScript(string name) {
      var _parameters = new LightJson.JsonObject();
      _parameters["name"] = name;

      var _result = RpcCall("getScript", _parameters);
      var _ret = new GetScriptResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.script = (string)_result["script"];
      return _ret;
    }

    public AsyncRequest getScript(string name, AsyncRpcResponse<GetScriptResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getScript(name, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getScript(string name, AsyncRpcResponse<GetScriptResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["name"] = name;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getScript", _parameters,
        _result => {
          try {
            var _ret = new GetScriptResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.script = (string)_result["script"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetScriptNamesResult {
      public System.Collections.Generic.IEnumerable<string> _ret_;
    }

    public GetScriptNamesResult getScriptNames() {
      JsonObject _parameters = null;
      var _result = RpcCall("getScriptNames", _parameters);
      var _ret = new GetScriptNamesResult();
      _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
        _value => (string)_value));
      return _ret;
    }

    public AsyncRequest getScriptNames(AsyncRpcResponse<GetScriptNamesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getScriptNames(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getScriptNames(AsyncRpcResponse<GetScriptNamesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getScriptNames", _parameters,
        _result => {
          try {
            var _ret = new GetScriptNamesResult();
            _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
              _value => (string)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DeleteScriptResult {
      public int _ret_;
    }

    public DeleteScriptResult deleteScript(string name) {
      var _parameters = new LightJson.JsonObject();
      _parameters["name"] = name;

      var _result = RpcCall("deleteScript", _parameters);
      var _ret = new DeleteScriptResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest deleteScript(string name, AsyncRpcResponse<DeleteScriptResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return deleteScript(name, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest deleteScript(string name, AsyncRpcResponse<DeleteScriptResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["name"] = name;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("deleteScript", _parameters,
        _result => {
          try {
            var _ret = new DeleteScriptResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetScriptOptionsResult {
      public int _ret_;
    }

    public SetScriptOptionsResult setScriptOptions(string name, Com.Raritan.Idl.luaservice.ScriptOptions_2_0_0 options) {
      var _parameters = new LightJson.JsonObject();
      _parameters["name"] = name;
      _parameters["options"] = options.Encode();

      var _result = RpcCall("setScriptOptions", _parameters);
      var _ret = new SetScriptOptionsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setScriptOptions(string name, Com.Raritan.Idl.luaservice.ScriptOptions_2_0_0 options, AsyncRpcResponse<SetScriptOptionsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setScriptOptions(name, options, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setScriptOptions(string name, Com.Raritan.Idl.luaservice.ScriptOptions_2_0_0 options, AsyncRpcResponse<SetScriptOptionsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["name"] = name;
        _parameters["options"] = options.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setScriptOptions", _parameters,
        _result => {
          try {
            var _ret = new SetScriptOptionsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetScriptOptionsResult {
      public int _ret_;
      public Com.Raritan.Idl.luaservice.ScriptOptions_2_0_0 options;
    }

    public GetScriptOptionsResult getScriptOptions(string name) {
      var _parameters = new LightJson.JsonObject();
      _parameters["name"] = name;

      var _result = RpcCall("getScriptOptions", _parameters);
      var _ret = new GetScriptOptionsResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.options = Com.Raritan.Idl.luaservice.ScriptOptions_2_0_0.Decode(_result["options"], agent);
      return _ret;
    }

    public AsyncRequest getScriptOptions(string name, AsyncRpcResponse<GetScriptOptionsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getScriptOptions(name, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getScriptOptions(string name, AsyncRpcResponse<GetScriptOptionsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["name"] = name;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getScriptOptions", _parameters,
        _result => {
          try {
            var _ret = new GetScriptOptionsResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.options = Com.Raritan.Idl.luaservice.ScriptOptions_2_0_0.Decode(_result["options"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetEnvironmentResult {
      public Com.Raritan.Idl.luaservice.Environment_2_0_0 _ret_;
    }

    public GetEnvironmentResult getEnvironment() {
      JsonObject _parameters = null;
      var _result = RpcCall("getEnvironment", _parameters);
      var _ret = new GetEnvironmentResult();
      _ret._ret_ = Com.Raritan.Idl.luaservice.Environment_2_0_0.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getEnvironment(AsyncRpcResponse<GetEnvironmentResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getEnvironment(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getEnvironment(AsyncRpcResponse<GetEnvironmentResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getEnvironment", _parameters,
        _result => {
          try {
            var _ret = new GetEnvironmentResult();
            _ret._ret_ = Com.Raritan.Idl.luaservice.Environment_2_0_0.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetScriptOutputResult {
      public int _ret_;
      public long oAddr;
      public long nAddr;
      public string oString;
      public bool more;
    }

    public GetScriptOutputResult getScriptOutput(string name, long iAddr) {
      var _parameters = new LightJson.JsonObject();
      _parameters["name"] = name;
      _parameters["iAddr"] = iAddr;

      var _result = RpcCall("getScriptOutput", _parameters);
      var _ret = new GetScriptOutputResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.oAddr = (long)_result["oAddr"];
      _ret.nAddr = (long)_result["nAddr"];
      _ret.oString = (string)_result["oString"];
      _ret.more = (bool)_result["more"];
      return _ret;
    }

    public AsyncRequest getScriptOutput(string name, long iAddr, AsyncRpcResponse<GetScriptOutputResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getScriptOutput(name, iAddr, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getScriptOutput(string name, long iAddr, AsyncRpcResponse<GetScriptOutputResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["name"] = name;
        _parameters["iAddr"] = iAddr;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getScriptOutput", _parameters,
        _result => {
          try {
            var _ret = new GetScriptOutputResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.oAddr = (long)_result["oAddr"];
            _ret.nAddr = (long)_result["nAddr"];
            _ret.oString = (string)_result["oString"];
            _ret.more = (bool)_result["more"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class StartScriptResult {
      public int _ret_;
    }

    public StartScriptResult startScript(string name) {
      var _parameters = new LightJson.JsonObject();
      _parameters["name"] = name;

      var _result = RpcCall("startScript", _parameters);
      var _ret = new StartScriptResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest startScript(string name, AsyncRpcResponse<StartScriptResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return startScript(name, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest startScript(string name, AsyncRpcResponse<StartScriptResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["name"] = name;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("startScript", _parameters,
        _result => {
          try {
            var _ret = new StartScriptResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class StartScriptWithArgsResult {
      public int _ret_;
    }

    public StartScriptWithArgsResult startScriptWithArgs(string name, System.Collections.Generic.IDictionary<string, string> arguments) {
      var _parameters = new LightJson.JsonObject();
      _parameters["name"] = name;
      _parameters["arguments"] = new JsonArray(arguments.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
        new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
        new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value)
      })));

      var _result = RpcCall("startScriptWithArgs", _parameters);
      var _ret = new StartScriptWithArgsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest startScriptWithArgs(string name, System.Collections.Generic.IDictionary<string, string> arguments, AsyncRpcResponse<StartScriptWithArgsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return startScriptWithArgs(name, arguments, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest startScriptWithArgs(string name, System.Collections.Generic.IDictionary<string, string> arguments, AsyncRpcResponse<StartScriptWithArgsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["name"] = name;
        _parameters["arguments"] = new JsonArray(arguments.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value)
        })));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("startScriptWithArgs", _parameters,
        _result => {
          try {
            var _ret = new StartScriptWithArgsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class TerminateScriptResult {
      public int _ret_;
    }

    public TerminateScriptResult terminateScript(string name) {
      var _parameters = new LightJson.JsonObject();
      _parameters["name"] = name;

      var _result = RpcCall("terminateScript", _parameters);
      var _ret = new TerminateScriptResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest terminateScript(string name, AsyncRpcResponse<TerminateScriptResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return terminateScript(name, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest terminateScript(string name, AsyncRpcResponse<TerminateScriptResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["name"] = name;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("terminateScript", _parameters,
        _result => {
          try {
            var _ret = new TerminateScriptResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetScriptStateResult {
      public int _ret_;
      public Com.Raritan.Idl.luaservice.ScriptState state;
    }

    public GetScriptStateResult getScriptState(string name) {
      var _parameters = new LightJson.JsonObject();
      _parameters["name"] = name;

      var _result = RpcCall("getScriptState", _parameters);
      var _ret = new GetScriptStateResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.state = Com.Raritan.Idl.luaservice.ScriptState.Decode(_result["state"], agent);
      return _ret;
    }

    public AsyncRequest getScriptState(string name, AsyncRpcResponse<GetScriptStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getScriptState(name, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getScriptState(string name, AsyncRpcResponse<GetScriptStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["name"] = name;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getScriptState", _parameters,
        _result => {
          try {
            var _ret = new GetScriptStateResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.state = Com.Raritan.Idl.luaservice.ScriptState.Decode(_result["state"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetScriptStatesResult {
      public System.Collections.Generic.IDictionary<string, Com.Raritan.Idl.luaservice.ScriptState> _ret_;
    }

    public GetScriptStatesResult getScriptStates() {
      JsonObject _parameters = null;
      var _result = RpcCall("getScriptStates", _parameters);
      var _ret = new GetScriptStatesResult();
      _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
        _value => new System.Collections.Generic.KeyValuePair<string, Com.Raritan.Idl.luaservice.ScriptState>(_value["key"], Com.Raritan.Idl.luaservice.ScriptState.Decode(_value["value"], agent))));
      return _ret;
    }

    public AsyncRequest getScriptStates(AsyncRpcResponse<GetScriptStatesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getScriptStates(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getScriptStates(AsyncRpcResponse<GetScriptStatesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getScriptStates", _parameters,
        _result => {
          try {
            var _ret = new GetScriptStatesResult();
            _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
              _value => new System.Collections.Generic.KeyValuePair<string, Com.Raritan.Idl.luaservice.ScriptState>(_value["key"], Com.Raritan.Idl.luaservice.ScriptState.Decode(_value["value"], agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
