
Test ccs on 100 zmws from the lexogen-SIRV dataset, using --byStrand

  $ $__PBTEST_CCS_EXE --minIdentity 0 --minZScore -100 --maxDropFraction 0.8 --byStrand $TESTDIR/../data/100zmws.bam test.fq

  $ grep -c ^+$ test.fq
  200

  $ cat test.fq
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/170/ccs/fwd np:i:5 rq:f:0.995204
  AAGCAGTGGTATCAACGCAGAGTACGGGAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCCATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTTAGGTGACCTTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGGAGGCTGTGACCTTCCACATCCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCATCCTATAATGCTAGGTTCTTAAATGTCGTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTTCTGGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCCGAATGGGGATTGCACCCAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAGCGGGTAATTCATGGGCTACAAGTCTTGCAGTATGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  CkZN[ZgGjLYfN>jNZMEX[ZeENAnh<WMDXgHO/<IMNoMB7CX[ZfIM$gjkkkkkkkkkkkkkkkkkkkkkkkkkkkjAArEe[Nh[NXF1b[M@ILX)g-JH+V8ja9L@tBYN[gLnEN[BseTQe:r^GNYISNEAsZ@L/pJSN[?[VFl7_UEhN[ZgZgZ[nN;laKLmUSLBWgY9ooooiL@0kGlfMAR([o@kONgTNg[b?_[gNZI[OXLXYl78iM;mmc?I;f@DU,=[UKL,/(@W>mmmVK6XVNM8dJW9XmBdDnnNeFBUiLA>lBMYDnnmV=lYc>XXR[XEeZgKl<_\/ApZ.ssYX9ngNQHLKLX'SILdBmmNoZ[nNO*LXa1;?pFlM2hnnfMEYeMEOf;['MYAd[5rg[Bv[n[XEXNYFlZ<g3LbYe+02JC_ENZYZ>nfNd8;ieWB<,klX[BvgKk9dNgNeBL=leNfN`O`J8kR[gYMBdOoX9YM?mmLDXeA%R>9XOoMfK[NKnKKogNnBmmNWKAIEMBlJBKBMY(mlVR3LcZ[Bv/9.>BQDdWL3ueZCaFV.j9]AqECqZnNRNDnndBYNhZ>ZUgOoLo[NYk1rZCqf8[oZ,cJdWENHPNZ[LLX(^^[W)[NZgMEe[0vfT_8PXZ,rrUK[g[gXE@rB?UXECuZg,+)XO[;]qgN[>OCR99kb0kDnn[nBv[<tu[g[M8kOyDd]N_7ziJ[6DJ;ZzgU}bUgubZdegeO~~edTSPm1w~~PyXe2~lfT~PddWKrge`\-xxcfbJxK~~CmcEde:~m=~~tF|Tv0znFTE|~eWda-~1oocZVg>~~RRe4~l>6PEhnf3e`Zddd)mBlG{Y0mJwW&78Ru@lesNeK~f}J~T/JN,~aW~WedYcV~YcXvgWnZueo,S{C~z4sd`/MKV`S0T;cgY}|MeugtbKP|dl?seNVg}XvdBX{|KXBddAbs*TF}JYH~vepFdWfpF~eUZW~dcfXe=cNjVG@fMd|DijUsNVsPcJ|vLSNe}dPDpMV/yzWeuU6,aUMx/ej^<zcbUgcYQ~UvdfdbUvgcH~gp1\Gm5~cL3eISg}XesLM6iMz7~j0~~~qdgu`ZucPS~TSrNH~gesNZdDNjd<iWI\$IdfuXvXheH~f}XvW~_[XSzBcguXeXeugeXvdN,|||eeoJ=JOHobe}Me}gVLadVPmVugeuI{N7F`9X<C~L|feD~cBs;gQJ0kbteguH~geyQQQPkQddMseRh`|X~t[H6kW`VQD~guK~vguX~kHVveD~e|VSx2~~ueuQMZVsPF}}}}eH~cBeWfp]^efVO9~}dG;BfuGngcWdZdeuheqeV}}etUYcVPsWf}F|tesLRJ;zcrBd?~~U8u`]cPFyK<~nR|WubhU~pUdq?TKP|LesRB`k^\ueuU^tgeWEs4isWgf}B~~eVRsAncC7USKpXuesLRy*JB~~~zU~gesH(@\@PlVegXvWUng}geVPE~[:qgesD}Xf}Q~XerBcuW~[J~guWKWTYcVM>xeVwW@PJ}}x`Ab1w~frAb`aeL|vBeesL8~OhF(A.HMaU~WvgueXtQXvesPduVQqX>ue]6o:~NU~uXdR|@||WverLpboesPH~sN*{}|ICs%RR7R~f}S~WETG>Cy}}fR~drcZV`\ueWa9V||A}fJuD{O@GX~gud:e^uT~ZB:mWblKhBe|b;GhfWds(Vde3~~tU~uEkiT}uU~qbLsL||fJ}MN~~aOak@:pNGN{foee}OMLP|cE}}|WsPV=x~}dX~Wb:G~oTmLIj?y|`M=v>Sd}MpBcWsMdWOrEU7s~fRkdVa[U~f}GhHawuX}k>aWc?UaL~FaDODlOM{REW+T:aaZcuK~~W~Me}gmJ7kgd}eO%>hn`A}uVPcXSWf}cU~W@}~jMChOcR|fd8}}lJAHwzF5`UOeguW5iWb_9nVeVRRI7g}thes/~iK=a?%=^PZDc^gWfA=PeWpUvWc;[nZm2[Lr/~~peX~uD~~~P_{LAd?orW~WgXg}edYT~X~uK<SXVeWbYNH~^_mTu-{{{dDfWNYJ~d8Y%y{cH~vTs.~ifdg}L7o@GGR>seuegXsAqO~uXeG~Mc7~duO~~Wep)L`GCeWpUgnQyWU~L}}eT}FngWeWQ}VF|U~O~~T~YWtf;yfVQ|dK~o%aV:o[dV~ObBdl9{U'ZPVF{duXf}cV`ZsPsd0}eebugXvXveXc<zcgudH~gXveXu~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/170/ccs/rev np:i:5 rq:f:0.996289
  AAGCAGTGGTATCAACGCAGAGTACGGGAAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCCATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCATCCTATAATGCTAGGTTCTTAAATGTCGTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCCACCCAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  MkMZgNE?rUg[ZVkLNSeNgN[gY:vv[nNVJIZAq[eEX[nZNZeMeMIfY$gZ_gkkkkkkkkkkkkkkkkkkkkkkkkQEkg[gXVZYNgBvgZN[UD0SXRPIe?[[YZ8kMgTB00qeWKKoYI6Y6^P@\gYYBdGkNFl;oYgZgLoONnCni9S@KLY9YNNlY8mmV?[`HYc60:8cmmmlYM.`BdEXNoAp`3SZSZgZ[eELneEXM.jXg[N=lSBuY4mmma@TWNNogGnNoXCmXKQ+llleYBmmNZ[nY9RNnN[99dY[g9ND<^HYNZO4}}|Wg}WfH~rPrXudCa<{Ov3mAzs*zusKGw|dgVLNceAzdX}FccX}W7tdXgeWRcWDzR~`:~~~~sKZgeudcc}QS9OHqAzfuS~X~tSKUFPVuuU~D~fH`XbugugsMqXr3{{_geg}fWN>HccWvQ~_7~ceMddPVdP|N^IbO`CcZ{RvgXeXgg}VMqZGu~eq>GqB~veXf}=k{kd<}eK~e={&uedVKWbu_SweXeueW6|f`I~bWvU~f`WRCngXgU~gWT~YTF{cb&luU~W~KWa:~^H)bbIJeuXgXvH~vdE{=~sTz9Iq~u'qWAApLP|a;H]IqHccubQZbBQdqNUL~}WQdudZI~~Xb`R_<TuS~WQkBrU~Wd9{[IXYI~v9bu=]Fi`%xDv=njC[U~nFwokgue\f6jGz}b7=~}eP5e[HcxuIoien[VeuXuX/{bWtPcugG~~}X~cYL~~uH~uXtPUPsXvgY}}WvgQm@ouK||LVvU~f,ykef},gC|sT|9jiVL>WP~F~wWget=~oYcWM}}yRJ?i~uS}V:qUamC`gPS&9gP|LVuJ~aeBdV\Se3yT~sMqe9{V~eVZdXV~gXeguefVO@cODM.yyP{0vsU~sMrdQ|dXt?||+mgq:qXTtBHXIrVaC][PfMK^sUbdudbVxcdT~WMR~gWFU}dugR~Wege{WWddV?xrgud:~p4`4xg^9UegsB<wktguWx?aSoR]Sv|b?_a._WQ3yL~}WX~WsMrXeEx^DQtVtefnRQ~ugeudPT~uWT{Bb>d]WbOjU~L{U~f+~}^WugtW=Us9sNafPL7nBdp,WbI~U(lY^^PS~o5H5IYBT|Qg^:d}Xgd6~cUlb[WdWbNO`gTQA~~~uVN]dXvT}DHeF1gueLfA8`PbPsV:PyZp5oU~uU~F|tTL^tegGy6j$SdUcaR~uL{ZbgeguXvVaAe|Ux[y:mcL~ctcPT~sNP}Kqee|gXegs7^BmcF|Y}}gXeMSbegs-{{{sVQzVNseugugXveu4bDUdrdq7Qfo<QbgtFQdEPF0vzV[ZdB>qheW|^heXM>_BVzWQdt1||y<w~kU?R~uK~}EzZKAo)~ccBdegWX~Umgue8RBXcXMe}b]geg}T|c^dLpHyvAGF|dgXeg}gsPceVMA$aWQc4|||vB~uWfrU~Fd]H~dXvdPcg}L~uXem<q`]ftWRGUIPhJseXgeXde}PP[sgcANdgTY<Sk>1wcud=~~~teWL~~tcbWs>^@mzKS/^GQ~nSCCYdgugA{cPc=Va9`ecXNXQLMrgeX~uUmgU~u,hdGLAq4~rdhS_ugn_DagU~eV&ZffbeWcd&H(LOHjeP]u`Et~~uNiAV*aeU?L@cWZ;FH>y`U~e}QVdH~sgWR|Ve+kb`%pcdVbEpbIyXuT~Ya2w<^BfK~~eHi:J|u>~X>r]TTyD~wZT~WX}}WfV?cpguWG}sd=8\_STUu@7duf\PsdG}}zVR|dX\T~gebbG]1|cWe9~WuGyVgeXegXucYeeW<~~uc9@b4yDmUzD~X}}gg}fR|dVNeWEt9{LUMcZPg^'~bfK|w@Rc*GSaxO>HK@WT~tF|ULr=~mWL||duXeueL~s<~c<~}qTP~uXH~uWG~~}_L-`\_L||dXvgeB}eXvU~Q`_VMO2k]guXg*z[WeXbseW`BMyWvdN8{bXef_PcXaLQVfT{BdJ]rWQ|O9xvVdRfA'oq=}zQ|dudGeCse;Z<zdeCygcBcWQUD{Vq77zL{}{WU}]TP@rrTs3{xVT~PJyF~~vTC]FeJ^WeXedD@FucL=`G~PbWT~WvU~GeHo}cQF8x||dudPaWLA|eH~A}sWC|R~ueU]IwNe}IwU}o<~eee[L~~uLzW<xdR|Ve.~ngf}Fd]tb1PbQbhueg}UbdE{VcURM\L,<m~lU8pegdPVeS2_>nguS~ueeB:=H
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/230/ccs/fwd np:i:6 rq:f:0.995083
  AAGCAGTGGTATCAACGCAGAGTACGGGGATCCATTTTGGAGGGGTGGGGATTTGTTCAATGAATGAGGCAATAAACCACCGCAACCTCTGTAATTGACGAGAAACTTGTATAAGGTCATCAAAAAGAATAGATGAACATAAAGATTGAATACGGCTGGGTGAGGTTAATTCAGATTTCCCCAAATTATGTAGATGAAAAGATGGTAAGTTTATTGATAGGTAAAAAATCAAGAGAGGGTAATAAAGAAGAAAGAATAATCAAAAGATAGAGCATGCAAACATTACATGGTAGTATTGTTATAGGCGGTATATTGGTAAATGACCGATCCTTGACTTAGTTTTTTACATCGAACGGTTGCAAATCCTAGCATACTTGATATTAATAGTAGATACTGAAATATATCTGAGTATATCAAGGGAAATCGAGATGTAACAATAAGTCGAGGAAATTAAGGTCAATTTAGTGCTTATCATAGAAATAACTACTTAAGCCCTTAACGAACTAACTCAAATTAAACGAGGTAGAGGTTATTCTGAATTGTACGAACGTAGTCGAAGTTTGTTACCAAGGTAAAGCCAAAACAAAACGATTTGACAAGAGAATCTATTCCATGTAGTAGTGCGTTTGTACGACGTTCTATTCGATGTAAATCATTAGGACGAGGGTTTGAAGCAACTCGGAAAGATGGTCGGTTAGAATTTAAAAGTACTGAACGGAATTAACGAAGTTGGCTACTACCTAATAGTCTTTGCTTAGGATTTAGTAGTTCGCAATTGGGTCAAAGTGGTCGCTTTGGTCGTCGACGTCAAGACTCAACAAGTCATTTACCCGCTGTACGAACCATCTCATTTAACAGGTTCTCAACCAAATAGCGGTAGGAGTAGAAAGCACTTACCATCGTACGAACTTTGACAACGAAAGGTTCAAAGGTAACCAAGGCGTAGTAGTGAGTTAGGTCAATGTATAAAAACTCCCTTTCTTATTTTGAGTCGTCAATGTAGTCGAGAAAGTATGCACTTAGTGCCATTATTATTAGACAAGATAGTCCGTTCTTTAGTCGAAAGTTCTTGTTGTAATAACAAAAGTAGAGCAGATTACGATCCGAAATTTCATGGACACAGATATTTGAGATCAACATTTGATTCGTTGACGTATTTATGTTGATTCGGTTAGCGAGAGTTACAAAGTTAGTAATAGAAAGAAAGAGGAAATAATAATCAAAAGATTACAGCATGCAAACATTAAGAGGACACATATGTATTGGTGGCATTTGCGCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ayhM>gtL}sUrODgFTOhhhhqXPHtvxgr>~VGuuuXxSCzzx^6zyj_=wte*tNVt^fVYlhhWvOXvtLvr/[TA~dIBbD~xOxhtFtVwfSPhfQMwuOguhthrG^VvtN>qM(<EU\gHa[hhhtOR\/EMISPWhQVhWvpS?K[Pv>uushhWvdxXvbvOhf=Kut'~~ULdc[`)mf]VhYsZ2tttd>]Fwn3qf<tteSweNj_Vus-tttttq?TtcighLvvtDzs6ttfGtgNvvhWwqH^sN(W^QPcscdhhQhtiO.u[OhguWPXlCsrXg^fcV^.IO]dYtOWvsSrhbxK}t=xmXhO&hgSp=~esg`?BtdQ2vvvvqcLSrGhGtNCsMvf<AqusA~xhhQhtSOoi^_f_\iHl_[^cA\XL^HfK([IO[dWJG`]_]gIf^hIAb8ii'fghI]_]_h^fBdH8bhPj^hI]INj:RS]iNjPihIOUBgiH^h^ITW=H9\XH]FjjRJiJjIIUjPj^4{n\i?gJ]IgIhNcJi7(YbS`*fOHZR;ee\^]Oj[i^Ic5i^9lViCVGI^LiGEOWKf7]Pj^CLd[%M[<p@U)ddHjj^=n3^`WH5ehhGEFGij]IHPeYG]PjgIgGBg:XWc^eSFe^^gHH]Fjj]fG8[II^]iIh^FiH^^?YgEbM`@T[iIMi4H^^HkkDii]?g]IGhJZI;T;ii\SSNiP4KLJh]^9[EfM7gii]gIGLF,IF?iKdDfHU@P8T]SkPkIh4HjJ:^j;kg^^eE7aj^HHhFNi^4ki^^gI\JhFTC:TIh-jWNF9Qe]hOjhI\5EgjOjhJ^f5\I7]f6KaK^GR7K]6Kd^c4VK`H\'t`W3d^f25RH];mZN3OFFChi@\1W@o\fGRF,e>K)dff_^IQjh^Oj]^VY[7_h\7?IJh\1jJL4[a4H_PjHCKd]D6HZES:ia;gGg6FgjOjfH7+nLeNh5]gI^gI\eV\]:kG@_GGPjg\LR\,ajjU0_7{t2YXIUh[4KKb]I^f6]hIMjgGe_^cI^]]5ee]b0JEH^JUj^Jh^:x_\iYKhVJUZ]GG=]I]dL\R.w[9cHRcf4\eH]5:M]XJGWcV8j\hHacJiJ=eQDJL-V]^I^ZLWe4H^\R+t\6h_Dh]9ORNgN14E\]ROA=`C[YK^hJJgI^EKd^^PiHGXJ\I7Fc^DjhH^BDJ]^]iIOjXf?HG\SRWK&jXGCicYIh\Jd(FPX^EaMY(2G\SIGBkk`MifLUhJ2ea`BIWJD)WHFF\,38dhH^Yf;Q]^Nd:ILIMe;'YL]I`@dgOkI^HjdHE0F$dfffffcYNKLQZcffffffffffffffff]]`/4RHh]J\Lk]YL^3D4Ij^J]i
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/230/ccs/rev np:i:6 rq:f:0.994209
  AAAGCAGTGGTATCAACGCAGAGTACGGGGATCCATTTTGGAGGGTGGGGATTTGTTCAATGAATGAGGCAATAAACCACCGCAACCTCTGTAATTGACGAGAAACTTGTATAAGTCATCAAAAAGAATAGATGAACATAAAGATTGAATACGGCTGGGTGAGGTTAATTCAGATTTCCCAAATTATGTAGATGAAAAGATGGTAAGTTTATTGATAGGGTAAAAAATCAAGAGAGGGTAATAAAGAAGAAAGAATAATCAAAAGATAGAGCATGCAAACATTACATGGTAGTATTGTTATAGGCGGTATATTGGTAAATGACGATCCTTGACTTAGTTTTTTACATCGAACGGGTTGCAAATCCTAGCATACTTGATATTAATAGTAGATACTGAAATATATCTGAGTATATCAAGGAAATCGAGATGTAACAATAAGTCGAGGAAATTAAGGTCAATTTAGTGCTTATCATAGAAATAACTACTTAAGCCCTTAACGAACTAACTCAAATTAACGAGGTAGAGGTTATTCTGAATTGTACGAACGTAGTCGAAGTTTGTTACCAAGGGTAAAGCCAAAACAAAACGATTTGACAAGAGAATCTATTCCATGTAGTAGTGCGTTTGTACGACGTTCTATTCGATGTAAATCATTAGGACGAGGGTTTGAAGCAACTCGGAAAGATGGTCGGGTTAGAATTTAAAAGTACTGAACGGAATTAACGAAGTTGGCTACTACCTAATAGTCTTTGCTTAGGATTTTAGTAGTTCGCAATTGGGTCAAAGTGGTCGCTTTTGGTCGTCGACGTCAAGACTCAACAAGTCATTTACCGCTGTACGAACCATCTCATTTAACAGGTTCTCAACCAAATAGCGGTAGGAGTAGAAAGCACTTACCATCGTACGAACTTTGACAACGAAAGGTTCAAAGGTAACCAAGGCGTAGTAGTGAGTTAGGTCAATGTATAAAAAACTCCCTTTCTTATTTTGAGTCGTCAATGTAGTCGAGAAAGTATGCACTTAGTGCCATTATTATTAGACAAGATAGTCCGTTCTTTAGTCGAAGTTCTTGTTGTAATAACAAAAGTAGAGCAGATTACGATCCGAAATTTCATGGACACAGATATTTGAGATCAACATTTGATTCGTTGACGTATTTATGTTGATTCGGTTAGCGAGAGTTACAAAGTTAGTAATAGAAAGAAAGAGGAAATAATAATCAAAAGATTAAGCATGCAAACATTAAGAGGACACATATGTATTGGTGGCATTTGCGCAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  'tQQhs=R@qfqRfVwgOhl'f=Qrh6~~~vSXzp56[UAzX*vs?3b~~tMbjNVZT]MeQ`qgMb>~ibrM>uvM}sWbMc;qUvfgYLT_xVvOwhDE)@TcgUk<e^fds*PQq__%ttn<<PsTj+1OP`s_qh[uuRo-XQasTsh?kRf:~~hPb?rXvcuSphtOo2q\,orAwgEpjRNfrOqMN<s^ZNvf/~gguO<eSkXvLqRn%~QS/VWdhVfhMc7N1Q2DkRUwfAu_OQsPI[SMdlgTtWYCWaQGjM^9V=^UO:UHVlhmCnp_Xg2~WlOcoSc9CjU13=dL-iNngo4_7Q]TltS-tg<pMPUDW;uhBt_;,guvvqjN[NU;P`Z%~[@hQh.xldCsfrOdXdWRPnN]HVTY`n7n+en)VFTh`@KmVh`WrScWOaNhthqXhNH$~Zruhg<nOEaOJVrheu>euCh\AY<~NsvDzgu?uhhdsKW^sPe*bSpsIIpG\@=bvh_STS\aNgNVNHb7WxSsgNKa_g`xhSQQpRTUguhOr6W?j<u?qXvs8sfhL]W2<<_ohQ]vhRhrQhhOTtOKvtQRwtYzcd,~~RNr[@K^@nuugGuutf=d9WWKwhI[>sQarX_6lRxYys>MgsOhqLAHe(2XG8`^hP_fQ7reR^FtPNuQ?QMrV)WWPSqC~qhOv0~p?phOguOhgueWg2rMID3RdCqQ:-zf@msOSt@lYGuuuOhthf<fthA~drSrdsf.Ep+/=/~fSqQftWvdLpSrPUg+]6<hPpl>~w%pmWW<QrOBoJJ6Kr>T%nu`KNlsOe0~RgOR'j=2.oA]@X]0Uc.]LarPlQQe0tgWuN>Pr@xxpBe*bf<cXg?_wWvtQgRgtMZnTtgt<rEsgcQJVLt@XpaQKd2~hrD~uAfZMNprOirc/flRrn8PPhthOguhC_W<uhguhO\ut>~Dnf9tt@~gTtVvguD~h@ha@UVQTN_N?b8/~fhgugOSrg'surohhhNwwMvvMSx];vuhLtNSgPSgdv?NSrOhhOxONtj<d]]@f^dDmrAhAXwtXupALRPrpLwh]q?oWsNUVvQPX[:Tfe6\^HLhHAh]OaH377>.d]]i^?jj_FZd6iJ]eJiBjg]Gb^@`GNid4fj\S[3uk^h^fIc4O;igGiG9GSYgKQ7k[IkPj]9LWHW^HIf8cMU:H6XGQ@j]=p?ggI^IkIj8MXh]Cif5&bfHW9[IeJ3jXIFfdIk<_9ffZYj_Yj^^@jjeHkMl]iJ^f4GGAdK[`7kOeJg={k]h]g_g^I^g?e3TJ:u^d<dgI]I^%iiiiihhaUMOWbhhiiiihg_YaOHGe]H[3F^IIfFiJeOjh^^I^6t
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/301/ccs/fwd np:i:6 rq:f:0.994115
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTACTGAAGTTCAATAACTTCGATGGTTACGTTGTCCTTAGTAACTGGGTTAATGACCTAATGACTGTCTCCCTATACGTCAAAATACTGCTCTACTTTTGTTATTACAACAAGAACTTCGACTAAAGAACGGACTATCTTGTCTAATAATAATGGCACTAAGTGCATCTTCTTTAAGCTAACGATTAGGTTGTCCATTAGGTAACAATCACGGATAAATAAGTGGCAGGACTACGTCAAGCAGGTAAACCCGCAAGGGCATAGTGTGCAAGTCCTTACTCAACCGTTTCGTTACGTTTTGCTTGGACACTTTCCTCGACTACATTGACGACTCAAAATAAGAAAGGGAGTTTTTATACATTGACCTAACTCACTACTACGCCTTGGTTACCTTTGAACCTTTCGTTGTCAAAGTTCGTACGATGGTAAGTGCTTTCTACTCCTACCGCTATTTGGTTGAGAACCTGTTAAATGAGATGGTTCGTACAGCGGTAAATGACTTGTTGAGTCTTGACGTCGACGACCAAAGCGACCACTTTGACCCAATTGCGAACTACTAAATCCTAAGCAAAGACTATTAGGTAGTAGCCAACTTCGTTAATTCCGTTCAGGTACTTTTAAATTCTAACCGACCATCTTTCCGAGTTGCTTCAAACCCTCGTCCTAATGATTACATCGAATAGAACGTCGTACAAACGCACTACTACATGGAATAGATTCTCTTGTCAAATCGTTTGTTTTGGCTTTACCCTTGGTAACAAACTTCGACTACGTTCGTGACAATTCAGAATAACCTCTACCTCGTTAATTTGAGTTAGTTCGTTAAGGGCTTAAGTAGTTATTTCTATGATAAGCACTAAATTGACCTTAATTTCCTCGACTTATTGTTACATCTCGATTTCCCTTGATATACTCAGATATATTTCAGTATCTACTATTAATATCAAGTATGCTAGGATTTGCAAACCGTTCGATGTAAAAAACTAAGTCAAGGATCGTCATTTACCAATATACCCGCCTATAACAATACTACCATGTAATGTTTGCATGCTCTATCTTTTGATTATTCTTTCTTCTTTATTACCCTCTCTTGATTTTTTACCTATCAATAAACTTACCAATCTTTTCATCTACATAATTTGGGAAATCTGAATTAACCTCACCCAGCCGTATTCAATCTTTATGTTCATCTATTCTTTTTGATGACCTTATACAAGTTCTCGTCAATTACAGAGGTTGCGGTGGTTTATTGCCTCATTCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  2aHMOF:;yKObCAmR2TaYbYfhY$]dd]`ktz{{{zume`_`cfea_bhhluz{zjdDOP@aKWzYEyLWzZV|DYb]M{U{hZZDzD[3SEl&BcAnLK1FMSpC^`CNG`d>:V[hZe[\@dC|~c;cgTWdZ3ydcc_VeZVaWdQX7||oAPwTDT4QE_YKxZGzYS_R@LU^-W`VBKXIrPGc:cXDZX_.\D\]OpIM[\FsCMXePIXQX3Z;>AvVKqiUxERJJgDU^V|QK~@pZaJrfG{84Y]KwZJ[5N$J7Q*H'F[dU^YeL{VRMsLUZ:U[a.CwZZhK}M5rI6\rZJX|,j<5ccOY_UNYZH|Z[<]G{bFX$;pHzW:[qUHUaRYW)<?CWWTf<aLUgYM}|)daZ[g[fgYPV~ZQBCfU]X1zyn`:gR1r\5v}fZ9}~~xge^RhX}ZM97<D<YfZhVKQXdQU-;QTwK~E{gIu0zz[X|Lp?{tSAQYBcV0]\B%uXZ]6XT1L>meK|[fYD>[lDdeE`KzehBL0XdQ<s[A\@xVfYD_5bKXAv6Tpe[g[feK{HaD7SXBO?B@va:TQRQM?CfK=lUb/G]Si\;SFeN_h7M\O}+cRIXHR>F8aIaBXk8AAGLZlKVIJhW=DImHuunS~l+dGU4rqbZ^a[<|Z=~UYbmRN8_BmYMyWKHoAbXd3oWXt`Q74-P66LkO)fg@k^T<>NZSW@o`[O:uX>yblOZ~8KNpZ@Uc5cWFHXXMok`rgDC'pYJk\LUYjaiXUmP/[\QgfVIp^@VEaP^^\]]RPY@X8I]^TaDlHfW6cVf\BqlVRP.poL3YpZJYTOleH6pqM|MqdXqMHuu^UzDEgNb;M,<5C;M)/RIVHq?gX7TMOc@hY?W\&wXM_F^7W2I^PYI/bl`'oLLFzX`FszZJnK_R<Z6/Re@qi_molfrYb~e`\ZO&ojZ~aXP~]~Q~J~~RrqbeudZgg>~M-yD_a(ZEDBQIonCqnQ~cIX`p\`X3fcroo_nR~~cobkYoNklep[P~HbVlsb@~dnIk^bYHS~pA~~ec;si:fU7yACckaq;~~rreMjHbKVD'f9tmkeem\gB~i[NX,~nqri*pIFLmT[WMqLO~[hN\hGYinE'YnreH~l_4.idLpcrjOc6}~vds`~HO~cR~~_R~d-{a[^~H<~~b[[`a~dB6~~~~|i:jhsoN`~nTs~NP~oR~)lrd;rZdL\mbnoXqgEtStj:~nK~~qbVM@~OiJmAthNTDv~iNDrdro_~L>~pcJ~~tmOJ~bqN?Vr^a%<a~~~eupM\5~]~CPN[K~N)hIX`e[M`~>~m^h7oOvO~cNS~rO~W~~o[mcN~j_n_~?~~hartP[QmNbaN~d[XmI~L_redr~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/301/ccs/rev np:i:6 rq:f:0.995521
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTACTGAAGTTCAATAACTTCGATGGTTACGTTGTCCTTAGTAACTGGGTTAATGACCTAATGACTGTCTCCCTATACGTCCAAAATACTGCTCTACTTTTGTTATTACAACAAGAACTTCGACTAAAGAACGGACTATCTTGTCTAATAATAATGGCACTAAGTGCATCTTCTTTAAGCTAACGATTAGGTTGTCCATTAGGTAACAATCACGGATAATAAGTGGCAGGACTACGTCAAGCAGGTAAACCCGCAAGGGCATAGTGTGCAAGTCCTTACTCAACCGTTTCGTTACGTTTTGCTTGGACACTTTCTCGACTACATTGACGACTCAAAATAAGAAAGGGAGTTTTTATACATTGACCTAACTCACTACTACGCCTTGGTTACCTTTGAACCTTTCGTTGTCAAAGTTCGTACGATGGTAAGTGCTTTCTACTCCTACCGCTATTTGGTTGAGAACCTGTTAAATGAGATGGTTCGTACAGCGGTAAATGACTTGTTGAGTCTTGACGTCGACGACCAAAGCGACCACTTTGACCCAATTGCGAACTACTAAATCCTAAGCAAAGACTATTAGGTAGTAGCCAACTTCGTTAATTCCGTTCAGTACTTTTAAATTCTAACCGACCATCTTTCCGAGTTGCTTCAAACCCTCGTCCTAATGATTTACATCGAATAGAACGTCGTACAAACGCACTACTACATGGAATAGATTCTCTTGTCAAATCGTTTTGTTTTGGCTTTACCCTTGGTAACAAACTTCGACTACGTTCGTACAATTCAGAATAACCTCTACCTCGTTAATTTGAGTTAGTTCGTTAAGGGCTTAAGTAGTTATTTCTATGATAAGCACTAAATTGACCTTAATTTCCTCGACTTATTGTTACATCTCGATTTCCCTTGATATACTCAGATATATTTCAGTATCTACTATTAATATCAAGTATGCTAGGATTGTGCAACCGTTCGATGTAAAAAACTAAGTCAAGGATCGTCATTTACCAATATACCGCCTATAACAATACTACCATGTAATGTTTGCATGCTCTATCTTTTGATTATTCTTTCTTCTTTATTACCCTCTCTTGATTTTTTACCTATCAATAAACTTACCATCTTTTCATCTACATAATTTGGGAAATCTGAATTAACCTCACCCAGCCGTATTCAATCTTTATGTTCATCTATTCTTTTTGATGACCTTATACAAGTTTCTCGTCAATTACAGAGGTTGCGGTTGGTTTATTGCCTCATTCCCCGTACTCTGCGTTGATACCACGCTT
  +
  :F8V[+$)ZSSTZVlZUA`AcYQdD%cZeqyyyyyyyukbWKEDGQckd``e[PLSdie[QX>nZKeZC{RRzVTvQ?aN:f7vd[YE_XQJz4wbDb5zYh=~qWzEd8VM;wOFdJ&VEITKZeC~z]cNJXF]+V']fSRdZQG/bZb[ZDr^qPBY]0qcZE{ZVyZU|ZX}[XKYb8pWCDz[J}dDeffD6SFf[cSyQV}QVdR@rY8OSW}YQX[c;WDTX?mzW}Z[hX}ZW]X}eJ|GiCeL~eXyX4l\<B>@UaIIBEwMeLdS=%NF7EXeFvNYQd[KEIHbWEeHz_F_e9[C-QOy=vcDJ8YHUG>+XHbTQJaX|e[cT2x7yR>h]R>B_KWD?{}_DWD\;sd[fZ=rXXaBT\ZfMYeT]Ac[ZfZfA.ki\>1]I@`\5z~lc?mg=4Xa?Lj[iaqU~s\~UTTqS[nSr[NJL`;iN~^~lMv>~{b`~R~J{|dcP~_mdR~xK+~`M]pdLl\NwA5ZOrTNN~p`Wpc]T~]oS~b]KQ9NO<xAeGbW]mQ[OC/`R}~]`X]Tp=j=~aG@T_jbcB|XBo~B`qeQubAqRTaqeOl[l_MZ;JVbQqR~Q~~bP6kM~mdPVc7kIvv_qMkbbdZoNlicr4~~qR~^N~cdE~e$h`tpMkpL~]oLBeNNb:~K=~b8(n;w7~O~bP~craClN5{mdByuXd`QO~R~HWR~pZ`5a]NjcqcVxNLK~MEx^:}~[>bFD~\INEJRQ~~gLVqcMY~NicK~d^k^`[R_Dh~a7aqb0kNqm7ke=hMc>TYBPrOnZ<o_iMLUmecM?~~~bF~~uQvNL~pq(~?:~B~\a~d-~ldP~_Hm[[WbcSv\Ii`%[tCR7SD<~q]nR~FbtqU~WLab~YbMpoGn]>~oc`~`]^~Jv(~KGHoM~blR`P~U(hN[QcW^j]\n_Nk_V4q~Q~bo@~O~`~Tn~O~\a8^NN~kZ~Y2VVNVTLnacqV~x:~bIjV]H<?T`E]JIQRLXiEU`7iO]jTP@mc]n>~\~Gnsd^~^pVZQaVeMvUJ~%`KUOsMwWDKC[n[\+/gmonj\?NsO[KO~Q~p]bMoLV?~~pR~K~hl1g?~L5ym]nK~M^~H]bEZA~psc`I~sc;qxc`iZ_Ij_koGbIjJobqb~o;d\B^M^J~`D~~W`~rH~rsbFaU~dp0~po~~pOiD>ncP~pDxjJJ~p9hZleB~~oJotesnKSVL~:~fEpzR~xobrM_~a~J~R~sdq3~~qcM~ctqa~d:~XL:~np^JMYdqtdqWJ{`9\stxcqrMoMa7Nkmic`~MG~~c]b_S`^~R~pdqcqI~S~bNP~)D@~G~~j9~]TzD`Z_~9~~cLZmKgZr=bN>sYooY5}K>->Q'
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/322/ccs/fwd np:i:8 rq:f:0.998736
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTACAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTGGATGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACTGTATTTGGTAGAGGCGACGGGCTTGTTGGTCTTCCACACTCCGCTCCCTACGTGCTGAGAGTGGGGTAAGAGCATGTACCTTGCGCCTCACACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  N~qx~v~M~~\~t?~np`~s~rkos&~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ql\Zp~k~~u`~nu~mrq~v~u~vQyO~lZ~lu~at~vu~_~o~pi[skinYmuN~~b~m]`~_p}Ou^~~t~q~w~q~Y6~~L}\~u~toS~~c~a~~qP~quk~uR~~~mho~sp~ru~a~u~v~N~~V~~~o^~_eY~o~u~`~,~K~~b~u~Q~~5~~~~omv~q~i\p:~smp~w~~q~C~~G~~|V~~r8~VZ~M~sIqS~~tB~~u_~~~~^~]~q~~u~f~dqg~J?~iN~oP~p]~a~ovt^~~p~Q~~qz[r~su~\sc~utC~~~L~Y~tq~v~P~~t`~L~l^~c~~Q~uPoF~~M~cH~w~t~n<~t~~r~9xd~~vL~~v~`~s~[~~_~^S~~t~J~Z~(~cb_~^~<~kltM~G~~~p~su~~uW~~yy<wm~{C~{l|Y~Rick}kX~wiV~H~aj<~~~tW~kX~|W|zhxljaYcxh*~Uxdni{U~xVM<rRcRylkglm{T~wfPV~~G~{lW~jA~zq[}{`~l}{l|k}{[~h~L~`UkhukOvj[Ssvj_Ni{hwY~|yVufPxluXR*g]OC~{mmmzzbwTxj-~~[.~`ajfyhvK~J~~~eWY~P~~{Y~{T~N>~~xTzlzcWfRyhy1~~~{VykymX~yexbBezl~DpRBd>~~vetglzX~sh{[~{V~~W~u`|Z~^VwkV~eX~|P~~N~~1|ji{leX~gkzkyc{zzi~l{lh~mxulkP~~W~O~~V[~~llh~V~@~~myl1~}l@vkwk\YeIdvU~~lr3fly}Y~~L~xfiPW~lkgkH~dGd~lj~[~xmi~[~{myjaB~hlyA~~ygll{mjbk}k~j|C~~~xD~SbYWw`kwY,vh~jWk2jajgl|W~T~h[kg~kU~kg~|?~~~~}xmg~X~xAabqgx}jVwT\?v^Nqbrqd~jdkvX~iujzfa+~~~~{iO~~lE~~ly_1~~|yfkzVwSKJRWtA~W{jS~jtV~\~~l{E~~uC~xZ~U~k{ebWskkUZ~wT_zl?~~~l{{WylxVklZ~equOX~|l{lnt~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/322/ccs/rev np:i:8 rq:f:0.998264
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTACAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGATGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACTGTATTTGGTAGAGGCGACGGGCTTGTTGGTCTTCCACACTCCGCTCCCTACGTGCTGAGAGTGGGGTAAGAGCATGTACCTTGCGCCTCACACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  m~tr~<i^~~n~vg~t_cqp~tp~u&~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}z^~N~r~~v\~kso~uuoZ>J{s`~a~q[~~tipolo_psrp~vrqq~s^oz\c~~\~lpsY~vrs~a~~_~qVooa[~9~[G~Lvt~v~6~~]~O~YrO~tvb~uW~~~u{rt~rk~u~T~\~p~]~.C~~~p^~so_~q~s~P~I~`~~u~a~9~o/~~~SJ~oo~~~w~R~sr~rt~~[~5~~@~~lN}~v`~~b~c~s`tp~~uP~~vo~~~~_~jv~~fA~_ntua~t&~FF~pT~t`~]~qtuY~~i~s~~]~uvjnu~reL~ttF~~tQ~P~a7~sla~qtZ~^~p_~b~~s~p\~_~~T~~<{~^rqup~wugI[`~8~~\`~~ujt~K~N~nb~qX~~si]~r~O~~vc~b~N~^|u^~@~~~u~vu~~r5~~q~2~~~VH~~v~M~~u~u~pl~~q^~a~p_;~~~~f~v`~U\~[st]sr~]`]^~a~tiu{U}~lhrhHpGzuqdmZUR~WZsT~~Q~~rG~ed~~wt~l\~kdnq~]MVV~V~`~~q~g~5\~r~ojg^~{_~Q~O~l~]~t~xtjuo*[d6^~~t`k+~o~u~u?~~~~]~WVan\s~OuL~~~~vp~+~~~U~~M~~_~~~v~v~~uu_~r~:~~~~rqqioJ~~kXjsp~vxL~p~\>~~qW~tq]~~s~M~nW~~a~~`~R~~tpr_~~Q~VP~~)~]N~~t~u~R~~v~uxs~v~^~[ffZ]T~rtv`~~_~`~~uX~~q`l~\~U~~tnHQ~~~b~v~r~ni[~ZL~~uuuq^~e8~~[~~~up`~uv~aAl~tj~kZ~X~ms`~_~~^~qsc~uq~S~~~~L\p_p~u~q~srE~~~md~u~[u~o`~l]~iyf\Y^~~v~sm]~o~mP_R~rW~pL~~3x~~~~~vQ|O~qS~~~e~ipt~[~=~n`qt~Uk~ursq^~`~r~qj(~ol~~t9~~ta~~u~~W~~~~~u~vrr~~n5~]~Q~t]~iq^~O~oFT)~~~;~v_~[~^krmr~iVs\~isb~tE~~~s~dk~v~u_m>~\wj}Y~wekV_*~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/335/ccs/fwd np:i:9 rq:f:0.998712
  AAGCAGTGGTATCAACGCAGAGTACGGGGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAAGTCGAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAGTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTGGTATCTAAAATGGGGTTTGCCGATGCGGTCTTCAAAGTCTAAAATTCTTGAAGTTTGCGTTTGGTCGCAAAAATTATGGATTTAGTCGATTATTGCCTACTAAGCCAGCAGTTTAGAAGTTTTTAAGATAGTTACGCGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  p~oZ~t|:~u}|p.ulthWnf_wOk-~~~\i~p~N~~pQ~~palrN~~|mr[~vTdE~Xiy`}qMPips|H]~tlg~L~x~kHzbz~[~IzGP|Z~~^~d'jEg~B~q~pYgkkTx{Uzrpj~kgyZqc5Y[gmHj{P~~mzrGqJUC{h~]~\~qsniC~\l~toYmooa~wgrbw`Yt[I~s}Y[~t~oajzp~opuiN~~~x5wKrYi~pyXpcrpt~pzf^~lZDR\T~YZ~rYezchB~fR~sM~|mX~_~eoV~kO~~trkzS~~rXF:n{YahM~~~qsh~~ppQ~~`~dkTUi1~~~idTcloukWU~hRvS4i~mpU~cJnm~sZ\~jrDl~~t~p~tq~~kU~i~t]~nVOfug~{O~}NUpOYh~I{a~~otZJ~~~t~lpP~~jYQS~a\~sluptqw`H~R~\Q{nN~d`dMypq/~~u~rt~th~re~k[~Oj~rjY{sX~fL~|~]gsH~^n[~l>~z~~w~P~yzk\ebY~v{\xRCptnlap~}uvT~~cR~yuY~xy;~~9~L8Ujdx{lcxgwir=~~vh~~~~rft~{5a~mx|g~wwnT~~~b~~N~~g~~_~~f~L~{EP~~^~~wh~z~mv{k~lZ~zyX~~P~~]zrc~~E~~mt~du~r~{Gssrcb~xav~lclI~~~sG~~_*m~z[~md~^~}b~f~s_~z\~~{kL~gb~e~~t~c~qf`q{tc~b~E~~zX~~|~zRd~z]_ud~xsKr~~8Y~Q~zfqat~dyux}t~f~U~V~q~g~a\~QPndnxHv~n~ovgL~~~d~r~`OXl~Q~Bzb[~y`~tLw~_~srD~~~t~z}~C~~~{~dg~~b~vZ~~z~R~+~~~~vd~fq~b~eK~\~~`~df~`\a~P~_~Hn~fb~~iO~~Rrmb~9~~fQ~a]~cw|~Q^~~}q~tirc~[z~g{D~~~O{S~|a~~z~Z~~q^~|~u`n~}R~~xzO~~cm~~X~~|gd~Q~~a~Y~~~y}~f~~S~~uc*~~ga~~4~~~NY|zKp~RsOZc~wv~Y~~~Ie~~do~Q~Zn~x=~~pf~~~Qvuq~zO{~uN~p|~v~r~vUQ~W~~m~X~~xYU~~u~Zv/~yx~F~~~Q~~|P~{~~RgU~l9`~^A~~}~_t8~~t_~yv~{[j|_~~ybz'~~X~qbNa@~~~~l~~~?~~_~~~~~P{~c~X_~{`~~~w~XmU5~~}u~tf~~~ht~nI~~~e=~|\}g_[~lfF3w%~~~~~~~xv~~~~~~~~~~~~~~~~~~\P~apBk~ztfc~|~~~[~~wthx~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/335/ccs/rev np:i:9 rq:f:0.997391
  AAGCAGTGGTATCAACGCAGAGTACGGGGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGGACTATGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAGTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTGGTATCTAAAATGGGGTTTGCCGATGCGGTCTTCAAAGTCTAAAATTCTTGAAGTTTGCGTTTGGTCGCAAAAATTATGGATTTAGTCGATTATTGCCTACTAAGCAGCAGTTTAGAAGTTTTTAAGATAGTTACGCGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  T~n`X;FQbel}s\~spt~]~p~~sC~~~d/~RZQjUAAr~zh{oB~~~sZ\jhn~]~Y~{of`gO{d.fHK|Yr>j;fUdqI~qzcj~YXp6~M~mJ~|~YGehY~\TXXarp_~RM~~m:~ng|kxptrJ2~h\_[~~YzkO~K~d~l~[~i~q7D9j~DM~,EcyR>5`A][s^ep~[r~m=Xi~nnYUfho~qYdbY~j|dK~]|tg~^|_nmlunBd:^K~f_FDTJ~]]~otawerV~}F~f0o`Uh~G~x[\~YU~~]|og=~~z_xnFuoo@O~~~viL{}^kW~z9~dI~{w>~~|[z|plYduq[~dM~~s[~zs_~~}jU~k]Y~gKS~~eUDnzjtje\]~~~aC~v]tgZ[~jH~~\K~kpe~U;)iYQjp@~~~kh]nA~rep~b~pY~p~Fpkr`Tg~[~^ZmY`~ZgxXT[nn~ll]fg\i~Xh~sX~];k[_iplF~cE~KzA:ZA~msU~j;~~~o]QY~l}XSGq8~ygV~i?~~~~oT|Hqp3~|o\~d]f~\UM{kT~o?~~~qnTH_nLdlX~z}H~aY}w]m}q}Y~o^k[~s~s@~~oR~~L~pR~~R~~S~<~~y`~y4i}pq~q{i~ok}~}y\Z'~d\~~sViT~~@~~|I9mZlibWu`fq^]~q[~~p~q<~~~}C~cj_~hYT~~i~\~`UY)r{U~r\~|plD~`E~F~~i~Y~tmLa(ihsxgm.~~aO~~mfitg~RrZ~_lr}^~WzM~tN~~m\nm~]mo~p/e\~p~Y~hj&~[OfZkoiqW]~zY~~]jO~~~shY~spty_K~j~tg~oS~BE~~ny[~P~~}\~]j~L~~`i~q`vcC~Wzywo~<v@~~~~rimpj~smpM~]~~[mqY~u~h~[~Y~Z~f68QT|Z~ht~~I~@~~~X~IZ~E\jlrB~~g6{J\U?~~p~tpQ~~~_nk~me~mr~@~~rG~XzZr<neX~~^UG}}\^~sMbZ7xsub~YE}G~~~~d~V~~e~~~dE~~~h~|F~~~eb~]V~~vz9n{~x]~Q~~~D~~~wa~p~dt~e^~~rp~y~wqub~vvssgvs~xrd~t~}~O~V~~p~L~~c~b~~mr|~A~~~~H~~~bw~vA~v~be{]~~zV~z`~~uq|tG~~~m~}^~sp~uV~~]{\P~~Ixu{wd5va~yQ~kjM~~,~~~h~|v~o~~;~q`~~~}~s~wg~Yav`$jGiiPvl%Wm~~(Xfq_}XKppbl^t$~~~~~~~~~~~~~~~~~~~~~}|~~~pjismv~|~Ivc>eQ}l~`~~cVXsr~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/413/ccs/fwd np:i:7 rq:f:0.997698
  AAGCAGTGGTATCAACGCAGAGTACGGGGATTGGATTAAAAAAGTTGTAGTAAACCACAACGAAGTTAGGTAGCTGGTAAGGTTATAGATGCGTTCTGTCGTTGTAGTCCCAATGAACATAGTATGGTTTCGCATAGTAACTGACCTAAAAGACCGCCACATAGTGAAAATACTTAAAACGCAAGTTTCATAGGATTAAGTGGTAGAGGCTATAGAAAATGATATCATAACTATAACGAATATAACAGCAAATTAAAATGCACTGGAAGTGGAAAATTTCAGCAAGAGAGTCGAAGTCGTCATAGATTAGCATGGACGAAAGAAAAGTCGCAAAGATCGGAAATCAAGACGCAAAACAAAACGGAGAAGTTCAAATCGAACTCGTAGAACATATCGCTGGAACATATTAAACTCTTGGTATCGCTCAGTTACAAAAGGAGACACGTAGACACGAAAGAAACTGGAACAACAGACATATTTGTGGATAATGGCAATTATAGTTAAAATAGTCGTAAATTAGATTATGGTGCACCGGGGTGTAAGTTTCGAACTCGGTGAGGCAATAGTAGTATAGACTAACAACAAGGTAGACATTGCAATGTATTGCGAGAAGAACTTCACGAAGATATAGATACAGTACAGAATTTCTAGGATTAAGTACAGCAGACGTATTTACACCTGTTATAGGATACTTGTTCACTTAATCCCTGTTATGACAAAGTAGTCTCATAGAATTTTTAGAACGAGAAGATTTGAATGGACGTAAAGGAAGAAGGTCAAAATGGAGAACTTAAAAGGGGAAATCTAGAACATTGAACCCAACATTATACAATGATATAAGAACGAAAAGACGAAGACAATAAGGTCCATGGGATTTTACCCAAATGAGGACCTAAATCACCGGGAAGAAGTAAGTAAACATAACGATATAGTTTTAGATTATCGAGAAGTCGAAGAAGACCGGGATAGGTAACAGATAATCGACGTTTGGGAAGACGGTAACGTAAGAAACTGAGGAGGTTAAAGAACTAAGAATCAACAACAAGAAACTATTGTCCGCTATTCTACTTAGGTATCTGCTAGTATGCGATATGGAAGTTAAAGAGGAAACAGTAGTATGCACTGTTTGAGAAAATTAGGATTTAAGAGGTGGAGAAGTCGTTAGTTTGGAAGCATAGATAGTTCAAATATCCACAGAAGGCTATTAAAAGATAGAAGAGAGTCGAGAGATCGATTTTAAAGTCTGAGTCGAAATAGTTTGGTGCAAGATTATCCATTCAATTCTTATCGAAAACTTACAAGGTCAACAAGTAGAGATAGCAATATAACTAAAAGCTATCTATTGAACATAAATGCGCGACTACAGCTTGCGGGTTAACACGGTCGTCTTCATTATACGTTTAATCGACGCCGGCTTATTCATGCAGATATTTAACTCAATCTTCGATAGGATAGAGGACGTAGTAGACTTGGATGTCTGTCATCCAGACATGAGACATATACTTATATGGATAATGGTAGTGCAGCAAAGTCGTATAATTTAAACGGTATGGGACGAAGCTAACAACATAGAGGTGGACAACGTATAGCAGGTAATTGTTAAACTTGTTCTGGAAATAAAGAAAGAAATCTTTTGGACTATGGGCGTGGCATTAGTATCAAGAGTAGTCTTGGTTTTGTATTATATTGGCAGTGAGCTTATTCGTAATAGACGTAATCTGTCGCACTTACGTTTAGCCAAATTAGGTCCGTGAAACAGACACAAACCTATATTTATGTGGCCACGGACAAACGAAAACTATAAGCTACTCGCATTCTGAGGTCTTGTTGGGCTAATAATAGACTGCAATCACGTTGCTGGGGTGGTATCCTTAACTAACATATGGTATATTTCACTTGGCGGTCGCCACAATAAAGATTTAGAATCCACTGGCAGAAAGTCAGCGCATTTTTATAGCAGACAACTTGCAAAGGGAGAGGTTCATGCAACGTGTTATGGTGGATCAAGTTATCTTAGTAAGACATAAACTTGTATAGACAATAACAGTGGCGGAAATTAAGGTTAAGATAATTGTAACTATAGTTCCGGGAGAGAACTATTTAATTCCGACAACTTATAGCCAAAATAGATGAAATAGAGCGTATAAAACCTATTCTTCCAAGCGTACTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  d~mICi]YrhLNCDQ1Y5jokC`hHHs~|WSz\~if~/~{J3Qmft\sXUY:~u=g^I?mZmZzVZ~n^~}YmFa[~`Gu]~Y~n~opf]n^pj~[~q~^oY~pz@iz9~uZ~chDI*OaknMSoTiU~~_pWT{mq}L~Yn=C9a}L~~~jg>~l){3:1^BiiX4~|hci[i~;y~qDeVQkjO~~CbhVLrT@~M~[wI~{Vk?G|VeLldU9n~~}pi|lsZY}V~]vez)z\oJq]BmT|GeiYN~~cj%tdcbnGeToJpX~p~Ty:r~qO{~HjXJRmmVkUi~^oL~pyCi|]nu\[ci~jd3k~\~CZnD~~pJ~~~p~Xj]Blrioy\Z~O~~w^^~pnVRF>joy];~~_H]rmXF{dA~X*~gfZ@K~]|E?sXOM~^mteHJp[aG~Lm\Y{ohg:~{]~^f~Z~~oy[mG|^ol+~V]G|~oE~TXeFl]q}mib]m]n'~~m?HnW~ZlYz4C`]nqmIm}YQ~~jB[~o~]~tY~^W~htW}mYl~;~~zdnq|Ho}@~rj~oqnU~e~^~zBYmM~M~~~~q{(vk?~~]oNsJ}^I~weT]~^]~ulndmq|Xx@nn^~@u\7kH6iH~blpn^pn~p\Y~~q{pl~WD?ln[soK~Hl~\SFiZlkoyTTfnm~l\oohlKYlO~Tt~\vBFhAl~X~p~gDWoYjpo^ndm^~~V[f:k}oY~lOf]~nij[PoZQ~Xe0e~Is_:~~~oX~XudWGOtjp~pqy.pHnxYgGiG~~~~ik'X]pmkLkjoQ~~n=~|]~lHo~T~~\~VyeH~]~~]>~}sj^~ooI~Zd~:~~cJ~~~T~~~[dmp^~Yjigp[~@~~LvHX]YAnfHH_}peJi}\~XN~^p?mo~olMo\sll[EkkO~R`|K~Y|E~~n$~hdZ>QcD~~~qo]~U7~kPm~d\m;~E~~;~^;~o~Dop~N~~^o~[~ZYk{W{fS5~qiXnYf~oy[ponI\]hGh7~o]~nVN~F~~iHc^~{[~Mhjld]~y[po\Y`~~D~~^~po^^~}K~Xg}L~oBiiYtpmJ~m]~Y~S~~oO~]z<`hL~|ZIb[YzH\~pO~nGvWQfVb=m%4yTU~W~j[a~[F~}Y|[aW]~npf>lG]oY}o~\~KYjf~Oj|AhXl<tq\ZkHkqzWWb[WBtoR~~ZlU>u~~i~g]~Y]}z:~nnYg~^~gTZ~p{HUL~gg<p~YgX~pUO`mpg^kjV~[4`K{o~L~n_jn=~\~FamdjH~~~oZjXULppopooh]jgmBmV]Zpo6~~G3{fo~^~qoq|HoR~~zlpa~~\~_@YIgnWX~n~L~nY~]Y~?~\^kXS[\B~~~[E~jZT~XxpHI~^\~p~oljildff]^~~o~CfK|A~~~nHzY|_|Yh~Y]~YSxC~sknHY[Xm[eY\Rj_k~B\I~gD~:~\oUY~aGo~^cu8lY~n~mHm=~~Z~}]jgXVHtEyGf~Yk~IjcmYinPsWN~~[~\d\W~d\m~^jRygZ~n|Xon]~\^p~olFTnY]n~^~p~qw1kp|Im}>~loVHm~oRcXLorp}lHl~o}Y}^~o~Z|~^~}hkvfZhfXPjjp{En~l_JV/~~0jRIF~w^|Dssl]N3~o^}G{EUt[BenomWdp]~Y]E>$lvRddp]eUbwX~n~oY~PpgJ]opm~\e\o2z~aAisjOVkjAu~~]I~~qJ~lM|mrS~~^m|L~]on~oq}Y}^X~poq}Yo~]Y~Gq(d~spvDg|X|nhgL~Lon|VWk^m~Ym~^q~X~~ophEo}L~}^~q~^q^o]Y~n\W0|~iXK~D~~V~m^~~L~m|VCno]npjFSBA[iN~~l]^Kb~XuU\[|K~W\M~l\FllNk>~~~H|o~Ymp_ujX,0T-;`~^~qoKK)GHeoh~S~~YHF|bTrVFYY]}Y[H~c\n]oD~o]t6{~~vIkxo~L~m~M~]~WeE'_a\\~sm{WF~uGcWh~\~_\~~^mLuR[G~lK~~YYP~~ooL~}O~lH|\~KXWN~~ibL\bUk^n@~zfqf~pp^oqo^]~Hl~oH4zaP~~XnXJ~k~Q^hMH[~[p~o[}Z|J~|O~V`5YrnE~VYNBkln\6fhbY]M;~aIl~pz@znqmJDu|M~XjneH}[\~E~rh~C{]~\~]~Ym~X~l~Yz=~\}llm\W~=~O~~TonmZt[{lQ~jGhT~L~lWHV~^m~Y}opNs4~~~{XolcmB}h|[XX?\mwQwFw~sM~vXJ}\Uf.|Ixd[XxAYv%lwxkXUanv~~~~tjeaadhjox}vokijp}YXs[|WZXl~oXyB;dU[~nH|~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/413/ccs/rev np:i:5 rq:f:0.99754
  AAGCAGTGGTATCAACGCAGAGTACGGGGATTGGATTAAAAAAGTTGTAGTAAACCACAACGAAGTTAGGTAGCTGGTAAGGTTATAGATGCGTTCTGTCGTTGTAGTCCCAATGAACATAGTATGGTTTCGCATAGTAACTGACCTAAAAGACCGCCACATAGTGAAAATACTTAAAACGCAAGTTTCATAGGATTAAGTGGTAGAGGCTATAGAAAATGATATCATAACTATAACGAATATAACAGCAAATTAAAATGCACTGGAAGTGGAAAATTTCAGCAAGAGAGTCGAAGTCGTCATAGATTAGCATGGACGAAAGAAAAGTCGCAAAGATCGGAAATCAAGACGCAAAACAAAACGGAGAAGTTCAAATCGAAACTCGTAGAACATATCGCTGGAACATATTAAACTCTTGGTATCGCTCAGTTACAAAAGGAGACACGTAGACACGAAAGAAACTGGAACAACAGACATATTTGTGGATAATGGCAATTATAGTTAAAATAGTCGTAAATTAGATTATGGTGCACCGGGGTGTAAGTTTCGAACTCGGTGAGGCAATAGTAGTATAGACTAACAACAAGGTAGACATTGCAATGTATTGCGAGAAGAACTTCACGAAGATATAGATACAGTACAGAATTTCTAGGATTAAGTACAGCAGACGTATTTACACCTGTTATAGGATACTTGTTCACTTAATCCCTGTTATGACAAAGTAGTCTCATAGAATTTTTAGAACGAGAAGATTTGAATGGACGTAAAGGAAGAAGGTCAAAATGGAGAACTTAAAAGGGGAAATCTAGAACATTGAACCCAACATTATACAATGATATAAGAACGAAAAGACGAAGACAATAAGGTCCATGGGATTTACCCAAATGAGGACCTAAATCACCGGAAGAAGTAAGTAAACATAACGATATAGTTTTAGATTATCGAGAAGTCGAAGAAGACCGGGATAGGTAACAGATAATCGACGTTTGGAAGACGGTAACGTAAGAAACTGAGGAGGTTAAAGAACTAAGAATCAACAACAAGAAACTATTGTCCCTATTCTACTTAGGTATCTGCTAGTATGCGATATGGAAGTTAAAGAGGAAACAGTAGTATGCACTGTTTGAGAAAATTAGGATTTAAGAGGTGGAGAAGTCGTTAGTTTGGAAGCATAGATAGTTCAAATATCCACAGAAGGCTATTAAAAGATAGAAGAGAGTCGAGAGATCGATTTTAAAGTCTGAGTCGAAATAGTTTGGTGCAAGATTATCCATTCAATTCTTATCGAAAAACTTACAAGGTCAACAAGTAGAGATAGCAATATAACTAAAAGCTATCTATTGAACATAAATGCGCGACTACAGCTTGCGGGTTAACACGGTCGTCTTCATTATACGTTTAATCGACGCCGGCTTATTCATGCAGATATTTAACTCAATCTTCGATAGGATAGAGGACGTAGTAGACTTGGATGTCTGTCATCCAGACATGAGACATATACTTATATGGATAATGGTAGTGCAGCAAAGTCGTATAATTTAAACGGTATGGGACGAAGCTAACAACATAGAGGTGGACAACGTATAGCAGGTAATTGTTAAACTTGTTCTGGAAATAAAGAAAGAAATCTTTTGGACTATGGGCGTGGCATTAGTATCAAGAGTAGTCTTGGTTTGTATTATATTGGCAGTGAGCTTATTCGTAATAGACGTAATCTGTCGCACTTACGTTTAGCCAAATTAGGTCCGTGAAACAGACACAAACCTATATTTATGTGGCCACGGACAAACGAAAACTATAAGCTACTTCGCATTCTGAGGTCTTGTTGGGCTAATAATAGACTGCAATCACGTTGCTGGGGTGGTATCCTTAACTAACAATATGGTATATTTCACTTGGCGGTCGCCACAATAAAGATTTAGAATCCACTGGCAGAAAGTCAGCGCATTTTTATAGCAGACAACTTGCAAAGGGAGAGGTTCATGCAACGTGTTATGGTGGATCAAGTTATCTTAGTAAGACATAAACTTGTATAGACAATAACAGTGGCGGAAATTAAGGTTAAGATAATTGTAACTATAGTTCCGGAGAGAAACTATTTAATTCCGACAACTTATAGCCAAAATAGATGAAATAGAGCGTATAAAACCTATTCTTCCAAGCGTACTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  V}TelFO+hD[ee[|c@ccQ`@a]a+izol=K5ecUt5yzzzkT$<Bbo@`CyyCsmMazc?_w?>ro-idqUdN2NLax9oKgULUNa^@^OPiYRGPcT9jAMERR:ik\Xa>WkPmKTQ3E];fE_dY)CIJWBK2wQbU]@fN(mfT>OQtPOkd_U:\BT>C^^gK[^AZDyyxRJXc~XN}~p{^~L~w^~beZCJ~BgJl;~QPyU^FE~~~hD{mcUU|of~f\[dg{mEO~YrVVul`WmP~~[lT~~~p^q~qpO~n~]m>~4{~SBl~^h\WC~ZcZ]V^q]m~Mon^oq~kGVvJnR]YhYL~~q]>psWU~~~]Yo^oCnlYvom*~O~~VUj~HxAZpF~~dBG~~~pK~{Ec{[Z~jG~gAUZ+~qnhU1KVE`gcon~op]XTK~l~Y|jx^~R~~pokMa-~X{ol2<Tn~^V~aAL~~~M~y^|W`n\C{[qY|o]O~yC;|~ooL~V~@k~p|HzYvf~/~RFeM~~on~oO~pn~^~}ll]MpE~~~o~\@RHjR~~^~|^~^~|V@vZKAz]z9~~~n]XS~W=~~p_l~XnjH~o\x=~gNfRmLm~]iikE@Znof~pl~pV~:~ka3ykd[~]Yh~VZAaN~YCWbFcm3j~pX~p~oHJ}ZeXxT^X`+xq~^o~q~[j~D|mgo~K~cJ~X~Xl~q|Fi~\dn^o~E~~{TEZ~i8[~}Y|L~^lfXKpWU~AzoI~h~_DjgiDUn~o\bU>~~GesHloXokn|Hl~-~qno|]k~kX~]Y~]~PpkI_~mJg~o[Y(~=:}Hn[LjN~mYV~~~m:~pXd~oBhI|~f0~~p\~}poYz]e~pwZ~^n~T~}GtnxJkzmzS`co^uo}YIoXZ~mET~~~^~q]LgKdmY~m[zN~YX~bF)eolL~~v0~~O~~UViH~~]~B^~~Zly8F,Vh~Ij~]lWn]nR~~pzom~kV`S_TGY;~oViByX~~okWvEC^HioZV~XQ~^~\q7~vcm{=~lY~o~[wYl~Yo^}WD(q_*}f~Fni(jSj~UAS0~ZD~~ojY~G]}@~S~O~q^n~qnW~[hfYXV~?>~nMiH/~mmY|X~^oU~~o~^~po}XK~{=~kdlpmIm=i^o~o\oX^VblL~d~^]y3~~\xKmDr~n6\Vb[Ydl]Y|qn]5~lEsY,~|eZsnL~~4hXcqJbH~dHox]Zp6>g6GZ{]N~e:~i~^q}Y{^~o~]M~oD~~m}Z\~ckx\h~L~pnwEq%~~~]klpKal]hYmGioH{]fHelm^x>~~j?~~FWioZ_[^oH]~~iy05dtI~o^pTf[z[tugG~FZ~kcw6~nX~}jk[*~~~pjC~|Sf~K{+kY~nY~\Yz^}]sX^G(U~n~on~oX8~~p]oYvipjsUzG[mp~oP~~o^mIm^~qmdn{EnX~Yo=~]YrR~XypN~noLXlX~p}L~zBzq^P~sU~WhBwVFZvH{i[~zEw^_mInw_oXbP~{@~mnYl~omNVp^~o~L~|V|^}>~vR<_[^o~^~p^~L~~nMnoX\Ymcl^~}\^c~hCu\dl\b|X|oXt{lzVK~}Ym~oL~Y|NoL+w^oA~~\Yo]Y{Yl~F~m>~~h:mB_l4~~{VZNzWpm>~cP~W{o{[FK~YM~dnh~p]YflaFn~L~ol~[k\={Q~~p^~^V~oV9~:~mY;~s^`~~]R~~np=~iX=~}pmrX:^~kNaB~WaUo_QiaVnX~^{_o~^op16,~R~~^lyWm|l|WzGXTx]Y[d\jG~|I~f]of{@z^~q^YKxYokDkoHY|pMplp\?t~z]^~R~~^~y<}oY~TRZR~~g{HialaT~~^~jvn}D~~zBLi>yF~cm;~}pQ~qp^E~~~kh}mK|]ke~pXJp^p~^~nB[xK~on[rI]~B~xUn^~pi~`vH|oY\pY~nq~q]O~]pg3D:dV'nTk[\~I|dgjoa~p`mW][6xGi-WAWkU|o=yHyW=tiWZJ~yAk~oa~~\dD~hd\m~j[~~oXI~Tc]O~~]Xk~^oEhb8~~xioi~^pz3wXD~h\~HnR~~<~~{[d:`M~p}Y[XV~PXT\]~ulO~m:~GjpX~ZGtlF^<~|^on~[gowfP~~YO~Zhaiq^}pY~mY~o~[+G~nM~M~~>bW~:~SwJhHho\~X~Nf\~oXi`h]^~N\7`_CeX)JloowA~uV~Fx]~^|lH~mInjld[\~G{~~n~\dlZN~}V_Z`FXGltlH~~}L}oxHkXZs\~j~/TZY}oV%~~~~~~~~~~~~~~~~~~~~~~~~~~xiUUoxgonB[p]O~]}Y|X~mdWW,H~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/418/ccs/fwd np:i:5 rq:f:0.992508
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTGATACTACGAGGACGTCACCCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTATACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTAACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACGCCGACCGTAACTCACCCATCACCGGCGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCAATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCAGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCATCCTATAATGCTAGGTTCTTAAATGTCGTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGTCCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAACACGATCGGCGACCTTCGCTAAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGGCTGTGACTCCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCCCGTACTCTGCGTTGATACCACTGCTT
  +
  RpUIAQ?EkSYT64PJR7AMMNB/0$MZhmmmjaYUTUW`jmmmmmmmldV:55/E4T1>LEBMXG<YOE%SBCNXMUAIBNY.UMZP[WDqWMQ,F[APY5TUFdCIO;X0OQ=m4b^[PY2mS:K1VNmP[T\SY<%YL5]Q71REB[BS^T+mmlXGATLX2N\N+^.jlGo^P\B9\[S:9?TGS>]NX>I?mPDmP8oomSPNpS-VB@kMmM,NMf7kVNM@?FMS:Mm^UN:iMF>TkP^[Ap`MECoS:R,mn\P77;\<qk]TNZ]U]NoCq^[CpE<o]@M9hfP^UP^P[F//NLe.gREW>BkPT[N9OPT.JF_P<fQeL-XW@N[P];i:S^U^[@]BR%d>lYTXUPR7OYBc)hjS^[P[^[^WOZSVHnf:\N<cDS^[*ZJR[@mSGm:Z:\P]UQMj>9DNZNGOAmU[^O7S^NpUO1O>oR7TO^[Hp[PT=m<ok)RL5T\GnC;kEK`N>M>;@HAkPUOE:S:mlC0f:I[BoDXU[UUN=BDp^T4SFR>hK,AkECWRoOEN/lkCS[P^Z?YS[+fGn[P0PCq[Dq]3rh[CooeAC8LePU[PZZ:mmZ[=YPU\:Y^R2UoU^P[^[:hSZOCSZ[=T%;Ag=YErU\+jL.7B;YX?>LB@d7dL%gGQ@opQj/lD/`e[\BL>XHp<phP^)T\LE<o)&hVCB7P,NXXPMX=SL4NNT[^KTI0.HRKM@L+5]VGY[U[^U\DT[]8mmT[Z&2\\;phPU[BkQ&NJ;?`G]7eTDn=hQRPUP2;DjoT[4./AN;171\S\NO2mnX1jMW-LZVV:V4_]>SNoN=TEiPZU^U[CqIX2lUKD\Co@iPU[^T8MCSNCC:VMDS^PGm8nL)QNQ2LE:R::fKBY<omT[W?\[UJpTO$=BR;IhQ[J:0VXRWODFKHJ(U5kTQ2m]U^NoPZY>NS:=)4G4YPUBl-UW-FEj[KkFpoP^S:\YUGo}QXKBxCcF`Ph>}vCZa2NGN0-p;fsHWb\gT^DcJ_XP]f^PYjb1JsPeHQ@ZGeb(:NF@C`Y_hI^*v@a+uq]7~~sVKif_j_gP~dYJ_JnN^jg_fYF}IP~tDhJ~gjZjW:]J~\~ZjH~_jZ)ZW_fe8*[UIdP^Zj^d3}~uf_g:X[\K}_X~_X~dGIdGV7NXid^i<~f:RI6n9:]/y7XK^o=[Q|ZcGHFh_gjJ~f[~PYhDb]WP^bCDv[~Gyd92CYXcTbL~a^<~igjK~j_WOOAkMyZKe;d`Q^hD]jZhP;}~~w]GbJQYV9fefGbD`?mmlWORKUL~fEZgjg_jg_j^@~~^h-qc_[fdVZz4zh_iPYYP}_eDd?~~K+tSA\`:p_-kZXo+e_e7XIWHeAg_\~_gjgZ\~^Pi_iBF[^^ZTeBfNUeH}>~|WUFjDe_ZK~jgeZgFeEZ{Lq&xn]A?ocHhcApMyXIjX_bVb@Vw\~dHRKD{mObZZfPoZ\~P~Z_h>YhUgg=kSeD[MB_>UM%IHL3D?4;2]bM?X^?\IHPW]P[]3{|YgX2[L}PiZFN0b]dM|UPPHG=HXHdFQKL[.9]ZV{P]MP;dLMv`BXE}BB'>h_c]c[bUJM+O6X9q{r@g[WiKuPOLsfI`B<8MBeME_FE<<AFE2.6TF7gYE[A)9H^U>73T\I@cJ*ANCA)\SWJ=eBEz[^BxPOKi:SZe?fB[Pjb=jP5S]+QNM@fDaiG4'B(V\Y7\i+jgjgZIdJF?0wd_g\~^/d]O7J0./McpTBfW^O,gI7R\AZ*PiZg9[/`DaEcBXNF5]E:`:T,YYA?GN%Q\;z?g6xE{w_Tm2TwWHXj]4e*sU_YjgRl@>xYh=@V_Zc;a[9\GIfMa%>dSLl_V4%Is\9cO=]YYgZTd]MxD0]w}\9~P_S~cF5lgabS@c[01`NM2S.RSQyZ_b<~[~Z_ZdEc\Eg_i6~~\[]Q8OWW^9~]_.dRXW^B8?J/D@BVHhCcJd=~qZ6ng@^t~dZ~H=^:CNJZCNVI}Z^f:^<ia=HNQBDSZQC5b^abP~%z{{__M~jgj2nK:hJF]]<kWKv9o\u^G}8q9<Y?*A@_Hh]*182XVJW^CXBf[fAfMg-_Z?]j%c[NOXL=@5L?{YPd2tL[FtI~NCXQ*xVDh<y0{zHc]YhP<qd^\~^6{^0tDZ;~~fW~ZzB[.?fjL~gdU2[HI@?s_XP^jfhJ)ydOe(S7OHVB][~HejfIdNTNGTc~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/418/ccs/rev np:i:5 rq:f:0.99358
  AGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTGATACTACGAGGACGTCACCACTGAGGGTCTCCGACATGGACACCTAGTCCCGGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTTAACCTACCACCCATAAAACTGCTCTAAACAATTAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTTCCACCTCCCATTTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCATCCTATAATGCTAGGTTCTTAAATGTCGTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATTACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCCGTCGCCGACCGTAAACGTAAACACTCATGGCGGTTTGTTCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  XNU^PU5oY]ESJYLPTZP^O/[T$kkgZORQ?419CMPT]ZSU^hkkkkPPUE\PFTM/ZDq^QICRDFfDSY:W&aZYTEGoP^QRZDq^SDGq[\:X0ll%g?@LZT^EmPRoGfEW>TDkP=l4p<+RM]=>FO3)QZT?B7P2M1(W^OEN3ThdPWTNKPBW[UNn?Tb?e=OD\U[^[DsWZQJMhTW08+gSEqR8Thn^UQn8/lVCR)WMKkP=_4Rf[CR;mmPUL`FNQIiPZ3nbTDX74FL\3TFSN8aQ`OIhPYBjSATO\H>,6+B7B3(=AO7ON@A)ZQPKEM/CF/$RHNQg*Z%4-AI<ICL0LB.,/4)&1Q^PTHWGPDREQnSL1D1\GfE\Gd?n[P^QQG9d[8m?aS9WFS[DVDCMDN]0h[M95=R.%9=27D9[7VN@VKCOCF/<9=jCHDNDFJ:9@6NN5>>NQOQFKQCR]?E<:8GeQ\@Cy5ceQDAq6Fg\EoCfwXBU6A1J3mA;AED@,gaN9fNQH=bPK>E;X'':O~gZP~jY?vQaNtQNrSc_j_@~yb+d^cI/H4cXoJ~j^&w>=}iQtgI~~j%zzzXXQT@x]DhZKhE~~jgZj_YPT7KJB[mYg_jgjE~t7[ia^cDf<|VCmYjQ~YRQ~]:]jJ~~gZMN}Gw\:a]F|=~`GgQji/|pgNh_UY)O/Hf[P>q~}f@yh8|jO@iQYjfYNhYWDD{~YiP]fc@~jh4fY]jCkkjI~cUQcZOh[cK?_zYj]<c/g|4tXHXjM~gG~vPWh4\2dw<|9|gV_[jO~1kdYPG`'vf^X?n~eDY=~dL)`VG/TPif^QBdLMc1{]W^K~]9V`Cb<K=C'\NZ6M:y>q[<bL<9]PA\:g^QWPXdF;d3nXH{WO,cT5[JM^GYjGX@@cKifjY3wBT^?hZ^F{\5X_A~wZe_jd_OpU\O|je:xOXeK~^gK?qX]:UxZhPMV<wh_JFK~gC^Az{G_T_gjY@}|hNe;hZh<}_eNodZDd_Y_W3Fg?}W?VvXMGeZgKjGPWcYj_gjZP~iP^j^PQ~h@9wWGF}^ZgZi=|PfAfa%_kYNcOfV]?aCUDYfZLceP>iZhHVdZB~w^MO~jeHd]PWPrEy]P[~YP^6bH?fP^V1>_.R^OIi0cI\iYPi_ZhPpTAtW2^e_T{T]ONYJd[eP~gj_jO|aJ`-rgYA~}^fB`GPN~YNXfgP~jI~j^OYDCVPRcW[{4zTb:^CG|^i[W:ejgPpbhP[~gV.SQAJMU_&AB{|I6cHUa_gj8~ydTT=|X_j_b;[\Hi_j;r_r]dBfPO~jZ_iPgDdaE^I/trWPXPWHd5TS|RaQX`PEKKb=NMg%uzz21}~yXjD~`;~cFh\9WjJ~N^YP^UY4wRVO<[BxRO=EaW\afg_X~Mda\jRs@TTBFA^^]YM6e[iP\K=@XWwQq;~~|P4xDYSi>oKi]Qk_WcHbFC}R`gC\j;tVb@cS[BxDDw?v_R2RSeH}a6geg_YN\EB2SWyY5pFgJ3ptwi\,Ed]`]ZJOK^4z\GhZeD<ef`EDyGdiPF`Y>FTY^Pi^P9LPPa/PP]EhUYhgQ~jJ~eFAFg=rVCQW^VbQc[fjP~fY4||jITFHc8e8ZFrB@<d]3jnvg;UYfYP^U]HB]ZiDlmQ~jO~KreZ^8g@TWGXEPDrY^J~_YPKrC@vYeLce[F}i_Zg)xLI~fE~nG_a8\_CVg4zxg=kT@xaXPWP^jdPVFgafY<e_TjX~Y(yu[U@fH0k^`SFh9BO:{e[fjQ~I~hNQ6xD{FjCd]BYbXOFVMYTH~naZIX\*aAD@gHaJ~uQCtcXd]R]fYBzF}]D]b^5n_@u]KAv~eYP6vd[~V.YO5rjQ~hPkYZ`3xeP0gQIWX^i[T~jH}D*@?D>H_bDUxiO,nb]ZA~~^>S=CRfcH@w_ZjOy4jIWHUQ}o:R@E9]kX_UDdZY_V9yBh`g[~HX\7Z4AV^WOW_O~DbH~{U6[7.\QqiF}XZ7In`Ve\`^;mVLYL~Z|KU+`7[I^HKTO~ZjgJ~4|i>/IcaQ`-~jL|>{dAOwQKq?~kiYF|Id:LW^X^fVKURW[/<,'X`YPoDa<bT\C~~]DN$zy\iY4[N7Ak[<{M}sCEY0e_Z_Jc3:`:j%pIHh`^a/(GrdFhULy83yP]%^a&Y}JlHgPC~}?gPh_\~VJO6IX_eSNL6U?~~~Lfj_f^PX_ZJ|[iPhQ~hHbYZ3`
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/420/ccs/fwd np:i:10 rq:f:0.999173
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGGTAAAGTAATGCCTCTACGTCAGTCGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCCTAACATGTTTAGGAACTTCCCCCGAACGTTCGACTCTGAGACACTCCAGGGACCGTACTCTAACTACCTACCTAGTACCCATAGAGAAGTCTTTTGACTTCCAGGCCCTACCACGAGAGGTCTAGTCGAACATCTTTGATAGTAGTGTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTTCCGTATGTGAGAGTAGTTGTTCTGAGAGTACCTTCGTCTACAGGTAATGTTCAGACATTCTCTTACCTTTCTTCACTAGGGTAGATTTCCCACAGACTACCGTCCCCCCTCTACGGTAGGAGTGATGTCACCATATAAGAAGTTACCCTAGTATGACTCAGGTCCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACCTACTCCATGTTGACCTTCTAATGACCACTAGGCTCTATACTTCTCAGTGATGTGTTGGGAATGGGACTGAGAGTAACCAACTCTTGTACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCTCACCCCGTACTCTGCGTTGATACCACTGCTTCCCGTACTCTGCGTTGATACCACTGCTT
  +
  ~~~\~~~w~~~~pk~~~p~~~~~~~%~~~~~~~~~~~~~~~~~~~~~~~~~~~~j_~~X~~~~_~~~]~~~~~~~~s~{~e-i~~~~~~~]~~m~~~~{~~~q~~~~~~~w~~b~~~~~~~~j~n~~~~~~F~~~tk~~}~m~~~~~Q~~~~w~~~X~~~`~~G~~~n~~~~n~ub~l~~~_~[~~P~~~su~~~:~Xp~~y~h~y~~~~~~_~~E~~~~~n~~~~~d~&~~~~~~~~~~[~~;~~~Y~~~u~{o~~~~~~t~~ic~~~~~~~~h~u~f~~~~~~~gc~~g~~`~~r~lx~u~~~~u~~~~~~~~~~~~s~~~Ts~s~Y~~j4~~~~i~]~[~~~~~[~~j~y~sf~pl~v~~a~~~~~~v~cj~~~~t~l~j~~~S~~~~_~}~w~~~~~c~~vnK~|~O~~~~~r~y~~~g_~S~~~~q|o~~~G~~~~L~~~~c~~~~X~]~~u~~O~~~g~u~~{X~~~~m~xh~~[~~jn{o~~~~~c~X~~~x~w~~~c~~~~~^~~rp~~c~~ofG~~w~~r~~~i~~~o~~n~~[~o~~~~q~~~U~~qx~d~\x~>~~~~~m~~~l~~~~~~~~~~~~R~v~j~~T~~~[~~Y~t~>~`~~~~Z~~~f~~~~~uK~~~~~~~~^~~~~V~~~~~~~~Z~~y~\~~~uh~~~w~~Uc~~~~t~~~hp~~~~~h~~~~~~{~~~~{~~e~w~oq~~~~k~v~~q~~t~~pu~~~~q~~~t~~~~j~v~~~~g~w~{~~L~~_~~G~o~~o~~~~~~~~~{~~~~~T~~c~~~~~~~~~si~|~~~~~~r~~g~~`~~~h~r~~~u~~~\~[~~ui~f~~`~~x~c~~c~~~~{~`~~G~~~N~~~s~~`~~~(~~~~~~s~~~z~~pd~Z~~z~~~~k~[~~~~~~~~~~~v~~Y~~~~~~~~e~~~n~~~~,~~~~~~~~~6~~~t}r~~y~R~K~~_~~~~r~~~~~~~~u~\~re~~~i~~~~XXo~~~~ra~~~~~~~~~~~~Q~~~~e~~~~nxgj~Q~~~o~n~k~~q~~~Z~~v~~~r~~~~s~s~~~W~~~~~~uqb{~~~~k~m~~~x~m~FE~~~~~~~~o~~~~Q~~7~lZ~~8~e~~h~q~~~~~~o~~X~~R~~~~e~g~v~~~~_~~~l~~~~f~~~~~~K~~k~f~r/V~~r~~~w~W~~~~~N~~~i~~~I~_t^~~c~~paJ~~~~~o~~~~~~~sF~~~~~t~~~~Y~~o~~y~-~~p~q|Y~~~~c~~o~~~m~~y~m~~t~~d~~x~~~~~~~~v~Z~\|J~~~~~~~Q~y~]~~w~~:~xh~~B~~~~~~~y~Z~~V~~~~~~Wj~m~h~ZLqq~~k~~~{~Q~~~h~s~4~~~m]~N~~~T~~~~~^~~~~~m~~~|j~}~~z~p~~~~~~[~n~~~~X~~~\~~Y~|~~~spt~m~r~~~ns~~i~~b~<~~~~~~q~t~w~~~~~~~~V~~i~~~~~T~~o~~Zyd~~~~l~~~~~g~~~~~~~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/420/ccs/rev np:i:9 rq:f:0.998245
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGGTAAAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCCTAACATGTTTAGGAACTTCCCCCGAACGTTCGACTCTGAGACACTCCAGGGACCGTACTCTAACTACCTACCTAGTACCCATAGAGAAGTCTTTTGACTTCCAGGCCCTACCACGAGAGGTCTAGTCGAACATCTTTGATAGTAGTGTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTTCCGTATGTGAGAGTAGTTGTCTGAGAGTACCTTCGTCTACAGGTAATGTTCAGACATTCTCTTACCTTTCTTCACTAGGGTAGATTTCCCACAGACTACCGTCCCCCCTCTACGGTAGGAGTGATGTCACCATATAAGAAGTTACCCTAGTATGACTCAGGTCCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACCTACTCCATGTTGACCTTCTAATGACCACTAGGCTCTATACTTCTCAGTGATGTGTTGGGAATGGGACTGAGAGTAACCAACTCTTGTACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCTCACCCCGTACTCTGCGTTGATACCACTGCTTCCCGTACTCTGCGTTGATACCACTGCTT
  +
  P~Jhwn~U~g~}~s~vk]~9tU~~~$~~~~~~~~~~~~~~xYIJXu~~~~~~~~~~~[\~i`~~{~k~x~r~}~s~~~~lx}z~V~o~~[~dh~~v~~ex|~p~t~~~~sf~~~i~~i~~ewb~~~~~S~~h~S~~dl~~S~~l~@~}|~~=~~}~W~~yJ~zr|~~<~~~~W~w~~~~~~r~h}~~u~~A~~~~l~~~N~~~}~P~{~I~b~~h~T~~=~~~~i|fe~e~i~l~xerw~~~j~K~~Y~~~S~~{b~~q~d~j{~o~~~O~~fk~_~~p~G~~mr{~~~y~~~~D~~h~}r~~U~e~uj`Qadg~~~~@~qvgxc}~uo~~j@~~~o~W~QX~~~p~h~i~r~~b~g~~d~~a~`~~K~~{~~~~c~k~o~~}~n~h~~Z[~~8~~~k~Z~~j~eg~~~~[~W~Z~~{X~~~Vo9~S~~f~~~~||~~~kO~~|~B~~~~3~|T~B~~zs~~}s~~~U~n~gaM~~~~]~do~~r~h~~|~~~X~j1~r~{__~W~~~~n~~v}~~i~u{RP~~~~L~~E~~~|~sF~gq~~Y?~fslS~`v~~~~vc~~vA~z~~U~/~~~~vz~~uP~}J~x}~~v~`~~~~~h~~S~~tY~d^~i~~ou~~~~f~Umb~~~Mpc&~~~z~sdud~us~?~~M2W~t~h~~`~N~~[~W~~~v~[~`~]~s~__~vz~~~~~S{{N~~vsL~utq^~`~^~l~b~}oW~~~w~d~rfqfsrrFWf~[eW~~_tl~0~|r~e~t~J~~_~~e~~F~R~Wi~v~~~]oGrq~q~~^Z~Y$^~J~u~fq~e~b~~sWzY~}~.~qp~~d=~~~v~~~Q~~Z|O~~m~V~~j^~w~g~~Q~}~rn~G~~J~~~hv\oi~~g~qtH~~~~~~}v~~Q~r~>~~r`d~oa\}~S~t~~~{~vt~^CvnW~~v~`Vr~_~zF~~_~s-~~~~~~x~`V~~^~~{uqa~t~j~s~~v~rg~u~~~~[m~v~q~b~~s~~~~a{Xp}r]h~m~~v~`~~Qg~~_?~~~zR~~w~~`~9~'~~~lh~;~~r[~~f~P@~~~}~q~~~ue~n~?~~~~~~l~pT~]~]~~c~~~K~bcI9~~~ur~xly~~coU~]K~~Z~~w~=~~~s~\~qQ~r_~~E~~[~~tti~0~~~~j~~s~~g~oGZT~v~~}mT~ee~W~~~W~~~_@gN~J~~~~e]~~~N~]~u~~~d~~[~~j~f~W~k~k~~~dN~[}F~p~~~v~~`~@~w{u~b~~t{`~\~k]~jwTqq~v~~MZGT~.~~z~~=~~~~YoZX~]~f~g~b~~~~S~uz~k~r~~~b_~o_~bS~~K~~~~~~~]~S~~c~~tpl~~tlH~l~q~~~~qL~tphhl~ut~~w~)~~~~~m7~~\<~~ob~Y~~~Wnyptjm~rv_~C~w~s_~~~n~b~~qQ6~~~)~NKy+NL~S~~~xn{O~~~x~_U~oh~L~~oks~~ge~W~sPuKtnZ6~~~m(~t~`~~ut~eq~~qTqD[?}gTT~~~stm:~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/428/ccs/fwd np:i:8 rq:f:0.995934
  AAGCAGTGGTATCAACGCAGAGTACGGGGCTTAAATGTCGGGAAATTGGGTTTGCGCCGCCTTCAGGGGCAGCGATGGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAGTTAAGTAATTGGCATCGGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTGGTATCTAAAATGGGGTTTGCCCGATGCGGTCTTCAAAAGTCTAAAATTCTTGAAGTTTGCGTTTGGTCGCAAAAATTATGGATTTAGTCGATTATTGCCTACTAAGCAGCAGTTTAGAAGTTTTTAAGATAGTTACGTGAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  a}XAQY^6c^c5O@pNCB]Eg[`eB?~jj[F~7~xfceIC~kR~sIqE~Y5~vFT>:ga@oC~Ii?Wn|^l_^boN&geftLI\FC;{C~KMQ}iEebjqjT~oJdK~jJgFSN\hJ~|]9?Lsi]<~rQVNuJ~b]g]PCd}`K`\w^I~`+zRgi:Odc^qcL~\h_X]d9hQ7\RRg|LI[mQ~Sb8zdKQN\?jdc/NHaZ_`WJqbgZ^:nX9~Zb-~~k[meaMp^_~`EXK8R]W~LH>kql^bRIfkjfQJWT?BN~i_H~~bq^b^Y~7}a8T>bg8X^O%PNFaY\U`SZJ:~hqE`Gtm[d<oaP~i>X_MWJ^~aPJCnh]M8po\_]?~iQ~Yjf`daPLV~bG~fZm\`Lo~\RXJ%ChbsgJh_G|cAXSJ?W[c_FLabNDoYLPheK@ks^dqbL~`hGM[RXRO.~^wi^gdgoSYORSH~OZ%pF4_a3d@~GPTE~bgXOtJljM~[Wc\N~Ur=fPCi]_Gkn5v~[^u_jpbf9WcbEk`INIXMHURFgFd[g_~R~F~ZIPIEf_Lm^Y\~S]T~gW]MmNZQ`H[`SK]y_eY_eZKPX]=gIudnSQ~^L[%i_dYZO^X]R]dkS~]\a]aU~_N~bQWO[I>q\X~M5y~IL~Kx\bN~KCMcch^g7~~oKWWbUJai'~heJ[;Z@]QY~nLH]]hohD~bPLeXag\ae[Y~KSyhZJtlY9phSaRm9\X__M3~~ibeLmMT(TZF~mC_Kwo[kO]G~OQ~bVQ{S[J]agA~fZ_]*n~~~`S]`Tv~e[p9~M^v`g`[`O\f;^F~[dJaTjJalbgZ_`~de6_Hc_U~_G~]MoG:_RUVkNU~f?^JMRJ^(n`TY}J*}~tVRfOodj`.a\8nmR\gb3^^pn`@ra[bU~~\>~Xh$OU[7A,)Ia[?g~o^bb^pKnSo?qqWNogoQWLbfbgV~aJaZ~]Z[8~~KJsk/j^R~sKi~_~N~~qJtjIjlU_eIj@{8JF`SQ_JQ~SQ~pQbj6~bBbQgFZ\[bXfaS3UX\OiY<Wf%la<~~|f/dqdO~g`<~i^~W~bW~Onh<aK[~fOcLgc-~7~~W~M~^dqia[Zfoh6~~]9~~`p]]_~iYZ~Zj\k6nCfD~~M~~agKM~Y`UeJSUQsaQ;zGqQh6leV-^YGU_H_e]qTG_@{~m\qY~N_6ZhR~]~_VmK?x\7F7HV[AFfej3hW\V5nVE`eHQ~g>~Z<neI`6L8Nr~vJ:U`%]^ia?~*nKE~HJZ9g^~8dMkEpfODqphAnh^qdM~7~~~\~RX~g`jYPO~~_<~d]^,gajldjF~~xRUe~la~hd\O~xR_~Wqje>jWS~vbjWffV]~f>~rWcjW.rjS~B~~~zi\R~b3~~bk@~~^@~r4{~~W_~jT~~iQhNMug8z3}~qR~~~fa~d~`QpeI~~fBf`qif`Svefh\bVYvR:Q~U~cnSy3Sm<lT~~epByGwoK>7K`t[:adD*j~S(|VSG3GQK{XR_nd)~{njpd]5~naVe>=}havaB~~ZdFI~~X~CahMG~~~wP~SmZ~{L~~xjpOd^Wxf\~QJXPaeq[xh`dhPwj,~~{k_nfC~~~oIyiwr{i@~_@hri&~~~~{lXLO[n{~~tk`WU^q|~~~lgT?Ri7WUMhJ~gqNu?T?UbcdH~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/428/ccs/rev np:i:7 rq:f:0.993569
  AAGCAGTGGTATCAACGCAGAGTACGGGGCTTAAATGTCGGGGAAATTGGGGTTTGCGCCGCCTTCAGGGGGCAGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAAATTGGCGATGACTATGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAGTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTGGTATCTAAAAATGGGGTTTGCCGATGCGGTCTTCAAAGTCTAAAATTCTTGAAGTTTGCGTTTGGTCGCAAAAAATTATGGATTTAGTCGATTATTGCCTACTAAGCAGCAGTTTAGAAGTTTTTAAGATAGTTACGTGAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  3`G:ZB\=tf^>XS|X,;1:1PeKU/aueY7a=fxdQgV&^q@=rhDs1bKHK`sVETG]VKrD2TY&Y[^WVFSZSGc,ZZ\dZV]YB^Dq=e:_M;xR\YP9n]CYJm]TY\`Q\f2z\1TMFveS2mdPJOg:vTEdEPI||VZVN`SD]=AdH|^[9t^WW?Rv`gUJUcO{YUT>Dt`VZPfDdc,@so6ydER]@\FeTLRVBLY`BeYD9r]Fl4R,mU[,ueVQ{[HrRaZC=jYEFCG1hygZVf[cIe_IUZgJXFggZ9{zTVWVZ/zY;B>B/IhJX^@DYa[MU`fUQ7P>`cDGU885XVK`RAWg`AOZ]X.vSgWADYZV=zsBRREwcAvW3T]fVgZHhC8qbP{ZT@x\?F]V_KfR4OY&SVL|RX`DNWBPJUKzdSTO[P9=W[S;MRY^C<Ec=CFTX\WQ=E^ByQD\<:YaTAPT9\T/Of5dP^gDH'aa2RtSNYFxIa`AqC_UZ=sD@FUEVfROJs_AyyX/yXcZR+SH^S/qU\_-thQRT'`.`V]1]C[UfXTbVBU<-]/E6k_UBeZ'OUWSXQTZ\?LENvC_NBGR;NCBZ^4s\afEzYaXSE@IBCJ9X.[RBH4V\ZOEIEcJ/bUZ`I7R4jIOYB@YmVSyHw`WJwV:d_CcC]=}`GY_ZUR[Vf-ww_ZUQ`QYAP{_I}]VH?_.WoZY]B?dBPJSAUB&rdZDq,I+^qQS0_DN1aTE6^Y$:ANO\RV^\1Ux`gVAvQ2VeP.geFegZH{aL>gTPGmeET[6zzzkW]+L:izfYJAgGB]3NBT=:5`HeDU:@QB@wXR6Q`ZWPbSNYU/_S@]>BnWL`ZFjNWQ[MAsX.][GSHE8aT,FU.3f{zcRNLxeJT_?Z@ubdKaF%psvVUCeTXH@ceH8cDPBqTR?arNa@5i{n[VgZ^EMe_=t`0Ak931,8RYV_GjQVSIbNZYHuxV<ys?xu8`rHUa?zAwyaKo]MvzZVfIJDcUZHO]QTC?pO6niWRe)yh>X_LZY[I=]Y0]Z`Z77eY0vp>>B)lwsFSu]@E]eB:xgP|UvS2S8U\;rEPt^SO?fWDW(PfJFm&tXRGdSIY_4d2uyt6we/]QY+KLUA_RQY`LwHfE}a=qYHbUM{ZV\_TRcLtSVMwTsEdKY15>TTYA6>\NwL?I>c`HAWGbAN1WgEc?aZ,YVAyU8xsAMC_;yN`Qp[P\'eb_SiZS|f5wX^_eU>Fr2ytd_UHZVHsZiVLyI{tDtUC^ZiP|KjBx'``S7HMfHgg\^>C[1inSGiXHkPVURXDrnRFwMC2$>D;^YBLgjXYVEiQ&GDO\3[fV5YE?D@SXUKi`\R>yuVHy_8;K,5CK6FH2c9rwuZ=V<z{@ov\-0_wZJ_H'bccT@fU=q`RYBKE7SIp;{{f8u|uWVfBjFQKY;f^UNxQQUaZ19;ERQV@G0ILFvR|Yb4_6^S/XHz|VaAZ_]KWM$RRM=B5`lI.akO-kA^gV[FwWYIkZH|c2;Yg9}}i0OBR`.Na>I\`PCT>`fGuQXUD0ikaqVFw_d3v]@ydI@PYW`Ux`3vTLwR]\f<ZSWU><\S=tx_S=vS/ha^X1>TIa\R7F[WN9=$[]`bcdfgecbdhowz{{{{{{{{|n]`haYaY/JXO~[=T]Bzgc_;aZ|
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/429/ccs/fwd np:i:5 rq:f:0.993094
  AAGCAGTGGTATCAACGCAGAGTACGGGGTTGGTGTATTTATCCGCTACGTGGTGGATGAACATGGATGCGAACGACATTTCGAAATATACGCAATGATATCCAACCCTACCGAAAACAGCAATAATTGTAGAAGGTAGCAATATCATGCCGAGAGTTTACTACGTTGTAGCGAGTTTAGTTGAAATAGTTTTGTGATGTGTAAACTAAAACATACCAAATGGTAAAACTTGTCACCCCCATTTACATTGCGACAGACACAGTTATGGAGTGGATGGAAGTGTGTTCGACTGTCAAGACCCTTCTATAATAGTCGAACCAGTACGGTAAGTGGGCAACATGCCCATATAAGTCGAAGCATTTCAAATGGTTCATCCAGTAGACGACGATGTCCTAGACAGTCATGTCTCTTCCCCATTTGAAGTCATGTAGTGGTTGTCTACTTTTTCATTGAAGACGTCCACCTCAACGCTATGAACGTTAGTTGAGACAATGTTAAAGCAAACGACAACGTCATTGTGATCTACATACACAGTGGATGGTTAGCGTAAACATGGTGGAACGTACTTTGACTGCGCTGCAAGAAATGGTTGGGTCGATCGTAATGCTAGTCGTTACATCGGAACAAGCCAAAACAAATCATTCGCTGGATTTAGACCTACTGCACGACGACGTCGACACAAGACATTCTTGAAAGCGCTAGTCCATGAAAATGTCCTAGCTTTGAACGTTTATCAAATGCAAGTTGTGGGAGTTAGTCATGTGAGAGTTGTGCAAGAAAGTGTTAACGTTCTAAGCCGTGCTCAGTAACAATTACCATTCGGCGGTAACAACGTAAGTTGTCACTGCACTCATGAGCATGAAGTTAGACCAGTAGTTGGGTCAGAAATTAGACGTGGTTTAGTCTGGTTACCGTGGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAGATAAACAAAGAAGAAACGGTTAATACGATTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTTCAACTAGAATCTACGTTTCATACGCGGATTCCACATCGTTCTTGCAAATTAAAGAAACGATGTAGAAAACGCTTTGGTTGGCGACAACTTGGGCGGCAAAATAATTATGGTAGGTAATTGAAGTAGCGTTAAAACGCAAAAAGAAAGGAAGCACGGATCACTGCAAAAAGGACTACTCAATAATGGTTTCTAAAGTCATTATGCTGGTGCTCCCTATGGGCGGTGGTCAGTACTGTAACTAAAGATGGATTACGGCACTTGTAGAGCACGTATCAGACCCAGCTTTGAAAGAAGGCTGAGTTCGGTTCGGGTTTCACGTAGGCCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGGTTACCATGTAAGAAGCGGTAGACGCCATGGCCTAGTAGGAAGAATGCTTGTTCACGGAGCCGACGAAGTTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGAATGCGTACTACGGTCGTCCAAGTTGCAAGAGGTATTAGAGTCATTCGAATAGCTGTGGGAGTGGTATTTATAGCATAATAAGTGTAAAAACATTCCCAACAGCATATGTGTAGCCAAGAAGCGTTGTGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGATAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGCGTGCTGGTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAAGAATGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCATGATTTGGTCGATGCGGCAAATGTTGCTTAGGACTATTCTATGGTCTTGCGTAATTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGTGAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  H|_GO;,R}fcL+C`AJV`[P`ePWA|||V|QoO`^a=amKH*y`WgfXbfR}fR{Pe`DwA`aR{fgaW`FzV`OT:HofA\@eyffffWaU4tL[[gff)`0D5~|efGfJ&wwYUM_VFxdG^WzagfaW}R}ff`B,d`ecDN^\H~af`P_9}eOVgfUIG|`fJWA`fa6~]K`Y}aE~|a_a$xx`adJdfadJe2|H;C:pfrUPed6|<t`bR~c3fjgVW|Jb<M/YDXePO|}dAdW|HU`fWfaa?MVe`E{eaJTf^hQ}fMP~W}abbbHAzVacR`agWK~ae6~vTjWbMJ0Zbc`dA^4_7jP]fcFR|fW}^IIznAFyVfbY@zfaa`fOhN:U_3w^@NO||U:vc]O{RmUQ`9~eafTQ'?^OEO8O_N<~f`YOVea`;L``eWcXW{:ljm`=emIDz_NUPeagfae>yDz]\VRSR2__vO?8W|_2jF6@`e:~e@vaWKzW_Aea\aT|TaY}faY}_OK>DF\faXy0xx^A9\GB`a1FjW_SVfTwYf^9AUbLO`adVOUQ^fR|`^R{W~faWafM}sTLKQ{fQ|A\TEVIUB|qHNVgaWaXgaWHe]N}}fQx4s6xp1S^2,KGb7[NLS8`^F:\Fn]Se[VPe)EA7URAW7geVNDVc_QCO[O=OE<aMJh_[VN'F.:+YaV]SK=QV=GYS2MKU`UBm@OANAcPBfIM|}]VIVa[afJ~fga;{{{fafJ~ffaW6}r`F_E_3{g=JR4ijf_AVzaT|_JI}~faY}fagUP[Id]faf_I|`c8ABy[?{{agaY}W}WaY}Wd&a_H~`h_AdGP_b(NH8eX{fDb9W|WR}WR}e7uO$_VaeG|`Y}afD:EdJTIOJ(KeadJQ^`YCx^:we`IGzP`gf`F{>l]dBP`Ds^U}e_Y)K^=rFy~fagWgR~Y}b&d_fR}FSTaV}edaWgaByTbU=R?_3w`At.\B3YS_J_IgxV:se[W}aA|wUB{VsV{NcQ[OW~afQ|O\1cvdbVpVV{KD^W|T?xT4wVfeE{JyUJ&pXVGvU[XI0]_O`dA_?{vAdePS`VOmUBvG~dAdb,^UcV:j5P$tBDwHg{`?{zVafebb7^;dgvVaWH}xR~Y}R}W`M+CsTU[HwrRDYA+o^ldDwDzOeQ|NbA}dFzX|aW}agfaWaX|<{|uVaM,Vhyy`$qTQ~W}aWdAP{PeXfWgaW1}}}`Q|PWeL<]WKjMJ_dR}LcvVc7itag[.Nl[[WIR9PQUNU/kkZ[Z%RHJ:LQIiY8YW[[NN/UJkN[FmmUDUFOT;gEMIl?T?IQWZVRXRMDMT@.XNZUD;o`EVM8llU'I_UAaC7LBU[WMi7F`@lNAmW%O89YNT@BIlApUP>A^NU;@_B?@RK;i>VGlMl<jMFkmSNBTd8b;kS0e?I%VNmV<kONCnU>LUI?6L>M@D2]PK:@XDJ+`VNm[U8Mj;4gMYMIm[Q?hL@FJ,YV*n_ZUDMUDU[GlLDT*gU=mkVX?MY<kY[NJ]6iXDM[NHoZO[WNm[WNW[[LBXK$c)KWW;RKkV3cPM<jUDIlXUF`GTZCBM[Nj8>+gYYWN[VY3kTDV[HoYDFlkDZZWL5L<jPBlV[WZ&]KUM?KJc*ik?_HBULDWB;SATW[VApNlU,[@MU;jM[U5?GMNWZNV(UgiV[IRHjAEODK8FZG\8YOmNk<qqZ4[UFTL?JNLXT57gkV[J7^ZA6.OZUTG_:llZWN[JgDNX=LSAWVJOmWNW[OmU8UY?M[Gb)HkYE4\6?PU*I0F>4`YDSVFONOmMRGDMYN2KLU>9MCKF:^?G>9K,KAYA]MTRMMZHQ>3@BCJSF=U7GBP$QNT/LF8H%,C?R<MEKOKN7MCOCVCABSH2KBEA1TJE=DM6EL3F,IKB:?74EC*)N=EBDKA;BI</B:8K@VZIiF75`3CgmVKlIlDU[WM7kkVCr[Y>A:lhIm[NWW[VG4gL8kkYU<kVM<kYIk@JX?HhN[UMHmY8NkWHNZEXMkVW*BMUD+XYV<dQFOm[UNZ<jIlDUZNVX%eXV6bO8$UbhiidXNOS[diiiaM9.*-9L`hiiiiiia<;XCLQ&SVNU;k==JR?N/L[WNMk
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/429/ccs/rev np:i:5 rq:f:0.991542
  AAGCAGTGGTATCAACGCAGAGTACGGGGTTGGTGTATTTATCCGCTACGTGGTGGATGAACATGGATGCGAACGACATTTCGAAATATACGCAATGATATCCAACCCTACCGAAACAGCAATAATTGTAGAAGGTAGCATATCATGCCGAGAGTTTACTACGTTGTAGCGAGTTTAGTTGAAATAGTTTGTGATGTGTAAACTAAAACATACCAAATGGTAAACTTGTCACCCCCATTTACATTGCGACAGACACAGTTATGGAGTGGATGGAAGTGTGTTCGACTGTCAAGACCCTTCTATAATAGTCGAACCAGTACGGTAAGTGGGCAACATGCCCATATAAGTCGAAGCATTTCAAATGGTTCATCCAGTAGACGACGATGTCCTAGACAGTCATGTCTCTTCCCCATTTGAAGTCATGTAGTGGTTGTCTACTTTTTCATTGAAGACGTCCACCTCAACGCTATGAACGTTAGTTGAGACAATGTTAAAGCAAACGACAACGTCATTGTGATCTACATACACAGTGGATGGTTAGCGTAAACATGGTGGAACGTACTTTGACTGCGCTGCAAGAAATGTTGGGTCGATCGTAATGCTAGTCGTTACATCGGAACAAGCCAAAACAAATCATTCGCTGGATTTAGACCTACTGCACGACGACGTCGACACAAGACATTCTTGAAAGCGCTAGTCCATGAAAATGTCCTAGCTTTGAACGTTTATCAAATGCAAGTTGTGGGAGTTAGTCATGTGAGAGTTGTGCAAGAAAGTGTTAACGTTCTAGCCGTGCTCAGTAAACAATTACCATTCGGCGGGTAACAAACGTAAGTTGTCACTGCACTCATGAGCATGAAGTTAGACCAGTAGTTGGGTCAGAAATTAGACGTGGTTTAGTCTGGTTACCGTGGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAAGATAAACAAAGAAGAAACGGTTAATACGATTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTTCAACTAGAATCTACGTTTCATACGCGGATTCCACATCCGTTCTTGCAATTAAAGAAACGATGTAGAAAAACGCTTTGGTTGGCGACAACTTGGGCGGCAAAATAATTATGGTAGGTAATTGAAGTAGCGTTAAAACGCAAAAAAGAAGGAAGCACGGATCACTGCAAAAAGGACTACTCAATAATGGTTTCTAAAGTCATTATGCTGGTGCTCCCTATGGCGGTGGTCAGTACTGTAACTAAAGATGGGATTACGGCACTTGTAGAGCACGTATCAGACCCAGCTTTGAAAGAAGGGCTGAGTTCGGTTCGGGTTTCACGTAGGCCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGGTTACCATGTAAGAAGCGGTAGACGCCATGGGCCTAGTAGGAAGAATGCTTGTTCACGGAGCCGACGAAGTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGAATGCGTACTACGGGTCGTCCAAGTTGCAAGAGGTATTAGAGTCATTCGAATAGCTGTGGGAGTGGTATTTATAGCATAATAAGTGTAAAAAACATTCCCAACAGCATATGTGTAGCCAAGAAGCGTTGTGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGATAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGCGTGCTGGTGGTCAACAGTGGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAGAATGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCATGATTTGGTCGATGCGGCAAATGTTGCTTAGGACTATTCTATGGTCTTGCGTAATTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGTGAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  FiMW[NY3oY[[WOmWNWX4?K[[R0MZWMkCpZNV&2dgXBFU4U[X:B+AdZ>f5TM?lVYB@jO0IPM<kT8YWT+R`VM7lfWXXV?LVOm[KSIWIGiJi0OeY[JmM/laV[NU+i.+iMlN[Z;1O/OFYNWZXA@QPXN<fJQ%GK2c5/UDYVKId8BXNWMBL8kkZNNmLA``DUKEhhNY8YZMQH,6UkUZ7mmkVZ[[Jm?nmZApY'jjUMf8WPZ*jjjh?$edMLOHONWN[W[N[W[WYKJk[ZAkO3@@N+VBkHS><?:?0RS5XT>'1>OmN[Amk<jUF@R)hN[KSUM*iHkBL[[V?m@NmNZ:WjV<k?XDLAmkAVX,ITLQ)IKlNWZ8kkU8llY=R<jV[Y6iYN[ZMBS7>=L[Z=WIlDYOV?YOZDZX=VR.S=\<lmm[;[<'JiIYRPCLDT:O5XLlLPWY[S2ll`QV[BS:NlN[T5OHm[IlB>Hc1NU@(S8NkWM9SZNNmMU9U?JnY6Ij?ngNV0m`T8VVOmU8XWZ=i>U<Z[W[[RQDYW[W[DE;]OB/kMj[L=&B9VeUPQ2J'@dKRCNXQOFmlNX;KM?LVVG?JgM5hRS%(b$MVP?LZ?HI?IlZOWZZK0R:1BPRQW==Q<kVOmNFf8mdSV8klZWV/:U7=U>jZ8kkX6V6iY[U[L-J,6V;EYWMC>LZVY?:i7UVZKjNAcH5XU5EL>;?ISHkAQ=,km`X8P@kZ[NP8VVJKlWNFmm[[WGmmV8UOmKAS:Y:WkZNMm[N[V[Y8XN[IPMB`N[NV<kH=ZSNSNBjOmVK9g,>X8IkMSL9%S[NZ/maVLiIg[JmZ<jV@l=%gYZOmV?nZ?IQIU;,A8U(VIFMW[WVKZDLTJPZZNI^<=PZKKEIVJFVINj;qcDUY8,hWNmZMVLMX%d7Xj@LZW[An<jZFJJZ@@,`fL>YYVIUS=HiOZU1mZL7M;GkN[W*mmTNZY'jiN;aP9:cL/caV?RNmNl?CVOZNmN[?TIM+hRWX9N>FSWHnOmVApVLiLX=*K;jVNBRVR)hPOX8MjTS[[WNFmmVZXZWNWAp[NmHb)RZT2MK:iUNlL;Ea=H)jhL5^JVN[ZNZO7&=QhXT8T9lX;I,P0kUO[WOmWNj3W7R=HU9nfUZLiIgZF@o[[4g[Om.,(JRN[[NWM+f4jllVNV/nnnmZNIcApOmM?W=;ECTK[U[L)<hmmc7[T?X[UDP9iOKRWCjFmkTA<B@IDBVGfBXNT-6YW8UVAlnY[[ApVApZ?nS?XKQZW[N[KTTD8kkMUZ%TTY-hWU0jQKVNmKQVI[NVGUIOL.PLMZCnnY7=4cSM>meNEa%QUV[N[M9SP,f9W>8iW;dVK[R1EZApEP.WM<kVNZ2Q-WW?I@3KZAnEL=kVGmmNZ)gTA[@NP5fXT6/BeNLmM;0iVT9XU8Ik[Z'X=<R+?KDR6lOlNKTZNSK]67H:WUAiR8DOMBUNDVNMmYKSVN[NZ5M=XM<jH>h_MX6LW=UUK?:iCo[[W[U3oYWY8MjC(SNX[TDYV*IC=?MZIl<L$?L7UKdL,AZZZ3Y.LXMVNX(HS8ILOLMWUJU:ThX8@>O>A*T[0EA8UYB)iXJZ7OMZ/llbR\?Y@R4k^8PU[M?YVRY8DMZY8DM'cFIWKP8@`KR8UVKMVM[VU)hkV<GRZ3dSBLW[OW[An;MGU8e3lcUF@MVDVM>jV[[WHmmN[VCLcRNj8XZDA^8^kZNUBMl[W[NWMCXBKLe8UNY0D8UMY8TD@mZ6Z3OOmWZ;+.I?GlmGo[[I0?k?GOKK<@T[V2gPTN[UHTG3XNW[NmGk13'MSDBS3B:MMiWNYXVNMmW[4[KcHKLV?cSZ[KgKZRL1U[?VZNIm[NWN[IhNMMLlQ7@L[[NZVA$WWZS23hUMD>QcMQJRHVGTUEM[O9TNYKRVY@h<DfRNNlAp[J@HUEjTNJmW,KZ8kb6a4OO[[NQ/kUGmi>3JjNP>]T7pZW[ZA[SVRZ5g[WNmM?L[Om@eMDKL_N[=mQ9Gn[M=jZUKZM\'NP%2F;+1O<H8^kU$ijjjjjjjjjjjjjjjjjjjjjjjjjjjjQ6DXVSN</TL>fJSDW6iXUZM?Au
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/456/ccs/fwd np:i:8 rq:f:0.999065
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGGTAACTATCTTAAAAACTTCTAAACTGCTGCTTAGTAGGCAATAATCGACTAAATCCATAATTTTTGCGACCAAACGCAAACTTCAAGAATTTTAGACTTTGAAGACCGCATCGGCAAACCCCATTTTAGATACCACTTTAATTTCCAGTTAATCTACGACGCAAGTCACTTCTTTGTCGTTAAGTTTTATTTAACTGTCGCAAACAACAAAATGGTTTTCTAAATTTACTAAAACCAGGACGCACCTAACTTTCTAAACAAGCACAAGTTTAGCTTCTTCGTAAACGTCACCGCGAACTTTGACGCAAGAATTTTCCATGACCATTTCTGGTTGGTTAGCCGAATTTGGCAGTTCATGTTTTTCCACATAGCCATTGACTCCCACGAATAGGTCTCTTTCTTCTTGTTCCATGCGAATGTAAACGATTAGGCGCGCGATGCCAATTACTTAACTGCGTTCACAAATTTATGGTGAGTTGATTGCTCTTTCCCCATAGTCATCGCCAATTTCCATTACATTGTTACCAACAATTAGGCAGGCTAATAAAACTCAAAGTTCGTGTCATATGTGTAAATTTACGTTTACCGCATATACAATGACGAAATGGTAAATTAAATTTAAATTTCTTTGTGAACGCAATCTACTATACCTAAATATGTGACGTTTTGTTAAACGAATGCCGTTTCGCTTCTTTTTCTTATTTGCACTATTACTTTTTCAAGCGGCACTACCTAACTCTCTTGTTGAACAACTTCGACTTCGACTCGTTCATCAATTATACGCACTTCATTCGTCTTCGACTTTCTCAAAGATCAAATGGATTTAGTCGTGTTAGAAACTCACGTTTGGTTTCTTCAAAGAAGTACCTATAGTTATTTTTGCAATTGATATTTCTTCTTTTTGTCCAAGACTGAGGCGACGCACGTTGACTAGGCGTCAGAAAGGTGGGCCAAGACCCGAAGTTCTGAGCGATGCCGTAGCCGTAGTTGGGCAAACGACTGTCGTTTAGGGTCCGCGGCAGGCGAGCGTAGTGGAGGCCATACAACTCGTTTCTGTCGCATCCATTTTTGCGTATGAAGGCAGCACATACCCAATTTCCAACGATTTACTGATATTTAAATAGCCTTTGTAAGCGTTTACGCTTTTTGCTTAAATAATTACGTCATTTGTTGCCACTTGGCGTTCTTTCTGTTTTACTTAACATGCCACTGTACTAATTGGTTGATAAACTTCTTTGATTTAATGTTTCCGGTGATTTCGACAAAAGCGACCACAAGACCGACCATTCATGTTTCATAAGTAGCTCACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  ~~~zplzR~bk^BdsH}c[~~~~sy%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~_[~~h~ybq~{|~@~~~~m_~ay/~~t~~r`Wxx~~~}~h~ZV~XW~lw~pv~a~~\\~m~j~8~~~~UfcV8~N~~]uF?mjPi~e4~~f~4~~l]~lxK~ue]~~m7~;qv~um~_[~v8~~]GI~~~xx{~~2~Zb6~~_~Y~~J~~~R~`|{a~xER|e~dO~zvd~wi~n_~~l~ck}~P~lH~~~]N~lK~r~~~YxSL~~zs~l;~~~wk~E~~~w~D~~N~~~x~L~~~g~~i~~chVdI~~A~tQ~~|~U~~y\~~{~za~ln~~~~zg~MX~d~~;~yd~~O~P~[aje~kh~~~~~~pz~xp~]~~~X~j~~~Y~~V~~e~O~W~O~q~wqU~~v~h~~f~~~~_~jzyX@~~~cE~fm~~~~n~~~~~~m~R~~~~mG~~wo~~|~~F~~n~~~~~~~~i~d~x~~n~~x~[~~~~~r~&n~~~}~cu~~~,ql~u~jqr~w~~~x~~~~vZd]~~w~~f~p~~~}v~~~~~~x~~ol~~U~~~~~~~~B~~~~]~v~^~~P~so~~t~r~~[~dD~a~~m~t~~^~W~g~~~w~~+~~~Ioil~~u_~~~r~~n~~~~~~~~^~~b~~~vwI~~cb~rf}~}~tCd~~~|~~[~~~;~~Y~~v~T~~t~~]~~d~~le~~~~~m~~~mH~~~~~o~~~uj~~h~~~zk~~u~~~N~~~~~~8~~T~D~~~h~~1~virA{~oA~~~~ku~iI~kHasj~~I~v~8~~~~j@~umr~~cj~~J~~D~~~~~~d~~w~~g~pu~RY~a~}kM~~x~W~W~~~~~~nk~q~dwJ~wfaNt|Rzv~h~~~~~e~~~g~~n~xU~~~~~~=~~~k~~t~~{~~X{t~y~~~D~[?~f}~~[~~<xW~~~d~c?~~~b~~~d^~~~~~~s~sC~~~~uih~q~{{~}X~~~i~~R~~~~u~k~l~~~o~~~t~n~~~~X|m~L~~~~q}u~U~~l~~_~~s~~d~~G~j~~~@~~~r~~~~i~~~~mu~~y]~w~|~Z~~~~~J~B~~jW~~~~k~~~~m~[~~{E~~~h~\}(~~yl~l~Zpg~~b~_J~}p~i~~~s~z~~~{pK~~~~~~~azx~R~}I~~~~~~~~u~~S~f~~j~~e~~~~R~~`~h~~]~v~~uhZ~~~~~[~~~>~~i~~~~sU~b~~w~s~~~_V~~}|qh@~~~y\~~~^~~~b~g~Weoxmdk~~uH~vi~j~W~h~r|c~~A~qTg~:~~leos~E~kz~~h~j~~~~f{~c~~~o~`~~~~S~~~k~hs~~~~n~~v~~~t~~k~l~~~~T~~Yv~k>~~~~~~~J~~~m~~~d~~^D~~A~ar~7T~~gu~3~~~plz~{oN~~~~~~bwwtRb~{~V~~~f~ip~w\|~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/456/ccs/rev np:i:9 rq:f:0.998884
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGGTAACTATCTTAAAAACTTCTAAACTGCTGCTTAGTAGGCAATAATCGACTAAATCCATAATTTTTGCGACCAAACGCAAACTTCAAGAATTTTAGACTTTGAAGACCGCATCGGCAAACCCCATTTTAGATACCACTTTAATTTCCAGTTAATCTACGACGCAAGTCACTTCTTTGTCGTTAAGTTTTATTTAACTGTCGCAAACAACAAAATGGTTTTCTAAATTTACTAAAACCAGGACGCACCTAACTTTCTAAACAAGCACAAGTTTAGCTTCTTCGTAAACGTCACCGCGAACTTTGACGCAAGAATTTTCCATGACCATTTCTGGTTGGTTAGCCGAATTTGGCAGTTCATGTTTTTCCACATAGCCATTGACTCCCACGAATAGGTCTCTTTCTTCTTGTTCCATGCGAATGTAAACGATTAGGCGCGCGGATGCCAATTACTTAACTGCGTTCACAAATTTATGGTGAGTTGATTGCTCTTTCCCCATAGTCATCGCCAATTTCCATTACATTGTTACCAACAATTAGGCAGGCTAATAAAACTCAAAGTTCGTGTCATATGTGTAAATTTACGTTTACCGCATTATACAATGACGAAATGGTAAATTAAATTTAAATTTCTTTGTGAACGCAATCTACTATACCTAAATATGTGACGTTTTGTTAAACGAATGCCGTTTCGCTTCTTTTTCTTATTTGCACTATTACTTTTTCAAGCGGCACTACCTAACTCTCTTGTTGAACAACTTCGACTTCGACTCGTTCATCAATTATACGCACTTCATTCGTCTTCGACTTTCTCAAAGATCAAATGGATTTAGTCGTGTTAGAAACTCACGTTTGGTTTCTTCAAAGAAGTACCTATAGTTATTTTTGCAATTGATATTTCTTCTTTTTGTCCAAGACTGAGGCGACGCACGTTGACTAGGCGTCAGAAAGGTGGGCCAAGACCCGAAGTTCTGAGCGATGCCGTAGCCGTAGTTGGGCAAACGACTGTCGTTTAGGGTCCGCGGCAGGCGAGCGTAGTGGAGGCCATACAACTCGTTTCTGTCGCATCCATTTTTGCGTATGAAGGCAGCACATACCCAATTTCCAACGATTTACTGATATTTAAATAGCCTTTGTAAGCGTTTACGCTTTTTGCTTAAATAATTACGTCATTTGTTGCCACTTGGCGTTCTTTCTGTTTTACTTAACATGCCACTGTACTAATTGGTTGATAAACTTCTTTGATTTAATGTTTCCGGTGATTTCGACAAAAGCGACCACAAGACCGACCATTCATGTTTCATAAGTAGCTCACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  FvU~~vWX~ns~~i~~xkhk>ZjG{%~~~~~~~~~~~~~~~~~~~~~~~~~~~{GE~~i~ey|fv`~?~~~~~m~i~V~~uwekZuzE~~{~SK~P]~oS~vrc}~rb~~~[~uB`i-~~~~s~bs]~-~lU`~O~~~m~~R~{x~;~~~~cw~R~~sj~z~\~z~sp~d~~R~~O~~~nC~~~~cvm~;m~rG~~f~2JXR|~p_~l~~~m_bb~{Yze~c~l}k_~kT~~^eKk]~~~zW~~~}R~~Q~~}^~hr~`~~~l~~G~~~~b}<~~~~~:~lV~~qdS8~~~n~~R~lduSuk~~8~}T~~|~]~~iu~obZhf{p@~~rref~~1~x^jm~~Uwsk~D~jT3]~uO~~O~lgn_za@~;~{Te~~xY~k~~Rv~~o`~`~^~_~~Nh~zk~,~hB~{xsg~roZVE~~~eD~t~~~Dni~xDdO~iqH~yvctu~m~/~`vzwK~~~c~~\~sh~U~^~ipSZ~~p]d~~\YfL~|LrlYf>C@urmj[~m~Q~Czk~i~~~acM^~~g|=~~?~~~~@~W_~qi~twa~Y_JfG~~@~~~xnxxt~~~~t[~T~N~~d~kH~u~w?~w[~~n~E~ri~g~~N~m~_~~~s~};~~ul~mT~~wP~KT+pC~~~~~aorVE~~Y~~~j;6~~~X~Rv{)vqbjiOR2qz~{g~~]D~r_~~O~K~~P~~d~~Y~~~T~U7A]g~p^XD~Jas~c~~i_f~oY~~}vLSDUa|o2~v~PXv_~~oNz~sOm~xd~~~N~l~~7~~~~~?~~M~~\&v~ssr~~~9~~~~~U~SeE~~y~]~K~~}~~~~~~T~U^~lK~~j~~[~|awtj~|u}j~~{i~~ynT|~b~~~~zu{~~]~zyb~{ZW~t~~zy~B~~~~~L~~z~~~m~~~<~}8~~~uxrNYb@uvyK~~~~{~lr@~qU~A~~~M~~L~~dd~hz^W~n~m~|r~s=~~~~um}~\~h~E~H~~~R~~I~~~~{~b~i~y~~rc~O~~d~~mS~~{s~f~~~~V~mj~~lgN~~e~tM~~f~d~d~^~~|l~u^~~~|~e~csrzl~dutga~x~~cBnP~~|W~~jMu~~zv~z/s~~C~~`m~enV~~~e~~y~|~j~Wa~>{vC~l~~~~}U~~p}zT~~~~Mo{htrhF~~F~~~~_|eq`~ej~T~l~]|~Sso~K~~d~_~~P~f~~d~D~~~lhq~y~R~~p~~~ywi~T~vQr}~z~w9~~~}IsE~~~~shc~l~~~c~\~q}tp~xQ~~zi~[f~~xd~c~~fW~s+~~x~w@~~~q{_~h~~~~yl~~~~aVv~tw~:~LkJ~u~pS~~~e~~G~~y~V~~w~~zE~~n~P~~a~T~~~`~~c~~~uzb~\~~gb~rZX~c~l~wN~~~~c`~~~~~~~{q]taJh~D~~~ys~g~~~z~yq~{~~|d~~a~|ob~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/578/ccs/fwd np:i:5 rq:f:0.989296
  AAGCAGTGGTATCAACGCAGAGTACGGGGCATACTGCAAGACTTGTAGGCCCATGAATTACCCGCTTAGGCAATGGGTAGACCTTTCCTTGCCGCGTGGAACAAACCGCCATGAGTGTTTTACGTTTACGGTCGGCGACCGGAGTCACAGCGCGACCAACCGGGGCCAGGCAAAGGCCCATAGGCTTTTCCATCGGCACGCGACCGATTCCATCAAGTGTTTAGGTGCAATCCCCATTCGGGACGGACCACGCGAGAGCGTTAGTCGGCGCGTGCGCGGGACTATTTAGCGAAGGTCGCCGATCGTTTGCCCGTAAAACTAACTGGCAAAAGCCTAAGTGCTGTTTCGGGTGCAATGGTATAACTTCCCACATTTAGCCGAATAGCGCCAACAGCGTTATTATTTGGGAACCAAGCAGTGGGCGATGTCAGCGACAATTCCACTTTGGTAGAGGTCGTTCTTTGTAGAAAACAATCTAACATAACTATGACACTTTCGGTAAATTCACCACCTTTACCAGGGTCGTAAGTGGTCAAGCCACGCCGACCACTTCATAAGCATTGGTGGAAATCGCATCGACACAATAAAAGTACACCAACCAGCAGAAAACAGGTACATATACAGTTTAACGACCTGGATCTAAGATGACTACAGTAGCATAGCCATAGAACATGGCACTGAAATATCGATGGGCGTAAAAGTGAACAACGCAGACGATGGATTACGACGCCAAGCCACTATAAATGCTAATTGAGTCGAAGAAGGTACTCCTTTTTGGAACACAGATATTGCAGAAGCGGGAATGAGGTTGATATTACATCAAGTATCAACAGACGACCTCAGAAGGGTGGTCCTTTTAAAATGACAACGTACATTAAGATGCAGACAAACACTACTATGCTGGATGTGAAAATGTCATATGTGCGGCAAAAATAGACGACATTTAAGAACCTAGCATTATAGGATGGAGTGTTGTATTAATTCACTCTAGAGTAAATGGATCACGGTGCCAGAAACTAAGGTGGTGGTAGGACTAGATGCAAGTAACAACGGTCGTACTAAAATCAGCTACGCGATCGCCGACTTAGAAGGCTGAGATGGAGAAACTTGTCTACTGGCAGACCTCACTATCTTTTAGGAAGGTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAACCTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACAACTATATCAAATCGTTGTGTGGTCTTAAACCGACACAGTAGCCATTCCATCGTTGGATGTGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCCCGGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTTCTCTACATGTCCTGGGTGGAGGGGAGTTTCCCTTGTATGGGTGGAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGCGGTCCATATGTGGGTATGACGGGGTATGACCGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGACATTCTAGGTCACCTAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAAGTGCCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGTAACGCTCTAAGGTAGGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGGTGGTAGGTTACATCTATTTACTTCAAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCCGAACATGAACGATGGATAGTAGACCGGGAAGACCAACGTTTTTTTCACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGGTGTCCCATGTTCGGAGACCCTCAGTGGTGACGTCCTCGTAGTATAGAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  Rw\Qc\cMudc@P2pMGOP[^WbcN6askPb\2PeZ;4YVQMDi[ccLm5ba`^ZN_@r^8u{ZOEsbMuPEsbFvvcc\_@u=sl2vM[@Cb[P[cNb2fPI_pB{\Bv^]Z]Zc\Ftts\:ZHv]8OI\_QOpQW\?<BNc]cQ`/V;D&GO):f?]$*+dd].cAEfICcPEf7lkU?@EfI?ffR,MBWIFfIXIRIQT;JPU4O()PV4AY<WR.[MD4_XQI5421KcgXGK<1fSGHEfB6fXHP4:AM=IF8CbBQUIBLHRG;VQIRI@fhV5WUAQeV<CLKeEfXH:,fQXTFQCcNO7llRX1N`cHV=eIXEfI4ONOO<kW:INXRIWR@'UH.dcU;F8bV2c>R@ANIG[5YWPHE*Rc@:1dQJb?QKIR6WEbEBO3?)OKJfXEff%`LLf<kBaRA)AL<WOIRXXRW9WNIRV4;cLf<jV32beFhW@HBDfV4MBGG)PdQXUK1PS_IA]XIXAcIV@KfI9MXQBB2E3M_44cW&c`:\IX<jB9J3ceB<jX4ieXIRV8bQXBEV4@QP<kXCJ;KNW=KXIMfIXXBhRHBHF3cWEf,eTN4QIP8CLU67=;`?;ddO9U>7C/gCQ0h0;HXQ'cccHXD_;S4IWU@M9WQ6eeLfIRP3UR1_WWJTBF::WRXIXXIXP@VRIXXWR<kTS'BKaC;>EfHCHPN?O[KHW7;MW0eT/IX?fffRXQEFJFfIRHBQV4PBWFd@&cUIQ@5P<iFQJ/hWIXXX-eaTQIXLfD*8VRVDK<eQKc3cWXIX>X0dff]EfJ_0J4T;RKL:eQIKCDQRI@ggKf@LDB_:eQTRAFgWIAWI1NKBVXILfIXRXIRU=WTFXRLg4heXEfX$33dfT;^bPSFUEGeIP@GGTIFLgRXXRH?:QE8bRHWG?AHXXV;DMEeSHRXO-SdUL<F6VTTXRXOEBEE*QXe^XXRV4QXIX-g[,YQ:Y9fNXRH/MfXXXEfSHEfXP@P:eQW9AY;d:eGR9F'A&'5CH$DBE5KAWIXJEfXN;hOO3GFHV1PDe>2bW%9>@CH+F?URXXRG+OMFLfDHeJEdXF?@G4U)cd[AGB<HWP6O1&QM38=XQTF8N>:,PDX5WQQFQ<DbGO.SSHKe;VIXXIXDd3,IW<kXIXIXXXH1ef[EDbEaEfUISFP*]:HEdIX4eXRXQOOEeIXXRL4D3@>)QR7SRXH<MA<5V;K;CKIRXIRBfcE9BgXIFZFCL([$LN?QIXL*LH:`G>hRSGX/QEJXV5IcSJJDbXS<7c0G?%ZVXEfXRA^FXXQBG8aeQXXN9GQIXXNGHJ_4R@OSH3%_\EHRIZOSGW1E94@P2JI+a9HIVH>:.XR%ADLf%VXS4QIFCIU@O@De;dDiRIO/BQ6fXH=4ABKXFfV;QHRBMMG4YX3lK:43`O^IRX$KVXM08A^_Ab@HRI3dbAa=BP:fIdV-dc@5cWHM4_Y(\g4LCOGEffV@HXXIPHFK;kX5ieXRLf<hhhXXP-LIBfR0SFOL@,NQT-KW4geXEfX&cc0.:8eZ)OQMfRSGX9d7-F^8E-`U-E4jcR<h3cWRX@hgXNGRK_)@-Z8@&2CY@.K)<WXRX:E[@VU<IH*LD0/BP7V%QRUJTU<FEGRKWIQ:eQXJ7A+QX>ffXDf@0aDHRT:OI\>:1&I,;>FL-FdQXRIHEfXEfXRKb5WEZ4VEfXIO?(E>GEdXFK1cV*S1OW;HQ;dM?PV;4L7dU9`9+0<)UQU;EOGeHNG8\@IIV4);''G<;'@$2IISAQI8;RA5I3-21GASOGM-@:WR1jV5\YJ9hgYXJXI`<UP7_KPGXQ?4EB3F;KIBOT'?Jc5NE@HU'DEgXDG_YXHCG<LfXRW<OHKQ4VWZUP6D+8EOH&QYJSAdJI\?PPMfQ)dVQ;8IYSEg[-F3geXFgXYFgMgB6VXHAR?ffTGIVD.DQ\A<HEKAO*QRU=J.j_@94NPH>EcSJ@g[QA;LDD;eRMgP;O4eYAdJ4\OR*P`YR=lSMgJYW:BQGRVABb>XXSW3NI8D=\fGP=,2K8?7J);6FPGLITGXTGX?iS.g]M;aGO2WIW<Lf>gf765DeYQAWFgIfJDfTFT;T@g?fhSJYU'_US99'LOLK%0C53c?QT&RXKGYSYGjYSYJSW-hRFQAWSWCVC<AYI$cdeeeeeecZOJIJMT^deeed_UPU^cXRXB6B=M:B>7FP;2C=iYJYQ5Wg
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/578/ccs/rev np:i:5 rq:f:0.99331
  AAGCAGTGGTATCAACGCAGAGTACGGGGCATACTGCAAGACTTGTAGGCCCATGAATTACCCGCTTAAGGCAATGGGTAGACCTTTCCTTGCCGCGTGGAACAAACCGCCATGAGTGTTTTACGTTTACGGTCGGCGACCGGAGTCACAGCGCGACCAACGGGGCCAGGCAAAGGCCCATAGGCTTTTCCATCGGCACGCGACCGATTCCATCAAGTGTTAGGTGCAATCCCCATTCGGGACGGACACGCGAGAGCGTTAGTCGGCGCGTGCGCGGGACTATTTAGCGAAGGTCGCCGATCGTTTGCCCGTAAAACTAACTGGCAAAAGCCTAAGTGCTGTTTCGGGTGCAATGGTATAACTTCCCACATTTAGCCGAATAGCGCCAACAGCGTTATTATTTGGAACCAAGCAGTGGGCGATGTCAGCGACAATTCCACTTTGGTAGAGGTCGTTCTTTTGTAGAAAACAATCTAACATAACTATGACACTTTCGGTAAATTCACCACCTTTACCAGGGGTCGTAAGTGGTCAAGCCACGCCGACCACTTCATAAGCATTGGTGGAAATCGCATCGACACAATAAAAGTACACCAACCAGCAGAAAACAGGTACATATACAGTTTAACGACCTGGATCTAAGATGACTACAGTAGCATAGCCATAGAACAGTGGCACTGAAATATCGATGGGCGTAAAAGTGAACAACGCAGACGATGGATTACGACGCCAAGCCACTATAAATGCTAATTGAGTCGAAGAAGGTACTCCTTTTTGGAACACAGATATTGCAGAAGCGGGAATGAGGTTGATATTACATCAAGTATCAACAGACGACCTCAGAAGGGTGGTCTTTTAAAATGACAACGTACATTAAGATGCAGACAAACACTACTATGCTGGATGTGAAAATGTCATATGTGCGGCAAAAATAGACGACATTTAAGAACCTAGCATTATAGGATGGAGTGTTGTATTAATTCACTCTAGAGTAATGGATCACGGTGCCAGAAACTAAGGTGGTGTAGGACTAGATGCAAGTAACAACGGTCGTACTAAAATCAGCTACGCGATCGCCGACTTAGAAGGCTGAGATGGAGAAACTTGTCTACTGGCAGACCTCACTATCTTTTAGGAAGGTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAAACTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACAACTATATCAAATCGTTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCCCGGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTTCTCTACATGTCCTGGGTGGAGGGGAGTTTCCTTGTATGGGTGGAAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGGCGGTCATATGTGGGTATGACGGGTATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGGACATCTCTAGGTCACCTAAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTATGGGTGGTAGGTTACATCTATTTACTTCAAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCCGAACATGAACGATGGATAGTAGACCGGGCAAGACCAACGTTTTTTCACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATAGAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  .OIRTGG9YQJVQIW:F(UJY)H>A&]^^UI-T@UBZ9\CTFTtQccBS4rrbZ=TrB\C.S:NZDs)ID}[?]_8{wK]Na;r:T:Hh>POKlPAHD?^1qY.rq:oO:o^\Qb?F8-frrb[M:ajKY6e]Y2wZQb=q@Y?QL4]Y2CUKUKJ8>Mj[6qahMtb4vWIls-@Bitdcb2xZ3vkM=sbc\DsDHCLHO_@iPa/g'm3[SVtPNP;IX0`&<+>US;VWUa/nV:rbc[2w`C`[PBIIK[<ZQKvcQc[2uZOD;IJ\PX9v|bEacEr``P[NMYB^cZ<NoOOJG'ET[O6si;L1bdg(KRi[Y%uT*cbW?LoMUtM[;VFL9Ld[:|O18ETrbBN%[[Cs[Tp3rpaV3EslKL<jPUtMaNF9>^EsYKMSJRsX@mb%hAAl)eIpVtQZMM\,xxWLbbO[[cR\Rc\UvUuOwbC(UFDtccQcB{c\RQuY3aOSQccQ5sbN?Rkb[N2bZcbCsXVVbR^\bFItl@$k\Ess6aSKKvdIo9KqcOt]%Xcd`Z0`SrBG>`MZCsPMuc\P*?:U:qb[Cr\^9SsQ[O9XDxb0nBHlc[PE\HW']Ea\UtcAuu_Ac^ZKLtTv@wcQ[\8>]a`WU5_K^YY5K^c\^67VYSe\P_GkF0UDFZMSn<`cQcXM_TdP7J;Cacb=Nu]2X.Nu\c%ED}[bWXL.roT_c\Qcb0{sZN\?r]VB[N0qY?sX=EaQbENKY)Y[:HP[Qc\QKq?\P:q`C>E8EanUP\cTrDc;`9DQPVtQUr4ybc\b8m3kp\H/`Rk\c[LMPba>>HDILRqQ[.yxUscMb2wCqMKabCr\T`M[UtQc_\[Dd.]=aZ<aIgO\a+PW3dbaDvcX3tvH7VjjaPJZUt]Qc`U=8pUlPL_<[cQF[=sh/_WRbXSWG;ZcAs4^PM=/bd[PNP[cc_O?V=ZChY2uul_bcQbH*]\b7]UBp;RnNxccQ[L?Ac_VCfbcAv7O[EM?Qc_@qBtKaZc\cWG`:`KKPOcAs2I[cX?wcQLtP-=R^'`;^.URAPOMK`$sB[ccQ_\Q\UtKa1qYB]B2XN[QNaWT2rvpb\dQ\c`/MZ<ac\O?iQ`XKqUQPZDx\cM`;3G)TL2:T_D=N<5RM_Z9Cj\`PD*oLI`AXa\Y5Z]^^3xRb@xc]_TQR]NY>_Z]2``BV,IaE}\cdQaVTCaR@wc\cQaCQ[V9_nAeO[MWN][QEuvccBzMZSjH[H>st[cbNFNM=rsTvcBWJ@_YB{\QaDJ=BF@[BzbKNF:2XcBzN`4u`<SqR`aRbF*jUP_[<TrO3MINJY<SZccbba]7pac\N&cKLOL[/[LXAV6tcBA*EQ_DJ9EbQ[E>q[JaX+KX3xa_LcCwOn-UN\b\`QOwc[M/l/`\?@4K>K`\cbE=Ub3rrP[6hRbZ*H+)O^=a[-sl@hc[QE7vUAx3aXKr@Tb<}x_ByaC67Rj>sd/kcc[+dNN2Z^cXUcZ7Ktc:t`]NOf.ziVK`Pac[?upPN6,NZba<aMuc=~ycBbc&utMKN+pm7oSrAc^c9{{c@p%oGFvvVtEqe;H\/\O>^8m\U88>@jS\@i][4a92B5[cGRMOM4]U3I_QbE4oWB?UAc\NKZccHvt\cQc\QLWM4Y<ttt_88,_=w\@]AhNcMuUuc\cLUa=aSL3p\PcPFn@^I-;HLPU[_?v[a3moaE^RY\D9ZAzc\cNtH<srS4_OZ<DmO[75;Y<:iSC\WIuRIuPL/pU>HUOA9gMb\cQ@trPcQF7o_TP[cc[@]PbQ[>YQ]Ed;[Y<SAGLKt^.TT[9u`QT[a;_PLOHonLDaQc_U^G8FWT;mp>sOTtEKSH\bGsAzcb9GaZIB:BpbQNPbMJK3ftuaPTb2vTJ4XQc[ORs\Q\:prKjPA@NOcP\b<0mF7;w{c@^ccE}6m^Tbc\ccHs`VSCrU0c[ICIB?rcQ8uhLbQFvvc\Uk=ZcLsQ[=sl9GAuuqUqK0oPTr7w\Rv\UuQc:jEU=+nN>[AQcQVt\Qcb2CTMaOYJOcOk;{w%,eL`MuVt\L&T`^c][bEac\cISN%`OQ=m\_Tc\dNQf:JcEoDAycQccA_Aq\DyMOLOb<e0wxaIb_?fJP`Ls_F1GDAxcQb;XXEH@\)wZBc\PONnc\NYVO>HZ_QMtU$rssrmc\XYbnsssssnfbchdaciqri[QIUO\d\dR[RJsQ^Ia?s[6UNO)S
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/603/ccs/fwd np:i:6 rq:f:0.997485
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTGTTTAACGCAAATGCCACCAATACATATGTGTCCTCTTAATGTTTGCATGCTTAATCTTTTGATTATTATTTCCTCTTTCTTTCTATTACTAACTTTGTAACTCTCGCTAACCGAATCAACATAAATACGTCAACGAATCAAATGTTGATCTCAAATATCTGTGTCCATGAAATTTCGGATCGTAATCTGCTCTACTTTTGTTATTACAACAAGAACTTCGACTAAAGAACGGACTATCTTGTCTAATAATAATGGCACTAAGTGCATACTTTCTCGACTACATTGACGACTCAAAATAAGAAAGGGAGTTTTTATACATTGACCTAACTCACTACTACGCCTTGGTTACCTTTGAACCTTTCGTTGTCAAAGTTCGTACGATGGTAAGTGCTTTCTACTCCTACCGCTATTTGGTTGAGAACCTGTTAAATGAGATGGTTCGTACAGCGGTAAATGACTTGTTGAGTCTTGACGTCGACGACCAAAGCGACCACTTTGACCCAATTGCGAACTACTAAATCCTAAGCAAAGACTATTAGGTGGTAGCCAACTTCGTTAATTCCGTTCAGTACTTTTAAAATTCTAACCGACCATCTTTCCGAGTTGCTTCAAACCCTCGTCCTAATGATTTACATCGAATAGAACGTCGTACAAACGCACTACTACATGGAATAGATTCTCTTGTCAAATCGTTTTGTTTTGGCTTTACCCTTGGTAACAAACTTCGACTACGTTCGTACAATTCAGAATAACCTCTACCTCGTTAATTTGAGTTAGTTCGTTAAGGGCTTAAGTAGTTATTTCTATGATAAGCACTAAATTGACCTTAATTTCCTCGACTTATTGTTACATCTCGATTTCCCTTGATATACTCAGATATATTTCAGTATCTACTATTAATATCAAGTATGCTAGGATTTGCAACCGTTCGATGTAAAAAACTAAGTCAAGGATCGTCATTTACCAATATACCGCCTATAACAATACTACCATGTAATGTTTGCATGCTCTATCTTTTGATTATTCTTTCTTCTTTATTACCCTCTCTTGATTTTTTACCTATCAATAAACTTACCATCTTTTCATCTACATAATTTGGGAAATCTGAATTAACCTCACCCAGCCGTATTCAATCTTTATGTTCATCTATTCTTTTTGATGACCTTATACAAGTTTCTCGTCAATTACAGAGGTTGCGGTGGTTTATTGCCTCATTCATTGAACAAATCCCCACCCCTCCAAAATGGATCACTTAACATATTGCTACTGACCATATTTTGAAATCGAAAAAGAGTTACCTTGTTAGTTCGCAGTTAGCTTGCATTTTCGCTAAATATGGGTGTTTACTTGATGAAATCCAAAGTTCCAGGTTGATTGCCTTCAAAAATACTGTAACAAAGTTTAGTCAAACTTTCTCTCCATCTCGATTTCGGATTGTGATGAATATGAAACGTTAAATTGTGATTTTTTCATTTTCGTCCACCAAACCTTGAAAAGAAACCACGATCACCATCATAAAATCGTCTATTAAGATTCGGAAATATGAATCTACCACATAATGTTTCACCAAATCCACGTCTGTAAGTGCAATTAAAATTACCTCAACAATTACTACTACAAACCCCGAACGTAACCGAATGTAAATGTTGATTCAGTTGTGAAGGATTAAGATTTTGTACCTCCAAACTTCAAAACCCTGTTTCCCTGTCTTACCGTACATTTCTTGTAAGTTTAGTGTCTCCCGCTATTTGGATTTGGTAAAGTTAACAGGCTTCGTCTGCGTATATTTATATTAGTTATAGTTTACCTATTTCCTGTATCTCTCCACATAGGCTTGAAACCGAAAATAATATCACTTCTTAAACTGAAGACAACGCGAATATTTCATTTATAGGTCAGTCCAAAACTTTGATGATTAAAGTACGGACAACTTGTCTCAATGTGTTAATCAACACTTCAACTATTGGAACGAGTTTATTATTTGGGTCAATTTTGTATGATATAGTCTCAGGGATCGTCAACATGAAAACTCGTCGCGTATAATTACTTGGTGTGTTGTCTTATACCTCCATTGACGAATAATCTTACATTTCGATTTCCTTACGTGAATCATCACAAACTTGTTGGACTCCCTCTAATATCGTCTTCAGATTTGTCCTTTCTCATACGATTGTACATACTGTTGGATGTTCGTTTACTCCATACCACAAGTTATTAGCTGACCACACGTTTTCCTCAACTATCAGAACGTCTGGCAGAACAAAAAGCTCTTAAACTTTTACTACTGAAATGTCATTTACTTTAAAAACTCCTTTTATTAGGACTATATAAAAAACTATCATGACAGAACAGTCGCGAATAACGTAGTACATCGAACCGAATATAAAGATTTCGACTTTTACTATCTAATCCACTGACTTTTTCCATAACCTATGGCCTCTAAATTCGGTATCCAAGTATTTTGCTTCTCCACCCGTACTCTGCGTTGATACCACTGCTT
  +
  _~a[Q`jR~hRfD5oE^A%Y__Pf\%~~~~~~~~~~~~~~~~~~~~~~~tj>~Z7mAUcAxyui?pYH~?jvshst]tjYkq2~occ~Q~ukK~~kgtvlgd~R~pg6~~~ltd~\Q~sQ~~S~pfK~~f>~jPo0b~^fs>veL~~kv`~bLN]MSev^|MRiR~ufP~e^tW~~vtglvfM~clU~ve=~~pUc~ltvgvgL~~vtugsmof[B~svlM~uK~~dF~rveTsL~nfulgvgu\d=~~~iX|se~rR,WRU~h[vdb~:WqcpDRhjL~c[~]frGqfd~j]apa~uR~uT~r2~NrfuP~ktTdIq]5Bd~NXdltgq,LZc~Ojfk^fva>rt~ub~lPlWQ~~]kK~~~~\sk<pT~ksG~uT~gve]fvtdb^`VT~e~[~K~]T~?~~j>~Rw0ppdTb~UqeDuaie~glq1`i2r4~v[~SrUeZ~~d[\cr=sBLE~kgu]L~~Y~L~kqjN~W~wkR~=|{rlqOXsY~U~flwsf\iPY~uH~~ul^f3wkX~lrhpgd~SY6MYOi^fi.<~:w~iPi^E~\cR~~mn<z~)l`~khjP~d^qMUC~~\T~QN{jgD~~f[J@oe~tZ~vZ~v]i1~O~fe~gle~Q~P~C~jR~gsfWpgB~~x(~~je~frP{RwjEIWCqPIwa.~jtkR~kge~d5~o,~~tfllS~o>wsl]Z~~sfnlckZ~r]jP~flvglvtfI~{Pkftgt^fv]cGsM~b~vtk\Q~c[O8qkvf+ztqPUF~~}U6~~p[~g[~~q)cca~Z~vb~e;~W;c~gk^c\naSQ~fltYcb~a~cskR~ub~U~vgvtK~n:hT~`~;~~hDdQ~\ke~hle~?mQ~~gMwP~i\rkR~p=~~et]sUrs[~jOGevG~~M~e\T~d~<~G~~U~k`lrPb~t^~ld~GbEhNZOjpA~jK~~R~h.Y[s\LB9FhFZhmIV~zdXSttvanYarEa~N~[lkKN~kt]sUevu\~t;~~Wc8~R~gb~hiDqmt7~~xwfPqOviT6_~Z~sugjZOrR~~tT~Q~s]s[B~jT~vqv`~g^~vqhvrF~svluP~^TZ~~le]uleqfvtsg6~~~ltd~]d~e;~{aTzfY~r2_~^K~~mgpgL~gH%~~~~qrAusuufK~\T~~ge~]Cn1re=z~~d]pctRMSROy>~Z>~~M~~vgvlT~b~P~Q~]`3$~vbkC~ksGd~fP~sPY~~[aZ?zMVLIo]P~O@~~~~SJNL]T~d~]p)6WuV>~F*dSPq@?|d~YctltY~R~kg\~vZ~K~~sd~UP~se]c~hsP~jBmRV~~t(yyvrA~~~qR~8~~~uZ~tqcocR~T~cDssM~jPr^fvj\+|OmHQ~~~k9~~rKf?yyz~ltlM~tQyL~O`~tle~glgui+~qmd>~je]8~~uPkft=~~tsuE~~qhG~`.GP~j]ulR~h>1~<~~kR~W~t[~c~Uo>~fI~^~e/~~~~[gGklva~b(st[K~xGktLEp~Q-~C;rd\Q|qmfldlsK~~f\~rN~>pg.qkQ~trpk9~~ekT~H~~e~lvk\/~~~~zdX8~~{gj[G~qB~;~~V~d~S(~~~gH|~W~tZL9dW^Q~pve]p=~~~udTrPtrT~O~krR~f[~=~rY_di.~cRlhC}fPOtb~m]X~~gaT~,~|uV~]`Ttgvj\`~mtUdP~e~O~~~e~qU~[RLqeM~e~tgvtgvogU~~5~|fTT~bTtb~Ryi>~qUq9~~tle~ltb|@^dP~TtkP~Y~te~L~ftR~~~lt\,prSt6o~eR~a(r~RK~~bkL~~4~~tTtge~sL~kvtgr>~~fY~lt>~fH~~sltTtfs,~~kft]Y~~F~]R~vF~s>x~kd~:~N[Yu:I~PQrPtlgj\iVZ,|vrk2`~tld~ustj8~~pF~utZ~~C~tmqXibgdsS~\NFsoY~Pd~kH~|>Pf%s~tuN~1Y]`qge~ge~W~~gvfL]k^f_wglgjA~tsN~~ht,~ztvt[~\TbltC~B~~~d;~~j]ujGIjI~~i[[eBpreN~dQ~g@7qbNsulukR~a~ugTi:fR_|IN~fsGc~\~`~Ogng<~~O`~sM~~Kq~ugRm:~~~TrXmk]r]stiE8^dXN~~]uhlVgTf6ZYi7~~~eqflvglglvtt?~c~GbH~0}vlvj>~jr<d}q\qR~[M~rR~k[OiAyaRssPOjFOqZ~~gj\@~tV~d~aUkvkR~ue]sO\eI{~ab~i,~Z~Y`Z.~~oLkDFrpsgmq8bwdZkrRx~lvL~Z~~bCb`b`ek]M|[sXa]s]fwkS~F~o\iR~fl[~~r\jU}HssK~]eQ~ke~td~alfvk]S~[_TJeF~~Y1~ZcD~fhN?bEiP~glvgvZ~gskH|I:Zyy|hfqcd~9~~eH~~~tdYEfvkEupVkrPr?~w]d:wn6~~~~fqTs8~~~sd~]Y~tgvtvtv,~~qrYQtttOGslshsj,~esmvaggkM~OJ~flt]kpia\ufjA_C~jPutrs*~xhs;~gPenf;~~~]enQ=ct`~]L~tgvltf<~~~vT~tuP~S~Z[uY~E~]dfH~~JsPY~t]tP~?~lvt)~~qlg]~daD~\I~~mvtgjgclgkP~RZt]R~Xfvlgk~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/603/ccs/rev np:i:6 rq:f:0.994989
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGTTTAACGCAAATGCCACCAATACATATGTGTCCTCTTAATGTTTGCATGCTTAATCTTTTGATTATTATTTCCTCTTTCTTTCTATTACTAACTTTGTAACTCTCGCTAACCGAATCAACATAAATACGTCAACGAATCAAATGTTGATCTCAAATATCTGTGTCCATGAAATTTCGGATCGTAATCTGCTCTACTTTTGTTATTACAACAAGAACTTCGACTAAAGAACGGACTATCTTGTCTAATAATAATGGCACTAAGTGCATACTTTCTCGACTACATTGACGACTCAAAATAAGAAAGGGAGTTTTTATACATTGACCTAACTCACTACTACGCCTTGGTTACCTTTTGAACCTTTCGTTGTCAAAGTTCGTACGATGGGTAAGTGCTTCTACTCCTACCGCTATTTGGTTGAGAACCTGTTAAATGAGATGGTTCGTACAGCGGTAAATGACTTGTTGAGTCTTGACGTCGACGACCAAAGCGACCACTTTGACCAATTGCGAACTACTAAATCCTAAGCAAAGACTATTAGGTGGTAGCCAACTTTCGTTAATTCCGTTCAGTACTTTTAAATTCTAACCGACCATCTTTCCGAGTTGCTTCAAACCCTCGTCCTAATGATTTACATCGAATAGAACGTCGTACAAACGCACTACTACATGGAATAGATTCTCTTGTCAAATCGTTTTGTTTTGGCTTTACCTTGGTAACAAACTTCGACTACGTTCGTACAATTCAGAATAACCTCTACCTCGTTAATTTGAGTTAGTTCGTTAAGGGCTTAAGTAGTTATTTCTATGATAAGCACTAAATTGACCTTAATTTCCTCGACTTATTGTTACATTCTCGATTTCCCTTGATATACTCAGATATATTTCAGTATCTACTATTAATATCAAGTATGCTAGGATTTGCAACCGTTCGATGTAAAAAACTAAGTCAAGGATCGTCATTTACCAATATACCGCCTATAACAATACTACCATGTAATGTTTGCATGCTCTATCTTTTGATTATTCTTTCTTCTTTATTACCCTCTCTTGATTTTTTACCTATCAATAAACTTACCATCTTTTCATCTACATAATTTGGGAAATCTGAATTAACCTCACCCAGCCGTATTCAATCTTTATGTTCATCTATTCTTTTTTGATGACCTTATACAAGTTTCTCGTCAATTACAGAGGTTGCGGTGGTTTATTGCCTCATTCATTGAACAAATCCCCACCCCTCCAAAATGGATCACTTAACATATTGCTACTGACCATATTTTGAAATCGAAAAAAGAGTTACCTTGTTAGTTCGCAGTTAGCTTGCATTTTCGCTAAATATGGGTGTTTACTTGATGAATCCAAAGTTCCAGGTTGATTGCCTTCAAAAATACTGTAACAAAGTTTAGTCAAACTTTCTCTCCATCTCGATTTCGGATTGTGATGAATATGAAACGTTAAATTTGTGATTTTTTCATTTTCGTCCACCAAACCTTGAAAAGAAACCACGATCACCATCATTAAAATCGTCTATTAAGATTCGGAAATATGGAATCTACCACATAATGTTTCACCAAATCCACGTCTGTAAGTGCAATTAAAAATTACCTCAACAATTACTACTACAAACCCCGAACGTAACCGAATGTAAATGTTGATTCAGTTGTGAAGGATTAAGATTTTGTACCTCCAAACTTCAAACCCTGTTTCCCTGTCTTACCGTACATTTCTTGTAAGTTTAGTGTCTCCCGCTATTTGGATTTGGGTAAAGTTAACAGGCTTCGTCTGCGTATATTTATATTAGTTATAGTTTACCTATTTCCTGTATCTCTCCACATAGGCTTGAAACCGAAAATAATATCACTTCTTAAACTGAAGACAACGCGAATATTTCATTTATAGGTCAGTCCAAAACTTTGATGATTAAAGTACGGACAACTTGTCTCAATGTGTTAATCAACACTTCAAACTATTGGAACGAGTTTATTATTTGGGTCAATTTTGTATGATATAGTCTCAGGGATCGTCAACATGAAAACTCGTCGCGTATAATTACTTGGTGTGTTGTCTTATACCTCCATTGACGAATAATCTTACATTTCGATTTCCTTACGTGAATCATCACAAACTTGTTGGACTCCCTCTAATATCGTCTTCAGATTTGTCCTTTCTCATACGATTGTACATACTGTTGGATGTTCGTTTACTCCATACCACAAGTTATTAGCTGACCACACGTTTTCCTCAACTATCAGAACGTCTGGCAGAACAAAAAGCTTCTTAAACTTTTACTACTGAAATGTCATTTACTTTAAAAACTCCTTTTATTAGGACTATATAAAAAACTATCATGACAGAACAGTCGCGAATAACGTAGTACATCGAACCGAATATAAAGATTTCGACTTTTACTATCTAATCCACTGACTTTTTCCATAACCTATGGCCTCTAAATTCGGTATCCAAGTATTTGCTTCTCCACCCGTACTCTGCGTTGATACCACTGCTT
  +
  \sEHhYO:vhjh`H~_F_j]j\fV`$Z`hq|~vledlw|sidelw~~~~wjelb\N~zK~`]`>~s8C>|jR~Z~eK^KfPe[OT[?yaBE}[~fK@~~\ajfF_G~FjO`H~~~]iH~iX~jO~~R~ha5hi`A~}ahiH~h]_G~D3gf\g\~ah`Q_\5dHq;zZH~g`4~_igE~~gia]haS~aZUuQIH~`<FFaQhQ_Q]?d|fe`Ke\fFRQ~jfFC~|8fhaM~chb\RY~;^Q[ahahja9~vaWUtiG~iaQ~]TwFU~`2{_]jahD~z\Lz\NnjbhhR`Vh-ZadV~_7pPE~PL~Ig_QH~[h]ajhja%\aafJ[iaUgHOGz[Q_^gHO^1~~~f[~\Aga9~~i]<~~~~jhibdJ{[QP~P>w]f`jahjahj`FP~IsNtG~iR~$|yDGZ~R~<vG@Y3SEO`H~fCC^[YOh]W^Y%ri;<m\R[`5yY@dahS~fN>aV5Od.ca=M8VPi]\~R~h\HyR~~fFg\id8q-F`ZUiaj]`>~fQ~~KLiaWyCGoNNCK_ExEg`Ffa]fa^jR~R~~]aZJ={ha?~d0d>~X}'V[`EG~`hhJaN|~QR~hX~[K2~REO_egGcf>tRNtONY>~[~a%\Y^[F~H~HrQ~X2{_j]hja=~~w4xn3n`P4~P~I`?xjhaO~~S~]j\G~\aX~a5~[H~~ha\;Q~h\~h]iA~~hajdGWR}fL\H~L\S`\ReaE~~a]ajahj`QfJfT;u<yhjZ]V~ae]/WGN]B~~Q_G;~~pE:{~rJiK>sQ-I<G~M~h\~aD~~\5h_]_`QhaZU~b]hjaZ|2{_j]\~hX~R~hahjOnI@UX~W~C~x[A[X~hGGk^YD~Z~9qq`X~\~\Uj\NldN~zJehR\jhX~[Ie^g?|dF~\jR~X~[~@~~Q~ha]jaH~iX~]W~jai%K\e`]h4~qJ~e7}[gY>Ohahbj]bSghiLycaj\Rhh`Qhac`X~[~QgQ`\~]hjfF^Qg<~g1~~[a\~Qa2Fda]hR[g1~~~~zahX~Wga\~M~jha^hag(Sgh>qTwLhhjR~]R~gVP6~^Q~hjahjR~hR[hX~_[?zwE_iR[ahafPe_&[X[\iOcd+gZ:|yZX~]GymbG~hE`wb[h`4}[j9~~~~`JQ~hhR`[~QD~~a?MIR~jha8~~vJgeIfjajh[|1~o8~|Q~~gag]H~W~L~Nbh`Q.t?7XQ~FeiH~`\~c[HiiiUF$a^Pe\D;5^I$byvY()cR[fQ~F~f;ga\~\@~~_O`IS`V}Hfgac-QL~G~\a?|hM~G~nb&-3P~fJe@bZaSb]Uua8~xgD~~~iA~~~hRs5~~wgO~jfG4\Gg\~ajed5}[K9gagLiR~`fe1loy[D~~g`G%r~~~\\j\9jd?qX~\NmcEE~`]aj]W~hF_X~]ah,}}}`]afH~~hjhF~~h]/~qgNPZYbhZ$|OMcPx~\NmP~PKw5yXcJiFPi%z^-~yftPh`QZMCc`R~~\>~~hZb`D~~`@~~`hafA~hhah`FgO~~aM~jX~\R[eOEX~hhQ[C~~`ZHyE~j%y[XNYJ,eYfpfYh8xyr_B7DggB{4c`=gQs]1~~RGP~d.{f_C`fJgRqif_R%KI~~qIFWTM;f4yF~ZO5}`?nG~H'e[&^S~h]_jR~jaiQ[~h]O~~_KQ|R~~f>~ha]h`OA_\~Y`F_H~<M%j~~ZX~jR~c[Z~JZ~I~SNc1S]jaB~~-~~d]UuIVf\~R~]\~h]h6~\MUX~]iF~Jg]W~]h]\~O~h6~Ap]jH~~{[;gQ~QQ~D~nI2{I7uL7~~eHDrr,~jfEL`W~jR~KfgbhD~~a7WIdV~]O~~jZ^C:[h,hb]ahjC~[;~g0~K'}>:P~~]I]7~_h<~_F~IWc[h]a^hjhjL~z`UP6|N,1vggi]O~~jR~hj2~dCpcZaPe]&X^R~hJZ[iM~aG~\3~dQ~YI~~~hCiTbh`P_T{DEiC~~_dFU~]ja\~^]_FI~gi>awajD~~ihf;~OHfC_R~@~~{`.^tXch]iG~Q~}Ybi`<~e`IpKV{E;_haXn>N;I7_[~haX~aj`3CD%|``gh5}L~H~`[ODC~nPW~jD~U4NxgaV~&?\GGfe_Zcgigi\_Dfaf;V`hR`]h`6p\Q]\3~~qahb[;_\`C^ifH~HriaC|H~h]h]H{]f_6oifPN~RO~jX~Yda]\~cV~Q`X~jah)|j8Dg8~cP~K~jb\fFZ~hag;_ja8~r_O[SR[FyL_hH~~hahU~gbN`]haY~aj]i?~uFaR~2~n`Q`jhja]jJ~]hjag;gafFHrL~ch]X~a]C~~jahNca&eR~jaXvIKqjJ~hF_ODO=jeJKHB<~~pQ~Q_H~_NdQ`gEF~`]R`f>~^PI[~a-~~~f]a4oaF{?~~`=jjjiac`\IYR~~g[;]J*?VS_0{v;~~~{ahR~*ai?A5g`;~Tafjhjb5w~~~yahhR`gcFgaIWJ~]6WR`\[@[~WL~keXlettTttlfQ~I~eb~tu^@~|cq;~~lgvk8~~~tkgoXjrQ~]H~tk]evl0~j\fY~t\Q~K~ho^U~H~skt>~|Q~VQvqt\G~d~`kkL~saTO{irF~tO~~fJrTqltfld*~cu]tL~vh.PjP~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/624/ccs/fwd np:i:7 rq:f:0.997543
  GGGTATCAACGCAGAGTACGGGGCTTAAATGTCGGGAAATTGGGTTTGCGCCGCCTTCAGGGGCAGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACAACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGATGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATAATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATGGGGAAAGAGCAATCAACTCACCATAATTTGTGAACGCAGTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTGGTATCTAAAATGGGGTTTGCCGATGCGGTCTTCAAAGTCTAAAATTCTTGAAGTTTGCGTTTGGTCGCAAAAATTATGGATTTAGTCGATTATTGCCTACTAAGCAGCAGTTTAGAAGTTTTTAAGATAGTTACGCGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTTCGTTGATACCACTGCTTCCCGTACTCTGCGTTGATACCACTGCTT
  +
  1~~~g~sY~i\XPwjx~hnAihxn_v<~~py~sW~~M~~u~N~~I~qLq{^~uC~e~]~P~~~qizszi~H~~~~sxPoG~y~{~g~hN{P~g~V~{Cn`~~{~~~{prF~~znTB~~hQ~~~sj~J~vY~s~S~~y\wG~z{~zg~({{FP~}bRvM~b~b[z~g~]~{~@~~ysa~D~~k'~CA~~i~~nfN~zlcocxD{{~siO~~:~Qy<~~_G~vhY~lc~|^gXX~r[~Sd&|~kRdyP`[~lQ[<yYe]~xOS~~XpRnfE~@~gbsR~niqaTe~bt:Yen~]nW~~\E~h~nil'~R7y~~ipd_g]~;jQG~[HC;f[^ih]~~\~gX_Bypw:W~i6~|Q~eWP~~h~mi]EykWrg^nH~yh]`bWcpbb@jwpih~p~[~|p^~~]xmh?~~q]BbcVh_F~U~efdn|G{fVi0U~j]P~0ja[V?yaIom~X{KDmS~~]~]~nS`~h~jr=9{hpW~Z7~l%;~Q|jVb`[U:_~nj|F~~o~pJ~`~RwP~\~Y~Rl`ao~oJqj`LurhY~wlj{2\[RU[?iKfb~ncQn|@g~RjUX]~|Hx]~iehey=\fo}ZelfauHK~tinRmZ~k1]Rg~qfgg~\X~TB~~m[~[~Xj%skW~~o{f~5~gW5''EUBJcvHoiEQn~t~ipo~t[~icf\~J~{YdzlX~ip~QW~QJ~}hY~UQM~rZV\~mP=~~pC~~~jtn^nfdmfo~t~oF~x;p~oR~}K~t;G~}NY~Z~]~~jpf.~z~n~in8~~zd]T~l>~n}Vgo~]}P~M~puyjR~gXrny;lt~^zKhP~Jd~nU~a:~Qa~ptptpn~]]~~]o~XK~pjo~o5~~~~o~R~}]o~XP8~~uX~o0~s~~oipL~~gJ~hmW~epa~~=~h?~~~fUdcP5Y}]a~~][~W]aehntn[FxERWi~ec]<~~lM~pA~r)~~>~nP~*~wrAys_~~fo~g[h~oxX~+V\oi\~]PwwbU\D~~S~~m]VEU{pejobnRmL~PR~~hWn@~~~Zj~rYW~gnW~yNun~nW~X~]O~;@~}X~V~yY~E~~W~6~eXr~W\h~t~G~y~OxlUnmfUs~hO~bwg]U~]{.~O~~jDe,~gpitmB~a~mea~n~J~ht}bXho[TU~cN~zhnA~~qhmj~eXan~]~T~hN~lO~nE~~XmnXNzZoU~do~I~hDV~iV~e\~i~t~me\~>~~~rOq~YQ~h~pW~M~}T{Q\~i~T~Sb[~R|nn<~~~]~~ceEPo8~~}iqP9fWgo~UHx~lAxgnIE~~n]gpa~~GgoP~oV~kaDF~~_h~SFWem~T:~{OT8{~mV~gTv|jip~9laH~>~~~sjtM~~\s~qR=~~O4~]1z~~n`~pO~~XhmEe\mZ~@~~xD~~~[[q[~eoqQD~~ob~p~pofm~Xeo}O^\Tlfn~P~i~\z'~}I~K~~p~L~~t~i~6~~~~J~~~O~~hT~kGx?NH~zLA~f;~~o~i~5~~~n~h[~X`~nB~~neUQ~~J~~_=W4~~~~n~t~[~lXzw]o~iptg~tn~XE~eqi~M~@frXhtoa~~meHrnB~~~^>~kD|lkn~^cW8h%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~vo{1RbLAWPoo~ps~K8X6M_?dI~K~~U_?beRzpio^~onImV~Zc`jh~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/624/ccs/rev np:i:7 rq:f:0.997786
  TGGTATCAACGCAGGAGTACGGGGCTTAAATGTCGGGAAATTGGGTTTGCGCCGCCTTCAGGGGCAGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACGAAGTGCGTATAATTGATGAACGAGTCGATGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAGTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTGGTATCTAAAATGGGGTTTGCCGATGCGGTCTTCAAAGTCTAAAATTCTTGAAGTTTGCGTTTGGTCGCAAAAATTATGGATTTAGTCGATTATTGCCTACTAAGCAGCAGTTTAGAAGTTTTTAAGATAGTTACGCGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTTCGTTGATACCACTGCTTCCCGTACTCTGCGTTGATACCACTGCTT
  +
  =Xdfq}yd~^nHO0x~^~~z+~~~yG~h~~~s~{M~~f~~W~1~K@~~qwtM~se~b~fyF~j~uqmws~c<~~~~vDfsM~`~biR~~C~q}qf[~~utT~~Ttk1Bu~K~~~{~W~jx0~jzyd~Y~j[Iu<%~UZdTh~t[~sZ~`~~{X~~z~rH~~uKxs~Z~{~l8N~~r{x~L~`gK~~R~~m~~]~ziq~szq~{~]}y\M~~e~~sO~~~f~}]y~{w~C~{qd~rY~qdM~~~`DgwQ~z~cq{~~vGKSxL~~q~{pvT~@~~{~?~~|~k\xs_u{vSbMomc~}sV~[~~y\`~ZI~~jxtz~aM~Ziz^~~cpH~~~nx<~kJ~y~}lvq]yJnd;~yP~qIB~~z~~s~M~^sfNmmb~cZpdilkgpoT~iqe[~o6K~_\A~~~~~r;~~~cqzhnpdM~h~tpsgH{]nfoi\~ioQ~W~]}]V~pt}/~gcnH~]~tU~JmN)j~@iSGfn^mg6~|W~~po~o[ce\Mj~ib~imDP~gNgXY~itpq?~RzP~ohXYG`B[~eph~lhW~]~h^~tklOPZOpW[~g^ngF{Sppi^}E~\y-BcB|p@}h^ndZgpispqeJ~~X_SfP~h[~hppekiP~}A~gE~`=c}G~~iY~i:~|itpt2~~~nemhKi^a$~ohNl~\WeN~}F~\bk|VHp~~pt~`\UQqpV~h>|boS~~Z=~~shP~gpn~[fG~~mfofKbkm~oT~nKRFx~o~]hm~GCy\mT~]iBiS\U~]nio=~~~f[UPT~~tm_+do~hkRmQ[}\TzV~iv]gc~oh|QYWg~titpif~e?{a)~Vdwo1mhzhee>~~X~^~eYgG~ioO~Q2~~~pb^,ho}PEeoB~~ro~iB~~~|aU6_~~pV~ima~WcG~~h~n=~~~lR_opXyp|T~~~4}s}G}jsgQMV~jmeT~mdiKq~g^}~S{~;~t9~~a~=~~|5~u?~i[`CVsa~`]elqCc?S~W)~pmgHQ~uH~~~p~nfq~qOunemio~n8~~effA~~~cP~~hI~Fe]~tFx'hcB~W~Xi~ph~tito~tW~M~{QwF~mdfn:`l]~t0~|rO~~gfdAl~mQY~orX~]~~sS~~E~~htek~nQV~fQye~fog~M~V~m~]mRXfXfK~[n~rXgT~~{p|,~mc=z]X~o~pi~hH~YQ~~SnZyZ~l}OsodYDO~{<mVY~rT}Rk{E^\1~/~~~wlepWX~TDeHtT~~b~oD~Wre~J~o~^~~g1}oZSasp}GR~Gw~qJzmP~ipirXQ~~iY~mipK}\Q~phE~~~oRn~ic~ij\D~~VP~gkfoGnP:~~cRS~~h_~}P~Wgle/\~]PT(~|~uKDM~l({~uhT~~~Y~~3~~gVO~d.~ZRZP}pzbP~O~~]E~~~p@~o~pi~p_t~io~irSx>V~hjRqnRq~j|.~[~otL~\zz@~N{}bnCx\rkn]M~~~s/~~e:~yeZ~htn`lU}ifP~oJ~y>Zm\H~~~[~A;{in~RG~~hnR9~~T~jhioH~~~g9~apE~zH~~~jtpjt`~sS~i\~]~pto~ip}QT[e:~~}QXwd1~~~~a~j}t~hP~~piph%~~~~~~~~~~~~~~~~~~~~~~~~~~~~og^~n\l;vig>|fbB|2~~ptfB_~R~~c1{o]m\QnhO~PtX|I~~ptiiP~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/657/ccs/fwd np:i:9 rq:f:0.997792
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGGTAACTATCTTAAAAACTTCTAAACTGCTGCTTAGTAGGCAATAATCGACTAAATCCATAATTTTTGCGACCAAACGCAAACTTCAAGAATTTTAGACTTTGAAGACCGCATCGGCAAACCCCATTTTAGATACCACTTTAATTTCCAGTTAATCTACGACGCAAGTCACTTCTTTGTCGTTAAGTTTTATTTAACTGTCGCAAACAACAAAATGGTTTTCTAAATTTACTAAAAACCAGGACGCACCTAACTTTCTAAACAAGCACAAGTTTAGCTTCTTCGTAAACGTCACCGCGAACTTTGACGCAAGAATTTTCCATGACCATTTCTGGTTGGTTAGCCGAATTTGGCAGTTCATGTTTTTCCACATAGCCATTGACTCCCACGAATAGGTCTCTTTCTTCTTGTTCCATGCGAATGTAAACGATTAGGCGCGCGATGCCAATTACTTAACTGCGTTCACAAATTTATGGTGAGTTGATTGCTCTTTCCCCATAGTCATCGCCAATTTCCATTACATTGTTACCAACAATTAGGCAGGCTAATAAAACTCAAAGTTCGTGTCATATGTGTAAATTTACGTTTACCGCATATACAATGACGAAATGGTAAATTAAATTTAAATTTCTTTGTGAACGCAATCTACTATACCTAAATATGTGACGTTTTGTTAAACGAATGCCGTTTCGCTTCTTTTTCTTATTTGCACTATTACTTTTTCAAGCGGCACTACCTAACTCTCTTGTTGAACAACTTCGACTTCGACTCGTTCATCAATTATACGCACTTCATTCGTCTTCGACTTTCTCAAAGATCAAATGGATTTAGTCGTGTTAGAAACTCACGTTTGGTTTCTTCAAAGAAGTACCTATAGTTATTTTTGCAATTGATATTTCTTCTTTTTGTCCAAGACTGAGGCGACGCACGTTGACTAGGCGTCAGAAAGGTGGGCCAAGACCCGAAGTTCTGAGCGATGCCGTAGCCGTAGTTGGGCAAACGACTGTCGTTTAGGGTCCGCGGCAGGCGAGCGTAGTGGAGGCCATACAACTCGTTTCTGTCGCATCCATTTTTTGCGTATGAAGGCAGCACATACCCAATTTCCAACGATTTACTGATATTTAAATAGCCTTTGTAAGCGTTTACGCTTTTTGCTTAAATAATTACGTCATTTGTTGCCACTTGGCGTTCTTTCTGTTTTACTTAACATGCCACTGTACTAATTGGTTGATAAACTTCTTTGATTTAATGTTTCCGGTGATTTCGACAAAAGCGACCACAAGACCGACCATTCATGTTTCATAAGTAGCTCACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  y~nMmxrI~~i~_i~by^Yx~ysG_&~|{~~~~~~~~~~~~~yjdiuz~~~~~ykb~~7~Ik}~Om~>~~|~_x~`rMzv^~yb~{ah~~xrU`~HUm|RivJvk_~M~~ZJ~{~W|%~~~~N_tiH~G~~ay]&~~L[~LZu[c~F~~~mwULY~~_W~_l;CGVm~``~aP~q1~~~~S~~z~y~~lMnB\K~|Z~d~w?~~yy~Y~iC{\D`hOcNl~y~M`M]~\Wj~u~;ac~j~e4~~~~`~~M~M{m|CnER}s^k~`L~~~~J~I~~qLnS~~Xy~jZ~.~}hKH~fc~l_x_nC~~k}XY~x\~O~~[k~aCkVF~rW~~e`9Rs_s~Mx~*~UMz~W~H~NLoHz`Z~~b~^v`\~wX~E~~{K~g~wmH~lI|{b~a~w~d~]smxI~w]~B~q>~]nhY~]fZ_/s~~F9~~WxkuzJ~nf~y~^z<~}S]xh|t~`~qa~_Yw~`s~Lorsc~?~~~yayl~~y~Y~~`z~a~?N~MwYdZpn~:A~]~p~ZNS{j~K~cKdR~Jy>G_J?~~Y~a~~x~ae~xj]tx[v`5~X(~~pltmi~-{x:g?~T~X~~@~~]xXZfk~bExf2d0u_Xta~~Qu*u[XC|l~~F~~~L~S_|~yY~agzcxLozWygcRbD~~P~~o^vN~~oO~d]W~{ytQX|~qn\^P~~rQz~N~~v~[~~a~~ObbU~~bc~~wsYQmRfL9utOjlP`iuABq]Ds~~zx{~vYAcFm~~eN~F~~Iuit~zI~uL~~`y\_u]H~~~~^TyuN~~a:z^~wb~[aA~~~~_6~v`b~Pg=R`O~~i~X`_~PY{tc~wC~Yf~`s~by|?exMxyIpX5u~GqRDaid~}rT8x^n`k_LwQj_{~:c~\M}[f~~^~\=~fsu~`_~~ma~~Z~~oz~a{~yy~ib\t~^s7=Hb?~{[~P~wSd|L0~~vJ~w~~I_R}~tx_~m/~~~~w]Y~c~xq~~;~{>^mK7w~x~m|<~a~zj^`w~b~OujX_Im^dx~xnQ~~U~`y~>iu[~~^~~Pzc=~\~c~A~~b4z`_~`~wka^w~~eG~`t~yN~y~~yf~5~~2IN?FaqXuxqJtX~~cGtzx,cQ?ZvYd\~JkV[X[~yp~]~LUmDz`s37TdXAGiY~~[~ni3XF9d)va,v~~~skW[~adVRlY~FaZEOEeob6~YCvT~|K~U~YZbC~{aL~ltlvF~kJrr{aXE~Q~~_~^~b>U9_Mv[pZ9~~~\FYe~Q~~|\ri~lYoh7w[~fZjyD<|uTEJWwYb[sEEQfG\X-~~~xGl~TuEu~pJ~wYq*7]6~TnYoMnAdMRz9v~GnpYT~~SM`~~C~~pQ~~L~Y~koz^~~\`dW,~~~oYnq?q%AOgmfIwnt>~n__VtRWQ~vEu~g~q~xoR9Ja1Oc~p~eZi7j[Ckm~pz~dI~wZcFX~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/657/ccs/rev np:i:9 rq:f:0.997418
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGGTAACTATCTTAAAAACTTCTAAACTGCTGCTTAGTAGGCAATAATCGACTAAATCCATAATTTTTGCGACCAAACGCAAACTTCAAGAATTTTAGACTTTGAAGACCGCATCGGCAAACCCCATTTTAGATACCACTTTAATTTCCAGTTAATCTACGACGCAAGTCACTTCTTTGTCGTTAAGTTTTATTTAACTGTCGCAAACAACAAAATGGTTTTCTAAATTTACTAAAACCAGGACGCACCTAACTTTCTAAACAAGCACAAGTTTAGCTTCTTCGTAAACGTCACCGCGAACTTTGACGCAAGAATTTTCCATGACCATTTCTGGTTGGTTAGCCGAATTTGGCAGTTCATGTTTTTCCACATAGCCATTGACTCCCACGAATAGGTCTCTTTCTTCTTGTTCCATGCGAATGTAAACGATTAGGCGCGCGATGCCAATTACTTAACTGCGTTCACAAATTTATGGTGAGTTGATTGCTCTTTCCCCATAGTCATCGCCAATTTCCATTACATTGTTACCAACAATTAGGCAGGCTAATAAAACTCAAAGTTCGTGTCATATGTGTAAATTTACGTTTACCGCATATACAATGACGAAATGGTAAATTAAATTTAAATTTCTTTGTGAACGCAATCTACTATACCTAAATATGTGACGTTTTGTTAAACGAATGCCGTTTCGCTTCTTTTTCTTATTTGCACTATTACTTTTTCAAGCGGCACTACCTAACTCTCTTGTTGAACAACTTCGACTTCGACTCGTTCATCAATTATACGCACTTCATTCGTCTTCGACTTTCTCAAAGATCAAATGGATTTAGTCGTGTTAGAAACTCACGTTTGGTTTCTTCAAAGAAGTACCTATAGTTATTTTTGCAATTGATATTTCTTCTTTTTGTCCAAGACTGAGGCGACGCACGTTGACTAGGCGTCAGAAAGGTGGGCCAAGACCCGAAGTTCTGAGCGATGCCGTAGCCGTAGTTGGGGCAAACGACTGTCGTTTAGGGTCCGCGGCAGGCGAGCGTAGTGGAGGCCATACAACTCGTTTCTGTCGCATCCATTTTTGCGTATGAAGGCAGCACATACCCCAATTTCCAACGATTTACTGATATTTAAATAGCCTTTGTAAGCGTTTACGCTTTTTGCTTAAATAATTACGTCATTTGTTGCCACTTGGCGTTCTTTCTGTTTTACTTAACATGCCACTGTACTAATTGGTTGATAAACTTCTTTGATTTAATGTTTCCGGTGATTTCGACAAAAGCGACCACAAGACCGACCATTCATGTTTCATAAGTAGCTCACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  y~`vy_k?~~~}K^~v^tkUWYv~x&~~~~~~~{z~~~|ytmjga]`hy~zx~~o=9~~R~x~w~x7s(w~~okT{PR+~~sSNOg>cQw~N~t3~u;wdi{Zubvv@T~y~c~l1VvD~~~~`yauN~X~~c_pIu~d\~hj~`v~+Hlzm_~q^z~`m~O~T|MV~~S,~wY~~>~~~fEut~l_qUXM~sw]~~a~0~}b~v^S~b~lvD~xO~x`wauHk9f^T~sW~~R~wMi~t~bB~~~~_~~v~v|_~xLPG~~x\~dO~~~~M~2~uqkfX_~]~~{aj+zu~_~~?~~u`^s`~~d~x[~{qmO~~wS~]w~xh~M]~~~]xi~yZ~bIc;~~wM~N~\pZmWc~vReaQ~ZL^`pIM~G~x~L~^eLtQ~sC~~sY-l:c>~Rvu:Wi`u~,t60~Lu^l~y~{KBz~~za~~sp~oIO~~e~N~x~L~~~y`w~~~N~c\\qFy~ub~b^~bZ~`~~@^s8q~e^g:~jc`si~~J~d^e`]6~CKb~d~Z~~wf~c~wg5u]l~x~=^~yBVh~v9a{^~^NtLn?C:mSsP~q0~~es|~b~d~pwML~a~Z~~]~[S~[a~e~K]~~>nE~ae~TnxO~x~Epph[~jP~~~tS^Y{~OZfc[=\c_pe~i^|bndv~Q~~{sZ=mhjbyOmsZ~f~yt~n^vy`i~~}A~}Y~~]~d~~Q~~e~[^~~y\~}In[tvN]xw~~zm~\>~V~d~~gx~\yt<eDlpY9tvmVar_~~w;w~~aP~`9~~y`eW~d9iim~yf~tW~}MKeZk~Y~~yDw~~~ct~Kr@~s~xWrL~ud~sdszdQ~[U~^v~xM~rXb^]q^S~wO~{~yKU~q\xLKuU~tz~yauqwL~rY[~uY{tk~wKwvO~~debf~r^m~w2knUI~tC~~iFOHL`IW~~^F~~cg\nx`[~|N~`~~yn~z^~~_]iMip;~P~}rZN{xE~xft^yr~Ky_~~~I~]rTt_=~~ca[VX~s~:~yn]~O~w_hxMxvo]X~_~ymu>~yKyn}WOVmE}d7~P<~]~[WJd~[o~[b~XtY~XZEfITN~WMhZI{Q\~[c~&~zmlE~jYFfnY8mXE9~~a2^>[DyVS4ul~H~[Z~4oXZ~Zu1\~:~H~u`g[W~i\kP/ayndYxp[k~b\~}0~~~yAZXqczYJ~I~p~Gn~Zlvj$~ifj~G~zJ~fnpW4Ay~~qeL~UiE~~W~~d~G[~Q}UTnE~/mWI~~~oZX1iPRaUWJnN~~yjne~~q[uq~B~zGTuZY~hYTf,shQ<q^6I8gMF9irvYE]n6~nkbG?~cS6:ZjmsegUR0}QjO6E\~~X'vcH~~DzHu~dsUA<5JWf%DHH~Hw~nYgZ*}R)XoM|\}|eQkD~]~[~K~h^wk~lXU~~Zg`o~\clZow[k+~~LH^kowobVmDCuGkJy]~jlyZqW~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/692/ccs/fwd np:i:7 rq:f:0.994784
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGAGGCTTATCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCAACACATCACTGAGAAGTTATGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATACAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACAGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  axePjYg@reRWNNkNeMjcj_Z\=&@fihJgEoOVtih@~aHagcgdfNWt:~+or<uutiM=liNp`]XuOCb;]FnMhZ1idgcQRQGvvhbQIb^:9eW?W,Z]lm`ZgbfKRaU^dNUuhQVQQXFme<b@dTdLiLvv`RxIvU@Z'drn\[QVMQe)LLI9a:`On<a:O[cUdYuUpGYgLRJfELZM0rujUW(m8_K^Mc=ISJ]VX:9PQM)_Q;fcAsTT_b@ea;USmhcGsSwd*Vk;ghQthdhjSwOc@quhB]GIM^]OTpA5x_MidIwj4mHkL`@]]d@tdPrJte9ceWM;iKR(WqWgee0beQd@~haZMDt^-WD:csd@niUuefdi@~VthDdBupd4tY?hElScTR9PKmdNSdAsTcJrOOhfh=tJb9fd.~sl\RKYsOc`PNedb.eMMPsgJsh8~dJkPf)urE?Zb;TMBT&b.,mssrP]aLNb:;cH8Ft9NHE>O``hhdhdfS7xdObPZdOgUcgMGjIfOcdhQtWtAuF`bNJ-eQtighdU;uuutg8`WcTciNhfa=QiChthIo>LWMUnjeihSzhPTJTUJ<Nb-mfN8c]hW^d1]ZllXANNjfUcS<f_TBso<tvdOPg5~qQRMQbGscKuuTwhVv_`^WwQcc,_]P]MSDtT@qPdgjcUNcYwTwfcENJ_7gb+m=>XLRhNLI=LePbhaLPt;bcPt@vlDxpQ+RLm0ohKHmTSjgNMtuWNjdeLhKc8JidS;^Z_cFohefLRdYn;{PaI>CdW?QcV8@csOgbb0rVJaNFegcR=db8dIacKnTf(oN(gdBuU]\Q::]abbhMTmOeMgQ^HvveC@:R5ifhF|dYPHbddScfCNTq^&b?-jphb;9AP.?_dcUNcWuOcIsM9gUf_GsdVt@~hJwa9ffOItS<pSQbHuhidYi<jF<qdS<cJttLaiPt^?dQ8_dJQNh^UOd@qfMfNTwXm;b:ehdPh[hPZSTpNJs7sjnN@CHn/~chElHNNf\dAlgPi:R:ttitg`=ZjL`WdMdYh5ycQj/E<=]Vk(pG:ntAb1igdJu_;R9S8kVghda,KbtMLbtSwUKQO7Sg_SXZ9DX7]fHle@~dWuh;kSsUNpFi)dQvUPVaNVtFm9vmdMdVude>GNhM>OPiYtXb^WnNbTVj/nIHi:HP,p~cBjMaMX`LReiQ$QSwebcCpJ=ptLUYxeOdIuQtgAlQ7rG(rss0`WQM[;^e?R:TuhNcF^ULSE&f\^E%DEhHgdg<mQn7yUABr/ridVud:wwcQSzSeb5COhdOO`eQV`]3ssaL7q_OCoOU0U-P0MrVbSJ4rTd5~~fTNdefMO7<?QSiUb`_OId;zfYscWgPdgMdcaVrRKVHaVPbBK`Crb>N2XchOhcFOdg^WdEoG]UsTJ2jl$j_X^ipqrrrrrrrrrrrqld]YWUX[\_gorrqpoa<<Kd$_YeprrrrrrrrrrrrrrrrrrrrrrqifSP^LF(JecMNXvdWcY?lSNhdNhv
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/692/ccs/rev np:i:7 rq:f:0.995648
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGAGGCTTATCCGCGAGTGTCAACCGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACAGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGTT
  +
  )\FGI+K&aW_^\OjYD]^HKH`_Z.eQDEBA;Z>H[__UoMPKjLf;ScHuRb$bAS_qgdMvf;tLK@rNFsSvUsdhidhOfOdTd9~~fDL;Qad9ttdd5vwwraNeMeQ<yhMhdYvdTEd<d@~jcRaNefcB@htc>bCgNN]9uvupS6_]9aa4KINHIk8fcgdToLiKJo<]GrgdhcUc5NiFiuiVu7gsVvQcdiicgacJVLNlKf<eeKhJOtd;Hf;kjdhYwaKVg;ucO6tbgjA~eLiN<|/E+nmf3pUJWIDc;~M(phdgM=rtSwFYcMKtqM>iI0a=otbNcUb6qM?bFbNX=QcKd?hTiiNjb5t[,qrBnZgH|gGlLSLDJlIgg=~9oaJNbbaeXoTLAeeh?ttdFKCs^L>X=YX4YPVGc<cL9U]qvgeVuONSgdiNjAplA<~hVu_FX^:Q@U.tttRvjdhidiSu8uuuudh>RCVXb;cg+VSfdSLdjNiWNYJjh@zeb]XLf-He=M\4qLPWdIaAsTqQgchLQK'b>fPeSCL)jz~eQthMgMCcgQbeh`7Wh`TpdTv]<eidhfC~gMgedQ^X`kOihhTvPidOf*|olxygcAujf<id[6Q6t]>_hQ`VRJvwgR=gMFrLBaj@odER=S?UpgMcKSLHscUWqRPtULhiNfdMVtAfA?a\[ZbU-Q<c8tcUfbf_U^gPdieZ=w)RM)PKto.~xdSvS^7MgO=ts@}hc4sseac@f\NdhNPfMg`:bTNVtgQSchOVtDuWvOebVfdgfdKMvqMhhMW`\PhcbMLQEvcaSNNe0kda/|bTvg3bRiMUc=vtnP[`EsNQbe`e3FCUQc\\BrXW-D@eOUieMTLTfd@~jHvvh2~~}eMhcUcbLKGbcMI[OKGsc.~~w[Od:FZQth>wvefdPUuSBsWU>:VH-9c^DsOXtNbOq@WXMFh8xhdNUcMU`NbfPcdhRvdMP`;gXncRbcbAdT>R5fh3zbXm.kXkcgCrRgKS;pcVMcGh?]ecTSh)~~~oiK8kVVVN>`?Lh3~~Iod__QtOxUxd0~dVs7fKH$lbhc@ExWviMUcImYKMtn,kefjcK:_KTKihXw4x_<p^OT)DogOb9jf8C/XM_:hPG2o`Bf,nD_uuaPD^:MfdNScOfW_YwWujWteLQ@eQtMGs_FsGvuN4q7GSJhcOWTXp?{cP:7kb3dPbf>`IOLXs-ZWVtODtq:^na4x~hddH=NYed?uedc[=Qcic'd\_r5uqgM>JfQtWuG}icG_<uiKWlI5llhL;bcHdP>NR;TV8_QIC:;N^qdL4Mb?xaYSsGoGophNic0u)I5nsfbQh<hc@ZBOhAeRLjhNehTwh.E=b_^;gdNhNDhcQfc=U^OfWgSn>P_St;fejNhdMUfMh;xdhYwhd@tc$ssssssqmnqsssssssssssssssssssssssssfdfM$prsssrpmnqrssssssssssqnnqrsqgLKSecjcWLaKUmOe<V.nfOe83-
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/705/ccs/fwd np:i:9 rq:f:0.997022
  AAGCAGTGGTATCAACGCAGAGTACGGGGCTTAAATGTCGGGAAATTGGGTTTGCGCCGCCTTCAGGGGCAGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGCTTCGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAGTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTGGTATCTAAAATGGGGTTTGCCGATGCGGTCTTCAAAGTCTAAAATTCTTGAAGTTTGCGTTTGGTCGCAAAAATTATGGATTTAGTCGATTATTGCCTACTAAGCAGCAGTTTAGAAGTTTTAAGATAGTTACGCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  v~|KTskS~~y~`OvMPLi}h{}{d4~~m^U~B~~~}maX~~<~~w~Z~h0~~cc{@~}P~|~]UE~~~bf{c~~~'~~~PN~~bQ~i~h~h~mL~i~a~g~sJxP~xUxA~~^~J~~~OuB~~\(n~~Nd~7~yL~N~9FryQ|X~{z~xm{cyy_Xz~\gtz~krvbk~^s_~bj*~~O_g~W~zvCzmNz~~~~~~c~~~|bimb~igL}I~uJ~h}2~~{T~_bc~dWyjm]|N~y|~zcIl~~b~~b~~~la~\|y_bz~\N~|[}d}Q|~A~|afO~fOs~~T~Tp\yx}~~~7~zyK~Y~nbif~OY~~~b}aeMV|{~PC{~b}.~~}ued~~g~cu~y~i~M\~~M~~f~c}c~~b~~~|M|hk~akzJ~~aYd~~~~SqL~~~`~~~~i~~}@z~wnCgU~~d_~a~~~~P~b~~e~~~~~9|~~=~f]\~2~~d~ez]{xz~d~cd~O~~f~y~j_?~~~h{QL~_jMwgO~~;h~d~hx~gd~cq~|b~IeeeuQN~\uc~X~d~YkQ{~Lp~~V~n[cs~ch~cd{|f~e~ib~~~PV}kd\P~Um~d~~yd~sv~N~`\`~~~~aywhS|yW~~Y~l^xI;F~|[~~O~usb|x{v~kC~~hS~c~kwN~fP~~k~^~8~~}RWS~~bj~[~~ke~~g~cy}~{h~kS~c~,~~{a~hw~]n&in\'~d~~f;Oj~~wjyzcj~~~F~~~~~~~~c~~d~~{{hM~tOw~hW~~cy~=i~~R~~~~c~~;i`Ny~~yvb~VJLx`kN~Rdui~g`gx~~X~~~Qh~~J~]Lqx~O|I~h~a~i~~r~~p~^(4J~fgg}~~~kO~xi~~[,~pFs~_A~~~~k~G~{ru~]\C~~t[~u;o~~~u(ja_G^P~k\b~\epv\sM~`NZX3i{m]v~[bWjurU~gtQ~st~Orz^tsy~c^bb~[rVC~~vL~~c~~E~~R~~?~fz~q;~Hg~~\v~Oud~u~Hmmiu\_~~Gn[Fu~K~~\~~]ZL[t~noucP\Tq<NV[~~strE~~~qa~`qH~~vL~~bwt~_f~c~~\~HQ~~uya~~Ms'c~^~']\uv~\qIio~%gwWW~~tw_]0~~ZLmK~YsHV&nEnjFj~^psT~\v\vvh~^~]~K~ogN~\pmQ_^c\rL~~B~s\vR~~o&pt~Gs\tv<iQe0PatU~iQOlsamnK~~ua~]tuI~~ws~FP~s_~[yvw_~_o-hn~~X^yvQ~[~v=~1xn`~J8mZ~MjB~C~5tusT~~rL~p]tp\~L~~~_j\f~uZ_~ZE~~\c~X[U<~~bc_sa~pv_qc~v`~w\~Sy~[a~ptt[h~ud~~_oGjThf~w8~~`Ls[6~~a~^~~~^u~W~~T~~om.~~~D~uQm~~uz~uX~~pGtu\ubd~T~~pA~ycGu~NnGtlJ%sxfB~u~wv^e~u\w~]v~vvvz~]z5~6lS~yJiU~~v~a~s`~^lL~~~~?~~~R~~aD~vv~v[M~~]Bx[)kot~_~G~l~]m\a{md~uY~~IVEX~oQ~~DoHEcu~~fu`~_~pS~~usV8tvS|bv~uI~~v\~b~u]]\Yau[~~atR~^+~~~V~wqsas^sNG9H%riemt{{tqrv|~~~~~~|tibcjoz~~~}v~v]~X~b\tr~va~u9~cX~_HI~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/705/ccs/rev np:i:9 rq:f:0.997034
  AAGCAGTGGTATCAACGCAGAGTACGGGGCTTAAATGTCGGGAAATTGGGTTTGCGCCGCCTTCAGGGGCAGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAGTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTGGTATCTAAAATGGGGTTTGCCGATGCGGTCTTCAAAGTCTAAAATTCTTGAAGTTTGCGTTTGGTCGCAAAAATTATGGATTTAGTCGATTATTGCCTACTAAGCAGCAGTTTAGAAGTTTTTAAGATAGTTACGCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  X~HL~<[:vd}wS[Y<Ze~_~N{~i3cgviZ~K~~u;hiD~~`t~gv3~w8v~_g`g~Oh~k~ey.^$SS~QhOb=-_df}b(zgn~RpMk%|vg~cxvwO~y`aT~~_~~vd~~F~~Wefh~mz8~~si\~g~dz}coYx~_~c~~b`vcX~C~~~U~~|~^U|`t6KMkU~~~bk\~~O|}~:~RJY~~p~~^y}9~~l`~a~`hi~^kfNP~~L~~aFz~~yuT]~~~q~c~{Rf~~GTa~M~~{qOxi~~x~e:dQ~hM~gu[~~b~e]d`~f~~c`W~~g|]]z}|fi~wa}~`K~g~i~l~~}^Ix(SAw{|;cvfWzb~~8~B{aI~~~]Q@~b'~b~kWr\a|c~\,~zrzg`M|vMT~M~S~N~\j~bN~{byWa~ad~LRwbZpJeP[EzsRBk{~mY\Q~~~ia}g~ZOY~~~gxc>L~uqGFLY|RkBdGXT~zQ~|f~L~bg~>~[~sQ~~BM{}~P~\PK|Xhbi~{N~~|~~hf~b}^~~dd~N<b]~~Xg^Q~~~ih~~=~Y~hcf~h~QS~\U|~iQM~||b{~yh|Uy~:\o~~X\ca]v[yQYYP>~u~{&~~~~fe~PVc?jbjc{}g~A~~BNhHb~b1~^hW~~zW~~k~dX~~co~K~~`e~LV~vQxd`B~~~e~ia|y^d4~~~:EfzziOW}zD~~}ctb2A~|}~~aS}cy~_~gC~{ij~~he~~|aaxawctaaY~~{J{X~\Lorzb{~U`]r~N~gJS~q?~zo=~}~U~Ku=~mxaY$~~\zzOk~~vaa?~an~LhH^JU~cczR~[thO0ZU_|]yO`e~b~~cl~Ubv:Z~{G~Wsa^v_t^X}~N~t~OSNe~bkZz?R~~~~ayr~~~YY`iI~~eVu_Ht|jg_IxKN>l~~~Q~~~]~}aZ~~S~rBvt~ydwwg|~f~M~~~CX=|U~:b~_wV~^bCc~~~hb~~bYruA~~F~nK~~x~Lk}~W~~W~~<^~~~aZMx~~~~aeC~~2~aSQ}8~iU~~uh~~~{~l_~e~y_~~hF}{_~c?~~~~G~~Ec~rM@z`nKQoaEs?`Dc~~|~x_{~~nC~_~~a~F~HRKhKj[Crk&~~ZPM~Z~WzR~bb7~mWc~`~~lF~y9`N>EMFmaPa~O:~i~bjm~FuJ~S~iUa~b}bZ~}u~iv_Y}~~gzd~e`~~yDuZ~|r~bX~[[~~c~b~C~l~V|vJu'~~~Xk}gr}H~~m~c\lOz8~~~nRdFMo~}laT~^rtX~R:~f|~~<~w~`~~b[~lsS~tz~5?~E~~sR\wDS/I'R1V~~YQ~bZn:~W]~wa=~~zja~~ek~P}~Z~~z@ycj`~S~bP~~~b\~~bX~~@~ZP]M(c[~x*~H~~~vKeR~~?}}~OF~~~V~~T~~~``~9?~~b~Q~~~ch~N~~i-~~pgZ~j~ga~jE|d^Y~L`F~ge~O}b{Q_T2CXf~c~h}N~ZyseyJnlVfI~j~}~jI~~~{8~~nH~m_W~c~l_d1tjhTxQp~~]{~j_~~~j~hL~b~~cE~~\~`?~mR~~|[dH~~~zY~~gK~~N{~~d~~b~]|~f~M8~{~~~T~_~~bp~N>_x~bl~Q<~~~~p~c~l~dN~~~c~%~~~~~~~~~~~~~~~~~}~~~~~{uturpqsvYTWmaunVa}bOO(~i~f~{rr`9\~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/734/ccs/fwd np:i:12 rq:f:0.998868
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAGTAAGACTGTATCGGAGACGACTTTTTAATAGTAGTAATTCTCGGTACAACTAAACCAGTAATTTCAGACACTGAAATAGAGGACTTCGTTAGGTACGAAGCAAGTTAACTAAATGACAATTAAATTGAGGGTAAATATCACAAAGAAATCATGGAAGATTTCGACCGAATACAGGAAAATTTAGATTAAAGGTTTGTCGTCGTTGAAATAAGAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGAACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAGTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ~~|h~~~K~~p~]B~ekU~z~~~b\=~~~~gS~\yO~]a~p9IVW~~z~~k~~_h~<mX~~z~~BdI~G~zy^~z~e~~Rv~~~~~ek~~gF~~~~~o{_~~[~~~j|~~~Y~{~z~V}~~c~~~~L~cXdz~h~j~~~j~~S~ho~bCfT~i~~Hu~@~~~gq~p~~~7~hdb~]~~~N~~_~~f~a~b~~~VvV~~C~~T~~DW~tp~X~y~~M~VX~k~[~~v\~m~~W~~?i~R\~~j~~~TU~~~jx~~V]v~|@~~~n~NncT~Xf~~~~~X~~gz~z\~~u~z0bz~Vd~u~j~~i~TN~~~~~P~W~~~9\/{{n~|~~W~~~~n~~~|~t~MkT~i~~h~k^~ac~{~x~~R~~fQh@h~tq~}w|~vc~~~~~fQ~ojh~~5~~~~~{l~~~~~|b^~~~U~~S~~~~Y~~~i~~~~~_dm`~~gz~c3~~~~d~~~~~~nmb~~~D~d2~~a\gtI~W~~K~\q_j~s~~g~}~^~X~yR~~~~Q~`~~Yk~e~~~~a~~i]]P~~B~~~~~n~c~,~~~~~gj~~~b~~f~~~`~~~m~~~~~^zK_~~|\~~ZIl~`~t~o~S~~i~~R~~R~~~Q~btY~~~Z~~~~~~~n~~^~^~~.~]M~g|}~fH~{~R~d_~~l~~R~k~wfu~Nw}~Cv[i~l~UO~~~[m~O~g~|WQ~~z^~~5~R_~a{r~~>A~~~XXedk~~X~~x~~Q~~e~~x~e~`~O~~n~~ff~X~~~~~yxKljXd~~7~~TU~VonQ~jbY~Q~~~~n6vgrS|z~En~~~{z@~~~~~~~~@~~~P~~e|^~}~~h~~CuWd~~ym}~|x~e~~~~U~cx~~~um~~yP~~~h~~a~iZ^~~g{~T~btA~s~j~~n~~~~~~~jiaiz~~m~~~k~~~d~h~~L6RNTn+ioh~~k~]~~~cq~~i~fpaL~X~lX~~i~~F~~~|{~X~~~z~V~~L~~~~~d~~~w~j~~~wyf~F~~~~k~~sA~k~[%FJ~ku~^LbH~b~F~W~Vwk~&_^~u~}7~~s~W~~~|~ak~~_~~fT~~p~~o~F_~~~~l~m~~~k~v~~R~jg~Z~~i~~~~~lk~~r~~x~`~~~s~}{~~~n~~X~~}~<~~~~~~W~~A~~~~4~~~Q~x:~~~n{||a~~~b~~V~~`~Zxg~Nx~|O~ij~Jg}Fh~~~r~~~~~o~~kZ~~m~~~~~~~s~e~|~Y~~~vk~~~~D'ubUgpkku~~~|xqpl_PJPenp~~~~~~x~~f~:|~bi}~}~~~:~v`~}Z~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/734/ccs/rev np:i:13 rq:f:0.997666
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAGTAAGACTGTATCGGAGACGACTTTTTAATAGTAGTAATTCTCGGTACAACTAAACCAGTAATTTCAGACACTGAAATAGAGGACTTCGTTAGGTACGAAGCAAGTTAACTAAATGACAATTAAATTGAGGGTAAATATCACAAAGAAATCATGGAAGATTTCGACCGAATACAGGAAAATTTAGATTAAAGGTTTGTCGTCGTTGAAATAAGAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTGTGGTAACAATGTAATGGAAATTGGCGATGACTATGGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAGTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ~~Z~~h~;~o~~~y~}gh~W~_~~})~UVuX~~~hE~~B~~~}~z~l]~c~~d[qj~~k~~etkrkn~~tk~Q~AY^Y~~m~air3~rp~FJae~j~~~u~ji~hr{G~ed~h~~l]~h~~M~ju~P~~~~o~SdNI_Qh`oY5~R~~q[rLq{gs~g?r~Hwl~~G~E6~~T~~6~~Of~W]~~jr||*~~~i~yG~[bi;~~~eS~~~~nk~~.~~~uhuD~~ml~}k~~k~~u~~Q~~~s~~ck~~~Om~Vg~~}d^~~|WpY~`~~~hl~~3PO~~k~rSk~nR~~{9E3UY~=[>qnzN\,5JiUauW[~}~~ze~\j~P~S|g~ygs~ZoPd~A}~~QxZ~~d~~UmuP~~W}~Ni~~~~uz~B~_~cy~wP~~~YHSy}Txi~c?~~~~d}x~~~Ia)hX~~~ktYin~da~~X~~~&[~~}N~~a~~g~z6~txx~~Z~`:cCs~~M~~~9%wjI~x~zXS~~c~~`t~~Pmbl~P~~~~_E@~~~~bxM~~yI~~cm~~>s[~mey~Ndr~YL~jux~g~~yVznn~\~]~~j~R~;~^wJ~~~~~^~cN~~c=~~~{ypB~~~f~Z~~{RyK}2Dh~~~~A~B~~{Y~~~Rqy~m~~S~T~~Pa~>~~g\~\J~~zm~Rh~Jm~X~Ih~~f;~z~[~h[e~~~~~L~~~~?~~~~xiv^~~uPe.~n~b~~dm7~LgZb~~~~W~~VF{aE~~I~~Y~~b~It|rP~~M~~cD}~~Qs=w~|zb]\I~rV~~tc~y~~]~~v~~vx~~qg~~~|er~~R~~S~A=jik~k~~Rq~fFH~iv~GUAK%@=TWr~~u~~g~~~~C~l~~a~M~MOenT~~~~~%~~sW`f~V~Uh~~~~y~~~~~e~~KM~~R~~Z~L_~qR~~da~~~f~Z~_{D~v~~yPwerdC~}Q~s~eW~~~r~^~~g~~o/~x~|~~f~~CR~ya~4~x~~~[~~e~E~~~d~h~~~V~~~xRQ~1~Sv~~~{~~h_~~~Eg~f~~x~yD~~mn~u~z~P~~VS~j}O~~~~s>~\~~~^~QT~B|gt{u~~[W~~`8)~nc~~d]~~~~\sq[`~`hih~~^c~e~MRk~EZ~~~eu~~ip~~Cpv\|fsgk~Q~6~~~~W{]~~D~opT0~~~W~~[~~~iW~el~~Tt_~~~cm~Z~~~@~~~~h~s~x^~j7~obs~d~b~~p~Viercc~~<R`~R~n~C~_|~R~Z~~H~d&~~rkv~~~~~~~~~~~~~~~~~~~~~~~~]X_~~~~qRlgY~a~~~Z~~~~Voy~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/820/ccs/fwd np:i:10 rq:f:0.999584
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGAGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACCAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ~~~kc~~U~~~~Y\~fzHv~~~~dmT~~~~~~x~ig~~~S~~gj~~~~~]@eH~^~~G~~~eiS~~v~y~P~G~~C~s~mv~]~~~~~~~k~~x~~P~~jb~~e~-~~~~~~~~~m~~~~wYt~~`}~~~}~~k~]~~~]ue~~~}~w~~~~S~~~~~a~^p~mj~n~~B~f~~pnl~~~v~~z~g~~Y~\~m~~~-~~~~~J~~t~m~]~~`~`~~v{o~|~e~~~~~T~~u~~n~~V~h~e~I~e~~][~K{~y~~zzrf~~~h~~{{~~~v|~[y~~`~~m~~6~~F~^k6~d~~{Ottz~Y~~h~^~Es~ghd~~~}o~s~~~~3~~~~e[~~L~~V~~~V~~c~~`~|N~z~qg~?~~sD~~[~~~y~~ekzG~~Sk{O~~~~~~v_~~Z~~~v^~;~~~~~jb~Wh~~k~|~8~~~y~~R~~I~~k~~~P~~~Z~~fo~n~3~3u`~~kq~~b~~m~lz|~~vZ~~j~~`~~~~~~O~~C~m~yn~y~~[vdQ~Q~~zRyd~Z~y~~~~P~z~~~~~~>~~~~~U~~~s~~Z~~~S~~J~~~X~^[~o~~~~~~y~~~~n~~m~b~R~~~U~Z~s~~S~~~~~~Y{~~~~~m~~ya~~e~~~Y~dK~~~y~~~q~~T~~z~~_~~~~q~~~~k~~r|Gt~~xP~^x~~~~n~S~~~~sV~k~m~~a~lh~l~~\~n~mzpx~~Ux~V~~}~E~~m~~~2~~O~~XF~~|~~ke~~MTw~vYnk~~lx~wK~a~~g~~~~m|~n~G~]~j~f~{n~x~fR~~~u~~~~l~~k~~~~W~~k~d~~m~~wk~~X~~{~N~~~jP~~~~u@cuB~X~~~n~~~ho~wk~~~z~~~~~~~~~~~;l|~~:~~~U~~~~r~m~ky~x~~?y^yX~k~YL~~~~p~e~~4~~e~~m~~~~~~y~~tr?~M~~p~c~[r~~~I~c~~m~y}~~[~~m~yV~h~~~m~O~xk~kN~b~lYh~^~i^}~{~vz~l~~I~~~~Y~~~S~~~@jT~~~~v|~~h~O~8~~~~~yE~~[x~~m~~~[~~~~p~sD~~~f~mO~~c~h~{}?~~l~Z~R~p~~~~\c~~~e~~{~~n~b~~~~~~r~`~8~~W~~S~~w~~6~`~~y~m~~~n~y~n~Ve~x~M~~~m~~~~~se~d[~~j~x~p~~r~n~~~~Z~~~~l~~K~~~}~k~~v{Z~~~r~z~~~~~~ms~~lw|~|l~U~w~~^~~L~~e~~~k~~~m~r~`~ym{~{o~c~fl~l@~~~hH~~xg~~~I~{~B~~j~~l~~~l~~f~~~~{~~~dl{~a~~u~~r~]~O~~~j~~~~|~mxX~~~H~~~~glh~~~K~~~~F~~~f~l~W~~~~~~z~c~E~~f~~~~p~~X~~~~~~jKe~xY~~Xwz~f_~T~~yn~~tX~~Y~~q~d~~~qI}&felx~~~~~~dSS^r~~~~~~~~~~|~~~~g~d~~e~~~~~~~;H5a~ba~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/820/ccs/rev np:i:10 rq:f:0.999655
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGAGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACCAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ~~o~~r~U~|~{~~~~q~~n~[~~~5~~~~m~[~~w~pNh~jnj~o~qv~Z~r~>~~^~~~~~v~~Q~~E|~~i~~~o~~~x~~j~l~~~O~~~~j;~~~o~~y~@~~~~~p~K~~]~~n~~k~y~:rM]W~~~~nnx~~~\~~~J~~~o~hT~~s~ry~~~~~~~~~H~~KrS~~m~n~lU~R~U~~~~~{~~kuL~~~f~q~~z~~~~~Q~|~~m~n~~p~~~~o~\~~g~o~Z~~~~w~~n~~I~x~j~~~~P~~f~~F~~m]~~~A|uKd\v~Q~~D~~~~Gz~~~~~~~Zs~~p`~~;aR~~~o~~~Y~~~kw~~~~y~l~kl~~~7t~J~~O~~e~~zy~iv~osY~}~n~~Z~9{z~~~~cgu~~mPy~~N~~m~bs~pZX|QC~g~~~o~E~l=~~~~~~D~~\~~~tJtu~~~\~|~~{r~~w~m~a~~~y~|~~~~~~~K~~~~}~q~~{~~F~~N~z~~~p~xo~cWz\~Qj~~~t~a~~~~nv~x~ly~~o~L~~~~~~~p~k~~K~~u~Sv4~~~~~~~\~ng~~d~~{~?~~zl~~t~~u~~s~eC~b4~~~~~~~~}~~~x~mz~m~1~~~~~~~[~~~\~~zL}2~~b~~w~d~T~~u~d~@~~og~z:~`~~q~G~~~o{~~ml~~~w~~|~~]~~no~Qk~8~}~~u~{~~[y~~o~~|~~e~ri~~~|~~H~p~~N~Y~~M~~~p~Z~Z~~~_~~8~~~W~~~~wE~l~~zp~~k~~j~~p~~~~a~{op~~~~~yu~~~~~~w~v~~[~~`m~~n~~|~o~p~~~~~p~F~w~H~~~~~]~~~o~~H~~{^~~w~~~~uo~B~~z~~~~]~x~V~~~mX~~]~_|~~]~|n~~~A~~}Nit~~~~q~o{~p~~~`k~~?~~~~~~pZ~~~yF~~~~~rh~~T~~~ml~~~b~~~~~~~p~Z~b~~~c}T~~~]|~p~~n~~ji~|{~q~~~\~o~~~~z~p~}q~P~~E~~E~/~~~~~~w~~~nem~~}l~ovV~y~~gv7~~~~~cu~~~~vp~~n~P~~R~~~~|~e~k~~=~~~~Z~~]r~~~~~~{~~~zn~~^~~ov~~\~~~~~mH~r~o~~~~\~~x~~~~j~~d{~G~~>~=mi~\~~Z|~~Ke>~[~~~~nn~Yc~~o~~mz~~b~~~~f~~q~f|l~lo~~s~r~~ok~~o~l`~u~~z~[~~{~w~~B~~~~K~p~p~~M~un~qj~kO~~tH~~x~~~p~{~pL~~ju~{~~~kC~~~~q~~~o~n~~~h~~~~~v~O~~po~mR~~~~W~~Z~~W~{h~~k~~\~mC~~~~`~n~G~~~k~r~n~~~o~tP~y~r~~~~~~\~us~~|~a~~p~~p~~z~^~~o~KxCrk_~c^~s~~~Wvhl~~~orUd~n~n~~Rl~~`~~q~]~~~]~~V~&~~~~~~~~~~~~~~~~~~~~~~~~~~}md~zb~~l~kd~l~y~|~~~qj~k~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/822/ccs/fwd np:i:7 rq:f:0.991318
  AAGCAGTGGTATCAACGCAGAGTACGGGGCATACTGCAAGACTTGTAGGCCCATGAATTACCCGCTTAGGCAATGGGTAGAGCCTTTCGCTTGCCGCGTGGAACAAACCGCCATGAGTGTTTTACGTTTACGGTCGGCGACCGGAGTCACAGCGCGACCAACGGGGCCAGGCAAAGGCCCATAGGCTTTTCCATCGGCACGCGACCGATTCCATCAAGTGTTAGGTGCAAATCCCCATGTCGGGACGGACACGCGGAGAGCGTTAGTCGGCGCGTGCGCGGGACTATTTAGCGAAGGTCGCCGATCGTTTGCCCGTAAAACTAACTGGCAAAAGCCTAAGTGCTGTTTCGGGTGCAATGGTATAGACTTCCCACATTTAGCCGAATAGCGCCAACAGCGTTATTATTTGGAACCAAGCAGTGGGCGATGTCAGCGACAATTCCACTTTGGTAGAGGTCGTTCTTTTGTAGAAAACAATCTAACATAACTATTGACACTTTCGGTAAATTCACCACCTTTACCAGGGTCGTAAGTGGTCAAGCCACGCCGACCACTTCAATAAGCATTGGTGGAAATCGCATCGACACAAATAAAAGTACACCAACCAGCAGAAAACAGGTACATATACAGTTTAACGACCTGGATCTAAGATGACTACAGTAGCATAGCCATAGAACATGGCACTGAAATATCGATGGGCGTAAAAGTGAACAACGCAGACGATGGATTACGACGCCAAGCCACTATAAATGCTAATGTGAGTCGAAGAAGGTACCCTTTTTGGAACACAGATATTGCAGAAGCGGGAATGAGGTTGATATTACATCAAGTATCAACAGACGACCTCAGAAGGGTGGTCTTTTAAAATGACAACGTACATTAAGATGCAGACAAACACTACTATGCTGGATGTGAAAATGTCATATGTGCGGCAAAAATAGACGACATTTAAGAACCTAGCATTATAGGATGGAGTGTTGTATTAATTCACTCTAGAGTAATGGATCACGGTGCCAGAAACTAAGGTGGTGTAGGACTAGATGCAAGTAATCAACGGTCGTACTAAAATCAGCTACGCGATCGCCGACTTAGAAGGCTGAGATGGAGAAAACTTGTCTACTGGCAGAGCCCTCACTATCTTTTAGGAAGGTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCATATAAACTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATTGACAAAGTAGAAGCTAGACAACTATATCAAATCGTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGAAGGTCACAGCCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCCCGGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTTCTCTTACATGTCCTGGGTGGAGGGGAGTTTCCTTGTATGGGTGGAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGCGGTCATATGTGGGTATGACGGGTATGACGTCATAAATAGTCCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGACATCTCTAGGTCACCCTAAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGGTGGTAGGTTACATCTATTTACTTCAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCCGAACATGAACGATGGATAGTAGATCCGGGAAGACCAACGTTTTTTCACTACTGCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATACAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  E\?-Q/6)-KeFJ4i8N9H>[QYKC-fXhOMQOKT.OR;MU@?f?^^DW:Xo`:QGZLV9&TL:JStc4c<CWE$fUZf?c(AA9rsO>MAa@DW-P@_AW@Y7@LZ8rS?aR\Q<DB8;7C[TLN6WWL3Bl`RGtRSe?m7O+1KL[9`SL0QEf0R5U=3`V6/<^C[*JWZ?]0o_T_hDvN(lZJ-'=IQEc9QNRJ)M0P*ePr/PQaMI`HQGD^f1XYON&PFG*P^ph[*XN1rpdQ@_KHb<NM&BbOMOPR-hSS`L+C<=PJTQN<9.c[PLD]+YqgR>PP:3^_PQAVQhI<ABSdR-rkPMCgOE:WNT:G:hJCcXX?/TZRk,\<7NF?IFA2[o_RNSq^3tT$BY:I<KM-_iSDR5WWQO?qSRVCUPO.?_L759RRSQseNgb6YUDYHq=H.^@ARLV9o]N:7QBYBXLM&=BFNL@?ohRFssAR[E(Q;kJN(JRO%bmSR]HR<RET:AN[Q\JVH]3&JM>H(@>eSdLA>eM3r_BVM/gQhC`S<Q5\M;>LU+khaP=D9iPHBTX9NUF.nTJT=pPf4X^<PrQ;p^XsSRgA_3]2+X@XeWLN>fMP>S>]C%`KR%5MQMMLF@*a7N/kgTRcP8]`Y>d%pZWQf_fV>,UR6YP.C<NP@`KGwa2PXR\KI@@TJRPQSUY(RPS^QAAc]^VCMR/eH4n;e?GO;G6\OEQRT_/wJ=Q`CkX^@]RTh8@CNSQRRdONI<GuaHQMMRa80?lVp@>aG;VLRJsnF?NRB[83,8CM_M,AQ*8>8b[])&R8ltrZBtWgM^BdPa6c=n;M?PHmQ-3p`CRXPjBvBoR_E]+\VL^AMCK*CT^L0hN_MLQSc3[\ON@C]&D;Z=<KB+BO_7[T^^SI=MJ>PK^>hNWGqLSHBJYScOC^]JU>Y7NZZ_SP]Dga]R\O-V:HE<1=T@'4H.M=BGN:bXLYD?QU=RaKK9ntCeSQm@rIRRRN?^b^a/VOB6^OMO:NqS`eQrXt@rQiMGP_BKKPP4g[Bt^%FeQ(]]O4qd;:mn<B<^AkZDEZ<HRDxPO[?>?[CNAlQFRn$*<b=-UONNI\+Q8P\QOHYOQZPJQMM%'KJ0lNN?@e51F0:3<X?fF80BPUP'UP@=O^S^S^PMKFfQhSG'1QNF:M5:eLQ5hWjiExEp+]X:X:K:EJ@@Q.K<^X9[ML/6^NJgU^S_Q?OEuiPDRFHCGH,mZDOQ?RQSePOCMP>_ArZP'Sg_HV[7`iSSiSGlXYtU(DED`]4pPRgLQPo[RS/^]5P@``8S0NN6>X_NA^?P&SRNQ:m\Q_VOWp@RbiSiNOTPHb_X4@?\RV>O@FTZU^7pV,P_N^\DpT]@iQbWdmVSYPZ3k`SUSX9aRMV;9X)n8g9TkVUQ(eMNRSDPGgmL~mVfbmWdmWKuO?ovWVExxkABY2fabWVP'kXKK}dS0PPs_7s>TIG[ASl7gDM;YDUV<vr3e\?ikJDLtxmeVchSXNUcDQM6ms`U8N;z}wUcU?AT8plPBT-T\AQGQJ8ua>o\_Drh4vzzWS=WT;?OjVLXa?|{dD][o-^U<`5plV<aATJRY<_^[R^WSbTRHvNSDUKv`RG^WZP]2^rFT]AVS@uV:gL2PQU_Q_[BN`]kNI,NTRrWdU2nO]Q8QX?=QI;f7<Ic;wTwXU]Bb`S5=`/`PRPRU]Gwc:taRAWIUHiRU4bcBW>UMAOjG{dIS'\\^Lb@S3bTET8rXdW`UUXByrWyhB\-8[RW@`]-YRR3EXaTPIPEguX`SRRgTO.;*]QT\SWSbWlVU6vUCkWlSTWHxmL~dVCzwcYUXR\W`YJkUOU`YckcXPTFhV9xO>yaHQ2CTdQJHbEucXJ}dmViTV0nRBaSFNXK@llXiUEaFrSEWTWW/>HpVCv.lKEOB.hTVfUNHWHpukM2nlGJrdmLzSw2FV[W]SH?TiTTuT)[>KHUIk`.;iZKXU>_veOVZVCfEqVUJcuWc*se;OoWUxWZv?xdNcGG^ENLwhdVDqUWeRg[XIK-PP[7wdaXUKPSZ:Hd:aqLeWlH`E^SK'K-+NU><UcXR636VSC\[QCFG]?kVfW]xA~fKcTGgcAaV7xSvA9veQ^W`Hi?y|mQYCEy=W\5aLHU[PDTQSe>eWQREcKmaRmVVbEcOTD]RT\W_NC$IG[nhadipoid_ainjcagpuvvvoaVMVUcVcVR.DmVUDQ=UPWb6,Ks
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/822/ccs/rev np:i:6 rq:f:0.986584
  AGCAGTGGTATCAACGCAGAAGTACGGGGCATACTGCAAGACTTGTAGGCCCATGAATTACCCGCTTAGGCAATGGGGTAGACCTTTCCTTGCCGCGTGGAACAAACCGCCATGAGTGTTTTACGTTTACGGTCGGCGACCGGCAGTCACAGCGCGACCAAACGGGGCCAGGCAAAGGCCCATAGGCTTTTCCATCGGCACGGCGACCGATTCCAATCAAGTGTTAGGTGCAATCCCCATTCGGGACGGGACACGCGAGAGCGTTAGTCGGCGCGTGCGCGGGACTATTTAGCGAAGGTCGCCGATCGTTTGCCCGTAACACTAACTGGCAAAAGCCTAAGTGCTGTTTCGGGTGCAATGGTATAACTTCCCACATTTAGCCCGAATAGCGCCAACAGCGTTATTATTTGGAACCAAGCAGTGGGCGATGTCAGCGACAATTCCACTTTGGTAGAGGTCGTTCTTTTGTAGAAAACAAATCTAACATAACTATGACACTTTCGGTAAATTCACCACCTTTACCAGGGTCGTAAGTGGTCAAGCCACGCCGACCACTTCATAAGCATTGGTGGAAATCGCATCGACACAATAAAAGTACACCAACCAGGCAGAAAACAGGTACATATACAGTTTAACGACCTGGATCTAAGATGACTACAGTAGCATAGCCACTAGAACATGGCACTGAGAATATCGATGGGCCGTAAAAGTGAACAACGCAGACGATGGATTACGACGCCAAGCCACTATAAATGCTAATTGAGTCGAAGAAGGTACTCCTTTTTGGAACACAGATATTGCAGAAGCGGGAATGAGGTTGATATTACATCAAGTATCAACAGACGACCTCAGAAGCGTGGTCTTTTAAAATGACAACGTACATTAAGATGCAGACAAACACTACTATGCTGGATGTGAAAATGTCATATGTGCGGCCAAAAATAGACGACATTTAAGAACCTAGCATTATAGGATGGAGTGTTGTATTAATTCACTCTAGAGTAATGGATCACCGGTGCCAGAAACTAAGGTGGTGTAGGACTAGATGCAAGTAACAACGGTCGTACTAAAATCAGCTACGCGATCGCCGACTTAGCAAGGCTGAGATGGAGAAACTTGTCTACTGGCAGACCTCACTATCTTTTAGGAAGGTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTCATGGTCAATATAAACTAGCAGTTTAATCCGATATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGGAAGCTAGACAACTATATCAAATCGTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGCAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCACCGGATCTTTATCTACCATCTCCTGGGTGAAGGGGATGATCTTTCTCTACATGTCCTGGGTGGAGGGGGAGTTTCCTTGTATGGGTGGAAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGGCGGTCATATGTGGGCTATGACGGGATATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGACATCTCTAGGTCACCTAAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTTATGGGTGGTAGGTTACATCTATTTACTTCAAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCCGAACATGAACGATGGATAGTAGACCGGGAAGACCAACGTTTTTTCACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  >.<@19)/QLB>3_O?RE+'*-MV?']YSQ]WS,L8<>[LPFCX=bWDW-`fJaP:.AIV.\W;FIZG1H=J\[&3Q9BQ:U@l87]1U/TN2W.D?H?o?b+;HR=SG4YU7(T)6G;@SOI*(;Wh\O&mbLA3L<W0K<8+52f>HQ]:;LL9C4g)FB=-a<Y(Q\AI>B4`7^5mu_PH0V>4PWM-iHN=<G8]R,VQ,H5sMFUc4t'LS=6,7KLA]VBs^:8HkO(j\k`KqT9gYQN'T=9Q^?BO<E<Z>@LMXFMRP;N=M:HOKNJ:+@YS?QI0TSUL9>.91YX;62V,TcR;/;AN<sU<6:n6@Sg-UP\3VB3=Pj>?]dJOQTQSdO9B--%<RN92Nmg.c,KM=9OOo,Xj[O[IgYV5)8XT+|rlZIZNm9|Ig\I[`gkW]NKveG_3cIpTR5ZiHj;|p\[iY'DOSUIZi5W`\e6ccEKom=XCcAe:gmCVAmS>mtqZl<B)xw_I5XPEHc*vIXtFz&>HnVV\iJHl_4&Ki9_YNbZj@~jG{3fzP7kG09KpHW[G~EjGf3R?6@-si6/2+Rf7fMUb~JeXEcFWd@V0<W>n2NSG3XJ-[QZ`YkXJlo=hcXOV^A^EaQ[Iqb*CNH:6btcTME^A7R[=`@UGY=(>=9@ARK7ceFmLa=Q7S?Wh?KPPDE+LYRQ?=TYRBi5%*K9:d9JT.XP],LAM%<kQ]\SN5M,g[.XPK/WbF,GDMe?@Y/D>]OG?8C@>[L9a_R>^TQGtPsRGw`QYWhIttR<=:KmHrOXQTRQEjQPgC\h`ShEr6qrrZ1T9NOZQDM`h`TqK<S8BXRM%bnOrf=I5[MPPJMAS^_S`?Q@rSdV\OE4OZOGPA^Dd+>Z@M_*--RCR(L1YVL<mZ>OIWPPr?L;JPHDQ:[CY;@R[+>Q8]HQVO><AKWV9K77CYH:UG?Y]fNQaNV6BM>b9+.P-6.@O^^\\.JN-]S\DOT;YR+UFki`Q>E9KKV^2p_a.XGBH?A\PFTHXRfXrC_0dQ?LP^BTOgh>SUY6@$#6Q5R<eQD0\qP[/q<kbAMH8LK8f`Ti_?]TO>CYK(:EF1P:7lP=NP_RU@ttp\QJ=0^\OMRP\GJ*AjR_AT@VF&$$.bRjIMN\TDeA<7lsRYsK$QaE8U/[S]Q-/QQQ\;TDU>:ikWJ?f;V4[a<^R>BqQSAaUgBhAI%&>R/n?_SNPOgSKOCsJRiP_TQhS7fI>fMBPBP]>=Ipk.Ke1pfDC[g_cEcoPN7AR`QLZlJWd>o;*E^hBKQQNaQP6LP@?fIMLVe_RH0ULP4XNM?a<J[KRUCZmRb:9fKdKOV^QWQMWNJTc/7QFtd8=OCQ=^QZ=QgSDo7kTCfAYS[,GOcFPT]QTRaPM6&e3r^hQTCu%Nm<P@AY)BNDtg>;Bi85\@a4;_g`RT\M$MN=xX?Q8rgO9:Q(PBZLJC96W>^XSRS7sm>S7nb@tAX^<jY[=jSRQBsc43A\CSC[P>ON9LLO5,=9FAKBd_.<,07@a'bX63aS])9.MOQQPMP>YNLQDwU9NAQ$\\$b\OX]>AlUCmRRQb]?$aUG;I&9H+aJCo<j\Q'@=9QNW1gCPE\NWqG*-gdPBY,<^@O>&JUK<*HH(IIQQ`R(m3$R[V50MOTOEQ-rq>]QR=PB]@WQ0jWjg'aBV78cC`;:-B/ZTWJRgQc_RiOX'TP=PPSr?rP<SWOAW5=7bR`DmIL4ORdA_I4OOGY/g56JL?>POAN1nM^MMOPR(RLSmD0O-&LMXEUI$R0@Q>^SISP1DkWQTQSEW_>QS`hN3E@ZR\>ZRUDW8O@4VD'E0o^>URJ5LPV6KI4`:6P7neWO@OZE2SdScVR/pn@thQsR>@gP^Ok3[fMA>;0;\;MGp_<WQ^QEL/Uhg`OLe;SKL`SRaSO?L+GbDurOM-AULK2JT_Q%\[8>e(UgN,/=Y<)QHHR_iSi]JhRMPGWQ1ZhWN>P(hd>;s]@HP=xqXSSoRQ4EpRS@[QJ(6j[gJfQ/G@KY2XdNnQSI:N(mrgJ&Y?G\=HTO/mPSJ9%@Zg[L@]R^5K.RG>R<BEZ.b@59AJ^[kS`QN]=XExQ=tmM=TP\Q[>gRSq7oX9jRCtg>f_4qSj+0f=J]OS3t:XWJSi`>RROhEx^OQbQ>o`J[Bve.K?b.n=NGOPT5ve?CW_CXV]G<$F^mql\RR`prrpib^_bjmga][]ggNJQYThSP@?ABYR^;M7l`TdO&<j
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/873/ccs/fwd np:i:13 rq:f:0.999384
  AAGCAGTGGTATCAACGCAGAGTACGGGAATCCGAAATCGAGATGGAGAGAAAGTTTGACTAAACTTTGTTACAGTATTTTTGAAGGCAATCAACCTGGAACTTTGGATTTCATCAAGTAAACACCCATATTTAGCGAAAATGCAAGCTAACTGCGAACTAACAAGGTAACTCTTTTTCGATTTCAAAATATGGTCAGTAGCAATATGTTAAGTGATCCATTTTGGAGGGGTGGGGATTTGTTCAATGAATGAGGCAATAAACCACCGCAACCTCTGTAATTGACGAGAAACTTGTATAAGGTCATCAAAAAGAATAGATGAACATAAAGATTGAATACGGCTGGGTGAGGTTAATTCAGATTTCCCAAATTATGTAGATGAAAAGATGGTAAGTTTATTGATAGGTAAAAAATCAAGAGAGGGTAATAAAGAAGAAAGAATAATCAAAAGATAGAGCATGCAAACATTACATGGTAGTATTGTTATAGGCGGTATATTGGTAAATGACGATCCTTGACTTAGTTTTTTACATCGAACGGTTGCAAATCCTAGCATACTTGATATTAATAGTAGATACTGAAATATATCTGAGTATATCAAGGGAAATCGAGATGTAACAATAAGTCGAGGAAATTAAGGTCAATTTAGTGCTTATCATAGAAATAACTACTTAAGCCCTTAACGAACTAACTCAAATTAACGAGGTAGAGGTTATTCTGAATTGTACGAACGTAGTCGAAGTTTGTTACCAAGGGTAAAGCCAAAACAAAACGATTTGACAAGAGAATCTATTCCATGTAGTAGTGCGTTTGTACGACGTTCTATTCGATGTAAATCATTAGGACGAGGGTTTGAAGCAACTCGGAAAGATGGTCGGTTAGAATTTAAAAGTACTGAACGGAATTAACGAAGTTGGCTACTACCTAATAGTCTTTGCTTAGGATTTAGTAGTTCGCAATTGGGTCAAAGTGGTCGCTTTGGTCGTCGACGTCAAGACTCAACAAGTCATTTACCGCTGTACGAACCACCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ~~~~~~~e~~~~~m~~~~~~~~~~~k~~~~~|~~N~~~~~~~~~y~~~~~P~~~f~~~~x~d~~~j~~X~~~r~~~jB~~~~~~~w~~~~~~r~V~~}~~~~n~~[~~s~~~p~~2~~~^~~}~^~~~~~e~~~~~~V~~~~~~r~~~~m~a~~~~~~~~(~~w~y~~Z~}~~D~~~~~~~c~~~.~~~~~~y~}in~~~~[b~~~~~~~k~~~~~~u~~B~~cE~~]~~~~E~~~~y~~~~~~~~~~o~~~~h~~o~~d~~}~~x~~~p~x~~|~~~m~~~~~~~~~B~~mz~}~~~~~v~~~~~~I~~~~~m~~~~{~~k~~~~h~~~~~~~~~~~~o~~~R~~~~~g~l~~~|~~~~~N~~d~~s~~~~~~~~~~~~~U~~~~~~X~~l~~S~~~~~~~~~a~sS~~~~~}~m~k~~~Y~~~~~~u~~~~~~q~~~~~~~~~~\~~~~~~~~~~~~~~~o~~~~~~~~~~z~~C~y~~~iY~~~~w~~~~~~~~~~~~~}~~~~~~~~~~~~~~~~~~~~>~~~~~~~~~~~~~~}~P~~t,~~~w~~~~~~~~~~~~~~~~~~~~~~~x~~~~w~~j~~~~~~~~~~~~~.~u~~t~^~~b~~~~~~~x~~~~~~~~~~~~~~~~H~~~~~~~~w~~~`~~~~~~~~~w~~~~`~~~~~~~o~~~~~~~e~~W~~u~~~~~~~~~[~~~~Y~~~~x~~~~}~~~~t~~~~~~~~~~{~~~~~~~~~~~~~~~~a~~~~f~~~~~~\~s~n~~~q~~~}~a~~~wf~~~~~~h~~~v~|~~~~t~~~~~~~~~y~~~~~~z~~Y~~Z~~~~~~~~{~v~~~x~~~~~~~~h~~~~~v~d~~~~~~k~~L~~~R~~~x~~~~h~a~~~~~~~~~~~r~~~~~u~~i~~~~~}~~~~~~~~h~~~~~~~~~~R~}~~~~~~~~~~~~~~~~vd~~~~~~~~~~s~~~~~b~P~~~~v~~~3~~~~t~~~~^~~~~~t~~T~~~~~~~~~~~~~~~~~~~y~~~~~~~~s~~zq~~~~~~~~~~~p~~~~'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~t~~~~~~~{~~~~~~~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/873/ccs/rev np:i:13 rq:f:0.999058
  AAGCAGTGGTATCAACGCAGAGTACGGGAATCCGAAATCGAGATGGAGAGAAAGTTTGACTAAACTTTGTTACAGTATTTTTGAAGGCAATCAACCTGGAACTTTGGATTTCATCAAGTAAACACCCATATTTAGCGAAAATGCAAGCTAACTGCGAACTAACAAGGTAACTCTTTTTCGATTTCAAAATATGGTCAGTAGCAATATGTTAAGTGATCCATTTTGGAGGGGTGGGGATTTGTTCAATGAATGAGGCAATAAACCACCGCAACCTCTGTAATTGACGAGAAACTTGTATAAGGTCATCAAAAAGAATAGATGAACATAAAGATTGAATACGGCTGGGTGAGGTTAATTCAGATTTCCCAAATTATGTAGATGAAAAGATGGTAAGTTTATTGATAGGTAAAAAATCAAGAGAGGGTAATAAAGAAGAAAGAATAATCAAAAGATAGAGCATGCAAACATTACATGGTAGTATTGTTATAGGCGGTATATTGGTAAATGACGATCCTTGACTTAGTTTTTTACATCGAACGGTTGCAAATCCTAGCATACTTGATATTAATAGTAGATACTGAAATATATCTGAGTATATCAAGGGAAATCGAGATGTAACAATAAGTCGAGGAAATTAAGGTCAATTTAGTGCTTATCATAGAAATAACTACTTAAGCCCTTAACGAACTAACTCAAATTAACGAGGTAGAGGTTATTCTGAATTGTACGAACGTAGTCGAAGTTTGTTACCAAGGGTAAAGCCAAAACAAAAACGATTTGACAAGAGAATCTATTCCATGTAGTAGTGCGTTTGTACGACGTTCTATTCGATGTAAATCATTAGGACGAGGGTTTGAAGCAACTCGGAAAGATGGTCGGTTAGAATTTAAAAGTACTGAACGGAATTAACGAAGTTGGCTACTACCTAATAGTCTTTGCTTAGGATTTAGTAGTTCGCAATTGGGTCAAAGTGGTCGCTTTGGTCGTCGACGTCAAGACTCAACAAGTCATTTACCGCTGTACGAACCACCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  K~~~~~~l~~~~~m~~~~~~~~~~~_~~~~~k~~t~~~~~~~~~j~~~~{|~~~q~~~~|jQ~~~i~~~W~~~~~~~7~~~~~r~~~~x~~~~~p~~~~~~~j~~~~~{~~~~~~~~r~(~~~~[~~~~~\~~~r~vu~~~~}~~~~~~~~~~~~~y~~~k~o~~e~~~~~~~^~~~~~~~V~~~Z~~~~~~}~~~~~~~~~t~~~~x~~~~~C~~~~~~E~~~s~~S~~~~=~~~~b~~~w~~~~~~~~~~~g~~~~~|~~~~~o~~~T~l~~~~~ar~~~~~~~~~N~~~~~~]~~x~~~~~~~~Q~~~~~~~~~~~~~~~~~~g~~~~v~~~~~~~~~~~m~~~~~}~}~{~f~~~~~P~~o~~f~~f~~~~~~~~~tc~~~~~~a~~~~~~~~~t~~~~~Y~~S~~~~~~~~~~~~~X~~~~~~K~~{~~vs~~~l~~o~~~b~~~~~v~~~r~~~~~u~~~~j~~~~~{~~~~~~z~~Y~~~~~~~~~x~~~o~~~~g~~~~~~~~~~~}~~~~~~~~P~~~~~~~~~p[q~~q~y~~~y~~ym~~~~~~v~~r~~~~~~~~~~~~~~~~{~~~~l~~}~~|~~~f~~~~~~~~~~G~~~~~~~~~~~~~~q~~~~{~~~~~~~t~`~~~~~~j~~~~~Z~~~~~d~~~~u~~~~~t~~~i~~~}~~~x~~_~~d~~~~yf~~~~~~~~j~~~~d~~~~\~~~~~x~q~~~~~~~~~V~~~~~~~~~~~~~~~~~~~h~~~v~~~~s~]~~`~~~~q~c~~~~&~~~~~~~h~~~~~~~~~~~~~~~o~~l~~~~~~~~~~~~~~e~~~~~~~~~~~~~~~~~~~~c~~r~~~~~~~~~~~~~~R~~_~~~h~~~e~~~~r~M~~r~~f~tv]~q~~~~~e~~F~~~~c~~s~~~~~~V~e~~~~~t~~q~t~~~~~~~i~~~~~~~~~K~~~~T~~^~~h~~~~b~~~~~v~b~~~e~~~~l~~~kf~~~~~O~~m~~~~~~S~~w~~u~s~v~~_~~~~yz~~v~~~~~~~~~~~~~g~u~~l~$~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~W~~~~~~~~l~~~~~i~~~~~~J~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/938/ccs/fwd np:i:7 rq:f:0.995748
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCACCACGTCTCCTTAGATAACTGGCAAATCTTCACAATTACGCAAGACCATAGAATAGTCCTAAGCAACATTTGCCGCATCGACCAAATCATGGCTTTGCACTCCAACTTTGCCTGAATCGTGTCAGACTATAGCGGGACGTTCGACCATACTACTCATTCGATTTACGCATTCACCTGACGAGAATAGCCATTCTTCCTGAACATACGTTAGAAGTAGTTGGTTAATGCTTGTCTACATTTGAGTGCGAAGCCACTAGGTTTGCACTGTTGACCACCAGCACGCAAATCGCAAGATACGCAGTAATGCTAAACCATACTTATTTGACTTTGATGTTCTATCACTGGGTTAATGCCTGCTGCTACCTGACTTTTAGTCGCGAGCACAACGCTTCTTGGCTACACATATGCTGTTGGGAATGTTTTTTACACTTATTATGCTATAAATACCACTCCCACAGCTATTCGAATGACTCTAATACCTCTTGCAACTTGGACGACCGTAGTACGCATTCAGTCCGAGTACCAAGATAATGCTCTTTCTTCTGCCACTCGTCTAACTTCGTCGGCTCCGTGAACAAGCATTCTCCTACTAGGCCATGGCGTCTACCGCTTCTTACATGGTAACCAAATCTTTGTTAACCACTTCTATACCTCGTTCTAGGCCTACGTGAAACCCGAACCGAACTCAGCCTTCTTTCAAAGCTGGGTCTGATACGTGCTCTACAAGTGCCGTAATCCATCTTTAGTTACAGTACTGACCACCGCCATAGGGAGCACCAGCATAATGACTTTAGAAACCATTATTGAGTAGTCCTTTTTGGCAGTGATCCGTGCTTCCTTCTTTTTGCGTTTTAACGCTACTTCAATTACCTACCATAATTATTTTGGCCGCCCAAGTTGTCGCCAACCAAAGCGTTTTCTACATCGTTTCTTTAATTGCAAGAACGGATGTGGAATCCGCGTATGAAACGTAGATTCTAGTTGAAACGTTAATAGTTGCCGTTGGATTGAATATTTCTCCTCAATCGTATTAACCGTTTCTCTTTGTTTATCTTTGTCGGCTTCTTTGAGTTCAGCTATTCTTTCCACGGTAACCAGACTAAACCACGTCTAATTTCTGACCCAACTACTGGTCTAACTTCATGCTCATGAGTGCAGTGACAACTTACGTTTGTTACCGCCGAATGGTAATTGTTACTGAGCACGGCTAGAACGTTAACACTTTCTTGCACAACTCTCACATGACTAACTCCCACAACTTGCATTTGATAAACGTTCAAAGCTAGGACATTTTCATGGACTAGCGCTTTCAAGAATGTCTTGTGTCGACGTCGTCGTGCAGTAGGTCTAAATCCAGCGAATGATTTGTTTTGGCTTGTTCCGATGTAACGACTAGCATTACGATCGACCCAACCATTTCTTGCAGCGCAGTCAAAGTACGTTCCACCATGTTTACGCTAACCATCCACTGTGTATGTAGATCACAATGACGTTGTCGTTTGCTTTAACATTGTCTCAACTAACGTTCATAGCGTTGAGGTGGACGTCTTCAATGAAAAAGTAGACAACCACTACATGACTTCAAATGGGGAAGAGACATGACTGTCTAGGACATCGTCGTCTACTGGATGAACCATTTGAAAATGCTTCGACTTATATGGGCATGTTGCCCACTTACCGTACTGGTTCGACTATTATAGAAGGGTCTTGACAGTCGAACACACTTCCATCCACTCCATAACTGTGTCCTGTCGCAATGTAAATGGGGGTGACAAGTTTTACCATTTGGTATGTTTTAGTTTACACATCACAAACCTATTTCACTAAACTCGCTACAACGTAGTAAACTCTCGGCATGATATGCTACCTTCTACAATTATTGCTGTTTCGGTAGGGTTGGATATCATTGCGTATATTTCGAAATGTCGTTCGCATCCATGTTCATCCACCACGTAGCGGATAAATACACCAACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  \~^\QVa(oIOe[8hTX^h^_Xhg]$~vinv}~~~~~~~~~ync\Z\afq}sX=9$)U`WLf]hP~FrQcMkA}go;eO9OeA[AoLf^NtOo6[hc+weZ3~lpogN?:]<ST~rP{fcP{d]TzziT~gdrrhf]AsGwjT_EaMue?znVbeUmF{FteE_U8SkrbTqj8argpfWbZQmZWl:d7~~N>ZQ~bPVNg1RD9jUV9-`DbOTM+WPG_VF?LvNFW~rithfZeLnqddKlG`~hO{U~pQ`~hoT0Qf_qhQU~fV>c;~X~L~\qYfd^YfliiWOT7~~gnbU`ReN|aNseaTEKpD~rRgoZmUI~hsFsh3baPKU<`9*k\X`SdUAYH_naFdqYk>gg8Uo3o~V~Xf[PWiTKdQ`kQRuwW[F[@rdSfVe\dq>~~\~TFmgG~qhblb\]@2uohsQA~~ZAgpQfb8VfQ]\I~bOaG~QC|3thpUOmMprtsieSMP~'nUCw[S0YUdq[FbZb\WS`~YlN`NTmDdnh`V~]aI.x]R:jieXZPzgh^urgrLUQpZriXLy\eM~he=~POV-|_UXV9dSpqRoZO:ajXsaqQmP~LZgrn?X.~fZUQu_ZQpgOggNK~hrhOljdpgipIPOaEYfeQleKvRpT~Qpc^~f>~Ma]=lR$G~pLQl^Q~EkYqV~`OTWjdK~`]P\OVusf^pF~qTwS~Er~qhV~~Q?~BiK-[Q`~ihMOsJ{Zfhb~hqZW~L}h^Qhrh;ueM~~h^~V~f(g]reW`O~7l`@~kQ:~~NaYDt[.Lgdsq[PgpRdQflXbNseYf/~bn+giC|jpQ+~WQ`a~]hsgYqirg]Rt]T~P5~qm1J~~SMe]V~HfNEm*png]gS~~thL~{Rt]\~Xa~htgYqilG~,~~~c%`c0bnMllR~eoig[~R~W~[:pe~lK6d)~~~Xu[PPh=\Xb_P~\~HW~q]W~USN~a~n<~t`&US~Q@~tP~h_~SjegSt`~D~Qehhgh?~~~QpqQrpM:Q|~hP~~_~^{hZYliYubS~mmLnEyNppW~TeQo[XeHtwgirtg\<~frthb~g9~~ghQ~a~oGd8ugO~:`~O~^`~Q]rhQSzvepS~Lbb~pQbk_8kQ|PkL4~aX&c?ntc@y~rpi@u~hpiG~d+ZcI~~itiJ|e]RRYp6bQP|vH~YTP~SLpL~Ta\gsU~x@w[fioRlEoB~~grh^F{y@^HrmNj,qYDN;pNZn:WnKXUZhI)TNUVc]XWKUfJl`]smc:R~pc\~oM~VR~g;~SX~o[cLdR8~qfYMd[`ocD~gi@eO~ghQ~R~htfD~~M_|=csfM~]kfqfYdsrgZ_jB^\iL~~r[:~cb~hf\I~~P[pI~~a8NseBqpg\QtV~`SJ;{t{c1pV~lbX6X\:aE}tW'_;Cjn_S<<uMOY^[OqfCqhZpQeWNPrioGR~TdP;txlV~theP5nNcR+a^T1fUF@~aS~gVg1iCIT`RCVJfjQX^gQ\`~sgWkBegp5yt+XD~WTr~h`~Od]dPbR\Rj&;tkNleHd^~PhH=ijhL7phVQUfnOu?~^`GxdSgd]:WrpVrmhrq^BX?uiaGG9O~hodfS~~Q\Pt[J~O[a~h`?ge1~fo[kcS\~iojshggO~fEC~lDxh8Upg_~d^~mh?~~~~gnjcXTC\P~Vdp]f[]h]UF~`3~~i:z~u\~drih=j:eog^Qi;lEB~[T\ldhWhiqgmZdg;j.XeSlQnsQ~}T)ponod(\{hitha~soYX9~9'jlh`yg:~rrfR~l@~di@PpXu7~6OXNota~]qsg>~$olof\~KWf^DjOc/l<BRXG;~J~qZT~SKUQ~\pQwPk>bRW)l]incdhT~rdm9emi<p~~~rhkI\tf5~~~pCvmPlQSzYjh_){~~kg:~~iKUHbq^Ic&oo*jiFA~hK)Mi:~~amhiha]g]tQgoGhqD~~OSQjgK~f^qfGnXkfRiXT~_~hq]gAsJ|[^~;erg;~~gV~cX;~~]~F~rlmr\>4lc_QeernPi~eg9~~rirgcUlfihtp6~rbgJ~A9--XY>]LOeRUPfW~qSS~~qn`gBVRqAs~~iq^_UgnRfhA~f\mFR~Xgricn~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/938/ccs/rev np:i:6 rq:f:0.995688
  ACAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCACCACGTCTCCTTAGATAACTGGCAAATCTTCACAATTACGCAAGACCATAGAATAGTCCTAAGCAACATTTGCCGCATCGACCAAAGGTCATGGCTTTGCACTCCAACTTTGCCTGAATCGTGTCAGACTTATAGCGGGACGTTCGACCATACTACTCATTCGATTACGCATTCACCTGACGAGAATAGCCATTCTTCCTGAACATACGTTAGAAGTAGTTGGTTAATGCTTGTCTACATTTGAGTGCGAAGCCACTAGGTTTGCACTGTTGACCACCAGCACGCAATCGCAAGATACGCAGTAATGCTAAACCATACTTATTTGACTTTGATGTTCTATCACTGGGTTAATGCCTGCTGCTACCTGACTTTTAGTCGCGAGCACAACGCTTCTTGGCTACACATATGCTGTTGGGAATGTTTTTTACACTTATTATGCTATAAATACCACTCCCACAGCTATTCGAATGACTCTAATACCTCTTGCAACTTGGGACGACCGTAGTACGCATTCAGTCCGAGTACCAAGATAATGCTCTTTCTTCTGCCACTCGTCTAACTTCGTCGGCTCCGTGAACAAGCATTCTTCCTACTAGGCCATGGCGTCTACCGCTTCTTACATGGTAACCAAATCTTTGTTAACCACTTCTATACCTCGTTCTAGGCCTACGTGAAACCCGAACCGAACTCAGCCTTCTTTCAAGCTGGGTCTGATACGTGCTCTACAAGTGCCGTAATCCATCTTTAGTTACAGTACTGACCACCGCCATAGGGAGCACCAGCATAATGACTTTAGAAACCATTATTGAGTAGTCCTTTTTGCAGTGATCCGTGCTTCCTTCTTTTTGCGTTTTAACGCTACTTCAATTACCTACCATAATTATTTTGCCGCCCAAGTTGTCGCCAACCAAAGCGTTTTCTACATCGTTTCTTTAATTGCAAGAACGGATGTGGAATCCGCGTATGAAACGTAGATTCTAGTTGAAACGTTAATAGTTGCCGTTGGATTGAATATTTCTCCTCAATCGTATTAACCGTTTCTTCTTTGTTTATCTTTGTCGGCTTCTTTGAGTTCAGCTATTCTTTCCACGGTAACCAGACTAAACCACGTCTAATTTCTGACCCAACTACTGGTCTAACTTCATGCTCATGAGTGCAGTGACAACTTACGTTTGTTACCGCCGAATGGTAATTGTTACTGAGCACGGCTAGAACGTTAACACTTTCTTGCACAACTCTCACATGACTAACTCCCACAACTTGCATTTGATAAACGTTCAAAGCTAGGACATTTTCATGGACTAGCGCTTTCAAGAATGTCTTGTGTCGACGTCGTCGTGCAGTAGGTCTAAATCCAGCGAATGATTTGTTTTGGCTTGTTCCGATGTAACGACTAGCATTACGATCGACCCAACCATTTCTTGCAGCGCAGTCAAAGTACGTTCCACCATGTTTACGCTAACCATCCACTGTGTATGTAGATCACAATGACGTTGTCGTTTGCTTTAACATTGTCTCAACTAACGTTCATAGCGTTGAGGTGGACGTCTTCAATGAAAAAGTAGACAACCACTACATGACTTCAAATGGGGAAGAGACATGACTGTCTAGGACATCGTCGATCTACTGGATGAACCATTTGAAATGCTTCGACTTATATGGGCATGTTGCCCACTTACCGTACTGGTTCGACTATTATAGAAGGGTCTTGACAGTCGAACACACTTCCATCCACTCCATAACTGTGTCTGTCGCAATGTAAATGGGGGTGACAAGTTTTACCATTTGGTATGTTTTAGTTTACACATCACAAACTATTTCAACTAAACTCGCTACAACGTAGTAAACTCTCGGCATGATATGCTACCTTCTACAATTATTGCTGTTTTCGGTTAGGGTTGGATATCATTGCGTATATTTCGAAATGTCGTTCGCATCCATGTTCATCCACCACGTAGCGGATAAATACACCAACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  L-S@`qemCqaZLhM~idir`Nfsrh$~~~~~~~~~~~ytv~~~vrt{~~~~xtw~~POVEwphgXeiO_7kKaYZRh=J=fM3hiegFiJgPGmKqZNO^;~frY~oEoe\~dHenSznc~hh`~gYL~~gD~dcTRO_YB~:q_,Z;VrrS~MF~~QfmH]X|_}i?xxgY~rSMyVIDEdrdg$;H*NfSSFa7XlZieLVMOpX~mlX9hjOW?XNjfOFQ~rhgTY=~hrW~n^lQfpR]uqYeW~q>|b:|C1;dQ~hntseaN~XdK|g`gT-tLkO~b~mQgb~hbiboQj6ttOf\B\D3_~QV~raNiAx&kPLPphX_P~gqEtYNilhhlKJIL~\hhh`~hllSffelf]R{Yc;YG~~Tz7pPI5\e1i~M?O5~~`q]f`~Qkj]d:6XH~ta~O~pQLiHdPOFQprW~thrf<x~~qRnghe9W_LWfOuOOgM~g`~Rvhrrhn^eFnreibPLn@~~_~na2~h~~~m:iNWykLmmZfior[)~~ko5~natL~~pPWd\gU<pS]Lt]RphpQX]z=fDuhdN~gfb~T<_&h\kgcXB~^M^BbdFLfqNtdrQ\IoL@btrV~6qai0HpENSjHA~r8K~Pqf6~ocWghnPmQ{e)cUKBYH`N>7FH[NL~N6keiqIff_~C~ZRg]qU~G~l^EtVPDTYpW~ed>~fKlUeWA%r[:~X~?~~rQU~~R>kNuHqp`UzMUnYSDtYcP*OflSPsPslZeMVbQ}rKs~gJxB~O`~htfofW~a~e2yrc$k\N]H5wsho9kGoihthh]f]qhMnJk7FH=X\~\WykheV~~sd=~jhqRWXg\TrV~rY~gLAqqY8VdTdO>F~fR7lrN~pQpiK~vf3Re~E~kP~mA}dRaGoUmQ~:qvwtfQjLqhrtW~ekfR?~V~b~h/ju~rfia4q~x_~QfhtrfN{O^~Oug/gbST~ZpLsGHR'WagK3id>~~]rS-pdpiVW`%nBtBypeRe/_HXcGoirrQeC~nK<i|P~YF_=Zm<;qfBne\a@.~XeKV~RggYQ/`D~~RcsrelQtXJogN~PA~jWUS~`~GoR;t`Cu[6\S~nU}SLgDl(eybV0][?L~\gh]m]~;~C~fV~~QU~hG|]GDun][f8ssfsg3~e>~f/|YOQNL~fYeh]qa~d0~eD}mJMssc~W~pRpitS~p2mVJJkg[M~G~~chaq>~~N~htritV~rQqb~QOzIH[fg[fX[fpRqc5OcrQpgA~gb~rieL~wRS~rW~hY~dMm16~sb~T~g9bgbjfZehrQNzKWUONZaQ^|8~fpQH~~ha~TM$>&se[OYPpcU[?oir;~fV8~~qh`~dBlQgq6~oaoFG~~hha~h,~XSQEoC~UfpN~~~hq]B~dd]oRgfSN~iN/ihV~hp~rZ~Kh`~qZaZmt@iNplRnbIbSzL~cq{?L{ga~~q\hT~PlxQ~~qL~~sJ~r[~nJ~M~l`OZ{G~p\qc~~rqL\~}\p~~qG_@~~F~J~y@~~oU~joumVfZ{\zEK~~qi{okI_S~bQ~ylZF~dkrq\c&_BSrqSzs*@P[N^NT0QD`u~sstbganh^YZ~q~sp;x~pp?~v[~r~N~WgUj_G~_I4~kW@~oejtqpkj~owNpu[~|qD_ZD~fd|PoB~~~~XZh0V<;[Zt_WPxjby[eo3~V?~b~9~~w`~Qtmvo|@h~mgW^go~Z~s]w']=a73$$HXQDaY~jJh,~:|r.~~oZ~~~idP~\mg_F^mZb9,[f^]H3WoD:~~ZWR~XSsYV[WWO~SzT*kr}zSwpWbTj~Km~}[5dZz\bRMYXV~HyKhqP~7yb^\~fmgB~rhR~qkIk^gmdnIZmGk~wg~X~~i<~~~|dYytj~n%}~bd^~s?ttZma|irU~~~~rP~~xm]kl~opmNt~q^sI~^rk~rg9~~[yljUVHS?~jjYbKHJ~~]gLlY>M,jPlcO{~q]}y^~C~piz\e~d~}[~omMW*t~vq`~2~~N~fG~`~|~}~s~_~qroz}bwB~~tqC~~|pbRgJ~p[qyd[~w}_D~nJcI~wKya]jJ]ps]~}r;~}~j[{^~j~=~~~hWtr~qSn\lJ~mtic^~^Und7Rt
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1034/ccs/fwd np:i:10 rq:f:0.993574
  AAGCAGTGGTATCAACGCAGAGTACGGGATCGTGGCCCAGTCAGTGGATTACGTTGACCATGAGTCTGGCTGTTCTTGGTTCACCATTAGCTGTGGTGACAATAACGGGCATTGTGGCAACGATACGTCGTACTGCAAGTCCCACTGTAACTAAGACAATTCGGATTCGACCGATACTTGGTCTGGTTCGTTAACTTCGCGTACCTTCTGCTTTACCAGCAGGTCGTCAACGACGAGCCACCGTAACGAGTGTGGTTTCGGTTCGCTTGTTGGGTGCCCAATTTCCAGTACCGAAGAGGTAATTGCAACTTCAATTGCTTAGTTGACGTGACCTTTCGGGTGTCATGGACTACCGACGGTATCTCATACGTGACCTCGTTGTTGACCTCGTTCTTCATCTGCACAGACTACAACGTTAGGACTACGGAAACCAGTGTGAAGTTGACGGACGCGCTAGTTTACAGATGCGGTTTATTGGATTGGTTACAACGGCAAAGGCGGAGACCACTCCAACTGTCGGAAGAGTACCTCTTCAAATTGCCATTCCAATTGCTCGTCATGGACTTTCCACTCTTAGACGACCCGATGAAGCTAGAAGTCTGACACTGACCATGCTTGTGGCAATCGTTGTTCATGTAGCCACTTTGACTCGACGTTCACCGAACATACGATGGTTAGTTCTTCTACTATACTAATGGCTTGTTTTCGCAGAATCTGTATTTAGACGTAACAATGGAAATAATCTTTTTGGACATTGATCTAGATTCTTTAATAATAGGTTTATTTACCAAGTTGACGTTTCACAAGTTGTTTTAAACCGACTTTTTTGATGTGTTTGTAGTTATTACAGCTGAAAGATGACGCGTACTAGAGCCGCGGCGTGTCAAACTTTGCATGCCAGTCGCGACAGCGAGTCAGGTTAAGACTAGCCTATGTTAATTTGCACATGCTAACATAAGTCAATAACTTTAACCGTCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGAAAAGAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  m~^9qZbIZ3?`K,[D5h~e~YjO=(]<dAXGu?Z>woPdw]iZ*&FVRpZ[KCJLp5Y_g1Z`\?L)Lkt^3JESdO~S~iLVad;ott`~sxI~UWu_Z|~Y~M)^nu~UkSgN~\^zjfev~ro~ss~~rZ6J_~s~7{~^acGgLpImBacW^Q~n~cV~~q~tbp5Q\l8HcG~W~sBnK~MymT[~nl$QwiUPmsu?~j~g}n7:Yr\L~~MfSLe\3`uaIXOBGNeva;pg>J5?=Y;><OqYyN~4gTT1W@C+kT=](8b&B49:0.:?j68E7G8[VVHXS^~mmY~~t~^~stR~`i~J^ts~scc~{qZ~pFfI^ovR~=~~i<~>(HfJnA?i~b~vK~\~h[~pM[a~pmhxIstnt9YUOnJ~Y_qlW;pe6Ef~o^~X<$ZlsPm9ujfGh~^M}sro~w_~c^i?]M~%a>P~Cp~lp?VuK%_aiDPyoVfdstn\n@}PP+k][HC]Vu*~~w]~Z~`fsY~IBboX`sNs_:n~P~mM~~pzE`-Oh<cNxsrO~wKwY^lXc~~S~Pse~_2~~X~|b~NWuA~c~j~eakyh~g~|Q~dF@~W;~~`|XP~hXd>`~,~~O~~y@~Y\a\cLs[dE~SXhrjuOeK^5QKI_~n}\~x_~~kgZ~zk~hhHM~~wZ~~[;s{gXP}wUaG_>~o~'5:ic~~~Y|}~ka~l~qfp~fY~a~~xaHdVQ{_~~5~`c~fH}~~eT|~w[~~uwc{lj~~~djR{~]~~k~JS~P~~~R~~|2~~~wZ~~i~Z~{~ig^Rj{_~~\~~5~~~~S~@~W~~~K~x[@~S~rt~]]FSE~~sm_UrUV<PGi~J'^~^~vuV*w^{~oSh~l~uM~~a~~}Y~~o~~~~c|~v\~v{~~eFxh}g~Pt~qool1~FT[~oC~e}~]~~mG~~wfrkyO~aQhKbua~_DLvQ~w~d~c~L~~~xEQ^Pgf~|U^Of?W~RfldW~_iZyrwd~k|zQ~|~NK~ve~^Q~~C~T~o~s${}xud\`x~~~~~~~~~~rjd]TJ;204AMMPb3'XRT)$[]Q>-+27=Meqvy{}~~~o]Vcgayz`WEnWkGX~_~~cDw^UwGYl~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1034/ccs/rev np:i:12 rq:f:0.997175
  AAGCAGTGGTATCAACGCAGAGTACGGGGATCGTGGCCCAGTCAGTGGATTACGTTGACCATGAGTCTGGCTGTTCTTGGTTCACCATTAGCTGTGGTGACAATAACGGGCATTGTGGCAACGATACGTCGTACTGCAAGTCCCACTGTAACTAAGACAATTCGGATTCGACCGATACTTGGTCTGGTTCGTTAACTTCGCGTACCTTCTGCTTTACCAGCAGGTCGTCAACGACGAGCCACCGTAACGAGTGTGGTTTCGGTTCGCTTGGTTGGGTGCCCAATTTCCAGTACCGAAGAGGTAATTGCAACTTCAATTGCTTAGTTGACGTGACCTTTTCGGGTGTCATGGACTACCGACGGTATCTCATACGTGACCTCGTTGTTGACCTCGTTCTTCATCTGCACAGACTACAACGTTAGGACTACGGAACCAGTGTGAAGTTGACGGACGCGCTAGTTTACAGATGCGGTTTATTGGATTGGTTACAACGGCAAAGGCGGAGACCACTCCAACTGTCGGAAGAGTACCTCTTCAAATTGCCATTCCAATTGCTCGTCATGGACTTTCCACTCTTAGACGACCCGATGAAGCTAGAAGTCTGACACTGACCATGCTTGTGGCAATCGTTGTTCATGTAGCCACTTTGACTCGACGTTCACGAACATACGATGGTTAGTTCTTCTACTATACTAATGGCTTGTTTTTCGCAGAATCTGTATTTAGACGTAACAATGGAAATAATCTTTTTGGACATTGATCTAGATTCTTTAATAATAGGTTTATTTACCAAGTTGACGTTTCACAAGTTGTTTTTAAACCGACTTTTTTTTGATGTGTTTGTAGTTATTACAGCTGAAAGATGACGCGTACTAGAGCCGCGGCGTGTCAAACTTTGCATGCCAGTCGCGACAGCGAGTCAGGTTAAGACTAGCCTATGTTAATTTGCACATGCTAACATAAGTCAATAACTTTAACCGTCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTT
  +
  &=(4SZdW~o~|ZP~Vi)RdaetPS'~~]gekst@gJ~~kvo{~sz_~ks~~lj\~w~E~~~R~[RhoS~=uoD~_\uP~K~p[/~~bgc_TVnQ7r4arVOsZh~}5~~o|mmhs\~mN~k~~~~~~~}n~yu~g\]io~W~~~~~}~~~~yd~~~~t~v~~g~~v~~u~m~o~~~~h~P~[~~Q~n~\~t~r~kshxe~u~~e~b~j~~mT~~~f~~y|pi~~is~~<~sn~~~~~]~pS~~~h~~gi|~V~i~c~~k@sw~uxvd~d~_yB~~~Y\~~h~j~~b~lg~s[~hJ~ViNe~o~k~Rjk~|[|ru~;~~W]b~~O~E~~~~K~H~*zztnH~~_o~~X~b~qfv~C~l~Th~~~~~~x~~~nq~v~N~~|Rb~~a~pBe~~}~N~zH~~~~{of~AY~~~ir~~p~r~q~Y-~~~~rgC}b~O~~ozLmdu~~s~ktxa}sUP`Qe~~pM~~~|~~k~~^l~f~~~o~[~~r~\~9]Sd~|iX~bV~~S|hP~~V~h~~p~e~/~l~QdxX~T~o~~\v^~xvh~qG~~q~Ck~~e~<~~~T~s~~~u~~~~[~~{Qx~J~~~~}_~~k~YY~%ex~~^os~p~~~Yt~~~~~\~~~g~w~_~r~~~o~~~c~~~~~m~p~my~~wwr~~~]~~~h~~Y~~yz~~~}mz~kY~h~lm~h~sa~[}`~~~p~}]~|H~fprY~~~q~~^~ob~o,`~~TT~~wtQ~~~~~d~U~~qikskJI~imj~]~O~~|I~~~3~~~~i~~~~]~~~|ns~~~X~P9~~e~~n~n~_~^~~~Z~~~j~M~}w~s~pvd~x~~~oxtmur)~~~cU~~=~v~[(~~~~~~~~~~~~gOt~wr~nZRYY~~~~~~~~`~~i~~o|Ugld7~pe~u~~k~s~Y~c[XaQaZ~~bQ~znT~aX:~}^~n~kr~n|v~~~~~~~n~O~~~Dm~~~dP~~~~c5~~~g~~~~~|~q~~~t~~~~y~m~~X~zt~_^~|b~S~~Ad&p~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~m%~~~~~~~~~~~~~~~~~~~~~~~~~~SN~~~~zv`_~l~z~T~~M*0
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1091/ccs/fwd np:i:6 rq:f:0.997974
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTCGATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCATCCTATAATGCTAGGTTCTTAAATGTCGTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  i~mO[n{5~{twLQ~gog]l]gbX_$x~~~~~~~~~~~~~~~~~~~~~~~~~[Pmo\oV~tgn[H~mbWw:pQ~nh|TE[~~g}D~ntgrf]~tgrD~c[la3~nY~o:ze]T~iM~S~dqgtW~pm~;~~k~Rro~o~m4~OC~~g\~]o|Wi~n4~{z|ygog~I~}gn~&~~_]~~g{Bc~tqG~qdfoj~dsuQX~g[~d%~~togb~l@~FTxa~fQ~SWuA~~}ZP8~l<cV~~mQi~?yC~~d^@/{}N^R~ogoM~~~oV~o~9~~~tjmdncO~Q~{sK~sE~~t}6y~f~og~g|>~gW~9~iP~`k~bn|Ynw/`:m`|QL~~~pFz]xc^fwM~gmdm}]U~~r?~h~rotmQmm~Z.~B]un~rfj[Ybqgtos:~xf~gb~~o{\Q~~lX2|x5t<TWqEqkO9t{g|Nbf~c,~insVOm~P~ngtg^~~RrouU\~]dX`~a~~]eI~}]~~b~Nz~gogtgtgn~goTGRnR~~t]~~otSfykOWjs~ozQu~i&YmW~MbT~]U~n~dGeT~~~n_f~lhso~a~I~lMk~>yrU~};~~\%~~~VV\Ua~gm8]iYD~rGhhX`h_7VaZ;~~ldd]}oFnctgt~txi]@rk@~msG~b|M~:z^mG|~deq-SZzg6~VE~Q~~n~T~]K~~o^pfP~]~V~~h|'x}||Ry]F~\t]~tgqdm~totoN~~otwgqd<~~~i~MM;V~s]~slG|o~sps}<~~nt}F~H~O*~~fnY@lE6~~tIkL~;~mT~?~q)dm]P~Q~~o~f]G~xY`V0yhzUOP~~]P~h~mj~t~g~W~v3]=efot\~Qzn}nrG~X~T~\SCvD~O|Pnt~lKYb\ddqgxj~o~g\~?~nQ~i]?s]YHdH~gosP~~=Qos~snY~WyPuhjfZ~g~tcOs~o{LZxdc~dvNut{2~|o|>~a]}U~og~V~n]}aoX~s{BLY~Zft5~~f|RKaqnR~~s~tn~osP\tz?xlQn~fXfnXn~H~~ln~otgto}I~f~n]m[MaqoS~]c`pe~T~]nX~of\~go~osL~0aU~|E~~~nZ`[n~kXTwrg}nE~^n~mjtg@~o'~ge_4kqz:zgtoL~f~Z|[~o~g\~gn]|ajgo~todaT[G~~~^n}Ycor8~nn~ol~Gfi~(bnbarjgaN~~seZ/voCi@~\n`~~dc\~goO~j{W[bU~JFk_Ba?xnVro~oVx[~T~{^SV~gsg~X~t}D~}t|>~}ohxeRp>n_a~@~~qmdgo~g{FG~~~~mC~fdae]pf~iY<YE~rp\G^Dl7p_iQmr]n}[kcj,~~UyQwiN[uNRp[~rfx^RiY~ny7nF~tl@\~~m[9~eB~~l~Q}nZO~~dRlOte<lmostb?ngUXWs<~oebR;qI~~`WY~G~{jcI~d~ofP~whsPcm|VX~R~0qz~B4~YjzdJqJoQX~gotgzcP~l~]j_iL~~r~mj|H~Ph~]~go|Rm{,~x2~q~go{R|ogl0~ln~gtg8~~~rgn4~~s~gnZbpA~~Udn}XK~]}om~bHo~H~g~s{mQ{^f~p~to~gt~eU~rn[bT~]X~zgom~H~~g~o}]|]}o{GF~}n+~~B;zkd~^~n~\~y=ytgF~~~ta~o|nvb[T>o`i[Q~~W~tU~R~~ogn~t~ob~o~]~vO1aVo|\~M?~l_S~Gfn~sgl-J~~~^~~J~~G~aI~_U]~Q~~[A}iM~~n}nyN?lmhD~r~nY~shXg~WA~~~g~lL6~~qWZ~dorD~xY^YJ~I~~o~X{<uO}n~gog~otgt~fW;~~]cdmhn~]~F~H}Fw~t[~~a~cUc{Bh~K~b?eyoc~dY~My;~~yUzC~~Z~gn~t~tT~]m~oeHJ}~nF~~dtof^eY~sZ~gA~~~nK~]mY~sn:~~~sgT~~gN~yRmbzgY~bktU~n~gkaaI~~~t]~M~~ogod1bogoU~otau>~fmQ}g~nc^cqdpN~bQC~~bF~pF~~~hZ~d]cL~qW~Gf\N~dbbT~G~p]S~VWNZ]60;~bQpT~4~~j_O~rhr<~fM~H~~cN~qT~8~{h`c~S~WWKXNZqdoI:WXK~T~oFa?~cf;~KhC~|]dp1~~|\h[QXhrR~]R~-~|ja7~O~h]bGS~]K{T~N~vC~i-h;8~~cCWJO~pB~^\8~~TW~c~\RpL~zN~pR\J~bQPM~aGQcqeVa1~~~cpS\UYm6[`O~aMnNJlR\oM\r~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1091/ccs/rev np:i:6 rq:f:0.998009
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCGATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCATCCTATAATGCTAGGTTCTTAAATGTCGTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCCCCGTACTCTGCGTTGATACCCACTGCTT
  +
  J}Y^a_`F~rsdmJ~ld?yaJhh}o%~s{~~~~~~tfYWat~~~|n]RONQcqYWd^ern]}k(fE~}ogo;]\~~\tg}D{on]\~g}RnsD~}mc[~u~gtR~~U~~nsn~]~fE~\~qaU|Xrcb~R~~b~o|;IQD9IXG:ll]C~ZGYj:lS1~~~~~nfA~V~tn>~P~~R~Hh]}]s{FG~bpnha~jvsWU~nD}R7ryw~om~S@~~^~b~oh~on~=xz~~n;~~7SV~\eo_~coJ{~gglC~uZ|H~Mkb.~uodk~:o`~~t~h|\f\m~]~t~]~~6~~~r>~~mtfV[mqE~mf~L~~Y~eX~og^lNpog]~b~o<~~~~xnyj?zosV~n`A`V{I~r~X~U{]d~eod[~r\~R~~gl]f|\yDzmaN{H~~ntpn~sg]}>~Q<`G~p?~gVkqn[dSf~YXpl^kson~g~rQlc]l~QlaU<~~jwe\|&~}~ogY~HxrkmD~mQ~tfy;~~VemaU|oV~WSXxmOH~~q;~ma|J}Evfd_o\dG[~tg]~~f>~kFF~|]~L~Wdl:~peP|n]}o~f[B~?zdmO^G~}\~^J~~~-~xC<zmD~mh~ot~N~~{EN|ofX)nYHR~~gso}[[P~~~o}]{]f~^~fL~f}H{_qRvmqn}C~~ro~\~F~l-~~TyL~~M~]~}@~~^t~oh~<r/~~ms9~~aNQ~z6~~zS_|o{W9iw_ng?~~fz]n|FE~~nM~m}M~~}U~~g~tgqaNz\0~Z8P=IvA~~R~~nf`2p\<}~qgl-~(~~4~G~tJl`vF~D~~cCV{C~~|mPK~~~PmE~~z\~g)}|Qq~sn\G~[]~i~if~L~osf^Q|]~[l]~~o~s[~C~TLtsgU~lfWq{n[OoPqjT~L~~n~g~]~y=yl=nUd{Ixyb]Z}sy8MpeoiW|gm7Xl\|nG~~e^W|tnP~nrI~}t\~abKX~n~kV~JkDg~dIoofL~}t~mU~|;~Q~~ntfWobc@xy~tzG}fwY~u\A~~lQq[OBNmV~O~~`O~P|o|@W4znn`u5Zlq`O]~~tn~m[Y~FM]~gob~of\O|\~P~\~^2~~ug~n}bkbsE~Dk[HN{aIYbKYTg~g:~~mG[~~tn]n~d[~P~m]m~gsjRy?c{]lOVd^}gn]f}5~~~}gt~oVyZ~aR`MKnth=~eoynnrwQq\h,hZ|K~{H~M~bdH~~mYW~o}G~LlgyhQ~MI~~otn]}fdVRVm~P~X~\{pj~Uals\~v=UxY{tn~tgot~W~Q~n_u`~~tVsndmReq,~~~~NF~d;tle[vKdaU|8~~r]i\ir^~~fX}t~f^xbgM=oic[ijMi|]lP|k~rgdnWeO~P^n~O~~~F~r~gy]~}C~~a~n\QnL~rmP[m]f[sh~t~ob~g~tf\X~o`@TX~Z~nk~b~H~~fYB~n]foi~m~tosNZe?vH~-~~~bW~hUQlZ~P~Wa~ofdmp?QpMztgo~Fox}qaM[R~RM^(~ojJ=8O\>~j]~~rhIWVjJZLSL$Y~WzWH~~~~kh0~~~tog~t~T~~W]ZhQZ~cT`RYft}]T~UjuUeoswnqU^zg^n~qoP~~g~t]~}8~]j*(EA~~ikQknk~tgt~^~re>ldgntgnW?tJ~C~]Rr~n7~~~t<~MjR]mg|Gdog};~xH~z7~i~GNUA~ucUY~dGOwnnH}VLCA~gF|e_W{zj+]LmfdC~~rU~_L~zSr?IAWIQ~I~~~]r<]~yfogto|G[^P~~qdXQ~dya~Q5~~~n]}n1~~vLj~Z8GZ~tot~]~P~~eGQ~k~P~e]mgVYe~kHooc<~~nYnQk=p@zS~]|A~~rn~sX~Veose,~R~WdV[w@~mU~oq-~~NMJ-oul~`WhfXnY~~P~N>zQ~~g`~~h\dmdmb~~U~o8~~ua\~}N]qvKN~~~~n@~yVQ~{nfd]oU~og~\~P~ne?Z>~^GvgrBr~fogmdkP[gN~`Ym]l~nhk]ntogof]e^X~f]S~~fY~\D~~~~Q|RX{K~rn~o~o@~g~m>zY~pk<~rndRXQQ[~h|m5~G~~~gY~Ze\K~~\~W~~g]~nIR4f~m8NP4~[lgogosF3E{WqIhG~qofI~d_WrctQ~~odn@~~~owWro{p6~k4~FoxfMu\~}VNlC~ne~KtN~p1{qoorC~~}_ucH~[L~goM~~sY~V~o~s>~~\~t~nY~ftob~b<s6UnEdI~~~c^cmtotgoc?L9x]}$~x~hbbcG~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1092/ccs/fwd np:i:11 rq:f:0.998164
  AAGCAGTGGTATCAACGCAGAGTACGGGGATCGTGGCCCAGTCAGTGGATTACGTTGACCATGAGTCTGGCTGTTCTTGGTTCACCATTAGCTGTGGTGACAATAACGGGCATTGTGGCAACGATACGTCGTACTGCAAGTCCCACTGTAACTAAGACAATTCGGATTCGACCGATACTTGGTCTGGTTCGTTAACTTCGCGTACCTTCTGCTTTACCAGCAGGTCGTCAACGACGAGCCACCGTAACGAGTGTGGTTTCGGTTCGCTTGGTTGGGTGCCCAATTTCCAGTACCGAAGAGGTAATTGCAACTTCAATTGCTTAGTTGACGTGACCTTTCGGGTGTCATGGACTACCGACGGTATCTCATACGTGACCTCGTTGTTGACCTCGTTCTTCATCTGCACAGACTACAACGTTAGGACTACGGAACCAGTGTGAAGTTGACGGACGCGCTAGTTTAACAGATGCGGTTTATTGGATTGGTTACAACGGCAAAGGCGGAGACCACTCCAACTGTCGGAAGAGTACCTCTTCAAATTGCCATTCCAATTGCTCGTCCATGGACTTTCCACTCTTAGACGACCCGATGAAGCTAGAAGTCTGACACTGACCATGCTTGTGGCAATCGTTGTTCATGTAGCCACTTTGACTCGACGTTCACGAACATACGATGGTTAGTTCTTCTACTATACTAATGGCTTGTTTTCGCAGAATCTGTATTTAGACGTAACAATGGAAATAATCTTTTTGGACATTGATCTAGATTCTTTAATAATAGGTTTATTTACCAAGTTGACGTTTCACAAGTTGTTTTAAACCGACTTTTTTTTGATGTGTTTGTAGTTATTACAGCTGAAAGATGACGCGTACTAGAGCCGCGGCGTGTCAAACTTTGCATGCCAGTCGCGACAGCGAGTCAGGTTAAGACTAGCCTATGTTAATTTGCACATGCTAACATAAGTCAATAACTTTAACCGGCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTTCCCGTACTCTGCGTTGATACCACTGCTT
  +
  ~~_|~ms^~xrcd>~hxSo~|~~Nm,{~~v~r~~t~*~~h~~}~]da~c/~\`~f~~e:k^Ni~Y~gyo~~~~~~e,~ct`~]b<~]m~~~{jZ`^~~~{jj~~G~]M~~Osv~~~b~{[~wq~~}{s~}~~~qni_H~xuB~~~kNsua~}~c~~~UR~Y~v_~xV~z~Ra~~~~abj~]~~`~\~l~f~n~a~`G~t~|~~~_~~~h~~he~~HH~~ky~EjMf~~ZMp9d~`ovr2~]0~h|h~a~g~~~~[xC~~d^~i~h|aJ~7~~~A~~z_,~~]~j~~A~w~~tF~mh~~~r~~v~f~~Uh~UbmeS~~~`z[~~pR~wPSl~iP_~G~hbf~~~q~fs~G~~QOu=~~mDp~wbzv~sudu|~~~~P~~ft}~~]~~~R~~yw~~r\~Gn}Vpiom^~\J[qnH>yr~K~hR~ls~inl~4~4a}~~L~|l~jy~~wPo~`H[a]v~~~7~~$ehks~~~bk~]~~~m~d~~V~b~3~[u\~go~{j~~M~|n~r~x1~j{~e~\~w~p}{p~j~~~l`cT~~xm~QE~~~~wg~kW~Q~j~p~~zyf~{'q~~h~mnj~~Y~r~~q~~~~~~~~H~~nq~{a~~@~~e_~~~p~~~p~~L~~P~~~~ru~~~f~~^~~~~x~~u~~~~~~~~d~~~j~~{m~~~~o~~~~p~i~m~~~~e~~~~|~s~l~_~~~~~~~~~~~~~~k~~w~~w~~M~~~Df|~vI~~p~w~Zg~~~~~o~~Q~~`~~j~a~~~`~tsK~~~~z~~Z~~~~~uNz~~p~~~T~~m~~g~twl~[~~|e~~~V~{~~w~~~~~^~~~s~e~{_~}`~~~H~~V~~~~&~~~~~~~~s~~~~7~~~~~~~~~~~~o~~~~~o~~~~~~I~~p~~~~~~~~iT~{~|~~~~|~jQ~~l[~~{n~~~Z~~~~~~~~~X~~~~~~~~~j~b~M~~~~~t~E~~~~~~~[~w~~~r~[~~xZ~s~~~~o~~~Q{~~t~~d~|=~g~{~{&~~~~~~~~~~~~~~~~~~~~x}~~~~~~~~~~pw~~}~n~~~~~~k~~~~~~d~Y~~~~~sud~8~~v~~b~k_~t~u{~~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1092/ccs/rev np:i:10 rq:f:0.998561
  AAGCAGTGGTATCAACGCAGAGTACGGGGATCGTGGCCCCAGTCAGTGGATTACGTGACCATGAGTCTGGCTGTTCTTGGTTCACCATTAGCTGTGGTGACAATAACGGGCATTGTGGCAACGATACGTCGTACTGCAAGTCCCACTGTAACTAAGACAATTCGGATTCGACCGATACTTGGTCTGGTTCGTTAACTTCGCGTACCTTCTGCTTTACCAGCAGGTCGTCAACGACGAGCCACCGTAACGAGTGTGGTTTCGGTTCGCTTGGTTGGGTGCCCAATTTCCAGTACCGAAGAGGTAATTGCAACTTCAATTGCTTAGTTGACGTGACCTTTCGGGTGTCATGGACTACCGACGGTATCTCATACGTGACCTCGTTGTTGACCTCGTTCTTCATCTGCACAGACTACAACGTTAGGACTACGGAACCAGTGTGAAGTTGACGGACGCGCTAGTTTACAGATGCGGTTTATTGGATTGGTTACAACGGCAAAGGCGGAGACCACTCCAACTGTCGGAAGAGTACCTCTTCAAATTGCCATTCCAATTGCTCGTCATGGACTTTCCACTCTTAGACGACCCGATGAAGCTAGAAGTCTGACACTGACCATGCTTGTGGCAATCGTTGTTCATGTAGCCACTTTGACTCGACGTTCACGAACATACGATGGTTAGTTCTTCTACTATACTAATGGCTTGTTTTCGCAGAATCTGTATTTAGACGTAACAATGGAAATAATCTTTTTGGACATTGATCTAGATTCTTTAATAATAGGTTTATTTACCAAGTTGACGTTTCACAAGTTGTTTTAAACCGACTTTTTTTTGATGTGTTTGTAGTTATTACAGCTGAAAGATGACGCGTACTAGAGCCGCGGCGTGTCAAACTTTGCATGCCAGTCGCGACAGCGAGTCAGGTTAAGACTAGCCTATGTTAATTTGCACATGCTAACATAAGTCAATAACTTTAACCGGCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTTCCCGTACTCTGCGTTGATACCACTGCTT
  +
  N~_kweAR~y~}~~~u{u~u~|h~~8~~~~~~bg[~$~~x{uy~~y~c~}T~~~w%Q`X~N-DgT_s~L~Y~cP~~T~[yC~~~r~~v~~~~~nnY~hT~~r~^\~~N~~s~d~u|R~~h~tz}Q~~czza_~~eyvY~z}Q~~~~]d~U~~x~~Q{rF~a~mL~~y~~}~V~c~fz~w~D~~~~i~g~o^y~~~~l~x=bg|~s~y~~~h~N~~~o~~_~~]~d~~~~v~pa~~|~{D~~X~fw}~~O~u^zuM~l~~~c~f~~wqV~GhF~G~~~SG~~~~^~~k~~cr~_~|j~zX@~~s~v~R~~~tg~~~~j~f~d~~xg~bLuk~l~E~Z~~~C~~~[m~~~h~gpL~+ih~~U~{z6~y~~F~tvrg~o~y~|R~rt~v~f~i~hu~~j~~~\~~elqT~}~~w~~h~ozw~~S~~~~~~B~Z~q~~gdvi{~~Rs~xg~E~~~|~crw~g?~~~~~f~zT~_~T~~td~d~~N]7~e~e~~~~`~\m~~S~~Q~}hLr~~~~^w<~odz{~M~m~Me_~~p~~~c~ta~~d~ib~~|~q~~~5vlb~~m~~~~U~~~?~~o~~~~~i~~h~~~~g~~|~zf~~h~~~h~~he~Mt~b~~~|~p~~~e~G~y|R~~~~y~}[~}h~~~~l~~h_~~~K~~g~~~~g~~z`~o~~~~~~~C~~n~~N~i~~~n~~X~~l~~~~~~~~u~~6~~_~n6~~~~~~~~V~~~~t~~a~~~m~~r~`~~~~~n~z~~o~~~~Q~~~~\~~~~q~~~~~~~~~l~~d~~L~~p~~~]~^~~~n~~~l~~~yj~W~~~V~~~~~t~qo~p=~~~S~~{~~s~>~~~~~~~k~~q~~N~~~~~~F~~]~~n~~~~~w~~r~Xq~~~~~~~~q~~`~R~pnE~~c~p~~w~~~J~~[~~~uV~~~q~~~~~~~~~~~n[~~p~^~q~p~~~~x~~~~~Y7~x~g~~q~~~~~~~~P~~~~q~p~~v~~y~~q~~~~Q}U~c%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~xxq~~~~~~~nc~>~~~}~~~~q~k~m~~o~~~~~~~~~W~~~s~}~~~~_zz~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1133/ccs/fwd np:i:5 rq:f:0.992966
  AAGCAGTGGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTACCCTCTCTTGATTTTTTACCTATCAATAAACTTACCATCTTTTCATCTACATAATTTGGGAAATCTGAATTAACCTCACCCAGCCGTATTCAATCTTTATGTTCATTCTATTCTTTTTGATGACCTTATACAAGTTTCTCGTCAATTACAGAGGTTGCGGTGGTTTATTGGCCTCATTCATTGAACAAATCCCCACCCCTCCAAAATGGATCACTTAACATATTGCTACTGACCATATTTTGAAATCGAAAAAGAGTTACCTTGTTAGTTCGCAGTTAGCTTGCATTTTCGCTAAATATGGGTGTTTACTTGATGAAATCCAAAGTTCCAGGTTGATTGCCTTCAAAAATACTGTAACAAAGTTTAGTCAAACTTTCTCTCCATCTCGATTTCGGATTGTGATGAATATGAAACGTTAAATTGTGATTTTTTCATTTTCGTCCACCAAACCTTGAAAAGAAACCACGATCACCATCATAAAATCGTCCTATTAAGATTCGGAAATATGAATCTACCACATAATGTTTCACCAAATCCACGTCTGTAAGTGCAATTAAAATTACCTCAACAATTACTACTACAAACCCGAACGTAACCGAATGTAAATGTTGATTCAGTTGTGAAGGATTAAGATTTTGTACCTCCAAACTTCAAACCCTGTTTCCCTGTCTTACCGTACATTTCTTGTAAGTTTAGTGTCTCCCGCTATTTGGATTTGGTAAAGTTAACAGGCTTCGTCTGCGTATATTTATATTAGTTATAGTTTACCTATTTCCTGTATCTCTCCACATAGGCTTGAAACCGAAAATAATATCACTTCTTAAACTGAAGACAACGCGAATATTTCATTTATAGGTCAGTCCAAAACTTTGATGAATTAAAGTACGGACAACTTGTCTCAATGTGTAATCAACACTTCAACTATTGGAACGAGTTTATTATTTGGGTCAATTTTGTATGATATAGTCTCAGGGATCGTCCAACATGAAAACTCGTCGCGTATAATTACTTGGTGTGTTGTCTTATACCTCCATTGACGAATAATCTTACATTTCGATTTCCTTACGTGAATCATCACAAACTTGTTGGATCTCCCTCTAATATCGTCTTCAGATTTGTCCTTTCTCATACGATTGTACATACTGTTGGATGTTCGTTTACTCCATACCACAAGTTATTAGCTGACCACACGTTTTCCTCAACTATCAGAACGTCTGGCAGAACAAAAAGCTCTTAAACTTTTACTACTGAAATGTCATTTACTTTAAAAACTCCTTTTATTAGGACTATATAAAAAACTATCAATGACAGAACAGTCGCGAATAACGTAGTACATCGAACCGAATATAAAGATTTCGACTTTTACTATCTAATCCACTGACTTTTTCCATAACCTATGGCCTCTAAATTCGGTATCCAAGTATTTGCTTCTCCACCCGTACTCTGCGTTGATACCACTGCT
  +
  TxGR`]i.wXP^hS8gS]S^]^]g8P$^djpoebcgmrsssssssssssssrkIH/anhRf9RmV]2vvvvmVB\`^e)L[bBosJIjF)[KL3D^a[S^iSj]T[PLq9iDBuqDociSj\.sWk9Q+QAF^=jqHYBt]g`[vR>u?Q6anMMZWhMB%,;e^UqS;uwwq[4f]^G{Us^iY<INZ,`T0RD[PS6fTUHS]]^PxZvGRLujLv;vO5Vt)GBqF<\P`04AL\6YP6e\_,[^iX4imhQ@x@vyyhNwZ7LYRHt?l:Ki^WW]QPGRY)ZGx^_OJvvqF8vuPR\%tm[Q[I\ZuH&A/WPTr^\FuQFRGEZv^\R7s\RH(shT>H<M4hkg_c/uah\%mTX,HZ\DUZ9afN4a7do\@cFzZ=r[v[IVw\3vItS<xxxxi^RaBe6L;7QkYHrlI\iTHxxRBuuSiSi?SZhQLMEGGvtSPuYVtDLE]i\=XTVW\;deQ]8Q8vpZu]gEF'jlZ[eQI?uwkOFgAJGBjCWa=[Sm[4r^][ExqAaIR]^hPG1oX`SD_?xxu_>\h1ah^UB=L\HGtQ<s;_]Q]J\?vhSf4De[RIgBwd^BuuS^Cn*orf6v[>\iRV^VOxJgHRLqJg1uq_WdI@u`SLuSMv[qZPh]Sg9A2W=-8WFOwS]e<SCp]Pxi]iHxxcZRkRBGpS\B3N[h\9NLsI>iPx]^1wwUGh]FxPCxEv`<TdQ=fY+VWV\&tr8hThYXRZsIBw]hZQ]BusRJq]g.s[Aww]]gGVBX2hnZNNF?lu?[\/r]HUiHxx\HuNmPX9pP1\R]iSj[<EfD`]Eut]O]Wu_W$ZIT0?@qlJAae_Auk3vOZO^dRfQP0QTKCHUNvS[v]7r`CwF5xyrbGXPWXQEQ[vS[vDnYPi]Px\IQ@g>\S]:bPZFhA;I5\s]iJLtZSI\d2a2^`^SJubY^i]*50tGvx]iZP?]G=OlTTw]g>gR<_gY%8%HZg=>rS^SXtO0lQcUDuMv?uS]^]Buu^[v^$pGGxxf;@j=lveHZ0b0?HYa?ESRiNA1dj^iRYY.TIY<]i]AyyqQCQ\POIQZMBM>q;d]S[vL\;Z`GF\[eT[u^cEBueBe]Hu[IR]FpFMxfTSv^S_RvvS]^Qv[%sIpF=\i\BwhS^f.7C,Qj8Fs\JuNqW'2Z%TZ^O58Z]Ba>\iSZu>[^]HwU0d3vAsiQ_76EH+TYEcCNEMDgWQfHYmNw]M]ZvS\3taFRiDy\PG>V<-'m\XsVXsV\O]F\F`]PB3@<UWUB@FK9gShIf>]VNwS]iQPKvCPXB[@:_txtZOPQEp9vvSKvvv[;eIRbUFyrP\g?\HalISBus)BBfZSi@a2tvgXDpTNw^RP\i]h1tu[QL8LQ_S&hc\IP4[?tQI]g?\S]KaZ;WOZi^]h[>IN<D9K5cLNmiYXGxx]^EifMYXS;ile6OP\e=aNaiDy^SgEHB9Zqv@%rY`GjFyf^iNvB[CMa8ip[vSNtXFJCt>]Yi]9c3/;FoPN%r\=fvYXGOYSa0ODZt]Ih^0PH>`CR{
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1133/ccs/rev np:i:5 rq:f:0.992852
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTACCCTCTCTTGATTTTTTACCTATCAATAAACTTACCATCTTTTCATCTACATAATTTGGGAAATCTGAATTAACCTCACCCAGCCGTATTCAATCTTTATGTTCATCTATTCTTTTTGATGACCTTATACAAGTTTCTCGTCAATTACAGAGGTTGCGGTGGTTTATTGCCTCATTCATTGAACAAATCCCCACCCCTCCAAAATGGGATCACTTAACATATTGCTACTGACCATATTTTGAAATCGAAAAAGAGTTACCTGTTAGTTTCGCAGTTAGCTTGCATTTTCGCTAAATATGGGTGTTTACTTGATGAAATCCAAAGTTTCCAGGTTGATTGCCTTCAAAAATTACTGTAACAAAGTTTAGTCAAACTTTCTCTCCATCTCGATTTTCGGATTGTGATGAATATGAAACGTTAAATTTGTGATTTTTTCATTTTCGTCCACCAAACCTTGAAAAGAAACCACGATCCACCATCATAAAATCGTCTATTAAGATTCGGAAATATGAATCTACCACATAATGTTTCACCAAATCCACGTCTGTAAGTGCAATTAAAATTACCTCAACAATTACTACTACAAACCCGAACGTAACCGAATGTAAATGTTGATTCAGTTGTGAAGGATTAAGATTTTGTACCTCCAAACTTCAAACCCTGTTTCCCTGTCTTACCGTACATTTCTTGTAAGTTTAGTGTCTCCCGCTATTTGGATTTGGTAAAGTTAACAGGCTTCGTCTGCGTATATTTATATTAGTTATAGTTTACCTATTTCCTGTATCTCTCCACATAGGCTTGAAACCGAAAATAATATCACTTCTTAAACTGAAGACAACGCGAATATTTCATTTATAGGGTCAGTCCAAAACTTTGATGATTAAAGTACGGACAACTTGTCTCAATGTGTTAATCAACACTTCAACTATTGGAACGAGTTATTATTTGGGTCAATTTTGTATGATATAGTCTCAGGGATCGTCAACATGAAAACTCGTCGCGTATAATTACTTGGTGTGTTGTCTTATACCTCCATTGACGAATAATCTTACATTTCGATTTCCTTACGTGAATCATCACAAAACTTGTTGGACTCCCTCTAATATCGTCTTCAGATTGTCCTTTCTCATACGATTGTACATACTGTTGGATGTTCGTTTACTCCATAACCACAAGTTATTAGCTGACCACACGTTTTCCTCAACTATCAGAACGTCTGGCAGAACAAAAAGCTCTTAAACTTTTACTACTGAAATGTCATTTACTTTAAAAACTCCTTTTATTAGGACTATATAAAAAACTATCATGACAGAACAGTCGCGAATAAACGTAGTACATCGAACCGAATATAAAGATTTCGACTTTTACTATCTAATCCACTGACTTTTTCCATAACCTATGGCCTCTAAATTCGGTATCCAAGTATTTGCTTCTCCACCCGTACTCTGCGTTTGATACCACTGCT
  +
  ]hKS]KT@a?Z?RKiR6=TI,=>\P$D?KSPLKMQVVVX]dffffed[QKKX\4j`SR?R9gKU(gggfJ=Ea(;QSKeS;fSJD\D2N<>R+gfOH]TSRD<X*Pf=SU9g\:fc87RKMPBbKT5MFEI-sXPQNwS]O>u\Kw\-%bVeYSM`FaIYWaInX+tusUOiLROOa0meD]YTr?:hXCG\S^EBqJqi]g=NEkOmQG@k^DxEwuKLbR8kADeLWY`LU<WtF?s_]@wvgM1ciQS9a=vra\%]/1RX[KMuS5ZCHDITSHCZ]^SiOqH5`'psmMHPE1Y<9`YF]QeS'ce:X.J9Sb<*@GY;?1:NrN:[QxS]i5vvv]S]^(M@IXQ1XKY*CgecY=WPY/AK\\IKo2Wl=,SB5FG9\1mCf5LPN\=s\3vvvo$79RPBDNQB'VB?Gsxg>\]BuuG7okV_VUMri]\\DQh.XYY\Dyh=hOY:F[QRR^hI;GtpVRPwBus)sYQXQh1wwwwu]h3Wjv\PFLVg>sBuu=n&=>=hvY?<tgKXi]RdF-SN:sh^]i^EubRLNOWBUg@rKuTW9n[%s8ebWdXSPJ0Z[g;sh]i^[v\*@mc;J6k8uo];_TLN4ZIR]Ds6CDXGt>u@uwnLtPMvI\Xx]Zq9f`CSfEGh]Buo4ttRVw]S^Tx*VS[v^S^RvvY;>QPiNqViR1MPFPRq@xc>pV`Se7beU=GcKs^NvBuu]MYFNWoEvv\S9dhBqv_S^]PxfNpQXP[e8s]Y7VMWZsS7wvfPY)E\^@vlS]^h,ViBii8x^As^RvvSPxHu\h6yZKaGQI\^Q\PWcYIC]YgGM>uhTOxbFhSExY7Lv^iFyrNw^S[Q[]^Z`Lb6YJ^eCtF/sRQvvNwS>uuuYVt^dH\i]<nS.sHtv\GQUj>g]DrQ=DOUn\P8bmTc'^fCUV2ds]]iT^Nw.wxf]3cMJU]6\+k>otR7g^G|i]Sx^PuRK\^][vR?WS:^Hu]\@U\i\Bw\Hu\^iPxGyUt]SiR'sWCwiGgb<xxZ][v&VgTSBgIQHMi^g>\\I\i;|{c^]T^^Sq]e\<9HZp[\]S]JQD,YeITR>uO[PvCe::K>2lNZ1(i%6<Ku^@te?JSj]R1sVWqI\Pxi\O'qi/Ma7dOKk>_h]S^S[uI\hESgF%rs]]McP:I3s7[\/qa\E2Yt^hH]R]]KjQRRf+P:YNv8ZL7^]i^eVRiItT[eVcDg]]@:YDxi[T?u]S9^^PPI3^N\%R<zi][vRMYKJuPQ\4Pc;rPYZ\@8euoLqETXx]^hI\g>UqT=\]^Bw]fRMuG0uuuZ>[I[<VHuw]@gvxi]\PZ4@5gZJ*I]h/[ZO[9vr:tvvt]]Nu5vs`WHiR3sg]_hIg].tuuu^BRP\^gOAOJO>YuFgRI\>Z?Bh[&p^]PEe>X7Zi]FO2bNm@)G\QG5[_Sh+tt\RdT8a`P<\YXI\_StU=a1WJRO]:qeamJjR@Ei>r_fH4uMu^]^HXoPx]Dy\P]OyYq<Wg8uvR]OvA9C[dCtvS^iYU]]BN?'CUSD^iNwi]HN\g
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1199/ccs/fwd np:i:10 rq:f:0.999121
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAGTAAGACTGTATCGGAGACGACTTTTTAATAGTAGTAATTCTCGGTACAACTAAACCAGTAATTTCAGACACTGAAATAGAGGACTTCGTTAGGTACGAAGCAAGTTAACTAAATGACAATTAAATTGAGGGTAAATATCACAAAGAAATCATGGAAGATTTCGACCGAATACAGGAAAATTTAGATTAAAGGTTTGTCGTCGTTGAAATAAGAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGTAACAATGTAATGGAAATTGGCGATGACTATGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAGTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTCTAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ~~~O~~~z~~~~R@~zv~~~~~~z~S~~~~/bdh~i~{x~~V<~p~~~~co}~v~s]~`~~~~Hk~e~n~i~v~b~~~~av~c|~~~S~~~V~~{~~]~j~sik~~n6~z~?c~~~~m~~jn~~~~y~^~Co~~~X~~aj]~~~jx~~kwkvd~~$~w|~~~~By~m}~~@~~zz~w~~~E~~i~~~~V~h~~~~w}x~}~~5~~zj~~~~h~~~z]~Jm~y~Q~~~m~~~~W~^~~~~Y~~~s~~~@~~~z{~~ng~~~U~~~~~~hy~p~~~~e~~Y~~r~~uD~~s~~Xw~~m{~{~x~~~{~W~~~z~~~@~~~~~m~~n~~~6xh~o{d~b~~x~~n~~yc~~~zS~~~A~U~y|~~L~~]~~v~~S~~yx~~c~~~~~~l~~~~~~:~~~~y~k~~~y~c~B~~~}~~P~~~~c~x|`~Y~~~oo~~~~~~ek;~~~~l~~~z~R~~Y~r~k~gx~~Lxc~~~F~~d~~~~}~L~~q~~~~~~~~o~~~~~~z~~o~~~zv~~m~Dpy~S~amk~~~~\~{~E~~~~~~\~s~L~~~~~un~~~U~~~~~~~uf~~~d~~~t~~]~^~~~P~~~~~N~~~~~~y~~~E~~~f~~p~~~~f~~~~c~~~~~~~~~~~~U~~~q~~g~~w~~~~D~~~q~~~~~~~F~~D~z,~~~~~~d~wo]ld~~~{~~r~~~~~~~~~~~~~~e~{V~z~n~~V~~^~~d~~f~T~~~c~~v~~v~~pbr~m~~~s~~~~~~5~~rl~f~~v~~^~x~v~]~~z~~~~C~~x~~~~~k~~~\\~~or~~~R~~O~~~u~~,~{~~T~~~|r~~~~d~~~~p~~~^v~sx~~~:~~dM~~~~~~u~~^X~}~~~a~v~b~~R~~~~~U~t~vt~~~x~~~o~~~L~~~~x~~~~~s~~[~~~~f~~~|~|~r~~~~x~j~~q~~t~~W~~~s~~g~~~z~~~~N~~w~~vq~~v~~~~~o~c~H~~~~~~~~@~~~~OeK~~~~~c~W~n~]~e~>~~ui~~~K~~i>mX~5~~~z~w~~~~~x~^~~~~~rV~\~~~~~~X~~~~~<~~p~~~~a~~~~~~~~b~~~p~~~~U~~~~~xn~~~b~~c~~~~_~~~~j~a~~x~~~~O~~~t~~<~~~]s~~C~~p`m`s~w~~t~~~O~~~lu~m~|~~uZ~~~t~~~~u~p~~x~~d~~~~f~~k~~~\~t~~~~i~~~~<~&~~~~~~~~~~~~~~[KKf~~~~~~~~~~~~tu~X~~~~~~~rb~vo~kv~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1199/ccs/rev np:i:10 rq:f:0.998641
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTTGAAAAAGTAATAGTGCAAATAAGAAAGTAAGACTGTATCGGAGACGACTTTTTAATAGTAGTAATTCTCGGTACAACTAAACCAGTAATTTCAGACACTGAAATAGAGGACTTCGTTAGGTACGAAGCAAGTTAACTAAATGACAATTAAATTGAGGGTAAATATCACAAAGAAATCATGGAAGATTTCGACCGAATACAGGAAAATTTAGATTAAAGGTTTGTCGTCGTTGAAATAAGAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAGTTAAGTAATTGGCATCGCGCGGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTCTAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  u~~`S{o\~y~gy|~lxL~:eyc~`2~~~wlwh~lM~~Z~~y~~~~~~'|a~Xm~k~~X~~`q~l~k~~r~~>~~~~y~~r~~l~_~w~~~]~~~~~~~~b~~~y~~}~ja~uq~~~~v\~^~~~[X~T]~l~~t~}LQk~v~~~a~~~q~~J~~J~~~~~~~s~~q~~[~~~~~L~~~f~s_~~~~~~H~~|z~~Kt~x~K~~~~zu~T~~S~~O~~~~~~J~~~~t~vu~\]~o~~u~~~s~~hp~~~~1|m'|~su^~~s`~w~~~~~~]~~~~_~~~~~^p~bs~~~o~2~Q~z8R~~~x~>~~~k~o\`~~~w~m~vl~~~d\T~~ki~u~~T~~~~~~~~~~~~~y~~~~~~i~~R~~p~~~~v~~~xt~~c~~~kqpj~t~6~cW?~~~j~~Y~~~rko~i~~~~~~Y~~~vk~x~k~w~~u~J~xp~~Z~~3~~~~~~~~~i~y~~~o~~~~@~X~~p~n~J~~M~~uqS~c~~~~n~}~~yyS~~~~~~S~v~^~e\[~~P~~~ku~~n~~~vj~I~l~c~~~tx{~~~~C~~c~]~O~~~O~~~~m~~~`~~~>~~|~~xE~V~~~P~~~K~q~\k~~~z~_~P~~~S~~~~iX~d~~_~E~~q[~~q~kq~~v~~~p~e~~~~~~W_f~~|\~k~a~~yr~~~~~R~~~~~~~~~~r~V~~~u~h~O~~~yq~s~x~u~~t~~e~~`s~~]~~~~~p~~g~\~~~~~~t~~~~~~~p~o~~~~~n@,~~[~~~u~)~~B~~~~~~~e~[~~~~~^v~~H~~~~~F~~~~`~~~w~l~|~~~~U~~KY:~~b~~K~_w~m~~q~s~~`~V~~m~~w~~z~~C~~~d~~~b~~~~~~~~~~i~o~~uf~~F~~nkm~~muv~un~f~|u~~f~S~ip)lu~w~/^Q~~~~]~~W~~~~vn~~w~~~A~~~~~~~~~ze~~~~~~o~~~O~k~~M~~~q~~~~~f~~~~mtrO~'~~~~kh~~uF~~onn~b~~[~xI~~~~~w~~~q~~]G~~rU~`~~~:~4~~~O~~N~~~~Y~d~~w^~~~~L~p_~~JT~~~~v`~dc~`~~8~~|]~u~t~v~h]~~~Ks~~]O~~G~<bvn~j~~^~R~~~~~~Z~~Q~~~wV~~~l~~B~~~~j~~T~~u~b~~~o~~v~~^K~~~~p~e~~Wuja~~u/~o~~~~]~~>gk~~X~~bp~~~~~v~a~~Q~w~~~q~~&~~~~~~~~~~~~~~~~~~~~~~~~~~~~4~~~~~~~`\~u~~~P~~~`~m~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1216/ccs/fwd np:i:11 rq:f:0.995676
  AAGCAGTGGTATCAACGCAGAGTACGGGGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTACCGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTCTTGTAATTATGGTGGTCGATTTATTGGTAGTATATTTTGGAAATAGCATGCAATTTTGGAATGGACGAAGAACCTGACATCTGAGCTATTGTAAGTTTAATTTACCATTTCGTCATTGTATATGCGGTAAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATGGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  x~}hujte~~H'<&bYWfsS~T~~g<~pt`bnY,~~~~NKmP]eQD:`G`eN~{~v~A~]>_I~li~zlc^iI~~~gsF~zQL~~wQk~Kpybq`r$R[`lfe=~dH~x[qW}YaKueNrIU~~qtOerQ~T~FpK~yd=ZvJk~=3_i;w~r;Bm[c~Qm@]f~Z~f~h~B~~M~cX/~~~h~~Ki~]m~pvDpF~q`~zRC`y~Y~iF~~~p@WU}idB~~2Om8=Y)rBEr$~sccIdL\G^NFpZn;aVo~kj=~~~D~X~lklAxPHusfg^dZmx~i^PB~eaf?MevYFS~~Z~VNw>F]aks~~'~~m~m~c~~U~~m~6~o|~j~~8~~hXZijT~~~0~~^\n~~~B~ziGfW~~~m8k~g$@A]t>hB9~L~ch~Mt~ghj~}F~Hdg~p~~q}2vTx~R~W~UN}=sj*aBdkjd~W~s~~n~3n4~zJ~uj[~j~~~~qfWmm~~p~Q~~~~l0~OO@~l~b~W~UjP]o~qh~~mk~~T%~qiL~RvV~~l~~|kk~s~[`c~olgo~he~~g~;fgmij~q~@~w\j\~o~nDL1Yr[]_~dJ~~_lg~g>~~\~j3mxV8NYP~u@~xax~{zUw:~~zZ~STNWP~K~~c`1cSsex-~jP~vQ~h~T~~TI~~od4~xMV~h?nfIZ~{XO~}a~j~rOV}c3>mcw~~~Eqo~aEo~f`U<~|f[~SL~~V~~.9zw]S~V~5k~hV^V~~~~~ob:~~bSfT~ZB`~~UXr~i|d~jk3n~CR~E{y_~hzY~l~WjAsbNb[AY[O~KSui~x~zA~~f~k~~|mC~~iI~k&~~q~`cUs}I^~STIarZ`~~E~~~~~T~|VSA{~R(p-,qk~liHx~P~]G~~hCCoZ~ji^[@i`O;wb~~zZ}]4\]~FYtn~o~k1~~~@~~J~~H~aGgZT~Z~X~u~_m.e|m~~4j~H~~~n~`~j~vj]f8.X|_d~d~~a~mN~cxDEo6~b_V~k~~Z~~Y[Z~ZH~V~ka~l~~l~~~pih~JYbsfO^?|~f~N~~~W~fQ~~o~~fUZ~o~[z@WtI^~~%`_hl~~U~vNt~ykol~~~~le`k\iU~oP~~Y~~Z~}yjTrenC~~~V}NE~RxRO~K~~V~ZN~zm~d~ef~^~~i~M~ij~~~~nyhxJ~'~~~~}x~~~~~~}qmv~~~~~}|soq~~~}w~~]~k~~Zsl~~xy~CaQV~~q~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1216/ccs/rev np:i:12 rq:f:0.997646
  AGCAGTGGTATCAACGCAGAGTACGGGGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAACACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTCTTGTAATTATGGTGGTCGATTTATTGGTAGTATATTTGGAAATAGCATGCAATTTTGGAATGGACGAAGAACCTGACATCTGAGCTATTGTAAGTTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTCGGGTAACAATGTAATGGAAATTGGCGATGACTATGGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  'N~|ixI~hW~~\~}_K~Wap~~~'wN^yD^j'~~e`zWSyy~h~cg8|}_~Q~PjK~~SSG}~ks~~Mu~I~~m~~f~~_-uxy|\i~;~rb~q~Y~~j~YU~h~~Xb~=~r|I~mi}mU~ToFiDLa[~~`]W~`4n~~>~kQQ~~B~~kp~]yiiZl^~p~]Tp~KmY~~D|nRB~~~Go\iFL_cLo~`iZ~Zr~o_:~~.JcOytss~rosoW~~^~[Rcw~`~~[ts~Q~~u~m~mA\~m~jYo~n~nr~ZH~~~>PMe~~ZT~YbO~~~osgIem`vhPzzgkBt{uk6\P~~B~~~\~usvtx~_G~~{~~nW~~z~~c~n~p{]W~nk~~`~dp~n^jFm{k=tV{^A1~\abw~~~~ue~~~~mptTF}H~c~p~~s~m~~^}[M~Vki~@~h~~[~~S{O~n~sE~N~~Y~~~ltY~is[kns~~l^~|H}t]3~_~~gNqq{\mr[~m\~qs|N=~Guh~~~X~`~kgSIJrm_~CY\~D0-q}~l~rRok]mgY}`L~ZYkd|wfvmiihC~ByRC~~~~~~C~~k~LtON~Y~Yu~of~]T~Ud~a]mgRiM~~S~pc~~]~~F~~O@}Z[~~_qz~H~~~|~~M~a,~=~~o]X~h~d_}~~:aa~~~pK~~~zu~u8~b~v7~XK{r~~~~OZ~~~`I}bcq~P\b~~~`~O~`~eSqf~~~uc~~{}~cpXoE~~BA~vgQ~R8,}~ud~^~}w]j~_P~w~_~b~pQ~`~Lm4VLl\3|MeJ_wPl~ej~_~~u{ru~~mt~bd~eIy~k~~Q~g~S~^~~~K~^mVuMd~tgu~QM~~~~m~o~T~Ztv~_~p:e~Q&~~~~CL|Vr^f~~zH~~o`~x'[~rj~~D~~~`k|x~z~omM~~~RU>y~~ZV~_`|~swmh~@thIk~qN~i4~~W~~Epr[Ut~X~Sn~FC~aK~~~t~_~~~a~L~~~TWz~~A~~K~Nl~~~a~b~l~~~d~~~P~S}~R~~~d4ypk~k~~^~sr^q|q~;~~~r~?~r~gE~~r~T~~~h~rN~w3p~t~`~]gjr~da'1X~M~~|ps1xise~~~~~`]_VuV~{~j`>~t3``p~eP~~~~r~~_\~~ke~~i~b~`<p,-~stA~~~~~eTr~tC~l~~ms)~6H~u:~u~~rC~'~~~~~~~~~~~~~~~~~~~~~~~~~~~~aYNjs~~~w~qB~Y~q~i~~s~Np^]
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1226/ccs/fwd np:i:5 rq:f:0.991432
  AACAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTCCAATCTGGCAGATTAGATACAGCTATAGAGCGAATCACCACGTCTCCTAGATAACTGGCAAATCTTCACATTTACGCAAGACCATAGAATAGTCCATAAGCAACATATTGCCGCATCGACCAAATCATGGCTTTGCACCTCCCAACTTGCCTGAATCGTGTCAGACTATAGCGGGACGTTCGACCCATACTACTCATTCGATTACGCATTCACCTGACGAGAATAGCCATTCTTCCTGAACATACGTTAGAAGTAGTTGGTTAATGCTTGTCTACATTTGAGTGCGAAGCCACTAGGTTTGCCACTGTTGACCACTCAGCACGCAATCTGCAAGATACGCAGTAATGCTAAACCATACTATTTGACTTTGATGTTCTATCACTGGGTTAATGCCTGCTGCTACCTGACTTTTAGTCGCGAGCACAACGCTTCTTGCTACACATATGCTGTTGGAATGTTTTTACACTTATTATGCATAGAATACCCACTCCACAGCTATTCGAATGACTCTAATACATCTTGCAACGTTGGACGACCGTAGTACGCATTCAGTCCGAGTACAAGATAATGCCTTTCTTCTGGCCACTCGTCTAACTTCGTCGGCTCAGTGAACAAGCATTCTTCCTACTAGGCCATGGCGTCTACCGCTTCTTACATGGTAACCAAATCTTTGTTAACCACCACTTCTATAACCTCGTTCTAAGGCCTACGTGAAACCCGAACCGAACTCAGCCTTCTTTCAAAGCTGGGTCTGATACGTGCTCTACAAGTGCCGTAATCCATCTTTAGTTACAGTACTGACCACCGCCATAGGGAGCACCAGCATAATGACTTTAGAAACCATTATTGAGTAGTCCTTTTTGCAGTGATCCGTGCTTCCTTCTTTTGCGTTTTAACGCTACTTCAATTACCTACCATAATTATTTTGCCGCCAAGTTGTCGCCAACCAAAGCGTTTTCTACATCGTTTCTTTAATTGCAAGAACGGATGTGGAATCCGCCGTATGAAACGTAGATTCTAGTTGAAACGTTAATAGTTGCCGTTGGATTGATATTTCTCCTCAATCGTATTAACCGTTTCTTCTTTGTTTATCTTTGTCGGCTTCTTTGAGTTCAGCTATTCTTTCCACGGTAAACCAGACTAAACCACGTCTAATTTCTGACCCAACTACTGGTCTATACTTCATGCTCATGAGTGCCAGTGACAACTTACGTTTGTTACCTCCGCCGAATGGTAATTGTTACTTGAGCACGGCTAGAAACGTTAACAACTTTCTTGCACAACTCTCACATGACTAACTCCCACAACTTGCATTTGATAAACGTTCAAAGCTAGGACATTTTCATGACTAGCGCTGAGCAAGAGACTAGTTCGACGTGCATAGGAGTTTCTGCATTGAATTCCTTTCAAGAATGTCTTGTGTCGACGTCGTCGTGCAGTAGGTCTAAATCCAGCGAATGATTTGTTTTGGCTTGTTCCGATGTAACGACTAGCATTACGATCGACCCAACCATTTCTTGCAGCGCAGTCAAAAGTACGTTCCACCCATGTTTACGCTAACCATCCACTGTGTATGTAGATCACAATGACGTTGTCGTTTGCTTTAACATTGTCTCAACTAACGTTCATAGCGTTGAGGTGGACGTCTTCAATGAAAAAGTAGACAACCACTACATGACTTCAAATGGGGAAGAGACATGACTGTCTAGGACATTCGTCGTCTACTGGATGAACCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  J>(-2REpTOYP<NQQ@SO@OWE3$jZOTZWWWWZ^ZTQRTTROMKKMRO94C4HQK>7>8OO@7N)@W9I8IN?:4IUL[HQQ>]2AJ1RNJ4QPQCK'=JFQ:ILK3G;<TUB*;V;CD$*X[ZNK4+B:D,7+QEIDOKB3B/^*=-PPQBT?0./@XIDWC77A052-I;A0@H3G=U6,UJCE?+?G2YT=C-&;/3MD'/KJH<S;B*MLA<BFFB8;=SRZPO3YOPD%OTW>+9TEPR8ZIjPHCCd3<9K;7LOEDlYRW&LBP9RJEO4fVIYJ7O5WBPCR7SJO:I8QDO<T<N/PIZ4gJYKiNO;GUQTIQ0N[CnhKW8:NM,6%:/2FGC2)7-:@>'AA1R*>PQ<2V706=YUQ\O?Q?UOB'ED1VD61P@+(48QNXX;@=,;:82?F7F*Q.<3OARA^T=+A<3HCLJVRKTW:[C.W1FXSEZZ?S\UTXX=QCAGM9jkk_SDCPSTV;>NO5XPTTJVLFH)JT2BH=ENARI,@:5L7V+SHL(WYNI.9>M>?R?[^[=7*:45DQME,P--@H(XWK1F3@OH\G-+(NOIC;CTDEI@9J;HBR9MHF8+@Z<VJM=3)HJTN;R^S>PHPqUX>B:WT_SBF;AT>HB0OJA8149*9-U:A1)2=>:WO<W@ZCY<9YRTHM6[NRUMO7PDSRBR)0P9QGIS9VPOFOQ9B/APV;RO@WOW:;PE@ET4FWST\QBXX5SFW6TQSKDYYQ>W@a4<92VC56TMDBC1?4OBKOIOU\.>6mH[V_UUZ>=e:-F<L,CDkOLSAU@\?G]8XOA]YADOUR8Q-HaUU\UZNOSQARP-MQDHRoU\UIqUZ.KNH]VXOCr[?I>RNKRUZZDDSZFW_IoUHp^Y6*WKIR/J=r_UU]UE`ZT]OFnq_T-lkES_Ns_NqU_U\\U\Hp-oqq\UU_QSU[+<<U\UU1R7[MjS4hWH;O>+Wi\KhOTO@4RQqSI.MlU2eD]GpHY=B:?71kpN?ChO&jNSSMpTYA?:TIF?E8_JHUUAqaKMAQ=XRUT:poS7V`/jMpTN<RG@LRHrI[U\HpD3S<YQ)90<>;N3PYUU\_UY>k@DWQKNR7J5TUNjNSDYOJXQ1IDF`Bb/2DH.YL8DQVSCD\LBbPL[`>PUJeMjZ?\fGCu[M_]ELoycH??JaPVZQhM4IO.L\^k^FLQYVNf\NjN8oVCe1P?kV'`65^IV]:b4``IuRTY`Z[NvLlnI__a4L4+YVYEVJ,+22TF1<N'TVTaQ]X]O.LgNdL4C9[f[P\F`]X~k^*9~p^UcT/Q1*9:Nb]Dr\LheIbDSIFTcG3LLaD]iQMtNde],aVRNJ^=aG7]T6gQ@WrD[KTQlLQUKXcIWh\<B:4RSK0JnF>J|]J~^^aGXl[kgN~rC\ErV,]j^Y`a<~QGU:NRc<0O)5FO[QWWU[BYM_ScDWN_G``PWjZ7ERSe<V_NHAdFIKwe0bI[VJiEShWkJa?ddU8\Y6^b[f^BbKa[cXHaSBH)XPVDKW1TCVXHO]YV3kbS;Sj_^YBaQVWEmjL@knlMl[X|^EY<pXHZYKNZYZQHZ9I]gBp_G._c-XQFw^3h@pB=aZEAgG?[\\F\j^eM+F_=:JRY\XhDb-&TR]?XBQ`=XPULNdJfJ\*TaDf_b[g^QW_a]Q<SL3:Wf_k_^Bv^bH]Q~~^^JUlJkISVd0bIf]J~ZJCxZ]D~]hJKBXSIt]iO~gFV:]]NZR_[\~h_5~o_g_ik_f[ZyI^DU^j\=cHQLFiRIgbPB~~~Nz^eZT\Tf_U^h_fIdUO~XGP&=J[b@W_@Y?W_9ddg_Uu8v~~~^eeIc[f[RYZ~\7\d;P4]fH]_~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1226/ccs/rev np:i:6 rq:f:0.992886
  AACGCATGGTATCACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCCAATCTGGCAGATTAGATACAGCTATAGAGCGAATCACACGTCTCCTTAGATAACTGGCAAATCTTCACAATTACGCAAGACCAATAGAATAGTCCTAAGCAACATTTGCCGCATCGACCAAATCATGGCTTTGCACTCCAACTTTGCCTGAATCCGTGTCAGACTATAGCGGACGTTCGACCATACTACTCATTCGATTACGCATTCACCTGACGAGAATAGCCATTCTTCCTGAACATACGTTAGAAGTAGTTTGGTAATGCTTGTCTACATTGGAGTGCGAAGCCACTAGGTTTGCACTGTTGACCACCAGCACGCAATCGCAAGATACGCAGTAATGCTAAACCATACTTATTTGACTTTGATGTTCTATCACTGGGTTAATGCCTGCTGCTACCTGACTTTTAGTCGCGAGCACAACGCTTCTTGGCTACACATATGCTGTTGGGAATGTTTTTTACACTTATTATGCTATAAATTACCACTCCCACACTATTCGAATGACTCTAATACATCTTGCAACTTGGACGACCGTAGTACGCATTCAGTCCGAGTACCAAGATAATGCTCTTTCTTCTGCCACTCGTCTAACTTCGTCGGGCTCAGTGAACAGCATTCTTCCTACTAGGCCATGGCGTCTACCGCTTCTTACATGGTAACCAAATCTTTGTTAACCACTTCTATACCTCGTTCTAGGCCTACGTGAAACCCGAACCGAACTCAGCCTTCTTTCAAGCTGGGTCTGATACGTGCTCTACAAGTGCCGTAATCCATCTTTAGTTACAGTACTGACCACCGCCATAGGAGCACCAGCATAATGACTTTAGAAAACCATTATTGAGTAGTCCTTTTTGCAGTGATCCGTGCTTCCTTCTTTTTGCGTTTTAACGCTACTTCAATTACCTACCATATTATTTTGCCGCCCAAGTTGTCGCCCAACCAAAGCGTTTTCTACATCGTTTCTTTAATTGCAAGAACGGATGTGGATCCGCGTATGAAACGTAGATTCTAGTTGAACGTTAATAGTTGCCGTTGGATTGAATATTTCTCCTCAATCGTATTAACCGTTTCTTCTTTGTTTATCTTTGTCGGCTTCTTTGAGTTCAGCTATTCTTTCCACGGTAACCAGACTAAACCACGTCTAATTTCTGACCCCAACTACTGGTCTAACTTCATGCTCATGAGTGCAGTGACAACTTACGTTTGTTACCGCCGAATGGTAATTGTTACTGAGCACGGCTAGAACGTTAACACTTTCTTGCACAACTCTCACATGACTAACTCCCACAACTTGCATTTGATAAACGTTCAAAGCTAGGACATTTTCATGGACTAGCGCTGAGCAAGAGACTAGTTCGACGTGCATAGGAGTTTCTGCATTGAATTCCTTTCAAGAATGTCTTGTGTCGACGTCGTCGTGCAGTAGGTCTAAATCCAGCGAATGATTTGTTTTGGCTTGTTCCGATGTAACGACTAGCATTACGATCGACCCAACCATTTCTTGCAGCGCAGTCAAAGTACGTTCCACCATGTTTACGCTAACCATCCACTGTGTATGTAGATCACAATGACGTTGTCGTTTGCTTTAACATTGTCTCAACTAACGTTCATAGCGTTGAGGTGGACGTCTTCAATGAAAAAGTAGACACCACTACATGACTTCAAATGGGGAAGAGACATGACTGTCTAGGACATCGTCGTCTACTGGATGAACCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  $1:D9;$9VGQdY3/Y[[RJNF[V$V[]_^][YTLDBELXbkrme`]]^]WC7)*NSeKQ<KlJ^PLW{aDZ;a[cD;>4NMV\XZW@I[>BA]DW;XLHmA_P?8]3jYJ9dZCqR8?LcVcX,OGsaC>YR\Xa?p$&9YU@VaMNJLaWTeUY3yY]51NUIgRRDUNAZIl6acLB[^JyZI``Q*[Wd;i?^Y/nZPH^dE;ma%TYSY`@_G]JR_;EFL(a[LQG`XD`DoYJIVaWUCV`Ek[V^CJPCVRM?<C`<]MDcXDTKBfUK:JhaCZX<N8RKZQ{WZfaZC9[HX>_ZgcY2t[KT&(IdYPIeEe[eKYb$Z'F\VXU@CAqY7M\@LZ6G,MK=X_<MI=dSQEb[BaPUQ;>4.JXRFTXRiM\A_NOL]VRFh_RK?5OR?gab3WLc`;^]YbMAcaHSXF;UZLAbYaA[?b>IiHl\X=P)XYARYN]F^eC_43\KQ_Y;X\Y[d[YGURqFXDDrB$l7ODaNRM<LP]][\gZGs8j^C{fZ,zm]nP3WcZTxDNd`g[[gdgG^l3IIM}d[g.~ldZU&gdUaM[N_1BaWZTF>\XEXJ_ET~JMPSF=d=lkcOmV~c`cdsiO_akW_3``RCM5>\.e>~\~]?jH|Yc^o\6peOMq[`a3MCRWcbjK^DrX'E]ee5%XddmOmc]]8mZ&Z=eZq`Fn;yon_jbLmQxLCLa>Ml]qU@xaaNo]JihemoOrjFuNoQonmdS~d^7k9p8h[=2lLScAH/NgLd_~dYnF~L~loN`o7Ij|H~xVK~C~c^~^R[mN?gK`a8mlK.~_EN3zUAXbVY1X_;I@cpc_RNEmY[cKpOk<v\U~nZJ.i{mdC~e*SNXj\qNlTy>$HK8VVEW*x4E_e>Obdcmd7peb\a;kudc1yvL=s[>odGjPi`XjaaPm2eooraaod]dnr=k^seSP~R~[|b;{~~|dcFAjqnI~]]`SO]\rcHp-rnF}SYBl?S$.LM6VmfY=}^,qwPvZTkJE=^(V[YnAd:jtbM`=nY\^PV`kabS:uzdB~qQyAybNL~a*tSJlhZAN6;*a(NY\_PijHQ{yOc\]_TSe``edQ~a(~be`~;wqW]=qbS~`;~3gZ,=7XmmZ0]jZbQpkNFmD\DOR&fMpM~d;{mQ?]D:an_7xi[Rc?phNaYNr`IrPAwcLJTXhaZ>JchDl[5~~T~l_Ak]PpIqnQhdmB~~S~obIL9^G~Km{cmNk)~~@9~c`neqPyBbp:~cWxPmseescWZaXRcTNmbB`Cb^~fa~ocOE~fbN~VU~Y*~aZmES~rJ~:H:-hmfqLhIcmNOs$SkdO~ddIlCg`idF~~dL~McmN_~bqdqeoeoqMVcmH~dn;~]MG8~cAgPcn>~zaSiR~~d`(c]R~{Ob]l/~Sdm.vpA8mrD~lOqpeeees`SaN]~_mJQcppc=nbNmeeseelnkT~o`2g~Lqeb>_~^H~*c?oClncM~`[nm`gVLp`kcDKLmecn_MoMOILKS`mg>lmMkQ~~sQ~>_cNZo^WL3~`H3aymMwc=naXoKzdTRcmEe_8iX[^Q`hL~e`]SBaOm6~p_~V~oQrsdNxNPWacNdmP]cQ~mal`eeO~>~oQ~osaJ~~oeed]N~M~os1wWLm^nHqoseqVbXseka^~YNled>j<hV`M\WFb'nnHoaRYid]dsdL~dlJvbHJzKKQeddbP~^]@pZNimN^UKOqa_|o^+W]dGDTd*XX-C^9ObfMkZLB[J~aJJl\>bto:YSd:^HloaWPgYJCPe.WWLJ]S_GMK@DNSIZLvU[PMq0m~~l_XVbZcMH``K_P-??7bUOXG5Ly
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1234/ccs/fwd np:i:5 rq:f:0.995348
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTGACGCAAATGCCACCAATACATATGTGTCCTCTTAATGTTTGCATGCTTAATCTTTTGATTATTATTTCCTCTTTCTTTCTATTACTAACTTTGTAACTCTCGCTAACCGAATCAACATAAATACGTCAACGAATCAAATGTTGATCTCAAATATCCTGTGTCCATGAAATTTCGGATCGTAATCTGCTCTACTTTTGTTATTACAACAAGAACTTCGACTAAAGAACGGACTATCTTGTCTAATAATAATGGCACTAAGTGCATACTTTCTCGACTACATCGACGACTCAAAATAAGAAAGGGAGTTTTTTATACATTGACCTAACTCACTACTACGCCTTGGTTACCTTTGAACCTTTCGTTGTCAAAGTTCGTACGATGGTAAGTGCTTTCCTACTCCTACCGCTATTTGGTTGAGAACCTGTTAAATGAGATGGTTCGTACAGCGGTAAATGACTTGTTGAGTCTTGACGTCGACGAACCAAAGCGACCACTTTGACCCAATTGCGAACTACTAAATCCTAAGCAAAGACTATTAGGTAGTAGCCAACTTCGTTAATTCCGTTCAGTACTTTTAAATTCTAACCGACCATCTTTCCGAGTTGCTTCAAACCCTCGTCCTAATGATTTACATCGAATAGAACGTCGTACAAACGCACTACTACATGGAATAGATTCTCTTGTCAAATCGTTTTGTTTTGGCTTTACCCTTGGTAACAAACTTCGACTACGTTCGTACAATTCAGAATAACCTCTACCTCGTTAATTTGAGTTAGTTCGTTAAGGGCTTAAGTAGTTATTTCTATGATAAGCACTAAATTGACCTTAATTTCCTCGACTTATTGTTACACTCTCGATTTCCCTTGATATACTCAGATATATTTCAGTATCTACTATTAATATCAAGTATGCTAGGATTTGCAAACCGTTCGATGTAAAAAACTAAGTCAAGGATCGTCATTTACCAATATACCGCCTATAACAATACTACCATGTAAATGTTTGCATGCTCTATCTTTTGATTATTCTTTCTTCTTTATTACCCTCTCTTGATTTTTTACCTATCAATAAACTTACCATCTTTTCATCTACATAATTTGGGAAATCTGAATTAACCTCACCCAGCCGTATTCAATCTTTATGTTCATCTATTCTTTTTGATGACCTTATACAAGTTTCTCGTCAATTACAGAGGTTGCGGTGGTTTATTGCCTCATTCATTGAACAAATCCCCACCCCTCCAAAATGGATCACTTAACATATTGCTACTGACCATATTTTGAAATCGAAAAAGAGTTACCTTGTTAGTTCGCAGTTAGCTTGCATTTTCGCTAAATATGGGTGTTTACTTGATGAAATCCAAAGTTCCAGGTTGATTGCCTTCAAAAAATACTGTAACAAAGTTTAGTCAAACTTTCTCTCCATCTCGATTTCGGATTGTGATGAATATGAAACGTTAAATTGTGATTTTTTCAATTTTCGTCCACCAAACCTTGAAAAAGAAACCACGATCACCATCATAAAATCGTCTATTAAGATTCGGAAATATGAATCTACCACATAATGTTTCACCAAATCCACGTCTGTAAGTGCAATTAAAATTACCTCAACAATTACTACTACAAACCCCGAACGTAACCGAATGTAAATGTTGATTCAGTTGTGAAGGATTAAGATTTTGTACCTCCAAACTTCAAACCCTGTTTCCCTGTCTTACCGTACATTTCTTGTAAGTTTAGTGTCTCCCGCTATTTGGATTTGGTAAAGTTAACAGGCTTCGTCTGCGTATATTTATATTAGTTATAGTTTACCTATTTCCTGTATCTCTCCACATAGGCTTGAAACCGAAAATAATATCACTTCCCGTACTCTGCGTTGATACCACTGCTT
  +
  Z~HCe`l9^jQjAOnZ5Ee]T`ngO%ct~~~~~~~~~~}skks~~~~~~~g_G2NU0|p`_=mQAQ6~lg]NP;f`m^[@rDCDdG~m`B{b^Hfn_HY~V~GN?y~uZOY~h_~R2x^:[LWEZdY8ey]ah_~\UMByWMdx\nX~XcHl^`VLDw;g^7~iHT~[hm?~z_HW_g8A<LZ<xM\F~rU^K~_Qe_n_D~~nhn(cdam`l=~abF2~fT~~_P~fn_`nW~T]n_Hl_lPV1~|c_W~g^~IYFiJ3h`G~^_~``c2jD~~`X~_R~fHh<j]Kh3i`lX~nX~nJ~nQ~_h_fE~`lI\QkQ]6~p^kH_h`k<]gn_`fH^R[T\<~jhmN~^6~\G~~g`.~~~~ocNbHf`~`U>nj'}]jHf_nh_g_\D;~^~@~]~RJ~H~~`IeAwE~~^_K~`n\.~~__~_`k<]_Ql@~mH~[bHF.~~.ghfO\E~j9=~\_ifD~P/gLh_Q_FlKlg_K~@~~m`eIadQ~<s_`nh]OGGR~nL~jgINVG~`Y~^OGfEYa`R^`kG^c:R$-:e0mh]]]c:{:]8~XF:8fzU~Ho`__8~^lR^nN~~OL~k4~_]@~~`fJlOY~f=~ebIlh`O~G~__~_^Yd<nUhBb_^~He\fg^>~y`3z~^~_l5zGe`h>{eO[S~r?xHf`^~F+Td_C~fF~~n_`l>~kH~m[`C~^M^gm__4~e[^Tf_`n\Ii;U=z~ZC?O\mUNeL^hl=~W~ngag\~[P[I~GKB1|~l[G?}~eHA~~~Q~_4~ug9~_G~?olIlG@~jI^~_`h`nfH^K~[`ncZG~_~]b[G~lG~O~l`gN<lY]_K~KiC~}\h`[~`_L~]\[~IpH~~\3e+SDcPSPMQ7_~_hK`_MfW~`VN\g=]y_~`hO~W}HzIif?ufX`_W4~^_~`XbQTJ$1D`F1dFsW7|~Yu_OldSe_i[h`hnhlL6o_^h`lOjBbg_nhY~X~g`j15i_nhm`^mgQ~hD~~_^${OO~`7[I^MM^k$~s`i^^nX~`n_X~Q~eT]`kHfU~~MDE$AXVZ)9}^>~kQlW~HJych]Se?hSk^S$xgiaIjk``hn`]m]fLg_=~~u\9E}cPb^E~~^^~^E~~QYsN6[[h@^\^~`g0~~~~tO<y];jIW~m?~zH^~cMe6PV<}~~\QgNmh_bhRdA|t5~}@n~m_n\PgW~GsNiiB:6kZc[?v_nh^~HW~n^F~~gn`WaEb;\iO]~HF~~~~^;k`e?e^~fkD<W~`F~~^iYHl_J~_~c]GS.5V7~__R~nQ~D~|dQd_?U=[QVwHc[i`G~]@~tR6~|hZ,jYD`+o)bchmQ~hn]R^?tG|[;kg^~JZRO^kHc>eQkO?oseG+cxl\I=~~li^RWM~<MsH~^L~P^L~\I]h`Y~g`]MpK\REzbC)^^nN~~j;dH~~m^$~~cH^~\_n`:qaQAr1~~^N~K~eQ~_~_QZ~[@~S~_$~~~~mngYI[cEa[Mz~_4~~M[O\N~~^GskVOIe:}Pd[n__QE~dE<U;Zv`kHMR^DjcYY`@~{_`^~1~~DQ1gEL;~~~~~^4aK~~~_^R=~gIF-~sHf[~`-~~iGF;^\7c8\_OjVL*TSjFPl;~~~m]\c^i9]~X~_R^~_R~2~vlQl`6|l`kRHc%Wde2{k`U~~Z;Ja4[hbO~h_`m\S\QE~]SI]LkI~Dfw~^~O=eXKD{]U~`~h_nd_g^]>gV>]~~`X~_`dDnMg^=ne`m5~|m\X~`hQ~LeE3nU_>)YHqXUsOtV\8sskTNFFu`Fc*eQSUsT6hR=gWU,;nc2eU`V_>>j+DUTa[S[LssTSp<D?oVLspFUaV_>^/saVUaV=ofGv\LsrHva;uW>Tr?Y>ZGtTUsR>_UaVUV\X`\=t^F`\Us\VUsYFZU6qkN7p^FJsP$l^Va\SU`U_AfHOF`\GsSCqT*dQGsU5ro^S:_>B_SFRLT>]oVaYLBKFTUVUsV\_FGs\U_?SMs
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1234/ccs/rev np:i:5 rq:f:0.994874
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTGACGCAAATGCCACCAATACATATGTGTCCTCTTAATGTTTGCATGCTTAATCTTTTGATTATTATTTCCTCTTCTTTCTATTACTAACTTTGTAACTCTCGCTAACCGAATCAACATAAATACGTCAACGAATCAAATGTTGATCTCAAATATCTGTGTCCATGAAATTTCGGATCGTAATCTGCTCTACTTTTGTTATTACAACAAGAACTTCGACTAAAGAACGGACTATCTTGTCTAATAATAATGGCACTAAGTGCATACTTTCTCGACTACATCGACGACTCAAAATAAGAAAGGGAGTTTTATACATTGACCTAACTCACTACTACGCCTTGGTTACCTTTGAACCTTTCGTTGTCAAAGTTCGTACGATGGTAAGTGCTTTCTACTCCTACCGCTATTTGGTTGAGAACCTGTTAAATGAGATGGTTCGTACAGCGGTAAATGACTTGTTGAGTCTTGACGTCGACGACCAAAGCGACCACTTTGACCCAATTGCGAACTACTAAATCCTAAGCAAAGACTATTAGGTAGTAGCCAACTTCGTTAATTCCGTTCAGTACTTTTAAATTCTAACCGACCATCTTTCCGAGTTGCTTCAAACCCTCGTCCTAATGATTTACATCGAATAGAACGTCGTACAAACGCACTACTACATGGGAATAGATTCTCTTGTCAAATCGTTTTGTTTTGGCTTTACCTTGGTAACAAACTTCGACTACGTTCGTACAATTCAGAATAACCTCTACCTCGTTAATTTGAGTTAGTTCGTTAAGGGCTTAAGTAGTTATTTCTATGATAAGCACTAAATTGACCTTAATTTCCTCGACTTATTGTTACATCTCGATTTCCCTTGATATACTCAGATATATTTCAGTATCTACTATTAATATCAAGTATGCTTAGGATTTGCAACCGTTCGATGTAAAAAAAACTAAGTCAAGATCGTCATTTACCAATATACCGCCTATAACAATACTACCATGTAATGTTTGCATGCTCTATCTTTTGATTATTCTTTCTTCTTTATTACCCTCTCTTGATTTTTTACCTATCAATAAACTTACCATCTTTTCATCTACATAATTTGGGAAATCTGAATTAACCTCACCCAGCCGTATTCAATCTTTATGTTCATCTATTCTTTTTGATGACCTTATACAAGTTTCTCGTCAATTACAGAGGTTGCGGTGGTTTATTGCCTCATTCATTGAACAAATCCCCACCCCTCCAAAATGGATCAACTTAACATATTGCTACTGACCATATTTTGAAATCGAAAAAGAGTTACCTTGTTAGTTCGCAGTTAGCTTGCATTTTCGCTAAATATGGGTGTTTACTTGATGAAATCCAAAGTTCCAGGTTGATTGCCTCAAAAATACTGTAACAAAGTTTAGTCAAACTTTTCTCTCCATCTCGATTTCGGATTGTGATGAATATGAAACGTTAAATTGTGATTTTTCATTTTCGTCCACCAAACCTTGAAAAGAAACCACGATCACCATCATAAAATCGTCTATTAAGATTCGGAAAATATGAATCTACCACATAATGTTTCACCAAATCCACGTCTGTAAGTGCAATTAAAATTACCTCAAACAATTACTACTACAAACCCCGAACGTAACCGAATGTAAATGTTGATTCAGTTGTGAAGGATTAAGATTTGTACCTCCAAACTTCAAACCCTGTTTCCCTGTCTTACCGTACATTTCTTGTAAGTTTAGTGTCTCCCGCTATTTGATTTGGTAAAGTTAACAGGCTTCGTCTGCGTATATTTATATTAGTTATAGTTTACCTATTTCCTGTATCTCTCCACATAGGCTTGAAACCGAAAATAATATCACTTCCCGTACTCTGCGTTGATACCACTGCTT
  +
  >uA6_]:=eRlU`K~^NXf_RJhnZ%Xiw~~~~~~~wlefny~~~xmfer_[dZSH0hlO]Q~nN~[~hn`nhnh^R]hN~PH1cWdg^A~{\\bN0\6~'ch`0~~j_k5~gAhd4feP~g_4lXD~~`hnX~\.FBb\@~~^aAfEcHf[_`h^~=~XIbP_`~`nf5~~fi_NTG\~I[N~eI5~~aXX~_nh`h`C~~fne`N[:Y;P~nh_A~S@w~`N~dL\_h[db[h``h_Qh_2UiWJ5|V*~k`_~`L~\J~\.^\]e`f<g}^Q~`Bre[Rc5^X~^R^J@~eN~f_~hN~Gkah_~_R\Jkhm`=~~_g`_nahn`nh_Hk`_n`d1Hix{QZpJT~|;LbgG$u~~jQl`nW~_iMhgN~_i^n`Ol_QjI\Q~G~O~H~nQ~D~|_[iQ~N~xIWV{_h`F~~V>aY\Rl`_eQ=}:EaGf_`O~~`hn`hN~_SQ~\FNl3zK<~I|]RD7gQ~h_X~H~~h_n_mU?oW~`_hm]9X_,~OU~~h\U6U{_3i]RAb[3z\n`^R_^k^]f=~Ejh\O]l=~l`1vf[S<~aK~E~G_^L~]9P\OD}~gP~LY~_`A~{EQ^hnUel>~fm];R[>~K~_I~a]5n^|4~M~PEvX^TKl_%~~xR~~6o^95~P~_nN~ch`Cgv@s^kIF|_`X~`U~s:~aKJ[^Q~h`~h_nD~~n`nh`__~eSZK~__h`W@l_2~~\HGlahnahn`nh(~c_~hn]TW~_Q_TcZO_G~~g`])~t`\%f|OMh_2rbf*}Ex=ieK~^5~~_X~`_n`hn\XTj`KNL]\}4~_n_<xhXm9cf`hnQf7CN?x^~>~c/OUSe_WN?`_U~M`)j^UB}]~GOl_LjU8gh^?J3Xkh_~]Il`b?XVLkTaIuE[?o8qpH^UVUaUJtQ;TA+`aVa\QSTT`5HJBqlI]CHVLFLUWN`U]\^G\8tiVaU\`ESDRTFV7a8kP6CS8yPB_X7;,PE1o]+pQ6N5mBRI7kS>F-NR(pn\S_YD>URpQDQMc([FS6(Ta;rhVB[<Q4\B]@tQ&MUaZ-nTUrZFT\aIua\USUs\TFtsTQV[TCCC[a\VAttrT`=q`OsV;tlVOtV*peaOtaAuu\V\V*XT`-rrqgUOHs\^/S?m.>amT,n_Hwa\U5rrqSFYV\_>^\J`9r\>uiKsnETI<SsNpAqHu\VaAuu_>Go>Z`6iCTo\VGttaXQ>mVa\V\aOtV;siXiTa\UaHqGWTF[P>c:4TbTRPT\VTr<oET^>Z0cFMKU3KH/H13[\2VRGv\VaOtV[NsS>qT>oq\9ugQ`;uutZ5p7ptn\DhRVS'HON_-nSJY]-^OQEYV\Q-Gta\`5rroOHRY/R=+mqqpSaTNtaIu?kN>q`R(YVUVaT=q`UU=qTSa'qqZTP5S<`^YEW?ecFS:osaU9nPF>7Hos\Iu>skT>qHiaEZ+YS`;oODF$.+W]peUQVYU\UsU=rrS8qq`U\U;siO*^p\V\V\Iua\V\VSF5plN6q^;dMC8PKRTp\a\TLssVT=k8Qc+;<BPQ)a`_H@S8rfYVRUHvaEV=mX7p>`S8rrpSHroIu[PTa\V_5q]7RYD8WooXVU\V\`=qTsT`=qS6U*or\VR\TAq[UF_Iu[NR@Lo\T;_QVaIu>sq\IuaVUSV[SVAi72FQUs?f7ttcNtaIu\V&pXPQm=]`V\aV[YM<qb/rsk>RpHQKBqHgTPg-9@<Y]Q>JXT`.TPaT=qS\TTo6q_Na/kPH)koS\aHuZIbLqsU=qR4_B0pqZT:QXAupFH[N%\^IuTGFT`8qqUKXPATrQ)pc^<DRYQDBrqTLQ_8u>([.oO5oP:uiT?mSsV]6qT?nUUS>ZS?OU_F_Epq^WQ;oaT=oY0YS8traIu\a;uaHtFS\a\V\UFHuaV`F_HtVNk><rdGqT<ssrUGoFFYV`7<X>RiT\aV\VZ>TR,lR`F_HxaUFSVBc
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1241/ccs/fwd np:i:9 rq:f:0.994308
  AAGCAGTGGTATCAACGCAGAGTACGGGACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGTACAGCTGATGTGATCCTCTCTACTATCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGGATGAATATCTGAACCAACACTTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGTACTAGGTAGGTAGTTAAGTACGGTCCCTGGTGTCTCAGAGTCGAACGTTCGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAAGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGAATACCACTGCT
  +
  Ev_`UWQP~vx>EIjS[;RYshk~r1+V}N~hrWkb2ru}n]kQ{d<nVWnpbAhv_O~yUi7Dy~3mQg=~~x\~prlzVtE~<{jqg_fi~b{hKhIX(lZV\P^QaHg[ScUMI~isog}yDf`&H;wrlmai\X~R~Ow\ymrnZw8turtK`%UG[z|>ze`qanx~~~w|~:~~i\~r.|tY~pd~vY~{nzadywz\rR~~hT~ZhK;l'~~aktWSbxdc~Pknk-~nQ~~gihhDq~@X@bh0hI89\Ty]AdXNRTztft`{qa~?og~~[~knkUn~TiRpS~~lZR[gt~o]egHwb~rl]UeW~nfyldJ~H~~M~Q~p8zziU~Jx3Ne[B]H^~~K8~}jCxZrtr[{_^~n~T%gp`eZ~bkyyym\~[\(pRWS*NO]lDRo;z~f\ofI~j]Vn~jmUY~Md]ZTg/~{[IRsO~SL~P~SfJ3fvjjBZS~uxZv~x&ez~tOlCy_Q<j{~=WyY0j~~j9~|;~~^1~Kgru|a~;gq~ueQluqZ~s3~~~R~Xk~`~~H~~^bvLOt~Y~}j]C~jeapiZ~s^zYeCg8~~virF~u\buFjqRffVcku~\~Q`f_ZuH~`jsdsmKv]r-kfA}rFXFJg~~t~fp-f4yY~s}[b_SZ~~asY|'rk~ETN}r@4]d^tqu'<[[~j^pL~i~N~`-~XPfP~ueN~o`gawUy&Znkqv6~eUS~|V~al\kn[~miTaFYs:p~WjtE~Cg~~U~1to%NMsjnP~uXC~ne^@fH~~endd~pvimVKsf~v~h}9cQW~Y)~~Z~R~nN~qQqE~~qO~wkhjmc]`OSz(]cvu>~h%~~[ma~kloM~PxPQqR;~~%z~W+~~~Zdmm~`|mF|]_a\CvBv\<xPv~G~~~sul~]~J~`~sxl~]~qZUuh*nzqN~ULjw+qiddk\}?C_Y?oxx_L~pkJ~_~Pv[~?p[uqkb=~I}S~~~~w~nsfoQnA~[~v3h~rui\~zJH^V}^VhblrnBnhFWaqrSb~a~n~\g~b~[~gDWqw_i~MnToH]I~mt8~zA~i&kqvqlil|~~~|{~~~~~~~~znr~~~~~xn\~ues~pal7l^,~n~^~o;KUj~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1241/ccs/rev np:i:8 rq:f:0.991361
  AAGCAGTGGTATCAACGCAGAGTACGGGACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAACAGTATACGCAGGTACAGTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACAACACTACTATCAAAGATGTTCGACTAGACTCTCGTGGTAGGGCCTGGAAGTCAAAGACTTCTCTATGGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACTCTCGGAACACTAGCTGAGGTGGCTTAAAACATTCCGTAACTGAGTGGTCACGGGGGTGAAACTGTGGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAACCACAGACCTTCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGATCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAAGAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGT
  +
  G9.=<YC;dfglZIvCGEsjYfeeZ<~~l&svvsip/~iGFobY_[Wg~s~DdZ~~~M~|=DdIsf]gpf1~~VI{\eQ\SX[`%~~~n~s^w~b[\hAH}Ycmpb)eOS\Hm^dS~{RVevUTyrlB&.E6[Pbmg\lG~9~},mh^M~>h_VEJZ$It~y_MVi(PQih@H@\ci[@Fg^LoJO^ZDXIPcT[w[uxiIeld%J*h|M~iRwJy'XIlxffYVdMKo|[~r~5~~C~~~r~}:~~~z\~te~oA~~`~|N~[DPM~~`fbZ^7TYHz}]~~nh_[ioxNnP~GRiiXyn{IJ~DA~'JU]^Bi]K\d3NYFM8fs`~3~S5>KU8mFUTwZPIho4zn`Cqj_XcT^e7E8;?L^?HcufVWzgZD0jXbo)A~^oFgsdOZcgK~~jIgC3eMf`b]^V_)^=>Qa`?~Pu<pxT~K,~d~W^L(ntUsTU|\gM_vk&7FosdN~vW~cBDpxsEH~teCgJRfVrOG~~e8ooq|\jKyhoNZ_\RfP~ShQxg,tk|{D|lMV,oSJ~~f^yoi~uH{LwlDnifZrPR}Ub~ot/UJ~uRWi?~meVK`m|bhQfm}dY(SLYTW~S~gth|`hdRh`S~uF~P<N,uomdlPt=MYhM~Sma=_jLjzgr&'{c1=UU.YO;EG>%IW<E[Iz^<sVl:l:WR3}n$9@e*Q'yj^R_]@[DjyWPd;p~f>~~V~bh|tjZ~Urnoc`~7~^H~kExiEvs'GTG/dN~ff3~YeB~gU|S~'~~ifnk~n|VeouSi]drS|ash1lelo;p3E9J`K[\$vN*jUYXP`(n^qU~K~vke<~U@~zhvT{R;dS~I~cE~m;vvN[~f8~~dMJoSnPth9~k_5_NhRSf)z{r:lfTifvPsPJDinN~`~~fQ~gE~|xaA~a[Wj-kC^h^Lcubov-~~wnTHm<M~q~Cg]~7~~{ap[`~]~L~fdhlgJo5Y~TFT~e]Y~ra~Q~`_~^y~?MlqpZt[~gj|pbtSkzq~\~d=z9\]kVvwz`jqbVNA~@oe~n_8~~e~p$~~~~~~~shciw~~~~~~~~~y~~xqqi_}UaRmrT}Q[qX9cK3Y*3
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1250/ccs/fwd np:i:5 rq:f:0.991797
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGGAGAAGCAAATACTTGGATACCGAATTTAGAGGCCCATAGGTTATGGAAAAAGTCAGTGGATTAGATAGTAAAAGTCGAAATCTTTATATTCGGTTCGATGTACTACGTTATTCGCGACTGTTCTGTCATGATAGTTTTTTATATAGTCCTAATAAAAGGAGTTTTTAAAGTAAATGACATTTCAGTAGTAAAGTTTAAGAGCTTTTTGTTCTGCCAGACCGTTCTGATAGTTGAGGAAAACGTGTGGTCAGCTAATAACTTGTGGTATGGAGTAAACGAACATCCAACAGTATGTACAATCGTATGAGAAAGGACAAATCTGAAGACGATATTAGAGGGAGTCCAACAAGTTTGTGATGATTCACGTAAGGAAATCGAAATGTAGATTATTCGTCAATGGAGGTATAAGACAACACACCAAGTAATTATACGCGACGAGTTTTCATGTTGACGATCCCTGAGACTATATCATACAAAATTGACCCAATAATAAACTCGTTCCAATAGTTGAAGTGTTGATTAACACATTGAGACAAGTTGTCCGTACTTTAATCATCAAAGTTTTGGACTGACCTATAAATGAAATATTCGCGTTGTCTTCAGTTTAAGAAGTGATATTATTTTCGGTTTCAAGCCTATGTGGAGAGATACAGGAAATAGGTAAACTATAACTAATATAAATATACGCAGACGAAGCCTGTTAACTTTACCAAATCCAAATAGCGGGAGACACTAAACTTACAAGAATGTACGGTAAGACAGGGAAACAGGGTTTGAAGTTTGGAGGTACAAAATCTTAATCCTTCACAACTGAATCAACATTTACATTCGGTTTACGTTCGGGGTTTGTAGTAGTAATTGTTGAGGTAATTTTAATTGCACTTACAGACGTGGATTTGGTGAAACATTATGTGGTAGATTCATATTTCCGAATCTTAATAGACGATTTTATGATGGTGATCGTGGTTTCTTTTCAAGGTTTGGTGGACGAAAATGAAAAAATCACAATTTAACGTTTCAGTATTCATCACAATCCGAAATCGAGATGGAGAGAAAGTTTGACTAAACTTTGTTACAGTATTTTTGAAGGCAATCAACCTGGAACTTTGGATTTCATCAAGTAAACACCCATATTTAGCGAAAATGCAAGCTAACTGCGAACTAACAGGTAACTCTTTTTCGATTTCAAAATATGGTCAGTAGCAATATGTTAAGTGATCCATTTTGGAGGGGTGGGGATTTGTTCAATGAATGAGGCAATAAACCACCGCAACCTCTGTAATTGACGAGAAACTTGTATAAGGTCATCAAAAAGAATAGATGAACATAAAGATTGAATACGGCTGGGTGAGGTTAATTCAGATTTCCAAATTATGTAGATGAAAAGATGGTAAGTTTATTGATAGGTAAAAAAATCAAGAGAGGGTAATAAAGAAGAAAGAATAATCAAAAGATAGAGCATGCAAACATTACATGGTAGTATTGTTATAGGCGGTATATTGGTAAATGACGATCCTTGACTTAGTTTTTTACATCGAACGGTTGCAAATCCTAGCATACTTGATATTAATAGTAGATACTGAAATATATCTGAGTATATCAAGGGAAATCGAGATGTAACAATAAGTCGAGGAAATTAAGGTCAATTTAGTGCTTATCATAGAAATAACTACTTAAGCCCTTAACGAAACTAACTCAAATTAACGAGGTAGAGGTTATTCTGAATTGTACGAACGTAGTCGAAGTTTGTTTACCGAAGGGTAAAGCCAAAACAAAACGATTTGACAAGAGAATCTATTCCATGTAGTAGTGCGTTTGTACGACGTTCTATTCGATGTAAATCAATTAGGACGAGGGTTTGAAGCAACTCGGAAAGATGGTCGGTTAGAATTTAAAAGTACTGAACGGAATTAACGAAGTTGGCTACTACCTAATAGTCTTTGCTTAGGATTTAGTAGTTCGCAATTGGGTCAAAGTGGTCGCTTTGGTCGTCGACGTCAAGACTCAAACAAGTCATTTACCGCTGTACGAACCATCTCATTTAACAGGTTCTCAACCAAATAGCGGTAGGAGTAGAAAGCACTTACCATCGTACGAACTTTGACAACGAAAGGTTCAAAGGTAACCAAGGCGTAGTAGTGAGTTAGGTCAATGTATAAAAACTCCCTTTCTTATTTTGAGTCGTCAATGTAGTCGAGAAAGTATGCACTTAGTGCCATTATTATTAGACAAGATAGTCCGTTCTTTAGTCGAAGTTCTTGTTGTAATAACAAAAGTAGAGCAGATTACGATCCGAAATTTCATGGACACAGATATTTGAGATCAACATTTGATTCGTTGACGTATTTATGTTGATTCGGTTAGCGGAGTTACAAAGTTAGTAATAGAAAGAAAGAGGAAATAATAATCAAAAGATTAAGCATGCAACATTAAGAGGACACATATGTATTGGTGGCATTTGCGCTAAAAAAAAAAAAAAAAAAAAAAAAAAACAGTACTCTGCGTTGATACCACTGCTT
  +
  QnSLVS[4fU<[I6G4NHTN<R]UK.ghg[Ee?M8gQ42<@B@KHh1M@[UA\='d=fiUOJGi$fUP\Q6QHPSQ@P0F`igS\MS<ZFe:4JJNI>IMT/C42KV8RBjj\K7hgSV@DNH2^QiLSUZ<ZO8A>H;IdUOg6NLL9J\R>gK\S\I+X<RLPS*hhhbF>WP=NM[?k[8h[=jjhEb)M%NagJ%aMP\>lk\STLPFgiLVS]US[(ggR>jcIi@@AK(hhhXSMhIYB6XURA&RSQiL]OJ\UJ;VHODc/NLMGOWPVCQDJS:-/B@W'FKH\SZ4g[U]GiUS\?jZEI9QF?K?jAeLUS[@[RCNJFL\LS]U]P+P4d\CeUK2cO[L[>D]SULR@[UQhUST/gg7.J1hG]JCGN8dgSZ<T\SUMIIU;SZ2REf0VL?GR6ii[RF+QS@cS@fKS]K9h[GiUGj\UY&K2F8-TKOFJ1WAXS\HgAHRZRJQKR@KSUQ'hhLG@Y<JjSULSUX9im\QARUL]U]U[KS\E<4L_fQiSU5lE$\Y9cPBgjL]LR>g@e@L\UR>gSFcICRQhQ,HW0@4;C0@QSUSTK6OQ=gQ?>\>Z:;IhiJk\LTDG;]hQ'^H[3e2;SST/hZ@Z4hh\R6McS@K`5;JSQiS\LQiLUS;hhHi<BhSZ<QCS:]O)8\RKGWGgiLJkR?kV<[S[FW>N(EQE<JP3F6igV@FfX?WUL\U[6fKZ1G9I>-FW<C8DESKTRR5H8dS?kZ<<g:fKHig@57'cfZAZ7gi\UOK1ga@NEC<GX/^E838*A%K<&dZS[PECI9=aSULU?ii=keLU4kK9hhSJkS?jdGeP3e[@K;TZWLKJeGK\?QQiKS6&MK]SBl]LAfLQCBBQLUKE42V+NGQLSQiL4jjK9efL9ROE7P@FNOdSQiSUGl\JjCiihBjQiSIAGEVP5@;>J<HFiUIiiGi\S=M_LU1M@X;AFi\:R@PhLPTTAVV?kR;ORJ<W3`=PSSLSU7iigU\SV]4h\SV]MS[4f8g[35NVaJ6fCL;ddGi\GV=HR3hiiZ<+giiic\FCKBXGg`6M?Q:hE)I35UQhLUP,LH*`Z?kS>kk\MQARU\GiUSSN&]fR;ihSUL]=leLIihR:dHKTS[@&eggSQ&b1B1Ig\J0L?h\Fi9hIFIbGd@Ghb7T]K8hS\1hXGP5KZ0KE;eeQ'H<-hjXPSK7f<KU>`GMPHSCL.L:RI+FkY/F98K4ghfC0QU;ifK=jjiY+VGiZ7TOJ,K=/c[UZ<PiBkSZ;=V@gU/hdMDSA;^jj\4jkQ?*ffQ:gJ;h[S8gX2.-30C_Z'eY$JD3g;61:,cN7C<ZAkHc@TJM'K:SaGLhSYVZ9hG\\J:GG5akicR5YD>Q@[R>cJ@[-M\SUQiSES@=JFhL]?iiZ<TGhQiJkMIIO7KIib6R0IQOdQRS]UR@[Q'ggeQ@U2I=BjS6ha:=fSU\UGl[%fffff]\K:bQ@Q=>eiXJk\@jaI8hS0OQR7gBGwPR)JW]G7d_]a\T]NG=;csSFWy`UaeOch`\NV6n]WvHBS?f>+ocIcGEsD`c8bSV]`U]XT@]Bf]`TSsJZ'wwwweG=IgRF=uP=f1sCR=xxb4c]J\?^bDP?p]`i[UtIoUVSZ_\HKGA5@7G_J^`5eRO[J]SUT_RT>r0fNAS]`U\^\@N[L+DAMcf:bSQRWFJu8wpCYLmD4gTRz9gg^Gg]ODuKcPIcZFHvyhMmSP_S?;RyZ<ahYwKuOC(mXTgAvTeD&YYYr5_TSaJ[gJEINtBbK>kSLE8iV_HbLPZKwT^bF\e<Z6YZ3dd\%SNO:U-)f0Sge.vv\E{5fnaT3agG9ATA`u][UNfBA*<Y^Sg_Gv-]VHWc`]ha]d/Q[Qxx]i^<'.Q^Xn+\`UrREHN\h$negF%UTTQ)XPOIK8_N/YaL@v]S1fTdS?g8GIHXOMxeTPvJx[Y-B9`D+vugFN3Q`XAc(MnQwGvOvT]M{\4uOqTgKRNIA|hRzi`^^H+hdC:Tu`NxCDYoa]eJYGvSQ+6\ZxEzv[T&t_]g;ua<\SHyL'oeT]dR[G-<bQ;VZ5SiT(qVR/rYDO39]v]1ZY<eGeWO]KoGuKgTiT`QxxRyTY<dUoL\PAu@X<tyha]TPzgLLkZJVH]Fp[]D]AUqH9UKFTY\_RE/sSQxx]^COcT[FcmLtUvT(mTLohPp6a.bNwT]i`]f8Ga^`]Gv_OzPTQycXh`h=zzzhK</q]7cdSMTM/`vv[J]gOYe?Qvi^h_\OT]`]Izz\MJcHS`T=s_JfF:cMPu^Pw`VuJ]]>0]XKfa^a5x\YuSCtx_]f>D@v\CtREs]Zx]hH{]?vTAevy]i`]`]TJ]`Se7S[5aCd]F{c?wwT`a+s]T`T`]`i`Ms[GWQ4c?>qREFWt\KUxT\S`\`T]a7Bvw_h]FvFX@MPMwJ_^ZT32SAGv_PFwz\IhK]f0^Z`]8wnZ8]p\JOu'tQQNjHMshT)uvc]`ZxCx]LVcLE)DLUOuRz]`NxJRJS_h_U^PKUtMoKMvT`QxxZ+[Tg$vvvvvvum`XW[epvvvvvvvvvuh2$)\i`SKMfGS]Sy^_aCBR7Th]Tiy
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1250/ccs/rev np:i:5 rq:f:0.994926
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGGAGAAGCAAATACTTGGATACCGAATTTAGAGGCCATAGGTTATGGAAAAAGTCAGTGGATTAGATAGTAAAAAGTCGAAATCTTTATATTCGGTTCGATGTACTACGTTATTCGCGACTGTTCTGTCATGATAGTTTTTTATATAGTCCTAATAAAAGGAGTTTTTAAAGTAAATGACATTTCAGTAGTAAAAGTTTAAGAGCTTTTTGTTTCTGCCAGACGTTCTGATAGTTGAGGAAAACGTGTGGTCAGCTAATAACTTGTGGTATGGAGTAAACGAACATCCAACAGTATGTACAATCGTATTGAGAAAGGACAAATCTGAAGACGATATTAGAGGGAGTCCAACAAGTTTGTGATGATTCACGTAAGGAAATCGAAATGTAAGATTATTCGTCAATGGAGGTATAAGACAACACACCAAGTAATTATACGCGACGAGTTTTCATGTTGACGATCCCTGAGACTATATCATACAAAATTGACCCAAATAATAAACTCGTTCCAATAGTTGAAGTGTTGATTAACACATTGAGACAAGTTGTCCGTACTTTAATCATTCAAAGTTTTGGACTGACCTATAAATGAAATATTCGCGTTGTCTTCAGTTTAAGAAGTGATATTATTTTCGGTTTCAAGCCTATGTGGAGAGATACAGGAATAGGTAAACTATAACTAATATAAATATACGCAGACGAAGCCTGTTAACTTTACCAAATCCAAATAGCGGGAGACACTAAACTTACAAGAAATGTACGGTAAGACAGGGAAACAGGGTTTGAAGTTTGGAGGTACAAAATCTTAATCCTTCACAACTGAATCAACATTTACATTCGGTTACGTTCGGGGTTTGTAGTAGTAATTGTTGAGGTAATTTTAATTGCACTTACAGACGTGGATTTGGTGAAACATTATGTGGTAGATTCATATTTCCGAATCTTAATAGACGATTTTATGATGGTGATCGTGGTTTCTTTTCAAGGTTTGGTGGACGAAAATGAAAAAATCACAATTTAACGTTTCATATTCATCACAATCCCGAAATCGAGATGGAGAGAAAGTTTGACTAAACTTTGTTACAGTATTTTTGAAGGCAATCAACCTGGAACTTTGGATTTCATCAAGTAAACACCCATATTTAGCGAAAATGCAAGCTAACTGCGAACTAACAAGGTAACTCTTTTTCGATTTCAAAATATGGTCAGTAGCAATATGTTAAGTGATCCATTTTGGAGGGGTGGGGATTTGTTCAATGAATGAGGCAATAAACCACCGCAACCTCTGTAATTGACGAGAAACTTGTATAAGGTCATCAAAAAGAATAGAATGAACATAAAGATTGAATACGGCTGGGTGAGGTTAATTCAGATTTCCCAAATTATGTAGATGAAAAGATGTAAGTTTATTGATAGGTAAAAAATCAAGAGAGGGTAATAAAGAAGAAAGAATAATCAAAAGATAGAGCATGCAAACATTACATGGTAGTATTGTTATAGCGGTATATTGGTAAATGACGATCCTTGACTTAGTTTTTTACATCGAACGGTTGCAAATCCTAGCATACTTGATATTAATAGTAGATACTGAAATATATCTGAGTATATCAAGGGAAATCGAGATGTAACAATAAGTCGAGGAAATTAAGGTCAATTTAGTGCTTATCATAGAAATAACTACTTAAGCCCTTAACGAACTAACTCAAATTAACGAGGTAGAGGTTATTCTGAATTGTACGAACGTAGTCGAAGTTTGTTACCAAGGGTAAAGCCAAAACAAAACGATTTGACAAGAGAATCTATTCCATGTAGTAGTGCGTTTGTACGACGTTCTATTCGATGTAAATCATTAGGACGAGGGTTTGAAGCAACTCGGAAAGATGGTCGGTTAGAATTTAAAAGTACTGAACGGAATTAACGAAGTTGGCTACTACCTAATAGTCTTTGCTTAGGATTTAGTAGTTCGCAATTGGGTCAAAGTGGTCGCTTTGGTCGTCGACGTCAAGACTCAACAAGTCATTTACCGCTGTACGAACCATCTCATTTAACAGGTTCTCAACCAAATAGCGGTAGGAGTAGAAAGCACTTACCATCGTACGAACTTTGACAACGAAGGTTCAAAGGTAACCAAGGCGTAGTAGTGAGTTAGGTCAATGTATAAAAACTCCCTTTCTTATTTTGAGTCGTCAATGTAGTCGAGAAAGTATGCACTTAGTGCCATTATTATTAGACAAGATAGTCCGTTCTTTAGTCGAAGTTCTTGTTGTAATAACAAAAGTAGAGCAGATTACGATCCGAAATTTCATGGACACAGATATTTGAGATCAACATTTGATTCGTTGACGTATTTATGTTGATTCGGTTAGCGAGAGTTACAAAGTTAGTAATAGAAAGAAAGAGGAAATAATAATCAAAAGATTAAGCATGCAAACATAAGAGACACATATGTATTGGTGGGCATTTGCGCTAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  GfJ=ZKB@X>BP&)eP6;ZL]LV]S3iW?+?cDJPfJ-9OgU\R>\Al]V]4XK:g=jk\HE0RFgV)T?kJj[@Ae=iiifLVS\IE0e\IgMACSXFT(hhhPLVSLIihQK&ebZSB6e<>jHe96KDJDTO@?OFAdY:3=JSK\/AF)UCBJ?R\UM[QNL*cSWgb>M39ZK>6fS:gSAgia?k]K.`NObQwxU\FykK@U^T:WZUPSKgTKHt`tTFzyZvTb;[3xvieP+\_\_TMxORh]ULz\JP`KgT7TB\%_*Sov\NLPJAa5[hU\9EuISXXMhS7FeJg`Cn.KEEaT]RWw]i`P{WqFfT_c^QWYFFv_]TZL*OLPRQsvE{h]QxvJV?FUl?f]S`_ONcH>_.lqhTaPj8uT&tSHzo?^Ti`TiObYi]T`ZxGgIix`]TDxw_?^[xTiOb]ObX?\FFvKGjf1f_faYxUe\Dv\gPiKoF\S_RwKtfG4YU[Ti]SPR(nZ^]gFN7eTgGRi_7ww_RORd]_h^O^]i`h]<O_pLvThDr\CwhKXu`0vsKLMR?IDHCc`S@'VTZxTKNApUgNvZq\N\dRzSQRMWZxTLtTKJaR[h]=xuT`WYh%[]QxxT?yt`<Vh^`S7LwGY_Ewx`TBww_hOsU>[TQt?^]M{]iTFzyZxTUvUKSi`iRzh8zp]U@W;ww][xT>w^h^C^6SN*M9N?NZbCT5u^dEfKQwx]`h_Gv\JVuac_1vq[`_dWT\NRb]RTl?Lt5RQsLwZDrzhPsBww_@oHyx`iT]/|qgTh]i]]Auw\@wc\4uRN`v`T`gEBaXBn>_]g%ve3Io]h>|X,pqN0P<<sjEzfEc@]\0vwv^]Rz[x`Nm)?TJEBv]`UZx`]Gv]dCZad]hAw]>o6ri]TRz]8||oDiSQ\hT\]+\ZwCrSAuSiHu[BV%YjsU`EvU]iH/tf]iTi]R[H|g8mQ2TTLPwx]b7nOX+\AR5eSPFyEh`h(tUOyT?_L\@vCrUM=T^UW5zyha\?eHDu_UeFZ?]AY:qvX4wxrFYxGm=t_@?`Ari]T9ws_VN4Xjwxp\[h\5u5jlTw]TIzxZZKdAe]eW]h]Gv_+xYTBww_]TgUg`E{hThTDsqTGewTiYF6fn]Gw`@9ng]iT`h5xxxqSFuDeGYx`][x@u_7zYw]F{kHzh6{o]gL\[xTKPwxYiCxxh`dErze<TI58^X]@YS[OYCRX]^C]TGv\JVy]AS7n^[x[5Z+uwpdF>fIzz].zve\_\F]\^iT^]LXGv_haTAwTmQWTgKN{f?[gF&sT9{}cL6cevg;wwT&FHXv[?XuKSg7wGXwJAvwNxhM^T]WuKt`]`R[WuL]Ag\?`B0ck]Jb?D[`FvE{`]bE\;xyxkTV`JeT*^]?Yw]i`Pxr?eCvSTu\VT4v\`:ua`UhHzRzXu?LFfTh6Xa4uuFxu&ZbLS`bUh`T@xyoTiW&Y[xPFZob/V=M^hH|^+wxxxg`]HfRe=L:q{`Yv55tdTZwTBwuSDsRWu`]4wwrSf(<OcP]h^C]Qxx]hCye^gLAj_TSFcGrT?wg`d+X&tWfIe@tEy`HxcC:eGSi`NxCvRP\NXVP/xmcrsh]i^E=Ux]H|LvT]Hyx\KtJgSXgKg^RzTi`fKkCt4eT`fHZNfH^TCxu\c[gJ\aScO[e`dK\Zx=r^Bvw_]SgSTG>[E[FYu`[xT`]TiE{GwrOxVwGvK\ZxGzqYU`T\Ca_H\i`dUPxx`[x\Mg]L{UwTCxsMqJt\UIw]`[x]`^AlXLqJw]SM%c\hThE{GvZ-t\`TZw@rR5e]T)UZT^QR`]TGvQ&sUTRzhNxGv<^_58vgTJ\+mvv\4itfWTh:wwQ_^VuOiT[x\VW8;dMwO\=1eTKgT6PXTHyk>ZXDRi]U5m]`hAw[?f^?]AwuK\hN[h=|a]Th/zI8rhSYv?\Wz]^FBr?auThK9hHYE\OnhTGv:ws<noYC`b]I>YuI5xGvMz[x]T[xTRyDyUai^W8Jb]VsSf6-U5EU?[?of5wf4r[MQIbOQp\Q>1nNZ<ceKLPvxTKGy`]T]=xn=s_]UK\Ti]C`\Yu?P[a\Gv\GvL`]OFz{hNyT]`T`i]TFv;ug`\L[h7{5$\YgHpAwYTYYv;uOxtNINX6dZK:sFB`hTDwuT]j\AwgP|h`\@Hf]SEaXGztSP\Zx]S%s-K?v\6x]EjKFt)qXwGn\?Z_?IgU`SPRRzhH}^FYx`OBeF.cvwv]\EuuCzy]NyO@scmQ\?HW:\]WuVO\NP[]QbTExdC```T\]G@]K2M2MtgE`W$D^+UeSM[<P>eKgS5MwT7YFEveb;3[T[xS0]VO`>L`SJWwLVwF-obX=D7PSN]TThLy_]Ti`PzTQxp:sjFTT5a\]i]eTMHfIxySN=f^FXwGf9`_ThEz^T7eTi]QHe9YYfHOAbSiOxWA_RyiSF?eTTSOb]]QxxTKx_?^WtKTMLgwTM`oRKCuB^^^Xs`Mk]]1yyaTiM{[xT\O^U]Hyx]a,@rMB+e]i]i`iaT`hKnHw`,ve]h=yuS\?\_$vvvvvvvvvvvvvvvvvvvvvvuj\KGQ[]_]`R\>PqTh^OMxh]`T\Dx
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1334/ccs/fwd np:i:10 rq:f:0.997708
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTGCTAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCCTAACATGTTTAGGAACTTCCCCCGAACGTTCGACTCTGAGACACCCCAGGGACCGTACTCTAACTACCTACCTAGTACCCATAGAGAAGTCTTTTGACTTCCAGGCCCTACCACGAGAGGTCTAGTCGAACATCTTTGATAGTAGTGTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTTCCGTATGTGAGAGTAGTTGTTCTGAGAGTACCTTCGTCTACAGGTAATGTTCAGACATTCTCTTACCTTTCTTCACTAGGGTAGATTTCCCACAGACTACCGTCCCCCTCTACGGTAGGAGTGATGTCACCATATAAAGAAGTTACCCTAGTATGACTCAGGTCCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACCTACTCCATGTTGACCTTCTAATGACCACTAGGCTCTATACTTCTCAGTGATGTGTTGGGAATGGGACTGAGAGTAACCAACTCTTGTACACAACGAGAGATGGCGTGGTATAAGCGGACAAAGAACTTGACACGAGGAACAGACCGTTTCAAGGCTTAGATTTGTAGGGCCTATTCTAACCTGGCACCTCAGAGATAGCTGTATTTGGTAGAGGCGACGGGCTTGTTGGTCTTCCACACTCCGCTCCCTACGTGCTGAGAGTGGGTAAGAGCATGTACCTTGCGCCTCACACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTTGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGACAAGCCCTACTCTGCGTTGATACCACTGCTT
  +
  N~e_zd~D~~j~JT~`r\zwituUL%~~~~~~~~~~~~~}{|~~~~~~~}|\R^y[puB~v]J~~_tzMw~`~xv_^o*^`NywsxNt~`t~v~cx[~]x~`whk[d~gI~he^~~`~T~[~gxxxwM~x~iP~lao-~b}^uV~~U~_~sxO~xbh~w:~w]Zt]~ZQz|\xL~y~M~?_iKuu~_YlMx:~e~tp]~d~O~~M~t~Q~~B~~~xvjw~zm_smAfX}zw_s}xfB~|L~ywH~pMc~}J~U~_aNQ~~uP~|iH\~hs@~m~ny`Sg[g<uc~J*~ke~tZ~`e~g~savQ~|r~V~}uDattax~A]C~\vR~~rD~*~vW~\~<~~_s~B~~<~_~~m~aY~W~~Mu~R~aQ`~Xa~Mu|w~@~e~~_X~yx|_{q~b~hvys,~~IvM~Xz7~tdu~e~c~~zwSq@~~~\yt[Tsb3k~]Md/poscU~~c\,~tUKT`^L~uL^|i~utI~~~~Vkx<~bK~~^|fJx~t~Go~J~r\PPV~saf^qt[tj[qQV]TB~~Sw^~~e~~ai~ve~x~YnsKd]yvF~~e~_j~vU~~~b~Z~_R~(~~~|wW~`wy~bwkOqKnqiv`H\*wwkRLxmoK~L~fY~Z~3o`~X<~~VK~mxw~m<~~eptiyvY~tvI[~~~x~_gz-}`2D5~~yQ/hb]_]Yb_~y\tUVrLvc~Mmc^]}Ysgvgr~is~bp~Z~c~Kurq~^a~_glYu`[Wr_js{ry\kvyDi~v~?zK~~gk?~f~S~T9~|W~~LsE~nL~vodqLjoKmaJcSiA~sO~E{pruuw~V?~SwKrt\~d]fJZuQwyiE~[PMfL{R~V~KbtgBfHfdZOv:fM~q<~~~rYb`~{A~wY``vz_~c.ysX*~~~~y5qj__~tka~xs~kfgmpTXEx=~i~%M3;VwnXNz=~~~iv~crQu;wa~?~t(~s~}xK~k~M~}xMu[A~_~d~O~~[ev{v?hvV`~}yx_qSqd\~yval\T~`rq\Z`pfJ~~u6o~=kxZit3~~~ud~}vV~d{Ny2~~h,7RtG~~xy~}C~ce~~?^h`x{[nd~X{&~~~`xayME~o_~)@Yp]f^~GouN~~|N~d]}S~ePjCt`=[nDq~O~_~{LH\=~mb~}Zx~'~<:~~v{X~`~OadQ~g~T{Bsa~s>~v}~]b[~~O~Y~~QJ~~^aS~azT~mHf_&~rt?~vfNWZuF~~GvmXtKmZw]~/~}~aMwx~H~Au^~X~przH~z7~~`~9~_pi~q<d~_~^jxqq}zw~br~=~rX~p9~~g^~s{dwwsb~M~h~^~_S~v~O5+~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1334/ccs/rev np:i:9 rq:f:0.997544
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTATAAAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCCTAACATGTTTAGGAACTTCCCCCGAACGTTCGACTCTGAGACACCCAGGGACCGTACTCTAACTACCTACCTATACCCATAGAGAAGTCTTTTGACTTCCAGGGCCCTACCACGAGAGGTCTAGTCGAACATCTTTGATAGTAGTGTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTTCCGTATGTGAGAGTAGTTGTTCTGAGAGTACCTTCGTCTACAGGTAATGTTCAGACATTCTCTTACCTTTCTTCACTAGGGTAGATTTCCCACAGACTACCGTCCCCCCTCTACGGTAGGAGTGATGTCACCATATAAGAAGTTACCCTAGTATGACTCAGGTCCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACCTACTCCATGTTGACCTTCTAATGACCACTAGGCTCTATACTTCTCAGTGATGTGTTGGGAATGGACTGAGAGTAACCAACTCTGTACCACAACGAGAGATGGCGGGTATAAGCGGACAAAGAACTTGACACGAGGAACAGACCGTTTCAAGGCTTAGATGTGGTAGGGCCTATTCTAACCTGGCACCTCAGGATAGCTGTATTTGGTAGAGGCGACGGGCTTGTTGGTCTTCCACACTCCGCTCCCTACGTGCTGAGAGTGGGGTAAGAGCATGTACCTTGCGCCTCACACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  _~`ugXp7~yrybr~]LsrGo]d~t%~{~~~~~~~iUIEIYmy~~~~{z|~~yssgDrVZ~x~i_T~}uy~a[e2m]0nI~N~vv~|>|vPfuZ?aq}~}~}T~~g~u~q~~I~~Rjp|~~~~D~tc~h~|zCn~'~@}[~b~~w>~~W~E~peZ~~|V~NDu|yadyk~~~~~~g~b~~~V~~L~~~~m~|sa~V~Y_F~X~>~i~~QoD~c,~~~~[b=W~X~h~`~f~~^|}~g~D~mN~~~G~~j]~~C~[~nWpm~iKGnzSS~_jgg~3|~hyOyh~jeRovF~~c~e~~~7~v~ojdY~{M~ux~B~~d~~Oky}}~ma;{~}d~{~dk~}qg~ny:~b~~c~M~~a~~?~`~~E~~o~xkrqkn~|u~gsg~6~}~c~~i~~~`~H~iS{RS~~m~g~;~H~~N\~z~@~~~Rh~H~~~~~d~~~dS~~~~?~~~j<~n\~Y~~z_y~eY~~j3~gp~e5~~~~j~QV~~h~s~~g~~~VoWl~h~e~ew9~Fa~~|`~`yzS~~elC~xxe`~~K~~}J~fY~~ok~mY~}e87~nY~~~`cG~~{R~Z~{j~8~~}`Oa~~hN~~f~~o|~c~?w|~/~~~7~~~W~hv~l~paY~y~zV~Xwh~}k'~V~~~_~a~cx~es~I~maDzzm~E{]$b:Fk~Y{g~~}e~c{P~~~l~SYofo~{wH|C~~c~~}U~~c~fX~K~^~z_Ryk~[~~~\~f~~ve~~P~crp~d~C~pA~e~G}tT~k~~~S~~=~~a~~`~V}~f~eq|lR8c~h~T~~S@~Qh~fj[ac~es~T~V~ic||w~i~T~jy}DO^x}~f~~jk~|EhLz~_~Y~~}[~h~~n~:~~h~f~T~~Z~~~}~b~~n~e~b~'~~~~~~~~|t8ti~P~~Trf~uQsueb~~Yyl<yid~f^~~N~~]~d[~\S~~~~~C~l;~~~~~~~h~c~~]~G}~r?~]~W~r~}d~Td~P|~~~h_ba~a~O~~~j~p~O||ej~Tp~V~~QnOi~q~lpf4~l{e?x~L~sdqFwM~~~~h[~/~K@I~~g~}_~~~~~j~~|bj~>q-~~~~~~~~~~D~Xux}z~~~~E~}la&~}{R]~~_u~af}B~sD~~T~~~~?~|hndJ~~I~~Ny~B~~Y~~T~U~P~ELI`W`OdB]R\y@OzK[[|aa~~i~]~~~`~~h`i~K~Q~~~mSD~x[T~S~cxlxS~~?g|l~W~q~~re~~~b]~Q~g~m~~iz~~d|V~~{jzL~f~Y)~_{zI~eFS~IDFlXEeOOA&{~m~p4~~~uT~W~bmy~W~h~E>b'[/yF~tpa~vN~auU~aA{a$NRemYaoNvJ~mu0UA1DWvVpJvJqw`~C~e~w~Oq^~]E~~gr~O~iF~oZe]aQAw\t+~~P~r~@~tyVtN~RL~M~a~Tt[@QbH~]tvNc~Z~~K~jtZn8}_4~l?~~rPiNC~IrRui~\~~J~uzR~^okGvxb~^NdZej`~a~Z`3`]`d>~Y~Ls~aFNm\~Q~XuK[~|b~b~9nf~wq`J~`CxbG~~?~~}z~iwi~d~dW~~YR~~`]T;~O~~t~bvxQWODt|c~^xacrw4~~fW}]G~~]X~~w~~V~~~Yxf\`gZ]Z]MtJ~Zf7GtinW~[~~_j;~~\D~sA~bzN~r~tec/j>Qgko|M-~~f]RzucbcYaZCU7~ag^~~_}NeUs
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1378/ccs/fwd np:i:5 rq:f:0.996097
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGTATTTATCCGCTACGTGGTGGATGAACATGGATGCGAACGACATTTCGAAATATACGCAATGATATCCAACCCTACCGAAACAGCAATAATTGTAGAAGGTAGCATATCATGCCGAGAGTTTACTACGTTGTAGCGAGTTTAGTTGAAATAGTTTGTGATGTGTAAACTAAAACATACCAAATGGTAAAACTTGTCACCCCCATTTACATTGCGACAGACACAGTTATGGAGTGGATGGAAGTGTGTTCGACTGTCAAGACCCTTCTATAATAGTCGAACCAGTACGGTAAGTGGGCAACATGCCCATATAAGTCGAAGCATTTCAAATGGTTCATCCAGTAGACGACGATGTCCTAGACAGTCCATGTCTCTTCCCCATTTGAAGTCATGTAGTGGTTGTCTACTTTTTCATTGAAGACGTCCACCTCAACGCTATGAACGTTAGTTGAGACAATGTTAAAGCAAACGACAACGTCATTGTGATCTACATACACAGTGGATGGTTAGCGTAAACATGGTGGAACGTACTTTGACTGCGCTGCAAGAAATGGTTGGGTCGATCGTAATGCTAGTCGTTACATCGGAACAAGCCAAAACAAATCATTCGCTGGATTTAGACCTACTGCACGACGACGTCGACACAAGACATTCTTGAAAGGAATTCAATGCAGAAACTCCTATGCACGTCGAACTAGTCTCTTGCTCAGCGCTAGTCCATGAAAATGTCCTAGCTTTGAACGTTTATCAAATGCAAGTTGTGGGAGTTAGTCATGTGAGAGTTGTGCAAGAAAGTGTTAACGTTCTAGCCGTGCTCAGTAACAATTACCATTCGGCGGTAACAAACGTAAGTTGTCACTGCACTCATGAGCATGAAGTTAGACCAGTAGTTGGGTCAGAAATTAGACGTGGTTTAGTCTGGTTACCGTGGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAGATAAACAAAGAAGAAACGGTTAATACGATTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTTCAACTAGAATCTACGTTTCATACGCGGATTCCACATCCGTTCTTGCAATTAAAGAAACGATGTAGAAAACGCTTTGGTTGGCGACAAACTTGGGCGGCAAAATAATTATGGTAGGTAATTGAAGTAGCGTTAAAAACGCAAAAAGAAGGAAGCACGGATCACTGCAAAAAGGACTACTCAATAATGGTTTCTAAAGTCATTATGCTGGTGCTCCCTATGGCGGTGGTCAGTACTGTAACTAAAGATGGATTACGGCACTTGTAGAGCACGTATCAGACCCAGCTTTGAAAGAAGGCTGAGTTCGGTTCGGGTTTCACGTAGGCCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGGTTACCATGTAAGAAGCGGTAGACGCCATGGCCTAGTAGGAAGAATGCTTGTTCACGGAGCCGACGAAGTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGAATGCGTACTACGGTCGTCCAAGTTGCAAGAGGTATTAGAGTCATTCGAATAGCTGTGGGAGTGGTATTTATAGCATAATAAGTGTAAAAAACATTCCCAACAGCATATGTGTAGCCAAGAAGCGTTGTGGGGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGATAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGCGTGCTGGTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAGAATGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAAGTAGTATGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCCATGATTTGGTCGATGCGGCAAATGTTGCTTAGGACTATTCTATGGTCTTGCGTAATTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGTGATTCGCTCTATAGCTGTATCTAATCTGCCAGACTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  UtXJ*VbLub\Z9<oQBS\Y\VGZS1rsr`Y^/ISo\`6sV>]ANSS1jbGq@\;IqT\`8qWGWTX=n>W\T\=vlTX9tfa\_FTW;*l`SQb\_3rGX(R\_\EZWFurSEXTKX_LkArA^EXKXLu`EXQ/]E`T\bYFhEZT1V-qqZT`@O==pSV[STWCW@ttZV-rWDiT[TX=srX_@D^A`Y\:vkTa5sspNTa[Fb'nn`Gyb)ssZTVtWE;.%P_mXWIWp\T\LfBSXAOKOKIMP\X@rDYHp\T*5nRM:b<o@`YbYTr>VFSbYbTAsR4,VlUsT^Y`At5HYbTW,oEgEXb\TLubNuWZ2uB6=pRE`Y0wdYGZa@qYbTYNqBRF>hmTFuubKtDrS\bFx\Y_3HIN>VLM[bY_&o_ZY\T\Y`+kflJPFjFK~>~~~dF~~b4~cf_eTbmRcoT~L~co_mR]/~~~k^h`~dX~dh_dk,~c8^kZG~\M[TelMV~^b8~fcJ~IOWP^4{ocK~@~nQH=zi^cR^X~_do_fL~J9`hiV7LD9i;]g^`FQ>~HX?{6~QL[Lj>~zGfnDkkCvNiOJeS6U~~deHmbHb^mMY@bK>yvlB{K~Kooo_dho\JRW~ob^KQclHaK~P\Pm^P~Cz]GycPz>~~bG<sbn]QV~_d_o>|gA~]6bgP~oh_od_h_cR^dePdh1^8JaK'{>T^h_~FK~b@~~T~H~`~\4~md]Qb1~|GlO~neTb]^^_dDLV~XePbh.U][~d_o_fN]d^mPKV@yhod?~~~nbTL~Ted_U~~dX~_cF~~fk^/~wlMY1_aL~aT>~~hdZ~hdo_hndlLdaec`~clK\K~dD~jJQaGaF~^dXb4f_MN~dj5Ff1ddoI~^X~`~hOh;K~^R~[=~mAvX2aeZLmX~cO~co_h_od^gM=7dh^Uc[;ldK~cL~fcP92)aeEa`~K~~T\P`A}mP~g`'\doT~F~~eLiEiMlL~e=~coS~I}h^X~ohd_ocG~[U[3~~bFmc>{daF4~~choN~~^D~~cEf\.y~]S{L~Gwnh_a8Y~df@~Oa0~~lg<_IF~m>~4l^T~\5~]nh_~2|FKT~|GF~^ohdW~e_mR^dH~iH;lg_d^T~h_~=~RHfoM~ENu]Y{I0U~K~?~~c?~zW_godmOKG~~~^d^V~~S~_~A~]bO\'|]\Zm7~~]Q~^%~~nnS|Cz^oS~l<SynH~ZzdUebUX\_d`~1~~~l]\E'p~~ubI{Q~JucJAJS~dITR^od^6~~~~SxOHmh_o\7~lJ~oT~C~n5;+|~bo_hY~QmdUNS~od^nA|odImT~^Nc_OqeBedoh^nTnW~[MK~~cQmT~h`~^ISyHf^`~daZdeM[O]dngj[fcN-nkg`2T~~]A~~cVxA~]ocQbL~^T~V~^>~^C~~]_E_dQQ|O~lPcW~_de0~PNfQcX~doSzK~3WG*DKaQU~~T~K~PM~Pf\;MscH~c^S~nVG@]dN~QmT~=~lQcmQS~F~bGxnd^`~dV~Zc1=wfMN~deI`$`b_~Pc`DbgbOBr]SbF~cD~~dfM]e8~Pm_?[@~lUNeE(SS^ob4~md\LkMZnh_T~lHbjL~H~a4~b^X~dhS~k;Ym;aQco_h`~_dV~fNcX3^mL~~eLlO~LM5o]LkJGE$dDvkTidnbS5~~~~`Gf`~F~nG~^hd[8deg\QJlhb7~Lob4~b\LF~Y:%NJO^o_d_dh_n;~~~dj0NL[4aM[K\]e6p_h`~X~G~~hdodhoecF~^ho_M~~do^@~lOE~cohoS~V~~hd_hY~O]od_doho]J~LZLTZ~d_bTb_oT~oS~o_T~[hdod]0~t=~j=cmRu1X~D`FP]o^A~~ndk4Zg^X~d_g`~WzAf8f]oh^`~_oX~X_eIRaI{3aR~X~c6}nQtHfR[~De^dHMgS~TbR|_Y]di=jo_dJ~lL4ZJRedohm@~m_b5~]dn4_^JETdneLg.jdh_h_cO7~[OC~[.~~cX~RtgcmMY%_L]'~ihocPF~~QzP\^_MZAP~];hhgcL~c]GfdLZ6YmOZs]gbmE~e[`~a_coJnI~cnb3daO5~~cMc:GJ~go_oX~S~ObR^bTR~U`KU~^d^ZAXQiD\_nbL;eFe<~YLTcM};]Q]H%~~~~~~rg`^_fls}~~~~~~wleep~hck;Kn^nd_d_~LfmRJjR]c\_o~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1378/ccs/rev np:i:5 rq:f:0.994149
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGTATTTATCCGCTACGTGGTGGATGAACATGGATGCGAACGACATTCGAAATATACGCAATGATATCCAACCCTACCGAAACAGCAATAATTGTAGAAGGTAGCATATCATGCCGAGAGTTTACTACGTTGTAGCGAGTTTAGTTGAAATAGTTTGTGATGTGTTAAACTAAAACATACAAATGGTAAAACTTGTCACCCCCATTTACATTGCGACAGACACAGTTATGGAGTGGATGGAAGTGTGTTCGACTGTTCAAGACCCTTCTATAATAGTCGAACCAGTACGGTAAGTGGGCAACATGCCCATATAAGTCGAAGCATTTCAAATGGGTTCATCCAGTTAGACGACGATGTCCTAGACAGTCATGTCTCTTCCCCATTTGAAGTCATGTAGTGGTTGTCTACTTTTTCATTGAAGACGTCCACCTCAACGCTATGAACGTTAGTTGAGACAATGTTTAAAGCAAACGACAACGTCATTGTGATCTACATACACAGTGGATGGTTAGCGTAAACATGGTGGAACGTACTTTGACTGCGCTGCAAGAAATGGTTGGGTCGATCGTAATGCTAGTCGTTACATCGGAACAAGCCAAAACAAATCATTCGCTGGATTTAGACCTACTGCACGACGACGTCGACACAAGACATTCTTGAAAGGAATTCAATGCAGAAACTCCTATGCACGTCGAACTAGTCTCTTGCTCAGCGCTAGTCCATGAAAATGTCCTAGCTTTGAACGTTTATCAAATGCAAGTTGTGGGAGTTAGTCATGTGAGAGTTGTGCAAGAAAGTGTTAACGTTCTAGCCGTGCTCAGTAACAATTACCATTCGGCGGTAACAAACGTAAGTTGTCACTGCACTCATGAGCATTGAAGTTAGACAGTAGTTGGGTCAGAAATTAGACGTGGTTTAGTCTGGTTACCGTGGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAGATAAACAAAGAAGAAAACGGTTAATACGATTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTTCAACTAGAATCTACGTTTCATACGCGGATTCCACATCCGTTCTTGCAATTAAAGAAACGATGTAGAAAACGCTTTGGTTGGCGACAACTTGGGCGGCAAAATAATTATGGTAGGTAATTGAAGTAGCGTTAAAACGCAAAAAGAAGGAAGCACGGATCACTGCAAAAAGGACTACTCAATAATGGTTTCTAAAGTCATTATGCTGGTGCTCCCTATGGCGGTGGTCAGTACTGTAACTAAAGATGGATTACGGCACTTGTAGAGCACGTATCAGACCCAGCTTTTGAAAGAAGGCTGAGTTCGGTTCGGGTTTCACGTAGGCCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGGTTACCATGTAAGAAGCGGTAGACGCCATGGCCTAGTAGGAAGAATGCTTGTTCACGGAGCCGACGAAGTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGAATGCGTACTACGGTCGTCCAAGTTGCAAGAGGTATTAGAGTCATTCGAATAGCTGTGGGAGTGGTATTTATAGCATAATAAGTGTAAAAACATTCCCAACAGCATATGTGTAGCCAAGAAGCGTTGTGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGATAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGCGTGCTGGTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAGAATGGCTTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCATGATTTGGTCGATGCGGCAAATGTTGCTTAGGACTATTCTATGGTCTTGCGTAATTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGTGATTCGCTCTATAGCTGTATCTAATCTGCCAGACTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  WuS@D8A1RFAUWCc:PU_TLQAFB7i]jFLTW8xpO0GqSAD[XQBAZGDlSYUIuV^E6ZW0=JTHtXUUW[+gKS<t\C,P^LULEm7RWUFWHtLmBt_AAEqT<uoXaT<QmFUu?kT\bTIfD[G`TYb[UDX\CRFoRDNXTFuubYWRV>?jSB@PYTbTFuubTMuUKumF^>ErnO+Qb\T\T*A;ssWF8iumYb\]&<mJ/@8D)qrrW=rSX*];fuvubDjTaWF,nQU)ZA_T_XaYbT=r^1Fe_>ZGvb\GwVuT\SFR=pV>_Y\T+^W?m9]2qqNuY\`FLsZGQ\YS1pFcGQ\aRBoFUtPX=[\A@rXbYTCwvbTPZG\>IK>ToTYb;vcN;Vo[/dK:cV`D7p`R)eXTbYTbW:SSSVBKE]9DA_TIXb\T\UZV,i2Zso`;wjTQWSFXbY>C`KGBN1T>5K6]A2svviX`=@+@lSTYT\HwbHhFU*pVTKQ^YUQrQ=?q^S+A>MSbYVu\T)rSLuh>V>tqW>_X@r@QFXa;r4MRFCXX@>\F\YbYaQT8uMF?C<WaTNSF*r\WGSC_\GwVuXP?EV9tkSbY\TXUQOTUEsR/q\RE]=n=vS:GO`CWT\UtFSY\aBK:SMqGW^/TE[BrXVuTKc)Tjj@>qr\Y`,oVQBBFxbGuuaSHGv\bYZ;)]W>TARbYT\W:TY`AQj:D>Z&kI;kP=sO6sTs=rXVu\TY](,mqR9Ju\bZ>WbYT\YUUuXE_TIWEV+nRYZA];LSXF`T\Lub\T&qZJWSFHfE`TSB5aSBrXS8rr`\Y>vr\TYEsS<W(B%L_`T=raSFTGA9+9_TaT@A(?PA3Y19ngQFQ,6.pO><oWE`TLuO/LGGGY;YE_HG]KTbHxb@rYDlR8/@DUA<rsXR.SsT?kTZ@^TSTYbXCWb\TbTY`-ZRNbQMoGPF-^Q=JKJR(ZZZY^T=]]?qaUaYT[7t;eoZ5ETR4=,UK%XO[8aLsrSArD^>W\TItYZ@;rj=4]SFpTbX=ssSb\>voX9njROmO'ST[XGs=`RsF\W>^=rPM5s`P;ZP/^NsX6fY:aArXGwX>sW\a=rUuTF9JiYVuXE]:SoFWE`YT8ssX`F`W=V6r`OuLubY`FKuTNuYOuTYQ^LX(rfN9[n@O\H@HQQEhutYTY:u]AG?G4VA<-S>qW?]>xqX6rT7luh[Aq<o^EFtF_3WcYxG~]CA]giXd_Wr7~~~aGJ;~~~~]IgPz`~_dodO~ofLlb9AT)~~~G>kSbhodQc`~h\jhLm1~pcQE~~\=HQP~ieIa<LsM\HfI~~Qme+m`;?;IwNYCZMjLf_gO~cgG~}ZgP:zGDync?fMmcHmHeo^mGKmd_hmQaK;k*~qo_d'~z22T~~^`~P~^J[?ZFf`=iF~b:~Y@~~`9_^RmN~@~P=?1x`DcGf8gPW]\jZRKgInL~b?~mLl%~~L_+yM@[nfZMZ}^L~ZcMmhj1hL\T~ohO~Q~hn^Rm9x9m_>dS\\S{]ErKld?~n^>B,^5Z<iXKqS1fd^n\a@~co^<k^5mm[R1`nCilQ`&oIlhndW^;rg^aFYULDHD$ib;ka;iP`1cT~`~^X~\QLu]h>eOjThlZ]\RLlX~d_`~hmHbfDM-dRf\9M~cn;rbcOR[dgK_~h`~X8V&$t~ygIc4y9~~_~do]Mlgl;[g^glDO`LlN8jNd]2}[O]`M^[NZlLe?~~w^Rbg7xG]]bT[bT?f4jVu=p<~wf^h]i`o^L~cohdV~~]:JRhwe4~[hog=~?~~k]NkD~mdh]M\dRLbJvWbVD9l]d]PFbhK~Z6ENaL~coZM]cI~~RyNl]=Mu^4e_GJlb;aV~~fHAo_ocJbZdnW~K~El;kbSYcF~ch`~bHeoh^CgcoO~V~^V~e,~a7|mK}ZcR^RbmMf%YPyRXT^gK~ec^_~R\_]bc\QlRN~hd]8~b]<GM{^dbchmHedh_odod]R3~bl,~bV~~[TdJmo^R]c7~lG@~SR[g:niHxRQDdQ]c=~c2yODP(bHa1}bO~f]]cAwchohM~b]Qz]^[N_~4j^R]V~_oN~~_S~TZ1y^`dh`~MnNDMKZ63hI&hF~bHbhcQkQm^dgIMSPa;^~hdh^S~O.icP$jrz~~~~zvtrqqrtvy{{ywwwxyl]TONISCEV\Y\TU',jRb\b1jbY\TYQ^
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1407/ccs/fwd np:i:5 rq:f:0.986358
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGGAAACATTAAATCAAAGAAGTTTATCAACCAATTAGTACAGTGGCATGTTAAGTAAAACAGAAAGAACGCCAAGTGGCAACAAATGACGTAATTATTTAAGCAAAAAGCGTAAACGCTTACAAAGGCCTATTTAAATATCAGTAAATCGTTGGAAATTGGGGTATGTGCTGCCTTCATACGCAAAAATGGATGCGACAGAAACGAGTTGTATGGCCTCCCACTACGCTCGCCTGCCGCGGACCCTAAAACGACAGTCGTTTGCCCAACTACGGCTACCGGCATCGCTCAGAACTTCGGGTCTTGGCCCACCTTTCTGACGCCTAGTCAACGTGCGTCGCCTCAAGTCCTTGGACAAAAAGAAGAAATATCAATTGCAAAAATAACTATAGGTACTTCTTTGAAGAAACCAAACGTGAGTTTCTAACACGACTAAATCCATTTGATCTTTGAGAAAGTCGAAGACGAATGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAAGTAGATTGCGTTCACAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTATACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAAGTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTGGTATCTAAAATGGGGTTTGCCGATGCGGTCTTCAAAGTCTAAAATTCTTGAAGTTTGCGTTTGGTCGCAAAAATTATGGATTTAGTCGATTATTGCCTACTAAGCAGCAGTTTAGAAGTTTTTAAGATAGTTATGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTTT
  +
  QlRNXNPFlV+T8<g<QNYRZQYYN5MbeLRYRNXCL;jXXR4cNMVXO([O3hSJFnYNMlRYFmYNRN5kkhRYL;4bNUMR0M5V.RQLCLk7iiXM*hgQIP<Dj[.VL6L@i8fIiYRYUJW<WFkNT'9Kg:g;V'hhgMPH<`RL@U8Q@j;iRYD[5LhM7OcXRYMNMJNJeC6^hJNRK6MFOaP7IKCkM%K9LiTF.eI=P0^N->j]=LQOGQ:>OQEikYNRMl5J6LX1O$ff??AU<U<LVN(35\I+CWDH70ZhigU-CG<P69BIN,AiU/2A?;TQRDV3H7OT&???5I;4L/;7<BXW==^KEBJ<(OGH$?I59;6$K;F.M?^hQ'ILCG.S?95G8=.$ABOL>EHLJMLCQJhHMgN?mmSNIO3e9eMQ(R-GNGBK;D0=dM<H<9BSIRW<MQAMR;JM9-LRY%:=fFkTI(g\QRKEQL7TTXSWM9\7YM50fjjdV>J;VCXYF\SEM<iM9hjQ=gQ8i\@b(ggMRYQTPFlkNVFL&MMP.LY=RJUChYCOfQCWM4jjPCQAMQNYNM<^3NIL:g>MIhRYRNRWA=CV68&@XR@hNRYQAMRMlRW8L6MRGL=Ih8DD+AdRYRYQ;iVFYXY7YR4aRMFkR'cPSdVIW&DWYRYRM7jD(JfR2dTTS;LjRL6%EXH=)NYMlNR7jjJgJ>cPcILXK.LWXW2Rc<CjSQ9$6?NPL;7]RNOGP8R4(XQ4[L@OR+eA,Z57S=cQSBfCBdQ6996V:hO:JR9VP8DiB/[RI>+6ciJk.OENW8WXCV<VKBLR2JM?ljQCQ(iiiXJ^CP.GSRCjX<iJ`Q;j4cU<QMEJP<V=jX3X:lh3TEi8QYYRV8QC98NccFkkRYP23cYL;RIAGM@k7M&.E/TJRW;*fLQ60WN*U:VQS*dI\FlNYUMRMRMQ2=SEPW8Q<mlRNS=jMOGMDCV=XB*FMBNP3LQRYRYBc@B:h8QY$fgCCQP(3K+Dc8WYXNMFU.WQPRMYYR<SLW=AX>SD(e5CYL@;f3X*B=H;O%OU%Ce?7M&(H*hjUGF%'dQNQAL4_OJHLHRL3hXQ0MQ7jjYOQ5I8%NOHY<lfNMiP>:MFiR7jjTO9lgQ7gXFmW<MRYCoYF^6kkjYRU7UW6jjXR0V231H=/Zi_RMkR7jjRNQCMYQ:h0OMN'ENUMMk<iMRYL(ggQLh<U;WNJa<K<WNPBWP-HN9`IO3K-hD;i.fRIYFnYMUIH/,TgX;mmh<ihRAmRXTHJBJYNMlL&K`QW8T)hhT9g8LiR;iQ9kfO4O?lA&eU6;K(gZJC)gWS>DTCelYRYOSX<gBLj<@kYYNX;fNFNRMXQ+jjXRFWN1kkk[8MRYTK8:R(;B$IMO]fgf_UOR[dggggggbXPLJMZeb<<WOJ95\IEH2ZHNNN;]NENG1$I\
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1407/ccs/rev np:i:4 rq:f:0.990503
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGGAAACATTAAATCAAAGAAGTTTATCAACCAATTAGTACAGTGGCATGTTAAGTAAAACAGAAAGAACGCCAAGTGGCAACAAATGACGTAATTATTTAAGCAAAAAGCGTAAACGCTTACAAAGGCTATTTAAATATCAGTAAATCGTTGGAAATTGGGTATGTGCTGCCTTCATACGCAAAAATGGATGCGACAGAAACGAGTTGTATGGCCTCCACTACGCTCGCCTGCCGCGGACCCTAAACGACAGTCGTTTGCCCAACTACGGCTACGGCATCGCTCAGAACTTCGGGTCTTGGCCCACCTTTCTGACGCCTAGTCAACGTGCGTCGCCTCAGTCTTGGACAAAAAGAAGAAATATCAATTTGCAAAAATAACTATAGGTACTTCTTTGAAGAAACCAAACGTGAGTTTCTAACACGACTAAATCCATTTGATCTTTGAGAAAGTCGAAGACGAATGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAGTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGGCGTCGTAGATTAACTGGAAATTAAAGTGGTATCTAAAATGGGGTTTGCCGATTGCGGTCTTCAAAGTCTAAAATTCTTGAAGTTTGCGTTTTGGTCGCAAAAATTATGGATTTAGTCGATTATTGCCTACTAAGCAGCAGTTTAGAAGTTTTTTAAGATAGTTATGAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  YmNRUHYCeBTV;9iQNRXI>JCWR3m^KMNYNRYYRFVPYNAQJ7PW8H_dHz[I7%GT5rU_EcOZVZ(YoZVa1S5Tre\`Jq5M:ZrY*1Y:]td\@{sNTqQ@XoaMLTwOzViQu\?Z`DKOaE`ZecAMiP_>I2zj\\Y'/7M>EpZS,bTxVOG|[@yZ@w{dWbFRJRw@uJ7bE1wRE1vz{pV[@8?lz\WY?\_\I|kEyAIbJ]K=LKEWCQW5*=[CYRM/<2W3hi=K1TfXYYNYM@XMFk3MKUSQMNR1kkkkYCkULNRNYRYM7jjQKONMjMCXX0iEYNCiYRYXRNQ=FM4SV%DhNO>iS?mmY?mjRNW:;FBP86bSK=jlMiONWR5bMIQK1_OYW;KN=RYNMlQ*fQ&O>?<J_0i<jlY>J>OWMW8TRNFmYW9WN7eP+<&OLYRM3hAQR1BK4]>PYR'PajS7BW9AihW??NGh-e@9P1hkkdCKgNBNU>/gB?:IhQ+fWL;jMEia3g8hiND=(I31FMMAKZRYRNYRY>l\E0_R7TTMYV==kR8WM3dOJL@89cLERH72ELGbEV7QM<JBF,AVNUYM)hPI)9WQL1O6WRNIjNLeI6SP)hQDaH>/RM<iXCoYW9WKBf782HF-`jYBHP;fXX;M>Q'J]OEN85ell`NG`G<J*6TPBZRWE7Q(8KdLj;3gkD,LYRFRFXU<fjV-<7LPRJ?WK((M6KB+PM%94^hK&K4ZiEkY+gfLj9UUXFnYFlkROYRYMlNUYULYNRAmY1kI<K-6hj=akYRYRYYYYMFRFRN1]R:laL4L3aN`Y@bR%DjYNCnVJjMkKCS+dS8Y=LjCLTMlYCiFkk?Z?Q<KBWMAPBMX1mZ61ZjMXNRLh@P;TQTPYFlXC-kA6ic;:8MkRM<WJ,PIiNYHjAJ.R:VCQNOGPK3cYMlYRM8iXAQYMlRLNVRClMlRMkN(cLL-JJLKB5D]NXLhRMC(NZXMUJMlY5aRWUWL-,b)bkkXRYYM;jRXNFlEkaB-F@j<WMlFN)hDi@K9hkXAlEQYX0e*ejc+TA8DMLOG,O)jgI:U7HQ1H?=WRN7iiTKK%gJ9dLRY=miQ7VG93?HbNEkg@8/eRJMlY>S>EMK.EkY?P1iiiWN=@Ze/64YM4cO^FkY/PT?4(D'LQMRNYRYM=cEkiC9jlgRAhMlRNYRAk[J9MAQ2688I3aQNYSKOWNX;gIWNW1Q=cg@]BbQIXBkW@WOL9llP9&E4&0KhMDjNX2QL=8VCQMkR?mS8AP:(ZlQ:iJ<cNLi88gbJMM-ObM5]YQ8N2POaR>PXW2XA7iiXMEQNYMlYAgNFlYYRYLi8:=6QYM7iiXNIW:%QQ]X88LG>RNM<iXRD$ijjjjjjjjjjjjjjjjjjjjjjjieT5UV:AL@LRN+SNTXSCgSE8,8%a
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1426/ccs/fwd np:i:6 rq:f:0.994023
  AAGCAGTGGTATCAACGCAGAGTACGGGGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATTGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTATCGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACAGACGTCGTGGGACGTAATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCAATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAAGTCTTGTAATTATGGTGGTCGATTTATTGGTAGTATATTTGGAAATAGCATGCAATTTTGGAATGGGACGAAGAACCTGACATCTGAGCTATTGTAAGTTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  I~dFW_eQgTVlZL~XcWX`fKah\(~iNJaZk2fj~i@MhXV~TWH_;Rd5lJa@QBm\9G&NEDLlJX(SPH~~nYP6~TTFewU[]~EN_QbTjGSUb[fBhJ2}dNzS~gW4jdTeMI~mlaYen>]F:LdJLm`UWhR~TY3~~NmgMQP(F_coeYOgHndhDc>1W'MQb'eQfROQb>bEYzLk[^B_h\~OZ;~~s[fl\jS%O[`BR<?/HdYA~bcRGdZM[,W.B+)JMCS>cVQ@eZkP^kfHD~jnBlM{>WfWPfMofcWOXVEGicWY@\<T`Av~nbXR~eR~W<c_(QMSZN~c)~fPY+a?ojUb7WsP~ncwdylIu[W[H`saa[VM~co^P~W]Krx\F~rxlXUX{~b-NYawclpC~^oV`v[sDZagnm@~Z^B~5ohcuI~Y,\D~QpZG~JxYCg_pUO\vMl>XVKZH=N~w<~~a;wW[@i@PM=[S~T2<S~~Xf]<GNy_H^~Z~a|2gn0^~Ud~mc`glU3nY`kS@A^mXRvor4Z~WFOkD]k^M2A@L>Y[`JaO\]5r=G=iYlGRJW\JRztZAJGJiUKjfNmsnHMoxg~Y39XLE7AJo[B|lBke[aNmDeWsQJ-IKD[ccsL~~w^_w$WmPVN_\FTJ[Zq\%~pv`noB\GkXJO~ND~rLe~nY7F`qm@~=JFOda,\HrT[jshcwt`N~k_j7dVa]qYQ~qK~pNE|acg~lxIsDC0[C|~~n[bmNmlh^sQ~j_~fUDO^qrZ?~W~oyske~Jiuj`bn\~hYbkIOhPb^M~aT~`Jsg\Xbl@~l4~lzn^WG~MNl~e5PAI^bRQVjiUWUX1~zRUyI8vkJXOG~ME`Dqq[W~UBhIcVPOezDR4Gm|hEbZ5>M^=i@fN`:eE8/\7gi\JYlMV^Bj2PHHdpb9~U>dz>~x8hD\udS;o7~VjUtMS~mYNR$nCE=cPrQCbD7Y0Ec~T~5/FkYe[nkOZVp=~~rS~Lng+c\WFc9g^WaEmSLA[[c(&baGKgTX~cQBM<0j}@\O~k=<oj.V>W1>.Q6~JjkTVe8EOjJ0SB,dTNn`2fA9VWYUNJ_fmZOFLAsWQ~~fgG/bye[7xaR9n[dHoiDiGpcGzQZD8qFMQkflCpQAlAgW8~S}WQgQWAEhQ%C$KFSe_RGD@FVhnprw}veSJHLV[UL?=H_alWZj\h9Ye]~flUg2h9C9/Ej~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1426/ccs/rev np:i:7 rq:f:0.993881
  AAGCAGTTGGTATCAACGCCAGAGTACGGGGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATTACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGATAGCCTGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAAGTCTTGTAATTATGGTGGTCGATTTATTGGTAGTATATTTGGAAATAGGCATGCAATTTTGGAATGGACGAAGAACCTGACATCTGAGCTATTGTAAGTTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  37K*FK%27<N>MY0sZQ*ZR>FFJc\/|tZ=/@m-s;4Wb[ma7~U~ThH~hQ~TQ^S3^bY5/kQTfUkZKP+^mmaPPoU]3MwleL~T~ZcWc\It~[fZM~YDHCMO@qhc.eYQYVBb^`AFSe8l]P?L@JeZd>oG~XFFk~?|bUTK<hf$9A'Uf\mffS7bFR~~V~iWDnroH~cZ^|eKp1idEC~eWnWLH~~nb[lNVk.]TdWacK[3TjTR~~FkeWP*eLcTa8@~fahn[b)GS`e@U;:EQ~PRS~T~h`Q*sEEm~m[BNgbW}\ia4lgc1EngNZfI~kLwPkmmTT:KWx<9z?I~aR@y~dXkGkIzZWlfk2R~lOkd8G5dHNuiUPXmFkG~`L=]mUkj/IQxVd[fojDe0~Nu_LeZTbgcUXZ1f\b@?'dMNcK~`Qb(VWcIqQghH~hnJQLy@\WcXOidZ8wh:nzf_~f[lXh[gm[?uWHGP~mFRUJrM}bV[x%yU]_VlN8~XEyAMI~kMEkhm\mlWdXZe[[m_4bSkdFkhRaeXhk7NCTgF~elbY~XTdYVWaEV`Rj<~lf[^Q[zFM~ZfnmoaE|bTz\8~m[]~I~UYT~[P|eWWfn=~okNl^<]eW@AntT_>TPO;;A_C&R;aXlk/pslPlmYi`ZlN6p%GsQcTejeF~~kDCKWMM~VCK}~mFgTkUae8NEvc_*&q~NUP?BFd7bM78~R_+lBW8~ldFc,aIaTgKW1~nJ^Q?^YLdCVAa;9dQ,eBbFWfB'hMEOK0`C[~[nfZ8~U]~VFde]~eKgLSEjXZ~mK~imZTRMcEX4hW8Oc~gUK4|WhAK[e:~jTGWV9l~uoZ^~X`1E~~R*eQWF{JV?dT9nM/m~~bXibdfkji6logHUUkkUWUk[mVtENYEmbkOPfwZAm~D~k/oe[lOWnCXK^2GP?+~h*d@BAXL~g?\~I~ANViieO>RfK~C~~kU&dfliVeGm8y~\GjGXS7KJdZJ{T6pNqYZeQhgNmX>U]flV~[nWiWNp|Y~D~~lPdjBpLdJT^l6MUTSkkWU7EhXQ~~NDk>sx(vlhNSchEh`X=bkNE[~OBLwZkF<p~nT[~TBP~BYAh-NDAyX9yJyi]~PD~eTbKvlGoQ~~Z~L~bWjR1jfj<QK%zwndQWdjglu~~xsqu|~~~~~|uqobJFXlfnfo[fZ>~YWWi/~jXXZd(~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1446/ccs/fwd np:i:7 rq:f:0.992312
  AAGCAGTGGTATCAACGCAGAGTACGGGGCCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTGTGAGGCGCAAGGTACATGCTCTTACCCCACTCTCAGCACGTAGGGAGCGGAGTGTGGAAGACCAACAAGCCCGTCGCCTCTACCAAATACAGTGTTTAGGTGTGTCGGAGGGCAGAACCAACCGAAAGAAGGAACGATCAACACTTATATAGTGTCCTGTCGGCCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTTCCGACTGACGTAGAGGCATTACTTTAAGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  f{`Xnb`7SNehD8xXXNQNcJf.?6ipo(YHf_]'^YS4f`fTbVJeDq6bkB^hkZG/\KDPWQ%SZL;f:`KjQH?OI7NZYZd@BYREO5Z]F=jkZf5W`RaUGMLbGMlR_gFVmckaKCWLZfHhR]eBIW?~lEM^K/JKW0RP\M<>bSEd-UUBaFIjKpVZSN_QbC^K,eKmfX'@`MJMCVmR7Q_[MMWJU<B`RL=\\\IroH_P@hM[aKYGFUlOdD1DnXVkP)kUPRXSIrfW^3EoDbh^SIQ/1;6I*N?VV=X=OO&OT/[^FO72L;fB`%PN?h_R&DCD$OMOG^H5TAWUGf=LAJ]\_O`9i\>:M+`(Ub0,YUB?idVj_h_R9_L]BIe@bsd-YL5PJ~n]bjVb@X`Qd](jOaJ~bedjnIxRiN5@'hhhskSQeCJhSUSbg1ypfQ~RVeS+vMErYK0cihK~dUJQWfIk9njhoYi]Rb8hZcZnR~knYX_/ObXUceMjSG~iXRUdVVOAZZWLvReZjcnTz:~K~kQ:dIkjcWyd7\N=:T@Y}_e>~MslY_cN]i@`G:FeVLVfJ9?X:aQYiYR~^~Uh[kndWL^VCkeApYJ_3~qNIVRV~5}LgL~WO^mbhAqN$W;~3nppnb61ikXd`aZi[NAVSOqX`K:mWd4LY6wZHvQmY^3cMWNXf;XAlXbhZOvd_Mn]*gbZbYaHh^R`Sd7E2~kFwvH~\UmaI{=lX;x7b`@Q~i_VxG[pLp-~}<4aUo`K$LamYbjYdRn5bd8jYPlJu8e_[oX9|;~ybK~YV=_QDMfc>c=rbWc&a1AXpYmH~bZ^I~Q~jB~b3~i/di[7de\YfSGPijINncXTVTRZfZ8iU`]7pn[W[PZHnGj>~a=Yy+ZZK@YJ*PPWS~o`nXB~mcjncje\AZ:koG>W~cjT~YXK~Wk>~mXbhES~E~;t~iTT\aU@Y>=9~WkTcfdRXQJ~dXgbBhZQhEbi]T\lHXGbQ?_+F@0~`)q*%{LTAKG=XchTYmM`@jKqkE0~k^~b$~~~zndhoy{rkkpy~~~~~~~~~~|sjjdciXYjYgLBPY~bXMeHoYUebZM~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1446/ccs/rev np:i:6 rq:f:0.985367
  AAGGTGGTATCAACGCAGAGTACGGGGCTGTCCGCGAGTGTCAACCGGGTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTGTGAGGCGCAAGGTACATGCTCTTACCCCACTCTCAGCACGTAGGGAGCGGAGTGTGGAAGACCAACAAGCCCGTCGCCTCTACCAAATACAGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAAACAGCCTTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAAGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAATGGGAACTGTTTACTCTGCGTTGATACCACTGCTT
  +
  :/)/.-iEFISAqOMLF7(/IOF*Qg]F%>E0[CBC1>F@=B+V+K*a2)iTW[HulCc_RRuDFW9mB]E^_R[AbNH0^.wUK.L;ZnX:urY[2Q]pm_NAQZ.AN2N]@;mYIC[RG-PaY\VNIHB>&VFN?\N\S\b%skZm`BnX@sYQu[\RP]6p`A5GFAvYQD>f=s^FT1KJ.?T.:T;uvi\>_ZaYaN@^X<%Z:laZ<W@q\KVFV2e:ROD87BJXRpR/tE<7V<8pMXM^MpE_mRVDC8LKDKO_7hU/HD<B5p]:c\CAJFlp>gNXULETcQ=pkEpCoEVN>EM?sZC5>m>XHM^N[PMMxa=aZ$nZ7<`W:saI/IJ(Y:A:8:mM;[@t4_m_LfIXHC]WQ_`YM$[TJUW=In$H-2XPN^c_DcOcQHP8uuuq^VLV[R`cYILcIut^8y^P_1>e[R\Ra0lnaKiKB]^VdI_0jgUd@OK4PMTNC=H4hJX6RLXA-W7AL;]WKrbW\@NUZcaRWZBmMI<CEXBo?WFMXN=]OMaF?QHCI[U9TUKQ=5AfIuuT(H7aJPB:B0)I@NE$BNUDX>TBV=P)SGXBK[MCI8E$lQ3j@%T96uuurZ^Sn8S)C<oRcR_NI&ZNU`;M0dc]W^NGrs[^M(VbJX:y`8jYc^5QTtO\X<xj?J%XHL<,nQJBQVFfLnbANW6]\RHuk8q^Zc^P3^O\Q^L>s4rsHupKuSM`^;nBv_EuOoO^Aw_RRu[Tk0V5_uXD=@nPFYS=]ZScZ_Cp=p?>tXPXCrJuSSuZStAuuQ/kPQ`>[Q-[KOnCw_c_KpS?ihWH*JAQYO'GEvaRuSBva4lmZ/`?7Xb_R_c_X$q]YYM8]YKX&sttJ?nrZT[=ZJa/S<j^YDrASCFTnQ'QWb_DtX;WY:ZE)SZEIIQ=Z=5\\`TDb<KDgD]G^Qm@su_RaV>r@q?iWc_Z^=^ZcZcBpUuaRaQE^T;riLzZii_YHcZWXAkTLSQAMSTicbGmYV~U~ZVb\Y:NEZ]F`)P[^Ap^d+yF=jX#primsz~~~~~~~~~~~~~~~~~~~~~~~}kJ/&$$3(,-$(8+~+JGMF7@F/%=8A)'9A18C?&0'
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1448/ccs/fwd np:i:5 rq:f:0.991288
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTGCTATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTTCCCGGTCTACTATCCATCGTTCATGTTCCGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTTGTGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCCCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACAATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCCAGCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCCTAGAGTGAATTAATACAAACTCCATCCTATAATGCTAGGTTCTTAAATGTCGTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCTTCGCTAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCGTTGGTCGCGCTGTGACTCCGGTCGCCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCCGCCCGTTACCTCTGCGTTGATACCACTGCTT
  +
  TqXMYXa:m_C\K;eNXLCWYSKYM$hiiiiiihg^UQPTV[ZVYbhheUHIL_;F81bSCQRGjV8LbMY>d,JcWCIeJLbCtWCLXbKlYLC@ocYXb4t\JlCLcJS?oG<Z5j]KIN@lXH_5nZQkMBNM@`XK,H;jcL.I@DP9=XH%SQSW]MXWlKk^4(W>9b[GjaN`JJaYT?pW[JXUj6A[JUf&97_F*al_YMBlWBjX>XWlL9a6Ga5Jhe>K4UhWL=j_SFDVS?3dLaC?iW6F2V>IR(jjjWB^@`EmmbYSBMT3;[<XHC'Q('7A\.XXM\OMcMa8UMMkMllMmW4[MXcMXcMXCtVlM&hjgXWVKDF(5O3.FXbVHE5W\CBnVjSRYTJXRgJ.W6bkW`C;)-]RB;6:PM6eQMSM,YVXbYMllXY5m_8QLcMcM`ALBn]JcMcMa5CXXY`@JA_MmXMYL;TiKCWb:HhKMW9iMjlYMHobJlHIMMllMXJ.KW9DWLXLCLXHJL3'gbWC;RE:K:G>E@_@rcU8\XS2WRMb@pX3_GH;R61jM?DCLcYMYXa=iJlCLQO'FB8j^'UEC3UVDQ=7HXB;AKcX3iPBI),LYbOYbG1WiXcLCT,&_A8687XCaYZCpY?RYYB\SO9N8O82)=Q[GZCoLmNBlo0OCmlCk>aL;a`ZcZNNnLm=obIP+oo[1bC5PiZLmYNYcXXP<KJ=\ZKZcM2F*oeA@cKE(a/+)E?TVcYcG,Hc>[kYZcCjCm](i^7NVAr_6dpb<kKm:lW?q>kJ/MFYCa<khMA1P7ZTSFO>ljYVNCmc.@nVJXYbEIIR0W[<QBO7UBIX:\YcYZA\<h/fWHOK?YAU8VOAGNn]KKL:&EVbX]8KhMle8G-X2Y>GF6@ZOWC>kkR?Z?[LR/jWVKIXYHCj8`XM?klXcNZ`KMH']>XD`-kSXbAdI8>>c)6Z9bNT^JY@pA?%GHjYCk,lVN]YN`.U.jjYcZWlXB0mVI)Q?IA^8WNYMCi+fkQWlYZMYEbLkKLDVSVN[CXArZ`HDE<%ZXZYCuYNJjLHOIE(7=V4cQ4jlkW>IZYcYZLma8aYCtZXcYWA%GdR=j^JY.L/TNcNZYArVk8aNnYcNLjLAXcOYNYcZW8aYY8lgVSSbUI=*+1SVlAQaWOVl@6B_LLCVa/nGDLD@lD?pQbZX<KbMcLmNZArYcWH`'oQB[CKJ%MQ@@XVF?Ll>TCPVEL0S+BHA`ZcCr^QBCM`YN]HGL0KMDi3VX[OXNU^JcT2khUI@@XAEBIB\W`AWNV9miXJSIVS:KO@F.[SB_ZVbX@cKC_8aYITON@F@:[@aONTOkY[8C4lmU7h\OWU<X59WY@fJcYZGjQMTQ7RURbBDJ.LEgWXOXOMn_Z`LB\?[_KZFV3q_QJEbMa@7MkcZcHU@]@UkBN(jeQL3GXYcX,eBhNIfNYZNdNNnUi0QLELljD`TScGmNMmFiK@^8P>+Y.VVIMYa8aXOXWlYWl>O2-jkiCMY'MGSYFXZcZ=mfNXAHU2hBaYUj9^WHBQBDXcYNdZLZU/VYbNGbNVlDXXJ?eSGJbL@Bk*gTNdY^E_Y]AYZAr`?+_lWN\S>cIqWl4na[WcZM0^IPSTkX`?`NTK2ALSB=h^>YZArJfLW7/iQcYNnYcLmcN1ZNYcKmK?kXZBhFKDYLHRD9orcIeZ3PSH\EJm`VAj;dG=<XV7kkXcYcLD`TQKiE]W@JJMD>lW7bbaNYCK%V^:/DiC@C;gRNdZ=a'giXcJk1PCkXcNYNdYZNWIGA:qqZKHWNSPKmEgBM(iiaKa0=_MYNdYWl1ULBM`A@hJGfJB*fgLV_6l];kVCkYaB%jNInYLO5t[I6ZSC.VMDMWlZLmM/kkkS.XEPCjYX9mmiWG0gjM-i-&U?J6JkNYZ4hFhLAM`(g_YYc5uiYNYMDI?JV?TVZN`+gLSMdNcE'LXcYa.TU^8orX?oV%fgCDUlALU%^Lh8XNSWVDCHlK[`NIkcLWJDJA?NVWHKm:nnlYCvbD_1YR5=-j]*-laKf,ooVUa&e_MXJ@5[)Z?WNcArImcNY&mYYZCtYa,cM=Wc<QTdNZHWLD[EZ77hNllYWlArZGRIGJJAjFf<nP6aG7aZ9rrZVlACucMmAMDjma*f+TLZ]AiQ07ITK9KXcNVlAMZYcTOR%Q**JOS6WP)D`MbYNYWlXFPG3I>B??Mcn
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1448/ccs/rev np:i:4 rq:f:0.990433
  AGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTGCTATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTCGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGGCTCTCTGCAATCTCTCTCAAGATGCCGTAAGCACTTTCAGTAGGACGAATTTACGGTTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTCCACCCATACAAGGAAACTCCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTTGATATAGTTGTCTAGCTTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTTCGTGACCTTCCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTTCTAGAGTGAATTAATACAACACTCCATCCTATAATGCTAGGTTCTTAAATGTCGCTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGAGTGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTTCCACCAATGGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTTGGTTAAAGGTGGGTGAATTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCCGGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCGCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCGGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGGCCTAAGCGGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCCCCGTACTCTGCGTGATACCACTGCTT
  +
  ,0.:C9@hWHWW-i>KA[K.6AKH$=64AGMVZ\b^TMJKR[ZZbhhLI<@GAHVZcYNc7ZcYLDFO?PIFK@W9[VWCHZ8aYcU?RcYcHcAGKZCocCtcYZYcKhJ?jJlAFTHEN%F?X=NH5O?B9@=83,>H=aiX=k=KDaNZM(kkkkk]XL'e>dDT%'1fl?qTYS[JWTTGOaTR8LjWcXMAU-\N&JNK]YHjM=lb3E8jWBjD5>/ehhaYGhF8WVlCJQ@[?I1n_SC`'OJ<DGc7*;8UWaMCkMC+llW_LMXL./hFjCZ7cA,R=TTJPeAAF6-@PSlYSi>UMKhFGFWMDVE7VKF[<kW3llll`CaXSQS=UiW8-5:M$GTWHHW3)Z6NG<(':X8iLllNWLEEB\VXKGLa-UQXZYVjTG?V&NeLcLmR%R@BOPBWTHQ,RXXZVPHVYVlO`cB%RVP]hWcj[F|}dnU7j4hk^@9W=y{k1Cp%6Frda{A||bT5jG]_QsH)YYdVM}|VHzOUYQnfmWmAlQDMS{^=P~pVCz]L>po=Z1`bp_+fDBG8f_Ua\OO&We9xob?>Qum@^K8ch9.bxRHaBWTWT@_Of9lgVcVqdVL?3LQ)rZR9aWIYChigGifc_WpT|VSt?f>kNG6jKObpL~wOInT|Fy5>~nUk/kb%Pop?~lU][L\`Gl>w_W89p|xdT|p:~hRAIf]UbVPf:O=-NwUPLbpc'wwv9]KU-llg'w]Sa=HSTSUL:zvTTKNE(mbC3exbQWN[XEapONzF~GxiE]-^bP]Ok)XIrsTaRX5aiSaVB{h]@4&k}l?gSdpUJYe]WSveT|P}bTiG~dcUcTcBtCzRxe^J@>ZLdbPJ]>=ZNDaNaM_Sa>PA3;BmmLw?Q?xlJS\Xx]Vo6qqaOX4CQVUKwVdaNnVc%[LH?Ua/xxVZFaB`0qaZ@af`-taW\)ccnLS{VbMKyUp`R@N`m`pb6~nMjBYrG`T\8lS,XM^^lT{Tc@aneG[u_QObQW)^VzK``TDjUqdnAbBoa8TqTicepV?gVMbl4`S|m@RuVc'i]cVeVYAkRy@kM.||\RP[CPM/V4lEJ`TQ~l=3h>NH7xS-we;IOahLHBPdVI_&nJK$L_C_4E~dSR4\N_VcVAI5RVB}~~pT`pcAnT|VV{U(nocGyUdm8J^eQH=ZKRHRNzHNtSjoS7aO\RJr\kNoSJSNU?ph4gS_%]^^iSPA[GMz7n]{emaIfam_fS|j3>^5g8^vNC]acG~GwbDzGzyNURI9%7@Le5gy|iVTwT4Xd\dpcAndpG}}}dpdpeS|O';XHfL8eQaWC|sVe_`V\eecDzLzMUeo_PDnO=bj/^MU?r|qV^E{n<{zM|a8TpB|edVObeVTkVj`daEcUd%DVZX{epd_X|Qdb`WQ^It|VcEzceVFAVdpdaJOUO9tQm@w^^`9eQNepTvU}dW}dPgCbcb|Q<oVdi.m[cNnV]%e\Cc;|bD9]UN`{dC}nedVecM?JTV}VRfJncG}}}p_QD|lKOaVgNm<ymRYS^AS{m8TVwbLTP4g[^p`QbPn_YUc?T`cpbaDzoVm8S~o6~ccQAzTZtdcWdoOgMFRnC}bB9jluHTObJ2L<c6l2IN^c<|||nCg,6A9QTfeULTQ,OEH@NM9SWSb-PJ3oH6PU_Q[?Q7_GxdUb(0<9SATB}hY2wmb@gCYU7@1b)65Hh0EG0GKL9Jm-ok(MJ-fCR^DdbUbnVLtiHNLmIJS-TM-Wg_VCXR6WjUC)KRLG8kWI@Q:kHbMMZBqEYASLEB8=V;L?HRWNCnocYX7?=R-P,MLmMlgBTjCVlYNV/KMg@p@MUUZ&aU>e/BMijCLX)JP,L47UT,QKl`CVEMKCllJ&JYX[MXcXMmb'TWV)jjeLGo`8KjX69ammbT5JG=6<RVK:L@?qXMa7h6hWLAC<UjXbJSBig%UWMX`@KXMEX7BBV-h>KWXXXG:H9WLO(A7O>(6W7UjY2q`VI>NCM\HpXBjWbXCT;WB@nVkCT;M@U7PIYMGjMMN&ICglY9JkXaS,XiJi4iWK9f>1n>kmgL-I?f?HMUMUYMYKBFA3PBeCWJ3R&UWHRKT=m_J6B7jliXbWCV[HA`X6Y<mcL;ZCocXMR,kUAe9W0h`BoXWA^3jSA8\(NI`R9o2P'aMPLCjCYQR;)lnEbCM9FkMYV,eFXcLCaYM$fd()MUWV=@J>HEK]RZ1kWWU8:C\
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1454/ccs/fwd np:i:10 rq:f:0.997969
  AAGCAGTGGTATCAACGCAGAGTACGGGGCTTGTCCGCGAGTGGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTGTGAGGCGCAAGGTACATGCTCTTACCCCACTCTCAGCACGTAGGGAGCGGAGTGTGGAAGACCAACAAGCCCGTCGCCTCTACCAAATACAGCTATCCTGAGGTGCCAGGTTAGAATAGGCCCTACCACATCTAAGCCTTGAAACGGTCTGTTCCTCGTGTCAAGTTCTTTGTCCGCTTATACCGCCATCTCTCGTTGTGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTTCTGCGTTGATACCACTGCTT
  +
  }~bO~exL~t~\]W~cccdbgHVlo<tfxwT~a_J~Pa_~dc*yvbu~Z~B~L-zc`m`F~vL~]e`pxb~G~J~^dr^yc]Orb`B~~ceX4w~uN~~h{*uv{~~b~bKp9~{Y{fb~x{XbeuS~v]u_Tw~qsGpp~O~S|crdE~~vsTW]qV~uV~v~RWnBP\dY\~/~``aV~M~aysxudSgla~~B~~}t`u`yn~ew~vU`x3}`]Km-lzaoR_M~D~f~[~h~w]~f7~vbOldP~wqN~]~L~~a{qgevqvqZbsf|N~be_~yD~_~~dk~yuP~Cx~xxP~uV8^]`f~O]r^~Nh~~sL~maxRX~`~txcactsf~PQb;Sv~bMUg;ES~yrxL~\@w~tcrxnbcA~dsPpc~\oYc~>a~K~R~|pbaww~d\Hr^ia{Hp~W~Wnv~bo~sKcl?s~ed~_r[~d`~a{cOM~x`qYs}gp}/{ruoa_v`C~~hdgT~dg=~~~A~b=LbY<Ql|1~~tygP~~[^a~vaO~y`Y~~PvI~~ocfvqd~t|oP~vQ~v~S_cK]~vdt]Fzv?~~Jz~rGo`t~N~e~Yo1~`NR(~~[4x<:c[~jcd~jU-Q]V[S[~pbOUSaUl{UuMvb~e9~~uv|u\>^b~br_dLK~~OInCSdM8~iU~blL>_KAyrQ[va_P~A~~~kN^Q]DMm\Q]~O~L~b~dvd>~dRSc~FV}xo^mcx_T~d@u^~bwvwcQQ~Ub;rKHUedxaP~~JNdw/~ih~~]zaM~cvbwsxJ^~=~zMr~wR~s-~pw~IL~`_rmusudb^<~w~`~buuf~1~~~~ybU~wvbpL`cc=~nT~~^]q|O~~_q]INh}_Z~~P~we~=xbOjtiueyda~nZa~~a~uhv|d~geh~<~w~^]_tcf^N~t[~m0F_rt^q~s~rqtN~X~~O~L~~E~~aJ~P~+b_^e~u4~~bD~~fvvauaubzev|d~eQzedq~qudpe_-~V~rrcq`z~vmwu_d~~f~^a3Ync|`v~e~?~rqfncN?~wz9~~[~rN~u~dsK?mnpSp_C~MfbOgs8~~w~af|-vq~?~ptdC~edM]pY?A~KB~~m5~wQYNojcZvd~d`_ce~uP2~p;~~~~e~hU~R~eVh~N~bbR~~Oy{igY~zr+]`txr9jexO~I~~_azU~~8Pw_^6V>phVgty]~ambrV~h~w~wx~gcwi~P~bO~aQw;p~~~LcQ~={c{e~\td|fsPz^nt\~;~~~~xdMnaddxea`Qw?~nRrua^<~azq~iE~kC~Q~xd\~~ubrs1fgw^dnoM~~d%~~\>zhsv~SS}L6KZD_c%~~C~z^~d^~GO~U~~A~O}Qo@~o_]~bQ~?pQ~~~sfg~eu`nNt`dcu|g~s~wh~mN~N~VrZHdt6iEx~fg~whyfx`u~sutN~d^~Q~`H~yq~G~dwcS~MtiF~cK~|?~~j>~|dbv~e~b~bR~~Ou{r{sxpE~xuc@~~~w~f~K~V{`~~qe~R~ydf~R>~~v^>~o_ntU~yenwbW8bcaFx~~xe~ex=~uzXbM~9y~~hw\F{N~R~~t{a~Q~swoeM~_|~fx~d\u=~u<xceeseeLafbE~rgore=r>~`dd~cGwM~^L_L`~RcrdUnDkKsRv`hDSk$~~~~t[bv~~~~~~~~~~~~~~~~~}zwz~~edyzc$^dydbeR~ey^v_zxtaQvx~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1454/ccs/rev np:i:9 rq:f:0.997749
  AAGCAGTGGTATCAACGCAGAGTACGGGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTGTGAGGCGCAAGGTACATGCTCTTACCCCACTCTCAGCACGTAGGGAGCGGAGTGTGGGAAGACCAACAAGCCCGTCGCCTCTACCAAATACAGCTATCCTGAGGTGCCAGGTTAGAATAGGCCCTACCACATCTAAGCCTTGAAACGGTCTGTTCCTCGTGTCAAGTTCTTTGTCCGCTTATACCGCCATCTCTCGTTGTGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAACGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  @~d.O]cR~s`dgb~gweZhcYckaGz~~hu~m5L~[QV]_u>BWb~S~F{~S~~~tf9~[F~b]a~hV~@~`~blVYsWy]qquM{{au_H~sbP~~^q8~~~ybta`wRTzu;oN`~~togl~K}zcyb_k\P]X~~^P~Azluy4~~~~yas?<gPH3Vr\f~Q~uFFUK&waYP?~/}~bba~we[daje>~~~v`~`ycQsSvguyeR~~dZb:~[jaoz%~NY~roOzQ~QT}c<nuu~awQ~~dwpP~DsuYOOOsS~vRB~~uN]~|x6pnU`asbtEzNqOnG}~|wQ~uSszQ~VxeU~h~bF~pV\~yTspe~Rt~bw~qa^dowtsdZt{bzApYcaHdkT<|tC~r~a~f~Ssi~oi<w^scRtuzrDc\~h~xc~e}dyacH~~eq~G~{@ob`>]Mcxf|pwrRpmdw~qbsOA~~]ow]~bQssygbD~]~fcHrUt~[tpr^IH~_P;~~qKlXdrvyd\~yQ~xds]G~~H~_~dbH~~rS~~_zG~~Qux{d'~jdnch\nysyarzs_R~wq~NQ~|H~wL~~~>~u]~_P^MQ~ppaZ{T~RRIa_[T_~yvfsbw@xtTgwL~{vd~G4o`rN~pyFX13}~~xc_B~^rb}c~wzEqsV4~ZI~uD~~j~pa4~~nJ~cOrq[fMpFx~~~ezuypyqQHaOX{~\PsmQysb~jcm_}?n{Q~dveg~v`vde~Mde]m_^~d~N~tfsv`_bN~t~aWs*~~~~yP~wl\s~dbxxehv>r~ZL~T\hNWpl\r{a~zp4cp~atPyR~vbP~m]S[i+h~~~~we`~^g\ce~r}D~U>m]N~xE~~tq?~fA~s.~u]~|6~\YY\z~`~V~wU~f\x~wA~yuyv_pbt3~$Z~evf~agaa_Q~Q\rOFiS~e~c`db`J;Ls<w|J~B~xPy~|U~f|>~la:t~_|^^Xy~`a~_qe~gmEa`^]aIn~oKr~tuM~b`~?U<~]S]Nmfze~cJ~~aC~OcNfbve~uo_L~K=qSroR~~`0a~<~~c~U~v~f6~zpaDKOkVH`),YG~~x\R=va~~w]~xPsd|oEdq{ue^~~?~~~-|XH_[pa~ewsp\]SsF~dwU{<9iAc}e~vR~A~~)~~_cmWXg~{ZsowxqtptuQ~H~eQ~_|R~,~~eP~N~]]Yt^M~+qd~k~cMO~_QwM[~g~exe~du^worVrON~L_~&~~~f]oc|-l`\g~bldqaZM~masOx<~~k~{vW~dPrR\a~wxS~uG~UuaM~e~R~LJq~f~]~LjAjjbqT~;~_~|v|d\~~w@{jO~dc~yvv~QLof|H~I~~D~rR~vC~wPvM~u_~H~ot^~MsQ~Rb~AsF{~uR]aXts`O^]fx~c^P~OtaM~dwue~S~vJpSc~H~~vU~esaVUKxMa^~F~tbpisfd~~hzD~qbwg~[~~L~]>~w\~~n.~o~TtLsy~ydM~zb~w~wME`>~~~bGk~vBvadU~ewO~{c_~]~ztev_2um~`>~y`wV8K<p|sOc_pxs9~~xea~]XU~gPP~a~J~~zw~c:`c~=~~{yk~iiU]X~H~p~~}~{~l]M~~I~~npl{mhg{eg~zj~Zkljk}o|e~xKj;>-hk~~}W{q~~~CtXmg~~lI~`%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{n~[~a~~k}6~\~l_E~l_qw\^x
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1470/ccs/fwd np:i:8 rq:f:0.998974
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTACTATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAAACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCATCCTATAATGCTAGGTTCTTAAATGTCGTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGCGACCTTCGCTAAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  f~kz~wrP~s[ucf~{hd~xHy~~z%~~~~~~~~~~~~~~~~~~~~~~~~~~VOukp~S]~~_vFf~sdz~|~a~Gu~|~e~~cqc~|~|~~h~wbvb~~~}~K~~e~~O~x~Q~{q~Q~~~|~buxf~T~~x~zu|~|~zP~xD~~{h~~|~uy~z:~~~~~{{f~d~oMt~S~~R~~e~ui~~~S~~~vyr~x~~xt~bc~s9~~~sdd~{b~~Q~c~y(~mvn~H~~~~i/~~yw_~~yOt~|~K~~o~WQ~~dtb~ez|V~~~zQ~{~P~~o~y\pyqa~g~~~`~q+~~s~H~~{~|v~|~ClRT{L~~M~zw~||~ez~||d~u~eB~~~z]p~~a]y~d~ux~f~~S~~~g~v~uzu||zR~sc{9~~u~2wt~qqoyu{~-~meynA~~zqsW~~{ub~~U~y~yl]vtKN~~{~{~e~x>~yrqxcc~B~g{~yO~~e~|~~E~~t{zN~g~~~dR~~@~mc~h~~cdxtxusu~{{|~x{i~~~e~~{uf~~otHy~~vsR~~|N~sys~yqS~_L~g~x_q'~~~|~|~u{~}~P~c~tSu~d~v_~{I~~{=~~~nQXG~nZ}`~gA~~~~pe[mbY}~iQ~~mbg6\;Pz~zkih>|leT~oK~pi[~n~K~a{_T4~shZ}N~L~LC~}_~S{~R}MhBD~~ddhoX~W~G~~ju1~~~|W~yM}}~[~~pi~k~ViRm?x~VP|oTxD~~~]~d_N~~~]~fgaxGvzbw~X~~ny~_~T~~T~~XnTV~z:~~}5~J~^~~W~a~~sqrzFc]~~r}VfI~eKhqF~~~qq2~~|9~n~iq~i|[~X~g\~h~qr~`~q~r~qi[~@D)~co|~K~X~Yoi~rk~~q[{Sp~q{]vqW~H~|X~ofR~sJQnV~Co~U~~qf~~~~qY~pdp~zopZ~q~}ZO~~AxVaypW~m~G~x~]~~r~h~q~y9~pr}5~oi~qpK~~~ioJ~~Z~O~~k~p[egqF~~h~~k~YgZ~~~P~~qqeSeAopj~M~b6:~o~piq~X~ogp~r~q~hqM~i~pingW~~qR~nY\~pq~r{W~U~Z~|C~~~pi|Sl~mz]~~[|YX~~m}clgYL~pT~~nuD~c{[~q~p=~Z~q~Y~pbnB~oYg~i]nVb|rq~s}/~~~gm~iqrjR~n2~XX~~rk~_[izkegr~K~~{VfLo(M~C~kpT~~r~[~kMG~Y~q~|M~hl~~_ho~clipzY[~\}I~b`OB`fwi~_~~~P~}Tc?{xmB}~_~F~Zi~@~~}s~qr~q~iO~~~wD^~rnSni~~~qhBhT~~~Jlam~K~~omfdgq~ilznZ~~r~q~rpiz\j~k~~r~~qrm~r~q~F~c^9~~~opQ~YS~~Z~D|oS_~~qq~[~rm~r~xdnZ~lwhl{Y~{Tyq^~X~wf>i~5~kqm~q~rpY~~}~q~f~m]~X~(~~~]Y~xmsnV~X~n[~lDz[~oJ~Y~r`XPC~~}|PneBbGl~V~qr~oZwV~cZ~S}qr{B{rqqY~oF~lSiI~~~empD~~y|qr{~gS~~nSndZM~|cWC~]hed_~q~~~rq~gZ~r~inVKnlE7~gr{PZsz^~}o]k~I~vp~r~k}{>nQcN~~q>~~~q~rq~]~Y~J~~r~~qH~~~~_~n^^xUPgmnYnhW~n9~fD~h~Mm[n~~~pF~XeY~~nY~[p|8~n\~qiW~gYX~ikmiR~~}`~};~u,~}R~~nD~=~~hP~qE~~ggor>f~~rZ~~|XY~iocU~m:~~~kdxpB~~wW[~kqxX~{kyiZv,}~kKG~5~@~Y{[pibogZ{gknB~~|[~rqm~[~e~^~Q~~eR~`J~jX@aWC~J~VonvJ?~k\~XzC~rcp~B~~C~lk~i|T[~iZ~p[|Af~YA~~Si_o~rk~RJ~pK~~~pM~hq\~thG{~~~qN~~mBo~ppMgiEor~`~l~Y[p~C~~~xW|7~~n\qkikDnpJ~q}[}Z~eaRdUd]R\p~q}Ynoh<~|mh~~@~~~hY~qpi\~~Z~q|mV~oe~[~O|klL~amqpofoB~HfsM~-|~je_~~|fN~~Y~KlkcI~wI~=~~~mI~M~mnqkYmvptZkki^~-~zFjM~kL]~MtP~~mZu5~~dTilzAw~O~r[~E~}RV~X~elrqBuZ_p]~5~uV~~q|OP~~|l~qL~k\~qYD~~{E~V~nVlL~wO~zfHY~r~[k~CG~q}S~qB~~~jmjX^V}rqrU~s~~~_~zo~[p~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1470/ccs/rev np:i:8 rq:f:0.997737
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTACTATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGGACGAATTTACGGTGGTAATTTCGCCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCATCCTATAATGCTAGGTTCTTAAATGTCGTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGATTGCACCTAACACTTGATGGAATCGGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCGACCGTAAACGTAAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  m~vx~{pQ~~~~|h~|ze~L~zu~{$~~~~~~~~~~~~~~~~~~~~~~~~~~~~~|~~l~|~~{k~[~~_`]z~c~ny~{~W~y{uf~cpti~W~t}sb~Hqb~[~~F~u{t{~e~{w~d~r~}~e~z?~Y~~N~z~drxcx0~wQ~~zb~~z_~{)zy,~~~~~nyS~Q~lzK~F~~Q~exG~e~~ug~{VtxN~z~Hv_~wR~fG~~~~df~eR~~f~c~x9~xo~6~~~~{S~~z|y~~eyR~e~H~~uu~H~~z~d~|y{<~~cOt~{t9~~s~|~~dsi~h~~~R~~O~~~]T~~cNxzczcu~|t~\~~u~^]~u\ryc]z{e~b~zB~~~~~f~~e~}~b~cMfj~~?~~~f~@~~O~zycR~~T~V~~|~Yx~~~u~zry~'~~}|~{c~~`~~X~~ysf~~V~wptsc~||h~~{ouz{d{d~{~sczz_u~ze~sQ~~`~Ss~(~ssw;8gU~~rx<~FZp~x~T~~^P<~~z~{S~zzcpzzD~~~X~~coV~qqy~{~mq~a~DJc~~{l~ysU~Ye~P~z~|X~~tO~wq~tSv~x~U~~|p~U~~c~qM~~~>~~tI~eu~zduy~~$~~~ib~{ivz~u~\~~jebox~[~~rz~u~sc~g~ed~ypS~tub~zuy~P~~_wdV};~^3~~R~9~u*~b~rJ~~us~|c~c~D~~vW<~~~wY~z>~~~g~~|~~w_~{~{P~~{~~^~uM~~yQ~z~O~~~@~~b~~|~~|~~P~~{~uZx9~~6~~xesT~rU~~U_~T~[~~S~'~~w||~P~X~~y_z~\~~~|{T~~~tq:~~~S~y~Yv~~~|~e~X\~d~|rf[~{sx_x~d~A~e~o{~[R~U~{|~Yxu~\x|~~f~Mnxtw]~K~~d~{~e~~d~yP~z|~K~~y~.~p[a`~d~z\hb{s~|jlyJ~~wIwqryA~yvg~~vf~nc~V~{~~e~|w^s~w~~n\L~~s~yV~~Q~6~{eHav~wzL~cwPwM~e~`~~~Y~~{{uzzv$uu~=~~{Z~d~|~{~S~zxv~8kyv~eg~~~w~z]E~Xuc~xz7~xz~RoR~M~c~H?~~~v~I~|~{~U~~drxf~~{u~dp{w~e^~~{ud~~Gyxu~|`~b~|~w~{~gT~wj~uz{zd`~{ztf~J~~~~|~~x8~e~vt~er~r{p~f{~ioPcmPKY't\{]~~\zE~~qM~~miJ~mH]~n{q~j\~~Y~~q~q~~pnBgZI~T~T~QxnPp=\iy5yny[~c|ih~bXn{uI~G~pj~:~zhm>nqhr~~%~~~}S4~nq~[|i~nr~r~K~~~q~p{~^~~p[|i~qi~qzkQ~~qeq}[plOnY~h~~q~~qp8~neAaH~~~1~~l`h[~uA}pF~p~`~Z~goZgoRm5~o~~{lF~o~~qdj~i|SnJ~N~eY}V~D~~qo2~p|qrm~{Ldpe?snC~[{4~~~^J~}mi~`~W~pJ~pYeq~rl~J~~qr{S~~zq\ni_~l.~R~`mhqqiV~{H~{eZP7mgnX?ctT4~o~sM~~~~rnF~~~~rq~}fMdzqq[{[\~~fp_~o~}S]~RneTor~~qioi}Jhp_KoY~~qhi`~};~PliH~O~~nzI|~~bvr}hY~|E3~~~rwqr~J~V~Y~bnh~nI~~~~\~ccRIkndf\qf}C~~E~~P~W~}q^4~}~qi~SyW~wrT~\m}Z~nE~B{]~~r/~~~rq~P~~:[~T7~lZ~{I~aBj~P~~~\~I2~xl~q|CxzqjI~{yZ_ybl~K~pI~~~q~~rW~~~oX~pn~Z~~qgfT~Z~~miM~Y~i~pdXpq|AgrkhpqB~~~qioYC~]~Z~Y~<~{fj~JA~pp\}o6~[~nqqgcD~Y[~ri\~~~p}8~~i~qU~xf~]~~C~Uo~Q~~rL~|`cj[~rk~~K~pJ~~sFFsgnJ~~q?~~~~ZO~~p@~~Y\sXiK~o[~]~=vkoDzN~b7]l~E~zZpo[~qqrpF~=zr~\~Zoq~Wskppm~mu\~XuQ~~[k~x'~~|_~[`z<~{Z~p~nY~p~~_~=~zn*sQZN`pndiH~j|QN~J~~~V[~i}iO~~Z~@~~oC{eX~K~~~r^~X~ioXlqqioip~ol_~L~jZoB~q~J~lx<~~qqj$~~~)+_iJT{QY~o]~NdzXZ~.~~[oq]~sm~_~P~~M~hnPGS~~~S~i]~zh~[oA~~~m~V~r~hF~~_~SwsU~V|pA~i_~q~v_oB~~~phh]fp~qrqZ~m{~~=~{m~pYi~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1511/ccs/fwd np:i:9 rq:f:0.997405
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTATAAAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACCAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACTGTATTTGGTAGAGGCGACGGGCTTGTTGGTCTTCCACACTCCGCTCCCTACGTGCTGAGAGTGGGGTAAGAGCATGTACCTTGCGCCTCACACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  o~io|imE~uKklk~d7>=e~ivil$~~xz~~~~~~~~~~~~~~~~~~~~zx|~~~~~zytM~~f[e~sU@zuludfaf?uiwoR~C~lY~viwhcpffviv_~kvnhwgj}vmN~uW~|UkimpMf~J~jYyphLxYwyB|aL~c~r~\qJ~~`~>~~c6ySYP(I;o~~kwg~oNxGm<J~oaYdGvM3~~~tI~s~P~P~s~]~ky0~iWab~G~~E~~~~Zrq~~oHO[P~Dzsur|ngz,~ME|x~M~~g[~~a~d~XK[Q~~q?_CA:pcKrS~e~k{|DrVXojJ~^J~~`tV]~wJ~g~}]kV~oVv5yvd~RbqodeP<ZAzbnDpm`9vbnTNxSmKtdlZ~Z~\I~<~_c|`CvC~{:~vS~n_VXsh~`h~ne&s6n~c]~~\~d~l~O~knqgT~~KZT~dn0~mF~X{K~6U@\~D~~~nilXmvp>~{s7/~tbi9~u[tQ~~pY]\oI~~_T{l~ml@~~~uQ~]_~qK~bJU]^j~o|B0~K~o~p~_~jnHttqrAkvoFvqSb~wqYA~~^~mti~n\~mr]l~b~bjhsfv~|J~m~C~cV|\ork~q~g~~ri^kGjrZ~Yit]pF~vq[]}r~l;{dn`os~Ola~o&{~~d`~~mY|pH]~:~~}iqT~<~~pP~o\~W<~~~L~r~~boP~lz+~~~~th_mt5~r]wTt`~t~M~lUpC~~~mbmw~V~~qjL~xK~n=~x\\^~jw~xi~pX~sO~~>~Q5~~n~s~W~-^psyJfae?PaaY;uj1ykm`~~A~B~~uK~~aE[~[uS~~bgl@n^e_~p[GZZqN[r6~|nu=xs}EC~|\~~sqsQ~^nq^,~@:Y~\o~_~~wZ~0~m(iNdL~de~J~~t~xr~Hv~r~rs]~8~~~~c~s~rx~}o~l9~f~ovqN~vTqZW:zh~eypN~p7~\]~_:~~~~~hwo~`~wE~~^L~kr\~qoLo~tCbj~l~ZgO~_~[iw~x~$~~~{}oQ}~p4~~\q~I~~rru?vg~Z\~rS~Q~U]DIyrtR~`~~r~N~~~K~~Pf=~m~^st}]qx@~~o`~r:~~L7~tf~P~rv^l~p]{pR~]L~rx~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1511/ccs/rev np:i:9 rq:f:0.998244
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTATAAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAACACTGTATTTGGTAGAGGCGACGGGCTTGTTGGTCTTCCACACTCCGCTCCCTACGTGCTGAGAGTGGGGTAAGAGCATGTACCTTGCGCCTCACACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  J~kzwgFO~x~~|_~dgittd{}~s&n{~~scY_s~~~~~~~~~~~~~~~~~~~~{~+~Odd~}mf~~{~zz~~wsU~wY~d~{`~i~~NbjhT|~~`~xxM2sRj~ntM~pf~~|ujrtvi~Z~d;d_~e~~v~Q~~n~F~[zj~8~~p~e~ix/~b`\ykR~u~six~~y~~u{c~_Vg^MQH8~~~p/~ux`~P~f~@{Tw\p~ssqn7ZwI~~|xPZZ\b|tFTJe`zYhc`hX~F~~9v~kT~qIRs~<~Y|\dm`~<}@~~ha~}q|L{n~~h~o~z~UUYpcF|qGcUG~];~W~~e~O~q1gGz}zpe}~{zdmuM~erH~~~g~`~~a~evf~~`]~d~~c~W~~d~cc~E~~K~~Oi~~l~oL~{~q|RP~[~~cQ~~f~jso~g~~~~~R~~U~L~^~<~uj<~X~G~q~E^~P~~~y~kXpds2~}y}>~~~~Z~}]i7~TwPw~~P~|df~^~ei&~||~h~lQ~~d~~FQzz~thr`E~'vu~inB~~|~{nogg~~k~~bxW~~g~Y~yK~~~_~~U~{i~~ut~~moSm~~~m~~~l~n~~~tiQ~3],'q~~~q~~~;~r{~~~~~~|~~~~~~P~~ssh~k>~~~~L~~~~i~va~ZvyH~X~~~~~q~?~~~w~~o~~l~~~rni~~~rj~l~7~~~~~~l~@F~lfh~x?~wtSdUueG~~nzu|WZo~{kB6~wRy{L~_s~i~~eUy`~wT~jEt~8~~G~~x\SwH~{`z^zh~_uIfU~xX~wjhuy>~~JtQ~\w_~~khj~OhORZe[RT~~i7oa~v~]Ud~~*~knvxg~qL~~k~~~~~Y~b{_t.~~ee~Lao_|xip~^~mF`f~W}hKm>cMMg`__swQe^OoknC~~~~_~{~po~~r~YW~\~lwr]~~X~ova~V~O}aqvs`~de~`1~~~iZ\qd~S~{L~~}}{~{~~l~U~xv~a~{k~}du~f~Or`}yy,~~~~qnC~^B7~tbQ~K~~~`~f~x8b~yzX~V~c~W[~lU]~M~~fl>~~tW~~d~M~l\yry~ugcT~m{]~zL~~~fgxz~y|~v|k~~~~}Z~~rF`^a~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1512/ccs/fwd np:i:9 rq:f:0.998887
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGCAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCCTAACATGTTTAGGAACTTCCCCCGAACGTTCGACTCTGAGACACCCCAGGGACCGTACTCTAACTACCTACCTAGTACCCATAGAGAAGTCTTTTGACTTCCAGGCCCTACCACGAGAGGTCTAGTCGAACATCTTTGATAGTAGTGTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTTCCGTATGTGAGAGTAGTTGTTCTGAGAGTACCTTCGTCTACAGGTAATGTTCAGACATTCTCTTACCTTTCTTCACTAGGGTAGATTTCCCACAGACTACCGTCCCCCTCTACGGTAGGAGTGATGTCACCATATAAGAAGTTACCCTAGTATGACTCAGGTCCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACCTACTCCATGTTGACCTTCTAATGACCACTAGGCTCTATACTTCTCAGTGATATGTTGGGAATGGGACTGAGAGTAACCAACTCTTGTACCACAACGAGAGATGGCGGTATAAGCGGACAAAGAACTTGACACGAGGAACAGACCGTTTCAAGGCTTAGATGTGGTAGGGCCTATTCTAACCTGGCACCTCAGGATAGCTGTATTTGGTAGAGGCGACGGGCTTGTTGGTCCTTCCACACTCCGCTCCCTACGTGCTGAGAGTGGGGTAAGAGCATGTACCTTGCGCCTCACACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  ~~~ue~~b~~{~`U~ts`z~|~~~r&~~~~~~~~~~~~~~~~~~~~~~~~~~~~~khuz~~R~y~^~~q~`_qo]~~u7q~Y~fP~~~~7~~Kt~~~F~r~Eh~y~{~b~~~s~crt~~W~X~r~~~e~~a~~~y^~~RyN~~fc~T~~g~X~~u6~~bX~~T~~~v~shqs~~]r(~~~DrZ~~.~~~lU~v~P~<~j~q~N~l~y]~~~b~~D~~~~ue~~~~|~|B~~~~~a~~~~S~xB~~~?~~uo~gc~~~x~xw~~oZ~~~[~~~~T~~~~~~~tK~d~O~oa~~h~~E~ur~i~~w~u~~s~c~~j_su~w~~hVdxh~]~~~`~k~~l~u~Z~~w~~b~~]~r~yb~u_~n~~c~~~~f~[~wz~x~~~~.~Yy~vZ~}~~v|~~d~kx{~W~~]~Z~u~G~~~_~w~q~~x~q~T~~z^~~gM~~Y~~e{8~~~~c~~c~R~~w~x~~s~{tM~g~~sS~~~~Z~~c~~^~~df~y~~~~~e~^~yf~|p~~~~h~qJn~x~Iau~_~gv~i~~_~{wv~~u~~~r~~x~v{~R~~f~p|~~i~~~^~S~w~~&~~~~~r~v~~~x~~s~u~~{~sKJ?n~~xf~~gO~t~|r~`~e~u~xP~~~P~~~~~~5~}n~j{~~X~d~YU~~~~u^}~[~Xk~P~~~nE~|n~Y~~k~~U~o~~Z~_~kmmTe~~|l~~~~~~~~V~k~}~mZ~iv~i~mnuX~sB~~Z~~~~~np~~d~~~~V~l~~~~H~`~j~{5~~=~rX~_~~X~z~~~~~~q~o~~~~M~gP~U\~~~~~~~B~s~ji~n~~npj~~R~~~p~o~von~z~Z~ok~nW~S~~nb~o~mx~7~~~p{mQ~\.~~ijknqjwlX~f~%~~~~~u~~xu~~~\~~~~~~~~~ahKn_~`~HsrQ~~n~r=~~~e~~y~r~v~u}n~~?~~~~Qv~~~Y~x~y~q7~b~~~]~~v{~_~w~~~x~}rmt~~~~q~~~M~tc~d|~r~~~YI~~~x~mc~wg~rM~~~~J~y~{~~zG|Z~~~{ux~f~~uD~_P~rs~~`J~u~~r]g~~~I~~~~w~^M\r~~a{EJN~v~r~s~~B~~y~~zdgb~~~~r~~X~~P~~c~s~~c~`^~~p~rV~~F~~L~~q`s~p~vuva~u~l~A~~~~r~~~~w~x~~b~I~~wH~~w~s~^~J~~r~sI~~~N~~xux^~\~~_~~v|W~z~b~P~~~~u~~|a~~~u~d~~u~]~~p~f^u`~w~T~zws~u~rt~~s~~x~~v~D~~^~dN~~}g~m~~~m|J~?~gt>~eb~u~hY~~[O~w~~kv~~~p~em~du~?~~La~~S]~~uu~x~~u~Uy=~Q[~w~x~~zP~~[~~uW~r~x~~}~|~~~r~~rN~~N~~~~~N~o~`~~`~u~G~dv~q~e~~~rc~~cf~~K~awrsM~aWKrV~~q`~sp~R~~&mp~M~~dtm~[~~p~4~~~~b~kvw~u~~~~~F~~~hs~~wsT}~~~jQ~~~t_~_~~s~bqO~~~u~tq~^~~sg~u2~~~~{~uq~U~~Y~~~~~s]q~s|a~{w~x~Pw~u~N~_~~~y~\~8~~~~~tV~~~7~~r~~9~~x~~ty[js~~~~~d~S~{u~u~]~\~~t~I~~r>~~o~`~~wt~jn_zGq~~Ot~~A~~~~~}Ak:i|w~[~~~~xS|Qe~~c~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1512/ccs/rev np:i:10 rq:f:0.999433
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGCAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCCTAACATGTTTAGGAACTTCCCCCGAACGTTCGACTCTGAGACACCCCAGGGACCGTACTCTAACTACCTACCTAGTACCCATAGAGAAGTCTTTTGACTTCCAGGCCCTACCACGAGAGGTCTAGTCGAACATCTTTGATAGTAGTGTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTTCCGTATGTGAGAGTAGTTGTTCTGAGAGTACCTTCGTCTACAGGTAATGTTCAGACATTCTCTTACCTTTCTTCACTAGGGTAGATTTCCCACAGACTACCGTCCCCCCTCTACGGTAGGAGTGATGTCACCATATAAGAAGTTACCCTAGTATGACTCAGGTCCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACCTACTCCATGTTGACCTTCTAATGACCACTAGGCTCTATACTTCTCAGTGATATGTTGGGAATGGGACTGAGAGTAACCAACTCTTGTACCACAACGAGAGATGGCGGTATAAGCGGACAAAGAACTTGACACGAGGAACAGACCGTTTCAAGGCTTAGATGTGGTAGGGCCTATTCTAACCTGGCACCTCAGGATAGCTGTATTTGGTAGAGGCGACGGGCTTGTTGGTCTTCCACACTCCGCTCCCTACGTGCTGAGAGTGGGGTAAGAGCATGTACCTTGCGCCTCACACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  ;odssv~Q~uOr~~~~x~~u~sz~~&}qsu}{|~~~~~~~~~~~~~~~~~~~~~~nju~w~~~|vi~~~~~~_~~~f|~a~]~~v~~h~~<w~tz`xa~~~~x~s]~y~U~~J~~w~{~~yu~[~~y~x~~t]~~E~~t~C{b~~|'~ut~]~bso~~~~~sK~~~~~~~~~}~~zK~s~~~n~y9~~~t~~~~q~~~_~R~q~O~y~~p~U~~L~~~~u~e~~|~w|s~_u~~~h~e~g~~k~~~C~~~N~~_~b~ou~~~~q\~~t~~~~{r~v~~z~x~~~~wv~~:~lY~sa~~H~t~{~xz~~w~~~{a~uv~~w~~tr~~x@~~~a~^~uk~~~_~~~z~u~|u~^~~w~~[~Q~~J~~c}~~~k~~~~c~a|s~L~~sg~~a~~~h~`~~a~`Y~~[~]~h~F~~u^~p~a~~~yS|O~~y~}[s~~xf~~~~S~~~~\~~b~r~~~}~~x`~~~H~~~pi+yYUln~vo~~a~~~~q~~~au\K~a~v~x~T~~>~~~w~a~~c~~x~r~~~wY~~S~~~p~ft~~v~~~q~t~tJ~~b~~~|v\~~~b~~~~h~@~~~~w~~~tA~~M~~~~~`~b~~~]~~~~S~~~j~f_j~~~~~~~~~L~r~a~z~v~~g~~~v~q~d~~Mz~U~~~v~~m~`~~a~V~~|~u~~~s}q~_~g~~~_|~y~~}~~~K~~c~~~s]~x~wj~T~h~~~b~^yZ~~~b~Pz~|v~~mk`Gl~w{g~~aeq~K~~L~s~~~Q~~e~~W~~r~_~~u~x~~~d~r~v~q~~wT~be~pzc~x~w~~s~y~~N~~~~~~\~~~~|gM~~~y~u~h~~~~V~~q~M~~~v~~~~|~V~~~~x~[~~V~~~~~[}~~~^~<~>~~~~~~~~~~N~~~J~~caM~~u~d~g~~~~gq~N~~yp~~`~~~~y~~bs~~|~~b~~D~~~~~~~~~s~~~~e~~fT~t~u~~~~u~vv~x~~e~vw~u~u~N~~|~~~~}~~s^~y~~]~x`suy~5}~~w7~~~mY~{nha^~J~U~~~~~~~H~~~^~~i~~O~~~~~u~f~v_~Px>~~~~q~~~\M~|~}~~_~~~,~r~c^~~~x~~~|~~~y~]~~^~~t~w~~M~~~|~h~~M~~F~~;~~1~~v~~~>~~lz~~~~~xu~szvo~u~~~x\~~p~i~~uQ~~~wL~Z~c~~~~c=~~|t~`b~~~W^~~-~~q4m~w~~~^~~~wc~c~r~z~~~}~~b~s~~~~~b~txs~~|~~w~~~~~x~y~|~wqz~N~~t~~E~~~~iX~w~x~~~d~r~~~~v~sa~N~~pv~~Q~ese~~Q~~O~y~~s~p~Z~~~k~~u~~~w~x~u~~v~O~~~~~b~t~O=~~pq~M~qt~~f~~oaL~~~O~~n~u~D~qxY~]~~M~r~b~~~~S~~~~w~~V{~O~~Y~r~vy`~t^~~@~~~w~Nh~3~FxU~r~~p~~xq~x~|K~~M~~adt~wk~l~u~?~~~~Z~r~u~~~x~~u~h~r~sm~z~~o~o~z~~}vC~xu~ww~~H~~gt~qlu~h~ko~~~U|~uv~z~`~}ofnu~j~v|~~r~b~~~t~3~~~~~M>tqYL~~~~~b~~~f~C~~~v~yvKuO~q~vu~~}u~i~~w{R~~~V~~N~v~w~s~_t~_~^~~\~~w]~~~w~~~~~c\s^T~`~|~`~`goctxz
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1549/ccs/fwd np:i:6 rq:f:0.991332
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGCCAACGTCTCCTTAGATAACTGGCAAATCTTCACAATTACGACAAGACCATAGAATAGTCCTAAGCAACATTTGCCGCATCGACCAAATCATGGCTTTGCACTCCAACTTTGCCTGAATCGTGTCAGACTATAGCGGGACGTTCGACCATACTACTCATTCGATTACGCATTCACCTGACGAGAATAGCCATTCTTCCTGAACATACGTTAGAAGTAGTTGGTTAATGCTTGTCTACATTTGAGTGCGAAGCCACTAGGTTTGCACTGTTGACCACCAGCACGCAATCGCAAGATACGCAGTAATGCTAAACCATAACTTATTTGACTTTGATGTTTCTATCACTGGGTTAATGCCTGCTGCTACCTGACTTTTAGTCGCGAGCACAACGCTTCTTGGCTACACATATGCTGTTGGGAATTGTTTTTTACACTTATTATGCTATAAAATACCACTCCCACAGCTATTCGAATGACTCTAATACCTCTTGCAACTTGGACGACCGTAGTACGCATTCAGTCCGAGTACCAAAGATAATGCTCTTTCTTCTGCCACTCGTCTAACTTCGTCGGCTCCGTGAACAAGCATTCTTCCTACTAGGCCATGGCGTCTACCGCTTCTTACATGGTAACCAAAATCTTTGTTAACCACTTCTATACCTCGTTCTAGGCCTACGTGAAACCCGAACCGAACTCAGCCTTCTTTCAAAGCTGGGTCTGATACGTGCTCTACAAGTGCCGTAATCCATCTTTAGTTACAGTACTGACCACCGCCATAGGGAGCACCCAGCATAATGACTTTAGAAACCATTATTGAGTAGTCCTTTTTGCAGTGATCCGTGCTTCCTTCTTTTTGCGTTTTAACGCTACTTCAATTACCTACCATAATTATTTTGCCGCCCAAGTTGTCGCCAACCAAAGCGTTTTCTACATCGTTTCTTTAATTGCAAGAACGGATGTGGAATCCGCGTATGAAACGTAGATTCTAGTTGAAACGTTAATAGTTGCCGTTGGATTGAATATTTCTCCTCAATCGTATTAACCGTTTCTTCTTTGTTTATCTTTGTCGGCTTCTTTGAGTTCAGCTATTCTTTCCACGGTAACCAGACTAAACCACGTCTAATTTCTGACCCAACTACTGGTCTAACTTCATGCTCATGAGTGCAGTGACAACTTACGTTTGTTACCTGACGCCGAATGGTAATTGTTACTAGAGCACGGCTAGAACGTTAACACTTTCTTGCACAACTCTCACATGACTAACTCCCACAACTTGCATTTGATAAACGTTCAAAGCTAGGACATTTTCATGGACTAGCGCTTTCAAGAATGTCTTGTGTCGACGTCGTCGTGCAGTAGGTCTAAATCCAGCGAATGATTTGTTTTGGCTTGTTCCGATGTAACGACTAGCATTACGATCGACCCAACATTTCTTGCAGCGCAGTCAAAGTACGTTCCACCATGTTTACGCTAACCATCCACTGTGTATGTAGATCACAATGACGTTGTCGTTTGCTTTAACATTGTCTCAACTAACGTTCATAGCGTTGAGGTGGACGTCTTCAATGAAAAAGTAGACAACCACTACATGACTTCAAATGGGGAAGAGACATGACTGTCTAGGACATCGTCGTCTACTGGATGAACCATTTGAAATGCTTCGACTTATATGGGCATGTTGCCCACTTACCGTACTGGTTCGACTATTATAGAAGGGTCCTTGACAGTCGAACACACTTCCATCCACTCCATAACTGTGTCTGTCGCAATGTAAATGGGGGTGACAAGTTTTACCATTTGGTATGTTTAGTTTACACATCACAAACTATTTCAACTAAAACTCGCTACAACGTAGTAAACTCTCGGCATGATATGCTACCTTCTACAATTATTGCTGTTTCGGTAGGGTTGGATATCATTGCGTATATTTCGAAATGTCGTTCGCAATCCATGTTCATTCCCACCACGTAGCGGATAAATACACCAACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  Rz[RbIfJaA\SK;TL?OGULZc7P$ZVQSadYY]chnqrssssssssssssssssrZY6u$ACZ\AHB{Wu]Ybd1qQf@mRKvvfRXvRaQ?qF`N;,$M?XTB3WN`a[Sv`UZ`Ccd<6D=8P>J0a`ZCgFQ`\;ZN6]H_rfRIB:_N?UmZRaNQBgMY=.raJBfJYBtc=YeYLNFR5OaX`_[RAdcVNV2qP[QAJYK_MHC6GM'%@LSW@rI=YM[TTI3AXKX_:X_XC]c_FE|bXvRWt8ydZCtR_LKQ[VwbY.\ZfbZ2rKvXv7C0V;1qYb>]VNV<ZrVNXcALUA^ACsVK^:<uGkWFPaRfZHvZbDh7DsLY<[)2=>VXEZR6l[T^A<?$PZc.YcZOL/n[3[JN%*7EdM;rYB`QAuqU35Q'nSM;BKB]Cd5tgTkKx_RAxeF:_[O]_4YKYbRA_rvb[fR[LUTXRbQAlMVP3rP5oMmN]aRbRbfbeA'IYTt<q^J]0DA4hVgudMPLOMVNEv_bW;M4:&:CKM^BaNNM%kcXPb[Re`A>QZCe`V6QaRfTvdMElcRAe[P4mLDp=\IM8-?U.]HX\8LC%X@:=_DLE|[b[e_6x&PTZLdNXMB:_PEbqSNqRfZ8yaO5OY5NcAo@9YQ[dRNwRf>t[cDPuOMm>QKBnQUsDyfbPKG.PF{]V9oH>OPb5@a[QEtQXtbR`cLveCj@I'm]ROP(m\X3tKe?^6MO^ME3]J<`FOKFaPL].PF}dHO[fZ<tq<yxULY;@A=b<c@LXA`BrN;YT?FkVYRfEwxdSbD`_HQYbE=bJBDN2\Yf[ByUMLwfEwJdROuv]TXvbQJ?ILPGC_4eJ&@*7Qaa]4_WKU83&G<:U==JCaeY7RD^rb[KvuFzaAtHRuDLZbKZe.C8uuuuZALXf[bfF}XNXR<_/XRWP7\ohVZRWAtv`BoBK?AEFK(>8lTt`3v]`Ch:aDXT\_6atiW0^D-Z[=ZC%rZSPEExSk/ZBLfTPL2^lO<dbRbZFZ9^g=HktTvXv[R=_V3^?KuaMUM7I2nGAv[JUa4MOFrVOZf`D^HcQ_HWA[X<kVNDS^Gq[_Y>TV@pVXvCcIDtZLxfbGvb=^0pLOSpdQXEHRpTtCaH*qm<Cn<>ntZJr[ERL9e[DdRMm<DrQ?suYFDQj=]@:aLIZR5c85VaRKvMBg@^b[bRaHbg5`L?DMQd?\NuuRdQ>.WjL_?_[Oa0UOJG>XO3[M7c[O8Q``T`CI=(JR[XNLBpQE__RZ?PmY@oE+K2$(5FAcDQuNBaGNpEqVPT=M3UA`Y>[MKuQM`Y0]RWRY+ONHN;pQGHqY=`L?m;cQdO@;`]W4<^5f>H:xg9'1KO/sW=J9vnYNc;uQ-5?\8,]_ZRfbKu:HN;uvY75Q>cNQfb[R[RBurO'fOMMdDdRWuWNQeRW\S[a)Xa9Sa-OIEb]KgMPK7seP?^EG(G?TcZJ8tuZ%nnEEQQGuI4s>fP0_Dd;bMXbOJIZM\VsJODGLQX66UU'\$%9YcN<JZRcW(W;HVa'7OTVdJRX+_0ra>@;dW@^p_>YR`3E6wZ,>\aRQYMYeba[b7XK_;HN@UeZMQY5tYePC>uuX=%p11S?\U`CG56PDnRe;P;YWqRM4II:C@r[bEK_6j$P[fNTtRTvfZ4V]msYKJVZ=Ss@\CMB3JLWRGO?fQ?[[e<vvsEnE8CHL*cY7QdDb=bNMy_OFLODa>XMQfbRe@P6OE/XAs2FS^DCctaY<<lKZGMSjTICU9YEALJ03^Y9bVZK7T/0LC`[N_I\B\MVWAIaSaJJ3RL^4WA2.ICTA;B>XfS[LHJ1NY9ToC{bfAt_JMDi8Z7^Qf[f[fRf[c=W)?GJG[9UWV9qgVheZMQTt[;uuoN*^85N_Lvf]\Y%rrHCIjVWLI,J>OO>*EUQa]DSPMKY&a&rrRPaLWPbZ;?qPDbNYS+ak<a=JQ@kQLdZ:_ZcY>cM/]SuSa4OLgWuJ4sZReZ@t`QLv_C?jaEtNyW4[7<A?rBPXM[]a9ULNY+?jd[fS[EtPEP'NO?vGQ[HsQY(*.`kbEuMQVVX@;,QK_?_s\RRbA^K^4vcVTdbRaOf[NEGuYKZZA^BFGTRfw
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1549/ccs/rev np:i:6 rq:f:0.992851
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGCCACGTCTCCTTAGATAACTGGCAAATCTTCACAATTACGCAAGACCATAGAATAGTCCTAAGCAACATTTGCCGCATCGACCAAATCATGGCTTTGCACTCCAACTTTGCCTGAATCGTGTCAGACTATAGCGGGACGTTCGACCATACTACTCATTCGATTACGCATTCACCTGACGAGAATAGCCATTCTTCCTGAAACATACGTTAGAAGTAGTTGGTTAATGCTTGTCTACATTTGAGTGCGAAGCCACTAGGTTTGCACTGTGACCACCAGCACGCAATCGCAAGATACGCAGTAATGCTAAACCATACTTATTTGACTTTGATGTTCTATCACTGGGTTAATGCCTGCTGCTACCTGACTTTTAGTCGCGAGCACAACGCTTCTTGGCTACACATATGCTGTTGGGAATGTTTTTTACACTTATTATGCTATAAATACCACTCCCACAGCTATTCGAATGACTCTAATACCTCTTGCAACTTGGACGACCGTAGTACGCATTCAGTCCGAGTACCAAGATAATGCTCTTTCTTCTGCCACTCGTCTAACTTCGTCGGCTCCGTGAACAAGCATTCTTCCTACTAGGCCATGGGCGTCTACCGCTTCTTACATGGTAACCAAATCTTTGTTAACCACTTCTATACCTCGTTCTAGGCCTACGTGAAACCCGAACCGAACTCAGCCTTCTTTTCAAAGCTGGGTCTGATACGTGCTCTACAAGTGCCGTAATCCATCTTTAGTTTACAGTACTGACCACCGCCATAGGGAGCACCAGCATAATGACTTTTAGAAACCATTATTGAGTAGTCCTTTTTGCAGTGATCCGTGCTTCCTTCTTTTTGCGTTTTAACGCTACTTCAATTACCTACCATAATTATTTTGCCGCCCAAGTTGTCGCCAACCAAAGCGTTTTCTACATCGTTTCTTTAATTGCAAGAACGGATGTGGAATCCGCGTTATGAAACGTAGATTCTAGTTGAAACGTTAATAGTTGCCGTTGGATTGAATATTTCTCCTCAATCGTATTAACCGTTTCTTCTTTGTTTATCTTTGTCGGCTTCTTTGAGTTCAGCTATTCTTTCCACGGTAACCAGACTAAACCACGTCTAATTTCTGACCCAACTACTGGTCTAACTTCATGCTCATGAGTGCAGTGACAACTTACGTTTGTTACCGCCGAATGGTAATTGTTACTGAGCACGGCTAGAACGTTAACACTTTCTTGCCACAACTCTCACATGACTAACTCCCACAACTTGCATTTGATAAACGTTCAAAGCTAGGACATTTTCATGGACTAGCGCTTTCAGAATGTCTTGTGTCGACGTCGTCGTTGCAGTAGGTCTAAATCCAGCGAATGATTTGTTTTGGCTTGTTCCGATGTAACGACTAGCATTACGATCGACCCAACCATTTCTTGCAGCGCAGTCAAAGTACGTTCCACCATGTTTACGCTAACCATCCACTGTGTATGTAGATCACAATGACGTTGTCGTTGCTTTAACATTGTCTCAACTAACGTTCATAGCGTTGAGGTGGACGTCTTCAATGAAAAAGTAGACAACCACTACATGACTTCAAATGGGGAAGAGACATGACTGTCTAGGAACATCGTCGTCTACTGGATGAACCATTTGAAATGCTTCGACTTATATGGGCATGTTGCCCACTTACCGTACTGGTTCGACTATTATAGAAGGGTCTTGACAGTCGAACACACTTCCATCCACTCCATAACTGTGTCTGTCGCAATGTAAATGGGGGGTGACAAGTTTTACCATTTGGTATGTTTTAGTTTACACATCACAAACTATTTCAACTAAACTCGCTACAACGTAGTAAACTCTCGGCATGATATGCTACCTTCTACAATTATTGCTGTTTCGGTAGGGTTGGATATCATTGCGTATATTTCGAAATGTCGTTCGCATCCATGTTCATCCACCACGTAGCGGATAAATACACCAACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  AePEQPKC`INb[Vu[QEb:(J.@C$`j_SMLUZ_jrssrka[XX\fpsssqi]XblB<9qdZPLZ`9sSvdRLHM]RC4oY?uu_DPbZMDRlLwf[QECn;`LtcNa;KK]\Q:JVaEtQDBFX`.SZN<tRYdLZQL8r?tt]Xf`:pZ7t`LYdVU8pDtY+rpLJVNOApFYP[RaD]9bW[`VdRZ,xp5COMUWDUMuRIMXS^W2SJLOUMeEveZ=YaQuYMKvbRf[RfRVt7cRNxfPUYMQ:f4O%pDDdbf[R.oXQ1sPKdQ4P5^9O=N8Q[MrRbZLd[e=thL_ILNX9QTL8`GTC_Be:jVNZ`R[N3NHG[aJsfSXNCPY2rKYOVVdRfbfY=T8GMCrI?E^?up7nSbfJQt\:]pQf[7rF4I^Q0nY`e_WLVJ:bk%02U`RAP5PALOX[FI]^NfX@_roYPJQSYL?<CIWDXX9O>rYE[0o=Id[eYM8RNQXH7C;5VcGg_>)fkZ\LFT@V.[a<bc58QXL];:P6KKvf\bCvvfW]S[_aMX[PRUF(aZ^GXBiMR;p\Z=ZMQRnR6D3J_C:L@=5ZFHJeY=XLBj@bQ7IbNEKIJ;]BR=N]?cIO-ZW)FL,?MXIPCfMYKB*TX5VuZ?rT=MY8YG?En1G;BoXDWQ\_9XY>f'|joOkqK~QqJg.qYNTP_S]C~YcSgLY}]NlB'di^{Nf;3P,_1sPC<dL~?cod]~aaWToPx`NM7i]NhK|B{@neYc7K~g>~~XMw>{DK~cW_@VRrY~^0awpcG~~YQa*jkQaN?jSqdYZYcmdh;\F~@OSS~[k^~b:}N@bIJ%gW%^`dcXE@neV2hTv@Q~ZV~mDi5~pK2PaU~XX`QTQhCUja$xdQUZ>VM>h`LK1UgSgOjmYV>}4WbtlYcc4MGne>kVLA_DLOaJia5ehh_DMD.jhOE_aY_a=aAhd`~RdOR~WpM{WUYlV}n4hW]CIeCJ~~N~XRdXiMYMtM~@~V~~Zd[>~~~`fodqnaT2fg^Jdo^~6kT=LiG&^A(jO48G;fK^SOeZcB%CQLNEcsXYPG?1JnaGRE9P11]_^TB]G`PhV?pR=hFL_IbpJrYNx_XBu]7bCrM9Uh/MPC_2FBnP~T=cM_CY].N^UDvc=NaNf|Zi_JubT~_(ygEYHH~dqZ_)J7aIA?VOifJ8tf`~U~pDT_c:rkB~kSGSbW`~NwjNiFnH~~OeUXoemIi-^SM~cGz1]>U8RdrkDQRLQG)XkEodJbbVaqdE4}pA8{oOeFO{PM|g7~UHNEWY2\d\:@XSYYY:dF'AO-p`CGmL}`^P?y|bILC%kqdN~dkeicqdqlHqdia~bhG`gne]~d\~EdmApzVnRF}~d[HlbF~~Ea?T5jk_p:s_f`jUD~RLYmZdZaDnxb>CLf990VCM;RQg`WTcY;HSeL@3NTNkUVn:tAbn1qsmV~pXaZKRg[p@~nY@}~`7`6Z~UFpOrZj,VQI~`.ldmpXM^LVndGZRMXp9~cN~Di?@vfc6}Xc[WNWb>=9`P~mCem_YZoO~jNkOgY1~~ob1alPjAl.%'sVXAFPH>hOF)F?Vkb;Y[~BHp^KEXUS^A%EDNDv{P{cm9dGVWTc`~^P_~dZU~epW]XLVJ~SSBQWHsjdYS_Fia9qWI2nhwhYWoZm`FK)tOclpdmYTf\CwS1dVQ,``LIHRa@_\@M-IbmWR^Pl*~:j^^OJQXY:<\Ug[R+ZF^=8uM~kDjhC9]imYLGfbC=_3F>PM`%}hPL_PGhGEsdgGBdQ1eW*cV\*e/<HMoa&T8EligE^t2~H3KE_/OXZDOKD3EI[al`1iFsniBf]U^K`XiDh[(.($NMX?a_XLMhhVlCv_c%5023>_BmdK~F;W{gfS~g*`Z=dUY^L,`jq\W:dxhdoPYgdleFo~cWZ'ssc^~`l7~~`PMWci@aL~JUSoZk'~oERbiM;e8lYX\XVXFSQW=yA_bWiMJ~5dkUsSOVW3Mn]?qmq=~^GdJ~mVhN]R7xEcWR_':Nx~d[Tm~lX-aY9~cZdphJe:RWHhMfDPhpQ~RMWAYZdJ~jQ2~pQB_hJyI`:n~~ZhZVmdjC_ZZt/TbZ$bqcU+<Jy
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1608/ccs/fwd np:i:10 rq:f:0.998309
  AAGCAGTGGTATCAACGCAGAGTACGGGGGGGCAGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTTAAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTGCACTATTACTTTTTCAAGCGGCACTACCTAACTCTCTTGTTGAACAACTTCGACTTCGACTCGTTCATCAATTATACGCACTTCGGTGATTTCGACAAAAGCGACCACAAGACCGACCATTCATGTTTCATAAGTAGCTCACAGGGCATTGCAACATTTGTAAGACCGAAGACGACTAGTCCCATAGTCCTAACGATACGTCCCACGACGTGTCCCAGACTTTCGGCTCCTTCGGGCAATAAGATAGCTTCAACGCGTCCTAGACGCACGACAAGTGCCATACCTACGACTACGACTTGACTGCAGATACTACCGATTGCTTCAAGACGAACCTTAGTTGGCACTTTAGCAACTGCACTAGTTGAAATGGCGAGCACAATTGCATCCAGGCCGACAATAGCCATACCAAGCGGCACGATACAGATTGGACTAGCGTAAACTATAAACACCACAAGCAGGCTACTCGTGAGGCTGATCGGTCTAGAAACGTTAGGCAAGACATATGCCACCGCTGGGCGACCGACTTGTGCGATTTCTTCGTAAGGTAGGCTACATGAGAGCATGTGGTGTGGAAGCGTCTTTGACCGTAGCGTATAGACGTTTTGCAATGGCGTCTTGTTCATTGGGGCTGGTTTCGACTGTCGCTCAGTCTACTTTGGGCACCTTGCTTTACAGTTACGCATAACTGTTTGTCCAACAACTTCGCTTTAGAGCGGTTGACCCGAGGAGTCCCAGCATAATGGAGTCCATACGGTCCACAATTGTCGCCCCCATCGCTGCCCCTGAAGGCGGCGCAAACCCAATTTCCCGACATTTAAGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  ~~~V~~~s~~~~~\~~~Eh~~~~ip-~~~~~tnh~~Z~~Q~~~~~~~~J~r~s~X~~n~~~T~p~~~~K~~v~~~~r~-~~~~~]~~~f~~~q|~_~~~~i~R~~h~qd~~~~np~W~~~c~~~~~t~i~qp~~}~~~~~J~~~~`~r~~~^~~H~~n~j~fY~~~~~XwY~~~q~P~~O~~~3~~~Y~~~r~~~~~~~~n~~~~~r]~~~~r~[~~~~~~~~U~]~~~P~~~~~{o^~T~[qvh~l~~~o~~q~{~U~~~~~~~~~~~lq~~b~~~~~{l@~~~~^~q~d~~~^~~~~~~~~o~~~r~~~~Q~~~~~~h~kq~~rr~~[~~~~r~~~~pT~~~~~~o$~~~~Xe~mr~r~t~~~~~g~~~v~~~r~~~~~~n~u~~~q~d~~r~sj~q&[^G~~p~d~_~~^~~~~ikK~~~v~~H~~~~~~l~~~~~~qi~~~i~~D~~~~~W~~D~a~~~o~~~~~~~R~~f~~5~~~ps~s~x}~~b~~zp~~~~~~~~~~~~qp~u~mi~R~~~O~~g~~g~~h~~}~o~~~k~~f~~Xp~Y}~~~~b~j~s~[~~]~~~~~^~~f~~z[~~~~~~~~s|tu1~~T~~~~~F~~~~~~$~~~~~~~~~~~~~~~~~~~~~~~~~~~~~hh~~~~~~q~~w~~}~xK~~n~~rw~V~po~~~\~~~~oe~p~~~~~~~~~$~~~~~~~~~~~~~~~~~~~~~~~~~~p~~n~n~~}~7~~~~nu~~~o~ni~~~]~~l~~~A~~~~~~~~m~I[~pr~np~~v~~r~q~q~~~~~~~i~~~~~zl~o~~~~~p~~~~U~~Z~~~4~~~~~~ki~P~^~~o[~r~Z~f~~~~~~m~~l~~|~~~~t~~mh~~c~~~~~~~~;~~tf~~r~~~~fk~~Y~~~~~~~~j~~B~~f~~~~a~~\~~~l~l~q~_~~~n~~w~~~~5~~~~~pW~~~]~~~n~q~qX~~~F~~Z~~}~~~~t~~\~~~~~~q~~~~i~~~~~~~qf~~~~_~~~{)}~~~~l~~~~o}qv~~~~~Cm~~~~|~~wk~~~~~s~t~~~~~~~qE~a~~~~~~~r~q~~E~~~s~l~~~~W_~~~~~~~@~~~p~~~A~~|~m~p~~~~~K~~s~n~~~~n~~~rn~~~h[~|~o~r~q~~~j~~o~~P~~b~{k~~~~~~@~~H~f~Y~~sad~9~i~s~~r~r~f~~~~~~~n~[~~~~~]~~r~~~V~~~~_~~]~~H~_~~~~~~th~zX~~~~R~~~~~p~~~~q~p~~p~[d~~Rm~w~~l~s~~dm~[~~q~~l~q~r~~~~1[~~~~n~Z~~r~~)t~~~~l~~~nx~~~j~~~~~~N~~~ZlG~~M~~~~po~~o~lfv~;~~~q~Z~f~~q~~q~x~M~r~~~~~p~}\]~~`~~v{M~[~oVo~~w~m~~~~~E~k~l~~~~f~~nin~Z~pk~~~~~~~\~~~~~~~l~~~~~O~~~~`~`~~M~~f~~~~l~~^~~~~G~d~~~^~~J~~q|~t~p~g~'~~~~~~X~~~~P~~~~~l~o~qB~~~~D~uS~~^~E~pN~~~~pl_~~[~nH~~~~~lYjYm~m~~~rvMv_~g~~~~~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1608/ccs/rev np:i:9 rq:f:0.998902
  AAGCAGTGGTATCAACGCAGAGTACGGGGGGGCAGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTTAAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGCACTATTACTTTTTCAAGCGGCACTACCTAACTCTCTTGTTGAACAACTTCGACTTCGACTCGTTCATCAATTATACGCACTTCGGTGATTTCGACAAAAGCGACCACAAGACCGACCATTCATGTTTCATAAGTAGCTCACAGGGCATTGCAACATTTGTAAGACCGAAGACGACTAGTCCCATAGTCCTAACGATACGTCCCACGACGTGTCCCAGACTTTCGGCTCCTTCGGGCAATAAGATAGCTTCAACGCGTCCTAGACGCACGACAAGTGCCATACCTACGACTACGACTTGACTGCAGATACTACCGATTGCTTCAAGACGAACCTTAGTTGGCACTTTAGCAACTGCACTAGTTGAAATGGCGAGCACAATTGCATCCAGGCCGACAATAGCCATACCAAGCGGCACGATACAGATTGGACTAGCGTAAACTATAAACACCACAAGCAGGCTACTCGTGAGGCTGATCGGTCTAGAAACGTTAGGCAAGACATATGCCACCGCTGGGCGACCGACTTGTGCGATTTCTTCGTAAGGTAGGCTACATGAGAGCATGTGGTGTGGAAGCGTCTTTGACCGTAGCGTATAGACGTTTTGCAATGGCGTCTTGTTCATTGGGGCTGGTTTCGACTGTCGCTCAGTCTACTTTGGGCACCTTGCTTTACAGTTACGCATAACTGTTTGTCCAACAACTTCGCTTTAGAGCGGTTGACCCGAGGAGTCCCAGCATAATGGAGTCCATACGGTCCACAATTGTCGCCCCCATCGCTGCCCCTGAAGGCGGCGCAAACCCAATTTCCCGACATTTAAGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  y~pt~~vk~V~~~b~~V~~Z~~(N~%~iW~~~~~~~~~~K~~~~~~~~~~[~~~p~~a~~~~{H~~~~s~~-~~w~~~F~~~~~`~i~-~~j~a~l~o~~~~g~~~r~~~~r~~G~\~~~k~~~~lG~~ll~~~~~r~~{4~{or~~L~~qC~~u~~Zy~~~~~~~~~n~r~~~q~U~~r~~{V~~~k~~p~~ro~Y~yra~~l~~[C~~~t~h~~~~~r~~V~~p~~~j~~~~qnqn~s~~r~s~~~~~p~~~{~~Y~~~~~~~~~k~~k~~p~~~t~~~\~~~`l~~s~~~~c~~~qh~~~qh~~m~~~mW~~~~wnu~jn~~o\~m~8~~g\~~~~s;~~p[~q~m~~~~~p~~~~Yj~~~k~j~~I~o~~~q~~r~~~~ol~C~~~q~m`~y[~st~~~~Y~~~~Y~~h~~~~_hn~~oW~~H~~~~w~u~j~~~o~n~~~|~m*~~~j~~~~~G~~~Q~~~T~~p\~~o~~]~~~~r~r~~~~~`~~~k~f~z~~~~i~Z~~s~l~~~~S~~mS~|L~~@~~@~~~~_~~~x~~a~~~~~~~t~z~~~~u}y9~Z]~~~yvo~~i~~~~~~~~~~~~~~~~~~~Y~~]~~B~~~~A~%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~w~~~~~|y~Avd~~~w~~~v~}~~~~~~~~~v~G~~~~~~z|~|~~~~~%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}~~~~S~\~@~~~~~y~t~s~}~~~~x~~~~}~u~zk~~R~u~~~n~~j~~|~~p~|~~~~~wN~~~Z~m~~~~~~~v~~{O~`^~4~~\~~~|~}9~~~{~c~d~~xv~7~R~~~y~zp~~~~{a~~~~~|~~~~~~~~_}l@~~~~R~wf{~~~K~~~~~~|~Q~d}~~~~O~~y~x[[~~~v~s~d~~~~}~~~~cwti~~~~{~~_mt~N~~~e~~n~~~V~~~|~q~~?~~~~~~v~~x~~{y@~~~~~~~|~z~w~~~}~{~~e~~~~~~~z~~s~{~~~~f~~_~~^uzq~]~xp\~~r~B~~~~g~u~^~t~~~~i~|~~~V~z~w~~v~~x~~~~H~~~|~~~~~~~~~~~~w~~`~~~v~~|~~e~~~~q~z~~~x~~d~f~`~~~~~~~{~~~~z~l~~~T~O~~y~s~~~{~s~A~~~~~~~x~R~~~_~~o~~{~g~~~z~M~~v~~]~~~~~^t~w~}~~~~~s~~}~~~s~~~~B~~c~~~~~~~~~~~~e~~{~y~~Z~~}~~y~|~~S~~~~~|~f~~~S~~~~~~f~~~R~U~~~~~]~~~|~~~~~p~~~~m~~~~~yJ~p~~x~x~~`~|~~~~~~~~~~8~~~~~~~~V~~~x~~~~}~~~V~P~~~~~w~`~~}|~~~~~jxh]~~~~~~~~H~~V~~~~c~_~~~H~~~|~~c~~~|~~`~~~~~b~~I~d~|~~~~~Q~~zzT~~k_~~~d~~~e~^~~~~i~~~~f~~w~~~~~~vq~~~~z~~_~bl~~d~~~}~~~}~|f@~~~~~~~~~~~;~~~~~~~h~~s~~xzr~~\~~~~X~~S~~~~~~f~~q~}S~~~~q~~~~~~~{P~~~~~L~~c~~~]~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1630/ccs/fwd np:i:6 rq:f:0.994005
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGAGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTAACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAAGATGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGAAGTTCCTAAACATGTTAGGATGTTTATGATAACAAGTCCAAACGTGGACGTAGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCCACAGACCTTGCCACTTGGAGTTGTTTTAGGAGACCGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  d~SDjivY~rmp0:sOOXkjbj[UT5|~~ujNF{U\~j\8~i?bgeuluZ[~Jx6sU2w~[KR0$?B|LBDjXT~9^I~EikW@jvltVdQ~~l_f;~~D=~~Pk*~~dLCQQhRY\~lljGXprAfZjoTi\EgVgrhOWBiq`E}DqkfP*~~yhdTsYU{YDeGliZ~?QlfVGSKSje~Jjb~gIpWvYjTs=raPYX?fM'D_UCsXkXpbUjW~loXrUjhB+rpVgvZ~qWj`~miYmZ~rWHa>OrB~ahtK@{ukB~~kSb?il;WD[~j=~z1bLQ~~JzLuDb=rwi1}jSh>utYliQ>IxWkXS}<`jakkr>rG{Z_WWG~`<~v<\rc<~tN~gWklI{b~l[x;~~e;cQAH@~imoRYuD~}E[gIyYiQ~hiMaX*~jvllj+~~|~h?M~VRVoFsluMxvpC}aJ~i5a6_vUo=~~vJ~qWXbWrFgBo|~yVclrRRJ)`TmY|t_M]PXvlluj\dQb-R=UVYTYvg>[C7f<_E_ShF~Pb*|]cP<hduZg,pUhZ,~~~wV7~ri>ivZmulZvk>~iQO~[[~Zd~Vta]I~tiUE?sYVYs:s\h5rRn+\b+jxh\BKBDb['XnXtluI~iCiwdYtj8~~sVktSHnfCfzZ~uZ~TikYohlvZvl\~ZgbxOGxpkujkUYlW~Y~dlZh>oWilX~[QpBUeJY<nFkGjrBXY~B~~X|(~pO~~uH~c~4~WW3efOhAYJ~~)KGpTjZvZvkUgkhDebukE~n`pRXd3Q@cFL,NC`gXdcqE%glNSRtkQ~T>eWtTkg@|b7+Xlu[~\h5a;7gqC|G{ksE1w~f]iI`~YqRlUtD~~rVF[jX~^hC~lWeL`hSTjvgWSv:@~{^F~~~ulhBkXPffgpWfV~WjO~U*x~~Hcie~K~uP~~Ejvld~U4Y_ul+~rlvi/aLsYQ~jZ(m0weWkuZ~cRmr@inJkZsTp6U=mZRWXZb%uTdRgAdZuhXM4t[~Ze~9x~v^FiR~E~iTDdGtjVkuTmWHkH~C~~~~whL{]BfsRAsjU:~x,zUiK,X9`T].Kl~[~Z~sTKcRXuU^E~Ake[QIOfu`<ttRmLK]QB&]]@JIJJE:\\;sr@uEBt`(=^\RvSv_:Rm]_5V6;sRu@wwnQJHt`d37]LNFOQb[rSvhBtQ^6Ys1yJBkP8_9ucIZuPHh`iRiag3s?nag\EmR/l]Q\@[\'ECtQvdNoJ9||HetrGUlf>faaai]OQpPRf`^OPeP2rht>'BJPK2FFF0QKY$&Y[N?kRu_I8pH/ste3?jU\J.\QuaZG%AfKZK_5nveQ[uah=q7U4^JZ+xvJ`iQRv=M3QCc]E>`aNbNiE~VeX=iaaPVE~c>s`YGM`g<LLLCsX>KQaaQ`M-HWu`Cm<xaaSgIZA`i]``OvQaWvLP;s>%)Hfrspe\WT<)'4K`mfQB;<G`c]YLHMJL.Kc3P`Xx`LcJ2kIQc4Pjv
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1630/ccs/rev np:i:6 rq:f:0.9942
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGAGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACCGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGAAGTTCCTAAACATGTTAGGATGTTATTGATAACAAGTCCAAACGTGGACGTAGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  OgCSoZb5~h\gT`}C4JE8T3P\T%d[?AUoHyUZ~YV4fZlZvYRQZjJ~DP0XM.OqlhkL~j=}qZa~gF~Ube~gdVjvYhERti2~~PF%EBgdh:~~ju?vbhbtWmZtTD~A?lO]tUtVLVc8XjltTWXZPT<[xtF~;~Xtj3u~~qgb~j=~e^~TsYR~JySsld~YtWW~F_;~bcli@ivYV7~~uYmHc|c~[sVf9@tYiIuY]oP`rcjBk0VxJTUVB47bQ3unUJjGyk^U~lbVBirXArK~kY@{vsHucXUEhf)~q,~[UmFFpcKtN~eZS~h?Pwf:~W~|'TWnVk`~Tn_JaQNn`r2TUUXfb.Sf<~v>}~?~~mVbkR~FkDKZo1&aK\2~nW[~uj[E~nYVtkgJ~~gt@RlNC//-@K/b[~YVYr1*t~~a\j\~lZvgbPQiAowUG~gLh^@}~[~ZlH~~jF~?it;^h+o:pk|~kuUc[gpRXiu=~liTsZkiIrUS0PN_NeNeViTsgesDRRUi:bghXlI~e~Z~tVYuWpk8xaeoYj)~~~~pW~bUtXVTrWsXWs3kkgRoj[~lWapaS]HzlXUfR?biifEa:bUk8]PRo,D:Q\noK9`bVWc8dTg/k)(shkWmGvM)UDc@b~E*yT:dSLdA^Va|f7QJlZ+pksWsCDbeTVrAig?75vbD`NR`kT>LB`^~PLsc\j<LU^cKMZ6y9~~><=CO3XL.Cb4`6[[g(}?;jl]O~}dcjCTRPXZWSi-pjCReEJzbUbOBD&gBUBnUhhOalms?R<~q[pTCFd^Wa`\*/\C\IaNMQB2rQk$cSoI4qat[lk4bwj0q_W~kgbfpa.M|fChjZIvdDCpTZY[~tS?Vj\jDjM<dd`6z[iT1RT^QJFR7%I=K\iDJef,plvP~TIMVwdDio^TLOEaP,>&@C6'Q0URR*;?f`~IlX~4yoXXlK~tTXlvZkcOkgJ<GsLrkjUX)v<|QYaBpUklZvF~@6ugG~9cv~p`kY{2}FkJ~llZt+YH~Sjv[r4~x~wVYZ~~ltVXkVVp>liI~S`dX~Inc~l)~hZuJv<?G~~klgfY~a~h0gh6iiYZ~~K~vg^AX[~[s[slLnGvXQ~~OzZb~lJkGuqHmRqYoG~YXb~j8~;yGtv~i19TBdrT>RhEilv=_@vVJtl[v[~NQ.HlT4d?ZpVEhT>BEQdakK>rGajQtJ~^GgsId2H\PImBcHJtN;qa6f[G%JeW[`iR^]JV2xcGQfJf`K_.vvtC8ssfIgOcQuNhP`dZAs@tLPCjP/afW_@ff;;[ApS3MhQLcMg=?pvu`C]O32MHgQuMa=ixf:FF<X0qGuvaiag=ga[FWRuSvdJFPO`K?r]RhBia\IDLPg<NngIh^QjaRgbhDnP8eP[O]X[N[\K4fO_4QDH8eVH-aO$`feNIT]PGEM\nttttttpielstsC>\_`J^G;JN0mOe6S@ug]MND7q
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1649/ccs/fwd np:i:6 rq:f:0.991695
  AAGCAGTGGGTATCAACGCAGAGTACGGGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAAAACAGAAGGTGTGAGGCGCAAGGTACATGCTCTTACCCCACTCTCAGCACGTAGGGAGCGGAGTGTGGAAGACCAACAAGCCCGTCGCCTCTACCAAATACAGCTATCCTGAGGTGCCAGGTTAGAATAGGCCCTACCACATCTAAGCCTTGAAACGGTCTGTTCCTCGTGTCAAGTTCTTTGTCCGCTTATACCGCCATCTCTCGTTGTGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAAACCAACACTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGCCTGGAAGTCAAAAGACTTCTCTACTGGGTACTAGGTAGGTAGTTTAGAGTACGGTCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGAAGTTCCTAAACATGTTAGGAATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACAGCAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  UgF4G\g-jkg\f8'KII3FUGXJZC7K`\G4g\c=v\IVL]c1aJJS9YCSK=ii_4('IaNi\^8_JWh.qKSGFQ9XPf^gWL/jRFX]Eif8DXcI\-qwuZIWL]\IPk\^\H>h7PR=EOLiI3ZH^gZJ[JBD1+SFMYN`1NXXW]3>G*G10<>7=`Nd6ZeHZOiI^H@hOgRYIVPZ6dJSf\0j\VI>>?:)YOHGI_g[7haKF5@R\\P\gOe@jYV=\>gH:aU$]nXfJ^:ugI`E;MD\jgZIXGHi\g:dP\\Pmg\+s[PmHhYGNigXIe3qbiW<]YISMH^LM]9uRHX%eY57`b6gYK\7cdF^g^gI$\[[iIHgj\K:_^I8gXSA=o^>bGP49GhH^Xk^gOifE0>O]WW3gKfKi\IhGP9ZFd5x^>,c4bm7ZI\I\gI\HhI/[Ni\NEeW02Z+r]PI`MjO7386QZG2Nhe59O9DROi\^g]EkNV%fg]]OifMgMfIPk\Gka4@XDiU0eI`GGEjj]ENbOi5k\J_ZgINiI\IYhEdYeED`\N<jd]e5Ghd3vXFii`;diMj]X/F:^Ah/>[6iYG=q\I]Zi\^e3GJ9ghIWY=ziY5gj^d8=B;K7d?NF&DB;@>9HfH^\CIiYX8h_fOifIc2+QdNcZ^4bcQ9aODI`Ih;e9MHFB3/\`F`4G]6S6UfVEBGHi^ZJHdHZf>oh@P6e[Ji][bDUbHhGPYGMWNe,^Q6FK]\gNiLeLZL<jjjj\=wi\I\gI^e\JhSGjkf=bI&II<b[VP_,MHMYIZgH[Ii=xdL3k^gS][5iiiiiXHNibGYJ0TBTDWb8_hfIgW,q`WG]g]<cJEii>jd9RRHQAdJ]c%e\,^6E7h[;bhZ6HGEF]>b@]NFFPHhHYXG[3JVJhY@PCKBBBI?VIPk6h=6bElhGkke?wZi@qgI;gVH^\H2hh[Ji^SBHCQC37%DE[,NJ@id]WJfF(U40`JbDY;:6B84=51SK6FcE4gG[E3`V]Y?xf1\J^gPmgU'P6_\?jMgHd64YihYKGKcD`GN1$:AI_I2FEB;YLFBWWWX$ZFKY\^e\IOga*iL'gggYXU4\72ZESc%Z9_I[R_H2if?$][Tf=yiFiiHZG\UeT0T9JJT>NHLG6T;XF<SPc9_(`eF[gLmV5\gJ^eGF6R]bIZ*VUIeF;cHi:EBLJ]Ii]\PmgPkITi-hWMSI]Qe=y^gLiIi^\ZIMbFF73C2iiiie]EieHGe\6eGDAWE'D>X;kZf?_5BdeNjOigYBZLFgJg<n<gOX<B'Q+N;]I9Q.DdWK[i\QBFJ>G,SN9IM<[^KLQ=dNd\Mf7MNXKI[]%JF[iMM3hhhJ^XjXJ-4GBH^gI]Ri@hO;hG[EWe=y^WgF8e3o\XHhHNdMfIi\gMkJ`Lf[LgI5hhI\[i^I]<e8S=G`\0`>ehhC\JZIiXK\eF6MgGHi[aVIiH-ggg\-dfYJX^X>iHh1qU(Xh:e@2Cg9.djMA0[F[[HNgGL^A\g\^TK>jj`J[i^gNh6Z3cPb7gaI]eF.;3\%b\FIY^[IeJg=x[iZBe-CGg.ugK_[?NHJd3J5LZi[HV3[V8YVJZ[i]Ji=xZQ>4Q\I^g\YXMc&CGhWHUKH$`J53G\fgf]TNOWafdbbcfdYOM\g\IeGi^I^[i\ENY4C4G^-H\g
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1649/ccs/rev np:i:5 rq:f:0.992475
  AAGCAGTGGTATCAACGCAGAGTACGGGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTGTGAGGCGCAAGGTACATGCTCTTACCCCACTCTCAGCACGTAGGGAGCGGAGTGTGGAAGACCAACAAGCCCGTTCGCCTCTACCAAATACAGCTATCCTGAGGTGCCAGGTTAGAATAGGCCCTACCACATCTAAGCCTTGAAACGGTCTGTTCCTCGATGTCAAGTTCTTTGTCCGCTTATACCGCCATCTCTCGTTGTGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTTAGAAGGTCAACATGGAGTAGGTGTTTAGGTTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCCTCATCTCCAAAAACAGTATACGCAGGTACAGTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGGTAGACGAAGGTACTCTCAGAACAAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGGACTGACGGTAGAGGCATTACAGCAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  *L8F<GM1RH<ET7OTGB`5MGMfU0DYn]:cCB<^I\FXHOEG\[i@A&si,Vghe^Qi`0@N7:I\@hNiHh]fGYFGF519[5dghBHCG5\AhhBI9kk]L]IM4fY-lb(^U[i\eCIBF'Y]g\GXKIfEjcL:uMaHY[7ji\KXWi^[i]JkYW6Yf2WK1I:V'GN:OUh3i\f^fF4\\P(JN/gggbLL\7\e6CeZ62Z,hh_;G4_^AG@C9a$c3JHY8PFXh6DgiI&[ZJKdIRSfOiHLc\eELEZ4ICNi\HJ7Y[INig=uKggIZi][=Q22^YPNa[^g\^\[iIPj?h4Ejj]3h\^\ILi>mC,61D4E\Mi)?OTEQN5YPjI[*[cEP>RILgg\^\^\^IKeI\3RCcGUgDiJ4E,M&Q<ZY\Y[ZHH@hcKKc0XG5kW]eA*Y^dU16b?OqObYMnOs;Esc]La5wcgl&@[\N[m(hgfAvfq<@zoMbr<[9F(Gnq2|(TL`Ob`>fd5~~hjP&ttWyeuhOSuuPQuoCV(lhdN^df*sMoeT\oPgasOcQ`Csc@f`;~uKuu@wV=Wyf\c+_P^WyVxq@e?VZqVvshr3SUOSIfd37cfq<UtRQGtOerdX&HQPuR8wxxwqRUvf:UchfMaGVne>~SSvdEIIF_NQFuvt5|\LgoXf^Us/dstmHPPb]boX=fl@cIQdm3*9seNa8pgTqWcKg[PSfoNLeCsg`XeHN)hesTrWQNsP_>@lmPmER%Ygu\\UaNNuQfhrOXLdj+]]\0va=mSOYi4mP>j9MubROe\eQUu^_Vu>``Ok,uu~~eZO@~goObhGNX0~XIsda_NoJuuQZMbOPf<PplA~fOkLhKPLL+L?6$(>GKS_[Xwe)jgoNhdORt?ycshd\OZqN>te,vWN:ZQdgPfrgpashD~=rZ@g?mR6|qgWaRrB~fhZuuA~ug3tpBdfOuhef<Me>'mQLoe,abfsbXfQeuVvduOVf`FefsggAwmQl=MRjQPugKUOn6]Nc^gNa=^Lm1~gXvfCzRtOfe)mtB>[PFufdbZe_;~|fshfr1~]q?hRo(,A8K<epO0^I6nmL&}~{dNPfbOlLhMQgPRtfPGtg.~~~qauPDeEt;KvvhoQND`U=\h^Q@so:M_g^whdtNOPq?wve:N%q\^fN@f?Q]O_;N9P_Vvdiah>~KrUrgQqOgSNt3~c7ze8^ApujWgsVvCtKcAy^TNk@`>qehsKV*~}eRL9<mS=ofOhd<s8~j>QPHmRrVvcwh;~pTn6R*>9stKTP^>[Nsb<OfLuuPGlp3~me<ZMTtPn=gS[wKuu>opUuNDtPKe@~pA~NlOuA~eLeuhUs-W)hunPP6]MSlg<shOadeAnFoVPtPOuVvUt<UshVwKuuQ4qe:d>e\:fbSa>pe7nDt\EmYgsEnQhQeu>~dBa<KtuFvv_5rs;cWUNoQqh%~lmT5k>nh^^A8_ujKuusf[OsXxBmVvsgHoA~uQHnP2quuj?{[Ojg:YGEdsQfrMfO9qtvgBi;L>hOlRlDs=pYVOcg+HCoJuuOphp(aga\PPYV`\<b\JgOPffcrQiLf@f`Nq:1mof\c)ohQuhr4qLSpVu-yufR?th&A]WLp@~hnVvr_rOg%ttttttttttttttttttttttttttWPfrQcheOQMGl=H)SWumWNL?/Q
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1688/ccs/fwd np:i:8 rq:f:0.994267
  AAGCAGTGGTATCAACGCAGAGTACGGGGCTTAAATGTCGGGAAATTGGGTTTGCGCCGCCTTCAGGGGCAGCGATGGGGGCGACAATTGTGGACCGTAATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTTGTCGAAATCAACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAGTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTAAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTGGTATCTAAAATGGGGTTTTGCCGATGCGGTCTTCAAAGTCTAAAAATTCTTGAAGTTTGCGTTTGGTCGCAAAAAATTATGGATTTAGTCGATTATTGCCTACTAAGCAGCAGTTTAGAAGTTTTTAAAGATAGTTACGCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  mxPKr3NBoNfbi,qRUnzW~Xdir7jl~sU}@zyLX`]A~kCyuS|6~h-t_UXSZrXIvRs0a.LKhS4RsVic6~~~~q=z\W{I[UQC~JHaTL1pe7~eW^]{fRQFdWsf?~~xlJ;hU`:kkdqG}[pTXNd]7csSnS6_HTqU/wFzyV<ygPb1/TadThWeGyrcT?&cvWsKzJ~dWAxu>coUZ5U8iH<8UnTvWgXc]U=ytSt<XHzzyBvKV$sae>^Sw[UNyRR|VsAq^d`WN1azVvsWreRZ5a]BO||Xz[UXFbRq_haX`2[fcTW[C^Z^dWcTSKfbxLxJ~{sU2QC6qo[nHg7jbzDb^F{_EVAM`kPY4_M-:\gQxaBNnFzWXtEFfrVK||pLITWIxPc:mRRF^cn^oUfVbwDHu]Yk&POBtdVJv|w^SW%zzfnSMaPU85eSudseXexcW@^B2v?cTL2x`NOH~YFOOrDb^Hd;ucIa8LXqGyQsTNURLTVIsgFt_qUz0MwZdVm^DQhUX[ZgyFPG]yF|fcVzDh<mpWbHVzVJzX\8o\aBy;_B(_?]dXsyV9YX}YdXS\aY\'@Kp7udf91hf>iGZW\nDcS7EQJauD~RnRWD&r10VxVqbc`_T|zExU'WHJZaEl;TVx@@yyVb2c>~~|rcfEcsP<=z~irRF:epB7wwE~6ZT=V4x~^IeyW:/Vc]B{GF~c]R`Dh<pYMU3vUS$[aS@qeQWdEbTmNfrU}igVB{{rr]UX{fD~bA;xcqBJA:=<Y:V_$yutTUVSS6Vh%n1WI[UXzVa0EU_aaZYV{UebCCvqWyT_YBAcUN\UQ_YTwXNpsYq<Ot;8U{T4qo7uchUOTAqUlQTP3evzvYbUdH\DcXq.xqIOZQ7u{{mBWvVoRC_]]GTc=U~XS@dfDxo-gixpUPBOmdbd.abvB{9s9uB^\UcCrXsVQ_iIkJy\T<Gh6VV>yi$zm%uG||bJvg=~~pQ_]RE_TL:byc4pD~bJYMUP*/`u/zvgr{rf9kWS*pklT3u^A}cEnU0j`stT}yA8BeY]wdYzN[1SpHgcQu?BuaZaj|c;Y@fwTlGbrYjdW|Z9L8.a~tPccO{DiE]UX\xUbq{XtQ]@wjJxzUfQ@vYVpfUBzXyBLH{SyH~oO__0hAkFQUMPZ`oVJ|}_ZyC{rXl6NF~]ksYWQB`V,qvUvXwavccCvaVc3~zQWc\EyNC~\ck_EbIc9lZWnWCdT4vYNV^zL{w?qWD~tc6~lYy\~\yxW@zzeG{NZgc9~GzyfR}\@zPfR8WM{{VT|nDrH}_@drW=||hrU5tUGtT]NM{{^TyU_VsSzVDw?tDAcvWV|yFjPPf1a>UI9I1ewuSVc1xx=||iC&iga:uLA|}pTF]V?psVsVhqhVV|P|{dG{{{^R|YrkW~sP~lAa]UdVirVzUX3bpRNvZzQwi|o^C~BjgW~P{jSaF|LRbiZFa^O87o~s$oxCC:lT~eUfF~N\R|p1wdVaDa0}}}D5{]ThH3ZU?r]S[DKxtJ~dqYk+Onz{aW~{f:{d=||zUMXRgT}SU|VRvJc_eVyQTRLgQR6^k[,4qW'z||q0qH@%SYEUm_D:9$]fnvzzzzzzzzzzwmd`elha^eqyz`VefpdpRHkVS|ViOTLm9[OVs_~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1688/ccs/rev np:i:7 rq:f:0.995887
  AAAGCAGTGGTATCAACGCAGAGTACGGGGCTTAAATGTCGGGAAATTGGGTTTGCGCCGCCTTCAGGGGCAGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATTGGCACTTGTCGTGCGTCATAGGACGCGTTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATTAGTGCAAATAAGAAAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTAATGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAGTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTAAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTGGTATCTAAAATGGGGTTTGCCGATGCGGTCTTCAAAGTCTAAAATTCTTGAAGTTTGCGTTTGGTCGCAAAAATTATGGATTTAGTCGATTATTGCCTACTAAGCAGCAGTTTTAGAAGTTTTTAAGATAGTTACGCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  $yM`ZDb4D~rij\Tz[OGlt=Y`m]<~~S:SsJ_|md[[M~xE~e-~T~k;~~{]~K~}NyI~Xl>?4T4flUOTz1~~~~\gWHVZI~gsTu\<~y29]TvIZm9~U;~m[z`~;o~k^~M~iUC~~15<^?i_\nZw7~~z\gM~eHR@_|>W@Y/^c[hj<~SnX?mb_sNKZR/~}ZHY~c~~{C~dB~~zwkfSYHdlc^eW\l}t]h9lbH~VP7~~X2HUbC~^[}hl]~N~l_~NH?~~mLxu]ZSDRIj\DRRPjV[Q~~~lJe[;~Enb-G9JjSln~]s\s]iXzgilN~~[J~>~m_}NoQQpn[[hLkNMx\iId~mK{A~~oa[[[tT~_d\Vm8\]RZN:k|DmQgPceZib:T,zv=AZig;~~]lJ{o}~lh>~~|_]`_6F<.U:y~V~jdF~~gE]ElmhtOn<~~]tz]gY\~~v:~|\^ig~tl[S~Ytj^r{^YC~GZ<S~ij{JG~,~y~`]p7v-~jEP`[8~K~mw/K\oxb~{PuE|~|~}N~^~^sL~g~O~Izs\^~|S~}]L~~[e~oQN\]|WF6GowI^O~v_^g^g{s]vGjf~Xi2ZQ~8j_^~g^[`Wc_z~Z'\jAtYAa7o.pkcNtbG\UH[O~ka~{3rr|Y~ahgeHtRO~~yk^uL~~YMV]ztYkUJ~~Z^vYi]\~gn@@~V]tku=~~o^ASc\[SE[P~I^~t\@nkHPmnsz9fv7=~nrB~Z*`Tnl{_\gL_sW~{DqcONAxW~~c~I[e~Y[`}g0P~XH{^ByfZf~]|1i}s[W=~K9~y^yJyYlqJ~O~_/Va=qI`WHE]|9~yoXd2obi~efu\9~YAwzk|lwHlRJ~+cioXK~s]6zn)~jVZwnZ~,rlxXa7>gok4~p&t~~~|{K~dZ{5on\`~]l`j[jK~i>]H.n~~GuhYXIflf&WhfMoekllesYzookzZy;~]i_N~~}F~{Sj~O~~S~rY~J~~kJ~VSM~\gr\BQ~{vV~XauZBisA~~Gz~6~~FKdj\T_d[kYvg_l\gTu[M3pem{9tmnUN~m0K?qEGG~~[~^~i'}6w~W~^F|Nx~H~sg~2~~R~c~Z|WD2S\~,wt8stI4~~MhtZY~oZ]|X}SbC_]Z&{u2fkX7bS|WtWfs[~S~tySwGy\zWKcUaPkBZG{NCyNUpN|xNVJ4vUrVATZg@^SUjpOwGK~~rc^cJ~}dX{VnNS|{Wr^)BlfLxVz_@pTOz7}}|nUQrEA{Uhp5~.qLNcVOqTQUpF`DYHsb\1rSnKx9TdwWi-zifaWwVixnWX9TL{~rCcUqCIwQA`DqL{vW@VV}rH~rV^H||WCwozoUSeqIyTwpGn`qWzPZxeWBpkD~gKx(vvvdqg1ZpLy^GC1kzwYI{c2jhyq`~r?UQ]T1ZUfn%uGya&.z|wS]<U{VXJU:vzfO`ky]bCDx[UrzXpadrQTcR|VjAP4||Z|?~neMHitG_Wf9]Boz3~~]M{v^E}gcPXTMufS>`CJeeswRo0xzB4lR>oZC{k:sxqWr/yjIygVsV,z||nGyczMxVBk|d^gWhB8RV<XpI~ScXaD~`DbQUbX%uxcbH6L^@fw{{J~sdiO__~cDpD$kty{{{{{{{{{{{{{{{{{{{yrmhdb`bpeeYyWOYUf3^TOOODmaT]C1&~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1757/ccs/fwd np:i:6 rq:f:0.997919
  AAGCAGTGGTATCAACGCAGAGTACGGGGCATACTGCAAGACTTGTAGGCCCATGAATTACCCGCTTAGGCAATGGGTAGACCTTTCCTTGCCGCGTGGAACAAACCGCCATGAGTGTTTTTACGTTTACGGTCGGCGACCGGAGTCACAGCGCGACCAACGGGGCCAGGCAAAGGCCCATAGGCTTTTCCATCGGCACCGCGACCGATTCCATCAAGTGTTAGGTGCAATCCCCATTCGGGACGGACACGCGAGAGCGTTAGTCCGGCGCGTGCGCGGGACTATTTAGCGAAGGTCGCCGATCGTTTGCCCGTAAAACTAACTGGCAAAAGCCTAAGTGCTGTTTCGGGTGCAATGGTATAACTTCCCACATTTAGCCGAATAGCGCCAACAGCGTTATTATTTGGAACCAAGCAGTGGGCGATGTCAGCGACAATTCCACTTTGGTAGAGGTCGTTCTTTTGTAGAAAACAATCTAACATAACTATGACACTTTCGGTAAATTCACCACCTTTACCAGGGTCGTAAGTGGTCAAGCCACGCCGACCACTTCATAAGCATTGGTGGAAATCGCATCGACACAATAAAAGTACACCAACCAGCAGAAAACAGGTACATATACAGTTTAACGACCTGGATCTAAGATGACTACAGTAGCATAGCCATAGAACATGGCACTGAAATATCGATGGGCGTAAAAGTGAACAACGCAGACGATGGATTACGACGCCAAGCCACTATAAATGCTAATTGAGTCGAAGAAGGTACTCCTTTTTGGAACACAGATATTGCAGAAGCGGGAATGAGGTTGATATTACATCAAGTATCAACAGACGACCTCAGAAGGGTGGTCTTTTAAAATGACAACGTACATTAAGATGCAGACAAACACTACTATGCTGGATGTGAAAATGTCATATGTGCGGCAAAAATAGACGACATTTAAGAACCTAGCATTATAGGATGGAGTGTTGTATTAATTCACTCTAGAAGTAATGGATCACGGTGCCAGAAACTAAGGTGGTGTAGGACTAGATGCAAGTAACAACGGTCGTACTAAAATCAGCTACGCGATCGCCGACTTAGAAGGCTGAGATGGAGAAACTTGTCTACTGGCAGACCTCACTATCTTTTAGGAAGGTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAAACTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACAACTATATCAAATCGTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCCCGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTTCTCTACATGTCCTGGGTGGAGGGGAGTTTCCTTGTATGGGTGGAACCCAACCCGCCGTGAGGGTGAGTTACGGTCGGCGGTCATATGTGGGTATGACGGGTATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGACATCTCTAGGTCACCTAAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGGTGGTAGGTTACATCTATTTACTTCAAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCCGAACATGAACGATGGATAGTAGACCGGGAAGACCAACGTTTTTTCACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATATAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  d~g^ohqV~oWW[E{_g[A4A?mo]7MxnZ[^[ZT'\,ngo^\~coYU~D~~YocW}L~Z*~lg^M}YL~]HoQ:mijSboO~P~zL~a~f;~a\IW-~C~]?~p3~Z6nUTOUdDN$tmwNF^i/~xp^C~X[X{_hZLt9VEgnNm][W\OHfn:wAbL:~~aKsjQi]9~pIn;~nZoZV~HDjpb7ugSIWiRU'La-dR5kPn`~>~AQT*~gqhO~pIk[B\L~R<d|udGjM3pfi]CkgHY\gHSaR?c_gKuhWB)IGoGeIgreZRY+h[U[]iG~~U:Y9K~D~p_fO~dkq]RS~~h7{zf`@t~~]YM~_pD~]=~ydhM~r_~[ri_qg,~~^K~~riZ\~sV~VBoWM[LiA~tV^pW~~nSO~gVuipi_iLyBz^qgJfQ~o`u@7~~%Z[~IvH~a2Wfp>~~GNBicY\Zh_ik[N~a~K~/]V~~F{XYgU=sn`hN{]?~~~hqeH=hnpJNsk_qN~^pqM~\qXXbbNp_R~~_Y~sR~~N~\mKo@LnG~uk@mCHo~r^cVHsgZR`@YT`B=o^_hM~gZM|V\a~\.mM~h_oO~8iY6j?rrr_i^Xp_ik\kZIbo0~~~griW*-Y=i?~pi_ke@r~rInOz_[[DnnnB]og4~~O~YemN{mKrXq[mYydglep_ro`mirnRXYZagO~lUlOPs__qX~HY^rh/~{qpr_jprN~~Jgo;suuhmi]~_L~^i_nRn_gZpW~nK~E^gWFe6~^~i:~p_rpqG~~XQ]\WkN~hpipJg\~SXkW~lp_rM~>~~~~Oe=~]p[[fXVQ8~ZOmY;~g_K~~\~oPVOv^~fElq[}p_nY^`~jpZnIAm^ne-Lij>~mEWh`~K~~SPhoI5~~~J~~~rikK[~]hrp_o>~H~emrj^[hmIL~pFd\oY]rZpX_pE~eYgqhJ~~~pRp_nRTpiri_U~[0{~~~oUho^gY_nH~~]~d7~:|pZgKXKQhBdY~prW~hNph_~SmoN~_~O~^l[r^rpi-oim<onD~mY^d_J{YRL~XMCq~\XJ~WtrN~nSi[:hYIpZhprhLZwiqP~YXsJY~r_irp_rL~~km[Xg_i?\h_hpq_h=~gZ]Q~ohN~W~_pSofCmW~e^R~sK^~NUIop_sM~\DQl?~p\E^niiZC{~~TS~TmAph^q\e=lhLZ~JZZ~]h[i]sY~_Z\gX6p_]jP~s]Qcrb_waE~~a~S[QKRqblS~~]qG~sa_~CosK~~^s]iQsiF~~P~sO~gkZqH{_kst_<~sl`>n]lU^~Y]mS{^nVrskb~j]s`j`3kj]F]hKkg7qqh3JQi^ptpGma9~~sbjQ~jrTr[~sacw:k{P}kpK[^qj^CNUXO~brb+id~\~qogtY~_v\~tar`[S?~sakOpI~r<~qjpZqbt[KP~t-~kha7~s~aktQ~~tiH`Q~~Qe@Ij`<~~X~:~~?~bzkM~~sY~tbkT~z>~>(ntaI~~\sbrC]lQH\N~tQ~~tk_vJ~~~]skssLHwrW`TdZ_\tktR~tH~~tV~nE~~~mbD}y=wc~lp]q<~~[U~?~H~~b~I~~kPR)oitQ~~rTqjQ~s`F~W^Z~L[~sPrp]pkoM~~plie]bQ~~roZh[JSZ_]rI~~roTrbjR~SqZ'~~~rQ~~s\~t[~S~jtP~d~sbsjstjo>B5Mejtk`|2~sW~oh>h`tZ~bs6si_[n_tasqX|X^GP~uV~~]`Oe[k^WhrSrPKh9~~M~m=WC@rin:~tO~aktP~s\IZhIupRriNQ~raiJYj_Q~gpdHe_V^d~k`]jskshCus[~rMS{~[oLqalRsjQ~~]^qiXZmFrj^G_I~lI~rS~ak`\`n8gW~[qZ~tr[BHjRyW_p>ontn>y~~~kb~Y~bj]_SEKiO~LR~HYib~kd~pljQ[lUL~~pjK~~tY~rJ<qa~pLqk`p[L~~r_`ubL~~qMja[~[TH{{tlQ9~~j\P~jbsd~kaD~[=pA~l~O~SN~j^~O~sP~`S~TrK~~~kP~kR~`]ti;~QkssF~YsrkrXef*U<]sb~ksPyb~bj7~~~~Z;oOqI1=MgkH~~h]p_G_S[skP~L~~Z~IV~kTqWX~T~a[~[jsktMtKjx]as]X~[Wr<pqiKt`I~keZN~n[WfoY~rTqbi\6~f\QoWfrg`[N%u~~~~~~~~~wl`XW`kv~~~~~ulmu~~fgriP@]mTajd~kss]GmN\CfLn~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1757/ccs/rev np:i:6 rq:f:0.994762
  AAGCAGTGGTATCAACGCAGAGTACGGGGCATACTGCAAGACTTGTAGGCCCATGAATTACCCGCTTAGGCAATGGGTAGACCTTTCCTTGCCGCGTGGAACAAACCGCCATGAGTGTTTTACGTTTACGGTCGGCGACCGGAGTCACAGCGCGACCAACGGGGCCAGGCAAAGGCCCATAGGCTTTTCCATCGGCACGCGACCGATTCCATCAAGTGTTAGGTGCAATCCCCATTCGGGACGGACACGCGAGAGCGTTAGTCGGCGCGTGCGCGGGACTATTTAGCGAAGGTCGCCGATCGTTTGCCCGTAAAACTAACTGGCAAAAGCCTAAGTGCTGTTTCGGGTGCAATGGTATAACTTCCCACATTTAGCCGAATAGCGCCAAACAGCGTTATTATTTGGAAACCAAGCAGTGGGCGATGTCAGCGACAATTCCACTTTGGTAGAGGTCGTTCTTTTGTAGAAAACAATCTAACATAAACTATGACACTTTCGGTAAATTCACCACCTTTACCAGGGTCGTAAGTGGTCAAGCCACGCCGACCACTTCATAAGCATTGGTGGAAATCGCATCGACACAATAAAAGTACACCAACCAGCAGAAAACAGGTACATATACAGTTTAACGACCTGGATCTAAGATGACTACAGTAGCATAGCCATAGAACATGGCACTGAAATATCGATGGGCGTAAAGTGAACAACGCAGACGATGGATTACGACGCCAAGCCACTATAAATGCTAATTGAGTCGAAGAAGGTACTCCTTTTTGGAACACAGATATTGCAGAAGCGGGAATGAGGTTGATATTACATCAAGTATCAACAGACGACCTCAGAAGGGTGGTCTTTTAAAATGACAACGTACATTAAGATGCAGACAAACACTACTATGCTGGATGTGAAAATGTCATATGTGCGGCAAAAATAGACGACATTTAAGAACCTAGCATTATAGGATGGAGTGTTGTATTAATTCACTCTAGAGTAATGGATCACGGTGCCAGAAACTAAGGTGGTGTAGGACTAGATGCAAGTAACAACGGTCGTACTAAAATCAGCTACGCGATCGCCGACTTAGAAGGCTGAGATGGAGAAACTTGTCTACTGGCAGACCTCACTATCTTTTAGGTAGGTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAAACTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACAACTATATCAAATCGGTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGTCGTTTCCCGGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTTCTCTACATGTCCTGGGTGGAGGGGAGTTTCCTTGTATGGGTGGAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGGCGGTCATATGTGGGTATGACGGGTATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGACATCTCTAGGTCACCTAAAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGGGTGGTAGGTTACATCTATTTACTTCAAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTTGAAGGTAACTTGTAAAAGCCGAACATGAACGATGGATAGTAGACCGGGAAGACCAACGTTTTTTCACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  e{U]eFN;x_^d]Wz]U]OO\AKK[8ews]dNbHaU]CY<b^UxTNd,PGz|cMSWzL|eG|yUY0rJCvEJ,d?~uLMSd<wFps@c9P='qR]UdDzSv]NzwBvUBwddTcPbT9xxxcE@3irdY@Xa1Fh]UcBqAp>Od\L[LU]UY@MMyDx\9{hc>cLAw]Nzn8l7vydd^)`]A{{]>xcd]EzYY[@\UcOlU`P@Nzed]WzTD==WaEzL@\Wzd>zzzeVz]/`=5Y9lY1^F@Z?`+aT]UDxdUd]EvFQ3?X,YR\$Yad\I[=wxdU]VWzI~d\@OxUd^UNFasT8xwSNFyzrFbTvWbF}];yyo@Og`>iTPTFJD,]p\=~u@QGVydCg%C_=x\NTEv{e]e@yyb=KwT.gbc?ESNq&g]ZHS]URaaOeeJuaDa%oONzVyU]eUd?~~]Mb8Sc]eU]UcFNp<YLqL[F{kI~dc?J7wcZ-Ld]BtaU<X]U:yxu[.vMX\Vy]bN%tGGbeb@aGc\5p\-5x`5wU<]UfNzd9uDm\[NrH.bXN\UdWzUNA^NXCqSOue]T?dP_Nse]Q]WeKRj=[e5K;hNHyMzv_[HFJ8X)^^a]VuLGwzyUddG_KxVy>ycRYd@:hxx]eF}dcGdddNd]fT;wwUyGSd=mU6b4_P@Rk@bL?c^dcGcTNO>\cdeT;v^I^U(_ZQ_-OGc]dU8zaPbd[*HK1fbXT7%tZ>`BE^\S`2ACBM_]UdM(x^2[a\@c]UP{WzUNzgZdedNzyNSFIVxFuTeTN[?CuSDr?_dcS^Em6xyypF}WyXG[eUedeLwU\MST`@Y9\[NdbUeH}JuUP_MDxd]ed]GxRIWd\2v[eUe]UcOc6[eUEv/ec[B^b\,vvf4kz_NSNF@vWTMbEJLuTxQdNT^b+_F>xy]e\N^BP_Q>ENE|ebUWT4zzXJR8[baddUdV]AbF/xyyxcdVX]Ue[L-mWVyUVq)s`c@\eMeedeI~edHlNTdUVzUacSaUvO^VeYY]dc@OT`UdbH~d`ZK\GnOS>uMK<_c]dUlBpc-RNSNdE{M\_YTcOT]GxT_PyKSzYA@d]Ude]O3qz]O\fU]de]TGSdMXU<i>c]M\\@VuI~YNUeUa]G~`U6xp^UuTL\bQMbFc[dVdNxJ/a\Y\M\Fyzze9]%$3cb]e]UExT\1n\VA_@BGUX\Hu]deT=\R]eUNze]cVc]Dx\4}_AfS]U\@b]D<dc\a5zbYSudec2xx[NdU]dRJxzWzc=^+4VMBp]Ud_/><eR\Hod`UFxbKb6bdc5xb@@XHaNT_HMyyTLcUWzU]bMSb^Wz]YL`^d\/xw^W.^UwUdTNDr1S@V3kfMw@c]eY]UdeU]eLV\ed]VUyF}eRC;8zGnBZZNbGN?Mx]BSHjF~]Cv_UcMc\8YCAxcEzzU]&uoUWP^;aqbHe]NzxF}d]U]AzoH{3yaP{Vze=~k]'G\U>xwEzzF}dN\J[qdN\``Gcd]dKxI:W@XJRn$t`aedTMa\-utSJFMe]dPT[;]]<}{NE|d0z}zdUE{sP|TrC\Cd?~vNEv7fDyzVq'VhSM^*_MDd>ghdUST2ucW@abWAf\Dbd]eddMSM4wx^^b<c\,bgdedUe\@bYYN>xvKcUd]UKiDN[Gzzxa4}{dF}dF{E^>[OsDbd^cQ4aB\\eG{zUdUVo2c\EtbUBw]c>j[eF}e]eQ]dYYeF}`0`>fb%vv]]TbRFQEaTbULT]T/ws@edNzeNzSL;cXCw]UdOg8b^b@?wwEcE]Uze]U^e_WVzTdUc?KSdVzTGcUeUc@OzeF|N[1xtL]^`FxUY@?xyc]aB[d\F^FId\.vuE{EWz\TX?>7Bv5ybeF|NbGc]RRyeTbTcKbL7pzzkT+MGiYPe\@c]UGy\Le>yrBWTFseR_U]fS5dYJL%eu\N*`[\<QH@`]dKWK^=sxcVLs]=zzw[V\I~dUE{g@JPEzze]IvUZ]/RRG6yJ9Z5wzYErT%Y[K1VKxC\~b_~^o+~~PHU~^K~gpnMM~OGnoK~iBn^onHVGg8}u`~^pMsN~fM$i~~~lOngorfWW~_V~~^`~ghMjfY\^~7~eMuOI]V^ZoL~N~PK~o[k_oS~7~zkhmnM{mYDU~pnMofN~nXkV~ogq]YL~j_qg[?W~ic]UmHSR3${~zojpxwtu~~~~~~~~~~~~~~~~~~~]USpgogo]e3<~]qopSp?do^hd~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1800/ccs/fwd np:i:8 rq:f:0.9959
  AAGCAGTGGTATCAACGCAGAGTACGGGGTTGGTGTATTTATCCGCTACGTGGTGGATGAACATGGATGCGAACGACATTTCGAAATATACGCAATGATATCCAACCCTACCGAAACAGCAATAATTGTAGAAGGTAGCATATCATGCCGAGAGTTTACTACGTTGTAGCGAGTTTAGTTGAAATAGTTTGTGATGTGTAAACTAAAACATACCAAATGGTAAAACTTGTCACCCCCCATTTACATTGCGACAGACACAGTTATGGAGTGGATGGAAGTGTGTTCGACTGTCAAGACCCTTCTATAATAGTCGAACCAGTACGGTAAGTGGGCAACATGCCCATAAAGTCGAAGCATTTCAAATGGTTCATCCAGTAGACGACGATGTCCTAGACAGTCATGTCTCTTCCCCATTTGAAGTCATGTAGTGGTTGTCTACTTTTTCATTGAAGACGTCCACCTCAACGCTATGAACGTTAGTTGAGACAATGTTAAAGCAAACGACAACGTCATTGTGATCTACATACACAGTGGATGTTAGCGTAAACATGGTGGAACGTACTTTGACTGCGCTGCAAGAAATGGTTGGGTCGATCGTAATGCTAGTCGTTACATCGGAACAAGCCAAAACAAATCATTCGCTGGATTTAGACCTACTGCACGACGACGTCGACACAAGACATTCTTGAAAGCGCTAGTCCATGAAAATGTCCTAGCTTTGAACGTTTATCAAATGCAAGTTGTGGGAGTTAGTCATGTGAGAGTTGTGCAAGAAAGTGTTAACGTTCTAGCCGTGCTCAGTAACAATTACCATTCGGCGGTAACAAACGTAAGTTGTCACTGCACTCATGAGCATGAAGTTAGACCAGTAGTTGGGTCAGAAATTAGACGTGGTTTAGTCTGGTTACCGTGGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAGATAAACAAAGAAGAAACGGTTAATACGATTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTTCAACTAGAATCTACGTTTCATACGCGGATTCCACATCCGTTCTTGCAATTAAAGAAACGATGTAGAAAACGCTTTGGTTGGCGACAACTTGGGCGGCAAAATAATTATGGTAGGTAATTGAAGTAGCGTTAAAACGCAAAAAAGAAGAAGCACGGATCACTGCAAAAAGGACTACTCAATAATGGTTTCTAAAGTCATTATGCTGGTGCTCCCTATGGCGGTGGTCAGTACTGGTAACTAAAGATGGATTACGGCACTTGTAGAGCACGTATCAGACCCAGCTTTGAAAGAAGGCTGAGTTCGGTTCGGGTTTCACGTAGGCCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGGTTACCATGTAAGAAGCGGTAGACGCCATGGCCTAGTAGGAAGAATGCTTGTTCACGGAGCCGACGAAGTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGAATGCGTACTACGGTCGTCCAAGTTGCAAGAGGTATTAGAGTCATTCGAATAGCTGTGGGAGTGGTATTTATAGCATAATAAGTGTAAAAAACATTCCCAACAGCATATGTGTAGCCAAGAAGCGTTGTTGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGGTAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGCGTGCTGGTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAGAATGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCATGATTTGGTCGATGCGGGCAAATGTTGCTTAGGACTATTCTATGGTCTTGCGTAATTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGTGAAAAAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCTTGATACCACTGCTT
  +
  x|]c~LbMyaZK`M~_]H^.uD`wZ)olZAcBs_OM`2lib87bN5\y[FY3jUCrhYTYvHiPEn{MTOTGuXRMKX9_L^WYanZh\fVUYgyYEi\|U'\C`=ee^i5rQS^|]zV]Dh^VsCT2GvD]_CxHjV;t]e^CTXTHcVwWzW8{}{]a|^W-d:StFZD{W5{|oXQxXY|z[aV$ptV\SkXNGBILauZL;ahlKq]m4b2[\^Cw_Mq{lMRtV][v%@3/Wle6gawOqLxDZGz]zUhBqVcT2dRI;lnO8@TX]EyUJV;3HC9[9UpI_V_]0UJk1]bHcKZQX`_VhV^KUVlCjeW^lKC^XY]QU.sdWW_9sQE0g<3DB&RVPYEV[V\k>jPS=xlV&>=tLfTGQ@VY]SL??M4RdOWL>wVgNjDtX[LkWXF)CUKa7kgdyE}[.Q^VaXb`X]zT^9tNgXZY]wN+x}}wWWHvUWuZvFDZ<kwCZZX=BZDTGlZV+aSSO_rWKqW^UdZ3NWTQu2aWU^KveZYy]b{YTGPeLo?VPpMWI:LfX\A@@]T[<tbL36oRTH2XMbkVT'3IF.YJ1SJ`jM;stU{JG=E@Y^AKcmXPyz`Im;z?uz\ZF^FXA\f{UFFLfU6M<@Uj]vI[:p;qXIvQFaH{qy^Y{wYZ>9IUX=HJy|<~~jV|BiKyG]WZ?CAbFDa2R[GKATfZVKUf\zF]WJ|XSvqTYXVIzTD9gf3@:^`f?T8<dT\-<5anWWzZV0wbbX]^{zNX[[bW7xWC>kxvT0`sRY6tH=YWWGoWNwS\U\FWVAbdF_F/k[wYT/ULU<98nUIDZaZy3Wk{]gtMdk?|@A|X:P5ET[IwF:JL8UNFlN<^WE]x\_EHh\JYkZEvY]jIV`cDDwgOJFnfFZaYKo4bZKZuXOutM~jWV@EV2P0gdZW\=LAfPs_>K/XAmWwcT6[JrY\]UYl<JL@xYV9WVNvVw;^ypDiMOxz[OzuSTxY[y{\Ie>rJcKiZWyOu@dCagUNkw^oOwKj{]N}WbY3h[ZyK\{<gQuDP:KjKVtJZDKOy]KZ|[DBwnH`WDHVI7hfP~IyyLi81fVK{_IxSI[x@y5amV8vx]Wh6VZsX.wxx]V\5~L9gNk-vJ9h[Wx\Rl;{z[@l2=jxq]Rw:ai_9uIy5]YXx6A0Fm8IeK\VNt0\bc577-QOlgRUQG-BlVGjH3me^[U]_VY>o{|aE~}]^k[\YfsGW]ZH]/[iHGJvwU_]{O~kY2D_BkGW[\8nmYp_D{IAy\Gb7C^UFfX7%47Xx[KTbgUk^Hzw;wUV5jXu^DgXFfWjW\j\F^z]^yY{0wwyXXEnyT0onP[cDcW[TTW;{]FoJ^Z:jx>pu\gVC]e7sIY][Uk{[XhEgKz_vXefX\Jh<kBV2WghR|9rU2QJY\?rOVSFctGUvSY9y[WVcYIFwk\B|Jw\jT]\6eEsWgx\V)NqXNz]z^<vCWIyVzZUgt7GsrAIFQeS_HuNaTPrYKxzYsV[WP{lZ^MyIv_wXHZ%v{[]RYy^F\X_z<[S\GxH[T8-`ApT;SW\NiDmEuYz>hYWhV]JxNsLU\z]zU]ZV]?x~jV_D{ar3~cR[gE[fY=S\N]V]UH%q`<D]]{J}8xqU^:cY_vYb>EEU\TED}@gDSnU_S>vS%EHM['/HLg^^=imm0Y]{E{YoGBVYZ{H~\jQ~Vu;_fjY]Iv\,RI\Ph]HIibD^]?xrWe_VHT[Dx:tnWU\lHzaKEA]R\dWMDyV]WjBdGIU]Y\\8rM5R[L9U1]L[T;2]vJzIyCICd\Bg7R5u[J[R{z]XZkDp7VoY[i5gbi)oYaN\|\Hb]_fH]X\l]WI|Nk?LXtGc{\<zZIwMd8YE5Z[kEX8CK\]WHF]G_[JUVyLWgU`iUE_X>kJ\UMy]W]@{rVXZ\Z8(EB1AX5kXVM<|LlF_[>t`WPuDujT^C\]|{S<txHEv,qs6t_MVVMMF(15S@fdZU<wUYQlVDa\[YoImJ[zZ=b[^GuT\RZjxNVS\MUrPRAuaSEw<THjgWKZhpG~jTc]Y\>p\V@sds{{y]&nckqkcdoxwhWNOX_kvyyyyyyyraYYVHT=YTR&cEqIi@b\[5VH[}
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1800/ccs/rev np:i:8 rq:f:0.994058
  AAGCAGTGGTATCAACGCAGAGTACGGGGGTTGGGTGTATTTATCCGCTACGTGGTGGATGAACATGGATGCGAACGACATTTCGAAAATATACGCAATGATATCCAACCCTACCGAAACAGCATAATTGTAGAAGGTAGCATATCATGCCGAGAGTTTACTACGTTGTAGCGAGTTTAGTTGAAATAGTTTGTGATGTGTAAACTAAAACATACCAAATGGTAAAAACTTGTCACCCCCATTTACATTGCGACAGACACAGTTATGGAGTGGATGGAAGTGTGTTCGGACTGTCAAGACCCTTCTATAATAGTCGAACCAGTACGGTAAGTGGGCAACATGCCCATATAAGTCGAAGCATTTTCAAATGGTTCATCCAGTAGACGACGATGTCCTAGACAGTCATGTCTCTTCCCCATTTGAAGTCATGTAGTGGTTGTCTACTTTTTCATTGAGACGGTCCACCCTCAACGCTATGAACGTTAGTTGAGACAATGTTAAAGCAAACGACAACGTCATTGTGATCTACATACACAGTGGATGGTTAGCGTAAACATGGTGGAACGTACTTTGACTGCGCTGCAAGAAATGGTTGGGTCGATCGTAATGCTAGTCGTTACATCGGAACAAGCCAAAACAAATCATTCGCTGGATTTAGACCTACTGCACGACGACGTCGACACAAGACATTCTTGAAAGCGCTAGTCCATGAAAATGTCCTAGCTTTGAACGTTTATCAAATGCAAGTTGTGGGAGTTAGTCATGTGAGAGTTGTGCAAGAAAGTGTTAACGTTCTAGCCGTGCTCAGTAACAATTACCATTCGGCGGTAACAAACGTAAGTTGTCACTGCACTCATGAGCATGAAGTTAGACCAGTAGTTGGGTCAGAAATTAGACGTGGTTTAGTCTGGTTACCGTGGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAGATAAACAAAGAAGAAACGGTTAATACGATTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTTCAACTAGAATCTACGTTTCATACGCGGATTCCACATCCGTTCTTGCAAATTAAAGAAACGATGTAGAAAACGCTTTGGTTGGCGACAACTTGGGCGGCAAAAATAATTATGGTAGGTAATTGAAGTAGCGTTAAAACGCAAAAAGAAGGAAGCACGGATCACTGCAAAAAGGACTACTCAATAATGGTTTCTAAAGTCATTATGCTGGTGCTCCCTATGGCGGTGGTCAGTACTGTAACTAAAGATGGATTACGGCACTTGTAGAGCACGTATCAGACCCAGCTTTGAAAGAAGGCTGAGTTCGGTTCGGGTTTCACGTAGGCCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGGTTACCATGTAAGAAGCGGTAGACGCCATGGCCTAGTAGGAAGAATGCTTGTTCACGGAGCCGACGAAGTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGAATGCGTACTACGGTCGTCCAAGTTGCAAGAGGTATTAGAGTCATTCGAATAGCTGTGGGAGTGGTATTTATAGCATAATAAGTGTAAAAAACATTCCCAACAGCATATGTGTAGCCAAGAAGCGTTGTGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGGTAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGCGTGCTGGTGGTCAACAGTGCAAACTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAGAATGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCATGATTTGGTCGATGCGGCAAATGTTGCTTAGGACTATTCTATGGTCTTGCGTAATTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGTGAAAAAAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  QcMK>Kd/a\HWFFgLOI<MQLQ;E/LUWWBR&Q*,?Z.IilU`;K3NKVOAf5od6hNPRErNQmHoCNQQUJqPWGQHJob,R+Yjd^TIUQVP9prVTcVo?T7j/_tqB5mUAtlPXU=&_?sLTBZSVEk8hpV1ORSVSPWNU:dQTTOTUioCLqVPW^sVoDBOSWSVrqWC2mT?YkrXVJppV[S1VSoTp6sd>]-orfQKlW8e@ns`@V]'_]_RNNjUpPU,lbWbY:[T=,Q\aQ?RZOXV?AQ0SUH9SX8WB7R?IPa>IC`E]J[J=TJ5R?QoV^=IlVV0rX2\QaR`JtrWGoPVHoDlT1lW?5lnDnRo0omPCjRRrT7mrVZ1ECqVpRREY.NW-ooB;=ns^@R]qPU[5pTCY>RVOCUPVVrWpFxrVTP?RVpBW`EYOrPQo1uufXFrrVKtW_SX^TMHE]GsDoWbR\C>Hlqqd@WQn.&0C@&JYBkX)jd`NIjNWQqVeU<h?@BqVW^sUTEP-9knWTpAtrWP3nM=VWNJiPU%MY2d@VCT\Sn1LT`UNU:WMY4O%T3kQoWBN3k>][QR]EqpGmBlCTj>@PknQWS`UPVP^BN6m29XkLHrNl3PgnMWXrRVa:vrUB\NSaOS=kRSR`N9kGn?IZG*F06c]>1hdT9P-@NTPoEnATWkSRO*=OURpVOW=RUO@ANWlLWVNWNGoERRS>kORXU@trLIHJ<2MaDqU^R2J[k\TY>\aZVP+cZT:pOS5eVUp=4ls]CQ<WDKjTZ>o`HMUqYDmPU^FXHVVVUTpT5UP>aD4irUnV?kHjN5PiOpXW?rWhUTrOFIl1JO<W^m?BdTXoREk<@TmJ]?7hoQUI8^TQoVoPVP`VOXL]?T_FWHPT\BInCNEWDQBUSWnWGLY9ooLOZV4sc<]WBS?VmBCHnoURn;oEp@YQ?USaE\@rsVHaYUTRLQFcQ`OAqrW<rUAtVVP<qlQGm7siP6]KT4e@0RWOHoNW9[]ROUVSp?WAhT2?Rk`UboP7opDXIP=>RJ6gMVUalFqLTVlqRFrQ^VBKtp=^X=@HXkPVrY5ALAhXSn6UBLQX2qV`oQAf7=&RAAe@tqT1p;,QC[CQJA$ZYXLRMSk];4NbAR?RRM>]QWo6mk>BlP)SPUin-YRZUqGqYBDmpIvSqWJcCbYT?CDb4o]TIBC&Vkn`OEk)c2o@<W>C^VZ/VA]BO']VfHEjB=oER]O:n`2V\=QFocQn5doWbRX^YU[@>[9fnTLU6pcaYMC`NElp@V^?TVb@NoTV&BPE3emTCpCnYPoTPDk-TONXPLVUURMAEGdS\L?BS.oaDTRVqqT<gbCGR4[CeRXVRoJ@@NbP>pb;`nOVOQ<BGjBeS=.@ZPSXEjUVrVU7qT`Bn^l8T;.fqUWGqeA>]mU6qWXTX5kU6WQ@CkoV@=JV'nU_*lBs[QU`U(dFZE?ZWUPbqW`qQEOEmUDDqUVPWHsUQoS%SOHGGp;oPVTIoV>ssTZPSH:SPeT[i5W`VQ^=GpU@^UHt`SRRLD@_/M8]jOCm?]EoSMmAO8nTUC\aB\lXUCVmPX]YOVHvqCTQ]KZ7QfMBI9g0B0K@QYQAJR`F^\JsUJUe*ssssiO:?Q:tR:kOVVSXaDoV_H_UUDlGb@;oRP3Ma8\7QrMDNUEQ`&rroCnRX:onDSAFRPXHnRXLjGp0m^ST]:aCSPEkQS`O>rsVpP@rt\Dh@_U_>51gkU2>Q_nVS`TOP\SU>PkU>TXTpTNTgHQ6Alb$g\MEBMQEoG><iWL]UAZ(WJS`QVOT=^N*_d_VnZVZPHpVQE[K9i3D7KMmVR]^OpHqBQGW^3%BOXDhGlQGTk8jOZZO_B^OTaPT?WZQ2OOCPUZEifPMDSk-V?]GC]VX>kZPU8pLU\;ulU>hW_UVpPrWU2WATYQoPVCnR?pcCPo@VVSbS>:nrU/jQKRTB:ZEY`OVVrUO(jN=qsRHCU=NOoWGbFOIRL]PpX_HwoRaqCOUl7^KdTSADYDLGnqUCmVWcqVo,m*>8`GEQPUa:iXU$pqpld^PO$_diiaYV\dlkihijmpqrrrrrrqWJKTPaPpWRVFi@N;N2dRPUIRj]
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1860/ccs/fwd np:i:14 rq:f:0.997719
  AAGCAGTGGTATCAACGCAGAGTACGGGGGGGGCAGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTTTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTTAAGCAGTGGTATCAACGCAGAGTACGGGAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGCGTGCTGGTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCCATTAACCAACTACTTCTAACGTATGTTCAGCGAAGAATGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGTCGAACGTCCCGCTATAGTCCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCATGATTTGGTCGATGCGGCAAATGTTGCTTAGGACTATTCTATGGTCTTGCGTAATTGTGAAGATTTTGCCAGTTATCTAAGGAGACGTGGTGATTCGCTCTATAGCTGTATCTAATCTGCCAGATTGAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ~~~~~~~~~~~~xw~~~~~~~~~~~=~~~~~~~~~~~~s~L~~~~s~~~\~~~~~|~~q~~~~~f~~{~a~~~~~~~b~q~~~{~Y~~`g~~~~~~^~~c~z~p~~~f~u~~~~~~~~~~dl~l~~~}~^~~~~~~~s~~~s~~~v~~y~~~W~~d~~~~~~~~~~~~u~edz~~Q~r~~D~~~2~~~~~~~~~q~j~~c~P~b~~~f<~~~w~~J~p~~q~Z~~Mi~~fh~~~~Q~~~~A~~p~J~b|~~~~~R~~~s~~~~~~~~x~~:}zoB~~_~~dZnX~~~q~~~_~~~M~~~~~~~~~~l(~~~~~[~~j~~`~~~~~~~~~~z~~~~~~~~~uc~~~~~~~z~~~g~^~~y~~~~w~~~~~~~~~~~~y~W~~~~\~e~~~G~c~~~}~i~r9xY[n~~h~~W~~}~~~~~~)~~ny~~J~w~~~~l~~~~~lrI~~~=~w@~~at~~~~r~]~~pv~q~~qy~o~~d~[Xg?Fnx~d~v~~~z~~p~~~~~~~~~~~u~~V~f~b~wB~~~u~~j~~e~~|~~^~s~~yK~}~~~\~~s~~~~~H~Oa~Y{~oP~Y(~{a~~x~~wLwMc~j~~gS~E~3~`l~~~~~N~~~~P%~~~~~~~~~~~~~~~~~~~~zux~~~~~~~~~~K~L~~~~~~~~~~Y~kp~~s~~{~~r~~~\~~~~Jl~D~`~~~~~~tq~~|~~sj~v~v~~M~p~~~~h~~h~~~~~~~~[~~~~tD~~~d~~~~~~~6G~s~~~~uXv~d~~~~~r~I|~r~`~J~xS~~~~~m~~]_~~([\~~^~^~c~S~~p~~t~l~n~~~~~~~\~~+~}~~v~~~~~~~~~n~Td~Y~~~~~w~~~s~~x~~~|y~~~~~~~~~~~Y~~_~`~Y~~O~~~}~~~up~$~~}~[~n~bh~xpg`2W~~~g|z~~~~~g<~~~m~~~~~~~~o~~~~a~~n~~er~~~he~ihe~~\~~m~~~~~~u}~~~Zq~~Y~~~~~~~~ym~~~'~~~~O~~~}~~~D~m~~~~~~~~~{~~~~~~\~~~~~u~~~p_~~~~~~~~~7~~9~~~~~~~(l~~~~~~~~~~~~~~~~~~~~~~~~~~~]~vT~^m~z~~y~~(~~d~~~~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1860/ccs/rev np:i:14 rq:f:0.997512
  AAGCAGTGGTATCAACGCAGAGTACGGGGGGGGCAGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTTTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTTAAGCAGTGGTATCAACGCAGAGTACGGGGGGAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGCGTGCTGGTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAGAATGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCATGATTTGGTCGATGCGGCAAATGTTGCTTAGGGACTATTCTATGGTCTTGCGTAATTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGTGATTCGCTCTATAGCTGTATCTAATCTGCCAGATTGAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  0vz~~~~[~~~~~~~~~~~~~}~~~&~~~~~~~~~~~f~~9~~~~~~~~~~~~j~[~~~~~~~~B~~~~~~~~~~~~~~K~~~~~~~z~C~~~~~~~~~~~~~x~~~~y~~w~~}~~P~~~w~~~~B]~~~g~~~~~~~W~d~~e~~~e~~sp~~o~~t~~y~~~m~c~E~~~_~~wi~~~~~~Y~~~~~~z~~~~~c~~dL~~q~t~H~~~~v~~~~~~~~~~~~]~d~t~~w~~z~~~n~~~~~~~~~~Z~~~a~~1~~~~~~L~~{~~o~~V~~~~~~~~~~~w~~i~~~Zvq~~~n~m~~~~~~o~~}x^~~~~~~~W~O~~~S~~~|~`~B~~~~~[~~~a~~_n~~~~~~~y~~V~I~nB~~~~t~\~~}~~~r~M~~~~~~~~R~~hw~b~~~~~~~~e~~~wy~~`~~~S~f~~p~Y~gX~~~~b~~~~~hbA~~~~~~~bM~~~~v~~~sj~~~~I~~~k~~aa~~~~~K~~~~h~~~~~~~t~~~?~~~~~d~~~~v~O~Ys~~~~~~~tq~~d~~~~~T~~~~r~~~~~~^~~~~~~~~~h~~~~~~~G~~h~~~{~~~~e~~~~~~~~~~z~~~~{~~~o~~o~~%~~~~|&~~~~~~~~~~~~~~~~o__}~~~~~~~~|p~~~~~|y~hY}i~x~~~~~~t~~~~~d~~e~J~~~~~z~~z~~P~^~~~*kE?QSF~~~~~M~u~~~~~~~~~~~[~~~~~~~~x~r~~~]~r~z~~J~~H~s~{~~~~~~~>~~~~}~a~c~~~~~~~~~b~~~~~0Z~p~~~~_~~|~~~~~r~~~~~I~~~m~~~~~|Zd~~~q~~~Q~~~K~~~~p~~~~~~~~'~~q~~~m~^~Y~~~g~~~b~S~~~~~^&~~~~~~~~~i~~t~~~~~u~~~w~n~~z~~~~~K~~~~~di~I~~~~m~p~~~~~~~~~Z~~n~w~~~~~~k~~]~~~el~{~l~~$~~~~b~n~~~~~O~~~~~a~e~~~i~b~zt~N~{~~w~~~b{~~~~~~~W~~q~~~_S~~r~~~~~~~~~~~~y~~O~~~~~~~~~~V~~~~~Q~x%~~~~~~~~~~~~~~~~~~~~~~~~vu~~~~~~~~t~~s~~~~~~~~q~~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1902/ccs/fwd np:i:5 rq:f:0.991167
  AAGCAGTGGTATCAACGCAGAGTACGGGGTAAGTTTATTGATAGGTAAAAAAATCAAGAGAGGGTAATAAAGAAGAAAGAATAATCAAAAGATAGAGCATGCAAACATTACATGGTAGTATTGTTATAGGCGGTATATTGGTAAATGACGATCCTTGACTTAGTTTTTTTACATCGAACGGTTGCAAATCCTAGCATACTTGATATTAATAGTAGATACTGAAATATATCTGAGTATATCAAGGGAAATCGAGATGTAACAATAAGTCGAGGAAATTAAGGTCAATTTAGTGCTTATCATAGAAATAACTACTTAAGCCCTTAAACGAACTAACTCAAATTAACGAGGTAGAGGTTATTCTGAATTGTACGAACGTAGTCGAAGTTTGTTACCAAGGGTAAAGCCAAAACAAAACGATTTTGACAAGAGAATCTATTCCATGTAGTAGTGCGTTTGTACGACGTTCTATTCGATGTAAATCATTAGGACGAGGGTTTGAAGCAACTCGGAAAGATGGTCGGTTAGAATTTTAAAAGTACTGAACGGAATTAACGAAGTTGGCTACTACCTAATAGTCTTTGCTTAGGATTTAGTAGTTCGCAAATTGGGTCAAAGTGGTCGCTTTGGTCGTCGACGTCAAGACTCAACAAGTCATTTACCGCTGTACGAACCATCTCATTTAACAGGTTCTCACCAAATAGCGGTAGGAGTAGAAAGCACTTACCATCGTACGAACTTTGACAACGAAAGGTTCAAAGGTAACCAAGGCGTAGTAGTGAGTTAGGTCAATGTATAAAACTCCCTTTCTTATTTTGAGTCGTCAATGTAGTCGAGAAAGTATGCGCTTAGTGCCATTATTATTAGACAAGATAGTCCGTTCTTTAGTCGAAGTTCTTGTTGTAATAACAAAAGTAGAGCAGATTACGATCCGAAATTTCATGGACACAGATATTTGAGATCAACATTTGATTCGTTGACGTATTTATGTTGATCGGTTAGCGAGAGTTACAAAGTTAGTAATAGAAAGAAAGAGGAAATAATAATCAAAAGATTAAGCATGCAAACATTAAGAGGACACATATGTATTGGTGGCATTTGCGTTAAAAAAAAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  RkPR[PW5M<+5A&WQPRUJT:SD:(bjjVNkO5kkZIjOENJCmV)gXRai\VRAfP[KL<mmTCU8BdiO;e9:edO9f(9W?O6XWXNA=SI[PRZQ)P<lgRP,aKR[WCmW[PTN-SKIf,TUB]:3cUVO[Ji1iUDkhN9YP:YU4gKlP[RKl[P$iiaQW;<H[URPBX>>LI]894fgVElQLORWS:%FPL:VZ3VMgQPPVBOW?EQWP<liW[QOT9=MEN=?,A>N+e5bO9iiVP5HP[RKWNkRLkTKkPU<MEClGkjKl*P2cWRMj?mbLOWPRImY?OEUUK8gZP<aIWY;8iKMN/ggKl<khRP@V:P>RLVK'afHj<ULKDBZO[P[Cm3d[HlRWP@eJh:U[RM(HOLO[OP'I9cN9kX:9iZAfIf5nfV?SKIEj2kjaJ=jaNLID-jl[PWRJGM>G*Z:LV[GgEj[WPVWOT?HUOQL2\SJ=>INEQPKjOCC@WRKLVPW:ljRPEIm[ClEKO[;mf2^JL=hLKNkQRQDa9hgO[RAjT<D_9jZP?V%MW%$K;BDVVKWO;cJCmNkHl;S;JINPKlCmOUE3PA1`>DZH[PS5)WXORFj6Cm[.lTLOUEOKlQOO,WOGa<mmURGkjN=0fS<NQDlkCmWRPU<NEQPWRNkPYLC56J4@MNULL7ikZ?MJOWPW[RP=hDiES:>ND>]V<eQWCY9jQVO/Ca'B]UX:PClW[Cm[PUDN9PeOK?QGQADiFUP:TEQP<f:7jjO[Q=hQO9ibCkFgL&BA1XT-fEkKM4[P:U[PT.NWP[M2JYBj?P*E?NN:.$cgdM8;PI'aGLIdE>klkNDMRKOU9)c<NPF:TRP[O9ieNQLPH3MOIcEKN:@dK4gL4ZO;XQGSJCL?C4RM?2NK(LF0MSXPVAO>[OHdK7O36N;Q+RV@VR9kkePVCIV=Q[OFGK@-P[WCh:9gP5jkOBUEl[RYKMMDE64]eNEO[WP:fOC.YD9M3JQO9jNEQJT*)SSN=G4YN@%80gIU[OMKTIYN8i5G5O_O9jZPWE\REOFhc9EhhLF@g8`LSLaVNjWP*hh\L>:V8K9QY@NQ9jhQW=l;cO??NBNSPP??AM(I;eAd?B]:=AOiPRO6S&A33GZghhVB$WKLR]fhhhgbQ?622;KLLPVagaMC@FUEO;HVPRPJj8CU[AfLRWPRWm
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1902/ccs/rev np:i:4 rq:f:0.990026
  AAGCAGTGTATCAACGCAGAGTACGGGGGTAAGTTATTGATAGGTAAAAAATCAAGAGAGGGTAATAAAGAAGAAAGAATAATCAAAAGATAGAGCATGCAAACATTACATGGTAGTATTGTTATAGGCGGTATATTGGTAAATGGACGATCCTTGACTTAGTTTTTTACATCGAACGGTTGCAATCCTAGCATACTTGATATTAATAGTAGATACTGAAATATATCTGAGTATATCAAGGGAAATCGAGATGTAACAATAAGTCGAGGAAATTAAGGTCAATTTAGTGCTTATCATAGAAATAACTACTTAAGCCCTTAACGAACTAACTCAAATTAACGAGGTAGAGGTTATTCTGAATTGTACGAACGTAGTCGAAGTTTGTTACCAAGGGTAAAGCCAAAACAAAACGATTTGACAAGAGAATCTATTCCATGTAGTAGTGCGTTTGTACGACGTTCTATTCGATGTAAATCATTAGGACGAGGGTTTGAAGCAACTCGGAAAGATGGTCGGTTAGAATTTAAAAGTACTGAACGGAATTAACGAAGTTGGCTACTACCTAATAGTCTTTGCTTAGGATTTAGTAGTTCGCAATTGGGTCAAGTGGTCGCTTTGGTCGTCGACGTCAAGACTCAACAAGTCATTTACCGCTGTACGAACCATCTCATTTAACAGGTTCTCAACCAAATAGCGGTAGGAGTAGAAAGCACTTACCATCGTACGAACTTTGACAACGAAAGGTTCAAAGGTAACCAAGGCGTAGTAGTGAGTTAGGTCAATGTTATAAAAACTCCCTTTCTTATTTTGAGTCGTCAATGTAGTCGAGGAAAGTATGCGCTTAGTGCCATTATTATTAGACAAGATAGTCCGTTCTTTAGTCGAAGTTCTTGTTGTAATAACAAAAGTAGAGCAGATTACGATCCGAAATTTCATGGACACAGATATTTGAGATCAACATTTGATTCGTTGACGTATTTATGTTTGATTCGGTTTAGCGAGAGTTACAAAGTTTAGTAATAGAAAGAAAGAGGGAAATAATAATCAAAAGATTAAGCATGCAAACATTAAGAGGACACATATGTATTGGTGGCATTTGCCGTTAAAAAAAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  I]=JWOB&I4@92[MG:S8IN?C8$GOcDEJlQ.eUKROUESCP[)klgSMZPJfM)8N:NdZIQ,(WY7FZQ4iV'FePKl[P*ReXPSESRURN?XP:6hkOVNkWPW[EjE:RTVKiM;XP[U5VN3a+^c^&nL|c8UrQ'LJW\agM~UbYaXAkVA.^peb]]TIdYXM[WKt1sYX-v5KlfaD0NO_JE_W\>D7WCyOa\g_D\P`XPZ;zyO`aUKTcB/AR`fafYTg4wwJ{|gV+DAPKW`?xXQf5@yYNXY^'Z%oc.jBsKv:WT|OzzaGQZYWzbdY`P`\D}|a>yTN`XOZ/yX,e]JtT|XEOeYe/xWRX1gQGlSzXY[&nNHEF;_?u/>oU[\?pWyXP`Y\?nXVT7BSSAMeEAubK6[`Ly??&VO&Gjz\J|Az|vY/vtbXCHJh]\aYSzF_Z,adUUWJXJ}`QHM138GEOZYW=`tX\IU,YU\FsUdaFvXYMPWd>{pPYaK{aNzaYVX4Y5,T[X@yCBRyZgYKgFyS.ENKygYNvGy_FRv0vf.j{mZe]Ue\T|YJp>^WyR|Z[D{ZXzLyW%]YgaJ}gT|ga[LYLbv\X4u^;v_?xuIU$QQJIDYC@pVn5kcET2yYN:uZBYX?]oM|gS*bYLZPIZTR]1LYcYSyCRy\gYa@xx`J}\Yf[I,U\T|J}`?YUYMMyd2wWaN|WzYgYCk8wIx|_]\VKwP_<w\XPOJ>cEIY\E4X^7rDcY[QaW>A_X1yhXQXCkXF-krHwFxXK|{NzeAzJ{PaHqUX8VZfaVVH\MHh\E7c@Oe;@'IGH+]txE>P/wwIuf;RT`9ue_BDSgXE:XSyRGI1P8W\a)A<zz[c^JOWDUQyc[LDI|aDaXQq\Rs`[IWSy\`g`\gM~X4eVLwzaDW)SO]BJqO;iP:TA%Pb\AwW&szpX<FF]DFPYaXzaYZHL=sD7wc/ebYbN4XTMSSY2?S]%ZTUF\agX>^SC0svZaPbP1;A2\.P5U1glMAD0L:.:;N<@)'BVSV=5RA4CA]9M%NaF*S?@.&9H0CP7WA6-[XJ;*GF>n^[TygR{PW;yzmP4FRBjFX`QZZ/vbSD5^GlU/I_UJ(A_g_\.WY4\LygJyUa?xuV-<0/l,hdpqg^`cX$kcMIW[NMVbdaREADKYhswiVIGI<=WWQ^MPTU[Y[4NDZM\@q[SUUN:V
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1945/ccs/fwd np:i:13 rq:f:0.998195
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGTTGGTTCGTACAGCGGTAAATGACTTGTTGAGTCTTGACGTCGACGACCAAAGCGACCACTTTGACCCAATTGCGAACTACTAAATCCTAAGCAAAGACTATTAGGTAGTAGCCAACTTCGTTAATTCCGTTCAGTACTTTTAAATTCTAACCGACCATCTTTCCGAGTTGCTTCAAACCCTCGTCCTAATGATTTACATCGAATAGAACGTCGTACAAACGCACTACTACATGGAATAGATTCTCTGTCAAATCGTTTTGTTTTGGCTTTACCCTTGGTAACAAACTTCGACTACGTTCGTACAATTCAGAATAACCTCTACCTCGTTAATTTGAGTTAGTTCGTTAAGGGCTTAAGTAGTTATTTCTATGATAAGCACTAAATTGACCTTAATTTCCTCGACTTATTGTTACATTCTCGATTTCCCTTGATATACTCAGATATATTTCAGTATCTACTATTAATATCAAGTATGCTAGGATTTGCAACCGTTCGATGTAAAAAACTAAGTCAAGGATCGTCATTTACCAATATACCGCCTATAACAATACTACCATGTAATGTTTGCATGCTCTATCTTTTGATTATTCTTTCTTCTTTATTACCCTCTCTTGATTTTTTACCTATCAATAAACTTACCATCTTTTCATCTACATAATTTGGGAAATCTGAATTAACCTCACCCAGCCGTATTCAATCTTTATGTTCATCTATTCTTTTTGATGACCTTATACAAGTTTCTCGTCAATTACAGAGGTTGCGGTGGTTTATTGCCTCATTCATTGAACAAATCCCCACCCCTCCAAAATGGATCACTTAACATATTGCTACTGACCATATTTTGAAATCGAAAAAGAGTTACCTTGTTAGTTCGCAGTTAGCTTGCATTTTCGCTAAATATGGGTGTTTACTTGATGAAATCCAAAGTTCCAGGTTGATTGCCTTCAAAAATACTGTAACAAAGTTTAGTCAAACTTTCTCTCCATCTCGATTTCGGATTGTGATCCCGTACTCTGCGTTGATACCACTGCT
  +
  ~~~~~~~d~~~~~~~~`}v~~~~~~'~~~~~~~~~~~~~~~~~~~~~~~~~~~{sl~Q~q~~~nr~~~~~~~r~~~~|~~~~Z~~~~f~_~~~ylfw~~~~~_~h~~~~~~f~t~>~~~~\~~~~~~Znx`~~~~~~Z~~~h~~~~s~e~~~~m~~[~~O~~~~~~~n~~~~|~~q~~k~W~@~~~~~~~~e~W~~q2~~~~r~~~g~~~S~{O~i~~i~~~so~~~e~~S~~Q~~~w~~R~qIikn~q~~~~~~~~N~~~~a~~~~~~~d~j~~Ip~~~t~~~~~~~~~v~~~~~~~G~a%{X~|~~~~~L~~~~[~~~]~~\~~\Y~~~~s~~\~BJ~~~~~~~]R}O~}~~k_~y~^~~~~~o|~~w~b~~~~~>~~xv~~c~g~~y~~~~~~Q~~~q~z~S~~~z~u~~~~~'~~Q~~~~~~~~~s~n~~u~h~~~~~dd~~~Q~f~~~~~~~~~~~~~~qa~~~b$o~~~~~q~~[~~~~~lz~~os~~~~~~{~~M~~~~~~~~x~~~~~l~\~~~~~~~~~~~t~~~V~~V~~~~a~m~oo~~~~~~~<~~~~~~~q~z~\g~W~~~~~~9vP~~~Y~d~~~~jc~~g~~~~V~yy~~~~~~;~X~~~l~r[T~~~x~~~~~}~}b~k~~~s~~~~r~nM~~~Q~~T~~~eRx.~~~QPnx~~~4~~~~~~g~~~~~}~~A~~~~~z^~k~~H~~~~~~~~~~~~~~a~~Y~~\~~~~~~T~~~{~b~~~~O~~~~H~~~~~~i\~~cj~~~~~q~~~q=~~~~~;~~~|e\~~~u~F~~~^%i~~h~~~~~t~~u~w~wq~B~|~~~~nh~~f~h~~qr~~O~Yu~}~~bC]d_~j^~~~X~~~~R~~~~B~?~~~~|~~~~~~n~n~~~~~l~~~~~~~Esr~mnhJ~~~~u~~~rtN~~~~~~~~~~s~y~~~~~v8~~quU~j~~~bV~u~~X~~~~~~~.~s~~yG~~n~k~~~~~~~~~~G~~~y~~~~~_~k~~u~_~~~~~tN~~~~L~~~~yx[~l~z~oT~~~i~~~~~~\~~~d~~~~i~g~~~hmo~~m~~~9~~k~~~x~~F~~lzi~XY~~~~~~~~~~{~~~~~~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1945/ccs/rev np:i:14 rq:f:0.999584
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGTTGGTTCGTACAGCGGTAAATGACTTGTTGAGTCTTGACGTCGACGACCAAAGCGACCACTTTGACCCAATTGCGAACTACTAAATCCTAAGCAAAGACTATTAGGTAGTAGCCAACTTCGTTAATTCCGTTCAGTACTTTTAAATTCTAACCGACCATCTTTCCGAGTTGCTTCAAACCCTCGTCCTAATGATTTACATCGAATAGAACGTCGTACAAACGCACTACTACATGGAATAGATTCTCTTGTCAAATCGTTTTGTTTTGGCTTTACCCTTGGTAACAAACTTCGACTACGTTCGTACAATTCAGAATAACCTCTACCTCGTTAATTTGAGTTAGTTCGTTAAGGGCTTAAGTAGTTATTTCTATGATAAGCACTAAATTGACCTTAATTTCCTCGACTTATTGTTACATCTCGATTTCCCTTGATATACTCAGATATATTTCAGTATCTACTATTAATATCAAGTATGCTAGGATTTGCAACCGTTCGATGTAAAAAACTAAGTCAAGGATCGTCATTTACCAATATACCGCCTATAACAATACTACCATGTAATGTTTGCATGCTCTATCTTTTGATTATTCTTTCTTCTTTATTACCCTCTCTTGATTTTTTACCTATCAATAAACTTACCATCTTTTCATCTACATAATTTGGGAAATCTGAATTAACCTCACCCAGCCGTATTCAATCTTTATGTTCATCTATTCTTTTTGATGACCTTATACAAGTTTCTCGTCAATTACAGAGGTTGCGGTGGTTTATTGCCTCATTCATTGAACAAATCCCCACCCCTCCAAAATGGATCACTTAACATATTGCTACTGACCATATTTTGAAATCGAAAAGAGTTACCTTGTTAGTTCGCAGTTAGCTTGCATTTTCGCTAAATATGGGTGTTTACTTGATGAAATCCAAAGTTCCAGGTTGATTGCCTTCAAAAATACTGTAACAAAGTTTAGTCAAACTTTCTCTCCATCTCGATTTCGGATTGTGATCCCGTACTCTGCGTTGATACCACTGCT
  +
  9~~~~~~~~~~~~~~~~~~~~~~~~'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~p~}~~~~x~~~~~uX~~P~~~x~~m~~~~{~~S}j~n~~~~~~wd~~]~7~~~~~tg~~uy~~~~g~~~~|~e~~R~~y~~~g~~~v~~~~_~s~~~~~~gw~pj~~~~~~k4ur~~w~~jz~x~~~o~~~~~q~~~~>~~~l~~l~~~y~Vt]~~~~~~e~~t~~~~~~~~~~ih~t>~~~~msk~xlk~~~h~~~~~~~qt~`~~~~~n~~~e~~m~~~~i~~w~~~~x~~n~f~~~~~w~~~~~~~~~z~~~~nP~~~~\~~~h~~f~~~w~~i~~~~~~~~~~~~~~~~id~~~\~vyZ~f~~~~~~~y~y~~f~~~~~o~~~~y~~~n~~~~~~~~~~~~~~~~~f~~z~~~~~k~~~~~j~~~~~}~~~~~~~~~~~~~~~~~=~~~~~Z~~[~~~~~~~~~q~~~~~z~~~~~~~l~~a~~p~~~~~~~~~~~~~~v~~y~~~~~~m~~i~~~~z~~~~~~~}~r~~sy~~~~~~G~~~sU~u~{~~~~~~~~-~~~~~~~~~~~u~~a~~~c~~~~]~~~~~~~~~~~~~~V~p~~l~~~~~~~~~q~~~~~~~~~e~~{~~~~~~~~~~~Y~~~~~y~~u~~m~~~O~~f~~~~~~Y~~~~~}B~~~R~~~~~~z~~~~~~~~]~~~~~~~~~~wY~~~~~~~~~~~f~~~~~Y~~R~~~~~|~~~~S~l~~{~O~~~~L~~~~s~f~~~~]~~~~~~~~~up~~]~kZ~~~~~~~U~~~~~~~~~~~ob~~~~~~~x~~x~~~~~~~~~~|~k~~T~d~~~~~~?~~`~~~~~^~~q~te~~~a~~~~V~~~~w~m~~~~~~~~~~~~~{~z~~~t~s~~~~~~~J~~~~J~~~~X~~~~~-~~~~~~U~~u~y~~~~~~m~~~~~~j~{~~~~~~~;~~~~~q~T~~~~~d~~~nC~~~~\~~~~wV~~~Q~I~~sp~\~~[~q~]~~~~~~=~r?~~~~xweqs|~~~j~~~D~~~~~~g~~cG~~j~~~[~~~~[~~~]~~~m~~M~~~~~yh~~~f~~~~to~z/~~~~~~~~~~~Km
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1948/ccs/fwd np:i:9 rq:f:0.997785
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGAGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTAACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTTAAAGGACTAGTTGAGATAACCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAAGAGGCATTACTTTAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  c~zJVQmW~~X~QI~h~ghxozrAfM~~~lh~e~fS~}~B~~e}mxFz~gX~@~[~~=~~ySiL~~^~hwL~gh~R~h~fyximq~i~m~U~~~~kf~~g=~}a].x~~wl|l}}_c~~~vVh~\V{~R~X~~ekPt~mh~b~~~c~h~zT}7zaaq~cSQM{FZ~clwW~Q~{mcg~{hcO~i~h~~g~Mqj~~~I~~~V~<~qX~g}i|~YUX~d|ig~}~eUppcsQ~~{x~h~~>\_~ZkX~f~yhd~h~~d~Tg~X`x|OE~~ja~~{~h~Vg~nY~~h}|W~zE~WzfjP~~|A~~b~Z~~i~z]fk~S}hd~eehm|y~~~1~~h~ZH~kF~~F~~~E~w\~|l|lO~h~Wd~Y~~T7~|d[dzl|v;~i~9~ob}z1~~y]~x|}k]V~~~~{w3~~~rZhv~bdg~gt{oLf{~Q~vQ~~B~~p~r|>~nTGfdMd~b~Q~(~~~OLwskv~O<t_s_~~q]oFa~[8Wup_xtL~m_vKeba~tt~ak~\{N~tda~Q~2f^fossN|Zsv~cslD~~~~u9~~sc]~\_|oKh]D~~~R~Mk~bn~cvy~Ox{qt;u~Mta~$xoz]F~Kjbpo5~~~~iJ]^}~cu~LbnzBeq:~~o]~yC~~~xumtW~uL~wL~};~sbtKv\v~a~uY~]ynws5|xtzrlt^tWeKywb]l^~_uq\}_Yq^~u\~Lh\c[X~wbIjRd~\~D~~P~~~D~q~`~~aU~w^~c`2~n\M~\9J~_jm\Psu[[c~]@~fty`~tU~M~a{97_~b^yYc[8~|pc~tY~`t[]~RufM~gM|ao~L~~cT~~B{~L~R~t~`Czx~sL_X~7S`nw~U~~fqOlea~~jL~~qW2zMQcg~c`[~g6~~~.~~~~_vK~_RtNqrMrE~`vq~a3~~~w]~ue~D~~U]~`ems\~sS\DrlW~v~u`ha~K-|g~'@u~bsi9~cau~^q~at_Ws~LNCki_~aa~P~TtP~xua~vx]~g_~ao~5ystuawn~>~t~c~a~Is[~K~~NxJ~9~~xP3`Jvt^R~tOjQ\Dn~p~b~o9~hwPk^R~~S~R~~q@~~a~I];~O~~od:4j~^M~~`~vQ}noH~svsJiDu'~<~~N}qT~UN~N~pKZ@l]jVxFm2D:k~[s4rxu]tjrf]_ajQ`nu]oejZ^kGwXocZ~A~oh~NXiA|~l_~_qwG{_~`~Yq[|qvhcg1Vy~^li~TSfVQa~|KtU7~Q>{qVOp~kU{asv|EV>j@NZcziQXM,q~y3)rpk=osjDr\oDxU*`uK~\tk~qHu~~xa~sGM``~yr~vqeNsOpJs~~^_~n~^~^k=x]~>~~xu~a_~EsC{~ka_aaOIl\vA~d{P=qjtag$gkP~s^~TXzJGrsa~tar[nb[ZU^RXzok~M~sx`~naLF~/wsO]~Qxk~_^A~B$~~mYaowrrx~~yrrpe[XYfmjtne~fNXOhLJO`x`L}?<L:\j^a~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1948/ccs/rev np:i:8 rq:f:0.994982
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGAGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAGGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCCGTTCGTGTCTATAAGGATATTCTTTCATTTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  Y~I^~`_5w<sitp~o[FfIa]`~n+ihc^[y:~sPmXt(QQs<S<r>^\h~^~6~d/o~~}vC~fG~i[ZxR99WrR~\LLaoWcF7t[Bo~~b^+~~oH~{bt0|~~~~[W]B,Ii}Kz;i~wkX8ZQ>~v_v_`reX{L~~}K~XkY~d3ujkJZCTZazpS~ZfMN_Ig_ht\~\hUMf@cEoqpq]CBaI(Ntqs-o4~~o~u~bYZ\yT;)g`L}^Ohdv\OVC}Ks`oG~s[~8naE/~$tdn`J~puF@kxQNv9~rVPYkR>Q=G`M/X<ic5Ul^|9DZTNYk~q\]~|\]qj.~NsknPkOdi~KfgErTI[?UL[NVL~u_[o@~h4~~_r~aa~xU~__MoOxJhKI~X~~}BZ]puc~obv~tbE~uul9N~g,B\I7f<k^~_]FkY<~xx~xnWaf]RagN-iNnkEE|h=kjPvo>wC]&ggRbFhfih\Wj>~{i|ieFgr@YNS]_GoWqTAWjUHP87;0PJHgCSSMB]e[uXedJ~hkRF5_=nHPPi]PDl>nj=~vDL1\*eqtoIEwYITDXgX'NWYt-qqNN~kFgPJv]VZSI~mPwhiDTwLhQheiX~YnyUj4`u~~wUK~[oQmUfMl5~~Z~~^eG_9dzkpZfQfwZIrW0~lDVF`Xg}mYDf\We~Vg;{vV~kZnvDvm[d~JxW]UdiMNkE2ofK|PiafSTe9jWv[[b)p8o{Ds<em2ObVTy9_@[fj(b:8pYbLj}rfhVPekTWXmuEukYtnFe~^xIiYZcrX~i~gihYwlnuhT.~~Yrg[Y}jE_eALBUW~kkliYm:~kaA~|X~nG|f~Fll?~~fDwmY~jBW^QX3ryYxiak9OI;nktF7{Z@nWmvW=vi?faW4elWO?6YGXESQ%VVJHpkYP]G3xmnu_jY=vJ]U&Jbm[1Qm]H~vlKHy`KGqmT~kf~EUCpJ~wiXH<~wRMPfImiJPMXFL\F~mhniF~@~=\fiw[ln[r;pE-th)|:~~~~giHUDTYnf~mk%[^;?BfZhiVa)_r[Y:-J}~^wXNf`Mf9~z<g^GwR`K~f~k4~_e~E~SXL~~k`iZU~>tj[kg2_tV~~H~rkmxFM~YsGpQR~H~v<zmU~F^jk,T3oq(~jg~XrE|\X]~hXy(~N~s~XS5SX[yjE]TXjhxY~b~mT~iDp8qXqDVtkK~%~~YZJ~kKmZjcV_iRxGk`H\R~jO~ziu)uZWiETg=~ng~YM~~<W{V<~|EhYLYujuh=~bkkyludeh0~~~_P~~wVuFxX~]~E~ph[|?LIUBR76KohT>esPaSDv9ZQUjEAp2sW<x|c[&XZ^JzQ]EoG~H~~aWjlIO+~N~~ehdYDsUTdiN~BrsHHlEY3NblU~ZsmkJZiZy[Q~WT^h4biZwVx\~ZMvKkDUPOB[PHk`Vr=nFf*hdh;~?$ysir~~~slnjfkswwwxxyyzzt`WDujTahETXJuVxisC~adiYcTi
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1960/ccs/fwd np:i:6 rq:f:0.994341
  AAGCAGTGGTATCAACGCAGAGTACGGGGTTGGTGTATTTATCCGCTACGTGGTGGATGAACATGGATGCGAACGACATTTCGAAAATATACGCAATGATATCCAACCCTACCGAAACAGCAATAATTGTAGAAGGTAGCATATCATGCCGAGAGTTTACTACGTTGTAGCGAGTTTTAGTTGAAATAGTTTTGTGATGTGTAAACTAAAACATACCAAATGGTAAAACTTGTCACCCCCATTTACATTGCGACAGACACAGTTATGGAGTGGATGGAAGTGTGTTCGACTGTCAAGACCTTCTATAATAGTCGAACCAGTACGGTAAGTGGGCAACATGCCATATAAGTCGAAGCATTTCAAATGGTTTCATCCAGTAGACGACGATGTCCTAGACAGTCATGTCTCTTCCCCATTTGAAGTCATGTAGTGGTTGTCTACTTTTTCATTGAAGACGTCCACCTCAACGCTATGAACGTTAGTTGAGACAATGTTAAAGCAAACGACAACGTCATTGTGATCTACATACACAGTGGATGGTTAGCGTAAACATGGTGGAACGTACTTTGACTGCGCTGCAAGAAATGGTTGGGTCGATCGTAATGCTAGTCGTTACATCGGAACAAGCCAAAAACAAATCATTCGCTGGATTTAGACCTACTGCACGACGACGTCGACACAAGACATTCTTGAAAGCGCTAGTCCATGAAAATGTCCTAGCTTTGAACGTTTATCAAATGCAAGTTGTGGGAGTTAGTCATGTGAGAGTTGTGCAAGAAAAGTGTTAACGTTCTAGCCGTGCTCAGTAACAATTACCATTCGGCGGTAACAAACGTAAGTTGTCACTGCACTCATGAGCAATGAAAGTTAGACCAGTAGTTGGGTCAGAAATTAGACGTGGTTTAGTCCTGGTTACCGTGGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAGATAAACAAAGAAGAACGGTTAATACGATTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTTCAACTAGAATCTACGTTTCATACGCGGAATTCCACATCCGTTCTTGCAATTAAAGAAACGATGTAGAAAACGCTTTGGTTGGCGACAACTTGGGCGGCAAAATAATTATGGTAGGTAATTGAAGTAGCGTTAAAACGCAAAAAGAAGGAAGCACGGATCACTGCAAAAAGGACTACTCAATAATGGTTTCTAAAGTCATTATGCTGGTGCTCCCTATGGCGGTGGTCAGTACTGTAACTAAAGATGGATTACGGCACTTGTAGAGCACGTATCCAGACCCAGCTTTGAAAGAAGGCTGAGTTCGGTTCGGGTTTCACGTAGGCCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGTTACCATGTAAGAAGCGGTAGACGCCATGGCCTAGTAGGAAGAATGCTTGTTCACGGAGCCGACGAAGTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGAAATGCGTACTACGGTCGTCCAAGTTGCAAGAGGTATTAGAGTCATTCGAATAGCTGTGGGAGTGGTATTTATAGCATAATAAGTGTAAAAAACATTCCCAACAGCATATGTGTAGCCAAGAAGCGTTGTGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGATAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGAATTGCGTGCTGGTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAGAATGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAAGCCATGATTTGGTCGATGCGGCAAATGTTGCTTAGGACTATTCTATGGTCTTGCGTAATTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGTTAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  I{[Xa`mKhJKRE'y\`\N]cJM&HClnpYuLhb`hcQ~~hfOo]1`BEGdM~R@pZIABe\`KLcQh_BQC^ZI_GeIm9WI&ML5J+F;Z^IERR6SRacK{8lDnqQF@bGBUy^fJ[GmbOi]~^QMCS}Q~kQ_[)gQk]QbCA}_P^O_E~~g_jQ[7Zp`mhV^^^Y.QJVLQ'DFHz[\KE@s~~`m^6N]i^c?}~^m%u_Z\fmdM}=g\lQ~i,~~i'Z~aj[P)gfcWRP~sEHQDpYZaeA^_[GcGf`Y~hmP~9]kA~gk=~DdYMY`HH|F\MEj`jGK~`e+}I~[La9QfceIfZ_G~M~Q_j6T>diX~\b<}fFHyZ;hD:|djejCh_R\^CjHZK-xaE$|{eO|%|]^gf7s^Ymh`h^_MWGJ^FN8jgNI_W;^jGfd]R]l^^~5j~xhG~d]F~_i6dj^Rf`fN~^~`m^mfH:t~~\D9H~F3}_h^`fJ}_/kZJG~]`^kQb`G~]_H~:]J~`gafXU~m`Y~;fsGE=sbY`h\3v]\cA^]~OmOgk[Q^BcmfGf^d^OPh4WC~]~OJIOfI\x_am?~m@R5~\`mh\6~tZRHf`^XAH0F;b_C{zg?Q4~D~~b]`hmYJhX~m`^j;^m_`^~g_aa^RuCxE2uWN~%mCIHF9cpb[85~]`^mQ~bQ~~Q_REphfENH[MCGdH]9>Gj\I_A5.@\JY>1V~^^~^&yb^\IHkhad)_dfX5lh`a`f.~b3XZF~~^5~\_Af~dPE@~jZ`\4~_]~DI6~j:^Xz9LhGci`l`OHf^6}ZjI]J__%ah]^m`^~SdZ_^~^i9GKpA`H\l^fIe3`ZD`]~RKggWu^Q~^RuR]whL~y_Mi6daC~fyhtgXNaX:j;L>QTNN'PU^2UPah~maj.qXWi\^Z~*~b^e]iE~sS~ZhE(OkU~2~~lgq&X\4w@fFFoQjL~>~~`8{daeggkA|br%*4bSMqCT~gmM)ttimZ3o~QS~~fU~i(m_D~W~=qXYJ%?Lyb9PulfKg`PcP|e\syQ~In`H~e,TPCnexO|hkN|~gQ~hv\j`~vIVVRXJyxamr/dfO.S%;7kO_;^CbDyZatb\~Vhb~g~4~~eHd~hktulwXd7~~{gkhP~~JcA|X~hkrS@~hh~InogD~f0~~pqYyc~nyY~x]W~[LnasjS~knO_A(`~Lz~~Rjg6~~~~iP~X~T~gd`g[~oAQ^Wykf(~ppnX~]gxae]O>~vP~wC~OWghxE~~jwP\UytwTgyRWRKPpI~~tZ]Qp;K~q<iYd^kp]fuS[T~hyV~~fkyUsnYj*_4T;QcL~cA[i\eethkyqa$gldC>s{siI=kC+4]|gK~GDLndf]`x%V~^~iC~lM~s^G`_WF6hV~t;R\~YfZG~jrqGhOy\hMvHsTtP6dW7ZZ~f&d~sQ~Xwky`~SP~giY~_]e^]F@xXwX~D~xmessTpZ~fP~yiSasRe~hodM~_ZW~j]eY>sh_~`TmRcqfxB~O[jU~e,~~iMbM[h~hShe~B~pl5C-DYGVsQ.WsrePiyniw[gU~nRjyT~A~dV~Ug^{fhW~]OIs=Z_[wQhWvbRN~wqiQNkc8~jDRdLtZ\Wu~strjce\:qsK~f\Ru4Yd~~sd]h~K~j6~JjKSbpZ]iyfq[SF~*oh>~IS]<tgtWia`cRjthzK~~{f\Am@OMmkfZier6qbnbt8tAb~skwQUa-b=jeZ^e=~~h^N?Xmp7~g]ZqX~=~u]j_rT~]P^WY@oYQeU~Sgk,G?w:cTvTgy[~yY~yf=~OLMY&8I~wKwspOnX~O:~gkgYdwRIuvqi]ZXaRC~jiqdyL|5~O~Qw\O^TGVKvhgCCrcO~eW4aP~h<wX5~aCkOya`GRtQHY~_gR~qRPixP~x^jP~xk]frsdW[m2~vijNlOJf9L_\_fMZO@ARbY\cB5PZR~:p[~hJ~wZRnB~@dh7N,~~siDtV]gBWt~Vum0J0tjgG~gW~~ykg~Sa[eZY~qRpXa~Ou]x[~ygU~QfjsY~brkxTC~hb8~~PV~tlh~p[a_P~T~8_Xcg_Sj>d%vyusssqqkb[XPMTcx~q`[^gu~njrSM_RmPbSe~j]_oV~Gfykhl~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1960/ccs/rev np:i:6 rq:f:0.99314
  AAGCAGTGGTATCAACGCAAGAGTACGGGGTTGGTTGTATTTATCCCGCTACGTGGTGGGTAATGAACATGGGATGCGAACGACATTTCGAAATATACGCAATGATATCCAACCCTACCGAAACAGCAATAATTGTAGAAGGTAGCATATCATGCCGAGAGTTTACTACGTTTGTAGCGAGTTTAGTTGAAATAGTTTGTGATGTGTAAACTAAAACATACCAAATGGTAAAACTTGTCACCCCCATTTACATTGCGACAGACACAGTTATGGAGTGGATGGAAGTGTGTTCGACTGTCAAGACCCTTCTATAATAGTCGAACCAGTACGGTAAGTGGGGCAACATGCCCATATAAGTCGAAGCATTTCAAATGGTTCATCCAGTAGACGACGATGTCCTAGACAGTCATGTCTCTTCCCCATTTGAAGTCATGTAGTGGTTGTCTACTTTTTCATTGAAGACGTCACCTCAACGCTATGAACGTTAGTTGAGACAATGTTAAAGCAAACGACAACGTCATTGTGATCTACATACACAGTGGGATTGGTTAGCGTAAACATGGTGGAACGTACTTTGACTGCGCTGCAAGAAATGGTTGGGTCGATCGTAATGCTAGTCGTTACATCGGAACAAGCCAAAACAAATCATTCGCTGGATTTAGACCTACTGCACGACGACGTCGACACAAGACATTCTTGAAAGCGCTAGTCCATGAAAATGTCCTAGCTTTGAACGTTTATCAAATGCAAGTTGTGGGAGTTAGTCATGTTGAGAGTTGTGCAAGAAAGTGTTAACGTTCTAGCCCGTGCTCAGTAACAATTACCATTCGGCTGCGGTAACAAACGTAAGTTGTCACTGCACTCATGAGCATGAAGTTAGACCAGTAGTTGGGTCAGAAATTAGACGTGGTTTAGTCTGGTTACCGTGGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAGATAAACAAAGAAGAAACGGTTAATACGATTTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTTCAACTAGAATCTACGTTTCATACGCGGATTCCACATCCGTTCTTGCAATTAAAGAAACGATGTTAGAAAACGCTTTGGTTGGCGACAACTTGGGCGGCCAAAATAATTATGGTAGGTAATTGAAGTAGCGTTAAAACGCAAAAAAGAAGGAAGCACGGATCACTGCAAAAAGGACTACTCAATAATGGTTTTCTAAAGTCATTATTGCTGGTGCTCCCTATGGCGGTGGTCAGTACTGTAACTAAAGATGGATTACGGCACTTGTTAGAGCACGTATCAGACCCAGCTTTGAAAGAAGGCTGAGTTCGGTTCGGGTTTCACGTAGGCCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGGTTACCATGTAAGAAGCGGTAGACGCCATGGCCTAGTAGGAAGAATGCTTGTTCACGGAGCCGACGAAGTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGAATGCGTACTACGGTCGTCCAAGTTGCAAGAGGTATTAGAGTCATTCGAATAGCTGTGGGAGTGGTATTTATAGCATAATAAGTGTAAAAAACATTCCCACAGCATATGTGTAGCCAAGAAGCGTTGTGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGATAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGCGTGCTGGTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAGAATGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCATGATTTGGTCGATGCGGCAAATGTTGCTTAGGACTATTCTATGGTCTTGCGTAATTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGTTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCT
  +
  8YWMC]RO|RkfGTa_WF(?A.R'OZ&fkZSf,}$AB^l5~ufV'4<@%4`IC/4HO(3M%8>JNf~hjX%s_`gQSce}Y:bjv:~~ReJ~r]vZ]e`cHrBL[]oq[~O~:s~p]3l^:~wV`a?JqOSy`~f1thSz;hi\OipViDBwrRJ~gxfpZ/~~nh0rZS,nR]CtRb4oS*s~]^@te\~~q`e;~~frQv\NbJ\O~~i[+~kMHThPQrNHW/7X?7WmrM:M>H]u7dc^fqGy~xkxMxbggXcq_V\X9mNKepB=sSZqEmWWFkLpVbRLG@lje`e\Vk`^~@WL~wZ{;QkWLd>sg]`fboCYUL7IE@yGO\NO)_cXR)uRpE4Fqa^TWPTc2[hNL`Jcp7v~h.kz\OeGsgq@I{vdPm@uaNe<X`[MV>}rsCSdaMJhebN5E@D2m;x~|k0r`JQ@-0TV4QMeNcI{NmMVimkS:~~~~je:lObzhxYei%p@{ekW~jhg>AkaT~iN'zTfQ~gi<tjWz]ga~]~~e<?u~ihoSC~hb\jvAjQZgvsj^xkxuxkykzg]&~lh$AIP2KrGRVq*~jd_qX~\F~d~fiq_iSvs;rSqgTeU]giF~eP~~sD~<N5~~lf]YDhh_g~sijq`c1ReP~xkyrCE`FujT~U'h=foP:@i~rky\mQLQ]S~pH|~yg^IjDvltegxhQtRMU%4XR*h[fI\~hxW_DlMO~g]~~fjfW1rhrM~tme:~zkVeFB~k`cO4~~g^~TcP~U*UiJ~~WeOO~cXrOZ;~}]XBfr[\Ri?G->;M5AI.iE\JWS|BBr6MCG4XVmTQBU?IlX$aOQCB9D9N%X[qh]xP~wZ~xM~OHR)/.'CynbrQK~~khsd~XW^dskqMjePnjm`jmSnN]tHV-acQ{vMlI}tf`WZCb4KH0e_e]~~a~ta]QUEEaCr~rbrfTSzR{vNrR\S~Xr~hc~tyij[K8mgCaWu~gP~JQT4tjN~~gkYM~ig:y~PJmMH~tUPt:j\~noffv,qX`v=ieM<t~rya~SNrX1qK~S?~9e~ltw=~S~jN7T}jg~SG[Ob~]i]xk]4Wjha1`hJ]F}3'o9swku0Ria4~cXxc=f~TxHyk9&w|WdiEc,onf/~~}QOiW~~V~P~QvgMp_e~S>|F~}=S~47(~xynA{2nbTLyDs:xdQ~Q~d0TI`gPb0O~<~~mdhj-~~}~qgg~GyW~fTwjI~qZOwin`P%~~~43~mSYX^SN]eFTuCRx-}qQQ5I|~dWSt9tX%NWS`E1Z9Oc;zzXebNjK1s\<U/LJQ=gPSEWDVCW@w_CnT=r`L]ZUB}WXTA^?-EDCk6P_XRpetfmPoL~~wRg,vnO?~~eD~U~j\8lfN~cUn^wiM~k9~~g{iSqyJ~K}[]aT~jS_AhFYelL=sQkS~Ttb~S\~~Ru9~nD~\~xI|apXoT~gJ~hjE~ji<nkhJ~]CLgZ~p^fstB^TmKM`rhkV~g2~_wUW~`eI~fykhi~i`~_evkiyhsD~TbSXr:)nX\eZgtHjukf(nTwpyls[CzrTpRa~VMhb?jfswOOkjSe[1~AwR`~hXh~enJd@Y;utiwgXc_?T]aZzqwhktg]L~~uc'-~VwL~~v]ugfY^S~oe~Trg]3~~~~{ks>~L~a&\_ekx]v]eneGvf6~e~eU~ejc*~O]gjmbbjP]jtK~oL'hao2~FTKeW8cf/oRwZk@~J~~rish`]xeb~iuthUuza[R<~qqRrPqpg0OE~}FbgnQ~qksegfXnse9~dOTwPsQ<TeCclMrA;nreIIjtbrgj:~wIRBS`p3{g,~hgTrdC:H`1SbHkE_iM~hku+~_~U~O~SqyiSoQYNvRfcFnQK~eq1tc~gP{ZW~iDp]~j\iQ[jqIPl`T~\gkhtLuVjc<oW9tg[]dGs/S~_ZeU~hQe*Zj6QVW8lhqj\OwktbbPM~jeS~SB~kQ,~3~vg^gjM~~fE~]m;q0~\PtSdgyrRhF~jZ~~We=~NPI|?A~wegoGneM<jU{GhQ~fSR0]~(gg[eU~f`)w~NB~;OT~xelef~@]jM\e_.?tP\$~~~~|uqu~~~~{sgaeox|~~~~~~~~a`PNcrgCMT`=p:rFuG~x]WdI.
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1991/ccs/fwd np:i:8 rq:f:0.997902
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTCGCCACGTCTCCTTAGATAACTGGCAAATCTTCACAATTACGCAAGACCATAGAATAGTCCCTAAGCAACATTTGCCGCATCGACCAAATCATGGCTTTGCACTCCAACTTTGCCCTGAATCGTGTCAGACTATAGCGGGACGTTCGACCATACTACTCATTCGATTACGCATTCACCTGACGAGAATAGCCATTCTTCCTGAACATACGTTAGAAGTAGTTGGTTAATGCTTGTCTACATTTGAGTGCGAAGCCACTAGGTTTGCACTGTTGACCACCAGCACGCAATCGCAAGATACGCAGTAATGCTAAACCATACTTATTTGACTTTGATGTTCTATCACTGGGTTAATGCCTGCTGCTACCTGACTTTTAGTCGCGAGCACAACGCTTCTTGGCTACACATATGCTGTTGGGAATGTTTTTTACACTTATTATGCTATAAATACCACTCCCACAGCTATTCGAATGACTCTAATACCTCTTGCAACTTGGACGACCGTAGTACGCATTCAGTCCGAGTACCAAGATAATGCTCTTTCTTCTGCCACTCGTCTAACTTCGTCGGCTCCGTGAACAAGCATTCTTCCTACTAGGCCATGGCGTCTACCCGCTTCTTACATGGTAACCAAATCTTTGTTAACCACTTCTATACCTCGTTCTAGGCCTACGTGAAACCCGAACCGAACTCAGCCTTCTTTCAAAGCTGGGTCTGATACGTGCTCTACAAGTGCCGTAATCCATCTTTAGTTACAGTACTGACCACCGCCATAGGGAGCACCAGCATAATGACTTTAGAAACCATTATTGAGTAGTCCTTTTTGCAGTGATCCGTGCTTCCTTCTTTTTGCGTTTTAACGCTACTTTCAATTACCTACCATAATTATTTTGCCGCCCAAGTTGTCGCCAACCAAAGCGTTTTCTACATCGTTTCTTTAATTGCAAGAACGGATGTGGAATCCGCGTATGAAACGTAGATTCTAGTTGAAACGTTAATAGTTGCCGTTGGATTGAATATTTCTCCTCAATCGTATTAACCGTTTCTTCTTTGTTTATCTTTGTCGGCTTCTTTGAGTTCAGCTATTCTTTCCACGGTAACCAGACTAAACCACGTCTAATTTCTGACCCAACTACTGGTCTAACTTCATGCTCATGAGTGCAGTGACAACTTACGTTTGTTACCGCCGAATGGTAATTGTTACTGAGCACGGCTAGAACGTTAACAACTTTCTTGCACAACTCTCACATGACTAACTCCCACAACTTGCATTTGATAAACGTTCAAAAGCTAGGACATTTTCATGGACTAGCGCTTTCAAGAATGTCTTGTGTCGACGTCGTCGTGCAGTAGGTCTAAATCCAGCGAATGATTTGTTTTGGCTTGTTCCGATGTAACGACTAGCATTACGATCGACCCAACCATTTCTTGCAGCGCAGTCAAAGTACGTTCCACCCATGTTTACGCTAACCATCCACTGTGTATGTAGATCACAATGACGTTGTCGTTTGCTTTAACATTGTCTCAACTAACGTTCATAGCGTTGAGGTGGACGTCTTCAATGAAAAAGTAGACAACCACTACATGACTTCAAATGGGGAAGAGACATGACTGTCTAGGACATCGTCGTCTACTGGATGAACCATTTGAAATGCTTCGACTTATATGGGCATGTTGCCCACTTACCGTACTGGTTCGACTATTATAGAAGGGTCTTGACAGTCGAACACACTTCCATCCACTCCATAACTGTGTCTGTCGCAATGTAAATGGGGGTGACAAGTTTTACCATTTGGTATCCCCGTACTCTGCGTTGATACCACTGCT
  +
  ~~}gyz~2~~_~t<~{{t1{~z~`w&~~~~~~~~~~~~~~~~~~~~~~~~~85lTI~lbtv~c~i~u}t~R~h~c~e9~~wce~IBYN~k~C`d9P~}~H~mdg|O~~~z~)~rpY~}wO~xpF~~eT~|f^~G5jQ~6~~~|lpS~|Y~~gh~}~T~R~fA~jN$~~~xL~my~~~~Oq~~~~t~E|~K~~lf{Q~||\B~Co~|~Wd~eq[~t~~n~pzdy~`~vUHC~~x}|^wW~~u~T~rd~|f~e~~~c~{u~msgt~Xxb~~~sv-~f~y~_~O`{z~~~NpsSw=~~~~|oO{}a~ze~u}~~T~[~~eylc~~g~e^h~~T~t~ztosJK~~udx>~|t~u}~~~~~<~~~{~K~~h~~~~~r~Gb~~}u|X~~~~~~w~~~FPt_|~A~~R~n~s|X~v}dXe|~~B~pQ~~Y~~~\{rfyz~~~~~}_~z~|g~}x~j~|~~|uft~v~~|~zv~\~~M~~~@~~~~~ox~Kp~~x~~~z|~~~V~~~nQ~]u~V~~~~~z{rst~mIO~~MYZg\~n~~ug~t|x~~~9eRt~U~GyrBc~|qo~~`v?qcd~~~{~f~~~~~bb~b~}rqd~}}d~|Y~~ph~~~h\~[r~w|~e~b~hx~ff~gc~v^^~z~|<~{s~hwIW~|t~C~~+b~tR~U~xf_~sty_{c)~ytsn~rZ~gsy|`~~G~[i@~~~qG~~sm~AbD(acW~rwl~eY~crs]~s~ia~>~~Vrt~tO~~9~~sG~^~tZ~t~t~sM~l~]E~~p1~~rqgU~~|Vds~~gqp|s\~qnV^V~\~t_~t~Z~cI~RwZS~y>oJ~aWNr~~pgr~K~76Yn]~l~~V~~}\[}_~~r]z|D~|rSrI~vQqB~{Wjio~~V~o~rg|p|_~H~~~~tt~t~\jz\~]~trX~]~n~r?~~~~r]q>~~oF~DYY|g\$[nsH~ClS`~~|C~fh\Zcyu6~~lXJ~sR~~[~k]~s~st^~X~:~%~~sst?~~~s~~pSwor3tlQ.~~C~i~]qH~s\~\`~x^l|L~X~~_~tst|<qt^~~tt~~sil~K~~sY~r,~~rt\~Z~vMam~sP~r]~X}LV~sk~~SY~~jM_~~qG~~sri}o~j~_~t]~~p[~rV~~uV~~~~sb~~t~tR~p[~r\~~r~r6~WQomh{Y~\`~~M~Pqb~~C~NtUsf\~U~~L~Urt~t~X~H~dJEov@k~J~suvPR>|ut{Y~sm~[fdHnhr~rEhb~tt~sgrznV~Hj~O[rT~~s]~uBfXH~gY~~_~gi~]~qC~|pSpO\lIQL~a~ft[~ssZ~X~Y/zr9~~i*tqHUYJ~VnJmP|o}msis~S~ly:~~{[W~EX~st~b~~p5cB~~rq1~[%lCQts~j^~Sr~B~~~pT~b~~s~]iUnqZ~~\Z~sY~~t~ZF~s}[fnreDSa<PvFp~oF|q|yZ~|r~^~~~X~wuqtk~~sgP~~\P~~~_~]n~tk~^~^PzF|Y~sshmzQrt~o~verg~tt~Q~~E~^~~R~~qY~Fog\rts~t~\P~~n\Iqun~`~j,~f`is-~oRqs]~V~V~}e:~{\}]~t|z~t~hrczt}\X~}\iasa~uotq_~~tsS~~Z~s~n~t|pbmY~pyI~loZ~r~zVstrG~oj^~~b~xZs~\Z~pJ~{C(y~~~`qdqeYX~P~sn{zs~~tiq\~YD~~gN~~~^~oWrWXw{t~t~ra@{ja~j\Ul]s~]s~Y{T[~Vj<KpY~V~PN~rYD~~isp[~ssisn~~~}hC~~se{rK~qM~~ziU~;K~o}Sr~`~fhsq9q~Sk~S~uVI~S~~~r]~rg\wp}]qJ~hKkqlm~O~h|0~jYcL~R~j~qcZwY`G|uxFqsk~~t~]~~qB~~~~cDw]F~t?~~X>A~eR~~C~}de(~~xt~|_lIjFpto~sf~`C~ul~^n~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1991/ccs/rev np:i:8 rq:f:0.998997
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCGCCACGTCTCCTTAGATAACTGGCAAATCTTCACAATTACGCAAGACCATAGAATAGTCCTAAGCAACATTTGCCGCATCGACCAAATCATGGCTTTGCACTCCAACTTTGCCTGAATCGTGTCAGACTATAGCGGGACGTTCGACCATACTACTCATTCGATTACGCATTCACCTGACGAGAATAGCCATTCTTCCTGAACATACGTTAGAAGTAGTTGGTTAATGCTTGTCTACATTTGAGTGCGAAGCCACTAGGTTTGCACTGTTGACCACCAGCACGCAATCGCAAGATACGCAGTAATGCTAAACCATACTTATTTGACTTTGATGTTCTATCACTGGGTTAATGCCTGCTGCTACCTGACTTTTAGTCGCGAGCACAACGCTTCTTGGCTACACATATGCTGTTGGGAATGTTTTTTACACTTATTATGCTATAAATACCACTCCCACAGCTATTCGAATGACTCTAATACCTCTTGCAACTTGGACGACCGTAGTACGCATTCAGTCCGAGTACCAAGATAATGCTCTTTCTTCTGCCACTCGTCTAACTTCGTCGGCTCCGTGAACAAGCATTCTTCCTACTAGGCCATGGCGTCTACCGCTTCTTACATGGTAACCAAATCTTTGTTAACCACTTCTATACCTCGTTCTAGGCCTACGTGAAACCCGAACCGAACTCAGCCTTCTTTCAAAGCTGGGTCTGATACGTGCTCTACAAGTGCCGTAATCCATCTTTAGTTACAGTACTGACCACCGCCATAGGAGCACCAGCATAATGACTTTAGAAACCATTATTGAGTAGTCCTTTTTGCAGTGATCCGTGCTTCCTTCTTTTTTGCGTTTTAACGCTACTTCAATTACCTACCATAATTATTTTGCCGCCCAAGTTGTCGCCAACCAAAGCGTTTTCTACATCGTTTCTTTAATTGCAAGAACGGATGTGGAATCCGCGTATGAAACGTAGATTCTAGTTGAAACGTTAATAGTTGCCGTTGGATTGAATATTTCTCCTCAATCGTATTAACCGTTTCTTCTTTGTTTATCTTTGTCGGCTTCTTTGAGTTCAGCTATTCTTTCCACGGTAACCAGACTAAACCACGTCTAATTTCTGACCCAACTACTGGTCTAACTTCATGCTCATGAGTGCAGTGACAACTTACGTTTGTTACCGCCGAATGGTAATTGTTACTGAGCACGGCTAGAACGTTAACACTTTCTTGCACAACTCTCACATGACTAACTCCCACAACTTGCATTTGATAAACGTTCAAAGCTAGGACATTTTCATGGACTAGCGCTTTCAAGAATGTCTTGTGTCGACGTCGTCGTGCAGTAGGTCTAAATCCAGCGAATGATTTGTTTTGGCTTGTTCCGATGTAACGACTAGCATTACGATCGACCCAACCATTTCTTGCAGCGCAGTCAAAGTACGTTCCACCATGTTTACGCTAACCATCCACTGTGTATGTAGATCACAATGACGTTGTCGTTTGCTTTAACATTGTCTCAACTAACGTTCATAGCGTTGAGGTGGACGTCTTCAATGAAAAAGTAGACAACCACTACATGACTTCAAATGGGGAAGAGACATGACTGTCTAGGACATCGTCGTCTACTGGATGAACCATTTGAAATGCTTCGACTTATATGGGCATGTTGCCCACTTACCGTACTGGTTCGACTATTATAGAAGGGTCTTGACAGTCGAACACACTTCCATCCACTCCATAACTGTGTCTGTCGCAATGTAAATGGGGGTGACAAGTTTTACCATTTGGTATCCCGTACTCTGCGTTGATACCACTGCT
  +
  ]~nt~sx<~h~}]l~spDz]~pz~t&~~~~~~~~~~~~~~~~~~~~~~~~~~~wr]_~~ufft}O~\o9Wk}m~u~O~tJ~~jsk~u~tm~Y~{c^aE~E|`~~~~]l~i~sjb~~\~\rH~]~/~f]^~sZ~}ZDz9~N~r&p~jM~s\~~r]~si^~D~pH~~n\~}[E~fss~sis}sgZf~}g^q;h~~r\F~q\}b~~~~t{MpiqfZ~ss~Y~~s]s~g~o~L~~t~s]~sm~~{j]~~X~sY~a~i`m~u}~~tsY~~]m~s}gpH~EuW~g~irtk~mfth~u~Q~~stqejtsZ~k`~~u~zY~P~~ss~sviT~X~_~ga~~tu~s]qGmN[]rm~Zxi~ttt~t~i~gKrhB~~Z~~j~tI~~O~~]~tS~~t~irk~si~}]~t~D~~G~k~SpW~irsi_\g~b~i]~tH~~~{mhr^n^w\r~s[~sstY~sItQ~s}gr}u|h|Ppu~s]~T~~n~o^.~~~~~~t~j`~~5~~flSu~gP~~h~O~~s;R~~~t~st|~Y~stj~~\}K|t~o~~~b~|[C~C\[~tj~M~~ts|^~smws~~s]s~[~s~[REw^nY|~M~T~t~~Z~eq\gsZ~~`/~pQlL~gmcr]|q;X~q-ulrSqL~[hE~s~\J~t^~rt}V~sk~U~~~^i~_~`~~~_~\Xfsi~K~Dp]~s9~~t~SXf}J~^~T~~hr@~~q^~G~\~{tj~ux~|g^~~rrT~[swZ~`~~~t\gqb~~Q~~s^~C~rX~r~s~_a~Y~r@~~rR~~rsiF~~~pyt~P}ut~ts~s~~to~re[O~\}m~i]~Lcr@~~~s[~}[lpder}Yz`~~Y~s`~~S{<~zFq~`~~]s~~Z~hs~r6u~n]U~~L~~Y~zKxU`h]tr~b~7~~~~rrflbn{i`~kbnpY~_~^~b1~~~~~rtr9~vtY~tst}gqG~sn~[~~b~gf_~~~o~k~~.~~~q[~sC~|]~rD~sjssb~n~L~\~~ssZG~~~qz~]zztsE~|\D~~jpM|^nV~rm~q^~~}\g`~n~|EtXTh~~ODH~~tq>dphh~qO}tExQP~~\o\~n~dyo3~\Y~sY~M~~I~sm~i~M~~owE~~nH~:qso~Z~m~Q~WC~~tY~sQ~~qT~Sw`rA~c.brM~r[~sL~~l|tZ~t~tt}SG~sD~jJ~~qGiMm~b~~]~oc[~~L~|o\Sr~Z~^~~t~t~U~~[~sgfriV~~t~o~tk~t~Potg[e}s~rSo]~[_/xsZ~rG~~plN~~bB~~`~p+]^i~SK~~o~X~fW~~t~svsmls]~aQ}s[~s]h~J~r~u^~~sX~\p~sm~]}sis~t~eE|shZ~s~R~~^qR~mR~srgZ~~qReL~~osV~n\~~su~i[ymt~J~~~u~~O~dr~~stsr,~~rm~]j~~sjq8~oiqjs^~tshomxnox^qeZk^9~|t~\~~~D~~br\X~Rm{=~~qD~~~O~rY~qU~7~Wg=jdm~tt~q<|su~5~~s]~~tt~S~~n~b~~Q~~sk~sreZ[qt~si]4~~s~~oW\~Y|f;~~zlQ~~~srsgY~K~cIG~~sg[|t}~~iefq~e0{rm~g[~ttY~qissQ~~q]]~~m~u~\~s~sisn~u|Z~^pDuc}R|ns]Z~Zy^~i[~~^oQpA~Fjm$V3~~~~rQ4TL[F~_~~tgzt~is~t`~l\~~SEzz~m~s~\fr~~t~tmbns~mP~dt~gq\Sss~si~t|O~yNYZ~b~~^~~sU~~|ssZ~qF|tV~tioiS~~t~ipJ~qS~~~\Z~~`~si~thO~j~s]~ty~U~}|~s=`H~~~sX~s~t~t~ts\~^~t~sU~N~gRK~~q~`~~~Z~s{Yxqds~t~tttn~QYfY~~}:~~~hR_~tn~t?~~~h_~~L~~O~{dNU~~p{~q~s~jtr@~j~~~B~~tiscf
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1999/ccs/fwd np:i:5 rq:f:0.991191
  AAGCAGTGGTATCAACGCAGAGTACGGGGTAAACGAACATCCAACAGTATGTACAATCGTATGAGAAAGGACAAATCTGAAGACGATATTAGAGGGAGTCCAACAAGTTTGTGATGATTCACGTAAGGAAATCGAAATGTAAGATTATTCGTCAATGGAGGTATAAGACACACACCAAGTAATTATACGCGACGAGTTTTCATGTTGACGATCCCTGAGACTATATCATACAAAATTGACCCAAATAATTAACTCGTTCCAATAGTTGAAGTGTTGATTAACACATTGAGACAAGTTGTCCGTACTTTAATCATCAAAGTTTTGGACTGACCTATAAATGAAATATTCGCGTTGTCTTCAGTTTAAGAAGTGATATTATTTTCGGTTTCAAGCCTATGTGGAGAGATACAGGAAATAGGTAAACTATAACTAATATAAATATACGCAGACGAAGCCTGTTAACTTTACCAAATCCAAATAGCGGGAGACACTAACTTACAAGAAATGTACGGTAAGACAGGGAAACAGGGTTTGAAGTTTGGAGGTACAAAATCTTAATCCTTCACAACTGAATCAACATTTACATTCGTTACGTTCGGGGTTTGTAGTAGTAATTGTTGAGGTAATTTTAATTGCACTTACAGACGTGATTTGGTGAAACATTATGTGGTAGATTCATATTTCCGAATCTTAATAGACGATTTTATGATGGTGATCGTGGTTTCTTTTCAAGGTTTGGTGGACGAATAATGAAAAAATCACAATTTAACGTTTCATATTCATCACAATCCGAAATCGAGATGGAGAGAAAGTTTGACTAAACTTTGTTACAGTATTTTTGAAGGCAATCAACCTGGAACTTTGGATTTCATCAAGTAAACACCATATTTAGCGAAAATGCAAGCTAACTGCGAACCTAACAAGGTAACTCTTTTTCGATTTCAAAATATGGTCAGTAGCAATATGTTAAGTGATCCATTTTGGAGGGGTGGGGATTTGTTCAATGAATGAGGCAATAAACCACCGCAACCTCTGTAATTGACGAGAAACTTGTATAAGGTCATCAAAAGAATAGATGAACATAAAGATTGAATACGGCTGGGTGAGGTTAATTCAGATTTCCCAAATTATGTAGATGAACAAGATGGTAAGTTTATTGATAGGTAAAAATCAAGAGAGGGTAATAAAGAAGAAAGAATAATCAAAAGATAGAGCATGCAAACATTACATGGTAGTATTGTTATAGGCGGTATATTGGTAAATGACGATCCTTGACTTAGTTTTTTACATCGAACGGTTGCAAATCCTAGCATACTTGATATTAATAGTAGATACTGAAATATATCTGAGTATATCAAGGGAATCGAGATGTAACAATAAGTCGAGGAAATTAAGGTCAATTTAGTGCTTATCATAGAAATAACTACTTAAGCCCTTAACGAACTAACTCAAATTAACGAGGTAGAGGTTATTCTGAATTGTACGAACGTAGTCGAAGTTTGTTACCCAAGGGTAAAGCCAAAACAAAACGATTTGACAAGAGAATCTATTCCATGTAGTAGTGCGTTTGTACGACGTTCTATTCGATGTAAATCATTAGGACGAGGGTTTGAAGCAACTCGGAAAGATGGTCGGTTAGAATTTAAAGTACTGAACGGAATTAACCGAAGTTGGCTACTACCTAATAGTCTTTGCTTAGGATTTAGTAGTTCGCAATTGGGTCAAAGTGGTCGCTTTGGTCGTCGACGTCAAGACTCAACAAGTCATTTACCGCTGTACGAACCATCCTCATTTAACAGGTTCTCAACCAAATAGCGGTAGGAGTAGAAAGCACTTACCATCGTACGAACTTTGACAACGAAAGGTTCAAAGGTAACCAAGGCGTAGTAGTGAGTTAGGTCAATGTATAAAAACTCCTTTCTTATTTTGAGTCGTCAATGTAGTCGAGAAAGTATGCACTTAGTGCCATTATTATTAGACCAAGATAGTCCGTTCTTTAGTCGAAGTTCTTGTTGTAATAACAAAAGTAGAGCAGATTACGATCCGAAATTTCATGGACACAGATATTTGAGAATCAACATTTGATTCGTTTGACGTATTTATGTTGATTCGGTTAGCGAGAGTTACAAAGTTAGTATAGAGAAAGAGGAAATAATCAATCAAAAGATTAAGCATGCAAACATTAAGAGGACACATATGTATTGGTGGCATTTGCGTTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTTCTGCGTTGATACCACTGCTT
  +
  W~e]henC~hbp\H~\_MZcRcnOE=~~~pCucWd6hVbkK~7TIdMhheZEHEG_mFcpeU`4Y3zRA~fW6xcd]lMX~[YY_H8>J]>ch>~sZ=VIXPm\EkZFjwcmcaR`JI`WfV_nFdTt-cu_[c/c_^epUn__`~OI~\ep]KjeA~`P~PLc;NW;,%VdOX0>3eJk9ZLbR\gYIBI6BbheL~~~[>ne`~Md?X_n)rmWcheh[Z=UHNYVMJC(B`cWddR9~\@~~oX~'$$zBn]e[g>oKmhLcBPQ/vPlMVB`VU~7|ZQ\fM~O;AH\+LL_~ELL~emIUCzXCw_\eV[F~nM1w_sA~f\i]^-`[\_2~bUc3~f_'Ta2]]a5}HQXVu]Mc6b~Sd_0xaUcglgYnR=VYq\QwF~jF1/MM~nQUcnCud;cSRl:XO1f0z[OfQ~_8nmYUeiFk]pK~nK^LycoeSMCL[idhZMRsd<~lLHzJ~]R~lXL~>~oOJm:97jbcE6i`GR]CLNf0]TH{aE6jcO~~p_[@[D~dPYHYEe?~T9HiUK6t]6~~dY~eTg~Q~_N~Wd\=~~~bEL~Cai/z7P<MS3VFb[6CKHIbC_A@m[QEEnN);lNRYAp<&cRO?mE,_\XE?X\HYWsZLuZUIrcKj;mroE]SrUMB8Uo\RKVH9W^+XJqSEPY<6G5-5;PVQBUHPaEW8*QRYHZMqoBXT=n`P6K>j[BHIQTU7ntiVQZ\cLtcXCGQZ\En(n@:4ksO=0[/WJsnHqa:Q1EQ7].:kPR$klllaaQCPL]-ppLd6N.ppQPAZQPOE_=;/*LJ0S?/X:77W\ZZ[7MYMPE-WRT>sqY\R^<K1-<n[A@oM.VGb[&^JRWN+j8oQ9jN=.Q2[`FO*WRGMfFt\LsrP.YLKLW]6[a>9,kZc[:dOSXPU&9Q)+UR-aYOV@\RcZSZ=d$DINrR>qGeG=mR`<3eKUeSZ\MsrM8ruo\P^HX^K<M4YSR,ha\cZId>qYcZWDAoY;rroKsE?sus]=eYQD9gOYWsS@_FR=6OXZ4LK:PX+Q@8C6:VYSJ[Dv`S\ZYAXJ3ZTSNQX.PQNBqYcVQ+m/>:R\cR0piVYOta6'-VZKrOY^+KEDZEsY@bHZSLtPG?bPGVEKsBqNtRPPVS\<t^1wTEp[QPC`WHPW-DWHq,5_M\a8mK:X6%dqMEpW?TYHnQ.jK43`QA[BZR/Cqta;lS,TXS;lYGttZ@ucMqHN=cJdZ\aEX[XQF_T<:_O<XL]VPVWLrc\YYPJhRRsYM83i<KraEa\WsGwc8vsYZX6MDHDfC=8NN@nZY%nR8EFNNCaSZMl<GqQnOR?q^UFec\ZS\\POMKKSAZPP>fO\Z[[YUQ0H&*)]f^W]YGMXX[TT[aO?PK[Cmb.TYSZ\XFaZ^8T</PZ@Z@DQXS7m)o\Vs+@8oaP'OFQk9YaBRQoI`RVQ\W=XW[7M<ZPNB]3YT?bcWsAC)W?lRYCdMXR8rrVs)XSZ\BvVEXS&jTrEIpROX?X<oA`ISYOtLOOHYcSZLSY;sZ<GmL%oA=g2tm3(YFBDj2rrbR&jhTSZ\>RlZ\SNtTLA7jaRZ@Us3h\cZc\ZaEXQ;;O<qoXLFQS@QX;f7Q(6eRVS4SG<tpbSZ;&F@YX;RKAntNssXL[XR>qR`<Kr<ujXF^HX^SIoOlKL1Z<s@'dNXc\ScVFTNBSE]Pn>U'NTJqRBpJhKHSPHZCpXB]W[SLB-dbYSVsCCDZ.pp[TQ\WC`<V:<MMgDttcP+KUXcKsC&NR>\gLt`<XcSZ\STUR=dO)9)5:hN=pWGOW*.QZFwZScZaG<T)4Ch\\3W5H3;0_:SLUJ^SrScR8e?M+=@aUO8?8D\DmFWc[Z@r]SRPQVsFFvZZ'V[Z<U=ZP'oFBZMKkLQ8oqLtImN8jqGucLi5b?aEmLPU[Z[\X\R[YWrYJZ]<<pWO_EX)qrrXS_'oKosSVrE7QJgX[SUSZcSF[=?[PWE8W\X4_7KHZUMERDApDOZ;7>F=SGMSU;jNZ\3O>nSRENDaFuTOlP%pc-PTSWF]ZSrORUXBqYcMrH(B>?pm[N?CWEXS[ZVOo\Q;*Y43U29M;_TR\\Ho\SVOZZ\_S,RNWEX*b]NJRJL-npXXHmLR/rTR.,)=S>or[cZWsTPM3SLtKtZBPBZZ\W.oSN6QQX=RXYX%CXW/N,FPOUDP*nfa<XL(Dj/5-QCSY\O]@nUOZJU;;gVP@Hp?dO?6oZSWOE`FaZ]7PpCbFGN8ZMsnBPBPe$`X`kqrrrrrrrrqncZTU]hpn`F0&%BTUY<8B9cZSXBpR=ME6iERbUOaq
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/1999/ccs/rev np:i:5 rq:f:0.993087
  AAGCAGTGGTATCAACGCAGAGTACGGGGTAAACGAACATCCAACAGTATGTACAATCGTATGAGAAGGACAAATCTGAAGACGATATTAGAGGGAGTCCAACAAGTTTGTGATGATTCACGTAAGGAAATCGAAATGTAAGATTATTCGTCAATGGAGGTATAAGACAACACACCAAGTAATTATACGCGACGAGTTTTCATGTGACGATCCCTGAGACTATATCATACAAAATTGACCCAAATAATAAACTCGTTCCAATAGTTGAAGTGTTGATTAACACATTGAGACAAGTTGTCCGTACTTTAATCATCAAAGTTTTGGACTGACCTATAAATGAAATATTCGCGTTGTCTCAGTTTAAGAAGTGATATTATTTCGGTTTCAAGCCTATGTGGAGAGATACAGGAAATAGGTAAACTATAACTAATATAAATATACGCAGACGAAGCCTGTTAACTTTACCAAATCCAAATAGCGGGAGACACTAAACTTACAAGGAAATGTACGGTAAGACAGGGAAACAGGGGTTTGAAGTTTGGAGGTACAAAATCTTAATCCTTCACAACTGAATCAACATTTACATTCGGTTACGTTCGGGGTTTGTAGTAGTAATTGTTGAGTAATTTTAATTGCACTTACAGACGTGGATTTGGTGAAACATTATGTGGTAGATTCATATTTCCGAATCTTAATAGACGATTTTATGATGGTGATCGTGGTTTCTTTTCAAGGTTGGTGGACGAAAATGAAAAAATCACAATTTAACGTTTCATATTCATCACAATCCGAAATCGAGATGGAGAGAAAGTTGACTAAACTTTGTTACAGTATTTTGAAGGCAATCAACCTGGAACTTTGGATTTCATCAAGTAAACACCCATATTTAGCGAAAATGCAAGCTAACTGCGAACTAACAAGGTAACTCTTTTTCGATTCAAAATATGGTCAGTAGCAATATGTAAGTGATCCATTTTGGAGGGGTGGGGATTGTTCAATGAATGAGGCAATAAACCACCGCAACCTCTGTAATGACGAGAAACTTGTATAAGGTCATCAAAAAGAATAGATGAACATAAAGATTGAATACGGCTGGGTGAGGTTAATTCAGATTTCCCAAATTATGTAGATGAAAAGATGGTAAGTTTATTGATAGGTAAAAAATCAAGAGAGGGTAATAAAGAAGAAAGAATAATCAAAAGATAGAGCATGCAAACATTACATGGTAGTATTGTTATAGGCGGTATATTGGTAAATGACGATCCTTGACTTAGTTTTTTACATCGAACGGTTGCAAATCCTAGCATACTTGATATTAATAGTAGATACTGAATAATATCTGAGTATATCAAGGGAAATCGAGATGTAACAATAAGTCGAGGAAATTAAGGTCAATTTAGTGCTGTATCATAGAAATAACTACTTAAGCCCTTAACGAACTAACTCAAATTAACGAGGTAGAGGTTATTCTGAATTGTACGAACGTAGTCGAAGTTGTTACCAAGGGTAAAGCCAAAACAAAACGATTTGACAAGAGAATCTATTCCATGTAGTAGTGCGTTTGTACGACGTTCTATTCGATGTAAATCAGTTAGGACGAGGGTTTGAAGCAACTCGGAAAGATGGTCGGTTAGAATTTAAAAGTACTGAACGGAATTAACGAAGTTGGCTACTACCTAATAGTCTTTGCTTAGGATTAGTAGTTCGCAATGGGTCAAAGTGGTCGCTTTGGTCGGTCGACGTCAAGACTCAACAAGTCATTTACCGCTGTACGAACCATCTCATTTAACAGGTTCTCAACCAAATAGCGGTAGGAGTAGAAAGCACTTACCATCGTACGAACTTTGACAACGAAAGGTTCAAAGGTAACCAAGGCGTAGTAGTGAGTTAGGTCAATGTATAAAAACTCCCTTTCTTATTTTGAGTCGTCAATGTAGTCGAGAAAGTATGCACTTAGTGCCATTATTATAGACAAGATAGTCCGTTCTTTAGTCGAAGTTCTTGTTGTAATAACAAAAGTAGAGCAGATTACGATCCGAAATTTCATGGACACAGATATTTGAGATCAACATTTGATTCGTTGACGTATTTATGTTTGATTCGGTTAGCGAGAGTTACAAAGTTAGTAATAGAAAGAAAGAGGAAATAATAATCAAAAGATTAAGCATGCAAACATTAAGAGGACACATATGTATTGGTGGCATTTGCCGTTAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  <aOGW[]-lfnQd`~MXFEP^Ygj_:~|_aF^Z`X8ycj_U~KrM[Zfi`FahEAaNZ>GA;;>S%m)]adCyoQa:[a~]pcFcVl=no]m&|h8MhQ~X~`Z~S5cXIdEfJBj6uKne\RL~NrDz`g`U8xuQ[h]rT5MagAfJEdM[tg>~f?|hnQS|Wg^M~dcHiOyX~]gL~2i`hlLDc\pe[OR1XgwdnKP%Bme]nJI~~bT:VneaLeohephp_0[byX~]pEsWD{~e`}bC{~Lfe]KgC~a~hp[$DFNvJY@'CGdBEH_^peoG~XiYc\0YDLcAbR~[;md0qh\gddf&`G~yX5pSnN}SKg]pU~hhRE~qR[J~~feImdZ`\@J[ca&apX8[F=uY:GQ;YUQl5nd1jJ7EFAZzeb~WP|c:_EaCg8,ODdKi5kO~2~shp:\:2xsQGmhZaZZGb\TQDnuhphjcG[nFkMZL~EO}\/6qIg]@~~oQ}Q|lRQ~GZyfk\e*~rhSjepec@\f\GuQG5Q)WEqQXZGT`(]ea~\j^m1bl5lc`e(spK3~j[GY(BJiIi;KxL_eM~~vKJ>aL~QN~X~eibKz[=QJ`*TM}do6ocTboG~dLl3^QGDI}_?~~w2{`VJ]ENT4I`}LhF2QXQ/LL~1b[na~5j]epd5qkcO,h`S_L~n2|d>mbT&t~]mKneaZ(>[ATUS-Zbp]XO~~R~]a~`=8D_~Qk3gd\W(|x[POKQ6DWIZiQd\P9~Eb`d4f~tcRk6`%zBDZ7f<NV/q~pdC)o~~~iOF]MOu5nbP~d]D~~ei]4J~epfMneb~hT}CR~~QOEVZk6GnOBLCDlnZ%|YX_L4ln`E}wYD~ncUX;l;~|O/L~M~dLe9UKbNa];zUZVL~j8za8j~bU]>VbZhGtc^n5Ypnhg+32]\cF1~~j7YdM~\ei]adiXG<I;b1:PcMY@gPCZ\gd2~~ug_Pe*7'/_>D-'F7ZGAQG_ODbI}]M>S%QZBPYT[Mgp/~kC7~_+bm}d,|uB)'CBD`TR6XQVV[Kk/o`Rl78~{OfpRpEI6hPxOcf\PH3&>kMW_7<wed4RDLbGM~O|hepg`9rgkF0]~P^NBN[\lMmgD~~ZW<e\a~fUaJm_d;~vbFl;pFpP^.eFgUUF[kK~~H~lGwYQWag@mhZ1`Q;G<EJnhY~\/~_TLqZQUpKd`8j^z~hQbGd[UZi)}p`Oq`F~~ZN{]V~~]V~hY~c^1`nWQZSRWlYcjN@\5u`ciE`lKQI&W]NZhpP~DAj<JP>s\>[E_ON3wMlcPk~QJfe]phS~?j[hGE~oV:XWh|~mNfhe]]~]=jKbDcH~~h=J6BD^`hocDuVU_oIxU_hp]bSOXPn_ZT'g]*MOh^_PGbJJbAH?cb~E~Z0~pcbBdWK8YbI~]`~PZ_ZBa+fJz;a_4`Pw:paPC]?~kkL_,DY%cnQY0FPZ1js\6<afOZEqG~\K~~PlJ~LZ9~bQ\~^heE~}4\M~`,G9~fp[VAdG~n/o[e\P~6OI7EcD4~]U\3BRMW]aX%xDAm>BbJu:FO90qbX=]1h}h`@~~j_Fl1~~ZVcTpGh\J~fdPmCBPaoXZRRB8dPM8S+2GbSbp`Vm`T5V[MEE~JCQMHQAugbcj*3_SL~pcFi'oo3ml\b~]eZ~eheM~:~QDOMC8N[KmE~UYL~:~{7nph[SZbQXDUbNh<~W~`~MZM~\X~L~KKS@fpRh<_~hp]MSA~vZ63~l9fk$|RZRmHEl^UW94'CrnhdF~lRO;iQa?F<~xFjJ['PObFg^\ce`|[c>fLL~cNk6`Jm']gg<eDM_TNRaFL~T~f?bgdkEggWzepK~6tdheb~Q~G~rQj/I>tfpM~iEJME7<u[aicF{UT~pc]Ycpe]V~d7~B0k`Z~]FE~bAmHed5~QGibF{O~Lj:|]\QSY8QEdYg^X~pMuNKM~e@XUd9SQt~ch=~hHdee:]M1p~bVTYheVI]Ird\hp]heYSG7~tB[ObFaUcX~p]^\3dbDjU5YR7Y]]dS~WnQmLbM~V@~[@~~p]he]a~^F~eMgDD{\hY~_[^b0~mODLo[SDcp[VTcpe]ph&FF?]T&+NSP\FxaB`ZcSc\`@^lRbQHVO;MXa)og;`OtZTNtR]O;RF)noa\S)qWScOtX4p;1BHZScS]MMt[ZHUgL?j`POI@QYR>ppR=niOWFr<rrY1[UE^E@)RipRTMtKoRVGRPQ/PSWH@qElR\FwbWHW[PbU0U\OrFuG4aWH<r[H.[SMS$a@2MjqqqqqqqqqqqqqqqqqqjZUVR\]OWS\SZR>qOZ\cGw]OEQNEW
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2012/ccs/fwd np:i:6 rq:f:0.993399
  AAGCAGTGGTATCAACGCAGAGTACGGGGCTTGTCCGCGAGTGTCACCGGGTTTTACAAAGGAGAACTTCCAAACATCAAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTGTGAGGCGCAAGGTACATGCTCTTACCCCACTCTCAGCACGTAGGGAGCGGAGTGTGGAAGACAACAAGCCCGTCGCCTCTACCAAATACAGCTATCCTGAGGTGCCAGGTTAGAATAGGCCCTACCACATCTAAGCCTTGAAACGGTCTGTTCCTCGTGTCAAGTTCTTGTCCGCTTATACCGCCATCTCTCGTTGTGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTGCCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTCGACAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGAACGTCGTCGCTGTCACCTCTCGGAACACTACTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCAAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCTTTTGGGTCTAGATACGGACTATACTCAAAACCCACAGACCTTCCACTTGGAGTTGTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGTTCCCTACAGACTCTCCTTAGTAGCCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  RqXQ[V^Kp\B\Q@jPUODVDU\EP2qq`QKqX\2oWQWDW\@Z8-CnCpl6op]F?/6OGo[W=nPRp?V1OTNBWO2BP^X\E\Cpp[^W9oh:DmlMD1BXpj[X[X[QKp[X[P>n][X^X^Kp^Q[QX]I7I?gp[Fp@pX[^'m[Y^[DZPNnQNqQ[XNqKp^X^TPEdQXNKQHn^[OE\XNEOQnF/chf[Q\Q\Q[XOEPX^Y2mmZXQ1e[X^X\7lNpXV&+`9<\X:jUXY$DCq^QZ[Ds<pp^[Q[V;\[^EoXOCJm^V@X.JoRp[W9lSWKp<ss\F4a[Q[^Q^ApXDsQp=?[kQHs^QZ?:l4P?NX^X\:9X<Oh8)j?Z2nU9=mZ^Y2oV6pXWLSQ]QXQp@\Kp\B:MlX[U=m6k=nTQ^Q^Q[X^2tgZ?n=qm?T<OLE\Q[Q^TFVMm@[Z\PJ[XDs^[X^Kp]@YQp[W=nGr^QMf8-XKp[VDYKp^X)onZUGl]X\@\Q1e[CqnQR-7[XCn9h:V9plSDlpGm,lC<P[^Q=iQ[N+lX]ZKPX^X^B\DV^O4nV0peDPf^Ds^NpOWTFEbPh.Jo,o^W3oEPZ2PDW[/O\7QhLFS3V\XKrX][]XBTTDROT'aopp^ZQHlQXU7KQU<+eb\3gZ+k\1se0aX^8qqXAX^Q[Q&YB]$jje:YX^[\EPXQ[KpZ>6YXQ^W[^X^X[^Ds^LQM^[Q^[X^QRpQ^Q^X[Hp@]BUW^X[XX^Kp[^[X^;qqqaEDr^XUN^N.X/O^[Cpp]=nPRpQRoZ]Z[I_^XZPXENEP]Ds[/4fX]TO/'Zmmm^[QHs^[VZ<[X^Brm&l`KQ^[>tsZ.V^XAoU.\VKp]=nW[XNq^VEO]X*WQ[L`D4^\X^+]V@LR;iGs]VJ]P]PYW:lPNmQ\EP]Q^QZPY^[QKn5jUIh,pKBpoDCpJiE_TO)lkGaFP)oo`[Q^X[QYM^XQ[X[QVE\XNq^[]NDU=mBe+`Yf[f/XJ]fA<XcGH_]JtW[BO6bV;S@YVC`gAmJdKwtK~e>bC~bfZCytqb\>EgS`K5Jh:~{_TYgJCiPQ;OFQa4{QbebZKVSvi*pYU)olcalVOC.XUDIDZ@Fv.MFg\?qsuqVnQPZ9|p'fHIPni^zDPcBBG+lF\bH]D|KPzaW?u;~{_W^Km(VT_O[<]CaVp_o`I:eICKVLw-MD^YfE+[`lJ{]IoMCi'Yci[X`?cMk\gDkOq_YkkIeA`SNk1gifPES4srTZBg^FcKBLX6VGmd.:aJoE1k]KbMiV_=~r>^[\Mn/YO8P=4jZT9njLZGJ5>UL}Y2.;B5Q.H.BaUIbd)Td;j5SGJ]?~\RJ]HDEm'GlIc;wvamZ~fmYb`P_:g^7W{Id<AO^UQ^~Fpe:hU=G8^{f:fU^[X3Z[WK@p=JI\OCYV/bTLNXiJU];p&d@3`-9U0hh_*P^EG3SL:PYB?iG3Vb_[NGU/wkW/9MLBWWS?.%h:W?D?rDtT@J^a'qt`>\G@LV?QH`WPOM?FWK:klm+D{HRBcMD4IBW0]a<QGQ1@f+Y6CKGaF]YE6QH]HeMOWT^/&MO4F6LMRUJ-^RAIk>EVNKRPX[QYA\TIY3VTKP]WUPVMZRV0YNA-k7@;eUH?$afkmnnnnnnkaWQS[`[SQRQWclmdQM^[OSPWAPXMaTDRV4h[QZAPMo
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2012/ccs/rev np:i:5 rq:f:0.99375
  AAGCAGTGGTATCAACGCAGAGTACGGGGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTGTGAGGCGCAAGGTACATGCTCTTACCCCACTCTCAGCACGTAGGGAGCGGAGTGTGGAAGACCAACAAGCCCGTCGCCTCTACCAAATACAGCTATCCTGAGGTGCCAGGTTAGAATAGGCCCTACCACATCTAAGCCTTTGAAACGGTCTGTTCCTCGTGTCAAGTTCTTTGTCCGCTTATACCGCCATCTCTCGTTGTGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTGCCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  /YKA\QNEhUXLWKgWO?CLPO3ER$oooWXLW&VGRMT6CHLOBVKnKo>sT2nokSWEn]/OL?0TP(nOJn=nTA*>Z:XO.[Y.fSHLC/v|aC~~bj>~r^rjZjZjb;aXAMKX~gjZdZPB@&_jcZgjch0||hK~YsXjgE~~~~eH~aG~JH~`QXRh>>'VQYjK~cZcX~HkcjchaE_7`QDc)|||hRdbcKhZbCVY:f3~~]Fa=~P>B<-0uY}A_BnJsaH~YJ~~[TcZP~_bPgB~H~iIKE4RLdhaSigZc)zaDR~i<zEEeZYj%eK~9axgiR~P_Pdcg\~ZS~$wXY2~VH6^R][WJwS~PbZfYOJZ~ZJx^$NPUK?_SWEzgNhS~ZS~jfce`NbZF~YfHjRh^W{ZZXF}J~X~jcfbPbjYR@bWTD^:~~AqcjY<eLhbdZjZGhYfiPe<E<?|Ph[fM~g^^F~gDH}I`^X\~cdI;|hZggHffZ0xoe5cWVeW`bM~jD~~chDQ}~>q[~KXG~gEDmb:~&icbYPaa2~pcjb9\Y@JXJEULWS~dEbLCxe8}s2cbJP|SRfZcDJR~L~jHjAtqT<ZhciF~hW=hbOB~~biUO]eYDgBHd4c9ZFXIbV@~~~~jbF~`DhgcgVJ${|dMrPG~eK~u8gXP?~~rR~gcjbbfS~-n`smcjZfg:gcZchKb8fcjZbNXjeX`ZjdP~gcb\gicTiZfbEaaPbfWQ@s\~S~iPYjWcbKhjgjZf)~{gjjS~gWMVgcMPhcg^.WsNG~bL|bBWdKeMKwNDgaQ`JhbO?|ejS~ZLJA^3bFf~~jcLxMTGKaeZe'hhCiVObfjJ~~gjYeWW{Y3f`@kfRoEdZ\~gZgcLZH~bjK~jS~fYNhYQa[G~@fPOagcgciYC~`4|adO_`YNbjciPh`:hQ~o9x/yp?czcEqHrJ~OJ5~M=oi^Ky~jceDhbe`QXNPWjcXLcZPlN2ZJ8W\~S~Gdbjcee]effcH~|ZLMYV~bDOX8gZjRqeae^KaEjIN@~~S~P>uSwW`LAx~vZjcV~Kdcfjg@PQfjY<jDnA[;hPPWCceFbAejcK~fFzcd'{c9SJaPbhDLWgcZH~bZ4qb'~~|84\@FxNcUB}~bjTIHdOL~g4?Q|edZjgZ~cZ~ZPAqH~~cZg@~jcVJNEacZcgZgcjS~P_9`K~\~aPagj[cgVG:eQG~bEh'~~~kKgF}EeEcJ|IKWYDKHnfcjQl+kQbWQY1plb^=OX^MS>BU3`ORQ3`BrUsa3eeTq0N<29`qTVY]1eIl]>]\%^lV6d_9hbG^QD%hLKH%;EScG_`Lb^;mVScc@YAkA4QCVC;8dH;BaX6\7Z$cc[KJdOXg`6Wa5GSJBwWnNXjcI`'d+_R<p\On?dVN@eKILC,>6P<UX=~KVKBgI;eu]^8ePZTIgLoUYmZ;mc2n~SC~|IFSjXgOhb=wcbKP\hY6_0ub^U9P[SXaBb?c6l@fb`D}BoiPJP22OgffI~].bM;yZVZ[+F46Z=&4,;SVDgWb3RE`GP@b7l[KU;R@\@cBRfRRQeM_VcZIKpAq^PE\QXVGl[RpQ[.UQ[WNKP=n\X\@J@T;[X^NoP>nG^J^V[Q^W?XXNS@mSNKXZXGqpQP$nnnnnnnnnnni^UQPSZemnnnnnnl=77SV?K[PAO@iPWH\7l\XY;-6t
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2091/ccs/fwd np:i:12 rq:f:0.998786
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCTAAAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACTGTATTTGGTAGAGGCGACGGGCTTGTTGGTCTTCCACACTCCGCTCCCTACGTGCTGAGAGTGGGGTAAGAGCATGTACCTTGCGCCTCACACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  ~~~~~~~x~~~~~i~~~~~~~~~~~'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~l~~~~~~~~w~~~~~}~~{~~~|~~\~~G~~~~~~~~~~~~~~~~p~~~~~~~~~~_~~~t~~q~m~}~~~~~~~~~~~`~~{~V~y~~~T~~}~k~~uS~~{X~~?~~~/~a~{~~~~~/~~~d~j~~]~~~~}~~~w~~~~~u~m~o~~~~~~a~~i~~~~~G~~~~Z~~L~~~~~~~~~~P~~K~~~Q~~|~~~L~~~~~al~~~M~~wn]~u~n~~~~~~~~~~~w[~~C~~y~~~~~L~p~~y~u~~z~j~~~~|~~~~~~~~~~~c~~~l~~~~~~~~n~mtn~g~~n~m~~~~h~~w~~g~~S~~~~~yj~~~~~~`~i~~av~~~~~~~~f~~~u~q~~d~X~~~c~~~~~j~d~~~su~M~~~~~~O~~~T~~~~L~~~~T~~~~m~jis~~~W~~}z~9~~~K~~~~~~~f~~]~~p~~~~~~~~~~v~~~x~~~~~~~~~~~~~~~~~~t~~w~w~~M~~~~~z~~~~~~~u~~~~~~~~~~~~~t~~~~~~~~~~~~~~~~~w~~~}~~~{~s~~y~~x~~~~r~~~`~~S~zs~~(~~~~~~~~~~~~b~^~~~~j~~e~~x~~~b~f~~~~~~~~~w~~~~~S~~~~~~{~g~~~~~r4l~~~~~m~~~~~~~~~o~c~~w~R~{q~~R~~b~a~~~~~c~~~~~y~~L~~[~~~~~~b~xLwv~~~u~q~~~n~~~~~p~q~~X~]~~~n~~~~~~f~p~~nu~'~~~W~~ua~g~S~~r~~c]~~r~~F~~k~~~~~~~~~~eX~~~~~~~~]~~o~~H~~~~~~n~~~~X~~~y~q~~t~~~~p~~_~~~~k~~g~^~~~~~o~_~l~~&~~p~~~`~~~~~~~~oj~~p~~U~~~~~~~w~I~~4~~~~~~~~~~~a~mk~s~ev~e~m_`~o~~~~~0~~~~~gr~q~Eu~Wr~*~~t~ry~e~m~l~w~R~u~~~~q~d~e~~~~L~~~V~~|~U~~~~~~~rk^o~~k~~kN~~~~~~\ze~mU~~~pu~Me~~~~~~~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2091/ccs/rev np:i:12 rq:f:0.999211
  AGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCTAAAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACTGTATTTGGTAGAGGCGACGGGCTTGTTGGTCTTCCACACTCCGCTCCCTACGTGCTGAGAGTGGGGTAAGAGCATGTACCTTGCGCCTCACACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCCCGTACTCTGCGTTGATACCACTGCTTT
  +
  fp~~~}b~~~~~~~~~~~u~t~~~'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~T~~f~~~~xs~~~~~~jr~~f~~m~~~~~~~q~vV~~q~vwY~~~~t~~p~~~\~~Z~y~~~~~~~~m~~~~~~aw}w~F~~s~x~~~~~L~~n~S~~X|~~~~~~X~~~~~~~x~]~~~[~q~~zw~~O~~~iZ~~~~~~~m~U~v~c~~~hl~<~~S~~~~s~p~~v~n~l~j~~~~~~_~n~~l~~~[~~~x~~n~]~~t~k~~~{~~~~~~~~~~~~N~~s~m~~~~~~A~~l~~n~~R~~~~~~]~~x~~~~~~~~e~_~_~t~t~(~~~~~~~sP~~~~~~~t~~~yh~W~~r~~XeK~~N~~o~~~~~~S~~~~~~z~=~~~L~~]~~~x~k~~~~~r~~k~z~w~o~~~u~~~[~r~n~~^~~~~~}i~~~b~~{~L~~~~`~~g~l~~m_~~~~~~~C~~~~~Y~~~q;~~\~~q~~~~^~~~~~~\~~~}~~~X~~l~u~s~~~~~~~r~n~~~nS~~Z~~~~~~q~~~~~~p~~~~~~~~~c~q~n~~~~~~o|~`~~~~s~~~~o~[~~~~~~]p~~~~icv~m~wUfm~~~~~~~K~~~~c~~~~~~~]~T~~~~~u~7~~~x~~Z~~f~~~~~~~~~n~~s~2~~~~}~~~~T~Y~~~~_~~~X~~~t`~~~~h~~~~~yi5H~~y~~s~~c~\~~~~~s~~`~~Q~~R~~[~~~~~~K~~m~~~~~~~o~rzJ5p~~~nX~~i~[~~~g~~~~`~p~]~~~~rl~~~o~E~~~~~V~~Q~~~~~~~r~U~~a~~~~~[~~q~~>~~~L~dM~p~~~d~Y~~~~~~]~~~~b~~_~~c`a~~~~{~J~>eI~~~~~~o~~~~~~h~~~w~_H~~~~~~f~p~~~dV~~n~qb~~C~~~~~~~u~~~xp~~~~~~~~~t~/~~U~~d~l~~~~~e~ry~~~~1~nfcySC~~na~~~~~^~~~{~~~~r~~z~p~P~|~{X~cag~M~~}z5~~~L~zJ~S~i~~~~KYzxg~~m~~^M~~NIr~k]~~~~~b~{~~~k~~~~rq'~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2097/ccs/fwd np:i:5 rq:f:0.995215
  AAGCAGTGGTATCAACGCAGAGTACGGGGGGACCGAAGCATACTGCAAGACTTGTAGGCCCATGAATTACCCGCTTAGGCAATGGGTAGACCTTTCCTTGCCGCGTGGAACAAACCGCCATGAGTGTTTTACGTTTACGGTCGGCGACCGGAGTCACAGCGCGACCAACGGGGCCAGGCAAAGGCCCATAGGCTTTTCCATCGGCACGCGACCGATTCCATCAAGTGTTAGGTGCAATCCCCATTCGGGACGGACACGCGAGAGCGTTAGTCGGCGCGTGCGCGGGACTATTTAGCGAAGGTCGCCGATCGTTTGCCCGTAAAACTAACTGGCAAAAGCCTAAGTGCTGTTTCGGGTGCAATGGTATAACTTCCCACATTTAGCCGAATAGCGCCAACAGCGTTATTATTTGGAACCAAGCAGTGGGCGATGTCAGCGACAATTCCACTTTGGTAGAGGTCGTTCTTTTGTAGAAAACAATCTAACATAACTATGACACTTTCGGTAAATTCACCACCTTTACCAGGGTCGTAAGTGGTCAAGCCACGCCGACCAACTTCATAAGCATTGGTGGAAATCGCATCGACACAATAAAAGTACACCAACCAGCAGAAAACAGGTACATATACAGTTTAACGACCTGGATCTAAGATGACTACAGTAGCATAGCCATAGAACATGGCACTGAAATATCGATGGGCGTAAAAGTGAACAACGCAGACGATGGATTACGACGCCAAGCCACTATAAATGCTAATTGAGTCGAAGAAGGTACTCCTTTTTGGAACACAGATATTGCAAGAAGCGGGAATGAGGTTGATATTACATCAAGTATCAACAGACGACCTCAGAAGGGTGGTCTTTTAAAATGACAACGTACATTAAGATGCAGACAAACACTACTATGCTGGAGTGTTGTATTAATTCACTCTAGAGTAATGGATCACGGTGCCAGAAACTAAGGTGGTGTAGGACTAGATGCAAGTAACAACGGTCGTACTAAAATCAGCTACGCGATCGCCGACTTAGAAGGCTGAGATGGAGAAACTTGTCTACTGGCAGACCTCACTATCTTTTAGGAAGGTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAAACTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACAACTATATCAAATCGTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCCCGGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTTCTCTACATGTCCTGGTGGAGGGGAGTTTCCTTGTATGGGTGGAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGGCGGTCATATGTGGGTATGACGGGTATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGACATCTCTAGGTCACCTAAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGGTACACGTTAGTGATATAAAAAAGAAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGTGGTAGGTTACATCTATTTACTTCAAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAAACTTGTAAAAGCCGAACATGAACGATGGATAGTAGACCGGGAAGACCAACGTTTTTTCACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATAGGAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  _zVZgT^J~_RdYEsSTBNQ_TNPY*}~}r_b=\GWtVIPQeZgVZUYTPXHcAegH~<r`IeVXxWw;*utSZWzgH~ZXxg>~~gfULFY3ZN<aHvVMwVZWgJsGkDKYoKwVJwReVgT5S/owweY@?nSQY8yMD5xCTP9WHtPUeDeZfVZVZQ><fM[S9z~vKwgJ~U-\l6z<tlXaZDd@8pwuFvK`T7a,MYUDUe<wUOEvJwPeYEkAeVTsKB~gVZCZ_0EXa`RWEAn~gY4nSP3NAATfVd@V=TvgVeEBiUSZVgVZVY2z^OTXf9yvdBYVKpJ~c/RK_Vb6XU1vvUDxxVg-zzcZfGW1dJ~[At_]VKwgKxUU?IVR@rwZ0F>Y)COST?eUKQ4_XEv2uuPIeGxygU<uU:YX=VX@9r9iYgWZVWxgWxe1vvCdFvHYFvVIQRb5zsUQ:bOcYPUV<YW2oQrKbbUMWoJz_9VMExgZVWwD1jaeVd;@9ovpTXxgZfFvZ^HO=BKC/RH6K+;;lB6bZGSdBuDdJwcBhOwxfHbP9hWIXVgKd<NIsgZXxU:teXAJuVgJw&BDQxX8X7bVZPTu@hNIs@vvfZVVH>W@aBJ/K\M7E^nReQAZEY7VBO7VXWV.uurHAIvePY`M3M]TbCNug2s>QPIwNG~ggZgKS+cgS$AfcC<U`K*-abgU<wea7O+WP?eH~ZbZa+=Kn>FdDUgfA~|[Q[(]lsL`)RsFLgDTCdVfZUMbFz5SwgZUPWWJwCT?En`U]JaGcoZWZaKuYxVdBeX@EsT9a@qePVaLc2wxwcG~CqTfZfR\N^=oOA(TTXvVY5}sSv^NQBrYwVVV@FR<WUeUKwTIceZJzZfUNDUgKwgYPUF`.{pgJ|bU<wwj9q_qfVgZXxZVggZcEyVxS\OUX\U@JBatZbUgdDegaWUR>{gShUYxVggYxXxUzYeUaXcKSL?KDr`@cggWOW;w]D;ZOU?svZgKoH~e:q_PNb<xbIdNSLO>YWqS`Ak9IvDG}eDAedWHBlY`dT]AY_CCIGKdNW=KuVg[Sy`C=UI|YNUgVggH~fU*XC5HH4S8cIPGIf<FM0BcD7XJNI:U2t[^QJ~OjD{]S>US8\>X:dCeG~PUgVga=^KgaQ]YXXgV,wkcEc@`UWwV3mfFtVKUFS8XV%teggJ~eDWxeedLYoZggIZfV6yaNiLJvVggcHdDTRSTE\`SW:ved@O@KWaEmgZ1nOP9cSggVbZ=r_Vb[@LgACegRBA3\XeS;NbL:qqeUSUV?4P]8o`WVxLu`IvVfYQZc0c<KF:>mYN`DBTd8|egVg.\QRI{cZf[eU8e_ZVU_F|:GzfW^9]8dLH-jg,w[SW@vyuZVg?~~gTPY3y^B}eCR+=emG~HvoJwHxeA~{QIrNYVOxu@oXGp_HVHrygdBLbCGHYfIvN?~~gVXw<~~Z>LRfdZ6yXE_ZePXQcAeKwc&wdJ|f7~r_HH@omHYRVUcPe>~~gIg3g'm_HhAwtU:tBygSM=iiOOQQEvMCJ~eF-aZ,`gZdLNeVg>~w]'NALP<^cINaRPZUL.cgGeVbOSLTR?WVfY0vvva?{~gJ~gJ~XxVd4UXwdZgVggVeDeAwwUcOQbE}N6{dT7tYgGzCND`fYPcT2@cfG~NYgKwgBzw[UNUZU4sTa)_TX?IU`YxgC|[KtDe1tqRtZVg?yc8XgWCyuVfU-@veVA@^YVCqQ9TOUc?NVxVY_NP;ITJ[N8}bY<vt\LZfU_VgVExzgZfWefc7KQ][CNuo;xeGjBSBeZfXxH~ge;~efZdDUWwKReUTWDQ:'@9F;M)[L3J<LEPLC:LNiQKI?XWHeC;f>GB7PWM-i4*G.eBCiZW>O;aBNWZPUO1>%?JIL*'@dW:LO<9,H&RMXCK,[JMHG\MQZ=]6EBOeJR2OcT:H8BL6;dAo[*hUNG=K;2fbOMDV:MfPMHH+dPM[XAo[[WM[[LEAR8PL38L@26,cOM/Z87YbPX;YHN@4b>%>@KJX;YQ[Q[MIY3:BAPM6UV4M:>f?ePAo[NY8YBL<b`DFBC>N[M[BJRQ<Y<7VEM[BJ[OEM[6[OM[QLF?V@62X[MY?LP9:$bggggggbXQT\efaXRMNZaM916OLFE>B8F7OIJOM>W[=G%IIIO[j
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2097/ccs/rev np:i:5 rq:f:0.9915
  AAGCAGTGGTATCAACGCAGAGTACGGGGGGACGAAGCATACTGCAAGACTTGTAGGCCCATGAATTACCCGCTTAGGCAATGGGTAGACCTTTCCTTGCCGCGTGGAACAAACCGCCATGAGTGTTTTACGTTTACGGTCGGCGACCGGAGTCACAGCGCGACCAACGGGGCCAGGCAAAGGCCCATAGGCTTTTCCATCGGCACGCGACCGATTTCCATCAAGTGTTAGGTGCAATCCCCATTCGGGACGGACACGCGAGAGCGTTAGTCGGCGCGTGCGCGGGACTATTTAGCGAAGGTCGCCGATCGTTTGCCCGTAAAACTAACTGGCAAAAGCCTAAGTGCTGTTTTCGGGTGCAATGGTATAACTTCCCACATTTAGCCGAATAGCGCCAACAGCGTTATTATTTGGAACCAAGCAGTGGGCGATGTCAGCGACAATTCCACTTTGGTAGAGGTCGTTCTTTTGTAGAAAACAATCTAACATAACTATGACACTTTCGGTAAATTCACCACCTTTACCAGGGTCGTAAGTTGGTCAAGCCACGCCGACCACTTCATAAGCATTGGTGGAAATCGCATCGACACAATAAAAGTACACCAACCAGCAGAAAACAGGGTACATATACAGTTTAACGACCTGGATCTAAGATGACTACAGTAGCATAGCCATAGAACATGGCACTGAAATATCGATGGGCGTAAAACGTGAACAACGCAGACGATGGATTACGACGCCAAGCCACTATAAATGCTAATTGAGTCGAAGAAGGTACTCCTTTTTGGAACACAGATATTGCAGAAGCGGGGAATGAGGTTGATATTACATCAAGTATCAACAGACGACCTCAGAAGGGTGGTCTTTTAAAATGACAACGTACATTAAGATGCAGACAAACACTACTATGCTGGAGTGTTGTATTAATTCACTCTAGAGTAATGGATCACGGTGCCAGAAACTAAGGTGGTGTAGGACTAGATGCAAGTAACAACGGTCGTACTAAAATCAGCTACGCGATCGCCGACTTAGAAGGCTGAGATGGAGAAACTTGTCTACTGGCAGACCTCACTATCTTTTAGGAAGGTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAAACTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACAACTATATCAAATCGTTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCCGGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTTCTCTACATGTCCTGGGTGGAGGGGAGTTTCCTTGTATGGGTGGAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGGCGGTTCATATGTGGGTATGACGGGTATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAAACTGGCAGGACATCTCTAGGTCACCTAAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATTCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGGTGGTAGGTTACATCTATTTACTTCAAACGCGGTGCCCTAGGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCGCCGAACATGAACGATGGATAGTAGACCGGGAAGACCAACGTTTTTTCACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTTATAGGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  @fNPHMVO]ifUGEj[^EPC_^[SZ:dcprb].UZxZBffX[WL[[}`gPMq_hfJ^5XWP[CTsGrM=~oWFHtf=xVUxPD|qMfXYKn;Zd=U;D08`TFTX<mKnF.RXA]FHuKPC<VQ?1xx^PJO3rc_VLze@8rUZf8|JaYZQShUgWUCO&LG~VuV9uetAfL1jOJV]El)gT[8\7_U2xyTE{ggV<pR`VX@2bCnZg(8F0hfPUYxVKXGwfJ[dEQQWP0dYeNIbC?bZSL*gI?`?V@D_>^X@UStfFWUEbOVKAN2TX=(nudVfa:nueZVWCsGY:R*CaDcSVX3eeY/~bX`2kecS%CuWfJ[U3sy?/7eKSZZgZRI/)Ia\V5vpJTVYxgKwKUfYxLWw?~{aTa?vuMXAoV/,IbETDGx@Q>5T>RImO4fH8iP:tC_&o>K/G]=H)UX>3aMO_VeEUZbOOYQ_3[<RI`oItPa?VH`DVZGER+LjqGP[S=wxqRVfeVaRsReMGwUf`CC_WfV?r\:9nKHxV0nAfI|[0>.OheJ~d$rrIN*]*x=)IFVJUGrCAs^VY5s/bAs^WFtVbRC[.P`FuIv:IwHyqPQRL>eSTKScUPRf=_[dDdcWfBlSXCcdV>cD1wydVf/xUK3Q7aa&^C_N2abFuWXN.E>;gdPUd3uWIJAPB:]VHORGT>ZdOXG~RFXG6cL?[8j-KELB?vwfggVTCM1ulBVe9w^M)FTCAoWFwWZS]/bVZge:ueFv_=WbRZG~FvV+TNTSaOBwwbFLbYxXxYfW_AVUvZBq4UOeRY%v3nvvrIsQc?KTQFRcfMgFUdC0uWU+ou_Wv8WgL{8aVVWbBV_RePTU_WdggVVuVe[fUDe-kgUOXXwAymKHZQH-?8A*KJlK-\AWvVMTfVdTaGvYgeC?aUfU1vtTe;ILTJ[eZVPFmRW^[PYD`XWwAV7tThUfSPeYNXgYxgJwN_Qd<%oRNG|S21]vT8TwGve9ZbC\P)^KTKGXfgVQ:3O`=`B,UT.Y^AUNcS^:mwoPS3>?cL:OR;`1UWH|YbK?_UC>cLxRKCLSXMIsKA8mwVWxYOQV\SM5_?`SM5zeVeAbHATCTmuPC^TW:_LUe?BBkXVKwVgKtIXeD_I;uVPeZeRHTNXJ~gUNA&SE_U,fd=D0RAR.bVZIYfCHJwgV?S:FJGdiURfZVgY;ttXxa9\?2cd@oVYL3OPjeC<2[Y:E5[[T^9Z_:KsfY=G2XbDSV5gWD_XZFvXAdeDbR;qOPa^JdVHxyfVH2ydVXJK,Y9TTaHynJ}YQ19FIJOT/KVPNUfPVVEU:qHFLJ'S\RvDrfVRR1,FzgR>5U+WTIcGHMNWR^JO5dO0~dZV0aB:.(6<btPYgVLx_)scVYAH_\:a0YpCO0^ZAvwbGrPUV:W<&]:rOdVBxx`\R:dS^gVgH~e%]pdZRa1pf^HNUHFQFUiI]VdNUeR6SG|f?YnNKlc:;cweDDyiHuEsXKGbAww^'a3b3y}Up?xrZId6;[VgCya;XgYBp5SMyfI,SH,R$SVbPU?4X<Rb8ce[fW;xbP_OXSWZPQHP@cdebZdUAJ_G;THxxvP.a]YHvP7t>mZf8yIVcWNF;_ZgUc3bdYgZRq<SQ<bWI%URU_%i+bLwNSMcUNESe<xeV`1tc9xkVZeCTBDvGXJCHVZGpXCpV5e]Ex?^GrhDqVZPJ~ggUPX@wwYTZVFvc=RAd$QT6VCa.]YfYa+\(DZ.bZfYH~dEeZV%tcdNUd;TFcF(icRR]Yab\C:WfgV=vl=rJ<`*U@dVfU\+uMK7s9`<Y?=@pBO_Yd:c^0ctxfYRlDm,VgVZeVZHwUGn8snJwZFveZfV2;F3bteb3vrNAoYa,\BbFU_JCacCcrbQ/^?%_c4C?.[MX2{a;^)H;~{fRYxX-\EgEU2ufDdBxuM59.JdWRZ+r[<kV8_3@?XleF2($I==Y@\KXFvUVNdIccb]YReYNFm<Xh*\ZfBaGaSE%tuuurVgWbNUgJ~ZGyP-BqROQfWeDWwBZpYxS4R0SXgHX/:AGZMARS5%V&^\HOK0]S?Q4s\>FL=0eJS^BW:EbEGC`PF.>8N?iOQCHQ5%GIPO,^$[bdd^QE><AFNX]`bcc^VMFB=97:?LXG83I)B?JRA14^CQ<a48@KELI>m
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2126/ccs/fwd np:i:11 rq:f:0.998071
  AAGCAGTGGTATCAACGCAGAGTACGGGAGACCAGTAGTTGGGTCAGAAATTAGACGTGGTTTAGTCTGGTTACCGTGGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAGATAAACAAAGAAGAAACGGTTAATACGATTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTCAACTAGAATCTACGTTTCATACGCGGATTCCACATCCGTTCTTGCAATTAAAGAAACGATGTAGAAAACGCTTTGGTTGGCGACAACTTGGGCGGCAAAATAATTATGGTAGGTAATTGAAGTAGCGTTAAAACGCAAAAAGAAGGAAGCACGGATCACTGCAAAAAGGACTACTCAATAATGGTTTCTAAAGTCATTATGCTGGTGCTCCCTATGGCGGTGGTCAGTACTGTAACTAAAGATGGATTACGGCACTTGTAGAGCACGTATCAGACCCAGCTTTGAAAGAAGGCTGAGTTCGGTTCGGGTTTCACGTAGGCCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGGTTACCATGTAAGAAGCGGTAGACGCCATGGCCTAGTAGGAAGAATGCTTGTTCACGGAGCCGACGAAGTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGAATGCGTACTACGGTCGTCCAAGTTGCAAGAGGTATTAGAGTCATTCGAATAGCTGTGGGAGTGGTATTTATAGCATAATAAGTGTAAAAAACATTCCCAACAGCATATGTGTAGCCAAGAAGCGTTGTGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGATAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGCGTGCTGGTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAGAATGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCATGATTTGGTCGATGCGGCAAATGTTGCTTAGGACTATTCTATGGTCTTGCGTAATTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGTGATTCGCTCTATAGCTGTATCTAATCTGCCAGATTGGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ~~t_~p|K~bytoc~lbnrr~s~sX<~~~nm?~vy~~vTz9z{np~xa~~^~~f~rrp^~I~~~nA\}N~k~~I~u~_~J~~tj~~~dnja}~n~_a~~xj~hJ~s~Zk~~ft}^~~[U~~tN~uE~~pQ~F~V~t~gl5W~m|W~~_S~~RnYuXb~sD~oWWZ~Ul~ftif~h~Td$zdX~dwhn^uzdp~dl=~~Z~]cgnj\~|gq(~|[~vG~_U~ic~qkk~d~3~mPQPwZXlw]`TS2g~~bWcV~~I~e~Z~cYrVu~kW~;~~^H~hC~~~yb~E~}tF{ruKzcx~a~Zq~dqteV=V~8j~~ikUK~~~yirwY~V~iSyjX~|{j|U^ThS~~~~X~~cfRghZg~qB}qF~J~~kuN~~]uA~_~jTjS@J{{kYvDl~wttU~lW~gE~ZRvne~j_Yt5~Xx>~~mvfM~~Y~xR:FQGAd~lw~Yx\j~mny}dCop~9u~~`hX~~Yg~~ht~J~fho~df~gE~b~iB~~N~~e|kn|~Y~@~|~\T~ZMyU~o1Mk4PqeuW{F~v~k]~~m~IeYG=>~~T~~u]vk~hl~hjG~^PiP?mRo~yF~N~\GHu[8F/_SHzypjS~hC~IaX1tI?-m>E=CLf^=dd:W?[~\eW~h~jd}kWm~ijmTZ]w\reQ~B~r;aPdH~~:yJdh~oeWazi{dfG~zWmw7~i~Zammhj~k~U~ov_V~n~Sbj~S~UkT~x~`jufh4rx~\{Q~z~Y~~~Or%UepaNfkiizmy;~~~~~P~h~Dnne~g[oYx{~q[tXy}]O~R~hf~nlpf~ovlfzRkjk~kyG~~~owj~I~nlU^_iduLsUx]~h~F~~~oyEz|~pi~W~`IZ~~n|jh~~vt~\qIy?~:~~~XffE~gYtCYKwxnRdsWij~e~hTB|hW{Z~zW~gkj~d~IxGek~~J~eWkw9|ia~VJc(cWic~sw_bxm~kh~]f~d~`~D~l~fz}YY~jcy~mod~xlW~f{Y~V~Yj~zW~TO~`~Fyfl|ft0~ubh~|mh_vZ~{\mfyTm~mw~l^(aJ~}jSY`@jy;~aKlzU;k[jZPr~6~nit'ppzU~J`~~qY~\~~_~sk`~~`Gw~~q~Tr~]~~tu~|pVZw8Kt~gu\iai?~o`~~]sRj~qw~~R~~\4xTnjUPh[~_inWwpS@vl^2~f\5~~Rej]}[|y^nasvV~xgXK~GoNdmlrOZ:Vwcd~wsvk~ye}uW~a`~T~Gt'Vmw~~~~zlin~~~~~~~~~~~~~~~~ohmg\k?m~aLnUr[~~~L~nRm^n{~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2126/ccs/rev np:i:12 rq:f:0.998078
  AGCAGTGGTATCAACGCAGAGTACGGGAGACCAGTAGTTGGGTCAGAAATTAGACGTGGTTTAGTCTGGTTACCGTGGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAGATAAACAAAGAAGAAACGGTTAATACGATTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTTCAACTAGAATCTACGTTTCATACGCGGATTCCACATCCGTTCTTGCAATTAAAGAAACGATGTAGAAAACGCTTTGGTTGGCGACAACTTGGGCGGCAAAATAATTATGGTAGGTAATTGAAGTAGCGTTAAAACGCAAAAAGAAGGAAGCACGGATCACTGCAAAAAGGACTACTCAATAATGGTTTCTAAAGTCATTATGCTGGTGCTCCCTATGGCGGTGGTCAGTACTGTAACTAAAGATGGATTACGGCACTTGTAGAGCACGTATCAGACCCAGCTTTGAAAGAAGGCTGAGTTCGGTTCGGGTTTCACGTAGGCCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGGTTACCATGTAAGAAGCGGTAGACGCCATGGCCTAGTAGGAAGAATGCTTGTTCACGGAGCCGACGAAGTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGAATGCGTACTACGGTCGTCCAAGTTGCAAGAGGTATTAGAGTCATTCGAATAGCTGTGGGAGTGGTATTTATAGCATAATAAGTGTAAAAAACATTCCCAACAGCATATGTGTAGCCAAGAAGCGTTGTGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGATAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGCGTGCTGGTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAGAATGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCATGATTTGGTCGATGCGGCAAATGTTGCTTAGGACTATTCTATGGTCTTGCGTAATTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGTGATTCGCTCTATAGCTGTATCTAATCTGCCAGATTGGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ohU^hfD~~~~]\~n6p~[K\v~uA}\vWx\~~`t\cd~A~~~p~]V~~S{Wjlfl~Z~_~~klSVgO~K~kN~_~B~O~~lg~~{XgxXS~f~uW~~pl~kC~n]qG~~\y~G~~rC~~YU~WJ~~q=~`i`~unbp~t~^cT~dkB~~~Zp~Lk~~M~g~H*~r_qq~~l~^~voY~~s6~IIge[~zIv~CZ_~~rX~~qXaQ~~o~J~nti]`~a^}_Z~nun~vvP~ra<lwSUy~jVnV,~~yqU7(oyB~|~Tz8a^UF~jRpC~~hA~:L~~~~[~u~x~W~~WQ~~B~d~V`Uo~sm]hX~8{~~Z\@1Nre\kR~Ny`xm`ojGwV~b}a~E]Ep~~|L~gO~\h~dR~~[~~T~X~~p~3~~onIhf~~~pstK~~kx~M~~gzdEQ:A9e=~tFVn`jn~lw/~dkL~{SU~:Ytn~~RL~@{RjsL;Wlr\uorjppnVq_W?~~oad@{uaAuc[S~W~q~[WkE`FP}PuB4~~P~~_~bH~mBsVtCrkf~_c}A:2X^[kZ~mvAwn~Z~aQm|nkP~S*vl~~U~~~q~b~qe~qd\~~X\jgoI~~~I~R~~Gl~]=~Q~n^~lnfO~^n~b~nK~Wk2ZO~ur`~]{~~ZiahYY~6te~`e~oF~}]~cn|Z~~yt]~U~~]eI8LidNv7V~~ZbHSlqho-MNgBDWIh>y=XtICAwgkJtp88jlOuG~4aUjNI7v~k[d{YJ=r^pUz2kNgCX3M\[[e^mP~]N~HUV=%zz~nQWY_~:~}Vyr~ax~~}Xj~I~qlI~>jne~pVm,UanPadpSdIqX~HAJlgjDP8~hofQfmgq:~gABRVh6~~Dh`l[RiKYoa~~tT~|J|RN|uyO~h~[~Sn?x~}qt|g~t^|jhp~c|pu~Lql^gwYm`<>^]HNs46<g?OTd9]JJ?\L-CUUG\)rUSR<DDE:PZBp]WE=R[c`7sYg=7]Q~FtGtMSU\\oSncjnGz~~oa~u|Bh]~pJz~Sq9Xy9~^3dOlb~Kb_QK[~T\P~Zw~skIfmkcc\y]be^<sEXfT~ilM.sq[b?U1[lmdzXlZ=NgyFe`~I~`T~~QYrF}~B=>68hug]~x~f~Y~~Z~|pm}y_sS~v+~~|^q~qfcmfT}Jf_hbpQfK~X~~qX~im[oQ~`~rOkh~\i_~~r^~~7_~lfa~\~T~tg~on[G~}P|e~gnk}KClNbcv~_~d~DnZywij]W~~m|~~V~$~~~~~~~|yy{ztmlmnt|~~zz}rWHGTll}[~VX`_[a~kvmn^~}>~]s@~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2164/ccs/fwd np:i:7 rq:f:0.99559
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGACGCAAATGCCACCAATACATATGTGTCCTCTTAATGTTTGCATGCTTAATTCTTTTGATTATTATTTCCTCTTTCTTTCTATTACTAACTTTGTAACTCTCGCTAACCGAATCAACATAAATACGTCAACGAATCAAATGTTGATCTCAAATATCTGTGTCCATGAAATTTTCGGATCGTAATCTGCTCTACTTTTGTTATTACAACAAGAACTTCGACTAAAGAACGGACTATCTTGTCTAATAATAATGGCACTAAGTGCATACTTTCTCGACTACATTGACGACTCAAAATAAGAAAGGGAGTTTTTATACATTGACCTAACTCACTACTACGCCCTTGGTTACCTTTGAACCTTTCGTTGTCAAAGTTCGTACGATGGTAAGTGCTTTCTTACTCCTACCGCTATTTGGTTGAGAACCTGTTAAATGAGATGGTTCGTACAGCGGTAAATGACTTGTTGAGTCTTGACGTCGACGACCAAAGCGACCACTTTGACCCAATTGCGAACTACTAATCCTAAGCAAAGACTATTAGGTAGTAGCCAACTTCGTTAATTCCGTTCAGTACTTTTAAATTCTAACCGACCATCTTTCCGAGTTGCTTCAAACCCTCGTCCTAATGATTTACATCGAATAGAACGTCGTACAAACGCACTACTACATGGAATAGATTCTCTTGTCAAATCGTTTTGTTTTGGCTTTACCCTTGGTAACAAACTTCGACTACGTTCGTACAATTCAGAATAACCTCTACCCTCGTTAATTTGAGTTAGTTCGTTAAGGGCTTAAGTAGTTATTTCTATGATAAGCACTAAAATTGACCTTAATTTCCTCGACTTATTGTTACATCTCGATTTCCCTTGATATACTCAGATATATTTCAGTATCTACTATTAATATCAAGTATGCTAGGATTTGCAACCGTTCGATGTAAAAAACTAAGTCAAGGATCGTCATTTACCAAATATACCGCCTATAACAATACTACCATGTAATGTTTGCATGCTCTATCTTTTGATTATTCTTTCTTCTTTATTACCCTCTCTTGATTTTTTACCTATCCTTCCCGTTACTCTGCGTTGATACCACTGCTT
  +
  p~y]httc~jM~\8zdfZ|xix~Nh$~~~~~~~~~~~~~~~~~~~~~~~~~~~~~``ZRw\@~~~yM~yZ~G~~zp~~h~mlx~X~j]Y~F~~yZ~~xVuj_YF~e~%lq@~~~rRc~~f~}I~~a~~lY~~sY~~mQb_~{niI~ra~cred~m|t{Oqn~Y~Xk^T~|j1qYul?~~htih^bNzaiJn(a7ys\gH~nnE\pa/|~|s|iyWzozH~h$c'T76~~u`6gn_gWwS~ycuodGc^PM<~~~mU~r`z@B7q_[~o=zbK~UPmfx)~~lN~S\~]hy]Y_b~jse]W~_S~\T~{]~hrcp.~jtR`VrmT]~~QxbjpNyqWTY~m]Wm[M[\0pTWpZhn?~nR~~snD~~~rDrXbsg~n]NlXN~Y<O:ZLDTx\ad&tWW~\~W~]U~Kh}VM~OZ1uoSb<~`IeNymgT~dl{cik)CZ~f1|j\hG9~~<+3/d{S~s]<`/bWm0~xIxO~gTi\~W~|nV~C~t]mskFvPdB~`BBEP9Je\~|N|g=jsfT~XEwQZd`M?~UqiovQ;1IeY9p;~~jfmGP\diR{~n]Hss`~R~@LhGjIZqQ[*~xS~tO~niV~~hJh{oB~r[~aqpz]nPZO~\KIgWe~VxNyImf=~N]n|sg4x~z:~|MhSzT|D\TH7]VoaM~~X~n]mW~nhRyhQ}~<r~geo|W~|_~aWqP~~m\XybdRhvShO~]hnAanUYL~qLVe^g{^RvGgmTZ~]}yjjsi~Szii~Rp<@~v`fW;~~~nG~~kF~H@~vFH~xH~@_V>~]N~~ic~_bQ;vXOgQ~Rk_ZhP~a~ERmFd>R)T~{`XE,mNS^nk~)TN~~VrmQ~Uia~fng|;~H~~`f~W~n|slY~qM~~itFyotyX|lQeh|&~~XW~lGR~g~>y]~n0]:4kshV~X:~Ui~siiBfvengY~~K~~S~Tm`m]QUafsnZvipm>s~hqWvWAb]Vez]g~a~xGyaN~nxGyoiz]]~q>~~UP={X~mF~hm]rQ2'K]p~~eVHqn{iAqRumshm_O?Ve~GT~3~~xf[YOdWT~Y[yS{QM{woiz]R~nv?w>nVl]~~ois|ocuiv.]g6~pxe)S~ZV~gH~jGZ~N@~~p^~l?qNsFn`Axmr1~~n~zkSexl50F9D(|q<&>2MvQymG9h~nZ^VIqYc?ei|~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2164/ccs/rev np:i:7 rq:f:0.995644
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGACGCAAATGCCACCAATACATATGTGTCCTCTTAATGTTTGCATGCTTAATCTTTTGATTATTATTTCCTCTTTCTTTCTATTACTAACTTTGTAACTCTCGCTAACCGAATCAACATAAATACGTCAACGAATCAAATGTTGATCTCAAATATCTGTGTCCATGAAATTTCGGATCGTAATCTGCTCTACTTTTGTTATTACAACAAGAACTTCGACTAAAGAACGGACTATCTTGTCTAATAATAATGGCACTAAGTGCATACTTTCTCGACTACATTGACGACTCAAAATAAGAAAGGGAGTTTTTAATACATTGACCTAACTCACTACTACGCCTTGGTACCTTTGAACCTTTCGTTGTCAAAGTTCGTACGATGGTAAGTGCTTTCTACTCCTACCGCTATTATGGTTGAGAACCTGTTAAATGAGATGGTTCGTACAGCGGTAAATGACTTGTTGAGTCTTGACGTCGACGACCAAAGCGACCACTTTGACCCAATTGCGAACTACTAAATCCTAAGCAAGAACTATTAGGTAGTAGCCAACTTCGTTAATTCCGTTCAGTACTTTTAAATTCTAACCGACCATCTTTCCGAGTTGCTTCAAACCCTCGTCCTAATGATTTTACATCGAATAGAACGTCGTACAAACGCACTACTACATGGAATAGATTCTCTTGTCAAATCGTTTTGTTTTGGCTTTACCCTTGGTAACAAACTTCGACTACGTTCGTACAATTCAGAATAACCTCTACCTCGTTAATTTGAGTTAGTTCGTTAAGGGCTTAAGTAGTTATTTCTATGATAAGCACTAAATTGACCTTAATTTCCTCGACTTATTGTTACATCTCGATTTCCCTTGATATACTCAGATATATTTCAGTATCTACTATTAATATCAAGTATGCTAGGATTTGCAACCGTTCGATGTAAAAAACTAAGTCAAGGATCGTCATTTACCAAATATACCGCCTATAACAATACTACCATGTAATGTTTGCATGCTCTATCTTTTGATTATTCTTTCTTCTTTATTACCCTCTCTTGATTTTTACCTATCCCGTACTCTGCGTTTGATACCACTGCTT
  +
  U~ZvhosS~NN6pF~YT4I<dm~~y$~~~~~~zrx~~~~~~~~~~~~~~~~~~poisos1~~{rH~WTd6~awbcdHXJw^xd~|vX~R~zjF~aEM09Ih\~T~trEnc~r~N~~f~~W~~^~hrF~~sT~~vG.?z|yhX~m6~~j{3~Y9_bIh\g)QPh'>9?wq~wgdS~~8{_8]p7~u]t~~yJ~vOpH~p~Yqys/~{HavzzUWSIX~sgZT~~F~~sX|~zti\Xwwtx`T;iXcs9~~_H5k^R~}q7~_`~Y_~yH~x[jtn4y~op~g<~hy|lfxL~nMqhi~nd~YQ~US~`~xgY~f{Equeek1~~hgd.%W^iugIxXZoaHYIv;~~o`X~S8~~Q~~Ln9~~~mHmoJu~Q~mz;~at~yfpfxP~uuf]hW~P~X~?~e~U~`ik~\gD~~olKtZfbg~~mZ~tUs_nQ}~X{Js~pzpvK~~y}nueL~LiO~jkI_LC)QMw\ybWh2~]~mD@~D~~wg;YCvQ~a~wa=.hjG]M~KK~~ySfrQmY3`W6j~yO~3M^>o4Whws~d~4~~px\mN~~zZ~~BWK~~R~EkPfWm~xPjx~T~~p6xbI~Ud%~P,nvyhU~jEwwTlxmmLoL~rM~a[G~u~Y~g~oJ~sEf9oy4^we1x~E~x|A~]~rj^~i|y<~~J~RXk2zpv$~J2~~B~~qh[_b~hiwaRf)ZH\mx~Sxm2~vN^e~lOPwi2hu'~~wsysus~sG5n~~?zs~dg[VW~[RuJt?MrV~~QslB~~~j?f~|X~oN~~pD~~@jBwca~`J~~b4~wp~ydPplS~qD8ev[~V~z~sb~Q:~U~zxa~B~umiT~]~G~rTrnU~~VJ~yqI~`~J~~\Ps3qgmb_Y~kK~~axi{sltt~l\kw}G~u6~XlR~I~u~B~~Tq:YnIoP~|CyKW~~zm6m{an~U~~V~~T~nSTld>t~z~qk{yfqFzmr`n{Uyw@~uYpZ~t~h~~y_~Xt~}sz~~I~~J~~nvTia~kg~ulo|oa;~~~~~h`[~mxct~\~q?tX5ogW~~~a~'~xw~zK[fkK~dU_2~lM~yicd~ZyNPgHC~ymK~~]ji}rYflc.sk?~sR9a^|\OgoC^zf%~TG~~xX~|M~u]hZhT~O$1{~~~xCpD_]=~~dZyocl5eoh,tkhw.w]~|pshVP~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2225/ccs/fwd np:i:6 rq:f:0.995244
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGTAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTTCGCAATGAAAAGAATATCCTTATAGACACGAAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTGGACTTGTTATCATAACATCCTAAACATGTTTAGGAACTTCCCCGAACGTTCGACTCTGAGACACCCAGGGACCGTACTCTAACTACCTACCTAGTACCCATAGAGAAGTCTTTTGACTTCCAGGCCCTACCACGAGAGGTCTAGTCGAACATCTTTGATAGTAGTGTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTTCCGTATGTGAGAGTAGTTGTTCTGAGAGTACCTTCGTCTACAGGTAATGTTCAGACATTCTCTTACCTTTCTTCACTAGGGTAGATTTCCCACAGACTACCGTCCCCCCTCTACGGTAGGAGTGATGTCACCATATAAGAAGTTACCCTAGTATGACTCAGGTCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACCTACTCCATGTTGACCTTCTAATGACCACTAGGCTCTATACTTCTCAGTGATGTGTTGGGAATGGGACTGAGAGTAACCAACTCTTGTACCACAACGAGAGATGGCGGTATAAGCGGACAAAGAACTTGACACGAGGAACAGACCGTTTCAAGGCTTAGATGTGGTAGGGCCTATTCTAACCTGGCACCTCAGGATAGCTGTATTTGGTAGAGGCGACGGGCTTGTTGGTCTTCCACACTCCGCTCCCTACGTGCTGAGAGTGGGGGTAAGAGCATGTACCTTGCGCCTCAACACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGACAAGCCCCCGTTACTCTGCGTTGATACCACTGCTT
  +
  e~Uctj]J~xtsRN~UjTslshXZc%~~~~~~~~~~~~~~~~~~~~~~{y~~~~~plvFh_V~xgB~xevG[aH]slycJ~OtPXtslvdTjJUwlvTq^XAL9X`QbMX_^J^:_[lh\lX~Rj:^O_gJQZ`hI~~Wv:~JfYSAynL_?bhI<rfZB|[@|~zWTUleEjg[WK~bgXUK~l;~~cGGfGkN~X~bl?rX~R~jEL`kE^t8~r_uahblggfad1m]R[6ViQagB~z=~~U3Zf@>~M4^'a;7NOPZFV*dc`Z@wkhlL~X~hlb[gZLW`&e\YI~n<b]FcGO~:kdD\]~S@_Cee[h[`SZ]aKWFpU\5~~^;~Lp]Y{XQ6}RV]}LllM~P{^^~[P}Q{|F~|F{QeE_@JuPChbh7jHIF5>u}Z;YfYoQ}e`g\>>jDR@fJ~8~t^K|F~O}`S`2zCu~l[h_4^e\Cz~PT7~~~hR~l_:Hx9WPDfb<v_4P~G~ka4~~~uX~T)eI/nfVQa[lg]c[]~>jQea]LNPFODfb[bh[`QT]k:~VX^%{Q~fEJkJE]gfZNQV~ZNkL~l'rUUQkaE~~gQ~6\ZUe2~~~`G~ZaJ~Zb`AiV>_gbdCM${~eH~~QHh^jQZgEiCJAbLJ~f^IhlhbdM:Qyhlg^aHG~afF%ztX[[TX~CkRQ{)~olhK~QZbhbhS~iFihbl[bJjEflY7~~ZYlhbkQ_hJ[~Gn;lEf]^ih]~[hl[biBja[h`Qal[hbkA~lLiFV5de\]*b3KRwgB~~2}J:~PvZ7xalhk_NYM_fbjM^I~_J]YcYO_P^Rd=zR}[bf[lh[hR~lUblb^~YQ^;YgRwS]WH|K&_Rw~Z]~ZQ[kQG~~Re]^Fh]7ak^LeJf[f^Ih`l)~~~y]Y[WJFPuR]PuJE[V??`SU&K{Qk\>PkW$yI[kc@h}lhbi;ibeF_4J?jS=~~~h[lb`J~Qk[gR`lR~]~?ub\g`QJRcaeJjQalhbhafQn?`MXKYkZUGZkbg'=sjJWbkdbf[la1^s~rR~hafhaO:c.WnzM@:`Jz~e2yYEyI?fUYP\aej[a@`\i?~~~}XQXOEI^lhlgX0fBd?eBf`4ctY]CUDQ9DPLJR~k@~_;mi4yP~l[gXYdH8mZ:e`G`k@|h]QZgR~hUa[khlhi9nblbYzJfl[`4~~K~T~~ZB~}WZX`Ln'sgQHG4gfU1~`g[gYK8~j=waUdDYRPZlK~QbE]~b_4b]~[kG~k`QL{PUcQL\@eXkdPI,EJXaV8Hjahg[OG\~;~sKelJ~~dJKbh`QalVvH]STXl[^~bf^=fMB8?/,UWP[aj@w[R~\P]<L_E?yc0E`abX~[Y~`QYaYbhR~KZ6e_OHh_6~lYB}O~[\~:`gj]eO~kQG~s4V\J\|XMCdJlZM|ZQK~kHLLe]`a[WR^ReH~wRldh`QQ~[bh[J~~['^`Iv>}kZIy+}SXBBX:~a\lC~wO9X\LaGS^PFL[_*ocagj4|\YTZhjHPeIh]~JZ`:~`V%YZgJ~Z_X`GE~_I}^3d\@]^\`Qk[^~L~lH~m_[kQZajJfK~QZg[lfI~IhEi:~akXK)\.~~~tjKFs~aLawZMkE~~hl`Aa,e]^lb^~R~W~K]~[k:~H~~bl9~zfC~{Qi7}`PAMFkX])+SFH^`,oVHaU%bZBAIgI`RKqW\`Y2VYP`WQ`r
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2225/ccs/rev np:i:6 rq:f:0.996153
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGTGTAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGGAAGGTTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATTCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCCTAACATGTTTAGGAACTTCCCCCGAACGTTCGACTCTGAGACACCCCAGGGACCGTACTCTAACTACCTACCTAGTACCCATAGAGAAGTCTTTTGACTTCCAGGCCCTACCACGAAGAGGTCTAGTCGAACATCTTTGATAGTAGTGTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTTCCGTATGTGAGAGTAGTTGTTCTGAGAGTACCTTCGTCTACAGGTAATGTTCAGACATTCTCTTACCTTTCTTCACTAGGGGTAGATTTCCCACAGACTACCGTCCCCCCTCTACGGTAGGAGTGATGTCACCATATAAGAAGTTACCCTAGTATGACTCAGGTCCCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACCTACTCCATGTTGACCTTCTAATGACCACTAGGCTCTATACTTTCTCAGTGATGTGTTGGGAATGGGACTGAGAGTAACCAACTCTTGTACCACAACGAGAGATGGCGGTATAAGCGGACAAAGAACTTGACACGAGGAACAGACCGTTTCAAGGCTTAGATGTGGTAGGGCCTATTCTAACCTGGCACCTCAGGATAGCTGTATTTGGTAGAGGCGACGGGCTTGTTGGTCTTCCACACTCCGCTCCCTACGTGCTGAGAGTGGGGTAAGAGCATGTACCTTGCGCCTCACACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  TwdmzesR~]wo<d~T_;sUuTXif$LZjx~~~~~wqopvvrrw}~~~~~{gXM>43,NE<]sh~sTZ~sjFvletlyftk<~Mlfh~qSFgN^eKjMpQ~ftlc_jc`^j;~lE~]ahmxk]f~.~mKvctlsd]w:{{`~TpH]j^$~~iZ~2u&OQ[~yle~_@~vkSZjqufUkg[H~KDi\Z~sB~abkT~jXTwc~NHQ~U~U~shkcp-~s8~~~~cyesqhwKlY~G@qESqwNrQ~s:~~T:xvjPyqZ~P~iN>f~rNFdb`a{lx]\~^xuZuewR\idJ~l7~p^~[FefS~b~BPK;kfa~TzGaxh]Gf0<uldqBMD~~~F~b~c;tfCToFc6PMrm[~Pyy]~c=l5v[7~~U~y)oltj+~Ro_bnSoE~xgA~fKsRvVvE~tTu;Eq~ktW~_rNq~N>~d~PznncT~E~UVTobffQ=@_ekyB~y~Q-pkKvY~_jslea]~^ONvco^c4yi\yct%X~wF~[ktNj]wS]RP~J~asdv1~DNqPC]leylevlbBF}vh^<}pE~iEDTA/LWQ`kQ]~bjLJ]OH~akPU/^cjK~J~aG|1k\\YSV~`EE}_Ee]`aQYe?jbk3~~~kD~~k:ZCOjbhbh^~ba,NzQk?|hjDNeI~~i;i[i\X}Eea0~}eDf`QlLb8Ef6`f:i?~lbY%VZj:~eaglZO`[Fb>HN_=}~ZkgfD`\Rg[4VGv5|^QDd\QAxDjeb\e`:XaWZfGfbjC87}]D_R~N~uEjR~]~EwlJ~tF~xQ~;VtR~[hldBHAeIfTcRXKkZG~afE]V[EelQ~J~`DO\glajCgcJ~fZG~ahUlblX~aQ`X~kQ{:s]W0_.%Hfj/~~]Ok[lA~^9aaP2fEf`:iR~[g8~~~~|P^:g]=~dRL~jDNEkaYg`UPgFSR_XfZJ~H4aCA;m:iZOQa/h[8[RJ~b%Sh|}eeXLdRLU]BVDVkQJ~Cv;xGXdEf+Su?ib`/@\kG_SWK~lb[lblhajM=XFKPkR~G6GBekQkbhZ/~~~J*iXIXPYlKt.ezjb^~<~~kH~k?~lMxakaj[kQ`ZJ~YQ7~~~vafIhIM~gd5h`G~`j8~[QYFucRVL]aQXeMYgK~Q7un>whT{>xb\hbK~iIlbL{y;~f<~p[lbj)|MHhCF[L6b]~ZNK3_T]g]R@~tQs+hPS?~{IYHqMo@~~_O2;m}fSv[l]_]SL}]/`y[`1Y@jaP>~iNW/d[g+\K~baF{]/gS~g[b_:~`f`gkQk]4hZ^;^PBe[lMFaAC[0{jWrRA~za^h[l[l\gH~.OG|]h]2J,O>Nul]Y}`Ej[l[kQCkF(cVgeLnZa:jc[=f<::L`GlEgH:`TOIU'u^[?QQ|T8^a\Uj-JQBeKA`\X`F\;`?koR~_aB}[hZ}P~bIrLkR~hbj8dkhl[bh[hh5oS=l`LWkK~`Ef[,~QJ@nB0u@|h]CyRtjJjab:m\_gC_p5aZVhZ]]CcDgEe;\LnMRyCPE_bTYNjR~K}[b[Q{Q_R_lNv0u`g[X~Z9I18hb3wdeaOM_HxR~f4~~eY;_.Ud-M@|j_S[QhMhFbafA}P_Jeag.~~liX3B`uZF~~alh=~~dVk]_a<CjhZHmEZRQUOk^QJS>bf>]2~~|J~wK~GY3dKg_LDSXGgi_Yc>@nfbVQkaQ`hX]ZFkKcflN~kOTMC@_
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2255/ccs/fwd np:i:14 rq:f:0.999157
  AAGCAGTGGTATCAACGCAGAGTACGGGGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAAGTCTTGTAATTATGGTGGTCGATTTATTGGTAGTATATTTGGAAATAGCATGCAATTTTGGAATGGACGAAGAACCTGACATCTGAGCTATTGTAAGTTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATGGATAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ~~u_~|~p~~~~U/~Xr~~u~i~~~B~~~~~~~C~~~uWrZ~~~Vqo~f~~c~uj~\Q~~pSK~~L~~{t\~R~~~v~]~vyU~~lrl~K~~~q~~g~~c~~~~~k~`:~e~~tK~~~~oB~~n~r~~d~sX^~p~~Gp~~_~~~=~~o{ly~~z~i{m~~~~~m~k~s~l~~i~~~L~~~z~Xyu~va~~~sWJ~~`~~tR~~~jq{~{~~u}~~~~YC~}_U~~T~~mvJ~^~~~~Ixwp_utbki_}fQov~iW~oo0|C~~~XY~jF~x[sndbRp~emoZ~e_`9s~~qaV~~Y~t~~~~~wuH~uh~}v~~NBt~~~bn~Q~{~l~~~\~esSo|jcz~m2ig~pBg_bSbyLU~~~~~|0~~~iB|J~WaQ~~~~w~oi}~~}~z1~~}G~Y~lzmX~~{~S~[e]h~Y~{C~~iir~~e~]}~`irtb~~K~~~y~~l~~kp~~mM~~syB~~Z~nm~t~~~~~j~]~~o~tX~k~~~~~~n~*~y~~~~~~}n~~v~~~~~msn~~~|snm~]~m~~a~~~~i~[vYmw\pt~]~~S~c~pt~7~E~~]Q\~sp^~~Z~]4~~io~Z~~}E~~l~~~~q@/q~~~~sh`bnu=~~~y~g~i~~i~~^~O~~~~=~~~oa{o~~~QkS~Z'y`i~~uq~~o~C~[h]xx|5~y|{~}~~~j~tW~~}~S~~~~~st~~R~o~T~g~Z~a{h~~~~kN~~~~~~~^~~xu~]~{w~xjZrn}~op~\~q~p~n~dY~~zt~r~~~u~~~~[~oU~~{~Yl~r~}~|[~~WrEt~R}j~)u~k~~O~~~~~~~~~~~z~xw~~}~~|U~~~~~]~y~w~~~~o~i~Y~U~7~l\~v\~~~~tpi~}~~~A~~~P~I~~~xy~~~J~~~~b~~~p{~~~I~~Z~~\~~~~~n~~~m~m~~~k~~_~Va~~=~~~Q~_~{~zs~[mF~~`~G~~u~ruwccn~~;~~~j~x~~f~~Q~~~~`~`~~~~q~a~v{~w~~~Z~u~~~~B~jL~Z~~~q~~]~~vhy~~W~~}~~~W\~V~{g|~~w~~~~V~~~~L~~~~x~~~~~~~~~Jn~~~~:~~~~^~~q`~~zN~~~~i~xO~bv[~~~i~~~~~~Qa~`~~a~o~cx~~k~X~~~g~~U(kv~~~~~~~~~~~~~~~~~~~~~~~~~~w~~~_{~w~~t~~~u~\~W~jL~~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2255/ccs/rev np:i:15 rq:f:0.998188
  AAGCAGTGGTATCAACGCAGAGTACGGGGCGATGGGGGCGACAATTGTGGACCGTATGGACTCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAAGTCTTGTAATTATGGTGGTCGATTTATTGGTAGTATATTTGGAAATAGCATGCAATTTTGGAATGGACGAAGAACCTGACATCTGAGCTATTGTAAGTTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGGTAACAATGTAATGGAAATTGGCGATGACTATGGATAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  S~y~_c~e~~~~~B~u~~~y~~~~yR~~~k~t~9~~~~~vm~_~~~}~b~~p~~~m~^~^p~9~t~y~~~~N~~~~~M~~yJ~wjbc~n~~~ya]\~~~vsa~~~~Z|~j~`y?~~xs~q~~~ys?~Y~u~y~6~~{~h~R~~WD~~]~~~~~{twszU~~~~~ry~et%~cd~w~P~~~V~~id~vW~~vs~]~~|~~gN~~~x~~u~}~~b{~~_~p~~~N~~<}b~vq~X~~`[[~~i~~{|~~~}S~~~~~V~~p`~~~r~~f~uM~~~~~fuff~~~kO~~~hE~~lxvd~~i~~c~x~~~y~~q>~~a~~~~~~n}~~~c~}~p~~h^~~lx~s~~vsjm~jf~~~|~c~~~`~~T~w~n~~~^yt~~R~g~b~~~~~~\~~~~Qc~fuO~3~b~yI~~~_~~x~~J~f~~a~y~~ua~f~~UV~~~~c~`d~~~s~~~~~~~vr~|~~~~]~~~~~(~jg~}~m~l~h~~~~t~~~q~~vW~~*[~~rpmsxr~~v~~~v4~~~a~~y}~c~C_o~~r~I~~uu~~~~]~~d|~~~~~g~q~~swx~~l~~x~u~P~~~~~~Z~~~P~`~~~J~xT~~~~~~Q~~s~~~{~~g~O~~~~\~~~~|W~w`~~x~~~S~~u~~~~~w~~v}~fa~~~r~yzZ~~~QK~Cpp~~hC~~~`~fltq~~~~~~~f\~~qh~{j~~D~~~a~~~~~~~g~~w~~I|~~c~v~a~~~h~e~{b~ehgor~~~<~~~~~~~q~|~Tg~u~e~x~~~Y~mn~J5~~h~{]~U~~nsI~~c~~u~~}j~~x6~VA~~~~ueX~~n{~~tT~~f]~|C~~~~|\~~QsJ~~~c~}g~~~~i~~S~~)~~~q}~~~ep~~~~~f^~~~~~{~o~q\~|tg~~_~~V~~~T~~m~~(~~~o~p~~~k~x~{nU~~U~~~~~j~~|^~a~mWa}~~q`~~X~>~~~ouxv~zbg~F~~~a~]~~q~~~~d~~T~k~~~t~~~~~y~~~~~~~|~f~~l~~K~}~~r]~q[~~{d~sl~~~~~~~~czU~v-~~MfjN~~u~~{~kv}~x~n~~~~~b~~t~~~z~`~~~~~~~]\~~j`~]e~s~kF~%~~~_~~b~~~~l~~]~R~~l~T~s~u~dmw~~~_~]~$|z~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~s~~}~~~~~R~~~~x~~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2286/ccs/fwd np:i:7 rq:f:0.994486
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTACTATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCCTTCAACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAAATTTACGGTGGTAATTTCGCACACTTCGCACGTTAGGTGACCTAGAGATGTCCTGCCCAGTTCTCCACCTTCACGGGTGGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATAACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCATCCTATAATGCTAGGTTCTTAAATGTCGTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCCTTCGCTAAATAGTCCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCCCCGTACTCTGCGTTGATACCATGCTT
  +
  e~b]k^bS~gZeY9jW^Ll`X^MUY$W_kyyrmlnpaWSV`igiowuqqu}~~~|kgZcSd`/V@\^lP~i@(9IC>QMYdLkS~fHeK~bkVkfN~lYX7z`YWd@~~A~k]dG=H~KJ~N|fFWU:|^7L9~xSj]d[[Ca[BlV5bmDP~mbfmba^$~~~~~\]]E~O~MT).,_j6rb^dWZcX`L~jPZKDj[UILYtXGXC.~~oALLn_D~V)}PI}]CfJUo<~~~l\2{g_\M~ec]X~WRD~f4eVG~i3U(S^Za;|iy^6\[d?~}KjbmeaNAlN~`A<iX7]LVK0y~\fb]f]b3@G@j1~WJiaM~]bdH``E_:|G{\2lq~fWejeZAEdY~[bfbfm8xfj;mOwXLWa]bN~a2u2ey_PfJjeZfWZf_kL~~]fX.oebflN~~P<=~c1jXb]f]hb\FaJEaFbYMZW~bjOJ3`hVwIYkH@~z^g^eg=h(CY)RRL~~lZ-}dRy`7yBrvPH[SYgHUo]`Hk[J&~gO~Q\BKucICT`hC^_:q]^%hfg\UhVH,eP/u6~[W\<~~e%gkMgm]mceK~P~lZG]IpjKpe5fg?8i_XHiCX~]bm]`BLxrA`Lk]`P\hLg9l~bf^hc$2_fbPQcAf`B,fd_K~ahEdZ]8y[c2D3>heXXK~Q~]9~oNi9~rKtN~W<~q,ceZWgQpA~aDc/|~eAei7ZdcMlF][f^][B`]Al|`WQ[S8;{~~LwTU6k~fP~Q]lf^beMjfO~lIj^$fE{n4~qFal$bUbCu~dUgLw3PTEh=jrKYHPHz%\99d[U*JPhXb>~~r^[9]WR7g2UXREIBROK}fL~[~H[a7G5dbfaV<wIoBu:PH`,DVS]K`AdaK~ba]eUFQaeNTMN~I~~JaTZK~l[mZ\~\^eB~~`UNhdU`V~^d\MT`GD~^aVY$~`dHkfWCsPO7NGOCldJL-YQ>d2k0NfAg`Oa\^JdRb2@CO}lShM``]hc]eWa@~o?egX~blLnlg+~e]bc4]7^FT{(~~ok\~QsBvkpV~OVSuf]eobjQ~bkM_`o@~`hM~Rc@~agiP`8kU~R~pN~~~[_nuhYLEQgCdolPtqkpwj]be~j@~\CS6_ol?k?vhDxI~Pja~Uj]GzSZ`qfkfkpwJbET`E~~~jeC2^T9IRPT~ka~wfXyhQwpfo\gpT~kbcNR~u3~<|Ff<~U>jE~aKE~][:tpOys]~Lel_nphqVqZK~_~B~owa'TTo`fCvuhNk`?HTA^jd\NBD'{`FgG~}pkpfljNYs4|x~d?R~jRLIZmZhjMMb2vxc;sUvkMsvfNqYujmC[njLzXfYepkcbnf]~IieBeCJSEtQAaL7~~T>p}ojcAzV9r~_~ekhaVpV:jnQmTK~joN0][~iLnkkXq=sU_O~C~kZW[p&~gKN]A|bYRLNrhHFb[?jkR~C}2q~u~W~tOXuT~V~f^~fgqejN`u_~wUewU~~t[oVnZ~d;{X~OTmQjpbypOyslaeU<SidTN~j`~dl?(}~~Yfh$~~rtWdlwj\B~xfwkpj@~aljA~a=TSU~^W\^<a\bepkobiV9\Ub^~Lhaj6~bW~nQh[yJ_pPnkn_Vm;[dUBy_^6x~wdV+\UV~M~4~Ujk7a(rXqaG~ji?mfj^TW9UT+W_?}t>~*dWcOI~_ORU~joK~lQF~`OTDwe[~fFQ~bcXuHbja8~rkW~oE{gAwnF~okLzQ~~K?~TW~~kolj9^mce's]QgTwMe^O~j6~~hV^Ga7~~yg\~_e]P~lT413k<~qkkWs?t[~Tj`X`X[KdtXPgE~zwdYje-~dZ~[wR~O~~_Srn=tehea>J~TkQjdk&@y_Qh4GGx~faR:l[@~i9~sm]P~Z[~kdAA~~gKt~fwleu\=}tV~N0~~xjQ~OiH~nW,~~qkNJ~}eI~~flqXfX}aa],zH?j\@LgNYdPlWV(~jUUV\*GZBJ>JrKn`]Bu_@<lKiLcgcYi[F~jm(n][@okG~~~sH~Qcv>~Y0h8^cW~SnWW~a{o`T~UdkdS<>OzSrnY~Dz~wfS~pwn>~~AyI~|U1pjH~7xxRP]~W~ZRidj``jnUaK_A~E_E[d'tjivMmhj,nkbklNu~~etRZ*lmGz\W~8~~g]~>~JID)JSdauE~H~jD~WbmtDpvpCjfBwUPtgQK~rhO~]o_`_@twF~prc`{jj=S~:MrfW_mV7~k_j`Laj\Yf;UA~j`qpTrP,hf]~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2286/ccs/rev np:i:7 rq:f:0.995951
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTACTATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTTGTGGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCATCCTATAATGCTAGGTTCTTAAATGTCGTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  8QF>NAV9olfmaE~Y]bcXhZmfa$~ra]ekllllgcdksykO>69HawqhWQRZJaPbeblc[Wd={eb]m_g>~ecn\OM~g^NM{E`^_WM~Q`fP~mf]W9~cN~eLUafS~]MzS~WcLdP~HUr<xbK~^8Y[WNLH~KOw~`Fd[\9C]m[*Uv~~i`BHcH|A^+|AdN%M]IeO^dgVS~dT_]Vn_PU\K~]L~a>er~f^R~TBcK=TUgKU~bV~<~~O8I@idH3B~iH`W}[e$sk`Vhe9~s_:No]a[;idqGT~HUN~~lf[bk]WU~A~kfS~e9uaMP;}~_k]blaWE~aV~7~~S~ZM~YLUa]W^3Iv*\I3SYOXZZFE5STfRq_E@YceQ~nhP~UOeVP=5D[~hP~&~YYSecdVciON^][F[y]lbV~m]j6AttXfOjWI~^h]laW\`VjlblaR\VaV~NajOa\WW~HVh_>itVK[mfLofb]V~Aoo]J<kX:v\Se<xh]\Ldbf`2eB\_fI[BjdL6ZbYfKmlf\h\fkE`Pq^8O}bI0i?3^Klf7\F\`fbC|il]c`ffbhZ(P~LmNXH`OsRIP,G~~`=eix]^MX~aHNJSc0gZag]faGU_M?c:~o\/`eWe'~|M`gkghHdP~HO~HdP~HiH~Rfbf:~zkLdP~M~_@|`Gw@~~V~N~aE~za@baFtLv@x~alA~~~V<md+|jeN~c^eM'hfZg\Kk~]I@`QS:{zf\~cf9~xfK~hZfm]g`\Ne9{i\fkRg(p_&z_]OP~lCZxVId@g>~l7d@ivZ^]fPj-~VMh[f7|wfG\4~~l\a9~~_>|ZR_[iTh]mPtgQ~N~b\N8kam^m^hS~\~S~f`O@QsE~`Hdn]V~kI_R_OVZUYS_Ll=~aH~\eFwfPO`'___\O?gvAELOEIZZ|ZObddH`S~ciSaAiFXQKdl`(|\cNhfmQ~c]hS~afDCx\blFk6UdK[N~`ldbN~^Q{L~yQBJaS^GCPTfleH|WeQ~fmA~nb]na\HUKJ~;~q]@bKd`NXQ*xYTCMXd9jOFR~cR]faWP_%W@g\aJlL\m]e>~WjPji/~~h]eWe]WYLM~kaX[>~NLWbLd`E~\A}e_g@xflaWaf\>~YsaYWpZc]M~_UekL[b]nf]7c\d:ywZ^XTP`^e<vAY~YH[cbVR1_fmbmeHBR~[`\_JDaHWK~`JQ~~bj/mKa?gTWFeiP~dVg_]e^R^T^Xm\X~Sy?\XO^3~_O`mR}Qj>~SPiW~U6^Ac6O=|`V|KNdjIWa]kcid)dsXMQMcXIbMakaPWdaH1{lj^f_I8L~`Z^emf^WcYU\Iru%SU`g1JQW^<~Gzj^kfb]RmMKSc;exk(pxaCKKk`Fbr?~VK4_K~laYcaT>D_[Og8^DtW[*HWX~mfm`4UR|mbf\~I~~]aK~akF1D|keV`VYd]Fd$@?~ws]=od\WeP~J~`Gg`HSbjaD~Dg]YaM5XjegQYZI}bV~M~aLlbZdD~WP~dA\Xmbm[^[<`[Uibf`?uzkeKF:~zdWa^`DID}lVe9jNSyeT]XgLjce@n`ghiQajfam[eg\h]gWaYeR]TlS~g5_U\XOJ5~bPTYbQU<ZVEPMZf[/jkkak7`jN~M{Mxl]YebFmGe`%tET[iL[hkWEVcAulN~aMyV~i2[X~fm]SjXgK~W^;h`E`=g`Yk\PDtN_Kobb^f:~~lKjl@~q=g,J^d\PsNj~fS~\$~}YfEi^HML\Y~aeY\~f]eJmH0~~oUaca'wfZZF{`GMB~iNlbN~2~i\W:VB~Si[kb]ahWc^fmb]H~tOLSF`\~Ij\~Nh>~~gS~f<pa]bkHAeH~`H`mfU~a-}_U@~~`Yf2^\HMFG[F:MC~d6fY6cHo~]L~i^a\ab[T_OLs_>kggY?}MHEn^]:LVabb8rQB/{~]TJ=^.^H+KS~Ygb[]WM~tU6Va9[F\YRVa]aHMlGa^VD~b]bm_g_W^YWYdQwIhC~~]V~W;bl~d4qRYSQ~fV~bfa:oHdWMzGhUQ=jkaGK59/BOH`RMy:~lmWR~h`W>yeA~B~~\Q~]Ng,~~nS3x<~Ub\L[bYZdHN_W:<(^k[T:^X[=N8R<de]WC9}~oLH_k_NUL~`4\Lzg^X~A~ea\K<~`CSE<Hk|>}kaVJ@scJFiHO~RPLMh6v{wQ~J~kpu3~jG~u\S:~O[UMnOgpe`o_PB~{f]^@hsjcdR]SdCLIVV~lgH_PUU
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2295/ccs/fwd np:i:4 rq:f:0.992186
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTAGTCTGGCAGATTAGATACAGCTATAGAGCGAATCACCACGTCTCCTTAGATAACTGGCAAATCTTCACAATTACGCAAGACCATAGAATAGTCCTAAGCAACATTTGCCGCATCGACCAAATCATGGCTTTGCACTCCAACTTTGCCTGAATCGTGTCAGACTATAGCGGGACGTTCGACCATACTACTCATTCGATTACGCATTCACCTGACGAGAAATAGCCATTCTTCCTGAACATACGTTAGAAGTAGTTGGTTAATGCTTGTCTACATTTGAGTGCGAAGCCACTAGTGGTTTGCACTGTTGACCACCAGCAACGCAATCGCAAGATACGCAGTAATGCTAAACCATACTTATTTGACTTTGATGTTCTATCACTGGGTTAATGCCTGCTGCTACCTGACTTTTAGTCGCGAGCACAACGCTTCTTGGCTACACATATGCTGTTGGGAATGTTTTTTACACTTATTATGCTATAAATACCACTCCACAGCTATTCGAATGACTCTAATACCTCTTGCAACTTGGACGACCGTAGTACGCATTCAGTCCGAGTACCAAGATAATGCTCTTTCTTCTGCCACTCGTCTAACTTCGTCGGCTCCGTGAACAAGCATTCTTCTACTAGGCCATGGCGTCTACCGCTTCTTACATGGTAACCAAATCTTTGTTAACCACTTCTATACCTCGTTCTAGGCCTACGTGAAACCCGAACCGAACTCAGCCTTCTTTCAAAGCTGGGTCTGATACGTGCTCTACAAGTGCGTAATCCATCTTTAGTTACAGTACTGACCACCGCCATAGGGAGCACCAGCATAATGACTTTAGAAACCATTATTGAGTAGTCCTTTTTGCAGTGATCCGTGCTTCCTTCTTTTTGCGTTTTAACGCTACTTCAATTACCTACCATAATTATTTGCCGCCCAAGTTGTCGCCAACCAAAGCGTTTCTACATCGTTTCTTTAATTGCAAGAACGGATGTGGAATCCGCGTATGAAACGTAGATTCTAGTTGAAACGTTAATAGTTGCCGTTGGATTGAATATTTCTCCTCAATCGTATTAACCGTTTCTTCTTTGTTTATCTTTGTCGGCTTCTTTGAGTTCAGCTATTCTTTCCACGGTAACCAGACTAAACCACGTCTAATTTCTGACCAACTACTGGTCTAAACTTCATGCTCATGAGTGCAGTGACAACTTACGTTTGTTACCGCCGAATGGTAATTGTTACTGAGCACGGCTAGAACGTTAACACTTTCTTGCACAACTCTCACATGACTAACTCCCACAACTTGCATTTGATAAACGTTCAAAGCTAGGACATTTTCATGGACTAGCGCTGAGCAAGAGACTAGTTCGACGTGCATAGGAGTTTCTGCATTGAATTCCTTTCAAGAATGTCTTGTGTCGACGTCGTCGTGCAGTAGGTCTAAATCCAGCGAATGATTTGTTTTGGCTTGTTCCGATGTAACGACTAGCATTACGATCGACCCAACCATTTCTTGCAGCGCAGTCAAAGTACGTTCCACCATGTTTACGCTAACCATCCACTGTGTATGTAGATCACAATGACGTTGTCGTTTGCTTTAACATTGTCTCAACTAACGTTCATAGCGTTGAGGTGGACGTCTTCAATGAAAAAGTAGACAACCACTACATGACTTCAAATGGGGAAGAGACATGACTGTCTAGGACATCGTCGTCTACTGGATGAACCATTTGAAATGCTTCGACTTATATGGGGCATGTTGCCCACTTACCGTACTGGTTCGACTATTATAGAAGGGTCTTGACAGTCGAACACACTTCCATCCACTCCATAACTGTGTCTGTCGCAATGTAAATGGGGGTGACAAGTTTTACCATTTGGTATGTTTTAGTTTACACATCACAAACTATTTCAACTAAACTCGCTACAACGTAGTAAACTCTCGGCATGATATGCTACCCTCTACAATTATTGCTGTTTCGGTAGGGTTGGATATCATTGCGTATATTTCGAAAATGTCGTTCGCATCCATGTTCATCCACCACGTAGCGGATAAATACACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  S_GKVGB?[TFSL,ZRKRFJ[KR/B$PV_ddddb\WTSRNKJMRUSMIKPSLGNWU2M:S=fJCJZEcGJ\VU9W6O>YTEIEJSKLaGS[E\@@FLNQ1\IeFISD>cRV@lR6d^FSJfP-;MeJfFO7B@N;\EdFUYLMeV\I=4aU@dKQ0R@I4deJEXHFZTQ5ZFd>RRS;DU?lR/_F9=DJUEc;bP4EKJE_VKNeTR;V;R8CA*CU[TEJQ%^HI=I8dRK\EdBSAQREOVS[BFO<L7MH1E<ZJfS\FdVJD<IAF'^ZD8J4OUFGSJfFdVJ=cQ@DPRKJf\K=bKPEJH`>SJeOeVKSJfKVSVWGS<PVKC4=ISKM]G4bZNQZ7,2QBe^F9UGR%9L7V@_EFh\KR,D;H<NeVRJQ>XIAOUFJ<VKU:PUI:<9_P:VWTAMHe\CfeK\SBf\F@TJ;cP<CSAH>D9eeEI:BSJ4aRF(RKP=UDcVJWG8gZWQ:>O4<H\KSPP>eRJK7QQIc0hRVTR[RUP[U<RPJ>Y9jlOeUJ(deefe[S\SFFF4e\VI=TWG8dbS/6KQQS%`FLGIP;RIfSJ:PUJFRVSU>cU[;fOP:eJR>cQ6SAZ\SK\BcFT[KT3LF<YGiS\LVDGI\KUF6S,aJ[VOeVKOO<=fdM5d<TK3e[RNRKO=S<dRGFSKVS$PSVCX6Q@>ZR@_FRGCGP5:(S\RV\$GDgY>@TPF:';@BM:OBRN6dZQ>9>hVOeFdGeeQR4edJJZMc5CQCD`STD6CEdT=JHcSV\?lFdV\SI>IGed>ddK<bDeKNe<PRZJEdJfS17J=9^bJSV9m`=;TKO4NSKVJP>RUYN;cKTF9H>Lc=6eVGS/Xc\J8dSSWKV\RVJF3f[DMKFd[TF9mc@FPY1aFKRUU:Y'H\R4eeFI9bcEdD8dZIeK\KS/IU48'deedKRWJWIFQ4VIVKSJe7dJeS6fff]I=J4ffS:JP6RVZ=FFQ+`7dR5^RTEdC;+_8dY'ddJFdJ>dc:aD&]IS=JFb?\@B/QC6RG/E[RPE=ZVSJ4edQ'bNE`DaKSMb5?aS@cD9JTAhOeT6[5QJUFUJ9dW>JV[L[Ie:<YKJfKGeeSJ5b8IEXKH]6Da57b;g@IfKOeUU/]_OR2HRN9aTR9VOId,aEdE1]HLAeSCfcJ5bOHVS?gcKVR6ZNEaS?fR4GIJfS\KSUF8bN6FFE`V@@kT,`BGEIEQU8daB`\SLVSV>b-g]QTKY%_=JKUZ=SBlROR-JNP'cQ\TLRTO-SJFJVKSXHUFLMD`G'a0MJ4e\27ZP=<1CSK@dUAlS.SEW5:FOSVK\LQD:0gO>XJ<Y>JHb<dA4M;f`P<dJS\SLdKURURY=ZTE8(<<bRU6\UQ56J@,VJJT?Y]I0R6abRLJfQ2IJJSTE%EHR[1eeM%AN7YGO9BI:5N>HZJQ-^AXJ@>SVFI_Q4DRG&4RXPQ>MIJ?fU:S6RZ6[08_2UFd<fR9<RJ<LAKTSJfKULRSJI93SSKT=KVKRF6P-=h:MO'\`L$KOJSI)]DJ[3e_62PdG*d;6\J5WFdJFS6T@DCJ\SV\KS\Ih\PF@USK[3d_=S5bY)e^L6XJSZ6RJS\KVS-dPHBFPKIdCIO2`CEI4]dFRKRT,aDJ[T5bZSVKULS\UKTEK[VRFQ:JSKWKDDeKS;I0ddJSCffOeSWD`9O8HR:EM'IaKKJfSZR/ISICCH->XQ>H\SKVSHgODQ?I'cccbJW[KWK<W%GORV\S\VK\SIe<5_JR4lmR=cJ\J[RFUKFRVKS:SFAn\S\VSKVSI>RUZ=TAm\VL=\0d\CfeJ>LMVKSJfSFKSJfGUK<$Q^ONFSI1c5<bdGNJfFEfKUF=S0gJdSKUFF[Gh[SYF>U9mlT=IeKZ=W6TSKLbGWK\SJe5U0TFd\Q:Ad[T,aRVIOIQOPKP9JP*`PJP5J_U(jkjZVJWG=cI(deaEEO,?_e@iUZPH;FZdFKCffS;DR[VL1PFeeSTF<feR>cRVEaMSVRI=TMD=V<H4<KS7f`3<N:D.U=PVKFFKEH<TJ$^&)NQF?=PJf\IeKSVK@VeS?lTF6EDDU-hZUWTRGIb:?:NFOF9fdPI&cdVTLUSJ7d<JRN?4aFQHHeRFUFd\EdFRKVXLN<jF=5abUZPJ$``JKV\SVSVKSKJfJFYO;ZOIGBI>X
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2295/ccs/rev np:i:3 rq:f:0.977706
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTAGTCTGGCAGATTAGATACAGCTATAGGAGCGAATCACCACGTCTCCTTAGATAACTGGCAAATTCTTCACAATTACGCAAGACCATAGAATAGTCCTAAGCAACATTTGCCGCATCGACCAAATCATGGCTTTTGCACTCAACTTTGCCTGAATCGTGTCAGACTATAGCGGGACGTTCGACCATACTACTCATTCGATTACGCATTCACCTGACGAGAATAGCCATTCTTCCTGAACATACGTTAGAAGTAGTTGGTTAATGCTTGTCTACATTTGACGTGCGAAGCCACTAGGTTTGCACTGTTGACCACCAGCACGCAATCGCAAGATACGCAAGTAATGCTAAACCATACTTATTTGACTTTGATGTTCTATCACTGGGTTAATGCCTGCTGCTACCTGACTTTTAGTCGCGAGCACAACGCTTCTTGGCTACACAATATGCTGTTGGGAATGTTTTTTACAACTTATTATGCTATAAATACCACTCCCACAGCTAATTCGAATGACTCTTAATACCTCTTGCAACTTGGACGACCGTAGTACGCATTCAGTCCGAAGTACCAAGATAATGCTCTTTCTTCTGCCACTCGTCTAACTTCGTCGGCTCCGTGAACAAGCATTCTTCCTACTAGGCCATGGCGTCTACCGCTTCTTACATGGTAACCAAATCTTTGTTAACCACTTCTTACCTCGTTCTAGGGCCTACGTGAAACCCGAACCGAACTCAGCCTTCTTTCAAAGCTGGGTCTGATACGTTGCTCTACAAGTGCCGTAATCCATCTTTAGTTACAGTACTGACCACCGCCATAGGGAGCACCAGCATAATGACTTTAGAAACCATTATTGAGTAGTCCTTTTTGCAGTGATCCGTGCTTCCTTCTTTTTGCGTTTTAACGCTACTTCAATTACCTACCATAATTATTTTGCCGCCCAAGTTGTCGCCAACCAAAGCGTTTTTCTAACATCGTTTCTTTAATTGCAAGAACGGATGTGGAATCCGCGTATGAAACGTAGATTCTAGTTGAAACGTTAATAGTTGCCGTTTGGATTGAATATTTTCTCCTCAATCGTATTAAACCGTTTCTTCTTTGTTTATCTTTTGTCGGCTTCTTTGAGTTCAGCTATTCTTTCCACGGTAACCAGACTAAACCACGTCTAATTTACTGACCAACTACTGGGTCTAACTTCATGCTCATGAGTGCAGTGACAACTTACGTTTGTTACCGCCGAATGGTAATTGTTACTGAAGCACGGCTAGAACGTTAACACTTTCTTGCACAACTCTCACATGACTAACTCCCACAACTTGCATTTGATAAACGTTCAAAGCTAGGACATTTTCATGGACTAGCGCTGAGCAAGAGACTAGTTCGACGTGCATAGGAGTTTCTGCATTGGAATTCCTTTCAAGAATGTCTTGTGTCGACGTCGTCGTGCAGTAGGTCTAAATCCAGCGAATGATTTTGTTTTGGCTTGTTCCGATGTAACGACTAGCATTACGATCGACCCAACCATTTCTTGGCAGCGCAGTCAAAGTACGTTCCACCATGTTTTACGCTAACCATCCACTGTGTATGTAGATCACAATGACGTTTGTCGTTTGCTTTAACTACCTCTGTCTCAACTAACGGTTCATAGCGTTGAGGTGGACGTCTTCAATTGAAAAAGTCAGACAACCACGTACATGAACTTTCAAATGGGGAAGAGACATGACTGTCTAGGAACATCGTCGATCTTACTGGATGAACCATTTATGAAATTTGCTTCGACTTCATATGGGGCATGTTGCCCACTTACCGTTACTGGTTCGAACTATTATAGAAGGGTCTTGACAGTTCGAACACACTATCCATCCACTCCATAACTTGTGTCTGTCGCAATGGTAAATGGGGGTGACAAGTTTTACCATTTGGTATGTTTTTAGTTTACACATCACAAACTATATTCAAACTAAACTCGCTACAACGTAGTAAACTCTCGGCATGATATGCTACCTTCTACAATTATTGCTGTTTCGGTAGGGTTGGATATCATTGCGTATATTTCGAAATGTCGTTCGCATCCATGTTCATCCACCACGTAAGCGAGATAAAACACCCCGTACTCTGCGTTGATACCACTGCTGT
  +
  <XD.GB@3FB@1A*5/DBF=4)MHB$K@KTND<:COTOE?@GOJB>AJNC>D:3E:<O>TBKIJ%SD5JPJBH-3&KPK'JI2@2=8:AK&MA>3M<-:YCU6@7BBXB;;VB<XX5PB4UA4ABUEWKBH.AVIK9]KPKH-<;KIN(YN>XH-/TAJ1DTH*MIBKPA3I)G&TOPBJ:>VB%SSIHA4@8,AUB$SSG9]OF=P%AG9FJ<G<)?AKPKF:&UKKBH4SBIG6[GBJ+9JB9AKEWBIK5WKBH.IDWCK9\NGJBFKI;YOF68\J4UBDU+TCH0VBHK?BE2SJIBXH:JH4A-TDW9O;GB6@C8@5IA4>VWIJ')NG?A<M9*PKB:I<F:N=2AKBN39PGG8YK9\GHBKBG?-U;.FBBXIKPKBH?+GHO3XNF;P<XW:YKPKB4UJ>VWD8A1UUHKPI@=AJ2L-IBP6P?1T(=:G9N:GBN1,NF&WMIKB-POLGDDA3AHJ2@HBBXBD+6LBEW;P;=JBKB'MPKPIBN34U6XTAW:G3VWWM=FB%C?EWKCWFMI?=JN.DD7I9]KB:5\[KBKG?@7@CQA3>8OIKA99$,'=?H:SNB<?/?:;''>+JAA3I496$5EM5AFBK5RBGIN*ZG':9OK8[=JHI%;A4:5A:,81()31-5.FD3-7-'5;-**47>E9,-7-78[IOD9@/AVIBI%@ADO*ZNKBHG0H5;E8,TAE>BPK7V<B@H;?52AH;-TM/5/=6:<>=.D;=/8/E'AI@2LA2'38ZPBF4CBPK'U=9]O8@:B:4H9)YZH?W7E0@V@:+>G*I8LB1UN+6AQ6A@6O:NBPIKPH00&-/@>B>JB=VIPH(YGO0VN9]KOB1VVJFBBI-.=7IBPIK:ZK:YI:[J:J4J;&;:<7W42,FO=Q9DCB1CTJI5XM9YJ4UI4THKH85=O9\7WWWWIBKH:FKP:\H:GBDV0S5Q?,:+:B=BF,:FBBXA3APKA4?BBW3S29ZPK9]J9/V4JF+2M<29XI*ZL<SH3S2:AI)60V8X.VWGBF%G69BA8)FBJ:AH&UQA1RRAW4UHBBXH0VA?VKPIK6RBXP:JG-0&E93:WO-1MKIJ%SAOKIEWH.WWAF9T?AOKH3UG9]H1WO=T70=7AR:H%HRDBP9\K<*:9-6*I3Q%U:9]I?WWBBB-1SS@2XUJ;@$>DH;@B;VB5CB$STGKIDWCKIBPKEVB1UU+NKB'867B:\KFCB:6XK7ZCA27@'1E.J>%<N34(XAVB?*??(UOM.9AXBAN5-GIBPCKPIKIPIBKH81HA-VA2TEBI5VB;3S28XC*>@<;55TO>L2UBBWKB<<$1C?@B>T.MGBBXBIEWAU.I@/UPA5AE;JA/N)J?9AKBKPH7%70VAP5^XJ.<RB4UH>/2QUIKO(WGBIEWB;XT3@:J=VCBC&>GEBJ:;P3APKIBIBPIKH-.T2G0@?AKH4UBIE>-:GBKPK6X=F1A9-&6A53C0V;H1R4U>WVA4UE/NMDJ:DT3:GOBIKBIK:E4AH:GBKIPK?VOB9-VVI6TE6BI<YPHG%ENHH-N<N>VB4UHEW:\IJ;GOBXBF9AB96BKDWIBFB9AH>2YG3N8U5:VU'-L'DBJ3.GBKH:A<XXIPKBH4P(YJ9RG9I:WWWKBIB=:/+HHB59F?KIPIOF2AM243LA3@/<?CC@>'8:>::979A@?0:859;%0(71'/)45420H<9+3.'60<99:8?4>8=>?2CO=S5<1.<;;/9<(52/=;9;DN+<-G?<A5@B2'94?9=8'C=%9<?8DS83GED>IDKHF.;?A8BC@A=*I/A,<:F:3CA=7(6.4A?2;8$+?$8C48I)UU#)64:9$;./8*(37@:?A,4C4J)OPF>8%4895.AB8<.<9*HG5RK@9=V'<>H'EAPK3VA?B2?R(=<9A4R3IBJ34SBIBXBKBKBM'L-[FB8R2>;5J>3.+<%14;6<?=H:AIA0::*GL-FE>$SA'6)5CB==I/SST&'MJ1N2$7@+:H$PB>=?G>WWJBJBI;A:=&P309A1&4@B(U??N6EEBJ-FA8D.5;53&HHL6RSBN-=-=UBJ:GKPKN3@%H(K4>-MKB=M4UJ5PFA93/CGB?VCK,N6')%,9NG&AK5VI?ANKPJ.7K1E4WXOH8><2;@./8=:\J:G4UA4M9[J+VJBH;)IHA0$E15'3%'?7,?FGB71,LA:4AEA=0H:J*OK@EC62,?
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2305/ccs/fwd np:i:11 rq:f:0.999136
  AAGCAGTGGTATCAACGCAGAGTACGGGACGGTCGTACTAAAATCAGCTACGCGATCGCCGACTTAGAAGGCTGAGATGGAGAAACTTGTCTACTGGCAGACCTCACTATCTTTTAGGAAGGTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAAACTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACAACTATATCAAATCGTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCCCGGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTTCTCTACATGTCCTGGGTGGAGGGGAGTTTCCTTGTATGGGTGGAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGGCGGTCATATGTGGGTATGACGGGTATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGACATCTCTAGGTCACCTAAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGGTGGTAGGTTACATCTATTTACTTCAAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCCGAACATGAACGATGGATAGTAGACCGGGAAGACCAACGTTTTTTCACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATAGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTTCCCGTACTCTGCGTTGATACCACTGCTT
  +
  ~~]f~~~h~}~~[0|`~dg~{~~~gl~~~_e~~M~~xe~N~~~~Vd~e~cQ~a~c~g~Q~~wQ~~~~T~x~b~~s~u~|~w~T~wR~~~~^~~f~~~fy~sM~~bzX~r~]\~~~u[~a~i~~c~`la~~ch~_~|~w~~~~~x~d~]~~d~Tx~6~z\j|~Bd~ba~~_~~f~`~~U~~~~~~a~~Rk~~~~c~~c~~~P~~z~~q~~R~~~~~~~d~~~P~~~~d~~~~ip~qa~|~v~|~~~_~~~~~bVX~~~~~~U~xb~~~T`@eQ~Y~~~SG~~kd~w~~~ffnn~`~~3~~M~~wZo\o~~ToA|~~O[~J~~~Y~hd~~v~P~s~~[bZu~J~~`i{~n~oe~t~g~dE~vd~~~A~~~bZ~~~O~~o~~~~~_K~~s~~U~dP~~j~@~~G~~~`i~~~|~~Q~\~~F~~~~~~ev~~~~O~nb~~f~N~~a~~~~o~c~~~x~~p~am~y9~U~be~~~~*v~_~~~r~~b~~~~~w~~M~~~~~r~_~~~l~i~>~yVu5~~~1~_~~~~X~~~~~~]~b_h~~Ra~b~~~Q~f~~~~o~~~w~~~Rl~~~`~~Jb~~Qw~H~~~~~~Q~J~}~bE~~~~m~~\y~~_~^~~~<~d~uR~~~`~~`P<~~~~~r~~~~]~s~b~f~r~_~\~|dr~[~f~~|~~R~=~~\~~e~~~b~O~~~~~kWq?~~~~~L~cG~~~c~~~~c~~O~~_b~~`~~~~~b~~~S~ba~d~~~~ls~u~m~~~ba~t~~~;~n|~~eN~~~|c~~~~s~T~~~c~~~~~b~~~~hw~~]~~F~f~^l`~m~~~~y{~~mESL~v~~~~~q~{~C~~~~~]~{~O~te~sb~M~]~~<~~o~~~~~mqVe~~k~~u~P~~~d~~~}~w~uau~c~xy~~vU~~TB~~nP~cH~~mC~~~o~'~`_aO~~Bv~~~d~~~~~P~~~~~~~~~t~~~~S~dw~~~K~~~~O~~n~bw~~a~`~r~}~~~~~~~~N4~[~~_~~_K~o~a~P~~~~~SLN~oaXM~~T~~~Z}X^UvY~~n~l~~U~d~~~~~~v~~~^z~~~e~~O~m~~~T~~}~~~~N~~~y~g{~p}8R{~aw~~~~~~~f~~O~~e~~tk~u~q~$~~~~zwrpu{~~~~~~~~~~~~~}|~~~~~~~~~~~fPCK]z~~~~m^~Y~|]e~~~~~~I~Y]~|\l~2~~~~~Q~]~a\v~~~}~~C~nY~u]`~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2305/ccs/rev np:i:11 rq:f:0.998747
  AAGCAGTGGTATCAACGCAGAGTACGGGACGGTCGTACTAAAATCAGCTACGCGATCGCCGACTTAGAAGGCTGAGATGGAGAAACTTGTCTACTGGCAGACCTCACTATCTTTTAGGAAGGTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAAACTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACAACTATATCAAATCGTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCCCGGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTTCTCTACATGTCCTGGGTGGAGGGGAGTTTCCTTGTATGGGTGGAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGGCGGTCATATGTGGGTATGACGGGTATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGCAGGACATCTCTAGGTCACCTAAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGGTGGTAGGTTACATCTATTTACTTCAAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCCGAACATGAACGATGGATAGTAGACCGGGAAGACCAACGTTTTTTCACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATAGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTTCCCGTACTCTGCGTTGATACCACTGCTT
  +
  m~]~~QW<{o~_z~~~^x~^~M}~~@~~|sErl~^m~~m<~~~juxVt~~y^~^~~w[r~M~~]~xVw~K}~X]~]~~?~~[2~~~j~NZ}m~~~K~wr(sr~~o~~m~l~M~~~~L~~~K~r~~~]m~R~7~~1-dq[3J~~L~~n}_~~o~~Mv~~~|Gk~~~x>~~W~LfQz<~~_V~{^~M~~e|~e~Zc~~~~~]~~NV~~~~mt~ZJ~W<~~R~~~Z~~G~G~~lMZ~~~~5~~~J~~]{~B~[\~`x~~^~~`~~^~~~_~x~~~Y~l~j~t~~m~OJwNaU<Fu~~M~f~~v~N~b~~~\o~_~~Kz\~~~^MQ+~~YYm-kv~O~p~~~~_j~Vu^Y~K~~L~~N~m~~it~-soa~sZoP~~~~Gl5~~}_~~e~~N~~b[~c~~MzP~~v~N~~A~~~@~n~_H~~Q~rG~~m~N~~~o~~~~~i~~r~~6~~~]y~0~~~~oR~~~Y~~~i~~~~~~_~d~l5~z?>Eu;~~~~]^~~b~j~^x~~+~nlJ~~~b~~T~e~~`c|@~kQ~;~xjY~]O~~v?~~~>~~>r\~~}yh]X;~~mnm_~~>~~j~la~y`ov~l]~~~w`y~Z7~\k~V~~~wB~~~M~VI~}~]zm~i~~~lZwwI|c~B~aH|Jt~N~~F~~\X~eVFtpF~v~~~~~~~~M]5~~a~jT~~~_oZz`v~C_;vH~<U~lN~~z~~w~]]s~~idx]~;~y~~~K[~~<~<~^~~xJ~~~~0{Gn\~b~`~StM~xY~K~Kp~~L~~x[~~l~~yi}I~I~~~~xl=W~l~w^wi~M~~=~~~~~`~~~~~~>~n}2rU~~~~Vi~~P\P~n~m-~~~YZj}4~x5~~ZY~_~~~Y}c~~R~Ndz~Q~M~~JKs{~~=~~mG~~~J~X~~~~z~~~K~~~~=~~Z~~~~S~.~kMa~~~~\5~~~o~~b~~kaC~Q~~asX~s~]~TR~`~~=~~~~~o~SaN~~~_=~N~~{iaW~~~WtqK~~~~dM~a~}~E~~b~N~~~~~~e=~~~~~j~~v~~~s~ay~~c~~~~Y|~~RAd/~~~~~G~~[`~@U>g~M~rP~_~w~C~~~ym~K~}]ih~~j[}~F~~K~t~~v~^xI~y_~~]mv~m~^m~H0~l~_%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{|~~~~~~~~~~~~~rZY1~~Yx~`~`I~`~~~u}~~~\~m~_~~T]~y~~YZyLFv_~?~x~~~~Yyq~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2319/ccs/fwd np:i:11 rq:f:0.9989
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCAAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCCTAACATGTTTAGGAACTTCCCCCGAACGTTCGACTCTGAGACACCCCAGGGACCGTACTCTAACTACCTACCTAGTACCCATAGAGAAGTCTTTTGACTTCCAGGCCCTACCACGAGAGGTCTAGTCGAACATCTTTGATAGTAGTGTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTTCCGTATGTGAGAGTAGTTGTTCTGAGAGTACCTTCGTCTACAGGTAATGTTCAGACATTCTCTTACCTTTCTTCACTAGGGTAGATTTCCCACAGACTACCGTCCCCCCTCTACGGTAGGAGTGATGTCACCATATAAGAAGTTACCCTAGTATGACTCAGGTCCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACCTACTCCATGTTGACCTTCTAATGACCACTAGGCTCTATACTTCTCAGTGATGTGTTGGGAATGGGACTGAGAGTAACCAACTCTTGTACCACAACGAGAGATGGCGGTATAAGCGGACAAAGAACTTGACACGAGGAACAGACCGTTTCAAGGCTTAGATGTGGTAGGGCCTATTCTAACCTGGCACCTCAGGATAGCTGTATTTGGTAGAGGCGACGGGCTTGTTGGTCTTCCACACTCCGCTCCCTACGTGCTGAGAGTGGGGTAAGAGCATGTACCTTGCGCCTCACACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  ~~~~~~~a~~a~~f~|ge~{~}~u~%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}z_~zys~~}u~~~~~~}~d~}~~@~q~vb~~S~||~vd~gxz~~~~z_ty~y{|~~f~~}~~~~~f~c~d~cy~;~}~~V~~f~t~g~O~J~~u~Q~~fa~]~O~}F~~~{~~~Dq~~~~t~}~y~f~~,~~~~h~~zu~b~q~e~c~h~~~vdvG~~>~~~~{v|~~~~{~v~}~~uzx\{HUzxK~~~Z~~~h~rc~a~~T~~~~gU~~}s~~~~u~f~~a~|Z~~~{<~~J~~`~|M~~h~r~c~|R~~i~`~~Xsrfj'}ya~~q~~}U~~~a~N~gY~~~`~~~g~<~mb~h~~v~`G~I~}W~~V~~~w~ze~~~~}{%~ld~~~>~~{~~~x~M~~h~I0|~hzd~x~C~~jz~l~g~~~|e~[~~~~~t~u{|W~~e~H~~~~U~b|~]~\}YO~~f~~~1~~~~~F~~~oK~ch~~g~~~~{~~rz~}f~Q~f~z~f~~}~~sem7~~x~{ky_~J~iG~~i~~~|~|S~~z~\~:~w~~B~~P~~t|z?~~~N~R~{f~>~~~~sR~v|Z~~eYx~~_Qy|w~IK~~~~N~~vw~|~~~~~~~{~~~u~~~d~~`{~vV~~~~t{~{_~|~:G~~~zKyt~c~vg~c~~~tu~~~Po|~h~~zoiu~||~~~~u~D~~|v~~~{`ywd3~U~c~~~w~~se~~~{~}~~tfw~}~|~~~}~P~~e~x~]~~|~t~m~P~~a~~g~~G~D~qR~yd~xg~h~i~|~~~f~}b~~~gt}~}~vt~f~{|~yw~{~g~ua~q{g~s~~~{~x~~~vm~~q~W~~gx~~p~]~<~~~sz~L~~W~~v~~{rdwrw~}~7~~~~~qxzn~`~~~e~~hz}~~~~~pP~gs~~;~{:~wY~~[~~~~x[~qz~~~~vh~~<~~~~~ut~~x~~x{~~~ye~g~u~~x~|Y}~~s[~~~y~~|~t~T~~~~w~ty~msu~}~`s~||~~~t~~N~|<~~~mT~qzs~[vS~O~~~~~N~V~~~{~xq~pJ~~~~~z~y~b~~}~1~~~~vx~t~i~~~~~~~~z~d~w~{^~~~i~~~t_~|z~Y~~X~~h~~q~X~~ys|z~~i~uN~~V~~U~~}~|~e~a~~~~~~~~d~ztTu~y~~~|J~~Y~U~~fj~~~|w~e~D~~c_yR~~~s~|~~~~~j~~f~~~~s~~~~~w~_byW~{~_~g~{~>~~}~s~~~yq`~9p~yq`~~C~z~~~z~erz|~}d~G~rR~~@~s[wbd~c~y~i~Z~A~~~~f~}~~T~w~P~~b~zre~cF~uJ~lR~fY}~e~~yb~~zo~~X~Tp~^~{ve~~~~s|~^~{h~~~6~W~{g~uztz}~V~~vU~~t~~~j~xvz~v~~e~{~u~~x`f~~~~j~w}~rK~~[~~~fkX~~}~v[~~{h~{W~h~~}u~S~~~~~wD~{~zc~~~~~i~{~~{~|~h~>~~~w]~b~h~~~yxtb~y~gm|h~~{u~~c~f~O~fD~z2~{e~~G~~~~~~~{~e~~t~~~f_~~}~~~f~:f~iy~z~}~z{w~|y~~~~@~~~~~uM~~SJ~~~p~~K~~~~~tp~~y~hgV~J~Ph|R~x~e~M~~~~+~~jc~~d~Y~bVst~~ug~`~~~}~{N~~~|~w~~vuVx|R~{~y~id%~`k~~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2319/ccs/rev np:i:10 rq:f:0.998365
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCAAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCCTAACATGTTTAGGAACTTCCCCCGAACGTTCGACTCTGAGACACCCCAGGGACCGTACTCTAACTACCTACCTAGTACCCATAGAGAAGTCTTTTGACTTCCAGGCCCTACCACGAGAGGTCTAGTCGAACATCTTTTGATAGTAGTGTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTTTCCGTATGTGAGAGTAGTTGTTCTGAGAGTACCTTCGTCTACAGGTAATGTTCAGACATTCTCTTACCTTTCTTCACTAGGGTAGATTTCCCACAGACTACCGTCCCCCCTCTACGGTAGGAGTGATGTCACCATATAAGAAGTTACCCTAGTATGACTCAGGTCCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACCTACTCCATGTTGACCTTCTAATGACCACTAGGCTCTATACTTCTCAGTGATGTGTTGGGAATGGGACTGAGAGTAACCAACTCTTGTACCACAACGAGAGATGGCGGTATAAGCGGACAAAGAACTTGACACGAGGAACAGACCGTTTCAAGGCTTAGATGTGGTAGGGCCTATTCTAACCTGGCACCTCAGGATAGCTGTATTTGGTAGAGGCGACGGGCTTGTTGGTCTTCCACACTCCGCTCCCTACGTGCTGAGAGTGGGGTAAGAGCATGTACCTTGCGCCTCACACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  N~URa~~a~s~t|{~}~P~wz~B^y&~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~|x~~[a~~zF~~z~xz^~fwx~}d~V~gy~~n~{sf|~~~~T~|~}~~}~~~|f~~v~~~}`~y~V~b~~f~~v{~~~~b~~f~h~~~_~$~KwQ~<{`~~eU~~U~~~z~vR~~~~|va~un}nb~~C~~~|g~|~f{R~~~c~[~q~tzI~~Z~~=~~~~J~~~vD~~qb~~~wlw~~~zT~~S~~~K~~fg~~T~]~|~}{~~|V~~ev~~w~`~zz~s~|~~~~~z~{V~~R~~w~}g~i~~gvq~uR~z~tv~~~(p~~~}x~h~A~~~Y~z~~t~|Pd~~zA~R~]g~x~zs~{b~e~~G~~J~~~~~zw~}vx~~b~d~~QN~~f}}~n~a~f~s|N~~f~f~n~I~~~_~{~u~[uxb~F~~~}~|y~~c4~~ex.~~~rig~|~T~~{re~~v~weQ~S~~~+~~~~w~PS~~W~~|Jt}^~|{~f~h~~z~~q~`~z{zvd7~}~~~~~Z~~}~J~~E~~}f~}g~~_|~~W~{{pT~~f~|~~~^~~~`~?~kS|3~~~~~4~y~T~{|~~~~~i~{yo~L~~~~P~~{b~~~~z`{~Y~{qk[~~af~H_~~{B~~~~~~~wx~~~~D~~~~~zM~g~~x~Y~~Vv/~~i~yy~Y~~{~~~}w~E~{~~{=~~~~~~t~cw~~~f~t~L~{|~uq~\~Q~~}|~g~^{~~z~~gc~~J~~c~e~K~~~~W~k~U~~J~~P~~b~+~~h`~~r~~z~~~~J~~~~a~~_~f~~|~p~pwa~*~xe~{~yz~S~pr~~~~~ao_v|~s~{]zg~~b~c~~yn~R~}w~V~~~~~~[~~2~~~|tGw|v~c~~~B~~~~~rym~dn~~~^~~~.~y~~~r~_~~~~er~~p~~K~pS~~~~[|~~[~tjt~\~h5~~~~~~~~~f~~~}~fw~a~~~j~~~xht>@~kgu*~~~~~yxbN~c~y~h~Ey~~}~~r~T~~yzXW~\~}~v:~~~~h~y~~t~~w~%~~~~hw~O~~~_~~g~~m~~~}~}~v|}x~~w6~~~~muW~zl~}~~zzP~f~b~}~~n~~~~~z|~^~~~od~~i~~f~~l~w~~{t|/~~T~~`~~Y~~U~~|~}~y~~}y{v~~~~u~{~p<~~~_x~f~~h~f~~|Y~~zsL~c~Z~~}p~Y~~p`~Q~nsCsS~~[~~cuTvu~}~e~{~`o~{~e~t~}wg~pp~X~~uv~d~{~s\~~`gc~z~x~~~~{`w~~R~R~~]~~e~~~r~z~asz~B~d~g~{~yv|~~~g~~~m~{i~~~}~~d~y]~u~~U~z|w~z{_~~~y~}m~~~Sz~~~u~v~xJ^~f~~f~~}y~f~kO~~~~~~mn~~~X~~S~~~s~x~m~g~~x~}~E~tx~e~~~~y|~~~~?~~s~rcfwN~zw~{X~~{U~~b~p~~||~c~~cuwsg~~z~N~~~~k~^~}~pt_]u~?~~y_e~v~y|~a~q~h~w~~h~X~~}~z~f~k~}~~R~~o~eM~~F~~~~~oz<~d~~J~~~~Yv~~r~~c~~uzvzij~zszo]~~[|~N~2~~~~~v$~~q[~~x:~<~~~E~g~zs~W~~e~g~{~~Q~|~e~T~~~q7~~~E~~t~k~d~e~y~{{{V~~>R~yH~~~~~~z~yn~~~U~Y~~~d~|wt~|c~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2333/ccs/fwd np:i:5 rq:f:0.992596
  AAGCAGTGGTATCAACGCAGAGTACGGGGAATTTAGAGGCCATAGGTTATGGAAAAAGTCAGTGGATTAAGATAGTAAAAGTCGAAATCTTTATATTCGGTTCGATGTACTACGTTATTCGCGACTGTTCTGTCATGATAGTTTTTTATATAGTCCTAATAAAAGGAGTTTTTAAAGTAAATGACATTTCAGTAGTAAAAGTTTAAAGAGCTTTTTGTTCTGCCAGACGTTCTGATAGTTGAGGAAAACGTGTGGTCAGCTAATAACTTGTGGTATGGAGTAAACGAAACATCCAACAGTATGTACAATCGTATGAGAAAGGACAAATCTGAAGACGATATTAGAGGGAGTCCAACAAGTTTGTGATGATTCACGTAAGGAAATCGAAATGTAAGATTATTCGTCAATGGAGGTATAAGACAACACACCAAGTAATTATACGCGACGAGTTTTCATGTTGACGATCCCTGAGACTATATCATACAAAATTGACCCAAATAATAAACTCGTTCCAATAGTTGAAGTGTTGATTAACACATTGAGACAAGTTGTCCGTACTTTAATCATCAAAGTTTTGGACTGACCTATAAATGAAATATTCGCGTTGTCTTCAGTTTAAGAAGTGATATTATTTTCGGTTTCAAAGCCTATGTGGAGAGATACAGGAAATAGGTAAACTATAACTAATATAAATATAACGCAGACGAAAGCCTGTTAACTTTACCAAATCCAATAGCGGGAGACACTAAACTTACAAGAAATGTACGGTAAGACAGGGAAACAGGGTTTGAAGTTTGGAGGTACAAAATCTTAATCCTTCACAACTGAATCAACATTTACATTCGGTTACGTTCGGGGTTTGTAGTAGTAATTGTTGAGGTAATTTTAATTGCACTTACAGACGTGGATTTGGTGAAACATTAATGTGGTAGATTCATATTTCCGAATCTTAATAGACGATTTTATGATGGTGATCGTGGTTTCTTTTCAAGGTTTGGGTGGACGAAAAATGAAAAAATCACAATTTAACGTTTCATATTCATCACAATCCGAAATCGAGATGGAGAGAAAGTTTGACTAAACTTTGTTACAGTATTTTTGAAGGCAATCAACCTGGAACTTTGGATTTCATCAAGTAAACACCCATATTTAGCGAAAATGCAAGCTAACTGCGAACTAACAAGGTAACTCTTTTTCGATTTCAAAATATGGTCAGTAGCAATATGTTAAGTGATCCATTTTGGAGGGGTGGGGATTTGTTCAATGAATGAGGCAATAAACCACCGCAACCTCTGTAATTGACGAGAAACTTGTATAAGGTCATCAAAAAAGAATAGATGAACATAAAGATTGAATACGGCTGGGTGAGGTTAATTCAGATTTCCCAAATTATGTAGATGAAAAGATGGTAAGTTTATTGATAGGTAAAAAATCAAGAGAGGGTAATAAAGAAGAAAGAATAATCAAAAGATAGAGCATGCAAACATTACATGGTAGTATTGTTATAGGCGGTATATGGTAAATGACGATCCTTGACTTAGTTTTTTACATCGAACGGTTGCAAATCCTAGCATACTTGATATTAATAGTAGATACTGAAATATATCTGAGTATATCAAGGGAAATCGAGATGTACAATAAGTCGAGGAAATTAAGGTCAATTTAGTGCTTATCATAGAAATAACTACTTAAGCCCTTAACGAACTAACTCAAATTAACGAGTAGAGGTTATTCTGAATTGTAACGAACGTAGTCGAAAGTTTGTTACCAAGGGGTAAAGCCAAAACAAAACGATTTGACAAGAGAATCTATTCCATGTAGTAGTGCGTTTGTACGACGTTCTATTCGATGTAAATCATTAGGACGAGGGTTTGAAGCAACTCGGAAAGATGGTCGGTTAGAATTTAAAAGTACTGAACGGAATTAACGAAGTTGGCTACTACCTAATAGTCTTTGGCTTAGGATTTAGTAGTTCGCAATTGGGTCAAAGTGGTCGCTTTGGTCGTCGACGTCAAGACTCAACAAGTCATTTACCGCTGTACGAACCATCTCATTTAACAGGTTCTCAACCAAATAGCGGTAGGAGTAGAAAGCACTTACCATCGTACGAACTTTGACAACGAAAGGTTCAAAGGTAACCAAGGCGTAGTAGTGAGTTAGGTCAATGTATAAAAACTCCCCTTTCTTATTTTGAGTCGTCAATGTAGTCGAGAAAGTAATGCACTTAGTGCCATTATTATTAGACAAGATAGTCCCGTTCTTTAGTCGAAGTTCTTGTTGTAATATACAAAAGTAGAGCAGATTACGATCCGAAATTTCATGGACACAGATATTTTGAGATCAACATTTGATTCGTTGACGTATTTATGTTGATTCGGTTAGCGAGAGTTACAAAGTTAGTAATAGAAAGAAAGAGGAAATAATAATCAAAAGATTAAGCATGCAAACATTAAGAGGACACATATGTTTGGTGGCATTTGCGTTGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  c~YLTIh?~krh]PxOZdYV[Xmsf4~wh6u?k~\ZrJ~RlYeWL~[~Fc;c9y~~qXUfqGkGsPTj+^ZakaZj)o`dXmgZI~~dPB~~mh_V^&J~M|eYYiYTmMZTZWK{EF~bVaXC9?WHsPlZkN[UYIefX/~p`pbDipkp[jCsWL|j7{u_H~ZE'ksn::ii@hE_g>IFTBAr`IPEdWVf)K'.@;no%W?E3Yf7~~~oZCoWm[FwUW0bGYlafY]krY[_YsI~BuwwQYlZk9~iP\XciNhj`~f]~WnG~g`lL~\Zm6~xfZ'tW]oYR~T|UrZkIhUcB;.2SNFX<ZM^LEdm4_]]I|~l^aX:sTSLYqgTG~nV]6~ZGXlQm1ycQmHE}~YnUVmXECdPqfZmb~G~Fs~lfY4t^SYh.dZsUj[7vfYSMMqaEjs=iVqgSzZI^N~e]erT~V~ZlP~\~ogQRXPDAMZsW<`pZ8+^Z5|DO\CDUE{~lZlX[b`G]FeNhVk6;_IZYe7WA=jH~~lO~lF~~fmfYI~DzR~lqM;bX<zZ\[JjD[Y~>ed`fcOzX0W1dV~YM}ZkC|Zm]QR}~P~lekQN>b_THut_F~@cmY]T~ijjFk~lX7chXm[~fYgX^~ZeMFTMGZD~~O~V[sXhDO__^me7nnofEWJOuS0f92RYi?\[lL~VVjV^iYL^>q-^D9[BV&;eiV]_URe[ZQoaWO2`PZBN'5>E-?,UXS,bQQ1[I2=q6ZN>DY7DnFqf^<m+biiGZ6r^GYgQhUk:{V:IkCI?gY+wslZnsgL~lLpURaq>~~<Z`SJ>~~5pdS5[0Di{I~sL~laU.sice\It9fhB|\~aE9*Z]UZa~lfBtT_B~~\esYqa2~]lrf[J~d/~~PBx~[irZmsYS7^JyYMyY[8~k[]Ex~wBgKrDLe]Z}`FGIZa7T>kE3\Z=hjFGvc7EST&mkWnK~mYFVGyNVkqC~~V~YDrVWJ`.lbDV\e\q1~~i;[Y]kL~gYlM)YlI~Av_eDpO\8MzJ|P~l0~yjIy^\S4imu]OU'opm\_Tb[a+^Q~~Q~gZC~~e`\_9\fpTS^9IVP2zZFuaWL-cYBdI~[UFW&wzVPs`W]cQGj~fQ~|E\~sflRVq%}}qB@'p;fSQwkeCnSelI~AzeA~tK~\Q~~]AhQQ{XT>otdl:|}oS[C}v[FeZO~~~lYPRLQ>i`~PlXMKKcPRMjMTkInE:N@BD.n]a{`V\@_vd6beykrgJ~UbYQ8m[eP~g^f[Y~O}JmDfRBcqH`t}L~]9~~~l9~~r^LsTBFqMPvl[a~mZsH~9[~i*y^V~rJkFdP~T~kaPYhIY[~XFeY]YGklTMU7(FVLZ?h;3gf]&Xkvt30HveVXFTXFOHjZ@HVKb2]E5b[@JJyRa;vV>Ug@]DpIT3{KVCFGc`.HU7fc@ui_KMaZaaZ2lmiLijDuB1P&5@jL<YH<Z\7q<$c]\gbT\F[@]Qf-ylNGoU,iiYN`J.OJMAE&EqjO>xHEXElqZoBEML9<G}~fqM~l9e[I~fWTPjBwHXd0]>=i3DjfhbjCB]Z6eVWXlfXb^UuDv5EI7bXI/fY^]LYdZkfZQ{RJ|Y[DdE~y`PyQ^Za`moJM{UUkq]zV~\SRcgRbX][bQ0oeRaS]/U]SgS`JW(:I@j3da8SBCD2`7MLOI)J:h`OaLUC4R>`)OOB\FpCyI?,L)MMSO4(E?Nf`D8^OQAmn_6]Z`NXAH0bI)]\>]Xr[P6g[bFs\b\=[nAcEk[PK9KXMf@a7Y>6aA3LCZJF6R$@FM;TTOZQNC5;%PCM9cPLMM?7Q2M&L&)\,dTCLm<qqq[@ThaDQgKrrQR[KjQPQFmO\OeAq?h=J9I_O`RRaR\SHrmNHOYNY<PPiBJ=0pYL5_RU7MKYTOEV\<cBT;/0`]:RWN0O<[XsZ`Z)i+G\LOX=[YVEh8CHA5SG__EdfePK8@/P1^I>S9LO\5Q,,0LOBpAe\bd[]VJqbHsagQPI;UU-\WQrgEj;>rrd<HeSBqZ=[JrOc.Yi`F?kmLD-k(+PWIni3ya\S[-Pg\Rb[BRRa\b\O_EGkRb\gGuugMqR\bR^F:QXrMqg`FJ[g6tG3lXdFxNbWW*&J2W&NNPM<?1S^PCaeRafQ0noPB>U0idOugb\RaQ\RUnSIrcKF*DcZE5gWD}Pp\?qY2y_Fq*HDoBdFRbgS`RQ^(M.SreCyHEJuaPG9_.bssh\a*qqC<qqGRke0rcG49@2A<^DI\VH]WM\C*AN'beN[&HIK=PFRrQQI>M_L?W$BXPDa\1HC?[PbadO]'OINR^T.QSQLV[QFpQBq\PQ;QURU<Y>S&*X3\\ZQMNQ`<[e=dER(YQMY4V<?no=riB6P1kQSORQMHQO(bURP]QIYVInNN8ecR`?lYQOcQ(EQ^S:qmd]Q2nPNPRADzTraM0M^RgQAne\DWYDQeX=I%QCOM=`^Q?^\P\Ad=\=N5T`K_HC.o`^QgTqAiO0KP@?;WXFL?lJcRfC{fX8ZbDE\P:%L5r_8iHQJrrR\QBqQ%HG`nppppppppppppppmfchnppmbLEZGQVF]RZ<AoQdI;>]eYJQWZs
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2333/ccs/rev np:i:6 rq:f:0.992344
  AAGCAGTGGTATCAACGCAGAGTACGGGGAATTTAGAGGCATAGGTTATGGAAAAAGTCAGTGGATTAGATAGTAAAAGTCGAAATCTTTATATTCGGTTCGATGTACTACGTTATTCGCGACTGTTCTGTCATTGATAGTTTTTTATATAGTCCTAATAAAAGGAGTTTTTAAAGTAAATGACATTTCAGTAGTAAAAGTTTAAGAGCTTTTTTGTTCTGCCAGACGTTCTGATAGTTGAGGAAAACGTGTGGTCAGCTAATAACTTGTGGTATGGAGTAAACGAACATCCAACAGTATGTACAATCGTATGAGAAAGGACAAATCTGAAGACGATATTAGAGGGAGTCCAACAAGTTTGTGATGATTCACGTAAGGAAATCGAAATGTAAGATTATTCGTCAATGGAGGTATAAGACAACACACCAAGTAATTATACGCGACGAGTTTTCATGTTGACGATCCCTGAGACTATATCATACAAAATTGACCCAAATAATAAACTCGTTCCAATAGTTGAAGTGTTGATTAACACATTGAGACAAGTTGTCCGTACTTTAATCATCAAAGTTTTGGACTGACCTATAAATGAAATATTCGCGTTGTCTTCAGTTTAAGAAGTGATATTATTTTCGGTTTCAAGCCTATGTGGAGAGATACAGGAAATTAGGTAAACTATAACTAATATAAATATACGCAGACGAAGCCTGTTAACTTTACCAAATCCAAATAGCGGGAGACACTAAACTTACAAGAAATGTACGGTAAGACAGGGAAACAGGGTTTGAAGTTTGGAGGTACAAAATCTTAATCCTTCACAACTGAATCAACATTTACATTCGGTTACGTTCGGGGTTTGTAGTAGTAATTGTTGAGGTAATTTTAATTGCACTTACAGACGTGGATTTGGTGAAAACATTATGTGGTAGATTCATATTTCCGAATCTTAATAGACGATTTTATGATGGTGATCGTGGTTTCTTTTCAAGGTTTGGTGGACGAAAATGAAAAAATCACAATTTAAACGTTTCATATTCATCACAATCCGAAATCGAGATGGAGAGAAAGTTTGACTAAACTTTGTTACAGTATTTTTGAAGGCAATCAACCTGGGAACTTTGGATTTCATCAAGTAAACACCCATATTTAGCGAAAATGCAAGCTAACTGCGAACTAACAAGGTAACTCTTTTTCGATTTCAAAATATGGTCAGTAGCAATATGTTAAGTGATCCATTTTGGAGGGGTGGGGATTTGTTCAATGAATGAGGCAATAAACCACCGCAACCTCTGTAATTGACGAGAAACTTGTATAAGGTCATCAAAAGAATAGATGAACATAAAGATTGAATACGGCTGGGTGAGGTTAATTCAGATTTCCCAAATTATGTAGATGAAAGATGGTAAGTTTATTGATAGGGTAAAAAATCAAGAGAGGGTAATAAAGAAGAAAGAATAATCAAAAGATAGAGCATGCAAAACATTACATGGTAGTATTGTTATAGGCGGTATATTGGTAAATGACGATCCTTGACTTAGTTTTTTACATCGAACGGTTGCAAATCCTAGCATACTTGATATTAATAGTAGATACTGAAATATATCTGAGTATATCAAGGGAAATCGAGATGTAACAATAAGTCGAGGAAATTAAGGTCAATTTAGTGCTTATCATAGAAATAACTACTTAAAGCCCTTAACGAACTAACTCAAATTAACGAGGTAGAGGTATTCTGAATTGTACGAACGTAGTCGAAGTTTGTTACCAAGGGTAAAGCCAAAACAAAACGATTTGACAAGAGAATCTATTCCATGTAGTAGTGCGTTTGTACGACGTTCTATTCGATGTAAATCATTAGGACGAGGGTTTGAAGCAACTCGGAAAGATGGTCGGTTTAGAATTTAAAAGTACTGAACGGAATTAACGAAGTTGGCTACTACCTAATAGTCTTTGCTTAGGATTTAGTAGTTCGCAATTGGGTCAAAGTGGTCGCTTTGGTCGTCGACGTCAAGACTCAACAAGTCATTTACCGCTGTACGAACCATCTCATTTAACAGGTTCTCAACCAAATAGCGGTAGGAGTAGAAAGCACTTACCATCGTACGAACTTTGACAACGAAAGGTTCAAAGGTAACCAAGGCGTAGTAGTGAGTTAGGTCAATGTATAAAAAACTCCCTTTCTTATTTTGAGTCGTCAATGTAGTCGAGAAAGTATGCACTTAGTGCCATTATTATTAGACAAGATAGTCCGTTCTTTAGTCGAAGTTCTTGTTGTAATAACAAAAGTAGAGCAGATTACGATCCGAAATTTCATGGACACAGATATTTGAGATTCAACATTTGATTCGTTGACGTATTTATGTTGATTCGGTTAGCGAGAGTTACAAAGTAGTAATAGAAAGAAAGAGGAAATAATTAATCAAAAGATTAAGCATGCAAACATTAAGAGGACACATATGTATTGGTGGCATTTGCGTTTGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  0RTR=VM8A?9%Q@fOT:_ZIZTaR5rnZEm&U[_F\Hj)T_J;n?dHQ,W1-;`XIAJIJW=FV@XDHLO]TR:\U[Z;P\HssgR@ohHKHARONsWqR]\]CGaQ:YNTI`_JeHPFNNDPH3P<@=)DA/QCNM9G5\`abSac]K`ZL5R8RrgAss[;o]W8WNP_GpdNeIUZRW\/26KB:^Z6GELBbgcT=DYSmUE@N'ZSB26N&XQRD&t]F^=Y&96@>H^IC0]UI:oArkYPKUJ?2]_Rb\QQQnTTrSEpZMKqO``7n\@8>rqQ\Rp?]gC^>bQa[L^MZfbRTrgR\bRg\b\HiR;o`R7qYGQ40Ph?F<ZbgaHsa\a9sq`ZK4`AkQAo[Orr[Q\bg\\ASObR[;PR(T&[HHKFJrrg\gUrYTUr^BQNBdRTre=Y`IeT[&QpFLRCkQaRaFuTrYLSrJs`5NR\QF`R\b\1rr`RbbQJd@\)USg>~kNI71^Re]TFLP48PQ@espJt\a/zk9cqeTsN;ljSgR\FpF}Psd_\6k[TrYOW)iBQWk/mPaQISpVaZUP?Q[Jq\T2yXQ]OMcrTrgR^TRKrr\;qqpKmTReEHEzbRQEJJf\FNde`Bm<X;X@REdRXrR^RGjhKpTMj@5Z^dbJqa;qqh;HR+eOOQrWBy`\QZPA_SLNHKIM;X*Q;dT$FH1,_H[Q;\\PSrSd>fW\Q,_^MDK^S\Sb[bQEBYE@mF.DhAqQNrrb>eGpp[7_>mrf`F?=^i`G\NcPgGsoQ5[_RQnRKrrg\d^:HofDs[bRa8qpGspRbBiTDts\Tr\?kT=q`KS&^R?pqV:PFkRr;E|XrSbOPcP_QMZbHEWQI?pq`S`FpQNS%l_QFWrR:qcU=oo[M_EJP[QOR7pZFp[bMqfDn81EfTrXsYNHPXrbRb\`R[gMq`0o\7bRZ'fa@>^EmQNFG<\&[0]GVC`f_6dH5bV?q]7RcTrg]F\RYTFrrr\b\bgJ]Q[`MQYRLtNrpR6nraOTrNtD_V5K_7j_=ZBqaQ&<0WncScRQ_S?d5bc7teR\@_nQafaGpQaN8GOO_RDO2HjqRNV]Raf;QNJ&H@ZqVAbgOWRV=aINLTj\CRaRb\RQ/diiQDAqLqQEqeSCqFz](rZOrSAqmLq[9ZQNbgRTr]f>rdO1=]\Dd`3fp`\R]1ss\OEQTr\RgSp=NX>BSpRfKh(CS;ZR1YG:J'TUVZNFL3V;(4SXb8FH=b?KJ=VXOM@gMOOJGQ9Z@MO;A=X'+AEVC`36e`R`.WbfZ-0FVCROSrMWMbPZa;U0<>]%S65[A?^D*@P/lSST[QO4S^UbR\^]EsnO%AF`KPC^B`TS`FQ-SUjY5eQW>0c[FpJMa)QOT^QnV5jf^H,W=W9WS:CJ6B=T+R/H'DD[%\P,\]:d`;2I4%9G6ZBK+_d=ML*lM3W/3e_Q/;PUQ\)HNK,dSIUH>A>d>7<++KSNDZZ2hWG1DD+TVMBfO<\P<4_mfSU6EC_ZS]LZR0rr_RbJubR`A<XUaY]aFlQGlRQbKRQLg]LN]5^K]Q6_UC8U7RagBeMdN`Q@LVS*^bddj[Q`OQESmOIPD_LMDL_gF~gaX:]OJM1lH;NH7YSfPHCe`DH_^N^?:h`K[OZcSO[b\faeJO<@E)od;qreR\b\_8YfPPORigTrXMPF]DX9gRWrTsKQ'PDoNrraMbMI6JE%L`g^R2GL[;_SgbRGp'oHF>}dFpRp=ZTpOE;QMgQ-q[/NQqS\^<TOb[bKf&^LdS_@EhI]J;GPFQqONcPHRQ\?]F?ao[XrbCjNm'^^N<FOG5U)VXiP(UQOPEHGq]B^R+KJ[B?_`QIXFfD}aQWO`\Q`]]]R\2th[R`R\^)WFlL;YPnQNRQ[e=rlRRKUpELsbRX^CjULrqVSs\SSp=NP;o7tjYTd+eNQ@H)U\\E<;%Xg?os_BP`Rg\ToI=YRbQTMbR[=dEOhIjSeJPgbB{bAX=a\bSMroGPSm^IqI/TW`\g^Q5eNY:?lQT)TRSQE`2@V;U5N<D1R_>C(AIM@?ZOIUPFI4I=MPBpQTp[^Na'n[\7rXLPQAGQANpGuXNABQPAbeSmPKKaSf>_CDcC\;`oQP[P<cLD9p_ZRP77EOD:]ODgbCyHNQ[LPNYQW.AQZ\bRSp?ZKrr?^GqQ?qqMsM@o8r=F,mNHVb\g^RQXT\R5_HWdRTseFd_Q%ppppSRg>~n.i]REib@ssqYT\gS\Q=SoKLFHWcQ/T8<dT[Q_OZSbRGf`[\HBcJEpaVo\AV[EaR@^F`gb\gD}[/MN<Kca\QQ]Tr\EmSUp[3n95SsM@oQ5lfREeb\^WRa\^2e_R\bgC{FJrp<ok<HdLp3;^Q`UbfKFar\b\L%QQQrP_BtaD^FpQ\Hs[bR\gb2tnbdC4]P3Dc;>YFmIY=Z_WNWVrKP2mgZ=IVDIYf_F@qgI6ieZI:oHsiH9f%TTrfQ5mnhXIDpAq[SaR[S0qoQaFp@^F`=pZ;IQ`cJa\faC`Kqf>hK[D]gT?S&]DF$nppppppppppppppppppppppppppnIG;^RcSK\R\6k[aIVBu^OQ[E7I
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2334/ccs/fwd np:i:10 rq:f:0.999059
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGGAGAAGCAAATACTTGGATACCGAATTTAGAGGCCATAGGTTATGGAAAAAGTCAGTGGATTAGATAGTAAAAGTCGAAATCTTTATATTCGGTTCGATGTACTACGTTATTCGCGACTGTTCTGTCATGATAGTTTTTTATATAGTCCTAATAAAAGGAGTTTTTAAAGTAAATGACATTTCAGTAGTAAAAGTTTAAGAGCTTTTTGTTCTGCCAGACGTTCTGATAGTTGAGGAAAACGTGTGGTCAGCTAATAACTTGTGGTATGGAGTAAACGAACATCCAACAGTATGTACAATCGTATGAGAAAGGACAAATCTGAAGACGATATTAGAGGGAGTCCAACAAGTTTGTGATGATTCACGTAAGGAAATCGAAATGTAAGATTATTCGTCAATGGAGGTATAAGACAACACACCAAGTAATTATACGCGACGAGTTTTCATGTTGACGATCCCTGAGACTATATCATACAAAATTGACCCAAATAATAAACTCGTTCCAATAGTTGAAGTGTTGATTAACACATTGAGACAAGTTGTCCGTACTTTAATCATCAAAGTTTTGGACTGACCTATAAATGAAATATTCGCGTTGTCTTCAGTTTAAGAAGTGATATTATTTTCGGTTTCAAGCCTATGTGGAGAGATACAGGAAATAGGTAAACTATAACTAATATAAATATACGCAGACGAAGCCTGTTAACTTTACCAAATCCAAATAGCGGGAGACACTAAACTTACAAGAAATGTACGGTAAGACAGGGAAACAGGGTTTGAAGTTTGGAGGTACAAAATCTTAATCCTTCACAACTGAATCAACATTTACATTCGGTTACGTTCGGGGTTTGTAGTAGTAATTGTTGAGGTAATTTTAATTGCACTTACAGACGTGGATTTGGTGAAACATTATGTGGTAGATTCATATTTCCGAATCTTAATAGACGATTTTATGATGGTGATCGTGGTTTCTTTTCAAGGTTTGGTGGACGAAAATGAAAAAATCACAATTTAACGTTTCATATTCATCACAATCCGAAATCGAGATGGAGAGAAAGTTTGACTAAACTTTGTTACAGTATTTTTGAAGGCAATCAACCTGGAACTTTGGATTTCATCAAGTAAACACCCATATTTAGCGAAAATGCAAGCTAACTGCGAACTAACAAGGTAACTCTTTTTCGATTTCAAAATATGGTCAGTAGCAATATGTTAAGTGATCCATTTTGGAGGGGTGGGGATTTGTTCAATGAATGAGGCAATAAACCACCGCAACCTCTGTAATTGACGAGAAACTTGTATAAGGTCATCAAAAAGAATAGATGAACATAAAGATTGAATACGGCTGGGTGAGGTTAATTCAGATTTCCCAAATTATGTAGATGAAAAGATGGTAAGTTTATTGATAGGTAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  |~~S~~~W~zktb-~e~v~r~o|WvH~~~~h~~zV~~gb~~~|fi~i~i~~P~J]~P~~fn~o~c~W~if~d~~aX~2~~~~~{chk~j~~x~y~m~~~w7~~~~xN|i~~ax1~~~~io~dh~E~l~~{~{~uv~zpa~zN~`ov~~Rj~V~k|~zv~~~~~~~+~~~~~~~~swA~H~~m~|F~~~k~~~0~~~?1~~~~k~~~}~{~n~~i~~qp~vP~~~o6~iV~@}n|H~~~~o{~}~qP~|~dv~g~;v~~~rYh~~v[~I~t~x~z~~^~}fm~Qvl~ck~|]~~RE~~}nN~o}~Un_ftY~Oj~U~j~|~~~~~~~~gQ~~}uvT~~~~G~~g~]{U~~~f{~h~m}{~D~~y~]`~M~~~~~^~n~dX~~8~~~{}K~~~Sbe~gmzV~U~>~~~{~:~~~~z|~~|x~}l~|~~fs~~f~gl~}~~I~xjTf~`~[hJ~^~~~l~j~i~|aYupizzo~T~~~xi~~~~~~y~~~X~~~~~~~h~Z~~{{~y~y^~~~|~~~W~~l~~~y~~_~~f{{~[~W~^~~~~g~Tg~o~ni~Z}X~x~tye|m~~~~OwX~~Y~l~]~~~~|]~~Y~~d~~PZ~~lS~~~?~~h~~~c~~~~M~~~~`~~~~j~|~clR~~~xq~a{~[~~j~~I~o~~U~~h~~V~~~hk~T~~h`~~c~|~~~~V~~~~~qbdTj^~]~~~~p~~P~~g~~~z~zxS~yg~K~~~r{^[~TzYcm~n~~X~~~V~{~|]~~gN~?~~~T~Q~~~~~yD~~~~~e~QxZ~~um~~}|~~`~~~~~p|p~~n~~EU~`~~`~~mrS~~G~~qT~~E~~i~~o~~xcD~~~~|l~I~~X~u~u~zi~g~~~~xt]~f~a~~~c~g~^CmS~~dq6~{D~~~h~~~~~~~~v~{~Y~~k~o~k~~k~^~~~+bd~Xy~{l~~l~~~wm~_~~Y~~\~~~U~~l~x~o~~~k~y{m}x~U]~`F~~S~vs~~}}~Z~~~~~tm{*~~YU~~~|W~{~~ztU~e~C~~|M~~~{\~m~^~~L~|l~kh~%~~~~~0~~~~|y]^\dr[~~M~z~]~~ef}~z~g~s]icd~ic~~I~~~0e~zg~U~~{bi:~~oi~~V~crR~~gk~~~j~n}~~~y;~~~~~X~n~|j~~y|~`~~W~m~ze~~Z~~_~~x~~gz~p~N~~RvF~~~~}b~~i~S~W~~~d~mC~~{~~~k~~}~~~bcX~WExj~~|~w}w=~~~~yn~Q~~yZ~~~~~~_~~e~kz~tjm~}~~~o~T~vaz~~f~~X~~~W~~@~~u~K~~~uDv~mg~wV~~~c~~l~[~hk~~l~~S~~c~~z[~O~~c~{|X~c~vOL|fzO~~ui~~~~~k~l~~}~~c@~~~~~Z~z~~~~~z~d~~i~~nfh~~n~~~`j~NdR~~~~|h~e~~~syy~~V]~~W~~l~~d~i{~|~~}~~M~~~jial~|Y~~S~~~m~~~~eB~[%~~~~~~~~~~~rfa_l~~~~~~vp~~~~WfQg~Wx~y~nj{~K~ml~~}~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2334/ccs/rev np:i:11 rq:f:0.999183
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGGAGAAGCAAATACTTGGATACCGAATTTAGAGGCCATAGGTTATGGAAAAAGTCAGTGGATTAGATAGTAAAAGTCGAAATCTTTATATTCGGTTCGATGTACTACGTTATTCGCGACTGTTCTGTCATGATAGTTTTTTATATAGTCCTAATAAAAGGAGTTTTTAAAGTAAATGACATTTCAGTAGTAAAAGTTTAAGAGCTTTTTGTTCTGCCAGACGTTCTGATAGTTGAGGAAAACGTGTGGTCAGCTAATAACTTGTGGTATGGAGTAAACGAACATCCAACAGTATGTACAATCGTATGAGAAAGGACAAATCTGAAGACGATATTAGAGGGAGTCCAACAAGTTTGTGATGATTCACGTAAGGAAATCGAAATGTAAGATTATTCGTCAATGGAGGTATAAGACAACACACCAAGTAATTATACGCGACGAGTTTTCATGTTGACGATCCCTGAGACTATATCATACAAAATTGACCCAAATAATAAACTCGTTCCAATAGTTGAAGTGTTGATTAACACATTGAGACAAGTTGTCCGTACTTTAATCATCAAAGTTTTGGACTGACCTATAAATGAAATATTCGCGTTGTCTTCAGTTTAAGAAGTGATATTATTTTCGGTTTCAAGCCTATGTGGAGAGATACAGGAAATAGGTAAACTATAACTAATATAAATATACGCAGACGAAGCCTGTTAACTTTACCAAATCCAAATAGCGGGAGACACTAAACTTACAAGAAATGTACGGTAAGACAGGGAAACAGGGTTTGAAGTTTGGAGGTACAAAATCTTAATCCTTCACAACTGAATCAACATTTACATTCGGTTACGTTCGGGGTTTGTAGTAGTAATTGTTGAGGTAATTTTAATTGCACTTACAGACGTGGATTTGGTGAAACATTATGTGGTAGATTCATATTTCCGAATCTTAATAGACGATTTTATGATGGTGATCGTGGTTTCTTTTCAAGGTTTGGTGGACGAAAATGAAAAAATCACAATTTAACGTTTCATATTCATCACAATCCGAAATCGAGATGGAGAGAAAGTTTGACTAAACTTTGTTACAGTATTTTTGAAGGCAATCAACCTGGAACTTTGGATTTCATCAAGTAAACACCCATATTTAGCGAAAATGCAAGCTAACTGCGAACTAACAAGGTAACTCTTTTTCGATTTCAAAATATGGTCAGTAGCAATATGTTAAGTGATCCATTTTGGAGGGGTGGGGATTTGTTCAATGAATGAGGCAATAAACCACCGCAACCTCTGTAATTGACGAGAAACTTGTATAAGGTCATCAAAAAGAATAGATGAACATAAAGATTGAATACGGCTGGGTGAGGTTAATTCAGATTTCCCAAATTATGTAGATGAAAAGATGGTAAGTTTATTGATAGGTAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTTGATACCACTGCTT
  +
  U~um~ahQ~l_~~`~~}n~w~b~~~A~~~nN~~{^~gnI~~~|~c~Z~~w|l~~}~M~~|i~;~j~~~~M~|~~mT~I~~~yR|~~x~N~~{~~y~~x`~\~~~z~]w]~~U~^~~dypX~~_~k~~z~~yC~o~~~iX~~y~ky~z~~~|{~~mf~m~~yy~~|3~~~~~ykz~~~~m~~y~~V~~~R~uf5~~~~R~~h~_~~~i~~~L~~c~x~~d~X~~~y?~~f~w~skL~~|~a9~~~tj~yz~~xt~u~w~~~@D~y~U~L~~~~|oz~T~~~mygSu~~z~~d~yh_~~~~K~~{n_~~~~~~~|hl~~~p~|~nquk~~o~~~|~~p`tbd~~b~~s6~~X~F[j~M~~x~h~X~ao~9~~~c~i~h~~j~}W~~zXf~vbjn~~~~g`l~P~D~~~mg[~~~z~k~|~|~~f~t{~~m~~f~~a~~~~w~zo~(~lzlYS~q~{~z~^~yi~~}~}~~}~|>~~~~~~jo~|~~{yo^~~~w~T~~~~~~n~~X~yE|~^;~j~O~~]~~~}~~L~~i_~|m~j~x~~~mp~mm~{~{\~j~|~|~~z~~i~ezf~~l~{m~xlT~uk~~Z~~~~~X~~~g~~~N~~~\~~~|e~i~~z}Q~~~zN~~~~F~~|~}n~S{~|~m~}l~~g~ui~`cqy~~k~~?~~~i_~o~~~E~eo~~~|S~d~~~~l~~~~~f~_~~~~a~m]~~~~b~v~~~w~~~~a~~~~~~~z~~}~~}g~PW~~<e~f~pe~~~m~m~~~X~l~~~~|~O~~~q~~~z@;~~~m~~~h~kU~~~|~~~a~~F~d}ozC~~l~~~~M~~P~~{|~g1~~S~~V~~~~K~~~d~n~y~~h~u~o~~f~|tKa~~~K~~~d~~}p~j~k^~[~~pce~|=~~~N~]fdfx~~j{t~n~vm~y~P~~x~L~~~c~c~z]~~[~~~~a~DRh;~~E~vS~Vme~~~~x~~~f{a~|xs~~~s~~~N~~U~}~~~~|~{~~~h~oe}>~~~~f^~~K~~q~h}xUb~l~~~[~ww~f~c~S~~D~~R~~lva~~~UxB~~~~~~~~TY~Q~~~~~{O~~~}~~N~p~~n~n~~~Z~]i~~lmy~N~~f~~y~yn~~z^~~g|~~E~~~]~~iE~~p~f|~/~~~~yl~^~mz~k~V~h~~T~j~~n~~d~~b~~o~n~\~{~?~~~|O~~g~w]~~~qozN~~~~i~k~}~~V~~~R~y}~~jU~mX~`~=*~ej~5x~~~Yw~A~~~N~~~~~{O~~evym~ym}~~~~Rm~|~gnxr~l~~:~~~e~~K~~~~/~~~~c~ze[~~v~~{{~~dwO~mU~yY~~]~~_~{~A~o~~~~W~{~h~\|mR~kS~~~~~wv~kk~M~m~~~~V~~~~|y~~~||~}f~~~~O~~x~l~ne~m~o\~~~P~~o_~b~~~z~L~~|{~M~b9~~n~~u~`~l~~}~~~>~~~xf~b~~Z~fU~~~f~|~~~^~~$~~~~~~~~~~~~~~~~~~~~~~~~~~ttb|~~~~o~~(~oo~{~f~~~~q~e~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2359/ccs/fwd np:i:8 rq:f:0.993299
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGGTAGCATAGCAACTGTTCTGAATGTGATATTCGGGTCAGGCCACGTTGACACTTACCAAAGCAAAGACAGAAGGAAGTTGACGGGACAATAGGGAAGATTGGCAAAGGGGATTTAAACATAGTCCAGTTCGCGTGGTGAATGACAGATTGCTACTGTTACCATTGGCGATACTAACGTTGGCGACTTTACTTGCCTCGGTAGCGACAGAACAAGTGTCGTCTACGCAACGAACAACCAGCCGTGTTAGCTGCAATGTCCCCTGTAGAAGACCCTCTTCTTTCTCTTCTGAATGATGTAGCTGTGGATAGAGCGTCTCCCACGTTAGGGTCTAGCAACCCTCCGGTGGTGTGTGGTTTCGGTTCGCTTGGTTGGGTGCCCAATTTCCAGTACCGAAGAGGTAATTGCAACTTCAATTGCTTAGTTGACGTGACCTTTCGGGTGTCATGGACTACCGACGGTATCTCATACGTGACCTCGTTGTTGACCTCGTTCTTCATCTGCACAGACTACAACGTTAGGACTACGGAAACCAGTGTGAAGTTGACGGACGCGCTAGAAGTCTGACACTGGACCATGCTTGTGGCAATCGTTGTTCATGTAGCCACTTTGACTCGACGTTCACGAACATACGATGGTTAGTTCTTCTACTATACTAATGGCTTGTTTTTCGCAGAATCTGTATTTAGACGTAACAATGGAAATAATCTTTTTGGACATTGATCTAGATTCTTTAATAATAGGTTTTATTTACCAAGTTGACGTTTCACAAGTTGTTTTAAACCGACTTTTTTTGATGTGTTTGTAGTTATTACAGCTGAAAGATGACGCGTACTAGAGCCGCGGCGTGTCAAACTTTGCATGCCAGTCGCGACAGCGAGTCAGGTTAAGACTAGCCTATGTTAATTTGCACATGCTAACATAAGTCAATAACTTTAACCGTCTTCTTTATATGTTGTTGCTGCATGATTATCTGTAACCACTATCTAGTTAATAATATGGTTGTAACAGTGTCTGTTACAGTCCACCATGGATTTTGTTGTTATGGATTTGGCTGTTGACACAGCTGTAGCCTATATTAACGTTTTTTGTTTCCACGGTTGTTTATTAATAGCTAAGACTTAGAAGGAGCGGCGTTTGTGTATACGGCGGTGGTTATGGTGGTGGTTATGGCGGCGGTGGCGGCGGCGGAGTTTGTTTGAATAGAAGCTGCTATGGAGGAGGCGGCAGCGGAGGAGGCGGTGGCAAGTAATGGTAATTATCTTCTATATCATTATGGTAGGGTCATTTCTAGCGCTAATATGTTGCAGCTGAGCCGTTCAAAAATTTTCTAGGTGCATGGCTTAACTACCTTGTTTATGTCTTTCCTTAATTTAATTTTTTTCATAGTTTTGGGCGGCTACCGCCAAGCTATCATTTATGGCAATGGCGGCGGCGGTCAGGGATGACGTTTCTAAAATGTTGCTGCGTATCGGCAAGTTGGCTCAGGACATCAAAGCAGTCCTTAGCCTTTTGCCCACCTGGCTGCTGCTTGTTGTCGTCGCTCGGTCGTCGCTTAATTTTGTTATACATGCTAGAAACAGGATAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  s~fpVr|d~fEWN^~ZuYftQt}7nM~~xN2q~g_nMz~vlZ~\~t8~mhs2~bpRsi~ig~,1~~~r~b~I~sdT5~lflgmT{iYj4~~vq%~tugr}pE~M~C~qj~J6A;XmW\:~|g4p~i~\N^r9~Z@|~${~nzKwd:~Y*asvanL~}q6~SpnDHa~}X_~uZ~lxFaA~0TwQl}w(y~Rf:V~_~G]f~bUy'porn~a~``UoN~|Qf0hrO~~re~x4pn_snK^V~Y=us~Yy)ePcgbkGXF~o]/~W^yU~ur'^]|Il~9GE&WqZ~u/_-~~}vFgxGV~usB{xXeB~H8tsddCN@Zz[F~c]CL9S]mm~b_9~b~}qf\Yux8n-~~}o`]~hH~~~r~d_lE~M}ndX~O~|(~}kMQyPy3~~lJ~T~ZucS~<~H~A~~`PD~p;g8qP<~]oizX~p5~pjM~wPtDK6lM~rn~iB~g~HP<{Op,~\wd`o`y]t+~[GS~~zI[*P~Iv_m~O7~FNY`|3aglPo~}zrv}CqF~ZgA@~KKzNtZ~~p]6~H@~i|hicq=\dyw{X{ehPH[rU~zc~<g\Gf^~&wKV~jtf\fsJ~vm~tdr^~^cHOAY~~uA~X/?|_|p`Ra;a_V~^EspS~ufP~Wc~~qaE~o(ciKG[emvG~ys4~m^{q~rrnUrT~Xd_VN~ggWRgmy~Ss*~IsP~f:~VfbmS.b^hrf~~d~oK~s;~~~qabc?g>dPVmIw=9|ROqyk3~d~sf~~<~K~|aQjzc:rtqdN~_jwn~pdgp~OTE;~[@yiPs~X~stM~4~noa>~~yY~F~NY~D_UHI~vQ7EZ~uC^t:~~kB~S0ZEu15~{~xchGzz[grD~~\~~`Lr`Zpwnfgk:Y,~~^|kNci0Wu~<o}KfL\SeF[*b_SbFp4T~~X[~~sE|~pX~woM:pA\xXeMfZ|ql5J`~IwPHFpWaxt=~}czZI~4RA~~]K<V$Xc\{;|azyB~r~Ga~{I~]P~~c~0~Yc@>jRJ~~xzxlXOAhOVlog^hJyqhZ~h~r~wzF~\~ilyY2<pdtW~R~uD~|~{O~E~FEMqlulIYA&wGV~ymg]y(`WBn>mD~$(qx{[7sB4lTlW~i?~e;~:.pl~_iksiRur~[`EC1{ewzs?~)qo_,ya_~h^T~v<~Ok9~0~r&~dhk~_~ppNk{Y~ucV5maq<uY|Ec<8pc-Oy~_|]hqgD9BldVeD8~n~}v^}G=~`Xh0~u}d~rd~n6|{<~Y?r+)~q`~hq2dw\8~~q$~extY~u\~^E|Md1~dMtuJ~lb~pQql0]SZ~j_~/`~~^~f)qp|T~~a~{@cWv_vd@KgdqgF_flasUsX~\6&~`erwO~qTB1[o`nc\~XEh^D~qW8]oil4XM~go~q&~~~@=~~xMu~VqFZU;}+tpX~X~VyNEz]p_W~Th|FzYZ~|X~l~H~R~g)q+`cj~~OJ+{lt%~~~Qz~[?t\zhRdMP}T~tRYoySG6{[p}Q~g@{b`~ZM~YI~Z_~lLv*a31pgCc|O~~bd(~~~t>ebjvlPt~~Alxb~yh~~OK$~N~u^f~~cWqsK~~RWU~~6~u~~d@~D~~~~A~~bOdpU~]~~f~Ovs~f3~zj2}~diy~cj~\[I{5}xL~l~4~~~h=~\vh^~~~|{c~N~~tne}0b$~~~~uz~~~~~~~~~~~~~~~~~~~~~~PPr[wos~~zjg~~\r~f~8YfVV~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2359/ccs/rev np:i:8 rq:f:0.993974
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGTAGCATAGCAACTGTTTCTGAATGTGATATTTCGGTCAGGCCACGTTGACACTTACCAAAGCAAGACAGAAGGAAGTTGACGGGACAATAGGGAAGATTGGCAAAGGGATTTAAACATAGTCCAGTTCGCGTGGTGAATGACAGATTGCTACTGTTACCATTGGCGATACTACGTTGGCGACTTTACTTGCCTCGGTAGCGACAGAACAAGTGTCGTCTACGCAACGAACAACCAGCGTGTTAGCTTGCAATGTCCCCTGTAGAAGACCCTCTTCTTTCTCTTCTGAATGATGTAGCTGTGGATAGAGCGTCTCCCACGTTAGGGTCTAGCAACCCTCGGTGGTGTGTGGTTTCGGTTCGCTTGGTTGGGTTGCCCAATTTCCAGTACCGAAGAGGTAATTGCAACTTCAATTGCTTAGTTGACGTGACCTTTCGGGTGTCATGGACTACCGACGGTATTCTCATACGTGACCTCGTTGTTGACCTCGTTCTTCATCTGCACAGACTACAACGTTAGGACTACGGAACCAGTGTGAAGTTGACGGACGCGCTAGAAGTCTGACACTGACCATGCTTGTGGCAATCGTTGTTCATGTAGCCACTTTGACTCGACGTTCACGAACATACGATGGTTAGTTCTTCTACTATACTAATGGCTTGTTTCGCAGAATCTGTATTTAGACGTAACAATGGAAATAATCTTTTTGGACATTGATCTAGATTCTTTAATAATAGGTTTATTTACCAAGTTGACGTTTCACAAGTTGTTTTTAAACCGACTTTTTTTGATGTGTTTGTAGTTATTACAGCTGAAAGATGACGCGTACTAGAGCCGCGGCGTGTCAAACTTTGCATGCCAGTCGCGGACAGCGAGTCAGGTTAAGGACTAGCCTATGTTAATTTGCACATGCTAACATAAGTCAATAACTTTAACCGTCTTCTTTATATGTTGTTGCTGCATGATTATCTGTAACCACTATCTAGTTAATAATATGGTTGTAACAGTGTCTGTTACAGTCACCATGGATTTTGTTGTTATGGATTTGGCTGTTGACACAGCTGTAGCCTATATTACGTTTTTTGTTTCCACGGTTGTTATTAATAGCTAAGACTTAGAAGGAGCGGCGTTTGTGTATACGGCGGTGGTTATGGTGGTGGTTATGGCGGCGGTGGCGGCGGCGGAGTTTGTTTGAATAGAAGCTGCTATGGAGGAGGCGGCAGCGGAGGAGGCGGTGGCAGTAATGGTAATTATCTTCTATATCATTATGGTAGGTCATTTCTAGCGCTAATATGTTGCAGCTGAGCCGTTCAAAATTTTCTAGGTGCATGGCTTAACTACCTTGTTTATGTCTTTCCTTAATTTAATTTTTTTCATAGTTTTGGGCGGCTACCGCCAAGCTATCATTTATGGCAATGGCGGCGGCGGTCAGGATGACGTTTCTAAAATGTTGCTGCGTATCGGCAAGTTGGCTCAGGACATCAAAGCAGTCTTAGCCTTTTGCCCACCTGGCTGCTGCTTGTTGTCGTCGCTCGGTCGTCGCTTAATTTTGTTATACATGCTAGAAACAGGATAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATTACCACTGCTT
  +
  @~k`~oE(~cX\V8~f^dkVeeNfDCk~nxV8GgkneKYbEw_wY'uphp5j~inbXyy}*~*$Kl;\~F~a~yqmD~ovcf`d~~5{9se9EYj5UGZ^HGG~Wvg_b+VD-nh4F@i&K3~dX~RfG~C~vX~zA~}f0~PC~mC|~gh>MnW>U~J^U\>JrLNe~N2v>xT\C~hay~p<d8yh`~bZ~X~g[oR~tT~rTF~N~WTUAV~~nHT~C.SSG\~IKZusyw~nG~dh~mhmvZlaW7}tEI]~uYF~E]~d~}_uIca0~QY`%-0rl~vpgH~~~zXH_TP~<uT~~{u6~uQ~~_wbO~roZ2D;nk_SuH)mcpaX~x1vZqXnfjrSC~~rZ[7~s7u~_t]~lvm~)~<8-G~T,fC`T(4Xz@~fMXvJ~]H_LzU~2TD}k%HOPy~\~<~~W~~\D|S~g7v^TBb^\~Uz]^n~s_~``}Dy]vO~yDV~`aZZzkrb~7~lY<zjfM<VZgDf?lec9uOzXJ~X*1,o9q~a~tYDBLO{ItnL~^FoHTY~}r\4~UJ~v~oq[l`~u~D~tOsvC~mh4~w]~ks@~s-ul~a~}\1X'-H~k9~ipXA~zbltW]iNg_~ku`c>_^~qYF[)sglq?KnnUW~hZ~iSlUkd?~dmWnWo,_~tsQ~~bvuSq6ZtdFxS]L[o~f}qg\O>{[~E~ynG}nNx\By_:cFuiMg~vX~bLhE&~~USqi^\~vsNWaYA~~rey^XQ@`WRARX~K~~nJqW_(rrjB=kqJCJpUJdEglJ<ZGs1~oa~Md~R~[~?~~uK~~},~D~jJoK~\hA~~[fpZ~iY~d4~upQ@M\DaDfn$z~ols[Jn_OVY-rpgdJ`G|Z7cQu|msei)~CAfODnqSuiNlprPZfDK~cXW~f@VQLZ3~~nAoknZFDX=jTV7agi$xy`{ljfdfYt~M~`~P~%mpl]uiZ~twsgA~T~G~dLUtgqYgepR}WopSzPhQMT1L~jI|c<i5~cGj^~kD~vsosogP~f@~fkXOkxsQt_~~iv~[fN~M|a]Ocete~qI~[~Nl}KcMI~K~mRI~u~r}IgtjT?~~w~qbD}d~~~^~~6~~zZF~r>~ezX}~R~~]~simB~Cx0dp3Stipi~A;~|~~~V~~wr9~~~~zMK~~e~~vWtE~pk~~H~l~T}rw~m~E|_W~~Z^~T~~rsW~snN~hpipfb`gjC~tQ~\A~X~~X&~GDq=@n=g[6M~eF|fF~bM~a_~jR~p\~|V3~~o@~~nO~rA=T{hvRk[R~~E~VI~_'wX&sn}\jImVB~fH~`RuUUt+Kmh[~b3XLo~Y~~}tJ~vw^9|hv~V~~{`~}fK~|_x=~~tPdYqj_gl~k|Rm6~Ztipwip~\c~q7~]3~~S=~~~qz|H~hndjOH~rH~F~XHfa~b~]E~jHUK[u0~na~S~_yA~~DT4~~~~~~v}xjo0~~`S~~t'~s~~L~ob~^~Zui~jv~8~bv[*~MgtDK~rN~_K~sL~~vj\~~<j}`Z3~~`xK~~~woH~Vg_Zqjii}u9~FG~oJ~O~HYv~:~{r~P^K~~ZrPlit?~hp^~8~~\*E~~NL~:J~o'lt>mvPvhK~k'VRf[AaPY2acvqitXoi~^~+~~~qc}y\Ks~Sn_fprI~~irWtFG%pbis~~~~~ypou~~~~~~~~~~~~xpi~[gsPY`pY~[}&y{b~~w~qe]u
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2409/ccs/fwd np:i:6 rq:f:0.996913
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCCACGTTTGGACTTGTTATCATAACATCCTAACATGTTTAGGAACTTCCCCCGAACGTTCGACTCTGAGACACCCCAGGGACCGTACTCTAACTACCTACCTAGTACCCATAGAGAAGTCTTTTGACTTCCAGGCCCTACCACGAGAGGTCTAGTCGAACCTTTACAGGTACTAAAGGTATGTCTACTTTAACTTGTGGAACACCAACTTCTCAACCAACTTCTTCTCCCTTCTCACAAACCTACGACATCTTTGATAGTAGTGTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTCCGTATGTGAGAGTAGTTGTTCTGAGAGTACCTTCGTCTACAGGTAATGTTCAGACATTCTCTTACCTTTCTTCACTAGGGTAGATTTCCCAACAGACTACCGTCCCCCTCTACGGTAGGAGTGATGTCACCATATAAGAAGTTACCCTAGTATGACTCAGGTCCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACCTACTCCATGTTGACCTTCTAATGACCAACTAGGCTCTATACTTCTCAGTGATGTGTTGGGAATGGGACTGAGAGTAACCAACTCTTGTACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  f~lOnVw[~yry^=|`VdihMmsXY$~~`A7Jh~zsrx~~~~{vvux~~~~~~~rl[vV6~yeyqeZs`Z[tNZ~;~`R}ynwLR^>kwVvPuRxdnrel[uf`~q\~rnb\YRx]rWxoUYmyewVwqP~~<~T~ikdu.~~_~\~ynU~oO_~m?~x{^Mal[dsja_P{ly`aP~xA~|~`]qbyL~^~WsKnHj7xqOwlyR~w5~~~cNqmx[xqnySzk]YwexXSW5~\-~~[P~~ec|[P~FzcnaBqxm@~~k9tunvU~i~rysiiKCbj'~bP~~<~kK~bG~N~x`nc~Vg~O~xlWaWuNe]ULT~`m&~v1/~_~ia~`x>~pae~S~yP{K~pR~Z6^K~r?~~dpryetaP~dsZS[Ab7~~ZDmoiUNjar[qMNjQCr~QF3~ctA~~lU};~[~vEk]{G~}^KSS5Yrb=~~bZ&www~MtkMVOg[IUcshU~qdHyKzxl+~~~c;tBA~ZQ~serlOwrl`gW~NxhqgR[~ym_N[^N^mOj[Pe\'vpoOj/~~X~/aM~O=y`b`EvR~eaw;OU]yc[mPSSrqZ~6pcMT*~^^smU~emU~bSCLpdxn_kl3V>}~|q?~~pOx@^YavMYUUNxqU~xZD~xrnyqI~wlmANAeLkmwN<~~~Ukbh~S~q\~F~~xX0wodnmkZW~ZLurnwNl]rQ~Q~~[b[K~]Yb]7srZ~slwVuOwmbQ~{[~^V~WvH~_~c[R~Q~eg~a]LOnB~C{bascNtNr7nof~dp]>^E~~CblncVocZk]@~sWksSVyrmvk>~NsQUOgjdeRDpQ[tZOqKuTMpkslwOqnyO~^byU~]~~nqS~W~Z~F9}p8~Q;rT~S~nxsrhxl[k[lxrY=~j@~\V[ZeEZxqS~i~egYdtCcq]~xO~l6N~_ARZc[a~^L6bl,JZN~~eb~ajI]n?~~xqmnR{v7gj.a`onoOwqU~nw(~t~yreim`H~xs[~[lwVqyl]LYQ~[wo__~mN~me~p7Snv[ivYwgh]sb[Z~_4~~~~qewZsL~qjPyels[~Sh?~w`ZcjUL~>Zdyrnykhrnq\~lmH=JVxcom\pjuqP~DhNlw[v[ci`;{~~~}4g\mpsip[~E~~~lb`~:~uVCvnO~e,nji_XU[xcV^~Vv6ypo`Orap`J|vEXjX>xaVUq9si/~~ZmwYasELwny]~y>~jPxw=sQwyeydS~ZM~Z+yYQMe~%~mnrepF~-`k4pGZncM~l`>S~jEvdeFwrAw@~zK*~~clb~Y~H~q>7eF~~tNxeTE[`qR~vBspbnLZlr_nS~qynf~npQxbq7mIovTTK~)XTp<F~`Z^cGD2YS\O^T_\_Dovj\iR]Kw~Z|`Q~~mbwVucfcmKc?Q$_Ym[YiHJF9tkxclS[j[mc[cY~ccRc9EPE7HDk~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2409/ccs/rev np:i:6 rq:f:0.993329
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGGTGCCACAAGTTTTCTCTTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAAACATCCTAACATGTTTAGGAACTTCCCCCGAACGTTCGACTCTGAGACACCCCAGGGACCGTACTCTAACTACCTACCTAGTACCCATAGAGAAGTCTTTTGACTTCCAGGCCCTACCACGAGAGGTCTAGTCGAACCTTTACAGGTACTAAAGGTATGTCTACTTTAACTTGTGGAACACCAACTTTCTCAACCACTTCTTCTCCCTTCTCACAAACCTACGACATCTTTGATAGTAGTGTTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTCCGTATGTGAGAGTAGTTGTTCTGAGAGTACCTTCGTCTACAGGTAATGTTCCAGACATTCTCTTACCTTTCTTCACTAGGGTAGATTTCCCACAGACTACCGTCCCCCCTCTACGGTAGGAGTGATGTCACCATATAAGAAGTTACCCTAGTATGACTCAGGTCCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAACACCTACTCCATGTTGACCTTCTAATGACCACTAGGCTCTATACTTCTCAGTGATGTGTTGGGAATGGGACTGAGAGTAACCCAACTCTTGTACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  -IJ]VTZBr^_onf~>al``a:=Wj%~~~~~~~{yy}~~|~~~xstx~~~~~~~dbYS^VoAghZg_pVwernU~bt>e~XKCkeoZLi]SKudXg`PS`^jh?~wQsmef.`fi]b9ni_m=oh]`ZwI~p=~W~eykAH~~W~'k>LYZ~_kh~b8~~kcbh+tynsxhV]~ejkm7rCD~~~g;~j[Z~Q~7kRuT~=wDkhVf1{a6fy~wJqelp\vdZG~][xqnpb:G,~~F~~t6xmk_~\0~6~leni~rdN~~cW~pypF~MrxqwOuoxlNR~U8~^M~cW{jAxc~mde`~xQ~g~W7tnerlOEsSQ~Ub4~~~Kf@~a+~j[[zDjN~Z~[Z~C~rOtjR~G~~G~~[~uCgBg$ji[uMB[r4~qRL~~b_YyU~NpvbvbV~~nyZ{(~=~ucM{LrJyiYHP~O~q[lyb[s\dE~~fx+~~~~SLYpOuH~wl[lye?~ynS~X~n8/y~~cW~d\~y\~rnqFgrxVqeS~H~dwenK~n8[i`_neyf2tndqN~xnd5qR3vwmN|`M~xpVwq't[WlJD~o`jBtpd>~~r.sd~l*y,wxxlIRoTbHlS^ZlnTnLm_ynyG~~~w.~rs[~aCqPhRdBqgdeI|`lLy_WcJvC~~rRl`t`e~dTU2r~a7tjQ~7mbQ~Cpw[^Dw[jeyanS~[j@bHhj^HqFu2k~ynyS~mxm\H~`>EV[9I/<]rd?~v5f=0TK)7`)}ju[~Lid+P$6b`%zFiYQ+ICMp^_FbyL~cdKhJD~f>{aR_ZS_O3YIpiFgMh\`K1RY$d9:^E}`STVNUEr\`PGVbH7S]c/`YSbkAJ5giY:P~9nXEj>oX[L~k0}g'SWPpOZSxZPeJHAT=@23NOPDKFCc[X@ERTED-<yQ`1;PafkbhF@JH}NS4d)aa>hKjUyGI2FwkFi0ixWC~al^]Q:~WEj[mN~}I~~laH%fcfmS~[d%}}}}qNafmc@|fk<~QXNCff[fcmS~mcfd^~DWmZG~j6~|]j[fmf[mcdLjBdO&z||{ibdRc?~iL2a`LN>M4eQ~fclZjZ9cCT]IjX$c/dUlKnSdbi3e9`m[bPZfmS~f[aE9^K`bdE3z~~~qK~lZQMVfIj@}~~jc^~C~uP%kF-zO9tV_3dVkPa[^~I:2~~~sbdKiK@hPhMP^F{PN+RHZC:]rk[efHGTabZN;lOI}`PlLY~GbU]H]Q_eL~mE~eD~mCtiZhJHI~hciEGidkdJeEXV@wZmfc[L~jQy>~yN7juc[GrKl<}s\1LBwcF<7[\[&ZV>La(|CZPtekNNR~j8AEdZmRy3|``F~eZQ>}kcfk:~af`7YNiJC~`ccm[dEiOYfZEt6~~^~e4~jXJdWb,XU\Wc$dHJ~]]KL|ZPi(`crTG=^fbOXYZBrDmfkA}Q`QZ]<u
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2417/ccs/fwd np:i:6 rq:f:0.996571
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGGAGAAGCAAATACTTGGATACCGAATTTAGAGGCCATAGGTTATGGAAAAAGTCAGTGGATTAGATAGTAAAAGTCGAAATCTTTATATTCGGTTCGATGTACTTACGTTATTCGCGACTGTTCTGTCATGATAGTTTTTTATATAGTCCTAATAAAAGGAGTTTTTAAAGTAAATGACATTTCAGTAGTAAAAGTTTAAGAGCTTTTTGTTCTGCCAGACGTTCTGATAGTTGAGGAAAACGTGTGGTCAGCTAATAACTTGTGGTATGGAGTAAACGAACATCCAACAGTATGTACAATCGTATGAGAAAGGACAAATCTGAAGACGATATTAGAGGGAGTCCAACAAGTTTGTGATGATTCACGTAAGGAAATCGAAATGTAAGATTATTCGTCAATGGAGGTATAAGACAACACACCAAGTAATTATACGCGACGAGTTTTCATGTTGACGATCCCTGAGACTATATCATACAAAATTGACCCCAAATAATAAACTCGTTCCAATAGTTGAAGTGTTGATTAACACATTGAGACAAGTTGTCCGTACTTTAATCATCAAAGTTTTGGACTGACCTATAAATGAAATATTCGCGTTGTCTTCAGTTTAAGAAGTGATATTATTTTCGGTTTCAAGCCTATGTGGAGAGATACAGGAAATAGGTAAACTATAACTAATATAAATATACGCAGACGAAGCCTGTTAACTTTACCAAATCCAAATAGCGGGAGACACTAAACTTACAAGAAATGTACGGTAAGACAGGGAAACAGGGTTTGAAGTTTGGAGGTACAAAATCTTAATCCTTCACAACTGAATCAACATTTACATTCGGTTACGTTCGGGGTTTGTAGTAGTAATTGTTGAGGTAATTTTAATTGCACTTACAGACGTGGATTTGGTGAAACATTATGTGGTAGATTCATATTTCCGAATCTTAATAGACGATTTTATGATGGTGATCGTGGTTTCTTTTCAAAGGTTTGGTGGACGAAAATGAAAAAATCACAATTTAACGTTTCATATTCATCACAATCCGAAATCGAGATGGAGAGAAAGTTTGACTAAACTTTGTTACAGTATTTTTGAAGGCAATCAACCTGGAACTTTGGATTTCATCAAGTAAACACCCATATTTAGCGAAAATGCAAGCTAACTGCGAACTAACAAGGTAACTCTTTTTCGATTTCAAATATGGTCAGTAGCAATATGTTAAGTGATCCATTTTGGAGGGGTGGGGATTTGTTCAATGAATGAGGCAATAAACCACCGCAACCTCTGTAAATTGACGAGAAACTTGTATAAGGTCATCGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  `{d\6biRqbYU\:|bVaDW\PmXTDty~hAgVb^~d;-fqhX`M~6u?elBQ7>d@ukYRWEsOqS_hEqGndCNj:r^\^Mf\XaXN~n%FENgJhTiAv~a<U\S@ssm_P~~qngKsKBlEhFQI^VG_S9r_HX>eJ?jJWRX_Pg_'~`UdkLAeLkUQK<ovss_CIegl9f@~jWmj+ly[M[jN-qspI>}cPYL~~ofq_lMvG_,coqfl&~uPGGup@ybYed4pt]_O[vepfO~keZdfXtMPbA)/cM~dZEx4]rlKfndU@~Q7ngdlE~o`~Z5|_QA~l[nQ~H\`Jt~eg8wcXk0~U~eoge-]dAV\RhWIdj-kdEd:~lU~iOG~~neoeHycW\aUVW5~dgpI~t@foR~P~d`~fR~teoZ\Ze[Z~JT^OmM~Cy6~~mcOU~~mPmV~bq_~pN{Pef]N~mO~Z?~RkgMmfmdR~[H^mItO~b)BgHwdS?LAOWnOaXc4|~i;BRP^yf]edES2~|oeZfoeiclQda[ikcG~fnVr:P*C7A8wvD>|]7uhLUcc$~>z=rh[c9~e_~>leItOYQ|W~cbOk`~e\fmaTrfOuRl@~OmqeE~~V~W`Eh`9~j9=x~L/~nemNYR~l[W6]dbS*skN[Kn_befSf:leLc<kXQ~pO~e5qcm]H=hPXB=d~~cB~@~iL7~aS~m[mfmA~Edpe_^_dnV~:v~oqU~o9~zekXjJadoU~nan;~|hXi3_eOpfq_a<~eU~nd9~M~dA~~g9u:kkUS~DiuVROcM~~qfq`]aVN~~e`~qeXwfD~~ndVH_Qoo_~aPdqJ~~=scdqL~~@~~dXngA~uW~qV~Vod9~~gPVH~KklL}Z~_>HYveoa6kfM9~cp,~wqbFK~_O~DqgOdH~K9y~iO~tbm[ehUNmP~3kcJk;T1lg9j>i{~_~`~fcFc\oYKS]iOehB~n.m_Pqk=3o~aFZ~UONmVwnqdE^~TdlpG~~S~d+~ldO~IR_QUFcf[A~~~WjdFeS~mOmWbaRS~1~xJ:x~zc0~RE~S~~D~TE~pef8~~~oe.~jV`}o`/aJt)mtL~]LO~~dZkCH~aoUP]YHj:QyX<munefpfmVS~U5ld+jmfR~teEbX<|jaEo~eL~peqfhp2~~~dJ?~U~e`~mM?~K~mA~N~cH~~W~q@~U9Ym`\~fnK~pVa4qzWkpC~\=JbLB~~|TObP~fdjM~dnPde<~`m<~bOuT~n@uYf\,~~~XNcE>RaI'~~k[mW~oesdVofb,oNCSeJ~R~Z[foWT~Z2~~~T~UD~~~m1~~~nH~~f_~eVqme>~Y_<P~7Nxl*~s@rpR~PdU~R~cMifo1sZL~Oo_bqe7~~d^~dUEkHoR~T8XgLd$~~~~~~~~~~~xpptt]G>ATjq{~~~~|qgfsKWb\b\YFU}\dbfN~f[bF[\|
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2417/ccs/rev np:i:6 rq:f:0.996522
  AAGCAGTGGTATCAACGCAGGAGTACGGGGTGGAGAAGCAAATACTTGGATACCGAATTTAGAGGCCATAGGTTATGGAAAAAGTCAGTGGATTAGATAGTAAAAGTCGAAATCTTTATATTCGGTTCGATGTACTACGTTATTCGCGACTGTTCTGTCATGATAGTTTTTTATATAGTCCTAATAAAAGGAGTTTTTAAAGTAAATGACATTTCAGTAGTAAAAGTTTAAGAGCTTTTTGTTCTGCCAGACGTTCTGATAGTTGAGGAAAACGTGTGGTCAGCTAATAACTTGTGGTATGGAGTAAACGAACATCCAACAGTATGTACAATCGTATGAGAAAGGACAAATCTGAAGACGATATTAGAGGGGAGTCCAACAAGTTTGTTGATGATTCACGTAAGGAAATCGAAATGTAAGATTATTCGTCAATGGAGGTATAAGACAACACACCAAGTAATTATACGCGACGAGTTTTCATGTTGACGATCCCTGAGACTATATCATACAAAATTGACCCAAATAATAAACTCGTTCCAATAGTTGAAGTGTTGATTAACACATTGAGACAAGTTGTCCGTACTTTAATCATCAAAGTTTTGGACTGACCTATAAATGAAATATTCGCGTTGTCTTCAGTTTAAGAAGTGATATTATTTTCGGTTTCAAGCCTATGTGGAGAGATACAGGAAATAGGTAAACTATAACTAATATAAATATACGCAGGACGAAGCCTGTTAACTTTACCAAATCCAAATAGCGGGAGACACTAAACTTACAAGAAATGTACGGTAAGACAGGGAAACAGGGTTTGAAGTTTGGAGGTACAAAATCTTAATCCTTCACAACTGAATCAACATTTACATTCGGTTACGTTCGGGGTTTGTAGTAGTAATTGTTGAGGTAATTTTAATTGCACTTACAGACGTGGATTTGGTGAAACATTATGTGGTAGATTCATATTTCCGAATCTTAATAGACGATTTTATGATGGTGATCGTGGTTTCTTTTCAAGGTTTGGTGGACGAAAATGAAAAAATCACAATTTAACGTTTCATATTCATCACAATCCGAAATCGAGATGGAGAGAAGTTTGACTAAACTTTGTTACAGTATTTTTGAAGGCAATCAAACTGGAACTTTGGATTTCATCAAGTAAACACCCATATTTAGCGAAAATGCAAGCTAACTGCGAACTAACAAGGTAACTCTTTTTCGATTTCAAAATATGGTCAGTAGCAATATGTTAAGTGATCCCATTTTTGGAGGGGTGGGGATTTGTTCAATGAATGAGGCAATAAACCACCGCAACCTCTGTAATTGACGAGAAACTTGTATAAGGTCATCGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  @dLFIDMBbI.MBAx[ZFb*eVUfd\;~~oCDycZCcX[+xu9a[EzK}bPb@^EC|;t_KV]*SM~da\:zFx^K<t;z~~Y@d\bDMJzK6xb[a9afq;~~s_kfdE~~ZeO~~oqnN~bR~`~feol_lifqofOPzmO~eeePmfqd<~dVaiMl\eoqod6~scf{iSmegNDO~pI~i@~ulAvj_&ophpNq~YqT~~oOmfi&i~dnSqnepC~~~a2y[K~cobf'XnuaY.~cXcL~k9kfdUucCcnqpe?fMUSv0~~sed[`kNPqfoegqZo[^~g]rbnP~PnWHvQ]qE~~fd>udTRNy_~fmPnVXd[Vc9~XeepgKaoeQ~nA~VeR~~qbSIK~doe^RZlO~kfk%~~mn_eNtL~e_~N5|jP1^]O`ajV~Omfbk_~U~@~~qfdB~wYdZ]~OmV~o`~feqf_~SS~lRm[l[]~RQcN~eieiB~K~d^`~_~nXmfefeofend5~~~ekf_`~eofdnqJ~hB`lLkSKjJlZflCjPI~~uN~en9~~B~ojI~n6~~d[eb]~7n]~EldO~cK~LWL=~coV|L~dpcnB}cmMSN]~aJ}8kE~cEle7~~^~[en[eA~~d6~~~H~jN\c[T~rmFQ~tGNF}~mnK~eeeORwQmfN~el_F~~PuPIsbCLghi8chD|~~cQb&~~d]~NAlZhId_T~edg_hrmgiV~<~W?cArYG~~chhYZzf[9~kGnP~~rkqmOKRX%imdN^~eL~rd<~K~e7~~lGoD~~pW~@~u[lOeJ~~lPf9kfqH~~d?~kP_~dH~~ndBlfU~ZL~KQ`nF~~L~~gj;p~?}hO^~d?~[AwlA~pof?~~~ZeO~N{[PmN~dVdN~eqc?~mO]~foH~~nflKgVQ|+~jPbM~PB~~d9~~]nCa]mdTMw\~dO~bWS~\Z~*i~iKtO~dfofW~ofW]WbapS~m:~~Q~m6Cs~cJ?vll^ET~qoeoR~fopn>~rLoK^vqfN~N~Zi5PLJj=~~{hA`Wo6tg^Vofa\LnI~~eA~~~eL~R~M~~K~m&~keN.~~d[d/~~dXldfof_~G~z\~feN~~eVkoM~^aCOVOZ~VRtdC~~kbdk`oqCkWRP;*dKOtpGUbES~~fI~~cK~eLjO\nEq~~~_LwA~dOvnO2~5'_JiZpbF~~Pud4jidkk\Grcg<bLZ_Dfkfdn.rvndfT8r~qZceJzNe[L~d[bPc_~eYZ~gZ~A~p^~bka:~~~}fen?m}d?sucFhFT~qfnaEndb\~YTh^@~M~bF`kj+obi%[p~?>meD~~~Z*~~~l<WY^CpOZzpe_~l_mO~f_~qE~~V~VT~egL~S~Dd_dK]~P~dofek_:~~a^~LlVoMxS~qglCdd%~~~~~~~~~~~~~~~~~~~~~~~~~~~~tqwhd[l^MNoaRJMpMVnhGlg]g[Q^p
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2436/ccs/fwd np:i:8 rq:f:0.989356
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCGCCACGTCTCCTTAGATAACTGGCAAATCTTCACAATTACGCAAGACCATAGAATAGTCCTAAGCAACATTTGCCGCATCGACCAAACACTGGCTTTGCACTCCAACTTTGCCTGAATCGTGTCAGACTATAGCGGGACGTTCGACATACTACTCATTCGATTACGCATTCACCTGACGAGAATAGCCATTCTTCCTGAACATACGTTAGAAGTAGTTGGTTAATGCTTGTCTACATTGAGTGCGAAGCCACTAGGTTTGCACTGTTGACCACCCAGCACGCAATCGCAAGATACGCAGTAATGCTAAACCATACTTATTTGACTTTGATGTTCCTATCACTGGGTTAATGCCTGCTGCTACCTGACTTTTAGTCGCGAGCACAACGCTTCTTGGCTACACATATGCTGTTGGAATGGTTTTTTACACTTATTATGCTATAAATACCACTCCCACAGCTATTCGAATGACTCTAATACCTCTTGCAACTTGGACGACCGTAGTACGCATTCAGTCCGAGTACCAAGATAATGCTCTTTCTTCTGCCACTCGTCTAACTTCGTCGGCTCCGTGAACAAGCATTCTTCCTACTAGGCCATGGCGTCTACGCTTCTTACATGGTAACCAATCTTTGTTAACCACTTCTATACCTCGTTCTAGGCCTACGTGAAACCCGAACCGAACTCAGCCTTCTTCAAGCTGGGTCTGATACGTGCTCTACAAGTGCCGTAATCCATCTTTAGTTACAGTACTGACCACCGCCATAGGGAGCACCAGCATAATGACTTTAGAAACCATTATTGAGTAGTCCTTTTTGCAGTGATCCGTGCTTCCTTCTTTTGCGTTTAACGCTACTTCAATTACCTACCATAATTATTTGCCCGCCCAAGTTGTCGCCAACCAAAGCGTTTCTACATCGTTCTTTAATTGCAAGACGGATGTGGAATCCGCGTATGAAACGTAGATTCTAGTTGAAACGTTAATAGTTGCCAGTTGGATTGAATATTTCTCCTCAATCGTATTAACCGTTTCTTCTTTGTTTATCTTTGTCGGCTTCTTTGAGTTCAGCTATTCTTTCCACGGTAACCAGACTAAACCACGTCTAATTTCTGACCCAACTACTGGTCTAACTTCATGCTCATGAGTGCAGTGACAACTTACGTTTTGTTACCGCCGAATGGTAATTGTTACTGAGCACGGCTAGAACGTTAACACTTTCTTGCACAACTCTCACATGACTAACTCCCCACAACTTGCATTTGATAAACGTTCAAAGCTAGGACATTTTCATGGACTAGCGCTTTCAAGAATGTCTTGTGTCGACGTCGTCGTGCAGTAGGTCTAAATCCAGCGAATGATTTGTTTTGGCTTGTTCCGATGTAACGACTAGCATTACGATCGACCCAACCATTTCTTGCAGCGCAGTCAAAGTACGTTCCACCATGTTTACGCTAACCATCCACTGTGTATGTAGAATCACAATGACGTTGTCGTTTGCTTTAACATTGTCTCAAACTAACGTTCATAGCGTTGAGGTGGACCGGTCTTCAATGAAAAAGTAGACAACCACTACATGACTTCAAAATGGGGAAGAGACATGACTGTCTAGGACATCGTCGTCTAACTGGATGAACCATTTGAAATGCTATCGACTTATATGGGCATGTTGCCCACTTACCGTACTGGTTCGACTATTATAGAAGGGTCTTGACAGTCGAAACACACTTCCATCCACTCCATAACTGTGTCTGTCGCAATGTAAATGGGGGTGACAAGTTTTACCATTTGGTATGTTTTAGTTTACACATCACAAACTATTTCAACTAAACTCGCTAACAACGTAGTAAACTCTCGGCATGATATGCTACCTTCTACAATTATTGCTGTTTCGGTAGGGTTGGATATCATTGCGTATATTTCGAAATGTCGTTCGCATCCATGTTCATATCCACCACGTAGCGGATAAATACACCAACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  b~7]kbh2lhD_QCiSiaJh^Rlob$vafdhqutv{~~wpljdadit{hVPI83633ZiSLcF`JL%o@aWS[~^@PP^5pZX[E`Uk_JsBcSYT:/KHbDtIMKPDo`;DG@wkG`NAQbBK*=YB1\S\OT^NS0Q3Y6(D&dHn^8riQZW`WMxAfJC7eMHjRlF~hTk]6JF_gQC^ldc?E6<xhDPOgST\J7TwYgbeT:b.^Va(EjTelUJH~iYC~fdOTW[KEzZQPI~mNsV:_H~p@?JViG`6TK`<Z<wa_@CKc7&NL=<JH?S~IEAY\J84kTLVuD>\>Q>HjcTikB:/xOKO`jX.O[ed?p>'dN]H[Sexq1~~Ib>7Y7QtltPfs_lELSH^\2kqV~nmOtJvQGdJm?O'gZZycoMj2XlrX20olD~rS~WsjeA~tiDXp[N.Ffo-Y?$rXR:TdTc4[UVSU:@BYWVW~c^{Z~p}cd]Umdnrhj~rOR({U~36X,g~vvwhQ]`Gx]VtLle>x~]/JXPa@~Ab|Ik}ccU\b7DMcP}_R\Uq2WhJ2e~c@sK_3E:UVyRQiJ[HZsR7VO_vzgZ^lV>GtZjWbFbgccuibuKdPcp[o[NSdHG^BE8Wa3</i:`WFtbLaR~^<c[ZYN]rOWMwykYLwbWQ^^`Y~T_~S~rogbqVd@~KYG^dZd]iB.TNTcBIq_GO`K~E5]NO%bW\6j~V6b)_Dsam2o`aiDW<DTC^;gW+9Bv'KAMZj\E;Z=Se`QBoIsKAkM<KKD9BTkB&JA+[J9\E_O^SVURs[_^ycNgQWs;FqqiIMXkkZ{ZT{\j0Bi^?IPm\VYaZZ`el]KIKCiSUt]k>G~}TTa]B=`o>gdJg>sA\>GGcqCxJB\Tb~e(yXVYhyV[X~.~|sl[]vcio<]Slu`pB\~So?PC%`DAAZJ3vJ6H@2$BTDARELrK~>?mciF~jQ7G?6A$B]B1`t^6~uFskC\KjV<B~JgRr5~mKSS*lp]S7CYYZ`&wK9Vy?x^~ZNFnP%\<n>leeKd?~`BnY<PUV:_Hgc]gl[ZU8cOL=PHsT4~~\_8Z:}eZf7x[E]5`MzHkD6sf&yhC1MXLdLhVA?jiWO4@6jMb.pS<cZ;TVJBrD=@GZ?&QMY}dePVv?TdZI}}^f_T~XP^WJdU}X.a_?a@?>haFoHy9\MB\CnG'[`VZ-BX3r@lpYbYIAsk?@O`8D\O~aXHBHCT}YeaZT_>QGDaYXB:SI[MaVW}VMTKU\&%UMAAx`9K?KxZ>^GMacW}U~[Rzd?T4J5S7BJpVaU^7yTMQd5_BI>:f]DG\X(EUVsC]J8?LC(=Wb?IOW;M%`[]^QA\?Ph\Y^;k]]GHCevTHBcD/X`WSKI=i4AG0SD<9FYQ}_XL`CS^W9ucW6cO6c`HaWQI^_H[T\MX_V;GW2.DW>GODL@H/,^HDZ^5\Z^SN4c]]3*CUG%bbd8YSCv^PaHa_fb]M5hZ_fZ`8EEO'H$6>BGV\e,j=?`+[\FwWARjHWP]VFE3SZ@5^?*6HVZ@w;vLDZFZ]1||b4D._H{HdbE@r_>DG]DAJD)9DQ%=CAdQQsd^PY_As[\D]<}{GW/yU9NX_Cw\]ZcR$7AKN7JF+=)-4G(:=W7dEF=W3:K2$))<@MC\U1m[V,gxzT1ZGF[>V{Iz8T`OCdc_fUR|Y$vvab<^ca7p[L]fZfcKNDa_cZaB'MDQ^aV7BACGB\'BBN4OV_F<]&RD&VL>1\ta_Z_+HUDMSQYPFc`-yF>YJYQc3>mceETkPJ}_aKT`,]CkY]K>ZLLyOS<.Nj5uz],Sx\;4P[\AX-,,U^UDSE\<|`^F`fWKL|_`K_K3HN<:HXCY9DSDVYZ[-\^O,orxld[WY9y^3wzufJ}e?}kG@\f]Y(u^RN1ImfI9N0*NQL<6]lZaPIhe;AhYb?s^PHV^S2$AD8eW[]N^bEwiG]0U6GLX[OUSV[J]Ya9(vQtSJ[AHSAeZ1^UDF\GxkPDJ]L&p2.b8d32a^QFQcV+A>GEV6mLRY%sbb_cYROYYVYS`*eQ_ES{Z\7@'K{fCWKY_bOKQ9QXBFe^Z>V;(uHh0^bh[^^?+@M[XWSnOHI`1l$UXQT^~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2436/ccs/rev np:i:6 rq:f:0.982503
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCGCCACGTCTCTCCTTAGATAACTGGCAAATCTTCACAATTACGCTAAGACCATAGAATAGTCCTAAAGCAACATTTGCCGCATCGACCCAAATCATGGCTTTGCACTCCAACTTTGCTCTGAATCGTGTCAGAACGTATAGCGGGACGTTCGACCATACTACTCATTCGATTACGCATTCACCTGACGAGAATAGCCATTCTTCCCTGAACATACGTTAGAAGTAGTTGGTTAATGCTTGTCTACATTTGAGTGCGAAGCCACTAGGTTTGCACTGTTGACCACCAGCACGCAATCGCAAGATACGCAGTAATTGCTAAACCATACTTATTTGACTTTGATGTTCTATCACTGGGTTAATGCCTGCTGCTACCTGACTTTTAGTCGCCGAGCACAACGCTTCTTGGCTACACATATGCTGCTTGGGAATGTTTTTTACACTTATTATGGCTATAAAATACCACTCCCACAGCTATTCGAATGACGTCTAATACCTCTTGCAACTTGGACGACCGTAGTACGCATTCAGTCCGAAGTACCAAGATAATGCTCTTTGCTTCTGCCACTCGTCTAACTTCGTCGGCTCGCGTGAAACAAGCATTCTTCCTACTATGGCCATGGCGTCTACCGCTTGCCCTTACATTGGTAACCAAATCTTTGGTTAAACCACTTCTATACCTCGTTTCTAGGCCTACGTGAAACCCGAACCGAACTCAGCCTTCTTTCAAAGCTGGGTCTGATACGTGCTCTACAAGTGCCCGTAATCCATCTTTAGTTACAGTACTGACCACCGCCATAGGGAAGCACCAGCATAATGACTTTTAGAAACCATTATTGAGTAGTCCTTTTCTGCAGTGATCCGTGCTTCCTTCTTTTTGCGTTTTAACGCTACTTCAATTACCTACCATAATTATTTTGCCGTCCCAAGTTGTTCGCCAACCAAAGCGTTTTCTACATCGTTTCTTTAATTGCAAGAACGGATGTGGAATCCGCGTATGAAACGTAGATTCTAGTTGAAACGTTAATAGTTGCCGTTGGATTGAATATTTCTCCTCAATCGTATTAACCCGGTTTCTTCTTTTGTTTATCTTTGTCGGCTTCTTTGAGTTCAGCTATTCTGTTCCACAGAGGTAACCAGACTTAAACCACGTCTAATTTTCTGACCCAACTACTGGTCTAACTTCGATGCTCATGTGAGTGCGAGTGACAACTTACGTTTGTTTACCGGCCGAATGGTAATTGTTACTGAGCACGGCCTTAGAACGTTAACACTTTCTTGCACAACTCTCACATGACTAACTCCCACAACTTGCATTGATAAACGTTTCAAAGCTAGGACATTTTCATGGACTAGCGCTTTCAAGAATGTCTTGTCGTCGACGTCGTCGTGCAGTAGGTCTAAATCCAGCGAATGATTTGTTTTGGCTTGTTCCGATGTAACGACTAGCATTACGATCGACCACAACCATTTCTTGCAGCGCTAGTCAAAGTACGTTCCACCATGTTTACGCTAACCATCCACTGTGTATGTAGATCACAATGACGTTGTCGTTTGCTTTAACATTTGTCTCAACTAACGTTCATAGCGTTGAGGTGGACGTCTTCAATGAAAAAGTAGACAACCACTACATGACTTCAAATGGGGAAGAGACATGACTGTCTAGGACATCGTCGTCTACTGGATGAACCATTTGAAATGCTTCGACTTATATGGGCATGTTGCCCACTTACCCGTACTGTTTCGACTATTTATAGAAGGGTCTTGACAGTCGAACACACTTCCATCCACTCCATAACTGTGTCTGTCGCAATGTAAATGGGGGTGACAAGTTTTACCCATTTGGTATGTTTTAGTTTACACATCACAAACTATTTCAACTAAACTCGCTACAACGTAGTAAACTCTCGGCATGATATGCTACCTTCTACAATTATTGCTGTTTCGGGTAGGGTTGGATATCATTGCGTATATATTTCGAAATGTCGTTCGCATCCATGTTCATCCACCACGTAGCGGATAAATACACCAACCCCGTACTCTCGTTGATACCACTGCTT
  +
  E=1.1B7:OVZG]Q[[T^^&9V\b^%l]ce^a__acglhb^[Z[^cnxyyyyvn\YYNxJWB>'DSN(82mYK'->+HNF]G05eH\>[VJUJtTyc]D\+H^?V?jQ)`HFQ?XPBKEF58M>>+rD;/>hW@+&R>L\@K%6:2Y;,P.>=a:/abQF[_fOm;TN;W[;E2/_D?x\W*?*WEaV(G=$5]IC?V=_S,USAa]ZbOpZ(MGSc_PY\BV\>1><0S+QG*fT?KnB>bX9XR<[JXBKbbB_ZCb3RTIRM_Y\M[W>AB5UKoV\DKPaC<,[Nd;<07FBPXJQ^]<vvVKFV0RR=q?8WGKHD7T<db-S<VXMH[=<4XU8n[CF_CO-=xMFWLEfQCEYY>4<2RCO+SOP;7HSEYN;I?NV\7aRA1</p_EEbYDu[1*1B\Ze>zgOdDaJD<veZ[NVZfcF^H>VY(`ahB?NLT-&;FS]`EP`Y;ZTbG2]&V;1DJFF^9^6NV]M$2E<]SETHP6MHLCBPBYBAK29'EL.?BcYE*F'8^X@[\T;?zu^W2S?J`2sCTQe<E]Z$MWZ/zHZ<kY@:\:Y;fC/\>f]RM_8P=JU<ID]Z_^&H/EW'>^T>CEIY=yDmLaXTicJOS<.SO*EF>R0@JwPXPZ,GVI@\]CtUA1+2_MV>291MV2l]QR\?\]<_E'J'UCY44>5,P:q\83uS2+\ec=ZC\CS$'Z0.[\TB48(ND7\B[:MURM/\P%%-Z'm;7XIW>sR3]8Y=_e_Y&s^\KZJ}O}\CYUeX8S5<TEL9R7e>J[LR^dUK]>YY>a[L8kWD\P5Z_D5VJUL]ZZfTQC?MTIPq/%5$D=ANDl[FUW\X8;QDC=\CBOAFZZ_TKJb^*`WOw_\X5mb+>WGZ53LL4:4PqbC`_%t^^bY<xO8;VJxZBpRWX;`YOA@)NO=%1QU?>\TacO~ZfUC3Y>aDrX02El`S\M%@I/7//F-/UWA\KP_.UL)>$T:7BET|Baa,\^E=9rQ%?e\8xS$VU'PTX7`BQ6X:@T=VO6atz^a```KWZ3~cS0?eT~BO;EF_B=b:>jH?-C9d2e_O}Z_Ze^[S@wdK:SVT\SrF9]X0sW&eO\X4aB[Q1JFIA4LA8SFk\?lVOf]I%q]R?CH9(I_8G?=D/i@J$I:&CE7KGDHC.&24=BVqaNF>aoSNF/\D@q\0wvSGWC_F_D\ZJ8eU/$2ZMZKE--$1[RBm%7GPKH$/:VXF^6LB^BDK@-FbUCXA^Fg_6)X\c^P4[EXO0zF<C3,JL5[O]_A3-HYJ=;D)0R0;WVO]WDn_MT9oa:$aHKNe,DKrC8mV>hH=ZDhR0T`\%=A+JVLCR#0';XWL^AM8\FQW[[*9COHaAA?Z?XO=OR7F-9L:W2N<JEG1]TZ2%c\BuS_a/o>C\DXoUT'B%.;cxWZeb7vHYb?daQTD\(p/ZdIMRXF$^U1BgXEi7=7YUwYJ)PX_Yb^WA0B]STLRR>9\JGwK@A4GKdP}_+VU:9&GW2`]DCqws@d\EwSFwP~Y`PXd0zW>[GM@+WU0mYC7CP_W>(C%A=:CJ.+BXU;[7L\00O:*K?JV&eQUL\JPFKIPE9w`dHB||bF<PPE{>^EB(U\YM<L=LPKUX[LG&TZ^T|eW^V=0RS6\Y<ZP-54T^IYJI352D8T;DA`L9Ej_YGzXDMYXVJ6YTE0=LGMKZ.5'DLSO]NB+`ODYS?JYPNSzMf_YP`H_LB]ZDsE-I-@-YJ>3EUIRDW\_CZILPbBDQ*\NU_[_W][(DD3YVS>OM@DPi<w`(d-,EsT0DV4a\X]J?WS5QJ4{pE_L<1J2&5T\R?\I$=>DUA\X&-8I[8GNT[&><<CNS+71bv8<Au=LE^*>]X0xXV@RYAaF[VF7WUV&4pU`A]YLD65>P8FJTT^@U?CI5R85&F.$JZL?N;\T3:HEN%LLR7tL:J*66F+\qvXS8VVKDH[a_C`]:wtFL\FQVGCg[9>x\8`I=H9QO<O;R5ZBN3Dc^cFd^:kG]bUWA`:W^PaP}V{GPa_T~JiJOUR]NV9SYC*JgcL?kdGQ*^OGUOKED`BY=+,.4)./K\UOFTsODb/OBvVA+P=ArccX0sVEL@{cAc^ZZfa6N9TLO=vyROXbQxSl8yxcD?=WNL>(:6^RT6[NoZTE+@E@
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2451/ccs/fwd np:i:8 rq:f:0.994617
  AGCAGTGGTATCAACGCAGAGTACGGGGTGAGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACCTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  AUkzWwO~`B]{o~dDb~ktlkxjFu~~i[~L~hD~KNKvegd{fujuRS~_~H~z7~~~~WK}z>}~Dj~Ub~3~=iTlemiPnP]~t?~iQR16kseVatXl3hbvY>NGVEQP~ii~Ts~`~koWwQ~Tp~lPfprnP~~qR~P~bt`=~~w~dZ}[U|s_~skdhXQuZiTUmb~]\|R~Zon:gXbk[]Z?|ts]~HyS+T_elMj^[^N8uaIZQingc%l`WqQi`fO|lZs?l@`]~PtSXYuCklR~seo~OmDC%rrVGmjP^\cnK~qCphep[J{eQz.b]cO~c[IgxR|HISCWZ]rS~mbDM}akxT~-gIVPy[^aVI~}I~kTk~nA~gTn\nTz]z^~[S~B~~yTb9Qr]~fbln^f5Yrl_`^~jO(~>S]k2P~]Z^E]?jKPSolS~sb[]t[dhA~VKArkq~_My~M~bV>~~dI~lp~WfPE~$~~~~r~dS<\LBaoYQpC~sqQpYbqediP~nT~n\hsp~\i~dX^\~m[mlL~@~[hL^Zle~enjB~~k~em.~~~{q\wA_~ci@eo~ojZ;~YOd~mKs^]~~UjiPbE`DlgVjWiWY~mmY~Plfc~2~~~~~uaP|k[dhYi]pE~~\~pFr]~$~j]j~Oo`CfJ?s~A~ke~Ked]~lQi&i<]~_~\~o9lBcZ~e~ob]u/s^{mRZh\\d4v:*q%hn~jS?hTplkL<T>u:kYLw8x~D~~lKQ8~B^TF^~Y@~onBo~rpeB~pgmYcss[lI4C@Ojl>dPmgaU~T~p~avlfOro^mh;e~Pjia+pr`b0Rr`_VUjhERNm.pbq.~q3)~SL~m~cjh-|o~`Z`:pnkmXf/4UXLtnWCDgS{L~m~Q6rhNqOXmh>~CP~tS9~~jVLeUDoWd~bXhI4^lK3Ok%~|q^~cR~M}FQz~Y~V_:y~L~[a`Rq~Vd~nW~p_~ek^vG3c_NB<~~lRn_ShT'WVcY7zNq$gVOQ~_~pliKjbVCb~Pr\Mq^\~1~~~~^r<eMvWn^~mU;mNVD~lWgUR9~~~~ncEt~\kfNpnd~2RYKprVoKtI~kqoB~~o~OuVQ^~~[XnoZ~`~lPmp<~{cU~~N~qbi~`B}b[eUmgtNruNooY~`K~i]~Br.N~CTed>zQJFg[T~-D;~~n[bK~dUrmRYYMRY{B~et0hblbmL}FVaJ~ZPx<x}aNyp?XRR,L~UXV<ejkcFcm%_q`daY~anPj~G~h3~^JuL%r~c<j~l_n~d~ZxRM=~^htmhf=C$fW|m;dP`kkbmHqElZ~~pWjQ~laZ~a@xdu|P~qai7>x?TT:JV~KYbJ~vqnRlW_GwmXJ~W~.qupQdR%CKN;zn~q~`vokrW[~I~YdmmdnVI~or~`~Yrdm\No]K~ilqr]TpOlSX7]K)UXq]]_YQ@7bg|^qCkOKPu^nV%Ygu|{rtysgTHBDQ\n|~~~~~~~~~len~qSHmb^P]~d~kA=tF[h_mk~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2451/ccs/rev np:i:9 rq:f:0.998117
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGAGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACGAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACACTGCTT
  +
  WplerrYP~hcqU\~UqCCgR]tkO6~qV?WiHzbD~qnS~nc_a\|qpbE~Py6lrGf~~mdGvsR}lcG~`5jDqZ~dmqbYqupZh~N~kDxZCdzcE~t]X0~~~wjj@fXb\~lIiKZwnNgDDSR~wgnc^~ncT,m~kK~Y~sgg-~~~xn<taKEb4WOW]\~[~\ldW~[k[a~\yP~kP\VcPft~<~~pS~@~V:~blPkq`kaqrm_^~s~ithpkG;WXpnM~pdX`~[`@~\w\c@jOl~]~mk~p_~~sJ~~m^~Z[~]~cNwlC~~ensP~~D~\]bnJ~~rF~~\~G~e=mSba9~aW_^~lunqorpq~C~~oWbS~~H~fNS~qT~qV~q[onR~Yro]~_~~oG~lNGT~o]fVamEw~ffIP~~^^~ojo~pA~t~tns3~~~~paj~\kgsd~ZmH~li;~~\~pB~|^w`n>~xaNg~bkibl@w1twzcj[hlkoc]Oj^~piTV7b9>imqusp~T~pcod~ng~o^~g]~d~a~qp\~]~._Yo[nnT]Xsj[k]n2~~{vkM~|ieDXcZ~oPpmM{{~K~F@~O^YV~KKNty]_\`WQXNU8y=Q@jUNgVe,y{}ypjP^~qYpYb|t~N~_*~~lNnkG~~~o]o]@vDEuX7|m9jojlQ~~^qKvr)zbX]~CS~~EqrtoO\^~^~VhcoOocll7~eS~ank_TN~^hPmjiaO|6~~]~9~K6~t~S~Mk=cVQ:|~\~nbN\dKcpmXd~a~_bkgh]RR~sN~~n~OZq[~T~K~dkS~ibpiXcA~~VTjrq~c^kQqlqVO~nTQdppYuEk3uuS~pMuM~]~Q-nZ>4gd_~O~d~Y~HTd`^@to[wB\\rnpX]~i/+jslPO~kHzz~*yt~aQsbnMm`op~eYKnb[j~dA~w~~_~s[tAn~Nt~Qc~_O~o\}aVW,o]Wrj~A~dG~H{A~P~~cn~;~Zam]ds~dtd~XQblR~DdYa;~MycYc|WZRllkM}tT~bL~0~~~~dUg~S~r~)yNkji]jX~q]iMsB~~~~qr2uqdi~pbmnpM~sp~Oop@~a~Q~fJ~~\w[~~r&~~ciaOFkVlkWk_G~~]Q~~IqYc~lqU~\mrjUSxI~{N~~T~aL~xQxL~nN~N~]lL~mrM~cM~J~I~~~esX~UQjOnmVrvejE~Z~~Yeb\aT{R~pj~Mj~H~~nk~ds~]oP~j~V~^~hzn`~cSqqOjT~oPR<~Ix~O~U>~l:~kz@~~{S}hMo~naWV[d~h~jPRT,~vk4+qVaV3jN~F|R~oM^~Z~i]W~=Na~~k[~^]Ze4[KFmXq~dpPk<~~~d^s^o_~MlQ~`~D~~pt~P]~KrD~~rlcjHneqc~Q~K~ht~prOVP~~Y~sUob^~eq]]_~Xbnbrmarmeoh~p_~.d`me~kiPprjllLucrq~rds$~t|~~~~~~~~{yz}~~~~~wnknt~woYVaZ_[Z`FF~hltS)Xck]bg~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2472/ccs/fwd np:i:5 rq:f:0.996916
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGGCAATCTGGCAGATTAGATACAGCTATAGAGCGAATCACCACGTCTCCTTAGATAACTGGCAAATCTTCACAATTACGCAAGACCATAGAATAGTCCTAAGCAACATTTGCCGCATCGACCAAATCATGGCTTTGCACTCCAACTTTGCCTGAATCGTGTCCAGACTATAGCGGGACGTTCGACCATACTACTCATTCGATTACGCATTCACCTGACGAGAATAGCCATTCTTCCTGAACATACGTTAGAAGTAGTTGGTTAATGCTTGTCTACATTTGAGTGCGAAGCCACTAGGTTTGCACTGTTGACCACCAGCACGCAATCGCAAGATACGCAGTAAATGCTAAACCATACTTATTTGACTTTGATGTTCTATCACTGGGTTAATGCCTGCTGCTACCTGACTTTTAGTCGCGAGCACAACGCTTCTTGGCTACACATATGCTGTTGGGAATGTTTTTTACACTTATTATGCTATAAATACCACTCCCACAGCTATTCGAATGACTCTAATACCTCTTGCAACTTGGACGACCGTAGTACGCATTCAGTCCGAGTACCAAGATAATGCTCTTTCTTCTGCCACTTCGTCTAACTTCGTCGGCTCCGTGAACAAGCATTCTTCCTACTAGGCCATGGCGTCTACCGCTTCTTACATGGTAACCAAATCTTTGTTAACCACTTCTATACCTCGTTCTAGGCCTACGTGAAACCCGAACCGAACTCAGCCTTCTTTCAAAGCTGGGTCTGATACGTGCTCTACAAGTGCCGTAATCCATCTTTAGTTACAGTACTGACCACCGCCATAGGGAGCACCAGCATAATGACTTTAGAAACCATTATTGAGTAGTCCTTTTTGCAGTGATCCGTGCTTCCTTCTTTTTGCGTTTTAACGCTACTTCAATTACCTACCATAATTATTTTGCCGCCCAAGTTGTCGCCAACCAAAGCGTTTTCTACATCGTTTCTTTAATTGCAAGAACGGATGTGGAATCCGCGTATGAAACGTAGATTCTAGTTGAAAACGTTAATAGTTGCCGTTGGATTGAATATTTCTCCTCAAATCGTATTAACCGTTTCTTCTTTGTTTATCTTTGTCGGCTTCTTTGAGTTCAGCTATTCTTTCCACGGTAACCAGACTAAACCACGTCTAATTTCTGACCCAACTACTGGTCTAACTTCATGCTCATGAGTGCAGTGACAACTTACGTTTGTTACCGCCGAATGGTAATTGTTACTGAGCACGGCTAGAACGTTAACACTTTCTTGCACAACTCTCACATGACTAACTCCCACAACTTGCATTTGATAAACGTTCAAAGCTAGGACATTTTCATGGACTAGCGCTGAGCAAGAGACTAGTTCGACGTGCATAGGAGTTTCTGCATTGAATTCCTTTCAAGAATGTCTTGTGTCGACGTCGTCGTGCAGTAGGTCTAAATCCAGCGAATGATTTGTTTTGGCTTGTTCCGATGTAACGACTAGCATTACGATCGACCCAACCATTTCTTGCAGCGCAGTCAAAGTACGTTCCACCATGTTACGCTAACCATCCACTGTGTATGTAGAATCACAATGACGTTGTCGTTTGCTTTAACATTGTCTCAACTAACGTTCATAGCGTTGAGGTGGACGTCTTCAATGAAAAAGTAGACAACCACTACATGACTTCAAATGGGGAAGAGACATGACTGTCTAGGACATCGTCGTCTACTGGATGAACCATTTGAAATGCTTCGACTTATATGGGCATGTTGCCCACTTACCGTACTGGTTCGACTATTATAGAAGGGTCTTGACAGTCGAACACACTTCCATCCACTCCATAACTGTGTCTGTCGCAATGTAAAATGGGGGTGACAAGTTTTACCATTTGGTATGTTTTAGTTTACACATCACAAACTATTTCAACTAAACTCGCTACAACGTAGTAAACTCTCGGCATGATATGCTACCTTCTACAATTATTGCTGTTTCGGTAGGGTTGGATATCATTGCGTATATTTCGAAATGTCGTTCACATCCATGTTCATTCCACCACGTAGCGGATAAATACACCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  ^~c[8ak+}OOP-2z[L]gcgcoc^%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~B@~]I~o_oP`1Mbga~gcgkRR^c^^2YK^R`_bF~nYNJjf\co^j.g^}8agoW~^oR~^>~~T]_~EKZ1x_~g]L\F~aP:gcTN]4~lQal8fkF~_]C}ZgV~~c>M3EenKVA=mKldo]QnR~^V~~a4%Km=~W~^3~pb=nna4~m\KkKm%e[acGlQneL[8~~f_bM~_a80kOkOLngY;ZQ`~_cga~g^_0^\~^gKchceH`Q`7~mgcP~g_~HT{N~obF~\Qng_ca~gbF~boeJK~S~`~B}`LXJb`U]mR^dE~~`;`j2[aG~bO~c[oaBn6i~IHbIkd^~IM=c9Jlgc]P]aIFpQFa]F~aQneHa_gcn&}nnaHl=~p=tRGSC\~:E~~aMZV~~cgia8~G1PV>\CjJqj:~V~ocO~oc_mKWfd&`Tbg^?~jV;ao\JF`Qb^g^In^aHXe2Z~S~XeMD_[gogoc_IcVf2x~CeaK9~~~~tQ^g[8~dF~KV`Hmgj8p~ngN~R[n:~~f^gc_nQM~^a1^ma;]m_kHo\Q/l_]P~c^W~^a~S~c[cgM~HMdcl;ZL]fI{/MboN~]`cngP~R~\KRE~nc_o^F~i^a~_ocM~;U)XZch2f%}[I~]co^Q~^mO~cocT}H4paHeOpGJl=~ng_ogS~?~OgP~\IS]ogNlaY8~\Mr;LOSR~UF~Mq8adn^V~~ca~W~N~Q\Jh^mQj<@~n^d`~_nO>~Ouog_docB~W6ki_F~AQKF~^o^a];~CL04}~]@~~a_oI~~U]lKeog\IRa_o_ng]G~bob=~bm4~l=~e[JFi~fbL~c_gcl;]obQHI;Im]CfQkDG~|R_YP>r\ESQnJ~obQ]G~~gcM~q@~fa~ga~`;bogdn@u;v~~{c_gaTaac>z_eb\6~Ava~^F~~~nJ1[1~~d0}]c_nQ]WC]6^K~O>~SeO~goX~a~f3~~qa@~bE~~V~JK~bj1`Km/bD71\[_G`C~~~^nSH7iI]4~o]3pfI{[~JFW~cI~^S~dTaoSwF~l>lb^cogob<bvGaogcg_~_kQ`;~a*~~e^a8~U~Teda~b=~aL~R~OF~H3~mg2vk]hIekZ5~p`_ckRS~W~O~bD~g.]~^H~lJ5~~fo^H~~co^<t^a~^3~qbQ`5~\gc[TeV~]A~y;~MZK]SJCO~gbJ3iM~m<~P[Kl_nV~6qq^o_RBKaW~^nQ^o>~n^lG~]M~\QkJFlF`g]gcoc_fKmbQZ%zG_~cZb7~~aL~fM~\HfNU~|\~y.~h~Vb~FcFjsn[\fK~avrmLzhmW~Twe[P?~~i4ti_ieB~gyLrc1IjajMg{KsQz@~~aJK~eT~misQ~~m]x*~~gnk~hG~~lO_q]~m5mJ~~~Q[{]~siyslhkK[]qkRU~kFlqQlflW~hm]hjXkg]rXZ~DNK~~h|niqU~T;oU~O~\z~f@~lO~{lbfW~kal|ghmagnanzRl|j;pl_ZV~j8sG~~y@VVmil9~ym[<~~mG~~~\~gZ~lPrSzmcjRDM~hnsi{[VLFj~pRWpzRkW9eQFPJca?~~ear%J1jc?[qT\O%~ogalgjTtSl,K}iai)yldh;bP~Q~BlO~Xealw>ws|nz]l)}|isiU~|l]WmU~mv?fU{{ni]~~NrGTd~ikOrcNu\T@qTk\|</`S9dggtnhV~|[~[RlyhV~hNzzg0~~~~n{\kGg=^D~_hu]Ap|np_:~a1~vUCgx~W~gjm^`TJVnRzn|iyGM~i^U{inw;kvbXoi|Y~k^WN~E}r`~~mG~~{lQX~hnsij~nqsy1~~gs|lC~lB~{^fE~qW~l{]ixG~Qq\eQ^|sj~]{qmL~B~~uif~m]hsl_PlP}hpP[g`~C~qrBpN/XI~rz;~d|l_Tzi}n|_UQO~{n|7~~~|C~~u~ajGg`~nJ~~{\T~mP~~[z@,snT~~~^l?~~^>ERa{dDN:~pQyq:~~NPjef/tkbbflGPCH+@NSu]iaT~~fbdbg\~hmsns|s|mRzsOrW~c\pia~i~th~Wg|mO~~fD~oQLr~b~V~mFnyS]B~lin{rtDM~~gnF~~un|inj~R[lVm=~bOKKhBK50)c_>`b@^VO^1BnQl@~jMALO'{|lnQj`Vo^o_YK_~bQlQNog_oc_o~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2472/ccs/rev np:i:6 rq:f:0.995793
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGGCAATCTGGCAGATTAGATACAGCTATAGAGCGAATCACCACGTCTCCTTAGATAACTGGCAAATCTTCACAATTACGCAAGACCATAGAATAGTCCTAAGCAACATTTGCCGCATCGACCAAATCATGGCTTTGCACTCCAACTTTGCCTGAATCGTGTCAGGACTATAGCGGGACGTTCGACCATACTACTCATTCGATTACGCATTCACCTGACGAGAATAGCCATTCTTCCTGAACATACGTTAGAAGTAGTTGGTTAATGCTTGTCTACATTTGAGTGCGAAGCCACTAGGTTTGCACTGTTGACCACCAGCACGCAATCGCAAGATACGCAGTTAATGCTAAACCATACTTATTTGACTTTGATGTTCTATCACTGGGTTAATGCCTGCTGCTACCTGACTTTTTAGTCGCGAGCACAACGCTTCTTGGCTACACATATGCTGTTGGGAATGTTTTTTACACTTATTATGCTATAAATACCACTCCCACAGCTATTCGAATGACTCTAATACCTCTTGCAACTTGGACGACCGTAGTACGCATTCAGTCCGAGTACCAAGATAATGCTCTTTCTTCTGCCACTCGTCTAACTTCGTCGGCTCCGTGAACAAGCATTCTTCCTACTAGGCCATGGCGTCTACCGCTTCTTACATGGTAACCAAATCTTTGTTAACCACTTCTATACCTCGTTCTAGGCCTACGTGAAACCCGAAACCGAACTCAGCCTTCTTTCAAAGCTGGGGTCTGATACGTGCTCTACAAGTGCCGTAATCCATCTTTAGTTACAGTACTGACCACCGCCATAGGGAGCACCAGCATAATGACTTTAGAAACCCATTATTGAGTAGTCCTTTTTGCAGTGATCCGTGCTTCCTTCTTTTTGCGTTTTTAACGCTACTTCAATTACCTACCATAATTATTTTGCCGCCCAAGTTGTCGCCAACCAAAGCGTTTTCTACATCGTTTCTTTAATTGCAAGAACGGATGTGGAATCCGCGTATGAAACGTAGATTCTAGTTGAAACGTTAATAGTTGCCGTTGGATTGAATATTTCTCCTCAATCGTATTAACCGTTTCTTCTTTGTTTATCTTTGTCGGCTTCTTTGAGTTCAGCTATTCTTTCCACGGTAACCAGACTAAACCACGTCTAATTTCTGACCCAACTACTGGTCTAACTTTCATGCTTCATGAGTGCAGTGACAACTTACGTTTGTTACCGCCGAATGGTAATTGTTACTGAGCACGGCTAGAACGTTAACACTTTCTTGCACAACTCTCACATGACTAACTCCCACAACTTGCATTTGATAAACGTTCAAAGCTAGGACATTTTCATGGACTAGCGCTGAGCAAGAGACTAGTTCGACGTGCATAGGAGTTTCTGCATTGAATTCCTTTCAAGAATGTCTTGTGTCGACGTCGTTCGTGCAGTAGGTCTAAATCCAGCGAATGATTTGTTTTTGGCTTGTTCCGATGTAACGACTAGCATTACGATCGACCCAACCATTTCTTGCAGCGCAGTCAAAGTACGTTCCACCATGTTTACGCTAACCATCCACTGTGTATGTAGATCACAATGACGTTGTCGTTTGCTTTAACATTGTCTCAACTAACGTTCATAGCGTTGAGGTGGACGTCTCAATGAAAAAGTAGACAACCACTACATGACTTCAAATGGGGGAAGAGACATGACTGTCTAGGACATCGTCGTCTACTGGATGAACCATTTGAAATGCTTCGACTTATATGGGCATGTTGCCCACTTACCGTACTGGTTCGACTATTATAGAAGGGTCTTGACAGTCGAACACACTTCCATCCACTCCATAACTGTGTCTGTCGCAATGTAAATGGGGGTGACAAGTTTTACCATTTGGTATGTTTTAGTTTACACATCACAAACTATTTCAACTAAACTCGCTACAACGTAGTAAACTCTCGGCATGATATGCTACCTTCTACAATTATTGCTGTTTCGGTAGGGTTGGATATCATTGCGTATATTTCGAAATGTCGTTCACATCCATGTTCATCCACCACGTAGCGGATAAATACACCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  :i^bo^QNoeSN`4}Y\Km_n[Pob$~~~vaOFFSg|~~ujcadkw~~~~~~shdmC=~aL~fce?wJm_oX~mHmgoco_^`lNl_o^bJXqOJi+he]^QbbO~Tkj\Pd_~]KM~bA~jM_Qd^oca~X~ocMb]w1jS~ogd^^~hl_gS~gL~]`8~aoC~{^S~^cogc]UR~F~~PbnQI~cKz\UHmcgRl%~I?~~]S~U^N~Qc_g_cco(mmKeoeT[cE~~oc_F~b_oS~nQncgi]QboX~c_oOpgaHaoW~KmS~Q]oa@NZL~fX]S~oW~a4cR~Q\M~bl;k^GIno_VrGbcF'tLx5~^~QZ^4~[QaQnco5jh]o\7Da^_~HQ~ocgjMyB~_C^Tag^F~]mB~mS~o_coc_ca~gc_cS~_lgoc_cm_3na~g_bP3~~Q}=;>UJzoC~dFR`@~~^eQ]W~cgoeKjKeC~kF~`~eHQ{Q]cg\4_KNi`^mI%kv~ji1Pb]LZj.Jmca~c_bE~IFuN~bORaocogl8DadC1l7|s`~g^(~~~~~mcmJE~nW~og_cgogG~~foS~obQI~~oco^bUkFja^M~f_obQb`YfO;@jQbJ~]KK~aGf@~n^1dNuT4g^gmK\ciF~bn_gS~]U\QnS~a~^egX~g]LecD~jJE~aQ\C~m]K`HO_&^~b4~a^Q\=~aQ?r^Q\M~aL~]cnD~bU~S~Qncgm=~Q~N\<~HZQafoS~^aPqcX~ococ.iKG~RwG~~fcGkj]F~`~S~ocX~cgoeTO~_c\PfZaiMj?~MRa\8ZV~~L~~^$~?@\03~agcn^RwW~a,~|I3~k^YO%~~g]cg_ogoc^fH`Rbflc`~]?[@}XM_~QR~TecN~~o^W~mKm_gocf\f@~mRrHQ~nQl9k~n^cmB~m_aTdZ~g_ob=~~n^G~~+rlfB{nJmNOP3Q]gSu*~~xf]coKdHmg?r^g_b4}Ai6w`*|~yiYc]'~yfc`~c_cgocX~ca~X~oS~gm@~lQ`~X~oG~~~^R~^I~~L~\5~XLa^<yS~<^G~~]^^G~~~cgoch7[XGefb@~~`~X~^cY~WM~`,~lg_gO~`~QS~^c_`[Q]F~w]Sg[^ZOp_Qm]B~\G~~b^F~O~fmG5~\S~^Ee)~jF~]M~fn?~~aQS~d3K~fcZMmG~`~(]^@~~b@V;3tl^@~~ngb@~~^gc=~J7~`3~kGm^W~aT[ceTS|`Ah]?~m`KLfL~>~R[ocgV~~S~o`09afL~M~~ch_oJ~~a~cdO_QIIQaO+~H&|MKkMA`$IKj8X_\;[Qo]Q]iPL~bX~oc^4~{\F~nS~^S~^V~gO~eQ~K{^F~n^SGg]LmcP~ceT[O~b^W~Z~^fb-~~?3PGalcI~@PZfcmKkO,ibPK~`e.~\Ra?wcLjJboC~{^nQH~~c]E~b5~VI]`Q*~kci:~~~bma:mmbQkHa]KMFjE3YuHm^odgo^W~c_n^Ub^cgZTM~lGL~~ch_cnG~]a~JyS~=hzJLwF_~g^Pa;^RcZb^VU_GOb]$`c_g_aSIORKkgbPF~~f?~o_b]@hQ^m1~~\'q~~UO|b4~[5zOy[gPT,L~_1jceREal/}kc]Uec]S:~zK~S~n>~~_1~\aV[c_co^QaC~f\Omc^TkS~TR~og^N~~i]]be5~SuogT~obQ]g^gog_gn_ogcocY~eGWc^D|]dc^N~~^cBrgJ~boW~^c`:IP~cd%~`^I~aTORZL\3j^n=~PN~Bc_g`&_`~Q\3~~~~]go_oa9~SzocbbKg`]ocT~\6~~e*~kiSSYAZ*bQof_obPL_\:lOujcnQb];[[N\6;^Q>~dQ\8~?~l=ycX2|pdH_4~a_ocW~lR`g:ywcmQ\F~]J~~obF~nS~^gobbL~H~c_obPi4~mglILp:w|dKU|Imco[bc^WcJ@/K_F~RqON?~ocg8~`ga~dfF[]gcf_gaHaa~f^CI~~K)obOV^Gmc`~[:kz~hJ\U@~mMy9Qa0:ggcS[@mmncocog`T`7vr\ZS-gu`8~af6~~bgc\4bT_;~a^bf^f6~~`ebe^?wKeK[Ueog^MQmS|5~a\ZaMfS{nFiIbg^@~hGIbQmC~kGtN~nfh[]f.x[c[]Ngj.~}ZXU}~eB\`^G~bo^cgT~og_3pcnQS~oS~oc^Qn_cO~nQH~~gmKm,~~~=7djKecg_c^ByDTcY=mnaU^_/|
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2614/ccs/fwd np:i:6 rq:f:0.993948
  AAGCAGTGGTATCCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCAACGCAAATGCCACCAATACATATGTGTCCTCTTAATGTTTGCATGCTTAATCTTTTGATTATTATTTCCTCTTTCTTTCTATTACTAACTTTGTAACTCTCGCTAACCGAATCAACATAAATACGTCAACGAATCAAATGTTGATTCTCAAATATCTGTGTCCATGAAATTTCGGATCGTAATCTGCTCTACTTTTGTTATTACAACAAGAACTTCGACTAAAGAACGGACTATCTTGTCTAATAATAATGGCACTAAGTGCATACTTTCTCGACTACATTGACGACTCAAAATAAGAAAGGGAGTTTTTTATACATTGACCTAACTCACTACTACGCCTTGGTTACCTTTGAACCTTTCGTTGTCAAAGTTCGTACGATGGTAAGTGCTTTCTACTCCTACCGCTATTTGGTTGAGAACCTGTTAAATGAGATGGTTCGTACAGCGGTAAATGACTTGTTGAGTCTTGACGTCGACGACCAAAGCGACCACTTTGACCCAATTGCGAACTACTAAATCCTAAGCAAAGACTATTAGGTAGTAGCCAACTTCGTTAATTCCGTTCAGTACTTTTAAATTCTAACCGACCATCTTTCCGAGTTGCTTCAAACCCTCGTCCTAATGATTTACATCGAATAGAACGTCGTACAAACGCACTACTACATGGAATAGATTCTCTTGTCAAATCGTTTTGTTTTGGCTTTACCCTTGGTAACAAACTTCGACTACGTTCGTACAATTCAGAATAACCTCTACCTCGTTAATTTGAGTTAGTTCGTTAAGGGCTTAAGTAGTTATTTCTATGATAAGCACTAAATTGACCTTAATTTCCTCGACTTATTGTTACATCTCGATTTCCCTTGATATACTCAGATATATTTCAGTATCTACTATTAATATCAAGTATGCTAGGATTTGCAACCGTTCGATGTAAAAAACTAAGTCAAGGATCGTCATTTACCAATATACCGCCTATAACAATACTACCATGTAATGTTTGCATGCTCTATCTTTTGATTATTCTTTCTTCTTTATTACCCTCTCTTGATTTTTTACCTATCAATAAACTTACCATCTTTTCATCTACATAATTTGGGAATCTGAATTAACCTCACCCAGCCGTATTCAATCTTTATGTTCATCTATTCTTTTTGATGACCTTATACAAGTTTCTCGTCAATTACAGAGGTTGCGGTGGTTTATTGCCTCATTCATTGAACAAATCCCCACCCCTCCAAAATGGATCACTTAACATATTGCTACTGACCATATTTTGAAATCGAAAAAGAGTTACCTTGTTAGTTCGCAGTTAGCTTGCATTTTCGCTAAATATGGGTGTTTACTTGATGAAATCCAAAGTTCCAGGTTGATTGCCTTCAAAATACTGTAACAAAGTTTAGTCAAACTTTCTCTCCATCTCGATTTCGGATTGTGATGAATATGAAACGTTAAATTGTGATTTTTTCATTTTCGTCCACCAAACCTTGAAAAGAAACCACGATCACCATCATAAAATCGTCTATTAAGATTCGGAAATATGAATCTACCACATAATGTTTCACCAAATCCACGTCTGTAAGTGCAATTAAAATTACCTCAACAATTACTACTACAAACCCCGAACGTAACCGAATGTAAATGTTGATTCAGTTGTGAAGGATTAAGATTTTGTACCTCCAAACTTCAACCCTGTTTCCCTGTCTTACCGTACATTTCTTGTAAGTTTAGTGTCTCCCGCTATTTGGATTTGGTAAAGTTAACAGGCTTCGTCTGCGTATATTTATATTAGTTATAGTTTACCTATTTCCTGTATCTCTCCACATAGGCTTGAAACCGAAAATAATATTCACTTCTTAAACTGAAGACAACGCGAATATTTCATTTATAGGTCAGTCCAAAACTTTGATGATTAAAGTACGGACAACTTGTCTCACATGTGTTTAATCAACACTTCAACTATTGGAACGAGTTTATTATTTGGGTCAATTTTGTATGATATAGTCTCAGGGATCGTCAACATGAAAACTCGTCGCGTATAATTACTTGGTGTGTTGTCTTATACCTCCATTGACGAATAATCTTACATTTCGATTTCCTTACGTGAATCATCACAAACTTGTTGGACTCCCTCTAATATCGTCTTCAGATTTGTCCTTTCTCATACGATTGTACATACTGTTGGATGTTCGTTTACTCCATACCACAAGTTATTAGCTGACCACACGTTTTCCTCAACTATCAGAACGTCTGGCAGAACAAAAAGCTCTTAAACTTTTACTACTGAAATGTCATTTACTTTAAAAACTCCCTTTTATTAGGACTATATAAAAAACTATCATGACAGAACAGTCGCGAATAACGTAGTACATCGAACCGAATATAAAGATTTCGACTTTTACTATCTAATCCACTGACTTTTTCCATAACTATGGCCTCTAAATTCGGTATCCAAGTATTTGCTTCTCCACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  byWQRQMHwNRb+^T_=DOjWhV4BM$gkf]YalrssssssssssssssssssssON5iLUNN_`QW@oT4^=_[dQR`S\X`Wc=vcQVtYvcV?uoQ;Rc>QWuYvZP/rwOBgTviWwiEb`BwcP5mP=KpuQbSJ__@OS`QJvvWcBgJJM_JSPc8a2uQ%V_QBlPQK6DGciQWMLSuRSBhJN3qpbSCrVi%?N]K'qrbhbOMVcWa3]cVTMvgItvQHv?bQWcVxb>dWOMNLgRCvvtVFpiTvCQJrQVsW5rOFsOBRPcLvpSVtMFXhPc?IOS\T7ObUvN1bcUv^4mOAPb8sWRXQfLRN*sqOIOF\A^OOfDtD\AFB9YP=vwt]RbB;q`.lqiV%e\Yjjj]iQf2sVi@xdG]L`RiP_ZPdiQW5uQqE`2qe1r>ndCGs>^ItsOVTvWcQCupDSuQWdiQVTMHxeYvXcVQKvrQ_\>bEzciEyUPNf0sX+73pVRU9j@_dVCt5^ZLURVLA6s5rQWbSOSVQIu`LvrWShRTuWPhRKScQTvWVOCbQVeNBg@_<rnVRVf/mP&FotBg;|cG]Dq4O3HdP_TNL?ttcEydGbOPMvtDcQ_\C\a6t]OVMgW?xJqOCtPWVvG\Gj?[TTvQVXdiO.hva;x_Gg=aHt=nWi>[icQJui@]VcQSsWQLrO&qp,LWNMVNBl_BU\SND\j;=dMQV7_<@WHrRWeQVcBPNctQWPOMaTQca;fK4[NU]\UPHg>bPVoWb=Lrd`RV;vuiV5REXEt=*rgU9rkVp:bMOWP-jrPTvQWe+_TAVKqOAKTPYtSt=hVIc^HrBxcOMgE|bCVFbGsLwvWiX%ae.ArMV5WHo=kr>StFrXZLQ2RdJZmQbj`B]K@LVPcL^CqeFmGS0ZC@YvFY\ExcQVPOWweNnVCtfQScQb>WiGpT5`^@X<cc]aPN`(WWaCV4\>rmSeQI?XPa?QdMDbXv^X]=CrUMgbUOba=[iKviCAUg=pBEtPXbITL5tuuurQaVdWa>HrIyi`PUOPTIvvS@QD`]f^OAuWEteh_QoKSsefQdg/p:^CXEabW2vfWQhPWPcP`P-H8\sqXfCthPs>=prPQsOLrtc<RQ-csaKX?KaWh3wwueYgC{ce\QVvb.[ZOS^e'xf\=2lw]NRaRaTPfMUr@wb>w^&UZ=bYXv?rAU3u_*P4a]hD,\WdiTvQUtJNHrvgJT5h>PT6_EEkO%elsWWidW_<bDmRaa>/]T2oqPcQXcPCJCeaCgWb4WFLLP8sb;hHqvjN\U<VE8LROQRSuVIsL/_cc3yzyh6kheb?v.sssbHwS[BiBVuXt9YciWwV<KfQM<EDaBLe5XkuVMwsIJP<\[a`WhUCo??wCtVVtiUQrQVRhSFsf@*OmQNh:vvl@H@`AZGMgcA^`\@._qiP=m;UaV@``a0u@orU6_CXiFwTvWiVvDDgCZ,-eVT@UPcW^GnP/pbWH?VTVb=@rnP&pQP^PJApQO(Q?UT2utP=kTUtCbWgMSE[c`ZW=fkQXSsJTo7iWcXg(uuuusRg:vvtOC`'[Z't?Z`@wOpT/k`YS,]:1vNNWgLJV1`cY?@`.OfgZJOX&W];hPiO]<hH4c:PcVMNN7fO?U^@p^J^X<WFN8N[6Z(d(QHA<]LF;UJ[NC?gOFM8;B-g>`QTJh[=iZJIX:GfNjJIYU/ZT>?WU'UQRONgGNZJe2WNJ?PNB9XgU??[O[?dJ_PMiLNMKd0PI<gFPOG/bNLOZ^;`P/b'[:8IO4+[0TeZOEi`4_aX;VK>h^>mOZ^II3bN7.OMB@gN9ii^OZLK1R2537>VP9ii0g^:k[DkZFidJJZKeJ^@3DBgJOZJYLHOYCSG7aJI)U;UU57_YB8D)Sb\<XS^9kS;kZPU_R4UHY;jU7IS]DkJMiN:gc>fL)OQNYII1W$@B=KBfKAf<hgFPOQiLMH?aJOI<AYY^BhZIJ9gbIUMBnY;JNX,c7VffF@M[J]VIMJZFeiOZ]KAjE3<EBHbPP&WJB';V<WO'OMJcJD>bIT5J`:@PIZ^Ni/ZPg7KTOCiiE;_I8^e.RKQ8=D5fifNAGWL4IXG]ND4XHH/Tg]ZKOX6@cJET83LO^IX6N[H;IOVMZQiLiFJLi>j[LZLKeOX7Kg\XF*GX9f_NjNH6LLVXLOQ8+U\J^EjiJNU6gZ;L+bYFIF=?fYK^Y:J;B\NH<bPKiAUM,45YiVH[IgN^ZKOUJ:e6]LM8ihPT/iBgdFAI_Z^JN^IN<WSJ_Z^IUJ=TB`ZMPLiJN.eKVIU.BF?\7hR7?OH;MD9d]OJZO^6GG6W9O5jiN:JR@IP:XISH]ONhHOZJYB^I^ODhK4aLQcN5B6:b6jJ7&dgLKDLEKXLCbNBKJ4IAOdJIDih4hhhcDP'iA>iii^JeMAj\7W[:;(-PTJVeJZ^ZHEIHCI\;MVKWOZKNI9PhZMN'NZ^N?LJWLGPKW.f9;cTN(3S\GUDgiJNJI/]L_NIWOH5DK`Y/k]KX;]I2ieSJ8OIYOa'JLTAR,hYEC9TTKe83EPHN;iQiOZ^6hhPI>dIZ<kY(khWNZ]JGJZPJPMiOID48hTGZO/<V
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2614/ccs/rev np:i:6 rq:f:0.993526
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCAACGCAAATGCCACCAATACATATGTGTCCTCTTAATGTTTGCATGCTTAATCTTTTGATTATTATTTCCTCTTTCTTTCTATTACTAACTTTGTAACTCTCGCTAACCGAATCAACATAAATACGTCAACGAATCAAATGTTGATCTCAAATATCTGTGTCCATGAAATTTCGGATCGTAATCTGCTCTACTTTTGTTATTACAACAAGAACTTCGACTAAAGAACGGACTATCTTGTCTAATAATAATGGCACTAAGTGCATACTTTCTCGACTACATTGACGACTCAAAATAAGAAAGGGAGTTTTTATACATTGACCTAACTCACTACTACGCCTTGGTTACCTTTGAACCTTTCGTTGTCAAAGTTCGTACGATGGTAAGTGCTTTCTACTCCTACCGCTATTTGGTTGAGAACCTGTTAAATGAGATGGTTCGTACAGCGGTAAATGACTTGTTTGAGTCTTGACGTCGACGACCAAAGCGACCACTTTGACCAATTGCGAACTACTAAATCCTAAGCAAAGACTATTAGGTAGTAGCCAACTTCGTTAATTCCGTTCAGTACTTTTAAATTCTAACCGACCATTCTTTCCGAGTTGCTTCAAACCCTCGTCCTAATGATTTACATCGAATAGAACGTCGTACAAACGCACTACTACATGGAATAGATTCTCTTGTCAAATCGTTTTGTTTTGGCTTTACCCTTGGTAACAAACTTCGACTACGTTCGTACAATTCAGAATAACCTCTACCTCGTTAATTGAGTTAGTTCGTTAAGGGCTTAAGTAGTTATTTCTATGATAAGCACTAAATTGACCTTAATTTCCTCGACTTATTGTTACATCTCGATTTCCCTTGATTACTCAGATATATTTCAGTATCTACTATTAATATCAAGTATGCTAGGATTTGCAACCGTTCGATGTAAAAAACTAAGTCAAGGATCGTCATTTACCAATATACCGCCTATAAACAATACTACCATGTAATGTTTGCATGCTCTATCTTTTGATTATTCTTTCTTCTTTATTACCCTCTCTTGATTTTTTACCTATCAATAAACTTACCATCTTTTCATCTACATAATTTGGGGAAATCTGAATTAACCTCACCCAGCCGTATTCAATCTTTATGTTCATCTATTCTTTTTGATGACCTTATACAAGTTTCTCGTCAATTACAGAGGTTGCGGTGGTTTATTGCCTCATTCATTGAACAAATCCCCACCCCTCCAAAATGGATCACTTAACATATTGCTACTGACCATATTTTGAAATCGAAAAGAGTTACCTTGTTAGTTCGCAGTTAGCTTGCATTTTCGCTAAATATGGGTGTTTACTTGATGAAATCCAAAGTTCCAGGTTGATTGCCTTCAAAAATACTGTAACAAAGTTTAGTCAAACTTTCTCTCCATCTCGATTTCGGATTGTGATGAATATGAAACGTTAAATTGTGATTTTTTCATTTTCGTCCACCAAACCTTGAAAAGAAACCACGATCACCATCATAAAATCGTCTATTAAGATTCGGAAATATGAATCTACCACATAATGTTTCACCAAAATCCACGTCTGTAAGTGCAATTAAAATTACCTCAACAATTACTACTACAAACCCCGAACGTAACCGAATGTAAATGTTGATTCAGTTGTGAAGGATTAAGATTTTGTACCTCCAAACTTCAAACCCTGTTTCCCTGTCTTACCGTAACATTTCTTGTAAGTTTAGTGTCTCCGCCTATTTGGATTTGGTAAAGTTAACAGGCTTCGTCTGCGTATATTTATATTAGTTATAGTTTACCTATTTCCTGTATCTCTCCACATAGGCTTGAAACCGAAAATAATATCACTTCTTAAACTGAAGACAACGCGAATATTTCATTTATAGGTCAGTCCAAAACTTTGATGATTAAAGTACGGACAACTTGTCTCAATGTGTTAATCAAACACTTCAACTATTGGAACGAGTTTATTATTTGGGTCAATTTTGTATGATATAGTCTCAGGGATCGTCAACATGAAAACTCGTCGCGTATAATTACTTGGTGTGTTGTCTTATACCTCCATTGACGAATAATCTTACATTTCGATTTCCTTACGTGAATCATCACAAACTTGTTGGACTCCCTCTAATATCGTCTTCAGATTTGTCCTTCTCATACGATTGTACATACTGTTGGATGTTCGTTTACTCCATACCACAAGTTATTAGCTGACCACACGTTTTCCTCAACTATCAGAACGTCTGGCAGAACAAAAAGCTCTTAAACTTTTACTACTGAAATGTCATTTACTTTAAAAACTCCTTTTATTAGGACTATATAAAAACTATCATGACAGAACAGTCCGCGAAATAACGTAGTACATCGAACCGAATATAAAGATTTCGACTTTTACTATCTAATCCACTGACTTTTTCCATAACCTATGGCCTCTAAATTCGGTATCCAAGTATTTGCTTCTCCACCCGTACTCTGCGTTGATACCACTGCTT
  +
  NLSWbQUDx\XhXMwXQW;9SO[IC%mssssssmc\]bjqssssssrjb^_^\^fd\ZZXStQP49=kJ2DI7GsOa`dXaU_XQTPhFvOCUsKyhP:RR(PTKIBTq?oST6gRbMJWsc.PLHPp=bPP2`oU0[TQYb0kFP7NoWLt^<_TaTRBfVQV>PpH^O?dNUWvTYTB_oZcWRiXTvXPGf`C<spYNTpQcTUjT4r8*beWe>QPhIyb=;Ip]NvjD5e_<@OiEvfXeLAhSYMW<vwhQYvcXvNVUeVTtPRuU6]GNcXiLwtQTuX?[%UidhXDkNPBL:aeMYh@qL?`WdVTRW;P:T`=K@@brVfXO`S<cVKFN?bWQeWiV-uuufEo=2^I:yqL<;m^STbRbWbHP=6)D=BsViU9VUcV>aUPDuET4`EKdEvM]qQVh:]@trVQYvO]CG`QM3CU=hcV?be2GgKmNOQV-pWRhcWiCaT_EqBQgMLpZ/X'51aOA`8ehLBqIvtTP[6[JDyUsR4V[>BHT=hc:nXRJ_T>cO/cI?5-bCSn=`A<TU=LVR_EYBibQWPcIxcUBb]>\%[GcAkQWN@XBPLUTLtvf6YgSt=BJsd;bWjcIg79hTbPRbNFYAqRBnQ=FrVwUtHsL8IReQTbU5]o]IvsVdW]RpEoR;:gM)BO6hWFsLIKVuMV6rV<\[3pfQIBgHnARvT=cIm<2U_VVO8O>[>DaVONSGeYW3tfWOR4UjbVV^W][=tCtbHNaSmTLVRgO=F=dtST:1bU;;(UeN0oC@^\Q.^oDr?xhAWD=rtU8dAOaB\aTMD[RO*_CM]4_R`:Lp_?pFviWic<yiWP6q0r&U/J+DDK>DfV@DbEd1pfU9sTo>PE/6bK6otVaXAOIXGVOW_XcHiuXvRO6sVtTvAvc8ujR>\NRbcYvME]cWdiVjUPML]p@xpN%;$6'^WiVLN\=O^_LqvWdQhILWdcXbBSlPbeceXEdMA@UOBP5>tcNwuP@GsEvQYvVOJNHQ2stwwjVhEvQTUAt?wNaT<RV_(`^I,RIi><MSIsR;V@be%bBCAs7WUTb=M7Z.RSuT?@WpNR5fQWgWCT665b>cPcRxeEbTLkuWVsT?]pcUuM?xqRVQTFpO`6ql]mtcIygMgBDr_;puWIt\I{c`WGvuiXdFSV@THR3fKYr&\eC@fvgXgP4jWtTvJzeRa>UdcRIqO`LFrVMwfXNtd[RM54+[hVIc@8C0\p[SLPP;ICqE`J[PUNpQKvvWgYRdWVwAxcWcQ_,\GGQVAs]@eDrsbVcPHfiWcVqRcYvQVtWDupT4vvva2pswg<_=twwiAv\iVa0TrEqUG+Y6qPVUa.P=_Gq]\?)areP>mc`UO+pttOcLGrdIyVsQWveRFrS9UcNGkK=THsPVN&bqrVQWiBxmOM`2ee_N=[a`XAkQdg=>swiIw>un=IqIyb1uHa>dTuQFvHtR8\n\_Q41ROfCtVFY\P@tt`MiXKv^/C\kTMVf)sJgSYQQcNwwV8yZVn;SO9QOFtgcQI.WjSI6Z>_`9pM\La2O60.KUN9to\TRi=dMEu1ttFtDqO&stSRDtm;fbCOcL(IGo`gU^g-t_^TWQFE9YUuNqO`VvU%iGqvich=PpOUSa6tGR\?R^hP1]`WcFv)rulgFva0L]W>NiVrOSQU4tFs8uvqA\`8d<UTtXRk4mVXj`SeVR6u>*`6KOHiA<gLc:fOVvSQf.r]`AB]QaDYVcA9B)>>OmAqJStQVN]-caMA9UIb[6B<itVGtW=uu/lTLQNsu=utbO>>1Y^+f8)'30G,Ud0CYQQCs;AqfI'O6BRR5X5&Mbb:VV3rD/sA5V>8a_8@nHsX_CaH8ZP;YCdLW:6]Za<K=YO[?aN@Xs`]POLud`Iyh`/D^9hQ1HEIPfVf8kaBc`a2^@U]L3tTDm9/DFC\0lU_ZCOA&nARU/ssDe=UrQ`USXCPV?KsScNvvXaAcsba^Aa+TcO^HqDuvuX,^DJ\iM@7q=PO9[cWCycE%VUXqN9TcD(NQOf9OkCtfB&rZS^WYvXAUSZc@T:p5fWPeOI__XBfb>aW*LTgBSu4ti?62E)MOfbdNAVR@T]'aqaiVOQVTvX`?M8Z@PTRSQiV=S>CWSDuGd\WCP0thOgQLpRdBPF^]U7V>9__Da9]CLRuiTvhVJucWcNwnBOLAo^@NHacWOT;LsTUJXWaV4\_UI`>D[CbZWS3svgWhNxgLRU=]R5pAcQcL_XQdFt&oUhVdieVOYPrQTaXcTVRW*Ra4OJRQEsVK9YR8Rg9\\?a>vbB<eQ8\bUbT?Vg>K4s\@VLPEjYj=riWUgWfIIBa=EmT:cV_>X>aOPhU6j_OK=I?EES3kXO>%@ocXidWiP<uueQ<Uc@[pND1j9+esutVbJfFvvveUveBzcX`Lfcg'uvurVhcVWbTPaDXH0sVcSi'TRTQ%qOPEvVBdDN]MUaZV=Nf8cMDsh^?4nO+`IU^WQ_=-VUiNWebQVf4ufIybW^9YVBvvv[6taR4t)UQL]&rGmhXeLwwWbT6h_X_<rH;LgM']SQXWvT_HkM.ttPjcXiWiRWQ4oJaRI7p_JVMKB7
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2616/ccs/fwd np:i:6 rq:f:0.994842
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCTATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAAGCGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCAGCATAGTAAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTAACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAAGCGGGTAATTCATGGGCCTACAGTCTTGCAGTAATGCTTCGGTCCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  f~Zer_rN~rnhIGJH^dq]E^r\d%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ldrrr^dbPO^rM~ZN^n6YR~YJj\rP~[drU~_kIDpP~l^mR~Y^YdD~r?xmdl^NGNCOxPiTmOpL~^R~?~~Izdq_pInIQ~cH~~b?~q_q\\r_7~~~~yd^OsP~qQ`}4~g8~rerYcoZpSkrrf^^fd\X[Ta<8g[B~~~nMN~^O~hQtb~e'edQ~O~~~kN6~{ZMBxr_ea~IpF~~frrF~~OpM~K_O*~~f_*f`rT~~lq`oT[hRmU~p]7kZ7p~nYU~~fs^OjYkGVDZ}Rg}YnZb~_]nb^`d^F|Sue:~~~~`a\ROc^pLnJVaSgfLc]cLbHxRVc.YUEvN7V-_[UeOXNeeff[fT^Hlw[gYOd_Ue`H:iUQ=vd7wILEX[fV[TsXWLAdZfZKpUOcV[UN4sUYNZHyiEeVd:Hl:V->O?saOAB[e6x[4s2xj[UA6WOYUvJUI_A?HusPJ~gWQKqI`SgVgeVMKwgW<yfU3uZfIYd;lEvYPZ0~jb+ZS[cB8UgGgG\GZSv*vUO*r\-`nf1yydUPX4sZUPXKNAwxcNT=ZVc?[fd3ur@e[ggbAqwf[ggggVg?nVLwUMKfVb4eZgW]>er`Wd*F>_W/hMA^A~tFvJwN7vwcePYBtDbDcaTf>xxxbHuF/nteJ~O[dSWSfV]TFxlTddYNP7osmYxZP9zxcG|OTMdWcfVbb@xsVd_IbBuo4rVEUe=w`@nYd-c;REemLwPxxV[V;?kGxO-J?L'lVR[V%kstVVX%wMKwVePUfdNZfMye:tJy[Ve5zDeUNTd;WXxN{fZTfKwJy[Vgd?5qaSYfdJb+cVdEIpDuuWrT:FY8Y_VGgUSfPxxT:deedT$ZFUWfgW[VyYMd[PxxVdAN^YXv[f:Te^5>_UNDuWecLvVYNVxVeeLU<uOa:X0neWyLxwXfV[ggVHpXfaPXxVgLwfe0ttZV_[UEUZ>O5wmIUsUOMOTJ%uYeGW?KBJ:T:tedC?C\Dgb@9h:JCN1@H3E8YCl)rd%nYVUUQVeVO@eGj`YNT<Y;SL:UcEWxV2xj[bLwfg[g[fU=YXx[fFvR_ZJ~[VdNU?Q+a:SEeUP-zpWOU>*YVM?ZUVuVRdc\WvAV6aEegVgN{gdEdLg8?tUzgVOxx[e9zH?AxVgUPe+TPEvdEe[d>TUQKPEqHxWxgc1:SYPZgLwfW[gggVe6kUfU4tZ@bEeV[gg[YxK{gVgg[WVwVb/_FuxW)VVVQNFbL6nvRf[gWQJse[Vg[fUHuWeefZFvUPdV`BpNdf[JqKvd@MXxDysUDEuVfUAR^gggZ`5dFRd'X&STVV;]KCQ'KE_9ZLEwEUg[fZ6tVySWYPHyrPaPUgJ~[YxJ~[Vg\Vb.[]<tee[V`?IU[VYvUFvXOUEwxoXWWAxqWdED]EdFyx[f,eALwPb>,tYedNI~[ePfU[aWB2@CBPXQ_IX)QRVfbIsPEx6XV@eIxd9a)_7IObVgfKwQH1wxSFcAZfBnT`3c_VgdD;vwwfYxVgVg[UPeU\Uf8ye>hPMzJtRUDWwfaRHvUbF{e\ClYUZ7fYCqT99tIVTYPUUPAdtFH~f?vi5xLHdM>2q?wwd8VS@wuHgVgZPdNTFve_WQxgVgYwV@wvXLMX6Q[jVVvXAQK`][\I2b(_XTIF{TcUl=\EUXNTPU_dYA6^ue[eAZXv8wEu-F<uudFufWxYAZaADuJ}[VYNKRs[Av[fAxxeTJ%uJZK:PaO]7`aFuTEa=btSEBWMWQSEGTsfG~E6nxeQ4_%SFveW>xxxf[:TSY3quZVfg\=jOP?KfFYYSXeBzybbVb>[9?@>MKOQXQ3VRf[gXx[VZeO8@>ZVfUO=YCd2VlUFve7_sN%OpSYa:seXx[g[?nUPeG~DuMQD_g[V[UhULwUPeG~;vwvT7scPeB~k=^?\\WJiNG}9vymVVtJ~eFGT>FaCeT8WNIe4ycEUKtUQMrVfAxw[Ve%tttZfVXY=eG~[G~?qaWVwN{fYVZH~[XxH~Nxv-SK/OK:do`3uUNx`%VWV[.~ogWxUnYSS$ZAG\fPV%Tg[M`DWLB`-`UW[UsQEt_1rlI>PV>7=3^VYJJvVgfE?pQSI?/cy
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2616/ccs/rev np:i:6 rq:f:0.993526
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCTATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAACAATTTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAATGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCAGGGACATGTAGAGAAAGATCATCCCTTCACCAGGAGATGTAGATAAAGATCCGGGGAAACGGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTTACTGTAGTCATCTTAGATCCAGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCTTCGCCTAAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCTTCGGTCCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  e~P^qNZQ~XpnH:~Z__n`l_Ul`%~~}rsw|~~~zupf_^gw~~~~|vmbagq~~`^pqZo^pkGJmTwYHcr`o-~Q[rerR~];\ExepHWoU~mZYLnNYaYFwv%}pr_r^YN~eb~:fWX[h<~`]~:~x_~HVKYaY<?q]=vg]:pN[\oNZ9;{~~no^aFeJlNC-d7X\QxJZDh_rrq<~qr`eO~^aIQRs_U~_>p]pr_L~e>~rN~a~^A}]Q~*~~~^WHO|~f_L~rf_P~_hI~~^\k:mlTXM~e_d4yesL)~bqR~~rs`Uperb~N~\qN~YG~~nr<~='`\p^pO~^a~HkkL~dO~^er_fr\fP~K~^5|~~plfl^t^qN~^T_bgrN~\qP{=~pbgb]b<dkL~W~~blp`qpXYp_rer<~w`n_a~W]Wa9~xerN~rS~_PTPUa.L9]9GG:A@MMQ[0UNYUYLCs,?@S7q:'C?I^:oNR)+Z(_cLTLS%JlfYx2_UT[WeW`REtU[UO<K-jR]HvKTe?l]]ZeZdRIQFja[J~g[3pA^+bG{EY>^U0iXZEcVPeVZJdDg,bcUCVIydHgc.cjc2^]=/\@5[STDVfc:Y9ef\gVY(O<NLB}~[PQH`b@ggcD]NLcZM8tF.KCdHnXe%uVVgVe/mjd=[.D;[S>nqJZ4YYGoIsN0zrefgVTg=lH]_TF8gfxaF~f@}~f+wkeWfeZOSZaAHlvXVMVdJ&wwIpVd&xb:Z_Ya7OMeYNc9kXZgdC[)sv81eZK(MaIvc6adJU^-d6n]Jq?vvY?VTHe?Y\YPUgA~~bRA%`_aS?8cl]<YRPf[fd:TPDVOG|EtII\(o>MYNW&<XHkFq^R]88LBW/OINXG^EXAHF@`5`FeVKg$rr<l\eH~gVgVVn@SbHadYA?KDTZFvZTWTfYWSbVMeV>vsE^S`eVUxWdH~fNDzJZfS`TKdH~[UPAgRILP@GnARAVMzgWn1vvN6AS8^U9kVH_]Ir[a=`ae@vvTF;T[V[UCt>~~[JiFdT]ZfMyWgYLAVVgeBD{a*SMLb:}e[I~XF1oTY:V=?V,o5wC0t]\[c7^B7OCDb>VTZA|cA8bEeVYxZ3fdVYFpQKGOUeEFh$]Q9Wx[gVLwSP]`V[UAId\Vf[`2b_ccVGQTD\.JE/?:ufVXx[Wd8>MdWJ5{ec<F6v^8_,SHR/ZUI>+YS`@9NOUALDY_9NU@WVaWZM?OW1u;[UaLeVFvVeVd6|eZBegg[gfINX3uYH`HcXScdU/ZPWISdgV[Xx[cVe-:Pk;tweEdGn_?^uPkS_WKG_PUWHVdZ7jZePeUCtYeOYOWwecKP3t8zeT6Tu>~}ZTC`Uf[VFvcE]@KTG=/L(r9pxx]BxBH]ND\@UT/i:Aa>PT+UNQ_WS`8XUcMaVI2POEgF[FOOUHR(g>=ENNcVX7SSAFB?\/Sf+^RElxs\A>2Z]_:DXe?YAY]Ug[g[H~dbIOd=MbfKqTU\g\V$`dAOVFfW`We^>GbWGM91[Y(BKQMY:plUPXI0=QPQ]JEdBR:R_aP3091(N/`A_C@1JA5UFPJ3G?OKL>>MSABFQ9\Z<jUDaKO<M>CZRF0FVC0>WN=A`PE\:d?C[2FEraRP[[U?V:>FK@k^?loHwfDX2QQn.osZH{Z?wtAIEdS^K[[Jyd:W4saAEJ_[=xxqTN\@4rxiY2s?WFDu]VKeJs@wwXcIe@VOYEdVXSMDdEg\R04j|eU=YVEt:tWxH~&qKMTwQEj=.ReEVt=uT\RggUbV?nVRGspPYe8xrXx[XxgggD_fXx[Vg@~u[GysRg[VfV5teNyV&rss\ZA}gZ9weZ9wwlUP=_Q*9Z\UZML?<hUZ`8iFL*V*eaH`WVWY:;t`ZVY@7@YV[J|[gWRWqVZCOTdLLL6NYPBNMd?vl?Dve;wwwe::X,_Ezd6vUfUFvZeP@rYxfVKvdWW>Zc[,`[gfLw4xyjZJ~b^f)uMH~IbaXBhQIe&X`PN2C4\K=S@UN:FSM[Q=10%['SFCW>MClZO:wwUY:8vwwUf,PUePJtA;tEqvZEq5{eW[SJvVYxLwDy]=xeVgg>~|gTY?C[8B]ZVB]WT=a1TQdK<u>&wKIA.cB9Q7rYWgZHWcV,UoVLwf/at~eZPc@dUNCUY4sYePeJ~gVg[W_z
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2628/ccs/fwd np:i:12 rq:f:0.995312
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTACAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTAACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCCTAACATGTTTAGGAACTTCCCCCGAACGTTCGACTCTGAGACACCCCAGGGACCGTACTCTAACTACCTACCTAGTACCCATAGAGAAGTCTTTTGACTTCCAGGCCCTACCACGAGAGGTCTAGTCGAACATCTTTGATAGTAGTGTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTTCCGTATGTGAGAGTAGTTGTTCTGAGAGTACCTTCGTCCTACAGGTAATGTTCAGACATTCTCTTACCTTTCTTCACTAGGGTAGATTTCCCACAGACTACCGTCCCCCCTCTACGGTAGGAGTGATGTCACCATATAAGAAGTTACCCTAGTATGACTCAGGTCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACCTACTCCATGTTGACCTTCTAATGACCACTAGGCTCTATACTTCTCAGTGATGTGTTGGGAATGGGACTGAGAGTAACCAACTCTTGTACTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCGGTTGACACTCCGCGGACAAGCCTCACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  ~~~=|~~n~~v~XV~^~]t~q~~vY'~~~~~~~zstz~~~~~~~~~~~~~~~keIQ~~k~~jI~~Ic\N~k&~~~bj~\~^D~~~~N~~`~~~~f~b~Z~~_~v~_p`z~~~~XhEHl[w^j_~>|~:~Wx_Z~~_~D~qda~J~~g~uuyyG~fM_~~4~d[LlR~g[~AnZt.Hhl:W=~aH~~gQV_K~?}p~~~j~Yau~qP~Ys]~~2y~~l]]|{X~h~p<|i~xxMw`~f*~`:5~~c[PO}yL:PKvO~CZw~aY~~nU~_^0.VliDu&~Q)l8wQgXJ~},~i`~ab~Zm]4vc~dd~2|]qgT{W=YaaRZcG~D~~n'~As~Y~2c4~~>g~G~~A~hommy4b~\}}Ce^Va{t^~\\~^~XmaHlIt~NG~~msSnl~U~b~f~I~~N\Bah~0p`|`~RLK~o`~L~(}~~Kv~_c~~h~|5]'x~~E~~~qN~~G~\iMId_Ph|f~~Y>~~~lZl~J|}?ybWZ~^yrz{~v~.~~;m`r~~~u[{}NeP8tOC|u:~k\~%ww`~]4u_qU~h~QK~R~K_~>~~6~[Z~~DdaYnQKbOl~.{jfjtf~^k\~Z~^V~^~~`~g-I%VKJzR~~~F~l~KU|Ufd~^~zC~~[<bqvY~L/432~R|~[Qx~~.D~~~~s\wy9~g\q3~~~c?~qV~wxjgz~^~~~~:~Pm<~}]U~~~b_u~~^}~r`~w~F~Lfml~q[~8iQJ~~=~~MN~kv?[X~rO~~~~@~ZsdWP5bCZP~?%h<(Ht9nUkS2~~~~~n~~y~o~~ZgTb~sSQ~|`s~~~a2~O~W~t-u~oY~{~~X~}X4~JLjqN_AmMUW$j~L|R~WPMB'T;ifTz\~e{P^rs2_by3V|~^~=;w~~*~~WJ`qDi`e~~~~}~w~~yYIYsTu+B<y>[:X~h`~~~SA~~~UkvK~~+O~[v~~~)~~~~a~j~Kn~~a~?V~s~]vS~~bxuz~W~~M]~i~~rqscWqo~~YYYq}D8vA~~u~P~~~\[~j~kY~~F~~~~w~~~o~~lox]~~~kep~t~~|o~ZN~Kx~~~Xl~~~k~I~~~9~~~~f~ftf~~~~~}PS|e~b~M~~Ma~z~~hY~R~n~~w~~R~~?~~N~n~~=jYtw~~~~i~~b~s3~~~jd~t~~Sr[~jUt~nlz~~x~~y}a~l~~F~f~~fn~~e~~~w~]~~c~{?~~~@x~uZwYe6w~H}uIm$ld$V^P~~~~V~~~N~w~S~c~~~fB]Cc~~u~H~Xxgb6OYsDZ:|x~xl^bi~t~D~~H~~a~~]\~~~~~~~o~U~m~f~e~~~~S]~yb|kp~~n~~fi{L~}t~ik`R~H~~m~~~~~~T~~~v/~~c~O~p~~j~k~V~w~i~h~F~~~~~~r~~oL~~hp{0~h_~ta~j~~~~~~~s~b~~{~Hd=~q~~~~G~rQ-w~~q~~VLzQ~?u{aZUGOQQ{E~~a{+~u~~~~R~a~~g~p~~~~~H~eg~|j~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2628/ccs/rev np:i:14 rq:f:0.996596
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTACAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCCCTAACATGTTTAGGAACTTCCCCCGAACGTTCGACTCTGAGACACCCCAGGGACCGTACTCTAACTACCTACCTAGTACCCATAGAGAAGTCTTTTGACTTCCAGGCCCTACCACGAGAGGTCTAGTCGAACATCTTTGATAGTAGTGTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTTCCGTATGTGAGAGTAGTTGTTCTGAGAGTACCTTCGTCTACAGGTAATGTTCAGACATTCTCTTACCTTTCTTCACTAGGGTTAGATTTCCCACAGACTACCGTCCCCCCTCTACGGTAGGAGTGATGTCACCATATAAGAAGTTACCCTAGTATGACTCAGGTCCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAACACCTACTCCATGTTGACCTTCTAATGACCACTAGGCTCTATACTTCTCAGTGATGTGTTGGGAATGGGACTGAGAGTAACCAACTCTTGTACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCTCACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  =k`~|]f7sb~^ic~~d~~a~f~~~%~~~~~xfkx~~~~~~~~~~~~wkjs~rns:obO]u^;`|\s]~~aS~~^aq8~T~~~~z`y~aw~Ak3s~~~~~c~~]~~~H~~H~~N|Z~~~{TKSfa~a~~q`ty?~~U~4~I{~g2~~yZLtR^~~~p~~b'~~~f~~}~~f~zU]m4v~^n~~?~~~lp~f^s~~~X[=~b~3oYj=Cb5hM.ZgxjG~)9y3Y>wp~Ma{t~`}9}d~~Mz~S&oYFHBx~V~X~~Y|v~^VGzqUw~Z~~z~i~~r{N~lu~^otd5~|0[Ed~vA~w~XsVBmdd~s[s;~eE.vuFs~~v~~K?}~~[~WwKM~uWPr@nQpkoxl~F~~:~}.PF~h+xCv\NdZcHQ`t~e~m}Ia~~`~|ZzY~L~G~~Hk`R~~~~~~`~`~wRO~]c4}hbbXpaVeMr~:~~lPFy~~~X~~~d*HYId?~f~E~~_r~~~'~~~~uT)~~~~g~^s~~~~~~~U~v~Eb`9~z~b~L~F~~dsl~_~]~~N~{X~~~~~V5`d/~~nZzP<t~S~~cd~it_$VXc/~~~uK?~~~-~}~~M~4~~{~_~~~__~~N~~~~qY~*~l~C~~~~;~~~c~_b~~|~jEexomN~2bj~qy_v~m~~~Q~\~Ow~_x~M~~wN~z`~f~~K~c~~n~l~~~B~E~:Q>~Y~Lu~^tt~~~~*u~_~L~ZyrWd=Vf2pHi~~XZh~O~k~hkP~~e^~~`~Px~]btX~~Dip~>v~\~_~~~=~~V~~C~pm~M~~l~Yes~_~d~:l_u~^R{Q\y~~G~;}WGyj~a~~L<l_~~~3HKsuua\~~~e~~~]~w[~p~~{~F~~~Y~l~~$c+~y1q~[uL~pH~~~~~Zg~x~VpHd9_Yv}~d~xjF@~b~JtbK>+_UZqz}n~~r~~z~`g~]c~q\omKrXb~~Q~~~~~J~sR~~~~~~~~~cz~op~]~xG~Q~~~g~~_rU|~:~~ltY^g`~W~9tcYT~p{wb~^c>Ry}w~aKzC']\~diXBy~~pD~~V~~^~GW9du}jkn~1cCORv~e~~`~~~~~j~~~i~~Gg/du~~~H~~~2n1jf~~e~~uNp~ucO~~md~~~~~~~a~M~e~~~j~n~~Q~~}q~k~~U~~[~k4~~v~~e~}~-~~~~~~m~~~~~efPeqF~t~7>t}c~l~~~[~~~_W~M~T~~~Zft~~~p~Q~~~~~U~s&o~~a~~~~~Y~~pBj~j~{~Yvv|v~w*~c~~~~~R~~}~O~8~ba~~u~g^]e~]WuKNdC~~~~~0~~~~rg~a~g~v~m~j~~QqSRRkA~~f~~]]krQa~\\~~8~\Lg~n~L~{~fm~\EIbm~O/T~i~fl~}k~`uQS~~p~\m~t~~/~~YCcW47e_BeJ^~~g~~~T~~~~~`~v_p}9~apCDy~~~~]~~Bo6}~xD~~=x[fP~~~~~~M~?~~~~~f~~~~~R~~~Vj~zZ~nd~R8~S~l~Qf~sjcu7Z
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2648/ccs/fwd np:i:9 rq:f:0.998685
  AAGCAGTGGTATCAACGCAGAGTACGGGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCGGTCTTCTAGCGTAACTATCTTAAAAACTTCTAAACTGCTGCTTAGTAGGCAATAATCGACTAAATCCATAATTTTTGCGACCAAACGCAAACTTCAAGAATTTTAGACTTTGAAGACCGCATCGGCAAACCCCATTTTAGATACCACTTTAATTTCCAGTTAATCTACGACGCAAGTCACTTCTTTGTCGTTAAGTTTTATTTAACTGTCGCAAACAACAAAATGGTTTTCTAAATTTACTAAAAACCAGGACGCACCTAACTTTCTAAACAAGCACAAGTTTAGCTTCTTCGTAAACGTCACCCGCGAACTTTGACGCAAGAATTTTCCATGACCATTTCTGGTTGGTTAGCCGAATTTGGCAGTTCATGTTTTTCCACATAGCCATTGACTCCCACGAATAGGTCTCTTTCTTCTTGTTCCATGCGAATGTAAACGATTAGGCGCGCGATGCCAATTACTTAACTGCGTTCACAAATTTATGGTGAGTTGATTGCTCTTTCCCATAGTCATCGCCAATTTCCATTACATTGTTACCAACAATTAGGCAGGCTAATAAAACTCAAAGTTCGTGTCATATGTGTAAATTTACGTTTACCGCATATACAATGACGAAATGGTAAATTAAATTTAAATTTCTTTGTGAACGCAATCTACTATACCTAAATATGTGACGTTTTGTTAAACGAATGCCGTTTCGCTTTTCTTATTTGCACTATTACTTTTTCAAGCGGCACTACCTAACTCTCTTGTTGAACAACTTCGACTTCGACTCGTTCATCAATTATACGCACTTCGGTGATTTCGACAAAAGCGACCACAAGACCGACCATTCATGTTTCATAAGTAGCTCACAGGGCATTGCAACATTTGTAAGACCGAAGACGACTAGTCCCATAGTCCTAACGATACGTCCCACGACGTGTCCCAGACTTTCGGCTCCTTCGGGCAATAAGATAGCTTCAACGCGTCCTAGACGCACGACAAGTGCCATACCTACGACTACGACTTGACTGCAGATACTACCGATTGCTTCAAGACGAACCTTAGTTGGCACTTTAGCAACTGCACTAGTTGAAATGGCGAGCACAATTGCATCCAGGCCGACAATAGCCATACCAAGCGGCACGATACAGATTGGACTAGCGTAAACTATAAACACCACAAGCAGGCTACTCGTGAGGCTGATCGGTCTAGAAACGTTAGGCAAGACATATGCCACCGCTGGGCGACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  ~~x{utnb~~t~ue~snr~w~[UqyF~~zvv~w~cw$~~~~~~~~~~~yx~~~~~~~~~~~~~~~~~~~~{{a~~dm~x~tufv~N~N~~|tm~:~~~~gr~xZF~~LiLw~u`j~qv~~]~bp~~S~~y`~|~X~~l@~n~K~7~~~~_t]GH~Y~~uo^E~~bn~u[~st~J~~~stbvE~~^b~v~P~wwu{YL~w9~~@~~~tK~~~ngtl}E~ivV~~`~S~~P~XsK~P~mZjispluugQ~v~dlwo~}^~~P~x_^~b~t3~~~~O~~G~uj2~|w{Y~~dg~eKq~~~a~:~~w`~T~qP~~[x~/~~~dO~o`~~vc^m_~~u~|`~~f~E~~rI~t{pxq~rU~~[`sQ~zs~whf9{vIs~Jg%~;B9db~{a~~u]^jwe~t]~T~~~O~Op^~W~~C~~yoc~c~O~_~~KO~oRoE~~O~xuu_~uIUD,m~~KA~~|~n~r<gsW~CkqX;~~xe`S~~~I~q|u|c~~fp~w_~u_~c~po^es<~Uu~W~~lhur~~\~JbtiutT~g?kT~`~~~g~Z~~ag~~R~ifjM~~;~~~~l~~~~~C~}zb~Sl~mY~X%~~~~h|~~~aw~l~^~i~~]~~z~{U~X~~`~~U~P~lb~u~\X~~~i~~ai~~Q~~~Z\}R~~}@~~~~~rzv~~~{b|~P~~i~~~o~_~~~Z~~~~~{~~dV~r~~~~T~~~Z~~_~~g~I~{N~~O~~D~~~M~~~~ik~~~m]~~~az~~w~c\~~l~~~~~~~~~moQ~~~ig~V~~lyV~~ji~g\~~UR~(~~~C[~zj~~{Tww~xy~~~?~~~~~Y~j~d~l~p~?X~nw~zq~~~l~~V~~j~~S~fe~n~~~{~oxceqx{Z~n~~Nq~l~~z~~~~~~d~ki~wf~]~~~U~r\~~~~~~~M~K~m~~fZ~~~o~~n~~W~}l~~~~~f~|x~~zE~`v|J~~r~e~i~[~s~j~~~tj~~~j~~i~m~l~~~~j~~=~~cz~~~R~~i~~||uh~~~Y~~chghNb^NgB~~|i~~l~~~j~~~l~y~ZI~~~k~~t~fz~`yqi~~>~r~f{~N~~X`{m~Z{t}QpR~j|~j~k~sm~y~^~~~~~~~~Yh~~j~~~u~xc|~~{~d~N~}~~~O~n[~~~o~s~g~u~~~D~V~eM}N~~`e~]~~xgj<jv~|Q~}J~~~f~yx~}ue~k~X~~~w~a~lf~]~~~ng~~dzI~~~~\n8~~o]~`~z|~~xj|hj|~g~~~~~~fNn=~~gr~uFz~~|]~YyA~j~{e~T~xx~~~~h~g~~~h|~q[~y~~~if~~~|h~~l~~H~}zitu~wgC~7^~r~~I~~~h~0~~~~~~~~nvi~~l~~~y|B~~wyjxs~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2648/ccs/rev np:i:9 rq:f:0.998161
  AAGCAGTGGTATCAACGCAGAGTACGGGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCGGTCTTCTAGCGTAACTATCTTAAAAACTTCTAAACTGCTGCTTAGTAGGCAATAATCGACTAAATCCATAATTTTTGCGACCAAACGCAAACTTCAAGAATTTTAGACTTTGAAGACCGCATCGGCAAACCCCATTTTAGATACCACTTTAATTTCCAGTTAATCTACGACGCAAGTTCACTTCTTTGTCGTTAAGTTTTATTTAACTGTCGCAAACAACAAAATGGTTTTCTAAATTTACTAAAACCAGGACGCACCTAACTTTCTAAACAAGCACAAGTTTAGCTTCTTCGTAAACGTCACCGCGAACTTTGACGCAAGAATTTTCCATGACCATTTCTGGTTGGTTAGCCGAATTTGGCAGTTCATGTTTTTCCACATAGCCATTGACTCCCACGAATAGGTCTCTTTCTTCTTGTTCCATGCGAATGTAAACGATTAGGCGCGCGATGCCAATTACTTAACTGCGTTCACAAATTTATGGTGAGTTGATTGCTCTTTCCCCATAGTCATCGCCAATTTCCATTACATTGTTACCAACAATTAGGCAGGCTAATAAAACTCAAAGTTCGTGTCATATGTGTAAATTTACGTTTACCGCATATACAATGACGAAATGGTAAATTAAATTTAAATTTCTTTTGTGAACGCAATCTACTATACCTAAATATGTGACGTTTTGTTAAACGAATGCCGTTTCGCTTTTTCTTATTTGCACTATTACTTTTTCAAGCGGCACTACCTAACTCTCTTGTTGAACAACTTCGACTTCGACTCGTTCATCAATTATACGCACTTCGGTGATTTCGACAAAAGCGACCACAAGACCGACCATTCATGTTTCATAAGTAGCTCACAGGGCATTGCAACATTTGTAAGACCGAAGACGACTAGTCCCATAGTCCTAACGATACGTCCCACGACGTGTCCCAGACTTTCGGCTCCTTCGGGCAATAAGATAGCTTCAACGCGTCCTAGACGCACGACAAGTGCCATACCTACGACTACGACTTGACTGCAGATACTACCGATTGCTTCAAGACGAACCTTAGTTGGCACTTTAGCAACTGCACTAGTTGAAATGGCGAGCACAATTGCATCCAGGCCGACAATAGCCATACCAAGCGGCACGATACAGATTGGACTAGCGTAAACTATAAACACCACAAGCAGGCTACTCGTGAGGCTGATCGGTCTAGAAACGTTAGGCAAGACATATGCCACCGCTGGGCGACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  J~}unyoN~~~Luh~w|xsb~ysmrH~_<}a~tW{s%~~~~wx~~~~zd[at~~~~~~~~~~~~~~~~{tW~~uT~u~~ys|~p~J~~Iho~1~~~~xu~w~X~~t^zrovas~qz`~P~mG~uZ~{pb~`~c~~~c~~op~@~~~~yekw_~F~~cxuU~~g0~`Q~{h~C~}kzH~r,mU3_~{~`~xIgElX~wc~~H~~~~X~~~~y}m})~fn'~~J~F~~P~k\\~c~Oc~r^HgH`tK~q-g_nt5~mN~~ds]`j~]~bO~~~~G~~c~v~Npw{`@~~wo~v@~~~sZn.~~~uuC~~N~~~rtD~~~b~~d~~w|x~^~op~uY~~w~X~~u_~xJ~v_~zJ~~~euU~uY~qlL8~~tepu~S~zue^~vb~~|~w|v`~slzV~~~^~}Z8~c~~W~~utR~d~S~a~laB~cq~Y~~`~u~rd~w~~{?~~~hB~oosqveN~l-~uu`\-~vqr{c~u~Y~~`pH^~~rZ~tL~bc~c~~~{r\]~~erC~~u|~c~~P~boXsSc~]cQ~o~b~~va~K~u~|dy]~um_c~~J~~j\`~uyozWwQ~b~]hf`S~}?~~~~~~f~up~s}`~o~Q~~`~~O~ltlO~yc~~R~n~_q~_~}7~u~S~v~b~~<~~t]mvT~~cp~w|~f~x~~~~aka~U~yJ~~~vz+~snb~~|~~~~~~z~~h~~~\~~hZ~~]~~D~h~~R~~l~~g~~~*~~xt~oU~~p~u~~g~y~ly~~f~p\~~_l`kzY~~Z3~~|Vh~W~~~qt~n~Z~A%~~frmC~~~~hY~~H~~~T~~~~t~~dF~~~~~h~~cS~S~|~~e~~~~~~i{~w~~s~~|~ig~~j~R~~~Z~~~~~fc~{~}`}~|~g~~e\}~~~~h~{f~R~~g~~~~~i%~~~~~Y~j~xhn~~~Z~~zk~xX~~~~~n~~~z~{~~~y~~~f~~~_~~~~h~ohd~~~O~~~~z~p~h~~k~~~~~~~~~~|X~~}~}~~g~~|~j~~~~j~{M~~y}l~~u~w~K~~~~~~S~~~[~~~f~{~~B~~it~~u~~~~~mBj~~{~~p{~~g~~~~~im~~~~u~}~~a}j~~~~e~~~}C~~~~~~~nK~~~~~~~}~~~[z~wY~~~~~~~Z~}|~~u~~E~k~[~~~B~e~h~}]~~x~~h~~~~~v~~~`:~k\~~}E~h~~~-~Vh~z~~~~~X~~A~eq>~i|~~~~g~~h~Z~s~~~m~T~~~~~{~~~~z~U~z~~~~|q~k~~i~~v=~~i~f~x|{~~~~o~~j~~~~~~~za~~~~z~hUu~~~~~Z~~~~v~\f~Sh~~~u~~~~pk~~+r~~~P~~~U~P~~~~?uds_~h~~]~~~~~W~~k~~~m~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2673/ccs/fwd np:i:6 rq:f:0.994508
  AAGCAGTGGGTATCAACGCAGAGTACGGGGCTTAAATGTCGGGAAATTGGGTTTGCGCCGCCTTCAAGGGGCAGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGAACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATGGGGAAAGAGCAATCAACTCACCATAAATTTGTGAACGCAGTTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTGGTATCTAAAATGGGGTTTGCCGATGCGGTCTTCAAAGTCTAAAATTCTTGAAGTTTGCGTTTGGTCGCAAAAATTATGGATTTAGTCGATTATTGCCTACTAAGCAGCAGTTTAGAAGTTTTTAAGATAGTTACGCTAGAAGACCGGGCAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  \~a^hae,~rhhl\5~]a\O`g^PO]@~~k1Z~B~~kal^J~}N~{I~>~`D~Z4\`Ol[)aZ~G,L,n~f^ha^agj0~~~k]^9\W}I~^M,zeO~ag&f@~RHh<~O[~QfH1eH~~h^lO~iH<~~k^G~Lg_[iHi@~~`^aG~`S~`I~R~c[C~gHf`I~giH1^lW|Hdaj7~G3FTu:gNY9pa?x~]?c\YHjaha\G9@^al^`=~p<fL_4~~xDSlaI|[%{^QW[B~eDu`^3~~|^ahIihlh^^^jR]R~l_N~~a$X]a^V~Pxh^e;}:[QjaY8Ud\QbMihaO~jS?t\~R]`G~_@~~iH9@947`al\>~j_`8~uLEY4]eN|]SigV`h^G~I<~jX~^aS~~^lh`RN~\ak^UGN~`YR]`K[jh`=~hJ]]~ak(lk(83~~Pjh`C~~LZa[Sf^J*yW~k_kalhdXIgIO~a^\~A~jhlO~_lhXp_R]Ol@~jP~L`L^J~]~aiJ]k_aN~PC~~[5~Wb;_iJ[Q]$}]Hh3~q`l_+}F|^i4~Q~]~^_PF\~aK~a]G~hHO~hQ`iQeXQ_^haiHW~ag1^jQ^R]_Qa2ghlQ~[;\X~_PF_la\IgHhRQ~h\Y0^]~aK~\\OOiZ&}OX~aE~~aX~Q~`GNnF=_z`iBa?~lRZc[`UG_kH~~h^ajhi[HH~e>~f^g7e,vnh_jQ`f[_eD6~]:~_^]~fG0`xd[K~HEF~ka)~okaiG:^^i;YX~Qj`@~~^ciHF~kQ~VHQneF4~HiQ~iH_^0~~mal^aO~~l]RLg_E~`l_H_jNeKqX~`Qj^%{\`Q]MYHE~`iH_X~a?waZx0E|\Fp_N_d_6~fR~lhalaO~a\;~`9~~~~akX~h;_iJ\?~vOSb_%~~~|\[aO~~\>~]hYd_`E~nEkL9g{~^al^h^dhgS~~f>~hQjhalgafI~_K`I~CNZ1dw]4omH~uO~~Ov_G~0~shN~QCkf^ahF=YxakbbeQZ^O~kA~jG_kN~tD~~g^fHfjQj_O]g]^&kL3qe`Q`C~ljf8~Q_O~l_M~i0^K{`\~A~eT|W?{a`kX~lQq=^jWr@~]Y`iHP]khi'~~p?fu_QJR=\YU2sFj^hO~gkD~uT~~al_?{Y`\Q`$|EG~ai2}Xr>~Y'eG_]_G^<~i6{k^aT~~h^gH~F^GflQ~9~]K~_6_Y2_o`g`^>~h;Z~H_l?~~hal[4cgQ~[QfkalQ~1~~~l^hlaX~^laO~B~}Tu^Q~][J~Mz5~M~Q_@~~i>~hHflRo;h~~]~]Dy^H_l]@~~`=I1\GR~l_N]`D~~g^_4~_X~a^lO~~^]~ala_\~J;phP`O~~aY~hQ~iHF_gM~kQ~@~~~gafA~sP~~\W$vd<~P?~~~^6~^Dnn`^ad[;_\~4~~i<~~~^]~D}T[PZ%zF4malah^\~J]akKakhahY~IdEM;~Ep~]~O~~ajA~d;e_gH~~~kA~~m0|d`P~ZLia^Q~l^V~Z%cc]OCg;~{g=]F:~`X~aH~~_H^6~{Q~l\JV3YYhn]~hlQ~gB~t:_iH_h]~h]~aP~jR]kG~`]Q`^haS~~Q_H~_0~~~`4}^QjhaY~hZGDgQ`X~af;c>wpV$9$Hq~~~~~~~ynhhmx~~~~b]KN]l^la^aX~agjMJacIQHM<l
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2673/ccs/rev np:i:6 rq:f:0.997664
  AAGCAGTGGTATCAACGCAGAGTACGGGGCTTAAATGTCGGGAAATTGGGTTTGCGCCGCCTTCAGGGGCAGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTTGAAAAAGTAATAGTGCAAATAAGAAAAAGCGAAACGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAATTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAAATTGGCGATGACTATGGGGAAAGAGCAATCAACTCACCATAAATTTGTTGAACGCAGTTAAGTAATTGGCATCGCGCGCCTAATCGTTTACATTCGCATGGAACAAGAAGAAAGAGACCTATTCGTGGGAGTCAATGGCTATGTGGAAAAACATGAACTGCCAAATTCGGCTAACCAACCAGAAATGGTCATGGAAAATTCTTGCGTCAAAGTTCGCGGTGACGTTTACGAAGAAGCTAAACTTGTGCTTGTTTAGAAAGTTAGGTGCGTCCTGGTTTTAGTAAATTTAGAAAACCATTTTGTTGTTTGCGACAGTTAAATAAAACTTAACGACAAAGAAGTGACTTGCGTCGTAGATTAACTGGAAATTAAAGTTGGTATCTAAAATGGGGTTTGCCGATGCGGTCTTCAAAGTCTAAAATTCTTGAAGTTTGCGTTTGGTCGCAAAAATTATGGATTTAGTCGATTATTGCCTACTAAGCAGCAGTTTAGAAGTTTTTAAGATAGTTACGCTAGAAGACCGGGCAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  Cr6ipPKD}ZQfeQ~jQXXQoKEukF~~~kU~Q~~]U]j<~~?~~RwI~nH~~fTfE|eW~b~kxD~y~kwQSgxt=~}}~khvSR~Jl\kB~vZ~htw_Orud<?~rZyo]glsIr~xktY~mj+yn-f;oW~ONhRX[~~ghQd~R^~hN~ArYR5~~irca~t/Jfg^g~j]eGR~~hkg~J~qSP~~\~~e/o8sltT\gjRvkygZjiM~~Y~xhI~~~g~ahg~kR~QvgbX~\<~OR:~~~jgGibvLtTdhZqjE~]i<~~gvROiP~X~]g]W~\Rt[fktkskdsf1shUw]vY~b~xkhf~Q?~~WehkvTb~dL]Qqqjf:tttcM:m^T~Qs^q\g\jU~eG~[;~if&ttisxg^[~g`qkt;W~sjxkbVhtwRX~thkO~eES~^cG~~]qxh=~~wkhj]tR]G~U~jc]f]u[SdYOW~Oib~X~GsGT~j]uP~drSC~Y~rF~]qhkf~>~dHbjYReF~uJ~~i@~i]vh^gj^e;reTZI{o`QfX~/~htT~SxA~gaZj=~dXfNjg~tiBurwRo\\jthkxh^jOpRFigXnV^XRo^Rx]wtV~lxkA`cHXNcNHMqdUf1wj@OWP@}fP~dPjwpkP~wb~g0~~Od~D~]aLnO?~~gtkr.~~oRVheokh]>~~]ih^wtjP+~lD~~xj]vsM~~^j]vhtlhqla~kV~tkV~xk\~~chD~gkS~\gR~~m9,Lrhkn?fP~u]fN~~ekO`b~^F~rjV{qka~cAB~\jhj/~vu[Vhg<~~ZQDW~g@~bYfegqw]R~N~G.thT~jglg^iRbvfGjhc~f+~NP{kg~kg~g_fxhT~x4}twdBcY~hk,~mg7~~~{gtg~]vfnhj:~~lW~c5|~~weid[~~SBeg^Q~kg*~~L~j.~~~jhtj^iv]uG~~uG~]vtugHYfu?~ejQ>~h^iR~~eZ~~IyxO~y;z~f~H~~w\~wE~~jhrTwa~hrYjwsVjD~[F~~SgtQ~~L~~wi\jm?Z^hwkxjRR~jM{xQ]P;~~~vP~xgF~rhUw^f~M~b6hA~rM~kg~th^e~GW~[~}?tU~g_np;skr^p)t~~Gx~QvhkG~mkQ~jtj\F~[ZP~u9~v[)dbJuTfkxhQ~K~hqczSwG~jwKe`RdiPW~]e~tkhL~~^iwR~g59trG~J~kg~hg~hL~~fsO?W~uxa~lhtIx~vS_jg~tX~ktxsg[U~A~~~rR[qf=~ith3k\~~U~jE~jr@~Z~RzY~xg<~rrX~rTv]U~Fq~~Z~j>~fkh^i1~ncRxkgS4~ZMsTTU~~^ihb~hV~gd*J~~j=~fZgj@~e)~tuh[~~f>t^U~thkit[~^Uq8~~~vh^<~x(~vsSG~~mF~vG~~~hO~R3~thgbxkxhP~L~~s&~~lkP~btjRvkN~~gg~g[fxlO~Qjhtlhruet`~S~jtVx<~~_~CjS=*MG~pxqR/+~~~p*~oz<~~gZ~iw]gjA~SjPvjN~~grjD7~~xB~hAgMR~f.~nekb;~aB~0hhk@~~~~a~w]U~v;~~vh\g_ZW{x^vKC|Hrk_f~hkvQSwhW~~vQR~f0~~~~3\Rt^tfQ~wkhlss_a~L^;h7cZg$~~~~~~~~~~~~~~~~~~~~~~hg^]emiFLee7cHj\vK~xltiiN~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2729/ccs/fwd np:i:5 rq:f:0.994462
  AAGCAGTGGTATCAACGCAGAGTACGGGGCATACTGCAAGACTTGTAGGCCCATGAATTACCCGCTTAGGCAATGGGTAGACCTTTCCTTGCCGCGTGGAACAAACCGCCATGAGTGTTTTACGTTTACGGTCGGCGACCGGAGTCACAGCGCGACCAACGGGGCCAGGCAAAGGCCCATAGGCTTTTCCATCGGCACGCGACCGATTCCATCAAGTGTTAGGTGCAATCCCCATTCGGGACGGACACGCGAGAGCGTTAGTCGGCGCGTGCGCGGGACCTATTTAGCGAAGGTCGCCGATCGTTTGCCCGTAAAACTAACTGGCAAAAGCCTAAGTGCTGTTTCGGGTGCAATGGTATAACTTCCCACATTTAGCCGAATAGCGCCAACAGCGTTATTATTTGGAACCAAGCAGTGGGCGATGTCAGCGACAATTCCACTTGGTAGAGGTCGTTTCTTTTGTAGAAACAATCTAACATAACTATGACACTTTCGGTAAATCACCACCTTTACCAGGGTCGTAAGTGGTCAAGCCACGCCGACCACTTCATAAGCATTGGTGGAAATCGCATCGACACAATAAAAGTACACCAACCAGCAGAAAACAGGTACATATACAGTTTAACGACCTGGATCTAAGATGACTACAGTAGCATAGCCATAGAACATGGCACTGAGAAATATCGATGGCGTAAAAGTGAACAACGCAGACGATGGATTACGACGCCAAGCCACTATAAATGCTAATTGAGTCGAAGAAGGTACTCCTTTTTGGAACACAGAATATTGCAGAAGCGGGAATGAGGTTGATATTACATCAAGTATCAACAGACGACCTCAGAAGGGTGGTCTTTTAAAATGACAACGTACATTAAGATGCAGACAAACCACTACTATGCTGGATGTGAAAATGTCATATGTGCGGCAAAAATAGACGACATTTAAGAACCTAGCATTATAGGATGGAGTGTTGTATTAATTCACTCTAGAGTAATGGATCACGGTGCAGAAACTAAGGTGGTGTAGGACTAGATGCAAGTAACAACGGTCGTACTAAAATCAGCTACGCGATCGCCGACTTAGAAGGCTGAGATGGAGAAACTTGTCTACTGGCAGACCTCACTATCTTTTAGGAAGGTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAAACTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACACTATATCAAATCGTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCCCGGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTTCTCTACATGTCCTGGTGGAGGGGAGTTTCCTTGTATGGGTGGAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGGCGGTCATATGTGGGTATGACGGGTATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGACATCTCTAGGTCACCTAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAAGGTAAGGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGGTGGTAGGTTACATCTATTTACTTCAAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCCGAACATGAACGATGGGATAGTAGACCGGGAAGACCAACGTTTTTCACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATACAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  PsRRC@[&j]\\N,oSUP\YZB\.J*<fC3WFZTaZTOuZZ?MSW\UHp<vqSXWCRSo\?wtYTUu[Ko>LpD2qm_\XFEp=sZ@iNnYFpUN><4-=TR;h\CZYFr\]USRaY9ts[D=A8kW[TLuaTLrRBZGvHQ0W^7@S[UJ/RW1Bq?mT?uvQ0l@EqTGusLm1t?/[EKp=9os`8e[\Q/E:.M?7>DDZWVHmFw\^;*lXaZTtEGRZ<5;nF/etfXPUT@hQFPLn\T\SW<O4TX+H7Cq\ZaTKq=TPY_BSYTBssZ4M=E8lX[XP?8mJqGSYGtTR_SW,qqV)sjXa8vviTaNnNULuT@kXkX6r_OuVAU>_ZLttS6rr_YT@uaLsNIN;EKMo4ts[T\LttZADXXMrFZXOB0k7WT\ZTTPr\PsU+oTLuLqEa=rW<SP_6rpSX=>W`QFR=WFR=pTtGtY<)h29UXSAHkD<X*sYS6Xi_RY\X(eM9JbD<^OuNSFMmT^DYXFSY=<pj=;s_EuW-Q\E_FGu>sq[6>.=L,=9WaOuY^:[UP=rYGvNOB4gWAA\GPSh,1=9LYSDBqJsX@V8Vk`TX>Z\QYY:C6Ij^&UQSXaVLY@hGO=ZYZT\Y6traREJrDBQZ`\`O;TR<rj8WOZ\E\]Lu\aTaOuS@_Z\QFT>C@_\ZT\a\X4UD_ZBLiMX\-OO>3>9-:,OLK[[=XVR%iKB^,rr]TSYLXTLpLCPZBZUVEXGw\TtAOY\TX6rMsSFsFSa\`:ss`UND8nM]BSR\:V=qR(jKta\T[3J4rtt^Kc)mO\T\Z*\Y.?qYT\ZOuUK-M^;m`Z\EdCfXVFXAqSTVXTF\K]XWT?nT[TO1Z[8r^AEU:TCjuaLuaT8st\8j\n^BZTOuMR^FOB>m=qY\X(%WY\S7sm$NYTa\-H\aX>YBu\aZaX2qqq_WD:C]BDRSYTEmM0Rfss`\Z\TZ\T\>viNqBMb0V]S=R@Mj-]Y7nB]8oDR);(iW]0BaMpCqS\TaTa\YZ?D@taLu\aRGSIpQU&UY9tkQF>V6oFHpFW`\Lu\T`WAB_UP@aNIKsTOuTLu^=XaWOZ6gXaLAFYT`WPZTZ\_MRFtAUO>g=W>>>YTaXDRZaLu\YEupPTqZ^>_Z>_/I>ZW0Fs\Q\TZ@OS6]qR@Eo>kEdD<AOV'kWT/F:^GUVUaZYaLuTa\ZaT\Q\ZGv\TaZaR)QOCmp=qWQASW-<W;soF[BdHSOt_E_GttQDAAQFX=ssOuaGvZa\ZHmRBZ\P@qBAQ2RD]XRpVOBGB+FC\\S9fS^c[DQ:rt[bWNAs[SMGDV,/?IVXULCBVmcWZ/rCZRW=qaT(P,S<1WW_W_W_\c]EUYOrS[cWXQ[CPMU\_(nPvOw_:PM^\HycW\WwIw_OwW>E`YRb_RJTb4q\YRGwwuW\c2wlc[HU8cY=sbW\Q;M\Jp?ui8tM[BCkTXJrIV[)qW.ZUNu_cV?uu^cWcVW_cWcJx`1db@@+P5ccQCa\^aT8pYSDPc_W\HZ]DuQ(n`2f]/Pfs]YLwc8uUvDa_cGwwcOwAa@yr+K?yt\GZIvcX^DwqTRHVQsHEJicRJTRFZ[PV`AMUCA5PYVUUCVGwwaDVQXWZF8NC:TNRJE_POVr\P<*oss`8ut]OwcOwCtZIFZNn_Wc\bWSV/Y@f_Yc\ClOw\Kt^[@tSHLs@]Iy^UHaVbL-@IaG>FIua1lNPVCV[>Z[c\c\PTA\]Ww_:_ZIw\c>yoWwW\c4kaHRaWC[7\c\WNwZLTVY+H<a[^\^[HVVWt\WZZCYCJ7\GIzcV9ukCZFUVw\^U)jr_@aZHYGEa\cZSAxW;s`=sRZ@I@a0SSOwc-RJX^HTCQ[VvH[c[R[NW)Q^WD=/bNsTD]<\_PT?QNWwJxwWvT(oEZ[BOVZ(QkF[CXnc2jaHMf,rR8TOO[G>tu^WWwT,rr`UeJ?~pf9~~ojb3~yb^WfeJOCZd_D~~OnB~mjMm8H~fN{T~pL~^9~cV8{mVZ;k_J}Za9CBh[fQH&NEOm\WgTeJ'wDVLV~beCTIhF6+~~~fF'Gl_26<``H~lPW~]j_RGiL2fJ~~JoLS~db6^Kp0bEPwCgjgmJ,Kg~RJkSV~pgpLndSNlJV~QePHcj]=_eSjldjagpQ{OEepjgnhnOJ&wmqnlw~~~rgaa_XOMVj|~~wlebbbfRQh4kaGf\~d=gTNl(^nP[,~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2729/ccs/rev np:i:5 rq:f:0.994212
  AAGCAGTGGTATCAACGCAGAGTTACGGGGCATACTGCAAGACTTGTAGGCCATGAATTACCCGCTTTAGGCAATGGGTAGACCTTTCCTTGCCGCGTGGAACCAAACCGCCATGAGTGTTTTACGTTTACGGTCGGCGACCGGAGTCACAGCGCGACCAACGGGGCCAGGCAAAGGCCCATAGGCTTTTCCATCGGCACGCGACCGATTCCATCAAGTGTTAGGTGCAATCCCCATTCGGGACGGACACGCGAGAGCGTTAGTCGGCGCGTGCGCGGGACTATTTAGCGAAGGTCGCCGATCGTTTGCCCGTAAAACTAACTGGCAAAAGCCTAAGTGCTGTTTCGGGTGCAATGGTATAACTTCCCACATTTAGCCGAATAGCGCCAACAGCGTTATTATTTGGAACCAAGCAGTGGGCGATGTCAGCGACAATTCCACTTTGGTAGAGGTCGTTCTTTTGTAGAAAACAATCTAACATAACTATGACACTTTCGGTAAATTCACCACCTTTTACCAGGGTCGTAAGTGGTCAAGCCACGCCGACCACTTCATAAGCATTGGTGGAAATCGCATCGACACAATAAAAGTACACCAACCAGCAGAAAACAGGTACATATACAGTTTAACGACCTGGATCTAAGATGACTACCAGTAGCATAGCCATAGAACATGGCACTGAAATATCGATGGGCGTAAAGGTGAACAACGCAGACGATGGATTACGACGCCAAGCCACTATAAATGCTAATTGAGTCGAAGAAGGTACTCCTTTTTGGAACACAGATATTGCAGAAGCGGGAATGAGGTTGATATTACATCAAGTATCAACAGACGACCTCAGAAGGGTGGTCTTTTAAAATGACAACGTACATTAAGATGCAGACAAACACTACTATGCTGGATGTGAAAATGTCATATGTGCGGCAAAAATAGACGACATTTAAGAACCTAGCATTATAGGATGGAGTGTTGTATTAATTCACTCTAGAGTAATGGAATCACGGTGCCAGAAACTAAGGTGGTGTAGGACTAGATGCAAGTAACAACGGTCGTACTAAAATCAGCTACGCGATCGCCGACTTAGAAGGCTGAGATGGAGAAACTTGTCTACTGGCAGACCTCACTATCTTTTAGGAAGGTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAAACTAGCAGTTTAATCCGTTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACAACTATATCAAATCGTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCCCGGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTCTCTACATGTCCTGGGTGGAGGGGAGTTTCCTTGTATGGGTGGAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGGCGGTCATATGTGGGTATGACGGGTATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGACATCTCTAGGTCACCTAAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGGTGGTTAGGTTACATCTATTTACTTCAAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCCGAACATGAACGATGGATAGTAGACCGGGAAGACCAACGTTTTTTCACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATACAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  Go:@U:*Bo\_EBLsV;QF&IA+[aY0uupQ[RaXASZL`>^ZOuT\aEJ&l\EQ.p=aY0W^TY*ra[CfLKGF;fG.CL`GjGusLtLXR:VRTJU3_Tt/;0rk0B77nDYQYSFS8qfX[TK.oe2?$k>SBpYU_;iEv`T\Y`WFQYTX<DGrStB9kZeLuaFcBKtrGuAs`PUaFrT4jteGL-VR/kQ`YTZTaLuTUA+1ka\YOP:A=KmFErGPZTtE5sts]LmD1lTGWFtGW`YRNLG0EJYT>s`T\XBMRI*LVLF(H-XPHW\[;s]FQZTTt1e\ZTIqLGESL6jUSDutP)%SojNFC[XD5qW,srZPIs[@nNPTZWL*ppS9mX-PY<n=4b@]Y@]U6I4DW^Y^6Xm[?BT;.oY`TZTDYPrCZ>XTB[_C[_EmP+dRrLs?p<X[JN=XnYT_ERFXaTX<B@Ss=rJoER9qWAoB_QX9tSA3'[Y8vvaN\_<(\V^YSrGSSSqB\\Op<Z_LVkKiMI~qB8~fH~{X~ck>sM?C%HzSST~mEpa;b]^Y|[b;jRdZ~^Qgib^P~^mU~kLFtLiPI~]elGsJmD-[@~q8J\emd5Zi_cb?~RCS\wWEP_nS~Kp<aM/_gG=}~~dg<~DPbkQjOQbl[L~xFb\WR@~e=~lfMf_~^kc.hde>*^f]RiH[Gbj^U~ldNYHz3O9L~eh_g[R~~ba&IC_aD~~ZYP&~w*Oe^VyM\~M\en_neYLQM~eX~me_mbZQcZrCO]nab8^&~~e[`h^~F}GRD`e]7~[K~Lb:O\JT~1~~~`O~\~FgXgHdOKU{IW[I*gVW5~iWw`RMGwJq^]dK4~ddi;`[l_eQNcS~ejCOK\mPw;_m_V[)ikH8hP`/qtW?rmv^XLbZ~^Z]dbOLGD\^mh_dhXm_=|~JP`8hN_e]]dO5ecfHR\6~~lKVL]lgj7V]Q6,cc1~~~_Rh_m`WjcjCkjK~][~Q~Rl_emLij;jJamhK~KZ^^LfEN@5eXuTjMkb:`5Z@1Xh^~QJ~%abU]S:f`^Q~m^F~~_^Q]G|`JdJYNj=~lb8i]e3TbJxF75gaKfOAeM^^OQaQ@~~~gen_ehkKEc^ePQIEh\bR4^CNNvLiMf]T\mg@qiG4}~c6gX`]eSbhOd6i^kPcheneimb`,getcLp>^Kdhene[[~^eM~_P7~d]Z[eN'w`WCUhaa`m^T~TLPZ[aE~cE~oH~]e^cHke^N~|RLA]P^S~eO^C~~cNLZbMT*}qTfhS~\'ilf9c`DdhdG~l[\=~lh^3fhemM~fQN~m^_~^nfHjL8ibXTBNNh@Kfn_jeZcefldR`^Rl~c^Y+R?cVHAkL]Xs5~~T~^VLjdhWSk[`lH~aLJcV/M8ykNWLLgG~Kh;OiLj\1cPa^JsO~j?h9Y`VkMa8Z9c_<~~\K;~~~dNdD~tZZmdGjuN~he_dG~uN~D~uU~L~mD~~gN~ROG9exE~i7bf_d0~~UQ]hmcQNchU~g8}c?[^{6o~~kQ\Ygb&z[E\hlbfbTMT~cD~~f=~f=~~sS\O~~U~X~HbgYBj~hLb]}>~<%eF|xU0R,bE$L5ioMEkI.yjc,~HB3~M:~MaO5P?Y?+~zPkgMmeF~tdmg\8I\fMjP4~~PfYQbBR|]Rc2{ltg9~xc>oe=~]~IRQ~K~meV]fWGcemF~~Pf]VwLoS@um^_~dS*RNlO~mcSc]2[Hi;|OY8QxMIxlHT;[eWNs?YJH]e^T~e.k,;6Q?G[f7~\1cb^fA~a8]LABOs^a>]UjS`0JjQcG~]mZeCL\mW~HcjENBj\U~gKcfeP`xhmdV7n^m^@o~deg];hQka[fndBo_:~II~d]NfegSwLicR=lejMkb4BkK\h_kAae4~~~O4WnHve^kKBhM\K~cG~T~~Hb5%`P\m^emZ,~y_b,~WQK~(_eO~6zldnhdbb?~~idE~a?~~~d^d;mA\9~c&gHK~qedK~]cS5k^dB~zZK&}hlGu\EjH\s+mL1g`T~]M/h[`ZPpGJ~bTODZ~e\RGF}ROk^Rl_mRsE~~^~^[T~Fad^2~~_GF5`^C<dP=b[4~l1[~ch[l``^]~,x?6~KNxNYLj@uW~dA~RMm^P:b4|hlehm@kT3OS~QN]fL;~[F`4iQSgX<2RMOmb^aP~F?^hfQ<fcQ_%jrz~~~~~~~}smnw~~~~smpy~c^hmdJX^^d])_Z]NKN~leh__X~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2771/ccs/fwd np:i:6 rq:f:0.990658
  AAGCAGTGGTATCAACGCAGAGTACGGGGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTGTGAGGCGCAAGGTACATGCTCTTACCCCACTCTCAGCACGTAGGGGAGCGGAGTGTGGAAGACCAACAAGCCCGTCGCCTCTACCAAATACAGTGTTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAAACAGCCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGTGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGAATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAGACCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTTGTTTTAGGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCCTTCCCAAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACCACGACGACATTGTTCCGACTGACGTAGAGGCATTACTGGTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  Gu6,Lag@~b?2R6eV_ZRcgdnJR*`_rYQ&x^S0QX@6[7iFDILmEv6a2'MgJ1VBsgOY:KBMX6~?qW~WYFY;al\L5N8Z_cdZ5dRA*LbZb)lrigVHJWQSNbXRG1*WVb^U`TS~o^g]bmN\eC~qXKSSdLeo:~scjcJw]LY45h]gdUlM]AF9__=~]]ZX~Q~cP[JZ`?:Q*[Y+ZU`^A_Z^FRKAOXHVP%we',N0<J0C^Xc1QEd_QL|8~\J~dBg_amFa?~VYJ*M~/~yod[QcmL$h`RaMikaj`M.R~gL~~]][?khGY;K5J/rnLJkkS|D~cGJOnW1fWIY0qgnd\F[hEZ<lfboW;g],qaN~~oN~oT}]gdgL~OjeSvF~iJ:ld[T9cFV@LED1ddM>MP'XROM9f5L6P7;TAQ1R3..-]@0HK]WYejZodnB~~nR~gPgJ%csVfUgBuyjLie]ejTc6y/jLL_\^^bEg?-9(LHEhi:.E76PV\MKeIOl3kBGT:aHSfLMOGWrQfSbdgT~UxKgQndg]KkcR~goa:bBoGMcLPIoCWN1PY;h^>Ek[Li@XXRJ>VX9haC_C&QOlG]YSaHEkLeTpiT~^Sf5~~t`WXDR8D\b,cXhLabj)^XQJHj2`dcbKF6ni[Pd]BRJR2?NKU6LSCkDlUoY=}~<S:kUI<VcV]ZfGEKwo]O@Ml{`7vo;dQ]UcI:~\3S/Q5Q9fG,lf>~a6}lHtKa`Ng<a4LM(P:Z@K?IMBT4TJOJECbIH=AL8PJRBYH=@]^-D4Z%=K;6_PKB;KK*TVL?JFPR=AOaVR0G:&9S;+R3.[YJNIh0CE9R>T].;=>x`.sE>%R?HTiM:S<SN<2G@@EMX0N*/W`[C4_fVIYbIAP5x+aMFV{;m[I(DIEE`feL(XON]9[S~gbQ7]k]C^J6cHYZ\qKmQjEP)pZTb3b{$`_P0E]DW5ihLU8JaSEL)LJma~eMlNM/bN~e/eKefGbaDbhd`~M(NXSbQ]df\a\~b5~FBL`E_ODQ]l8J_D~\e8~^Sa2h\$vl]\mvrkjiXHBIYn~s^RNU^ht{qgdoTMmh]c@mc[_T~ceN_Le>DmdWbv
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2771/ccs/rev np:i:5 rq:f:0.993395
  AAGCAGTGGTATCAACGCAGGAGTACGGGGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTGTGAGGCGCAAGGTACATGCTCTTACCCCACTCTCAGCACGTAGGGAGCGGAGTGTGGGAAGACCAACAAGCCCGTCGCCTCTACCAAATACAGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCCACTTCGATCTGTAAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGTTATTGATAACAAGTCCAAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGGACTATACTCAAAAACCCACAGACCTTCACTTGGAGTTGTTTTAGGAGACGGCGCAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTGTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  JZA<P=@CqUHXXKtXG[[9VO2C-;$2Om`RK^:KBpZWCQKic^nS~Gz?~~<\~~yWN~vT~zPMsS*kJ~M~o|smads^]xlH~~s?b5~yj<~qh[D~~~~abHbzjJ_lOrmV~VYOCVC:SU[p_N\eGd5~yzU~PbKgm2~~~j]g~nUsnk~o|fV~D~XKYc{B~lbk?j9`C(9sGa*mnP~z=~}pyX^V^Zw_Szoblv1{ccN_LuschfG%ngazM{[~Aw:Jnb1ttOZ[PV|RWk^J~D~rm`QqbZ`2vzxEeCSL=ZYU~o3~zladL~uZzj~XdNuue7nfS~0ne[M^YUOtns)Kp\SmZugk^r]~pLm`?~~E~~N~~s\~Zf~gyQz]~b~|V~D~|yI~zox@~yblxn\P~~nzPIzmh^~di|sxW~`[`vc$s~~qkq?EI)LzrYrfo%v^0<;~Ve~qC~sLkdX9~tnZ~VTU_UQ0~9~~~~n|gpZT`ngotO~r{ozQl\f|sfqd3p]~mi\lBYjGvdgmNzjWhpPx?uA~\~`OSG^grfKok?o[vs`~nW~d]G~2~~|mLn@obkPZlQk'_Vof]n{Dn\nrmT`*~i^QjzgRSdtR~m3~<GQ7x}|xgUWxIuT[FaA?0FFZ=zQSzYY$pmbXNP~~n{ZOl\eyG~}P~nruCqH~f~n0~~j~R~[OP~~llikWvg~mcVRG~rGDhwNaWlmbcM~degxmN~Ny~P~~Z~Jf~l]~W~{6N>~`_Ao^\4~h]~Q~Cg}tgP`~gs{j_`ngo@w@~g~sl~mLYP~L~TLwhM~3yrgQ~oeXNojh]ed~Lpu^wNq?8Q{Ws%qcek7`w*INOs`Cpb:~~R;z~oSgs^Xf|m&}WVg(GRXaHJ+Tqt^8ybgLjGmS}AQ$^9Nl<kfH4fZDul~l7{iIXZ3I6;*30\8B_hSJP;Cl}cL~]bJtKRR~A]0VcaPH]MoX~K~sMZco%lW]Ocf@~L~o]fZZ]8>rLPC9eIJL]XU_\5gbdnd]eF\aSnF|F5j=]G_NTPKMTXMXPJwOUK~l^L.N$|lVFCGKC=:9>AELeeeedddcccc^N@:O[WXSXO84-G<VWR6]FQ<HI7`
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2772/ccs/fwd np:i:6 rq:f:0.991694
  AGCAGTGGTATCAACGCAGAGTACGGGGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCCTGGATGCAATTGTGCTCGCCATTTCAACTTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGTATGGCACTTGTTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACTGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGCATTCGTTTTAAACAAAACGTCACATATTTAGGTATAGTAGATTGCGTTCACAAAGAAATTTAAAGTCTTGTAATTATGGTGGTCGATTTATTGGTAGTATATTTTGGAAATAGCATGCAATTTTTGGAATGGACGAAGAACCTGACATCTGAGCTATTGTAAGTTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAAATTGTTGGTAACAATGTAATGGAAATTGGGCGATGACTATGGAAAAAAAAAAAAAAAACAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  .JYcL?>gfedL0rW_S2C_]d7K4||yX]Mf4r]_Q@]aUSdEz?69p83\ELcf@e:TJ7yaFadeHR\Cw}OX`5rbS+`VRVL\4WETgVNJ}zZVG=XA,AGB69L\T0\_WQZDyNf\A]f<iTOY^+fvh^WE{Q~h^-}I?z|_f_ZaUf\9]X_eXf_dC]D~M*UHX9lp_<_`[,[WUvYJT^I~eX}HV)q^o@CXUdOfeX_TG@9P~d0>^x]OTZVUv@]:HL9Z&67NZ@a@bQCb/KX.JlfL<hVzaTH=PE.vyd@\P6*?dDbO'\:@O)X]@FAOLlV5hS^d6L]gX@v_H~_P\SG.z{WeFBO:FWGfWO^H~OS2LCb^he^8|f_XW}_gP~g^>|pZLTSGprJ*EWfO^cD]+m5Wf_fObU\HI$UCQ:lMbgegP~XgcC|^eCNy/dpfO|`][UTdVzHf\3^CYB[HEaVME{W+c^Yd3S7MS}^RIFGkHf]FdDzXc3xO~X|C\LXVw51_UWDwOWP~fN^cOH=5\Xe`eCU|^_X`he_eBY[6N|gee:wE9A?_H,\T^`[AEI,beO~QW^WFX}^@aGUNOfR@`DQr^-`V[Ut8XbK8f]?||\H?K7{zQVDB^gVK/0P[PX[]5KAHXoc9x\XgeW+X:8UMM^]'ZH+<~WP~dXF|dX:UU^YY|[ONE]X%S?M\dFM^VOcYXmMeI7dVDdh^3uINx_DKcJT2xY`Q}hY_XF~r]HMRZ;^]\VN1m?)]VfEB]b[M4X@t]E0Z,rQ&6[]eCX@a\OUB+R]F|JVnXIU2Ll^O^e]C|dF^.N^eH-WRUE{^3ifco_gDxcZEe^YJwb]W~^/YNEYUVz[MV4xeXM}VdC{U]${hG$\QQ(pr^X]OWdYa]]8vmX2\XNcF=cOXHCuHPB>vYeSArbW0zJ=|m:_tZfX+IHJIfCm[NJY['VDV^OKqXV><3J),L0APH$J]PPj5mtfYXP@X]B@\9iz}Y=f>AJO~eN+9SC5\Jnd\2;HLBQSaIS_NM{EaE|^Mbu@W:m{\F{eP~}R2`YdB[WeHcL_*;;paAES;^g<buA||bCYMYfdf_^YdSY3xOJ:l^O]/z||dZ~e_Ec`[IjM%mVUx\(}MyMDx?L^5\fGv`5O2bRD\)^cBYOdC[AKKE7]'T`deghikotyxtr_*$wyoecddkceqygXNcWeUJ\RVVz_eb^:b7NMCL<u
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2772/ccs/rev np:i:5 rq:f:0.992066
  AAGCAGTTGGTATCAACGCAGAGTACGGGGCGATGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGCTCGCCACAGCGGTGGCATATGTCCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGTGTGTTATAGTTTACGCTAGTCCAATCTGTATCGTGGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAATTGTGCTCGCCATTTCAACTAGTGCAGTTGCTAAAGTGCCAACTAAGGTTCGTCTTGAAGCAATCCGGTAGTATCTGCAGTCAAGTCGTAGTCGTAGGCTATGGCACTTGTCGTGCGTCTAGGACGCGTTGAAGCTATCTTATTGCCCGAAGGAGCCGAAAGTCTGGGACACGTCGTGGGACGTATCGTTAGGACTATGGGACTAGTCGTCTTCGGTCTTACAAATGTTGCAATGCCCTGTGAGCTACTTATGAAACATGAATGGTCGGTCTTGTGGGTCGCTTTTGTCGAAATCACCGAAGTGCGTATAATTGATGAACGAGTCGAAGTCGAAGTTGTTCAACAAGAGAGTTAGGTAGTGCCGCTTGAAAAAGTAATAGTGCAAATAAGAAAAAGAAGCGAAACGGGCATTCGTTTAACAAAACGTCACATATTTAGGTATAGTAGATTGCGGTTCACAAAGAAATTTAAAGTCTTGTAATTATGGTGGTCGATTTATTGGTAGTATATTTGGAAATAGCATGCAATTTTTGGAATGGACGAAGAACCTGACATCTGAGCTATTGTAAGTTTAATTTACCATTTCGTCATTGTATATGCGGTAAACGTAAATTTACACATATGACACGAACTTTGAGTTTTATTAGCCTGCCTAATTGTTGGTAACAATGTAATGGAATTGGCGATGACTATGGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCATGTT
  +
  @^T2:U8L6X+XXcRyeZd[WEKZZe._<ChZcR*L0;fdHRD;VCcDS-wj8L[ANZLH]glUb_0oef`eD+vyhPeEsWg5}qnUIhUj]f[gZ/vQI8J`zbO~`M~PyBQEm`KJ[ThlWUM[l_tTm^h7~}\=`~KuPVG~~>~u]T`HJKi^WL>*[GR.<b[Cm`U~S_2~yoJXT[5H<A[,[bZKKfN\9e+xtjP4BKETBV_\]7I]MtdNEm}]YUZfJpB~jfnW{pNXjMgphZgcZOY``Y~VnYzM~ribQtL9v^LgS`lHPy]Zb0[&EXNNt:I=FR8]YKmQilgpQl'BEh]K~jNvUI:zdQO^MG6nbsqj``3yjMYgLk^krLUsI`iIcJO8BHA,'DeXnQ?wriO+XQNF^IxQ~Ze[[TYndWT7cPmKZ$?>nGDT@XO`PNr]bQM~Ft_K^]eT<MR>mBeUZ2MOUnT%LaXH~`BQXM\=bUPmQZjAsROcIB~SH[RLsKqClTaoW:~[:~\=TnX$7<~or]krqirbirIfeNy`i^FZ`ali_gh7H$QTMI]6LjXr^R^J8NDSWILhO~[fadKL~_,~[gAoj^(kPNN4JpuV_[MuS@'>@E_xZ57I@`X/PFBZT6\W5Z~qhLgPeX1Nb;:vGPRgH3`qj;V>ZgaLhOXj4DkmeKo?dEnn\J/Y\PIe[\/^M/9>'?KhlqP8aJO[,v_Y'N.FVIKV5Z=mfRC^J?$AJN2TdA~uRMZPH2i8EcPP{^NrQYDcD)M)XM4Z@5baO~hPZOYe5HkJEEKJp`WoWIhgHne>K6cVNZO~rKtUlI]JFjK\2V;)kZiv[Xb|_iPWPB=b{l[p@5p~~y`Qz_\]K{{_(wQMYAc[ECLsKviJ~zv`NT?SNScM7dbJ<c;F\.2>/HO:O3[,N4BhgQQUza7RPEls6g[QVL0HMTJqGZVMFYc%E7NKI&HLKFUM`hC^lmml6oQ+~@fQ^M[`gL9VKj7llycNk=x>8dHCPKhH;nDeWEPalN^f5l7J:Q3x?OMmI?jF+t@eP=T~ULu{dQXPn;oVMN\ad[bGMAGmxPVJM\p>c_S1;OdF]QFKefSGLVP3olXSW=~~pYZ~qLJWW3SpTEnRzCQp0nS\ZBHlUISN`1@r(r-_)^E0S3NCVMKTD`$jeddcccbbaa]SIDEMX_````````GAN_Y4R;?FF5\D`O[B_=07/U
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2774/ccs/fwd np:i:11 rq:f:0.998209
  AAGCAGTGGTATCAACGCAGAGTACGGGAGGAAGGTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAAACTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACAACTATATCAAATCGTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCCCGGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTTCTCTACATGTCCTGGGTGGAGGGGAGTTTCCTTGTATGGGTGGAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGGCGGTCATATGTGGGTATGACGGGTATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGACATCTCTAGGTCACCTAAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGGTGGTAGGTTACATCTATTTACTTCAAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCCGAACATGACGATGGATAGTAGACCGGGAAGACCAACGTTTTTCACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATAGAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ~~~~~~~i~~~~~g~_Zi~~~~~z~q~~~~~t~n~~}~~~d~~~l~~~~~|~~~~~r~~~~~~X~m{~a~~~~~~~m~~b~~f~~~~~~S|~R~~~~m~~yh~~~~^~~~~x~~~~b~~Y~~V~~{~~N~~~~~jz~~~~^~~~~x~~~WO~m~p~u~_~_x|ss~e~~~~r~X~~~~~~~t|~~~j~~~~c~~~o~v~i~i~W~~Fl~C~jJ~~~\~~~~~4~~~~~t~~~|r~i~~~~~w~r~f~~~~_~~\~~v~~~y~~&~~~o~~{~~~t~~Q~~~qT~~~v|~j~~~~msc~~e~~_~tQ~~x~Z~~o~c~~S~~~b~}t~X~~4~~%~~~~d~~~~s~~s~~~~^~~^~~~~m~]~~~~~~q~~f~~~~X~~[~~}~Q~~f~~~w~m>~~~~~Q~a-~~~~~~~S~~~c~o~\~~j~<~~~^~h~~~~f~~~~\~~~~ss~~~g~~k~~_~~~~~~]~~b~~~~~K~~~~~|m~~~q[~V~~~~~~~~t~|~p^~~~rU~~sx~~u~~~~~P~y~u~~~~~~~~n_~~~~^m~q~~a~~~~~~~{~~~w~~~~~~~~~~{~~~~o~wg~~~~~~b~a~~~~~~~~g~~`~~m~~r~~~`~~~~c~~@~~~~~~r~~~~[~_~~~~~Z~~~~~k~o~~~~~~bq~{~~~~`~~|~~~S~~x~_~~~~~~g~~~~~~sq~~~~~~~f~~{~~~~~gs~~~}~g~~~f~~~~~x~~~~~~~h~~~7~~~~~o~y~r{~~~[s~T~~~~D~~~~~x~~~~z~~~C~~~~D~~~t~x~z~{~~~\~~~~s~~qrj~5%~}pw~vW~~}O~~~~~P~~~~u~~~~~~d~g~z8~P~~~s~~s~~`~h~~S~~x~u~d~~~~r~~[~~~~~s~}~~i~~~~~~J~CU~3~~Z~uhH~W~X~&~~~~\~\~mi}Y~~S~~~_~~~~~t~~c~Z~~b~s{~~~~~e~w~~2~~x~y~N~[~~~u~~f~~~~`~~~~~~;~~~~\~~o~~~T~~~~q~~`~~^~~~~Th~~~&~~~~~~~~~~~~~~~~~~~~~~~~~~~~~x~M~~`m]~y~~~]~~~~|~~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2774/ccs/rev np:i:11 rq:f:0.998888
  AAGCAGTGGTATCAACGCAGAGTACGGGAGGAAGGTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAAACTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACAACTATATCAAATCGTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCCCGGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTTCTCTACATGTCCTGGGTGGAGGGGAGTTTCCTTGTATGGGTGGAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGGCGGTCATATGTGGGTATGACGGGTATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGACATCTCTAGGTCACCTAAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGGTGGTAGGTTACATCTATTTACTTCAAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCCGAACATGACGATGGATAGTAGACCGGGAAGACCAACGTTTTTTCACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATAGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  j~~~~~|s~~~~~B~~~o~g}~~~~P~~~z~g~o~~~~qdV~~~A~~u_~~~~f~~[~{~~zf~y~~~Y~~~~|}~x~~X~~T~~~h~i~~yS~~s~u~u~x~~~~]~~~~~~~~~]~~~~~~~w^~|g~~y~~~G~uw~R~~P~@~~~~4~~jc~~~\~~~y~~~?~~w~~~w~~~z~~~~E~~~~~~~ki~~~~}x~~Pt>f~~~y~?~~s~~~p~~~~~~~~~E~~~~~~E~C~~~~~h~i~r~~~~~~c}~~~~}~c~~d~~;|g~~~~rv~}[~~~{R~~~~~~H~~~~~~W~~a~~}v~p~~g~o~~o~|~~U~~~`~~~}X~~b~~t~~~~H~~~R~~~~~~~w~~~P~~~~~~H~~~~~~~~~u~~~~~~~~~~~~~~~Y~~~s~~G~~~t~R~~n~c~~~~~`~~~T~w~V~~~~8~~w_~p~}~~,~~~~~~s~~~y~k~s~~s~~~~~~|~~X~~h~|}~~A~~&~~~~~~~~~~n~~~~~}~~~~~~VY~~~~V~~~F~~y~Z~~~c~v~~~{~~~~~~{I~~h~xZ~h~~b~~~T~~~B~~~y~~~~|~{~~~d~~~~~~~{~~~~^~p~f~r_~~~Yt1~~Z~mn~xo~zvk~~S~~~}n~~~~~~j~~~~~pg~~~~~~~~l~q~~~}~~~~~~~xd~~~~o~~t~~~H~~~~~~%~~~{T~~y~~e_~~~~~~~mD~~\~~]~het~~bb~q~~~z~~~~~fq{~~~t~~~~w>~~~Z?o~y~~~~hbt}b~~s~~i~~~~to~~}~~~~~t~~~~I~~~W~~~c~}~~~~~~~~]~~~~y~~b~~~~~e[~i~3~~~~~X~~~~~~~~^y~~~_~~}~Q~~~t~~u~|v~r~~w~~|~~pF~~~}j~qe~~~~~~~~~~t~~~~a{~^~n~J~~_~}~~~H~~~K~~~~~~~~{~~~~~io~~~~~~~~~~~~t~h~~~~~e~g~~~U~s~~N~oC~U~m~L~~~~}~g~~z~~~~~n~~`~y~rS~~~~}~j~~N~~~~j~dky~~a~~~SN&c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~h~af`~{~~~}>~~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2786/ccs/fwd np:i:5 rq:f:0.989691
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGTTTTTTTTTTTTCTATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACCACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGAATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCCACTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGTCTGCCAGTAGAGCAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATTGTGTTCCCAAAAAGGAGTACTTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTAATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACAAAGTGGAATTGTCGCTGACATCGCCACTGCTTGGTTCCAAATAATAAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTTCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCATCGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAGTCTTGCAGTATGCTTCGGTCCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  RsYJd]e@tdb^KG[7Y7_Ea\\\7$aiiiiiiiiiiiiiiiiiiid__fi`XZZ%]]dkkkkkkk]Jc`bB=`[:CO>bPJ\dKc2ZMJe[WNZbJ_>fE`K^]K`SHW:bHK[e1|\L^W>`E[9W[7R=^aI1cU6m\Sh3|dS^77Ze\e[FjE4^\K%O^YebOcF-^iXOB7[RmNoJ7JQ,fgKlbK_MFc`N-YFGGZ2jJa[GUlG=dIEek^bKRa\(bb?|ShJ6J7:T2jmF8GGeeBHCjd\KEl[`Bhd8cbCli6G>uZHS0cak[TlX]Fj^N[[7VH\`@^2sdb:_R/i]<AE@R7d\LeJb/hIJeNlkAjEUeFXb8Za7[;vOdL,g_jULO8@<P<dBf7Yc[eb?k`L&TM_b\b\K[DkJ0b9]]XNOJadadYH]XbEmeJIF$^DK`?kkE`?}`JK=Q=B>PXE@McKaHeKeJKd@_`FHEREl[K^H5d]Kc\ea8fMIZNZ7\`MC%FH9ibAh-X@J\J\HLEUlJ[JcL[Bll\I]e\b2ncEB^ZOd\c2gb[/yaVGT4Z+?U'P\KcK*lie]bLeaLb\c2hMjPKR^/ua7bZ36c\.bOdXOI;I2AKF[J%habcET;\eKbb6+fx[E7`bK-ap`L[M]bXM/cM2`ZM<c\c3YIb=R/Aib8N>`+PJCiV'b?nnTg;yI4hvMbJGIhMlD]W9K+vxX9zb1r_NMl^GMbY1^\b[<K9I968_O%bdGGfGF2VI9KlcWae\cN[beEmdAFS?vCll8]iJY3=ve&vdbB_MlEmU2S6M^GJV4=o<lkEbI_'VBU?RElll\I4jj]<uXbMZJ<=4Y&]4RO^IE`KlJd\eXG>bEk9t[ID;?|JhK\be\Emd\LdMG59]EaKOmJMc1eY<<QLFV;>[JZ7FmgEMbVV_02`YMHbGVKT^Kc]G:Wj[`%IJKR]Jd/wae@~e\eIgEJ`-xZJO?MZMa7[=hXaY6;VTSk=kjKcFJeb[(ldacMB`Ga?}`MKllK]dJZ1@I3[7qx\TM\aIKEcNnLe\b[H7]JZ?}`MIKKe$PQF?y\KTe5/_@E6KCk3jb9j`k\`M`[MZbKl5&_F;v]Mdb[J(-Q`Z9lG4\+U\[HeK`F?tRc5^;/[^K(NJXbeKWLW]`XIcIGEellbZN^8DY7XGQSSEgLJT^Y6K\JcM[c2{dZ3J1oP$]BDja\>Lb:d;h8a=cALC_a<kNVl]GGI`7Z]WdW<]BM4e[IIJ[HEFa;ZbZ8FOR\eb\e[?RRE_&`FIMa6CiLod[P8H1Vl\c6[9dki5gQSO^2ZF1eg?bKc]bMleK\dILZGm[bebKVl\bc[KC_<ORFQj=EeLcSP(RZYHL_KeYHLmea=-YM[Rd%t='chiPMlb\aL0#6)5?XDB`Jb($HWlM[KcHNfbcMXaLmJVlOjKZMK\eTlJ9b;aK\a7d[G/Ck[WlIN(0lmkbK\3r`HCH\bcMGm\9N[eY:_cbG?cJa*92>^Je`MMIebJ`McN[eKY.GTcM[b_1WL9iLJ[Gm%gKKe\bKbHHKOC;j`]@ldV7cZ7cMlWlOjdZLN1)^k_]Ul\dZMJ\be\K[M8gL$_KN?dCjd\KVl`MY.fZeNl_7@TIFb9h6Vj\b>e`FTlMJ\]7deeOpd>lV,ia@hd[Bj9mcO$n\\BmlVbE^%IaGB?o^N]VkVUMVn[=llhJd^HAlmk[CjIZ6-YV3Z^%IflDKNoTlGcML4>Ie\`Lb`JA*p\@0YH+Z=S4j?`?jldKmN%fKII8NJD`KdK\IbLGiI:f%O=ajAYcCljLW\Eb`S6>eL%`10F5(TJEIdOH_\KcKXlb?eJ'jkJG4F8[Wlb\<llQ1I>l_J$K:H\`KJIhHAD1WIKIXDDFPV`VU`*`Q=HZJ[IFJ\@u\bKeMY9[G5HbFFJ]a\e?}ZE4ea\Ioe=`L`MWl\Ja1iN3YI7FWl\aNLa<R[ILlL%XY8Fc[/xWNeOo3mmj\@|dHLDll>q>kkE?{eNb0bed[U]+iL6;HM(N1KJII&==j:ib7F7^,W9dGK6SPCG]3UOCCO2BEFP0@:KYHdT&NV%QZ&A<JFQKPYJc'HA=iaKaU.rrTPDI?heOiXH:c[N?iS]JJJB\[/hPH</DZJKY=8UM<_XEHA]JGjb)bdg^B[SIT8\3F@AfCGK`4d[H`J8[l
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2786/ccs/rev np:i:5 rq:f:0.98505
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTGTTTTTTTTTTTTTCTTACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCATGCTTGTGGGCTAGGGCACCGCGTTTTGGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTAAGTTCGTCGTCGCCTTCTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCCAAAGACATATACAGATTTCTCAATGGTATTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTCACCCAGGAGATGTAGATAAAGATCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTGTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGTCTCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATAATACAACACTCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATTATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCTTTAAACTTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCAGTTAGTTTTACGGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGGACTCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCTTCGTCCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  Z`DRYDU8YRFT97^QDRYDZEXYP$XNKBGOUTRSZ]]]YOIFEIT\]]YG>>(8ENNPZ^WQRKFL%+?RRRN@Z:mZRCB;WF[YRWDZ8RXRWF`EYRT>(UYRU?\BGBW4a;,gXRSAYF`EN_E`UEPAD_CJ`@aaK_;U=BAK?=^R=a`Q+iXCO:@;B)^___[QEK_7UXREK;OK(KLRWYQBV.5YWUN?JWRVBC/EM+gQ;FH\XQ8^BL`YFT8MM1ZPC\8YQ_W<-XHAH%?DRI_?X2keN>R2RaRYDNEN1)K?=%9N_A>F__WYDXF0AH[7\@VF`Y>__T9)^^PB2K69?=<:D@&6.PB.YQCBP0URD=L)+>%5O[UI<O?<IQ:]QCWCAN2\R=6?(DB,A%5)8DR%=<<;6+)+5=9ON<WDY8__QWRI_C'BCL'UBY6^T*RAJQVQABRN_WRWP@GBQ/FDN<=O?OD^9QAL==K'B/.=-LPI53=--N@;7B/-IK<X0DEA:9P4RO6E,@@WAB3M?V:kXDY4`TG2B3AHCB0Y597GXA6@@V4^S9G4COQ;'E&@&K=5);H32FD4I5(-C%7;E[W>__V'\\BZNI_RDZRWV5YXMF0WI1Q@JVA?aR0T;VBW.]]SAAUYWDZ4HC4]A*D_DXN_RWLP.KXKRYF]:eN&6@+1(K;),277=UaYWYR1F:hG__QB5^a`WFP+>TV>%XOMR=0NB:<@$F;4AOQMS1^\4'CL*R-&8NEDP:DEU?VWE__EVT'0UI4O^PCLDY>0MPTJ^5bD^N9T)NH.QBVC_=CVDV;W@aaYRC2M]^CQ'hYAE_?;VDXUCQA62&;J>NICS0PM;2G5YF_L`F_SG@:@\FS;&2>@DP<AIUL+E@D-@;%*311.O@B8SHNKCJTFCS2VR1%%C=R??LDQPU==:3HD@GQ.Z>@70'3=,C+E@D]R6,2:/PIWRUBD^0PC<^CW=JAD`XVEA7R9+9D:LQCG7I?S>+-?MBSAM/-5@3415CF8-@5-/;+H/@A52',)RKVBW/NP8@EAK?F1?8RA>EKKF1KB)2X=H>242@0@D]'ME_U;RURB+NACWEZ:mPO@%VK5V=>YRG^E;``RWF_YWQBQWDF`L`RWJ_DV;9iRDZWRCQ0OWEQBBY/MbabIMc\JNLlLQe8<]ZHJ?4@/DE__E:LlMaEa,dJA_ARP@2MLT\/aVMKj9JH\LNoKB_KXKXJQ6D;YGI\)7NSVK)HHQRC@ePBL933)86C)E8X\>ZCX?=_BLOPI61*GUPF9V8%6W4VXS'SXHFEEOM>ZZ8P@02U5T9E<)IPDA]ENOST5?0XFB<CM'5LHMIR<MC0JBX8XP5IDSI714?BQSO2K=O6469U-,-I6,IF4DD4G<SS1MIKb[`JB`JT\2CU8_aRANBJ/WG2I4OIE5?.<3\1,QT:B45?C;A>:EE$?CN23SZ[\B88[VA&%C<5<9\QA#0BED^O<<@CT7KR;YBZWCBFXYONDO<HQ[e^FBlD0D]HX?6>/>(+PB]_=%77LDG>K<XM3F9G6_beXQGYU*k4P,e3-LQ['E;FV`DkKSKS\LcM;[J`(PPMbeOpUnbK\Lnd^F>R>N-=b[2gZ3M;y[Ch9^MnPU7]J24H:=F.:tOBaN7XX<jaIF_+KJJOnKNllJM1LZK6`-DkdbHLWNJ`TjJ:ikk\`d['kW@OLA2_HOXW7W;]<aS9H1KH_,/7VN&UZHLWUTY38`^WRG<ZDR1[0OE;DdOF?j`U\0:MC@GQ>c[FVJ?NR[&`YX3HlkMCY3x{WkK=TaMcLlJK]JBY@odJ?^l[b6Fb[=<c;tX,P[bH.IHCj`F*dQPMT&bbMMH^U7G=JX.GU4c@[?h@CEN@]Y9KHS.VVF4DW[:IKIA`KcX^-UPJM>K\LKLJN=N+[I^-hQJ5EC&L`dcP_K[MMe60OQ`0;M7cb>dHa`\>y&YZ7Y3AF9M4OO4R0\ZQDINRNJ-gZ9]Gg?HMia2R?kmkLTl?dcVHAF+49`$U`\^Jf@yc\KLeGP=kIbAljEHJ5imA/`\b[a[?|\?O-a^82N?V]JKJ>m[Gg>xLk^9WQE`d8mmcSeFJmN>T;D/Xp^QeLR/_T*WA8hadGFgJZ\BP7ZdKM\bJM2\B$^:jjmkKOd]^M`JCD*Q@aba:i_WaJFXa
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2802/ccs/fwd np:i:14 rq:f:0.998759
  AAGCAGTGGTATCAACGCAGAGTACGGGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTGTGAGGCGCAAGGTACATGCTCTTACCCCACTCTCAGCACGTAGGGAGCGGAGTGTGGAAGACCAACAAGCCCGTCGCCTCTACCAAATACAGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAAAAAAAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ~~~~~~~~~~l~~~~~n~~~~~~k~K~~~r~~~~]~~r~~~~~~t~~b~8~{_~~~m,n~~~~~~o~v~~C~z~v~~o~~~~~~~{~~~~~~~~~_~~~~7~~~~~~~~~s~~~~~~~~~~~~~~{~~r~~~~~p~~~~~~~~~~~~;~~~~~q~~r~~|~~~~{~~~~~~~~s~r~a~~y~~y~g~~u~~~~~B~~~~~~~~~~~~~~~~~~~~~~p~~~~~~~~~~~~}?~e~`~~~Z~~~~u~n~~v~~j~a~~~~~~~~~l~~~~~~~~~~b~~~V~~~~~{~~;~~~v~Q~~~Z~~~~k~~r~~~~i~~~~~~~~~~~~~~~+~~~~r~~~O~~m~~~L~~~~m~~~X~~~~~~Q~~~j~l~~~~~~~~y~c~~a~~W~~~~~~~~~~X~~~~~~>~~~~~m~~~~~~y~~~\~~~~~~~~~<~~~~~~V~~~a~~_}~~~P~%|~~ac~~~g~s?hqn~~~ys~~~~~j~~~~}~X~~~~~~~~~~~~Nzrh~a~~~y~J~h~~~~~~~~~~~~~~~~z~~~~~~l~b~~~~~v~~o~~^~~p~~~~~~~]~~~~ry~l~~}~~~~~~~~~~~}~~~~A~~~~~~~~K~~~~~~~~~~~y~~~zP~6~~~~~~R~~z~~~J~~~u~~~~~~~a~~~w~ut~~w~~~~~k~~~~a~c~\~~~~~y~~~G~~~~~i~~~~~~~~~~]|E~~j~~`~~g~~l~~~~~~i~~~}~r~l~t~~i~X~~~p~~~~~~~~{q~~o~~~l~~~~~~~~~Y~~w~~|~=~~~u~s~~~~s~~~~~~~~~~~~pj~~~~~~~~~~~~~~|~x+~~s~~~t~~~~~~~~~~~w~|s~~~ilt^@~~~rA~~~x~~~Z~~~V~~x~~|~~~t~~E~~~~~~~~~d{~~~~~~~~~~~T~~~p~~~~y~O~Q~~~6~~~~~uv~~~Z~~~{s~~~~~~~Y~~~~~~~~o~f~~{~~~~~~~~~~~z~~x~a~~~~~R~~~~@~I~~~~~~~n~~~~~\~w~~~~oH~~(~~~~~~~yb%o~~~~~~~~~~~~~~~~~~~~~~~~~~~~^zh~~~~~~~~~~R~vzxwz~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2802/ccs/rev np:i:13 rq:f:0.999486
  AAGCAGTGGTATCAACGCAGAGTACGGGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTGTGAGGCGCAAGGTACATGCTCTTACCCCACTCTCAGCACGTAGGGAGCGGAGTGTGGAAGACCAACAAGCCCGTCGCCTCTACCAAATACAGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAAAAAAAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ~~~~~}~Y~~~~~~~~t~~~~~~~}7~~~~x~Z~}~~~r~ub^~~~~~~K~~h~~~~~~~~\~~y~~~~~~~~~~~~~~{~P~~~Q~~~~~q~~~]~~~~?~~~~~~~~~~b~~}~~~~~~~~}~u~~~~~~~~~~e~~~s~~~l~~h~~~~~~~~~~~~~~~~~~^~~~~~~Q~~~~~~`~~~~~~~~~~~~~w~~~~~~~~~~k~~~z~~0~~~d~4~~s~~~a~~~f~~~~~~~~i~~~zn~|~~~~~~~~~~~~~~~~~~r~~~S~~Fop~~Y~~V~~~~~~~~~~~~~~~~~~~~~X~r~~~}~~~~~~~~~~~~~~~P~c~~~~~~~K~~n~~~~~~~~~~~~~~~~~m~~U~u~~~~~~~~k~~~~~~~~~~~~v~~~~}~vR~f~~~~~~~lQ~~~~~~~~~~~~~~~~~~~Ll~~~~~K~~~~p~t~~~~v~~~~~~~~[~~~~~~~}~~~~~~~o~u~~~x~~~~~~~~~~~~~~~~~~~~~~~~~~~}~~c~]~e~{~~oa~z~~sL~~[y~~~~~~~ftu~~~~~~~s~~~h&~~~~~~~~~~~~~~~i~>~~~~~~~~V~~~~e~~F~~o~L~~~~~~p~w~k~~~~~h~~~\~~~~~~H~~~~~~~~~~~~{~~~~T~~~~~~~~~y~~~~J~~~~S~~~w~~~~~~~~d~~v~~o~~~~~~O~~~~~~k~x~w~~q~p~~n~~q~tw~~~~S~~Z~~~~~k~~~~~~~~[~U~~~~~k~~h~~~~~v~~~n~~~~d~~t~{~}~cl~~~~~~~~m~~|~^~~~~~~~9~~~~~~~w~~~~k~~~Y~~]~~l~mT~~O~~~R~~~~~~j~~~~J~~~~~y~~~~Z~~~~r~~~~~~~~~~~}~~~~~h~~~K~~Q~qY~Y~~~~~j~~v~~k~~~~~l~~~~z~u~_~6~~y~h~k~~~I}mb~~~L~~~~w~O~~y~~~~w~~w~~~~~z~~}~~~~~X~~H~~j~~~~~~~~w~~~z~zk~~~_~~~~~~~~~~~f~~~}~~~Q~j7~~~~~~~~~)~~~~~~~~~~~~~~~~~~~~~~~~~~~z~~~~~w~~uP~~~~~~~~~{v~~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2877/ccs/fwd np:i:11 rq:f:0.998386
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTGCGTAACTATCTTAAAAAACTTCTAAACTGCTGCTTAGTAGGCAATAATCGACTAAATCCATAATTTTTGCGACCAAACGCAAACTTCAAGAATTTTAGACTTTGAAGACCGCATCGGCAAACCCCATTTTAGATACCACTTTAATTTCCAGTTAATCTACGACGCAAGTCACTTCTTTGTCGTTAAGTTTTATTTAACTGTCGCAAACAACAAAATGGTTTTCTAAATTTACTAAAACCAGGACGCACCTAACTTTCTAAACAAGCACAAGTTTAGCTTCTTCGTAAACGTCACCGCGAACTTTGACGCAAGAATTTTCCATGACCATTTCTGGTTGGTTAGCCGAATTTGGCAGTTCATGTTTTTCCACATAGCCATTGACTCCCACGAATAGGTCTCTTTCTTCTTGTTCCATGCGAATGTAAACGATTAGGCGCGCGATGCCAATTACTTAACTGCGTTCACAAATTTATGGTGAGTTGATTGCTCTTTCCCCATAGTCATCGCCAATTTCCATTACATTGTTACCAACAATTAGGCAGGCTAATAAAACTCAAAGTTCGTGTCATATGTGTAAATTTACGTTTACCGCATATACAATGACGAAATGGTAAATTAAATTTAAATTTCTTTGTGAACGCAATCTACTATACCTAAATATGTGACGTTTTGTTAAACGAATGCCGTTTCGCTTCTTTTCTTATTTGCACTATTACTTTTTCAAGCGGCACTACCTAACTCTCTTGTTGAACAACTTCGACTTCGACTCGTTCATCAATTATACGCACTTCGGTGATTTCGACAAAAGCGACCACAAGACCGACCATTCATGTTTCATAAGTAGCTCACAGGGCATTGCAACATTTGTAAGACCGAAGACGACTAGTCCCATAGTCCTAACGATACGTCCCACGACGTGTCCCAGACTTTCGGCTCCTTCGGCAATAAGATAGCTTCAACGCGTCCTAGACGCACGACAAGTGCCATACCTACGACTACGACTTGACTGCAGATACTACCGATTGCTTCAAGACGAACCTTAGTTGGCACTTTAGCAACTGCACTAGTTGAAATGGCGAGCACAATTGCATCCAGGCCGACAATAGCCATACCAAGCGGCACGATACAGATTGGACTAGCGTAAACTATAAACACCACAAGCAGGCTACTCGTGAGGCTGATCGGTCTAGAAACGTTAGGCAAGACATATGCCACCGGCTGGGCGACCGACTTGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  ~~x~~~~U~~m~s_~~~p~~~k~~`%~~~~~~~~~~~~~~~~~~~~~~~~~k_qr~q~q~s~~;r%~~~~blf~~yG~uAXK~j~~~~~~~~^~~j~~r~~~v|R~5~~~p~~~~~S~~~~Is~rQo7q~~~~9~~~~~~`~~t~W~~~psnmU~~vt~~~n~s~~~~e~qo~~O~~~mL~~~~~{~se~r~s~~m~r~~=~~~u~q~o{~^]R~~t~n~x~~~qr~~M~~w~~~w~q~~E~~~~u~~|~w~~~s~~X~~s~~~M~~~~N~Q~~f<tC|~B~~~~q%~~~b~~f~r~{u~[~{j~qw~~~~;~~~C~nt~~u~~f~~Xg~w~~~~p~~\~~~x~~[Q~+dve~ln~~~K~~~r~~O~P~~~b~e~~~`~pe~~}~r~r~|~k~~wk~~~~`~~q~xh~w~~~~qH~~~~Y~~z~~~~Q~~~~~~~~Z~~~~~n~~~~~~~~~W~~~~~~E~~~~u~~~~~~T~~~~b~~~~~~~~g~VO~f~`~~~F~H~p~~~|~`~p~W~~n~vd~^~~f~~~~j~~~~~k~~~~~~~~~[~~H~~~~~`D~~~~~~E~I~Y~~r~~~~~{~~~~~~~h~X~}~~~~\O~f~z~~|m~~U~~f}~~]~~zb~~~~~~~W~~~~k^~]~~r~~~~~~~~~Z~xn~~~~~~t~~~~~~P~~~-~~b~~w~Z~~u~~=~~o~~vs~~~~|^~~~~}~~~~~~~~~m]~~[~~~~~~~~~}~A~~~k~~X~~~~o~~~0~~e~~~~~~~}@~~~z~~xg~~r~~w~~~~|~W~~~~~V~|yi~Cy~~~s~yt~~~~~~Y~~~~~c~Zm~z~~~~~~~~h~~~~~~m~~~~~R~~~~~~~d~~~~~~o~~~tj~~~~~bY~~~i~d~M~u~{~~~\~}~t~~oX{~~~L~~~~~m~~~~~~~}S`~*~~p~~~~~{~~~n~~~~u~{zf~~T~|4~~~~~~~uU~Rw~~~~k~~t~~}R~~~~~k~~~~~k~~~~~b~~x~~~[~~~`~~~x~m~z4~~k~~|~~~~~~~~~~~~~j~~~q~~T}~~~j~~~k~~~~v~a~g~~s~~~~~~~~~~~~~~~~~p~l~~~~~~~~{U~~~~~~k~~~h~~~g~v~^~u~~~n~E~~f~w~~~h~m~~~|}o}~y~i~f?~~~T~~~~~~g~~~~~}~~~o~~{~t~~~~x~~~~c~~~{e~w~k~~~|~~fz~~ik~X~~b~~~~x~~~~]~~~~~~Z~~~~g~O~/~ng~g~}~~~~y~~~~}~~~~~~}w~~~~~d9~~|~|~~X~|e~~~~~~~~~M~nL~$p~~J~~~~~u~~~~~~~O~~~~~~~~|~~~~~~~~~~j~~~~~~V~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2877/ccs/rev np:i:11 rq:f:0.999591
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGCGTAACTATCTTAAAAACTTCTAAACTGCTGCTTAGTAGGCAATAATCGACTAAATCCATAATTTTTGCGACCAAACGCAAACTTCAAGAATTTTAGACTTTGAAGACCGCATCGGCAAACCCCATTTTAGATACCACTTTAATTTCCAGTTAATCTACGACGCAAGTCACTTCTTTGTCGTTAAGTTTTATTTAACTGTCGCAAACAACAAAATGGTTTTCTAAATTTACTAAAACCAGGACGCACCTAACTTTCTAAACAAGCACAAGTTTAGCTTCTTCGTAAACGTCACCGCGAACTTTGACGCAAGAATTTTCCATGACCATTTCTGGTTGGTTAGCCGAATTTGGCAGTTCATGTTTTTCCACATAGCCATTGACTCCCACGAATAGGTCTCTTTCTTCTTGTTCCATGCGAATGTAAACGATTAGGCGCGCGATGCCAATTACTTAACTGCGTTCACAAATTTATGGTGAGTTGATTGCTCTTTCCCCATAGTCATCGCCAATTTCCATTACATTGTTACCAACAATTAGGCAGGCTAATAAAACTCAAAGTTCGTGTCATATGTGTAAATTTACGTTTACCGCATATACAATGACGAAATGGTAAATTAAATTTAAATTTCTTTGTGAACGCAATCTACTATACCTAAATATGTGACGTTTTGTTAAACGAATGCCGTTTCGCTTCTTTTTCTTATTTGCACTATTACTTTTTCAAGCGGCACTACCTAACTCTCTTGTTGAACAACTTCGACTTCGACTCGTTCATCAATTATACGCACTTCGGTGATTTCGACAAAAGCGACCACAAGACCGACCATTCATGTTTCATAAGTAGCTCACAGGGCATTGCAACATTTGTAAGACCGAAGACGACTAGTCCCATAGTCCTAACGATACGTCCCACGACGTGTCCCAGACTTTCGGCTCCTTCGGGCAATAAGATAGCTTCAACGCGTCCTAGACGCACGACAAGTGCCATACCTACGACTACGACTTGACTGCAGATACTACCGATTGCTTCAAGACGAACCTTAGTTGGCACTTTAGCAACTGCACTAGTTGAAATGGCGAGCACAATTGCATCCAGGCCGACAATAGCCATACCAAGCGGCACGATACAGATTGGACTAGCGTAAACTATAAACACCACAAGCAGGCTACTCGTTGAGGCTGATCGGTCTAGAAACGTTAGGCAAGACATATGCCACCGCTGGGCGACCGACTTGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  P~~~~~~^~~~~~-~uw~~~~z~~~)~~~~~~~~~~~~~~~~~~~~~~~~~~~~{vXmtA~~~~~~a~F~~~~~+~~un~~~eiA`EAl~~~m~l~v~~~~~~~~~~~k~~rt~~~~~G~~~~k~N~e~e~~~v]9~~~x~~Y~~~~L~~~~~~~T~~t~~~~R~qw~~~_~Nb~~]~~~~J~~~bWs_nd~~ks~~z~W~~h~~~k~~~~~Z~{~~~~{y~]~~~~~~~M~~ue~~Q~q~~Y~~~~`~~u~ypV{~YOes~~z~z[~~~vm~,~~~qek~~L~~~~{T~~~x~~`~~f~j~[~~k~vg~~_~V~~d~~~y~~x~~V~~~x~s~~Q~~~`V~~~~~~~v~u~~^~~f~~~~~~~~~xo~S~~~d~~~d~R~~M~~cu^~c~c~A~~~x~t~~N~{=~~~~N~~~K~;~~~~u~~v~y~~{~~t~h~~yd~~~~~w~~~a~~qr~J~~~u~fZ~tN~O~~Xt_k~~~~~[~~sW~v~~>~ob5QZA~~~z~~~e~~~{~b~~~w~]J~^gs=~~N~~~[N~y~~~~~~~t~~{x~^~~/~~~~~~y~y~~d~v~~~T~~b~~\~~~~g~~|~~k~y~zt~T~~U~~~a~~~}~uk~~~~~{y~~tX~~~~^r~~k~~b~{iW~~e~~~{w]~~~K~~~~x~\~zS~~~~~~`~~~c~Lk~~y~Y~~8t~I~~c~~~e~~~~tx~~~{o~X~~~~~~~~v~~k~~~~~~E~~~`N~~~~q~l~~~vt~~~Q~~i~~`~yq~~?~~~~~f~~d~~~L~~~~m~~~I~~~~~~~~xk~v~~~~q~}M~~~~|~~~wg~}~~w^~~t~~~~~^~~~~~~~pr~~~~~~~f~~k~~~r~~~~~t~~~~^~~~~~gT~~~~~~~o~~i~~~~e~|~~~~~~~~~~r~~~~~~~m~~~~~~~~~H~tW~D~~X~~~~Z~~~~y~y~~~~n~~~~~~~~~~~c~~~l~~~i~~q~}~~t~~~W_~~~~~~~~]~~]~~~|~~F~~sN~y~{~i~~h~~~p~~o~~~~~~~~~~C~~y~~~z~~~f~~~~~~l~~v~~~~Z~~~~}~~}~~~~~~~~~~~~d~~~~~~~~~~~[~n~~~M~~VS~~~~~~~~~~x~h~~~t~z~~~~O~~f~~i~~P~~~~~~~V~~q~~lv~~~~~~~~~~w~s~~~z~~m~~~~wRz~z~ky~~k~5~~~~~d~k~~~~~~~~~~~~N~}~w~~o~~X~~~~~~~~~~~p~~~~~~~~[~~~~~~~~/~~~z~5~~~~~j~~~~~~[~~~~~~~z~~~~~~~~~~i~k~~Q~~}~M~~g~s9~x~~=~mI~~~~~~~~~Mo~oc~y~~~I~~~~~l~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2884/ccs/fwd np:i:11 rq:f:0.999491
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGAAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCCTAACATGTTTAGGAACTTCCCCCGAACGTTCGACTCTGAGACACCCCAGGGACCGTACTCTAACTACCTACCTAGTACCCATAGAGAAGTCTTTTGACTTCCAGGCCCTACCACGAGAGGTCTAGTCGAACATCTTTGATAGTAGTGTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTTCCGTATGTGAGAGTAGTTGTTCTGAGAGTACCTTCGTCTACAGGTAATGTTCAGACATTCTCTTACCTTTCTTCACTAGGGTAGATTTCCCACAGACTACCGTCCCCCCTCTACGGTAGGAGTGATGTCACCATATAAGAAGTTACCCTAGTATGACTCAGGTCCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACCTACTCCATGTTGACCTTCTAATGACCACTAGGCTCTATACTTCTCAGTGATGTGTTGGGAATGGGACTGAGAGTAACCAACTCTTGTACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCTCACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  ~~g~~~~f~~_~~~~`~~~~~x~y~%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~M~~~|~~{w~~c~z~d~z~~Z_g~Y~~H~~~~aw~L~~~~f~}~~~`~~~~w~~~x~v~t~~~~H~u~~~~u~v~~~vg~~R~_t{~~~b~~g~v~z~c~~~^~wY~~~~~~~`~~v~sq~z~s~q~~Y~~~mz~~~W~j~~~a~I~z~~~~~~3~sN~~~~~~~~~~~~~p~~~~~~~~~~U~~D~~~j~~~~~~k~z~~e~@~~~\~~~q~~~~t~l~s~~~~~~~~n~se~~Q~~u~~a~0~~~q~t~~q~~~x~~~xz~~~Z~~{d~~~c~@~~l~t~l~~b`~u~~f~v~~~~uQ~C~~]~~~~~~L~~W~e~v~~M~L~~rb~~~ty~~~h~~~~~T~~~vb~~~\~~~~~q~?~~Z~t~\~~~~v~~v~~a~~~uB~~~~c~~\~]~~~~w~~~~~xg~a~~~L~~~~R~c^~~L~~~~~~~~~~~r~e~~~~]u~~~~~y~~~~z~^b~~s~~~~h~~u~ray~v~~~~~~~g~y~~w~~e~~~~~y~~~o~a~qv~H~~~~~C~~zy~Kx~~~~~a~~~a~E~~~~N~o~]~~~~wut~c~v~~`~~~t~~v~~vL~~~~~~~~P~z~wC~~~t~~~~w~~v~b~~~~Y~m~y~~~q~~~~v~~~~v~c~~_i~~{~~~~~~~x~~~z~~~x~~~~~~~~~~~~~~~{w~~~~~c~~~Q~~~~w~p~~|~a~]~s~~R~~M~~K~P~~X~~~~~v~~~|~~~~~|~~e~~~~~~u~~~`~~~xz~~~u~~y~~\~~~~~tx~Mn^~~]~~~~~b~q~~u~~c~w~~S~~~~~^t~~H~~~~~~v~~~Xo`~)~~~~~~~~{~g~~~x~nw~{~~~~x~e~>~~~_~~~~~}~tI~~~~~~~~~~~~~~v~wD~~~~~y~~~_~~~~~~~~w~H~]~p^~~~~q~~~~~~~~n~~c~x~~~~~k~~mk~~~~~uw~~w^x~s~~~~b+~~~c~}~~~z~y~T~~~~}w~^~~~~~~t~JL~~~~~~~~~~f~~~>~~~~~~~~~u~~b~~mW~d~j~`vz]~~~~~~~~p~~~~x~~6~~d~~}~z~~b~~]~~c~[h~~f~~W~~~`w~g~]zv}~~~p~~~~~~T~~~~{~e~~v~r~~yf~~~~~~x~N~~~~~I~~~H~v}~_\~`~~Y~~x~p~|~nZF~~~~~~~`p~~~w~q~~~~V~~\~Yp~Y~~~~~J^y~~~~n~~d~~~~zl~d~~e~~U~~wx~o~~>~~f~r~~~w~~z~~~~c~y~~~~~~~~~~U~~B~~~~v~~q~v~~`~~~~~s~~~~~p~Kt~~~~|~|~~~w~~~M~~~A~~~~~~[~~yI~~~~~J~~~~~~ux~~~~~~~v~a~~v~z~s~|~~{~d~~~J~~d~~~~~_n~~o{~V~~z}~{e~~p~5~v~~~~w~u~~~~S~~~~nM~S~~~{~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2884/ccs/rev np:i:10 rq:f:0.999243
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTGAAGTAATGCCTCTACGTCAGTCGGAACAATGTCGTCGTGTAACTCGACGATCTTAGGAGCTACTAAGGAGAGTCTGTAGGGAACCGACTGGGAAGGTGCCACAAGTTTTCTCTACTACTCCGTCTCCTAAAACAACTCCAAGTGGAAGGTCTGTGGGTTTTTGAGTATAGTCCGTATCTAGACCCAAAAGGGCTTACCTTCGCAATGAAAGAATATCCTTATAGACACGAACGGGAAGAACGGAATCGTTATTAATGACGTCGTACAACGTTTTCCAAGTTCTCCTCTTCCTCCGGATTCGGTTTGGGTTATCTCAACTAGTCCTTTTCAAAGACATTGGAGAGTTTCACCTTCCCGTTAAGGTAGAACCCTCAGCATGTTTCACCCCCGGTGACCACTCAGTTACGGAATGTTTTTAAGCCACCTCAGCTAGTGTTCCGAGAGGTGACAGCGACGACGTCCACGTTTGGACTTGTTATCATAACATCCTAACATGTTTAGGAACTTCCCCCGAACGTTCGACTCTGAGACACCCCAGGGACCGTACTCTAACTACCTACCTAGTACCCATAGAGAAGTCTTTTGACTTCCAGGCCCTACCACGAGAGGTCTAGTCGAACATCTTTGATAGTAGTGTTGGTTCAGATATTCATCGTCTGCAGAGTCAGTAAAGTCCTTTGACCAAGGACCCAAACCTTTCCGTATGTGAGAGTAGTTGTTCTGAGAGTACCTTCGTCTACAGGTAATGTTCAGACATTCTCTTACCTTTCTTCACTAGGGTAGATTTCCCACAGACTACCGTCCCCCCTCTACGGTAGGAGTGATGTCACCATATAAGAAGTTACCCTAGTATGACTCAGGTCCCCCACTATCCATCTCATGGTTCCTCAGAGAAGACTAGTAGAGAGGATCACATCAGCTGTACCTGCGTATACTGTTTTTGGAGATGAGGTTTTACAAGGGATTACCATTTACAGATCGAAGTGGGGGCTCACGGTATACAACAGGCTGTTTAGTACTAATGTGGTAAACCTAAGGTCTCTTAGGATTTGGGCCCGACAGGACACTATATAAGTGTTGATCGTTTCCTTTCTTTCGTTGGTTTCTGCCCTCCGACACACCTAAACACCTACTCCATGTTGACCTTCTAATGACCACTAGGCTCTATACTTCTCAGTGATGTGTTGGGAATGGGACTGAGAGTAACCAACTCTTGTACCTTCTGTTGTTGTTATTTTTATCTTCCTAAATGTACGTGACCACACTATTGTCTCCGTCTCTGGGGGTGTTTGAAACATCCCATACACTGATGTTGGAAGTTCTCCTTTGTAAAACCCGGTTGACACTCGCGGACAAGCCTCACCCCGTACTCTGCGTTGATACCACTGCTT
  +
  _~z~~s~U~~~v~~~k~G~^~~v~~&~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~StY^~~~ui~~~~~~~pb~~/~w~z~{S~~~~~b~~~~~w~~~~~A~~z~~\X~~b~~~zW~w~~~m~~~~~nt~~~~T~~~~a~u~{~g~~~~d~X~P~~~~~~>~~~~~~~~~~~~~u~~p~~L~pR~~{~z~~~y~~~~~d~~~M~~~~~~P~k/~~~~~~~~~~~~~y~~~~o~u~w~U~~@~~dG~~_^~~po,~Xkux~~Qs~~gp~j~l_~[~{v}Y~vpq]v~c9~~m~rt~~@~j~~v~d~~V~v~~x~~~t}~[~~h~wo8~~~?~z~~i~z~i~~~~~i~~b~r~~T~|v~]~~R~~H~~d~S~w~~~~mi^~&~~~~_~~p~q~l~g~~~~T<~~n~q~W~a~~~}~g~^~ZomRwZ~~~~~~~~S~R~~~~(~~~ro~~~~P~~~~p~~s~~~U~i~~~<~~~~~~ro~~W~v~~p~~~~ejL~Fv@~w~N~by~~~~~Z~~A~~~wZ~~~~P~~n~~~Z~~n~~j~~ju~~~~n~~~~m~~nK~~~h~q~~Z~;~~~~zp~~oY~~~~p~~~~~Y~~~X~~~~M~~lj~{d~~~~}:~n~~H~~~q~b~~X~=~~~|~~~ku~?aoR~~~~~~k~k~~PwQ~~~~Y~~~~~~~0~~~{~^|p~~~s~]LK~~~~v~~~~~~ls~L~8~~~~~t~`~~}]~k}~f{J~z~_m~~~zg~~o~\~R~~l~]~_~]~~S~~n~~k~Y~~n~~~~hm~~~t~k_~~m~dW~~~~~Y~~zyX~O~i~~~~~~~H~~~~~oHp~~~~~~p~~@~m~~Z~B~~~u~~~~j~_~~~~g}[~~E~~~~{_L~~~o~~|J~~~~~~q~~~j~~~l~~~lY~u~{g~Z~~~~~~~lr~~s~~_~~~~~~~~u~~w~~m~~P~~~~[~w~~l~~{~R~~~j~d~m~~q~~~~K~n~r~{{{~~~T~j~~qt|~~j~~|~~o}~Y~~r~J~~~~~k~C~~~~]~~~~}i}N~F~~~~~i~8~mYT~~s~~<~~~~~s~~~yR~~~B~~~~~~~~jD~~~~~~z~~~Y~c~hh~~~~~~v~~~~~_R~tf~~w~vj~S~~|Y~Q~~N~~f~~R~~T~~~~v~M~~{~~~~~~~~~x~og~~~~~y:~~n~D~~~W~~~uI~e~N~~~>zd~~~z~~~~~~~{~~p~~z~S~~~~~o~~~~r~~~U~Y~~x~~~w|s~x~~~s~{~~~~~~r~~x~~~~~~~~y}~a~E~~~~~e~~y~~z~~~~~~~w~K~_~~~~~~~g~>~~~~t~~p~~p~~2~~~~~t~a~e~~M~v_|y~~~~a~p~~c~x~~\~`k~~v~~~~~~~@~~~~~~[~~~O~~v~qW~~~~~K~~~~~r~R~g~w~~N~~~b~`~~w~W~~~_~~S~@ud~~~~~z~~f~~yi~sp~s^~_~~~~~~~~~~~q~C~~~~~w~~~~l}c~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2899/ccs/fwd np:i:5 rq:f:0.991514
  AAGCAGTGGTATCAACGCAGAGTACGGGGTTGGTGTATTTATCCGCTACGTGGTGGATGAACATGGATGCGAACGACATTTCGAAATATACGCAATGATATCCAACCCTACCGAAACAGCAATAATTGTAGAAGGTAAGCATATCATGCCGAGAGTTTACTACGTTGTAGCGAGTTTAGTTGAAATAGTTTGTGATGTGTAAACTAAAACATACCAAAATGGTAAAACTTGTCACCCCCATTTACATTGCGAACAGACACAGTTATGGAGTGGATGGAAGTGTGTTCGACTGTCAAGACCCTTCTATAATAGTCGAACCGTACGGTAAGTGGGCAACATGCCCATATAAGTCGAAGCATTTCAAATGGTTCATCCAGTAGACGACGATGTCCTAGACAGTCATGTCTCTTCCCCATTTGAAGTCATGTAGTGGTTGTCTACTTTTTCATTGAAGACGTCCACCTCAACGCTATGAACGTTAGTTGAGACAATGTTAAAGCAAACGACAACGTCATTGTGATCTACATACACAGTGGATGGTTAGCGTAAACATGGTGGAACGTACTTTGACTGCGCTGCAAGAAAATGGTTGGGTCGATCGTAAATGCTAGTCGTTACATCGGAACAAGCCAAAACAAATCATTCGCTGGATTTAGACCTACTGCACGACGACGTCGACACAAGACATTCTTGAAAGCGCTAGTCCCATGAAAATGTCCTAGCTTTGAACGTTTATCAAATGCAAGTTGTGGGAGTTAGTCATGTGAGAGTTGTGCAAGAAAGTGTTAACGTTCTAGCCGTGCTCAGTAACAATTACCATTCGGCGGTAACAAACGTAAGTTGTCACTGCACTCATAGAGCATGAAGTTAGACCAGTAGTTGGGTCAGAAATTAGACGTGGTTTAGTCTGGTTACCGTGGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAGATAAACAAAGAAGAAACGGTTAATACGATTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTTCAACTAGAATCTACGTTTCATACGCGGATTCCACATCCGTTCTTGCAATTAAAGAAACGATGTAGAAAACGCTTTGGTTGGCGACAACTTGGGCGGCAAAAATAATTATGGTAGGTAATTGAAGTAGCGTTAAAACGCAAAAAGAAGGAAGCACGGAATCACTGCCAAAAAAGGACTACTCAAATAATGGTTTTCTAAAGTCATTATGCTGGTGCTCCCTATGGCGGTGGTCAGTACTGTAACTAAAGATGGATTACGGCACTTGTAGAGCACGTATCAGACCCAGCTTTGAAAGAAGGCTGAGTTCGGTTCGGGTTTCACGTAGGCCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGGTTACCATGTAAGAAGCGGTAGACGCCATGGCCTAGTAGGAAGAATGCTTGTTCACGGAGCCGACGAAAGTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGGAATGCGTACTACGGTCGTCCAAGTTGCAAGAGGTATTAGAGTCATTCGAATAGCTGTGGGAGTGGTATTTATAGCATAATAAGTGTAAAAAACATTCCCAACAGCATATGTGTAGCCAAGAAGCGTTGTGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGATAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGTGTGCTGGTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTAATGTTCAGGAAGAATGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCATGATTTGGTCGATGCGGCAAATGTTGCTTAGGACTATTCTATGGTCTTGCGTAATTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGCGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTTCCCGTACTCTGCGTTGATACCACTGCTT
  +
  YwY+]ZGNu]I\@8aOZMVTKZ]KQ/YaX-rKtYSW_-ZIGDDr[S`\PW^;l]KtJL[FrRZE(n^^ZPZ?a2CJGKGovS[Jvv]][^<DPA\LZ`\LXDYJZ2vcFK@qUIvuT\Z=/`[?X=q/ZCR?UJpZ%SUS`^\WQIFY2sCKVUH,_^X=4KLXH[LV'L;IKJ4\S;PQdY-rlOJK*]_/MMGWWZZX5g\S`CuvqMG\M-R%d[HGKt^6Z]YPQdL\7D'EFdY_GvqGOaQv[Q@$;MUE&:RM-EKqJS7V^X\=t_^LuNW[X0NBPuSZE<WH^S6cX$.ZU@gO]]]@oZ\KHTZMW<N$0:0>l\Oa[]6tsSQtRH\E3wx\Za\SvWWR[LqUR`8vhR6rlT<q@aLJFEb`[^]X5>YKQXXSQ/.e;2X0=^WWR_[V\<FPAc/smP6:saL@_IY>_YU]LZ^LuQv[^>\KS:viQQ=DMrZCuVVRZF8r_EoGP9cSXP\K]ZBVH:M\^[PuKIWG<@hTSPvFYR.<9po=Z`Q/kNKKR`QsI\4\GR]\?\.T>H=FBE>][YKo-s_XMX`5gdT^^Mu^:sRuT[]G*8omX%Q\ER[R^[RAsZ&qnEBGqRm;tb2'W`_QDE'R`]V:9L8BEWNX_P2>QNwSvSMt[Bd>\`mSGurVOH2ENC>]BeLFkoV[`-f^`O0XO7LTE:Z^NVZ&A\OIN2jVWB`OjPNVL;^UYRZOZ`[[%jFIEY1YJc][]7^LXQ9<Y`UCkNV<u^I7>:b^]ZRIOP;iZ\6ptZUPu`[W(ZG1ZW3UEV,hI^JL$9J7TWDUC3P:8D@@XNIZ$=SRBTR\>_YGQtNOqPtYEu]+b:2EH0-:=mRIsuM[^MRZRtZM849NZLE8WPKX(H_YS]0XAsZOtKX`Fy`[]]Y?tCtu^S`Z9sjMYJY7PAY*j:r^HZ]>]LuRv_3rU]>[;ss[Lu^[WLGXP_OZR8tWDHIYFz[`L6`bH=F'PUSE[l[=bXHmXPLt<ZNeV<Q[_0`X^*o^Z;rs]F>oM86H%=6L=KpO0pQG_QvKa>TFi_SLd<F^ZAs\TZ8@[Gvq>[SDR[SNt`Qr@fKMXYEwY.qQA`ZNMm@WF[iD:ssPZ`XA\OIAovqSV<)e0,oQtLuS[KPPXQPu1P7?5L6*d_b]Y>X@_V^=s^KFU2MaOuEJv\^`ZBY/c'hrY(S:<\KHlbU~TpSuN)G+I]&TVE81Ma'>-ZK^e@9Z@CdUIV5/~mcH~HA_(\k40a@|{acKkZskje[h7qgOVd5hwhkhNWSNWgA~gZT[JeE=bfL~[hN|gekiN~hQxVYC~Ei[Y~eikekcFi[ff<LVHSZ+yhieZFj_=>G^bCjQsFSaZN&kWPw1]O9fg;j|Dc,]ilS~I~bQ^GvV`OQqcjiiRZ~c9R~G~KoHP~~ei1~~U~Ma<)a2W8aV~eG~eZD~hUdk[eLiBgS~A~he`fT=^Rvc5xPd\Y~MGrYZZQmgeJ~ek[e+~kc8~fdjV_CdhTl2Sd[~d@~eGl_5iX~TQ&ALCZE7<U'AWJ=Z)2-[Z[RWW`ST9@9q[>Z^Dw8dUPx[M=nYW8WXV?t_Y3C]S`QfQ[NU^U[S^[^*sgaWYJt^`7lV`^`ZPB\NYZ0[Z^[^1tkZ\bQY?t8q^AsR`Z<4V[UXGWWYZBpOXCOa[OU?_XFYC_A-:P\@]6ttqD\BaKtFIVJGYNZHUN`QgJX0sua[\E^FXYOXQYYQ9J:X[+5ak]=VD][V.Y8_gT4OIMEZ8Q.ODY\HRPpC)U5LW[YADDPZHSO7hHK;L6M?@+M@C5)IOX?.0Q;PeQEPW4K,3O9H+2FI0JNlSPIOtAsD]RuS^`Q2eC[3WQ[^$STPKWR]:S>cB1VFGWS^`MY:S>ZZ%GKsYU-UTSOV\BnGQWKr^[KYK[RS1V;jS;B.SL25:@g[S^`^`[[*[[`RKR[`QvS_:YN6um[QvKs3DZ/QH_r[>w^^[\9\Y:r]>Z`\X>6TRFvuX\Np/N@_ZHoV9V:@k;\`^Lu\>InMLBEOq<dU^X@[XJ,QXT?^YY=h<LOH,Z<`WUQ=J_>\PD$psssssqiaafoqi`\[^`[\_`jrrmaZQJ-OCN:DOReX4F\AnXS]ERQp=xtYGKLZPGZS[Qv[@\CBQ39[GLSv
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2899/ccs/rev np:i:6 rq:f:0.993409
  AAGCAGTGGTATCAACGCAGAGTACGGGGTTGGTGTATTTATCCGCTACGTGGTGGATTGAACATGGATGCGAACGACATTTCGAAATATACGCAATGAATATCCAACCCTACCGAAACAGCAATAATTGTAGAAGGTAGCATATCATGCCGAGAGTTTACTACGTTGTAGCGAGTTTAGTTGAAATAGTTGTGATGTGTAAACTAAAACATACCAAATGGTAAAACTTGTCACCCCCATTTACATTGCGACAGACACAGTTATGGAGTGGATGGAAGTGTGTTCGACTGTCAAGACCCTTCTATAATAGTCGAACCAGTACGGTAAGTGGGCAACATGCCCATATAAGTCGAAGCATTTCAAATGGTTCATCCAGTAGACGACGATGTCCTAGACAGTCATGTCTCTTCCCATTTGAAGTCATGTAGTGGTTGTCTACTTTTTCATTGAAGACGTCCACCTCAACGCTATGAACGTTAGTGAGACAATGTTAAAGCAAACGACAACGTCATTGTGATCTACATACACAGTGGATGGTTAGCGTAAACATGGTGGAACGTACTTTGACTGCGCTGCAAGAAATGGTTGGGTCGATCGTAATGCTAGTCGTTACATCGGAACAAGCCAAAACAAATCATTCGCTGGATTTAGACCTACTGCACGACGACGTCGACACAAGACATTCTTGAAAGCGCTAGTCCATGAAAATGTCCTAGCTTTGAACGTTTATCAAATGCAAGTTGTGGGAGTTAGTCATGTGAGAGTTGTGCAAGAAAGTGTTAACGTTCTAGCCGTGCTCAGTAACAATTACCATTCGGCGGTAACAAACGTAAGTTGTCACTGCACTCATGAGCATGAAGTTAGGACCAGTAGTTGGGTCAGAAATTAGACGTGGTTTAGTCTGGTTACCGTGGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAGATAAACAAAGAAGAAACGGTTAATACGATTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTTCAACTAGAATCTACGTTTCATACGCGGATTCCACATCCGTTCTTGCAATTAAAGAAACGATGTAGAAAACGCTTTGGTTGGCGACAACTTGGGGCGGCAAAATAATTATGGTAGGTAATTGAAGTAGCGTTAAAACGCAAAAAGAAGGAAGCACGGATCACTGCAAAAAGGACTACTCAATAATGGTTTCTAAAGTCATTATGCTGGTGCATCCCTATGGCGGTGGTCAGTACTGTAACTAAAGATGGATTACGGCACTTGTAGAGCACGTATCAGACCCAGCTTTGAAAGAAGGCTGAGTTCGGTTCGGGTTTCACGTAGGCCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGGTTACCATGTAAGAAGCGGTAGACGCCATGGGCCTAGTAGGAAGAATGCTTGTTCACGGAGCCGACGAAGTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGAATGCGTACTACGGTCGTCCAAGTTGCAAGAGGTATTAGAGTCATTCGAATAGCTGTGGGGAGTGGTATTTATAGCATAATAAGTGTAAAAAACATTCCCAACAGCATATGTGTAGCCAAGAAGCGTTGTGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGATAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGTGTGCTGGTTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAGAATGGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCATGATTTGGTCGATGCGGCAAATGTTGCTTAGGGACTATTCTATGGTCTTGCGTAACTTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGCGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTTCCCGTACTCTGGCGTTGATACCACTGCTT
  +
  BhRXXM:<`J^]EQw[RH^R]>^_L/^WEIU6\NCK=*c\EHBW'ENHEGO/]M-U=,PKMaC[IAY=J91LPc[S^[_;ttYN=]h]Z_GHS[E_DA&Y_G]9q>tFvw`\)YNA;c[ZNQ;q_Pt'B@[ZN?]=UW]O@D\G^[_KR;dD7MG<Grp\SIV[RC`AKZS[S[O7_YHF2$$DnpW^A4]IOFGZRMR_8wp[\3luqHB\^?eGwv\?>Y5wwVEBs+I[^/ZX`\F:qs[TGQtRER]E[=FWSY]@Md^_;w^E`BtXKFvPt=LO;M2]X>\Y5P`[RuS^Ewk>nS^G^Qv`\.^YSN\JqUNG\FEy`QvRK9uuD@uWX^?BfE=S\5;m,JSM>L*X^8.5Y(ta]@\Oj[^OLu^Q6[RGZS_[PG_R_<tW\S_[^Ta[^`RIV]X1F(Yp\9mY>NnT`[^`S`^P[CvCoM`[`]E=uq_[[]0pP?tR^[PGJbBKt`ZAcDPDY[]RBuZRAs\=6PZMGZQv`SSvGwpMD;uvZS[WOYZB<Y^1oL;OE]ZK][^N_[]E\J_1o?U,4@q]>ZS`9xo[^^6h4B_?tZN`^[;ssR^[`Q/O[bREPuP7ru_DwLU-trHCPG^XMI-r[*X``RGTR.[HZY6ED_L\YM[TMh6vwD/,VQKUX-mYPVaC`Q*[c]RGMtK]GKQG^Z>\[RGX>^[Q55LL/])Z[^RuZ>RNEsp>VM[`^SNAt]KA6hvq_RJ9r_]>D6]lRQv[SJvv^_D6tm^>X.`L3@7F5TV\PDt1Q`VQFNTL\MT9M_@_SXMsR6e7&3@<TQe[MRv[``SJZ.7+I`I\PXOsD>ZLt^Lu]B`WDw[@qB=qY*hbZRLDV=>URHZ^ZKQ[^ZKZG^T^S[]M0@WRL`[)^Z7q]T`_@%<<q``\^R)s]6m^S^[R24nCqp_R\RWFnAs]LuS\Ap8mfSQv`[OZ`R?tZ`Z.urRCsRNvRKF9jiSL`Hvv[5ucS,YR9rqZCtBaPu``[S^SvS]3qFQ8^rGRBtZPvKMuA[B3^WQvZK]Of:XCQGZnE>tZ`^>>r^\_]EQ8j]Z]][[SZ3qE1oKu^[``KUM3\UQr>ZRwK`8h`Q+otZS^`RK]SBvvv[S[9pU-[C^CuZ>\Z@gEKf&oYPY5nZ8vvl]HWAq\KEtJYAt`Rx7cR@tR]^Q/ORq5uuuZRE/tuiVNHhD`M^?Z^[EtW2*X@SRZ2vvvXCaGYK][a[Rw\Mq`DbEpv[`FwnQR[IGTEQMTI5MULS/;>]W?XFAoF/TGC[KZ\N<[LMOX<pSL:kgS]MEu]=`WW0nZ^[Rr;U_R^S[^[PU/HYZ>\?xt]>ZEoZI8vS=OsD^WA;UNQoW?kMPE2GKA?MZ[CNZ^AW9q7\MLiYT^@v`]`]SQvS`?>N_=rZEWi>\H_qFn<YV<t]`B_>sR?hRECu_FP[J@8Z<X.TZJr_[O_^-H>t2'[\'VI^@GmU]ZBrX><iT^[R?rMRp]T]ZOZQ6Ev[[S@`?9WTNZO[^Dr]JV=[:s_\ZZ@3s\\\NMoFOVQWFYK]Z3s_[Q6HYRqSLuT[Pr=F@pYJ7VYR^KXI\OZZ=?aYBDTI9H&XKWZF54r]]<YV\J\T[``OvaNt>^OF/k]WcRAUMT)SO<cU[>F^]\ICB*ZCPNl;bO>nPD99R=I=Z`[S[S^[_.vuqQIC^BrX[ODCIDP3lZ]AsNr+re_PH<7IH(JhUZ]BDpvJ`YHal^2lPI]Y?N7K]^RXUDpJW\ODNH<5YMdS[T^1QBPPNPVY%=&?=C4W>tD\RKR[FvoJrb^R_EiV-EA9;LIOD<spUBK[QDJ=;MB*IOF_%*49@?XQELJLE\XPNZH33ZZ^,]=eR<\_-yaWV^?pAX@PGWOB\F<AaGPWOGGJ/4ONoWNBI5\M\Y`D]`[SQvZ=[1f[PV`^`MQGS`S^[^Z>G@qZ^EpBGtnP?_Ek]=F)XHvvSLuO:RV/g[4cJ[QFY@T.dA0^OWB?DNMCcG%P98MJTCpY5W$&]L>McD>4F7K,-J5=(;[M-@Q_>Kt]>PqFHZIM\A_Y:][PMEx[S$sttttttttrlc__ensttttttri`_iUFL]GHXHQ[RDqR]I]@r[TKOWPm0\LL``[`[^*_[SEgJFH\JV[UZ>V/p
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2903/ccs/fwd np:i:6 rq:f:0.993003
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTACTGGTTCGTACAGCGGTAAATGACTTGTTGAGTCTTGACGTCGACGACCAAAGCGACCACTTTGACCCAATTGCGAACTACTAAATCCTAAGCAAAGACTATTAGGTAGTAGCCAACTTCGTTAATTCCGTTCAGTACTTTTAAAATTCTAAACCGACCATCTTTCCGAGTTGCTTCAAACCCTCGTCCTAATGATTTTACATCGAATAGAACGTCGTAACAAACGCACTACTACATGGAATAGATTCTCTTGTCAAATCGTTTTGTTTTGGCTTTACCCTTGGTAACAAACTTCGACTACGTTCGTACAATTCAGAATAACCTCTACCTCGTTAATTTGAGTTAGTTCGTTAAGGGCTTAAGTAGTTTATTTCTATGATAAGCACTAAATTGACCCTTAATTTCCTCGACTTATTGTTACATCTCGATTTCCCTTGATATACTCAGATATATTTCAGTATCTACTATTAATATCAAGTATGCTAGGATTTGCAACCGTTCGATGTAAAAAACTAAGTCAAGGATCGTCATTTACCAATATACCGCCTATAACAATACTACCATGTAATGTTTGCATGCTCTATCTTTTGATTATTCTTTCTTCTTTATTACCCTCTCTTGATCTTTTTACCTATCAATAAACTTACCATCTTTTCATCTACATAATTTGGGAAATCTGAATTAACCTCACCCAGCCGTATTCAATCTTTATGTTCATCTATTCTTTTTGATGACCTTATCAAGTTTCTCGTCAATTACAGAGGTTGCGGTGGTTTATTGCCTCATTCATTGAACAAATCCCCACCCCTCCAAAATGGATCACTTAACATATTGCTACTGACCATATTTTGAAATCGAAAAAGAGTTACCTTGTTAGTTCGCAGTTAGCTTGCATTTTCGCTAAATATGGGTGTTTACTTGATGAAATCCAAAGTTCCAGGTTGATTGCCTTCAAAAATACTGTACACAAGTTTAGTCAAACTTTCTCTCCATCTCGATTTCGGATTGTGATGAATATGAAACGTTAAATTGTGATTTTTTCATTTTCGTCCACCAAACCTTGAAAAGAAACCACGATCACCATCATAAAATCGTCTATTAAGATTCGGAAATATGAATCTACCACATAATGTTTCACCAAATCCACGTCTGTAAGTGCAATTAAAATTACCTCAACAATTACTACTACAAACCCCGAACGTAACCGAATGTAAATGTTGATTCAGTTGTGAAGGATTAAGATTTTGTACCTCCAAACTTCAAACCCTGTTTCCCTGTCTTACCGTACATTTCTTGTAAGTTTAGTGTCTCCCGCTATTTGGATTTGGTAAAAGTTAACAGGCTTCGTCTGCGTATATTTATATTAGTTATCAGTTTACCTAATTTCCTGTATCTCTCCACATAGGCTTGAAACCGAAATAATATCACTTCTTAAACTGAAGACAACGCGAATATTTCATTTATAGGTCAGTCCAAAACTTTGATGATTAAAGTACGGACAACTTGTCTCAATGTGTTAATCAACACTTCAACTATTGGAACGAGTTGTATTATTTGGGTCAATTTTGTATGATATAGTCTCAGGGATCGTCAACATGAAAAACTCGTCGCGTATAATTACTTGGTGTGTTGTCTTATACCTCCATTGACGAATAATCTTACATTTCGATTTCCTTACGTGAATCATCACAAACTTGTTGGACTCCCTCTAATATCGTCTTCAGATTTGTCCTTTCTCATACGATTGTACATACTGTTGGATGTTCGTTTACTCCATACCACAAGTTATTAGCTGACCACACGTTTTCCTCAACTATCAGAACGTCTGGCAGAACAAAAAGCTCTTAAACTTTTACTACTGAAATGTCATTTACTTTAAAAACTCCTTTATTAGGACTATATAAAAAACTATCATGACAGAACAGTCGCGAATAACCGTAGTACATCGAACCGAATATAAAGATTTCGACTTTTACTATCTAATCCACTGACTTTTTTCCATAACCTATGGCCTCTAAATTCGGTATCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  a~lTShT2xea`TU`RQ@ejRWnRU$|}}}}}}}}}}}}}}}}}}}}}{qjkmSL>nVy:zRjogSUiUZ~oN~~ng_I]tfL{iSkiVK}khSSlDT`Sif>IMp~kUkd+^>AQz~kg2~rStNxSUi3xTnSUp=ccjG~oG|kUMq{RPBMXYtNY~qhll?iEiDnS7{Rg\{UvYpE~OBb=WUU>G/WHF&d`IG['^)D1,O;J$U6>>FZ\0h)MSYa]0IWQ>sN,MenTjT1uPPXJQ\&p{dbS9iP>Dznfj7zVioViR&CR?]`@kSM?lhVoe@MiV}5yS>PWOyUlV]xTnV>||WUk:~~}kM~~zF{U@}xa,kg_~IonBcB>v{TO{UfPTob*cYwQ>Z=SVg^|VhkE~iQVF}oVk*)poQeM{U`.}lc;hM}gl\fTT[zD_>WwS6qUlkgf[6LVQ>{}TTOjiF>F]RReVn=||McSQ/mg\yTw6||D~kSkhV\}T\~fEaLC_PSQ?ihP~n;~t[~Tcoa`eUnSdTfohogB~pP=fe=jUQQSVQ\y&vU]AQCzSlSnjBnhZ~cPhzQ,Eb3Wg[]?iSmln=~~v~wUoX~loVCdCwgoVlkPhNw^a;kDqTPhcA~cCW;RjCLCM^ohVoh9|ilUmX~khCr}_JQYa@J0daSN<in{l_BcfK\LO_mAMmS>juhLrP+J1h)R8_nlgJ3'|r|wS6ejhoURr^MkwSJ_hG~hd@@{~{UhmBidVepU~Nt`O~~2dgnWieW~O~W~D~^Q=<ab;h7~joSHsUSxYTCt{gkfJyUb&QlaPwS<|~~}kSna83DD\:H%;Di9vZQ_RlmAVy\^fTc^h[~M}gSZ~WYtBu]^T~j6~lQcL{P6Ivi6wT=U=R3l^PW.efxT?~G|~~oWfaWUhUO}NMBTdXU^SAlSCfOe5uQF?0p}sS+vycRS7~x`bkfT^~d8>8yk_~fW;UUlVhjI|^^TO}h?c&miv=Q?i@yu`hn>||nkT~}SU_~eZokJ~}P5{HnO9^|7{eCzX^?LZeR:~Z|U6t}}}j\Volk'6765DjHv\WOnU@~[?DjlSPRNEuM_IQH`CS|~UL~h`~SoiReSF|mORS@}qTTRu*fURqjliR5_hu~T@RFy~sWlm*TM2P1]K:lXfj/~~sh>fhDFPSkaSPRFoSj,Pj3hyzQSkmBlS[^V~SKZpUIt6{YO\`TW~oVm?FogTTmX~j^Cyq>&AjJUWkF~hUg[UnlnIdGhTVUzZz-{s{]whG|URQ]RRj^}UUlO/iMM1vE5uj{k0OEknG|H}VWidll4fgng[zi=9{Tce^z=ljG|Y~gL|F|iR9s]^gjdD~eD~CWGP^xQDaZ:rimTP~b3~~kiE@[_=9~bAPVeDxgA]{TnX~k@~~hTnkjWn>u~iAjiMd[E\eT}}HxX$rrgh(zKzVT%xRJ|SknVoXTg__ofM~}d_OZxQRLg[Y'da4bba<~c:_Hdn@_]acIaN`L`;]ZNCC(=mI>K19YR@l[)fm\@oZSWMZMSkOTp8kR8b`?o`^NPqM^9FLbb\H]nL^Mpp^d^RqdN^adAh5OWjNCpd^^e]YVp7sn]REKMZYNIZMK2\ZKb9Al*7S@FnAjcNJc;\6FMD>]HL\RoLS*<MIHO?N*5XDjI+H<4MdcN<O6ljM3TGd`Y]Z\I_GJb=A65cHcO]P%9<:[da5V58J:aKJbLGM`_X_F@JYD<DQ=lb`bHBo`dNUpD]W/]K2t[RYa^OaOqcAhZ:Tk[O\>poOaX;eJ2qRdKN^e_?obNKcHEME^kJSQaVpRuZLa-gh`;_MfbMXNaa9<mK[JXKlpJa/uET6Nd@7\DJ_^@ePQ48G>G7HZPnRo^d_1M6GLppIL_>Z([JAbIM?l`Vp^UpI`NdI\?u]MIM`;qpb@tdNMqH^\L:X^GdIXb:bRqO[`@nN2dopp^6JL?R<pmM<opV49b^NdaDrrdadMIMppZ%Ijl3pphF3?>V'T`H=c]>rVO]JX5K%XN9?JKFYbMGXI]N^`?lLG\RH5LM'd:7`$XWG1NE')=)7P;?)YW<JSP\A`m`X;daLHE91bl[J?P3^O_L\`AdYKda]J&nool64i]dK]5s`4Z=N>ddJ_&m[QpNRsbFE%9MnZYN6D)OO:KQoSVbZ/rDN^JNdr
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2903/ccs/rev np:i:6 rq:f:0.99194
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTACTGGTTCGTACAGCGGTAAATGACTTGTTGAGTCTTGACGTCGACGACCAAAGCGACCACTTTGACCCAATTGCGAACTACTAAATCCTAAGCAAAGGACTATTAGGTAGTAGCCAACTTCGTTAATTCCGTTCAGTACTTTTAAATTCTAACCGACCATCTTTTCCGAGTTGCTTCAAACCCTCGTCCTAATGATTTACATCGAATAGAACGTCGTACAAACGCACTACTACATGGAATAGATTCTCTTGTCAAATCGTTTTGTTTTGGCTTTACCCTTGGTAACAAACTTCGACTACGTTCGTACAATTCAGAATAACCTCTACCTCGTTAATTTGAGTTAGTTCGTTAAGGGCTTAAGTAGTTATTTTCTATGATAAGCACTAAATTGACCTTAATTTCCTCGACTTATTGTTACATCTCGATTTCCCTTGATATACTCAGATATATTTCAGTATCTACTATTAATATCAAGTATGCTAGGATTTGCAACCGTTCGATGTAAAAAACTAAGTCCAAGGATCGTCATTTACCCAATATACCGCCCTATAACAATACTACCATGTAATGTTTGCATGCTCTATCTTTTGATTATTCTTTCTTCTTTATTACCCTCTCTTGATTTTTACCTATCAATAAACTTACCATCTTTTCATCTACATAATTTGGGAAATCTGAATTAACCTCACCCAGCCGTATTCAATCTTTATGTTCATCTATTCTTTTTGATGACCTTATACAAGTTTCTCGTCAATTACAGAGGTTGCGGTGGTTTATTGCCTCATTCATTGAACAAATCCCCACCCCTCCAAAATGGATCACTTAACATATTGCTACTGACCATATTTTGAAATCGAAAAAGAGTTACCTTGTTAGTTCGCAGTTAGCTTGCATTTTCGCTAAATATGGCGTGTTACTTCGATGAAATCCAAAGTTCCAGGTTGATTGCCTTCAAAAATACTGTAACAAAGTTTAGTCAAACTTTCTCTCCATCTCGATTTCGGATTGTGATGAATATGAAACGTTAAATTGTGATTTTTTCATTTTCGTTCCACCAAACCTGTGAAAAGAAACCACGATCACCATCATAAAATCGTCTATTAAGATTCGGAAATATGAATCTACCACATAATGTTTCACCAAATCCACGTCTGTAAGTGCAATTAAAATTACCTCAACAATTACTACTACAAACCCCGAACGTAACCGAATGTAAATGTTGATTCAGTTGTGAAGGATTAAGATTTTGTACCTCCAAACTTCAAACCCTGTTTCCCTGTCTTACCGTACATTTCTTGTAAGTTTAGTGTCTCCCGCTATTTGGATTTGGTAAAGTTAACAGGCTTTCGTCTGCGTATATTGTATATTAGTTATAGTTTACCTATTTCCTGTATCTCTCCACATAGGCTTGAAACCGAAAATAATATCACTTCTTAAACTGAAGACAACGCGAATATTTCATTTATAGGTCAGTCCAAAACTTTGATGATTAAAGTACGGACAACTTGTCTCAATGTGTTAATCAACACTTCAACTATTGGAACGAGTTTATTATTTGGGGTCAATTTTGTATGATATAGTCTCAGGGATCGTCAACATGAAAACTCGTCGCGTATAATTACTTGGTGTGTTGTCTGTATACCTCCATTGACGAATAATCTTACATTTCGATTTCCTTACGTGAATCATCACAAACTTGTTGGACTCCCTCTAATATCGTCTTCAGATTTGTCCTTTCTCATACGATTGTACATACTGTTGGATGTTCGTTTACTCCATACCACAAGTTATTAGCTGACCACACGTTTTCCTCAACTATCAGAACGTCTGGCAGAACAAAAAGCTCTTAAACTTTTACTACTGAAATGTCATTTACTTTAAAAACTCCTTTTATTAGGACTATATAAAAAACGTATCATGACAGAACAGTCGCGAATAACGTAGACATCGAACCGAATATAAAGATTTCGACTTTTACTATCTAATCCACTGACTTTTTCCATAACCTATGGCCTCTAAATTCGGGTATCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  1[UloCP1PcU:Q\yQTkmVVTSjj%||{whSJOXZY_b`XPKMVdqrja[UOQiqneI>cU}lDRTjoUP?haCu]gVn`9GCOvQOShl/_VojTTiAWjWnIpG~qAjSgIlnkB~{RTI`v\tR`Oh+YZjNPi`Agg`XpgM}Uj8sp'V^Y\TF_nD~dkWhkRZ~`~R8sgQ+]L]7zV~QClOPOQmk:uV_BtvE^PdHo0`WoZ~k^k$wlRD^BOUQrUlW~SC~pK{macA_W~_[MQUWNSg`RcEPNTd5BNVpaNI`N^bJIp_D7Q(H@O_VD^_J?xTm]cMXJra\INlM4^:r]I`M7bojM@kraBu`0n_RIim9]0g^Ur`1YeN+7N(IKIc`;+R]N[^`VpLsadNQd_TpRq^_XEB\5NL.kUpFrnNdNMq^NLqaNM[Rf7jcI9iUnO]`D8.J-`Sc^HaHHE[MdN]Xa\;3d&9;KPn)h=Q7noMn3TLLZKhaLqGHi`^DYa^aO`DYkHqqK^<`WL\da^ac>=$%KK4pZIMLJb]a_aa_`ApR[XNZaPQGWRFJESJ>v^,:?K_RkMX=9T^La$:5-VSfpp_VJlLZ(C?k@oKG_M6_d7q\U,pD<g%SDaQfK$T&/_YRm4Tb/2\Ia>nb^N^Vp^N6p]KJS\MI[_]cI_6VX]KZDo^GQQ(UU`PqaGqqc:hP>ncM^[]::)`*maTSGKm]cHJBm\.VVHJsbPucF05jig__H]FI_cIUo;US,rj=mp\6[N<i5jAiQp\EN>msdNQqNZ^PqaVrZ`Gqqd[JKS]5YMOZ,k^02GdeMdDOdPnKXa[aX7k9,PTTOPN^aSp8^ZH\NdAp<`H0,[E<_DheD=M$%[>IL:gXF7aLCY];RSUBnjXV?]^n^Qq7PenG/X3[abJMqSqZ[WQAnMa^c]7LZFn`R`4YV]LJfnYH8<iZkfO\)9KdRqMlN?ocM1eO:_^*7=PMF6T0]c6gSF\9IHBopOGG*]3AJE5l_R+k%NcY>LopIRqFO]<?\Qfc>=+l:`,kK>m;m_<qcQ]EP`H=DMn`KiiN(m76GWM>oo\BJg[C^HQfcJ^WMJ^7jhP1jP8RI4&G[MVnZ^^OEp^N9GLEpaCjJH>_&mnnnb`c5ql[JL'7=jbQq<ZZBjU)/>@_5M8?^d:iOFLd^acArbZR^75fq[H`MI`OdPqVnKH<cXAm:TTVIYJSd^\Q`L\`^_5Ac[7$c\ZKJhGgaQG^UG=G5F3?2gK^MaVpMS@pVI%^`Nq^`>P1Bo?XT_3a`GJ^.pc2omZ75ST9H=N)FLAo\MF5WfZM;j8J-ETa<K^L^KEj?bM:ZCoM^*jVGLAF9;E=f5jF42W`@pn:ppZ99RVDPfKNIQMrdQoM[F.`9rVK?P:IUpNGqqdN^N^\_IrpNa^b;\I2rK+gI@]H2lI;HgMYJb?x`)ne`N\IZ']L-C2S<]>9_[\:^dN<n]]dM,_URNiP^EgpRq_MIbXY]a]>nbad^d?]G>YMFp_Kk;4`oYH3WJS3^daPq`<PFnq`\MEVL6^Vp`KYMJ_@BCSgIb9oocMc2f\aeN^Qp,lTVH+_`F^KM\8UJhN6Gca?xb84Y[@`9I_W3TpYNHMNh0SEHTpJ^RMSaVp`Ib8R=f@T\OdNEqrdLUa<UO(Z_HF_@Z=fbnNZ^^NcHDWN<HXGHa*I_WH`N\IUpacIL7oooJ\^)N8KIJARIAnApc`Ge?pCI98F[<FG9'9.I_(^^Rq`LkML^L?U?OQZKKSGIaESgaNLBd`?Y?ocaFUKSQ^`^/[I2H]hG=TMKdAtL_]9qS7VB1c_^W`MID:g__GaDWPM[>l5^aPVacIcaL8@VMZEP\ZPC]NOh2t_^NLn^')Tkb_XPod^c?tbaVpLILL7lcLJT>b>n_JZR6@XjoQqDPVpa\L\adNVpaOZB8?U7_H>O^,oppkLJ[I=C*j_J:H3f`RYW@[MHebIM]adGqqdaGqq9qqrpa^Po;USXdPqZ'eZ_HTI_[%gRF55\4V4^ad\9[OQMChPb7QV9[7,l@Ci`N\^,(Zd^_:EnQqM@o]`JF\XNdGqqaNd`5?eqca^d[GZFq]?t`R[MMY0YF<MQq]ZBX=mN`XAW8R9<I>ooKpY&f232FCqrpNI_R^\XL\M-`9YIbOuaSE4RON
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2944/ccs/fwd np:i:8 rq:f:0.995619
  AAGCAGTGGTATCAACGCAGAGTACGGGGTTGGTGTATTTATCCGCTACGTGGTGGATGAACATGGATGCGAACGACATTTCGAAATATACGCAATGATATCCCAACCCTACCGAAACAGCAATAATTGTAGAAGGTAGCATATCATGCCCGAGAGTTTACTACGTTGTAGCGAGTTTAGTTGAAATAGTTTGTGATGTGTAAACTAAAACATACCAAATGGTAAAACTTGTCACCCCATTTACATTGCGACAGACACAGTTATGGAGTGGATGGAAGTGTGTTCGACTGTCAAGACCCTTCTATAATAGTCGAACCAGTACGGTAAGTGGGCAACATGCCCATAATAAGTCGAAGCATTTCAAATGGTTCATCCAGTAGACGACGATGTCTAGACAGTCATGTCTCTTCCCCATTTGAAGTCATGTAGTGGTTGTCTACTTTTTCATTGAAGACGTCCCACCTCAACGCTATGAACGTTAGTTGAGACAATGTTAAAGCAAACGACAACGTCATTGTGATCTACATACACAGTGGATGGTTAGCGTAAACATGGTGGAACGTACTTTGACTGCGCTGCAAGAAATGGTTGGGTCGATCGTAATGCTAGTCGTTACATCGGAACAAGCCAAAACAAATCATTCGCTGGATTTAGACCTACTGCACGACGACGTCGACCACAAGACATTCTTGAAAGCGCTAGTCCATGAAAATGTCCTAGCTTTGAACGTTTATCAAATGCAAGTTGTGGGAGTTAGTCATGTGAGAGTTGTGCAAGAAAGTGTTAACGTTCTAGCCGTGCTCAGTAACAATTACCATTCGGCGGTAACAAACGTAAGTTGTCACTGCACTCATGAGCATGAAGTTAGACCAGTAGTTGGGTCAGAAATTAGACGTGGTTTAGTCTGGTTACCGTGGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAGATAAACAAAGAAGAAACGGTTAATACGATTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTTCAACTAGAATCTACGTTTCATACGCGGATTCCACATCCGTTCTTGCAATTAAAGAAACGATGTAGAAAACGCTTTGGTTGGCGACAACTTGGGCGGCAAAAATAATTATGGTAGGTAATTGAAGTAGCGTTAAAACGCAAAAAGAAGGAAGCACGGATCACTGCAAAAAGGACTACTCAATAATGGTTTCTAAAGTCATTATGCTGGTGCTCCCTATGGCGGTGGTCAGTACTGTAACTAAAAGATGGATTACGGCACTTGTAGAGCACGTATCAGACCCAGCTTTGAAAGAAGGCTGAGTTCGGTTCGGGTTTCACGTAGGCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGGTTACCATGTAAGAAGCGGTAGACGCATGGCCTAGTAGGAAGAATGCTTGTTCACGGAGCCGACGAAGTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGAATGCGTACTACGGTCGTCCAAGTTGCAAGAGGTATTAGAGTCATTCGAATAGCTGTGGGAGTGGTATTTATAGCATAATAAGTGTAAAAAACATTCCCAACAGCATATGTGTAGCCAAGAAGCGTTGTGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGATAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGCGTGCTGGTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAGAATGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGTCGAACGTCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCATGATTTGGTCGATGCGGCAATGTTGCTTAGGACTATTCTATGGCTTGCGTAATTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGTAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  dpZCn[[Z~qH[@.tOWBaj_mZZLAm~~d~K~viX_E~~^p2~ZCb]QkrJ~tN~svn`}R\_Z~an1Pa@|Tj%I4Td~VmEgguswm@mDQg\jL[bt,vTNn7m~[W*ZYQ~aTtYT_{`FvV~mvpXO{L~ttlPYG_sUS\Z$s\eiijm9~~vNj=EMWcenj`B_gKFwwleXubAuumhWDpuPfSXjRfdgGU`=f.[f5,gjR+|@kumRqlIwvuOWuPWLV'qs~i@nY/Lg;A9LbBNheiJEJjP4_hjGpDWjQuW[DeG^AVCfSMuPadLjdYLKtfg8ugKmMjijJugVTe;SUk;WlfYXI=8hKvdlGwvMHqNdic,rjfW(hg<^QjNeYveNf@ltM0qrk@s6WKZS9~^PWDF3JaiNeeTM='bdcjNkeSJQUd`KeI0>/e\fj6uvdYvgmK1ifmk`=Qu,VShNmgL*tvsVNWZu^QqekQgi%~ZX6VUBGj:aLjEDe+QKeLmje^wcfYU8U]`aZw;gUC:<W\MekNYnOekPUSTKWcEbJc[>SSMMjMURjCS=TN_GX\U:bfBjcJGcDsiBoNPHSdkM@muMhNkO;dMmb*HpeNm[hRx[jEuulNdSBLel;n]aNj?[eMbXtGLCQ:EsIsNQ[d;~Erw`<N`\ZOiWm;bHkRuPNkl__U<Zhc:j:GBMekNdWQc?<dj(k]JFpQC:V]nL9sc-]GKNbKTUek<vild,rp`Zfk<smebO=uweYvASQvvlgN;k]XQMKtE<vdTIcvhQ;tT]T:CiPkejdk_JvXc[BIXP0iqa[d<uGeJYWiLRD/9p_Vd<f:gb[LlNYpZsA(gSIjK>bKNXg;T<<N]OenYvdOxelMVNkeKBMnKmlekd=fifZx^@qHcT@~kekUO%[DsulNleAun]wZXYBSHC[=Y]T[DIMFN(N6/\dkDdBdqN7cgbMLjfYtJAKKuvbUxc:WMhI2_ULXhBvmN:WZbBMaMsuOTvItJuQ`IK]NqdBETZd6ttkQHmHHrS>q5lFCT;(hM[j]wMsNP@wgIPTMeKNWjj=iYMcOnsMgUWMeL2oh[u=mXNji:~eXs=Vt:8QdIt:tkd<s`HbgZdk^D8ttmNeOPuuTxLvQKKbWBM[KEX8c[KEjL(oqofhQ^GtkbR{hBPn[Py[ucJ^TYi8'_=K9tdB6dM2snuiOUvOsX`c?W?CmB\M[HS^,9`uwU=iT<kiMgNZvVXvnUxOur<lBquc\MfZhPYfMlRukQMg0n~iknPsN=oYTuV9UegRNh:UJSAk$hjcdcUSpk]wXPRuMmK\tb[jeiPIgPfWEiL@_d/~qgfO)vURIwwfUtAqNhUjdNd>Tf[uO6wL4iQ?D@cVh=p(XhdMrOZ\KthTUgaHtLL?CLhXvO-pZPf5YYEhH^S5]CjdUJvbSreJSuljgjNb*USOlAllmejBQxVvd6mXbMZpbYuOkNEs@O<~OVJbSnM:tjdkLOVbfPe9dfXqNIFeI^N+S4qXJ:IrDvkkNkKDtj=Vc6mXc;aZWMfE>QkU;dl2~9nbItQMKtcjHwll\wVcUa[MmYp<c8qYUdIVefAXfTeZF~mW;vlTfUPMSg[wk7rLOOj5vugWQ<h@f(hG2[>YUMTYUiJ;VgcK<~;ndXv_LNQ7PfPLWMeLOCMlGuvvUlKbAhR^M6RYLIGqNXYuKP(~~e^ZdghWd=rNVf4Bmd[lO8oqjHtflkkDvMnvWeKfHsM?mdMa>AKC5__Lc?HteNcfeMdNcdRjiLKnPcekSOLon@{PXQkRtMYk;QLkNmJIhhjd=Seb@ReeNkZtIi?p;cMlLOP`L??E.ViWke^tNWUo9seXwlQuM?gYsLcHblLhVlebFVjJGOXJuXLVInZgkeljgkUiAUj>cImNgj&~bBVVjjcSKONgBj@ejOtNkTpFJuvcJjE`VAidN6sg^<rklek=xqV{lNaSS_KM<7(gVTIsdK[uhJyjOIjOsOYSh%j-Igc<ckEiZqOlb>`dVDvvf7ifbFlRRKlYvQukcSM`h2tk%tsk_XUVZ\_flf^UPTYWWYTRVblgbijCj?leNfMvejkWA|iNmeOZq
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2944/ccs/rev np:i:8 rq:f:0.995812
  AAGCAGTGGTATCAACGCAGAGTACGGGGTTGGTGTATTTATCCGCTACGTGGGTGGATGAACATGGATGCGAACGACATTTCGAAATATACGCAATGATATCCAACCCTACCGAAACAGCAATAATTGTAGAAGGTAGCATATCATGCCGAGAGTTTACTACGTTGTAGCGAGTTTAGTTGAAATAGTTTGTGATGTGTAAACTAAAACATACCAAATGGGTAAACTTGTCACCCCCATTTACATTGCGACAGACACAGTTATGGAGTGGATGGAAGTGTGTTCGACTGTCAAGACCCTTCTATAATAGTCGAACCAGTACGGTAAGTGGGCAACATGCCCATATAAGTCGAAGCATTTCAAATGGTTCATCCAGTAGACGACGATGTCCTAGACAGTCATGTCTCTTCCCATTTGAAGTCATGTAGTGGTTGTCTACTTTTTCATTGAAGACGTCCACCTCAACGCTATGAACGTTAGTTGAGACAATGTTAAAGCAAACGACAACGTCATTGTGATCTACATACACAGTGGATGGTTAGCGTAAACATGGTGGAACGTACTTTGACTGCGCTGCAAGAAATGGTTGGGTCGATCGTAATGCTAGTCGTTACATCGGAACAAGCCAAAACAAATCATTCGCTGGATTTAGACCTACTGCACGACGACGTCGACACAAGACATTCTTGAAAGCGCTAGTCCATGAAAATGTCCTAGCTTTGAACGTTTATCAAATGCAAGTTGTGGGAGTTAGTCATGTGAGAGTTGTGCAAGAAAGTGTTAACGTTCTAGCCGTGCTCAGTAACAATTACCATTCGGCCGGTAACAAACGTAAGTTGTCACTGCACTCATGAGCATGAAGTTAGACCAGTAGTTGGGTCAGAAATTAGACGTGGTTTAGTCTGGTTACCGTGGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAGATAAACAAAGAAGAAACGGTTAATACGATTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTTCAACTAGAATCTACGTTTCATACGCGGATTCCACATCCGTTCTTGCAATTAAAGAAACGATGTAGAAAACGCTTTGGTTGGCGACAACTTGGGCGGCAAAATAATTATGGTAGGTAATTGATAGTAGCGTTAAAACGCAAAAAGAAGGAAGCACGGATCACTGCAAAAAGGACTACTCAATAATGGTTTCTAAAGTCATTATGCTGGTGCTCCCTATGGCGGTGGTCAGTACTGTAACTAAAGATGGATTACGGCACTTGTAGAGCACGTATCAGACCCAGCTTTGAAAGAAGGCTGAGTTCGGTTCGGGTTTCACGTAGGCCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGGTTACCATGTAAGAAGCGGTAGACGCCATGGCCTAGTAGGAAGAATGCTTGTTCACGAGCCGACGAAGTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGAATGCGTACTACGGTCGTCCAAGTTGCAAGAGTATTAGAGTCATTCGAATAGCTGTGGGAGTGGTATTTATAGCATAATAAGTGTAAAAAACATTCCCAACAGCATATGTGTAGCCAAGAAGCGTTGTGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGATAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGCGTGCTGGTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAGAATGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCATGATTTGGTCGATGCGGCAAATGTTGCTTAGGACTATTCTATGGTCTTGCGTAATTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCAGCTT
  +
  Ii>@%/5(dZ`snRvYKdnBBDtlk0tjXKR=U>;[sDygsM\pSmk^kNV%B5:9G&qUb~YvsB~upL\C`~mAsmsQ}~oVS~~_TkkTRU[FQ?kN]o5|Q~J~~^Y3sNF~gE]PE]~uMhKeIULNVr;uq6?0n_c_mxtSI|@pTlNEr~ul\MUNDwN\uRnPp0DQstSAzQF~~HYQ@h?:?;dMFHMbD~rUc8N\T\\Ob6zI~~`%q9;*}~l_wQ]jwA~~~~uGy\hLl>uLRM_hY?^DYILQ]xH[8wh:p&~qrE~`t@[=\NOnbApjYTZlDe7cIscJt_\ss_~tvOXlT`|Y~vUtwW?|9Nv=S6~~nS~lesSN~~qut`a}CrlRbhCXuD~yX;ydn<~^wXiPS~p>XeStjE]>NGEQoL~jh1JlqKqikaUmFbXAJ'S}sH~~Sd~VqXqlA]_FrDw^_/Lndum=jdy~m`<X-^v>bWA^Yql>Wgae~kQH,E&KQj_O6m`Q@lTuSjlMvsSP~Sy~TnW~~mTskc~U@jWtRfTdTuans_Y`ssV`Y_NcA~^`D~VntQjSKP~mLTo6gAE~SkbTtskHw_Inm`CmSWY<j=wQ6NE`7~[m9pd`lBaTf2nRsq/RYmPL^CK]^ltrj7q/VU=vRZ~9~~~lF~v]k`_~mAltD~u5tb_QnG}`u[`TmwmUvm?odKdSHgWij?eN_nuP~kMxRH|yBWQj^tS`X~wsF.pslcSoM|[rSkEZuTbylVF|yqtoM~~sTl_yT^}S`9~~uU0|uVtl]PB[3b?iEZjRbOC[i@B_4ET%XlP{jQ\~nowR:B:WQkpU]Cs`~Y`~P}v[~s8R:2Q5+&:CJ\kJz}mEM`tU]sUq]wYIAUn\JI[]RJQotuST~RVeuSuL~vRM]B^h)~yllZ>An~UslT^cNV<bO_gvR0_\-eDi_WyS_'|MmtU`{puQifQQcj_mR~pDarSC[KV[>zyR`hH}ymJsjSUxU@z~g;`Nxc~LqmVtH[Nq:~rQ8~~rv`}WQdmY|SzT-cX`ilOMOR_~nW9}wlL_TXpPb~sosclB)mdj`rumRbG~xb~]~vntj7zAY~n^zRE_nao&~UUW~~mEtuTs[NAv~~iQlGef?~Sa6qY?IK=fNR_/^if4vV6toeIIg27:\(u^^9~qE^?bRD)CMYsSXRR~;~~vVSW&~~}VUSk?~b~TnuX4~I]fvmLBi>jyzmB~uosIj`l@~o^uID~Ov~nZI~wTsor+n1mTntB~_AGbEzh\o`C~k>cO8~b]\QZZkgIPWykl9ar=nnAo[EzoU<mfeVRgTQsUtTmtWRovtnr.qQ~~vDV7~SAQbsSay?~ouPpSS~l*RM|l2~aCw~Hu]Qqt?]=M7JN:zlSr%[_XAhG\r?l4yI{Kdl<}fGH8\W8?,]bBdniKZ[n>LfMOAtZo=hkU\~bo9hRvhbIsh/jYmS^[rQk]YBOzmvm-EQJ{DtnU`~Vb~sR^gEfFq7}ouQPl1HgsQ\RWs\|s5l_|@~uqetoF~rVqU_y\=B=[tntdmFs_mUsH~avUXqOUNsFJ-YsR~uTvVpS[^|YTUmg`SnpT_:rt^SZ?jcg6kRLDL@nusN~WQnQZ>Y,~~zj`YkM|M}~V~nqBkYaIiQoSM\O]~a}V]zUn?HWQ>>j]WSlTvnuAdw~SrkK>~puR@kAWbBR\L<`I{M~uWS_2A9[RQyY^`l?ngNKjSw~pGt@qop5aBg|wSotBetnuUnUr^XhYyPXTsBvRa9O;mo)yZ=iLkN|^bOI>YI~nG~WcSq@~j`mnTm_Z_mN~geN^qV`lCwRmtS~]}VrF[i]_nP~kpc}nD9iqSO~Xt@~PtU[xs2~jbdJ~j9eOIlq:WD:R{I=THGVw[kRJVk@pN`uTlHS>G.SH_wdSKEcuNWLsssAZnrUtEXZT]Lz[u/~UI{eQL`B~xTsAlH~~Q[~tiDr6{[;wpXMxsRo@~`H_wVLPSE`Jb`(lslYm^}hDX>2NBTMJ/XPoa~ObTmSV~:`EztTW~^RE]^lYpSnF~iDaSLo@yf%gfs|~~~zqifhjp{~~~~~~|zz|zzXQKoUbmOEmTDt?ounKgX+U3G
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2951/ccs/fwd np:i:5 rq:f:0.995232
  AAGCAGTGGTATCAAACGCAGAGTACGGGGCATACTGCAAGACTTGTAGGCCCATGAATTACCCGCTTAGGCAATGGGTAGACCTTTCCTTGCCGCGTGGAACAAACCGCCATGAGTGTTTTACGTTTACGGTCGGCGACCGGAGTCACAGCGCGACCAACGGGGCCAGGCAAAGGCCCATAGGCTTTTCCATCGGCACGCGACCGATTCCATCAAGTGTTAGGTGCAATCCCCATTCGGGACGGACACGCGAGAGCGTTAGTCGGCGCGTGCGCGGGACTATTTAGCGAAGGTCGCCGATCGTTTGCCCGTAAAACTAACTGGCAAAAGCCTAAGTGCTGTTTCGGGTGCAATGGTATAACTTCCCACATTTAGCCGAATAGCGCCAACAGCGTTATTATTTGGAACCAAGCAGTGGGCGATGTCAGCGACAATTCCACTTTGGTAGAGGTCGTTCTTTTGTAGAAAACAATCTAACATAACTATGACACTTTCGGTAAATTCACCACCTTTACCAGGGTCGTAAGTGGTCAAGCCACGCCGACCACTTCATAAGCATTGGTGGAAATCGCATCGACACAATAAAAGTACACCAACCAGCAGAAACAGGTACATATACAGTTTAACGACCTGGATCTAAGATGACTACAGTAGCATAGCCATAGAACATGGCACTGAAATATCGATGGGCGTAAAAGTGAACAACGCAGACGATGGATTACGACGCCAAGCCACTATAAAATGCTAATTGAGTCGAAGAAGGTACTCCTTTTTGGAACACAGATATTGCAGAAGCGGGAATGAGGTTGATATTACATCAAGTATCAACAGACGACCTCAGAAGGGTGGTCTTTTAAAAATGACAACGTACATTAAGATGCAGACAAACACTACTATGCTGGATGTGAAAATGTCATATGTGCGGCAAAAATAGACGACATTTAAGAACCTAGCATTATAGGATGGAGTGTTGTATTAATTCACTCTAGAGTAATGGATCACGGTGCCAGAAACTAAGGTGGTGTAGGACTAGATGCAAGTAACAACGGTCGTACTAAAAATCAGCTACGCGATCGCCGACTTAGAAGGCTGAGATGGAGAAACTTGTCTACTGGCAGACCTCACTATCTTTTAGGAAGGTCACGAAGCGGCTGGAGTGATGGCTAGTCCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAAACTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACAACTATATCAAATCGTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCCCGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTTCTCTACATGTCCTGGGTGGAGGGGAGTTTCCTTGTATGGGTGGAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGGCGGTCATATGTGGGTATGACGGGTATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGACATCTCTAGGTCACCTAAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGGTGGTAGGTTACATCTATTTACTTCAAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCCGAACATGAACGATGGATAGTAGACCGGGAAAGACCAACGTTTTTTCACTACTCCGAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ^~b^g^e;}KfkG${]^c]Q`RanfI=w~v]QkR^ncWEeTU\K~blQQtD~khncX~]~9C~kaX;NMM~]C|H;k~iK]f>~7rcO~_~bCnNKSkCl0gD:fe1?6<~gk^Qbnc@~~h9\cU~~h_S~n_OpK_f/G>bfcn]R^haFJ]cd-H,=?<~~hN~PB~]A~wS~F~~hlQR~H?~~Z:gPl_T~\O]aFHN/~bhZiLgQl^HxbVc]~QS~nc_Uji3~~~eJ~F5zcc_T~fHfZ5\chchc[FY~g^b2R~^c\Lkc^]EH~{;]mgE~w=K]bE~?~l`cO~^_PFaF~\54xcHj,~ye^lG~^l@~];~~~a>~lK~ckJBL`D~~^J~~kLX@`lT~lQl8l]Ty7~yg[;T~~hcNb35yQcL]cLjB_VK`FIJq:\~PD~|B~2YJID~M[hcmJ~~\Kfncn_hc\JM]E~J~?tg^F~~9xfhbKP~n_bK~]@t~kKjQa.~~~]GqXHU1z]gj%}]nhnbR^h]4fpGS~mC~~T~YaF\UH[H~lH6kH@ffUY`lH~`SS~n\4~`/wLA[9`_hP~h__~_hkPuc]KZ~S~mSz1~~l^aD7j]XN[e[Ezk3y~\Kkc[hP~X~MkhcV<W&}~]gT~neF]K9ic^gcG~~I~_bRO~mT~eU]b1c_<jaNPFMZddj;a]QjR`,~elRaA~ZgnQtFcCPF3~~lhm\bRlJ~~[cl1~~~bncX~^En2`\QbeHbhnS~fK~g_a:\cP~X~cP~h_lQk%x~mmB_nX~Y~chcn`cGlY*}P}nh_lOm:h|~lRz2{[F?N`Neg^~L]hcG~^HJ~T&~fJORf5~3dme7~f]OR\G~LghiZE~GfbR^chN~TZ;`4~K~~mR~QG?m~i$~~~lmcf]6p^clQ^Z]~X~bgiM\QaQV.{~^h_nd_kOlaHj?};jaPH.~~~jLjF=W=Vclc_<_H9~~~yd^OC]ch_`2~~W~a%}JviQbJ;]~hnd+}NlS~Q[Sa_~cnh_~X~PkHS5h]kQbhcnW~f9zhf^fHS~kLL};`1~~^i1cS~mQ|RNQMD|aYhR_;faBT~aST~_U~_O~b\IN7]m$~~~kmZ%5Ymh`c_`9j^cLV_h_]~;`F~S~YfbK]eS?gKI0}~\ImJj_nh_nR~XabP=~l_h_j9f[/~~]Q>`G~S~h.=]a4~_2Qv[T@iRckKQl<u_nhdl@vk\Q`:gNGj`OZ6q]G~gK~b]bZKeY<6T}fm>~n_PvjhnC~{\RQL]hb4~o0{L)TbnhnT~_bQk^W~hc_S~Qja&~QQ^gT~hnS~hbG~ceS^'Z>k~bYhcX~c_nhch_Jn_lPaaR^A~~n_c_~aPIi@~jH]~?~vICORY:[faQOaF<P~_hn\K^~>}hgLjS|7|QwLEd]Pb=~h[c_~T~fB~fchnfEPKX?~k:~zc^1~~i[UP9lyNIb_1~eQ~mN`M@~~SvF~~OxK~gIi~hT~kHaF~Y2pi1bm_U~~hn_lR^hgIiO~l9~~lcJmE~~wOla;dCQ_w^m\QO\Qlcl<~SJyyLO~OD~~c8`E~y@~^~aQOlK~{Q>~Gq3~lDl0~o`@~Q~ncf9~~lbQaI~:]T~kHR~ER~n_gkIaKjI~jkOOIc_J~~lQlbR^cjB_k0|~jQckHb_~aO/0{~~lJ~~QS~l@~K~cnP~^~R^kKe_Kk]RCFncncKzT~mT~hcX~_l@~]QQm'J8NFk^i8>~m`hM~SN~~_cnc\KE~]iJgK]cJei\~hJi'8~]`)bx\~I`TO~nc\ncA~~cnc_^~R^c_eT]Y~bSbgbgM:]~c]Q`;agb>~gR~T[1~~kOGdH~2Ta0r~wkHiLkedOg>lg_U~~T~lE~G`Hk^kBCS~lQR~Se]ODb_~hcncdkOQ8[a{|`%}9oYLa_bR^cU~[^~?~~J~`3~;`Qb]a\5~~fmJ~~mT~h%I`G|Q^hm\SQN^\c__~_;~~~^c_T~lMFy~lQ`Dk~d_T~a>YJ~b^E~~aQ0~~~X~bF~IE~S~lF~^(JLR<w~~cP~bG~\Qlb4oEbhnS~gla^i<Q8KiK}~${ILPNt5jY3-|~~~i]MWeR^j+fa%|^'{P@\U^lcX~J~~Ue[S~nckQS~V~_Q~cchcl>~>~kQ_f5PhgJdN~NQakHC~G\SOxkHfcl@~lcfHbnO~m_cnhcnhna]$~~~tjjheccfq}~~~~~~|qjhhms|~~~~iclS\OZmc_cY~ceQO)RP^nc_n~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2951/ccs/rev np:i:5 rq:f:0.994585
  AAGCAGTGGTATCAACGCAGAGTACGGGGCATACTGCAAGACTTGTAGGCCCATGAATTTACCCGCTTAGGCAATGGGTAGACCTTTCCTTGCCGCGTGGAACAAACCGCCATGAGTGTTTTACGTTTACGGTCGGCGACCGGAGTCACAGCGCGACCAACGGGGCCAGGCAAAGGCCCATAGGCTTTTCCATCGGCACGCGACCGATTCCATCAAGTGTTAGGTGCAATCCCCATTCGGGACGGACACGCGAGAGCGTTAGTCGGCGCGTGCGCGGGACTATTTTAGCGAAGGTCGCCGATCGTTTGCCCGTAAAACTAACTGGCAAAAGCCTAAGTGCTGTTTCGGGTGCAATGGTATAACTTCCCACATTTAGCCGAATAGCGCCAACAGCGTTATTATTTGGAACCAAGCAGTGGGCGATGTCAGCGACAATTCCACTTTGGTAGAGGTCGTTCTTTTGTAGAAAACAATCTAACATAACTATGACACTTTCGGTAAATTCACCACCTTTACCAGGGTCGTAAGTGGTCAAGCCACGCCGACCACTTCATAAGCAATTGGTGGAAATCGCATCGACACAATAAAAGTACACCAACCAGCAGAAAACAGGTACATATACAGTTTAACGACCTGGATCTAAGATGACTACAGTAGCATAGCCATAGAACATGGCACTGAAATATCGATGGGCGTAAAAGTGAACAACGCAGACGATGGATTACGACGCCAAGCCACTATAAATGCTAATTGAGTCGAAGAAGGTACTCCTTTTGGAACACAGATATTGCAGAAGCGGGAATGAGGTTGATATTACATCAAGTATCAACAGACGACCTCAGAAGGGTGGTCTTTTAAAATGACAACGTACATTAAGATGCAGACAAACACTACTATGCTGGATGTGAAAATGTTCATATGTGCGGCAAAAATAGACGACATTTAAGAACCTAGCATTATAGGATGGAGTGTTGTATTTAATTCACTCTAGAGTAATGGATCACGGTGCCAGAAACTAAGGTGGTGTAGGACTAGATGCAAGTAACAACGGTCGTACTAAAATCAGCTACGCGATCGCCGACTTAGAAGGCTGAGATGGAGAAACTTTGTCTACTGGCAGACCTCACTATCTTTTAGGAAGGTTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAAACTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACAACTATATCAAATCGTTGTGTGGTCTTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTTAGGGAGGTCGTTTCCCGGATCTTTATCTACATCTCCTGGGTGAAGGGATGATCTTTCTCTACATGTCCTGGGTGGAGGGGAGTTTCCTTGTATGGGTGGAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGGCGGTCATATGTGGGTTATGACGGGTATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGACATCTCTAGGTCACCTAAACGTGCGGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGGTGGTAGGTTACATCTATTTACTTCAAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCCGAACATGAACGATGGATAGTAGACCGGGAAGACCAACGTTTTTTTCACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ,A?V\TZ4hZ_FW1aXMPK8>61[W(ssQ@]F^SSS:HiT_@NtT\aEl$iNWESF_+qf`@wnTS=pF1cXLu\>wL0^UaKuGurKu*XTKuTXTH8rQc)+ok7pRKs_FS`TIS6qtr`V;8br`XGvZ@EbARaKuEhJS4WaX_>VTW>^HtUuX9wwfFraFuX<sc5D2pr[\aEYV,pq-%l]\XF_>_W>VTaGqC\=qHwa\XUuT\T@sXCu\UXLhF%jn_aOuX>wvaWCO^XaXTXO.L^P<J;n_U\XErSTW>YHI78<ZXaX\a'^]XZTXTFY9rYQ36kSa\XQ:siTAjWQUDuusVETtX[8`A+qrf<Jt\LpTFSX\TFuuX0vRDCXPpO@Y\a\QsQ>bCuu^W[8sE+J23*0Z\aUXTKs?q>DQARNuaNu_*nMGuUuHsSq;PaT[2s\ST_FS\VFQW>^XMV8T6o_W6qoEdUaTaEYYWQ=pX8uvhT\_>9ossXTtFW[CoRC+;nVE^ESaXaX7rk@Fu\LutOuXaKt]Fk;vr_7qZ1UYDURITuSC8hDWLqS8q_XS2]SaKuaV=rWa[?j*?%<DREpVEpJtW.T>UFYXU`VFUAr[DsurTI`XaJg-oJtaUX[T9sssXaFv\aWZ\[0^X_>:skTuWUaHw\FeEB?YL]PBW>^WC_XaTY[>Va\aTJsFY^>SsX^.)`TFUCR=ss[aXXQN[:wnKPS5sufSZ>RrW;tVUXaUaWSHX6r_OuaXUaXTJpAVQFuaXWR\LuuZ>V\Uu@jQWTFWT/XTArDYF_X\Kd)ppS7bAqV^CEQ_E^=qSXaTUuTX>wpUu\QWGv?kTaYWMuaXaZ??qS\a\WCsWaUaXU`JbWXaNKr?vpGFg\X5ssa9ssU-:^SKa<KSaX_;[:\O;WTVMTaX=ssW`VE_WE^EPS\Gu_VS1Q7gRi[T&ZQ_E^ES\TSBpA)rssa[aUaV;^X`,r]TuTTr3fZaUXaKpGV^5T[UB`-OGP7eT\a*qGArNtXaX\X\_>^SFTt[6r_\XaXEsUS8q_TLuuWGTtEt[D]EN@_DYGVZFQ_D<VUuTSCpWUtXGtFWU\aX\DuutXXaS@C]?;VTa\XTJn?^V;W`TTp6rUAQOTa\F^`TLuuX(oA@VX\aV/EtX](Y%lSPaWE^EV5qss`FsUtGv)\XaXR?pQF4fVEDl>O\T_FFuW3[R0T-UaQFvaX\TFWLd@0qs*XLUTVUaXS,qp^EDY\WCs[a\>toWF[UXaT:vjTtF7pNB=-EdW>^\X<tWTW7^NER=p`XnM~gg@o\MPl_hQ]n^H~iG'e^Vr^chn_nc_~^`hRjfKT~~Q`GDnWb]R8TNb3{UF~~S~]TamchY`fHaj%~`nhc^FsBigf\]L~Q{;zhcncn_T~hc_Gg?teGu^XlOkchkL?R<I~~_]'~z\VcC`mO>C_@vg?Q;JZI>~~Mu1~w@~&tllEjlS<~fc^A~oK~xM~ghcM~~`7ahkG^hchT~b@k~fH]s*~~cQ]k;`A~zJ^[VkLi???R~P5~|dMjl+~~XQFM~~S~X~_hlQE~mhO~Uj8y~U~<~s_T~O~h`mF~uR^m_X~kIJ^dcArcP~hdkPk_SRFzq0v[N]]Z5~M;eP]nc^RbngB~|TkE;aJErY%_A~~~f9~{eLyR>v_~_hT~K~nch^Rl]ObmI|iZM]_~P~hO~m^K~aQO~cmO~lbPNbgbOkO~hcmS}RInr]GQJZ/B8Y:L;LGaVB}KEtj?~jBx]UT~j2~b`c@~cN_PD(Z<:7-O/FIIALhMbKvRTGTM[=<Jz\5gEc^^\QmCGkP_Qin9O\_$JZNPi|_Y;[dnhngV6jcA~sO~h_~c_chch^~=i;jNy9jcYc]G~l_h_mgk;:|h|v^:dM~cLmbHkc]7~aX~4~VF}GG~l^kHan^1~~kR:|zg?~alNv6{h`Q9`eSM~~mcW~L2w~rb_a@mP]J~~hm_J~~kKI~^ck4~[MM~~WG3~~~W~_3j_]~NjgK~a4~\gM~~~_R~]D|HhQ\7~a_nhMknhn_hh2iQh9~L4|C6,jJ~b[&~~~~~ech]fS`QR~ES~zHS~ciJLah__~F~qK~a@~P]hn=oW~c5`LYSYb;c5~}Y_;jJo-YKClfa^Rb8}ZEeOyR_n\:8~PFk^WPS~i`_hm_hk;jc$~~~~|snlny~~~~~~~~~~~~~~~~~~~~a\<jcf_7[c^C~WkhkD~lbhY$Nx
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2986/ccs/fwd np:i:6 rq:f:0.996692
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCGATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAAACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTGCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCATCCTATAATGCTAGGTTCTTAAATGTCGTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCAATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATAACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  e~ur~t}O~z~{rX~ntr~tzope]$n~~~~~~~~~~~~~~~~~~~~~~~~~~~srt~}gr`=rqh[~~sq|]{U~fr~u~H~]Xd\~tepNsP~jqsA~{Rr}F~}^~t\go`X~]KvO~|jhGL~W4~7~zB~l~glr~lZ~r5~~qE~fi~jpyo*~~~~zsrD~Y~nVc~Q~k3jmaMVm~{J~k`h[T~mc;ml~o>~pA~~~}\b~kl~i`~i~F%~op`u9~~~fI=~~lS&~{oim~kc+~~\|h,~xqdL~p[q5~~iWS~s}\~~tzryIqfJuO~_N\~Q4~~h}R~~k[qq|ob,@bQkK~~j~uj~\rrX\vZF]~[rF+~~~[Vq{yppsqFc@izs}f8~{~R~k~Pla\mAd~;H~V~~o{~qgzRyQp~sf8~ice\5~|ty9N~~rQN~}b~od[|r~sI1xyWts{r}pD~ma\lZqy2~jBzoK~~piqf_Y~eptX~3~`RnL~{L~}k~H~~rtoSodlG~T[lTptL~~h`~er~^~~skzp~|p{O~|^_~~_P~mgJ~|]~Z~pirV~~~t~lskoRr~k~Z~SpY~_~i`~~,~~}K~~~\xVOt[r~ruLB~~h{]wroznRw(=~~pfoi|iS~~xYe{~vnhK~rJ~[|K~\}Z~r~pfC~~yE|\~L~qV~~j~8~~j~L~QD~~i}nsY~YxD~~l{=~~~{X}}<~~q_~mkZ~oL{risS~~r|}qjyG~~~h~QdM~~R`~iswwt~WqAzG~~ri}^~S~~R~~rsiL~THs~~Z~a~>~~_~R~~rq[i\~=~~s~qi?~~}fAI~~~tlM~~S]~oUdsz9cp~\~dI~G~qsia~cYhriYU~M~.~hgssX~P~eitsh>~ijeY[;Rgphm;T~W~r/~haG~lO'C3~hipT~~hJqsr`hR~ipOVSLNN~grtgG~~Rl9WoR_~ikAr\mT~tisT~htsK~ihq9uP4nRdEvnpGc6~tb~T~vdsicmtiK~~]qq=~OX:~DoD~~gjnRPIRQGd%/o~QN~e1PXeUCa8TfYhnRrsiU~[nNpOLQ~siV~hPN~gish]RsZ~@pnA~~~Qqq[Qqh]L~qRriX~sjssgEPa~h6~j%g2~qrblPYRU~b~hq>~hshY~gPYqiihiq[Ra@ftO~~~]hrLT^98tQ]~dR~sh^she^_frthYD~qthtJ~^H~`~]h<~|^3B~grG~hpD_rV~tb~tfNhn*ashsib~_~\wsrRMphpeW2~qnV~npXLqniRnGV~a~gN~6~~YgpRfXao[(~~~|QX~ihsc0jmrf.eqA~~pSJTapD~sihsrsjq]g^O*~~hpRqhNEphb}?~qiq]eW=vhphsB~~a(~~~fFCn1J~~^~RoP[D~nhUZfrd<~d0lGK[~;psirQ~oGpfA~W~rita~+~~hfO~grib<~qsmRnRnP:~Mm5~~~~W~tjoA?j`~hb~hitflNU~O~tidCI~~]kmisW~O;~W{fishisb~qAuYreishsic:OygQ~gtc7}~~shh?~~nAbe,Xn5~~hneoRU~)vria~RnEnX~OmrpRgn1esirneoRrrfL~rcXqF~qW~[gib~H~~erh]\o_rem\V~mi9~~~fkK_YX~O~V~WQptg@~~~sa~RoRnSg[QfRg\J~tB~FR{)qoiha~]qiU~isL~qcU~hftW~e@~h\F~pR^~l`P[Jm~rPRrJ~tG~pD~qiT~Q~[-A~:Bvym[pRl9Bn\i`~tsia~\fBR~h3~~~apXb:~~~hO~RhrF|AertRu,~~h]C~(~M~PW;OPqh]b0ofQ,~undqSeKqU~N~>~)qtkJliO~Qhhth7XD~eRQnZN~gZ~c?9~~qgYK~c;~gN~\q&FD{pH~O'B&rxQ5sU&WCO0;`~]Y~hD~~~iS}.eO~sjI~~~]gO~~QI~~eO:fa6\NOEU~]~iihsV~~soip0u~hhif]ce1KT~irUqAoRifkKpfhfNYgqD~gq=~~iU~q9~~~sa~Re]U~pY~hshb~itsZ~b~shY~V9feRqhD~htsYr1~gvaU}sttO~~W~>~~iV~sJf4~~xhO~U~AMgfihpQ[fsh^D~D~qhiX~h]KvRo6~~dirN~~~Rrhsg]qZ~hNQ)~rY@uS~HafNE~Z>~W~V~~A~kgrr=~e2P~hV~p>~hhO~~p:~I~8Do?~~U~p]fQ~hpgL~HdtirUThE~~~imjS^>_ihib~gFlB@uWMXfRq~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2986/ccs/rev np:i:7 rq:f:0.997961
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTACTATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAGATTAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCATCCTATAATGCTAGGTTCTTAAATGTCGTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCCCCGTACTCTGCGTTGATACACTGCTT
  +
  PvF\eOLKehfR]F~^^_g]N\hg^$~~~~~~~~{qhdir{~~~~~|sjfebiq}~~~qirr\qitsigmG~qig^etG~sgA\kV~sgGNsSqintWrkBkJ~trVY:~^Eya[\esC~fb~D~\[0ZGxL;~)~1+~gr`jdqeMqhJ~~iD~ohlhfng'~~~~ligSsF~\gF{<ov?iZdZSgsqLN}Yqie^vjq^fP~iV~h,~~vnja~TV~sW~<|eO~ha~C~~~mj@~jPQ^~ndiR~fe1~th]p>~kSqX~eM^)~~hcb~dYW~~qYfrtg]?~L~]qV~@8~~stW~~W]eaditb~iQ~I~zN~c=yhg^hfXcfD~O~h2~~{bYPfiitgGb~ihjg\qY~tsYy>~qhshhRQ~rZ~H~~gspjp[XoZgqRpL~rR[hc~rgckV~~MoW~mK~h]hsh]eRNw[gohYg[gb~Ro]Uihtb~hisiN~kinbGqV~shRJt;~~rhB{+T~]a~Jvxhie[grh;~fRisig,~~oD~YKVX~trfWPU4GJW~tgE~qhP~itX~sMwS~jrgI~~ohre[Sh\Y4Q~W~[hO~:~pY~_9~~n-~~C<oiH~VgYdkr;~~stgXPfaisolJ|~dYhstq?~~YgrtstgnL~hY~R]J~hsN~RriqO~~[RpZ~S~hJ~~@fJ~~P~WyZN|~rrXgN~W~A~~h]6~~~tM~sJ~~qG|ZhqZO0phqS+~ldX^iq]G~~~b~isO~~rV~mgNiP1WfntK~~im^5U3~jP~~igZX~sL~~]a~W~I~~W~=~{dPd[Lo@v~gsis8~~sihE~~~gi?~~qX~g^qRoWDgsY~]HxN~hhsJuRrhthsW~,~U~YgrtZ~b~ihsrR`~nbh[Xf^f]fsiWf*~~b~hsZ~sisic~ihq0T]fnGpsrhQySXh\qiiM~gZXgQ||gsipGfA~dlI~[^O~bha+~P?TW~hit`~RQYhhW~^]^aE~pP~@~~i]eRrshL~~rtrP~gsZ~ssH~~ig]hgigRL~G~k^[jerhXOqK~iufn:mjsqSW~stiqSqZ~shZ~hh>~fRqisLxQ~V~W7~~dRn.pmc]coT~qSphX~thtn8kj_~hW~~h\C~qtitisiW~R~in]~g^iT~=asrhfScno<e]gr6~~lYQVjgRpY~hPxNL~rib~gRqsgDTaZU~tqOpC~qW~P~rhW~~isNrMrW~g^gqXT~p,~pitimPhqhtha~P~M~tsi_~Qmh]V~V.X~pq\X~QURrqG~a~g,~C~y\d1gg]g]p2~~~~gX~hisiq]qtgZhq9~~~iqjqtX~rRisttg_qZsg8~~endtigRAPVzS~sg^qihb~g^g[(wuUO~~~hqD~qO~~b~gEOpV~rRe]g]e;~estsg:~dsthtb~srXPM~I~_ek0r@~xQfU~h[fia~]p]g[;jQ>vV~0~~~SG~qhtsYy>~ha~iSAftiMuP~pRfYG~~TDihtKwTT~X~i\Ggh]O~rN~pXaileqhgd>~fa~jsi-~~wn;cL~~ttihstsV~~NVcYfG~p]f@~itstV~f0l]U_Nrg`fPafSfEMgFaPYi]Y~rJ~_iWQh5p~g]eZ?KT1dnsM~fQ5~~~hshjtQTAxF~rhsqA4n~~lOvfHdGghsthhRpK~uX~sL~a~]gib~q]e?~e]U~rST~Re]W~iO~ioG~Xf=yUfRpL~~]U~sJ~~P~hU~rNMl,aqn4yKI~~PkgsgZ^rh=~U=^M~Xfn:~`@l~~inlcB~{~e1sc)_l4oChosL~R~~XpI~b~b~g[QdgGeqRoXdY9w~qSqWhO~MuQ~M~N~~]M~DKbQce[fP~X~hRhtrOwhX~gD2ukda]K~~O~fQypWjW~rP~get3~shH~~inaRqja~sE~h+u~gcY~qRa~rTE~~~siL~~e=}~ihpGgV~ihsW~P~gP:AI~~XiPn4tLgfRoRdReD~fqRqR~hhguitfOffsfGV~it:~L=`~^)~tsq@~eSoG~^b~isiV|ORUU~]~^gK{tjhhf]g4rhstV~Ms~~NPvQomJ~~K^9~~gY~_LmD~~~QB~TuEghihisVD*QeEHT(~gihU~NlZ~hsJ~~Zhr+~~~hrhuipGT~SR~V~~g>~E|YfRh4via~H~?~_E~ritqA~~qU~iX~t`~Ra0~}pO~?~istLw~X~trib~etib~hRoRoWDeE~~~htsgGgq@gf?~cnsm&leVfTG~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2993/ccs/fwd np:i:7 rq:f:0.993803
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTAGTATATCCTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCAACCGCGTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCAGGACATGTAGAGAAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCCAGTTAGTTTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCCGCGGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCCGCGCTGTGACTCCGGTCGCCGACCGTAAACGTAAAACACTCCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCATACAAGTCTTGCAGTATGCTTCGGTCCCCCGTACTCTGCGTTGATACCTCTT
  +
  \zXQ7BJBV7JL>EhSGHkaWarWU$fgdegjmrqlcZSU\iywqkc\\^TMIHKMPSaReHRb:4ppiXbWNzk]aZ[U@~W]taU>~X\j9}amV?qQ~n^mK~ik`DDzT/~j^tUKFi\8q7~ghK@KPGJlA~oR~HhL]aqL`}H5om^S~g^rTNXT%kZh\XXLb~Q~t^^~8diP{TFdB(;=V=~lmDJa~UO^WYf[7pE?@oZ]K%;GaO~VFfM{CU`/6`2gegC[M}x\WBuf]+K|\NDciWXE:k^H'&+cKCT2n[O:\PT4PXY/EHXagSuGmNABghB~_,dAtpIWb]ZOmT`0EaD~hUb^Nj6HFVHdDLCna~]3~~z`QMda\SU9VfU`mGmf7fo@/`JC8JO*E@_SmX.c4iQIYjHgoim@5>ZVIdWGfFDoeIRA6gi_BH~kIm-XVGl/b3YLrkGl0fDW[W~_*jKCZSD|^B>IA]L4iLpWM~aE:TtOkkUF<R^E`YQyJhrLaN\NVH<iX_^m^`9~~j?~raSMurW]f]PW_U5eSa9pla6VNM3X*5u^w\WV5~~l\TZj=IT^WEOKgEYHl;~R8um=JnmHgkn`l]Ue6]-[h]Cii>R_C\_h^lse2~~at]TpQ&|ylkKWnmqKU9|L:{Lk9~P[FrYBX@-)QrXV9\KZ2GewS~H~~3K=e]6_ScCfXHqOh-~OGU8~~~r9tF8m~j>~ZOHrbo)]Y_/Qhh`UZ\mm+t~oJkKlD~~]P~n_lm`sm`WkBtz^mtK~G~k1GZ\bf)hq,~lk<~Rz?~iLnU~}L\`X>hM]L*ViHg>_DdXY7vczZ]G~fC7o]afW;@nAeGJsK~<~[^fQvIo\S`WKqJmG\UZitH~H~]`WlLG~U[=861IBO[D[KmFv~\~aT5^B5^J<[]blG~xDPqkrjKO~Dj^rUMZ`h[qm]I~~at\Pe]AkMbAvhrJjpMqR~^dVK~b[WVP`UWW^N|XqU[7eeNt0}~ZsbY@N^P~mAgVMs:?:lXl9viKarFIG]W(~0~zKSi])Ge9Q2n\n]n`WXkP[;~mt]eBPHk-V'~^[@Gf]btaj6~L~=zp-he\[NqWatbmQ~s_rR/jYIP,_R]F~^I}_YCH~cIIoDda?vL~XXWdZb*;LDO?BCXDKfC^$6CXj1qmdSaneFIR;~^<dJ@zVZ\cSBUVE\EYZ+q\TE;Q4CC1F?OMNOhdFYMjQ@7d3p\Sd5hj`~@>KIk`5TarK9~a~<u\PLUmPl^tJnhKE0i^HpgQ_UGng2e[tc[PdFanZulLpWJKIfKl'?A,WrfGazt[Q8xP2t~;o3l^WP~g3`sMrF[|beUiF8TI?PGbFbbeV[EbIjoZWQ^+Vh4C,~Z;[WFziln_r`Z_@~Nx:~~~qMrmbqf;h^gQJ[]bkGRIXjQ~lcWSW~~jpRLWN~GMgO}EGNV^p&|g7eKUZ`W2o`[E+z\G^>^42^eqPMQ7koW*ZaiMU(``OHd_r`<|jsba}ZC'\O~IrcG9?>i^ub`h[_3TpC=~f\PZN~mN~t\KNhL~mCAZ?UpVnLqfGqfa2xfN4QJ\tOiN~>kR\f+CJm~tWZ~`Ybp]_bH[Hak0zF9rV(a)VlQ^`~knMXtbrHdX2Ol5_l?~[P~bQK~S2<l(V:*7Qoq<~e-dg9Z>ESeXDeNUYT%gR?k~_o^pGCqg\7~SmH]ngae'h6:hzbHlhH?~~yaG|Wac8TG[riLi>~~atS~]~bqJXD]]kIPW=bVJ:slXYSa\=~NrKb=g>\skLjBCN+Z]tab|OfW]XoUP~[;WC:B}~V`r)~MI~`N~hYe=olc~bZ)Dv~a?xH3Va[=EL~WQr43f}~a*~^Za@yDa8~~zhW]H~Z2A|rIah>XR{DZI(x:~Ha]s7mmrmcr6~~a]$?@E.MWJ8`^U^qAu]`Ir]s[b^`u_[M~JZD~~b1fg*y_YVK}_WY7~pO~]DXL~amp*~U~t^RyY9`&bbtbK~KUrS~>~wy`;~pEp8~x<xO~xMJ~tP~/~vZN6bQ~o(b_Z`IkHU\WY>I~Q~pW]9c`lL~bpLi_Z`[0zg[RQBZ(P_sO~_I|X~~L_x:~l]YWEhI;pKM.rfN~ZZYX8~~lc~bL~sO~c\4~njK~_h[l[E~~XVkR]Y~^tYXdGGkbtmp6ZR~HP~s1~~~yb_lZ@EnQ]]`~\=ob-2/*,W
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/2993/ccs/rev np:i:6 rq:f:0.996417
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTAGTATACTACGAGGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTTGTGGGCTAGGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTACGGTGGTAATTTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCTGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCGTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATTACCATTGCACCCGAAACAGCCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCCGCGCACGCGCCGACTAAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCATACAAGTCTTGCAGTATGCTTCGGTCCCCCGTACTCTGCGTTGATACCACTGGCTT
  +
  +JG816=<sfR:[]k]ZV`=PMI[G$cvoc_VXallnkf`^bhnssnjiks}~~~~~~{WZdikxgwfdZy0}pgjebjzW~ffpPdQy5f`W~f}hvbC~vV{V~rrcR4}VE~dOLjzX~fS~P|MqVzW~OKxBt{Y~g}VXWQ[R~jH~sfA~@PrvcNb&~~~~~a]JzHglaCp(~?<~f`Apc[JQIfjGRZ;}amS\T~b;~^>l~wXJb~J.pjJq9~_?~`c~>~~rYJT~gY:a~m]bY|Zh.\[\Sj0aP3V)d9_[;~~pYXdZXK@TS]^ZmXdIiMtmsO~Z1i~nCR~~`A[`A^@KfIMS@~nO~\\~`Hib[WKZNuKo^7tktcd9P4`t`?)~JYh]mtP~WrS~\~pIUWa\YuqRx9~~]mtbshifSJoHqL~~bQJO~k[eZ?~iFYO~lArVT^A]+W6L~fakaib^WI~FPbHa\lQsHISZ)/?LI]YmK~r`H`~MTtd0(rTM~kM~/n~UIZKoHd`3{[[Jn\H8h~p9~f\ULgPm]s[ji3jP~m]A~r^[~KUQ~t<q\~arKB~~jDp^N?`XE=]~HmrNC`A~rRw;Ev~r0~~~\saNf`1?Z]Z?wlYOET\\WaqSX<~~[Wag6b6ywUK`kim\VM[3O~\[R~]Y[~Ij]lFr~kKmPw:~aA~q8rC~~U~R~[I~~l/laP~Mz>~|\RB~~xWO~s:~~r;~rbtm]mnYk/KQJCR^]rW<~~\DaJXE~~tN~rHphGAp]tm?~v]rW;N7[NFb~a[jO~m*|A;MzK~@~[?~Mv]3IFqP~3h{[War9~~pM[G~j}]bE~~nJ]Ynt]mqA\fL{SJjLfaYUGP`CFDYcP~N~R}_aEKJbc~b[iPGa~iW];LZRCRFeI:`E~~^}Im>~pHlYMmb]sC~~VRKWhjWW~\)^VpH^Gh`RY_@~r\V_[U]VvRHDOUbJbXTWQsaQNOw\HkZlSo\\Z?ilmua=pMG~G~}ZOX^jY[MzkZgm1oSFZR~sk,~~^2N\Y$F?R`AhdK.c[o]ZYR,u_BFoEgTCVZIrgkMjQHJuX3?{FY:z_KYJk+~Vj>I31SQ_J`feXm\A:qX_@JO~XFkrHm5P~ZLhibmS~rSVjbt]Q~G~alc~]YaLqH\tn_2`ZUWGL@[p=k~~s]mlF-CfN}]V~]K~pKKi[btlaUY[g:|Jq^hP~ZL~Egr]4~}GSK~asMz[m[rUNgZLtncmbhVZZYhFLb6}XdRa`?kKq`WR~rHYsmu]msMj\.wMZ@ak]cskbV~c~lY=o`HI~[@Iq@~~pD~~nGmN~sE~~9~`l^sIjW_EP]]CJIKLSJK;}Z[eIcIMUYhLP{:|<CqV{H~~]b\~`%U[KO~kslbl]l]J~>~?~~~zK~s[gsP~M~`EhJFq`A`R~R~WVbsM}T^mrHh-~_Wm;~_C'OS^:j'O~mR_G`^hZb]Y~VS~ct^@cok[`]6~~rma\hms2SPMs\B[M~slLI~_>oVGU4SXUGJ=paAWRS?f5ombWlUWqWN~s:eS\GZ~:~~]U[efAogWBhN~l]0jCH_?Z^`BnUrKn]GanY>}TPjHk]W\h][jm\L\sP~k9m\QrOck]bW~tm]P~W-EydE5u`Zk>~a[~HqP~saXVlb]sH~|H8n\B~dIviG~m]b~7~~gS~^I~~]m]l^derZ3Jod]V~qCeH~[2{~z`js^A}gq[*~[CW=~kbkY+~;~~\mIjad)~Sfa\K^*?^nA_]:~|VPR8USFGqIS>~Ki~eE[ZQ~ICD>4'K/NE@[Vp:|G6aHeC~lLEd.y~b~]UlS)bhN~nJ~\\\6~~[-~{]AC$FXZHlm=~]3}~x[.v]YVur]>{i|sa8~cLU~~][XRO>g_DQQ~K~\BIUR~|Xr\SE~rHJ[^qLWa]S~]tbm,lc[R[H_QOJNGYTTO~YOA_{]b~W:vy~s\~]csP~lP~asb\~]nRK~N~ka=x?WF`Z?D@yYrj,x>QiV5Qrmtl6~~P~@~bIR~mL]2~kZMDT4{@`]b]^U]ZHp^gMkE~NZHR~^sPhXeHrrK[k'~zeJq^ebl<4e`L~O~~^X~S~pWX_Kqa_gM~H~~?~e^UZ;~~oDdJP~mc~]a6~~kc~[~Kpk7~~_T?pbc~]iaEfG`u\_IUXbDfJIlJ<g~~|]kXIT_WDD[K~[^C`P~h^f*PKMr
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/3023/ccs/fwd np:i:6 rq:f:0.996632
  AAGCAGTGGTATCAACGCAGAGTACGGGTGTATTTATCCGCTACGTGGTGGATGAACATGGATGCGAACGACATTTCGAAATATACGCAATGATATCCAACCCTACCGAAACAGCAATAATTGTAGAAGGTAGCATATCATGCCGAGAGTTTACTACGTTGTAGCGAGTTTAGTTGAAATAGTTTGTGATGTGTAAACTAAAACATACCAAATGGTAAAACCTTGTCACCCCCCATTTACATTGCGACAGACACAGTTATGGAGTGGATGGAAGTGTGTTCGACTGTCAAGACCCTTCTATAATAGTCGAACCAGTACGGTAAGTGGGCAACATGCCCATATAAGTCGAAGCATTTCAAATGGTTCATCCAGTAGACGACGATGTCCTAGACAGTCATGTCTCTTCCCCATTTGAAGTCATGTAGTGGTTGTCTACTTTTTCATTGAAGACGTCCACCTCAACGCTATGAACGTTAGTTGAGAACAATGTTAAAGCAAACGACAACGTCATTGTGATCTACATACACAGTGGATGGTTAGCGTAAACATGGTGGAACGTACTTTGACTGCGCTGCAAGAAATGGTTGGGTCGATCGTAATGCTAGTCGTTACATCGGAACAAGCCAAAAACAAATCATTCGCTGGATTTAGACCTACTGCACGACGACGTCGACACAAGACATTCTTGAAAGGAATTCAATGCAGAAACTCCTATGCACGTCGAACTAGTCCTCTTGCTCAGCGCTAGTCCATGAAAATGTCCTAGCTTTGAACGTTTATCAAATGCAAGTTGTGGGAGTTAGTCATGTGAGAGTTGTGCCAAGAAAGTGTTAACGTTCTAGCCGTGCTCAGTAACAATTACCATTCGGCGGTAACAAACGTAGTTGTCACTGCACTCATGAGGCATGAAGTTAGACCAGTAGTTGGGTCAGAAATTAGACGTGGTTTAGTCTGGTTACCGTGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAGATAAACAAAGAAGAAAACGGTTAATACGATTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTTCAACTAGAATCTACGTTTCATACGCGGATTCCACATCCGTTCTTGCAATTAAAGAAACGATGTAGAAAACGCTTTGGTTGGCGACAACTTGGGCGGCAAAATAATTATGGTAGGTAATTGAAGTAGCGTTAAAACGCAAAAAGAAGGAAGCACGGATCACTGCAAAAAGGACTACTCAATAATGGTTTCTAAAGTCATTATGCTGGTGCTCCCTATGGCGGTGGTCAGTACTGGTAACTAAAGATGGATTACGGCACTTGTAGAGCACGTATCAGACCCAGCTTTGAAAGAAGGCTGAGTTCGGTTCGGGTTTCACGTAGGCCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGGTTACCATGTAAGAAGCGGTAGACGCCATGGCCTAGTAGGAAGAATGCTTGTTCACGGAGCCGACGAAGTTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGAATGCGTACTACGGTCGTCCAAGTTGCAAGAGGTATTAGAGTCATTCGAATAGCTTGTGGGAGTGGTATTTATAGCATAATAAGTGTAAAAAAACATTCCCAACAGCATATGTGTAGCCAAGAAGCGTTGTGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGATAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGCGTGCTGGTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAGAATGGCTATTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGTTGGAGTGCAAAGCCATGATTTGGTCGATGCGGCAAATGTTGCTTAGGACTATTCTATGGTCTTGCGTAATTGTGAAAGATTTGCCAGTTATCTAAGGAGACGTGGTGATTCGCTCTATAGCTGTATCTAATCTGCCAGATTGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  4c=C\PfHz_QcO3nPB<BT:Uc;R*vvdVdOApvefEwXRc9SWfBoZHzcMUWuTaO>fNPWTWWwS@NTeHxuUW?uted]4SXQ/nVWffedEwGf<wwfeDmO/Y[RRR=;]\P]ECQX9T=WFvMcWUeeaXTOdXHwVeU9U?YpeUfeUWVvWcJ\]`q_G~~o]Lc]FliokW5~}[pLEg6W]K9D^Yj0phRHlo=:i6VREA~n<n~p&_`~Jj-Q%H?:PhjVz~ZWe^~`]`q]q[iX@Yp`Nz\W9ko=XM~DoM~-pEj:k]L~9NaLn`q\NyYV@~~^~IkXU;~onFbXYFLB_danEAH_j=~<d5~k[+~\ke_C~~ZpnpM~^\[O9f]GWErx]L~~qN~N~]jcGzq`qp_lZ^[]`Xf_qIgqX_p]q`oHoq`kIn]a~;~~~[@~y]-}\Y[lgHjUZQJxDfZc\oYGAsp`iJ[\jPNSGCF^lBu_Dop[M~X\JdGgMMmLX5bb[Zf<[R*JENki]^x8GVFHMhmZ^2S;eK_qWMBVRTY6WYZCZRMXNX6ZNc8hPK@eZoNFDHnDlcLYS?xmOc;{[]dXJFtpZRUTDKKIWEH7P[7hfoN~N~0n{RWZfeVZe[~X^]qpFcG]a|nHbBZ:f<vFWk[@v'elcKM?SP`HIM]1Z,KK~EDn~n_DIgqlZr[ETI][^_]MMj]_\HcV;`2THCM^[[zVPwiLiN~K~[<~o\U,]Ng~[YN~nBn`^l[Jo]`U~]qq^Z;kZ[O}_ZZY[2U7OjdOpNthcK;fovVKm>~l?[]@uQ4J~Z_D~~en[Bmnk\[Oq]P|NY<~~p_a~r`q]qm^l@YFWA(xFXE&YYr[4~~]jI/~]~XG<pIniF=y\aJ4YYD^q?bL]~_~Z=~p`~]N~HP~p9yZBd|]`h)UH~_p[E\q`XbUYUfU\o%VWPjIGgWK~mWBId([oXHMl:n@*ZfI?Ju`~[[k]`qN~U~~D^lE]O~a~qN~_l4@pq]9cjZ_HmI/Y]m3Gq~__~JM~[^F1r[]eiPQzI,lh^J~[${~\]Ps5}VJli8_qa~^i:~__:p~jnE{]U~d6_Jo]J~^`~\lW^~BaFH7~~Z;oIoZ[JRo]q^ZC8~~\pnn]^HP~YM~N~kImYFsJ`~\N~_^<{^~=~u[<~v]^YnLpr_+~~TLQLQq|Nu7~:~YH@GJ}Za~G~[3P~\0~~~kW`WWYpN~lgJ~pLf]~]Np\RV_]_N~@~~~[]E8r~~q[UvQ~Kg^FmCMs[m\[]jG[.~~y_+klJnZ]p]@~q`~o?~P~uHnF~~_q\XJepm6[rFzU\S:+bqlopM|YK^aQ~m2W]WY\j(TP6U\o+zf^prMmq`~[[?~FYGM~_q[`q`]q]^WBmGV^j0^Ja\10xe^Fkh^Gg<~ZX][\^~G?~`~]F~}D}eZE\`p[P~N~rm`K~\[gN~pppk\M~IoN~`~K~X7~~_oC~|:~`~mI~[p`r^~_:~[[N~Xn_[^_K~fqN~>~ok\n[Px8{ZM~q_\N~^N~\jA;n@X;~^[^_`~_-~yn^YKY@_qLtK[^^~J8q~`l_]lWsDm^^~N~nVIiU:~q^pJ_~q^3^p[\pCGP~oFIoM~X{HK~ZG;55qJgXX_~UZZ`q]k]h]_L~Xo_H1ULc'h[SPoJta\U~~[kf\ZMZ@~Y\~aq`q5~vtlPRER]~)~eTo\]P[XnYfJBLYk\?~@s_`~_\\J~Io^]p]]IYk[XAj~~`p]c7k[R]FX^J[P~GY`~*HA~~qaq`qpn^PzHjfG6~~_oG6~~p_~\qqqN~9~vD[V*Z~YHj[]^qpkKIt`]`q_o6G^n_[X>yo9~q[-yFD^V5G=~G.~oq`qQ~[;~K_6XEUGN~~paoVWcX\~_ZDL~=~JzStFnq\Ok7[={G^oXo_J~EoN~Q_]9ykL~YkY_~Ho]`r]qQ~qY5cjYCIn:~UFZY|h^X_p[`ldfN~q]`UyH`p4~{]]oXVWNl,f^HK]M_nS~KUJSXQoo_a~N~qaoKHEs~].~mX^[@igN}V\apX]G=t[Sr~r`K~`\J~eN~nIoqOsLpZpQ~m3P~]CYp`~P~_oM+lcS>AvhJK~qZ7~Sk[l\~N~q`q[KoO~q\@8d\^HiATT;e\Load0PYnN~qZpLHtl_[`~[$]ksphgbae^[cjov~~~~{rligjmikxa_sq]q[X^]`N~_qpk*~lHgDAo~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/3023/ccs/rev np:i:6 rq:f:0.993394
  AGCAGTGGTATCAACGCAGAGTACGGGGTGTATTTATCCGCTACGTGGTGGATGAACATGGATGCGAACGACATTTCGAAATATACGCAATGATATCCAACCCTACCGAAACAGCAATAATTGTAGAAGGTAGCATATCATGCCGAGAGTTTACTACGTTGTAGCGAGTTTAGTTGAAATAGTTTGTGATGTGTAAACTAAAACATACCAAATGGTAAAACTTGTCACCCCATTTACATTGCGACAGGACACAGTTATGGAGTGGGATGGAAGTGTGTTCGACTGTCAAGACCCTTCTATAATAGTCGAACCAGTACGGTAAGTGGGCAACATGCCCATATAAGTCGAAGCATTTCAAATGGTTCATCCAGTAGACGACGATGTCCTAGACAGTCATGTCTCTTCCCCCATTTGAAGTCATGTAGTGGTTGTCTACTTTTTCATTGAAGACGTCCACCTCAACGCTATGAACGTTAGTTGAGACAATGTTAAAGCAAACGACAACGTCATTGTGATCTACATACACAGTGGATGGTTAGCGTAAACATGGTGGAACGTACTTTGACTGCGCTGCAAGAAATGTTGGGTCGATCGTAATGCTAGTCGTTACATCGGAACAAGCCAAAACAAATCATTCGCTGGATTTAGACCTACTGCACGACGACGTCGACACAAGACATTCTTGAAAGGAATTCAATGCAGAAACTCCTATGCACGTCGAACTAGTCTCTTGCTCAGCGCTAGTCCATGAAAATGTCCTAGCTTTGAACGTTTATCAAATGCAAGTTGTGGGAGTTAGTCATGTGAGAGTTGTGCAAGAAAGTGTTAACGTTCTAGCCGTGCTCAGTAACAATTACCATTCGGCGGTAACAAACGTAAGTTGTCACTGCACTCATGAGCATGAAGTTAGACCAGTAGTTGGGTCAGAAATTAGACGTGGTTTTAGTCTGGTTACCGTTGGAAAGAATAGCTGAACTCAAAGAAGCCGACAAAGATAAACAAAGAAGAAACGGTTTAATACGATTGAGGAGAAATATTCAATCCAACGGCAACTATTAACGTTTCAACTAGAATCTACGTTTCATACGCGGATTCCACATCCGTTCTTGCAATTAAAGAAACGATGTAGAAAACGCTTTGGTTGGCGACAACTTGGGCGGCAAAATAATTATGGTAGGTAATTGAAGTAGCGTTAAAACGCAAAAAGAAGGAAGCACGGATCACTGCAAAAAGGACTACTCAATAATGGTTTCTAAAGGTCATTATGCTGGTGCTCCCTATGGCGGGTGGTCAGTACTGTAACTAAAGATGGATTACGGCACTTGTAGAGCACGTATCAGACCCAGCTGTGAAAGAAGGCTGAGTTCGGTTCGGGTTTCACGTAGGCCTAGAACGAGGTATAGAAGTGGTTAACAAAGATTTGGTTACCATGTAAGAAGCGGTAGACGCCATGGCCTAGTAGGAAGAATGCTTGTTCACGGAGCCGACGAAGTTAGACGAGTGGCAGAAGAAAGAGCATTATCTTGGTACTCGGACTGAATGCGTACTACGGTCGTCCAAGTTGCAAGAGGTATTAGAGTCATTCGAATAGCTGTGGGAGTGGTATTTATAGCATAATAAGTGTAAAAAAACATTCCCAACAGCATATGTGTAGCCAAGAAGCGTTGTGCTCGCGACTAAAAGTCAGGTAGCAGCAGGCATTAACCCAGTGATAGAACATCAAAGTCAAATAAGTATGGTTTAGCATTACTGCGTATCTTGCGATTGCGTGCTGGTGGTCAACAGTGCAAACCTAGTGGCTTCGCACTCAAATGTAGACAAGCATTAACCAACTACTTCTAACGTATGTTCAGGAAGAATGGGCTATTTCTCGTCAGGTGAATGCGTAATCGAATGAGTAGTATGGTCGAACGTCCCGCTATAGTCTGACACGATTCAGGCAAAGGTTGGAGTGCAAAGCCATTGATTTGGTCGATGCGGCAAATGTTGCTTAGGACTATTCTATGGTCTTGCGTAATTGTGAAGATTTGCCAGTTATCTAAGGAGACGTGGTGATTCGCTCTATAGCTGTATCTAATCTGCCAGATTGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  'LAdS:7iJ_eS@`MFMDDNCSQD9nyxeR]c.p[^N:fTVHKUR^GlP>Y^c<DtSYeH{feSU?SrCTcWd,iV@90rtcbM8+QUSZbUfef^6_S[1xqWd9wSHwrUMSW?sdAWLvUdeTIr@med?=`A\PWfdA.[UfUfT4\\dU7bVABaS_XUR;dT<kYcUNvT@Yi\LT3ttUUTaXUdTOIxvWd1vvpUMcc-KAunJ2=6)Y_[VFiA`Cb%uvaG<oucUYBWSU@cUM-jeUMUeS$pbbHzfO;,plfeHzTtLDJGGBZRQIVbTN@RuVc?|^@pWbfeTXefTOVS/sDXeU_AAEvSHoSd/XlVGuS_dUBz{`dacAv@bWUUwTAc?ZoVNvvQGnEsVdM.H`TOc@dWT`RUdO@cHzefUcAdKeVaXS7?KUDj&rvuMK-VSJDINeWdG%6]TN4q59=_VHGR1uwwcULEuTQvVcWUaFtYHy_<FtUU<C6VTSpU@TuMSWwU`@cWTweT3rHwc@U?uuVSITVrU?KAcHsUeTM`A]aVaMbVaDbRYE[XQ9WMTC9PQM;ko@_H2tT6vRsQVefT+MfI6=5?C2HISFVlO7Y@X(M\0hi_UUb`RTG;[L?B[c>F<QD[ZVRcV3\C[VUrUHy4twgV:h[IVaSsVS?]BvfExxeTOF\IcWSS1cFTD@=MUUOVUdAbA?iUdAdVuT?TROvuFwTsPqR@jaEVfU4ua5X3NedL*TfVDeU?UtAcaOKQQTBXQFSSfUTTAIVFPJ|feU@wwweTOChOLE>9coRSY@:Fkd\eW3u^RQSXvU>SCL.ScTDJpYSOVfeUeUbMbUGsUbTAFrTHp^PMR1DSnATVtVOMSFt?cR$J?JBbGsVTYWwfHzfWwV4l(2ndVtW6thWTLDuSFjCbS_VOSTJP^UdQSfUWeOR>U?+<C'G1ZUMMRP0+%VUGAD@4]\HbU)LRQO@L1Z]ZPAXOE5]OYO67K$:9[EOePI[Ob@GcO@WRcB7^_RUf=8Z=LAA[\TaPJn`C8^[NS]?7YUTE\3Sg>K5aASd6L9X77Q,1;jAI)KL?cF7cJj?&bT,YR[NNfTYSM7UXKUo@^WSCQ5>7=BR$aOQc\U/=MB\EA[G_ZRMEC_QMVA.WKBRuOEK^^UJp[SN`ICBO(8NsuSPV<urBvWvDuTQaVD\RSt<wwVHn@5W_eaWuQQePCU:cG|G`~UqB8)3*VK^J>a5]ghTTK<rqooZUs9n[g]]gYDoI]_n^ZH\Cjn{s9eS\qkUGJYlBLldJf*~wXKIj}$\a_Z9ocWTX8FhLGQZBWL>R:H\=%RGL?nEIhG=cE[JGJhIW@nz\gT={l(nd;.^RlLKT.^LMXWUm^\LiMIXTN8\fWVX4<+P;IfXJgIk^[XqZH~[HgXrZ@dr0cd[cDH[_HwKc,T7MeFCVEpE``KGO^L,0+4hZeK9wx[NAvoEH0oeDgXZJ_NlW\zVNMypn2XRZJ[EkJpLmQaWHa<s.OU<N[RKYrFGyEnE<ZVFMuY>EW`~LOlhCgJ[qZf4YJn\@mL=hlYlZGdWlqXH3bJdOPY_Z4MXYOC[yY)Y\dYS$]_7S;\]pO}L~\_~GHM~]a:n_UM~lYq][[i5cZ]L~Wf]_U]o7wfTLH@nhXOkcTbQZK`CRbYMm[l%M/~xrsqu[pN~;~sa~`oI^M<7`ZYI2gH&>@eKQi]\W+}\iX^n^[ZSjJn-~~RHo`q>~Ek]_oH^o;iJXL~[YG~~q\[\nCe]InKkAZ2~gYk_IlmZMjYVl/Jf;~~i@WC6aV[g[_FYR.^O|[8YVLgK^LR:^q<sh7^`])~\Y[q]_T~fP~qoHY:~^ES5Z_qaqYAfgEZld/RH_~]^X^~R~O~Zc_Rp`Y~`f_~L[XogW3{_q7r\{HM~m$t]`kk(~dYk\[\[hJpj?6N2Z`ZS:Mk]H]Xq^q]qpYU]oMvTHXDk_QU:{y[[noVdVUHX]oJ\`\nOi_qL~_<~n$LNj<u`Io^_C~z^N~m,a]qN~wN~\_^qp\\8~_R~~q]UvH^N~fMxnaqqEt^onX)]ZIHaBGFkI~HmHZ\KrDj:~~\@~q^S~qq`qa~EqD[q_^[M~\[pKg_[\oIWomq[^A1<Om_[_~D]XDK~q]]AbJ$~~~qhmu~~~~~~~~~{qjjpz~~~~~eWfr_n_o[\]?aHo^p9~q`q]`e~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/3046/ccs/fwd np:i:11 rq:f:0.996917
  AAGCAGTGGTAATCAACGCAGAGTACGGGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATACGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATGCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTCGTAGGTTTGTGAGAAGGGAGAAGAAGTGGTTGAGAAGTTGGTGTTCCACAAGTTAAAGTAGACATACCTTTAGTACCTGTAAAGGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAGAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ~~[i{edU{[&Sj_Mf5WMlYxYbf\C~~~nOJ<EHeV1p6`4Ji[lQnEVQB0{~~_~:sYPmXgfp{j~arF{EOrLYWmn)VuM=wMgN]KxBX{]~=TEd8~cPSvh~FCgef^`/^X<M6}~T~`dsdoe<~~7~t+uR?hhO~W~dcD~~gN~m?~B~~ecwlfh~E~FPzxXfs~gqhpHu^TO_1~~@akJ~{n?}nQk`Rfg>}PwfOp8d~gFys=QZ~zRmvUk7bWd~W;`KdMhA^mqt?l?p^~P5gtwmpe_~ad{`MPgQW~~Z/~ps~t-;~{;_eGD|~s8keY_a\XJxS~~~~R~c_9H7ETLb8~^GYsP^JS~pd[dx_N~bSm>r~hr~dn`BlPs_gd~R~F~P~LRK\S~tR~~pzTa0y}~~~@~pg~Une~`oTc~?~|mZfNW~dN~~kem5~qT`gxi\_]TS~s~M}SX]g~5~~~~~eeS~ljeo>\OrFv^7uViUm~7~bquSZ0`ziS~sQ~s<~c~RX~^et`^ec~2mG~fG~mjJ~g~hfe~V~pq:nLn`tSU}Sb~bo~_M`dZbfy^~[.e~~S~Q~s7~x]E~^~?~sRZ~~L~}h8~~~dygiYUWVDS~j~ghFqgp~^~kcogv~L~d~Q~fSQdt{ac\~wAuSdSdTbbF_Hy~P[dxRs~:~~~dhlT`~Cu@vZ~a~NY}c=~?pc`XwE.q_@tXM~[~~T`a5AEy`sDo<m~~frvKoK_3KaxN~E{di~gs~U~?\XZYQbt&vuhK~~;vlO~x~Vtg[~~}f~b\~gmSlem>~ylzbZOF^TzQ~Gcec~~i~WoKQO~rF~~t&}~olCm_mT~h{e^BfuyeT`~g4~~~~f~eBkP~r\~~fxkZT~~Bk|gPO~~]@n^P~:\~_EMoKimbe`M~ydY_ifsYcPF@jAJ)T`]`>~d~Wz`__iTtR~Du8:sc%y3k~~uav]~Q~hsqo_sg~SbT~qg}EZ-~~ij>dz~e~ageua}H~~U~f\RH~W~l~eF~~T~E~rbM[~K'D(OHZ[erd3~~cNpjI\~gs~e@~Qvdcj[wB~d/\gQ~br}_S~I~gP~qxi~P~}iZ~f`xM|Cx~~fhD~P^ggi~cdrS~S~tgpe{dS{W~S~eZmcNw(qYUaqfe`Ssdlwu?3gB~~q~Fmb4u`Q|L~WgPc{F~p[~SB~~&~~PH~~\gl~Rq]u4Jp`@fodYenXFc}~~G~~~UjUfA~W`(~~f]~5~{g;~e-|~lbR~dd~fS~}hu~fpyd~=TauvPZ~Wl9kWh2KWt8nqefrdF~bz5~ulalQ|Mn[lGrOO~CdzhA]8xnU~BjnebsgT~^R~~f~]7jh_eaP;~CZcHrN~gsh~Tb[dezFua&`M[z~{YI?@Ngv|~~~~~~~~~~~~fbo{cM`PJLO5]Hukq:rbcaUiu~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/3046/ccs/rev np:i:11 rq:f:0.994978
  AAGCAGTGGTATCAACGCAGAGTACGGGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAAGGTCACATGGAGTAGGTGTTTAGGTGTGTCGAGAGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGTAGTCTGTGGGAAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTCGTAGGTTTGTGAGAAGGGAGAAGAAGTGGTTGAGAAGTTGGTGTTCCACAAGTTAAAGTAGACATACCTTTAGTACCTGTAAAGGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACTGGACGTCGTCGCCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  =~Ogmah/|vY^aP~IeVm^ML~gU+hgu}o7Y~euce~T~i~jMxP|b?;M:~nXg}I~sI~\\XSre_U~flTBO_Ia_N[ZLFko:DlS~{R<%QH2/U;0GHG'E^b$LF5gSAgy_K~o9LoTNnViZ)9WK$tcga>~hH~\vRAItw]<~\Dv8z}bc__BH~dfGPKdldojK?;cNtUd|fChS*iqNz~~C~yA~\X]lD~jY`J~`ce`K~dLe^RKLkafeJ~~hMRDiS\IkO/\`_D~b~[[M)nj``oGWyYZ_zf~d~.uwoLe\>~xE~~bUXy@~~fElNO^ve|Vw8~~glbhavnio[eb_BufYbVbhVcmgOOG^pQ~ZMc`f\ZrG?Eb^oZXReQUHy^sR}nQFbLVnPrSeDWo60U~~jK~gLLMY`CpebhaE~~vY~bp{^izTw5P+{`P4g^ucT^iE~ph?R<e`Gp(uwx~gbR9Mabc_l\@6Zq'x|LGVjd;~~lpUhW?vUBNWQxq@n[`Y@dlV><~eNl`QVg?R~yN~bN\OOZu8c;E]tI\1<ZK~aL~g~ec{aaZ_KocofSt;dk'SQ~~6_rbH~`{:\zhP~vA~]d:~wlU~`MS~_qVecVKIH:lRHpmX|bmeY~IbIqL;MV\b}KuWG{}__^`aV6VVGFECbOTOh2HX9XGL\AQPXeAc@~E_^nP7\PXf@Z_Lhj8LE93Z\J~L~VTt1JGFNecByZuj:bsWS|n?}J~pILQrQesV~lekMuUQmCX]:.6O2uTE~{BnX~\wc>~~~fcTM`IlaeIs+=e:Xdc]BgnB'Hpc^AAC+KGgo@9vU${pl949_gfuhuSgXgTScfT~Zgdse4~rebOwbMq:[]=l[BrpRT{bLcuqSbSUZRLZS~hRiceUyCvd>-F~`hR9;`xPb0|~g~][B~cSySJaGJQX[2S`d~e_I|^9{ch~4~|dKPZrtP~cfJ~caG_KtNp|cuPX+mWfn_c$cZeR9PejS]3jqs~h~^A~RbZzO9q~F^6[bN*v|ca`_S~\{nX~fW~~RC^JS~\g~qgP}aQbaU?y,b\%{YFqVV~dMrLcYHO07NlAYkXJrb_a?j/v}nddiB?ZoUPoWe{Swi~Yxv=~bcpy~K~fW|QS~?~yaPxdWbDzT\Q~GZR~M{cO~gTwjHk^~aefFqR~~J~eH~~I~~~<~~}d~sTq~lSB~_VGf]5NVa0|~~n/|{reE>lC~rfG~sTW{M~pfj}e(iIUc`Mk\SucHT*JbZNN`a];3WfveIQdn<tXMEyg~F~~_g~fS{U}A~~~vgNRpf~g~Q~f~ff~[civS~|`~go|he~SbsfDx\Su@a^Ugaet[rab~W~euj~daVcimepF~S%~~}~~}~~~~~~~~~~~~~~~yo`Z[aa`T~h~efeU~Ph}sV~af<Yg_q
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/3116/ccs/fwd np:i:7 rq:f:0.995734
  AAGCAGTGGTATCAACGCAGAGTACGGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAAGCACTAACGTGGTCATCAGACTGGTCTGCGCTATAATCTACGCAATAGAGGCACCAGCGGTCGTTGAAAGCCGAAGACGCTATTTCGGTGGCTCGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCCCGTACTCTGCGTTGATACCACTGCTTAAGCAGTGGTATCAACGCAGAGTACGGGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTGTGAGGCGCAAGGTACATGCTCTTACCCCACTCTCAGCACGTAGGGAGCGGAGTGTGGAAGACCAACAAGCCCGTCGCCTCTACCAAATACAGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAGAGACCTTAGGTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTACCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  f~hMnftC~Xpt^Z~_i`/e[eTB_3~~vw~dilMBnQ~fYC~qS~ivrs@kqc\O~n`~ErieuJ~~\dqR~n9:xzteP~SzibZMoFh~VeiW~e`~ee~V~Fb8~~dn=R}[]hdhuQ~b[b[AXlgO`~Z~sR*~l>lBbolir\uiriegW<oimIf>~jN~]h&r~~MsAeO~]8~QnLgA~oK~b]=n~jOhueqmnk[;__VMV~udF~pircgK@mA_k_i.~<^ZtiLoJYIfofZRbP~r`S~G~mee$\Cppp6N\GO`~iub/~>LhD~QAd^CjsW~cZp@@fteM~iU~uU{KMI~{bWAbeO~KCqdpe1xrb]]dkir\gD~tje`~euZ~sQ:go]eqh=~\ULheu\hq'vNlrOsiurq8VuXPvQPLrI~mEqH{brs^siq96B1~lLcqqSdV~RaFdtJlLhuX~uerq:lKVbuV~k^ndMT]dffHQlaYBcib+~qPJoX~_gFb@eP9UEcg8yi(~ibA|A;mgYcjcs\Y~~ePOJA`^hLg%zcRKay~~~~~~{xy|~~zxy}~~~~~~ecEWbaEriShQ~g[r]%jIfhp0asOtiei^pb1?13aXcSifc~Loierjq1~p\taLobierilerQ3=s~~dd~jrS~i_d\aChacL~N~:~~+~~xpdS~~R~iSBr^NpFa(nXWqMZisRr]tL~~SkcIpi8-d]S^.jWy~qirireV~Ze-OIngVbsSm?~A`ZOdm[diHo~p@kN~gbm4onv|l=~d_~OU~emUS~Z~uiuh[I~dgRa~W~s\UZ[d`sc`~j.~~h]FMZaFaplahp^y.gewY@Mp`otq}[~\~qQR{GsD9`h7~zn~MoC~wfdh.7+q~wg`fbn^F~tbL~x^n^gU\~_Jgu[a_Il}V~7dPE;~xb?|w_s+~_ZWNRI~__eH~eQLLYGTLcCvgq_EAzi=yp:{^LE~o+akjq6~VogU[,YGAn4Wbecmjmbmy2|uhrnGtqlX|jbNk68~[wl|\,uHRw[Yj~ishnizbc:y{H]~}Y~{D~~k~l`5ytYG~_U:jgY9~8pYo[Hmjuz{=ToltX~jeDPpX{tgvUvha~Y~ud`e~eijSG\QEUEYEvjLO~]~Y~mb?</vLX~zz^Kl-IC/g^mHoTr~Xl~Y{\_Qyao{AcTrXl*|\-~WWLU6B2Y9N3S)mffm_K~^_~kX~+W]rbPXN~<o]mMznhj}hT<dvCyX}=~~~~nZ%`QOTqdNH_kH~sX~\waDjC}GkIS~sBj`~{\U~~icm}Z~C{{\{V>~~l)~rH~dViRnR~i>j:iNzMz~<keL~`;~iU~M~pM~PuebZ~mYJm_[~Wf09eeGhW~enUAa\kWoWNWk;v=N~\eL/RBePTbNNj/~~hb~Jjw[YJcg]0MLe;bkWzPUjpIZZl5>c5{Ex74qK%[]El}yO}~tUi]mYVm[T~kPx\h`b>d-phlS6~|iXG]MMoY~W~qnKjL~wql~p>~~jO\~aZul\~|r}ipyan`c;[y~&e~d}]~eJGqj{/}gMnhUV~k~A{lcvnw\`knjjF~f~lqP&SfKSlfTzlnVk[t]rjnX~aJwapomp^ib_~E`~O~abUn_`ge~q\sJeEcW~hkT~~WWx$~~~~|qjnw~~~~~unmt~~~~~~~~~~~~vs~glhh{boaZ~rfoO=~|n~]mz~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/3116/ccs/rev np:i:7 rq:f:0.993861
  AAGCAGTGGTATCAACGCAGAGTACGGGGGGCGACAATTGTGGACCGTATGGACTCCATTATGCTGGACTCCTCGGGTCAACCGCTCTAAAGCGAAGTTGTTGGACAAACAGTTATGCGTAACTGTAAAGCAAGGTGCCCAAAGTAGACTGAGCGACAGTCGAAACCAGCCCCAATGAACAAGACGCCATTGCAAAACGTCTATACGCTACGGTCAAAGACGCTTCCACACCACATGCTCTCATGTAGCCTACCTTACGAAGAAATCGCACAAGTCGGTCGCCCAGCGGTGGCATATGTCTTGCCTAACGTTTCTAGACCGATCAGCCTCACGAGTAGCCTGCTTGTGGTGTTTATAGTTTACGCTAGTCCAATCTGTATCGTGCCGCTTGGTATGGCTATTGTCGGCCTGGATGCAAGCACTAACGTGGTCATCAGACTGGTCTGCGCTATAATCTACGCAATAGAGGCACCAGCGGTCGTTTGAAGCCGAAGACGCTATTTCGGTGGCTCGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCCCGTACTCTGCGTTGATACCACTGCTTAAGCAGTGGTATCAACGCAGAGTACGGGGCTTGTCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTGTGAGGCGCAAGGTACATGCTCTTACCCCACTCTCAGCACGTAGGGAGCGGAGTGTGGAAGACCAACAAGCCCGTCGCCTCTACCAAATACAGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATTACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAACATTCCGTAACTGAGTGGTCACGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCGTTCTTCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTACCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  C~]h]`0@wkVZdR~e_Wuduer]i4~wowp`_\gGy:~S\FytX~foqGDw\eqG~l1{OEVip3~rho6~rfE^I\hR~Y~dRYRY?~|ehP`~_Vxe_~Pxoh7~~_ccO~q.Zgb\d~hW2kJ~~Lge~Q~VKN~~@~hNF^boeoHV\<Isiteaed=~vU~[b6~~`UWS]Q~gBr_UN`CvbJ~Jd9~~|hN^c@R=dhdhsuhQupQK~~dte_i^~Vztg\Y~uit\baAfrivpOmULW~]sV~LvnRcJnNI~~rieeXba~bZSDgXbdGyb\WcDnaG~aflnYcnRV~PM|[S~ie>~{gEn9lU~fVriueW~\gefeucFpM6j\ch:eJC&=ANKpvSVk^F~~\eMbfl`WY~c~qjoOn[ph_SfY~eiV~PsGq`3yNmVO~drh?mF~[U~rGbhQ~eh\dkP~hcF?~TcmriZJjaDQ~qhZSSTiilZNnUcoWfdRP~VretD~dmM~sLdQqrgK,~kdb~KMnKam9XgdRnY(~~fA~gJw\jf=$orrrrsrmkklfZNGKRJA?K]mvy{~UNmp^n^VORMQnU\=[8}~n]Tmg^hSee_O~dr5j%rjUEMeLq^hQdZ_GOvX[WeP~fDNiGq_FriA~yY=J~bY%;RE=G8,VgaxHnIaw*~~ysi*~[U~g]`~eMtY~T~h`_bc=+WcnM:{}rRPFz~bDsndg=|~u~jdrO_9DibPXeIeEnPkWp>q\h^gco^gV6L]_T~NsSla(~~dRY`xcSnL^mhr_Cv4iZ_VQT>xgXhIfAn\iiq\bVZeQvKC~~~cdVBTVP\^dSGRqG~]CRfMdE(CP[Buap7pW~c|f)h'>zd@X^JGu@LRP=Y@PO9[EpakJ2ypgAvVan_lf;k\F~tRlIK~}Z~b~hN,uhY%n@@l=ukTcp3^.zesfJokNjjlPj]>SqJDLcB~l,f%d(=pmawblCpWwLpZIs>feiRtoRl\wq=lshYHs_cd/BaT\ZvAJW$5BCjFlPWY3~nfxph@ti^sejcb_Be~mB{X_pp?zsN~dK6~~~J{[?t`j]Gk-zr][enLFiTpg\U^GSFq]MHc]Br[\RQTVO~mgZfqca_ecZfO~fiQnaD?OF~NkD_GfQOgRFiUeVlV1i`GeclE~=w}DZU@pZd\T_NhiaclfkhYO}nioiK|X|^H]kdeh\Pj@z[P~[;Z(a]PRXQpSteqRvPSH[`[T~pho$2l\jwmc*~GD_Zag\Nf4~aP~ioZY~`~M~bC~b~T~ob>~}]ZgpF~L~qeqh<~~^Po|K~qYltWBUFZaYZOuMwv0tX$]cQ~l(9je.^F]QV2zVXV`gX~U|4ZMnedG~\VXP]gibGgpDbDhl1xfOgJ^%?T~gOi/rG=[b=BTQ]Bge`vQyref5uM.mN@\P~EOT]~LyqT~c3~X0w|U<oUgQl[PLJUST}sZlHmZclf8vxysIo|lbo^TWzUU+eUdO~B~hPEX<;rxmY:TT4TbB~iR`XJDWJP$0joxhDh].1XdWW}LtQ~~qOZ]6aO~$zlqnNrSZM1d_F~[~F_]qdW`%OQ~dt\cGPWdqQ=}nc^hQ^icsUrPvNX~7QDKRdbJNXmbObG~Ud?zdiL~~eYf$~~~~~~~~~{wy~~~~~~~~~~~~~~~~RNFsirh\bRbOi9oErW~uf_cU(t
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/3119/ccs/fwd np:i:6 rq:f:0.994411
  AAGCAGTGGTATCAACGCAGAGTACGGGGCATACTGCAAGACTTGTAGGCCCATGAATTACCCGCTTAGGCAATGGGTAGACCTTTCCTTGCCGCGTGGAACAAACCGCCATGAGTGTTTTACGTTTACGGTCGGCGACCGGAGTCACAGCGCGACCAACGGGGCCAGGCAAAGGCCCATAGGCCTTTTCCATCGGCACGCGACCGATTCCATCAAGTGTTAGGTGCAATCCCATTCGGGGACGGACACGCGAGAGCGTTAGTCGGCGCGTGCGCGGACTATTTAGCGAAGGTCGCCGATCGTTTGCCCGTAAAACTAACTGGCAAAAGCCTAAGTGCTGTTTCGGGTGCAATGGTATAACTTCCCACATTTAGCCGAATAGCGCCAACAGCGTTATTATTTGGAACCAAGCAGTGGGCGATGTCAGCGACAATTCCACTTTGGTAGAGGTCGTTCTTTTGTAGAAAACAATCTAACATAACTATGACACTTTCGGTAAATTCAACCACCTTTACCAGGGTCGTAAGTGGTCAAGCCACGCCGACCACTTCATAAGCATTGGTGAAATCGCATCGACACAATAAAAGTACACCAACCAGCAGAAAACAGGTACATATACAGTTTAACGACCTGGATCTAAGATGACTACAGTAGCATAGCCATAGAACATGGCACTGAAATATCGATGGGCGTAAAAGTGAACAACGCAGACGATGGATTACGACGCCAAGCCACTATAAATGCTAATTGAGTCGAAGAAGGTACTCCCTTTTTGGAACACAAGATATTGCAGAAGCGGGAATGAGGTTGATATTAACATCAAGTATCAACAGACGACCCTCAGAAGGGTGGTCTTTTAAAATGACAACGTACATTAAGATGCAGACAAACACTACTATGCTGGATGTGAAAATGTCATATGTGCGGCAAAAAATAGACGACATTTAAGAACCTAGCATTATAGGATGGAGTGTTGTATTAATTCACTCTAGAGTAATGGATCACGGTGCCAGAAACTAAGGTGGTGTAGGACTAGATGCAAGTAACAACGGTCGTACTAAAATCAGCTACGCGATCGCCGACTTAGAAGGCTGAGATGGAGAAACTTGTCTACTGGCAGACCTCACTATCTTTTAGGAAGGGTCACGAAGCGGCTGGAGTGATGGCTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAAACTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACAACTATATCAAATCGTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCCCGGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTTCTCTACATGTCCTGGGTGGAGGGGAGTTTCCTTGTATGGGTGGAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGGCGGTCATATGTGGGTATGACGGGTATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGACATCTCTAGGTCACCTAAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGGTACACGTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGGTGGTAGGTTACATCTATTTACTTCAAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCCGAACCATGAACGATGGATAGTAGACCGGGAAGACCAACGTTTTTTTTCAACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATACTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  [~FD^E_@zfMOX4yE[F_YP]d6VA~~~ZNMd\d.@5k]ODE}]he7w2nx]h]F~V~dD~{Z\Z~gO~\X~f6~y\L^bK|>x`Mx*JN/XW\]c8'>NZ3p_Ls^KS7e[%X`Y=y~~f\]>~~f\Q~h]O~\]I(]El,\d/cZP]\\F[MKgAr;=icP3kCMrNCbcNq.[`SVFMh'F;bafEfOWMFLLQPXNA@3o\RY~A~edFW~^hX0yOOyPEGB`b%=RMIp[$p[Y]FEB%ETK]YGd]NF[\A~P]h[BfIOI>c5W4B)]LZcN8SScEK<EbOuOZ[*eGeh\]9[eC7at^g<~~fEeFfDfCaEAr~{^JfeCdUE\ULEGz|[6~a3D[X~hO~U>UHeZFj6eVJW^Fyzg];|[/_Ld[X]=tGuZJX\^X~:Go:JmaP~NlKw4_HWOYc7}}VZbZc`R;dVgF`E}_~N~WMJ{b/~bBajT~neQ^qO%~~~PjKOB~~Y:Lql`nU~fpYN~eoCndm`[]G~fJU~ZBsvJ|^3C2Y>>p?~q[@~VFr~j7OqP~LhV~td7~LT~pLfB~giCUPJ_zYoq;~^Po>jLrg&=^~nbgPqtcWX\RGIEY<~zwdq\_YNrO~D~\ha/eC~~~esSrn[OorYXYd_hAq_KtPO]H{sT~PQLo2qXDjhqTpDVWgtpRestmdS~eb`V%,8)>G\I@\l;=pgMDmfdF`=gyOgtH~~~fZhVuB9uZfH`_Z>bQOR~\a~T[a.]`Q~J~c:f`2gWp)~~pecq4jLKcCIJ^eZreIrRyYWMh(~H@xy|xXz<wQO3.<_Y\L*`)JS_OiScL~~[utgZEsO~gqsqc~?YRYM<.Nfl.Xc<~ZUd<[^A0]nj9TWV|I~~mW~rP9~~fO~~~qP@b=~ehr[``5`WggZi7VRI1A*GER\Pg\WSIdhcZN~\rhth@~~qs`eLE_UDfqPa@~c*~~~~xr\eFbQnPqX~~Hee;~S~rP+^r_~FkrX~\rW~rhtgO~Qm[0nO~Zj4gerdWZgldlZlZX~rtd\OD|WPL~rg6~ZLm*~2pnQ~VgsrY~rgtsinAb9WwfNLqPK~aLil`dsUer/~~bKb\fLPh`QbR.[\aNhhpPb~rgH|0~ctg[gZrW~rdPq~eN~LWStqftV~Pph]5zm_Fds`te9~~~qEu<s(qFCbQbiR~Xb6~Y9Ot[cng\sUycZphYLYdshA~[dbWsd,mfM~n9~gdRefFbO'~mpnT~tb8~nlo0mm_joSepP4Rv;eSD}gsYWB~OgpGO,~nReY~ri\J~VdlW~oWE[V`EbfWlfZREn~Qrmda~iftleeOU~frqqPbON~kB^R;~PqhsY~tfb~4~~RsfHU\R]hnjcfra~9otfhc~Y~jUPqV~V~T~BPkXTeT~k_hb~X}FDqlbVrpb\T_Ptk+~~NN<~~hPcA3~~ndi`OiSW~m%de<~lS~;~y>u\x?8~~BT|iehK~~D~vUvlW_6~tH``AkOlnemDwp>mnrg?^7~~~[Zg\rfQ~~^l\lU]TWfnDdnD~~e3jeFvxiFfH~wEz]~io\rN~~[U~P~B}aMo=x}fD}X~thrL~~thshb~Fd6~t_BoGE~rbCjVleR*~mQOZe>5Lt~V-nOk9fsc0P4~~Zpio9c?ygse7~~~rK~}DG~rMwO~itT~a~qTshr\bV9oJ~~RmcK~V~tY~rg=~etW~cEU~]fkVdsfr\Y~tb^F~nM~~fitfK75yOWYaXOe3qmMs@=]76=TQ%imHt`YYQr]g3neG{~QraBP~\dicqlJN~YJX4ZaZK]~OarhrhpR6|oV}[N5~~rpd\a~PZf@~olfthr_s_laUk_Hp~K~mM~O_?ldZ'mF|kW8oi>bmMgPvnQrcT?lr3tjuugJp1~dgW_bgGOLi6^vQs~Pw:=y[goUNZfB~oXr8|jZU~lET~<~V\CXdsp,~}Eb>|b-~~bYacF~rhE{~dYgK~~rfa~hfqP~dcR~~hm2~~~H*dK|fN~C~ra~fc~fX'{cNgT~h,K&W[pPNwcPE>UuCoZgk?^>IP5=UN~ho0~Jt\Q%UMX`sG9?.?Edd[]*P^Hj~hGZXSRjNrgO~K~S,~cE~pLqmT~b~PVwT$mhoEtN~~ra?UX~qOW=p[\\pfV~]drQttfseuV~thscRh$~dWhr\ho3qiHp$xcPax~~~~~~~~~~~}ustvux~~~~~sgfYDP\MA5acc~hrtoOdE`[UeH~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/3119/ccs/rev np:i:6 rq:f:0.992635
  AAGCAGTGGTATCAACGCAGAGTACGGGGCAATACTGCAAGACTTGTAGGCCCATGAATTACCCGCTTAGGCAATGGGTAGACCTTTCCTTGCCGCGTGGAACAAACCGCCATGAGTGTTTTACGTTTACGGTCGGCGACCGGAGTCACAGCGCGACCAACGGGGCCAGGCAAAGGCCCATAGGCTTTTCCATCGGCACGCGACCGATTCCATCAAGTGTTAGGTGCAATCCCCATTCGGGACGGACACGCGAAGAGCGTTAGTCGGCGCGTGCGCGGGACTATTTAGCGAAGGTCGCCGATCGTTTGCCCGTAAAAACTAACTGGCAAAAGCCTAAGTTGCTGTTTCGGGTGCAATGGTATAACTTCCCACATTTAGCCGGAATAGCGCCAACAGCGTTATTATTTGGAACCAAGCAGTGGGCGATGTCAGCGACAATTCCACTTTGGTAGAGGTCGTTCTTTTGTAGAAAACAATCTAACATAACTATGACACTTTCGGTAAATTCACCACCTTTACCAGGGTCGTTAAGTGGTCAAGCCACGCCGACCACTTCATAAGCATTGGTGGAAATCGCATCGACACAATAAAAGTACACCAACCAGCAGAAAACAGGTACATATACAGTTTAACGACCTGGATCTAAGATGACTACAGTAGCATAGCCATAGAACATGGCACTGAATATCGATGGGCGTAAAAGTGAACAACGCAGACGATGGATTACGACGCCAAGCCACTATAAATGCTAATTGAGTCGAAGAAGGTACTCCTTTTTGGAACACAGATATGCAGAAGCGGGAATGAGGTTGATATTACATCAAGTATCAACAGACGACCTCAGAAGGGTGGTCTTTTAAAATGACAACGTACATTAAGATGCAGACAAACACTACTATGCTGGATGTGAAAAATGTCATATGTGCGGGCAAAAATAGACGACATTTAAGAACCTAGCATTATAGGATGGAGTGTTTGTATTAATTCACTCTAGAGTAATGGATCACGGTGCCAGAAACTAAGGTGGTGTAGGACTAGATGCAAGTAACAACGGTCGTACTAAAATCAGCTACGCGATCGCCGACTTAGAAGGCTGAGATGGAGAAAACTTGTCTACTGGCAGACCTCACTATCTTTTAGGAAGGTCACGAAGCGGCTGGAGTGATGGCTTAGTCTCAGCCACTGTCAACGGGAAGCGCGACGTTTATGGTCAATATAAACTAGCAGTTTAATCCGTATGGCGATCTTAGCGGATGTTACAGGATGGAGAAGATGACAAAGTAGAAGCTAGACAAACTATATCAAATCGTTGTGTGGTCTTAAACCGACACAGTAGCATTCATCGTTGGATGTGGAAGGTCACAGCCTCGTTGGAGGAGATACTACGGTCCCGCTTTTCGTGGGTGACAAAGGTCGCAAAGGTTTCCTTAGGGAGGTCGTTTCCCGGATCTTTATCTACATCTCCTGGGTGAAGGGGATGATCTTTCTCTACATGTCCTGGGTGGAGGGGAGTTTCCTTGTATGGGTGGGAACCCAACCCGCCGGTGAGGGTGAGTTACGGTCGGCGGTCATATGTGGGATATGACGGGTATGACGTCATAAATAGTCGTTGTCAAAATGGGAGGTGGAAGTCCTTACTGTAGTCACCCGTGAAGGTGGAGAACTGGCAGGACATCTCTAGGTCACCTAAACGTGCGAAGTGTGCGAAATTACCACCGTAAATTCGTCCTACTGAAAGTGCTTACGCATCTTGAGAGAGATTGCAGAGAGCCAGGTCAAATACATTGAGAAATCTGTATATGTACTTTGGTAACGCTCTAAGGTAGGTACACGTTTAGTGATATAAAAAGAAGGCGACGACGAACTTAAATTGTTAGAGCAGTTTATGGGTGGTAGGTTACATCTATTTACTTCAAACGCGGTGCCCTAGCCCACAAGCATTGCTTTGTAAAATTGTTGAAGGTAACTTGTAAAAGCCGAACATGAACGATGGATAGTAGACCGGGAAGACCAACGTTTTTTCACTACTCCGAAAGAACACACTGAAGGGAACGGTGTAGGTTCGGTGAGTCCGGGACTAGGTGTCCATGTCGGAGACCTCAGTGGTGACGTCCTCGTAGTATACTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  %a+DcWa<]=df]I~]XYTENJegP(cy|]&OPJZPYGW~\h_JgHegFr<YcXf\Un>h03v{DX,t[Lz]VadCyeQb-4Nl9v^MdAtUO{[QIQKfZ~\;liDbTN~gPZa<[ZGt~~h^\J~qZBM~g^M~^\b;Q8wIXbYh^hYGX\BeL|?X]<~~~P~eJdZ9Yo:z6~z^ehM~^<zbX=_'JN;Z\hZVTYR8UCcRYKaceGW|[>,>LV=id[\C^b?uatfFh]D~maHMnO\fSVXG9,DQCO[UcgKf]L}]JHDdF\XY5}~g^bd=UV_W^[UyM~gZG=kW5K\F7Vm[>~mVf,]btaZgF|(N7yB,t^pC:gNTvI$SYZg[4}p\,]LMV.Vxb,=2=`RaARzD~hJVA7YZfW:x.ZVf&aC/TI\MiZX[^ZM`=8\T2{H*ySwJv3yVVMOd8~~ZRJCCI/bF[EeIDkMlO}f\;bbJ}Lf\hMe;\[A}U/MAQHMMY3ziZ]Ipf^gX}EegV~]OeJ-OV4Y3{xXFcPP~|G|Zb;W`9b-WUHO}hA~o:]T0_XxE:;dbYV}\P~i\FN~\hO~h]H}Z^:X~[FK@yK|O:|C|~f^[VR2ACe^h]1sODpda\b[.H@lVl;zMY^U1$^xu[JDvHdX_ed9d^fCIrdV{D-MP~gK}`P[P>kWhg\cZffGeY`c0[^?MZ?ybKg\Z~]L\<\GdGdZ%ybfLVM9NChcGYg>p=F7WWGs36i[F]fFf^Yaf;|aBZbHZh^\O~Y~FLgfFNeQ%b`gYZ_BC&aEBZ>\YCj\UyM~gh]PPx2~obH:gHh]e^`[dPL&WY'I7`HKDpf@YOYN2g-`GMIH>M\@GY^Qt;Ybb^R~_e[O[GfO~g[/PF:2RR@,c[XH~~j<~~{PYL?PyY[gg^`FzY~\heD1bC_]0vbVaYPf]PeP[^gN~gPVKZ%|}}ff[OFfghg\gWW+`LF$z~~}ec-b^\cFE,stTeBCmP{Pg\^hW}MNfM~gPJwMEPF*LOG:VDyTS$x\fGPY6bYh\gY~K7kaf^h]:f9X<~bZ&|^\N8hH]5IkR\Uf7DHXb]Whg\]6HFMBR^Z~ZI}eLG=^^f>~~{bYh\]Ng^\^\gP][?gVaWFpIQTmId\dXh\e31Q,8&-D_\VyER^?KY`IwYg\`896-d\\c_^4~~wgLuIyMyQ]fGY6}V[I\-H8Z9>:A]9@]]$cg[N]f^h\OzfJ0C]SC\T=cT?vW2U\Cf_\?wbccG`%E.uaaX3gdZJdCWOU,v{?nbApZ7a9M~^\hcHCvgVYJ\5V[BU`Yh@khgJcfFX}[NN[fGEYMUgcWZ~\]Pb]g^'h\Z\LJLbK=_wO]\O~[PT\CP1BNT:TsN~\fHf\NTLOZ^hKzYaK^[:OM~he[Q@U9lLyQXIX`Z=hMDXF|L~hL~aAbO`YbMO7:^;Sm[GG~~~\C\%k^^A`]%]<B].2SYG^oM~D~iHb>qf5oUP1v^BZDegE~~I{FYEKdzhXYYd\L]XhM~g=s[J@Kb&ccZbg\gQ]FrU>RV_g^hg[P=}N'dbM8vc'oeXV3=lcAkJ\[ZF[>tr_*PPFzBadF}7fNB7U)NJ;aA[ef]h[F~g]=jQ]6nY9ec^eRa_[e1^m$P[dWJ\BfpLeO[gZVLWOcA~~fh\QXQ/oCd^5~zcS;bmcEk^=}Ws/]LsE{f^VDQe[P[QFi}Y9T1z9mT(MG22PYRNt^hIcN]SbEK\NfJcQ[OOh95~t][aZGX2J:J<0W]F@{aTuh@|hN~NOM{zDaYYQP~fcX<FAix`lPg^~kQcir\fXtMlMXbrdqQ~egWdn`seW~tJhYfH~~jUfnKj=IPM[~qgW3eospoJ?qh>~mMi]_~QPfpODKrUj4oB~[qQrhf*~[Vbree_f`)v~~idMnSwhftgNWOcP~g]~9q~\~b%noeqeiteF~~XY<~~pB~qtP~[~thqFe\r<~~Wf@~e&~~fdQA~IdM~~\pe8tfY]Asdhta~eQ:~~cUP~~~N~M.~cb~S{_T}ha~eY<~~yb7lb`~`eqfa~EHknTyspYIYrfrW~%~cc~ftV~S~gf8~~s~~gscVpde;saSg~eT~VrW_gZNa~?~~`~QR~re\qBuN~gSyUHl_qY~K~~[f\qCzXLhX~slJpiU~pgoY~pQqc.@tqgthfpF~Zc_\rdH`G`hr%~~~~~~~vrx~~~{tsw~~~|trx~~~~~~dbmrcVgrTheP~fpstV~q8mgf'~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/3147/ccs/fwd np:i:7 rq:f:0.992852
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCCTATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCCTAGTCCCGGACTCACCGAACCTACACCGTTCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCGGTCTACTATCCATCGTTCATGTTCGGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTGTGGGCTAGGGCACCGCGTTTTGAAGTAATAGATGTAACCTACACCCATAAACTGCTCTAAACAATTTAAGTTCGTCGTCGGCCTTCTTTTTATATCACTAACGTGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGAGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTTGACAACGACTATTTATGACGTCATACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAGGAAACTCCCTCCACCCAGGACATGTAGAGAAAGATCATCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACACGAAAAGCGGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCGGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCTAAAAGATAGTGAGGTCTGCCAGTAGACAAGTTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACACTCATCCTATAATGCTAGGTTCTTAAATGTCGTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTCTGCATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  Ar:GV<i>pQ]f9Kh7FJZY^]kIG%hllllllllllkfabgllllllllllk60r`Zb[Hm^G\^Kh^MY_L^>rKKjV^M]UJj=y\ZJWRNp[GK%nmn_Wf&^RKhBCXDF;\WPm.^U@2R6_HNh.yJWF5X`\e]YeHCl]KHe^]j\[PJ0mfVUYK\[jHgT;MO/m7Zc9T\<Z6h?{^lK][PHYSZ]cG*;6IcOSG8OS\9kX1ZZbIB^<PZ>cPe]I5kkYJNmb]E'WU@mmKo]2kkK^<xWKW:oom\LmYg,LIWY\X[kEb>wjD$Y6I_V\4n[Jo\HdFV4V7.CABmlMo]Y`J\lK\lJ&><|_lJ6iln]Jj\VKNLd?kIGi]k_6b][=r^j^J`EJXKlJ0S7dhYeYKWfQP45WTGAe[HMHDkk\j7@co\Z.aZMmKiB_5Y96>hbLlJkFF95VZWX]FYk7[RFKINPgJ^ZR^MoB2NSEmlZHKml;ukAlHnnG[7[D@97E8X5H9[?oo`JmJBJ&][]]\^k]k>~o\?x^\XaB`+[P7f]i4^G8hijZ^Fn[KH[hLV5cJBJ_9y^/pn8~w^=eJ[1IELcGY^Mn]:nm]E\^K\lJ]jY5x{\WG8X3*dtHDYWKj[K9w\<z[W1THjQmKoIL/hmm<Z0k;_K=j?&N3ld)k;p[2sy[ZU3$Ik/ZQFY%jf^:e^3sn^Nn[;K8]iGAY[<mm\^jK^i8ywC^JK2Ej^JqWNFj\l`\PdCbcVEH:XBml6fiJXG<hW6zi]=VJbGnh;t6llZJEH2REhmZWGE%RB?3TllZ4A[`X3z\kWVkHfHk<^k<mPgIZOKmE'WVZ\*GRU=r_GZb:n.OEF8i\NlZW8lI6N6T[jKKmEmmOm\]:H4?H<ENL[W2jl\[?[k[QJ<QiJU]]J_kJnKIAVj\lJNgJIlKk9z`g<}pY_AS:G[?|XHU=kZZaEQ.J3XC6>WJ_oAogJp\Jo]F5llJiJ^m[K8dFaAneI[fJZKZKO`+fxYMq]`J]FUKmJLd<\M;b`\>gKi8]HV=i^]:{YK[lHEUZM=b6j&e=hk[SXLVX\FZ=mh9l\;f8YW]FF:2G\,nnUKe;Y[e5UHMV?|\mIf=PZkJKkFXWXJ\J]h^\7a[]2ook^Y_S:ZK.vZ&[G\mJG6OFI]UIh^\k0xm\G^;uL8n[m`[9mlJnM\8K>eIj[Kj?xZ[mMJd2QBX]\l[3l^m?kk]7IUIL>R+]j-yT_kHOTPIh^NoJmIG=3L^jGjJ[U3`J5mnnhF+qX;H*\X^l\H8[MmmlB6<KW7h_\H7b6Zl\UL\CRi\kKlII`iK[mLmhXfC5BKU]fJK=dnM1lll[F4]]2`eZk6m\^NphGZh8mW:k[`hNHOmY4h]kLRgZhGNl>yoJ^[^3xgYA'7h[H&c%fMcY_\[j<m-jlldGk\GY\1y\fIOiHGMJoJQmLlKOH&Fem]gIT[G_<KW=iKYkIGf?dW9uIBI\jKnXIFKR\MmEYC9j^gQIW)`c^SH[_Z^QnmJ^]lY'\j]^mJf%PJa:kIUFIo[Ho\l`\WI^kINhIX\f=j\Fe^J[9F*iQIlHi^fQf]d$,Hi\6nnA'T[Jo'=:lKml\kKJ:nnf]4dNk\lK\Wa9FVXMhj<x^<vQjl\I[P`iI7h[lKmkIMlKYlNnJLlZ6>b[8L]9I[M'aikJsl>nn'WXMnkGNmRnn^?|\FfRZUKQEKj\H\o`gH[mZ[YL[2Aim`HRNI4V]QGNmJGY3xhE_[?hCk[SkIg<cPkGg'WGhLOJ\h8[7yeK@@YI]mNp^j4i/HclNmWAh?\JnF9n<jKXJi]MlJJmImCooi]k:sgQo[JlHgH4ZFXD[IH4gZH)OJG]\J9J\lHK\J0l`kG0x]\_m`]5nnnk[H6VXH-ZcJ]RlKLmH\X+l9kI\KoGnnhQ\i3qqKJKJ^EIH\<vKZKkOmM\KjMj:?D1S\i>f\k(fIENml9qqN7]m\DV9dm/_LLK_mW7[;XHTZHLd^H]HD\\<|[L]@W*g\QZ?jfKjCm_1uSlmD1MmNh0ylf[4K:iK&ZGXGo\l\^Gk-u=d_CY*tWG>dVNCniJ\l4ma>,R:g:ZSKhG?cEmm[Ll=B&FXHAaH>c?a=^hJRSKh$0Vp^^hG;znG^TKClnl4\MjLZP1?]9xo[KPl\lJZ^GI^]l^l[*z{d[g)KeHf[I]_m]^l^6a54U[Jjj
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/3147/ccs/rev np:i:6 rq:f:0.993731
  AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCCTATACTACGAGGACGTCACCACTGAGGTCTCCGACATGGACACCTAGTCCCGGACTCACCGAACCTACACCGTTCCCTTCAGTGTGTTCTTTCGGAGTAGTGAAAAAACGTTGGTCTTCCCGGTCTACTATCCATCGTTCATGTTCGCTTTTACAAGTTACCTTCAACAATTTTACAAAGCAATGCTTGTGGGCTAGGCACCGCGTTTTGAAGTAAATAGATGTAACCTACCACCCATAAACTGCTCTAACAATTTAAGTTCGTCGTCGCCTTCTTTTTATATCACTAACGATGTACCTACCTTAGAGCGTTACCAAAGTACATATACAGATTTCTCAATGTATTTGACCTGGCTCTCTGCAATCTCTCTCAAGATGCGTAAGCACTTTCAGTAGGACGAATTTACGGTGGTAATTTCGCACACTTCGCACGTTTAGGTGACCTAGAGATGTCCTGCCAGTTCTCCACCTTCACGGGTGACTACAGTAAGGACTTCCACCTCCCATTTGACAACGACTATTTATGACGTCAACCCGTCATACCCACATATGACCGCCGACCGTAACTCACCCTCACCGGCGGGTTGGGTTCCACCCATACAAGGAAACTCCCCTCACCCAGGACATGTAGAGAAAGATCATCCCCTTCACCCAGGAGATGTAGATAAAGATCCGGGAAACGACCTCCCTAAGGAAACCTTTGCGACCTTTGTCACCCACGAAAAGCGGACCGTAGTATCTCCTCCAACGAGGCTGTGACCTTCCACATCCAACGATGAATGCTACTGTGTCGGTTTAAGACCACACAACGATTTGATATAGTTGTCTAGCTTCTACTTTGTCATCTTCTCCATCCTGTAACATCCGCTAAGATCGCCATACGGATTAAACTGCTAGTTTATATTGACCATAAACGTCGCGCTTCCCGTTGACAGTGGCGGAGACTAGCCATCACTCCAGCCGCTTCGTGACCTTCCTAAAAGATAGTGAGGGTCTGCCAGTAGACAAGTTTCTCCATCTCAGCCTTCTAAGTCGGCGATCGCGTAGCTGATTTTAGTACGACCGTTGTTACTTGCATCTAGTCCTACACCACCTTAGTTTCTGGCACCGTGATCCATTACTCTAGAGTGAATTAATACAACCACTCCATCCTATAATGCTAGGTTCTTAAATGTCGTCTATTTTTGCCGCACATATGACATTTTCACATCCAGCATAGTAGTGTTTGTCTGCATCTTAATGTACGTTGTCATTTAAAAGACCACCCTTCTGAGGTCGTCTGTTGATACTTGATGTAATATCAACCTCATTCCCGCTTCTGCAATATCTGTGTTCCAAAAAGGAGTACCTTCTTCGACTCAATTAGCATTTATAGTGGCTTGGCGTCGTAATCCATCGTCTGCGTTGTTCACTTTTACGCCCATCGATATTTCAGTGCCATGTTCTATGGCTATGCTACTGTAGTCATCTTAGATCCAGTCGTTAAACTGTATATGTACCTGTTTTCTGCTGGTTGGTGTACTTTTATTGTGTCGATGCGATTTCCACCAATGCTTATGAAGTGGTCGGCGTGGCTTGACCACTTACGACCCTGGTAAAGGTGGTGAATTTACCGAAAGTGTCATAGTTATGTTAGATTGTTTTCTACAAAAGAACGACCTCTACCAAAGTGGAATTGTCGCTGACATCGCCCACTGCTTGGTTCCAAATAATAACGCTGTTGGCGCTATTCGGCTAAATGTGGGAAGTTATACCATTGCACCCGAAACAGCACTTAGGCTTTTGCCAGTTAGTTTTACGGGCAAACGATCGGCGACCTTCGCTAAATAGTCCCGCGCACGCGCCGACTAACGCTCTCGCGTGTCCGTCCCGAATGGGGATTGCACCTAACACTTGATGGAATCGGTCGCGTGCCGATGGAAAAGGCCTATGGGCCTTTGCCTGGCCCCGTTGGTCGCGCTGTGACTCCGGTCGCCGACCGTAAACGTAAAACACTCATGGCGGTTTGTTCCACGCGGCAAGGAAAGGTCTACCCATTGCCTAAGCGGGTAATTCATGGGCCTACAAGTCTTGCAGTATGCCCCGTACTCTGCGTTGATACCACTGCTT
  +
  EjH[>GM/a\Y_\`o[K[hFHGMi\$ha]SUX`hiaYTU[cdeikibZTQQ[WQTJX/9NZ\Kj[F`8gm]>T>LIn\V]Jo>tK[^HeKo\l^/qj\T9jFL9_,eD<{l\`\lKlJLmLm[k\lNnL@f+kF?k[iEMI48AUV7Pl\>jbHIMKLJ:lmnnm\L?k-^XX?Z7iZ.c[\Kj]^l`Npl^YDOm\jKGAlZ5R2dfkh]^k;E\lKmMmYLd[[k-ZjdP\QnmK\_oI6[0F<]8jl]^k+tK\CcIGH2]:IH_mKZA^m^jIW\J^:lJm^lMoXDpo\;Qjm\^J\[S[Ll[9?+jbPcI>kXF\[;_VL4\'b?,_ccb_VKVPFLMS`UD'ECB_HcSFFN6\]1I2?EId`>P6aJ9EJQZ2O2J>K?5(IIRUSVbS?R^:dYDdAeN*kSUSQ>F@TRPRPPP@K=>UbDdUDADTUa2R`S>C6>Z/NX9odTC3a2_DU@5N@5]R@a-_]SCRN>\QIcP?@[SD4^MC1L@@^D[@JBMEG9C@B^R0B`aEHbSCC[aFS/51BQ1TWV@dLUaT_EBQ_3ZLRJdEb`2bO-Yd`$CPCdTVbTELOF^=[XKSEdTEDO='<b^EVTaUa<bbIKWLMM6bH_DEbDd@^EQ,BGPU`<EZWNKDb%PQ(b>;T2h\;_AP39XDJ@KQCa8a-a\AJ._RFQ0]>c_G:gcTaUDTECJB@X^BVCT`B5bbbFbP`?ae`8oPEPR3T\3`U?cbF]UEb*jD=aa=DN?PI:bbU>S;lMbbGb3[`CTEd+@6RG4TUa?cc`>B5baODQ*b_9^/D]DU`BRUBdUHeUb>Cb+lRVCWCdAdIdEb]GMUCgVbRBVUEVbUETUaTQ?O/?R:R0__UbDdEb]SE:SbSE_*\I1N2R?K<GJCSGUaDTFbMF_R0N]1GSaUTIcTUEfaUCgUBRCaRJ@Eb@UUIc(8COEEbJUaP9V\7P7G,RR@TQaE5abTV]9XEKHeQT@ccTDT>B>BQEb?cbD98$U>\@R-WP)Q:/9SWaDAdaWT_IN1R]C4YBPA]PEVFb.U<[EbU2ccW2PW[EVDV$iCDQUC1TGBF`DcSCaD3aaSUEbaSUTT`3GQJdSU'EEDT4bTFbBN0M0OJ0RT3a8bbZFBQaTEdE]B5X+5aaTHbDTaTR2NB<A`UMO^&^]EbIa^A9ZcSC5]PLC]BRDdUEbaHbaTSKL`DdBAAUa-MFc@F;>\&IZ6Q9FGAE`D^US\.CR.]%JIcSHbMbbTDQTDTUT`)YUR95G\2SZ?^B_UDdT`1aaaSLEOAGeKBT`W`DSSEBC*NJDUTU1=^US;bRcKB0^QAHXDUT`.<<;bbaE`4`_?ccIdSVEb+kTT4:1L5&@Ea2^Q?<4^<<UUbTLSUQGGeWQaHb>c\DTIdTWDUQa0CQUSDUDHM3]-`ccD8oa2>BAa9U*FbSD`FBRTdIdLBTK:ddaUlJ]/eWNk<h[H^[HWKkHJkkWVJ^[JI\KQfJNbZl\?iVUXFIDjpl^\Jo^lGnn\lJ^KNnlW>M^[;jO;xG]l^HVJiZW5WhJL[jA>OmfFTJMsi'ZIH?j5jjYWF5h]j8KLjNi_J2kofW7I\Y:f1O*_YG]d\=mmmjMgK[IK[JnI6[Kn4k[LllNp_oJJ]DmkMGLlL^9]XF;x\H^>z[ChHWJml\QokE7aDnn^>>$Bll7n[:oI6]l;UUi=fFFPdFMAM]l^WKNmlXK/^T4]:853IV`PJj\KmePG[c]Jm)gPOGRJmIng:G4sZiMX.XNIVCIn[W\\JCmnl]^J[AE9cPjL]2_k7Lm^KQX)WXLMm>s\HXJQOl\?|[L,gbTJ^3td^mK3jj^lMsk?kI\lCnj7@kaGUHVh]Omk;tT>XSTH=hjKOmjK4knnk\'__\@oo\JkQ[1lK<Q:V=?NH[^@ofJi8KAn`2EGXOJIOIKjIWZL]mN>SQBKZKZH_GOFZ9^?mmI]m\1p|yjEeJ\lKmK8l\j[AkJnY2iLk]\?v^ZK[K9HKi3a]0vJjmW&NIPYk]7{Z:jDie7Lj4=h<^ObJCM/oXNHMJ[;548m\]=i;v^GJIgKkNnJ^Emm[IJ4mmm\gGEOjI<`\=i@[R:AeMkkKIF%GJ\f0cDki-t9F4Q<qkW3WJKm^NmI\4|{`^m?VPP^7{_7d_j]LlIKZ>kI[XH[Q`J-mnD9IU\KYNI[95W:Q<iLnO\]J\Dm
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/3151/ccs/fwd np:i:10 rq:f:0.999126
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGAGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAGTAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  ~~n~~~~x~~~~vO~~cvr~~v~u~_~~~~z~y~vf~~~x~~~w~{~~~~q~q~k~~X~~~rv@~~x~~~r~~~~u~c~vX~~\~~~~~~j~~r~~w~~~<~~~~A~~~~x~y~x~y~~~~zb~~f~~~~v~~~x~x~:~~k~~~v~G~~t~2~~~~~^~{z~~a~~~~s~y~~~{q~~~~~~r~z~w~~~~~~~~U~~~x~f~~c~~`w~~v\~~~~~a~~~~~~~~~v~~u~~x~~`~~~~~a~v~~~f~}t~R~~~~Jp~A~+~~~w~~~~~~yz~~h~~f~~L~~N~C~~~G~~~c~~c~f~~~~u~~@~i~~~~~~q~~~~~~_~~~~|a~~d~~D~~~g~~'~~~~~~x~b~`v~U~~~x~~w]w~s~~~|~O~~~~~y~~~x~~~~~~e~~~~~~G~~~~~tx~~~~~~~c~W~~~S~~f~~I~~~~{~X~~~d~~~u~~~f~-~~~~e{~~1~~~~z~p~~nz~|~~~~~~~~u~q~~~~t~~~~~~~~x~~~~~~~w~z~e~_~~t~~~c~[~~~~R~~~~~q~~~ry~~~~~~~~e~~~b~~y~~~~~~~~w~~~~~~~p3~~T~~~r~~~~~~A~~~~~u~z~~D~~R~~~M~~c~~~~~~d~~~a~~|t~~s~~x~~m~~~~@~~~~{~~j~zrv~~V~~~~~~~~~^~y~~~~t{~~~~Q~~a~~~~~~u~x~~~~~~e~F~~e~[~~W~~~d~~~c~quo~~x~~~[~~rf~~tt~~~~~~~~~~\~~o~~~~ts~I~q~b~y~w~x~~x~~`~~~r~~~~~~u~~v~~e~~~~~|~w~~~X~~x~~d~c~~~~A~~~~o~~~~~p;n~k~~~~~~~v~~~v~~~~~~~~~~~~~d~~9~~~.~~~~X~w~c~~~~~~~~~~~~~~%~~~`~~~~d~~G~~{~~~~~~j~~~~v~~~~u~s~{q~~~f~Z~~~~~u~sw{~~~~wx~~~~~~x~~~~~U~b~~~~~~~vq~~s~rx~~~~:~~~~~~~~j~~~O~y~~~~~W~~~~x~Q~~~~~~\~~~~~~~~~~Q~~s~~~~o~~~V~~r~~~~~~~~x~~~~~~h~+~~~~mu~~~7~~~~~~~~~j~~~~~~~~k~~\~~y~~i~~m~o~~~~l~~i~~~~~~~~~~~K~~~p~~~~~w}~y~~~Wz~~c~~T~~~~~~s~~x~~p~d~~~~~~~~~~~~~~~~~~~~~v~~i~~~~~~a~vq~~~~~~~U~~c~~~g~~~~~~~~~}~~~~~~~~~~~~4~~~~_~~~~~~~~~~~o~~~~~~~~~r~~a~~~~~~~~~~~~~~~m~~Q~~~a~~~~~~~~~~~mm~~~_~~~~~~t~~~G~~~l~~~~~~~~~~~~~~~l~~~v~~m~~~~~[~~~~~~~~~~~~m~~~~~~~~|~p~}~~~t~q~~@~~~~t~~~~~c~~~~~(~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}x~l~~~~~~~~~~u~F~~gh~~
  @m150825_055401_42161_c100844482550000001823159012311525_s1_p0/3151/ccs/rev np:i:11 rq:f:0.999437
  AAGCAGTGGTATCAACGCAGAGTACGGGGTGAGGCTTGTCCGCGAGTGTCAACCGGGTTTTACAAAGGAGAACTTCCAACATCAGTGTATGGGATGTTTCAAACACCCCCAGAGACGGAGACAATAGTGTGGTCACGTACATTTAGGAAGATAAAAATAACAACAACAGAAGGTACAAGAGTTGGTTACTCTCAGTCCCATTCCCAACACATCACTGAGAAGTATAGAGCCTAGTGGTCATTAGAAGGTCAACATGGAGTAGGTGTTTAGGTGTGTCGGAGGGCAGAAACCAACGAAAGAAAGGAAACGATCAACACTTATATAGTGTCCTGTCGGGCCCAAATCCTAAGAGACCTTAGGTTTACCACATTAGTACTAAACAGCCTGTTGTATACCGTGAGCCCCCACTTCGATCTGTAAATTGGTAATCCCTTGTAAAACCTCATCTCCAAAAACAGTATACGCAGGTACAGCTGATGTGATCCTCTCTACTAGTCTTCTCTGAGGAACCATGAGATGGATAGTGGGGGACCTGAGTCATACTAGGGTAACTTCTTATATGGTGACATCACTCCTACCGTAGAGGGGGGACGGTAGTCTGTGGGAAATCTACCCTAGTGAAGAAAGGTAAGAGAATGTCTGAACATTACCTGTAGACGAAGGTACTCTCAGAACAACTACTCTCACATACGGAAAGGTTTGGGTCCTTGGTCAAAGGACTTTACTGACTCTGCAGACGATGAATATCTGAACCAACACTACTATCAAAGATGTTCGACTAGACCTCTCGTGGTAGGGCCTGGAAGTCAAAAGACTTCTCTATGGGTACTAGGTAGGTAGTTAGAGTACGGTCCCTGGGGTGTCTCAGAGTCGAACGTTCGGGGGAAGTTCCTAAACATGTTAGGATGTTATGATAACAAGTCCAAACGTGGACGTCGTCGCTGTCACCTCTCGGAACACTAGCTGAGGTGGCTTAAAAACATTCCGTAACTGAGTGGTCACCGGGGGTGAAACATGCTGAGGGTTCTACCTTAACGGGAAGGTGAAACTCTCCAATGTCTTTGAAAGGACTAGTTGAGATAACCCAAACCGAATCCGGAGGAAGAGGAGAACTTGGAAAACGTTGTACGACGTCATTAATAACGATTCCGTTCTTCCCGTTCGTGTCTATAAGGATATTCTTTCATTGCGAAGGTAAGCCCTTTTGGGTCTAGATACGGACTATACTCAAAAACCCACAGACCTTCCACTTGGAGTTGTTTTAGGAGACGGAGTAGTAGAGAAAACTTGTGGCACCTTCCCAGTCGGTTCCCTACAGACTCTCCTTAGTAGCTCCTAAGATCGTCGAGTTACACGACGACATTGTTCCGACTGACGTAGAGGCATTACTTTAGTAAAAAAAAAAAAAAAAAAAAAAAAAAAAGTACTCTGCGTTGATACCACTGCTT
  +
  x~vy~~uc~~~~~y~~~c~~~~~~~J~~oe~~s~~Z~v~S~~|~~~~~I~c~e~[~~9~~~~~x~~a~~~~~|v~t~r~~~~y~|{|~~~T~~~~~M~~~>~~~~J~~~~~~~~z~h~~|~~~~~~~~~s^~~~~~~J~~~;~~~c~g~~~[P~~~~~E~NT~~?~~~~x~f~~~~s~~~y>~Q~g~~|~~a~~~~\~~~t~g~~L~L~~~~~~~{~~~~~~~~r~|~~y~~~~~s~~~~K~~~~~d~_~g~~~~f~o~p~d~~~X~~~d~~~~~r~Q~~N~v|~{N~~w~~~~~P~~~y~~t~Q~~~~~~bt~~~~q~~r~p~~~~~v~~~t~E~~T~~;~r_w~~p~~~~~v~q~~d~[~~oO~~~~}~~~En~~k~~~~~y~~~q~ws~~~i~~u~~~K~~~~~~a~~~~~ypx~u~~5~w~km~oa~~d~~~I~~~t~F~~~~~c~N~~~~~~y~kjo~~~~i~~~~\y~~n~~t~~~So~~~~~d~~~~P~|M~~t~\i~>~~~i~~sz~~~~x~~~~~~4~~~~~z~~~~~r~~n~~~~P~~~w~~r~zo~~~~l_~vy~~~~~~~tu~~~z~~~~~~2~~~~~~~g~V~4~~~~~d~~`~~`~~~e~~~~~~~}~~k~~P~~n~}~~v~~~t~~~G~~~n~~{~~~~~f~~{s~K~V~~~~~~~zf~~|~{\~~t~~~~~~o~~u~P~~c~f~~T~~~c~I~u~u~x~~g~~~C~~~~~~~~~~]vy~y~~~~~xu~s~~~~~y~v~i~z~~_~~~~~~U~~~~d~`~~_~zp~|~v~byF~~pb~n~Y~~x~~V~~~d^~[~~~e~~u~~~~~~uf~~~~~~~t~~~y~~~~u~~~~~~~rd~~e~~~5~~~~sr~~~~xfx~{~w~~~d~~@~~~~~~~t~c~~n~~~~~~e~~s~~~~,~zX~~~T~~z~{~d~[~~~shk~~uqXc~~d~~~~sy~e~v~~~r~b~~~~~~v~~~~p~r?~xb~B~~~~w~&~a~~~1~~~w~|~A~b~~Z{=~~~~~~O~~~~^y~~c~K~~Z~~~~b~~~v~~F~~n~q~~~S~~~~~sb~~~~~d~U~~~Y~~h~~~~~|a~~~~~oo~E~~K~~g~O~~m^~o~~v~~~~~n~~~~~~a~d~f~~~~{t~|~~~~~{~u~~a~~~~r~_~~r~t~wp~~M~g~~y]~~{u~~~~~z~~v~~o~c~~C~~~~d~~~|~~v~tf~~T~~;~~~V~~~~Z~~~~~~g~~~~~B~~r~7~~~~R~~~~~{~`~9~u~~~O~c~n~~~x<~~~~e~~~~~j~~}~~~~~~~c:~~~~>~~od~{~u~:~Y~~~~~~d~r~f~~~~~~}~~t~~e~a~~~C~~~~{~~y~~~~~~~~~~yQ~~~~~L~}Hm~~P~~s~X~e~~~~~~~~~~~0~~~o~~~G~~~~_'~~~~~~~~~~~~~~~~~~~~~~~~~~jd~~eM~xb~~T~~~r~{~~~~~~z~
