package Config::Model::Dpkg::Control::Source::StandardVersion ;

use 5.10.1;

use Mouse;
extends 'Config::Model::Value';

# Debian only module
use Lintian::Data;
use Lintian::Profile;

# Given the initialisation required for Lintian::Data, using compute
# to extract the default value from Lintain is scary: I'd rather avoid
# running this code several times in an eval as done by compute
my $profile = Lintian::Profile->new ('debian');
Lintian::Data->set_vendor($profile);
my $standards = Lintian::Data->new('standards-version/release-dates', qr/\s+/);
my @std_list = $standards->all();

sub _fetch_std {
    goto &_fetch_std_no_check;
}

sub _fetch_std_no_check {
    return $std_list[0];
}

__PACKAGE__->meta->make_immutable;

1;

=head1 NAME

Config::Model::Dpkg::Control::Source::StandardVersion - Standard-Version model

=head1 SYNOPSIS

 Internal use for DPkg model

=head1 DESCRIPTION

This class is derived from L<Config::Model::Value>. Its purpose is to
provide a default value for C<Standard-Version> parameter using Lintian library.

=head1 AUTHOR

Dominique Dumont, ddumont [AT] cpan [DOT] org

=head1 SEE ALSO

L<Config::Model>,
L<Config::Model::Value>,
