#!/bin/sh

set -e

generate_file() {
    cat <<EOF
// Code generated by go generate; DO NOT EDIT.
package raftutil

import "github.com/hashicorp/nomad/nomad/structs"

var msgTypeNames = map[structs.MessageType]string{
EOF

    cat ../../nomad/structs/structs.go \
        | grep -A500 'MessageType = iota' \
        | grep -v -e '//' \
        | awk '/^\)$/ { exit; } /.*/ { printf "  structs.%s: \"%s\",\n", $1, $1}'

    echo '}'
}

generate_file > msgtypes.go

gofmt -w msgtypes.go
