# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._notification_hubs_management_client_enums import *


class AdmCredential(msrest.serialization.Model):
    """Description of a NotificationHub AdmCredential.

    :param client_id: The client identifier.
    :type client_id: str
    :param client_secret: The credential secret access key.
    :type client_secret: str
    :param auth_token_url: The URL of the authorization token.
    :type auth_token_url: str
    """

    _attribute_map = {
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
        'auth_token_url': {'key': 'properties.authTokenUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        auth_token_url: Optional[str] = None,
        **kwargs
    ):
        super(AdmCredential, self).__init__(**kwargs)
        self.client_id = client_id
        self.client_secret = client_secret
        self.auth_token_url = auth_token_url


class ApnsCredential(msrest.serialization.Model):
    """Description of a NotificationHub ApnsCredential.

    :param apns_certificate: The APNS certificate. Specify if using Certificate Authentication
     Mode.
    :type apns_certificate: str
    :param certificate_key: The APNS certificate password if it exists.
    :type certificate_key: str
    :param endpoint: The APNS endpoint of this credential. If using Certificate Authentication Mode
     and Sandbox specify 'gateway.sandbox.push.apple.com'. If using Certificate Authentication Mode
     and Production specify 'gateway.push.apple.com'. If using Token Authentication Mode and Sandbox
     specify 'https://api.development.push.apple.com:443/3/device'. If using Token Authentication
     Mode and Production specify 'https://api.push.apple.com:443/3/device'.
    :type endpoint: str
    :param thumbprint: The APNS certificate thumbprint. Specify if using Certificate Authentication
     Mode.
    :type thumbprint: str
    :param key_id: A 10-character key identifier (kid) key, obtained from your developer account.
     Specify if using Token Authentication Mode.
    :type key_id: str
    :param app_name: The name of the application or BundleId. Specify if using Token Authentication
     Mode.
    :type app_name: str
    :param app_id: The issuer (iss) registered claim key. The value is a 10-character TeamId,
     obtained from your developer account. Specify if using Token Authentication Mode.
    :type app_id: str
    :param token: Provider Authentication Token, obtained through your developer account. Specify
     if using Token Authentication Mode.
    :type token: str
    """

    _attribute_map = {
        'apns_certificate': {'key': 'properties.apnsCertificate', 'type': 'str'},
        'certificate_key': {'key': 'properties.certificateKey', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'key_id': {'key': 'properties.keyId', 'type': 'str'},
        'app_name': {'key': 'properties.appName', 'type': 'str'},
        'app_id': {'key': 'properties.appId', 'type': 'str'},
        'token': {'key': 'properties.token', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        apns_certificate: Optional[str] = None,
        certificate_key: Optional[str] = None,
        endpoint: Optional[str] = None,
        thumbprint: Optional[str] = None,
        key_id: Optional[str] = None,
        app_name: Optional[str] = None,
        app_id: Optional[str] = None,
        token: Optional[str] = None,
        **kwargs
    ):
        super(ApnsCredential, self).__init__(**kwargs)
        self.apns_certificate = apns_certificate
        self.certificate_key = certificate_key
        self.endpoint = endpoint
        self.thumbprint = thumbprint
        self.key_id = key_id
        self.app_name = app_name
        self.app_id = app_id
        self.token = token


class BaiduCredential(msrest.serialization.Model):
    """Description of a NotificationHub BaiduCredential.

    :param baidu_api_key: Baidu Api Key.
    :type baidu_api_key: str
    :param baidu_end_point: Baidu Endpoint.
    :type baidu_end_point: str
    :param baidu_secret_key: Baidu Secret Key.
    :type baidu_secret_key: str
    """

    _attribute_map = {
        'baidu_api_key': {'key': 'properties.baiduApiKey', 'type': 'str'},
        'baidu_end_point': {'key': 'properties.baiduEndPoint', 'type': 'str'},
        'baidu_secret_key': {'key': 'properties.baiduSecretKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        baidu_api_key: Optional[str] = None,
        baidu_end_point: Optional[str] = None,
        baidu_secret_key: Optional[str] = None,
        **kwargs
    ):
        super(BaiduCredential, self).__init__(**kwargs)
        self.baidu_api_key = baidu_api_key
        self.baidu_end_point = baidu_end_point
        self.baidu_secret_key = baidu_secret_key


class CheckAvailabilityParameters(msrest.serialization.Model):
    """Parameters supplied to the Check Name Availability for Namespace and NotificationHubs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: Required. Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The sku of the created namespace.
    :type sku: ~azure.mgmt.notificationhubs.models.Sku
    :param is_availiable: True if the name is available and can be used to create new
     Namespace/NotificationHub. Otherwise false.
    :type is_availiable: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'is_availiable': {'key': 'isAvailiable', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        is_availiable: Optional[bool] = None,
        **kwargs
    ):
        super(CheckAvailabilityParameters, self).__init__(**kwargs)
        self.id = None
        self.name = name
        self.type = None
        self.location = location
        self.tags = tags
        self.sku = sku
        self.is_availiable = is_availiable


class Resource(msrest.serialization.Model):
    """Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The sku of the created namespace.
    :type sku: ~azure.mgmt.notificationhubs.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.sku = sku


class CheckAvailabilityResult(Resource):
    """Description of a CheckAvailability resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The sku of the created namespace.
    :type sku: ~azure.mgmt.notificationhubs.models.Sku
    :param is_availiable: True if the name is available and can be used to create new
     Namespace/NotificationHub. Otherwise false.
    :type is_availiable: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'is_availiable': {'key': 'isAvailiable', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        is_availiable: Optional[bool] = None,
        **kwargs
    ):
        super(CheckAvailabilityResult, self).__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.is_availiable = is_availiable


class DebugSendResponse(Resource):
    """Description of a NotificationHub Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The sku of the created namespace.
    :type sku: ~azure.mgmt.notificationhubs.models.Sku
    :param success: successful send.
    :type success: float
    :param failure: send failure.
    :type failure: float
    :param results: actual failure description.
    :type results: object
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'success': {'key': 'properties.success', 'type': 'float'},
        'failure': {'key': 'properties.failure', 'type': 'float'},
        'results': {'key': 'properties.results', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        success: Optional[float] = None,
        failure: Optional[float] = None,
        results: Optional[object] = None,
        **kwargs
    ):
        super(DebugSendResponse, self).__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.success = success
        self.failure = failure
        self.results = results


class ErrorResponse(msrest.serialization.Model):
    """Error response indicates NotificationHubs service is not able to process the incoming request. The reason is provided in the error message.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class GcmCredential(msrest.serialization.Model):
    """Description of a NotificationHub GcmCredential.

    :param gcm_endpoint: The FCM legacy endpoint. Default value is
     'https://fcm.googleapis.com/fcm/send'.
    :type gcm_endpoint: str
    :param google_api_key: The Google API key.
    :type google_api_key: str
    """

    _attribute_map = {
        'gcm_endpoint': {'key': 'properties.gcmEndpoint', 'type': 'str'},
        'google_api_key': {'key': 'properties.googleApiKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        gcm_endpoint: Optional[str] = None,
        google_api_key: Optional[str] = None,
        **kwargs
    ):
        super(GcmCredential, self).__init__(**kwargs)
        self.gcm_endpoint = gcm_endpoint
        self.google_api_key = google_api_key


class MpnsCredential(msrest.serialization.Model):
    """Description of a NotificationHub MpnsCredential.

    :param mpns_certificate: The MPNS certificate.
    :type mpns_certificate: str
    :param certificate_key: The certificate key for this credential.
    :type certificate_key: str
    :param thumbprint: The MPNS certificate Thumbprint.
    :type thumbprint: str
    """

    _attribute_map = {
        'mpns_certificate': {'key': 'properties.mpnsCertificate', 'type': 'str'},
        'certificate_key': {'key': 'properties.certificateKey', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mpns_certificate: Optional[str] = None,
        certificate_key: Optional[str] = None,
        thumbprint: Optional[str] = None,
        **kwargs
    ):
        super(MpnsCredential, self).__init__(**kwargs)
        self.mpns_certificate = mpns_certificate
        self.certificate_key = certificate_key
        self.thumbprint = thumbprint


class NamespaceCreateOrUpdateParameters(Resource):
    """Parameters supplied to the CreateOrUpdate Namespace operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The sku of the created namespace.
    :type sku: ~azure.mgmt.notificationhubs.models.Sku
    :param name_properties_name: The name of the namespace.
    :type name_properties_name: str
    :param provisioning_state: Provisioning state of the Namespace.
    :type provisioning_state: str
    :param region: Specifies the targeted region in which the namespace should be created. It can
     be any of the following values: Australia East, Australia Southeast, Central US, East US, East
     US 2, West US, North Central US, South Central US, East Asia, Southeast Asia, Brazil South,
     Japan East, Japan West, North Europe, West Europe.
    :type region: str
    :ivar metric_id: Identifier for Azure Insights metrics.
    :vartype metric_id: str
    :param status: Status of the namespace. It can be any of these values:1 = Created/Active2 =
     Creating3 = Suspended4 = Deleting.
    :type status: str
    :param created_at: The time the namespace was created.
    :type created_at: ~datetime.datetime
    :param updated_at: The time the namespace was updated.
    :type updated_at: ~datetime.datetime
    :param service_bus_endpoint: Endpoint you can use to perform NotificationHub operations.
    :type service_bus_endpoint: str
    :param subscription_id: The Id of the Azure subscription associated with the namespace.
    :type subscription_id: str
    :param scale_unit: ScaleUnit where the namespace gets created.
    :type scale_unit: str
    :param enabled: Whether or not the namespace is currently enabled.
    :type enabled: bool
    :param critical: Whether or not the namespace is set as Critical.
    :type critical: bool
    :param data_center: Data center for the namespace.
    :type data_center: str
    :param namespace_type: The namespace type. Possible values include: "Messaging",
     "NotificationHub".
    :type namespace_type: str or ~azure.mgmt.notificationhubs.models.NamespaceType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'metric_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'region': {'key': 'properties.region', 'type': 'str'},
        'metric_id': {'key': 'properties.metricId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'service_bus_endpoint': {'key': 'properties.serviceBusEndpoint', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
        'scale_unit': {'key': 'properties.scaleUnit', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'critical': {'key': 'properties.critical', 'type': 'bool'},
        'data_center': {'key': 'properties.dataCenter', 'type': 'str'},
        'namespace_type': {'key': 'properties.namespaceType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        name_properties_name: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        region: Optional[str] = None,
        status: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        updated_at: Optional[datetime.datetime] = None,
        service_bus_endpoint: Optional[str] = None,
        subscription_id: Optional[str] = None,
        scale_unit: Optional[str] = None,
        enabled: Optional[bool] = None,
        critical: Optional[bool] = None,
        data_center: Optional[str] = None,
        namespace_type: Optional[Union[str, "NamespaceType"]] = None,
        **kwargs
    ):
        super(NamespaceCreateOrUpdateParameters, self).__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.name_properties_name = name_properties_name
        self.provisioning_state = provisioning_state
        self.region = region
        self.metric_id = None
        self.status = status
        self.created_at = created_at
        self.updated_at = updated_at
        self.service_bus_endpoint = service_bus_endpoint
        self.subscription_id = subscription_id
        self.scale_unit = scale_unit
        self.enabled = enabled
        self.critical = critical
        self.data_center = data_center
        self.namespace_type = namespace_type


class NamespaceListResult(msrest.serialization.Model):
    """The response of the List Namespace operation.

    :param value: Result of the List Namespace operation.
    :type value: list[~azure.mgmt.notificationhubs.models.NamespaceResource]
    :param next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Namespaces.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NamespaceResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NamespaceResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(NamespaceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NamespacePatchParameters(msrest.serialization.Model):
    """Parameters supplied to the Patch Namespace operation.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The sku of the created namespace.
    :type sku: ~azure.mgmt.notificationhubs.models.Sku
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        super(NamespacePatchParameters, self).__init__(**kwargs)
        self.tags = tags
        self.sku = sku


class NamespaceResource(Resource):
    """Description of a Namespace resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The sku of the created namespace.
    :type sku: ~azure.mgmt.notificationhubs.models.Sku
    :param name_properties_name: The name of the namespace.
    :type name_properties_name: str
    :param provisioning_state: Provisioning state of the Namespace.
    :type provisioning_state: str
    :param region: Specifies the targeted region in which the namespace should be created. It can
     be any of the following values: Australia East, Australia Southeast, Central US, East US, East
     US 2, West US, North Central US, South Central US, East Asia, Southeast Asia, Brazil South,
     Japan East, Japan West, North Europe, West Europe.
    :type region: str
    :ivar metric_id: Identifier for Azure Insights metrics.
    :vartype metric_id: str
    :param status: Status of the namespace. It can be any of these values:1 = Created/Active2 =
     Creating3 = Suspended4 = Deleting.
    :type status: str
    :param created_at: The time the namespace was created.
    :type created_at: ~datetime.datetime
    :param updated_at: The time the namespace was updated.
    :type updated_at: ~datetime.datetime
    :param service_bus_endpoint: Endpoint you can use to perform NotificationHub operations.
    :type service_bus_endpoint: str
    :param subscription_id: The Id of the Azure subscription associated with the namespace.
    :type subscription_id: str
    :param scale_unit: ScaleUnit where the namespace gets created.
    :type scale_unit: str
    :param enabled: Whether or not the namespace is currently enabled.
    :type enabled: bool
    :param critical: Whether or not the namespace is set as Critical.
    :type critical: bool
    :param data_center: Data center for the namespace.
    :type data_center: str
    :param namespace_type: The namespace type. Possible values include: "Messaging",
     "NotificationHub".
    :type namespace_type: str or ~azure.mgmt.notificationhubs.models.NamespaceType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'metric_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'region': {'key': 'properties.region', 'type': 'str'},
        'metric_id': {'key': 'properties.metricId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'service_bus_endpoint': {'key': 'properties.serviceBusEndpoint', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
        'scale_unit': {'key': 'properties.scaleUnit', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'critical': {'key': 'properties.critical', 'type': 'bool'},
        'data_center': {'key': 'properties.dataCenter', 'type': 'str'},
        'namespace_type': {'key': 'properties.namespaceType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        name_properties_name: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        region: Optional[str] = None,
        status: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        updated_at: Optional[datetime.datetime] = None,
        service_bus_endpoint: Optional[str] = None,
        subscription_id: Optional[str] = None,
        scale_unit: Optional[str] = None,
        enabled: Optional[bool] = None,
        critical: Optional[bool] = None,
        data_center: Optional[str] = None,
        namespace_type: Optional[Union[str, "NamespaceType"]] = None,
        **kwargs
    ):
        super(NamespaceResource, self).__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.name_properties_name = name_properties_name
        self.provisioning_state = provisioning_state
        self.region = region
        self.metric_id = None
        self.status = status
        self.created_at = created_at
        self.updated_at = updated_at
        self.service_bus_endpoint = service_bus_endpoint
        self.subscription_id = subscription_id
        self.scale_unit = scale_unit
        self.enabled = enabled
        self.critical = critical
        self.data_center = data_center
        self.namespace_type = namespace_type


class NotificationHubCreateOrUpdateParameters(Resource):
    """Parameters supplied to the CreateOrUpdate NotificationHub operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The sku of the created namespace.
    :type sku: ~azure.mgmt.notificationhubs.models.Sku
    :param name_properties_name: The NotificationHub name.
    :type name_properties_name: str
    :param registration_ttl: The RegistrationTtl of the created NotificationHub.
    :type registration_ttl: str
    :param authorization_rules: The AuthorizationRules of the created NotificationHub.
    :type authorization_rules:
     list[~azure.mgmt.notificationhubs.models.SharedAccessAuthorizationRuleProperties]
    :param apns_credential: The ApnsCredential of the created NotificationHub.
    :type apns_credential: ~azure.mgmt.notificationhubs.models.ApnsCredential
    :param wns_credential: The WnsCredential of the created NotificationHub.
    :type wns_credential: ~azure.mgmt.notificationhubs.models.WnsCredential
    :param gcm_credential: The GcmCredential of the created NotificationHub.
    :type gcm_credential: ~azure.mgmt.notificationhubs.models.GcmCredential
    :param mpns_credential: The MpnsCredential of the created NotificationHub.
    :type mpns_credential: ~azure.mgmt.notificationhubs.models.MpnsCredential
    :param adm_credential: The AdmCredential of the created NotificationHub.
    :type adm_credential: ~azure.mgmt.notificationhubs.models.AdmCredential
    :param baidu_credential: The BaiduCredential of the created NotificationHub.
    :type baidu_credential: ~azure.mgmt.notificationhubs.models.BaiduCredential
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'registration_ttl': {'key': 'properties.registrationTtl', 'type': 'str'},
        'authorization_rules': {'key': 'properties.authorizationRules', 'type': '[SharedAccessAuthorizationRuleProperties]'},
        'apns_credential': {'key': 'properties.apnsCredential', 'type': 'ApnsCredential'},
        'wns_credential': {'key': 'properties.wnsCredential', 'type': 'WnsCredential'},
        'gcm_credential': {'key': 'properties.gcmCredential', 'type': 'GcmCredential'},
        'mpns_credential': {'key': 'properties.mpnsCredential', 'type': 'MpnsCredential'},
        'adm_credential': {'key': 'properties.admCredential', 'type': 'AdmCredential'},
        'baidu_credential': {'key': 'properties.baiduCredential', 'type': 'BaiduCredential'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        name_properties_name: Optional[str] = None,
        registration_ttl: Optional[str] = None,
        authorization_rules: Optional[List["SharedAccessAuthorizationRuleProperties"]] = None,
        apns_credential: Optional["ApnsCredential"] = None,
        wns_credential: Optional["WnsCredential"] = None,
        gcm_credential: Optional["GcmCredential"] = None,
        mpns_credential: Optional["MpnsCredential"] = None,
        adm_credential: Optional["AdmCredential"] = None,
        baidu_credential: Optional["BaiduCredential"] = None,
        **kwargs
    ):
        super(NotificationHubCreateOrUpdateParameters, self).__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.name_properties_name = name_properties_name
        self.registration_ttl = registration_ttl
        self.authorization_rules = authorization_rules
        self.apns_credential = apns_credential
        self.wns_credential = wns_credential
        self.gcm_credential = gcm_credential
        self.mpns_credential = mpns_credential
        self.adm_credential = adm_credential
        self.baidu_credential = baidu_credential


class NotificationHubListResult(msrest.serialization.Model):
    """The response of the List NotificationHub operation.

    :param value: Result of the List NotificationHub operation.
    :type value: list[~azure.mgmt.notificationhubs.models.NotificationHubResource]
    :param next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of NotificationHub.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NotificationHubResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NotificationHubResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(NotificationHubListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NotificationHubPatchParameters(Resource):
    """Parameters supplied to the patch NotificationHub operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The sku of the created namespace.
    :type sku: ~azure.mgmt.notificationhubs.models.Sku
    :param name_properties_name: The NotificationHub name.
    :type name_properties_name: str
    :param registration_ttl: The RegistrationTtl of the created NotificationHub.
    :type registration_ttl: str
    :param authorization_rules: The AuthorizationRules of the created NotificationHub.
    :type authorization_rules:
     list[~azure.mgmt.notificationhubs.models.SharedAccessAuthorizationRuleProperties]
    :param apns_credential: The ApnsCredential of the created NotificationHub.
    :type apns_credential: ~azure.mgmt.notificationhubs.models.ApnsCredential
    :param wns_credential: The WnsCredential of the created NotificationHub.
    :type wns_credential: ~azure.mgmt.notificationhubs.models.WnsCredential
    :param gcm_credential: The GcmCredential of the created NotificationHub.
    :type gcm_credential: ~azure.mgmt.notificationhubs.models.GcmCredential
    :param mpns_credential: The MpnsCredential of the created NotificationHub.
    :type mpns_credential: ~azure.mgmt.notificationhubs.models.MpnsCredential
    :param adm_credential: The AdmCredential of the created NotificationHub.
    :type adm_credential: ~azure.mgmt.notificationhubs.models.AdmCredential
    :param baidu_credential: The BaiduCredential of the created NotificationHub.
    :type baidu_credential: ~azure.mgmt.notificationhubs.models.BaiduCredential
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'registration_ttl': {'key': 'properties.registrationTtl', 'type': 'str'},
        'authorization_rules': {'key': 'properties.authorizationRules', 'type': '[SharedAccessAuthorizationRuleProperties]'},
        'apns_credential': {'key': 'properties.apnsCredential', 'type': 'ApnsCredential'},
        'wns_credential': {'key': 'properties.wnsCredential', 'type': 'WnsCredential'},
        'gcm_credential': {'key': 'properties.gcmCredential', 'type': 'GcmCredential'},
        'mpns_credential': {'key': 'properties.mpnsCredential', 'type': 'MpnsCredential'},
        'adm_credential': {'key': 'properties.admCredential', 'type': 'AdmCredential'},
        'baidu_credential': {'key': 'properties.baiduCredential', 'type': 'BaiduCredential'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        name_properties_name: Optional[str] = None,
        registration_ttl: Optional[str] = None,
        authorization_rules: Optional[List["SharedAccessAuthorizationRuleProperties"]] = None,
        apns_credential: Optional["ApnsCredential"] = None,
        wns_credential: Optional["WnsCredential"] = None,
        gcm_credential: Optional["GcmCredential"] = None,
        mpns_credential: Optional["MpnsCredential"] = None,
        adm_credential: Optional["AdmCredential"] = None,
        baidu_credential: Optional["BaiduCredential"] = None,
        **kwargs
    ):
        super(NotificationHubPatchParameters, self).__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.name_properties_name = name_properties_name
        self.registration_ttl = registration_ttl
        self.authorization_rules = authorization_rules
        self.apns_credential = apns_credential
        self.wns_credential = wns_credential
        self.gcm_credential = gcm_credential
        self.mpns_credential = mpns_credential
        self.adm_credential = adm_credential
        self.baidu_credential = baidu_credential


class NotificationHubResource(Resource):
    """Description of a NotificationHub Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The sku of the created namespace.
    :type sku: ~azure.mgmt.notificationhubs.models.Sku
    :param name_properties_name: The NotificationHub name.
    :type name_properties_name: str
    :param registration_ttl: The RegistrationTtl of the created NotificationHub.
    :type registration_ttl: str
    :param authorization_rules: The AuthorizationRules of the created NotificationHub.
    :type authorization_rules:
     list[~azure.mgmt.notificationhubs.models.SharedAccessAuthorizationRuleProperties]
    :param apns_credential: The ApnsCredential of the created NotificationHub.
    :type apns_credential: ~azure.mgmt.notificationhubs.models.ApnsCredential
    :param wns_credential: The WnsCredential of the created NotificationHub.
    :type wns_credential: ~azure.mgmt.notificationhubs.models.WnsCredential
    :param gcm_credential: The GcmCredential of the created NotificationHub.
    :type gcm_credential: ~azure.mgmt.notificationhubs.models.GcmCredential
    :param mpns_credential: The MpnsCredential of the created NotificationHub.
    :type mpns_credential: ~azure.mgmt.notificationhubs.models.MpnsCredential
    :param adm_credential: The AdmCredential of the created NotificationHub.
    :type adm_credential: ~azure.mgmt.notificationhubs.models.AdmCredential
    :param baidu_credential: The BaiduCredential of the created NotificationHub.
    :type baidu_credential: ~azure.mgmt.notificationhubs.models.BaiduCredential
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'registration_ttl': {'key': 'properties.registrationTtl', 'type': 'str'},
        'authorization_rules': {'key': 'properties.authorizationRules', 'type': '[SharedAccessAuthorizationRuleProperties]'},
        'apns_credential': {'key': 'properties.apnsCredential', 'type': 'ApnsCredential'},
        'wns_credential': {'key': 'properties.wnsCredential', 'type': 'WnsCredential'},
        'gcm_credential': {'key': 'properties.gcmCredential', 'type': 'GcmCredential'},
        'mpns_credential': {'key': 'properties.mpnsCredential', 'type': 'MpnsCredential'},
        'adm_credential': {'key': 'properties.admCredential', 'type': 'AdmCredential'},
        'baidu_credential': {'key': 'properties.baiduCredential', 'type': 'BaiduCredential'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        name_properties_name: Optional[str] = None,
        registration_ttl: Optional[str] = None,
        authorization_rules: Optional[List["SharedAccessAuthorizationRuleProperties"]] = None,
        apns_credential: Optional["ApnsCredential"] = None,
        wns_credential: Optional["WnsCredential"] = None,
        gcm_credential: Optional["GcmCredential"] = None,
        mpns_credential: Optional["MpnsCredential"] = None,
        adm_credential: Optional["AdmCredential"] = None,
        baidu_credential: Optional["BaiduCredential"] = None,
        **kwargs
    ):
        super(NotificationHubResource, self).__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.name_properties_name = name_properties_name
        self.registration_ttl = registration_ttl
        self.authorization_rules = authorization_rules
        self.apns_credential = apns_credential
        self.wns_credential = wns_credential
        self.gcm_credential = gcm_credential
        self.mpns_credential = mpns_credential
        self.adm_credential = adm_credential
        self.baidu_credential = baidu_credential


class Operation(msrest.serialization.Model):
    """A NotificationHubs REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.notificationhubs.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft.NotificationHubs.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Invoice, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list NotificationHubs operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of NotificationHubs operations supported by the Microsoft.NotificationHubs
     resource provider.
    :vartype value: list[~azure.mgmt.notificationhubs.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PnsCredentialsResource(Resource):
    """Description of a NotificationHub PNS Credentials.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The sku of the created namespace.
    :type sku: ~azure.mgmt.notificationhubs.models.Sku
    :param apns_credential: The ApnsCredential of the created NotificationHub.
    :type apns_credential: ~azure.mgmt.notificationhubs.models.ApnsCredential
    :param wns_credential: The WnsCredential of the created NotificationHub.
    :type wns_credential: ~azure.mgmt.notificationhubs.models.WnsCredential
    :param gcm_credential: The GcmCredential of the created NotificationHub.
    :type gcm_credential: ~azure.mgmt.notificationhubs.models.GcmCredential
    :param mpns_credential: The MpnsCredential of the created NotificationHub.
    :type mpns_credential: ~azure.mgmt.notificationhubs.models.MpnsCredential
    :param adm_credential: The AdmCredential of the created NotificationHub.
    :type adm_credential: ~azure.mgmt.notificationhubs.models.AdmCredential
    :param baidu_credential: The BaiduCredential of the created NotificationHub.
    :type baidu_credential: ~azure.mgmt.notificationhubs.models.BaiduCredential
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'apns_credential': {'key': 'properties.apnsCredential', 'type': 'ApnsCredential'},
        'wns_credential': {'key': 'properties.wnsCredential', 'type': 'WnsCredential'},
        'gcm_credential': {'key': 'properties.gcmCredential', 'type': 'GcmCredential'},
        'mpns_credential': {'key': 'properties.mpnsCredential', 'type': 'MpnsCredential'},
        'adm_credential': {'key': 'properties.admCredential', 'type': 'AdmCredential'},
        'baidu_credential': {'key': 'properties.baiduCredential', 'type': 'BaiduCredential'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        apns_credential: Optional["ApnsCredential"] = None,
        wns_credential: Optional["WnsCredential"] = None,
        gcm_credential: Optional["GcmCredential"] = None,
        mpns_credential: Optional["MpnsCredential"] = None,
        adm_credential: Optional["AdmCredential"] = None,
        baidu_credential: Optional["BaiduCredential"] = None,
        **kwargs
    ):
        super(PnsCredentialsResource, self).__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.apns_credential = apns_credential
        self.wns_credential = wns_credential
        self.gcm_credential = gcm_credential
        self.mpns_credential = mpns_credential
        self.adm_credential = adm_credential
        self.baidu_credential = baidu_credential


class PolicykeyResource(msrest.serialization.Model):
    """Namespace/NotificationHub Regenerate Keys.

    :param policy_key: Name of the key that has to be regenerated for the Namespace/Notification
     Hub Authorization Rule. The value can be Primary Key/Secondary Key.
    :type policy_key: str
    """

    _attribute_map = {
        'policy_key': {'key': 'policyKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        policy_key: Optional[str] = None,
        **kwargs
    ):
        super(PolicykeyResource, self).__init__(**kwargs)
        self.policy_key = policy_key


class ResourceListKeys(msrest.serialization.Model):
    """Namespace/NotificationHub Connection String.

    :param primary_connection_string: PrimaryConnectionString of the AuthorizationRule.
    :type primary_connection_string: str
    :param secondary_connection_string: SecondaryConnectionString of the created AuthorizationRule.
    :type secondary_connection_string: str
    :param primary_key: PrimaryKey of the created AuthorizationRule.
    :type primary_key: str
    :param secondary_key: SecondaryKey of the created AuthorizationRule.
    :type secondary_key: str
    :param key_name: KeyName of the created AuthorizationRule.
    :type key_name: str
    """

    _attribute_map = {
        'primary_connection_string': {'key': 'primaryConnectionString', 'type': 'str'},
        'secondary_connection_string': {'key': 'secondaryConnectionString', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_connection_string: Optional[str] = None,
        secondary_connection_string: Optional[str] = None,
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        key_name: Optional[str] = None,
        **kwargs
    ):
        super(ResourceListKeys, self).__init__(**kwargs)
        self.primary_connection_string = primary_connection_string
        self.secondary_connection_string = secondary_connection_string
        self.primary_key = primary_key
        self.secondary_key = secondary_key
        self.key_name = key_name


class SharedAccessAuthorizationRuleCreateOrUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to the CreateOrUpdate Namespace AuthorizationRules.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Properties of the Namespace AuthorizationRules.
    :type properties: ~azure.mgmt.notificationhubs.models.SharedAccessAuthorizationRuleProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'SharedAccessAuthorizationRuleProperties'},
    }

    def __init__(
        self,
        *,
        properties: "SharedAccessAuthorizationRuleProperties",
        **kwargs
    ):
        super(SharedAccessAuthorizationRuleCreateOrUpdateParameters, self).__init__(**kwargs)
        self.properties = properties


class SharedAccessAuthorizationRuleListResult(msrest.serialization.Model):
    """The response of the List Namespace operation.

    :param value: Result of the List AuthorizationRules operation.
    :type value: list[~azure.mgmt.notificationhubs.models.SharedAccessAuthorizationRuleResource]
    :param next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of AuthorizationRules.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SharedAccessAuthorizationRuleResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SharedAccessAuthorizationRuleResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SharedAccessAuthorizationRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SharedAccessAuthorizationRuleProperties(msrest.serialization.Model):
    """SharedAccessAuthorizationRule properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param rights: The rights associated with the rule.
    :type rights: list[str or ~azure.mgmt.notificationhubs.models.AccessRights]
    :ivar primary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype primary_key: str
    :ivar secondary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype secondary_key: str
    :ivar key_name: A string that describes the authorization rule.
    :vartype key_name: str
    :ivar claim_type: A string that describes the claim type.
    :vartype claim_type: str
    :ivar claim_value: A string that describes the claim value.
    :vartype claim_value: str
    :ivar modified_time: The last modified time for this rule.
    :vartype modified_time: str
    :ivar created_time: The created time for this rule.
    :vartype created_time: str
    :ivar revision: The revision number for the rule.
    :vartype revision: int
    """

    _validation = {
        'primary_key': {'readonly': True},
        'secondary_key': {'readonly': True},
        'key_name': {'readonly': True},
        'claim_type': {'readonly': True},
        'claim_value': {'readonly': True},
        'modified_time': {'readonly': True},
        'created_time': {'readonly': True},
        'revision': {'readonly': True},
    }

    _attribute_map = {
        'rights': {'key': 'rights', 'type': '[str]'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'claim_type': {'key': 'claimType', 'type': 'str'},
        'claim_value': {'key': 'claimValue', 'type': 'str'},
        'modified_time': {'key': 'modifiedTime', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'str'},
        'revision': {'key': 'revision', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        rights: Optional[List[Union[str, "AccessRights"]]] = None,
        **kwargs
    ):
        super(SharedAccessAuthorizationRuleProperties, self).__init__(**kwargs)
        self.rights = rights
        self.primary_key = None
        self.secondary_key = None
        self.key_name = None
        self.claim_type = None
        self.claim_value = None
        self.modified_time = None
        self.created_time = None
        self.revision = None


class SharedAccessAuthorizationRuleResource(Resource):
    """Description of a Namespace AuthorizationRules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The sku of the created namespace.
    :type sku: ~azure.mgmt.notificationhubs.models.Sku
    :param rights: The rights associated with the rule.
    :type rights: list[str or ~azure.mgmt.notificationhubs.models.AccessRights]
    :ivar primary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype primary_key: str
    :ivar secondary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype secondary_key: str
    :ivar key_name: A string that describes the authorization rule.
    :vartype key_name: str
    :ivar claim_type: A string that describes the claim type.
    :vartype claim_type: str
    :ivar claim_value: A string that describes the claim value.
    :vartype claim_value: str
    :ivar modified_time: The last modified time for this rule.
    :vartype modified_time: str
    :ivar created_time: The created time for this rule.
    :vartype created_time: str
    :ivar revision: The revision number for the rule.
    :vartype revision: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'primary_key': {'readonly': True},
        'secondary_key': {'readonly': True},
        'key_name': {'readonly': True},
        'claim_type': {'readonly': True},
        'claim_value': {'readonly': True},
        'modified_time': {'readonly': True},
        'created_time': {'readonly': True},
        'revision': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'rights': {'key': 'properties.rights', 'type': '[str]'},
        'primary_key': {'key': 'properties.primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'properties.secondaryKey', 'type': 'str'},
        'key_name': {'key': 'properties.keyName', 'type': 'str'},
        'claim_type': {'key': 'properties.claimType', 'type': 'str'},
        'claim_value': {'key': 'properties.claimValue', 'type': 'str'},
        'modified_time': {'key': 'properties.modifiedTime', 'type': 'str'},
        'created_time': {'key': 'properties.createdTime', 'type': 'str'},
        'revision': {'key': 'properties.revision', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        rights: Optional[List[Union[str, "AccessRights"]]] = None,
        **kwargs
    ):
        super(SharedAccessAuthorizationRuleResource, self).__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.rights = rights
        self.primary_key = None
        self.secondary_key = None
        self.key_name = None
        self.claim_type = None
        self.claim_value = None
        self.modified_time = None
        self.created_time = None
        self.revision = None


class Sku(msrest.serialization.Model):
    """The Sku description for a namespace.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the notification hub sku. Possible values include: "Free",
     "Basic", "Standard".
    :type name: str or ~azure.mgmt.notificationhubs.models.SkuName
    :param tier: The tier of particular sku.
    :type tier: str
    :param size: The Sku size.
    :type size: str
    :param family: The Sku Family.
    :type family: str
    :param capacity: The capacity of the resource.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "SkuName"],
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity


class SubResource(msrest.serialization.Model):
    """SubResource.

    :param id: Resource Id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = id


class WnsCredential(msrest.serialization.Model):
    """Description of a NotificationHub WnsCredential.

    :param package_sid: The package ID for this credential.
    :type package_sid: str
    :param secret_key: The secret key.
    :type secret_key: str
    :param windows_live_endpoint: The Windows Live endpoint.
    :type windows_live_endpoint: str
    """

    _attribute_map = {
        'package_sid': {'key': 'properties.packageSid', 'type': 'str'},
        'secret_key': {'key': 'properties.secretKey', 'type': 'str'},
        'windows_live_endpoint': {'key': 'properties.windowsLiveEndpoint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        package_sid: Optional[str] = None,
        secret_key: Optional[str] = None,
        windows_live_endpoint: Optional[str] = None,
        **kwargs
    ):
        super(WnsCredential, self).__init__(**kwargs)
        self.package_sid = package_sid
        self.secret_key = secret_key
        self.windows_live_endpoint = windows_live_endpoint
