// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/oslogin/v1beta/oslogin.proto

package oslogin

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	common "google.golang.org/genproto/googleapis/cloud/oslogin/common"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The user profile information used for logging in to a virtual machine on
// Google Compute Engine.
type LoginProfile struct {
	// Required. A unique user ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The list of POSIX accounts associated with the user.
	PosixAccounts []*common.PosixAccount `protobuf:"bytes,2,rep,name=posix_accounts,json=posixAccounts,proto3" json:"posix_accounts,omitempty"`
	// A map from SSH public key fingerprint to the associated key object.
	SshPublicKeys        map[string]*common.SshPublicKey `protobuf:"bytes,3,rep,name=ssh_public_keys,json=sshPublicKeys,proto3" json:"ssh_public_keys,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *LoginProfile) Reset()         { *m = LoginProfile{} }
func (m *LoginProfile) String() string { return proto.CompactTextString(m) }
func (*LoginProfile) ProtoMessage()    {}
func (*LoginProfile) Descriptor() ([]byte, []int) {
	return fileDescriptor_c51261020b887e3b, []int{0}
}

func (m *LoginProfile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoginProfile.Unmarshal(m, b)
}
func (m *LoginProfile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoginProfile.Marshal(b, m, deterministic)
}
func (m *LoginProfile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoginProfile.Merge(m, src)
}
func (m *LoginProfile) XXX_Size() int {
	return xxx_messageInfo_LoginProfile.Size(m)
}
func (m *LoginProfile) XXX_DiscardUnknown() {
	xxx_messageInfo_LoginProfile.DiscardUnknown(m)
}

var xxx_messageInfo_LoginProfile proto.InternalMessageInfo

func (m *LoginProfile) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *LoginProfile) GetPosixAccounts() []*common.PosixAccount {
	if m != nil {
		return m.PosixAccounts
	}
	return nil
}

func (m *LoginProfile) GetSshPublicKeys() map[string]*common.SshPublicKey {
	if m != nil {
		return m.SshPublicKeys
	}
	return nil
}

// A request message for deleting a POSIX account entry.
type DeletePosixAccountRequest struct {
	// Required. A reference to the POSIX account to update. POSIX accounts are identified
	// by the project ID they are associated with. A reference to the POSIX
	// account is in format `users/{user}/projects/{project}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeletePosixAccountRequest) Reset()         { *m = DeletePosixAccountRequest{} }
func (m *DeletePosixAccountRequest) String() string { return proto.CompactTextString(m) }
func (*DeletePosixAccountRequest) ProtoMessage()    {}
func (*DeletePosixAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c51261020b887e3b, []int{1}
}

func (m *DeletePosixAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeletePosixAccountRequest.Unmarshal(m, b)
}
func (m *DeletePosixAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeletePosixAccountRequest.Marshal(b, m, deterministic)
}
func (m *DeletePosixAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeletePosixAccountRequest.Merge(m, src)
}
func (m *DeletePosixAccountRequest) XXX_Size() int {
	return xxx_messageInfo_DeletePosixAccountRequest.Size(m)
}
func (m *DeletePosixAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeletePosixAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeletePosixAccountRequest proto.InternalMessageInfo

func (m *DeletePosixAccountRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request message for deleting an SSH public key.
type DeleteSshPublicKeyRequest struct {
	// Required. The fingerprint of the public key to update. Public keys are identified by
	// their SHA-256 fingerprint. The fingerprint of the public key is in format
	// `users/{user}/sshPublicKeys/{fingerprint}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSshPublicKeyRequest) Reset()         { *m = DeleteSshPublicKeyRequest{} }
func (m *DeleteSshPublicKeyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSshPublicKeyRequest) ProtoMessage()    {}
func (*DeleteSshPublicKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c51261020b887e3b, []int{2}
}

func (m *DeleteSshPublicKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSshPublicKeyRequest.Unmarshal(m, b)
}
func (m *DeleteSshPublicKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSshPublicKeyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteSshPublicKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSshPublicKeyRequest.Merge(m, src)
}
func (m *DeleteSshPublicKeyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSshPublicKeyRequest.Size(m)
}
func (m *DeleteSshPublicKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSshPublicKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSshPublicKeyRequest proto.InternalMessageInfo

func (m *DeleteSshPublicKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request message for retrieving the login profile information for a user.
type GetLoginProfileRequest struct {
	// Required. The unique ID for the user in format `users/{user}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The project ID of the Google Cloud Platform project.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// A system ID for filtering the results of the request.
	SystemId             string   `protobuf:"bytes,3,opt,name=system_id,json=systemId,proto3" json:"system_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetLoginProfileRequest) Reset()         { *m = GetLoginProfileRequest{} }
func (m *GetLoginProfileRequest) String() string { return proto.CompactTextString(m) }
func (*GetLoginProfileRequest) ProtoMessage()    {}
func (*GetLoginProfileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c51261020b887e3b, []int{3}
}

func (m *GetLoginProfileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetLoginProfileRequest.Unmarshal(m, b)
}
func (m *GetLoginProfileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetLoginProfileRequest.Marshal(b, m, deterministic)
}
func (m *GetLoginProfileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetLoginProfileRequest.Merge(m, src)
}
func (m *GetLoginProfileRequest) XXX_Size() int {
	return xxx_messageInfo_GetLoginProfileRequest.Size(m)
}
func (m *GetLoginProfileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetLoginProfileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetLoginProfileRequest proto.InternalMessageInfo

func (m *GetLoginProfileRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetLoginProfileRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetLoginProfileRequest) GetSystemId() string {
	if m != nil {
		return m.SystemId
	}
	return ""
}

// A request message for retrieving an SSH public key.
type GetSshPublicKeyRequest struct {
	// Required. The fingerprint of the public key to retrieve. Public keys are identified
	// by their SHA-256 fingerprint. The fingerprint of the public key is in
	// format `users/{user}/sshPublicKeys/{fingerprint}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSshPublicKeyRequest) Reset()         { *m = GetSshPublicKeyRequest{} }
func (m *GetSshPublicKeyRequest) String() string { return proto.CompactTextString(m) }
func (*GetSshPublicKeyRequest) ProtoMessage()    {}
func (*GetSshPublicKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c51261020b887e3b, []int{4}
}

func (m *GetSshPublicKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSshPublicKeyRequest.Unmarshal(m, b)
}
func (m *GetSshPublicKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSshPublicKeyRequest.Marshal(b, m, deterministic)
}
func (m *GetSshPublicKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSshPublicKeyRequest.Merge(m, src)
}
func (m *GetSshPublicKeyRequest) XXX_Size() int {
	return xxx_messageInfo_GetSshPublicKeyRequest.Size(m)
}
func (m *GetSshPublicKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSshPublicKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSshPublicKeyRequest proto.InternalMessageInfo

func (m *GetSshPublicKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request message for importing an SSH public key.
type ImportSshPublicKeyRequest struct {
	// The unique ID for the user in format `users/{user}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The SSH public key and expiration time.
	SshPublicKey *common.SshPublicKey `protobuf:"bytes,2,opt,name=ssh_public_key,json=sshPublicKey,proto3" json:"ssh_public_key,omitempty"`
	// The project ID of the Google Cloud Platform project.
	ProjectId            string   `protobuf:"bytes,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImportSshPublicKeyRequest) Reset()         { *m = ImportSshPublicKeyRequest{} }
func (m *ImportSshPublicKeyRequest) String() string { return proto.CompactTextString(m) }
func (*ImportSshPublicKeyRequest) ProtoMessage()    {}
func (*ImportSshPublicKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c51261020b887e3b, []int{5}
}

func (m *ImportSshPublicKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportSshPublicKeyRequest.Unmarshal(m, b)
}
func (m *ImportSshPublicKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportSshPublicKeyRequest.Marshal(b, m, deterministic)
}
func (m *ImportSshPublicKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportSshPublicKeyRequest.Merge(m, src)
}
func (m *ImportSshPublicKeyRequest) XXX_Size() int {
	return xxx_messageInfo_ImportSshPublicKeyRequest.Size(m)
}
func (m *ImportSshPublicKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportSshPublicKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportSshPublicKeyRequest proto.InternalMessageInfo

func (m *ImportSshPublicKeyRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ImportSshPublicKeyRequest) GetSshPublicKey() *common.SshPublicKey {
	if m != nil {
		return m.SshPublicKey
	}
	return nil
}

func (m *ImportSshPublicKeyRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// A response message for importing an SSH public key.
type ImportSshPublicKeyResponse struct {
	// The login profile information for the user.
	LoginProfile         *LoginProfile `protobuf:"bytes,1,opt,name=login_profile,json=loginProfile,proto3" json:"login_profile,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ImportSshPublicKeyResponse) Reset()         { *m = ImportSshPublicKeyResponse{} }
func (m *ImportSshPublicKeyResponse) String() string { return proto.CompactTextString(m) }
func (*ImportSshPublicKeyResponse) ProtoMessage()    {}
func (*ImportSshPublicKeyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c51261020b887e3b, []int{6}
}

func (m *ImportSshPublicKeyResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportSshPublicKeyResponse.Unmarshal(m, b)
}
func (m *ImportSshPublicKeyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportSshPublicKeyResponse.Marshal(b, m, deterministic)
}
func (m *ImportSshPublicKeyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportSshPublicKeyResponse.Merge(m, src)
}
func (m *ImportSshPublicKeyResponse) XXX_Size() int {
	return xxx_messageInfo_ImportSshPublicKeyResponse.Size(m)
}
func (m *ImportSshPublicKeyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportSshPublicKeyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ImportSshPublicKeyResponse proto.InternalMessageInfo

func (m *ImportSshPublicKeyResponse) GetLoginProfile() *LoginProfile {
	if m != nil {
		return m.LoginProfile
	}
	return nil
}

// A request message for updating an SSH public key.
type UpdateSshPublicKeyRequest struct {
	// Required. The fingerprint of the public key to update. Public keys are identified by
	// their SHA-256 fingerprint. The fingerprint of the public key is in format
	// `users/{user}/sshPublicKeys/{fingerprint}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The SSH public key and expiration time.
	SshPublicKey *common.SshPublicKey `protobuf:"bytes,2,opt,name=ssh_public_key,json=sshPublicKey,proto3" json:"ssh_public_key,omitempty"`
	// Mask to control which fields get updated. Updates all if not present.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateSshPublicKeyRequest) Reset()         { *m = UpdateSshPublicKeyRequest{} }
func (m *UpdateSshPublicKeyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSshPublicKeyRequest) ProtoMessage()    {}
func (*UpdateSshPublicKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c51261020b887e3b, []int{7}
}

func (m *UpdateSshPublicKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSshPublicKeyRequest.Unmarshal(m, b)
}
func (m *UpdateSshPublicKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSshPublicKeyRequest.Marshal(b, m, deterministic)
}
func (m *UpdateSshPublicKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSshPublicKeyRequest.Merge(m, src)
}
func (m *UpdateSshPublicKeyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSshPublicKeyRequest.Size(m)
}
func (m *UpdateSshPublicKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSshPublicKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSshPublicKeyRequest proto.InternalMessageInfo

func (m *UpdateSshPublicKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateSshPublicKeyRequest) GetSshPublicKey() *common.SshPublicKey {
	if m != nil {
		return m.SshPublicKey
	}
	return nil
}

func (m *UpdateSshPublicKeyRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func init() {
	proto.RegisterType((*LoginProfile)(nil), "google.cloud.oslogin.v1beta.LoginProfile")
	proto.RegisterMapType((map[string]*common.SshPublicKey)(nil), "google.cloud.oslogin.v1beta.LoginProfile.SshPublicKeysEntry")
	proto.RegisterType((*DeletePosixAccountRequest)(nil), "google.cloud.oslogin.v1beta.DeletePosixAccountRequest")
	proto.RegisterType((*DeleteSshPublicKeyRequest)(nil), "google.cloud.oslogin.v1beta.DeleteSshPublicKeyRequest")
	proto.RegisterType((*GetLoginProfileRequest)(nil), "google.cloud.oslogin.v1beta.GetLoginProfileRequest")
	proto.RegisterType((*GetSshPublicKeyRequest)(nil), "google.cloud.oslogin.v1beta.GetSshPublicKeyRequest")
	proto.RegisterType((*ImportSshPublicKeyRequest)(nil), "google.cloud.oslogin.v1beta.ImportSshPublicKeyRequest")
	proto.RegisterType((*ImportSshPublicKeyResponse)(nil), "google.cloud.oslogin.v1beta.ImportSshPublicKeyResponse")
	proto.RegisterType((*UpdateSshPublicKeyRequest)(nil), "google.cloud.oslogin.v1beta.UpdateSshPublicKeyRequest")
}

func init() {
	proto.RegisterFile("google/cloud/oslogin/v1beta/oslogin.proto", fileDescriptor_c51261020b887e3b)
}

var fileDescriptor_c51261020b887e3b = []byte{
	// 1002 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0xcd, 0x6f, 0xdc, 0x44,
	0x14, 0x97, 0xbd, 0x50, 0x91, 0xc9, 0x47, 0xd1, 0x20, 0xd2, 0xc4, 0xa1, 0x64, 0x71, 0x14, 0xb4,
	0x4d, 0x53, 0x9b, 0x6e, 0x05, 0xad, 0x5c, 0xaa, 0xe2, 0x85, 0x52, 0x45, 0x7c, 0xad, 0xb6, 0xb4,
	0x12, 0x28, 0xd2, 0x6a, 0xd6, 0x3b, 0xd9, 0x35, 0x6b, 0x7b, 0x8c, 0x67, 0xbc, 0x61, 0x85, 0xca,
	0x01, 0x89, 0x23, 0x27, 0x24, 0x2e, 0x9c, 0x91, 0x10, 0x7f, 0x05, 0xe7, 0x8a, 0x53, 0xb8, 0x45,
	0x42, 0xea, 0x81, 0x13, 0x97, 0x5e, 0x38, 0xe5, 0x84, 0x3c, 0x33, 0x4e, 0x6c, 0xaf, 0x37, 0xbb,
	0xa9, 0x94, 0x53, 0x3c, 0xf3, 0xde, 0xfb, 0xbd, 0xdf, 0xfb, 0x98, 0x5f, 0x12, 0x70, 0xa5, 0x47,
	0x48, 0xcf, 0xc3, 0xa6, 0xe3, 0x91, 0xb8, 0x6b, 0x12, 0xea, 0x91, 0x9e, 0x1b, 0x98, 0xc3, 0xeb,
	0x1d, 0xcc, 0x50, 0x7a, 0x34, 0xc2, 0x88, 0x30, 0x02, 0xd7, 0x84, 0xab, 0xc1, 0x5d, 0x8d, 0xd4,
	0x26, 0x5c, 0xb5, 0xd7, 0x24, 0x0e, 0x0a, 0x5d, 0x13, 0x05, 0x01, 0x61, 0x88, 0xb9, 0x24, 0xa0,
	0x22, 0x54, 0xbb, 0x94, 0xb1, 0x3a, 0x9e, 0x8b, 0x03, 0x26, 0x0d, 0xeb, 0x19, 0xc3, 0x9e, 0x8b,
	0xbd, 0x6e, 0xbb, 0x83, 0xfb, 0x68, 0xe8, 0x92, 0x48, 0x3a, 0xac, 0x66, 0x1c, 0x22, 0x4c, 0x49,
	0x1c, 0x39, 0x58, 0x9a, 0x6a, 0xa5, 0xd4, 0x1d, 0xe2, 0xfb, 0x24, 0xfd, 0x21, 0x3d, 0x25, 0x73,
	0x93, 0x9f, 0x3a, 0xf1, 0x9e, 0x89, 0xfd, 0x90, 0x8d, 0xa4, 0xb1, 0x5a, 0x34, 0x0a, 0x1e, 0x3e,
	0xa2, 0x03, 0xe1, 0xa1, 0xff, 0xa9, 0x82, 0x85, 0x8f, 0x13, 0xf0, 0x66, 0x44, 0xf6, 0x5c, 0x0f,
	0xc3, 0x4b, 0xe0, 0x85, 0x00, 0xf9, 0x78, 0x45, 0xa9, 0x2a, 0xb5, 0xb9, 0x46, 0xe5, 0xa9, 0xad,
	0xb6, 0xf8, 0x05, 0x6c, 0x82, 0xa5, 0x90, 0x50, 0xf7, 0x9b, 0x36, 0x72, 0x1c, 0x12, 0x07, 0x8c,
	0xae, 0xa8, 0xd5, 0x4a, 0x6d, 0xbe, 0x7e, 0xc5, 0x28, 0xed, 0x9d, 0x24, 0xd9, 0x4c, 0x42, 0x6c,
	0x11, 0xd1, 0x5a, 0x0c, 0x33, 0x27, 0x0a, 0xbb, 0xe0, 0x22, 0xa5, 0xfd, 0x76, 0x18, 0x77, 0x3c,
	0xd7, 0x69, 0x0f, 0xf0, 0x88, 0xae, 0x54, 0x38, 0xe4, 0xbb, 0xc6, 0x29, 0xe3, 0x30, 0xb2, 0x74,
	0x8d, 0x07, 0xb4, 0xdf, 0xe4, 0xf1, 0x1f, 0xe1, 0x11, 0xbd, 0x17, 0xb0, 0x68, 0xd4, 0x5a, 0xa4,
	0xd9, 0x3b, 0x6d, 0x00, 0xe0, 0xb8, 0x13, 0x7c, 0x19, 0x54, 0x06, 0x78, 0x24, 0xaa, 0x6c, 0x25,
	0x9f, 0xf0, 0x2e, 0x78, 0x71, 0x88, 0xbc, 0x18, 0xaf, 0xa8, 0x55, 0x65, 0x6a, 0x59, 0x59, 0xc4,
	0x96, 0x88, 0xb3, 0xd4, 0x5b, 0x8a, 0xbe, 0x0b, 0x56, 0x3f, 0xc0, 0x1e, 0x66, 0x38, 0x57, 0x37,
	0xfe, 0x3a, 0xc6, 0x94, 0xc1, 0xbb, 0xb9, 0xd6, 0x5e, 0x7d, 0x6a, 0xab, 0x47, 0xf6, 0x26, 0xd8,
	0x48, 0xa1, 0x45, 0x3e, 0x14, 0xba, 0x34, 0xc9, 0x62, 0xe6, 0x10, 0x78, 0xe0, 0x09, 0x7a, 0x2e,
	0xfd, 0x73, 0xa1, 0xe7, 0x10, 0x04, 0xfa, 0x8f, 0x0a, 0x58, 0xbe, 0x8f, 0x59, 0xb6, 0xbd, 0x29,
	0xf6, 0xcd, 0x1c, 0xf6, 0x06, 0xc7, 0xbe, 0x0c, 0xd6, 0x26, 0x60, 0x3f, 0xa4, 0x38, 0x92, 0x4b,
	0x73, 0x19, 0x80, 0x30, 0x22, 0x5f, 0x61, 0x87, 0xb5, 0xdd, 0x2e, 0xef, 0xec, 0x5c, 0x6b, 0x4e,
	0xde, 0xec, 0x74, 0xe1, 0x1a, 0x98, 0xa3, 0x23, 0xca, 0xb0, 0x9f, 0x58, 0x2b, 0xdc, 0xfa, 0x92,
	0xb8, 0xd8, 0xe9, 0xea, 0x5f, 0x70, 0x3a, 0xe7, 0x52, 0xea, 0x81, 0x02, 0x56, 0x77, 0xfc, 0x90,
	0x44, 0xa5, 0xf0, 0xef, 0x81, 0x0b, 0x21, 0x8a, 0x70, 0xc0, 0x64, 0x82, 0xda, 0x91, 0xbd, 0x09,
	0x67, 0x42, 0x97, 0x71, 0xf0, 0x73, 0xb0, 0x94, 0xdf, 0xec, 0x33, 0x2f, 0x95, 0x78, 0x79, 0x0b,
	0xd9, 0x55, 0x2e, 0x34, 0xb3, 0x52, 0x68, 0xa6, 0xee, 0x01, 0xad, 0xac, 0x26, 0x1a, 0x92, 0x80,
	0x62, 0xf8, 0x29, 0x58, 0xe4, 0xc9, 0xda, 0xa1, 0x18, 0x2d, 0xaf, 0x6d, 0x22, 0xa3, 0x92, 0xa7,
	0xd6, 0x5a, 0xf0, 0x32, 0x27, 0xfd, 0x99, 0x02, 0x56, 0x1f, 0x86, 0x5d, 0x74, 0x3e, 0xcb, 0x78,
	0x4e, 0x1d, 0xbc, 0x0d, 0xe6, 0x63, 0xce, 0x99, 0x4b, 0x20, 0x6f, 0xe1, 0x7c, 0x5d, 0x4b, 0x21,
	0x53, 0x95, 0x34, 0x3e, 0x4c, 0x54, 0xf2, 0x13, 0x44, 0x07, 0x2d, 0x20, 0xdc, 0x93, 0xef, 0xfa,
	0x7f, 0x00, 0x2c, 0x7d, 0x46, 0x79, 0x4b, 0x1e, 0xe0, 0x68, 0xe8, 0x3a, 0x18, 0xfe, 0xac, 0x00,
	0x38, 0xfe, 0xde, 0xe1, 0x3b, 0xa7, 0x36, 0x75, 0xa2, 0x40, 0x68, 0xcb, 0x63, 0x4c, 0xee, 0x25,
	0x62, 0xae, 0xbf, 0x75, 0x68, 0xf3, 0xae, 0x7c, 0xff, 0xd7, 0x3f, 0x3f, 0xa9, 0x1b, 0x5b, 0x6f,
	0xa4, 0xbf, 0xc3, 0xbe, 0x4d, 0x2e, 0xef, 0xc4, 0x14, 0x47, 0xd4, 0xdc, 0x32, 0xe5, 0x26, 0x50,
	0x73, 0xeb, 0x31, 0xfc, 0xe5, 0x98, 0x58, 0xb6, 0x25, 0x33, 0x11, 0x2b, 0x19, 0xe7, 0x44, 0x62,
	0x6f, 0x67, 0x89, 0xd5, 0xb6, 0xde, 0x2c, 0x27, 0x96, 0xd3, 0xe3, 0x84, 0xdd, 0xaf, 0x0a, 0xb8,
	0x58, 0x50, 0x1a, 0x78, 0xe3, 0x54, 0x6a, 0xe5, 0xba, 0xa4, 0xcd, 0xbe, 0xbd, 0x7a, 0x3d, 0x4b,
	0x75, 0x13, 0x6e, 0x94, 0x52, 0x7d, 0x6c, 0x66, 0x77, 0x1c, 0xfe, 0x26, 0x78, 0xe6, 0x5a, 0x38,
	0x95, 0x67, 0x59, 0xff, 0x66, 0xdf, 0xda, 0x42, 0x4b, 0xe1, 0xac, 0x2d, 0xfd, 0x41, 0x05, 0x70,
	0xfc, 0xf5, 0x4f, 0x19, 0xf8, 0x44, 0x09, 0xd4, 0x6e, 0x9e, 0x39, 0x4e, 0xc8, 0x8c, 0xfe, 0xdd,
	0xa1, 0xfd, 0xaa, 0x10, 0xc1, 0xed, 0xfc, 0xfb, 0x3d, 0xb4, 0xab, 0xa5, 0xf7, 0xdb, 0x27, 0x92,
	0xc6, 0x4b, 0xbe, 0xa3, 0x5f, 0x3d, 0x2e, 0x59, 0x04, 0x1c, 0x0f, 0xc7, 0x72, 0xc7, 0xf2, 0x5a,
	0x05, 0x95, 0x80, 0xcf, 0x14, 0x00, 0xc7, 0x65, 0x69, 0x4a, 0x1f, 0x26, 0xea, 0xd8, 0x59, 0x06,
	0x37, 0x3c, 0xb4, 0x5f, 0x49, 0x66, 0x34, 0x56, 0xf7, 0x7a, 0xc9, 0xed, 0x76, 0x46, 0x86, 0x78,
	0xd9, 0xb7, 0xea, 0x33, 0x4e, 0xba, 0x58, 0xb1, 0xf6, 0xb7, 0xf2, 0xc4, 0x5e, 0x2e, 0x17, 0xd6,
	0x03, 0xfb, 0x0f, 0xa5, 0xcf, 0x58, 0x48, 0x2d, 0xd3, 0xdc, 0xdf, 0xdf, 0x2f, 0xca, 0x2e, 0x8a,
	0x59, 0x5f, 0xfc, 0x85, 0x79, 0x2d, 0xf4, 0x10, 0xdb, 0x23, 0x91, 0xbf, 0x7d, 0x36, 0x77, 0x23,
	0xc2, 0xa8, 0x7b, 0x8d, 0x04, 0xde, 0x68, 0x7a, 0x20, 0xf1, 0xc3, 0x98, 0xe1, 0x59, 0xfd, 0x38,
	0x72, 0x02, 0xdc, 0x38, 0x50, 0xc0, 0xba, 0x43, 0xfc, 0xd3, 0x06, 0xd8, 0x58, 0x90, 0xba, 0xdc,
	0x4c, 0xe4, 0xa9, 0xa9, 0x7c, 0xd9, 0x90, 0xce, 0x3d, 0xe2, 0xa1, 0xa0, 0x67, 0x90, 0xa8, 0x67,
	0xf6, 0x70, 0xc0, 0xc5, 0xcb, 0x3c, 0x49, 0x5a, 0xfa, 0x8f, 0xc1, 0x6d, 0x79, 0xfc, 0x5d, 0x5d,
	0xbb, 0x2f, 0x40, 0xde, 0xe7, 0x19, 0x65, 0x06, 0xe3, 0xd1, 0xf5, 0x06, 0x66, 0xe8, 0x49, 0x6a,
	0xdd, 0xe5, 0xd6, 0x5d, 0x69, 0xdd, 0x7d, 0xc4, 0x31, 0xfe, 0x55, 0x5f, 0x17, 0x56, 0xcb, 0xe2,
	0x66, 0xcb, 0x92, 0x76, 0xcb, 0x12, 0x0e, 0x9d, 0x0b, 0x9c, 0xcb, 0x8d, 0xff, 0x03, 0x00, 0x00,
	0xff, 0xff, 0x68, 0x4a, 0x62, 0xc6, 0xa3, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// OsLoginServiceClient is the client API for OsLoginService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type OsLoginServiceClient interface {
	// Deletes a POSIX account.
	DeletePosixAccount(ctx context.Context, in *DeletePosixAccountRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Deletes an SSH public key.
	DeleteSshPublicKey(ctx context.Context, in *DeleteSshPublicKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Retrieves the profile information used for logging in to a virtual machine
	// on Google Compute Engine.
	GetLoginProfile(ctx context.Context, in *GetLoginProfileRequest, opts ...grpc.CallOption) (*LoginProfile, error)
	// Retrieves an SSH public key.
	GetSshPublicKey(ctx context.Context, in *GetSshPublicKeyRequest, opts ...grpc.CallOption) (*common.SshPublicKey, error)
	// Adds an SSH public key and returns the profile information. Default POSIX
	// account information is set when no username and UID exist as part of the
	// login profile.
	ImportSshPublicKey(ctx context.Context, in *ImportSshPublicKeyRequest, opts ...grpc.CallOption) (*ImportSshPublicKeyResponse, error)
	// Updates an SSH public key and returns the profile information. This method
	// supports patch semantics.
	UpdateSshPublicKey(ctx context.Context, in *UpdateSshPublicKeyRequest, opts ...grpc.CallOption) (*common.SshPublicKey, error)
}

type osLoginServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewOsLoginServiceClient(cc grpc.ClientConnInterface) OsLoginServiceClient {
	return &osLoginServiceClient{cc}
}

func (c *osLoginServiceClient) DeletePosixAccount(ctx context.Context, in *DeletePosixAccountRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/DeletePosixAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) DeleteSshPublicKey(ctx context.Context, in *DeleteSshPublicKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/DeleteSshPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) GetLoginProfile(ctx context.Context, in *GetLoginProfileRequest, opts ...grpc.CallOption) (*LoginProfile, error) {
	out := new(LoginProfile)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/GetLoginProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) GetSshPublicKey(ctx context.Context, in *GetSshPublicKeyRequest, opts ...grpc.CallOption) (*common.SshPublicKey, error) {
	out := new(common.SshPublicKey)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/GetSshPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) ImportSshPublicKey(ctx context.Context, in *ImportSshPublicKeyRequest, opts ...grpc.CallOption) (*ImportSshPublicKeyResponse, error) {
	out := new(ImportSshPublicKeyResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/ImportSshPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) UpdateSshPublicKey(ctx context.Context, in *UpdateSshPublicKeyRequest, opts ...grpc.CallOption) (*common.SshPublicKey, error) {
	out := new(common.SshPublicKey)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/UpdateSshPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OsLoginServiceServer is the server API for OsLoginService service.
type OsLoginServiceServer interface {
	// Deletes a POSIX account.
	DeletePosixAccount(context.Context, *DeletePosixAccountRequest) (*empty.Empty, error)
	// Deletes an SSH public key.
	DeleteSshPublicKey(context.Context, *DeleteSshPublicKeyRequest) (*empty.Empty, error)
	// Retrieves the profile information used for logging in to a virtual machine
	// on Google Compute Engine.
	GetLoginProfile(context.Context, *GetLoginProfileRequest) (*LoginProfile, error)
	// Retrieves an SSH public key.
	GetSshPublicKey(context.Context, *GetSshPublicKeyRequest) (*common.SshPublicKey, error)
	// Adds an SSH public key and returns the profile information. Default POSIX
	// account information is set when no username and UID exist as part of the
	// login profile.
	ImportSshPublicKey(context.Context, *ImportSshPublicKeyRequest) (*ImportSshPublicKeyResponse, error)
	// Updates an SSH public key and returns the profile information. This method
	// supports patch semantics.
	UpdateSshPublicKey(context.Context, *UpdateSshPublicKeyRequest) (*common.SshPublicKey, error)
}

// UnimplementedOsLoginServiceServer can be embedded to have forward compatible implementations.
type UnimplementedOsLoginServiceServer struct {
}

func (*UnimplementedOsLoginServiceServer) DeletePosixAccount(ctx context.Context, req *DeletePosixAccountRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePosixAccount not implemented")
}
func (*UnimplementedOsLoginServiceServer) DeleteSshPublicKey(ctx context.Context, req *DeleteSshPublicKeyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSshPublicKey not implemented")
}
func (*UnimplementedOsLoginServiceServer) GetLoginProfile(ctx context.Context, req *GetLoginProfileRequest) (*LoginProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLoginProfile not implemented")
}
func (*UnimplementedOsLoginServiceServer) GetSshPublicKey(ctx context.Context, req *GetSshPublicKeyRequest) (*common.SshPublicKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSshPublicKey not implemented")
}
func (*UnimplementedOsLoginServiceServer) ImportSshPublicKey(ctx context.Context, req *ImportSshPublicKeyRequest) (*ImportSshPublicKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportSshPublicKey not implemented")
}
func (*UnimplementedOsLoginServiceServer) UpdateSshPublicKey(ctx context.Context, req *UpdateSshPublicKeyRequest) (*common.SshPublicKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSshPublicKey not implemented")
}

func RegisterOsLoginServiceServer(s *grpc.Server, srv OsLoginServiceServer) {
	s.RegisterService(&_OsLoginService_serviceDesc, srv)
}

func _OsLoginService_DeletePosixAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePosixAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).DeletePosixAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/DeletePosixAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).DeletePosixAccount(ctx, req.(*DeletePosixAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_DeleteSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).DeleteSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/DeleteSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).DeleteSshPublicKey(ctx, req.(*DeleteSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_GetLoginProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLoginProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).GetLoginProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/GetLoginProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).GetLoginProfile(ctx, req.(*GetLoginProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_GetSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).GetSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/GetSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).GetSshPublicKey(ctx, req.(*GetSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_ImportSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).ImportSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/ImportSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).ImportSshPublicKey(ctx, req.(*ImportSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_UpdateSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).UpdateSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/UpdateSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).UpdateSshPublicKey(ctx, req.(*UpdateSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OsLoginService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.oslogin.v1beta.OsLoginService",
	HandlerType: (*OsLoginServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DeletePosixAccount",
			Handler:    _OsLoginService_DeletePosixAccount_Handler,
		},
		{
			MethodName: "DeleteSshPublicKey",
			Handler:    _OsLoginService_DeleteSshPublicKey_Handler,
		},
		{
			MethodName: "GetLoginProfile",
			Handler:    _OsLoginService_GetLoginProfile_Handler,
		},
		{
			MethodName: "GetSshPublicKey",
			Handler:    _OsLoginService_GetSshPublicKey_Handler,
		},
		{
			MethodName: "ImportSshPublicKey",
			Handler:    _OsLoginService_ImportSshPublicKey_Handler,
		},
		{
			MethodName: "UpdateSshPublicKey",
			Handler:    _OsLoginService_UpdateSshPublicKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/oslogin/v1beta/oslogin.proto",
}
