/* $Id: genome128_hr.h 222927 2020-06-29 16:07:54Z twu $ */
#ifndef GENOME128_HR_INCLUDED
#define GENOME128_HR_INCLUDED
#include "types.h"
#include "mode.h"
#include "genomicpos.h"
#include "compress.h"
#include "genome.h"

extern void
Genome_hr_setup (Genomecomp_T *ref_blocks_in, Genomecomp_T *alt_blocks_in,
		 bool query_unk_mismatch_p_in, bool genome_unk_mismatch_p_in,
		 Mode_T mode_in, bool maskedp_in);

extern int
Genome_count_mismatches_substring_ref (Genome_T ome, Compress_T query_compress, Univcoord_T left,
				       int pos5, int pos3, bool plusp, int genestrand);
extern int
Genome_count_mismatches_substring (int *ref_mismatches, Genome_T ome, Genome_T ome_alt, Compress_T query_compress,
				   Univcoord_T left, int pos5, int pos3, bool plusp, int genestrand);

extern int
Genome_mismatches_left (int *mismatch_positions, int max_mismatches,
			Genome_T ome, Genome_T ome_alt, Compress_T query_compress,
			Univcoord_T left, int pos5, int pos3, bool plusp, int genestrand);
extern int
Genome_mismatches_left_trim (int *mismatch_positions, int max_mismatches,
			     Genome_T ome, Genome_T ome_alt, Compress_T query_compress,
			     Univcoord_T left, int pos5, int pos3, bool plusp, int genestrand);
extern int
Genome_mismatches_right (int *mismatch_positions, int max_mismatches,
			 Genome_T ome, Genome_T ome_alt, Compress_T query_compress,
			 Univcoord_T left, int pos5, int pos3, bool plusp, int genestrand);
extern int
Genome_mismatches_right_trim (int *mismatch_positions, int max_mismatches,
			      Genome_T ome, Genome_T ome_alt, Compress_T query_compress,
			      Univcoord_T left, int pos5, int pos3, bool plusp, int genestrand);

extern int
Genome_first_kmer_left (int *nmismatches5, Genome_T ome, Compress_T query_compress,
			Univcoord_T left, int pos5, int pos3, bool plusp, int genestrand,
			bool query_unk_mismatch_local_p, int kmer);
extern int
Genome_first_kmer_right (int *nmismatches3, Genome_T ome, Compress_T query_compress,
			 Univcoord_T left, int pos5, int pos3, bool plusp, int genestrand,
			 bool query_unk_mismatch_local_p, int kmer);

extern int
Genome_mark_mismatches_ref (char *genomic, int querylength, Compress_T query_compress,
			    Univcoord_T left, int pos5, int pos3,
			    bool plusp, int genestrand);
extern int
Genome_mark_mismatches (char *genomic, int querylength, Compress_T query_compress,
			Univcoord_T left, int pos5, int pos3,
			bool plusp, int genestrand);

#endif

