### New features

* [#4464](https://github.com/rubocop-hq/rubocop/pull/4464): Add `EnforcedStyleForEmptyBraces` parameter to `Layout/SpaceBeforeBlockBraces` cop. ([@palkan][])
* [#4453](https://github.com/rubocop-hq/rubocop/pull/4453): New cop `Style/RedundantConditional` checks for conditionals that return true/false. ([@petehamilton][])
* [#4448](https://github.com/rubocop-hq/rubocop/pull/4448): Add new `TapFormatter`. ([@cyberdelia][])
* Add new `Style/HeredocDelimiters` cop. ([@drenmi][])
* [#4153](https://github.com/rubocop-hq/rubocop/issues/4153): New cop `Lint/ReturnInVoidContext` checks for the use of a return with a value in a context where it will be ignored. ([@harold-s][])
* Add auto-correct support to `Lint/ScriptPermission`. ([@rrosenblum][])
* [#4514](https://github.com/rubocop-hq/rubocop/pull/4514): Add configuration options to `Style/YodaCondition` to support checking all comparison operators or equality operators only. ([@smakagon][])
* Add new `Lint/BooleanSymbol` cop. ([@droptheplot][])
* Make `Rails/PluralizationGrammar` use singular methods for `-1` / `-1.0`. ([@promisedlandt][])
* [#4541](https://github.com/rubocop-hq/rubocop/pull/4541): Add new `Rails/HasManyOrHasOneDependent` cop. ([@oboxodo][])
* Add new `Style/Dir` cop. ([@drenmi][])
* Add new `Style/HeredocDelimiterCase` cop. ([@drenmi][])
* [#2943](https://github.com/rubocop-hq/rubocop/pull/2943): Add new `Lint/RescueWithoutErrorClass` cop. ([@drenmi][])
* [#4568](https://github.com/rubocop-hq/rubocop/pull/4568): Fix autocorrection for `Style/TrailingUnderscoreVariable`. ([@smakagon][])
* [#4586](https://github.com/rubocop-hq/rubocop/pull/4586): Add new `Performance/UnfreezeString` cop. ([@pocke][])
* [#2976](https://github.com/rubocop-hq/rubocop/issues/2976): Add `Whitelist` configuration option to `Style/NestedParenthesizedCalls` cop. ([@drenmi][])
* [#3965](https://github.com/rubocop-hq/rubocop/issues/3965): Add new `Style/DoublePipeEquals` cop. ([@donjar][])
* Make `rake new_cop` create parent directories if they do not already exist. ([@highb][])
* [#4368](https://github.com/rubocop-hq/rubocop/issues/4368): Make `Performance/HashEachMethod` inspect send nodes with any receiver. ([@gohdaniel15][])
* [#4508](https://github.com/rubocop-hq/rubocop/issues/4508): Add new `Style/ReturnNil` cop. ([@donjar][])
* [#4629](https://github.com/rubocop-hq/rubocop/issues/4629): Add Metrics/MethodLength cop for `define_method`. ([@jekuta][])
* [#4702](https://github.com/rubocop-hq/rubocop/pull/4702): Add new `Lint/UriEscapeUnescape` cop. ([@koic][])
* [#4696](https://github.com/rubocop-hq/rubocop/pull/4696): Add new `Performance/UriDefaultParser` cop. ([@koic][])
* [#4694](https://github.com/rubocop-hq/rubocop/pull/4694): Add new `Lint/UriRegexp` cop. ([@koic][])
* Add new `Style/MinMax` cop. ([@drenmi][])
* [#4720](https://github.com/rubocop-hq/rubocop/pull/4720): Add new `Bundler/InsecureProtocolSource` cop. ([@koic][])
* [#4708](https://github.com/rubocop-hq/rubocop/pull/4708): Add new `Lint/RedundantWithIndex` cop`. ([@koic][])

### Bug fixes

* [#4709](https://github.com/rubocop-hq/rubocop/pull/4709): Use cached remote config on network failure. ([@kristjan][])
* [#4688](https://github.com/rubocop-hq/rubocop/pull/4688): Accept yoda condition which isn't commutative. ([@fujimura][])
* [#4676](https://github.com/rubocop-hq/rubocop/issues/4676): Make `Style/RedundantConditional` cop work with elsif. ([@akhramov][])
* [#4656](https://github.com/rubocop-hq/rubocop/issues/4656): Modify `Style/ConditionalAssignment` autocorrection to work with unbracketed arrays. ([@akhramov][])
* [#4615](https://github.com/rubocop-hq/rubocop/pull/4615): Don't consider `<=>` a comparison method. ([@iGEL][])
* [#4664](https://github.com/rubocop-hq/rubocop/pull/4664): Fix typos in Rails/HttpPositionalArguments. ([@JoeCohen][])
* [#4618](https://github.com/rubocop-hq/rubocop/pull/4618): Fix `Lint/FormatParameterMismatch` false positive if format string includes `%%5B` (CGI encoded left bracket). ([@barthez][])
* [#4604](https://github.com/rubocop-hq/rubocop/pull/4604): Fix `Style/LambdaCall` to autocorrect `obj.call` to `obj.`. ([@iGEL][])
* [#4443](https://github.com/rubocop-hq/rubocop/pull/4443): Prevent `Style/YodaCondition` from breaking `not LITERAL`. ([@pocke][])
* [#4434](https://github.com/rubocop-hq/rubocop/issues/4434): Prevent bad auto-correct in `Style/Alias` for non-literal arguments. ([@drenmi][])
* [#4451](https://github.com/rubocop-hq/rubocop/issues/4451): Make `Style/AndOr` cop aware of comparison methods. ([@drenmi][])
* [#4457](https://github.com/rubocop-hq/rubocop/pull/4457): Fix false negative in `Lint/Void` with initialize and setter methods. ([@pocke][])
* [#4418](https://github.com/rubocop-hq/rubocop/issues/4418): Register an offense in `Style/ConditionalAssignment` when the assignment line is the longest line, and it does not exceed the max line length. ([@rrosenblum][])
* [#4491](https://github.com/rubocop-hq/rubocop/issues/4491): Prevent bad auto-correct in `Style/EmptyElse` for nested `if`. ([@pocke][])
* [#4485](https://github.com/rubocop-hq/rubocop/pull/4485): Handle 304 status for remote config files. ([@daniloisr][])
* [#4529](https://github.com/rubocop-hq/rubocop/pull/4529): Make `Lint/UnreachableCode` aware of `if` and `case`. ([@pocke][])
* [#4469](https://github.com/rubocop-hq/rubocop/issues/4469): Include permissions in file cache. ([@pocke][])
* [#4270](https://github.com/rubocop-hq/rubocop/issues/4270): Fix false positive in `Performance/RegexpMatch` for named captures. ([@pocke][])
* [#4525](https://github.com/rubocop-hq/rubocop/pull/4525): Fix regexp for checking comment config of `rubocop:disable all` in `Lint/UnneededDisable`. ([@meganemura][])
* [#4555](https://github.com/rubocop-hq/rubocop/issues/4555): Make `Style/VariableName` aware of optarg, kwarg and other arguments. ([@pocke][])
* [#4481](https://github.com/rubocop-hq/rubocop/issues/4481): Prevent `Style/WordArray` and `Style/SymbolArray` from registering offenses where percent arrays don't work. ([@drenmi][])
* [#4447](https://github.com/rubocop-hq/rubocop/issues/4447): Prevent `Layout/EmptyLineBetweenDefs` from removing too many lines. ([@drenmi][])
* [#3892](https://github.com/rubocop-hq/rubocop/issues/3892): Make `Style/NumericPredicate` ignore numeric comparison of global variables. ([@drenmi][])
* [#4101](https://github.com/rubocop-hq/rubocop/issues/4101): Skip auto-correct for literals with trailing comment and chained method call in `Layout/Multiline*BraceLayout`. ([@jonas054][])
* [#4518](https://github.com/rubocop-hq/rubocop/issues/4518): Fix bug where `Style/SafeNavigation` does not register an offense when there are chained method calls. ([@rrosenblum][])
* [#3040](https://github.com/rubocop-hq/rubocop/issues/3040): Ignore safe navigation in `Rails/Delegate`. ([@cgriego][])
* [#4587](https://github.com/rubocop-hq/rubocop/pull/4587): Fix false negative for void unary operators in `Lint/Void` cop. ([@pocke][])
* [#4589](https://github.com/rubocop-hq/rubocop/issues/4589): Fix false positive in `Performance/RegexpMatch` cop for `=~` is in a class method. ([@pocke][])
* [#4578](https://github.com/rubocop-hq/rubocop/issues/4578): Fix false positive in `Lint/FormatParameterMismatch` for format with "asterisk" (`*`) width and precision. ([@smakagon][])
* [#4285](https://github.com/rubocop-hq/rubocop/issues/4285): Make `Lint/DefEndAlignment` aware of multiple modifiers. ([@drenmi][])
* [#4634](https://github.com/rubocop-hq/rubocop/issues/4634): Handle heredoc that contains empty lines only in `Layout/IndentHeredoc` cop. ([@pocke][])
* [#4646](https://github.com/rubocop-hq/rubocop/issues/4646): Make `Lint/Debugger` aware of `Kernel` and cbase. ([@pocke][])
* [#4643](https://github.com/rubocop-hq/rubocop/issues/4643): Modify `Style/InverseMethods` to not register a separate offense for an inverse method nested inside of the block of an inverse method offense. ([@rrosenblum][])
* [#4593](https://github.com/rubocop-hq/rubocop/issues/4593): Fix false positive in `Rails/SaveBang` when `save/update_attribute` is used with a `case` statement. ([@theRealNG][])
* [#4322](https://github.com/rubocop-hq/rubocop/issues/4322): Fix Style/MultilineMemoization from autocorrecting to invalid ruby. ([@dpostorivo][])
* [#4722](https://github.com/rubocop-hq/rubocop/pull/4722): Fix `rake new_cop` problem that doesn't add `require` line. ([@koic][])
* [#4723](https://github.com/rubocop-hq/rubocop/issues/4723): Fix `RaiseArgs` auto-correction issue for `raise` with 3 arguments. ([@smakagon][])

### Changes

* [#4470](https://github.com/rubocop-hq/rubocop/issues/4470): Improve the error message for `Lint/AssignmentInCondition`. ([@brandonweiss][])
* [#4553](https://github.com/rubocop-hq/rubocop/issues/4553): Add `node_modules` to default excludes. ([@iainbeeston][])
* [#4445](https://github.com/rubocop-hq/rubocop/pull/4445): Make `Style/Encoding` cop enabled by default. ([@deivid-rodriguez][])
* [#4452](https://github.com/rubocop-hq/rubocop/pull/4452): Add option to `Rails/Delegate` for enforcing the prefixed method name case. ([@klesse413][])
* [#4493](https://github.com/rubocop-hq/rubocop/pull/4493): Make `Lint/Void` cop aware of `Enumerable#each` and `for`. ([@pocke][])
* [#4492](https://github.com/rubocop-hq/rubocop/pull/4492): Make `Lint/DuplicateMethods` aware of `alias` and `alias_method`. ([@pocke][])
* [#4478](https://github.com/rubocop-hq/rubocop/issues/4478): Fix confusing message of `Performance/Caller` cop. ([@pocke][])
* [#4543](https://github.com/rubocop-hq/rubocop/pull/4543): Make `Lint/DuplicateMethods` aware of `attr_*` methods. ([@pocke][])
* [#4550](https://github.com/rubocop-hq/rubocop/pull/4550): Mark `RuboCop::CLI#run` as a public API. ([@yujinakayama][])
* [#4551](https://github.com/rubocop-hq/rubocop/pull/4551): Make `Performance/Caller` aware of `caller_locations`. ([@pocke][])
* Rename `Style/HeredocDelimiters` to `Style/HeredocDelimiterNaming`. ([@drenmi][])
* [#4157](https://github.com/rubocop-hq/rubocop/issues/4157): Enhance offense message for `Style/RedudantReturn` cop. ([@gohdaniel15][])
* [#4521](https://github.com/rubocop-hq/rubocop/issues/4521): Move naming related cops into their own `Naming` department. ([@drenmi][])
* [#4600](https://github.com/rubocop-hq/rubocop/pull/4600): Make `Style/RedundantSelf` aware of arguments of a block. ([@Envek][])
* [#4658](https://github.com/rubocop-hq/rubocop/issues/4658): Disable auto-correction for `Performance/TimesMap` by default. ([@Envek][])

[@palkan]: https://github.com/palkan
[@petehamilton]: https://github.com/petehamilton
[@cyberdelia]: https://github.com/cyberdelia
[@drenmi]: https://github.com/drenmi
[@harold-s]: https://github.com/harold-s
[@rrosenblum]: https://github.com/rrosenblum
[@smakagon]: https://github.com/smakagon
[@droptheplot]: https://github.com/droptheplot
[@promisedlandt]: https://github.com/promisedlandt
[@oboxodo]: https://github.com/oboxodo
[@pocke]: https://github.com/pocke
[@donjar]: https://github.com/donjar
[@highb]: https://github.com/highb
[@gohdaniel15]: https://github.com/gohdaniel15
[@jekuta]: https://github.com/jekuta
[@koic]: https://github.com/koic
[@kristjan]: https://github.com/kristjan
[@fujimura]: https://github.com/fujimura
[@akhramov]: https://github.com/akhramov
[@iGEL]: https://github.com/iGEL
[@JoeCohen]: https://github.com/JoeCohen
[@barthez]: https://github.com/barthez
[@daniloisr]: https://github.com/daniloisr
[@meganemura]: https://github.com/meganemura
[@jonas054]: https://github.com/jonas054
[@cgriego]: https://github.com/cgriego
[@theRealNG]: https://github.com/theRealNG
[@dpostorivo]: https://github.com/dpostorivo
[@brandonweiss]: https://github.com/brandonweiss
[@iainbeeston]: https://github.com/iainbeeston
[@deivid-rodriguez]: https://github.com/deivid-rodriguez
[@klesse413]: https://github.com/klesse413
[@yujinakayama]: https://github.com/yujinakayama
[@Envek]: https://github.com/Envek
