Binary Blob Assembler (bba)
===========================

This tools read a text file describing binary data, and write that binary data
file. The usual flow is that the input to bbasm is generated by a python
script, and the output is linked or loaded into a C program, using (packed)
structs to interpret the binary data.

All references (pointers) are encoded als 32 bit byte offset relative to the
location of the pointer. This way the resulting binary blob is position
independent.

Valid commands for the input are as follows.

pre \<string\>
--------------

When a C file is generated as output, all the "pre" strings will be included
before the binary blob.

post \<string\>
---------------

When a C file is generated as output, all the "post" strings will be included
after the binary blob.

push \<name\>
-------------

All following commands up until the matching "pop" will be writen to stream
\<name\>. Everything written to the same stream will end up in a continous
region of the output. The statements `pop`, `label`, `ref`, `u8`, `u16`,
`u32`, and `str` are only valid within such a block. The name used in the
first push statement also determines the name of the variable in the generated
C output (when C is selected as output file format).

pop
---

End of a push..pop block.

label \<name\> \[\<comment\>\]
------------------------------

Add a label for the current position.

ref \<name\> \[\<comment\>\]
----------------------------

Add a 32-bit reference to the specified label. The reference will be a byte
offset relative to the memory location of the reference itself.

u8 \<value\> \[\<comment\>\]
----------------------------

Add a 8-bit value to the binary blob.

u16 \<value\> \[\<comment\>\]
-----------------------------

Add a 16-bit value to the binary blob. Note that the input must be structured
in a way that ensures that all u16 are aligned to 2-byte addresses.

u32 \<value\> \[\<comment\>\]
-----------------------------

Add a 32-bit value to the binary blob. Note that the input must be structured
in a way that ensures that all u32 are aligned to 4-byte addresses.

str "\<string\>" \[\<comment\>\]
--------------------------------

Add a reference to a zero-terminated copy of that string. Any character may be
used to quote the string, but the most common choices are `"` and `|`.
