/* armeb.v4a-linux.elf-entry.h
   created from armeb.v4a-linux.elf-entry.bin, 14509 (0x38ad) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2020 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2020 Laszlo Molnar
   Copyright (C) 2000-2020 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_ARMEB_V4A_LINUX_ELF_ENTRY_SIZE    14509
#define STUB_ARMEB_V4A_LINUX_ELF_ENTRY_ADLER32 0xd677d80a
#define STUB_ARMEB_V4A_LINUX_ELF_ENTRY_CRC32   0xa093c785

unsigned char stub_armeb_v4a_linux_elf_entry[14509] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  2,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0, 40,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0, 19,148,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,
/* 0x0030 */   0,  0,  0,  0,  0,  0,  0,  0,226, 77,208, 24,235,  0,  0, 60,
/* 0x0040 */ 233, 45, 64,252,224,129,112,  0,227,224, 80,  0,227,160, 65,  2,
/* 0x0050 */ 234,  0,  0, 20,232,189,  0, 24,224, 64,  0,  7,224, 66, 32,  3,
/* 0x0060 */ 229,132, 32,  0,225,160, 64,  0,225,160,  0,  3,224,131, 16,  2,
/* 0x0070 */ 227,160, 32,  0,239,159,  0,  2,225,160,  0,  4,232,189,128,240,
/* 0x0080 */ 228,208, 64,  1,224,164, 64,  4,225,176, 76,  4,225,160,240, 14,
/* 0x0090 */ 228,208, 48,  1,228,194, 48,  1,224,148, 64,  4, 11,  0,  0, 14,
/* 0x00a0 */  42,  0,  0, 18,227,160, 16,  1,234,  0,  0, 29,226, 65, 16,  1,
/* 0x00b0 */ 224,148, 64,  4, 11,  0,  0, 14,224,161, 16,  1,224,148, 64,  4,
/* 0x00c0 */  11,  0,  0, 14,224,161, 16,  1,224,148, 64,  4, 11,  0,  0, 14,
/* 0x00d0 */  58,  0,  0, 25,226, 81, 48,  3,227,160, 16,  0, 58,  0,  0, 45,
/* 0x00e0 */ 228,208, 80,  1,225,133, 84,  3,225,240, 80,  5, 10,  0,  0,  3,
/* 0x00f0 */ 225,176, 80,197, 42,  0,  0, 60,234,  0,  0, 48,224,148, 64,  4,
/* 0x0100 */  11,  0,  0, 14, 42,  0,  0, 60,227,160, 16,  1,224,148, 64,  4,
/* 0x0110 */  11,  0,  0, 14, 42,  0,  0, 60,224,148, 64,  4, 11,  0,  0, 14,
/* 0x0120 */ 224,161, 16,  1,224,148, 64,  4, 11,  0,  0, 14, 58,  0,  0, 52,
/* 0x0130 */ 226,129, 16,  4,234,  0,  0, 64,224,148, 64,  4, 11,  0,  0, 14,
/* 0x0140 */ 224,161, 16,  1,226,129, 16,  2,227,117, 12,  5, 50,129, 16,  1,
/* 0x0150 */ 224,130, 48,  1,229, 83, 48,  1,231,210, 48,  5,228,194, 48,  1,
/* 0x0160 */ 226, 81, 16,  1, 26,  0,  0, 68,234,  0,  0, 20,233, 45, 64,252,
/* 0x0170 */ 224,129,112,  0,227,224, 80,  0,227,160, 65,  2,234,  0,  0, 20,
/* 0x0180 */ 232,189,  0, 24,224, 64,  0,  7,224, 66, 32,  3,229,132, 32,  0,
/* 0x0190 */ 225,160, 64,  0,225,160,  0,  3,224,131, 16,  2,227,160, 32,  0,
/* 0x01a0 */ 239,159,  0,  2,225,160,  0,  4,232,189,128,240,228,208, 64,  1,
/* 0x01b0 */ 224,164, 64,  4,225,176, 76,  4,225,160,240, 14,228,208, 48,  1,
/* 0x01c0 */ 228,194, 48,  1,224,148, 64,  4, 11,  0,  0, 14, 42,  0,  0, 18,
/* 0x01d0 */ 227,160, 16,  1,234,  0,  0, 29,226, 65, 16,  1,224,148, 64,  4,
/* 0x01e0 */  11,  0,  0, 14,224,177, 16,  1,224,148, 64,  4, 11,  0,  0, 14,
/* 0x01f0 */ 224,177, 16,  1,224,148, 64,  4, 11,  0,  0, 14, 58,  0,  0, 25,
/* 0x0200 */ 226, 81, 48,  3,227,160, 16,  0, 58,  0,  0, 44,228,208, 80,  1,
/* 0x0210 */ 225,133, 84,  3,225,240, 80,  5, 10,  0,  0,  3,225,176, 80,197,
/* 0x0220 */ 234,  0,  0, 46,224,148, 64,  4, 11,  0,  0, 14,224,177, 16,  1,
/* 0x0230 */ 224,148, 64,  4, 11,  0,  0, 14,224,177, 16,  1, 26,  0,  0, 59,
/* 0x0240 */ 227,160, 16,  1,224,148, 64,  4, 11,  0,  0, 14,224,177, 16,  1,
/* 0x0250 */ 224,148, 64,  4, 11,  0,  0, 14, 58,  0,  0, 52,226,129, 16,  2,
/* 0x0260 */ 226,129, 16,  1,227,117, 12,  5, 50,129, 16,  1,229,210, 48,  0,
/* 0x0270 */ 231,210, 48,  5,228,194, 48,  1,226, 81, 16,  1, 26,  0,  0, 63,
/* 0x0280 */ 234,  0,  0, 20,224,129, 16,  0,233, 45, 64, 62,227,224, 80,  0,
/* 0x0290 */ 227,160, 65,  2,234,  0,  0, 29,232,189,  0, 26,224, 64,  0,  1,
/* 0x02a0 */ 224, 66, 32,  3,229,132, 32,  0,225,160, 64,  0,225,160,  0,  3,
/* 0x02b0 */ 224,131, 16,  2,227,160, 32,  0,239,159,  0,  2,225,160,  0,  4,
/* 0x02c0 */ 232,189,128, 48,224,148, 64,  4, 17,160,240, 14,228,208, 64,  1,
/* 0x02d0 */ 224,164, 64,  4,225,176, 76,  4,225,160,240, 14,227,160, 16,  1,
/* 0x02e0 */ 225,160,192, 14,235,  0,  0, 14,224,177, 16,  1,235,  0,  0, 14,
/* 0x02f0 */  58,  0,  0, 22,225,160,240, 12,228,208, 48,  1,228,194, 48,  1,
/* 0x0300 */ 235,  0,  0, 14, 42,  0,  0, 27,235,  0,  0, 20,226, 81, 48,  3,
/* 0x0310 */ 227,160, 16,  0, 58,  0,  0, 39,228,208, 80,  1,225,133, 84,  3,
/* 0x0320 */ 225,240, 80,  5, 10,  0,  0,  3,235,  0,  0, 14,224,177, 16,  1,
/* 0x0330 */ 235,  0,  0, 14,224,177, 16,  1, 26,  0,  0, 46,235,  0,  0, 20,
/* 0x0340 */ 226,129, 16,  2,227,117, 12, 13, 50,129, 16,  1,231,210, 48,  5,
/* 0x0350 */ 226, 81, 16,  1,228,194, 48,  1, 42,  0,  0, 48,234,  0,  0, 29,
/* 0x0360 */ 229,221,192,  0,227, 92,  0, 14, 26,255,255,254,233, 45, 72, 12,
/* 0x0370 */ 229,208,176,  0,227,160,204,  6,225,160,177,171,225,160,203, 28,
/* 0x0380 */ 225,160,176, 13,226,140,205, 58,224, 77,208, 12,229,147,192,  0,
/* 0x0390 */ 229,141, 48,  8,229,141,192,  4,229,141, 32,  0,226,141, 48, 12,
/* 0x03a0 */ 227,160,192,  0,228,131,192,  4,225, 83,  0, 11, 26,  0,  0, 15,
/* 0x03b0 */ 226,141, 48, 12,226, 65, 32,  2,225,160, 16,  0,228,209,192,  1,
/* 0x03c0 */ 226, 12,192,  7,229,205,192, 18,228,209,192,  1,225,160,  2, 44,
/* 0x03d0 */ 229,205,  0, 17,226, 12,192, 15,229,205,192, 16,226,141,  0, 16,
/* 0x03e0 */ 235,  0,  0, 40,225,160,208, 11,225,160, 48,  0,232,189,  0,  3,
/* 0x03f0 */ 229,145, 16,  0,224,129, 16,  0,227,160, 32,  0,239,159,  0,  2,
/* 0x0400 */ 225,160,  0,  3,232,189,136,  0,233, 45, 79,240,226, 77,208, 48,
/* 0x0410 */ 229,141, 48,  0,229,208, 48,  0,229,208, 80,  2,229,208,224,  1,
/* 0x0420 */ 229,157,192,  0,229,141, 48, 20,229,157, 48, 92,227,160, 64,  0,
/* 0x0430 */ 229,140, 64,  0,229,131, 64,  0,229,157,192, 20,229,208, 48,  1,
/* 0x0440 */ 224,140, 48,  3,227,160,204,  3,225,160,195, 28,227,160, 48,  1,
/* 0x0450 */ 225,160,238, 19,225,160, 53, 19,226,140,206,115,226, 67, 48,  1,
/* 0x0460 */ 226, 78,224,  1,226,128,  0,  4,226,140,192,  6,229,141, 16,  4,
/* 0x0470 */ 229,141, 48, 12,229,141,224, 16,229,141,  0,  8,234,  0,  0, 31,
/* 0x0480 */ 229,157,  0,  8,227,160, 27,  1,225,131, 16,176,225, 84,  0, 12,
/* 0x0490 */ 225,160, 48,132,226,132, 64,  1, 26,  0,  0, 28,229,157, 48,  4,
/* 0x04a0 */ 227,160, 96,  0,224,131,144,  2,225,160,224,  3,225,160, 32,  6,
/* 0x04b0 */ 229,157, 80,  4,224,101, 48,  9,225, 82,  0,  3,226,142,224,  1,
/* 0x04c0 */  10,  0,  2, 73,231,210, 48,  5,226,130, 32,  1,227, 82,  0,  5,
/* 0x04d0 */ 225,131,100,  6, 26,  0,  0, 40,227,160,176,  0,227,160,192,  1,
/* 0x04e0 */ 225,160,112, 11,227,224,  0,  0,229,141,192, 44,229,141,176, 24,
/* 0x04f0 */ 229,141,192, 28,229,141,192, 32,229,141,192, 36,234,  0,  2, 57,
/* 0x0500 */ 227,224,132,255,225, 80,  0,  8,138,  0,  0, 68,225, 94,  0,  9,
/* 0x0510 */  10,  0,  2, 73,228,222, 48,  1,225,160,  4,  0,225,131,100,  6,
/* 0x0520 */ 229,157, 16, 12,229,157, 32, 24,224, 11,160,  1,225,160, 18,  2,
/* 0x0530 */ 224,138, 48,  1,225,160, 80,131,229,157, 48,  8,225,147,192,181,
/* 0x0540 */ 225,160, 53,160,224,  4,  3,156,225, 86,  0,  4, 42,  0,  0,185,
/* 0x0550 */ 229,157,  0, 20,226, 96, 48,  8,225,160, 51, 87,229,157, 16, 16,
/* 0x0560 */ 224, 11, 32,  1,224,131, 48, 18,229,157,  0,  8,227,160, 44,  6,
/* 0x0570 */ 224, 34,  2,147,229,157, 16, 24,226,108, 59,  2,227, 81,  0,  6,
/* 0x0580 */ 224,140, 50,195,226,130,142,230,225,128, 48,181,226,136,128, 12,
/* 0x0590 */ 209,160,  0,  4,211,160, 16,  1,218,  0,  0,164,229,157, 32, 44,
/* 0x05a0 */ 229,157, 80, 84,224, 98, 48, 11,231,213,112,  3,225,160,  0,  4,
/* 0x05b0 */ 227,160, 16,  1,225,160,112,135,226,  7, 92,  1,225,160,160,129,
/* 0x05c0 */ 224,136, 48,133,224,131, 48, 10,227, 80,  4,  1,226,131, 76,  2,
/* 0x05d0 */ 226,129,192,  1, 42,  0,  0,119,225, 94,  0,  9,225,160,  4,  0,
/* 0x05e0 */  10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,225,212, 48,176,
/* 0x05f0 */ 225,160, 37,160,224,129, 16, 12,224, 12,  2,147,226, 99, 43,  2,
/* 0x0600 */ 225, 86,  0, 12,224,131, 34,194,224, 67, 50,163, 42,  0,  0,135,
/* 0x0610 */ 227, 85,  0,  0,225,160,  0, 12,225,196, 32,176,225,160, 16, 10,
/* 0x0620 */  10,  0,  0,140,225,160,  0, 12,234,  0,  0,164,227, 85,  0,  0,
/* 0x0630 */ 225,196, 48,176,224,108, 96,  6,224,108,  0,  0, 10,  0,  0,164,
/* 0x0640 */ 227, 81,  0,255,202,  0,  0,168,234,  0,  0,105,227, 80,  4,  1,
/* 0x0650 */ 224,129, 16,  3, 42,  0,  0,151,225, 94,  0,  9,225,160,  4,  0,
/* 0x0660 */  10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,225,152, 48,180,
/* 0x0670 */ 225,160, 37,160,224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,
/* 0x0680 */ 224, 67, 82,163,224,131, 50,194, 49,136, 48,180, 33,136, 80,180,
/* 0x0690 */ 224,108,  0,  0, 49,160, 16,  4, 49,160,  0, 12, 32,108, 96,  6,
/* 0x06a0 */ 227, 81,  0,255,225,160, 64,129,226,129, 48,  1,218,  0,  0,143,
/* 0x06b0 */ 229,157,192, 24,226,  1,112,255,227, 92,  0,  3,229,157, 16, 84,
/* 0x06c0 */ 211,160, 32,  0,231,193,112, 11,226,139,176,  1,213,141, 32, 24,
/* 0x06d0 */ 218,  0,  2, 57,229,157, 48, 24,227, 83,  0,  9,197,157, 80, 24,
/* 0x06e0 */ 210, 67, 48,  3,194, 69, 80,  6,213,141, 48, 24,197,141, 80, 24,
/* 0x06f0 */ 234,  0,  2, 57,224, 76, 50,172,224,100, 32,  0,229,157,192,  8,
/* 0x0700 */ 225, 82,  0,  8,225,140, 48,181,224,100, 96,  6,138,  0,  0,197,
/* 0x0710 */ 225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,
/* 0x0720 */ 225,131,100,  6,229,157,  0,  8,229,157, 48, 24,224,128,112,131,
/* 0x0730 */ 226,135, 13,  6,225,208,192,176,225,160, 53,162,224,  4,  3,156,
/* 0x0740 */ 225, 86,  0,  4, 42,  0,  0,225,229,157, 32, 24,229,157, 80,  8,
/* 0x0750 */ 227, 82,  0,  6,226,108, 59,  2,226,133, 30,102,195,160, 32,  3,
/* 0x0760 */ 229,157, 80, 32,211,160, 32,  0,224,140, 50,195,229,141, 32, 24,
/* 0x0770 */ 229,157,192, 28,229,157, 32, 44,229,141, 80, 36,226,129, 16,  4,
/* 0x0780 */ 225,160, 80,  4,229,141,192, 32,229,141, 32, 28,225,192, 48,176,
/* 0x0790 */ 234,  0,  1, 98,224,100, 32,  2,224, 76, 50,172,225, 82,  0,  8,
/* 0x07a0 */ 225,192, 48,176,224,100, 96,  6,138,  0,  0,236,225, 94,  0,  9,
/* 0x07b0 */  10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,225,131,100,  6,
/* 0x07c0 */ 226,135, 95,102,225,213,192,176,225,160, 53,162,224,  4,  3,156,
/* 0x07d0 */ 225, 86,  0,  4, 42,  0,  1, 26,226,108, 59,  2,224,140, 50,195,
/* 0x07e0 */ 225, 84,  0,  8,225,197, 48,176,138,  0,  0,252,225, 94,  0,  9,
/* 0x07f0 */  10,  0,  2, 73,228,222, 48,  1,225,160, 68,  4,225,131,100,  6,
/* 0x0800 */ 229,157, 80,  8,224,133, 48,129,224,131, 48,138,226,131, 30, 30,
/* 0x0810 */ 225,209,192,176,225,160, 53,164,224,  2,  3,156,225, 86,  0,  2,
/* 0x0820 */  32, 98, 96,  6, 32, 76, 50,172, 32, 98, 80,  4, 42,  0,  1, 50,
/* 0x0830 */ 226,108, 59,  2,224,140, 50,195,227, 91,  0,  0,225,193, 48,176,
/* 0x0840 */  10,  0,  2, 73,229,157,192, 44,229,157, 16, 24,229,157,  0, 84,
/* 0x0850 */ 224,108, 48, 11,231,208,112,  3,227, 81,  0,  6,195,160, 16, 11,
/* 0x0860 */ 211,160, 16,  9,229,141, 16, 24,231,192,112, 11,225,160,  0,  2,
/* 0x0870 */ 226,139,176,  1,234,  0,  2, 57,224,100, 32,  2,224, 76, 50,172,
/* 0x0880 */ 225, 82,  0,  8,225,197, 48,176,224,100, 96,  6,138,  0,  1, 37,
/* 0x0890 */ 225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,
/* 0x08a0 */ 225,131,100,  6,226,135, 30, 27,225,209,192,176,225,160, 53,162,
/* 0x08b0 */ 224,  4,  3,156,225, 86,  0,  4, 42,  0,  1, 52,229,157, 80, 44,
/* 0x08c0 */ 226,108, 59,  2,229,157, 32, 28,224,140, 50,195,229,141, 80, 28,
/* 0x08d0 */ 225,160, 80,  4,229,141, 32, 44,225,193, 48,176,234,  0,  1, 90,
/* 0x08e0 */ 224,100, 32,  2,224, 76, 50,172,225, 82,  0,  8,225,193, 48,176,
/* 0x08f0 */ 224,100, 96,  6,138,  0,  1, 63,225, 94,  0,  9, 10,  0,  2, 73,
/* 0x0900 */ 228,222, 48,  1,225,160, 36,  2,225,131,100,  6,226,135, 31,114,
/* 0x0910 */ 225,209,192,176,225,160, 53,162,224,  4,  3,156,225, 86,  0,  4,
/* 0x0920 */  42,  0,  1, 78,226,108, 59,  2,229,157, 32, 32,224,140, 50,195,
/* 0x0930 */ 229,157,  0, 44,229,157,192, 28,225,160, 80,  4,229,141,192, 32,
/* 0x0940 */ 229,141,  0, 28,234,  0,  1, 49,224, 76, 50,172,225,193, 48,176,
/* 0x0950 */ 229,157,192, 44,226,141, 16, 32,232,145,  0, 10,224,100, 80,  2,
/* 0x0960 */ 229,157, 32, 28,229,141, 16, 36,229,141, 32, 32,229,141,192, 28,
/* 0x0970 */ 229,141, 48, 44,224,100, 96,  6,229,157, 32, 24,229,157,  0,  8,
/* 0x0980 */ 227, 82,  0,  6,195,160, 32, 11,211,160, 32,  8,226,128, 30,166,
/* 0x0990 */ 229,141, 32, 24,226,129, 16,  8,227,224,116,255,225, 85,  0,  7,
/* 0x09a0 */ 138,  0,  1,106,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,
/* 0x09b0 */ 225,160, 84,  5,225,131,100,  6,225,209,192,176,225,160, 53,165,
/* 0x09c0 */ 224,  4,  3,156,225, 86,  0,  4, 42,  0,  1,120,224,129, 34, 10,
/* 0x09d0 */ 226,108, 59,  2,224,140, 50,195,226,130, 80,  4,225,160,  0,  4,
/* 0x09e0 */ 227,160,160,  3,227,160,128,  0,225,193, 48,176,234,  0,  1,152,
/* 0x09f0 */ 224,100, 32,  5,224, 76, 50,172,225, 82,  0,  7,224,100, 96,  6,
/* 0x0a00 */ 225,193, 48,176,138,  0,  1,131,225, 94,  0,  9, 10,  0,  2, 73,
/* 0x0a10 */ 228,222, 48,  1,225,160, 36,  2,225,131,100,  6,225,209,192,178,
/* 0x0a20 */ 225,160, 53,162,224,  4,  3,156,225, 86,  0,  4, 42,  0,  1,145,
/* 0x0a30 */ 224,129, 34, 10,226,108, 59,  2,224,140, 50,195,226,130, 95, 65,
/* 0x0a40 */ 225,160,  0,  4,227,160,160,  3,227,160,128,  8,225,193, 48,178,
/* 0x0a50 */ 234,  0,  1,152,224, 76, 50,172,225,193, 48,178,224,100, 96,  6,
/* 0x0a60 */ 224,100,  0,  2,226,129, 95,129,227,160,160,  8,227,160,128, 16,
/* 0x0a70 */ 225,160,112, 10,227,160, 16,  1,226,129, 48,  1,227, 80,  4,  1,
/* 0x0a80 */ 225,160, 64,129,224,129, 16,  3, 42,  0,  1,164,225, 94,  0,  9,
/* 0x0a90 */ 225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,
/* 0x0aa0 */ 225,149, 48,180,225,160, 37,160,224, 12,  2,147,226, 99, 43,  2,
/* 0x0ab0 */ 225, 86,  0, 12,224,131, 34,194,224, 67, 50,163,224,108,  0,  0,
/* 0x0ac0 */  49,160, 16,  4, 49,160,  0, 12, 49,133, 32,180, 32,108, 96,  6,
/* 0x0ad0 */  33,133, 48,180,226, 87,112,  1, 26,  0,  1,154,227,160, 32,  1,
/* 0x0ae0 */ 224, 65, 58, 18,229,157, 80, 24,224,131, 48,  8,227, 85,  0,  3,
/* 0x0af0 */ 229,141, 48, 40,202,  0,  2, 36,229,157,192,  8,227, 83,  0,  3,
/* 0x0b00 */ 163,160, 48,  3,224,140, 51,131,226,131, 94, 54,225,160,112,  2,
/* 0x0b10 */ 227,160,128,  6,226,135, 48,  1,227, 80,  4,  1,225,160, 64,135,
/* 0x0b20 */ 224,135,112,  3, 42,  0,  1,203,225, 94,  0,  9,225,160,  4,  0,
/* 0x0b30 */  10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,225,149, 48,180,
/* 0x0b40 */ 225,160, 37,160,224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,
/* 0x0b50 */ 224,131, 34,194,224, 67, 50,163,224,108,  0,  0, 49,160,112,  4,
/* 0x0b60 */  49,160,  0, 12, 49,133, 32,180, 32,108, 96,  6, 33,133, 48,180,
/* 0x0b70 */ 226, 88,128,  1, 26,  0,  1,193,226, 71, 32, 64,227, 82,  0,  3,
/* 0x0b80 */ 209,160, 80,  2,218,  0,  2, 30,225,160, 64,194,227, 82,  0, 13,
/* 0x0b90 */ 226,  2, 48,  1,226, 68,112,  1,227,131,192,  2,194, 68, 64,  5,
/* 0x0ba0 */ 193,160, 32,  8,202,  0,  1,237,225,160, 87, 28,229,157, 16,  8,
/* 0x0bb0 */ 224,129, 48,133,224, 67, 48,130,226,131, 78, 85,226,132, 64, 14,
/* 0x0bc0 */ 234,  0,  2,  1,227, 80,  4,  1,226,130, 32,  1, 42,  0,  1,245,
/* 0x0bd0 */ 225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,
/* 0x0be0 */ 225,131,100,  6,225,160,  0,160,225, 86,  0,  0,225,160,192,140,
/* 0x0bf0 */  32, 96, 96,  6, 35,140,192,  1,225, 82,  0,  4, 26,  0,  1,237,
/* 0x0c00 */ 229,157, 32,  8,226,130, 77, 25,226,132, 64,  4,225,160, 82, 12,
/* 0x0c10 */ 227,160,112,  4,227,160,160,  1,225,160,128, 10,227, 80,  4,  1,
/* 0x0c20 */ 225,160, 16,136,226,136,192,  1, 42,  0,  2, 12,225, 94,  0,  9,
/* 0x0c30 */ 225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,
/* 0x0c40 */ 225,148, 48,177,225,160, 37,160,224,136,128, 12,224, 12,  2,147,
/* 0x0c50 */ 226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,224, 67, 50,163,
/* 0x0c60 */  33,133, 80, 10, 49,160,128,  1, 49,160,  0, 12, 49,132, 32,177,
/* 0x0c70 */  33,132, 48,177, 32,108, 96,  6, 32,108,  0,  0,226, 87,112,  1,
/* 0x0c80 */ 225,160,160,138, 26,  0,  2,  3,226,149, 80,  1,229,141, 80, 44,
/* 0x0c90 */  10,  0,  2, 60,229,157, 48, 24,226,131, 48,  7,229,141, 48, 24,
/* 0x0ca0 */ 229,157, 80, 44,225, 85,  0, 11,138,  0,  2, 73,229,157,192, 40,
/* 0x0cb0 */ 229,157, 16, 84,224,101, 48, 11,226,140, 32,  2,224,129, 64,  3,
/* 0x0cc0 */ 224,129,192, 11,226, 82, 32,  1,229,157, 80, 88,  3,160, 48,  0,
/* 0x0cd0 */  19,160, 48,  1,226,139,176,  1,225, 91,  0,  5, 35,160, 48,  0,
/* 0x0ce0 */  50,  3, 48,  1,228,212,112,  1,227, 83,  0,  0,228,204,112,  1,
/* 0x0cf0 */  26,  0,  2, 45,229,157,192, 88,225, 91,  0, 12, 58,  0,  0, 60,
/* 0x0d00 */ 227, 80,  4,  1, 42,  0,  2, 65,225, 94,  0,  9, 10,  0,  2, 73,
/* 0x0d10 */ 226,142,224,  1,229,157,  0,  4,229,157, 16,  0,229,157, 32, 92,
/* 0x0d20 */ 224, 96, 48, 14,227,160,  0,  0,229,129, 48,  0,229,130,176,  0,
/* 0x0d30 */ 234,  0,  2, 74,227,160,  0,  1,226,141,208, 48,232,189,143,240,
/* 0x0d40 */ 233, 45, 79,248,224,130,192,  1,229,157,144, 40,229,157,112, 44,
/* 0x0d50 */ 225,160,128,  1,224,135,160,  9,226,128,176,  4,229,208, 96,  0,
/* 0x0d60 */ 229,208, 80,  1,229,208, 64,  2,224,133,224,  6,227,224,112,  0,
/* 0x0d70 */ 225,224, 85, 23,225,224, 68, 23,227,160, 48,  1,227,160, 32,  1,
/* 0x0d80 */ 227,160, 16,  1,227,160,  0,  1,233, 45, 95,255,227,160, 96,  0,
/* 0x0d90 */ 229,141, 96, 28,227,160, 44,  3,225,160, 46, 18,226,130, 32, 54,
/* 0x0da0 */ 226,130, 44,  7,225,160, 16, 11,227,160, 11,  1,227,128,  3,  1,
/* 0x0db0 */ 228,129,  0,  4,226, 82, 32,  2,202,  0,  0, 26,226,136,  0,  5,
/* 0x0dc0 */ 235,  0,  1,  5,225, 80,  0,  8, 26,  0,  0, 30,229,157, 48, 36,
/* 0x0dd0 */ 229,157, 32, 16,224, 73, 64,  3,224,  4,  0,  2,229,141,  0, 44,
/* 0x0de0 */ 224,128,  2,  6,226,139, 16,  0,235,  0,  1,  9, 26,  0,  0, 80,
/* 0x0df0 */ 229,157, 48, 20,229,157, 32, 24,224,  3, 48,  4,229,221,  0, 28,
/* 0x0e00 */ 225,160, 50, 19,226, 98, 32,  8,224,131, 50, 48,226,139,160,108,
/* 0x0e10 */ 224,131, 48,131,226,138,172, 14,227,160,  0,  1,224,138,164,131,
/* 0x0e20 */ 227, 86,  0,  7, 58,  0,  0, 69,229,157, 16,  0,231, 89, 80,  1,
/* 0x0e30 */ 225,160, 80,133,226,138, 28,  2,226,  5, 76,  1,224,129, 16,132,
/* 0x0e40 */ 235,  0,  1, 11,226,  0, 48,  1,225, 83,  4, 36, 26,  0,  0, 71,
/* 0x0e50 */ 227, 80, 12,  1, 58,  0,  0, 58,234,  0,  0, 73,225,160, 16, 10,
/* 0x0e60 */ 235,  0,  1, 11,227, 80, 12,  1, 58,  0,  0, 69,227,160, 48,  6,
/* 0x0e70 */ 227, 86,  0, 10, 51,160, 48,  3,227, 86,  0,  4, 49,160, 48,  6,
/* 0x0e80 */ 224, 70, 96,  3,234,  0,  0,112,226,139, 29,  6,235,  0,  1,  8,
/* 0x0e90 */  26,  0,  0, 95,229,157, 48,  8,229,157, 32,  4,229,157, 16,  0,
/* 0x0ea0 */ 229,141, 48, 12,229,141, 32,  8,229,141, 16,  4,227, 86,  0,  7,
/* 0x0eb0 */ 227,160, 96,  3, 51,160, 96,  0,226,139,160,100,226,138,172,  6,
/* 0x0ec0 */ 234,  0,  0,135,226,139, 31,102,235,  0,  1,  8, 26,  0,  0,114,
/* 0x0ed0 */ 229,157, 48, 44,226,139, 30, 30,224,131,  2,  6,235,  0,  1,  9,
/* 0x0ee0 */  26,  0,  0,130,227, 86,  0,  7,227,160, 96, 11, 51,160, 96,  9,
/* 0x0ef0 */ 229,157, 48, 36,229,157, 16,  0,224, 73, 64,  3,225, 84,  0,  1,
/* 0x0f00 */  58,  0,  0,253,231, 89,  0,  1,228,201,  0,  1,234,  0,  0,237,
/* 0x0f10 */ 226,139, 30, 27,235,  0,  1,  8,229,157, 64,  4, 10,  0,  0,127,
/* 0x0f20 */ 226,139, 31,114,235,  0,  1,  8,229,157, 64,  8, 10,  0,  0,125,
/* 0x0f30 */ 229,157, 48,  8,229,157, 64, 12,229,141, 48, 12,229,157, 48,  4,
/* 0x0f40 */ 229,141, 48,  8,229,157, 16,  0,229,141, 64,  0,229,141, 16,  4,
/* 0x0f50 */ 227, 86,  0,  7,227,160, 96, 11, 51,160, 96,  8,226,139,160,104,
/* 0x0f60 */ 226,138,172, 10,226,138, 16,  0,235,  0,  1, 10, 26,  0,  0,144,
/* 0x0f70 */ 229,157, 48, 44,226,138, 80,  4,227,160, 32,  0,224,133, 82,  3,
/* 0x0f80 */ 227,160, 64,  8,234,  0,  0,156,226,138, 16,  2,235,  0,  1, 10,
/* 0x0f90 */  26,  0,  0,153,229,157, 48, 44,226,138, 95, 65,227,160, 32,  8,
/* 0x0fa0 */ 224,133, 82,  3,227,160, 64,  8,234,  0,  0,156,226,138, 95,129,
/* 0x0fb0 */ 227,160, 32, 16,227,160, 76,  1,229,141, 32, 52,227,160,  0,  1,
/* 0x0fc0 */ 225,160, 16,  5,235,  0,  1, 11,224, 80, 48,  4, 58,  0,  0,158,
/* 0x0fd0 */ 229,157, 80, 52,224,133, 80,  3,229,141, 80, 52,229,157, 16,  0,
/* 0x0fe0 */ 227, 86,  0,  4, 42,  0,  0,225,226,134, 96,  7,227, 85,  0,  4,
/* 0x0ff0 */  35,160, 80,  3,224,139, 83,133,226,133, 94, 54,227,160,  0,  1,
/* 0x1000 */ 227,160, 64, 64,225,160, 16,  5,235,  0,  1, 11,224, 80, 48,  4,
/* 0x1010 */  58,  0,  0,175,229,141, 48, 44,227, 83,  0,  4, 58,  0,  0,221,
/* 0x1020 */ 225,160, 64,163,226, 68, 64,  1,226,  3, 16,  1,227,129, 16,  2,
/* 0x1030 */ 227, 83,  0, 14, 42,  0,  0,194,225,160, 20, 17,226,139,160, 94,
/* 0x1040 */ 224, 65, 48,  3,226,138,172,  5,224,138,160,131,234,  0,  0,206,
/* 0x1050 */ 226, 68, 64,  4,235,  0,  0,255,225,160,112,167,225, 92,  0,  7,
/* 0x1060 */  32, 76,192,  7,224,161, 16,  1,226, 84, 64,  1, 26,  0,  0,195,
/* 0x1070 */ 226,139,160, 68,226,138,172,  6,225,160, 18,  1,227,160, 64,  4,
/* 0x1080 */ 229,141, 16,  0,227,160, 80,  1,227,160,  0,  1,225,160, 16, 10,
/* 0x1090 */ 235,  0,  1, 11,227, 16,  0,  1, 10,  0,  0,216,229,157, 16,  0,
/* 0x10a0 */ 225,129, 16,  5,229,141, 16,  0,225,160, 80,133,226, 84, 64,  1,
/* 0x10b0 */  26,  0,  0,209,229,157, 16,  0,234,  0,  0,222,229,157, 16, 44,
/* 0x10c0 */ 226,145, 16,  1,229,141, 16,  0,229,157, 80, 52,229,157, 48, 36,
/* 0x10d0 */ 226,133, 80,  2,224, 73, 48,  3,225, 81,  0,  3,138,  0,  0,253,
/* 0x10e0 */ 229,157, 32, 40,231, 89,  0,  1,228,201,  0,  1,225, 89,  0,  2,
/* 0x10f0 */  42,  0,  0,241,226, 85, 80,  1, 26,  0,  0,231,229,205,  0, 28,
/* 0x1100 */ 229,157, 32, 40,225, 89,  0,  2, 58,  0,  0, 33,235,  0,  0,255,
/* 0x1110 */ 227,160,  0,  0,229,157, 32, 32,224, 72, 48,  2,229,157, 32, 56,
/* 0x1120 */ 229,130, 48,  0,229,157, 32, 36,224, 73, 48,  2,229,157, 32,104,
/* 0x1130 */ 229,130, 48,  0,226,141,208, 60,232,189,143,240,227,160,  0,  1,
/* 0x1140 */ 234,  0,  0,243,227, 87,  4,  1, 33,160,240, 14,229,157, 48, 48,
/* 0x1150 */ 225,160,116,  7,225, 83,  0,  8, 10,  0,  0,253,228,216, 48,  1,
/* 0x1160 */ 225,131,196, 12,225,160,240, 14,225,160,  0,  6,224,129, 16,128,
/* 0x1170 */ 227,160,  0,  0,224,129, 16,128,227, 87,  4,  1,225,160, 32, 14,
/* 0x1180 */  59,  0,  1,  1,225,209, 48,176,225,160,229,167,224, 14, 14,147,
/* 0x1190 */ 225, 92,  0, 14, 49,160,112, 14, 32, 71,112, 14, 50, 99,235,  2,
/* 0x11a0 */  32, 76,192, 14, 48,131, 50,174, 32, 67, 50,163,224,176,  0,  0,
/* 0x11b0 */ 225,193, 48,176,225,160,240,  2,229,141, 48, 20,227,160,160,  0,
/* 0x11c0 */ 224, 74,160,  6,226,142, 96,  4,224,134,224, 10,229,150, 16,  0,
/* 0x11d0 */ 227,160, 80,  0,227,224, 64,  0,227,160, 32,  3,224,129, 16, 14,
/* 0x11e0 */ 227,160,  0,  0,229,141, 16, 12,239,144,  0,192,229,141,  0,  8,
/* 0x11f0 */ 229,150, 16,  4,229,157, 64,  4,227,160, 48, 18,224,129, 16, 14,
/* 0x1200 */ 239,144,  0,192,224,128,160, 10,229,150, 48,  0,229, 45, 48,  4,
/* 0x1210 */ 225,160, 48, 13,229,214,  0,  8,229, 45,  0,  4,224,134, 32, 10,
/* 0x1220 */ 229,150, 16,  4,226,134,  0, 12,225,160, 64,  2,225,160,224, 15,
/* 0x1230 */ 229,157,240, 24,226,141,208,  4,228,157, 48,  4,229,157, 16, 20,
/* 0x1240 */ 229,132, 16,  0,229,157,  0, 16,224,131, 16,  6,224,128,  0, 10,
/* 0x1250 */ 224,129, 16, 10,229,141,  0, 16,225,160,  6, 32,227,160, 32,  5,
/* 0x1260 */ 225,160,  6,  0,224, 65, 16,  0,239,144,  0,125,229, 22, 16,  4,
/* 0x1270 */ 229,157,  0,  8,224, 73, 64,  1,224,128, 80,  1,226,134, 96,  4,
/* 0x1280 */ 226,143,224,  0,224,134,240, 10, 47,112,114,111, 99, 47,115,101,
/* 0x1290 */ 108,102, 47,101,120,101,  0,  0,227,160, 32, 14,226, 79, 16, 28,
/* 0x12a0 */ 227,160,  0,  2,239,144,  0,  4,227,160,  0,127,239,144,  0,  1,
/* 0x12b0 */ 229, 30,  0, 16,226, 78, 96, 16,229,141,224, 16,224, 70, 96,  0,
/* 0x12c0 */ 229,141, 96,  0,225,160,144,  0,226, 79,  0, 72,227,160, 16,  0,
/* 0x12d0 */ 239,144,  0,  5,227, 80,  0,  0,186,  0,  0, 54,229,141,  0,  4,
/* 0x12e0 */ 229, 30, 48, 12,235,255,255,254,  0,  0,  0,  0,102,105,108,101,
/* 0x12f0 */  32,102,111,114,109, 97,116, 32,101,108,102, 51, 50, 45, 98,105,
/* 0x1300 */ 103, 97,114,109, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10,
/* 0x1310 */  73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1320 */  32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32,
/* 0x1330 */  32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32,
/* 0x1340 */  70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32,
/* 0x1350 */  70,108, 97,103,115, 10, 32, 32, 48, 32, 69, 76, 70, 77, 65, 73,
/* 0x1360 */  78, 88, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x1370 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1380 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 52, 32, 32,
/* 0x1390 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x13a0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x13b0 */  32, 32, 49, 32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 32, 32, 32,
/* 0x13c0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x13d0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x13e0 */  48, 48, 48, 48, 48, 48, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x13f0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1400 */  76, 89, 10, 32, 32, 50, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32,
/* 0x1410 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1420 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1430 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 48, 32, 32, 50, 42, 42,
/* 0x1440 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x1450 */  68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 78, 82, 86, 50, 69, 32,
/* 0x1460 */  32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 50, 99,
/* 0x1470 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1480 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 48, 32, 32,
/* 0x1490 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x14a0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x14b0 */  32, 32, 52, 32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32,
/* 0x14c0 */  32, 32, 48, 48, 48, 48, 48, 49, 49, 56, 32, 32, 48, 48, 48, 48,
/* 0x14d0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x14e0 */  48, 48, 48, 48, 48, 49, 54, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x14f0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x1500 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 53, 32, 78, 82,
/* 0x1510 */  86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1520 */  48, 48,100, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1530 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,
/* 0x1540 */  56, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1550 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x1560 */  78, 76, 89, 10, 32, 32, 54, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x1570 */  48, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 97, 56, 32, 32,
/* 0x1580 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1590 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 54, 48, 32, 32, 50, 42,
/* 0x15a0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x15b0 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x15c0 */  55, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32,
/* 0x15d0 */  48, 48, 48, 48, 48, 57, 51, 56, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x15e0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x15f0 */  48, 48, 48, 52, 48, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1600 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x1610 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 76, 90, 77, 65,
/* 0x1620 */  95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 52,
/* 0x1630 */  55, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1640 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,100, 52, 48,
/* 0x1650 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1660 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1670 */  89, 10, 32, 32, 57, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x1680 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1690 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x16a0 */  32, 32, 48, 48, 48, 48, 49, 49, 98, 56, 32, 32, 50, 42, 42, 48,
/* 0x16b0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x16c0 */  79, 78, 76, 89, 10, 32, 49, 48, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x16d0 */  89, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x16e0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x16f0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 49, 98, 56, 32, 32, 50,
/* 0x1700 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1710 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 69, 76, 70, 77,
/* 0x1720 */  65, 73, 78, 90, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49,
/* 0x1730 */  51, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1740 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 49, 98, 56,
/* 0x1750 */  32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1760 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1770 */  89, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10,
/* 0x1780 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x1790 */  32, 78, 82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x17a0 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x17b0 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48,
/* 0x17c0 */  48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,
/* 0x17d0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86,
/* 0x17e0 */  50, 66,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50,
/* 0x17f0 */  66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1800 */ 100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48,
/* 0x1810 */  48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x1820 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1830 */ 100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48,
/* 0x1840 */  48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x1850 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1860 */ 100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48,
/* 0x1870 */  48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x1880 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1890 */ 100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  9, 48, 48,
/* 0x18a0 */  48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x18b0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x18c0 */ 100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,  9, 48, 48, 48, 48,
/* 0x18d0 */  48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48,
/* 0x18e0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69,
/* 0x18f0 */  76, 70, 77, 65, 73, 78, 88,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1900 */  32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48,
/* 0x1910 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 72,
/* 0x1920 */  69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86,
/* 0x1930 */  95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1940 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76,  9,
/* 0x1950 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 95, 84, 65, 73,
/* 0x1960 */  76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1970 */ 100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48,
/* 0x1980 */  48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 10, 48, 48,
/* 0x1990 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x19a0 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 70,
/* 0x19b0 */  76, 71, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32,103, 32, 32, 32,
/* 0x19c0 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,  9, 48, 48, 48,
/* 0x19d0 */  48, 48, 48, 48, 48, 32, 95,115,116, 97,114,116, 10, 48, 48, 48,
/* 0x19e0 */  48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82,
/* 0x19f0 */  86, 50, 69,  9, 48, 48, 48, 48, 48, 49, 50, 99, 32,117, 99,108,
/* 0x1a00 */  95,110,114,118, 50,101, 95,100,101, 99,111,109,112,114,101,115,
/* 0x1a10 */ 115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32,
/* 0x1a20 */  32, 32, 32, 70, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48,
/* 0x1a30 */  49, 49, 56, 32,117, 99,108, 95,110,114,118, 50,100, 95,100,101,
/* 0x1a40 */  99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48,
/* 0x1a50 */  48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50,
/* 0x1a60 */  66,  9, 48, 48, 48, 48, 48, 48,100, 99, 32,117, 99,108, 95,110,
/* 0x1a70 */ 114,118, 50, 98, 95,100,101, 99,111,109,112,114,101,115,115, 95,
/* 0x1a80 */  56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32,
/* 0x1a90 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48,
/* 0x1aa0 */  48, 48, 48, 48, 48, 48, 32, 76,122,109, 97, 68,101, 99,111,100,
/* 0x1ab0 */ 101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32,
/* 0x1ac0 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48,
/* 0x1ad0 */  48, 48, 48, 48, 32,101,110,100, 95,100,101, 99,111,109,112,114,
/* 0x1ae0 */ 101,115,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x1af0 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x1b00 */  48, 48, 48, 32, 79, 95, 66, 73, 78, 70, 79, 10, 48, 48, 48, 48,
/* 0x1b10 */  48, 49, 51, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x1b20 */  77, 65, 73, 78, 90,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,
/* 0x1b30 */ 112,114, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x1b40 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70,
/* 0x1b50 */  77, 65, 73, 78, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x1b60 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1b70 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b80 */  48, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32,
/* 0x1b90 */  32, 32, 32, 32, 77, 70, 76, 71, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ba0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1bb0 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 10, 82, 69,
/* 0x1bc0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x1bd0 */  32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70,
/* 0x1be0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x1bf0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x1c00 */  48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1c10 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,
/* 0x1c20 */  48, 48, 48, 48, 48, 48, 53, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x1c30 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,
/* 0x1c40 */  10, 48, 48, 48, 48, 48, 48, 54, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x1c50 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x1c60 */  69, 10, 48, 48, 48, 48, 48, 48, 54, 56, 32, 82, 95, 65, 82, 77,
/* 0x1c70 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x1c80 */  50, 69, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82,
/* 0x1c90 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x1ca0 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65,
/* 0x1cb0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x1cc0 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 56, 99, 32, 82, 95,
/* 0x1cd0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1ce0 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82,
/* 0x1cf0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d00 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 57, 99, 32,
/* 0x1d10 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1d20 */  32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 97, 99,
/* 0x1d30 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x1d40 */  32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 98,
/* 0x1d50 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1d60 */  32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1d70 */  98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1d80 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,
/* 0x1d90 */  48, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1da0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x1db0 */  48, 48, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1dc0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x1dd0 */  48, 48, 48,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1de0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x1df0 */  48, 48, 48, 48,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1e00 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x1e10 */  48, 48, 48, 48, 48,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1e20 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,
/* 0x1e30 */  48, 48, 48, 48, 48, 48,101, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x1e40 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,
/* 0x1e50 */  10, 48, 48, 48, 48, 48, 48,101, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x1e60 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x1e70 */  69, 10, 48, 48, 48, 48, 48, 48,102, 52, 32, 82, 95, 65, 82, 77,
/* 0x1e80 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x1e90 */  50, 69, 10, 48, 48, 48, 48, 48, 48,102, 99, 32, 82, 95, 65, 82,
/* 0x1ea0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x1eb0 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 50, 52, 32, 82, 95, 65,
/* 0x1ec0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x1ed0 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 50, 56, 32, 82, 95,
/* 0x1ee0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1ef0 */  78, 82, 86, 50, 69, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x1f00 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x1f10 */  82, 86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x1f20 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1f30 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48,
/* 0x1f40 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x1f50 */  32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 53,
/* 0x1f60 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1f70 */  32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x1f80 */  54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1f90 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,
/* 0x1fa0 */  48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1fb0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,
/* 0x1fc0 */  48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1fd0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,
/* 0x1fe0 */  48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1ff0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x2000 */  48, 48, 48, 48, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2010 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48,
/* 0x2020 */  48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2030 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10,
/* 0x2040 */  48, 48, 48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2050 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,
/* 0x2060 */  10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x2070 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x2080 */  68, 10, 48, 48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 65, 82, 77,
/* 0x2090 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x20a0 */  50, 68, 10, 48, 48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 65, 82,
/* 0x20b0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x20c0 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 99, 56, 32, 82, 95, 65,
/* 0x20d0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x20e0 */  82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,100, 48, 32, 82, 95,
/* 0x20f0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2100 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,100, 99, 32, 82,
/* 0x2110 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2120 */  32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,101, 56, 32,
/* 0x2130 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2140 */  32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,101, 99,
/* 0x2150 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2160 */  32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 49, 49,
/* 0x2170 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2180 */  32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 49,
/* 0x2190 */  49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x21a0 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 10, 82, 69, 76, 79,
/* 0x21b0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x21c0 */  79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83,
/* 0x21d0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x21e0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x21f0 */  48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2200 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48,
/* 0x2210 */  48, 48, 48, 48, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2220 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48,
/* 0x2230 */  48, 48, 48, 48, 48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2240 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10,
/* 0x2250 */  48, 48, 48, 48, 48, 48, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2260 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66,
/* 0x2270 */  10, 48, 48, 48, 48, 48, 48, 55, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x2280 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x2290 */  66, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77,
/* 0x22a0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x22b0 */  50, 66, 10, 48, 48, 48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82,
/* 0x22c0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x22d0 */  86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65,
/* 0x22e0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x22f0 */  82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 97, 48, 32, 82, 95,
/* 0x2300 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2310 */  78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 97, 52, 32, 82,
/* 0x2320 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2330 */  32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 97, 99, 32,
/* 0x2340 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2350 */  32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 98, 52,
/* 0x2360 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2370 */  32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 98,
/* 0x2380 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2390 */  32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,
/* 0x23a0 */ 100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x23b0 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48,
/* 0x23c0 */  48,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x23d0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 10, 82, 69, 76,
/* 0x23e0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x23f0 */  70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 93,
/* 0x2400 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x2410 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x2420 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 65, 82,
/* 0x2430 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2440 */  77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 52,
/* 0x2450 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2460 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48,
/* 0x2470 */  48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2480 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 69,
/* 0x2490 */  76, 70, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x24a0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90,
/* 0x24b0 */  77, 65, 95, 68, 69, 67, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x24c0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x24d0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x24e0 */  48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x24f0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2500 */  48, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77,
/* 0x2510 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2520 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 98, 56,
/* 0x2530 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2540 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2550 */  48, 48, 48, 48, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2560 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2570 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 48,102, 52, 32, 82, 95, 65,
/* 0x2580 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2590 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x25a0 */  48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x25b0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x25c0 */  48, 48, 48, 48, 48, 49, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x25d0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x25e0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 52, 52, 32, 82,
/* 0x25f0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2600 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2610 */  48, 49, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2620 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2630 */  48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32, 82, 95, 65, 82, 77,
/* 0x2640 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2650 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49,100, 56,
/* 0x2660 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2670 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2680 */  48, 48, 48, 50, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2690 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x26a0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 49, 56, 32, 82, 95, 65,
/* 0x26b0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x26c0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,
/* 0x26d0 */  50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x26e0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x26f0 */  48, 48, 48, 48, 48, 50, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2700 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2710 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 51, 99, 32, 82,
/* 0x2720 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2730 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2740 */  48, 50, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2750 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2760 */  48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32, 82, 95, 65, 82, 77,
/* 0x2770 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2780 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 53, 56,
/* 0x2790 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x27a0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x27b0 */  48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x27c0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x27d0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 99, 56, 32, 82, 95, 65,
/* 0x27e0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x27f0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,
/* 0x2800 */ 101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2810 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2820 */  48, 48, 48, 48, 48, 51, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2830 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2840 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 48, 99, 32, 82,
/* 0x2850 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2860 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2870 */  48, 51, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2880 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2890 */  48, 10, 48, 48, 48, 48, 48, 51, 56, 56, 32, 82, 95, 65, 82, 77,
/* 0x28a0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x28b0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 97, 48,
/* 0x28c0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x28d0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x28e0 */  48, 48, 48, 51, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x28f0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2900 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 99, 99, 32, 82, 95, 65,
/* 0x2910 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2920 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,
/* 0x2930 */ 101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2940 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2950 */  48, 48, 48, 48, 48, 51,101, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2960 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2970 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 50, 52, 32, 82,
/* 0x2980 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2990 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x29a0 */  48, 52, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x29b0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x29c0 */  48, 10, 48, 48, 48, 48, 48, 52, 54, 99, 32, 82, 95, 65, 82, 77,
/* 0x29d0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x29e0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 56, 52,
/* 0x29f0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2a00 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2a10 */  48, 48, 48, 52, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2a20 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2a30 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 98, 48, 32, 82, 95, 65,
/* 0x2a40 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2a50 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,
/* 0x2a60 */ 100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2a70 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2a80 */  48, 48, 48, 48, 48, 52,101, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2a90 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2aa0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,102, 52, 32, 82,
/* 0x2ab0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ac0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2ad0 */  48, 53, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2ae0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2af0 */  48, 10, 48, 48, 48, 48, 48, 53, 51, 99, 32, 82, 95, 65, 82, 77,
/* 0x2b00 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2b10 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 57, 56,
/* 0x2b20 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2b30 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2b40 */  48, 48, 48, 53, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2b50 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2b60 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 99, 48, 32, 82, 95, 65,
/* 0x2b70 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2b80 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53,
/* 0x2b90 */ 101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2ba0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2bb0 */  48, 48, 48, 48, 48, 53,102, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2bc0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2bd0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 48, 52, 32, 82,
/* 0x2be0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2bf0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2c00 */  48, 54, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2c10 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2c20 */  48, 10, 48, 48, 48, 48, 48, 54, 52, 56, 32, 82, 95, 65, 82, 77,
/* 0x2c30 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2c40 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 56, 48,
/* 0x2c50 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2c60 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2c70 */  48, 48, 48, 54, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2c80 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2c90 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 54,100, 48, 32, 82, 95, 65,
/* 0x2ca0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2cb0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,
/* 0x2cc0 */ 101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2cd0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2ce0 */  48, 48, 48, 48, 48, 55, 49, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2cf0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2d00 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 50, 56, 32, 82,
/* 0x2d10 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2d20 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2d30 */  48, 55, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2d40 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2d50 */  48, 10, 48, 48, 48, 48, 48, 55, 55, 99, 32, 82, 95, 65, 82, 77,
/* 0x2d60 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2d70 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 57, 99,
/* 0x2d80 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2d90 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2da0 */  48, 48, 48, 55, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2db0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2dc0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 99, 52, 32, 82, 95, 65,
/* 0x2dd0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2de0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,
/* 0x2df0 */ 100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2e00 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2e10 */  48, 48, 48, 48, 48, 55,102, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2e20 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2e30 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 50, 48, 32, 82,
/* 0x2e40 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2e50 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2e60 */  48, 56, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2e70 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2e80 */  48, 10, 48, 48, 48, 48, 48, 56, 55, 99, 32, 82, 95, 65, 82, 77,
/* 0x2e90 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2ea0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 56, 56,
/* 0x2eb0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2ec0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2ed0 */  48, 48, 48, 56, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2ee0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2ef0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 56,101, 56, 32, 82, 95, 65,
/* 0x2f00 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2f10 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,
/* 0x2f20 */ 102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2f30 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2f40 */  48, 48, 48, 48, 48, 56,102, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2f50 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2f60 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 57, 48, 52, 32, 82,
/* 0x2f70 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2f80 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2f90 */  48, 57, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2fa0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2fb0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x2fc0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95,
/* 0x2fd0 */  68, 69, 67, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x2fe0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ff0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 55,
/* 0x3000 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3010 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3020 */  48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3030 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3040 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 56, 56, 32, 82, 95,
/* 0x3050 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3060 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3070 */  48, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3080 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3090 */  10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x30a0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x30b0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,101, 52, 32,
/* 0x30c0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x30d0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x30e0 */  48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x30f0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3100 */  49, 48, 10, 48, 48, 48, 48, 48, 49, 48, 99, 32, 82, 95, 65, 82,
/* 0x3110 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3120 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 49,
/* 0x3130 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3140 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3150 */  48, 48, 48, 48, 49, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3160 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3170 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 50, 48, 32, 82, 95,
/* 0x3180 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3190 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x31a0 */  49, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x31b0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x31c0 */  10, 48, 48, 48, 48, 48, 49, 52, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x31d0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x31e0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 52, 99, 32,
/* 0x31f0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3200 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3210 */  48, 48, 49, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3220 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3230 */  49, 48, 10, 48, 48, 48, 48, 48, 49, 56, 48, 32, 82, 95, 65, 82,
/* 0x3240 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3250 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 56,
/* 0x3260 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3270 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3280 */  48, 48, 48, 48, 49, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3290 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x32a0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 57, 99, 32, 82, 95,
/* 0x32b0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x32c0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x32d0 */  49, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x32e0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x32f0 */  10, 48, 48, 48, 48, 48, 49, 99, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x3300 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3310 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32,
/* 0x3320 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3330 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3340 */  48, 48, 49,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3350 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3360 */  49, 48, 10, 48, 48, 48, 48, 48, 49,100, 99, 32, 82, 95, 65, 82,
/* 0x3370 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3380 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,101,
/* 0x3390 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x33a0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x33b0 */  48, 48, 48, 48, 49,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x33c0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x33d0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 50, 56, 32, 82, 95,
/* 0x33e0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x33f0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3400 */  50, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3410 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3420 */  10, 48, 48, 48, 48, 48, 50, 52, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x3430 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3440 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32,
/* 0x3450 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3460 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3470 */  48, 48, 50, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3480 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3490 */  49, 48, 10, 48, 48, 48, 48, 48, 50, 54, 56, 32, 82, 95, 65, 82,
/* 0x34a0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x34b0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 56,
/* 0x34c0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x34d0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x34e0 */  48, 48, 48, 48, 50, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x34f0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3500 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95,
/* 0x3510 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3520 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3530 */  50, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3540 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3550 */  10, 48, 48, 48, 48, 48, 50,100, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x3560 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3570 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,100, 99, 32,
/* 0x3580 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3590 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x35a0 */  48, 48, 50,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x35b0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x35c0 */  49, 48, 10, 48, 48, 48, 48, 48, 51, 48, 99, 32, 82, 95, 65, 82,
/* 0x35d0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x35e0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 49,
/* 0x35f0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3600 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3610 */  48, 48, 48, 48, 51, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3620 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3630 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 53, 48, 32, 82, 95,
/* 0x3640 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3650 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3660 */  51, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3670 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3680 */  10, 48, 48, 48, 48, 48, 51, 55, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x3690 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x36a0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 55, 56, 32,
/* 0x36b0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x36c0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x36d0 */  48, 48, 51, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x36e0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x36f0 */  49, 48, 10, 48, 48, 48, 48, 48, 51, 98, 48, 32, 82, 95, 65, 82,
/* 0x3700 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3710 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 98,
/* 0x3720 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3730 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3740 */  48, 48, 48, 48, 51, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3750 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3760 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 99, 99, 32, 82, 95,
/* 0x3770 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3780 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3790 */  52, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x37a0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x37b0 */  10, 48, 48, 48, 48, 48, 52, 49, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x37c0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x37d0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 52, 48, 32,
/* 0x37e0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x37f0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x3800 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x3810 */  32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 90, 93, 58,
/* 0x3820 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x3830 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x3840 */  69, 10, 48, 48, 48, 48, 48, 49, 50, 48, 32, 82, 95, 65, 82, 77,
/* 0x3850 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x3860 */  77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 49, 50, 99, 32, 82,
/* 0x3870 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3880 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 49,
/* 0x3890 */  51, 48, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32,
/* 0x38a0 */  32, 32, 32, 32, 32, 79, 95, 66, 73, 78, 70, 79, 10
};
