% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colCummaxs.R, R/colCummins.R, R/colCumprods.R,
%   R/colCumsums.R, R/rowCummaxs.R, R/rowCummins.R, R/rowCumprods.R,
%   R/rowCumsums.R
\name{colCummaxs,DelayedMatrix-method}
\alias{colCummaxs,DelayedMatrix-method}
\alias{colCummins,DelayedMatrix-method}
\alias{colCumprods,DelayedMatrix-method}
\alias{colCumsums,DelayedMatrix-method}
\alias{rowCummaxs,DelayedMatrix-method}
\alias{rowCummins,DelayedMatrix-method}
\alias{rowCumprods,DelayedMatrix-method}
\alias{rowCumsums,DelayedMatrix-method}
\title{Calculates the cumulative maxima for each row (column) of a matrix-like
object}
\usage{
\S4method{colCummaxs}{DelayedMatrix}(x, rows = NULL, cols = NULL, force_block_processing = FALSE, ...)

\S4method{colCummins}{DelayedMatrix}(x, rows = NULL, cols = NULL, force_block_processing = FALSE, ...)

\S4method{colCumprods}{DelayedMatrix}(x, rows = NULL, cols = NULL, force_block_processing = FALSE, ...)

\S4method{colCumsums}{DelayedMatrix}(x, rows = NULL, cols = NULL, force_block_processing = FALSE, ...)

\S4method{rowCummaxs}{DelayedMatrix}(x, rows = NULL, cols = NULL, force_block_processing = FALSE, ...)

\S4method{rowCummins}{DelayedMatrix}(x, rows = NULL, cols = NULL, force_block_processing = FALSE, ...)

\S4method{rowCumprods}{DelayedMatrix}(x, rows = NULL, cols = NULL, force_block_processing = FALSE, ...)

\S4method{rowCumsums}{DelayedMatrix}(x, rows = NULL, cols = NULL, force_block_processing = FALSE, ...)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{matrix}}with the same
dimensions as \code{x}.
}
\description{
Calculates the cumulative maxima for each row (column) of a matrix-like
object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowCummaxs}
/ \code{matrixStats::colCummaxs}.
}
\examples{
# A DelayedMatrix with a 'matrix' seed
dm_matrix <- DelayedArray(matrix(c(rep(1L, 5),
                                   as.integer((0:4) ^ 2),
                                   seq(-5L, -1L, 1L)),
                                 ncol = 3))
# A DelayedMatrix with a 'Matrix' seed
dm_Matrix <- DelayedArray(Matrix::Matrix(c(rep(1L, 5),
                                           as.integer((0:4) ^ 2),
                                           seq(-5L, -1L, 1L)),
                                         ncol = 3))

colCummaxs(dm_matrix)

colCummins(dm_matrix)

colCumprods(dm_matrix)

colCumsums(dm_matrix)

# Only use rows 2-4
rowCummaxs(dm_Matrix, rows = 2:4)

# Only use rows 2-4
rowCummins(dm_Matrix, rows = 2:4)

# Only use rows 2-4
rowCumprods(dm_Matrix, rows = 2:4)

# Only use rows 2-4
rowCumsums(dm_Matrix, rows = 2:4)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:rowCumsums]{rowCummaxs}()} and
\code{matrixStats::\link[matrixStats:rowCumsums]{colCummaxs}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For single maximum estimates, see \code{\link[MatrixGenerics]{rowMaxs}()}.
\item \code{base::\link{cummax}()}.
}
}
\author{
Peter Hickey

Peter Hickey

Peter Hickey

Peter Hickey
}
