C
C   Copyright (c) 1997 Silvano Bonazzola
C
C    This file is part of LORENE.
C
C    LORENE is free software; you can redistribute it and/or modify
C    it under the terms of the GNU General Public License as published by
C    the Free Software Foundation; either version 2 of the License, or
C    (at your option) any later version.
C
C    LORENE is distributed in the hope that it will be useful,
C    but WITHOUT ANY WARRANTY; without even the implied warranty of
C    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C    GNU General Public License for more details.
C
C    You should have received a copy of the GNU General Public License
C    along with LORENE; if not, write to the Free Software
C    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
C
C
C

	SUBROUTINE MAGL3S(NN,NDIM,COEF,BB) 

C
C## Routine modifiee le 20.02.1995 : suppression des variables inutiles
C
	IMPLICIT NONE
C
C	ROUTINE POUR LE CALCUL DES MATRICES NECESSAIRES POUR LA
C	SOLUTION DE L'EQUATION DE POISSON DANS UNE COQUILLE ET DANS UNE
C	COQUILLE COMPACTIFIEE OU DANS UNE COQUILLE AVEC DEVELOPPEMENT EN 1/r.
C	LES CONDITIONS AU CONTOUR SONT FIXEES: (PREMIER COEFF. DU DEVELOPPE-
C	MENT=0)
C	ET CHOISIES EN FONCTION DE LA COMMODITE DU CALCUL. POUR IMPOSER
C	DES CONDITIONS AU CONTOUR ARBITRAIRES IL FAUT AJOUTER A LA SOLUTION 
C	INHOMOGENE 2 SOLUTIONS DE L'EQUATION HOMOGENE.
C
C	LA MATRICE DE L'OPERATEUR LAPLACIEN EST A DETERMINANT NUL. ON CALCULE
C	LA MATRICE DE L'OPERATEUR AYANT COMME CONDITION SUPPLEMENTAIRE
C	LE PREMIER COEFFICIENT DE LA SOLUTION = 0, SI R2 > 10*R1 ET LE 1ER
C	ET 2EME COEFFICIENT NUL DANS LE CAS OPPOSE'
C
C	POUR SOUCI DE GENERALITE',LES MATRICES DES OPERATEURS SUIVANTS SONT
C	CALCULEES: MATRICE DE TYPE 'A'(AID0A,DE10A,DE11A,DE20A,DE21A,DE22A)
C	MATRICE DES OPERATEURS IDENTITE, D/dr, r*D/dr, D2/dr2, r*D2/dr2
C	r**2*D/dr2 AGISSANTS SUR Tn(r).
C	MATRICES DE TYPES 'B' ET 'C': LES MEMES OPERATEURS AGISSANTS RESPECTI-
C	VEMENT SUR Tn+1(r) ET Tn+2(r). AVEC CES MATRICES ON PEUT INVERSER L'O-
C	PERATEUR 
C
C		CSI**2*C1*D2/dr2+CSI*C(2)*D/dr +C3   SI C3.NE.0
C	ET     CSI*C1*D2/dr2 + D/dr		     SI C3=0 
C	
C	(CSI=COEF(4)+COEF(5)*r.)
C
C	BIEN ENTENDU,D'AUTRES OPERATEURS PEUVENT ETRE PRIS EN CONSIDERATION.
C
C	LA ROUTINE GLAGOS CALCULE LES COEFFICIENTS COEF(1),COEF(2),COEF(3) 
C	
C	  N.B.
C         ----
C
C	LES ERREURS D'ALIASING DANS LE CALCUL DU POTENTIEL NE SONT PAS
C	ELIMINEES
C	
C		ARGUMENTS DE LA ROUTINE:
C
C		ROUTINE MAGL3S(NN,NDIM,COEF,BB) 
C	
C		NN	=NOMBRE DE DEGRES DE LIBERTE'
C		NDIM	=DIMENSIONS DES TABLEAUX
C		COEF	=COEFFICIENTS DE L'OPERATEUR A INVERSER
C		BB	=MATRICE DE L'OPERATEUR COMPLET. LES DIMENSIONS MINIMES
C			 DANS LE PROGRAMME APPELANT LA ROUTINE DOIVENT ETRE 
C			 .GE. (NN+2,10)
C
C
C
C $Id: magl3s.f,v 1.2 2012/03/30 12:12:44 j_novak Exp $
C $Log: magl3s.f,v $
C Revision 1.2  2012/03/30 12:12:44  j_novak
C Cleaning of fortran files
C
C Revision 1.1.1.1  2001/11/20 15:19:30  e_gourgoulhon
C LORENE
C
c Revision 1.2  1997/05/23  11:39:09  hyc
c *** empty log message ***
c
C Revision 1.1  1997/05/08 07:38:13  hyc
C Initial revision
C
C
C $Header: /cvsroot/Lorene/F77/Source/Poisson2d/magl3s.f,v 1.2 2012/03/30 12:12:44 j_novak Exp $
C
	character*120 header
	data header/'$Header: /cvsroot/Lorene/F77/Source/Poisson2d/magl3s.f,v 1.2 2012/03/30 12:12:44 j_novak Exp $'/

	INTEGER NN,NDIM,N,N1,NCONT,N12,ND,L,IDEG,J

	double PRECISION BB,COEF,DE10A,DE11A,DE20A,DE21A,DE22A
     1	,COE1,COE2,COE3,RAP,R1,R2,AID0A,XL,X4,XN5,XN3,XN4,X5,X1,C22
     1	,C21,C20,C11,C10,C00,X3

	PARAMETER (ND=257)
C
	DIMENSION BB(NDIM,*),COEF(*)
	DIMENSION AID0A(ND,8)
	DIMENSION DE10A(ND,8)
	DIMENSION DE11A(ND,8)
	DIMENSION DE20A(ND,8)
	DIMENSION DE21A(ND,8)
	DIMENSION DE22A(ND,8)
C	
C	DIMENSION AID0C(ND,8),DE10C(ND,8),DE11C(ND,8),DE20C(ND,8)
C	DIMENSION DE21C(ND,8),DE22C(ND,8)
C
C	DIMENSION AID0B(ND,8),DE10B(ND,8),DE11B(ND,8),DE20B(ND,8)
C	DIMENSION DE21B(ND,8),DE22B(ND,8)
C
	SAVE AID0A,DE10A,DE11A,DE20A,DE21A,DE22A,NCONT
C
	DATA NCONT/0/
C
	N=NN
	N1=N+1
	N12=N1-2
C
	IF(N.GE.ND) THEN
	PRINT*,'DIMENSIONS INSUFFISANTES DANS LA ROUTINE MAGL3S'
	STOP
	ENDIF
C
C		LE RAYON INTERIEUR ET EXTERIEUR DE LA COQUILLE ONT ETE STOCKES
C		DANS BB(N1,4), BB(N1,5) DANS LA ROUTINE GLAGOS.
C
	R1=BB(N1,4)
	R2=BB(N1,5)
	IDEG=BB(N1,6)
C
	IF(N.EQ.NCONT) GO TO 999
C
	NCONT=N
C
	DO 3 J=1,8
	DO 4 L=1,N1
	AID0A(L,J)=0
	DE20A(L,J)=0
	DE21A(L,J)=0
	DE22A(L,J)=0
C
C	AID0B(L,J)=0
C	DE20B(L,J)=0
C	DE21B(L,J)=0
C	DE22B(L,J)=0
C
   4	CONTINUE
   3	CONTINUE
C
C		PREPARATION DES MATRICES DE TYPE 'A'
C
	DO 5 L=1,N-1
	XL=L
	DE22A(L,3)=(L-1)*(L-2)/XL
	DE22A(L,4)=-(L-1)*4
	DE22A(L,6)=-(4*L+12)
	DE22A(L,5)=(7*L**2+5*L-2)/XL-((L+1)*L)/(XL+2)
	DE22A(L,7)=(L**2+7*L+12)/(XL+2)
C
	DE21A(L,4)=-(L-1)*2
	DE21A(L,5)=4*L+4
	DE21A(L,6)=-2*L-6
C
	DE20A(L,5)=4*L+4
C
	DE11A(L,3)=(L-1)/XL
	DE11A(L,4)=-2
	DE11A(L,6)=2
	DE11A(L,7)=-(L+3)/(XL+2)
C
	DE10A(L,4)=-2
	DE10A(L,6)=2
C
	AID0A(L,3)=1/XL
	AID0A(L,5)=-(1/XL+1/(XL+2))
	AID0A(L,7)=1/(XL+2)
   5	CONTINUE
C
	DE11A(1,5)=1.3333333333333333333333
	DE11A(2,5)=.750
C
	DO 60 L=3,N1-4
  	DE11A(L,5)=-DE11A(L+2,3)-DE11A(L-2,7)
  60	CONTINUE
	DO 6 L=N1-5,N12
	DE22A(L,7)=0
   6	CONTINUE
C
	DO 7 L=N1-4,N12
	DE22A(L,6)=0
   7	CONTINUE
C
	DO 8 L=N1-3,N12
	DE21A(L,5)=0
	DE22A(L,5)=0
   8	CONTINUE
C
	DE21A(N-5,6)=-(2*N-4)
C	DE21A(N-5,7)= (4*N**2-16*N+16)
	DE21A(N-5,7)=0
C
	DE21A(N-4,6)=-DE21A(N-4,4)*(N-2)
	DE21A(N-4,7)=-DE21A(N-4,5)*(N-1)
C
	DE21A(N-3,4)=-(2*N-8)
	DE21A(N-3,6)=-DE21A(N-3,4)*(N-1)
C
C
	DE21A(N-2,4)=-(2*N**2-10*N+12)
	DE21A(N-2,5)=4*N**2-12*N+8
	DE21A(N-2,6)=-(3*N**2-5*N)
	DE21A(N-4,8)=-DE21A(N-2,6)-2*N
C
	DE21A(N-1,4)=-(2*N**2-6*N+4)
	DE21A(N-1,5)= 2*N**2-2*N
	DE21A(N-1,6)=0
C
C	DE21A(N-3,7)=-DE21A(N-3,5)*(N-4)

	DE21A(N-3,7)=-DE21A(N-1,5)+2*N
	DE21A(N,4)=-N*(N-1)
C
	X4=N1-4
	XN5=N-5
	XN3=N-3
	DE22A(N-5,5)=-(N**2-9*N+20)/XN3+(7*N**2-65*N+148)/XN5
	DE22A(N-5,6)=-(4*N-8)
	DE22A(N-5,7)=(8*N**2-56*N+80)/XN5-(7*N**2-37*N+46)/XN3
C	
	DE22A(N1-5,5)=(N**3-4*N**2-11*N+42)/(X4-1)
	DE22A(N1-5,6)=DE22A(N1-5,6)*(N1-3)
	DE22A(N1-4,5)=(N**3-N**2-16*N+28)/X4
C
	DE22A(N-2,3)=N**2-7*N+12
	DE22A(N-2,4)=-(4*N**2-20*N+24)
	DE22A(N-2,5)=8*N**2-26*N+18
	DE22A(N-2,6)=-(6*N**2-10*N)
C
	DE22A(N,3)=(N-1)*(N-2)
	DE22A(N,4)=-2*(N**2-N)
	DE22A(N12,3)=N**2-5*N+6
	DE22A(N12,4)=-(4*N**2-12*N+8)
	DE22A(N12,5)=4*N**2-5*N
C
	XN3=N-3
	DE22A(N-3,3)=(N**2-9*N+20)/XN3
	DE22A(N-3,4)=-(4*N-16)
	DE22A(N-3,5)=(7*N**2-37*N+46)/XN3-(N**2-5*N+6)
	DE22A(N-3,6)=4*N**2-20*N+16
	DE22A(N-3,7)=-(4*N**2-9*N)
C
	XN4=N-4
	DE22A(N-4,5)=(7*N**2-51*N+90)/XN4-(N**2-7*N+12)
	DE22A(N-4,6)=4*N**2-28*N+40
	DE22A(N-4,7)=-(8*N**2-34*N+26)
C	DE22A(N-4,8)=24*N**2-56*N
	DE22A(N-4,8)=6*N**2-14*N
C
	DE20A(N-4,7)=-DE20A(N-4,5)*(N-1)
	DE20A(N-3,7)=-N*DE20A(N-3,5)*.5
	DE20A(N-2,5)=4*N**2-12*N+8
	DE20A(N-1,5)=2*N**2-2*N
C
	DE10A(N-5,6)=2
C
	DE10A(N-4,6)=2*(N-2)
	DE10A(N-4,8)=N
	DE10A(N-2,4)=-2*(N-2)
C
	DE10A(N-3,4)=-2
	DE10A(N-3,6)=(2*N-2)
C
	DE10A(N-2,6)=-N
C
	DE10A(N12,4)=-(2*N-2)
	DE10A(N12,6)=0
C
	DE10A(N,4)=-N
C
	X3=N-3
	X5=N-5
C
	DE11A(N-5,5)=(N-4)*(1/X5-1/X3)
	DE11A(N-5,6)=2
	DE11A(N-5,7)=-(N-2)/X3
C
	DE11A(N-4,5)=-DE11A(N-4,3)*(N-3)
	DE11A(N-4,6)= (N-2)*2
	DE11A(N-4,7)=-(N-1)*2
	DE11A(N-4,8)=N
C
	DE11A(N-3,3)=(N-4)/X3
	DE11A(N-3,4)=-2
	DE11A(N-3,5)=-(N-2)*DE11A(N-3,3)
	DE11A(N-3,6)= (2*N-2)
	DE11A(N-3,7)=-N
C
	DE11A(N-2,3)=N-3
	DE11A(N-2,4)=-2*(N-2)
	DE11A(N-2,5)=2*N-2
	DE11A(N-2,6)=-N
	DE11A(N-2,7)=0
C
	DE11A(N12,3)=N-2
	DE11A(N-1,4)=-(2*N-2)
	DE11A(N-1,5)=N
	DE11A(N-1,6)=0
	DE11A(N-1,7)=0
C
	DE11A(N,3)=N-1
	DE11A(N,4)=-N
C
	DE11A(N1,3)=N/2
C
	X1=1
	AID0A(N-5,5)=-(X1/(N-3)+X1/(N-5))
	AID0A(N-5,7)=X1/(N-3)
	AID0A(N-4,5)=-(1+X1/(N-4))
	AID0A(N-4,7)=0
C
	AID0A(N-3,3)=X1/(N-3)
	AID0A(N-3,5)=-(1+X1/(N-3))
	AID0A(N-3,7)=0
C
	AID0A(N12,3)=1
	AID0A(N-2,3)=1
C
	DO 13 J=4,7
	AID0A(N-2,J)=0
	AID0A(N12,J)=0
  13	CONTINUE
C
	AID0A(N,3)=1
C
C          PREPARATION DES MATRICES 'B'
C
C	DO 14 L=1,N12-2
C	XL=L
C	AID0B(L,2)=1/XL
C	AID0B(L,4)=-(1/XL+1/(XL+2))
C	AID0B(L,6)=1/(XL+2)
C
C	DE10B(L,3)=-2
C	DE10B(L,5)=2
C
C	DE11B(L+1,2)=L/(XL+1)
C	DE11B(L,3)=-2
C	DE11B(L,4)=1/XL+1/(XL+2)
C	DE11B(L,5)=2
C	DE11B(L,6)=-(1+1/(XL+2))
C
C	DE20B(L,4)=4*L+4
C
C	DE21B(L+1,3)=-L*2
C	DE21B(L,4)=4*L+4
C	DE21B(L,5)=-(2*L+6)
C
C	DE22B(L,2)=(L-1)*(L-2)/XL
C	DE22B(L,3)=-(L-1)*4
C	DE22B(L,4)=(7*L**2+5*L-2)/XL-((L+1)*L)/(XL+2)
C	DE22B(L,5)=-(4*L+12)
C	DE22B(L,6)=(L**2+7*L+12)/(XL+2)
C
C  14	CONTINUE
C
C	X9=N-3
C	AID0B(1,2)=0
C	AID0B(N-4,4)=(N-5)/(X9-1)
C	AID0B(N-4,5)=0
C	AID0B(N-4,6)=0
C	AID0B(N-3,4)=(N-4)/X9
C	AID0B(N-3,6)=0
C	AID0B(N-2,2)=1	
C	AID0B(N-1,2)=1
C
C	DE10B(N-4,5)=-2*(N-2)
C	DE10B(N-3,5)=-2*(N-1)
C	DE10B(N-2,3)=-2*(N-2)
C	DE10B(N-1,3)=-2*(N-1)
C
C	XN3=N-3
C	DE11B(1,2)=0
C	DE11B(N-4,4)=(N**2-6*N+9)/(X3-1)
C	DE11B(N-4,5)=-(2*N-4)
C	DE11B(N-4,6)=2*N-2
C	DE11B(N-3,4)=(N**2-4*N+4)/XN3
C	DE11B(N-3,5)=-(2*N-2)
C	DE11B(N-3,6)=0
C	DE11B(N-2,2)=N-3
C	DE11B(N-2,3)=-(2*N-4)
C	DE11B(N-2,4)=2*N-2
C	DE11B(N-1,2)=N-2
C	DE11B(N-1,3)=-(2*N-2)
C
C	DE20B(N-4,6)=4*N**2-8*N+4
C	DE20B(N-2,4)=4*N**2-12*N+8
C
C	DE21B(N-3,5)=-(2*N**2-2*N)
C	DE21B(N-4,5)=-(2*N**2-6*N+4)
C	DE21B(N-4,6)=4*N**2-8*N+4
C	DE21B(N-2,4)=4*N**2-12*N+8 
C	DE21B(N-1,3)=-(2*N**2-6*N+4)
C	DE21B(N-2,3)=-(2*N**2-10*N+12)
C
C	DE22B(N-4,4)=(N**3-4*N**2-11*N+42)/(X3-1)
C	DE22B(N-4,5)=-(4*N**2-12*N+8)
C	DE22B(N-4,6)=8*N**2-18*N+10
C	DE22B(N-3,4)=(N**3-N**2-16*N+28)/X3
C	DE22B(N-3,5)=-(4*N**2-4*N)
C	DE22B(N-3,6)=0
C	DE22B(N-2,4)=(8*N**2-26*N+18)
C	DE22B(N-2,3)=-(4*N**2-20*N+24)
C	DE22B(N-2,2)=N**2-7*N+12
C	DE22B(N-1,2)=N**2-5*N+6
C	DE22B(N-1,3)=-(4*N**2-12*N+8)
C
C		PREPARATION DES MATRICE DE TYPE 'C'
C
C	DO 15 L=1,N-3
C	XL=L
C	AID0C(L,1)=1/XL
C	AID0C(L,3)=-(1/XL+1/(XL+2))
C	AID0C(L,5)=1/(XL+2)
C
C	DE10C(L,2)=-2
C	DE10C(L,4)=2
C
C	DE11C(L+2,1)=(L+1)/(XL+2)
C	DE11C(L+1,2)=-2
C	DE11C(L,3)=1/XL+1/(XL+2)
C	DE11C(L,4)=2
C	DE11C(L,5)=-(1+1/(XL+2))
C
C	DE20C(L,3)=4*L+4
C
C	DE21C(L+1,2)=-2*L
C	DE21C(L,3)=4*L+4
C	DE21C(L,4)=-2*L-6
C
C	DE22C(L,1)=(L-1)*(L-2)/XL
C	DE22C(L,2)=-(L-1)*4
C	DE22C(L,3)=(7*L**2+5*L-2)/XL-((L+1)*L)/(XL+2)
C	DE22C(L,4)=-(4*L+12)
C	DE22C(L,5)=(L**2+7*L+12)/(XL+2)
C
C   15	CONTINUE
C
C	AID0C(1,1)=0
C	AID0C(2,1)=0
C
C	AID0B(1,2)=0
C	AID0C(N-5,3)=1-X1/(N-5)
C	AID0C(N-5,5)=0
C	AID0C(N-4,3)=(N-5)/(X9-1)
C
C	AID0C(N-3,1)=1
C	AID0C(N-3,3)=(N-4)/X9
C	AID0C(N-3,3)=0
C	AID0C(N-4,5)=0
C	AID0C(N-3,5)=0
C
C	AID0C(N-2,1)=1
C	AID0C(N-1,1)=1
C
C	DE10C(1,2)=0
C
C	DE10C(N-5,4)=-(2*N-6)
C	DE10C(N-5,6)=-2*(N-1)
C
C	DE10C(N-4,4)=-2*(N-2)
C	DE10C(N-4,6)=-N
C
C	DE10C(N-3,2)=-(2*N-6)
C	DE10C(N-3,4)=-2*(N-1)
C
C	DE10C(N-2,2)=-2*(N-2)
C	DE10C(N-2,4)=-N
C	DE10C(N-1,2)=-2*(N-1)
C
C	DE11C(N-5,3)=DE11A(N-5,5)
C	DE11C(N-5,4)=DE11A(N-5,6)
C	DE11C(N-5,5)=DE11A(N-5,7)
C	DE11C(N-5,6)=-(2*N-2)
C	DE11C(N-5,7)=N
C
C	DE11C(N-4,3)=(N**2-6*N+9)/(X3-1)
C	DE11C(N-4,4)=-(2*N-4)
C	DE11C(N-4,5)=2*N-2
C	DE11C(N-4,6)=-N
C
C	DE11C(N-3,1)=DE11A(N-3,3)
C	DE11C(N-3,2)=DE11A(N-3,4)
C	DE11C(N-3,3)=DE11A(N-3,5)
C	DE11C(N-3,4)=-(2*N-2)
C	DE11C(N-3,5)=N
C
C	DE11C(N-2,1)=N-3
C	DE11C(N-2,2)=-(2*N-4)
C	DE11C(N-2,3)=2*N-2
C	DE11C(N-2,4)=-N
C	DE11C(N-1,1)=N-2
C	DE11C(N-1,2)=-(2*N-2)	
C	DE11C(N-1,3)=N
C
C	DE20C(N-5,5)=4*N**2-16*N+16
C	DE20C(N-5,7)=4*N**2-6*N
C
C	DE20C(N-3,3)=4*N**2-20*N+24
C	DE20C(N-3,5)=4*N*(N-2)
C
C	DE20C(N-4,5)=4*N**2-8*N+4
C	DE20C(N-2,3)=4*N**2-12*N+8
C	DE20C(N-1,3)=2*N**2-2*N
C
C	DE21C(N-5,4)=DE21A(N-5,6)
C	DE21C(N-5,5)=DE21A(N-5,7)
C	DE21C(N-5,6)=-(6*N**2-18*N+12)
C	DE21C(N-5,7)=+(4*N**2-6*N)
C
C	DE21C(N-4,4)=-(2*N**2-6*N+4)
C	DE21C(N-4,5)=4*N**2-8*N+4
C	DE21C(N-4,6)=-(3*N**2-3*N)
C
C	DE21C(N-3,2)=DE21A(N-3,4)
C	DE21C(N-3,3)=DE21A(N-3,5)
C	DE21C(N-3,4)=-(6*N**2-22*N+16)
C	DE21C(N-3,5)=+(4*N**2-8*N)
C	DE21C(N-3,6)=0
C	DE21C(N-3,7)=-DE21C(N-3,7)
C
C	DE21C(N-2,2)=-(2*N**2-10*N+12)
C	DE21C(N-2,3)=4*N**2-12*N+8
C	DE21C(N-2,4)=-(3*N**2-5*N)
C
C	DE21C(N-1,2)=-(2*N**2-6*N+4)
C	DE21C(N-1,3)=2*N**2-2*N
C
C	DE22C(N-5,3)=DE22A(N-5,5)
C	DE22C(N-5,4)=DE22A(N-5,6)
C	DE22C(N-5,5)=DE22A(N-5,7)
C	DE22C(N-5,6)=-(12*N**2-36*N+24)
C	DE22C(N-5,7)= (8*N**2-13*N)
C
C	DE22C(N-4,3)=(N**3-4*N**2-11*N+42)/(X3-1)
C	DE22C(N-4,4)=-(4*N**2-12*N+8)
C	DE22C(N-4,5)=8*N**2-18*N+10
C	DE22C(N-4,6)=-(6*N**2-6*N)
C
C	DE22C(N-3,1)=DE22A(N-3,3)
C	DE22C(N-3,2)=DE22A(N-3,4)
C	DE22C(N-3,3)=DE22A(N-3,5)
C	DE22C(N-3,4)=-(12*N**2-44*N+32)
C	DE22C(N-3,5)=(8*N**2-17*N)
C
C	DE22C(N-2,1)=N**2-7*N+12
C	DE22C(N-2,2)=-(4*N**2-20*N+24)
C	DE22C(N-2,3)=(8*N**2-26*N+18)
C	DE22C(N-2,4)=-(6*N**2-10*N)
C
C	DE22C(N-1,1)=N**2-5*N+6
C	DE22C(N-1,2)=-(4*N**2-12*N+8)
C	DE22C(N-1,3)=4*N**2-5*N
C
999	CONTINUE
C
C		PREPARATIONS DES BB: MATRICE DE L'OPERATEUR COMPLET
C
	C22=COEF(1)
	C21=COEF(2)
	C20=COEF(3)
	C11=COEF(4)
	C10=COEF(5)
	C00=COEF(6)
C
	COE1=COEF(7)
	COE2=COEF(8)
	COE3=COEF(9)
C
	DO 20 L=1,N1+1
	DO 21 J=1,10
	BB(L,J)=0
   21	CONTINUE
   20	CONTINUE
C
C
C		CAS OU R2 < R1 (CAS MINCE DEGENERE COEF(3)=0)
C
	IF(IDEG.EQ.316) THEN
C
	BB(1,2)=1
	BB(2,2)=1
C
	DO 30 L=1,N1
	DO 31 J=4,8
	BB(L+2,J-3)=C21*DE21A(L,J)+C20*DE20A(L,J)+C10*DE10A(L,J)
   31	CONTINUE
   30	CONTINUE
C
	BB(N1-3,5)=BB(N1-3,5)*2
	BB(N1-2,4)=BB(N1-2,4)*2
	BB(N1-1,3)=BB(N1-1,3)*2
	BB(N1,2)=BB(N1,2)*2
C
		IF(ABS(BB(N1,2)).LT.1.E-8) THEN
	PRINT*,'LE CALCUL NE PEUT PAS ETRE EFFECTUE DANS LA ROUTINE MAGL3S'
	PRINT*,'CHANGER OU LES COEFFICIENTS DE L''OPERATEUR OU LE NOMBRE'
	PRINT*,'DES DEGRES DE LIBERTE OU LA METHODE D''ELIMINATION DU'
	PRINT*,'TERME EN PLUS DANS LA DIAGONALE DE LA MATRICE'
	STOP
	ENDIF
C
	RAP=BB(N1-3,5)/BB(N1,2)
	DO 36 L=4,5
	BB(N1-3,L)=BB(N1-3,L)-BB(N1,L-3)*RAP
   36	CONTINUE
C
	BB(N1-3,5)=0
	BB(N1,3)=RAP
C
	RAP=BB(N1-2,4)/BB(N1,2)
	DO 32 J=3,4
	BB(N1-2,J)=BB(N1-2,J)-BB(N1,J-2)*RAP
   32	CONTINUE
C
	BB(N1,4)=RAP
C
	IF(ABS(BB(N1-2,3)).LT.1.E-8) THEN
	PRINT*,'LE CALCUL NE PEUT PAS ETRE EFFECTUE DANS LA ROUTINE MAGL3S'
	PRINT*,'CHANGER OU LES COEFFICIENTS DE L''OPERATEUR OU LE NOMBRE'
	PRINT*,'DES DEGRES DE LIBERTE OU LA METHODE D''ELIMINATION DU'
	PRINT*,'TERME EN PLUS DANS LA DIAGONALE DE LA MATRICE'
	STOP
	ENDIF
	RAP=BB(N1-3,4)/BB(N1-2,3)
C
	DO 33 J=2,4
	BB(N1-3,J)=BB(N1-3,J)-BB(N1-2,J-1)*RAP
   33	CONTINUE
	BB(N1-3,4)=0
	BB(N1,6)=RAP
C
	BB(1,5)=N
	BB(N1+1,1)=COE1
	BB(N1+1,2)=COE2
	BB(N1+1,3)=0
C
	BB(N1+1,4)=R1
	BB(N1+1,5)=R2
C
	BB(N1,5)=316.1
C
	RETURN
	ENDIF
C
C		CAS R2 < 10*R1 (CAS NON DEGENERE).(CAS COQUILLE MINCE)
C
C	IF(IDEG.EQ.317.OR.IDEG.EQ.318) THEN
	IF(IDEG.EQ.317.OR.IDEG.EQ.318) THEN
C
	BB(1,3)=1
	BB(2,3)=1
C
	DO 40 L=1,N1
	DO 41 J=3,8
	BB(L+2,J-2)=C22*DE22A(L,J)+C21*DE21A(L,J)+C20*DE20A(L,J)+
     1	C11*DE11A(L,J)+C10*DE10A(L,J)+AID0A(L,J)*C00
   41	CONTINUE
   40	CONTINUE
C
	DO J=3,7
	BB(N1+3-J,J)=BB(N1+3-J,J)*2
	ENDDO
C
	RAP=BB(N1-3,6)/BB(N1,3)
	BB(N1,4)=RAP
C
	DO 34 J=4,6
	BB(N1-3,J)=BB(N1-3,J)-BB(N1,J-3)*RAP
   34	CONTINUE
	BB(N1-3,6)=0
C
	BB(1,5)=N
	BB(N1+1,1)=COE1
	BB(N1+1,2)=COE2
	BB(N1+1,3)=COE3
C
	BB(N1+1,4)=R1
	BB(N1+1,5)=R2
C
	BB(N1,5)=IDEG+.1
C
	RETURN
	ENDIF
C
	IF(IDEG.EQ.315) THEN
C
C		CAS COMPACTIFIE
C
	BB(1,2)=1
C
	DO L=1,N1-1
	DO J=3,8
	BB(L+1,J-2)=C22*DE22A(L,J)+C21*DE21A(L,J)+C20*DE20A(L,J)+
     1	C11*DE11A(L,J)+C10*DE10A(L,J)+AID0A(L,J)*C00
	ENDDO
	ENDDO
C
C
C	BB(N1-3,5)=BB(N1-3,5)*2
C	BB(N1-2,4)=BB(N1-2,4)*2
CC	BB(N1-1,3)=BB(N1-1,3)*2
C	BB(N1,2)=BB(N1,2)*2
C
	BB(N1-5,6)=BB(N1-5,6)*2
	DO J=2,6
	BB(N1+2-J,J)=BB(N1+2-J,J)*2
	ENDDO
C
	RAP=BB(N1-4,6)/BB(N1,2)
	BB(N1,4)=RAP
C
	BB(N1-4,5)=BB(N1-4,5)-BB(N1,1)*RAP
	BB(N1-4,6)=0
C
	BB(1,5)=N
	BB(N1+1,1)=COE1
	BB(N1+1,2)=COE2
	BB(N1+1,3)=COE3
C
	BB(N1+1,4)=R1
	BB(N1+1,5)=R2
C
	BB(N1,5)=IDEG+.1
C
	RETURN
	ENDIF
C
  100	FORMAT(1X,10E11.4)
  101	FORMAT(1X,' ')
	RETURN
	END
C

