/*
** winmbox.c   Windows message box function.
**
** Part of willus.com general purpose C code library.
**
** Copyright (C) 2020  http://willus.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU Affero General Public License as
** published by the Free Software Foundation, either version 3 of the
** License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Affero General Public License for more details.
**
** You should have received a copy of the GNU Affero General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/

#include "willus.h"

#ifdef HAVE_WIN32_API

#include <windows.h>
#include <stdio.h>
#include <string.h>

#define WMB_LINERAT 1.0

typedef struct
    {
    HFONT mf;
    HFONT bf;
    HWND hwnd;
    HWND parent;
    HWND edit_hwnd;
    HWND pass_hwnd;
    HWND b1_hwnd;
    HWND b2_hwnd;
    HWND b3_hwnd;
    char b1[256];
    char b2[256];
    char b3[256];
    char inbuflabel[64];
    char *inbuf;
    int  maxlen;
    char passlabel[64];
    char *passbuf;
    int  passmaxlen;
    char msg[1024];
    int  maxwidth;
    int  width;
    int  height;
    int  status;
    int  buttoncolor[3];
    int  dbx1,dby1,dbw,dbh;
    HBRUSH brush;
    double mfsize;
    double bfsize;
    HINSTANCE hinstance;
    char class[32];
    RECT aboutbox;
    RECT messagebox;
    WNDPROC eclassproc;
    void *myproc;
    int modal;
    char *title;
    } WINMBOX;

static unsigned int n_magplus = 2903;
static unsigned char xmagplus[2903] = {
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,48,0,0,0,48,8,2,0,0,0,216,
96,110,208,0,0,0,9,112,72,89,115,0,0,14,196,0,0,14,196,1,149,43,14,27,0,0,11,
9,73,68,65,84,120,218,197,216,73,108,27,215,25,7,240,239,205,12,103,56,92,196,
85,162,168,133,218,41,81,18,109,45,166,76,201,91,101,215,177,211,184,110,220,
58,78,107,244,16,52,105,209,75,81,116,57,164,1,130,6,40,208,164,135,4,45,218,
20,70,131,38,69,227,54,75,19,47,170,29,203,2,226,77,142,19,71,214,46,89,149,
68,81,18,101,138,90,184,138,28,114,182,55,211,131,128,0,77,23,52,146,108,255,
47,51,131,185,252,240,97,222,251,190,55,72,85,85,248,239,81,85,21,99,44,73,146,
32,8,24,43,8,1,73,146,12,195,104,52,26,130,32,16,66,176,213,161,254,199,187,
76,38,179,176,16,206,101,57,130,162,13,122,173,70,67,3,40,130,136,115,185,172,
170,128,197,98,44,41,41,33,73,106,107,65,232,63,86,40,151,203,141,143,79,40,
42,174,174,40,213,82,234,224,224,237,225,161,137,197,232,154,162,98,167,85,223,
224,113,111,111,241,73,192,132,66,225,60,147,169,174,206,115,127,65,193,96,48,
16,8,212,215,86,74,185,196,75,191,249,235,31,206,77,66,218,14,58,27,176,90,32,
16,100,114,32,197,129,142,124,235,80,201,143,191,255,77,163,173,40,188,184,210,
218,186,195,100,202,187,47,160,225,225,225,240,189,133,150,109,238,55,254,114,
254,185,223,14,131,161,156,53,48,79,28,105,106,242,22,141,45,38,77,58,186,216,
172,239,253,100,230,234,205,233,108,70,196,107,83,63,57,81,244,204,83,79,6,230,
150,90,90,119,56,157,206,45,6,141,140,140,76,254,227,110,115,99,245,179,47,189,
251,254,85,177,217,239,118,22,90,24,147,238,196,145,38,130,32,63,153,139,25,
89,218,83,168,231,56,225,204,229,209,2,13,121,103,116,97,108,100,225,72,107,
234,103,63,56,118,111,49,182,255,192,35,118,187,125,203,64,145,200,226,7,23,
47,108,107,172,124,249,181,155,239,92,231,247,119,122,188,13,69,28,205,86,122,
203,236,5,121,52,67,103,9,146,4,96,176,156,203,138,75,145,100,98,38,156,89,77,
6,130,43,55,110,77,31,223,41,127,247,73,223,114,44,123,242,228,183,73,146,220,
12,136,124,225,133,23,214,239,222,122,235,237,98,135,165,183,111,254,119,103,
163,187,118,213,150,187,157,150,178,18,87,67,89,77,169,105,155,195,248,254,155,
61,227,99,193,169,161,41,155,156,219,215,90,193,107,40,75,129,85,144,148,36,
151,101,73,242,218,64,182,204,146,46,41,200,155,95,8,187,221,238,45,88,246,159,
246,245,229,184,20,69,90,126,121,58,228,170,118,22,86,57,118,236,106,52,91,116,
73,0,35,169,210,44,24,10,236,197,85,69,162,32,50,98,78,163,33,244,36,240,12,
177,215,95,83,225,178,93,251,112,40,154,200,156,186,196,253,177,1,223,29,27,
107,111,239,176,90,173,27,6,17,235,151,222,27,215,29,246,188,51,55,98,10,169,
171,247,186,246,238,111,118,22,24,57,89,209,50,68,62,171,97,16,168,128,18,209,
116,124,117,77,37,73,130,4,59,171,65,4,240,138,100,41,48,183,237,110,104,244,
150,198,179,202,213,17,217,98,162,175,92,185,178,153,10,17,0,48,63,63,31,139,
69,29,249,214,183,122,238,149,87,230,183,250,61,38,171,142,64,32,19,132,142,
209,220,229,148,91,25,136,42,36,207,137,124,90,156,151,201,143,211,234,188,164,
232,104,42,45,34,0,156,239,180,55,180,84,151,151,154,255,118,45,97,53,179,99,
163,99,155,2,41,138,50,48,48,160,211,82,247,146,212,90,90,174,173,47,45,44,115,
228,68,121,73,144,181,12,201,80,4,67,19,38,22,180,12,195,11,106,46,39,233,117,
26,11,139,12,140,134,165,73,137,64,171,2,78,137,82,73,181,171,188,186,104,113,
57,157,226,13,162,144,14,4,2,27,255,134,68,81,156,153,9,228,233,217,177,32,175,
183,232,170,182,85,0,69,82,58,194,100,210,233,116,20,203,128,81,3,36,2,163,129,
93,90,147,4,9,108,70,214,165,5,164,213,100,65,99,176,177,92,90,77,197,179,136,
148,170,27,203,62,190,57,57,17,2,179,142,158,152,152,172,174,174,222,56,40,26,
77,212,187,29,189,119,114,246,252,60,71,145,141,209,18,35,253,129,172,32,235,
12,6,138,166,181,26,146,213,51,209,164,36,1,129,21,98,100,96,110,97,106,81,200,
100,184,28,175,42,40,147,230,188,62,79,81,89,145,179,188,48,207,164,189,151,
192,37,197,204,210,82,120,83,21,202,229,56,163,78,31,77,10,214,2,19,203,50,58,
150,9,205,71,195,203,156,41,223,66,105,13,26,173,142,214,42,8,81,88,85,20,64,
51,179,73,46,22,203,196,226,217,68,92,145,148,232,114,172,168,196,81,230,46,
203,51,27,141,70,93,42,173,50,52,21,143,39,55,14,82,20,5,99,76,16,128,16,210,
234,180,4,73,146,36,36,99,220,252,108,210,194,51,116,30,163,205,83,181,102,138,
2,5,167,37,46,193,37,35,241,100,100,57,179,178,42,198,86,0,0,86,147,130,40,146,
8,209,12,73,179,52,66,64,82,148,44,75,27,7,145,36,169,209,104,50,28,239,176,
91,103,120,140,16,18,101,185,197,95,93,89,47,26,76,121,140,86,203,232,89,155,
197,56,58,155,158,159,203,18,25,180,167,163,202,110,168,137,199,146,66,38,35,
43,176,182,198,149,87,23,203,50,70,136,148,177,106,51,107,49,86,25,134,217,56,
136,166,105,86,175,143,198,19,219,221,181,125,87,102,85,164,8,188,180,111,127,
131,197,68,24,8,160,1,104,0,7,192,175,83,233,96,80,225,5,252,104,103,213,161,
90,123,28,64,6,16,0,82,0,171,9,88,93,90,83,21,28,139,166,61,157,165,107,233,
156,121,19,29,141,96,24,38,223,102,227,178,82,107,157,241,222,252,170,44,170,
178,4,153,12,159,76,138,209,132,28,79,226,100,70,201,2,100,115,2,198,34,198,
82,54,195,199,0,150,211,202,98,10,71,146,114,44,42,113,169,140,130,149,108,78,
140,47,173,117,108,179,197,147,153,210,210,210,141,131,40,138,170,173,173,205,
100,249,146,124,57,143,64,139,225,168,10,170,130,85,21,16,0,32,2,0,1,5,160,74,
18,96,9,17,10,129,16,5,64,34,88,159,94,21,132,176,10,128,96,118,42,82,96,201,
179,27,115,92,86,240,122,189,27,7,17,4,225,247,251,179,89,105,104,104,236,185,
239,117,220,186,58,46,99,36,203,138,172,2,0,32,5,72,0,10,0,99,73,85,69,4,152,
4,117,189,155,171,0,24,171,10,198,178,164,200,24,93,239,25,122,246,153,29,67,
35,83,70,163,169,184,184,120,83,173,195,106,181,22,151,20,45,199,51,143,249,
77,139,119,231,35,145,148,40,42,18,143,37,4,152,0,69,5,0,144,37,1,99,1,99,25,
43,138,2,160,168,160,168,128,9,16,36,5,99,117,102,106,41,29,142,125,99,159,109,
122,46,188,211,239,223,108,47,3,128,199,31,127,60,28,94,26,30,27,121,243,23,
135,206,159,190,153,72,241,57,94,22,177,34,98,16,21,117,13,64,149,36,66,150,
52,4,150,36,57,167,128,8,170,4,32,72,42,159,195,177,4,255,222,159,62,124,239,
87,143,125,210,55,176,182,198,29,62,124,120,107,6,180,83,167,78,229,178,217,
157,173,245,51,43,182,215,7,226,135,190,214,226,116,232,76,102,198,72,34,11,
67,230,51,96,3,144,1,162,0,81,30,18,130,204,73,106,106,77,92,89,229,222,125,
227,198,143,30,169,172,178,46,143,77,133,234,234,60,123,246,238,221,130,10,1,
192,211,79,127,103,101,117,117,122,46,178,173,60,247,195,61,69,151,207,14,4,
102,147,43,209,92,66,196,203,130,58,149,86,250,56,117,48,141,131,105,37,42,224,
20,175,196,226,124,112,46,249,206,235,55,126,254,245,250,54,55,30,15,44,52,248,
118,250,124,62,0,232,238,238,230,121,126,179,19,35,73,146,141,141,13,103,207,
157,103,180,250,178,66,242,169,3,13,221,31,206,140,46,100,100,21,201,88,21,1,
241,88,205,72,176,150,147,150,98,252,92,40,117,179,55,152,24,157,251,243,79,
119,49,106,248,206,208,68,48,56,119,160,243,75,90,157,225,214,205,94,132,208,
181,107,215,220,110,247,6,118,200,207,159,58,150,151,151,95,121,229,229,234,
26,119,77,69,169,215,93,153,83,44,31,12,167,62,154,79,112,64,145,90,18,129,42,
112,178,70,146,154,11,117,199,124,118,87,62,190,51,50,241,209,199,125,52,195,
218,237,86,189,94,231,112,58,107,220,117,133,249,246,133,80,232,114,79,207,209,
163,71,11,10,10,54,123,46,19,4,225,181,215,94,11,45,44,248,59,58,242,77,121,
14,187,169,188,184,144,102,116,169,180,172,2,50,104,9,138,18,23,34,43,11,145,
248,212,204,236,224,224,192,129,3,95,62,122,244,40,0,252,254,213,87,111,127,
250,233,190,189,123,143,62,113,194,108,48,198,87,151,47,117,119,119,118,118,
186,92,174,205,158,92,1,96,122,122,250,157,183,223,142,198,99,133,69,37,101,
165,229,6,3,75,105,40,80,64,196,114,34,22,159,155,155,141,69,163,13,13,158,19,
39,158,252,108,130,238,232,232,192,24,187,92,174,175,60,250,232,193,35,95,45,
176,219,164,44,119,190,171,171,181,117,71,109,109,237,102,65,235,73,165,82,3,
3,3,3,253,253,209,88,148,231,121,2,17,172,142,45,45,41,109,219,217,230,245,110,
163,168,127,57,216,63,255,252,243,151,47,95,174,169,169,225,56,238,240,161,67,
7,143,60,86,84,88,76,1,190,240,247,11,21,149,149,77,77,77,91,0,250,162,121,241,
197,23,187,187,187,171,170,170,86,87,87,15,236,239,124,228,200,145,50,87,185,
158,161,47,93,186,100,54,155,219,219,219,191,192,42,219,146,236,217,179,103,
105,105,105,104,104,168,188,188,188,127,96,128,75,173,217,243,11,24,131,193,
91,95,63,59,27,12,4,102,42,43,43,31,40,104,221,20,137,68,70,71,71,235,234,234,
250,238,220,73,196,86,237,246,124,141,78,223,80,87,155,136,199,135,134,134,106,
106,106,30,40,8,0,118,239,222,29,10,133,198,199,199,183,111,223,126,167,191,
127,101,41,146,111,183,83,44,91,91,83,163,42,202,245,27,55,60,30,207,3,5,173,
215,105,118,118,246,238,221,187,62,159,111,120,100,36,52,63,159,111,179,2,173,
173,169,172,48,232,245,61,61,61,13,13,13,15,20,244,153,105,124,124,220,239,247,
79,77,77,5,103,102,108,102,179,66,209,85,229,101,133,14,71,87,87,87,125,125,
253,191,255,20,188,143,32,0,216,181,107,87,36,18,25,28,28,108,111,111,15,45,
44,76,78,78,154,13,122,76,209,229,174,210,50,151,235,204,153,51,110,183,251,
115,123,199,253,5,1,64,91,91,91,60,30,239,239,239,239,232,232,88,89,89,25,27,
27,53,178,172,76,16,165,206,226,90,119,205,217,179,103,43,42,42,104,154,126,
112,32,0,104,105,105,225,56,238,246,237,219,126,191,159,227,184,145,209,81,134,
36,49,34,10,28,5,245,158,186,11,23,46,56,157,78,150,101,31,28,8,0,188,94,175,
40,138,183,110,221,106,107,107,195,24,15,15,15,19,8,16,34,237,54,171,167,190,
190,187,187,219,106,181,26,141,198,7,7,2,0,143,199,163,209,104,122,123,123,155,
155,155,105,154,30,25,25,145,68,129,160,40,139,217,220,216,216,120,245,234,85,
157,78,103,50,153,40,120,128,57,120,240,160,94,175,191,120,241,162,207,231,99,
89,118,98,98,66,146,36,81,20,27,27,27,15,31,62,124,229,202,21,85,85,183,184,
151,253,63,25,28,28,236,234,234,218,177,99,71,56,28,158,156,156,180,88,44,109,
62,95,163,215,107,54,155,251,250,250,30,2,8,0,38,39,39,207,157,59,215,220,220,
28,137,68,166,167,167,53,26,77,107,107,107,101,101,165,32,8,15,7,4,0,129,64,
224,252,249,243,77,77,77,209,104,52,24,12,174,172,172,248,124,190,227,199,143,
19,240,144,82,93,93,125,236,216,177,177,177,49,151,203,165,215,235,9,130,56,
121,242,36,77,211,15,173,66,235,9,133,66,167,78,157,10,133,66,167,79,159,190,
47,3,218,6,178,188,188,172,213,106,77,38,211,250,227,63,1,56,221,152,226,175,
174,108,15,0,0,0,0,73,69,78,68,174,66,96,130};

unsigned int n_magminus = 2855;
unsigned char xmagminus[2855] = {
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,48,0,0,0,48,8,2,0,0,0,216,
96,110,208,0,0,0,9,112,72,89,115,0,0,14,196,0,0,14,196,1,149,43,14,27,0,0,10,
217,73,68,65,84,120,218,197,216,105,108,91,217,117,7,240,115,239,125,11,31,119,
82,148,40,106,161,104,89,164,76,73,180,37,75,212,208,242,204,164,182,235,140,
167,227,184,118,58,241,180,70,129,6,73,26,228,75,81,32,201,135,36,192,32,3,20,
200,36,31,18,32,200,130,65,7,104,130,212,237,204,180,83,47,170,29,203,6,98,123,
44,199,177,45,91,187,172,74,162,54,202,18,181,144,148,72,113,125,239,221,123,
251,65,109,144,164,11,18,73,246,252,65,224,61,130,120,192,15,7,120,231,156,75,
196,57,135,255,59,156,115,74,169,166,105,165,82,137,82,134,16,16,66,100,89,22,
69,17,99,140,16,130,221,142,240,255,252,150,205,102,23,22,22,11,249,28,22,36,
179,201,32,138,18,0,43,169,180,80,200,115,6,14,135,165,166,166,134,16,97,119,
65,232,127,173,80,161,80,24,27,27,103,156,54,236,169,53,8,124,96,224,193,208,
224,248,82,34,195,56,245,56,77,205,193,192,129,131,97,13,228,88,108,209,106,
179,237,219,23,124,182,160,153,153,153,104,52,218,212,88,175,21,214,191,253,
253,127,254,251,75,19,176,233,2,99,25,40,6,192,8,178,5,208,82,32,197,255,226,
149,154,47,127,233,207,45,101,85,139,75,171,237,237,29,54,155,245,153,128,134,
134,134,22,159,46,28,220,31,248,201,63,93,254,198,15,134,192,236,83,204,242,
103,78,182,182,134,170,70,151,54,108,70,169,218,110,234,189,63,125,235,238,84,
62,171,210,204,228,87,206,86,125,225,179,111,68,231,150,15,182,119,120,60,158,
93,6,13,15,15,79,252,199,147,182,150,134,175,125,251,95,254,237,150,218,22,9,
120,42,29,178,205,120,246,100,43,198,228,254,92,210,162,72,193,74,83,46,87,186,
112,125,164,66,36,143,70,22,70,135,23,78,182,167,191,254,55,103,158,46,37,143,
30,251,164,203,229,218,53,80,60,190,244,243,171,87,246,183,212,127,247,221,187,
31,124,84,60,122,36,24,106,174,202,73,74,125,168,206,106,55,34,140,211,26,19,
49,54,17,208,117,154,92,203,174,79,47,102,215,54,162,51,171,119,238,77,189,254,
130,254,215,111,132,87,146,249,115,231,254,146,16,178,19,16,121,235,173,183,
182,238,222,123,239,253,106,183,163,183,111,254,135,23,19,135,15,55,250,2,30,
71,93,141,183,185,206,95,107,107,176,201,62,171,56,147,167,22,9,119,186,13,110,
179,68,141,178,163,194,89,210,216,70,46,175,16,114,187,63,95,231,216,172,169,
176,206,47,44,6,2,129,157,128,240,214,229,97,95,95,33,151,22,8,250,214,249,152,
183,193,83,185,215,221,113,184,165,57,232,145,21,98,33,156,99,46,16,172,19,204,
8,150,8,2,132,77,4,64,198,47,71,252,159,122,45,28,12,213,120,170,173,239,92,
43,73,132,62,25,29,77,165,82,187,0,234,189,243,145,219,101,189,112,39,201,136,
177,41,228,125,249,104,155,167,194,146,211,153,65,198,229,138,168,16,2,24,100,
73,68,162,168,33,76,4,112,41,34,194,80,100,154,163,194,222,249,98,115,75,168,
54,149,103,183,134,117,135,77,186,121,243,230,78,65,243,243,243,201,100,194,
93,238,124,239,198,83,95,125,121,123,36,104,115,26,49,2,29,99,163,44,62,201,
177,251,155,250,237,52,147,21,65,21,241,221,52,125,184,169,207,107,204,40,9,
155,42,2,160,229,30,87,243,193,6,95,173,253,95,111,175,59,237,202,232,200,232,
142,64,140,177,254,254,126,163,65,120,186,33,100,54,245,198,166,218,202,58,119,
65,213,151,75,186,65,38,178,128,101,9,59,20,217,170,16,89,192,178,128,173,138,
232,80,68,179,44,42,18,209,48,90,43,209,180,170,213,52,120,125,13,85,75,43,155,
233,162,89,45,109,70,163,209,237,143,14,85,85,167,167,163,86,147,50,58,83,52,
57,140,123,247,239,1,145,136,70,98,115,152,204,38,108,84,192,12,80,4,80,129,
148,0,0,64,4,144,128,40,0,57,16,141,118,37,191,169,165,55,138,8,211,134,150,
186,95,221,157,24,143,129,221,40,141,143,79,52,52,52,108,31,148,72,172,55,5,
220,189,143,10,174,114,171,187,170,204,96,192,131,15,167,55,51,121,217,32,97,
196,4,64,128,128,115,216,106,15,8,128,96,4,28,116,4,140,163,92,166,232,111,169,
113,123,28,30,95,165,213,102,120,186,78,107,170,229,229,229,197,29,85,168,80,
200,89,140,166,196,70,201,89,97,83,20,217,100,86,162,227,79,103,38,150,101,131,
196,128,35,134,56,167,140,115,96,192,182,22,0,64,156,81,206,56,227,144,92,75,
255,149,243,120,173,207,101,181,91,44,22,99,122,147,203,146,144,74,109,108,31,
196,24,163,148,98,12,8,33,131,209,128,9,17,4,136,199,146,147,247,167,177,205,
136,5,44,202,18,22,49,150,4,140,48,0,227,140,51,141,81,77,167,170,78,117,74,
87,211,170,170,17,192,146,76,36,69,66,8,136,32,232,186,182,125,16,33,68,20,197,
108,174,232,118,57,167,139,20,33,84,82,245,174,163,205,129,150,26,171,205,40,
72,68,146,4,65,20,36,145,128,72,16,99,84,231,154,166,235,170,174,106,76,43,170,
169,68,166,174,222,173,81,138,16,209,41,47,179,27,40,229,178,44,111,31,36,73,
146,98,50,37,82,235,7,2,141,125,55,103,57,98,197,188,250,234,167,59,156,86,48,
3,200,0,50,0,1,32,0,91,203,24,3,160,0,26,128,14,80,4,200,0,36,82,116,109,37,
203,25,77,38,54,131,71,106,51,155,5,251,14,38,154,32,203,114,121,89,89,46,187,
30,110,181,188,245,147,53,93,229,26,230,153,116,158,235,66,14,97,3,66,6,1,9,
0,4,3,65,192,0,24,7,157,131,198,160,196,184,202,121,65,231,249,108,137,83,158,
47,168,169,229,76,215,254,178,107,87,179,161,182,218,237,247,33,65,16,26,27,
27,179,249,98,77,185,110,197,104,105,49,193,129,51,202,57,32,0,64,24,0,129,128,
64,192,32,32,16,16,144,255,254,252,87,193,16,162,28,0,193,236,100,188,194,97,
117,89,10,185,124,41,20,10,109,31,132,49,142,68,34,249,188,54,56,56,250,141,
47,118,221,187,53,166,83,164,235,76,231,0,0,136,1,1,192,24,4,196,5,224,34,226,
4,241,173,105,206,1,40,229,140,82,93,99,58,69,31,221,24,252,218,23,58,6,135,
39,45,22,91,117,117,245,142,70,135,211,233,172,174,169,90,73,101,95,139,216,
150,158,204,199,227,105,85,101,90,145,106,8,40,6,198,1,1,16,0,65,32,2,217,234,
65,192,56,48,14,20,67,73,99,148,242,233,201,229,205,197,228,159,125,162,108,
106,110,241,133,72,100,23,134,235,233,211,167,23,23,151,135,70,135,255,241,239,
94,185,124,254,238,122,186,88,40,234,42,101,42,5,149,113,21,128,114,16,17,32,
206,25,7,202,65,5,174,1,148,52,94,44,208,228,122,241,195,159,254,226,195,239,
188,118,191,175,63,147,201,157,56,113,98,23,64,126,191,127,239,222,134,133,165,
36,46,205,127,253,116,224,122,247,224,202,90,33,147,209,114,192,139,0,5,157,
23,24,74,107,44,71,121,158,161,60,131,2,227,57,157,101,178,218,90,50,255,225,
207,122,223,254,92,132,23,231,210,89,245,244,159,158,150,36,105,23,64,0,240,
249,207,127,110,117,109,109,106,46,190,223,87,248,219,151,170,174,95,236,143,
206,110,172,38,10,235,42,77,115,156,164,176,70,81,66,227,27,20,50,140,167,139,
44,153,42,206,204,109,124,240,15,119,190,249,233,166,206,0,29,139,46,52,135,
95,8,135,195,0,208,211,211,83,44,22,119,186,49,18,66,90,90,154,47,94,186,44,
27,76,117,149,228,179,199,154,123,126,49,61,178,144,213,57,210,41,87,1,21,41,
207,106,144,41,104,203,201,226,92,44,125,183,119,102,125,100,238,103,95,61,44,
243,197,71,131,227,51,51,115,199,142,252,145,193,104,190,119,183,23,33,116,251,
246,237,64,32,176,141,14,249,187,167,142,149,149,149,239,125,239,187,13,254,
128,127,79,109,40,80,95,96,142,159,15,165,127,57,191,158,3,129,24,8,2,94,202,
233,162,166,181,85,26,207,132,93,222,114,250,104,120,252,151,191,234,147,100,
197,229,114,154,76,70,183,199,227,15,236,171,44,119,45,196,98,215,111,220,56,
117,234,84,69,69,197,78,207,101,165,82,233,221,119,223,141,45,44,68,186,186,
202,109,86,183,203,230,171,174,148,100,99,122,83,231,128,204,6,44,8,234,66,124,
117,33,158,154,156,158,29,24,232,63,118,236,143,79,157,58,5,0,63,254,209,143,
30,60,124,248,137,151,95,62,245,153,179,118,179,37,181,182,114,173,167,231,200,
145,35,94,175,119,167,39,87,0,152,154,154,250,224,253,247,19,169,100,101,85,
77,93,173,207,108,86,4,81,0,6,42,213,215,147,169,185,185,217,100,34,209,220,
28,60,123,246,13,167,211,185,245,72,87,87,23,165,212,235,245,254,201,171,175,
30,63,249,169,10,87,153,150,207,93,238,238,110,111,239,104,108,108,220,41,104,
43,233,116,186,191,191,191,255,241,227,68,50,81,44,22,49,194,138,81,169,173,
169,237,124,161,51,20,218,47,8,191,117,176,127,243,205,55,175,95,191,238,247,
251,115,185,220,137,87,94,57,126,242,181,170,202,106,1,232,149,127,191,178,167,
190,190,181,181,117,23,64,127,104,222,126,251,237,158,158,158,189,123,247,174,
173,173,29,59,122,228,147,39,79,214,121,125,38,89,186,118,237,154,221,110,63,
116,232,208,31,240,150,237,74,94,122,233,165,229,229,229,193,193,65,159,207,
247,184,191,63,151,206,184,202,43,100,179,57,212,212,52,59,59,19,141,78,215,
215,215,63,87,208,150,41,30,143,143,140,140,236,219,183,175,239,209,163,245,
228,154,203,85,46,26,77,205,251,26,215,83,169,193,193,65,191,223,255,92,65,0,
240,226,139,47,198,98,177,177,177,177,3,7,14,60,122,252,120,117,57,94,238,114,
9,138,210,232,247,115,198,62,186,115,39,24,12,62,87,208,86,157,102,103,103,159,
60,121,18,14,135,135,134,135,99,243,243,229,101,78,144,12,254,250,61,102,147,
233,198,141,27,205,205,205,207,21,244,107,211,216,216,88,36,18,153,156,156,156,
153,158,46,179,219,153,32,237,245,213,85,186,221,221,221,221,77,77,77,255,243,
79,193,103,8,2,128,195,135,15,199,227,241,129,129,129,67,135,14,197,22,22,38,
38,38,236,102,19,21,36,159,183,182,206,235,189,112,225,66,32,16,248,157,222,
241,108,65,0,208,217,217,153,74,165,30,63,126,220,213,213,181,186,186,58,58,
58,98,81,20,29,227,90,79,117,99,192,127,241,226,197,61,123,246,252,230,130,240,
204,65,0,112,240,224,193,92,46,247,224,193,131,72,36,146,203,229,134,71,70,100,
66,40,194,21,238,138,166,224,190,43,87,174,120,60,30,69,81,158,31,8,0,66,161,
144,170,170,247,238,221,235,236,236,164,148,14,13,13,97,4,8,17,87,153,51,216,
212,212,211,211,227,116,58,45,22,203,243,3,1,64,48,24,20,69,177,183,183,183,
173,173,77,146,164,225,225,97,77,45,97,65,112,216,237,45,45,45,183,110,221,50,
26,141,54,155,77,128,231,152,227,199,143,155,76,166,171,87,175,134,195,97,69,
81,198,199,199,53,77,83,85,181,165,165,229,196,137,19,55,111,222,228,156,239,
242,44,251,125,50,48,48,208,221,221,221,209,209,177,184,184,56,49,49,225,112,
56,58,195,225,150,80,200,110,183,247,245,245,125,12,32,0,152,152,152,184,116,
233,82,91,91,91,60,30,159,154,154,18,69,177,189,189,189,190,190,190,84,42,125,
60,32,0,136,70,163,151,47,95,110,109,109,77,36,18,51,51,51,171,171,171,225,112,
248,245,215,95,199,240,49,165,161,161,225,204,153,51,163,163,163,94,175,215,
100,50,97,140,207,157,59,39,73,210,199,86,161,173,196,98,177,119,222,121,39,
22,139,157,63,127,254,153,44,104,219,200,202,202,138,193,96,176,217,108,91,95,
255,19,113,105,77,87,87,182,24,104,0,0,0,0,73,69,78,68,174,66,96,130};

unsigned int n_fitpage = 1096;
unsigned char xfitpage[1096] = {
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,64,0,0,0,69,8,2,0,0,0,117,
198,119,58,0,0,0,9,112,72,89,115,0,0,14,196,0,0,14,196,1,149,43,14,27,0,0,3,
250,73,68,65,84,120,218,237,155,77,104,83,75,20,128,191,27,99,193,230,34,5,107,
17,92,60,113,85,82,116,99,139,54,130,160,81,36,196,88,181,34,143,66,161,11,161,
165,160,173,160,11,113,47,226,166,45,40,45,136,80,80,196,90,26,127,168,32,24,
11,130,34,10,10,133,218,34,254,132,231,66,8,86,49,104,172,16,211,121,139,12,
201,203,245,246,229,6,103,234,13,220,67,22,51,115,239,204,157,239,156,249,57,
115,134,24,66,8,170,89,124,84,185,120,0,127,92,68,169,196,227,113,55,247,182,
179,179,211,210,97,43,64,87,87,215,248,248,184,80,36,179,179,162,167,71,40,148,
95,53,110,29,66,217,108,86,161,194,154,155,25,25,89,222,57,32,132,200,229,114,
74,154,78,38,249,254,29,224,204,153,234,156,196,45,45,50,113,246,108,21,2,188,
123,199,167,79,197,236,233,211,213,6,176,109,91,73,246,220,185,170,2,120,251,
150,143,31,173,133,154,140,160,5,160,181,213,166,80,147,17,212,3,188,121,99,
163,126,125,70,80,15,176,117,171,76,92,188,40,19,125,125,172,89,163,203,8,138,
1,102,102,248,252,57,191,159,208,219,43,11,27,27,153,159,103,243,102,160,88,
232,82,128,77,155,168,175,39,127,196,248,240,65,22,230,19,211,211,244,246,50,
60,236,98,128,137,9,118,236,40,78,128,130,83,178,184,88,28,84,151,46,113,248,
176,74,0,191,194,182,154,154,120,248,176,204,59,71,143,178,123,183,91,45,208,
216,232,232,181,13,27,188,3,141,7,224,1,120,0,30,64,181,3,164,82,220,189,171,
172,19,95,190,48,49,177,140,0,91,182,176,110,29,209,168,50,128,186,58,18,9,12,
131,231,207,53,3,28,58,132,97,240,226,5,202,35,194,195,195,132,66,52,55,83,91,
203,220,156,6,128,131,7,49,12,110,222,4,150,60,175,252,166,60,126,140,105,178,
176,64,48,72,93,157,83,12,159,195,174,223,186,37,179,137,4,245,245,142,154,14,
4,100,98,213,42,167,12,95,191,202,68,58,77,48,136,105,50,59,91,161,55,234,247,
203,211,19,208,214,198,157,59,37,79,247,237,35,28,38,157,150,17,171,255,17,211,
228,229,75,153,158,159,103,113,145,84,170,76,149,21,43,104,104,224,193,3,194,
97,89,146,201,208,212,68,32,192,179,103,4,131,75,84,179,132,26,187,187,255,30,
25,185,214,222,46,192,93,191,149,43,197,220,156,77,108,244,215,243,128,127,96,
224,175,87,175,92,183,222,103,179,244,244,0,129,50,67,40,151,251,121,229,202,
63,45,45,161,161,33,250,251,173,173,132,195,28,57,194,251,247,148,13,1,215,214,
146,74,201,3,100,107,43,7,14,148,4,234,108,197,48,88,187,150,108,214,38,120,
17,141,50,57,153,127,39,83,102,8,117,116,116,140,141,93,47,100,7,7,173,166,116,
46,11,11,178,202,192,64,5,181,246,236,41,249,92,52,90,97,120,61,31,80,40,72,
95,31,66,48,56,88,162,39,231,187,117,97,18,59,148,99,199,184,127,191,168,117,
33,164,226,127,119,31,200,99,12,13,201,236,198,141,90,70,121,60,206,133,11,0,
177,152,163,174,87,188,19,31,63,142,16,156,63,79,50,73,44,166,184,247,51,51,
180,183,179,125,59,66,88,215,110,197,190,208,169,83,8,65,67,3,10,47,211,190,
125,163,191,159,116,154,71,143,150,43,172,114,249,178,74,245,155,38,137,132,
119,30,240,0,60,0,15,192,3,168,118,128,76,198,209,107,63,126,184,21,224,234,
213,242,151,242,175,95,211,214,166,18,64,229,5,71,119,55,134,193,244,52,99,99,
0,62,159,213,129,157,156,36,22,35,157,118,241,28,184,125,155,27,55,164,187,186,
126,189,44,204,7,1,78,158,36,22,35,20,98,245,106,183,90,0,216,191,31,32,153,
196,48,120,250,180,120,192,136,68,184,119,79,198,78,212,138,95,249,178,48,53,
197,174,93,240,159,11,227,19,39,100,66,185,19,174,101,25,221,185,115,201,71,
21,57,250,127,114,31,152,154,178,41,212,161,126,93,0,182,70,208,161,126,141,
59,177,197,8,154,212,175,17,192,98,4,77,234,215,235,11,21,140,160,79,253,54,
0,134,97,248,124,62,181,70,208,167,126,27,128,154,154,154,64,32,160,170,245,
39,79,216,187,87,179,59,106,137,212,141,142,142,170,254,130,169,176,173,72,36,
98,233,176,225,253,127,192,3,240,0,170,91,254,5,67,123,252,220,57,115,119,137,
0,0,0,0,73,69,78,68,174,66,96,130};




static int wmb_inuse=-1;
static WINMBOX _wmb,*wmb;

static void winmbox_init(void);
static int  winmbox_message_box_create(void);
static void winmbox_message_box_calc_size(WINMBOX *wmb);
static void winmbox_message_box_add_children(void);
static LRESULT CALLBACK winmbox_edit_proc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);
static void winmbox_draw_defbutton_border(int status);
static void add_gray(int *r0,int *g0,int *b0,int delta);
static void winmbox_display_text(HFONT hf,char *buf,SIZE *size,int maxwidth,
                                  HDC hdc,int x0,int y0);
static int special_button_text(HDC hdc,char *text,RECT *rect,HBRUSH brush,HPEN pen,int simple,
                               int r0,int g0,int b0);
static void winmbox_text_extents(HFONT hf,char *buf,SIZE *size,int maxwidth);
static void winmbox_display_line(HFONT hf,char *s,SIZE *size,int maxwidth,
                                  HDC hdc,int x0,int y0);
static void winmbox_display_text_1(HFONT hf,char *buf,SIZE *size,HDC hdc,int x0,int y0);
static HFONT winmbox_get_font(double fsize);


static void winmbox_init(void)

    {
    if (wmb_inuse < 0)
        winmbox_set_font("");
    }


/*
** Present a Windows Dialog Box w/up to three buttons and a text entry box if desired.
**
** Inputs:
**    parent = parent window (HWND).  Can be NULL in which case the Desktop window is used.
**    title = window title
**    message = message to be displayed above buttons (max 1023 chars)
**    button1 = button 1 text (can be NULL) (max 255 chars)
**    button2 = button 2 text (can be NULL) (max 255 chars)
**    button3 = button 3 text (can be NULL) (max 255 chars)
**        (On button text, use * at beginning to denote default button; use & in front
**         of shortcut key, e.g. "*&OK")
**    inbuf = text input buffer.  Can be NULL for no edit box.
**    maxlen = max text input chars
**    fontsize_pixels = font size to be used in dialog box.
**    maxwidth_pixels = max width of dialog box (min width is 400)
**    rgbcolor = background color of dialog box.
**
** Return values:
**   inbuf[] gets text entry
**    0 = could not open dialog window
**   -1 = Escape key press
**    1 = Button 1 pressed
**    2 = Button 2 pressed
**    3 = Button 3 pressed
**    4 = <Enter> pressed (if no default button)
**
*/ 
int winmbox_message_box(void *parent,char *title,char *message,
                        char *button1,char *button2,char *button3,
                        char *inbuf,int maxlen,int fontsize_pixels,
                        int maxwidth_pixels,int rgbcolor,void *myproc,
                        void **window,int *button_colors)

    {
    return(winmbox_message_box_ex2(parent,title,message,button1,button2,button3,
                           inbuf,maxlen,fontsize_pixels,maxwidth_pixels,
                           rgbcolor,myproc,window,button_colors,NULL,0));
    }
                           

int winmbox_message_box_ex(void *parent,char *title,char *message,
                        char *button1,char *button2,char *button3,
                        char *inbuf,int maxlen,int fontsize_pixels,
                        int maxwidth_pixels,int rgbcolor,void *myproc,
                        void **window,int *button_colors,void *aboutbox)

    {
    return(winmbox_message_box_ex2(parent,title,message,button1,button2,button3,
                                   inbuf,maxlen,fontsize_pixels,maxwidth_pixels,
                                   rgbcolor,myproc,window,button_colors,aboutbox,
                                   0));
    }


/*
** Present a Windows Dialog Box w/up to three buttons and a text entry box if desired.
**
** Inputs:
**    parent = parent window (HWND).  Can be NULL in which case the Desktop window is used.
**    title = window title
**    message = message to be displayed above buttons (max 1023 chars)
**    button1 = button 1 text (can be NULL) (max 255 chars)
**    button2 = button 2 text (can be NULL) (max 255 chars)
**    button3 = button 3 text (can be NULL) (max 255 chars)
**        (On button text, use * at beginning to denote default button; use & in front
**         of shortcut key, e.g. "*&OK")
**    inbuf = text input buffer.  Can be NULL for no edit box.
**    maxlen = max text input chars
**    fontsize_pixels = font size to be used in dialog box.
**    maxwidth_pixels = max width of dialog box (min width is 400)
**    rgbcolor = background color of dialog box.
**    aboutbox = RECT of "about" text box, which is read only.
**
** Return values:
**   inbuf[] gets text entry
**    0 = could not open dialog window
**   -1 = Escape key press
**    1 = Button 1 pressed
**    2 = Button 2 pressed
**    3 = Button 3 pressed
**    4 = <Enter> pressed (if no default button)
**
*/ 
int winmbox_message_box_ex2(void *parent,char *title,char *message,
                        char *button1,char *button2,char *button3,
                        char *inbuf,int maxlen,int fontsize_pixels,
                        int maxwidth_pixels,int rgbcolor,void *myproc,
                        void **window,int *button_colors,void *aboutbox,
                        int modal)

    {
    int status;

/*
ansi_dprintf(NULL,"@winmbox_message_box_ex(%s,...) wmb_inuse=%d\n",message,wmb_inuse);
*/
    winmbox_init();
    if (wmb_inuse)
        return(0);
    wmb_inuse=1;
    wmb=&_wmb;
    wmb->messagebox.left = wmb->messagebox.right=0;
    if (aboutbox==NULL)
        wmb->aboutbox.left=wmb->aboutbox.right=0;
    else
        {
        RECT *r;
        r=(RECT *)aboutbox;
        wmb->aboutbox = (*r);
        }
    if (wmb->hwnd!=NULL)
        return(-1);
    wmb->hinstance=(HINSTANCE)GetModuleHandle(0);
    wmb->mfsize = fontsize_pixels;
    wmb->maxwidth = maxwidth_pixels;
    wmb->parent = parent;
    wmb->modal = modal;
    wmb->title = title;
    {
    int brgcolor;
    brgcolor=((rgbcolor&0xff0000)>>16)|(rgbcolor&0xff00)|((rgbcolor&0xff)<<16);
    wmb->brush=CreateSolidBrush(brgcolor);
    }
    wmb->inbuf=inbuf;
    wmb->maxlen=maxlen;
    wmb->inbuflabel[0]='\0';
    wmb->passbuf=NULL;
    wmb->passmaxlen=0;
    wmb->passlabel[0]='\0';
    strncpy(wmb->b1,button1==NULL ? "" : button1,255);
    wmb->b1[255]='\0';
    strncpy(wmb->b2,button2==NULL ? "" : button2,255);
    wmb->b2[255]='\0';
    strncpy(wmb->b3,button3==NULL ? "" : button3,255);
    wmb->b3[255]='\0';
    strncpy(wmb->msg,message==NULL ? "" : message,1023);
    wmb->msg[1023]='\0';
    if (button_colors==NULL)
        wmb->buttoncolor[0]=wmb->buttoncolor[1]=wmb->buttoncolor[2]=0xf0f0f0;
    else
        {
        if (button1!=NULL)
            wmb->buttoncolor[0]=button_colors[0];
        if (button2!=NULL)
            wmb->buttoncolor[1]=button_colors[1];
        if (button3!=NULL)
            wmb->buttoncolor[2]=button_colors[2];
        }
    wmb->myproc=myproc;
    status = winmbox_message_box_create();
    if (window!=NULL)
        (*window)=(void *)wmb->hwnd;
    return(status);
    }


/*
** Present a Windows Dialog Box w/up to three buttons and a text entry box if desired.
**
** Inputs:
**    parent = parent window (HWND).  Can be NULL in which case the Desktop window is used.
**    title = window title
**    username = receives user name, max len umaxlen
**    password = receives password, max len pmaxlen
**    fontsize_pixels = font size to be used in dialog box.
**    maxwidth_pixels = max width of dialog box (min width is 400)
**    rgbcolor = background color of dialog box.
**
** Return values:
**   inbuf[] gets text entry
**    0 = could not open dialog window
**   -1 = Escape key press
**    1 = Button 1 pressed
**    2 = Button 2 pressed
**    3 = Button 3 pressed
**    4 = <Enter> pressed (if no default button)
**
*/ 
int winmbox_login_box(void *parent,char *title,
                      char *message,
                      char *username,int umaxlen,
                      char *password,int pmaxlen,
                      int fontsize_pixels,int maxwidth_pixels,
                      int rgbcolor,int *button_colors)

    {
/*
ansi_dprintf(NULL,"@winmbox_message_box_ex(%s,...) wmb_inuse=%d\n",message,wmb_inuse);
*/
    winmbox_init();
    if (wmb_inuse)
        return(0);
    wmb_inuse=1;
    wmb=&_wmb;
    wmb->messagebox.left = wmb->messagebox.right=0;
    wmb->aboutbox.left=wmb->aboutbox.right=0;
    if (wmb->hwnd!=NULL)
        return(-1);
    wmb->hinstance=(HINSTANCE)GetModuleHandle(0);
    wmb->mfsize = fontsize_pixels;
    wmb->maxwidth = maxwidth_pixels;
    wmb->parent = parent;
    wmb->modal = 1;
    wmb->title = title;
    {
    int brgcolor;
    brgcolor=((rgbcolor&0xff0000)>>16)|(rgbcolor&0xff00)|((rgbcolor&0xff)<<16);
    wmb->brush=CreateSolidBrush(brgcolor);
    }
    wmb->inbuf=username;
    wmb->maxlen=umaxlen;
    strcpy(wmb->inbuflabel,"User name: ");
    wmb->passbuf=password;
    wmb->passbuf[0]='\0';
    wmb->passmaxlen=pmaxlen;
    strcpy(wmb->passlabel,"Password: ");
    strcpy(wmb->b1,"*&Login");
    strcpy(wmb->b2,"&Cancel");
    wmb->b3[0]='\0';
    strncpy(wmb->msg,message==NULL ? "" : message,1023);
    wmb->msg[1023]='\0';
    if (button_colors==NULL)
        wmb->buttoncolor[0]=wmb->buttoncolor[1]=wmb->buttoncolor[2]=0xf0f0f0;
    else
        {
        wmb->buttoncolor[0]=button_colors[0];
        wmb->buttoncolor[1]=button_colors[1];
        wmb->buttoncolor[2]=0xf0f0f0;
        }
    wmb->myproc=NULL;
    return(winmbox_message_box_create());
    }


/*
**
** Global variable wmb must be completely populated before calling
** this function.
**
** Return values:
**   inbuf[] gets text entry
**    0 = could not open dialog window
**   -1 = Escape key press
**    1 = Button 1 pressed
**    2 = Button 2 pressed
**    3 = Button 3 pressed
**    4 = <Enter> pressed (if no default button)
**
*/ 
static int winmbox_message_box_create(void)

    {
    WNDCLASSEX wndclass;
    static char *classname="message_box";

    strcpy(wmb->class,classname);
    wndclass.cbSize        = sizeof (wndclass) ;
    wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
    wndclass.lpfnWndProc   = wmb->myproc==NULL ? (WNDPROC)winmbox_def_proc : (WNDPROC)wmb->myproc;
    wndclass.cbClsExtra    = 0;
    wndclass.cbWndExtra    = 0;
    wndclass.hInstance     = wmb->hinstance;
    wndclass.hIcon         = NULL;
    wndclass.hCursor       = NULL;
    wndclass.hbrBackground = wmb->brush;
    wndclass.lpszMenuName  = NULL;
    wndclass.lpszClassName = classname;
    wndclass.hIconSm       = NULL;
    RegisterClassEx(&wndclass) ;
    {
    HWND pwin;
    RECT rect;
    int x0,y0;

    pwin = wmb->parent==NULL ? GetDesktopWindow() : (HWND)wmb->parent;
    GetWindowRect(pwin,&rect);
/*
printf("rect=(%d,%d)-(%d,%d)\n",(int)rect.left,(int)rect.top,(int)rect.right,(int)rect.bottom);
*/
    winmbox_message_box_calc_size(wmb);
    x0 = rect.left + ((rect.right-rect.left)-wmb->width)/2;
    y0 = rect.top + ((rect.bottom-rect.top)-wmb->height)/2;
    wmb->hwnd=CreateWindowEx(WS_EX_TOPMOST,classname,wmb->title,WS_OVERLAPPED,
                             x0,y0,wmb->width,wmb->height,
                             NULL,NULL,0,NULL);
    }
    if (wmb->hwnd==NULL)
        {
        wmb_inuse=0;
        return(0);
        }
    ShowWindow(wmb->hwnd,SW_SHOW);
    UpdateWindow(wmb->hwnd);
    winmbox_message_box_add_children();
    UpdateWindow(wmb->hwnd);
    if (wmb->edit_hwnd!=NULL && wmb->aboutbox.right-wmb->aboutbox.left==0)
        SetFocus(wmb->edit_hwnd);
    else if (wmb->b3_hwnd!=NULL && wmb->b3[0]=='*')
        SetFocus(wmb->b3_hwnd);
    else if (wmb->b2_hwnd!=NULL && wmb->b2[0]=='*')
        SetFocus(wmb->b2_hwnd);
    else if (wmb->b1_hwnd!=NULL)
        SetFocus(wmb->b1_hwnd);
    if (wmb->myproc!=NULL)
        return(1);
    if (wmb->modal && wmb->parent!=NULL)
        EnableWindow(wmb->parent,0);
    {
    MSG msg;
    while (wmb->hwnd!=NULL && GetMessage(&msg,NULL,0,0))
        {
        if (!IsDialogMessage(wmb->hwnd,&msg))
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            }
        }
    }
    return(wmb->status);
    }


void winmbox_terminate(void)

    {
    SendMessage((HWND)wmb->hwnd,WM_CLOSE,0,0);
    }


static void winmbox_message_box_calc_size(WINMBOX *wmb)

    {
    SIZE b1,b2,b3,m;
    int button_width;

    wmb->bfsize=wmb->mfsize;
    if (wmb->b1[0]!='\0' || wmb->b2[0]!='\0' || wmb->b3[0]!='\0')
        {
        while (1)
            {
            wmb->bf=winmbox_get_font(wmb->bfsize);
            winmbox_text_extents(wmb->bf,wmb->b1,&b1,-1);
            winmbox_text_extents(wmb->bf,wmb->b2,&b2,-1);
            winmbox_text_extents(wmb->bf,wmb->b3,&b3,-1);
            button_width=b1.cx+b2.cx+b3.cx+wmb->bfsize*5;
            if (button_width<=wmb->maxwidth)
                break;
            wmb->bfsize *= (wmb->maxwidth*.98)/button_width;
            DeleteObject(wmb->bf);
            }
        wmb->height=wmb->bfsize*2.;
        if (button_width < 400)
            button_width=400;
        }
    else
        {
        wmb->height=0.;
        button_width=0;
        }
    wmb->mf=winmbox_get_font(wmb->mfsize);
    winmbox_text_extents(wmb->mf,wmb->msg,&m,wmb->maxwidth);
    wmb->width=m.cx+50 > wmb->maxwidth ? wmb->maxwidth: m.cx+50;
    /* Make sure the buttons fit */
    if (wmb->width<button_width)
        wmb->width=button_width;
    wmb->height += wmb->mfsize*2.+m.cy;
    if (wmb->aboutbox.right-wmb->aboutbox.left>0)
        {
        if (wmb->aboutbox.right-wmb->aboutbox.left+40 > wmb->width)
            wmb->width = wmb->aboutbox.right-wmb->aboutbox.left;
        wmb->height += (wmb->aboutbox.bottom-wmb->aboutbox.top)*0.9;
        }
    else
        {
        if (wmb->inbuf!=NULL)
            wmb->height += wmb->mfsize*5.;
        if (wmb->passbuf!=NULL)
            wmb->height += wmb->mfsize*2.;
        }
    if (wmb->height < 200)
        wmb->height=200;
    }


void winmbox_message_box_display_message(char *message,int *ypos)

    {
    SIZE m;
    HFONT oldfont;
    int n,x1,y1,vcenter;
    HDC hdc;

    if (!wmb_inuse || wmb==NULL)
        return;
    vcenter = (wmb->aboutbox.right-wmb->aboutbox.left==0 && wmb->inbuf==NULL  && wmb->passbuf==NULL
                  && wmb->b1[0]=='\0' && wmb->b2[0]=='\0' && wmb->b3[0]=='\0');
    winmbox_text_extents(wmb->mf,message,&m,wmb->width);
    x1=(wmb->width-6-m.cx)/2;
    y1=(wmb->height-6-m.cy-wmb->bfsize*1.2);
    n=3;
    if (vcenter)
        {
        RECT rect;

        GetClientRect(wmb->hwnd,&rect);
        y1=rect.top + (rect.bottom-rect.top-m.cy)/2;
        }
    else
        {
        if (wmb->aboutbox.right-wmb->aboutbox.left>0)
            {
            y1 -= (wmb->aboutbox.bottom-wmb->aboutbox.top)*0.9;
            n++;
            }
        else
            {
            if (wmb->inbuf!=NULL)
                {
                y1-=(wmb->mfsize*1.2);
                n++;
                }
            if (wmb->passbuf!=NULL)
                {
                y1-=(wmb->mfsize*1.2);
                n++;
                }
            }
        y1 = y1/n-wmb->mfsize/2.;
        }
    hdc=GetDC(wmb->hwnd);
    oldfont=SelectObject(hdc,wmb->mf);
    if (wmb->messagebox.left>0 || wmb->messagebox.right>0)
        FillRect(hdc,&wmb->messagebox,wmb->brush);
    SetTextColor(hdc,0x000000);
    SetBkMode(hdc,TRANSPARENT);
    SetTextAlign(hdc,TA_TOP|TA_LEFT);
    winmbox_display_text(wmb->mf,message,&m,wmb->width,hdc,x1,y1);
    SelectObject(hdc,oldfont);
    ReleaseDC(wmb->hwnd,hdc);
    wmb->messagebox.left=x1;
    wmb->messagebox.top=y1;
    wmb->messagebox.right=wmb->messagebox.left+m.cx-1;
    wmb->messagebox.bottom=wmb->messagebox.top+m.cy-1;
    if (ypos!=NULL)
        (*ypos)=y1+m.cy;
    }


static void winmbox_message_box_add_children(void)

    {
    SIZE b1,b2,b3;
    int w,nb,dx,dx1,dy,x1,y1,def1,def2,def3;
    WNDCLASS wcl;
    static int class_registered=0;
    static char *wmbeditclass="EditWinMbox";

    {
    HWND dummy;
    DWORD bclass;

    dummy = CreateWindow("button",NULL,WS_CHILD|BS_OWNERDRAW,
                         0,0,0,0,wmb->hwnd,(HMENU)0,wmb->hinstance,NULL);
    bclass = GetClassLong(dummy,GCL_STYLE);
    SetClassLong(dummy,GCL_STYLE,bclass & ~CS_DBLCLKS);
    DestroyWindow(dummy);
    }
    if (!class_registered)
        {
        GetClassInfo(wmb->hinstance,"Edit",&wcl);
        wcl.lpszClassName=wmbeditclass;
        wmb->eclassproc=wcl.lpfnWndProc;
        wcl.lpfnWndProc=winmbox_edit_proc;
        RegisterClass(&wcl);
        class_registered=1;
        }

    winmbox_message_box_display_message(wmb->msg,&y1);
/*
dprintf(NULL,"msg=%s, wmb->inbuf=%p, right-left=%d\n",
wmb->msg,wmb->inbuf,wmb->aboutbox.right-wmb->aboutbox.left);
*/
    if (wmb->inbuf!=NULL || wmb->aboutbox.right-wmb->aboutbox.left>0)
        {
        int flags;

        if (wmb->aboutbox.right - wmb->aboutbox.left > 0)
            {
            dx=(int)((wmb->aboutbox.right-wmb->aboutbox.left)*0.9);
            dy=(int)((wmb->aboutbox.bottom-wmb->aboutbox.top)*0.88);
            x1=(wmb->width - dx)/2;
            flags=WS_CHILD|WS_VISIBLE|WS_BORDER|WS_HSCROLL|WS_VSCROLL
                  |ES_MULTILINE|ES_READONLY|WS_TABSTOP;
            }
        else
            {
            SIZE lsize;
            int dx1;
            winmbox_text_extents(wmb->bf,wmb->inbuflabel,&lsize,-1);
            dy=(int)(wmb->mfsize*1.2);
            dx1=wmb->inbuflabel[0]=='\0'?0:0;
            dx=(int)(wmb->width*.9-lsize.cx-dx1);
            x1=0.05*wmb->width+lsize.cx+dx1;
            flags=WS_CHILD|WS_VISIBLE|WS_BORDER|WS_TABSTOP;
            }
        y1 += wmb->mfsize;
        wmb->edit_hwnd=CreateWindow(wmbeditclass,"",flags,
                                   x1,y1,dx,dy,
                                   wmb->hwnd,(HMENU)10,wmb->hinstance,NULL);
        SendMessage(wmb->edit_hwnd,WM_SETFONT,(WPARAM)wmb->mf,1);
        if (wmb->inbuf!=NULL)
            {
            SendMessage(wmb->edit_hwnd,WM_SETTEXT,(WPARAM)0,(LPARAM)wmb->inbuf);
            if (wmb->aboutbox.right-wmb->aboutbox.left==0)
                SendMessage(wmb->edit_hwnd,EM_SETSEL,0,-1);
            if (wmb->inbuflabel[0]!='\0')
                {
                HDC hdc;
                SIZE size;

                hdc=GetDC(wmb->hwnd);
                x1=0.05*wmb->width;
                SetTextColor(hdc,0x000000);
                SetBkMode(hdc,TRANSPARENT);
                SetTextAlign(hdc,TA_TOP|TA_LEFT);
                winmbox_display_text_1(wmb->mf,wmb->inbuflabel,&size,hdc,
                                       x1,(int)(y1+wmb->mfsize*.2));
                ReleaseDC(wmb->hwnd,hdc);
                }
            }
        if (wmb->aboutbox.right - wmb->aboutbox.left > 0)
            y1 += dy;
        else
            y1 += wmb->mfsize;
        if (wmb->passbuf!=NULL)
            {
            SIZE lsize;
            int dx1;

            winmbox_text_extents(wmb->bf,wmb->passlabel,&lsize,-1);
            dy=(int)(wmb->mfsize*1.2);
            dx1=wmb->passlabel[0]=='\0'?0:0;
            dx=(int)(wmb->width*.9-lsize.cx-dx1);
            x1=0.05*wmb->width+lsize.cx+dx1;
            y1 += wmb->mfsize*0.5;
            flags=WS_CHILD|WS_VISIBLE|WS_BORDER|WS_TABSTOP|ES_PASSWORD;
            wmb->pass_hwnd=CreateWindow(wmbeditclass,"",flags,
                                       x1,y1,dx,dy,
                                       wmb->hwnd,(HMENU)10,wmb->hinstance,NULL);
            SendMessage(wmb->pass_hwnd,WM_SETFONT,(WPARAM)wmb->mf,1);
            if (wmb->passlabel[0]!='\0')
                {
                HDC hdc;
                SIZE size;

                hdc=GetDC(wmb->hwnd);
                x1=0.05*wmb->width;
                SetTextColor(hdc,0x000000);
                SetBkMode(hdc,TRANSPARENT);
                SetTextAlign(hdc,TA_TOP|TA_LEFT);
                winmbox_display_text_1(wmb->mf,wmb->passlabel,&size,hdc,
                                       x1,(int)(y1+wmb->mfsize*.2));
                ReleaseDC(wmb->hwnd,hdc);
                }
            y1 += wmb->mfsize;
            }
        }
    else
        wmb->edit_hwnd=NULL;
    nb=0;
    winmbox_text_extents(wmb->bf,wmb->b1,&b1,-1);
    if (wmb->b1[0]!='\0')
        {
        b1.cx += wmb->bfsize;
        nb++;
        }
    winmbox_text_extents(wmb->bf,wmb->b2,&b2,-1);
    if (wmb->b2[0]!='\0')
        {
        b2.cx += wmb->bfsize;
        nb++;
        }
    winmbox_text_extents(wmb->bf,wmb->b3,&b3,-1);
    if (wmb->b3[0]!='\0')
        {
        b3.cx += wmb->bfsize;
        nb++;
        }
    y1=(wmb->height-10+y1)/2 - (int)wmb->bfsize;
    w=b1.cx+b2.cx+b3.cx;
    dx=(wmb->width-6-w)/(nb+1);
    dx1=wmb->bfsize;
    if (dx > dx1)
        dx=dx1;
    if (nb==0)
        x1=wmb->width/2;
    else
        x1=(wmb->width-6-w-dx*(nb-1))/2;
    def1=(wmb->b1[0]=='*');
    wmb->dbx1=-1;
    if (wmb->b1[0]!='\0')
        {
        int w,h;
        w = b1.cx;
        h = wmb->bfsize*1.2;
        wmb->b1_hwnd=CreateWindow("button",def1 ? &wmb->b1[1] : wmb->b1,
                                   WS_CHILD|WS_VISIBLE|WS_BORDER|WS_TABSTOP
                                       |BS_OWNERDRAW,
/*
                                       |(def1?BS_DEFPUSHBUTTON:BS_PUSHBUTTON)
                                       |BS_TEXT|BS_CENTER|BS_VCENTER,
*/
                                   x1,y1,w,h,
                                   wmb->hwnd,(HMENU)3,wmb->hinstance,NULL);
        SendMessage(wmb->b1_hwnd,WM_SETFONT,(WPARAM)wmb->bf,1);
        if (def1)
           {
           wmb->dbx1=x1;
           wmb->dby1=y1;
           wmb->dbw=w;
           wmb->dbh=h;
           }
        x1 += w + dx;
        }
    else
        wmb->b1_hwnd=NULL;
    if (!def1)
        def2=(wmb->b2[0]=='*');
    else
        def2=0;
    if (wmb->b2[0]!='\0')
        {
        int w,h;
        w = b2.cx;
        h = wmb->bfsize*1.2;
        wmb->b2_hwnd=CreateWindow("button",def2 ? &wmb->b2[1] : wmb->b2,
                                   WS_CHILD|WS_VISIBLE|WS_BORDER|WS_TABSTOP
                                       |BS_OWNERDRAW,
/*
                                       |(def2?BS_DEFPUSHBUTTON:BS_PUSHBUTTON)
                                       |BS_TEXT|BS_CENTER|BS_VCENTER,
*/
                                   x1,y1,w,h,
                                   wmb->hwnd,(HMENU)4,wmb->hinstance,NULL);
        SendMessage(wmb->b2_hwnd,WM_SETFONT,(WPARAM)wmb->bf,1);
        if (def2)
           {
           wmb->dbx1=x1;
           wmb->dby1=y1;
           wmb->dbw=w;
           wmb->dbh=h;
           }
        x1 += w + dx;
        }
    else
        wmb->b2_hwnd=NULL;
    if (!def1 && !def2)
        def3=(wmb->b3[0]=='*');
    else
        def3=0;
    if (wmb->b3[0]!='\0')
        {
        int w,h;
        w = b3.cx;
        h = wmb->bfsize*1.2;
        wmb->b3_hwnd=CreateWindow("button",def3 ? &wmb->b3[1] : wmb->b3,
                                   WS_CHILD|WS_VISIBLE|WS_BORDER|WS_TABSTOP
                                       |BS_OWNERDRAW,
/*
                                       |(def3?BS_DEFPUSHBUTTON:BS_PUSHBUTTON)
                                       |BS_TEXT|BS_CENTER|BS_VCENTER,
*/
                                   x1,y1,w,h,
                                   wmb->hwnd,(HMENU)5,wmb->hinstance,NULL);
        SendMessage(wmb->b3_hwnd,WM_SETFONT,(WPARAM)wmb->bf,1);
        if (def3)
           {
           wmb->dbx1=x1;
           wmb->dby1=y1;
           wmb->dbw=w;
           wmb->dbh=h;
           }
        x1 += w + dx;
        }
    else
        wmb->b3_hwnd=NULL;
    if (wmb->inbuf!=NULL)
        winmbox_draw_defbutton_border(1);
    }


/*
** Subclass on edit box so that Ctrl-A selects all
*/
static LRESULT CALLBACK winmbox_edit_proc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)

    {	
	switch (message) 
        {
        case WM_SETFOCUS:
            if (wmb->aboutbox.right-wmb->aboutbox.left==0)
                SendMessage(hwnd,EM_SETSEL,0,-1);
            break;
        case WM_CHAR:
            {
/* ansi_dprintf(NULL,"wm_char: %d\n",(int)wParam); */
            if ((TCHAR)wParam==VK_TAB)
                {
                SetFocus(GetNextDlgTabItem(GetParent(hwnd),hwnd,GetAsyncKeyState(VK_SHIFT)));
                //cannot use WM_NEXTDLGCTL without handling in a parent window using the same code 
                return(0); 
                }
            if ((TCHAR)wParam==1)
                {
                SetFocus(hwnd);
                SendMessage(hwnd,EM_SETSEL,0,-1);
                return(0);
                }
            }
        }
    return(wmb->eclassproc(hwnd,message,wParam,lParam));
    }


static void winmbox_draw_defbutton_border(int status)

    {
    HDC hdc;
    HBRUSH brush;
    RECT rect;
    int i;

    if (wmb->dbx1<0)
        return;
    hdc=GetDC(wmb->hwnd);
    brush=status ? CreateSolidBrush(0x000000) : wmb->brush;
    for (i=2;i<=3;i++)
        {
        rect.top=wmb->dby1-i;
        rect.bottom=wmb->dby1+wmb->dbh+i;
        rect.left=wmb->dbx1-i;
        rect.right=wmb->dbx1+wmb->dbw+i;
        FrameRect(hdc,&rect,brush);
        }
    ReleaseDC(wmb->hwnd,hdc);
    }


static void add_gray(int *r0,int *g0,int *b0,int delta)

    {
    (*r0) += delta;
    if ((*r0)>255)
        (*r0)=255;
    else if ((*r0)<0)
        (*r0)=0;
    (*b0) += delta;
    if ((*b0)>255)
        (*b0)=255;
    else if ((*b0)<0)
        (*b0)=0;
    (*g0) += delta;
    if ((*g0)>255)
        (*g0)=255;
    else if ((*g0)<0)
        (*g0)=0;
    }

/*
** Assumes button was created WITHOUT WS_BORDER flag!
** Does not work correctly w/o PNG library support.
*/
void winmbox_checkbox_button_draw(void *hdc0,void *rect0,int state,void *hfont0,
                                  char *text,int textcolorrgb,int checked,
                                  WILLUSBITMAP *bgbmp,int x0,int y0)

    {
    HDC hdc;
    HFONT hfont,oldfont;
    RECT *rect;
    HBRUSH brush;
    HBRUSH tbrush;
    HPEN pen_dotted;
    HPEN pen;
    LOGBRUSH lbrush;
    static WILLUSBITMAP check8;
    WILLUSBITMAP _bmp,*bmp;
    static int x8=0;
    int n8,tcolor;
    int i,j,disabled,bpp;
    int ulx1,ulx2,uly;
    char t2[256];
    char tu[4];
    int r0,g0,b0,cbw,h,dx;
    SIZE size,tusize;

    bmp=&_bmp;
    bmp_init(bmp);
    disabled=state&ODS_DISABLED;
    hdc=(HDC)hdc0;
    rect=(RECT *)rect0;
    hfont=(HFONT)hfont0;
    r0=(textcolorrgb&0xff0000)>>16;
    g0=(textcolorrgb&0xff00)>>8;
    b0=(textcolorrgb&0xff);
    if (disabled)
        {
        r0/=2;
        g0/=2;
        b0/=2;
        /* add_gray(&r0,&g0,&b0,-96); */
        }
    tcolor=((b0<<16)|(g0<<8)|r0);
    tbrush=CreateSolidBrush(tcolor);
    brush=CreateSolidBrush(0x00ffff);
    lbrush.lbStyle=BS_SOLID;
    lbrush.lbColor=tcolor;
    lbrush.lbHatch=0;
    pen_dotted=ExtCreatePen(PS_COSMETIC|PS_ALTERNATE,1,&lbrush,0,NULL);
    pen=CreatePen(PS_SOLID,0,tcolor);
    h=rect->bottom-rect->top+1;
    cbw=h/2;
    dx=cbw*3/2;
    n8=cbw*4/3;
/*
printf("@winmbox_checkbox_button_draw: text='%s'\n",text);
*/
#if (defined(HAVE_PNG_LIB))
    /* Get checkmark bitmap */
    if (checked && n8!=x8)
        {
        static unsigned int ncheckmark = 2279;
        static unsigned char checkmark[2279] = {
        137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,128,0,0,0,128,8,3,0,0,0,
        244,224,145,249,0,0,3,0,80,76,84,69,0,0,0,1,1,1,2,2,2,3,3,3,4,4,4,5,5,5,6,6,
        6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,12,12,12,13,13,13,14,14,14,15,15,15,16,
        16,16,17,17,17,18,18,18,19,19,19,20,20,20,21,21,21,22,22,22,23,23,23,24,24,24,
        25,25,25,26,26,26,27,27,27,28,28,28,29,29,29,30,30,30,31,31,31,32,32,32,33,33,
        33,34,34,34,35,35,35,36,36,36,37,37,37,38,38,38,39,39,39,40,40,40,41,41,41,42,
        42,42,43,43,43,44,44,44,45,45,45,46,46,46,47,47,47,48,48,48,49,49,49,50,50,50,
        51,51,51,52,52,52,53,53,53,54,54,54,55,55,55,56,56,56,57,57,57,58,58,58,59,59,
        59,60,60,60,61,61,61,62,62,62,63,63,63,64,64,64,65,65,65,66,66,66,67,67,67,68,
        68,68,69,69,69,70,70,70,71,71,71,72,72,72,73,73,73,74,74,74,75,75,75,76,76,76,
        77,77,77,78,78,78,79,79,79,80,80,80,81,81,81,82,82,82,83,83,83,84,84,84,85,85,
        85,86,86,86,87,87,87,88,88,88,89,89,89,90,90,90,91,91,91,92,92,92,93,93,93,94,
        94,94,95,95,95,96,96,96,97,97,97,98,98,98,99,99,99,100,100,100,101,101,101,102,
        102,102,103,103,103,104,104,104,105,105,105,106,106,106,107,107,107,108,108,
        108,109,109,109,110,110,110,111,111,111,112,112,112,113,113,113,114,114,114,
        115,115,115,116,116,116,117,117,117,118,118,118,119,119,119,120,120,120,121,
        121,121,122,122,122,123,123,123,124,124,124,125,125,125,126,126,126,127,127,
        127,128,128,128,129,129,129,130,130,130,131,131,131,132,132,132,133,133,133,
        134,134,134,135,135,135,136,136,136,137,137,137,138,138,138,139,139,139,140,
        140,140,141,141,141,142,142,142,143,143,143,144,144,144,145,145,145,146,146,
        146,147,147,147,148,148,148,149,149,149,150,150,150,151,151,151,152,152,152,
        153,153,153,154,154,154,155,155,155,156,156,156,157,157,157,158,158,158,159,
        159,159,160,160,160,161,161,161,162,162,162,163,163,163,164,164,164,165,165,
        165,166,166,166,167,167,167,168,168,168,169,169,169,170,170,170,171,171,171,
        172,172,172,173,173,173,174,174,174,175,175,175,176,176,176,177,177,177,178,
        178,178,179,179,179,180,180,180,181,181,181,182,182,182,183,183,183,184,184,
        184,185,185,185,186,186,186,187,187,187,188,188,188,189,189,189,190,190,190,
        191,191,191,192,192,192,193,193,193,194,194,194,195,195,195,196,196,196,197,
        197,197,198,198,198,199,199,199,200,200,200,201,201,201,202,202,202,203,203,
        203,204,204,204,205,205,205,206,206,206,207,207,207,208,208,208,209,209,209,
        210,210,210,211,211,211,212,212,212,213,213,213,214,214,214,215,215,215,216,
        216,216,217,217,217,218,218,218,219,219,219,220,220,220,221,221,221,222,222,
        222,223,223,223,224,224,224,225,225,225,226,226,226,227,227,227,228,228,228,
        229,229,229,230,230,230,231,231,231,232,232,232,233,233,233,234,234,234,235,
        235,235,236,236,236,237,237,237,238,238,238,239,239,239,240,240,240,241,241,
        241,242,242,242,243,243,243,244,244,244,245,245,245,246,246,246,247,247,247,
        248,248,248,249,249,249,250,250,250,251,251,251,252,252,252,253,253,253,254,
        254,254,255,255,255,226,176,93,125,0,0,0,9,112,72,89,115,0,0,54,113,0,0,54,113,
        1,247,106,137,61,0,0,5,141,73,68,65,84,120,218,189,154,125,76,149,117,20,199,
        159,7,238,189,120,133,43,241,162,18,66,151,217,10,209,110,187,49,8,45,23,91,
        47,75,171,161,43,72,90,67,92,25,233,224,143,218,74,163,198,75,14,77,7,198,31,
        96,206,101,97,155,47,19,197,26,244,34,57,27,232,146,66,109,68,197,203,138,72,
        156,23,110,12,144,43,175,247,229,121,106,229,10,46,231,92,238,221,243,60,223,
        223,223,207,238,231,220,223,239,123,206,239,156,243,59,130,128,93,193,134,208,
        229,235,183,85,156,185,208,54,52,237,118,117,157,121,16,75,15,141,219,124,188,
        215,35,207,88,215,144,248,200,181,53,195,178,215,250,1,134,23,35,215,212,77,
        123,227,101,247,22,20,63,236,254,74,135,60,119,181,27,49,248,32,243,246,223,
        9,188,236,120,22,244,247,211,79,186,41,190,167,70,7,225,199,111,251,67,38,87,
        219,114,136,250,44,7,38,105,190,125,35,228,255,39,213,75,52,127,186,44,8,193,
        55,28,98,248,242,231,139,33,27,144,49,196,240,127,193,68,97,235,101,134,111,
        207,22,33,14,240,25,195,119,188,161,71,240,77,7,93,140,0,247,44,66,240,117,69,
        183,104,190,116,48,6,18,1,242,6,24,254,233,4,136,0,159,234,101,4,208,180,18,
        194,79,110,99,248,93,41,16,7,136,107,246,208,252,161,117,144,8,184,176,142,113,
        0,215,86,3,36,3,40,103,110,32,121,95,40,68,0,155,25,7,148,235,35,32,252,212,
        63,25,126,71,44,132,191,164,147,225,143,88,33,14,16,210,200,165,0,27,33,124,
        221,126,230,255,187,222,198,20,32,185,76,0,112,31,13,134,220,0,105,35,52,223,
        115,17,227,0,9,63,50,7,208,125,47,132,31,113,130,225,223,88,15,225,27,223,98,
        28,96,240,85,76,13,246,156,131,9,0,37,16,7,20,82,126,163,249,227,239,47,128,
        240,205,95,211,124,231,145,59,32,252,240,42,90,0,210,167,113,16,190,174,96,130,
        222,128,43,152,20,76,88,119,157,230,219,54,96,248,43,90,152,27,168,16,211,5,
        136,56,202,68,128,19,81,152,43,168,136,201,193,218,45,152,3,200,236,167,249,
        55,51,49,17,200,210,206,20,65,187,48,125,176,200,6,78,0,75,49,93,200,253,83,
        52,255,2,230,10,22,94,28,102,82,128,100,144,0,152,42,116,240,81,72,14,38,152,
        154,104,1,184,178,244,24,1,84,50,85,224,174,16,140,0,178,152,43,168,33,12,195,
        191,219,78,243,123,98,48,252,176,75,52,127,52,5,195,215,87,210,252,169,92,12,
        63,40,139,22,160,171,26,19,0,132,85,116,31,76,106,54,97,248,209,231,232,3,232,
        189,15,195,95,80,70,243,135,179,65,2,200,24,167,5,88,30,4,18,0,221,7,145,26,
        34,64,2,168,101,30,2,64,57,152,97,7,221,135,176,63,143,225,11,79,211,141,176,
        169,82,76,18,46,220,211,74,11,160,22,36,128,176,15,153,42,12,36,0,49,143,238,
        132,14,100,128,4,144,242,43,93,133,237,0,9,32,178,158,22,192,145,72,80,8,44,
        166,179,240,239,65,73,184,240,4,93,134,13,60,14,226,71,209,117,184,43,95,15,
        242,128,221,116,18,114,40,28,180,1,107,6,73,254,229,120,16,223,216,76,55,2,215,
        130,146,48,225,53,39,105,64,1,40,2,8,102,58,11,60,185,16,196,23,142,145,117,
        96,207,50,53,212,45,46,122,236,149,226,210,162,77,190,212,156,67,142,195,56,
        31,81,44,0,81,31,245,210,217,177,219,141,245,135,217,159,91,73,62,70,184,223,
        81,158,223,154,119,223,152,49,97,198,117,86,77,100,8,146,206,42,125,11,213,197,
        190,105,155,245,147,31,208,141,5,195,62,82,128,215,18,148,38,23,233,222,5,230,
        36,153,86,136,207,144,173,192,81,165,243,88,209,249,163,115,189,138,218,84,51,
        249,24,224,172,80,88,5,68,239,37,34,203,100,218,220,15,67,15,147,2,248,70,225,
        21,16,90,66,58,246,241,57,129,77,124,129,12,129,61,201,10,15,128,41,175,198,
        173,222,31,38,118,147,157,216,151,149,58,224,121,230,149,237,35,175,45,48,125,
        66,70,128,3,138,115,128,155,140,1,195,179,29,65,204,37,179,176,38,229,33,120,
        154,49,64,174,154,21,14,45,93,100,31,32,93,249,13,208,199,25,208,63,51,188,132,
        31,163,62,25,43,80,161,14,111,228,12,144,11,103,28,64,62,21,130,164,143,213,
        232,4,238,101,13,232,140,254,239,163,213,228,72,234,149,68,53,238,247,13,172,
        1,255,207,252,46,254,146,148,169,58,101,216,50,7,107,193,119,183,179,28,67,57,
        21,130,60,101,234,204,3,5,95,100,13,152,206,252,247,147,60,114,40,178,241,78,
        149,114,172,18,214,0,249,210,63,47,190,233,164,0,108,105,170,165,249,18,191,
        5,69,127,199,130,212,171,100,25,180,93,181,183,8,99,63,191,5,246,77,194,170,
        22,178,21,84,167,98,25,84,203,27,32,247,213,180,145,89,232,64,146,138,137,118,
        142,15,3,228,9,250,128,10,212,108,69,46,29,147,3,93,141,170,62,134,136,231,2,
        229,79,62,160,110,177,83,16,168,1,21,42,247,130,205,206,192,248,157,170,15,132,
        180,6,196,31,182,170,94,112,22,6,36,128,173,234,87,188,22,151,255,124,215,97,
        13,158,99,117,63,251,111,64,139,38,3,25,239,249,205,183,165,106,210,117,88,237,
        175,31,76,188,174,77,219,195,208,225,31,95,58,173,213,64,198,30,63,35,64,162,
        70,124,33,205,175,51,24,201,209,172,245,20,242,147,31,124,79,181,134,189,216,
        98,63,12,248,246,46,13,187,111,73,142,249,61,240,73,45,219,127,193,95,205,199,
        119,106,60,147,150,61,159,1,167,52,158,73,139,234,242,205,239,176,10,26,175,
        157,62,249,183,178,53,127,144,142,239,243,21,2,203,181,111,70,139,239,250,48,
        160,25,49,149,26,219,205,23,40,15,65,58,241,91,60,92,18,146,135,121,141,48,113,
        221,146,42,208,76,148,96,29,37,249,231,151,160,94,67,130,201,236,180,61,65,128,
        45,83,245,117,175,90,208,221,182,51,70,196,25,32,232,195,18,51,75,79,181,218,
        166,36,201,217,127,245,139,202,220,21,70,141,245,247,23,123,63,17,246,118,16,
        164,214,0,0,0,0,73,69,78,68,174,66,96,130};

        if (!bmp_read_png_stream(bmp,(void *)checkmark,ncheckmark,NULL))
            {
            if (x8==0)
                bmp_init(&check8);
            bmp_resample(&check8,bmp,0.,0.,(double)bmp->width,(double)bmp->height,n8,n8);
            x8=n8;
            }
        bmp_free(bmp);
        }
#endif

    /* Get background bitmap */
    if (bgbmp!=NULL)
        bmp_crop_ex(bmp,bgbmp,x0,y0,rect->right-rect->left+1,rect->bottom-rect->top+1);
    else
        {
        bmp->width=rect->right-rect->left+1;
        bmp->height=rect->bottom-rect->top+1;
        bmp->bpp=24;
        bmp_alloc(bmp);
        bmp_fill(bmp,255,255,255);
        }

    /* Draw checkbox and checkmark in bitmap */
    bpp=bmp->bpp==24 ? 3 : 1;
    for (i=0;i<cbw;i++)
        {
        unsigned char *p;
        p=bmp_rowptr_from_top(bmp,(h-cbw)/2)+bpp*(i+(h-cbw)/2);
        memset(p,0,bpp);
        p=bmp_rowptr_from_top(bmp,(h-cbw)/2+cbw-1)+bpp*(i+(h-cbw)/2);
        memset(p,0,bpp);
        p=bmp_rowptr_from_top(bmp,i+(h-cbw)/2)+bpp*((h-cbw)/2);
        memset(p,0,bpp);
        p=bmp_rowptr_from_top(bmp,i+(h-cbw)/2)+bpp*((h-cbw)/2+cbw-1);
        memset(p,0,bpp);
        }

    /* Draw checkmark from check8 stencil */
    if (checked && x8>0)
        {
        int r,c;
        for (r=0;r<x8;r++)
            {
            unsigned char *psrc;
            unsigned char *pdst;
            int rd;

            rd = r+h/2+cbw/2-2-x8;
            if (rd<0 || rd>bmp->height-1)
                continue;
            psrc=bmp_rowptr_from_top(&check8,r);
            pdst=bmp_rowptr_from_top(bmp,rd)+((h-cbw)/2+3)*bpp;
            for (c=0;c<x8;c++,pdst+=bpp,psrc++)
                {
                int k;
                static int pck[3]={0,255,255};

                for (k=0;k<bpp;k++)
                    {
                    int pix;
                    pix=pdst[k] + psrc[0]*(pck[k]-pdst[k])/255;
                    pdst[k]=pix;
                    }
                }
            }
        }

    /* Bit the bitmap in the window */
    bmp_blit_to_hdc(bmp,hdc,0,0);
    bmp_free(bmp);
/*        
    {
    RECT r;
    r.left=rect->left+(h-cbw)/2;
    r.top=rect->top+(h-cbw)/2;
    r.right=r.left+cbw-1;
    r.bottom=r.top+cbw-1;
    FrameRect(hdc,&r,tbrush);
    }
*/
    if (text[0]!='\0')
        {
        oldfont=SelectObject(hdc,hfont);
        SetTextColor(hdc,tcolor);
        SetBkMode(hdc,TRANSPARENT);
        ulx1=ulx2=uly=-1;
        for (i=j=0;text[i]!='\0' && j<255;i++)
            {
            if (i==0 && text[i]=='*')
                continue;
            if (text[i]=='&')
                {
                i++;
                if (text[i]!='&')
                    ulx1=j;
                }
            t2[j++]=text[i];
            }
        t2[j]='\0';
        win_gettextextentpoint_utf8((void *)hdc,t2,&size.cx,&size.cy);
        if (ulx1>=0)
            {
            if (ulx1>0)
                {
                int c;
                c=t2[ulx1];
                t2[ulx1]='\0';
                win_gettextextentpoint_utf8((void *)hdc,t2,&tusize.cx,&tusize.cy);
                t2[ulx1]=c;
                ulx1=tusize.cx;
                }
            else
                ulx1=0;
            tu[0]=t2[0];
            tu[1]='\0';
            win_gettextextentpoint_utf8((void *)hdc,tu,&tusize.cx,&tusize.cy);
            ulx1 += rect->left+cbw+dx;
            ulx2 = ulx1 + tusize.cx - 1;
            uly = (rect->top+rect->bottom)/2+size.cy/2-3;
            }
        SetTextAlign(hdc,TA_TOP|TA_LEFT);
        win_textout_utf8((void *)hdc,rect->left+cbw+dx,(rect->top+rect->bottom-size.cy)/2,t2);
        SelectObject(hdc,oldfont);
        if (ulx1 > 0)
            {
            SelectObject(hdc,pen);
            SetBkMode(hdc,TRANSPARENT);
            MoveToEx(hdc,ulx1,uly,NULL);
            LineTo(hdc,ulx2,uly);
            }
        if (state&ODS_FOCUS)
            {
            int x1;
            j= 5;
            SelectObject(hdc,pen_dotted);
            SetBkMode(hdc,TRANSPARENT);
            x1=rect->left+j+cbw+dx-5;
            MoveToEx(hdc,x1,rect->top+j,NULL);
            LineTo(hdc,rect->right-j-1,rect->top+j);
            LineTo(hdc,rect->right-j-1,rect->bottom-j-1);
            LineTo(hdc,x1,rect->bottom-j-1);
            LineTo(hdc,x1,rect->top+j);
            }
        } /* text[0]!='\0' */
    /* Delete pens / brushes */
    DeleteObject(pen_dotted);
    DeleteObject(pen);
    DeleteObject(tbrush);
    DeleteObject(brush);
    }
  
 
/*
** Assumes button was created WITHOUT WS_BORDER flag!
*/
void winmbox_button_draw(void *hdc0,void *rect0,int state,int basecolorrgb,
                         void *hfont0,char *text,int textcolorrgb)

    {
    HDC hdc;
    HFONT hfont,oldfont;
    RECT *rect;
    HBRUSH brush[7];
    HPEN pen_dotted;
    HPEN pen_solid;
    LOGBRUSH lbrush;
    int simple,selected,special,tcolor;
    static int unsel[13]={2,2,4,3,5,6,1,1,1,1,1,1,1};
    static int foc[13]={2,2,2,2,4,3,5,6,1,1,1,1,1};
    static int sel[13]={2,2,2,2,6,6,5,5,5,5,5,5,5};
    int i,j,dx,dy,cav,light,disabled;
    int ulx1,ulx2,uly;
    int *pat;
    char t2[256];
    char tu[4];
    int r0,g0,b0;
    double bmp_color_adjust;
    static int vals_light[6]={100,105,255,227,160};
    static int vals_dark[6]={100,105,255,227,160};
    int *vals;
    SIZE size,tusize;

    disabled=state&ODS_DISABLED;
    selected=state&ODS_SELECTED;
    bmp_color_adjust = selected ? 0.8 : 1.0;
    cav=(0.3*((basecolorrgb&0xff0000)>>16)
           + 0.59*((basecolorrgb&0xff00)>>8)
           + 0.11*(basecolorrgb&0xff));
    light = (cav > 0x80);
    hdc=(HDC)hdc0;
    rect=(RECT *)rect0;
    simple = (rect->bottom-rect->top+1 <=8 || rect->right-rect->left+1 <= 15);
    hfont=(HFONT)hfont0;
    r0=(textcolorrgb&0xff0000)>>16;
    g0=(textcolorrgb&0xff00)>>8;
    b0=(textcolorrgb&0xff);
    if (simple && selected)
        {
        r0 = 255-r0;
        g0 = 255-g0;
        b0 = 255-b0;
        }
    if (disabled)
        {
        r0/=2;
        g0/=2;
        b0/=2;
        /* add_gray(&r0,&g0,&b0,light ? 96 : -96); */
        }
    vals= light ? vals_light : vals_dark;
    tcolor=((b0<<16)|(g0<<8)|r0);
    brush[0]=CreateSolidBrush(tcolor);
    lbrush.lbStyle=BS_SOLID;
    lbrush.lbColor=tcolor;
    lbrush.lbHatch=0;
    pen_dotted=ExtCreatePen(PS_COSMETIC|PS_ALTERNATE,1,&lbrush,0,NULL);
    pen_solid=CreatePen(PS_SOLID,0,tcolor);
    r0=(basecolorrgb&0xff0000)>>16;
    g0=(basecolorrgb&0xff00)>>8;
    b0=(basecolorrgb&0xff);
    if (disabled)
        {
        r0/=2;
        g0/=2;
        b0/=2;
        /*add_gray(&r0,&g0,&b0,light ? -96 : 96);*/
        }
    if (simple && selected)
        {
        r0 = 255-r0;
        g0 = 255-g0;
        b0 = 255-b0;
        }
    brush[1]=CreateSolidBrush((b0<<16)|(g0<<8)|r0);
    if (!simple)
        for (j=0;j<5;j++)
            {
            int r,g,b;
            r = r0*vals[j]/240;
            if (r>255)
                r=255;
            g = g0*vals[j]/240;
            if (g>255)
                g=255;
            b = b0*vals[j]/240;
            if (b>255)
                b=255;
            brush[j+2]=CreateSolidBrush((b<<16)|(g<<8)|r);
            }
    pat = selected ? sel : (state&ODS_FOCUS ? foc : unsel);
    dx = selected ? 0 : -1;
    dy = selected ? 0 : -1;
    /* Button is small, so draw simple outline */
    if (simple)
        {
        RECT r;
        r.left=rect->left;
        r.top=rect->top;
        r.right=rect->right;
        r.bottom=rect->bottom;
        /* If WS_BORDER, don't need to do draw frame--windows does it. */
        if (light)
            brush[2]=CreateSolidBrush(0);
        else
            brush[2]=CreateSolidBrush(0xffffff);
        FrameRect(hdc,&r,brush[2]);
        r.left++;
        r.top++;
        r.right--;
        r.bottom--;
        FillRect(hdc,&r,brush[1]);
        }
    else
        for (j=0;j<7;j++)
            {
            RECT r;
            r.left=rect->left+j;
            r.top=rect->top+j;
            r.right=rect->right-j;
            r.bottom=rect->bottom-j;
            if (j==6)
                {
                FillRect(hdc,&r,brush[pat[j*2]]);
                break;
                }
            else
                FrameRect(hdc,&r,brush[pat[j*2+1]]);
            r.right--;
            r.bottom--;
            FrameRect(hdc,&r,brush[pat[j*2]]);
            }
    special=special_button_text(hdc,text,rect0,brush[0],pen_solid,simple,
                                (int)(bmp_color_adjust*r0),
                                (int)(bmp_color_adjust*g0),
                                (int)(bmp_color_adjust*b0));
    if (!special)
        {
        oldfont=SelectObject(hdc,hfont);
        SetTextColor(hdc,tcolor);
        SetBkMode(hdc,TRANSPARENT);
        ulx1=ulx2=uly=-1;
        for (i=j=0;text[i]!='\0' && j<255;i++)
            {
            if (i==0 && text[i]=='*')
                continue;
            if (text[i]=='&')
                {
                i++;
                if (text[i]!='&')
                    ulx1=j;
                }
            t2[j++]=text[i];
            }
        t2[j]='\0';
        win_gettextextentpoint_utf8((void *)hdc,t2,&size.cx,&size.cy);
        if (ulx1>=0)
            {
            if (ulx1>0)
                {
                int c;
                c=t2[ulx1];
                t2[ulx1]='\0';
                win_gettextextentpoint_utf8((void *)hdc,t2,&tusize.cx,&tusize.cy);
                t2[ulx1]=c;
                ulx1=tusize.cx;
                }
            else
                ulx1=0;
            tu[0]=t2[0];
            tu[1]='\0';
            win_gettextextentpoint_utf8((void *)hdc,tu,&tusize.cx,&tusize.cy);
            ulx1 += dx+(rect->left+rect->right)/2-size.cx/2;
            ulx2 = ulx1 + tusize.cx - 1;
            uly = dy+(rect->top+rect->bottom)/2+size.cy/2-3;
            }
        SetTextAlign(hdc,TA_TOP|TA_CENTER);
        win_textout_utf8((void *)hdc,dx+(rect->left+rect->right)/2,dy+(rect->top+rect->bottom-size.cy)/2,t2);
        SelectObject(hdc,oldfont);
        if (ulx1 > 0)
            {
            SelectObject(hdc,pen_solid);
            SetBkMode(hdc,TRANSPARENT);
            MoveToEx(hdc,ulx1,uly,NULL);
            LineTo(hdc,ulx2,uly);
            }
        }
    if (!special && (state&ODS_FOCUS))
        {
        /* RECT r; */
        j= simple ? 2 : 5;
        /*
        r.left=rect->left+j;
        r.top=rect->top+j;
        r.right=rect->right-j;
        r.bottom=rect->bottom-j;
        */
        // FrameRect(hdc,&r,brush[i][0]);
        SelectObject(hdc,pen_dotted);
        SetBkMode(hdc,TRANSPARENT);
        MoveToEx(hdc,rect->left+j,rect->top+j,NULL);
        LineTo(hdc,rect->right-j-1,rect->top+j);
        LineTo(hdc,rect->right-j-1,rect->bottom-j-1);
        LineTo(hdc,rect->left+j,rect->bottom-j-1);
        LineTo(hdc,rect->left+j,rect->top+j);
        }
    /* Delete pens / brushes */
    DeleteObject(pen_dotted);
    DeleteObject(pen_solid);
    for (i=simple ? 2 : 6;i>=0;i--)
        DeleteObject(brush[i]);
    }
   

/*
** Does not work entirely correctly without PNG lib.
*/ 
static int special_button_text(HDC hdc,char *text,RECT *rect,HBRUSH brush,HPEN pen,int simple,
                               int r0,int g0,int b0)

    {
    int ik,dx,w2;
    static char *keyword[] = {"_up_","_down_","_left_","_dleft_","_right_","_dright_",
                              "_magplus_","_magminus_","_fitpage_",""};

    for (ik=0;keyword[ik][0]!='\0';ik++)
        if (!strcmp(keyword[ik],text))
            break;
    if (keyword[ik][0]=='\0')
        return(0);
    w2=dx=0; /* Avoid compiler warning */
    if (ik>=0 && ik<=5)
        {
        SelectObject(hdc,brush);
        SelectObject(hdc,pen);
        SetPolyFillMode(hdc,WINDING);
        BeginPath(hdc);
        dx=(rect->right-rect->left)/10;
        if (dx<2)
            dx=simple ? 2 : 3;
        if (ik>1)
            dx++;
        w2=(rect->right-rect->left+1)/2;
        }
    switch (ik)
        {
        case 0: /* UP */
            MoveToEx(hdc,rect->left+dx,rect->bottom-dx-1,NULL);
            LineTo(hdc,(rect->left+rect->right-1)/2,rect->top+dx);
            LineTo(hdc,rect->right-dx-1,rect->bottom-dx-1);
            break;
        case 1: /* DOWN */
            MoveToEx(hdc,rect->left+dx,rect->top+dx,NULL);
            LineTo(hdc,(rect->left+rect->right-1)/2,rect->bottom-dx-1);
            LineTo(hdc,rect->right-dx-1,rect->top+dx);
            break;
        case 2: /* LEFT */
            MoveToEx(hdc,rect->left+dx,(rect->top+rect->bottom-1)/2,NULL);
            LineTo(hdc,rect->right-dx-1,rect->top+dx);
            LineTo(hdc,rect->right-dx-1,rect->bottom-1-dx);
            break;
        case 3: /* DOUBLE LEFT */
            MoveToEx(hdc,rect->left+dx,(rect->top+rect->bottom-1)/2,NULL);
            LineTo(hdc,rect->left+w2-1,rect->top+dx);
            LineTo(hdc,rect->left+w2-1,rect->bottom-1-dx);
            EndPath(hdc);
            StrokeAndFillPath(hdc);
            BeginPath(hdc);
            MoveToEx(hdc,rect->left+w2,(rect->top+rect->bottom-1)/2,NULL);
            LineTo(hdc,rect->right-dx-1,rect->top+dx);
            LineTo(hdc,rect->right-dx-1,rect->bottom-1-dx);
            break;
        case 4: /* RIGHT */
            MoveToEx(hdc,rect->right-dx-1,(rect->top+rect->bottom-1)/2,NULL);
            LineTo(hdc,rect->left+dx,rect->top+dx);
            LineTo(hdc,rect->left+dx,rect->bottom-1-dx);
            break;
        case 5: /* DOUBLE RIGHT */
            MoveToEx(hdc,rect->right-dx-1,(rect->top+rect->bottom-1)/2,NULL);
            LineTo(hdc,rect->left+w2,rect->top+dx);
            LineTo(hdc,rect->left+w2,rect->bottom-1-dx);
            EndPath(hdc);
            StrokeAndFillPath(hdc);
            BeginPath(hdc);
            MoveToEx(hdc,rect->left+w2-1,(rect->top+rect->bottom-1)/2,NULL);
            LineTo(hdc,rect->left+dx,rect->top+dx);
            LineTo(hdc,rect->left+dx,rect->bottom-1-dx);
            break;
        case 6:
        case 7:
        case 8:
            {
            int nbmpdata;
            unsigned char *bmpdata;
            WILLUSBITMAP *bmp,_bmp;
            bmp=&_bmp;
            bmp_init(bmp);
            if (ik==6)
                {
                nbmpdata=n_magplus;
                bmpdata=xmagplus;
                }
            else if (ik==7)
                {
                nbmpdata=n_magminus;
                bmpdata=xmagminus;
                }
            else
                {
                nbmpdata=n_fitpage;
                bmpdata=xfitpage;
                }
#if (defined(HAVE_PNG_LIB))
            if (!bmp_read_png_stream(bmp,(void *)bmpdata,nbmpdata,NULL))
                {
                WILLUSBITMAP *bmpsmall,_bmpsmall;
                int i,bw;;

                bw=4; /* Border width */
                /* Replace white-ish pixels with requested bgcolor */
                for (i=0;i<bmp->height;i++)
                    {
                    unsigned char *p;
                    int j;
                    p=bmp_rowptr_from_top(bmp,i);
                    for (j=0;j<bmp->width;j++,p+=3)
                        {
                        if (p[0]==p[1] && p[1]==p[2] && p[0]>200)
                            {
                            p[0]=r0;
                            p[1]=g0;
                            p[2]=b0;
                            }
                        }
                    }
                bmpsmall=&_bmpsmall;
                bmp_init(bmpsmall);
                bmp_resample(bmpsmall,bmp,0.,0.,(double)bmp->width,(double)bmp->height,
                              rect->right-rect->left+1-bw*2,rect->bottom-rect->top+1-bw*2);
                bmp_blit_to_hdc_ex(bmpsmall,hdc,bw,bw,rect->right-rect->left+1-bw*2,
                                     rect->bottom-rect->top+1-bw*2,0,0);
                bmp_free(bmpsmall);
                bmp_free(bmp);
                }
#endif
            }
        }
    if (ik>=0 && ik<=5)
        {
        EndPath(hdc);
        StrokeAndFillPath(hdc);
        }
    return(1);
    }


int winmbox_def_proc(void *hwnd,int iMsg,int wParam,void *lParam)

    {
/*
ansi_dprintf(NULL,"WINMBOX: iMsg=%d, wParam=%d,%d, lParam=%d\n",(int)iMsg,(int)LOWORD(wParam),(int)HIWORD(wParam),(int)lParam);
*/
    switch (iMsg)
        {
        case WM_DRAWITEM:
            {
            int buttonid;

            buttonid=(int)wParam;
            if (buttonid>=3 && buttonid<=5)
                {
                LPDRAWITEMSTRUCT lpdis;
                int buttoncolor,cav,textcolor;
                char *buttontext;
                
                buttoncolor=wmb->buttoncolor[buttonid-3];
                if (buttonid==3)
                    buttontext=wmb->b1;
                else if (buttonid==4)
                    buttontext=wmb->b2;
                else
                    buttontext=wmb->b3;
                lpdis=(LPDRAWITEMSTRUCT)lParam;
                cav=(0.11*((buttoncolor&0xff0000)>>16)
                       + 0.59*((buttoncolor&0xff00)>>8)
                       + 0.3*(buttoncolor&0xff));
                textcolor = cav>128 ? 0 : 0xffffff;
                winmbox_button_draw((void *)lpdis->hDC,(void *)&lpdis->rcItem,
                                     lpdis->itemState,buttoncolor,(void *)wmb->bf,
                                     buttontext,textcolor);
                }
            return(1);
            }
        /* Window never gets this message...no keystrokes make it. */
        /*
        case WM_CHAR:
            if (wParam==1)
                {
                if (wmb->inbuf!=NULL)
                    {
                    SetFocus(wmb->edit_hwnd);
                    SendMessage(wmb->edit_hwnd,EM_SETSEL,0,-1);
                    }
                return(0);
                }
            break;
        */
        case WM_COMMAND:
/*
ansi_dprintf(NULL,"WM_COMMAND: iMsg=%d, wParam=%d,%d, lParam=%d\n",(int)iMsg,(int)LOWORD(wParam),(int)HIWORD(wParam),(int)lParam);
*/
            if (LOWORD(wParam)==10 && HIWORD(wParam)==EN_SETFOCUS)
                {
                winmbox_draw_defbutton_border(1);
                break;
                }
            if (LOWORD(wParam)==10 && HIWORD(wParam)==EN_KILLFOCUS)
                {
                winmbox_draw_defbutton_border(0);
                break;
                }
            if (LOWORD(wParam)>=0 && LOWORD(wParam)<=5)
                {
                if (wmb->inbuf!=NULL && wmb->aboutbox.right-wmb->aboutbox.left==0)
                    SendMessage(wmb->edit_hwnd,WM_GETTEXT,(WPARAM)wmb->maxlen-1,(LPARAM)wmb->inbuf);
                if (wmb->passbuf!=NULL)
                    SendMessage(wmb->pass_hwnd,WM_GETTEXT,(WPARAM)wmb->passmaxlen-1,(LPARAM)wmb->passbuf);
                wmb->status=LOWORD(wParam);
                if (wmb->status==2)
                    wmb->status=-1;
                else if (wmb->status==1)
                    {
                    if (GetFocus()==wmb->b1_hwnd)
                        wmb->status=1;
                    else if (GetFocus()==wmb->b2_hwnd)
                        wmb->status=2;
                    else if (GetFocus()==wmb->b3_hwnd)
                        wmb->status=3;
                    else if (wmb->b1[0]=='*')
                        wmb->status=1;
                    else if (wmb->b2[0]=='*')
                        wmb->status=2;
                    else if (wmb->b3[0]=='*')
                        wmb->status=3;
                    else
                        wmb->status=4;
                    }
                else
                    wmb->status -= 2;
                SendMessage(hwnd,WM_CLOSE,0,0);
                return(0);
                }
            break;
        case WM_CLOSE:
            if (wmb->modal && wmb->parent!=NULL)
                EnableWindow(wmb->parent,1);
            winmbox_destroy();
            return(0);
        case WM_DESTROY:
            break;
        }
    return(DefWindowProc((HANDLE)hwnd,iMsg,(WPARAM)wParam,(LPARAM)lParam));
    }


void winmbox_destroy(void)

    {
    if (!wmb_inuse)
        return;
    if (wmb->b3_hwnd!=NULL)
        {
        DestroyWindow(wmb->b3_hwnd);
        wmb->b3_hwnd=NULL;
        }
    if (wmb->b2_hwnd!=NULL)
        {
        DestroyWindow(wmb->b2_hwnd);
        wmb->b2_hwnd=NULL;
        }
    if (wmb->b1_hwnd!=NULL)
        {
        DestroyWindow(wmb->b1_hwnd);
        wmb->b1_hwnd=NULL;
        }
    if (wmb->edit_hwnd!=NULL)
        {
        DestroyWindow(wmb->edit_hwnd);
        wmb->edit_hwnd=NULL;
        }
    DeleteObject(wmb->mf);
    wmb->mf=NULL;
    DeleteObject(wmb->bf);
    wmb->bf=NULL;
    DeleteObject(wmb->brush);
    wmb->brush=NULL;
    DestroyWindow(wmb->hwnd);
    wmb->hwnd=NULL;
    UnregisterClass(wmb->class,wmb->hinstance);
    wmb_inuse=0;
    }


static void winmbox_text_extents(HFONT hf,char *message,SIZE *size,int maxwidth)

    {
    winmbox_display_text(hf,message,size,maxwidth,NULL,0,0);
    }


static void winmbox_display_text(HFONT hf,char *message,SIZE *size,int maxwidth,
                                 HDC hdc,int x0,int y0)

    {
    SIZE m;
    int i;
    char s[1024];

    if (message==NULL || message[0]=='\0')
        {
        size->cx=size->cy=0;
        return;
        }
    if (maxwidth<0)
        {
        winmbox_display_text_1(hf,message,size,hdc,x0,y0);
        return;
        }
    m.cx=m.cy=0;
    for (i=0;message[i]!='\0';i++)
        {
        SIZE sz;
        int j;

        for (j=0;message[i]!='\0' && message[i]!='\n';i++)
            s[j++]=message[i];
        s[j]='\0'; 
        winmbox_display_line(hf,s,&sz,maxwidth,hdc,x0,y0);
        if (sz.cx > m.cx)
            m.cx=sz.cx;
        m.cy += sz.cy;
        y0 += sz.cy;
        if (message[i]=='\0')
            break;
        }
    size->cx=m.cx;
    size->cy=m.cy;
    }


static void winmbox_display_line(HFONT hf,char *s,SIZE *size,int maxwidth,
                                  HDC hdc,int x0,int y0)

    {
    int i0,i;
    SIZE sz;
    double linerat;

    linerat=WMB_LINERAT;
    size->cx=size->cy=0;
    for (i0=0,i=i0+strlen(&s[i0]);i>=i0;i--)
        {
        int c,j;

        j=(i==i0)?i0+strlen(&s[i0]):i;
        c=s[j];
        s[j]='\0';
        winmbox_display_text_1(hf,&s[i0],&sz,NULL,0,0);
        s[j]=c;
        if (i==i0 || (sz.cx+sz.cy*2. <= maxwidth && (s[i]=='\0' || s[i]==' ')))
            {
            if (hdc!=NULL)
                {
                c=s[j];
                s[j]='\0';
                winmbox_display_text_1(hf,&s[i0],&sz,hdc,x0,y0);
                s[j]=c;
                }
            size->cy += sz.cy*linerat;
            y0 += sz.cy*linerat;
            if (sz.cx > size->cx)
                size->cx=sz.cx;
            if (s[j]=='\0')
                return;
            i0=i+1;
            i=i0+strlen(&s[i0])+1;
            }
        }
    }


static void winmbox_display_text_1(HFONT hf,char *buf,SIZE *size,
                                    HDC hdc1,int x0,int y0)

    {
    HDC hdc;
    HFONT oldfont;

    hdc=(hdc1==NULL) ? GetDC(GetDesktopWindow()) : hdc1;
    oldfont=(HFONT)SelectObject(hdc,hf);
    win_gettextextentpoint_utf8((void *)hdc,buf,&size->cx,&size->cy);
    if (hdc1!=NULL)
        win_textout_utf8((void *)hdc,x0,y0,buf);
    SelectObject(hdc,oldfont);
    if (hdc1==NULL)
        ReleaseDC(GetDesktopWindow(),hdc);
    }


static char winmbox_fontname[64];

void winmbox_set_font(char *fontname)

    {
    strncpy(winmbox_fontname,fontname,63);
    winmbox_fontname[63]='\0';
    if (wmb_inuse < 0)
        wmb_inuse = 0;
    }


static HFONT winmbox_get_font(double fsize)

    {
    HFONT hf;
    hf=CreateFont((int)(fsize+.5),0,0,0,FW_NORMAL,0,0,0,ANSI_CHARSET,
                      OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
                      DEFAULT_QUALITY,DEFAULT_PITCH|FF_DONTCARE,
                      winmbox_fontname[0]!='\0' ? winmbox_fontname : "Calibri");
    if (hf==NULL)
        hf=CreateFont((int)(fsize+.5),0,0,0,FW_NORMAL,0,0,0,ANSI_CHARSET,
                      OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
                      DEFAULT_QUALITY,DEFAULT_PITCH|FF_DONTCARE,"Arial");
    return(hf);
    }


static int winmbox_wait_last_pointer=0;
static int winmbox_wait_pointer_status=0;
static int winmbox_wait_allow_cancel=0;
static int winmbox_wait_cancelled=0;
static int winmbox_wait_busy_status=0;
static HWND winmbox_wait_hwnd=NULL;
static int winmbox_wait_bgcolor=0xffe0a0;
static int winmbox_wait_callback(HWND hwnd,UINT iMsg,WPARAM wParam,LPARAM lParam);

void winmbox_wait(void *mainwin,char *message,int cancel_option)

    {
    static int bcolors[3]={0xa00000,0xf0f0f0,0xf0f0f0};

    if (winmbox_wait_hwnd!=NULL)
        winmbox_wait_end();
    if (cancel_option)
        {
        winmbox_message_box(mainwin,"Please wait...",message,
                            "*&CANCEL",NULL,NULL,NULL,0,30,600,winmbox_wait_bgcolor,
                            (void *)winmbox_wait_callback,(void **)&winmbox_wait_hwnd,bcolors);
        winmbox_wait_normal_pointer();
        winmbox_wait_allow_cancel=1;
        }
    else
        {
        winmbox_message_box(mainwin,"Please wait...",message,
                            NULL,NULL,NULL,NULL,0,30,600,winmbox_wait_bgcolor,
                            (void *)winmbox_wait_callback,(void **)&winmbox_wait_hwnd,NULL);
        winmbox_wait_busy_pointer();
        winmbox_wait_allow_cancel=0;
        }
/*
{
FILE *f;
f=fopen("debug.txt","a");
fprintf(f,"winmbox_wait_hwnd=%p\n",winmbox_wait_hwnd);
fclose(f);
}
*/
    winmbox_wait_cancelled=0;
    winmbox_wait_busy_status=1;
    winmbox_wait_bgcolor=0xffe0a0;
    }


int winmbox_wait_cancel(void)

    {
    winmbox_wait_proc_messages();
    return(winmbox_wait_cancelled);
    }


void winmbox_wait_proc_messages(void)

    {
    MSG msg;
    int i;

    if (winmbox_wait_hwnd==NULL)
        return;
    for (i=0;i<50;i++)
        {
        if (!PeekMessage(&msg,winmbox_wait_hwnd,0,0,PM_REMOVE))
            break;
        if (!IsDialogMessage(winmbox_wait_hwnd,&msg))
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            }
        }
    }


static int winmbox_wait_callback(HWND hwnd,UINT iMsg,WPARAM wParam,LPARAM lParam)

    {
    if (iMsg==WM_COMMAND)
        {
        int child_id;

        child_id = LOWORD(wParam);
        /* Allow ENTER, ESC, or button press to Cancel */
        if (winmbox_wait_allow_cancel && (child_id>=1 && child_id<=3))
            {
            winmbox_wait_cancelled=1;
            winmbox_wait_end();
            }
        }
    return(winmbox_def_proc(hwnd,iMsg,wParam,(void *)lParam));
    }


void winmbox_wait_end(void)

    {
    if (winmbox_wait_hwnd!=NULL)
        {
        winmbox_destroy();
        winmbox_wait_hwnd=NULL;
        }
    winmbox_wait_busy_status=0;
    winmbox_wait_normal_pointer();
    }


int winmbox_wait_busy(void)

    {
    return(winmbox_wait_busy_status);
    }


void winmbox_wait_busy_pointer(void)

    {
    winmbox_wait_last_pointer=winmbox_wait_pointer_status;
    SetCursor(LoadCursor(NULL,IDC_WAIT));
    winmbox_wait_pointer_status=1;
    }


void winmbox_wait_restore_pointer(void)

    {
    if (winmbox_wait_last_pointer)
        winmbox_wait_busy_pointer();
    else
        winmbox_wait_normal_pointer();
    }


void winmbox_wait_normal_pointer(void)

    {
    winmbox_wait_last_pointer=winmbox_wait_pointer_status;
    SetCursor(LoadCursor(NULL,IDC_ARROW));
    winmbox_wait_pointer_status=0;
    }


#endif /* HAVE_WIN32_API */
