package org.eclipse.webdav.internal.kernel;

/*
 * (c) Copyright IBM Corp. 2000, 2001.
 * All Rights Reserved.
 */

import org.eclipse.webdav.dom.QualifiedName;

import org.eclipse.webdav.internal.kernel.QualifiedNameImpl;

public interface WebDAVPropertyValues extends WebDAVConstants {
	
	// Resource types.
	QualifiedName DAV_ACTIVITY_RESOURCE_TYPE = new QualifiedNameImpl(DAV_URI, "activity-resourcetype");
	QualifiedName DAV_BASELINE_RESOURCE_TYPE = new QualifiedNameImpl(DAV_URI, "baseline-resourcetype");
	QualifiedName DAV_COLLECTION_RESOURCE_TYPE = new QualifiedNameImpl(DAV_URI, "collection");
	QualifiedName DAV_VERSION_HISTORY_RESOURCE_TYPE = new QualifiedNameImpl(DAV_URI, "version-history-resourcetype");
	QualifiedName DAV_WORKSPACE_RESOURCE_TYPE = new QualifiedNameImpl(DAV_URI, "workspace-resourcetype");
	QualifiedName DAV_HISTORY_RESOURCE_TYPE = new QualifiedNameImpl(DAV_URI, "history-resourcetype");

	// Check-in policies.
	QualifiedName DAV_KEEP_CHECKED_OUT = new QualifiedNameImpl(DAV_URI, "keep-checked-out");
	QualifiedName DAV_NEW_VERSION = new QualifiedNameImpl(DAV_URI, "new-version");
	QualifiedName DAV_OVERWRITE = new QualifiedNameImpl(DAV_URI, "overwrite");

	// Auto-version policies.
	QualifiedName DAV_LOCKED_UPDATE = new QualifiedNameImpl(DAV_URI, "locked-update");
	QualifiedName DAV_UNLOCKED_UPDATE = new QualifiedNameImpl(DAV_URI, "unlocked-update");

	// Fork control policy.
	QualifiedName DAV_OK = new QualifiedNameImpl(DAV_URI, "ok");
	QualifiedName DAV_DISCOURAGED = new QualifiedNameImpl(DAV_URI, "discouraged");
	QualifiedName DAV_FORBIDDEN = new QualifiedNameImpl(DAV_URI, "forbidden");
}