// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_3_3_autogen.cpp:
//   Defines the GL 3.3 entry points.

#include "libGL/entry_points_gl_3_3_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/gl_enum_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationES32.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL33_autogen.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY BindFragDataLocationIndexed(GLuint program,
                                             GLuint colorNumber,
                                             GLuint index,
                                             const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BindFragDataLocationIndexed, "glBindFragDataLocationIndexed",
          "context = %d, program = %u, colorNumber = %u, index = %u, name = 0x%016" PRIxPTR "",
          CID(context), program, colorNumber, index, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBindFragDataLocationIndexed(context, programPacked, colorNumber, index, name));
        if (isCallValid)
        {
            context->bindFragDataLocationIndexed(programPacked, colorNumber, index, name);
        }
        ANGLE_CAPTURE(BindFragDataLocationIndexed, isCallValid, context, programPacked, colorNumber,
                      index, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BindSampler(GLuint unit, GLuint sampler)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BindSampler, "glBindSampler",
          "context = %d, unit = %u, sampler = %u", CID(context), unit, sampler);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindSampler(context, unit, samplerPacked));
        if (isCallValid)
        {
            context->bindSampler(unit, samplerPacked);
        }
        ANGLE_CAPTURE(BindSampler, isCallValid, context, unit, samplerPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ColorP3ui(GLenum type, GLuint color)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ColorP3ui, "glColorP3ui", "context = %d, type = %s, color = %u",
          CID(context), GLenumToString(GLenumGroup::ColorPointerType, type), color);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateColorP3ui(context, type, color));
        if (isCallValid)
        {
            context->colorP3ui(type, color);
        }
        ANGLE_CAPTURE(ColorP3ui, isCallValid, context, type, color);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ColorP3uiv(GLenum type, const GLuint *color)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ColorP3uiv, "glColorP3uiv",
          "context = %d, type = %s, color = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ColorPointerType, type), (uintptr_t)color);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateColorP3uiv(context, type, color));
        if (isCallValid)
        {
            context->colorP3uiv(type, color);
        }
        ANGLE_CAPTURE(ColorP3uiv, isCallValid, context, type, color);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ColorP4ui(GLenum type, GLuint color)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ColorP4ui, "glColorP4ui", "context = %d, type = %s, color = %u",
          CID(context), GLenumToString(GLenumGroup::ColorPointerType, type), color);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateColorP4ui(context, type, color));
        if (isCallValid)
        {
            context->colorP4ui(type, color);
        }
        ANGLE_CAPTURE(ColorP4ui, isCallValid, context, type, color);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ColorP4uiv(GLenum type, const GLuint *color)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ColorP4uiv, "glColorP4uiv",
          "context = %d, type = %s, color = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ColorPointerType, type), (uintptr_t)color);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateColorP4uiv(context, type, color));
        if (isCallValid)
        {
            context->colorP4uiv(type, color);
        }
        ANGLE_CAPTURE(ColorP4uiv, isCallValid, context, type, color);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DeleteSamplers(GLsizei count, const GLuint *samplers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DeleteSamplers, "glDeleteSamplers",
          "context = %d, count = %d, samplers = 0x%016" PRIxPTR "", CID(context), count,
          (uintptr_t)samplers);

    if (context)
    {
        const SamplerID *samplersPacked                       = FromGL<const SamplerID *>(samplers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteSamplers(context, count, samplersPacked));
        if (isCallValid)
        {
            context->deleteSamplers(count, samplersPacked);
        }
        ANGLE_CAPTURE(DeleteSamplers, isCallValid, context, count, samplersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GenSamplers(GLsizei count, GLuint *samplers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GenSamplers, "glGenSamplers",
          "context = %d, count = %d, samplers = 0x%016" PRIxPTR "", CID(context), count,
          (uintptr_t)samplers);

    if (context)
    {
        SamplerID *samplersPacked                             = FromGL<SamplerID *>(samplers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenSamplers(context, count, samplersPacked));
        if (isCallValid)
        {
            context->genSamplers(count, samplersPacked);
        }
        ANGLE_CAPTURE(GenSamplers, isCallValid, context, count, samplersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLint GL_APIENTRY GetFragDataIndex(GLuint program, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetFragDataIndex, "glGetFragDataIndex",
          "context = %d, program = %u, name = 0x%016" PRIxPTR "", CID(context), program,
          (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetFragDataIndex(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getFragDataIndex(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetFragDataIndex, GLint>();
        }
        ANGLE_CAPTURE(GetFragDataIndex, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::GetFragDataIndex, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GetQueryObjecti64v(GLuint id, GLenum pname, GLint64 *params)
{
    Context *context = GetGlobalContext();
    EVENT(context, gl::EntryPoint::GetQueryObjecti64v, "glGetQueryObjecti64v",
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLenumGroup::QueryObjectParameterName, pname), (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                                      = FromGL<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryObjecti64v(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjecti64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjecti64v, isCallValid, context, idPacked, pname, params);
    }
    else
    {}
}

void GL_APIENTRY GetQueryObjectui64v(GLuint id, GLenum pname, GLuint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetQueryObjectui64v, "glGetQueryObjectui64v",
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLenumGroup::QueryObjectParameterName, pname), (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                                      = FromGL<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryObjectui64v(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectui64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectui64v, isCallValid, context, idPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetSamplerParameterIiv(GLuint sampler, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetSamplerParameterIiv, "glGetSamplerParameterIiv",
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameterIiv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIiv, isCallValid, context, samplerPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetSamplerParameterIuiv(GLuint sampler, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetSamplerParameterIuiv, "glGetSamplerParameterIuiv",
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameterIuiv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIuiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIuiv, isCallValid, context, samplerPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetSamplerParameterfv(GLuint sampler, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetSamplerParameterfv, "glGetSamplerParameterfv",
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameterfv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterfv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterfv, isCallValid, context, samplerPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetSamplerParameteriv(GLuint sampler, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetSamplerParameteriv, "glGetSamplerParameteriv",
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameteriv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameteriv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameteriv, isCallValid, context, samplerPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY IsSampler(GLuint sampler)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::IsSampler, "glIsSampler", "context = %d, sampler = %u",
          CID(context), sampler);

    GLboolean returnValue;
    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsSampler(context, samplerPacked));
        if (isCallValid)
        {
            returnValue = context->isSampler(samplerPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsSampler, GLboolean>();
        }
        ANGLE_CAPTURE(IsSampler, isCallValid, context, samplerPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::IsSampler, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY MultiTexCoordP1ui(GLenum texture, GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MultiTexCoordP1ui, "glMultiTexCoordP1ui",
          "context = %d, texture = %s, type = %s, coords = %u", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP1ui(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP1ui(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP1ui, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY MultiTexCoordP1uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MultiTexCoordP1uiv, "glMultiTexCoordP1uiv",
          "context = %d, texture = %s, type = %s, coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP1uiv(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP1uiv(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP1uiv, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY MultiTexCoordP2ui(GLenum texture, GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MultiTexCoordP2ui, "glMultiTexCoordP2ui",
          "context = %d, texture = %s, type = %s, coords = %u", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP2ui(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP2ui(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP2ui, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY MultiTexCoordP2uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MultiTexCoordP2uiv, "glMultiTexCoordP2uiv",
          "context = %d, texture = %s, type = %s, coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP2uiv(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP2uiv(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP2uiv, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY MultiTexCoordP3ui(GLenum texture, GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MultiTexCoordP3ui, "glMultiTexCoordP3ui",
          "context = %d, texture = %s, type = %s, coords = %u", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP3ui(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP3ui(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP3ui, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY MultiTexCoordP3uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MultiTexCoordP3uiv, "glMultiTexCoordP3uiv",
          "context = %d, texture = %s, type = %s, coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP3uiv(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP3uiv(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP3uiv, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY MultiTexCoordP4ui(GLenum texture, GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MultiTexCoordP4ui, "glMultiTexCoordP4ui",
          "context = %d, texture = %s, type = %s, coords = %u", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP4ui(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP4ui(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP4ui, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY MultiTexCoordP4uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MultiTexCoordP4uiv, "glMultiTexCoordP4uiv",
          "context = %d, texture = %s, type = %s, coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiTexCoordP4uiv(context, texture, type, coords));
        if (isCallValid)
        {
            context->multiTexCoordP4uiv(texture, type, coords);
        }
        ANGLE_CAPTURE(MultiTexCoordP4uiv, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY NormalP3ui(GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::NormalP3ui, "glNormalP3ui",
          "context = %d, type = %s, coords = %u", CID(context),
          GLenumToString(GLenumGroup::NormalPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateNormalP3ui(context, type, coords));
        if (isCallValid)
        {
            context->normalP3ui(type, coords);
        }
        ANGLE_CAPTURE(NormalP3ui, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY NormalP3uiv(GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::NormalP3uiv, "glNormalP3uiv",
          "context = %d, type = %s, coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::NormalPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateNormalP3uiv(context, type, coords));
        if (isCallValid)
        {
            context->normalP3uiv(type, coords);
        }
        ANGLE_CAPTURE(NormalP3uiv, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY QueryCounter(GLuint id, GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::QueryCounter, "glQueryCounter",
          "context = %d, id = %u, target = %s", CID(context), id,
          GLenumToString(GLenumGroup::QueryTarget, target));

    if (context)
    {
        QueryID idPacked                                      = FromGL<QueryID>(id);
        QueryType targetPacked                                = FromGL<QueryType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateQueryCounter(context, idPacked, targetPacked));
        if (isCallValid)
        {
            context->queryCounter(idPacked, targetPacked);
        }
        ANGLE_CAPTURE(QueryCounter, isCallValid, context, idPacked, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY SamplerParameterIiv(GLuint sampler, GLenum pname, const GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::SamplerParameterIiv, "glSamplerParameterIiv",
          "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameterIiv(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIiv, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY SamplerParameterIuiv(GLuint sampler, GLenum pname, const GLuint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::SamplerParameterIuiv, "glSamplerParameterIuiv",
          "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameterIuiv(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIuiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIuiv, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY SamplerParameterf(GLuint sampler, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::SamplerParameterf, "glSamplerParameterf",
          "context = %d, sampler = %u, pname = %s, param = %f", CID(context), sampler,
          GLenumToString(GLenumGroup::SamplerParameterName, pname), param);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameterf(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterf(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterf, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY SamplerParameterfv(GLuint sampler, GLenum pname, const GLfloat *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::SamplerParameterfv, "glSamplerParameterfv",
          "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameterfv(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterfv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterfv, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY SamplerParameteri(GLuint sampler, GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::SamplerParameteri, "glSamplerParameteri",
          "context = %d, sampler = %u, pname = %s, param = %d", CID(context), sampler,
          GLenumToString(GLenumGroup::SamplerParameterName, pname), param);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameteri(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameteri(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameteri, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY SamplerParameteriv(GLuint sampler, GLenum pname, const GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::SamplerParameteriv, "glSamplerParameteriv",
          "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameteriv(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameteriv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameteriv, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY SecondaryColorP3ui(GLenum type, GLuint color)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::SecondaryColorP3ui, "glSecondaryColorP3ui",
          "context = %d, type = %s, color = %u", CID(context),
          GLenumToString(GLenumGroup::ColorPointerType, type), color);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateSecondaryColorP3ui(context, type, color));
        if (isCallValid)
        {
            context->secondaryColorP3ui(type, color);
        }
        ANGLE_CAPTURE(SecondaryColorP3ui, isCallValid, context, type, color);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY SecondaryColorP3uiv(GLenum type, const GLuint *color)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::SecondaryColorP3uiv, "glSecondaryColorP3uiv",
          "context = %d, type = %s, color = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ColorPointerType, type), (uintptr_t)color);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateSecondaryColorP3uiv(context, type, color));
        if (isCallValid)
        {
            context->secondaryColorP3uiv(type, color);
        }
        ANGLE_CAPTURE(SecondaryColorP3uiv, isCallValid, context, type, color);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexCoordP1ui(GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexCoordP1ui, "glTexCoordP1ui",
          "context = %d, type = %s, coords = %u", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP1ui(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP1ui(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP1ui, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexCoordP1uiv(GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexCoordP1uiv, "glTexCoordP1uiv",
          "context = %d, type = %s, coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP1uiv(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP1uiv(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP1uiv, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexCoordP2ui(GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexCoordP2ui, "glTexCoordP2ui",
          "context = %d, type = %s, coords = %u", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP2ui(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP2ui(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP2ui, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexCoordP2uiv(GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexCoordP2uiv, "glTexCoordP2uiv",
          "context = %d, type = %s, coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP2uiv(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP2uiv(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP2uiv, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexCoordP3ui(GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexCoordP3ui, "glTexCoordP3ui",
          "context = %d, type = %s, coords = %u", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP3ui(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP3ui(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP3ui, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexCoordP3uiv(GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexCoordP3uiv, "glTexCoordP3uiv",
          "context = %d, type = %s, coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP3uiv(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP3uiv(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP3uiv, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexCoordP4ui(GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexCoordP4ui, "glTexCoordP4ui",
          "context = %d, type = %s, coords = %u", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP4ui(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP4ui(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP4ui, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexCoordP4uiv(GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexCoordP4uiv, "glTexCoordP4uiv",
          "context = %d, type = %s, coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexCoordP4uiv(context, type, coords));
        if (isCallValid)
        {
            context->texCoordP4uiv(type, coords);
        }
        ANGLE_CAPTURE(TexCoordP4uiv, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribDivisor(GLuint index, GLuint divisor)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribDivisor, "glVertexAttribDivisor",
          "context = %d, index = %u, divisor = %u", CID(context), index, divisor);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribDivisor(context, index, divisor));
        if (isCallValid)
        {
            context->vertexAttribDivisor(index, divisor);
        }
        ANGLE_CAPTURE(VertexAttribDivisor, isCallValid, context, index, divisor);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribP1ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribP1ui, "glVertexAttribP1ui",
          "context = %d, index = %u, type = %s, normalized = %s, value = %u", CID(context), index,
          GLenumToString(GLenumGroup::VertexAttribPointerType, type), GLbooleanToString(normalized),
          value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP1ui(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP1ui(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP1ui, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribP1uiv(GLuint index,
                                   GLenum type,
                                   GLboolean normalized,
                                   const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribP1uiv, "glVertexAttribP1uiv",
          "context = %d, index = %u, type = %s, normalized = %s, value = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          GLbooleanToString(normalized), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP1uiv(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP1uiv(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP1uiv, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribP2ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribP2ui, "glVertexAttribP2ui",
          "context = %d, index = %u, type = %s, normalized = %s, value = %u", CID(context), index,
          GLenumToString(GLenumGroup::VertexAttribPointerType, type), GLbooleanToString(normalized),
          value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP2ui(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP2ui(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP2ui, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribP2uiv(GLuint index,
                                   GLenum type,
                                   GLboolean normalized,
                                   const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribP2uiv, "glVertexAttribP2uiv",
          "context = %d, index = %u, type = %s, normalized = %s, value = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          GLbooleanToString(normalized), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP2uiv(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP2uiv(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP2uiv, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribP3ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribP3ui, "glVertexAttribP3ui",
          "context = %d, index = %u, type = %s, normalized = %s, value = %u", CID(context), index,
          GLenumToString(GLenumGroup::VertexAttribPointerType, type), GLbooleanToString(normalized),
          value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP3ui(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP3ui(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP3ui, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribP3uiv(GLuint index,
                                   GLenum type,
                                   GLboolean normalized,
                                   const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribP3uiv, "glVertexAttribP3uiv",
          "context = %d, index = %u, type = %s, normalized = %s, value = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          GLbooleanToString(normalized), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP3uiv(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP3uiv(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP3uiv, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribP4ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribP4ui, "glVertexAttribP4ui",
          "context = %d, index = %u, type = %s, normalized = %s, value = %u", CID(context), index,
          GLenumToString(GLenumGroup::VertexAttribPointerType, type), GLbooleanToString(normalized),
          value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP4ui(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP4ui(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP4ui, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribP4uiv(GLuint index,
                                   GLenum type,
                                   GLboolean normalized,
                                   const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribP4uiv, "glVertexAttribP4uiv",
          "context = %d, index = %u, type = %s, normalized = %s, value = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          GLbooleanToString(normalized), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribP4uiv(context, index, type, normalized, value));
        if (isCallValid)
        {
            context->vertexAttribP4uiv(index, type, normalized, value);
        }
        ANGLE_CAPTURE(VertexAttribP4uiv, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexP2ui(GLenum type, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexP2ui, "glVertexP2ui",
          "context = %d, type = %s, value = %u", CID(context),
          GLenumToString(GLenumGroup::VertexPointerType, type), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexP2ui(context, type, value));
        if (isCallValid)
        {
            context->vertexP2ui(type, value);
        }
        ANGLE_CAPTURE(VertexP2ui, isCallValid, context, type, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexP2uiv(GLenum type, const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexP2uiv, "glVertexP2uiv",
          "context = %d, type = %s, value = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::VertexPointerType, type), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexP2uiv(context, type, value));
        if (isCallValid)
        {
            context->vertexP2uiv(type, value);
        }
        ANGLE_CAPTURE(VertexP2uiv, isCallValid, context, type, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexP3ui(GLenum type, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexP3ui, "glVertexP3ui",
          "context = %d, type = %s, value = %u", CID(context),
          GLenumToString(GLenumGroup::VertexPointerType, type), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexP3ui(context, type, value));
        if (isCallValid)
        {
            context->vertexP3ui(type, value);
        }
        ANGLE_CAPTURE(VertexP3ui, isCallValid, context, type, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexP3uiv(GLenum type, const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexP3uiv, "glVertexP3uiv",
          "context = %d, type = %s, value = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::VertexPointerType, type), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexP3uiv(context, type, value));
        if (isCallValid)
        {
            context->vertexP3uiv(type, value);
        }
        ANGLE_CAPTURE(VertexP3uiv, isCallValid, context, type, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexP4ui(GLenum type, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexP4ui, "glVertexP4ui",
          "context = %d, type = %s, value = %u", CID(context),
          GLenumToString(GLenumGroup::VertexPointerType, type), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexP4ui(context, type, value));
        if (isCallValid)
        {
            context->vertexP4ui(type, value);
        }
        ANGLE_CAPTURE(VertexP4ui, isCallValid, context, type, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexP4uiv(GLenum type, const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexP4uiv, "glVertexP4uiv",
          "context = %d, type = %s, value = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::VertexPointerType, type), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexP4uiv(context, type, value));
        if (isCallValid)
        {
            context->vertexP4uiv(type, value);
        }
        ANGLE_CAPTURE(VertexP4uiv, isCallValid, context, type, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}
}  // namespace gl
