#! /usr/bin/env perl

# Test package that computes default database settings:

use strict;
use warnings;
use utf8;

use lib 'lib';
use RestfulDB::DBSettings qw(get_database_settings);

binmode( STDOUT, "utf8" );

my %cgi1 = (
    db => "testdb1.db",
    table => "ttab1",
);

my %cgi2 = (
    table => "ttab2",
    db => "testdb2"
);

my %env1 = (
    REQUEST_URI => "/~saulius/test.db2/dbase/tbl",
);

my %env2 = (
    REQUEST_URI => '/~saulius/test/dbase.sqlite2/tbl?param1=1&param2=22',
);

my @cases = (
    { env => \%env1, cgi => {}, par => { db_dir => "./db" } },
    { env => \%env1, cgi => {}, par => { db_dir => "./db", level => 1 } },
    { env => \%env1, cgi => {}, par => { db_dir => "./db", level => 2 } },

    { env => \%env2, cgi => {}, par => { db_dir => "./db", level => 1 } },
    { env => \%env2, cgi => {}, par => { db_dir => "./db", level => 2 } },

    { env => \%env1, cgi => \%cgi1, par => { db_dir => "./db", level => 1 } },
    { env => \%env2, cgi => \%cgi1, par => { db_dir => "./db", level => 2 } },

    { env => \%env1, cgi => \%cgi2, par => { db_dir => "./db", level => 1 } },
    { env => \%env2, cgi => \%cgi2, par => { db_dir => "./db", level => 2 } },
);

my $n = 0;
my $separator = "";
for my $case (@cases) {

    print $separator;
    print "test" . ++$n . ":\n";
    $separator = "\n";

    my $settings = &get_database_settings( $case->{cgi},
                                           $case->{env},
                                           $case->{par} );

    local $\ = "\n";

    $case->{settings} = $settings;
    for my $argument_name (qw(cgi env par settings)) {
        my $hash = $case->{$argument_name};
        print "$argument_name:";
        for my $key ((sort keys %{$hash})) {
            printf "\t%-21s ", $key;
            print "= ", defined $hash->{$key} ?
                ("'" . $hash->{$key} . "'") : 'undef';
        }
    }
};
